# generated by datamodel-codegen:
#   filename:  security/client/samlSSOClientConfig.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class Idp(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    entityId: Annotated[
        str,
        Field(
            description='Identity Provider Entity ID usually same as the SSO login URL.'
        ),
    ]
    ssoLoginUrl: Annotated[str, Field(description='SSO Login URL.')]
    idpX509Certificate: Annotated[
        Optional[str], Field(None, description='X509 Certificate ')
    ]
    authorityUrl: Annotated[
        Optional[str],
        Field(None, description='Authority URL to redirect the users on Sign In page'),
    ]
    nameId: Annotated[
        Optional[str],
        Field(
            'urn:oasis:names:tc:SAML:2.0:nameid-format:emailAddress',
            description='Authority URL to redirect the users on Sign In page',
        ),
    ]


class Sp(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    entityId: Annotated[str, Field(description='Service Provider Entity ID.')]
    acs: Annotated[str, Field(description='Assertion Consumer URL.')]
    spX509Certificate: Annotated[
        Optional[str], Field(None, description='X509 Certificate ')
    ]
    spPrivateKey: Annotated[
        Optional[str],
        Field(None, description='Sp Private Key for Signing and Encryption Only'),
    ]
    callback: Annotated[
        str,
        Field(
            description='Service Provider Entity ID usually same as the SSO login URL.'
        ),
    ]


class Security(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    strictMode: Annotated[
        Optional[bool],
        Field(
            False,
            description='Only accept valid signed and encrypted assertions if the relevant flags are set',
        ),
    ]
    validateXml: Annotated[
        Optional[bool],
        Field(
            False, description='In case of strict mode whether to validate XML format.'
        ),
    ]
    tokenValidity: Annotated[
        Optional[int],
        Field(
            '3600', description='Validity for the JWT Token created from SAML Response'
        ),
    ]
    sendEncryptedNameId: Annotated[
        Optional[bool],
        Field(False, description='Encrypt Name Id while sending requests from SP.'),
    ]
    sendSignedAuthRequest: Annotated[
        Optional[bool],
        Field(False, description='Sign the Authn Request while sending.'),
    ]
    signSpMetadata: Annotated[
        Optional[bool],
        Field(False, description='Want the Metadata of this SP to be signed.'),
    ]
    wantMessagesSigned: Annotated[
        Optional[bool],
        Field(False, description='SP requires the messages received to be signed.'),
    ]
    wantAssertionsSigned: Annotated[
        Optional[bool],
        Field(False, description='SP requires the assertions received to be signed.'),
    ]
    wantAssertionEncrypted: Annotated[
        Optional[bool],
        Field(False, description='SP requires the assertion received to be encrypted.'),
    ]
    keyStoreFilePath: Annotated[
        Optional[str], Field(None, description='KeyStore File Path')
    ]
    keyStoreAlias: Annotated[Optional[str], Field(None, description='KeyStore Alias')]
    keyStorePassword: Annotated[
        Optional[str], Field(None, description='KeyStore Password')
    ]


class SamlSSOClientConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    idp: Idp
    sp: Sp
    security: Optional[Security] = None
    debugMode: Annotated[
        Optional[bool],
        Field(False, description='Get logs from the Library in debug mode'),
    ]
