# generated by datamodel-codegen:
#   filename:  security/credentials/bitbucketCredentials.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import gitCredentials


class BitbucketType(Enum):
    BitBucket = 'BitBucket'


class BitBucketCredentials(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[BitbucketType],
        Field(
            BitbucketType.BitBucket,
            description='Credentials Type',
            title='Credentials Type',
        ),
    ]
    repositoryOwner: gitCredentials.RepositoryOwner
    repositoryName: gitCredentials.RepositoryName
    token: Optional[gitCredentials.Token] = None
    branch: Annotated[
        str,
        Field(
            description='Main production branch of the repository. E.g., `main`',
            title='Main Branch',
        ),
    ]
