# generated by datamodel-codegen:
#   filename:  api/data/createDashboardDataModel.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import dashboardDataModel, table
from ...entity.services import dashboardService
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateDashboardDataModelRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this data model.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this data model. It could be title or label from the source services.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of the data model instance. What it has and how to use it.',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this data model.'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this data model.'),
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Link to the data model service where this data model is hosted in.'
        ),
    ]
    serviceType: Annotated[
        Optional[dashboardService.DashboardServiceType],
        Field(None, description='Service type where this data model is hosted in.'),
    ]
    dataModelType: dashboardDataModel.DataModelType
    sql: Annotated[
        Optional[basic.SqlQuery],
        Field(None, description='In case the Data Model is based on a SQL query.'),
    ]
    columns: Annotated[
        List[table.Column], Field(description='Columns from the data model.')
    ]
    project: Annotated[
        Optional[str],
        Field(
            None,
            description='Name of the project / workspace / collection in which the dataModel is contained',
        ),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully qualified name of the domain the Dashboard Data Model belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
