# generated by datamodel-codegen:
#   filename:  entity/applications/app.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations
from typing import Union  # custom generate import


from enum import Enum
from typing import List, Optional, Union

from pydantic import AnyUrl, ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList
from ..services.connections.metadata import openMetadataConnection
from . import liveExecutionContext, scheduledExecutionContext
from .configuration import applicationConfig


class ScheduleType(Enum):
    Live = 'Live'
    Scheduled = 'Scheduled'
    ScheduledOrManual = 'ScheduledOrManual'
    NoSchedule = 'NoSchedule'


class ScheduleTimeline(Enum):
    Hourly = 'Hourly'
    field_Daily = ' Daily'
    Weekly = 'Weekly'
    Monthly = 'Monthly'
    Custom = 'Custom'
    None_ = 'None'


class AppSchedule(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    scheduleTimeline: ScheduleTimeline
    cronExpression: Annotated[
        Optional[str],
        Field(None, description='Cron Expression in case of Custom scheduled Trigger'),
    ]


class AppType(Enum):
    internal = 'internal'
    external = 'external'


class Permissions(Enum):
    All = 'All'


class ExecutionContext(
    RootModel[Union[liveExecutionContext.JobRun, scheduledExecutionContext.JobRun]]
):
    root: Annotated[
        Union[liveExecutionContext.JobRun, scheduledExecutionContext.JobRun],
        Field(description='Execution Configuration.'),
    ]


class App(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this application.')
    ]
    name: Annotated[basic.EntityName, Field(description='Name of the Application.')]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name for the application.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the Application.'),
    ]
    features: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Features of the Application.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this workflow.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    developer: Annotated[
        Optional[str], Field(None, description='Developer For the Application.')
    ]
    developerUrl: Annotated[
        Optional[str], Field(None, description='Url for the developer')
    ]
    privacyPolicyUrl: Annotated[
        Optional[str], Field(None, description='Privacy Policy for the developer')
    ]
    supportEmail: Annotated[
        Optional[str], Field(None, description='Support Email for the application')
    ]
    className: Annotated[
        str, Field(description='Fully Qualified ClassName for the Schedule')
    ]
    sourcePythonClass: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully Qualified class name for the Python source that will execute the external application.',
        ),
    ]
    appType: Annotated[
        AppType, Field(description='This schema defines the type of application.')
    ]
    scheduleType: Annotated[
        ScheduleType,
        Field(description='This schema defines the Schedule Type of Application.'),
    ]
    permission: Annotated[
        Permissions, Field(description='Permission used by Native Applications.')
    ]
    bot: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Bot User Associated with this application.'),
    ]
    runtime: Annotated[ExecutionContext, Field(description='Execution Configuration.')]
    allowConfiguration: Annotated[
        Optional[bool],
        Field(
            True,
            description='Allow users to configure the app from the UI. If `false`, the `configure` step will be hidden.',
        ),
    ]
    system: Annotated[
        Optional[bool],
        Field(False, description='A system app cannot be uninstalled or modified.'),
    ]
    appConfiguration: Annotated[
        Optional[applicationConfig.AppConfig],
        Field(None, description='Application Configuration object.'),
    ]
    privateConfiguration: Annotated[
        Optional[applicationConfig.PrivateConfig],
        Field(None, description='Application Private configuration loaded at runtime.'),
    ]
    preview: Annotated[
        Optional[bool],
        Field(
            False,
            description="Flag to enable/disable preview for the application. If the app is in preview mode, it can't be installed.",
        ),
    ]
    pipelines: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='References to pipelines deployed for this database service to extract metadata, usage, lineage etc..',
        ),
    ]
    appSchedule: Annotated[
        AppSchedule,
        Field(
            description='In case the app supports scheduling, list of different app schedules'
        ),
    ]
    openMetadataServerConnection: Optional[
        openMetadataConnection.OpenMetadataConnection
    ] = None
    appLogoUrl: Annotated[
        Optional[AnyUrl], Field(None, description='Application Logo Url.')
    ]
    appScreenshots: Annotated[
        Optional[List[str]], Field(None, description='Application Screenshots.')
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
    supportsInterrupt: Annotated[
        Optional[bool],
        Field(
            False,
            description='If the app run can be interrupted as part of the execution.',
        ),
    ]
