# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/qlikSenseConnection.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.ssl import verifySSLConfig
from .. import connectionBasicType


class QlikSenseType(Enum):
    QlikSense = 'QlikSense'


class QlikCertificatePath(BaseModel):
    clientCertificate: Annotated[
        str, Field(description='Client Certificate', title='Client Certificate Path')
    ]
    clientKeyCertificate: Annotated[
        str,
        Field(description='Client Key Certificate.', title='Client Key Certificate'),
    ]
    rootCertificate: Annotated[
        str, Field(description='Root Certificate.', title='Root Certificate')
    ]


class QlikCertificateValues(BaseModel):
    sslConfig: verifySSLConfig.SslConfig


class QlikSenseConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[QlikSenseType],
        Field(
            QlikSenseType.QlikSense, description='Service Type', title='Service Type'
        ),
    ]
    displayUrl: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Qlik Sense Base URL, used for genrating dashboard & chat url',
            title='Qlik Sense Base URL',
        ),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='URL for the Qlik instance.',
            title='Qlik Engine JSON API Websocket URL',
        ),
    ]
    certificates: Union[QlikCertificateValues, QlikCertificatePath]
    validateHostName: Annotated[
        Optional[bool],
        Field(False, description='Validate Host Name', title='Validate Host Name'),
    ]
    userDirectory: Annotated[
        Optional[str],
        Field(None, description='User Directory.', title='User Directory'),
    ]
    userId: Annotated[
        Optional[str], Field(None, description='User ID.', title='User ID')
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
