# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/tableauConnection.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import accessTokenAuth, basicAuth
from .....security.ssl import verifySSLConfig
from .. import connectionBasicType


class TableauType(Enum):
    Tableau = 'Tableau'


class TableauConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[TableauType],
        Field(TableauType.Tableau, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl, Field(description='Tableau Server.', title='Host and Port')
    ]
    authType: Annotated[
        Optional[Union[basicAuth.BasicAuth, accessTokenAuth.AccessTokenAuth]],
        Field(
            None,
            description='Types of methods used to authenticate to the tableau instance',
            title='Authentication type for Tableau',
        ),
    ]
    apiVersion: Annotated[
        str, Field(description='Tableau API version.', title='API Version')
    ]
    siteName: Annotated[
        Optional[str], Field(None, description='Tableau Site Name.', title='Site Name')
    ]
    siteUrl: Annotated[
        Optional[str], Field(None, description='Tableau Site Url.', title='Site Url')
    ]
    env: Annotated[
        str, Field(description='Tableau Environment Name.', title='Tableau Environment')
    ]
    paginationLimit: Annotated[
        Optional[int],
        Field(
            10,
            description='Pagination limit used while querying the tableau metadata API for getting data sources',
            title='Pagination Limit',
        ),
    ]
    verifySSL: Optional[verifySSLConfig.VerifySSL] = verifySSLConfig.VerifySSL.no_ssl
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
