# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/greenplumConnection.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.ssl import verifySSLConfig
from .. import connectionBasicType
from .common import basicAuth, iamAuthConfig


class GreenplumType(Enum):
    Greenplum = 'Greenplum'


class GreenplumScheme(Enum):
    postgresql_psycopg2 = 'postgresql+psycopg2'


class GreenplumConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[GreenplumType],
        Field(
            GreenplumType.Greenplum, description='Service Type', title='Service Type'
        ),
    ]
    scheme: Annotated[
        Optional[GreenplumScheme],
        Field(
            GreenplumScheme.postgresql_psycopg2,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to Greenplum. This user should have privileges to read all the metadata in Greenplum.',
            title='Username',
        ),
    ]
    authType: Annotated[
        Optional[Union[basicAuth.BasicAuth, iamAuthConfig.IamAuthConfigurationSource]],
        Field(
            None,
            description='Choose Auth Config Type.',
            title='Auth Configuration Type',
        ),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the source service.', title='Host and Port'
        ),
    ]
    database: Annotated[
        str,
        Field(
            description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
            title='Database',
        ),
    ]
    sslMode: Optional[verifySSLConfig.SslMode] = verifySSLConfig.SslMode.disable
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    ingestAllDatabases: Annotated[
        Optional[bool],
        Field(
            False,
            description='Ingest data from all databases in Greenplum. You can use databaseFilterPattern on top of this.',
            title='Ingest All Databases',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsDatabase: Annotated[
        Optional[connectionBasicType.SupportsDatabase],
        Field(None, title='Supports Database'),
    ]
    supportsQueryComment: Annotated[
        Optional[connectionBasicType.SupportsQueryComment],
        Field(None, title='Supports Query Comment'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
    supportsViewLineageExtraction: Optional[
        connectionBasicType.SupportsViewLineageExtraction
    ] = None
