# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/matillionConnection.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....security.ssl import verifySSLConfig
from .. import connectionBasicType


class MatillionType(Enum):
    Matillion = 'Matillion'


class Type(Enum):
    MatillionETL = 'MatillionETL'


class MatillionETL(BaseModel):
    type: Optional[Type] = Type.MatillionETL
    hostPort: Annotated[str, Field(description='Matillion Host', title='Host')]
    username: Annotated[
        str,
        Field(
            description='Username to connect to the Matillion. This user should have privileges to read all the metadata in Matillion.',
            title='Username',
        ),
    ]
    password: Annotated[
        CustomSecretStr,
        Field(description='Password to connect to the Matillion.', title='Password'),
    ]
    sslConfig: Optional[verifySSLConfig.SslConfig] = None


class MatillionConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[MatillionType],
        Field(
            MatillionType.Matillion, description='Service Type', title='Service Type'
        ),
    ]
    connection: Annotated[
        Optional[MatillionETL],
        Field(
            None,
            description='Matillion Auth Configuration',
            title='Matillion Connection',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
