# generated by datamodel-codegen:
#   filename:  entity/services/connections/storage/gcsConnection.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import gcpCredentials
from .. import connectionBasicType


class GcsType(Enum):
    GCS = 'GCS'


class GcsConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[GcsType],
        Field(GcsType.GCS, description='Service Type', title='Service Type'),
    ]
    credentials: Annotated[
        gcpCredentials.GCPCredentials,
        Field(description='GCP Credentials', title='GCP Credentials'),
    ]
    bucketNames: Annotated[
        Optional[List[str]],
        Field(
            None, description='Bucket Names of the data source.', title='Bucket Names'
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
