# generated by datamodel-codegen:
#   filename:  entity/teams/teamHierarchy.json
#   timestamp: 2025-02-06T10:15:59+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic
from . import team


class TeamHierarchy(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: basic.Uuid
    teamType: Annotated[
        Optional[team.TeamType], Field(team.TeamType.Group, description='Team type')
    ]
    name: Annotated[
        basic.EntityName,
        Field(
            description='A unique name of the team typically the team ID from an identity provider. Example - group Id from LDAP.'
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the team.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description="Name used for display purposes. Example 'Data Science team'.",
        ),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    children: Annotated[
        Optional[TeamHierarchyList],
        Field(
            None,
            description='Children teams. An `Organization` can have `BusinessUnit`, `Division` or `Department` as children. A `BusinessUnit` can have `BusinessUnit`, `Division`, or `Department` as children. A `Division` can have `Division` or `Department` as children. A `Department` can have `Department` as children.',
        ),
    ]
    isJoinable: Annotated[
        Optional[bool],
        Field(
            True,
            description='Can any user join this team during sign up? Value of true indicates yes, and false no.',
        ),
    ]


class TeamHierarchyList(RootModel[List[TeamHierarchy]]):
    root: List[TeamHierarchy]


TeamHierarchy.model_rebuild()
