!=======================================================================
!
! This source file has been provided to the Hoppet authors under GPLv3
! by Johannes Blumlein and corresponds to the following article, which
! should be cited whenever any routine in this source file is called:
!
!     DESY 24--037
!     J. Ablinger, A. Behring, J. Bl\"umlein, A. De Freitas,
!     A. von Manteuffel, C.~Schneider, and K.~Sch\"onwald,
!     "The Variable Flavor Number Scheme at  Next-to-Next-to-Leading Order"
!
!     This f90 part of code: K. Sch\"onwald, March 15, 2024
!
! The code as distributed here has been adapted by the Hoppet authors to
! be used as a library and Fortran 90 module. The intent of the module
! is to avoid filling the linker namespace with short function names
! that may conflict with user functions.
!
!=========================================================================

module AQg3mod
  use, intrinsic :: iso_c_binding
  private
  public aQg3

  contains
!---------------------------------------------

  real(c_double) function XChebyshevToS(x,a,b)
    implicit none
    real(c_double), intent(in) :: x,a,b

    XChebyshevToS = (a+b)/2+x*(b-a)/2
  end function  XChebyshevToS

!---------------------------------------------

  real(c_double) function SToXChebyshev(s,a,b)
    implicit none
    real(c_double), intent(in) :: s,a,b

    SToXChebyshev = (2*s-a-b)/(b-a)

  end function SToXChebyshev

!---------------------------------------------

  real(c_double) function chebev(s,a,b,m,c)
    implicit none
    integer, intent(in) :: m
!    real(c_double), external :: SToXChebyshev
    real(c_double), intent(in) :: s,a,b
    real(c_double), intent(in) :: c(0:m)
    real(c_double) :: x, x2
    real(c_double) :: d, dd, sv
    integer i

    x = SToXChebyshev(s,a,b)
    x2 = 2*x

    d = 0
    dd = 0

    do i=m,1,-1
      sv = d
      d  = x2*d-dd+c(i)
      dd = sv
    enddo

    chebev = x*d-dd+c(0)/2

  end function chebev

!---------------------------------------------
  real(c_double) function aQg3(x) bind(c, name="aQg3")
    implicit none
!    real(c_double), external :: chebev
    real(c_double), intent(in) :: x
    real(c_double), dimension(65) :: coeff
    real(c_double) :: Lx, y, Ly
    !0<x<25/100
    ! what intervals do we need?
    IF (x > 0.92D0) THEN !expansion around x=1, good for 0.92<x<1
        y = 1.0D0 - x
        Ly = log(y)

        aQg3 = 2421.43547035364D0 + y*(2267.75169678106D0 + y*(2544.95013419137D0 + &
        y*(-11533.8050254119D0 + y*(3510.74659607592D0 + y*(-2856.38630589815D0 + &
        y*(-17991.5484909622D0 + y*(-74291.4572802592D0 + y*(-261023.391799151D0 + &
        (-945497.35311606D0 - 3.25743662179011D6*y)*y)))))))) + Ly*(1536.64433401266D0 + &
        y*(-7167.07031303548D0 + y*(6341.37198639751D0 + y*(-335.988086191919D0 + &
        y*(-5615.65899520956D0 + y*(-13430.4963475668D0 + y*(-40457.8874713498D0 + &
        y*(-124793.339191669D0 + y*(-439018.842441394D0 + (-1.40308019220211D6 - &
        5.44411318160621D6*y)*y)))))))) + Ly*(-673.817647705065D0 + y*(3649.28819920348D0 &
        + y*(-2211.24674709702D0 + y*(5.79515098774107D0 + y*(-1123.39812130261D0 + &
        y*(-4164.27356531736D0 + y*(-14124.040529318D0 + y*(-45105.6809916574D0 + &
        y*(-157900.904704519D0 + (-503854.36457546D0 - 1.90272175567389D6*y)*y)))))))) + &
        Ly*(8.76039981179369D0 + y*(-665.767713203834D0 + y*(174.062466290254D0 + &
        y*(127.613511659808D0 + y*(165.584319272977D0 + y*(416.536083676269D0 + y*(1398.10472565158D0 &
        + y*(4719.36319587917D0 + y*(16169.8261297189D0 + y*(55997.3040500997D0 + 196018.111698892D0*y)))))) &
        ))) + Ly*(-16.7901234567901D0 + Ly*(7.40740740740741D0 + y*(-14.8148148148148D0 + 14.8148148148148D0*y)) + &
        y*(88.5925925925926D0 + y*(-72.8804012345679D0 + y*(-24.8276748971193D0 + &
        y*(13.823945473251D0 + y*(84.5108024691358D0 + y*(294.30066872428D0 + &
        y*(985.359861845973D0 + y*(3321.52212852734D0 + y*(11348.0983000196D0 + 39288.1348593964D0*y)))))))))))))
    ELSE IF (x > 0.05D0) THEN
        coeff = [ &
        23313.3871400941D0, &
        -17912.9312044369D0, &
        10352.7385836596D0, &
        -8843.39521332579D0, &
        4103.90973165495D0, &
        -2861.54124141535D0, &
        1367.70961442247D0, &
        -912.161340304181D0, &
        447.335030233063D0, &
        -289.734818067042D0, &
        143.848887748854D0, &
        -90.9896888328995D0, &
        45.2848982561553D0, &
        -28.0123024796034D0, &
        13.8312844107422D0, &
        -8.35149819516665D0, &
        4.03259439467523D0, &
        -2.36133356966821D0, &
        1.08656119652745D0, &
        -0.606326376350876D0, &
        0.249495786129085D0, &
        -0.125161292467616D0, &
        0.0346163667225804D0, &
        -0.00918734567460444D0, &
        -0.00912069063166575D0, &
        0.010597905528655D0, &
        -0.0117427947489907D0, &
        0.0092308672821315D0, &
        -0.00754912275616261D0, &
        0.00543953013272945D0, &
        -0.00402371495261006D0, &
        0.00278737889994597D0, &
        -0.00196249944218063D0, &
        0.00132886579322787D0, &
        -0.000908877751451785D0, &
        0.000606257342177608D0, &
        -0.000406911235413023D0, &
        0.000268537854600126D0, &
        -0.000177891947080556D0, &
        0.000116457678088431D0, &
        -0.0000764139322982043D0, &
        0.0000497111034552247D0, &
        -0.0000323822453027971D0, &
        0.0000209606415868613D0, &
        -0.0000135779164643879D0, &
        8.75128157257169D-6, &
        -5.6438196443288D-6, &
        3.62551532752205D-6, &
        -2.32945844409098D-6, &
        1.49118685139225D-6, &
        -9.56191224211347D-7, &
        6.10546776272212D-7, &
        -3.89863167625624D-7, &
        2.48475807931539D-7, &
        -1.59122486082347D-7, &
        1.00514659420386D-7, &
        -6.3967115274327D-8, &
        4.10304036032633D-8, &
        -2.60710322096509D-8, &
        1.5879593611396D-8, &
        -1.04815083172975D-8, &
        6.76765001309248D-9, &
        -3.63884759697074D-9, &
        1.98643407300325D-9, &
        -1.42290234845722D-9]

        aQg3 = chebev(x,0.05D0,0.92D0,65,coeff)
    ELSE !expansion around x=0, good for 0<x<0.05
        Lx = log(x)

        aQg3 = (20296.2296570432D0 + x*(-15203.9626008106D0 + x*(140027.359272651D0 + &
        x*(-164022.136972522D0 + x*(60088.2045307447D0 + x*(-115047.129708731D0 + &
        x*(737258.331107716D0 + x*(-2.89428012763914D6 + x*(1.86115103469489D7 + &
        x*(-7.16075880219513D7 + (4.35578734048095D8 - 1.60524103475833D9*x)*x)))))))))+ &
        Lx*(3387.7670886109D0 + x*(24141.1235905152D0 + x*(62935.6003761826D0 + &
        x*(48784.63656144D0 + x*(-1333.41102441824D0 + x*(111078.337272402D0 + &
        x*(-291099.409692458D0 + x*(2.55097880474454D6 + x*(-7.20422323075345D6 + &
        x*(5.75485553557481D7 + x*(-1.55486371452623D8 + 1.25357265339805D9*x)))))))))) + &
        Lx*(-20.1848022005447D0 + x*(-1781.42041452969D0 + x*(9329.78133744705D0 + &
        x*(-16255.8500165479D0 + x*(-12904.108088959D0 + x*(59739.7235021743D0 + &
        x*(-239748.121116917D0 + x*(1.50796242047358D6 + x*(-5.89737980336008D6 + &
        x*(3.44799478010053D7 + x*(-1.30235322969804D8 + 7.45518451385623D8*x)))))))))) + &
        Lx*(-0.49999999999994D0 + x*(1141.37535312454D0 + x*(171.027129891321D0 + x*(2476.85434100361D0 &
        + x*(-2294.40466392318D0 + x*(16183.566100823D0 + x*(-94335.6360082304D0 + x*(441071.80441701D0 &
        + x*(-2.31620342120909D6 + x*(1.03235221657395D7 + x*(-5.17637416007774D7 &
        + 2.22936218943037D8*x))))))))))+ Lx*(-0.166666666666667D0 + &
        Lx*x*(11.0305555555556D0 + x*(-50.4197530864198D0 + 2.84444444444444D0*x)) + &
        x*(-55.5092592592593D0 + x*(56.6604938271605D0 + x*(181.157407407407D0 + &
        x*(-487.380658436214D0 + x*(2344.01851851852D0 + x*(-14220.716872428D0 + &
        x*(67741.3938271605D0 + x*(-364316.265726044D0 + x*(1.6468656803351D6 + &
        x*(-8.35933319919655D6 + 3.64172541023516D7*x)))))))))))))))/x
    END IF
!  WRITE(*,*) 'x,val=',x,aQg3
  end function aQg3
!---------------------------------------------

end module AQg3mod
