# Generated by Django 4.2.5 on 2023-09-28 15:10
from django.db import migrations
from tqdm import tqdm


def update_new_site_field(apps, schema_editor):
    registered_subject_model_cls = apps.get_model("edc_registration.registeredsubject")
    model_cls = apps.get_model("edc_visit_schedule.subjectschedulehistory")
    qs = model_cls.objects.all()
    total = qs.count()
    for obj in tqdm(qs, total=total):
        obj.site_id = registered_subject_model_cls.objects.get(
            subject_identifier=obj.subject_identifier
        ).site_id
        obj.save_base(update_fields=["site_id"])


class Migration(migrations.Migration):
    dependencies = [
        ("edc_visit_schedule", "0012_alter_subjectschedulehistory_managers_and_more"),
    ]

    operations = [migrations.RunPython(update_new_site_field)]
