"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToBedrockinferenceprofile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const cdk = require("aws-cdk-lib");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const core_1 = require("@aws-solutions-constructs/core");
/**
 * @summary The LambdaToBedrockinferenceprofile class.
 */
class LambdaToBedrockinferenceprofile extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToSns class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToSnsProps} props - user provided props for the construct.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        (0, core_1.CheckBedrockInferenceProps)(props);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        if (props.deployVpc || props.existingVpc) {
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
                existingVpc: props.existingVpc,
                userVpcProps: props.vpcProps,
                constructVpcProps: {
                    enableDnsHostnames: true,
                    enableDnsSupport: true,
                },
            });
            defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.BEDROCK);
            defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.BEDROCK_RUNTIME);
        }
        const constructFunctionProps = defaults.consolidateProps({ timeout: cdk.Duration.seconds(30) }, props.lambdaFunctionProps);
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: constructFunctionProps,
            vpc: this.vpc,
        });
        const buildInferenceResponse = (0, core_1.buildInferenceProfile)(this, id, {
            bedrockModelId: props.bedrockModelId,
            deployCrossRegionProfile: props.deployCrossRegionProfile,
            inferenceProfileProps: props.inferenceProfileProps
        });
        this.inferenceProfile = buildInferenceResponse.inferenceProfile;
        const regionMapping = (0, core_1.createAreaRegionMapping)(this, id, props.bedrockModelId);
        const regionPrefix = cdk.Fn.select(0, cdk.Fn.split('-', cdk.Aws.REGION));
        this.lambdaFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['bedrock:Invoke*'],
            resources: [
                this.inferenceProfile.attrInferenceProfileArn,
            ]
        }));
        this.lambdaFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['bedrock:Invoke*'],
            resources: defaults.IsCrossRegionProfile(props.deployCrossRegionProfile) ?
                cdk.Fn.split(",", cdk.Fn.findInMap(regionMapping.mappingName, regionPrefix, 'regionalModels')) :
                [`arn:${cdk.Aws.PARTITION}:bedrock:${cdk.Aws.REGION}::foundation-model/${props.bedrockModelId}`]
        }));
        // Configure environment variables
        const foundationModelEnvironmentVariableName = props.foundationModelEnvironmentVariableName || 'BEDROCK_MODEL';
        this.lambdaFunction.addEnvironment(foundationModelEnvironmentVariableName, props.bedrockModelId);
        const inferenceProfileEnvironmentVariableName = props.inferenceProfileEnvironmentVariableName || 'BEDROCK_PROFILE';
        this.lambdaFunction.addEnvironment(inferenceProfileEnvironmentVariableName, this.inferenceProfile.attrInferenceProfileArn);
    }
}
exports.LambdaToBedrockinferenceprofile = LambdaToBedrockinferenceprofile;
_a = JSII_RTTI_SYMBOL_1;
LambdaToBedrockinferenceprofile[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-bedrockinferenceprofile.LambdaToBedrockinferenceprofile", version: "2.97.0" };
//# sourceMappingURL=data:application/json;base64,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