(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? factory(exports, require("react"), require("@darajs/core"), require("styled-components"), require("react-dom")) : typeof define === "function" && define.amd ? define(["exports", "react", "@darajs/core", "styled-components", "react-dom"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory((global2.dara = global2.dara || {}, global2.dara.components = {}), global2.React, global2.dara.core, global2.styled, global2.ReactDOM));
})(this, function(exports2, React, core$2, styled, ReactDOM) {
  var _a2;
  "use strict";
  const _interopDefaultLegacy = (e3) => e3 && typeof e3 === "object" && "default" in e3 ? e3 : { default: e3 };
  function _interopNamespace(e3) {
    if (e3 && e3.__esModule)
      return e3;
    const n2 = Object.create(null, { [Symbol.toStringTag]: { value: "Module" } });
    if (e3) {
      for (const k2 in e3) {
        if (k2 !== "default") {
          const d2 = Object.getOwnPropertyDescriptor(e3, k2);
          Object.defineProperty(n2, k2, d2.get ? d2 : {
            enumerable: true,
            get: () => e3[k2]
          });
        }
      }
    }
    n2.default = e3;
    return Object.freeze(n2);
  }
  const React__default = /* @__PURE__ */ _interopDefaultLegacy(React);
  const React__namespace = /* @__PURE__ */ _interopNamespace(React);
  const styled__default = /* @__PURE__ */ _interopDefaultLegacy(styled);
  const ReactDOM__namespace = /* @__PURE__ */ _interopNamespace(ReactDOM);
  const ReactDOM__default = /* @__PURE__ */ _interopDefaultLegacy(ReactDOM);
  const theme$3 = {
    colors: {
      primary: "#3796F6",
      primaryHover: "#0079D4",
      primaryDown: "#0060AA",
      secondary: "#434B87",
      secondaryHover: "#4E568E",
      secondaryDown: "#5A629C",
      background: "#F8F9FF",
      text: "#1E244D",
      grey1: "#EEF1FA",
      grey2: "#DFE2EB",
      grey3: "#C3C6CF",
      grey4: "#8D9199",
      grey5: "#5B5E66",
      grey6: "#43474E",
      blue1: "#FBFCFF",
      blue2: "#ECF2FD",
      blue3: "#E1EEFD",
      blue4: "#C4DFFC",
      violet: "#5E62E2",
      turquoise: "#2CB85C",
      purple: "#E28FFF",
      teal: "#0790AE",
      orange: "#FF8F80",
      plum: "#BA3C8B",
      error: "#DA6087",
      errorHover: "#D14975",
      errorDown: "#C33462",
      success: "#2DB3BF",
      successHover: "#1CA6B2",
      successDown: "#149AA7",
      warning: "#DCB016",
      warningHover: "#D0A406",
      warningDown: "#C39800",
      modalBg: "rgba(19, 25, 35, 0.5)",
      shadowLight: "rgba(0, 0, 0, 0.1)",
      shadowMedium: "rgba(0, 0, 0, 0.1)"
    },
    font: {
      size: "16px"
    },
    shadow: {
      light: "0px 2px 4px rgba(0, 0, 0, 0.1)",
      medium: "0px 2px 10px rgba(0, 0, 0, 0.1)"
    },
    themeType: "light"
  };
  const darkTheme$1 = {
    colors: {
      primary: "#2485E8",
      primaryHover: "#4799EB",
      primaryDown: "#5EA3E9",
      secondary: "#BEC5EE",
      secondaryHover: "#CAD0F4",
      secondaryDown: "#D3D8F4",
      background: "#111314",
      text: "#EDEEFA",
      grey1: "#32373D",
      grey2: "#43474E",
      grey3: "#5B5E66",
      grey4: "#8D9199",
      grey5: "#C3C6CF",
      grey6: "#DFE2EB",
      blue1: "#252A31",
      blue2: "#25323F",
      blue3: "#203750",
      blue4: "#204368",
      violet: "#5E31DC",
      turquoise: "#109C41",
      purple: "#D96FFF",
      teal: "#00849F",
      orange: "#DB6D5E",
      plum: "#AB2178",
      error: "#CA456F",
      errorHover: "#D1567E",
      errorDown: "#D7688B",
      success: "#1A9FAC",
      successHover: "#27A9B6",
      successDown: "#34B4C0",
      warning: "#C8981F",
      warningHover: "#D7A526",
      warningDown: "#E2B235",
      modalBg: "rgba(19, 25, 35, 0.5)",
      shadowLight: "rgba(0, 0, 0, 0.1)",
      shadowMedium: "rgba(0, 0, 0, 0.1)"
    },
    font: {
      size: "16px"
    },
    shadow: {
      light: "0px 2px 4px rgba(0, 0, 0, 0.1)",
      medium: "0px 2px 10px rgba(0, 0, 0, 0.1)"
    },
    themeType: "dark"
  };
  function useClTheme() {
    return styled.useTheme();
  }
  var Key;
  (function(Key2) {
    Key2["BACKSPACE"] = "Backspace";
    Key2["CTRL"] = "Control";
    Key2["DOWN"] = "ArrowDown";
    Key2["ENTER"] = "Enter";
    Key2["ESCAPE"] = "Escape";
    Key2["LEFT"] = "ArrowLeft";
    Key2["META"] = "Meta";
    Key2["MINUS"] = "-";
    Key2["PERIOD"] = ".";
    Key2["RIGHT"] = "ArrowRight";
    Key2["SHIFT"] = "Shift";
    Key2["TAB"] = "Tab";
    Key2["UP"] = "ArrowUp";
  })(Key || (Key = {}));
  const CONTROL_KEYS = [
    Key.ESCAPE,
    Key.TAB,
    Key.ENTER,
    Key.BACKSPACE,
    Key.CTRL,
    Key.SHIFT,
    Key.UP,
    Key.DOWN,
    Key.LEFT,
    Key.RIGHT,
    Key.META
  ];
  var commonjsGlobal$1 = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs(x2) {
    return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
  }
  function getAugmentedNamespace(n2) {
    var f2 = n2.default;
    if (typeof f2 == "function") {
      var a2 = function() {
        return f2.apply(this, arguments);
      };
      a2.prototype = f2.prototype;
    } else
      a2 = {};
    Object.defineProperty(a2, "__esModule", { value: true });
    Object.keys(n2).forEach(function(k2) {
      var d2 = Object.getOwnPropertyDescriptor(n2, k2);
      Object.defineProperty(a2, k2, d2.get ? d2 : {
        enumerable: true,
        get: function() {
          return n2[k2];
        }
      });
    });
    return a2;
  }
  var jsxRuntime = { exports: {} };
  var reactJsxRuntime_production_min = {};
  /**
   * @license React
   * react-jsx-runtime.production.min.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var f$2 = React__default.default, k$3 = Symbol.for("react.element"), l$3 = Symbol.for("react.fragment"), m$4 = Object.prototype.hasOwnProperty, n$3 = f$2.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner, p$4 = { key: true, ref: true, __self: true, __source: true };
  function q$3(c2, a2, g2) {
    var b2, d2 = {}, e3 = null, h2 = null;
    void 0 !== g2 && (e3 = "" + g2);
    void 0 !== a2.key && (e3 = "" + a2.key);
    void 0 !== a2.ref && (h2 = a2.ref);
    for (b2 in a2)
      m$4.call(a2, b2) && !p$4.hasOwnProperty(b2) && (d2[b2] = a2[b2]);
    if (c2 && c2.defaultProps)
      for (b2 in a2 = c2.defaultProps, a2)
        void 0 === d2[b2] && (d2[b2] = a2[b2]);
    return { $$typeof: k$3, type: c2, key: e3, ref: h2, props: d2, _owner: n$3.current };
  }
  reactJsxRuntime_production_min.Fragment = l$3;
  reactJsxRuntime_production_min.jsx = q$3;
  reactJsxRuntime_production_min.jsxs = q$3;
  (function(module2) {
    {
      module2.exports = reactJsxRuntime_production_min;
    }
  })(jsxRuntime);
  var Collapse$2 = {};
  function _typeof$9(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$9 = function _typeof2(obj2) {
        return typeof obj2;
      };
    } else {
      _typeof$9 = function _typeof2(obj2) {
        return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
      };
    }
    return _typeof$9(obj);
  }
  Object.defineProperty(Collapse$2, "__esModule", {
    value: true
  });
  Collapse$2.Collapse = void 0;
  var _react$1 = _interopRequireDefault$1(React__default.default);
  function _interopRequireDefault$1(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }
  function _classCallCheck$j(instance2, Constructor) {
    if (!(instance2 instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _defineProperties$j(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  function _createClass$j(Constructor, protoProps, staticProps) {
    if (protoProps)
      _defineProperties$j(Constructor.prototype, protoProps);
    if (staticProps)
      _defineProperties$j(Constructor, staticProps);
    return Constructor;
  }
  function _inherits$3(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
    if (superClass)
      _setPrototypeOf$4(subClass, superClass);
  }
  function _setPrototypeOf$4(o2, p2) {
    _setPrototypeOf$4 = Object.setPrototypeOf || function _setPrototypeOf2(o3, p3) {
      o3.__proto__ = p3;
      return o3;
    };
    return _setPrototypeOf$4(o2, p2);
  }
  function _createSuper$3(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct$3();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf$3(Derived), result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf$3(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn$3(this, result);
    };
  }
  function _possibleConstructorReturn$3(self2, call2) {
    if (call2 && (_typeof$9(call2) === "object" || typeof call2 === "function")) {
      return call2;
    } else if (call2 !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }
    return _assertThisInitialized$4(self2);
  }
  function _assertThisInitialized$4(self2) {
    if (self2 === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self2;
  }
  function _isNativeReflectConstruct$3() {
    if (typeof Reflect === "undefined" || !Reflect.construct)
      return false;
    if (Reflect.construct.sham)
      return false;
    if (typeof Proxy === "function")
      return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
      }));
      return true;
    } catch (e3) {
      return false;
    }
  }
  function _getPrototypeOf$3(o2) {
    _getPrototypeOf$3 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o3) {
      return o3.__proto__ || Object.getPrototypeOf(o3);
    };
    return _getPrototypeOf$3(o2);
  }
  function _defineProperty$s(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  var Collapse$1 = /* @__PURE__ */ function(_React$Component) {
    _inherits$3(Collapse2, _React$Component);
    var _super = _createSuper$3(Collapse2);
    function Collapse2(props) {
      var _this;
      _classCallCheck$j(this, Collapse2);
      _this = _super.call(this, props);
      _defineProperty$s(_assertThisInitialized$4(_this), "timeout", void 0);
      _defineProperty$s(_assertThisInitialized$4(_this), "container", void 0);
      _defineProperty$s(_assertThisInitialized$4(_this), "content", void 0);
      _defineProperty$s(_assertThisInitialized$4(_this), "onResize", function() {
        clearTimeout(_this.timeout);
        if (!_this.container || !_this.content) {
          return;
        }
        var _this$props = _this.props, isOpened = _this$props.isOpened, checkTimeout = _this$props.checkTimeout;
        var containerHeight = Math.floor(_this.container.clientHeight);
        var contentHeight = Math.floor(_this.content.clientHeight);
        var isFullyOpened = isOpened && Math.abs(contentHeight - containerHeight) <= 1;
        var isFullyClosed = !isOpened && Math.abs(containerHeight) <= 1;
        if (isFullyOpened || isFullyClosed) {
          _this.onRest({
            isFullyOpened,
            isFullyClosed,
            isOpened,
            containerHeight,
            contentHeight
          });
        } else {
          _this.onWork({
            isFullyOpened,
            isFullyClosed,
            isOpened,
            containerHeight,
            contentHeight
          });
          _this.timeout = setTimeout(function() {
            return _this.onResize();
          }, checkTimeout);
        }
      });
      _defineProperty$s(_assertThisInitialized$4(_this), "onRest", function(_ref2) {
        var isFullyOpened = _ref2.isFullyOpened, isFullyClosed = _ref2.isFullyClosed, isOpened = _ref2.isOpened, containerHeight = _ref2.containerHeight, contentHeight = _ref2.contentHeight;
        if (!_this.container || !_this.content) {
          return;
        }
        var hasOpened = isOpened && _this.container.style.height === "".concat(contentHeight, "px");
        var hasClosed = !isOpened && _this.container.style.height === "0px";
        if (hasOpened || hasClosed) {
          _this.container.style.overflow = isOpened ? "initial" : "hidden";
          _this.container.style.height = isOpened ? "auto" : "0px";
          var onRest = _this.props.onRest;
          if (onRest) {
            onRest({
              isFullyOpened,
              isFullyClosed,
              isOpened,
              containerHeight,
              contentHeight
            });
          }
        }
      });
      _defineProperty$s(_assertThisInitialized$4(_this), "onWork", function(_ref2) {
        var isFullyOpened = _ref2.isFullyOpened, isFullyClosed = _ref2.isFullyClosed, isOpened = _ref2.isOpened, containerHeight = _ref2.containerHeight, contentHeight = _ref2.contentHeight;
        if (!_this.container || !_this.content) {
          return;
        }
        var isOpenining = isOpened && _this.container.style.height === "".concat(contentHeight, "px");
        var isClosing = !isOpened && _this.container.style.height === "0px";
        if (isOpenining || isClosing) {
          return;
        }
        _this.container.style.overflow = "hidden";
        _this.container.style.height = isOpened ? "".concat(contentHeight, "px") : "0px";
        var onWork = _this.props.onWork;
        if (onWork) {
          onWork({
            isFullyOpened,
            isFullyClosed,
            isOpened,
            containerHeight,
            contentHeight
          });
        }
      });
      _defineProperty$s(_assertThisInitialized$4(_this), "onRefContainer", function(container) {
        _this.container = container;
      });
      _defineProperty$s(_assertThisInitialized$4(_this), "onRefContent", function(content2) {
        _this.content = content2;
      });
      if (props.initialStyle) {
        _this.initialStyle = props.initialStyle;
      } else {
        _this.initialStyle = props.isOpened ? {
          height: "auto",
          overflow: "initial"
        } : {
          height: "0px",
          overflow: "hidden"
        };
      }
      return _this;
    }
    _createClass$j(Collapse2, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.onResize();
      }
    }, {
      key: "shouldComponentUpdate",
      value: function shouldComponentUpdate(nextProps) {
        var _this$props2 = this.props, theme2 = _this$props2.theme, isOpened = _this$props2.isOpened, children2 = _this$props2.children;
        return children2 !== nextProps.children || isOpened !== nextProps.isOpened || Object.keys(theme2).some(function(c2) {
          return theme2[c2] !== nextProps.theme[c2];
        });
      }
    }, {
      key: "getSnapshotBeforeUpdate",
      value: function getSnapshotBeforeUpdate() {
        if (!this.container || !this.content) {
          return null;
        }
        if (this.container.style.height === "auto") {
          var contentHeight = this.content.clientHeight;
          this.container.style.height = "".concat(contentHeight, "px");
        }
        return null;
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        this.onResize();
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        clearTimeout(this.timeout);
      }
    }, {
      key: "render",
      value: function render2() {
        var _this$props3 = this.props, theme2 = _this$props3.theme, children2 = _this$props3.children, isOpened = _this$props3.isOpened;
        return /* @__PURE__ */ _react$1["default"].createElement("div", {
          ref: this.onRefContainer,
          className: theme2.collapse,
          style: this.initialStyle,
          "aria-hidden": !isOpened
        }, /* @__PURE__ */ _react$1["default"].createElement("div", {
          ref: this.onRefContent,
          className: theme2.content
        }, children2));
      }
    }]);
    return Collapse2;
  }(_react$1["default"].Component);
  Collapse$2.Collapse = Collapse$1;
  _defineProperty$s(Collapse$1, "defaultProps", {
    theme: {
      collapse: "ReactCollapse--collapse",
      content: "ReactCollapse--content"
    },
    initialStyle: void 0,
    onRest: void 0,
    onWork: void 0,
    checkTimeout: 50
  });
  var UnmountClosed$2 = {};
  function _typeof$8(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof$8 = function _typeof2(obj2) {
        return typeof obj2;
      };
    } else {
      _typeof$8 = function _typeof2(obj2) {
        return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
      };
    }
    return _typeof$8(obj);
  }
  Object.defineProperty(UnmountClosed$2, "__esModule", {
    value: true
  });
  UnmountClosed$2.UnmountClosed = void 0;
  var _react = _interopRequireDefault(React__default.default);
  var _Collapse = Collapse$2;
  var _excluded$6 = ["isOpened"], _excluded2$4 = ["isOpened"];
  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }
  function _extends$3() {
    _extends$3 = Object.assign || function(target) {
      for (var i2 = 1; i2 < arguments.length; i2++) {
        var source = arguments[i2];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends$3.apply(this, arguments);
  }
  function ownKeys$9(object2, enumerableOnly) {
    var keys2 = Object.keys(object2);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object2);
      if (enumerableOnly) {
        symbols = symbols.filter(function(sym) {
          return Object.getOwnPropertyDescriptor(object2, sym).enumerable;
        });
      }
      keys2.push.apply(keys2, symbols);
    }
    return keys2;
  }
  function _objectSpread$6(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source = arguments[i2] != null ? arguments[i2] : {};
      if (i2 % 2) {
        ownKeys$9(Object(source), true).forEach(function(key) {
          _defineProperty$r(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys$9(Object(source)).forEach(function(key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }
    return target;
  }
  function _objectWithoutProperties$3(source, excluded) {
    if (source == null)
      return {};
    var target = _objectWithoutPropertiesLoose$6(source, excluded);
    var key, i2;
    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
      for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
        key = sourceSymbolKeys[i2];
        if (excluded.indexOf(key) >= 0)
          continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key))
          continue;
        target[key] = source[key];
      }
    }
    return target;
  }
  function _objectWithoutPropertiesLoose$6(source, excluded) {
    if (source == null)
      return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i2;
    for (i2 = 0; i2 < sourceKeys.length; i2++) {
      key = sourceKeys[i2];
      if (excluded.indexOf(key) >= 0)
        continue;
      target[key] = source[key];
    }
    return target;
  }
  function _classCallCheck$i(instance2, Constructor) {
    if (!(instance2 instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _defineProperties$i(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  function _createClass$i(Constructor, protoProps, staticProps) {
    if (protoProps)
      _defineProperties$i(Constructor.prototype, protoProps);
    if (staticProps)
      _defineProperties$i(Constructor, staticProps);
    return Constructor;
  }
  function _inherits$2(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }
    subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
    if (superClass)
      _setPrototypeOf$3(subClass, superClass);
  }
  function _setPrototypeOf$3(o2, p2) {
    _setPrototypeOf$3 = Object.setPrototypeOf || function _setPrototypeOf2(o3, p3) {
      o3.__proto__ = p3;
      return o3;
    };
    return _setPrototypeOf$3(o2, p2);
  }
  function _createSuper$2(Derived) {
    var hasNativeReflectConstruct = _isNativeReflectConstruct$2();
    return function _createSuperInternal() {
      var Super = _getPrototypeOf$2(Derived), result;
      if (hasNativeReflectConstruct) {
        var NewTarget = _getPrototypeOf$2(this).constructor;
        result = Reflect.construct(Super, arguments, NewTarget);
      } else {
        result = Super.apply(this, arguments);
      }
      return _possibleConstructorReturn$2(this, result);
    };
  }
  function _possibleConstructorReturn$2(self2, call2) {
    if (call2 && (_typeof$8(call2) === "object" || typeof call2 === "function")) {
      return call2;
    } else if (call2 !== void 0) {
      throw new TypeError("Derived constructors may only return object or undefined");
    }
    return _assertThisInitialized$3(self2);
  }
  function _assertThisInitialized$3(self2) {
    if (self2 === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }
    return self2;
  }
  function _isNativeReflectConstruct$2() {
    if (typeof Reflect === "undefined" || !Reflect.construct)
      return false;
    if (Reflect.construct.sham)
      return false;
    if (typeof Proxy === "function")
      return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
      }));
      return true;
    } catch (e3) {
      return false;
    }
  }
  function _getPrototypeOf$2(o2) {
    _getPrototypeOf$2 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o3) {
      return o3.__proto__ || Object.getPrototypeOf(o3);
    };
    return _getPrototypeOf$2(o2);
  }
  function _defineProperty$r(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  var UnmountClosed$1 = /* @__PURE__ */ function(_React$PureComponent) {
    _inherits$2(UnmountClosed2, _React$PureComponent);
    var _super = _createSuper$2(UnmountClosed2);
    function UnmountClosed2(props) {
      var _this;
      _classCallCheck$i(this, UnmountClosed2);
      _this = _super.call(this, props);
      _defineProperty$r(_assertThisInitialized$3(_this), "onWork", function(_ref2) {
        var isOpened = _ref2.isOpened, rest = _objectWithoutProperties$3(_ref2, _excluded$6);
        _this.setState({
          isResting: false,
          isOpened
        });
        var onWork = _this.props.onWork;
        if (onWork) {
          onWork(_objectSpread$6({
            isOpened
          }, rest));
        }
      });
      _defineProperty$r(_assertThisInitialized$3(_this), "onRest", function(_ref2) {
        var isOpened = _ref2.isOpened, rest = _objectWithoutProperties$3(_ref2, _excluded2$4);
        _this.setState({
          isResting: true,
          isOpened,
          isInitialRender: false
        });
        var onRest = _this.props.onRest;
        if (onRest) {
          onRest(_objectSpread$6({
            isOpened
          }, rest));
        }
      });
      _defineProperty$r(_assertThisInitialized$3(_this), "getInitialStyle", function() {
        var _this$state = _this.state, isOpened = _this$state.isOpened, isInitialRender = _this$state.isInitialRender;
        if (isInitialRender) {
          return isOpened ? {
            height: "auto",
            overflow: "initial"
          } : {
            height: "0px",
            overflow: "hidden"
          };
        }
        return {
          height: "0px",
          overflow: "hidden"
        };
      });
      _this.state = {
        isResting: true,
        isOpened: props.isOpened,
        isInitialRender: true
      };
      return _this;
    }
    _createClass$i(UnmountClosed2, [{
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        var isOpened = this.props.isOpened;
        if (prevProps.isOpened !== isOpened) {
          this.setState({
            isResting: false,
            isOpened,
            isInitialRender: false
          });
        }
      }
    }, {
      key: "render",
      value: function render2() {
        var _this$state2 = this.state, isResting = _this$state2.isResting, isOpened = _this$state2.isOpened;
        return isResting && !isOpened ? null : /* @__PURE__ */ _react["default"].createElement(_Collapse.Collapse, _extends$3({}, this.props, {
          initialStyle: this.getInitialStyle(),
          onWork: this.onWork,
          onRest: this.onRest
        }));
      }
    }]);
    return UnmountClosed2;
  }(_react["default"].PureComponent);
  UnmountClosed$2.UnmountClosed = UnmountClosed$1;
  _defineProperty$r(UnmountClosed$1, "defaultProps", {
    onWork: void 0,
    onRest: void 0
  });
  var _require = Collapse$2, Collapse = _require.Collapse;
  var _require2 = UnmountClosed$2, UnmountClosed = _require2.UnmountClosed;
  var lib$2 = UnmountClosed;
  UnmountClosed.Collapse = Collapse;
  UnmountClosed.UnmountClosed = UnmountClosed;
  var faTrashCan = {
    prefix: "fas",
    iconName: "trash-can",
    icon: [448, 512, [61460, "trash-alt"], "f2ed", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM32 128H416V448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V128zm96 64c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16z"]
  };
  var faTrashAlt = faTrashCan;
  var faDownLeftAndUpRightToCenter = {
    prefix: "fas",
    iconName: "down-left-and-up-right-to-center",
    icon: [512, 512, ["compress-alt"], "f422", "M439 7c9.4-9.4 24.6-9.4 33.9 0l32 32c9.4 9.4 9.4 24.6 0 33.9l-87 87 39 39c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8H296c-13.3 0-24-10.7-24-24V72c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l39 39L439 7zM72 272H216c13.3 0 24 10.7 24 24V440c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-39-39L73 505c-9.4 9.4-24.6 9.4-33.9 0L7 473c-9.4-9.4-9.4-24.6 0-33.9l87-87L55 313c-6.9-6.9-8.9-17.2-5.2-26.2s12.5-14.8 22.2-14.8z"]
  };
  var faToggleOff = {
    prefix: "fas",
    iconName: "toggle-off",
    icon: [576, 512, [], "f204", "M384 128c70.7 0 128 57.3 128 128s-57.3 128-128 128H192c-70.7 0-128-57.3-128-128s57.3-128 128-128H384zM576 256c0-106-86-192-192-192H192C86 64 0 150 0 256S86 448 192 448H384c106 0 192-86 192-192zM192 352a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"]
  };
  var faSquareCheck = {
    prefix: "fas",
    iconName: "square-check",
    icon: [448, 512, [9745, 9989, 61510, "check-square"], "f14a", "M64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zM337 209L209 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L303 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]
  };
  var faCheckSquare = faSquareCheck;
  var faList = {
    prefix: "fas",
    iconName: "list",
    icon: [512, 512, ["list-squares"], "f03a", "M40 48C26.7 48 16 58.7 16 72v48c0 13.3 10.7 24 24 24H88c13.3 0 24-10.7 24-24V72c0-13.3-10.7-24-24-24H40zM192 64c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H192zm0 160c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H192zm0 160c-17.7 0-32 14.3-32 32s14.3 32 32 32H480c17.7 0 32-14.3 32-32s-14.3-32-32-32H192zM16 232v48c0 13.3 10.7 24 24 24H88c13.3 0 24-10.7 24-24V232c0-13.3-10.7-24-24-24H40c-13.3 0-24 10.7-24 24zM40 368c-13.3 0-24 10.7-24 24v48c0 13.3 10.7 24 24 24H88c13.3 0 24-10.7 24-24V392c0-13.3-10.7-24-24-24H40z"]
  };
  var faPenToSquare = {
    prefix: "fas",
    iconName: "pen-to-square",
    icon: [512, 512, ["edit"], "f044", "M471.6 21.7c-21.9-21.9-57.3-21.9-79.2 0L362.3 51.7l97.9 97.9 30.1-30.1c21.9-21.9 21.9-57.3 0-79.2L471.6 21.7zm-299.2 220c-6.1 6.1-10.8 13.6-13.5 21.9l-29.6 88.8c-2.9 8.6-.6 18.1 5.8 24.6s15.9 8.7 24.6 5.8l88.8-29.6c8.2-2.7 15.7-7.4 21.9-13.5L437.7 172.3 339.7 74.3 172.4 241.7zM96 64C43 64 0 107 0 160V416c0 53 43 96 96 96H352c53 0 96-43 96-96V320c0-17.7-14.3-32-32-32s-32 14.3-32 32v96c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V160c0-17.7 14.3-32 32-32h96c17.7 0 32-14.3 32-32s-14.3-32-32-32H96z"]
  };
  var faChevronUp = {
    prefix: "fas",
    iconName: "chevron-up",
    icon: [512, 512, [], "f077", "M233.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 173.3 86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z"]
  };
  var faBan = {
    prefix: "fas",
    iconName: "ban",
    icon: [512, 512, [128683, "cancel"], "f05e", "M367.2 412.5L99.5 144.8C77.1 176.1 64 214.5 64 256c0 106 86 192 192 192c41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3C434.9 335.9 448 297.5 448 256c0-106-86-192-192-192c-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"]
  };
  var faToggleOn = {
    prefix: "fas",
    iconName: "toggle-on",
    icon: [576, 512, [], "f205", "M192 64C86 64 0 150 0 256S86 448 192 448H384c106 0 192-86 192-192s-86-192-192-192H192zm192 96a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]
  };
  var faCircleCheck = {
    prefix: "fas",
    iconName: "circle-check",
    icon: [512, 512, [61533, "check-circle"], "f058", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]
  };
  var faLeftRight = {
    prefix: "fas",
    iconName: "left-right",
    icon: [512, 512, [8596, "arrows-alt-h"], "f337", "M504.3 273.6c4.9-4.5 7.7-10.9 7.7-17.6s-2.8-13-7.7-17.6l-112-104c-7-6.5-17.2-8.2-25.9-4.4s-14.4 12.5-14.4 22l0 56-192 0 0-56c0-9.5-5.7-18.2-14.4-22s-18.9-2.1-25.9 4.4l-112 104C2.8 243 0 249.3 0 256s2.8 13 7.7 17.6l112 104c7 6.5 17.2 8.2 25.9 4.4s14.4-12.5 14.4-22l0-56 192 0 0 56c0 9.5 5.7 18.2 14.4 22s18.9 2.1 25.9-4.4l112-104z"]
  };
  var faArrowsAltH = faLeftRight;
  var faArrowsRotate = {
    prefix: "fas",
    iconName: "arrows-rotate",
    icon: [512, 512, [128472, "refresh", "sync"], "f021", "M105.1 202.6c7.7-21.8 20.2-42.3 37.8-59.8c62.5-62.5 163.8-62.5 226.3 0L386.3 160H336c-17.7 0-32 14.3-32 32s14.3 32 32 32H463.5c0 0 0 0 0 0h.4c17.7 0 32-14.3 32-32V64c0-17.7-14.3-32-32-32s-32 14.3-32 32v51.2L414.4 97.6c-87.5-87.5-229.3-87.5-316.8 0C73.2 122 55.6 150.7 44.8 181.4c-5.9 16.7 2.9 34.9 19.5 40.8s34.9-2.9 40.8-19.5zM39 289.3c-5 1.5-9.8 4.2-13.7 8.2c-4 4-6.7 8.8-8.1 14c-.3 1.2-.6 2.5-.8 3.8c-.3 1.7-.4 3.4-.4 5.1V448c0 17.7 14.3 32 32 32s32-14.3 32-32V396.9l17.6 17.5 0 0c87.5 87.4 229.3 87.4 316.7 0c24.4-24.4 42.1-53.1 52.9-83.7c5.9-16.7-2.9-34.9-19.5-40.8s-34.9 2.9-40.8 19.5c-7.7 21.8-20.2 42.3-37.8 59.8c-62.5 62.5-163.8 62.5-226.3 0l-.1-.1L125.6 352H176c17.7 0 32-14.3 32-32s-14.3-32-32-32H48.4c-1.6 0-3.2 .1-4.8 .3s-3.1 .5-4.6 1z"]
  };
  var faRefresh = faArrowsRotate;
  var faFilter = {
    prefix: "fas",
    iconName: "filter",
    icon: [512, 512, [], "f0b0", "M3.9 54.9C10.5 40.9 24.5 32 40 32H472c15.5 0 29.5 8.9 36.1 22.9s4.6 30.5-5.2 42.5L320 320.9V448c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48c-8.1-6-12.8-15.5-12.8-25.6V320.9L9 97.3C-.7 85.4-2.8 68.8 3.9 54.9z"]
  };
  var faArrowRight = {
    prefix: "fas",
    iconName: "arrow-right",
    icon: [448, 512, [8594], "f061", "M438.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L338.8 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l306.7 0L233.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z"]
  };
  var faCircle = {
    prefix: "fas",
    iconName: "circle",
    icon: [512, 512, [128308, 128309, 128992, 128993, 128994, 128995, 128996, 9679, 9898, 9899, 11044, 61708, 61915], "f111", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512z"]
  };
  var faTrash = {
    prefix: "fas",
    iconName: "trash",
    icon: [448, 512, [], "f1f8", "M135.2 17.7L128 32H32C14.3 32 0 46.3 0 64S14.3 96 32 96H416c17.7 0 32-14.3 32-32s-14.3-32-32-32H320l-7.2-14.3C307.4 6.8 296.3 0 284.2 0H163.8c-12.1 0-23.2 6.8-28.6 17.7zM416 128H32L53.2 467c1.6 25.3 22.6 45 47.9 45H346.9c25.3 0 46.3-19.7 47.9-45L416 128z"]
  };
  var faArrowLeft = {
    prefix: "fas",
    iconName: "arrow-left",
    icon: [448, 512, [8592], "f060", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.2 288 416 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-306.7 0L214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160z"]
  };
  var faCircleInfo = {
    prefix: "fas",
    iconName: "circle-info",
    icon: [512, 512, ["info-circle"], "f05a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM216 336h24V272H216c-13.3 0-24-10.7-24-24s10.7-24 24-24h48c13.3 0 24 10.7 24 24v88h8c13.3 0 24 10.7 24 24s-10.7 24-24 24H216c-13.3 0-24-10.7-24-24s10.7-24 24-24zm40-208a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
  };
  var faEllipsisVertical = {
    prefix: "fas",
    iconName: "ellipsis-vertical",
    icon: [128, 512, ["ellipsis-v"], "f142", "M64 360a56 56 0 1 0 0 112 56 56 0 1 0 0-112zm0-160a56 56 0 1 0 0 112 56 56 0 1 0 0-112zM120 96A56 56 0 1 0 8 96a56 56 0 1 0 112 0z"]
  };
  var faEllipsisV = faEllipsisVertical;
  var faArrowRightLong = {
    prefix: "fas",
    iconName: "arrow-right-long",
    icon: [512, 512, ["long-arrow-right"], "f178", "M502.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l370.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"]
  };
  var faArrowDown = {
    prefix: "fas",
    iconName: "arrow-down",
    icon: [384, 512, [8595], "f063", "M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"]
  };
  var faMagnifyingGlass = {
    prefix: "fas",
    iconName: "magnifying-glass",
    icon: [512, 512, [128269, "search"], "f002", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"]
  };
  var faSearch = faMagnifyingGlass;
  var faChevronDown = {
    prefix: "fas",
    iconName: "chevron-down",
    icon: [512, 512, [], "f078", "M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z"]
  };
  var faArrowUp = {
    prefix: "fas",
    iconName: "arrow-up",
    icon: [384, 512, [8593], "f062", "M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.2V448c0 17.7 14.3 32 32 32s32-14.3 32-32V141.2L329.4 246.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160z"]
  };
  var faPlus = {
    prefix: "fas",
    iconName: "plus",
    icon: [448, 512, [10133, 61543, "add"], "2b", "M256 80c0-17.7-14.3-32-32-32s-32 14.3-32 32V224H48c-17.7 0-32 14.3-32 32s14.3 32 32 32H192V432c0 17.7 14.3 32 32 32s32-14.3 32-32V288H400c17.7 0 32-14.3 32-32s-14.3-32-32-32H256V80z"]
  };
  var faXmark = {
    prefix: "fas",
    iconName: "xmark",
    icon: [384, 512, [128473, 10005, 10006, 10060, 215, "close", "multiply", "remove", "times"], "f00d", "M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"]
  };
  var faTimes = faXmark;
  var faArrowsUpDownLeftRight = {
    prefix: "fas",
    iconName: "arrows-up-down-left-right",
    icon: [512, 512, ["arrows"], "f047", "M278.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l9.4-9.4V224H109.3l9.4-9.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4H224V402.7l-9.4-9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-9.4 9.4V288H402.7l-9.4 9.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4H288V109.3l9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64z"]
  };
  var faArrows = faArrowsUpDownLeftRight;
  var faChevronLeft = {
    prefix: "fas",
    iconName: "chevron-left",
    icon: [320, 512, [9001], "f053", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l192 192c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 246.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192z"]
  };
  var faChevronRight = {
    prefix: "fas",
    iconName: "chevron-right",
    icon: [320, 512, [9002], "f054", "M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z"]
  };
  var faMoon = {
    prefix: "fas",
    iconName: "moon",
    icon: [384, 512, [127769, 9214], "f186", "M223.5 32C100 32 0 132.3 0 256S100 480 223.5 480c60.6 0 115.5-24.2 155.8-63.4c5-4.9 6.3-12.5 3.1-18.7s-10.1-9.7-17-8.5c-9.8 1.7-19.8 2.6-30.1 2.6c-96.9 0-175.5-78.8-175.5-176c0-65.8 36-123.1 89.3-153.3c6.1-3.5 9.2-10.5 7.7-17.3s-7.3-11.9-14.3-12.5c-6.3-.5-12.6-.8-19-.8z"]
  };
  var faUpRightAndDownLeftFromCenter = {
    prefix: "fas",
    iconName: "up-right-and-down-left-from-center",
    icon: [512, 512, ["expand-alt"], "f424", "M344 0H488c13.3 0 24 10.7 24 24V168c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-39-39-87 87c-9.4 9.4-24.6 9.4-33.9 0l-32-32c-9.4-9.4-9.4-24.6 0-33.9l87-87L327 41c-6.9-6.9-8.9-17.2-5.2-26.2S334.3 0 344 0zM168 512H24c-13.3 0-24-10.7-24-24V344c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l39 39 87-87c9.4-9.4 24.6-9.4 33.9 0l32 32c9.4 9.4 9.4 24.6 0 33.9l-87 87 39 39c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8z"]
  };
  var faCheck = {
    prefix: "fas",
    iconName: "check",
    icon: [448, 512, [10003, 10004], "f00c", "M438.6 105.4c12.5 12.5 12.5 32.8 0 45.3l-256 256c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L160 338.7 393.4 105.4c12.5-12.5 32.8-12.5 45.3 0z"]
  };
  var faTriangleExclamation = {
    prefix: "fas",
    iconName: "triangle-exclamation",
    icon: [512, 512, [9888, "exclamation-triangle", "warning"], "f071", "M256 32c14.2 0 27.3 7.5 34.5 19.8l216 368c7.3 12.4 7.3 27.7 .2 40.1S486.3 480 472 480H40c-14.3 0-27.6-7.7-34.7-20.1s-7-27.8 .2-40.1l216-368C228.7 39.5 241.8 32 256 32zm0 128c-13.3 0-24 10.7-24 24V296c0 13.3 10.7 24 24 24s24-10.7 24-24V184c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
  };
  var faCircleXmark = {
    prefix: "fas",
    iconName: "circle-xmark",
    icon: [512, 512, [61532, "times-circle", "xmark-circle"], "f057", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM175 175c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z"]
  };
  function ownKeys$8(object2, enumerableOnly) {
    var keys2 = Object.keys(object2);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object2);
      enumerableOnly && (symbols = symbols.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object2, sym).enumerable;
      })), keys2.push.apply(keys2, symbols);
    }
    return keys2;
  }
  function _objectSpread2$2(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source = null != arguments[i2] ? arguments[i2] : {};
      i2 % 2 ? ownKeys$8(Object(source), true).forEach(function(key) {
        _defineProperty$q(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys$8(Object(source)).forEach(function(key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
    return target;
  }
  function _typeof$7(obj) {
    "@babel/helpers - typeof";
    return _typeof$7 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof$7(obj);
  }
  function _classCallCheck$h(instance2, Constructor) {
    if (!(instance2 instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }
  function _defineProperties$h(target, props) {
    for (var i2 = 0; i2 < props.length; i2++) {
      var descriptor = props[i2];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor)
        descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }
  function _createClass$h(Constructor, protoProps, staticProps) {
    if (protoProps)
      _defineProperties$h(Constructor.prototype, protoProps);
    if (staticProps)
      _defineProperties$h(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
      writable: false
    });
    return Constructor;
  }
  function _defineProperty$q(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  function _slicedToArray$a(arr, i2) {
    return _arrayWithHoles$a(arr) || _iterableToArrayLimit$a(arr, i2) || _unsupportedIterableToArray$b(arr, i2) || _nonIterableRest$a();
  }
  function _toConsumableArray$4(arr) {
    return _arrayWithoutHoles$4(arr) || _iterableToArray$4(arr) || _unsupportedIterableToArray$b(arr) || _nonIterableSpread$4();
  }
  function _arrayWithoutHoles$4(arr) {
    if (Array.isArray(arr))
      return _arrayLikeToArray$b(arr);
  }
  function _arrayWithHoles$a(arr) {
    if (Array.isArray(arr))
      return arr;
  }
  function _iterableToArray$4(iter2) {
    if (typeof Symbol !== "undefined" && iter2[Symbol.iterator] != null || iter2["@@iterator"] != null)
      return Array.from(iter2);
  }
  function _iterableToArrayLimit$a(arr, i2) {
    var _i2 = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];
    if (_i2 == null)
      return;
    var _arr = [];
    var _n2 = true;
    var _d = false;
    var _s, _e2;
    try {
      for (_i2 = _i2.call(arr); !(_n2 = (_s = _i2.next()).done); _n2 = true) {
        _arr.push(_s.value);
        if (i2 && _arr.length === i2)
          break;
      }
    } catch (err) {
      _d = true;
      _e2 = err;
    } finally {
      try {
        if (!_n2 && _i2["return"] != null)
          _i2["return"]();
      } finally {
        if (_d)
          throw _e2;
      }
    }
    return _arr;
  }
  function _unsupportedIterableToArray$b(o2, minLen) {
    if (!o2)
      return;
    if (typeof o2 === "string")
      return _arrayLikeToArray$b(o2, minLen);
    var n2 = Object.prototype.toString.call(o2).slice(8, -1);
    if (n2 === "Object" && o2.constructor)
      n2 = o2.constructor.name;
    if (n2 === "Map" || n2 === "Set")
      return Array.from(o2);
    if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
      return _arrayLikeToArray$b(o2, minLen);
  }
  function _arrayLikeToArray$b(arr, len) {
    if (len == null || len > arr.length)
      len = arr.length;
    for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
      arr2[i2] = arr[i2];
    return arr2;
  }
  function _nonIterableSpread$4() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function _nonIterableRest$a() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var noop$7 = function noop2() {
  };
  var _WINDOW = {};
  var _DOCUMENT = {};
  var _MUTATION_OBSERVER = null;
  var _PERFORMANCE = {
    mark: noop$7,
    measure: noop$7
  };
  try {
    if (typeof window !== "undefined")
      _WINDOW = window;
    if (typeof document !== "undefined")
      _DOCUMENT = document;
    if (typeof MutationObserver !== "undefined")
      _MUTATION_OBSERVER = MutationObserver;
    if (typeof performance !== "undefined")
      _PERFORMANCE = performance;
  } catch (e3) {
  }
  var _ref = _WINDOW.navigator || {}, _ref$userAgent = _ref.userAgent, userAgent = _ref$userAgent === void 0 ? "" : _ref$userAgent;
  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var MUTATION_OBSERVER = _MUTATION_OBSERVER;
  var PERFORMANCE = _PERFORMANCE;
  !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === "function" && typeof DOCUMENT.createElement === "function";
  var IS_IE = ~userAgent.indexOf("MSIE") || ~userAgent.indexOf("Trident/");
  var _familyProxy, _familyProxy2, _familyProxy3, _familyProxy4, _familyProxy5;
  var NAMESPACE_IDENTIFIER = "___FONT_AWESOME___";
  var UNITS_IN_GRID = 16;
  var DEFAULT_CSS_PREFIX = "fa";
  var DEFAULT_REPLACEMENT_CLASS = "svg-inline--fa";
  var DATA_FA_I2SVG = "data-fa-i2svg";
  var DATA_FA_PSEUDO_ELEMENT = "data-fa-pseudo-element";
  var DATA_FA_PSEUDO_ELEMENT_PENDING = "data-fa-pseudo-element-pending";
  var DATA_PREFIX = "data-prefix";
  var DATA_ICON = "data-icon";
  var HTML_CLASS_I2SVG_BASE_CLASS = "fontawesome-i2svg";
  var MUTATION_APPROACH_ASYNC = "async";
  var TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS = ["HTML", "HEAD", "STYLE", "SCRIPT"];
  var PRODUCTION$1 = function() {
    try {
      return true;
    } catch (e3) {
      return false;
    }
  }();
  var FAMILY_CLASSIC = "classic";
  var FAMILY_SHARP = "sharp";
  var FAMILIES = [FAMILY_CLASSIC, FAMILY_SHARP];
  function familyProxy(obj) {
    return new Proxy(obj, {
      get: function get2(target, prop) {
        return prop in target ? target[prop] : target[FAMILY_CLASSIC];
      }
    });
  }
  var PREFIX_TO_STYLE = familyProxy((_familyProxy = {}, _defineProperty$q(_familyProxy, FAMILY_CLASSIC, {
    "fa": "solid",
    "fas": "solid",
    "fa-solid": "solid",
    "far": "regular",
    "fa-regular": "regular",
    "fal": "light",
    "fa-light": "light",
    "fat": "thin",
    "fa-thin": "thin",
    "fad": "duotone",
    "fa-duotone": "duotone",
    "fab": "brands",
    "fa-brands": "brands",
    "fak": "kit",
    "fa-kit": "kit"
  }), _defineProperty$q(_familyProxy, FAMILY_SHARP, {
    "fa": "solid",
    "fass": "solid",
    "fa-solid": "solid",
    "fasr": "regular",
    "fa-regular": "regular",
    "fasl": "light",
    "fa-light": "light"
  }), _familyProxy));
  var STYLE_TO_PREFIX = familyProxy((_familyProxy2 = {}, _defineProperty$q(_familyProxy2, FAMILY_CLASSIC, {
    "solid": "fas",
    "regular": "far",
    "light": "fal",
    "thin": "fat",
    "duotone": "fad",
    "brands": "fab",
    "kit": "fak"
  }), _defineProperty$q(_familyProxy2, FAMILY_SHARP, {
    "solid": "fass",
    "regular": "fasr",
    "light": "fasl"
  }), _familyProxy2));
  var PREFIX_TO_LONG_STYLE = familyProxy((_familyProxy3 = {}, _defineProperty$q(_familyProxy3, FAMILY_CLASSIC, {
    "fab": "fa-brands",
    "fad": "fa-duotone",
    "fak": "fa-kit",
    "fal": "fa-light",
    "far": "fa-regular",
    "fas": "fa-solid",
    "fat": "fa-thin"
  }), _defineProperty$q(_familyProxy3, FAMILY_SHARP, {
    "fass": "fa-solid",
    "fasr": "fa-regular",
    "fasl": "fa-light"
  }), _familyProxy3));
  var LONG_STYLE_TO_PREFIX = familyProxy((_familyProxy4 = {}, _defineProperty$q(_familyProxy4, FAMILY_CLASSIC, {
    "fa-brands": "fab",
    "fa-duotone": "fad",
    "fa-kit": "fak",
    "fa-light": "fal",
    "fa-regular": "far",
    "fa-solid": "fas",
    "fa-thin": "fat"
  }), _defineProperty$q(_familyProxy4, FAMILY_SHARP, {
    "fa-solid": "fass",
    "fa-regular": "fasr",
    "fa-light": "fasl"
  }), _familyProxy4));
  var ICON_SELECTION_SYNTAX_PATTERN = /fa(s|r|l|t|d|b|k|ss|sr|sl)?[\-\ ]/;
  var LAYERS_TEXT_CLASSNAME = "fa-layers-text";
  var FONT_FAMILY_PATTERN = /Font ?Awesome ?([56 ]*)(Solid|Regular|Light|Thin|Duotone|Brands|Free|Pro|Sharp|Kit)?.*/i;
  var FONT_WEIGHT_TO_PREFIX = familyProxy((_familyProxy5 = {}, _defineProperty$q(_familyProxy5, FAMILY_CLASSIC, {
    "900": "fas",
    "400": "far",
    "normal": "far",
    "300": "fal",
    "100": "fat"
  }), _defineProperty$q(_familyProxy5, FAMILY_SHARP, {
    "900": "fass",
    "400": "fasr",
    "300": "fasl"
  }), _familyProxy5));
  var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
  var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
  var ATTRIBUTES_WATCHED_FOR_MUTATION = ["class", "data-prefix", "data-icon", "data-fa-transform", "data-fa-mask"];
  var DUOTONE_CLASSES = {
    GROUP: "duotone-group",
    SWAP_OPACITY: "swap-opacity",
    PRIMARY: "primary",
    SECONDARY: "secondary"
  };
  var prefixes = /* @__PURE__ */ new Set();
  Object.keys(STYLE_TO_PREFIX[FAMILY_CLASSIC]).map(prefixes.add.bind(prefixes));
  Object.keys(STYLE_TO_PREFIX[FAMILY_SHARP]).map(prefixes.add.bind(prefixes));
  var RESERVED_CLASSES = [].concat(FAMILIES, _toConsumableArray$4(prefixes), ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "fw", "inverse", "layers-counter", "layers-text", "layers", "li", "pull-left", "pull-right", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", DUOTONE_CLASSES.GROUP, DUOTONE_CLASSES.SWAP_OPACITY, DUOTONE_CLASSES.PRIMARY, DUOTONE_CLASSES.SECONDARY]).concat(oneToTen.map(function(n2) {
    return "".concat(n2, "x");
  })).concat(oneToTwenty.map(function(n2) {
    return "w-".concat(n2);
  }));
  var initial = WINDOW.FontAwesomeConfig || {};
  function getAttrConfig(attr) {
    var element2 = DOCUMENT.querySelector("script[" + attr + "]");
    if (element2) {
      return element2.getAttribute(attr);
    }
  }
  function coerce(val) {
    if (val === "")
      return true;
    if (val === "false")
      return false;
    if (val === "true")
      return true;
    return val;
  }
  if (DOCUMENT && typeof DOCUMENT.querySelector === "function") {
    var attrs = [["data-family-prefix", "familyPrefix"], ["data-css-prefix", "cssPrefix"], ["data-family-default", "familyDefault"], ["data-style-default", "styleDefault"], ["data-replacement-class", "replacementClass"], ["data-auto-replace-svg", "autoReplaceSvg"], ["data-auto-add-css", "autoAddCss"], ["data-auto-a11y", "autoA11y"], ["data-search-pseudo-elements", "searchPseudoElements"], ["data-observe-mutations", "observeMutations"], ["data-mutate-approach", "mutateApproach"], ["data-keep-original-source", "keepOriginalSource"], ["data-measure-performance", "measurePerformance"], ["data-show-missing-icons", "showMissingIcons"]];
    attrs.forEach(function(_ref2) {
      var _ref22 = _slicedToArray$a(_ref2, 2), attr = _ref22[0], key = _ref22[1];
      var val = coerce(getAttrConfig(attr));
      if (val !== void 0 && val !== null) {
        initial[key] = val;
      }
    });
  }
  var _default$3 = {
    styleDefault: "solid",
    familyDefault: "classic",
    cssPrefix: DEFAULT_CSS_PREFIX,
    replacementClass: DEFAULT_REPLACEMENT_CLASS,
    autoReplaceSvg: true,
    autoAddCss: true,
    autoA11y: true,
    searchPseudoElements: false,
    observeMutations: true,
    mutateApproach: "async",
    keepOriginalSource: true,
    measurePerformance: false,
    showMissingIcons: true
  };
  if (initial.familyPrefix) {
    initial.cssPrefix = initial.familyPrefix;
  }
  var _config = _objectSpread2$2(_objectSpread2$2({}, _default$3), initial);
  if (!_config.autoReplaceSvg)
    _config.observeMutations = false;
  var config$2 = {};
  Object.keys(_default$3).forEach(function(key) {
    Object.defineProperty(config$2, key, {
      enumerable: true,
      set: function set2(val) {
        _config[key] = val;
        _onChangeCb.forEach(function(cb) {
          return cb(config$2);
        });
      },
      get: function get2() {
        return _config[key];
      }
    });
  });
  Object.defineProperty(config$2, "familyPrefix", {
    enumerable: true,
    set: function set2(val) {
      _config.cssPrefix = val;
      _onChangeCb.forEach(function(cb) {
        return cb(config$2);
      });
    },
    get: function get2() {
      return _config.cssPrefix;
    }
  });
  WINDOW.FontAwesomeConfig = config$2;
  var _onChangeCb = [];
  function onChange(cb) {
    _onChangeCb.push(cb);
    return function() {
      _onChangeCb.splice(_onChangeCb.indexOf(cb), 1);
    };
  }
  var d$3 = UNITS_IN_GRID;
  var meaninglessTransform = {
    size: 16,
    x: 0,
    y: 0,
    rotate: 0,
    flipX: false,
    flipY: false
  };
  function insertCss(css2) {
    if (!css2 || !IS_DOM) {
      return;
    }
    var style2 = DOCUMENT.createElement("style");
    style2.setAttribute("type", "text/css");
    style2.innerHTML = css2;
    var headChildren = DOCUMENT.head.childNodes;
    var beforeChild = null;
    for (var i2 = headChildren.length - 1; i2 > -1; i2--) {
      var child = headChildren[i2];
      var tagName = (child.tagName || "").toUpperCase();
      if (["STYLE", "LINK"].indexOf(tagName) > -1) {
        beforeChild = child;
      }
    }
    DOCUMENT.head.insertBefore(style2, beforeChild);
    return css2;
  }
  var idPool = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
  function nextUniqueId$1() {
    var size2 = 12;
    var id2 = "";
    while (size2-- > 0) {
      id2 += idPool[Math.random() * 62 | 0];
    }
    return id2;
  }
  function toArray$1(obj) {
    var array2 = [];
    for (var i2 = (obj || []).length >>> 0; i2--; ) {
      array2[i2] = obj[i2];
    }
    return array2;
  }
  function classArray$1(node2) {
    if (node2.classList) {
      return toArray$1(node2.classList);
    } else {
      return (node2.getAttribute("class") || "").split(" ").filter(function(i2) {
        return i2;
      });
    }
  }
  function htmlEscape(str) {
    return "".concat(str).replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/'/g, "&#39;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
  }
  function joinAttributes(attributes2) {
    return Object.keys(attributes2 || {}).reduce(function(acc, attributeName) {
      return acc + "".concat(attributeName, '="').concat(htmlEscape(attributes2[attributeName]), '" ');
    }, "").trim();
  }
  function joinStyles(styles2) {
    return Object.keys(styles2 || {}).reduce(function(acc, styleName) {
      return acc + "".concat(styleName, ": ").concat(styles2[styleName].trim(), ";");
    }, "");
  }
  function transformIsMeaningful(transform) {
    return transform.size !== meaninglessTransform.size || transform.x !== meaninglessTransform.x || transform.y !== meaninglessTransform.y || transform.rotate !== meaninglessTransform.rotate || transform.flipX || transform.flipY;
  }
  function transformForSvg(_ref2) {
    var transform = _ref2.transform, containerWidth = _ref2.containerWidth, iconWidth = _ref2.iconWidth;
    var outer = {
      transform: "translate(".concat(containerWidth / 2, " 256)")
    };
    var innerTranslate = "translate(".concat(transform.x * 32, ", ").concat(transform.y * 32, ") ");
    var innerScale = "scale(".concat(transform.size / 16 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / 16 * (transform.flipY ? -1 : 1), ") ");
    var innerRotate = "rotate(".concat(transform.rotate, " 0 0)");
    var inner = {
      transform: "".concat(innerTranslate, " ").concat(innerScale, " ").concat(innerRotate)
    };
    var path2 = {
      transform: "translate(".concat(iconWidth / 2 * -1, " -256)")
    };
    return {
      outer,
      inner,
      path: path2
    };
  }
  function transformForCss(_ref2) {
    var transform = _ref2.transform, _ref2$width = _ref2.width, width = _ref2$width === void 0 ? UNITS_IN_GRID : _ref2$width, _ref2$height = _ref2.height, height = _ref2$height === void 0 ? UNITS_IN_GRID : _ref2$height, _ref2$startCentered = _ref2.startCentered, startCentered = _ref2$startCentered === void 0 ? false : _ref2$startCentered;
    var val = "";
    if (startCentered && IS_IE) {
      val += "translate(".concat(transform.x / d$3 - width / 2, "em, ").concat(transform.y / d$3 - height / 2, "em) ");
    } else if (startCentered) {
      val += "translate(calc(-50% + ".concat(transform.x / d$3, "em), calc(-50% + ").concat(transform.y / d$3, "em)) ");
    } else {
      val += "translate(".concat(transform.x / d$3, "em, ").concat(transform.y / d$3, "em) ");
    }
    val += "scale(".concat(transform.size / d$3 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / d$3 * (transform.flipY ? -1 : 1), ") ");
    val += "rotate(".concat(transform.rotate, "deg) ");
    return val;
  }
  var baseStyles = ':root, :host {\n  --fa-font-solid: normal 900 1em/1 "Font Awesome 6 Solid";\n  --fa-font-regular: normal 400 1em/1 "Font Awesome 6 Regular";\n  --fa-font-light: normal 300 1em/1 "Font Awesome 6 Light";\n  --fa-font-thin: normal 100 1em/1 "Font Awesome 6 Thin";\n  --fa-font-duotone: normal 900 1em/1 "Font Awesome 6 Duotone";\n  --fa-font-sharp-solid: normal 900 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-regular: normal 400 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-sharp-light: normal 300 1em/1 "Font Awesome 6 Sharp";\n  --fa-font-brands: normal 400 1em/1 "Font Awesome 6 Brands";\n}\n\nsvg:not(:root).svg-inline--fa, svg:not(:host).svg-inline--fa {\n  overflow: visible;\n  box-sizing: content-box;\n}\n\n.svg-inline--fa {\n  display: var(--fa-display, inline-block);\n  height: 1em;\n  overflow: visible;\n  vertical-align: -0.125em;\n}\n.svg-inline--fa.fa-2xs {\n  vertical-align: 0.1em;\n}\n.svg-inline--fa.fa-xs {\n  vertical-align: 0em;\n}\n.svg-inline--fa.fa-sm {\n  vertical-align: -0.0714285705em;\n}\n.svg-inline--fa.fa-lg {\n  vertical-align: -0.2em;\n}\n.svg-inline--fa.fa-xl {\n  vertical-align: -0.25em;\n}\n.svg-inline--fa.fa-2xl {\n  vertical-align: -0.3125em;\n}\n.svg-inline--fa.fa-pull-left {\n  margin-right: var(--fa-pull-margin, 0.3em);\n  width: auto;\n}\n.svg-inline--fa.fa-pull-right {\n  margin-left: var(--fa-pull-margin, 0.3em);\n  width: auto;\n}\n.svg-inline--fa.fa-li {\n  width: var(--fa-li-width, 2em);\n  top: 0.25em;\n}\n.svg-inline--fa.fa-fw {\n  width: var(--fa-fw-width, 1.25em);\n}\n\n.fa-layers svg.svg-inline--fa {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.fa-layers-counter, .fa-layers-text {\n  display: inline-block;\n  position: absolute;\n  text-align: center;\n}\n\n.fa-layers {\n  display: inline-block;\n  height: 1em;\n  position: relative;\n  text-align: center;\n  vertical-align: -0.125em;\n  width: 1em;\n}\n.fa-layers svg.svg-inline--fa {\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-text {\n  left: 50%;\n  top: 50%;\n  -webkit-transform: translate(-50%, -50%);\n          transform: translate(-50%, -50%);\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-counter {\n  background-color: var(--fa-counter-background-color, #ff253a);\n  border-radius: var(--fa-counter-border-radius, 1em);\n  box-sizing: border-box;\n  color: var(--fa-inverse, #fff);\n  line-height: var(--fa-counter-line-height, 1);\n  max-width: var(--fa-counter-max-width, 5em);\n  min-width: var(--fa-counter-min-width, 1.5em);\n  overflow: hidden;\n  padding: var(--fa-counter-padding, 0.25em 0.5em);\n  right: var(--fa-right, 0);\n  text-overflow: ellipsis;\n  top: var(--fa-top, 0);\n  -webkit-transform: scale(var(--fa-counter-scale, 0.25));\n          transform: scale(var(--fa-counter-scale, 0.25));\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-bottom-right {\n  bottom: var(--fa-bottom, 0);\n  right: var(--fa-right, 0);\n  top: auto;\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: bottom right;\n          transform-origin: bottom right;\n}\n\n.fa-layers-bottom-left {\n  bottom: var(--fa-bottom, 0);\n  left: var(--fa-left, 0);\n  right: auto;\n  top: auto;\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: bottom left;\n          transform-origin: bottom left;\n}\n\n.fa-layers-top-right {\n  top: var(--fa-top, 0);\n  right: var(--fa-right, 0);\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-top-left {\n  left: var(--fa-left, 0);\n  right: auto;\n  top: var(--fa-top, 0);\n  -webkit-transform: scale(var(--fa-layers-scale, 0.25));\n          transform: scale(var(--fa-layers-scale, 0.25));\n  -webkit-transform-origin: top left;\n          transform-origin: top left;\n}\n\n.fa-1x {\n  font-size: 1em;\n}\n\n.fa-2x {\n  font-size: 2em;\n}\n\n.fa-3x {\n  font-size: 3em;\n}\n\n.fa-4x {\n  font-size: 4em;\n}\n\n.fa-5x {\n  font-size: 5em;\n}\n\n.fa-6x {\n  font-size: 6em;\n}\n\n.fa-7x {\n  font-size: 7em;\n}\n\n.fa-8x {\n  font-size: 8em;\n}\n\n.fa-9x {\n  font-size: 9em;\n}\n\n.fa-10x {\n  font-size: 10em;\n}\n\n.fa-2xs {\n  font-size: 0.625em;\n  line-height: 0.1em;\n  vertical-align: 0.225em;\n}\n\n.fa-xs {\n  font-size: 0.75em;\n  line-height: 0.0833333337em;\n  vertical-align: 0.125em;\n}\n\n.fa-sm {\n  font-size: 0.875em;\n  line-height: 0.0714285718em;\n  vertical-align: 0.0535714295em;\n}\n\n.fa-lg {\n  font-size: 1.25em;\n  line-height: 0.05em;\n  vertical-align: -0.075em;\n}\n\n.fa-xl {\n  font-size: 1.5em;\n  line-height: 0.0416666682em;\n  vertical-align: -0.125em;\n}\n\n.fa-2xl {\n  font-size: 2em;\n  line-height: 0.03125em;\n  vertical-align: -0.1875em;\n}\n\n.fa-fw {\n  text-align: center;\n  width: 1.25em;\n}\n\n.fa-ul {\n  list-style-type: none;\n  margin-left: var(--fa-li-margin, 2.5em);\n  padding-left: 0;\n}\n.fa-ul > li {\n  position: relative;\n}\n\n.fa-li {\n  left: calc(var(--fa-li-width, 2em) * -1);\n  position: absolute;\n  text-align: center;\n  width: var(--fa-li-width, 2em);\n  line-height: inherit;\n}\n\n.fa-border {\n  border-color: var(--fa-border-color, #eee);\n  border-radius: var(--fa-border-radius, 0.1em);\n  border-style: var(--fa-border-style, solid);\n  border-width: var(--fa-border-width, 0.08em);\n  padding: var(--fa-border-padding, 0.2em 0.25em 0.15em);\n}\n\n.fa-pull-left {\n  float: left;\n  margin-right: var(--fa-pull-margin, 0.3em);\n}\n\n.fa-pull-right {\n  float: right;\n  margin-left: var(--fa-pull-margin, 0.3em);\n}\n\n.fa-beat {\n  -webkit-animation-name: fa-beat;\n          animation-name: fa-beat;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, ease-in-out);\n          animation-timing-function: var(--fa-animation-timing, ease-in-out);\n}\n\n.fa-bounce {\n  -webkit-animation-name: fa-bounce;\n          animation-name: fa-bounce;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.28, 0.84, 0.42, 1));\n          animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.28, 0.84, 0.42, 1));\n}\n\n.fa-fade {\n  -webkit-animation-name: fa-fade;\n          animation-name: fa-fade;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n          animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n}\n\n.fa-beat-fade {\n  -webkit-animation-name: fa-beat-fade;\n          animation-name: fa-beat-fade;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n          animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));\n}\n\n.fa-flip {\n  -webkit-animation-name: fa-flip;\n          animation-name: fa-flip;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, ease-in-out);\n          animation-timing-function: var(--fa-animation-timing, ease-in-out);\n}\n\n.fa-shake {\n  -webkit-animation-name: fa-shake;\n          animation-name: fa-shake;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, linear);\n          animation-timing-function: var(--fa-animation-timing, linear);\n}\n\n.fa-spin {\n  -webkit-animation-name: fa-spin;\n          animation-name: fa-spin;\n  -webkit-animation-delay: var(--fa-animation-delay, 0s);\n          animation-delay: var(--fa-animation-delay, 0s);\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 2s);\n          animation-duration: var(--fa-animation-duration, 2s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, linear);\n          animation-timing-function: var(--fa-animation-timing, linear);\n}\n\n.fa-spin-reverse {\n  --fa-animation-direction: reverse;\n}\n\n.fa-pulse,\n.fa-spin-pulse {\n  -webkit-animation-name: fa-spin;\n          animation-name: fa-spin;\n  -webkit-animation-direction: var(--fa-animation-direction, normal);\n          animation-direction: var(--fa-animation-direction, normal);\n  -webkit-animation-duration: var(--fa-animation-duration, 1s);\n          animation-duration: var(--fa-animation-duration, 1s);\n  -webkit-animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n          animation-iteration-count: var(--fa-animation-iteration-count, infinite);\n  -webkit-animation-timing-function: var(--fa-animation-timing, steps(8));\n          animation-timing-function: var(--fa-animation-timing, steps(8));\n}\n\n@media (prefers-reduced-motion: reduce) {\n  .fa-beat,\n.fa-bounce,\n.fa-fade,\n.fa-beat-fade,\n.fa-flip,\n.fa-pulse,\n.fa-shake,\n.fa-spin,\n.fa-spin-pulse {\n    -webkit-animation-delay: -1ms;\n            animation-delay: -1ms;\n    -webkit-animation-duration: 1ms;\n            animation-duration: 1ms;\n    -webkit-animation-iteration-count: 1;\n            animation-iteration-count: 1;\n    -webkit-transition-delay: 0s;\n            transition-delay: 0s;\n    -webkit-transition-duration: 0s;\n            transition-duration: 0s;\n  }\n}\n@-webkit-keyframes fa-beat {\n  0%, 90% {\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  45% {\n    -webkit-transform: scale(var(--fa-beat-scale, 1.25));\n            transform: scale(var(--fa-beat-scale, 1.25));\n  }\n}\n@keyframes fa-beat {\n  0%, 90% {\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  45% {\n    -webkit-transform: scale(var(--fa-beat-scale, 1.25));\n            transform: scale(var(--fa-beat-scale, 1.25));\n  }\n}\n@-webkit-keyframes fa-bounce {\n  0% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  10% {\n    -webkit-transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n            transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n  }\n  30% {\n    -webkit-transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n            transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n  }\n  50% {\n    -webkit-transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n            transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n  }\n  57% {\n    -webkit-transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n            transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n  }\n  64% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  100% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n}\n@keyframes fa-bounce {\n  0% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  10% {\n    -webkit-transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n            transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);\n  }\n  30% {\n    -webkit-transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n            transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));\n  }\n  50% {\n    -webkit-transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n            transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);\n  }\n  57% {\n    -webkit-transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n            transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));\n  }\n  64% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n  100% {\n    -webkit-transform: scale(1, 1) translateY(0);\n            transform: scale(1, 1) translateY(0);\n  }\n}\n@-webkit-keyframes fa-fade {\n  50% {\n    opacity: var(--fa-fade-opacity, 0.4);\n  }\n}\n@keyframes fa-fade {\n  50% {\n    opacity: var(--fa-fade-opacity, 0.4);\n  }\n}\n@-webkit-keyframes fa-beat-fade {\n  0%, 100% {\n    opacity: var(--fa-beat-fade-opacity, 0.4);\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  50% {\n    opacity: 1;\n    -webkit-transform: scale(var(--fa-beat-fade-scale, 1.125));\n            transform: scale(var(--fa-beat-fade-scale, 1.125));\n  }\n}\n@keyframes fa-beat-fade {\n  0%, 100% {\n    opacity: var(--fa-beat-fade-opacity, 0.4);\n    -webkit-transform: scale(1);\n            transform: scale(1);\n  }\n  50% {\n    opacity: 1;\n    -webkit-transform: scale(var(--fa-beat-fade-scale, 1.125));\n            transform: scale(var(--fa-beat-fade-scale, 1.125));\n  }\n}\n@-webkit-keyframes fa-flip {\n  50% {\n    -webkit-transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n            transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n  }\n}\n@keyframes fa-flip {\n  50% {\n    -webkit-transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n            transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));\n  }\n}\n@-webkit-keyframes fa-shake {\n  0% {\n    -webkit-transform: rotate(-15deg);\n            transform: rotate(-15deg);\n  }\n  4% {\n    -webkit-transform: rotate(15deg);\n            transform: rotate(15deg);\n  }\n  8%, 24% {\n    -webkit-transform: rotate(-18deg);\n            transform: rotate(-18deg);\n  }\n  12%, 28% {\n    -webkit-transform: rotate(18deg);\n            transform: rotate(18deg);\n  }\n  16% {\n    -webkit-transform: rotate(-22deg);\n            transform: rotate(-22deg);\n  }\n  20% {\n    -webkit-transform: rotate(22deg);\n            transform: rotate(22deg);\n  }\n  32% {\n    -webkit-transform: rotate(-12deg);\n            transform: rotate(-12deg);\n  }\n  36% {\n    -webkit-transform: rotate(12deg);\n            transform: rotate(12deg);\n  }\n  40%, 100% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n}\n@keyframes fa-shake {\n  0% {\n    -webkit-transform: rotate(-15deg);\n            transform: rotate(-15deg);\n  }\n  4% {\n    -webkit-transform: rotate(15deg);\n            transform: rotate(15deg);\n  }\n  8%, 24% {\n    -webkit-transform: rotate(-18deg);\n            transform: rotate(-18deg);\n  }\n  12%, 28% {\n    -webkit-transform: rotate(18deg);\n            transform: rotate(18deg);\n  }\n  16% {\n    -webkit-transform: rotate(-22deg);\n            transform: rotate(-22deg);\n  }\n  20% {\n    -webkit-transform: rotate(22deg);\n            transform: rotate(22deg);\n  }\n  32% {\n    -webkit-transform: rotate(-12deg);\n            transform: rotate(-12deg);\n  }\n  36% {\n    -webkit-transform: rotate(12deg);\n            transform: rotate(12deg);\n  }\n  40%, 100% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n}\n@-webkit-keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n@keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n.fa-rotate-90 {\n  -webkit-transform: rotate(90deg);\n          transform: rotate(90deg);\n}\n\n.fa-rotate-180 {\n  -webkit-transform: rotate(180deg);\n          transform: rotate(180deg);\n}\n\n.fa-rotate-270 {\n  -webkit-transform: rotate(270deg);\n          transform: rotate(270deg);\n}\n\n.fa-flip-horizontal {\n  -webkit-transform: scale(-1, 1);\n          transform: scale(-1, 1);\n}\n\n.fa-flip-vertical {\n  -webkit-transform: scale(1, -1);\n          transform: scale(1, -1);\n}\n\n.fa-flip-both,\n.fa-flip-horizontal.fa-flip-vertical {\n  -webkit-transform: scale(-1, -1);\n          transform: scale(-1, -1);\n}\n\n.fa-rotate-by {\n  -webkit-transform: rotate(var(--fa-rotate-angle, none));\n          transform: rotate(var(--fa-rotate-angle, none));\n}\n\n.fa-stack {\n  display: inline-block;\n  vertical-align: middle;\n  height: 2em;\n  position: relative;\n  width: 2.5em;\n}\n\n.fa-stack-1x,\n.fa-stack-2x {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n  z-index: var(--fa-stack-z-index, auto);\n}\n\n.svg-inline--fa.fa-stack-1x {\n  height: 1em;\n  width: 1.25em;\n}\n.svg-inline--fa.fa-stack-2x {\n  height: 2em;\n  width: 2.5em;\n}\n\n.fa-inverse {\n  color: var(--fa-inverse, #fff);\n}\n\n.sr-only,\n.fa-sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.sr-only-focusable:not(:focus),\n.fa-sr-only-focusable:not(:focus) {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  padding: 0;\n  margin: -1px;\n  overflow: hidden;\n  clip: rect(0, 0, 0, 0);\n  white-space: nowrap;\n  border-width: 0;\n}\n\n.svg-inline--fa .fa-primary {\n  fill: var(--fa-primary-color, currentColor);\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa .fa-secondary {\n  fill: var(--fa-secondary-color, currentColor);\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-primary {\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-secondary {\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa mask .fa-primary,\n.svg-inline--fa mask .fa-secondary {\n  fill: black;\n}\n\n.fad.fa-inverse,\n.fa-duotone.fa-inverse {\n  color: var(--fa-inverse, #fff);\n}';
  function css() {
    var dcp = DEFAULT_CSS_PREFIX;
    var drc = DEFAULT_REPLACEMENT_CLASS;
    var fp = config$2.cssPrefix;
    var rc = config$2.replacementClass;
    var s2 = baseStyles;
    if (fp !== dcp || rc !== drc) {
      var dPatt = new RegExp("\\.".concat(dcp, "\\-"), "g");
      var customPropPatt = new RegExp("\\--".concat(dcp, "\\-"), "g");
      var rPatt = new RegExp("\\.".concat(drc), "g");
      s2 = s2.replace(dPatt, ".".concat(fp, "-")).replace(customPropPatt, "--".concat(fp, "-")).replace(rPatt, ".".concat(rc));
    }
    return s2;
  }
  var _cssInserted = false;
  function ensureCss() {
    if (config$2.autoAddCss && !_cssInserted) {
      insertCss(css());
      _cssInserted = true;
    }
  }
  var InjectCSS = {
    mixout: function mixout() {
      return {
        dom: {
          css,
          insertCss: ensureCss
        }
      };
    },
    hooks: function hooks() {
      return {
        beforeDOMElementCreation: function beforeDOMElementCreation() {
          ensureCss();
        },
        beforeI2svg: function beforeI2svg() {
          ensureCss();
        }
      };
    }
  };
  var w$3 = WINDOW || {};
  if (!w$3[NAMESPACE_IDENTIFIER])
    w$3[NAMESPACE_IDENTIFIER] = {};
  if (!w$3[NAMESPACE_IDENTIFIER].styles)
    w$3[NAMESPACE_IDENTIFIER].styles = {};
  if (!w$3[NAMESPACE_IDENTIFIER].hooks)
    w$3[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w$3[NAMESPACE_IDENTIFIER].shims)
    w$3[NAMESPACE_IDENTIFIER].shims = [];
  var namespace$1 = w$3[NAMESPACE_IDENTIFIER];
  var functions = [];
  var listener = function listener2() {
    DOCUMENT.removeEventListener("DOMContentLoaded", listener2);
    loaded = 1;
    functions.map(function(fn2) {
      return fn2();
    });
  };
  var loaded = false;
  if (IS_DOM) {
    loaded = (DOCUMENT.documentElement.doScroll ? /^loaded|^c/ : /^loaded|^i|^c/).test(DOCUMENT.readyState);
    if (!loaded)
      DOCUMENT.addEventListener("DOMContentLoaded", listener);
  }
  function domready(fn2) {
    if (!IS_DOM)
      return;
    loaded ? setTimeout(fn2, 0) : functions.push(fn2);
  }
  function toHtml(abstractNodes) {
    var tag = abstractNodes.tag, _abstractNodes$attrib = abstractNodes.attributes, attributes2 = _abstractNodes$attrib === void 0 ? {} : _abstractNodes$attrib, _abstractNodes$childr = abstractNodes.children, children2 = _abstractNodes$childr === void 0 ? [] : _abstractNodes$childr;
    if (typeof abstractNodes === "string") {
      return htmlEscape(abstractNodes);
    } else {
      return "<".concat(tag, " ").concat(joinAttributes(attributes2), ">").concat(children2.map(toHtml).join(""), "</").concat(tag, ">");
    }
  }
  function iconFromMapping(mapping, prefix, iconName) {
    if (mapping && mapping[prefix] && mapping[prefix][iconName]) {
      return {
        prefix,
        iconName,
        icon: mapping[prefix][iconName]
      };
    }
  }
  var bindInternal4 = function bindInternal42(func, thisContext) {
    return function(a2, b2, c2, d2) {
      return func.call(thisContext, a2, b2, c2, d2);
    };
  };
  var reduce$6 = function fastReduceObject(subject, fn2, initialValue, thisContext) {
    var keys2 = Object.keys(subject), length = keys2.length, iterator2 = thisContext !== void 0 ? bindInternal4(fn2, thisContext) : fn2, i2, key, result;
    if (initialValue === void 0) {
      i2 = 1;
      result = subject[keys2[0]];
    } else {
      i2 = 0;
      result = initialValue;
    }
    for (; i2 < length; i2++) {
      key = keys2[i2];
      result = iterator2(result, subject[key], key, subject);
    }
    return result;
  };
  function ucs2decode(string2) {
    var output2 = [];
    var counter2 = 0;
    var length = string2.length;
    while (counter2 < length) {
      var value = string2.charCodeAt(counter2++);
      if (value >= 55296 && value <= 56319 && counter2 < length) {
        var extra = string2.charCodeAt(counter2++);
        if ((extra & 64512) == 56320) {
          output2.push(((value & 1023) << 10) + (extra & 1023) + 65536);
        } else {
          output2.push(value);
          counter2--;
        }
      } else {
        output2.push(value);
      }
    }
    return output2;
  }
  function toHex(unicode2) {
    var decoded = ucs2decode(unicode2);
    return decoded.length === 1 ? decoded[0].toString(16) : null;
  }
  function codePointAt$1(string2, index2) {
    var size2 = string2.length;
    var first = string2.charCodeAt(index2);
    var second;
    if (first >= 55296 && first <= 56319 && size2 > index2 + 1) {
      second = string2.charCodeAt(index2 + 1);
      if (second >= 56320 && second <= 57343) {
        return (first - 55296) * 1024 + second - 56320 + 65536;
      }
    }
    return first;
  }
  function normalizeIcons(icons) {
    return Object.keys(icons).reduce(function(acc, iconName) {
      var icon2 = icons[iconName];
      var expanded = !!icon2.icon;
      if (expanded) {
        acc[icon2.iconName] = icon2.icon;
      } else {
        acc[iconName] = icon2;
      }
      return acc;
    }, {});
  }
  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks, skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = normalizeIcons(icons);
    if (typeof namespace$1.hooks.addPack === "function" && !skipHooks) {
      namespace$1.hooks.addPack(prefix, normalizeIcons(icons));
    } else {
      namespace$1.styles[prefix] = _objectSpread2$2(_objectSpread2$2({}, namespace$1.styles[prefix] || {}), normalized);
    }
    if (prefix === "fas") {
      defineIcons("fa", icons);
    }
  }
  var _LONG_STYLE, _PREFIXES, _PREFIXES_FOR_FAMILY;
  var styles = namespace$1.styles, shims = namespace$1.shims;
  var LONG_STYLE = (_LONG_STYLE = {}, _defineProperty$q(_LONG_STYLE, FAMILY_CLASSIC, Object.values(PREFIX_TO_LONG_STYLE[FAMILY_CLASSIC])), _defineProperty$q(_LONG_STYLE, FAMILY_SHARP, Object.values(PREFIX_TO_LONG_STYLE[FAMILY_SHARP])), _LONG_STYLE);
  var _defaultUsablePrefix = null;
  var _byUnicode = {};
  var _byLigature = {};
  var _byOldName = {};
  var _byOldUnicode = {};
  var _byAlias = {};
  var PREFIXES = (_PREFIXES = {}, _defineProperty$q(_PREFIXES, FAMILY_CLASSIC, Object.keys(PREFIX_TO_STYLE[FAMILY_CLASSIC])), _defineProperty$q(_PREFIXES, FAMILY_SHARP, Object.keys(PREFIX_TO_STYLE[FAMILY_SHARP])), _PREFIXES);
  function isReserved(name2) {
    return ~RESERVED_CLASSES.indexOf(name2);
  }
  function getIconName(cssPrefix, cls) {
    var parts = cls.split("-");
    var prefix = parts[0];
    var iconName = parts.slice(1).join("-");
    if (prefix === cssPrefix && iconName !== "" && !isReserved(iconName)) {
      return iconName;
    } else {
      return null;
    }
  }
  var build$2 = function build2() {
    var lookup2 = function lookup3(reducer2) {
      return reduce$6(styles, function(o2, style2, prefix) {
        o2[prefix] = reduce$6(style2, reducer2, {});
        return o2;
      }, {});
    };
    _byUnicode = lookup2(function(acc, icon2, iconName) {
      if (icon2[3]) {
        acc[icon2[3]] = iconName;
      }
      if (icon2[2]) {
        var aliases = icon2[2].filter(function(a2) {
          return typeof a2 === "number";
        });
        aliases.forEach(function(alias) {
          acc[alias.toString(16)] = iconName;
        });
      }
      return acc;
    });
    _byLigature = lookup2(function(acc, icon2, iconName) {
      acc[iconName] = iconName;
      if (icon2[2]) {
        var aliases = icon2[2].filter(function(a2) {
          return typeof a2 === "string";
        });
        aliases.forEach(function(alias) {
          acc[alias] = iconName;
        });
      }
      return acc;
    });
    _byAlias = lookup2(function(acc, icon2, iconName) {
      var aliases = icon2[2];
      acc[iconName] = iconName;
      aliases.forEach(function(alias) {
        acc[alias] = iconName;
      });
      return acc;
    });
    var hasRegular = "far" in styles || config$2.autoFetchSvg;
    var shimLookups = reduce$6(shims, function(acc, shim) {
      var maybeNameMaybeUnicode = shim[0];
      var prefix = shim[1];
      var iconName = shim[2];
      if (prefix === "far" && !hasRegular) {
        prefix = "fas";
      }
      if (typeof maybeNameMaybeUnicode === "string") {
        acc.names[maybeNameMaybeUnicode] = {
          prefix,
          iconName
        };
      }
      if (typeof maybeNameMaybeUnicode === "number") {
        acc.unicodes[maybeNameMaybeUnicode.toString(16)] = {
          prefix,
          iconName
        };
      }
      return acc;
    }, {
      names: {},
      unicodes: {}
    });
    _byOldName = shimLookups.names;
    _byOldUnicode = shimLookups.unicodes;
    _defaultUsablePrefix = getCanonicalPrefix(config$2.styleDefault, {
      family: config$2.familyDefault
    });
  };
  onChange(function(c2) {
    _defaultUsablePrefix = getCanonicalPrefix(c2.styleDefault, {
      family: config$2.familyDefault
    });
  });
  build$2();
  function byUnicode(prefix, unicode2) {
    return (_byUnicode[prefix] || {})[unicode2];
  }
  function byLigature(prefix, ligature) {
    return (_byLigature[prefix] || {})[ligature];
  }
  function byAlias(prefix, alias) {
    return (_byAlias[prefix] || {})[alias];
  }
  function byOldName(name2) {
    return _byOldName[name2] || {
      prefix: null,
      iconName: null
    };
  }
  function byOldUnicode(unicode2) {
    var oldUnicode = _byOldUnicode[unicode2];
    var newUnicode = byUnicode("fas", unicode2);
    return oldUnicode || (newUnicode ? {
      prefix: "fas",
      iconName: newUnicode
    } : null) || {
      prefix: null,
      iconName: null
    };
  }
  function getDefaultUsablePrefix() {
    return _defaultUsablePrefix;
  }
  var emptyCanonicalIcon = function emptyCanonicalIcon2() {
    return {
      prefix: null,
      iconName: null,
      rest: []
    };
  };
  function getCanonicalPrefix(styleOrPrefix) {
    var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var _params$family = params.family, family = _params$family === void 0 ? FAMILY_CLASSIC : _params$family;
    var style2 = PREFIX_TO_STYLE[family][styleOrPrefix];
    var prefix = STYLE_TO_PREFIX[family][styleOrPrefix] || STYLE_TO_PREFIX[family][style2];
    var defined = styleOrPrefix in namespace$1.styles ? styleOrPrefix : null;
    return prefix || defined || null;
  }
  var PREFIXES_FOR_FAMILY = (_PREFIXES_FOR_FAMILY = {}, _defineProperty$q(_PREFIXES_FOR_FAMILY, FAMILY_CLASSIC, Object.keys(PREFIX_TO_LONG_STYLE[FAMILY_CLASSIC])), _defineProperty$q(_PREFIXES_FOR_FAMILY, FAMILY_SHARP, Object.keys(PREFIX_TO_LONG_STYLE[FAMILY_SHARP])), _PREFIXES_FOR_FAMILY);
  function getCanonicalIcon(values) {
    var _famProps;
    var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var _params$skipLookups = params.skipLookups, skipLookups = _params$skipLookups === void 0 ? false : _params$skipLookups;
    var famProps = (_famProps = {}, _defineProperty$q(_famProps, FAMILY_CLASSIC, "".concat(config$2.cssPrefix, "-").concat(FAMILY_CLASSIC)), _defineProperty$q(_famProps, FAMILY_SHARP, "".concat(config$2.cssPrefix, "-").concat(FAMILY_SHARP)), _famProps);
    var givenPrefix = null;
    var family = FAMILY_CLASSIC;
    if (values.includes(famProps[FAMILY_CLASSIC]) || values.some(function(v3) {
      return PREFIXES_FOR_FAMILY[FAMILY_CLASSIC].includes(v3);
    })) {
      family = FAMILY_CLASSIC;
    }
    if (values.includes(famProps[FAMILY_SHARP]) || values.some(function(v3) {
      return PREFIXES_FOR_FAMILY[FAMILY_SHARP].includes(v3);
    })) {
      family = FAMILY_SHARP;
    }
    var canonical = values.reduce(function(acc, cls) {
      var iconName = getIconName(config$2.cssPrefix, cls);
      if (styles[cls]) {
        cls = LONG_STYLE[family].includes(cls) ? LONG_STYLE_TO_PREFIX[family][cls] : cls;
        givenPrefix = cls;
        acc.prefix = cls;
      } else if (PREFIXES[family].indexOf(cls) > -1) {
        givenPrefix = cls;
        acc.prefix = getCanonicalPrefix(cls, {
          family
        });
      } else if (iconName) {
        acc.iconName = iconName;
      } else if (cls !== config$2.replacementClass && cls !== famProps[FAMILY_CLASSIC] && cls !== famProps[FAMILY_SHARP]) {
        acc.rest.push(cls);
      }
      if (!skipLookups && acc.prefix && acc.iconName) {
        var shim = givenPrefix === "fa" ? byOldName(acc.iconName) : {};
        var aliasIconName = byAlias(acc.prefix, acc.iconName);
        if (shim.prefix) {
          givenPrefix = null;
        }
        acc.iconName = shim.iconName || aliasIconName || acc.iconName;
        acc.prefix = shim.prefix || acc.prefix;
        if (acc.prefix === "far" && !styles["far"] && styles["fas"] && !config$2.autoFetchSvg) {
          acc.prefix = "fas";
        }
      }
      return acc;
    }, emptyCanonicalIcon());
    if (values.includes("fa-brands") || values.includes("fab")) {
      canonical.prefix = "fab";
    }
    if (values.includes("fa-duotone") || values.includes("fad")) {
      canonical.prefix = "fad";
    }
    if (!canonical.prefix && family === FAMILY_SHARP && (styles["fass"] || config$2.autoFetchSvg)) {
      canonical.prefix = "fass";
      canonical.iconName = byAlias(canonical.prefix, canonical.iconName) || canonical.iconName;
    }
    if (canonical.prefix === "fa" || givenPrefix === "fa") {
      canonical.prefix = getDefaultUsablePrefix() || "fas";
    }
    return canonical;
  }
  var Library = /* @__PURE__ */ function() {
    function Library2() {
      _classCallCheck$h(this, Library2);
      this.definitions = {};
    }
    _createClass$h(Library2, [{
      key: "add",
      value: function add2() {
        var _this = this;
        for (var _len = arguments.length, definitions = new Array(_len), _key = 0; _key < _len; _key++) {
          definitions[_key] = arguments[_key];
        }
        var additions = definitions.reduce(this._pullDefinitions, {});
        Object.keys(additions).forEach(function(key) {
          _this.definitions[key] = _objectSpread2$2(_objectSpread2$2({}, _this.definitions[key] || {}), additions[key]);
          defineIcons(key, additions[key]);
          var longPrefix = PREFIX_TO_LONG_STYLE[FAMILY_CLASSIC][key];
          if (longPrefix)
            defineIcons(longPrefix, additions[key]);
          build$2();
        });
      }
    }, {
      key: "reset",
      value: function reset2() {
        this.definitions = {};
      }
    }, {
      key: "_pullDefinitions",
      value: function _pullDefinitions(additions, definition2) {
        var normalized = definition2.prefix && definition2.iconName && definition2.icon ? {
          0: definition2
        } : definition2;
        Object.keys(normalized).map(function(key) {
          var _normalized$key = normalized[key], prefix = _normalized$key.prefix, iconName = _normalized$key.iconName, icon2 = _normalized$key.icon;
          var aliases = icon2[2];
          if (!additions[prefix])
            additions[prefix] = {};
          if (aliases.length > 0) {
            aliases.forEach(function(alias) {
              if (typeof alias === "string") {
                additions[prefix][alias] = icon2;
              }
            });
          }
          additions[prefix][iconName] = icon2;
        });
        return additions;
      }
    }]);
    return Library2;
  }();
  var _plugins = [];
  var _hooks = {};
  var providers = {};
  var defaultProviderKeys = Object.keys(providers);
  function registerPlugins(nextPlugins, _ref2) {
    var obj = _ref2.mixoutsTo;
    _plugins = nextPlugins;
    _hooks = {};
    Object.keys(providers).forEach(function(k2) {
      if (defaultProviderKeys.indexOf(k2) === -1) {
        delete providers[k2];
      }
    });
    _plugins.forEach(function(plugin) {
      var mixout = plugin.mixout ? plugin.mixout() : {};
      Object.keys(mixout).forEach(function(tk) {
        if (typeof mixout[tk] === "function") {
          obj[tk] = mixout[tk];
        }
        if (_typeof$7(mixout[tk]) === "object") {
          Object.keys(mixout[tk]).forEach(function(sk) {
            if (!obj[tk]) {
              obj[tk] = {};
            }
            obj[tk][sk] = mixout[tk][sk];
          });
        }
      });
      if (plugin.hooks) {
        var hooks = plugin.hooks();
        Object.keys(hooks).forEach(function(hook) {
          if (!_hooks[hook]) {
            _hooks[hook] = [];
          }
          _hooks[hook].push(hooks[hook]);
        });
      }
      if (plugin.provides) {
        plugin.provides(providers);
      }
    });
    return obj;
  }
  function chainHooks(hook, accumulator) {
    for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      args[_key - 2] = arguments[_key];
    }
    var hookFns = _hooks[hook] || [];
    hookFns.forEach(function(hookFn) {
      accumulator = hookFn.apply(null, [accumulator].concat(args));
    });
    return accumulator;
  }
  function callHooks(hook) {
    for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
      args[_key2 - 1] = arguments[_key2];
    }
    var hookFns = _hooks[hook] || [];
    hookFns.forEach(function(hookFn) {
      hookFn.apply(null, args);
    });
    return void 0;
  }
  function callProvided() {
    var hook = arguments[0];
    var args = Array.prototype.slice.call(arguments, 1);
    return providers[hook] ? providers[hook].apply(null, args) : void 0;
  }
  function findIconDefinition(iconLookup) {
    if (iconLookup.prefix === "fa") {
      iconLookup.prefix = "fas";
    }
    var iconName = iconLookup.iconName;
    var prefix = iconLookup.prefix || getDefaultUsablePrefix();
    if (!iconName)
      return;
    iconName = byAlias(prefix, iconName) || iconName;
    return iconFromMapping(library.definitions, prefix, iconName) || iconFromMapping(namespace$1.styles, prefix, iconName);
  }
  var library = new Library();
  var noAuto = function noAuto2() {
    config$2.autoReplaceSvg = false;
    config$2.observeMutations = false;
    callHooks("noAuto");
  };
  var dom = {
    i2svg: function i2svg() {
      var params = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
      if (IS_DOM) {
        callHooks("beforeI2svg", params);
        callProvided("pseudoElements2svg", params);
        return callProvided("i2svg", params);
      } else {
        return Promise.reject("Operation requires a DOM of some kind.");
      }
    },
    watch: function watch() {
      var params = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
      var autoReplaceSvgRoot = params.autoReplaceSvgRoot;
      if (config$2.autoReplaceSvg === false) {
        config$2.autoReplaceSvg = true;
      }
      config$2.observeMutations = true;
      domready(function() {
        autoReplace({
          autoReplaceSvgRoot
        });
        callHooks("watch", params);
      });
    }
  };
  var parse$a = {
    icon: function icon2(_icon) {
      if (_icon === null) {
        return null;
      }
      if (_typeof$7(_icon) === "object" && _icon.prefix && _icon.iconName) {
        return {
          prefix: _icon.prefix,
          iconName: byAlias(_icon.prefix, _icon.iconName) || _icon.iconName
        };
      }
      if (Array.isArray(_icon) && _icon.length === 2) {
        var iconName = _icon[1].indexOf("fa-") === 0 ? _icon[1].slice(3) : _icon[1];
        var prefix = getCanonicalPrefix(_icon[0]);
        return {
          prefix,
          iconName: byAlias(prefix, iconName) || iconName
        };
      }
      if (typeof _icon === "string" && (_icon.indexOf("".concat(config$2.cssPrefix, "-")) > -1 || _icon.match(ICON_SELECTION_SYNTAX_PATTERN))) {
        var canonicalIcon = getCanonicalIcon(_icon.split(" "), {
          skipLookups: true
        });
        return {
          prefix: canonicalIcon.prefix || getDefaultUsablePrefix(),
          iconName: byAlias(canonicalIcon.prefix, canonicalIcon.iconName) || canonicalIcon.iconName
        };
      }
      if (typeof _icon === "string") {
        var _prefix = getDefaultUsablePrefix();
        return {
          prefix: _prefix,
          iconName: byAlias(_prefix, _icon) || _icon
        };
      }
    }
  };
  var api$1 = {
    noAuto,
    config: config$2,
    dom,
    parse: parse$a,
    library,
    findIconDefinition,
    toHtml
  };
  var autoReplace = function autoReplace2() {
    var params = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var _params$autoReplaceSv = params.autoReplaceSvgRoot, autoReplaceSvgRoot = _params$autoReplaceSv === void 0 ? DOCUMENT : _params$autoReplaceSv;
    if ((Object.keys(namespace$1.styles).length > 0 || config$2.autoFetchSvg) && IS_DOM && config$2.autoReplaceSvg)
      api$1.dom.i2svg({
        node: autoReplaceSvgRoot
      });
  };
  function domVariants(val, abstractCreator) {
    Object.defineProperty(val, "abstract", {
      get: abstractCreator
    });
    Object.defineProperty(val, "html", {
      get: function get2() {
        return val.abstract.map(function(a2) {
          return toHtml(a2);
        });
      }
    });
    Object.defineProperty(val, "node", {
      get: function get2() {
        if (!IS_DOM)
          return;
        var container = DOCUMENT.createElement("div");
        container.innerHTML = val.html;
        return container.children;
      }
    });
    return val;
  }
  function asIcon(_ref2) {
    var children2 = _ref2.children, main2 = _ref2.main, mask = _ref2.mask, attributes2 = _ref2.attributes, styles2 = _ref2.styles, transform = _ref2.transform;
    if (transformIsMeaningful(transform) && main2.found && !mask.found) {
      var width = main2.width, height = main2.height;
      var offset2 = {
        x: width / height / 2,
        y: 0.5
      };
      attributes2["style"] = joinStyles(_objectSpread2$2(_objectSpread2$2({}, styles2), {}, {
        "transform-origin": "".concat(offset2.x + transform.x / 16, "em ").concat(offset2.y + transform.y / 16, "em")
      }));
    }
    return [{
      tag: "svg",
      attributes: attributes2,
      children: children2
    }];
  }
  function asSymbol(_ref2) {
    var prefix = _ref2.prefix, iconName = _ref2.iconName, children2 = _ref2.children, attributes2 = _ref2.attributes, symbol = _ref2.symbol;
    var id2 = symbol === true ? "".concat(prefix, "-").concat(config$2.cssPrefix, "-").concat(iconName) : symbol;
    return [{
      tag: "svg",
      attributes: {
        style: "display: none;"
      },
      children: [{
        tag: "symbol",
        attributes: _objectSpread2$2(_objectSpread2$2({}, attributes2), {}, {
          id: id2
        }),
        children: children2
      }]
    }];
  }
  function makeInlineSvgAbstract(params) {
    var _params$icons = params.icons, main2 = _params$icons.main, mask = _params$icons.mask, prefix = params.prefix, iconName = params.iconName, transform = params.transform, symbol = params.symbol, title = params.title, maskId = params.maskId, titleId = params.titleId, extra = params.extra, _params$watchable = params.watchable, watchable = _params$watchable === void 0 ? false : _params$watchable;
    var _ref2 = mask.found ? mask : main2, width = _ref2.width, height = _ref2.height;
    var isUploadedIcon = prefix === "fak";
    var attrClass = [config$2.replacementClass, iconName ? "".concat(config$2.cssPrefix, "-").concat(iconName) : ""].filter(function(c2) {
      return extra.classes.indexOf(c2) === -1;
    }).filter(function(c2) {
      return c2 !== "" || !!c2;
    }).concat(extra.classes).join(" ");
    var content2 = {
      children: [],
      attributes: _objectSpread2$2(_objectSpread2$2({}, extra.attributes), {}, {
        "data-prefix": prefix,
        "data-icon": iconName,
        "class": attrClass,
        "role": extra.attributes.role || "img",
        "xmlns": "http://www.w3.org/2000/svg",
        "viewBox": "0 0 ".concat(width, " ").concat(height)
      })
    };
    var uploadedIconWidthStyle = isUploadedIcon && !~extra.classes.indexOf("fa-fw") ? {
      width: "".concat(width / height * 16 * 0.0625, "em")
    } : {};
    if (watchable) {
      content2.attributes[DATA_FA_I2SVG] = "";
    }
    if (title) {
      content2.children.push({
        tag: "title",
        attributes: {
          id: content2.attributes["aria-labelledby"] || "title-".concat(titleId || nextUniqueId$1())
        },
        children: [title]
      });
      delete content2.attributes.title;
    }
    var args = _objectSpread2$2(_objectSpread2$2({}, content2), {}, {
      prefix,
      iconName,
      main: main2,
      mask,
      maskId,
      transform,
      symbol,
      styles: _objectSpread2$2(_objectSpread2$2({}, uploadedIconWidthStyle), extra.styles)
    });
    var _ref22 = mask.found && main2.found ? callProvided("generateAbstractMask", args) || {
      children: [],
      attributes: {}
    } : callProvided("generateAbstractIcon", args) || {
      children: [],
      attributes: {}
    }, children2 = _ref22.children, attributes2 = _ref22.attributes;
    args.children = children2;
    args.attributes = attributes2;
    if (symbol) {
      return asSymbol(args);
    } else {
      return asIcon(args);
    }
  }
  function makeLayersTextAbstract(params) {
    var content2 = params.content, width = params.width, height = params.height, transform = params.transform, title = params.title, extra = params.extra, _params$watchable2 = params.watchable, watchable = _params$watchable2 === void 0 ? false : _params$watchable2;
    var attributes2 = _objectSpread2$2(_objectSpread2$2(_objectSpread2$2({}, extra.attributes), title ? {
      "title": title
    } : {}), {}, {
      "class": extra.classes.join(" ")
    });
    if (watchable) {
      attributes2[DATA_FA_I2SVG] = "";
    }
    var styles2 = _objectSpread2$2({}, extra.styles);
    if (transformIsMeaningful(transform)) {
      styles2["transform"] = transformForCss({
        transform,
        startCentered: true,
        width,
        height
      });
      styles2["-webkit-transform"] = styles2["transform"];
    }
    var styleString = joinStyles(styles2);
    if (styleString.length > 0) {
      attributes2["style"] = styleString;
    }
    var val = [];
    val.push({
      tag: "span",
      attributes: attributes2,
      children: [content2]
    });
    if (title) {
      val.push({
        tag: "span",
        attributes: {
          class: "sr-only"
        },
        children: [title]
      });
    }
    return val;
  }
  function makeLayersCounterAbstract(params) {
    var content2 = params.content, title = params.title, extra = params.extra;
    var attributes2 = _objectSpread2$2(_objectSpread2$2(_objectSpread2$2({}, extra.attributes), title ? {
      "title": title
    } : {}), {}, {
      "class": extra.classes.join(" ")
    });
    var styleString = joinStyles(extra.styles);
    if (styleString.length > 0) {
      attributes2["style"] = styleString;
    }
    var val = [];
    val.push({
      tag: "span",
      attributes: attributes2,
      children: [content2]
    });
    if (title) {
      val.push({
        tag: "span",
        attributes: {
          class: "sr-only"
        },
        children: [title]
      });
    }
    return val;
  }
  var styles$1 = namespace$1.styles;
  function asFoundIcon(icon2) {
    var width = icon2[0];
    var height = icon2[1];
    var _icon$slice = icon2.slice(4), _icon$slice2 = _slicedToArray$a(_icon$slice, 1), vectorData = _icon$slice2[0];
    var element2 = null;
    if (Array.isArray(vectorData)) {
      element2 = {
        tag: "g",
        attributes: {
          class: "".concat(config$2.cssPrefix, "-").concat(DUOTONE_CLASSES.GROUP)
        },
        children: [{
          tag: "path",
          attributes: {
            class: "".concat(config$2.cssPrefix, "-").concat(DUOTONE_CLASSES.SECONDARY),
            fill: "currentColor",
            d: vectorData[0]
          }
        }, {
          tag: "path",
          attributes: {
            class: "".concat(config$2.cssPrefix, "-").concat(DUOTONE_CLASSES.PRIMARY),
            fill: "currentColor",
            d: vectorData[1]
          }
        }]
      };
    } else {
      element2 = {
        tag: "path",
        attributes: {
          fill: "currentColor",
          d: vectorData
        }
      };
    }
    return {
      found: true,
      width,
      height,
      icon: element2
    };
  }
  var missingIconResolutionMixin = {
    found: false,
    width: 512,
    height: 512
  };
  function maybeNotifyMissing(iconName, prefix) {
    if (!PRODUCTION$1 && !config$2.showMissingIcons && iconName) {
      console.error('Icon with name "'.concat(iconName, '" and prefix "').concat(prefix, '" is missing.'));
    }
  }
  function findIcon(iconName, prefix) {
    var givenPrefix = prefix;
    if (prefix === "fa" && config$2.styleDefault !== null) {
      prefix = getDefaultUsablePrefix();
    }
    return new Promise(function(resolve2, reject) {
      ({
        found: false,
        width: 512,
        height: 512,
        icon: callProvided("missingIconAbstract") || {}
      });
      if (givenPrefix === "fa") {
        var shim = byOldName(iconName) || {};
        iconName = shim.iconName || iconName;
        prefix = shim.prefix || prefix;
      }
      if (iconName && prefix && styles$1[prefix] && styles$1[prefix][iconName]) {
        var icon2 = styles$1[prefix][iconName];
        return resolve2(asFoundIcon(icon2));
      }
      maybeNotifyMissing(iconName, prefix);
      resolve2(_objectSpread2$2(_objectSpread2$2({}, missingIconResolutionMixin), {}, {
        icon: config$2.showMissingIcons && iconName ? callProvided("missingIconAbstract") || {} : {}
      }));
    });
  }
  var noop$1$1 = function noop2() {
  };
  var p$3 = config$2.measurePerformance && PERFORMANCE && PERFORMANCE.mark && PERFORMANCE.measure ? PERFORMANCE : {
    mark: noop$1$1,
    measure: noop$1$1
  };
  var preamble = 'FA "6.4.2"';
  var begin = function begin2(name2) {
    p$3.mark("".concat(preamble, " ").concat(name2, " begins"));
    return function() {
      return end$1(name2);
    };
  };
  var end$1 = function end2(name2) {
    p$3.mark("".concat(preamble, " ").concat(name2, " ends"));
    p$3.measure("".concat(preamble, " ").concat(name2), "".concat(preamble, " ").concat(name2, " begins"), "".concat(preamble, " ").concat(name2, " ends"));
  };
  var perf = {
    begin,
    end: end$1
  };
  var noop$2$1 = function noop2() {
  };
  function isWatched(node2) {
    var i2svg = node2.getAttribute ? node2.getAttribute(DATA_FA_I2SVG) : null;
    return typeof i2svg === "string";
  }
  function hasPrefixAndIcon(node2) {
    var prefix = node2.getAttribute ? node2.getAttribute(DATA_PREFIX) : null;
    var icon2 = node2.getAttribute ? node2.getAttribute(DATA_ICON) : null;
    return prefix && icon2;
  }
  function hasBeenReplaced(node2) {
    return node2 && node2.classList && node2.classList.contains && node2.classList.contains(config$2.replacementClass);
  }
  function getMutator() {
    if (config$2.autoReplaceSvg === true) {
      return mutators.replace;
    }
    var mutator = mutators[config$2.autoReplaceSvg];
    return mutator || mutators.replace;
  }
  function createElementNS(tag) {
    return DOCUMENT.createElementNS("http://www.w3.org/2000/svg", tag);
  }
  function createElement(tag) {
    return DOCUMENT.createElement(tag);
  }
  function convertSVG(abstractObj) {
    var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var _params$ceFn = params.ceFn, ceFn = _params$ceFn === void 0 ? abstractObj.tag === "svg" ? createElementNS : createElement : _params$ceFn;
    if (typeof abstractObj === "string") {
      return DOCUMENT.createTextNode(abstractObj);
    }
    var tag = ceFn(abstractObj.tag);
    Object.keys(abstractObj.attributes || []).forEach(function(key) {
      tag.setAttribute(key, abstractObj.attributes[key]);
    });
    var children2 = abstractObj.children || [];
    children2.forEach(function(child) {
      tag.appendChild(convertSVG(child, {
        ceFn
      }));
    });
    return tag;
  }
  function nodeAsComment(node2) {
    var comment2 = " ".concat(node2.outerHTML, " ");
    comment2 = "".concat(comment2, "Font Awesome fontawesome.com ");
    return comment2;
  }
  var mutators = {
    replace: function replace2(mutation) {
      var node2 = mutation[0];
      if (node2.parentNode) {
        mutation[1].forEach(function(_abstract) {
          node2.parentNode.insertBefore(convertSVG(_abstract), node2);
        });
        if (node2.getAttribute(DATA_FA_I2SVG) === null && config$2.keepOriginalSource) {
          var comment2 = DOCUMENT.createComment(nodeAsComment(node2));
          node2.parentNode.replaceChild(comment2, node2);
        } else {
          node2.remove();
        }
      }
    },
    nest: function nest(mutation) {
      var node2 = mutation[0];
      var _abstract2 = mutation[1];
      if (~classArray$1(node2).indexOf(config$2.replacementClass)) {
        return mutators.replace(mutation);
      }
      var forSvg = new RegExp("".concat(config$2.cssPrefix, "-.*"));
      delete _abstract2[0].attributes.id;
      if (_abstract2[0].attributes.class) {
        var splitClasses = _abstract2[0].attributes.class.split(" ").reduce(function(acc, cls) {
          if (cls === config$2.replacementClass || cls.match(forSvg)) {
            acc.toSvg.push(cls);
          } else {
            acc.toNode.push(cls);
          }
          return acc;
        }, {
          toNode: [],
          toSvg: []
        });
        _abstract2[0].attributes.class = splitClasses.toSvg.join(" ");
        if (splitClasses.toNode.length === 0) {
          node2.removeAttribute("class");
        } else {
          node2.setAttribute("class", splitClasses.toNode.join(" "));
        }
      }
      var newInnerHTML = _abstract2.map(function(a2) {
        return toHtml(a2);
      }).join("\n");
      node2.setAttribute(DATA_FA_I2SVG, "");
      node2.innerHTML = newInnerHTML;
    }
  };
  function performOperationSync(op) {
    op();
  }
  function perform(mutations, callback) {
    var callbackFunction = typeof callback === "function" ? callback : noop$2$1;
    if (mutations.length === 0) {
      callbackFunction();
    } else {
      var frame2 = performOperationSync;
      if (config$2.mutateApproach === MUTATION_APPROACH_ASYNC) {
        frame2 = WINDOW.requestAnimationFrame || performOperationSync;
      }
      frame2(function() {
        var mutator = getMutator();
        var mark2 = perf.begin("mutate");
        mutations.map(mutator);
        mark2();
        callbackFunction();
      });
    }
  }
  var disabled = false;
  function disableObservation() {
    disabled = true;
  }
  function enableObservation() {
    disabled = false;
  }
  var mo$1 = null;
  function observe(options) {
    if (!MUTATION_OBSERVER) {
      return;
    }
    if (!config$2.observeMutations) {
      return;
    }
    var _options$treeCallback = options.treeCallback, treeCallback = _options$treeCallback === void 0 ? noop$2$1 : _options$treeCallback, _options$nodeCallback = options.nodeCallback, nodeCallback = _options$nodeCallback === void 0 ? noop$2$1 : _options$nodeCallback, _options$pseudoElemen = options.pseudoElementsCallback, pseudoElementsCallback = _options$pseudoElemen === void 0 ? noop$2$1 : _options$pseudoElemen, _options$observeMutat = options.observeMutationsRoot, observeMutationsRoot = _options$observeMutat === void 0 ? DOCUMENT : _options$observeMutat;
    mo$1 = new MUTATION_OBSERVER(function(objects) {
      if (disabled)
        return;
      var defaultPrefix = getDefaultUsablePrefix();
      toArray$1(objects).forEach(function(mutationRecord) {
        if (mutationRecord.type === "childList" && mutationRecord.addedNodes.length > 0 && !isWatched(mutationRecord.addedNodes[0])) {
          if (config$2.searchPseudoElements) {
            pseudoElementsCallback(mutationRecord.target);
          }
          treeCallback(mutationRecord.target);
        }
        if (mutationRecord.type === "attributes" && mutationRecord.target.parentNode && config$2.searchPseudoElements) {
          pseudoElementsCallback(mutationRecord.target.parentNode);
        }
        if (mutationRecord.type === "attributes" && isWatched(mutationRecord.target) && ~ATTRIBUTES_WATCHED_FOR_MUTATION.indexOf(mutationRecord.attributeName)) {
          if (mutationRecord.attributeName === "class" && hasPrefixAndIcon(mutationRecord.target)) {
            var _getCanonicalIcon = getCanonicalIcon(classArray$1(mutationRecord.target)), prefix = _getCanonicalIcon.prefix, iconName = _getCanonicalIcon.iconName;
            mutationRecord.target.setAttribute(DATA_PREFIX, prefix || defaultPrefix);
            if (iconName)
              mutationRecord.target.setAttribute(DATA_ICON, iconName);
          } else if (hasBeenReplaced(mutationRecord.target)) {
            nodeCallback(mutationRecord.target);
          }
        }
      });
    });
    if (!IS_DOM)
      return;
    mo$1.observe(observeMutationsRoot, {
      childList: true,
      attributes: true,
      characterData: true,
      subtree: true
    });
  }
  function disconnect() {
    if (!mo$1)
      return;
    mo$1.disconnect();
  }
  function styleParser(node2) {
    var style2 = node2.getAttribute("style");
    var val = [];
    if (style2) {
      val = style2.split(";").reduce(function(acc, style3) {
        var styles2 = style3.split(":");
        var prop = styles2[0];
        var value = styles2.slice(1);
        if (prop && value.length > 0) {
          acc[prop] = value.join(":").trim();
        }
        return acc;
      }, {});
    }
    return val;
  }
  function classParser(node2) {
    var existingPrefix = node2.getAttribute("data-prefix");
    var existingIconName = node2.getAttribute("data-icon");
    var innerText = node2.innerText !== void 0 ? node2.innerText.trim() : "";
    var val = getCanonicalIcon(classArray$1(node2));
    if (!val.prefix) {
      val.prefix = getDefaultUsablePrefix();
    }
    if (existingPrefix && existingIconName) {
      val.prefix = existingPrefix;
      val.iconName = existingIconName;
    }
    if (val.iconName && val.prefix) {
      return val;
    }
    if (val.prefix && innerText.length > 0) {
      val.iconName = byLigature(val.prefix, node2.innerText) || byUnicode(val.prefix, toHex(node2.innerText));
    }
    if (!val.iconName && config$2.autoFetchSvg && node2.firstChild && node2.firstChild.nodeType === Node.TEXT_NODE) {
      val.iconName = node2.firstChild.data;
    }
    return val;
  }
  function attributesParser(node2) {
    var extraAttributes = toArray$1(node2.attributes).reduce(function(acc, attr) {
      if (acc.name !== "class" && acc.name !== "style") {
        acc[attr.name] = attr.value;
      }
      return acc;
    }, {});
    var title = node2.getAttribute("title");
    var titleId = node2.getAttribute("data-fa-title-id");
    if (config$2.autoA11y) {
      if (title) {
        extraAttributes["aria-labelledby"] = "".concat(config$2.replacementClass, "-title-").concat(titleId || nextUniqueId$1());
      } else {
        extraAttributes["aria-hidden"] = "true";
        extraAttributes["focusable"] = "false";
      }
    }
    return extraAttributes;
  }
  function blankMeta() {
    return {
      iconName: null,
      title: null,
      titleId: null,
      prefix: null,
      transform: meaninglessTransform,
      symbol: false,
      mask: {
        iconName: null,
        prefix: null,
        rest: []
      },
      maskId: null,
      extra: {
        classes: [],
        styles: {},
        attributes: {}
      }
    };
  }
  function parseMeta(node2) {
    var parser2 = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {
      styleParser: true
    };
    var _classParser = classParser(node2), iconName = _classParser.iconName, prefix = _classParser.prefix, extraClasses = _classParser.rest;
    var extraAttributes = attributesParser(node2);
    var pluginMeta = chainHooks("parseNodeAttributes", {}, node2);
    var extraStyles = parser2.styleParser ? styleParser(node2) : [];
    return _objectSpread2$2({
      iconName,
      title: node2.getAttribute("title"),
      titleId: node2.getAttribute("data-fa-title-id"),
      prefix,
      transform: meaninglessTransform,
      mask: {
        iconName: null,
        prefix: null,
        rest: []
      },
      maskId: null,
      symbol: false,
      extra: {
        classes: extraClasses,
        styles: extraStyles,
        attributes: extraAttributes
      }
    }, pluginMeta);
  }
  var styles$2 = namespace$1.styles;
  function generateMutation(node2) {
    var nodeMeta = config$2.autoReplaceSvg === "nest" ? parseMeta(node2, {
      styleParser: false
    }) : parseMeta(node2);
    if (~nodeMeta.extra.classes.indexOf(LAYERS_TEXT_CLASSNAME)) {
      return callProvided("generateLayersText", node2, nodeMeta);
    } else {
      return callProvided("generateSvgReplacementMutation", node2, nodeMeta);
    }
  }
  var knownPrefixes = /* @__PURE__ */ new Set();
  FAMILIES.map(function(family) {
    knownPrefixes.add("fa-".concat(family));
  });
  Object.keys(PREFIX_TO_STYLE[FAMILY_CLASSIC]).map(knownPrefixes.add.bind(knownPrefixes));
  Object.keys(PREFIX_TO_STYLE[FAMILY_SHARP]).map(knownPrefixes.add.bind(knownPrefixes));
  knownPrefixes = _toConsumableArray$4(knownPrefixes);
  function onTree(root2) {
    var callback = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
    if (!IS_DOM)
      return Promise.resolve();
    var htmlClassList = DOCUMENT.documentElement.classList;
    var hclAdd = function hclAdd2(suffix) {
      return htmlClassList.add("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
    };
    var hclRemove = function hclRemove2(suffix) {
      return htmlClassList.remove("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
    };
    var prefixes2 = config$2.autoFetchSvg ? knownPrefixes : FAMILIES.map(function(f2) {
      return "fa-".concat(f2);
    }).concat(Object.keys(styles$2));
    if (!prefixes2.includes("fa")) {
      prefixes2.push("fa");
    }
    var prefixesDomQuery = [".".concat(LAYERS_TEXT_CLASSNAME, ":not([").concat(DATA_FA_I2SVG, "])")].concat(prefixes2.map(function(p2) {
      return ".".concat(p2, ":not([").concat(DATA_FA_I2SVG, "])");
    })).join(", ");
    if (prefixesDomQuery.length === 0) {
      return Promise.resolve();
    }
    var candidates = [];
    try {
      candidates = toArray$1(root2.querySelectorAll(prefixesDomQuery));
    } catch (e3) {
    }
    if (candidates.length > 0) {
      hclAdd("pending");
      hclRemove("complete");
    } else {
      return Promise.resolve();
    }
    var mark2 = perf.begin("onTree");
    var mutations = candidates.reduce(function(acc, node2) {
      try {
        var mutation = generateMutation(node2);
        if (mutation) {
          acc.push(mutation);
        }
      } catch (e3) {
        if (!PRODUCTION$1) {
          if (e3.name === "MissingIcon") {
            console.error(e3);
          }
        }
      }
      return acc;
    }, []);
    return new Promise(function(resolve2, reject) {
      Promise.all(mutations).then(function(resolvedMutations) {
        perform(resolvedMutations, function() {
          hclAdd("active");
          hclAdd("complete");
          hclRemove("pending");
          if (typeof callback === "function")
            callback();
          mark2();
          resolve2();
        });
      }).catch(function(e3) {
        mark2();
        reject(e3);
      });
    });
  }
  function onNode(node2) {
    var callback = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : null;
    generateMutation(node2).then(function(mutation) {
      if (mutation) {
        perform([mutation], callback);
      }
    });
  }
  function resolveIcons(next2) {
    return function(maybeIconDefinition) {
      var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
      var iconDefinition = (maybeIconDefinition || {}).icon ? maybeIconDefinition : findIconDefinition(maybeIconDefinition || {});
      var mask = params.mask;
      if (mask) {
        mask = (mask || {}).icon ? mask : findIconDefinition(mask || {});
      }
      return next2(iconDefinition, _objectSpread2$2(_objectSpread2$2({}, params), {}, {
        mask
      }));
    };
  }
  var render$1 = function render2(iconDefinition) {
    var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var _params$transform = params.transform, transform = _params$transform === void 0 ? meaninglessTransform : _params$transform, _params$symbol = params.symbol, symbol = _params$symbol === void 0 ? false : _params$symbol, _params$mask = params.mask, mask = _params$mask === void 0 ? null : _params$mask, _params$maskId = params.maskId, maskId = _params$maskId === void 0 ? null : _params$maskId, _params$title = params.title, title = _params$title === void 0 ? null : _params$title, _params$titleId = params.titleId, titleId = _params$titleId === void 0 ? null : _params$titleId, _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes, _params$attributes = params.attributes, attributes2 = _params$attributes === void 0 ? {} : _params$attributes, _params$styles = params.styles, styles2 = _params$styles === void 0 ? {} : _params$styles;
    if (!iconDefinition)
      return;
    var prefix = iconDefinition.prefix, iconName = iconDefinition.iconName, icon2 = iconDefinition.icon;
    return domVariants(_objectSpread2$2({
      type: "icon"
    }, iconDefinition), function() {
      callHooks("beforeDOMElementCreation", {
        iconDefinition,
        params
      });
      if (config$2.autoA11y) {
        if (title) {
          attributes2["aria-labelledby"] = "".concat(config$2.replacementClass, "-title-").concat(titleId || nextUniqueId$1());
        } else {
          attributes2["aria-hidden"] = "true";
          attributes2["focusable"] = "false";
        }
      }
      return makeInlineSvgAbstract({
        icons: {
          main: asFoundIcon(icon2),
          mask: mask ? asFoundIcon(mask.icon) : {
            found: false,
            width: null,
            height: null,
            icon: {}
          }
        },
        prefix,
        iconName,
        transform: _objectSpread2$2(_objectSpread2$2({}, meaninglessTransform), transform),
        symbol,
        title,
        maskId,
        titleId,
        extra: {
          attributes: attributes2,
          styles: styles2,
          classes
        }
      });
    });
  };
  var ReplaceElements = {
    mixout: function mixout() {
      return {
        icon: resolveIcons(render$1)
      };
    },
    hooks: function hooks() {
      return {
        mutationObserverCallbacks: function mutationObserverCallbacks(accumulator) {
          accumulator.treeCallback = onTree;
          accumulator.nodeCallback = onNode;
          return accumulator;
        }
      };
    },
    provides: function provides(providers$$1) {
      providers$$1.i2svg = function(params) {
        var _params$node = params.node, node2 = _params$node === void 0 ? DOCUMENT : _params$node, _params$callback = params.callback, callback = _params$callback === void 0 ? function() {
        } : _params$callback;
        return onTree(node2, callback);
      };
      providers$$1.generateSvgReplacementMutation = function(node2, nodeMeta) {
        var iconName = nodeMeta.iconName, title = nodeMeta.title, titleId = nodeMeta.titleId, prefix = nodeMeta.prefix, transform = nodeMeta.transform, symbol = nodeMeta.symbol, mask = nodeMeta.mask, maskId = nodeMeta.maskId, extra = nodeMeta.extra;
        return new Promise(function(resolve2, reject) {
          Promise.all([findIcon(iconName, prefix), mask.iconName ? findIcon(mask.iconName, mask.prefix) : Promise.resolve({
            found: false,
            width: 512,
            height: 512,
            icon: {}
          })]).then(function(_ref2) {
            var _ref22 = _slicedToArray$a(_ref2, 2), main2 = _ref22[0], mask2 = _ref22[1];
            resolve2([node2, makeInlineSvgAbstract({
              icons: {
                main: main2,
                mask: mask2
              },
              prefix,
              iconName,
              transform,
              symbol,
              maskId,
              title,
              titleId,
              extra,
              watchable: true
            })]);
          }).catch(reject);
        });
      };
      providers$$1.generateAbstractIcon = function(_ref3) {
        var children2 = _ref3.children, attributes2 = _ref3.attributes, main2 = _ref3.main, transform = _ref3.transform, styles2 = _ref3.styles;
        var styleString = joinStyles(styles2);
        if (styleString.length > 0) {
          attributes2["style"] = styleString;
        }
        var nextChild;
        if (transformIsMeaningful(transform)) {
          nextChild = callProvided("generateAbstractTransformGrouping", {
            main: main2,
            transform,
            containerWidth: main2.width,
            iconWidth: main2.width
          });
        }
        children2.push(nextChild || main2.icon);
        return {
          children: children2,
          attributes: attributes2
        };
      };
    }
  };
  var Layers = {
    mixout: function mixout() {
      return {
        layer: function layer(assembler) {
          var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          var _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes;
          return domVariants({
            type: "layer"
          }, function() {
            callHooks("beforeDOMElementCreation", {
              assembler,
              params
            });
            var children2 = [];
            assembler(function(args) {
              Array.isArray(args) ? args.map(function(a2) {
                children2 = children2.concat(a2.abstract);
              }) : children2 = children2.concat(args.abstract);
            });
            return [{
              tag: "span",
              attributes: {
                class: ["".concat(config$2.cssPrefix, "-layers")].concat(_toConsumableArray$4(classes)).join(" ")
              },
              children: children2
            }];
          });
        }
      };
    }
  };
  var LayersCounter = {
    mixout: function mixout() {
      return {
        counter: function counter2(content2) {
          var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          var _params$title = params.title, title = _params$title === void 0 ? null : _params$title, _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes, _params$attributes = params.attributes, attributes2 = _params$attributes === void 0 ? {} : _params$attributes, _params$styles = params.styles, styles2 = _params$styles === void 0 ? {} : _params$styles;
          return domVariants({
            type: "counter",
            content: content2
          }, function() {
            callHooks("beforeDOMElementCreation", {
              content: content2,
              params
            });
            return makeLayersCounterAbstract({
              content: content2.toString(),
              title,
              extra: {
                attributes: attributes2,
                styles: styles2,
                classes: ["".concat(config$2.cssPrefix, "-layers-counter")].concat(_toConsumableArray$4(classes))
              }
            });
          });
        }
      };
    }
  };
  var LayersText = {
    mixout: function mixout() {
      return {
        text: function text2(content2) {
          var params = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
          var _params$transform = params.transform, transform = _params$transform === void 0 ? meaninglessTransform : _params$transform, _params$title = params.title, title = _params$title === void 0 ? null : _params$title, _params$classes = params.classes, classes = _params$classes === void 0 ? [] : _params$classes, _params$attributes = params.attributes, attributes2 = _params$attributes === void 0 ? {} : _params$attributes, _params$styles = params.styles, styles2 = _params$styles === void 0 ? {} : _params$styles;
          return domVariants({
            type: "text",
            content: content2
          }, function() {
            callHooks("beforeDOMElementCreation", {
              content: content2,
              params
            });
            return makeLayersTextAbstract({
              content: content2,
              transform: _objectSpread2$2(_objectSpread2$2({}, meaninglessTransform), transform),
              title,
              extra: {
                attributes: attributes2,
                styles: styles2,
                classes: ["".concat(config$2.cssPrefix, "-layers-text")].concat(_toConsumableArray$4(classes))
              }
            });
          });
        }
      };
    },
    provides: function provides(providers$$1) {
      providers$$1.generateLayersText = function(node2, nodeMeta) {
        var title = nodeMeta.title, transform = nodeMeta.transform, extra = nodeMeta.extra;
        var width = null;
        var height = null;
        if (IS_IE) {
          var computedFontSize = parseInt(getComputedStyle(node2).fontSize, 10);
          var boundingClientRect = node2.getBoundingClientRect();
          width = boundingClientRect.width / computedFontSize;
          height = boundingClientRect.height / computedFontSize;
        }
        if (config$2.autoA11y && !title) {
          extra.attributes["aria-hidden"] = "true";
        }
        return Promise.resolve([node2, makeLayersTextAbstract({
          content: node2.innerHTML,
          width,
          height,
          transform,
          title,
          extra,
          watchable: true
        })]);
      };
    }
  };
  var CLEAN_CONTENT_PATTERN = new RegExp('"', "ug");
  var SECONDARY_UNICODE_RANGE = [1105920, 1112319];
  function hexValueFromContent(content2) {
    var cleaned = content2.replace(CLEAN_CONTENT_PATTERN, "");
    var codePoint = codePointAt$1(cleaned, 0);
    var isPrependTen = codePoint >= SECONDARY_UNICODE_RANGE[0] && codePoint <= SECONDARY_UNICODE_RANGE[1];
    var isDoubled = cleaned.length === 2 ? cleaned[0] === cleaned[1] : false;
    return {
      value: isDoubled ? toHex(cleaned[0]) : toHex(cleaned),
      isSecondary: isPrependTen || isDoubled
    };
  }
  function replaceForPosition(node2, position2) {
    var pendingAttribute = "".concat(DATA_FA_PSEUDO_ELEMENT_PENDING).concat(position2.replace(":", "-"));
    return new Promise(function(resolve2, reject) {
      if (node2.getAttribute(pendingAttribute) !== null) {
        return resolve2();
      }
      var children2 = toArray$1(node2.children);
      var alreadyProcessedPseudoElement = children2.filter(function(c2) {
        return c2.getAttribute(DATA_FA_PSEUDO_ELEMENT) === position2;
      })[0];
      var styles2 = WINDOW.getComputedStyle(node2, position2);
      var fontFamily = styles2.getPropertyValue("font-family").match(FONT_FAMILY_PATTERN);
      var fontWeight = styles2.getPropertyValue("font-weight");
      var content2 = styles2.getPropertyValue("content");
      if (alreadyProcessedPseudoElement && !fontFamily) {
        node2.removeChild(alreadyProcessedPseudoElement);
        return resolve2();
      } else if (fontFamily && content2 !== "none" && content2 !== "") {
        var _content = styles2.getPropertyValue("content");
        var family = ~["Sharp"].indexOf(fontFamily[2]) ? FAMILY_SHARP : FAMILY_CLASSIC;
        var prefix = ~["Solid", "Regular", "Light", "Thin", "Duotone", "Brands", "Kit"].indexOf(fontFamily[2]) ? STYLE_TO_PREFIX[family][fontFamily[2].toLowerCase()] : FONT_WEIGHT_TO_PREFIX[family][fontWeight];
        var _hexValueFromContent = hexValueFromContent(_content), hexValue = _hexValueFromContent.value, isSecondary = _hexValueFromContent.isSecondary;
        var isV4 = fontFamily[0].startsWith("FontAwesome");
        var iconName = byUnicode(prefix, hexValue);
        var iconIdentifier = iconName;
        if (isV4) {
          var iconName4 = byOldUnicode(hexValue);
          if (iconName4.iconName && iconName4.prefix) {
            iconName = iconName4.iconName;
            prefix = iconName4.prefix;
          }
        }
        if (iconName && !isSecondary && (!alreadyProcessedPseudoElement || alreadyProcessedPseudoElement.getAttribute(DATA_PREFIX) !== prefix || alreadyProcessedPseudoElement.getAttribute(DATA_ICON) !== iconIdentifier)) {
          node2.setAttribute(pendingAttribute, iconIdentifier);
          if (alreadyProcessedPseudoElement) {
            node2.removeChild(alreadyProcessedPseudoElement);
          }
          var meta2 = blankMeta();
          var extra = meta2.extra;
          extra.attributes[DATA_FA_PSEUDO_ELEMENT] = position2;
          findIcon(iconName, prefix).then(function(main2) {
            var _abstract = makeInlineSvgAbstract(_objectSpread2$2(_objectSpread2$2({}, meta2), {}, {
              icons: {
                main: main2,
                mask: emptyCanonicalIcon()
              },
              prefix,
              iconName: iconIdentifier,
              extra,
              watchable: true
            }));
            var element2 = DOCUMENT.createElementNS("http://www.w3.org/2000/svg", "svg");
            if (position2 === "::before") {
              node2.insertBefore(element2, node2.firstChild);
            } else {
              node2.appendChild(element2);
            }
            element2.outerHTML = _abstract.map(function(a2) {
              return toHtml(a2);
            }).join("\n");
            node2.removeAttribute(pendingAttribute);
            resolve2();
          }).catch(reject);
        } else {
          resolve2();
        }
      } else {
        resolve2();
      }
    });
  }
  function replace$2(node2) {
    return Promise.all([replaceForPosition(node2, "::before"), replaceForPosition(node2, "::after")]);
  }
  function processable(node2) {
    return node2.parentNode !== document.head && !~TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS.indexOf(node2.tagName.toUpperCase()) && !node2.getAttribute(DATA_FA_PSEUDO_ELEMENT) && (!node2.parentNode || node2.parentNode.tagName !== "svg");
  }
  function searchPseudoElements(root2) {
    if (!IS_DOM)
      return;
    return new Promise(function(resolve2, reject) {
      var operations = toArray$1(root2.querySelectorAll("*")).filter(processable).map(replace$2);
      var end2 = perf.begin("searchPseudoElements");
      disableObservation();
      Promise.all(operations).then(function() {
        end2();
        enableObservation();
        resolve2();
      }).catch(function() {
        end2();
        enableObservation();
        reject();
      });
    });
  }
  var PseudoElements = {
    hooks: function hooks() {
      return {
        mutationObserverCallbacks: function mutationObserverCallbacks(accumulator) {
          accumulator.pseudoElementsCallback = searchPseudoElements;
          return accumulator;
        }
      };
    },
    provides: function provides(providers$$1) {
      providers$$1.pseudoElements2svg = function(params) {
        var _params$node = params.node, node2 = _params$node === void 0 ? DOCUMENT : _params$node;
        if (config$2.searchPseudoElements) {
          searchPseudoElements(node2);
        }
      };
    }
  };
  var _unwatched = false;
  var MutationObserver$1 = {
    mixout: function mixout() {
      return {
        dom: {
          unwatch: function unwatch() {
            disableObservation();
            _unwatched = true;
          }
        }
      };
    },
    hooks: function hooks() {
      return {
        bootstrap: function bootstrap() {
          observe(chainHooks("mutationObserverCallbacks", {}));
        },
        noAuto: function noAuto2() {
          disconnect();
        },
        watch: function watch(params) {
          var observeMutationsRoot = params.observeMutationsRoot;
          if (_unwatched) {
            enableObservation();
          } else {
            observe(chainHooks("mutationObserverCallbacks", {
              observeMutationsRoot
            }));
          }
        }
      };
    }
  };
  var parseTransformString = function parseTransformString2(transformString) {
    var transform = {
      size: 16,
      x: 0,
      y: 0,
      flipX: false,
      flipY: false,
      rotate: 0
    };
    return transformString.toLowerCase().split(" ").reduce(function(acc, n2) {
      var parts = n2.toLowerCase().split("-");
      var first = parts[0];
      var rest = parts.slice(1).join("-");
      if (first && rest === "h") {
        acc.flipX = true;
        return acc;
      }
      if (first && rest === "v") {
        acc.flipY = true;
        return acc;
      }
      rest = parseFloat(rest);
      if (isNaN(rest)) {
        return acc;
      }
      switch (first) {
        case "grow":
          acc.size = acc.size + rest;
          break;
        case "shrink":
          acc.size = acc.size - rest;
          break;
        case "left":
          acc.x = acc.x - rest;
          break;
        case "right":
          acc.x = acc.x + rest;
          break;
        case "up":
          acc.y = acc.y - rest;
          break;
        case "down":
          acc.y = acc.y + rest;
          break;
        case "rotate":
          acc.rotate = acc.rotate + rest;
          break;
      }
      return acc;
    }, transform);
  };
  var PowerTransforms = {
    mixout: function mixout() {
      return {
        parse: {
          transform: function transform(transformString) {
            return parseTransformString(transformString);
          }
        }
      };
    },
    hooks: function hooks() {
      return {
        parseNodeAttributes: function parseNodeAttributes(accumulator, node2) {
          var transformString = node2.getAttribute("data-fa-transform");
          if (transformString) {
            accumulator.transform = parseTransformString(transformString);
          }
          return accumulator;
        }
      };
    },
    provides: function provides(providers2) {
      providers2.generateAbstractTransformGrouping = function(_ref2) {
        var main2 = _ref2.main, transform = _ref2.transform, containerWidth = _ref2.containerWidth, iconWidth = _ref2.iconWidth;
        var outer = {
          transform: "translate(".concat(containerWidth / 2, " 256)")
        };
        var innerTranslate = "translate(".concat(transform.x * 32, ", ").concat(transform.y * 32, ") ");
        var innerScale = "scale(".concat(transform.size / 16 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / 16 * (transform.flipY ? -1 : 1), ") ");
        var innerRotate = "rotate(".concat(transform.rotate, " 0 0)");
        var inner = {
          transform: "".concat(innerTranslate, " ").concat(innerScale, " ").concat(innerRotate)
        };
        var path2 = {
          transform: "translate(".concat(iconWidth / 2 * -1, " -256)")
        };
        var operations = {
          outer,
          inner,
          path: path2
        };
        return {
          tag: "g",
          attributes: _objectSpread2$2({}, operations.outer),
          children: [{
            tag: "g",
            attributes: _objectSpread2$2({}, operations.inner),
            children: [{
              tag: main2.icon.tag,
              children: main2.icon.children,
              attributes: _objectSpread2$2(_objectSpread2$2({}, main2.icon.attributes), operations.path)
            }]
          }]
        };
      };
    }
  };
  var ALL_SPACE = {
    x: 0,
    y: 0,
    width: "100%",
    height: "100%"
  };
  function fillBlack(_abstract) {
    var force = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : true;
    if (_abstract.attributes && (_abstract.attributes.fill || force)) {
      _abstract.attributes.fill = "black";
    }
    return _abstract;
  }
  function deGroup(_abstract2) {
    if (_abstract2.tag === "g") {
      return _abstract2.children;
    } else {
      return [_abstract2];
    }
  }
  var Masks = {
    hooks: function hooks() {
      return {
        parseNodeAttributes: function parseNodeAttributes(accumulator, node2) {
          var maskData = node2.getAttribute("data-fa-mask");
          var mask = !maskData ? emptyCanonicalIcon() : getCanonicalIcon(maskData.split(" ").map(function(i2) {
            return i2.trim();
          }));
          if (!mask.prefix) {
            mask.prefix = getDefaultUsablePrefix();
          }
          accumulator.mask = mask;
          accumulator.maskId = node2.getAttribute("data-fa-mask-id");
          return accumulator;
        }
      };
    },
    provides: function provides(providers2) {
      providers2.generateAbstractMask = function(_ref2) {
        var children2 = _ref2.children, attributes2 = _ref2.attributes, main2 = _ref2.main, mask = _ref2.mask, explicitMaskId = _ref2.maskId, transform = _ref2.transform;
        var mainWidth = main2.width, mainPath = main2.icon;
        var maskWidth = mask.width, maskPath = mask.icon;
        var trans = transformForSvg({
          transform,
          containerWidth: maskWidth,
          iconWidth: mainWidth
        });
        var maskRect = {
          tag: "rect",
          attributes: _objectSpread2$2(_objectSpread2$2({}, ALL_SPACE), {}, {
            fill: "white"
          })
        };
        var maskInnerGroupChildrenMixin = mainPath.children ? {
          children: mainPath.children.map(fillBlack)
        } : {};
        var maskInnerGroup = {
          tag: "g",
          attributes: _objectSpread2$2({}, trans.inner),
          children: [fillBlack(_objectSpread2$2({
            tag: mainPath.tag,
            attributes: _objectSpread2$2(_objectSpread2$2({}, mainPath.attributes), trans.path)
          }, maskInnerGroupChildrenMixin))]
        };
        var maskOuterGroup = {
          tag: "g",
          attributes: _objectSpread2$2({}, trans.outer),
          children: [maskInnerGroup]
        };
        var maskId = "mask-".concat(explicitMaskId || nextUniqueId$1());
        var clipId = "clip-".concat(explicitMaskId || nextUniqueId$1());
        var maskTag = {
          tag: "mask",
          attributes: _objectSpread2$2(_objectSpread2$2({}, ALL_SPACE), {}, {
            id: maskId,
            maskUnits: "userSpaceOnUse",
            maskContentUnits: "userSpaceOnUse"
          }),
          children: [maskRect, maskOuterGroup]
        };
        var defs2 = {
          tag: "defs",
          children: [{
            tag: "clipPath",
            attributes: {
              id: clipId
            },
            children: deGroup(maskPath)
          }, maskTag]
        };
        children2.push(defs2, {
          tag: "rect",
          attributes: _objectSpread2$2({
            fill: "currentColor",
            "clip-path": "url(#".concat(clipId, ")"),
            mask: "url(#".concat(maskId, ")")
          }, ALL_SPACE)
        });
        return {
          children: children2,
          attributes: attributes2
        };
      };
    }
  };
  var MissingIconIndicator = {
    provides: function provides(providers2) {
      var reduceMotion = false;
      if (WINDOW.matchMedia) {
        reduceMotion = WINDOW.matchMedia("(prefers-reduced-motion: reduce)").matches;
      }
      providers2.missingIconAbstract = function() {
        var gChildren = [];
        var FILL = {
          fill: "currentColor"
        };
        var ANIMATION_BASE = {
          attributeType: "XML",
          repeatCount: "indefinite",
          dur: "2s"
        };
        gChildren.push({
          tag: "path",
          attributes: _objectSpread2$2(_objectSpread2$2({}, FILL), {}, {
            d: "M156.5,447.7l-12.6,29.5c-18.7-9.5-35.9-21.2-51.5-34.9l22.7-22.7C127.6,430.5,141.5,440,156.5,447.7z M40.6,272H8.5 c1.4,21.2,5.4,41.7,11.7,61.1L50,321.2C45.1,305.5,41.8,289,40.6,272z M40.6,240c1.4-18.8,5.2-37,11.1-54.1l-29.5-12.6 C14.7,194.3,10,216.7,8.5,240H40.6z M64.3,156.5c7.8-14.9,17.2-28.8,28.1-41.5L69.7,92.3c-13.7,15.6-25.5,32.8-34.9,51.5 L64.3,156.5z M397,419.6c-13.9,12-29.4,22.3-46.1,30.4l11.9,29.8c20.7-9.9,39.8-22.6,56.9-37.6L397,419.6z M115,92.4 c13.9-12,29.4-22.3,46.1-30.4l-11.9-29.8c-20.7,9.9-39.8,22.6-56.8,37.6L115,92.4z M447.7,355.5c-7.8,14.9-17.2,28.8-28.1,41.5 l22.7,22.7c13.7-15.6,25.5-32.9,34.9-51.5L447.7,355.5z M471.4,272c-1.4,18.8-5.2,37-11.1,54.1l29.5,12.6 c7.5-21.1,12.2-43.5,13.6-66.8H471.4z M321.2,462c-15.7,5-32.2,8.2-49.2,9.4v32.1c21.2-1.4,41.7-5.4,61.1-11.7L321.2,462z M240,471.4c-18.8-1.4-37-5.2-54.1-11.1l-12.6,29.5c21.1,7.5,43.5,12.2,66.8,13.6V471.4z M462,190.8c5,15.7,8.2,32.2,9.4,49.2h32.1 c-1.4-21.2-5.4-41.7-11.7-61.1L462,190.8z M92.4,397c-12-13.9-22.3-29.4-30.4-46.1l-29.8,11.9c9.9,20.7,22.6,39.8,37.6,56.9 L92.4,397z M272,40.6c18.8,1.4,36.9,5.2,54.1,11.1l12.6-29.5C317.7,14.7,295.3,10,272,8.5V40.6z M190.8,50 c15.7-5,32.2-8.2,49.2-9.4V8.5c-21.2,1.4-41.7,5.4-61.1,11.7L190.8,50z M442.3,92.3L419.6,115c12,13.9,22.3,29.4,30.5,46.1 l29.8-11.9C470,128.5,457.3,109.4,442.3,92.3z M397,92.4l22.7-22.7c-15.6-13.7-32.8-25.5-51.5-34.9l-12.6,29.5 C370.4,72.1,384.4,81.5,397,92.4z"
          })
        });
        var OPACITY_ANIMATE = _objectSpread2$2(_objectSpread2$2({}, ANIMATION_BASE), {}, {
          attributeName: "opacity"
        });
        var dot2 = {
          tag: "circle",
          attributes: _objectSpread2$2(_objectSpread2$2({}, FILL), {}, {
            cx: "256",
            cy: "364",
            r: "28"
          }),
          children: []
        };
        if (!reduceMotion) {
          dot2.children.push({
            tag: "animate",
            attributes: _objectSpread2$2(_objectSpread2$2({}, ANIMATION_BASE), {}, {
              attributeName: "r",
              values: "28;14;28;28;14;28;"
            })
          }, {
            tag: "animate",
            attributes: _objectSpread2$2(_objectSpread2$2({}, OPACITY_ANIMATE), {}, {
              values: "1;0;1;1;0;1;"
            })
          });
        }
        gChildren.push(dot2);
        gChildren.push({
          tag: "path",
          attributes: _objectSpread2$2(_objectSpread2$2({}, FILL), {}, {
            opacity: "1",
            d: "M263.7,312h-16c-6.6,0-12-5.4-12-12c0-71,77.4-63.9,77.4-107.8c0-20-17.8-40.2-57.4-40.2c-29.1,0-44.3,9.6-59.2,28.7 c-3.9,5-11.1,6-16.2,2.4l-13.1-9.2c-5.6-3.9-6.9-11.8-2.6-17.2c21.2-27.2,46.4-44.7,91.2-44.7c52.3,0,97.4,29.8,97.4,80.2 c0,67.6-77.4,63.5-77.4,107.8C275.7,306.6,270.3,312,263.7,312z"
          }),
          children: reduceMotion ? [] : [{
            tag: "animate",
            attributes: _objectSpread2$2(_objectSpread2$2({}, OPACITY_ANIMATE), {}, {
              values: "1;0;0;0;0;1;"
            })
          }]
        });
        if (!reduceMotion) {
          gChildren.push({
            tag: "path",
            attributes: _objectSpread2$2(_objectSpread2$2({}, FILL), {}, {
              opacity: "0",
              d: "M232.5,134.5l7,168c0.3,6.4,5.6,11.5,12,11.5h9c6.4,0,11.7-5.1,12-11.5l7-168c0.3-6.8-5.2-12.5-12-12.5h-23 C237.7,122,232.2,127.7,232.5,134.5z"
            }),
            children: [{
              tag: "animate",
              attributes: _objectSpread2$2(_objectSpread2$2({}, OPACITY_ANIMATE), {}, {
                values: "0;0;1;1;0;0;"
              })
            }]
          });
        }
        return {
          tag: "g",
          attributes: {
            "class": "missing"
          },
          children: gChildren
        };
      };
    }
  };
  var SvgSymbols = {
    hooks: function hooks() {
      return {
        parseNodeAttributes: function parseNodeAttributes(accumulator, node2) {
          var symbolData = node2.getAttribute("data-fa-symbol");
          var symbol = symbolData === null ? false : symbolData === "" ? true : symbolData;
          accumulator["symbol"] = symbol;
          return accumulator;
        }
      };
    }
  };
  var plugins$1 = [InjectCSS, ReplaceElements, Layers, LayersCounter, LayersText, PseudoElements, MutationObserver$1, PowerTransforms, Masks, MissingIconIndicator, SvgSymbols];
  registerPlugins(plugins$1, {
    mixoutsTo: api$1
  });
  api$1.noAuto;
  api$1.config;
  api$1.library;
  api$1.dom;
  var parse$1$1 = api$1.parse;
  api$1.findIconDefinition;
  api$1.toHtml;
  var icon = api$1.icon;
  api$1.layer;
  api$1.text;
  api$1.counter;
  var propTypes = { exports: {} };
  var ReactPropTypesSecret$1 = "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";
  var ReactPropTypesSecret_1 = ReactPropTypesSecret$1;
  var ReactPropTypesSecret = ReactPropTypesSecret_1;
  function emptyFunction() {
  }
  function emptyFunctionWithReset() {
  }
  emptyFunctionWithReset.resetWarningCache = emptyFunction;
  var factoryWithThrowingShims = function() {
    function shim(props, propName, componentName, location2, propFullName, secret) {
      if (secret === ReactPropTypesSecret) {
        return;
      }
      var err = new Error(
        "Calling PropTypes validators directly is not supported by the `prop-types` package. Use PropTypes.checkPropTypes() to call them. Read more at http://fb.me/use-check-prop-types"
      );
      err.name = "Invariant Violation";
      throw err;
    }
    shim.isRequired = shim;
    function getShim() {
      return shim;
    }
    var ReactPropTypes = {
      array: shim,
      bigint: shim,
      bool: shim,
      func: shim,
      number: shim,
      object: shim,
      string: shim,
      symbol: shim,
      any: shim,
      arrayOf: getShim,
      element: shim,
      elementType: shim,
      instanceOf: getShim,
      node: shim,
      objectOf: getShim,
      oneOf: getShim,
      oneOfType: getShim,
      shape: getShim,
      exact: getShim,
      checkPropTypes: emptyFunctionWithReset,
      resetWarningCache: emptyFunction
    };
    ReactPropTypes.PropTypes = ReactPropTypes;
    return ReactPropTypes;
  };
  {
    propTypes.exports = factoryWithThrowingShims();
  }
  function ownKeys$7(object2, enumerableOnly) {
    var keys2 = Object.keys(object2);
    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object2);
      enumerableOnly && (symbols = symbols.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object2, sym).enumerable;
      })), keys2.push.apply(keys2, symbols);
    }
    return keys2;
  }
  function _objectSpread2$1(target) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      var source = null != arguments[i2] ? arguments[i2] : {};
      i2 % 2 ? ownKeys$7(Object(source), true).forEach(function(key) {
        _defineProperty$p(target, key, source[key]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys$7(Object(source)).forEach(function(key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
    return target;
  }
  function _typeof$6(obj) {
    "@babel/helpers - typeof";
    return _typeof$6 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
      return typeof obj2;
    } : function(obj2) {
      return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    }, _typeof$6(obj);
  }
  function _defineProperty$p(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  function _objectWithoutPropertiesLoose$5(source, excluded) {
    if (source == null)
      return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i2;
    for (i2 = 0; i2 < sourceKeys.length; i2++) {
      key = sourceKeys[i2];
      if (excluded.indexOf(key) >= 0)
        continue;
      target[key] = source[key];
    }
    return target;
  }
  function _objectWithoutProperties$2(source, excluded) {
    if (source == null)
      return {};
    var target = _objectWithoutPropertiesLoose$5(source, excluded);
    var key, i2;
    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
      for (i2 = 0; i2 < sourceSymbolKeys.length; i2++) {
        key = sourceSymbolKeys[i2];
        if (excluded.indexOf(key) >= 0)
          continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key))
          continue;
        target[key] = source[key];
      }
    }
    return target;
  }
  function _toConsumableArray$3(arr) {
    return _arrayWithoutHoles$3(arr) || _iterableToArray$3(arr) || _unsupportedIterableToArray$a(arr) || _nonIterableSpread$3();
  }
  function _arrayWithoutHoles$3(arr) {
    if (Array.isArray(arr))
      return _arrayLikeToArray$a(arr);
  }
  function _iterableToArray$3(iter2) {
    if (typeof Symbol !== "undefined" && iter2[Symbol.iterator] != null || iter2["@@iterator"] != null)
      return Array.from(iter2);
  }
  function _unsupportedIterableToArray$a(o2, minLen) {
    if (!o2)
      return;
    if (typeof o2 === "string")
      return _arrayLikeToArray$a(o2, minLen);
    var n2 = Object.prototype.toString.call(o2).slice(8, -1);
    if (n2 === "Object" && o2.constructor)
      n2 = o2.constructor.name;
    if (n2 === "Map" || n2 === "Set")
      return Array.from(o2);
    if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
      return _arrayLikeToArray$a(o2, minLen);
  }
  function _arrayLikeToArray$a(arr, len) {
    if (len == null || len > arr.length)
      len = arr.length;
    for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
      arr2[i2] = arr[i2];
    return arr2;
  }
  function _nonIterableSpread$3() {
    throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function classList$1(props) {
    var _classes;
    var beat = props.beat, fade = props.fade, beatFade = props.beatFade, bounce = props.bounce, shake = props.shake, flash = props.flash, spin = props.spin, spinPulse = props.spinPulse, spinReverse = props.spinReverse, pulse = props.pulse, fixedWidth = props.fixedWidth, inverse = props.inverse, border = props.border, listItem2 = props.listItem, flip2 = props.flip, size2 = props.size, rotation2 = props.rotation, pull = props.pull;
    var classes = (_classes = {
      "fa-beat": beat,
      "fa-fade": fade,
      "fa-beat-fade": beatFade,
      "fa-bounce": bounce,
      "fa-shake": shake,
      "fa-flash": flash,
      "fa-spin": spin,
      "fa-spin-reverse": spinReverse,
      "fa-spin-pulse": spinPulse,
      "fa-pulse": pulse,
      "fa-fw": fixedWidth,
      "fa-inverse": inverse,
      "fa-border": border,
      "fa-li": listItem2,
      "fa-flip": flip2 === true,
      "fa-flip-horizontal": flip2 === "horizontal" || flip2 === "both",
      "fa-flip-vertical": flip2 === "vertical" || flip2 === "both"
    }, _defineProperty$p(_classes, "fa-".concat(size2), typeof size2 !== "undefined" && size2 !== null), _defineProperty$p(_classes, "fa-rotate-".concat(rotation2), typeof rotation2 !== "undefined" && rotation2 !== null && rotation2 !== 0), _defineProperty$p(_classes, "fa-pull-".concat(pull), typeof pull !== "undefined" && pull !== null), _defineProperty$p(_classes, "fa-swap-opacity", props.swapOpacity), _classes);
    return Object.keys(classes).map(function(key) {
      return classes[key] ? key : null;
    }).filter(function(key) {
      return key;
    });
  }
  function _isNumerical(obj) {
    obj = obj - 0;
    return obj === obj;
  }
  function camelize(string2) {
    if (_isNumerical(string2)) {
      return string2;
    }
    string2 = string2.replace(/[\-_\s]+(.)?/g, function(match2, chr) {
      return chr ? chr.toUpperCase() : "";
    });
    return string2.substr(0, 1).toLowerCase() + string2.substr(1);
  }
  var _excluded$5 = ["style"];
  function capitalize$1(val) {
    return val.charAt(0).toUpperCase() + val.slice(1);
  }
  function styleToObject$1(style2) {
    return style2.split(";").map(function(s2) {
      return s2.trim();
    }).filter(function(s2) {
      return s2;
    }).reduce(function(acc, pair2) {
      var i2 = pair2.indexOf(":");
      var prop = camelize(pair2.slice(0, i2));
      var value = pair2.slice(i2 + 1).trim();
      prop.startsWith("webkit") ? acc[capitalize$1(prop)] = value : acc[prop] = value;
      return acc;
    }, {});
  }
  function convert$2(createElement2, element2) {
    var extraProps = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    if (typeof element2 === "string") {
      return element2;
    }
    var children2 = (element2.children || []).map(function(child) {
      return convert$2(createElement2, child);
    });
    var mixins = Object.keys(element2.attributes || {}).reduce(function(acc, key) {
      var val = element2.attributes[key];
      switch (key) {
        case "class":
          acc.attrs["className"] = val;
          delete element2.attributes["class"];
          break;
        case "style":
          acc.attrs["style"] = styleToObject$1(val);
          break;
        default:
          if (key.indexOf("aria-") === 0 || key.indexOf("data-") === 0) {
            acc.attrs[key.toLowerCase()] = val;
          } else {
            acc.attrs[camelize(key)] = val;
          }
      }
      return acc;
    }, {
      attrs: {}
    });
    var _extraProps$style = extraProps.style, existingStyle = _extraProps$style === void 0 ? {} : _extraProps$style, remaining = _objectWithoutProperties$2(extraProps, _excluded$5);
    mixins.attrs["style"] = _objectSpread2$1(_objectSpread2$1({}, mixins.attrs["style"]), existingStyle);
    return createElement2.apply(void 0, [element2.tag, _objectSpread2$1(_objectSpread2$1({}, mixins.attrs), remaining)].concat(_toConsumableArray$3(children2)));
  }
  var PRODUCTION = false;
  try {
    PRODUCTION = true;
  } catch (e3) {
  }
  function log() {
    if (!PRODUCTION && console && typeof console.error === "function") {
      var _console;
      (_console = console).error.apply(_console, arguments);
    }
  }
  function normalizeIconArgs(icon2) {
    if (icon2 && _typeof$6(icon2) === "object" && icon2.prefix && icon2.iconName && icon2.icon) {
      return icon2;
    }
    if (parse$1$1.icon) {
      return parse$1$1.icon(icon2);
    }
    if (icon2 === null) {
      return null;
    }
    if (icon2 && _typeof$6(icon2) === "object" && icon2.prefix && icon2.iconName) {
      return icon2;
    }
    if (Array.isArray(icon2) && icon2.length === 2) {
      return {
        prefix: icon2[0],
        iconName: icon2[1]
      };
    }
    if (typeof icon2 === "string") {
      return {
        prefix: "fas",
        iconName: icon2
      };
    }
  }
  function objectWithKey(key, value) {
    return Array.isArray(value) && value.length > 0 || !Array.isArray(value) && value ? _defineProperty$p({}, key, value) : {};
  }
  var defaultProps$7 = {
    border: false,
    className: "",
    mask: null,
    maskId: null,
    fixedWidth: false,
    inverse: false,
    flip: false,
    icon: null,
    listItem: false,
    pull: null,
    pulse: false,
    rotation: null,
    size: null,
    spin: false,
    spinPulse: false,
    spinReverse: false,
    beat: false,
    fade: false,
    beatFade: false,
    bounce: false,
    shake: false,
    symbol: false,
    title: "",
    titleId: null,
    transform: null,
    swapOpacity: false
  };
  var FontAwesomeIcon = /* @__PURE__ */ React__default.default.forwardRef(function(props, ref2) {
    var allProps = _objectSpread2$1(_objectSpread2$1({}, defaultProps$7), props);
    var iconArgs = allProps.icon, maskArgs = allProps.mask, symbol = allProps.symbol, className = allProps.className, title = allProps.title, titleId = allProps.titleId, maskId = allProps.maskId;
    var iconLookup = normalizeIconArgs(iconArgs);
    var classes = objectWithKey("classes", [].concat(_toConsumableArray$3(classList$1(allProps)), _toConsumableArray$3((className || "").split(" "))));
    var transform = objectWithKey("transform", typeof allProps.transform === "string" ? parse$1$1.transform(allProps.transform) : allProps.transform);
    var mask = objectWithKey("mask", normalizeIconArgs(maskArgs));
    var renderedIcon = icon(iconLookup, _objectSpread2$1(_objectSpread2$1(_objectSpread2$1(_objectSpread2$1({}, classes), transform), mask), {}, {
      symbol,
      title,
      titleId,
      maskId
    }));
    if (!renderedIcon) {
      log("Could not find icon", iconLookup);
      return null;
    }
    var abstract = renderedIcon.abstract;
    var extraProps = {
      ref: ref2
    };
    Object.keys(allProps).forEach(function(key) {
      if (!defaultProps$7.hasOwnProperty(key)) {
        extraProps[key] = allProps[key];
      }
    });
    return convertCurry(abstract[0], extraProps);
  });
  FontAwesomeIcon.displayName = "FontAwesomeIcon";
  FontAwesomeIcon.propTypes = {
    beat: propTypes.exports.bool,
    border: propTypes.exports.bool,
    beatFade: propTypes.exports.bool,
    bounce: propTypes.exports.bool,
    className: propTypes.exports.string,
    fade: propTypes.exports.bool,
    flash: propTypes.exports.bool,
    mask: propTypes.exports.oneOfType([propTypes.exports.object, propTypes.exports.array, propTypes.exports.string]),
    maskId: propTypes.exports.string,
    fixedWidth: propTypes.exports.bool,
    inverse: propTypes.exports.bool,
    flip: propTypes.exports.oneOf([true, false, "horizontal", "vertical", "both"]),
    icon: propTypes.exports.oneOfType([propTypes.exports.object, propTypes.exports.array, propTypes.exports.string]),
    listItem: propTypes.exports.bool,
    pull: propTypes.exports.oneOf(["right", "left"]),
    pulse: propTypes.exports.bool,
    rotation: propTypes.exports.oneOf([0, 90, 180, 270]),
    shake: propTypes.exports.bool,
    size: propTypes.exports.oneOf(["2xs", "xs", "sm", "lg", "xl", "2xl", "1x", "2x", "3x", "4x", "5x", "6x", "7x", "8x", "9x", "10x"]),
    spin: propTypes.exports.bool,
    spinPulse: propTypes.exports.bool,
    spinReverse: propTypes.exports.bool,
    symbol: propTypes.exports.oneOfType([propTypes.exports.bool, propTypes.exports.string]),
    title: propTypes.exports.string,
    titleId: propTypes.exports.string,
    transform: propTypes.exports.oneOfType([propTypes.exports.string, propTypes.exports.object]),
    swapOpacity: propTypes.exports.bool
  };
  var convertCurry = convert$2.bind(null, React__default.default.createElement);
  var Icon$3 = function(e3) {
    var t2 = {};
    function r2(n2) {
      if (t2[n2])
        return t2[n2].exports;
      var o2 = t2[n2] = { i: n2, l: false, exports: {} };
      return e3[n2].call(o2.exports, o2, o2.exports, r2), o2.l = true, o2.exports;
    }
    return r2.m = e3, r2.c = t2, r2.d = function(e4, t3, n2) {
      r2.o(e4, t3) || Object.defineProperty(e4, t3, { enumerable: true, get: n2 });
    }, r2.r = function(e4) {
      "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(e4, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(e4, "__esModule", { value: true });
    }, r2.t = function(e4, t3) {
      if (1 & t3 && (e4 = r2(e4)), 8 & t3)
        return e4;
      if (4 & t3 && "object" == typeof e4 && e4 && e4.__esModule)
        return e4;
      var n2 = /* @__PURE__ */ Object.create(null);
      if (r2.r(n2), Object.defineProperty(n2, "default", { enumerable: true, value: e4 }), 2 & t3 && "string" != typeof e4)
        for (var o2 in e4)
          r2.d(n2, o2, function(t4) {
            return e4[t4];
          }.bind(null, o2));
      return n2;
    }, r2.n = function(e4) {
      var t3 = e4 && e4.__esModule ? function() {
        return e4.default;
      } : function() {
        return e4;
      };
      return r2.d(t3, "a", t3), t3;
    }, r2.o = function(e4, t3) {
      return Object.prototype.hasOwnProperty.call(e4, t3);
    }, r2.p = "", r2(r2.s = 2);
  }([function(e3, t2) {
    e3.exports = propTypes.exports;
  }, function(e3, t2) {
    e3.exports = React__default.default;
  }, function(e3, t2, r2) {
    r2.r(t2);
    var n2 = r2(1), o2 = r2(0), l2 = function() {
      return (l2 = Object.assign || function(e4) {
        for (var t3, r3 = 1, n3 = arguments.length; r3 < n3; r3++)
          for (var o3 in t3 = arguments[r3])
            Object.prototype.hasOwnProperty.call(t3, o3) && (e4[o3] = t3[o3]);
        return e4;
      }).apply(this, arguments);
    }, i2 = function(e4, t3) {
      var r3 = {};
      for (var n3 in e4)
        Object.prototype.hasOwnProperty.call(e4, n3) && t3.indexOf(n3) < 0 && (r3[n3] = e4[n3]);
      if (null != e4 && "function" == typeof Object.getOwnPropertySymbols) {
        var o3 = 0;
        for (n3 = Object.getOwnPropertySymbols(e4); o3 < n3.length; o3++)
          t3.indexOf(n3[o3]) < 0 && Object.prototype.propertyIsEnumerable.call(e4, n3[o3]) && (r3[n3[o3]] = e4[n3[o3]]);
      }
      return r3;
    }, a2 = 0, s2 = n2.forwardRef(function(e4, t3) {
      var r3 = e4.title, o3 = void 0 === r3 ? null : r3, s3 = e4.description, c3 = void 0 === s3 ? null : s3, u3 = e4.size, p3 = void 0 === u3 ? null : u3, f3 = e4.color, d3 = void 0 === f3 ? "currentColor" : f3, y2 = e4.horizontal, v3 = void 0 === y2 ? null : y2, b2 = e4.vertical, m2 = void 0 === b2 ? null : b2, h2 = e4.rotate, g2 = void 0 === h2 ? null : h2, O2 = e4.spin, w2 = void 0 === O2 ? null : O2, j2 = e4.style, z2 = void 0 === j2 ? {} : j2, E2 = e4.children, P2 = i2(e4, ["title", "description", "size", "color", "horizontal", "vertical", "rotate", "spin", "style", "children"]);
      a2++;
      var S2, x2 = null !== w2 && w2, _2 = n2.Children.map(E2, function(e6) {
        var t4 = e6;
        true !== x2 && (x2 = true === (null === w2 ? t4.props.spin : w2));
        var r4 = t4.props.size;
        "number" == typeof p3 && "number" == typeof t4.props.size && (r4 = t4.props.size / p3);
        var o4 = { size: r4, color: null === d3 ? t4.props.color : d3, horizontal: null === v3 ? t4.props.horizontal : v3, vertical: null === m2 ? t4.props.vertical : m2, rotate: null === g2 ? t4.props.rotate : g2, spin: null === w2 ? t4.props.spin : w2, inStack: true };
        return n2.cloneElement(t4, o4);
      });
      null !== p3 && (z2.width = "string" == typeof p3 ? p3 : 1.5 * p3 + "rem");
      var k2, T2 = "stack_labelledby_" + a2, q2 = "stack_describedby_" + a2;
      if (o3)
        S2 = c3 ? T2 + " " + q2 : T2;
      else if (k2 = "presentation", c3)
        throw new Error("title attribute required when description is set");
      return n2.createElement("svg", l2({ ref: t3, viewBox: "0 0 24 24", style: z2, role: k2, "aria-labelledby": S2 }, P2), o3 && n2.createElement("title", { id: T2 }, o3), c3 && n2.createElement("desc", { id: q2 }, c3), x2 && n2.createElement("style", null, "@keyframes spin { to { transform: rotate(360deg) } }", "@keyframes spin-inverse { to { transform: rotate(-360deg) } }"), _2);
    });
    s2.displayName = "Stack", s2.propTypes = { size: o2.oneOfType([o2.number, o2.string]), color: o2.string, horizontal: o2.bool, vertical: o2.bool, rotate: o2.number, spin: o2.oneOfType([o2.bool, o2.number]), children: o2.oneOfType([o2.arrayOf(o2.node), o2.node]).isRequired, className: o2.string, style: o2.object }, s2.defaultProps = { size: null, color: null, horizontal: null, vertical: null, rotate: null, spin: null };
    var c2 = s2;
    r2.d(t2, "Icon", function() {
      return d2;
    }), r2.d(t2, "Stack", function() {
      return c2;
    });
    var u2 = function() {
      return (u2 = Object.assign || function(e4) {
        for (var t3, r3 = 1, n3 = arguments.length; r3 < n3; r3++)
          for (var o3 in t3 = arguments[r3])
            Object.prototype.hasOwnProperty.call(t3, o3) && (e4[o3] = t3[o3]);
        return e4;
      }).apply(this, arguments);
    }, p2 = function(e4, t3) {
      var r3 = {};
      for (var n3 in e4)
        Object.prototype.hasOwnProperty.call(e4, n3) && t3.indexOf(n3) < 0 && (r3[n3] = e4[n3]);
      if (null != e4 && "function" == typeof Object.getOwnPropertySymbols) {
        var o3 = 0;
        for (n3 = Object.getOwnPropertySymbols(e4); o3 < n3.length; o3++)
          t3.indexOf(n3[o3]) < 0 && Object.prototype.propertyIsEnumerable.call(e4, n3[o3]) && (r3[n3[o3]] = e4[n3[o3]]);
      }
      return r3;
    }, f2 = 0, d2 = n2.forwardRef(function(e4, t3) {
      var r3 = e4.path, o3 = e4.title, l3 = void 0 === o3 ? null : o3, i3 = e4.description, a3 = void 0 === i3 ? null : i3, s3 = e4.size, c3 = void 0 === s3 ? null : s3, d3 = e4.color, y2 = void 0 === d3 ? "currentColor" : d3, v3 = e4.horizontal, b2 = void 0 !== v3 && v3, m2 = e4.vertical, h2 = void 0 !== m2 && m2, g2 = e4.rotate, O2 = void 0 === g2 ? 0 : g2, w2 = e4.spin, j2 = void 0 !== w2 && w2, z2 = e4.style, E2 = void 0 === z2 ? {} : z2, P2 = e4.inStack, S2 = void 0 !== P2 && P2, x2 = p2(e4, ["path", "title", "description", "size", "color", "horizontal", "vertical", "rotate", "spin", "style", "inStack"]);
      f2++;
      var _2 = {}, k2 = [];
      null !== c3 && (S2 ? k2.push("scale(" + c3 + ")") : (E2.width = "string" == typeof c3 ? c3 : 1.5 * c3 + "rem", E2.height = E2.width)), b2 && k2.push("scaleX(-1)"), h2 && k2.push("scaleY(-1)"), 0 !== O2 && k2.push("rotate(" + O2 + "deg)"), null !== y2 && (_2.fill = y2);
      var T2 = n2.createElement("path", u2({ d: r3, style: _2 }, S2 ? x2 : {})), q2 = T2;
      k2.length > 0 && (E2.transform = k2.join(" "), E2.transformOrigin = "center", S2 && (q2 = n2.createElement("g", { style: E2 }, T2, n2.createElement("rect", { width: "24", height: "24", fill: "transparent" }))));
      var M2, C2 = q2, I2 = true === j2 || "number" != typeof j2 ? 2 : j2, N2 = !S2 && (b2 || h2);
      if (I2 < 0 && (N2 = !N2), j2 && (C2 = n2.createElement("g", { style: { animation: "spin" + (N2 ? "-inverse" : "") + " linear " + Math.abs(I2) + "s infinite", transformOrigin: "center" } }, q2, !(b2 || h2 || 0 !== O2) && n2.createElement("rect", { width: "24", height: "24", fill: "transparent" }))), S2)
        return C2;
      var R2, B2 = "icon_labelledby_" + f2, X2 = "icon_describedby_" + f2;
      if (l3)
        M2 = a3 ? B2 + " " + X2 : B2;
      else if (R2 = "presentation", a3)
        throw new Error("title attribute required when description is set");
      return n2.createElement("svg", u2({ ref: t3, viewBox: "0 0 24 24", style: E2, role: R2, "aria-labelledby": M2 }, x2), l3 && n2.createElement("title", { id: B2 }, l3), a3 && n2.createElement("desc", { id: X2 }, a3), !S2 && j2 && (N2 ? n2.createElement("style", null, "@keyframes spin-inverse { to { transform: rotate(-360deg) } }") : n2.createElement("style", null, "@keyframes spin { to { transform: rotate(360deg) } }")), C2);
    });
    d2.displayName = "Icon", d2.propTypes = { path: o2.string.isRequired, size: o2.oneOfType([o2.number, o2.string]), color: o2.string, horizontal: o2.bool, vertical: o2.bool, rotate: o2.number, spin: o2.oneOfType([o2.bool, o2.number]), style: o2.object, inStack: o2.bool, className: o2.string }, d2.defaultProps = { size: null, color: "currentColor", horizontal: false, vertical: false, rotate: 0, spin: false };
    t2.default = d2;
  }]);
  const shouldForwardProp$4 = (prop) => !["asButton"].includes(prop);
  const StyledFAIcon = styled__default.default(FontAwesomeIcon).withConfig({ shouldForwardProp: shouldForwardProp$4 })`
        cursor: ${(props) => props.asButton ? "pointer" : "inherit"};
        color: inherit;
        ${(props) => props.asButton ? `:hover { color: ${props.theme.colors.grey6}; }` : ""}
    `;
  const mapFASizeToMD = {
    "10x": "120px",
    "1x": "12px",
    "2x": "24px",
    "3x": "36px",
    "4x": "48px",
    "5x": "60px",
    "6x": "72px",
    "7x": "84px",
    "8x": "96px",
    "9x": "108px",
    lg: "24px",
    sm: "12px",
    xs: "6px"
  };
  const SizeMappedMDIcon = (props) => {
    if (props.size) {
      return jsxRuntime.exports.jsx(Icon$3.Icon, Object.assign({}, props, { size: mapFASizeToMD[props.size] }));
    }
    return jsxRuntime.exports.jsx(Icon$3.Icon, Object.assign({}, props));
  };
  const StyledMDIcon = styled__default.default(SizeMappedMDIcon).withConfig({ shouldForwardProp: shouldForwardProp$4 })`
    cursor: ${(props) => props.asButton ? "pointer" : "default"};
    color: inherit;
    ${(props) => props.asButton ? `:hover { color: ${props.theme.colors.grey6}; }` : ""}
`;
  var mdiSwapHorizontal = "M21,9L17,5V8H10V10H17V13M7,11L3,15L7,19V16H14V14H7V11Z";
  const ArrowDown = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowDown }, props));
  };
  const ArrowLeft = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowLeft }, props));
  };
  const ArrowRight = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowRight }, props));
  };
  const ArrowRightLong = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowRightLong }, props));
  };
  const ArrowUp = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowUp }, props));
  };
  const ArrowsHorizontal = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrowsAltH }, props));
  };
  const Arrows$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faArrows }, props));
  };
  const Ban = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faBan }, props));
  };
  const Check = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCheck }, props));
  };
  const CheckSquare = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCheckSquare }, props));
  };
  const ChevronLeft = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faChevronLeft }, props));
  };
  const ChevronRight = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faChevronRight }, props));
  };
  const Circle$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCircle }, props));
  };
  var faImage = {
    prefix: "far",
    iconName: "image",
    icon: [512, 512, [], "f03e", "M448 80c8.8 0 16 7.2 16 16V415.8l-5-6.5-136-176c-4.5-5.9-11.6-9.3-19-9.3s-14.4 3.4-19 9.3L202 340.7l-30.5-42.7C167 291.7 159.8 288 152 288s-15 3.7-19.5 10.1l-80 112L48 416.3l0-.3V96c0-8.8 7.2-16 16-16H448zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H448c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64zm80 192a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]
  };
  var faSquare = {
    prefix: "far",
    iconName: "square",
    icon: [448, 512, [9632, 9723, 9724, 61590], "f0c8", "M384 80c8.8 0 16 7.2 16 16V416c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V96c0-8.8 7.2-16 16-16H384zM64 32C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64H384c35.3 0 64-28.7 64-64V96c0-35.3-28.7-64-64-64H64z"]
  };
  var faCircleQuestion = {
    prefix: "far",
    iconName: "circle-question",
    icon: [512, 512, [62108, "question-circle"], "f059", "M464 256A208 208 0 1 0 48 256a208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm169.8-90.7c7.9-22.3 29.1-37.3 52.8-37.3h58.3c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L280 264.4c-.2 13-10.9 23.6-24 23.6c-13.3 0-24-10.7-24-24V250.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1H222.6c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6l.4-1.2zM224 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
  };
  var faCopy = {
    prefix: "far",
    iconName: "copy",
    icon: [448, 512, [], "f0c5", "M384 336H192c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16l140.1 0L400 115.9V320c0 8.8-7.2 16-16 16zM192 384H384c35.3 0 64-28.7 64-64V115.9c0-12.7-5.1-24.9-14.1-33.9L366.1 14.1c-9-9-21.2-14.1-33.9-14.1H192c-35.3 0-64 28.7-64 64V320c0 35.3 28.7 64 64 64zM64 128c-35.3 0-64 28.7-64 64V448c0 35.3 28.7 64 64 64H256c35.3 0 64-28.7 64-64V416H272v32c0 8.8-7.2 16-16 16H64c-8.8 0-16-7.2-16-16V192c0-8.8 7.2-16 16-16H96V128H64z"]
  };
  const Copy = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCopy }, props));
  };
  const Cross$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faTimes }, props));
  };
  const Filter$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faFilter }, props));
  };
  const Plus = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faPlus }, props));
  };
  const Refresh = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faRefresh }, props));
  };
  const Search = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faSearch }, props));
  };
  const Square = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faSquare }, props));
  };
  const SwapHorizontal = (props) => {
    return jsxRuntime.exports.jsx(StyledMDIcon, Object.assign({ path: mdiSwapHorizontal }, props));
  };
  const ToggleOff = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faToggleOff }, props));
  };
  const ToggleOn = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faToggleOn }, props));
  };
  const Trash = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faTrash }, props));
  };
  const ChevronDown = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faChevronDown }, props));
  };
  const ChevronUp = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faChevronUp }, props));
  };
  const FarImage = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faImage }, props));
  };
  const List$1 = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faList }, props));
  };
  const Moon = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faMoon }, props));
  };
  const TrashAlt = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faTrashAlt }, props));
  };
  const DownLeftAndUpRightToCenter = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faDownLeftAndUpRightToCenter }, props));
  };
  const PenToSquare = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faPenToSquare }, props));
  };
  const CircleCheck = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCircleCheck }, props));
  };
  const CircleInfo = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCircleInfo }, props));
  };
  const MagnifyingGlass = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faMagnifyingGlass }, props));
  };
  const Xmark = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faXmark }, props));
  };
  const UpRightAndDownLeftFromCenter = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faUpRightAndDownLeftFromCenter }, props));
  };
  const TriangleExclamation = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faTriangleExclamation }, props));
  };
  const CircleXmark = (props) => {
    return jsxRuntime.exports.jsx(StyledFAIcon, Object.assign({ icon: faCircleXmark }, props));
  };
  const shouldForwardProp$3 = (prop) => !["isOpen"].includes(prop);
  const Icon$2 = styled__default.default(ChevronDown).withConfig({ shouldForwardProp: shouldForwardProp$3 })`
    cursor: ${(props) => props.disabled ? "not-allowed" : "pointer"};
    transform: ${(props) => {
    const start2 = props.angles ? props.angles[0] : 0;
    const end2 = props.angles ? props.angles[1] : 180;
    return props.isOpen ? `rotate(${end2}deg)` : `rotate(${start2}deg)`;
  }};
    color: ${(props) => props.theme.colors.grey5};
    transition: transform 0.1s linear;
`;
  const Chevron$1 = React__namespace.forwardRef((props, ref2) => jsxRuntime.exports.jsx(Icon$2, { angles: props.angles, className: props.className, disabled: props.disabled, isOpen: props.isOpen, onClick: props.onClick, ref: ref2, style: props.style }));
  const Chevron$2 = React__namespace.memo(Chevron$1);
  styled__default.default.label`
    margin-bottom: 0;
    font-size: 11px;
    color: ${(props) => props.theme.colors.grey6};
`;
  const List = styled__default.default.div`
    z-index: 5000;

    overflow-y: auto;
    display: ${(props) => props.isOpen ? "flex" : "none"};
    flex-direction: column;

    max-height: calc(${(props) => (props.maxItems || 5) * 2}em + 2px);

    border: 1px solid ${(props) => props.theme.colors.grey3};
`;
  const NoItemsLabel = styled__default.default.span`
    display: flex;
    flex: 1 1 auto;
    align-items: center;
    justify-content: center;

    height: 2rem;

    font-size: 1rem;
    color: ${(props) => props.theme.colors.text};

    background-color: ${(props) => props.theme.colors.blue1};
`;
  globalThis && globalThis.__awaiter || function(thisArg, _arguments, P2, generator) {
    function adopt(value) {
      return value instanceof P2 ? value : new P2(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P2 || (P2 = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step2(generator.next(value));
        } catch (e3) {
          reject(e3);
        }
      }
      function rejected(value) {
        try {
          step2(generator["throw"](value));
        } catch (e3) {
          reject(e3);
        }
      }
      function step2(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step2((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  var Status;
  (function(Status2) {
    Status2["CANCELED"] = "CANCELED";
    Status2["CREATED"] = "CREATED";
    Status2["ERROR"] = "ERROR";
    Status2["FAILED"] = "FAILED";
    Status2["NONE"] = "";
    Status2["QUEUED"] = "QUEUED";
    Status2["RUNNING"] = "RUNNING";
    Status2["SUCCESS"] = "SUCCESS";
    Status2["WARNING"] = "WARNING";
  })(Status || (Status = {}));
  var HTTP_METHOD;
  (function(HTTP_METHOD2) {
    HTTP_METHOD2["DELETE"] = "DELETE";
    HTTP_METHOD2["GET"] = "GET";
    HTTP_METHOD2["PATCH"] = "PATCH";
    HTTP_METHOD2["POST"] = "POST";
    HTTP_METHOD2["PUT"] = "PUT";
  })(HTTP_METHOD || (HTTP_METHOD = {}));
  const getStatusColor = (status2, colors2) => {
    if ([Status.ERROR, Status.FAILED].includes(status2)) {
      return colors2.error;
    }
    if ([Status.CANCELED, Status.WARNING].includes(status2)) {
      return colors2.warning;
    }
    return status2 === Status.SUCCESS ? colors2.success : colors2.primary;
  };
  var shortid$1 = { exports: {} };
  var lib$1 = { exports: {} };
  var seed = 1;
  function getNextValue$1() {
    seed = (seed * 9301 + 49297) % 233280;
    return seed / 233280;
  }
  function setSeed$1(_seed_) {
    seed = _seed_;
  }
  var randomFromSeed$1 = {
    nextValue: getNextValue$1,
    seed: setSeed$1
  };
  var randomFromSeed = randomFromSeed$1;
  var ORIGINAL = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-";
  var alphabet$2;
  var previousSeed;
  var shuffled;
  function reset() {
    shuffled = false;
  }
  function setCharacters(_alphabet_) {
    if (!_alphabet_) {
      if (alphabet$2 !== ORIGINAL) {
        alphabet$2 = ORIGINAL;
        reset();
      }
      return;
    }
    if (_alphabet_ === alphabet$2) {
      return;
    }
    if (_alphabet_.length !== ORIGINAL.length) {
      throw new Error("Custom alphabet for shortid must be " + ORIGINAL.length + " unique characters. You submitted " + _alphabet_.length + " characters: " + _alphabet_);
    }
    var unique2 = _alphabet_.split("").filter(function(item, ind, arr) {
      return ind !== arr.lastIndexOf(item);
    });
    if (unique2.length) {
      throw new Error("Custom alphabet for shortid must be " + ORIGINAL.length + " unique characters. These characters were not unique: " + unique2.join(", "));
    }
    alphabet$2 = _alphabet_;
    reset();
  }
  function characters(_alphabet_) {
    setCharacters(_alphabet_);
    return alphabet$2;
  }
  function setSeed(seed2) {
    randomFromSeed.seed(seed2);
    if (previousSeed !== seed2) {
      reset();
      previousSeed = seed2;
    }
  }
  function shuffle$1() {
    if (!alphabet$2) {
      setCharacters(ORIGINAL);
    }
    var sourceArray = alphabet$2.split("");
    var targetArray = [];
    var r2 = randomFromSeed.nextValue();
    var characterIndex;
    while (sourceArray.length > 0) {
      r2 = randomFromSeed.nextValue();
      characterIndex = Math.floor(r2 * sourceArray.length);
      targetArray.push(sourceArray.splice(characterIndex, 1)[0]);
    }
    return targetArray.join("");
  }
  function getShuffled() {
    if (shuffled) {
      return shuffled;
    }
    shuffled = shuffle$1();
    return shuffled;
  }
  function lookup$1(index2) {
    var alphabetShuffled = getShuffled();
    return alphabetShuffled[index2];
  }
  function get$4() {
    return alphabet$2 || ORIGINAL;
  }
  var alphabet_1 = {
    get: get$4,
    characters,
    seed: setSeed,
    lookup: lookup$1,
    shuffled: getShuffled
  };
  var crypto$1 = typeof window === "object" && (window.crypto || window.msCrypto);
  var randomByte;
  if (!crypto$1 || !crypto$1.getRandomValues) {
    randomByte = function(size2) {
      var bytes = [];
      for (var i2 = 0; i2 < size2; i2++) {
        bytes.push(Math.floor(Math.random() * 256));
      }
      return bytes;
    };
  } else {
    randomByte = function(size2) {
      return crypto$1.getRandomValues(new Uint8Array(size2));
    };
  }
  var randomByteBrowser = randomByte;
  var format_browser = function(random2, alphabet2, size2) {
    var mask = (2 << Math.log(alphabet2.length - 1) / Math.LN2) - 1;
    var step2 = -~(1.6 * mask * size2 / alphabet2.length);
    var id2 = "";
    while (true) {
      var bytes = random2(step2);
      var i2 = step2;
      while (i2--) {
        id2 += alphabet2[bytes[i2] & mask] || "";
        if (id2.length === +size2)
          return id2;
      }
    }
  };
  var alphabet$1 = alphabet_1;
  var random$3 = randomByteBrowser;
  var format$3 = format_browser;
  function generate$1(number2) {
    var loopCounter = 0;
    var done;
    var str = "";
    while (!done) {
      str = str + format$3(random$3, alphabet$1.get(), 1);
      done = number2 < Math.pow(16, loopCounter + 1);
      loopCounter++;
    }
    return str;
  }
  var generate_1 = generate$1;
  var generate = generate_1;
  var REDUCE_TIME = 1567752802062;
  var version$1 = 7;
  var counter;
  var previousSeconds;
  function build$1(clusterWorkerId) {
    var str = "";
    var seconds = Math.floor((Date.now() - REDUCE_TIME) * 1e-3);
    if (seconds === previousSeconds) {
      counter++;
    } else {
      counter = 0;
      previousSeconds = seconds;
    }
    str = str + generate(version$1);
    str = str + generate(clusterWorkerId);
    if (counter > 0) {
      str = str + generate(counter);
    }
    str = str + generate(seconds);
    return str;
  }
  var build_1 = build$1;
  var alphabet = alphabet_1;
  function isShortId(id2) {
    if (!id2 || typeof id2 !== "string" || id2.length < 6) {
      return false;
    }
    var nonAlphabetic = new RegExp("[^" + alphabet.get().replace(/[|\\{}()[\]^$+*?.-]/g, "\\$&") + "]");
    return !nonAlphabetic.test(id2);
  }
  var isValid$2 = isShortId;
  (function(module2) {
    var alphabet2 = alphabet_1;
    var build2 = build_1;
    var isValid2 = isValid$2;
    var clusterWorkerId = 0;
    function seed2(seedValue) {
      alphabet2.seed(seedValue);
      return module2.exports;
    }
    function worker(workerId) {
      clusterWorkerId = workerId;
      return module2.exports;
    }
    function characters2(newCharacters) {
      if (newCharacters !== void 0) {
        alphabet2.characters(newCharacters);
      }
      return alphabet2.shuffled();
    }
    function generate2() {
      return build2(clusterWorkerId);
    }
    module2.exports = generate2;
    module2.exports.generate = generate2;
    module2.exports.seed = seed2;
    module2.exports.worker = worker;
    module2.exports.characters = characters2;
    module2.exports.isValid = isValid2;
  })(lib$1);
  (function(module2) {
    module2.exports = lib$1.exports;
  })(shortid$1);
  const shortid = /* @__PURE__ */ getDefaultExportFromCjs(shortid$1.exports);
  var __awaiter$5 = globalThis && globalThis.__awaiter || function(thisArg, _arguments, P2, generator) {
    function adopt(value) {
      return value instanceof P2 ? value : new P2(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P2 || (P2 = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step2(generator.next(value));
        } catch (e3) {
          reject(e3);
        }
      }
      function rejected(value) {
        try {
          step2(generator["throw"](value));
        } catch (e3) {
          reject(e3);
        }
      }
      function step2(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step2((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  class RequestError extends Error {
    constructor(status2, message, requestParams) {
      super(message);
      this.name = "ServiceError";
      this.status = status2;
      this.requestParams = requestParams;
    }
  }
  const isValidResponse = (res) => {
    return res.status >= 100 && res.status < 400;
  };
  function validateResponse(res, fallbackMessage, requestParams) {
    return __awaiter$5(this, void 0, void 0, function* () {
      if (!isValidResponse(res)) {
        let message = fallbackMessage;
        try {
          const json2 = yield res.json();
          message = (json2 === null || json2 === void 0 ? void 0 : json2.message) || (json2 === null || json2 === void 0 ? void 0 : json2.detail) || fallbackMessage;
        } catch (e3) {
          if (fallbackMessage) {
            try {
              message = (yield res.text()) || fallbackMessage;
            } catch (_a3) {
            }
          }
        }
        throw new RequestError(res.status, message, requestParams);
      }
    });
  }
  function listCacheClear$2() {
    this.__data__ = [];
    this.size = 0;
  }
  var _listCacheClear$1 = listCacheClear$2;
  function eq$4(value, other) {
    return value === other || value !== value && other !== other;
  }
  var eq_1$1 = eq$4;
  var eq$3 = eq_1$1;
  function assocIndexOf$5(array2, key) {
    var length = array2.length;
    while (length--) {
      if (eq$3(array2[length][0], key)) {
        return length;
      }
    }
    return -1;
  }
  var _assocIndexOf$1 = assocIndexOf$5;
  var assocIndexOf$4 = _assocIndexOf$1;
  var arrayProto$1 = Array.prototype;
  var splice$2 = arrayProto$1.splice;
  function listCacheDelete$2(key) {
    var data2 = this.__data__, index2 = assocIndexOf$4(data2, key);
    if (index2 < 0) {
      return false;
    }
    var lastIndex = data2.length - 1;
    if (index2 == lastIndex) {
      data2.pop();
    } else {
      splice$2.call(data2, index2, 1);
    }
    --this.size;
    return true;
  }
  var _listCacheDelete$1 = listCacheDelete$2;
  var assocIndexOf$3 = _assocIndexOf$1;
  function listCacheGet$2(key) {
    var data2 = this.__data__, index2 = assocIndexOf$3(data2, key);
    return index2 < 0 ? void 0 : data2[index2][1];
  }
  var _listCacheGet$1 = listCacheGet$2;
  var assocIndexOf$2 = _assocIndexOf$1;
  function listCacheHas$2(key) {
    return assocIndexOf$2(this.__data__, key) > -1;
  }
  var _listCacheHas$1 = listCacheHas$2;
  var assocIndexOf$1 = _assocIndexOf$1;
  function listCacheSet$2(key, value) {
    var data2 = this.__data__, index2 = assocIndexOf$1(data2, key);
    if (index2 < 0) {
      ++this.size;
      data2.push([key, value]);
    } else {
      data2[index2][1] = value;
    }
    return this;
  }
  var _listCacheSet$1 = listCacheSet$2;
  var listCacheClear$1 = _listCacheClear$1, listCacheDelete$1 = _listCacheDelete$1, listCacheGet$1 = _listCacheGet$1, listCacheHas$1 = _listCacheHas$1, listCacheSet$1 = _listCacheSet$1;
  function ListCache$5(entries) {
    var index2 = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index2 < length) {
      var entry = entries[index2];
      this.set(entry[0], entry[1]);
    }
  }
  ListCache$5.prototype.clear = listCacheClear$1;
  ListCache$5.prototype["delete"] = listCacheDelete$1;
  ListCache$5.prototype.get = listCacheGet$1;
  ListCache$5.prototype.has = listCacheHas$1;
  ListCache$5.prototype.set = listCacheSet$1;
  var _ListCache$1 = ListCache$5;
  var ListCache$4 = _ListCache$1;
  function stackClear$1() {
    this.__data__ = new ListCache$4();
    this.size = 0;
  }
  var _stackClear = stackClear$1;
  function stackDelete$1(key) {
    var data2 = this.__data__, result = data2["delete"](key);
    this.size = data2.size;
    return result;
  }
  var _stackDelete = stackDelete$1;
  function stackGet$1(key) {
    return this.__data__.get(key);
  }
  var _stackGet = stackGet$1;
  function stackHas$1(key) {
    return this.__data__.has(key);
  }
  var _stackHas = stackHas$1;
  var freeGlobal$2 = typeof commonjsGlobal$1 == "object" && commonjsGlobal$1 && commonjsGlobal$1.Object === Object && commonjsGlobal$1;
  var _freeGlobal$1 = freeGlobal$2;
  var freeGlobal$1 = _freeGlobal$1;
  var freeSelf$1 = typeof self == "object" && self && self.Object === Object && self;
  var root$g = freeGlobal$1 || freeSelf$1 || Function("return this")();
  var _root$1 = root$g;
  var root$f = _root$1;
  var Symbol$6 = root$f.Symbol;
  var _Symbol$1 = Symbol$6;
  var Symbol$5 = _Symbol$1;
  var objectProto$j = Object.prototype;
  var hasOwnProperty$g = objectProto$j.hasOwnProperty;
  var nativeObjectToString$3 = objectProto$j.toString;
  var symToStringTag$3 = Symbol$5 ? Symbol$5.toStringTag : void 0;
  function getRawTag$2(value) {
    var isOwn = hasOwnProperty$g.call(value, symToStringTag$3), tag = value[symToStringTag$3];
    try {
      value[symToStringTag$3] = void 0;
      var unmasked = true;
    } catch (e3) {
    }
    var result = nativeObjectToString$3.call(value);
    if (unmasked) {
      if (isOwn) {
        value[symToStringTag$3] = tag;
      } else {
        delete value[symToStringTag$3];
      }
    }
    return result;
  }
  var _getRawTag$1 = getRawTag$2;
  var objectProto$i = Object.prototype;
  var nativeObjectToString$2 = objectProto$i.toString;
  function objectToString$3(value) {
    return nativeObjectToString$2.call(value);
  }
  var _objectToString$1 = objectToString$3;
  var Symbol$4 = _Symbol$1, getRawTag$1 = _getRawTag$1, objectToString$2 = _objectToString$1;
  var nullTag$1 = "[object Null]", undefinedTag$1 = "[object Undefined]";
  var symToStringTag$2 = Symbol$4 ? Symbol$4.toStringTag : void 0;
  function baseGetTag$6(value) {
    if (value == null) {
      return value === void 0 ? undefinedTag$1 : nullTag$1;
    }
    return symToStringTag$2 && symToStringTag$2 in Object(value) ? getRawTag$1(value) : objectToString$2(value);
  }
  var _baseGetTag$1 = baseGetTag$6;
  function isObject$a(value) {
    var type2 = typeof value;
    return value != null && (type2 == "object" || type2 == "function");
  }
  var isObject_1$1 = isObject$a;
  var baseGetTag$5 = _baseGetTag$1, isObject$9 = isObject_1$1;
  var asyncTag$1 = "[object AsyncFunction]", funcTag$3 = "[object Function]", genTag$2 = "[object GeneratorFunction]", proxyTag$1 = "[object Proxy]";
  function isFunction$4(value) {
    if (!isObject$9(value)) {
      return false;
    }
    var tag = baseGetTag$5(value);
    return tag == funcTag$3 || tag == genTag$2 || tag == asyncTag$1 || tag == proxyTag$1;
  }
  var isFunction_1$1 = isFunction$4;
  var root$e = _root$1;
  var coreJsData$2 = root$e["__core-js_shared__"];
  var _coreJsData$1 = coreJsData$2;
  var coreJsData$1 = _coreJsData$1;
  var maskSrcKey$1 = function() {
    var uid2 = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || "");
    return uid2 ? "Symbol(src)_1." + uid2 : "";
  }();
  function isMasked$2(func) {
    return !!maskSrcKey$1 && maskSrcKey$1 in func;
  }
  var _isMasked$1 = isMasked$2;
  var funcProto$3 = Function.prototype;
  var funcToString$3 = funcProto$3.toString;
  function toSource$3(func) {
    if (func != null) {
      try {
        return funcToString$3.call(func);
      } catch (e3) {
      }
      try {
        return func + "";
      } catch (e3) {
      }
    }
    return "";
  }
  var _toSource$1 = toSource$3;
  var isFunction$3 = isFunction_1$1, isMasked$1 = _isMasked$1, isObject$8 = isObject_1$1, toSource$2 = _toSource$1;
  var reRegExpChar$1 = /[\\^$.*+?()[\]{}|]/g;
  var reIsHostCtor$1 = /^\[object .+?Constructor\]$/;
  var funcProto$2 = Function.prototype, objectProto$h = Object.prototype;
  var funcToString$2 = funcProto$2.toString;
  var hasOwnProperty$f = objectProto$h.hasOwnProperty;
  var reIsNative$1 = RegExp(
    "^" + funcToString$2.call(hasOwnProperty$f).replace(reRegExpChar$1, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
  );
  function baseIsNative$2(value) {
    if (!isObject$8(value) || isMasked$1(value)) {
      return false;
    }
    var pattern = isFunction$3(value) ? reIsNative$1 : reIsHostCtor$1;
    return pattern.test(toSource$2(value));
  }
  var _baseIsNative$1 = baseIsNative$2;
  function getValue$3(object2, key) {
    return object2 == null ? void 0 : object2[key];
  }
  var _getValue$1 = getValue$3;
  var baseIsNative$1 = _baseIsNative$1, getValue$2 = _getValue$1;
  function getNative$8(object2, key) {
    var value = getValue$2(object2, key);
    return baseIsNative$1(value) ? value : void 0;
  }
  var _getNative$1 = getNative$8;
  var getNative$7 = _getNative$1, root$d = _root$1;
  var Map$6 = getNative$7(root$d, "Map");
  var _Map$1 = Map$6;
  var getNative$6 = _getNative$1;
  var nativeCreate$5 = getNative$6(Object, "create");
  var _nativeCreate$1 = nativeCreate$5;
  var nativeCreate$4 = _nativeCreate$1;
  function hashClear$2() {
    this.__data__ = nativeCreate$4 ? nativeCreate$4(null) : {};
    this.size = 0;
  }
  var _hashClear$1 = hashClear$2;
  function hashDelete$2(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
  }
  var _hashDelete$1 = hashDelete$2;
  var nativeCreate$3 = _nativeCreate$1;
  var HASH_UNDEFINED$4 = "__lodash_hash_undefined__";
  var objectProto$g = Object.prototype;
  var hasOwnProperty$e = objectProto$g.hasOwnProperty;
  function hashGet$2(key) {
    var data2 = this.__data__;
    if (nativeCreate$3) {
      var result = data2[key];
      return result === HASH_UNDEFINED$4 ? void 0 : result;
    }
    return hasOwnProperty$e.call(data2, key) ? data2[key] : void 0;
  }
  var _hashGet$1 = hashGet$2;
  var nativeCreate$2 = _nativeCreate$1;
  var objectProto$f = Object.prototype;
  var hasOwnProperty$d = objectProto$f.hasOwnProperty;
  function hashHas$2(key) {
    var data2 = this.__data__;
    return nativeCreate$2 ? data2[key] !== void 0 : hasOwnProperty$d.call(data2, key);
  }
  var _hashHas$1 = hashHas$2;
  var nativeCreate$1 = _nativeCreate$1;
  var HASH_UNDEFINED$3 = "__lodash_hash_undefined__";
  function hashSet$2(key, value) {
    var data2 = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data2[key] = nativeCreate$1 && value === void 0 ? HASH_UNDEFINED$3 : value;
    return this;
  }
  var _hashSet$1 = hashSet$2;
  var hashClear$1 = _hashClear$1, hashDelete$1 = _hashDelete$1, hashGet$1 = _hashGet$1, hashHas$1 = _hashHas$1, hashSet$1 = _hashSet$1;
  function Hash$2(entries) {
    var index2 = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index2 < length) {
      var entry = entries[index2];
      this.set(entry[0], entry[1]);
    }
  }
  Hash$2.prototype.clear = hashClear$1;
  Hash$2.prototype["delete"] = hashDelete$1;
  Hash$2.prototype.get = hashGet$1;
  Hash$2.prototype.has = hashHas$1;
  Hash$2.prototype.set = hashSet$1;
  var _Hash$1 = Hash$2;
  var Hash$1 = _Hash$1, ListCache$3 = _ListCache$1, Map$5 = _Map$1;
  function mapCacheClear$2() {
    this.size = 0;
    this.__data__ = {
      "hash": new Hash$1(),
      "map": new (Map$5 || ListCache$3)(),
      "string": new Hash$1()
    };
  }
  var _mapCacheClear$1 = mapCacheClear$2;
  function isKeyable$2(value) {
    var type2 = typeof value;
    return type2 == "string" || type2 == "number" || type2 == "symbol" || type2 == "boolean" ? value !== "__proto__" : value === null;
  }
  var _isKeyable$1 = isKeyable$2;
  var isKeyable$1 = _isKeyable$1;
  function getMapData$5(map2, key) {
    var data2 = map2.__data__;
    return isKeyable$1(key) ? data2[typeof key == "string" ? "string" : "hash"] : data2.map;
  }
  var _getMapData$1 = getMapData$5;
  var getMapData$4 = _getMapData$1;
  function mapCacheDelete$2(key) {
    var result = getMapData$4(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
  }
  var _mapCacheDelete$1 = mapCacheDelete$2;
  var getMapData$3 = _getMapData$1;
  function mapCacheGet$2(key) {
    return getMapData$3(this, key).get(key);
  }
  var _mapCacheGet$1 = mapCacheGet$2;
  var getMapData$2 = _getMapData$1;
  function mapCacheHas$2(key) {
    return getMapData$2(this, key).has(key);
  }
  var _mapCacheHas$1 = mapCacheHas$2;
  var getMapData$1 = _getMapData$1;
  function mapCacheSet$2(key, value) {
    var data2 = getMapData$1(this, key), size2 = data2.size;
    data2.set(key, value);
    this.size += data2.size == size2 ? 0 : 1;
    return this;
  }
  var _mapCacheSet$1 = mapCacheSet$2;
  var mapCacheClear$1 = _mapCacheClear$1, mapCacheDelete$1 = _mapCacheDelete$1, mapCacheGet$1 = _mapCacheGet$1, mapCacheHas$1 = _mapCacheHas$1, mapCacheSet$1 = _mapCacheSet$1;
  function MapCache$3(entries) {
    var index2 = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index2 < length) {
      var entry = entries[index2];
      this.set(entry[0], entry[1]);
    }
  }
  MapCache$3.prototype.clear = mapCacheClear$1;
  MapCache$3.prototype["delete"] = mapCacheDelete$1;
  MapCache$3.prototype.get = mapCacheGet$1;
  MapCache$3.prototype.has = mapCacheHas$1;
  MapCache$3.prototype.set = mapCacheSet$1;
  var _MapCache$1 = MapCache$3;
  var ListCache$2 = _ListCache$1, Map$4 = _Map$1, MapCache$2 = _MapCache$1;
  var LARGE_ARRAY_SIZE = 200;
  function stackSet$1(key, value) {
    var data2 = this.__data__;
    if (data2 instanceof ListCache$2) {
      var pairs = data2.__data__;
      if (!Map$4 || pairs.length < LARGE_ARRAY_SIZE - 1) {
        pairs.push([key, value]);
        this.size = ++data2.size;
        return this;
      }
      data2 = this.__data__ = new MapCache$2(pairs);
    }
    data2.set(key, value);
    this.size = data2.size;
    return this;
  }
  var _stackSet = stackSet$1;
  var ListCache$1 = _ListCache$1, stackClear = _stackClear, stackDelete = _stackDelete, stackGet = _stackGet, stackHas = _stackHas, stackSet = _stackSet;
  function Stack$5(entries) {
    var data2 = this.__data__ = new ListCache$1(entries);
    this.size = data2.size;
  }
  Stack$5.prototype.clear = stackClear;
  Stack$5.prototype["delete"] = stackDelete;
  Stack$5.prototype.get = stackGet;
  Stack$5.prototype.has = stackHas;
  Stack$5.prototype.set = stackSet;
  var _Stack = Stack$5;
  var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
  function setCacheAdd$1(value) {
    this.__data__.set(value, HASH_UNDEFINED$2);
    return this;
  }
  var _setCacheAdd = setCacheAdd$1;
  function setCacheHas$1(value) {
    return this.__data__.has(value);
  }
  var _setCacheHas = setCacheHas$1;
  var MapCache$1 = _MapCache$1, setCacheAdd = _setCacheAdd, setCacheHas = _setCacheHas;
  function SetCache$1(values) {
    var index2 = -1, length = values == null ? 0 : values.length;
    this.__data__ = new MapCache$1();
    while (++index2 < length) {
      this.add(values[index2]);
    }
  }
  SetCache$1.prototype.add = SetCache$1.prototype.push = setCacheAdd;
  SetCache$1.prototype.has = setCacheHas;
  var _SetCache = SetCache$1;
  function arraySome$1(array2, predicate) {
    var index2 = -1, length = array2 == null ? 0 : array2.length;
    while (++index2 < length) {
      if (predicate(array2[index2], index2, array2)) {
        return true;
      }
    }
    return false;
  }
  var _arraySome = arraySome$1;
  function cacheHas$1(cache2, key) {
    return cache2.has(key);
  }
  var _cacheHas = cacheHas$1;
  var SetCache = _SetCache, arraySome = _arraySome, cacheHas = _cacheHas;
  var COMPARE_PARTIAL_FLAG$3 = 1, COMPARE_UNORDERED_FLAG$1 = 2;
  function equalArrays$2(array2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3, arrLength = array2.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
      return false;
    }
    var arrStacked = stack.get(array2);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
      return arrStacked == other && othStacked == array2;
    }
    var index2 = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$1 ? new SetCache() : void 0;
    stack.set(array2, other);
    stack.set(other, array2);
    while (++index2 < arrLength) {
      var arrValue = array2[index2], othValue = other[index2];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, arrValue, index2, other, array2, stack) : customizer(arrValue, othValue, index2, array2, other, stack);
      }
      if (compared !== void 0) {
        if (compared) {
          continue;
        }
        result = false;
        break;
      }
      if (seen) {
        if (!arraySome(other, function(othValue2, othIndex) {
          if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
            return seen.push(othIndex);
          }
        })) {
          result = false;
          break;
        }
      } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
        result = false;
        break;
      }
    }
    stack["delete"](array2);
    stack["delete"](other);
    return result;
  }
  var _equalArrays = equalArrays$2;
  var root$c = _root$1;
  var Uint8Array$3 = root$c.Uint8Array;
  var _Uint8Array = Uint8Array$3;
  function mapToArray$1(map2) {
    var index2 = -1, result = Array(map2.size);
    map2.forEach(function(value, key) {
      result[++index2] = [key, value];
    });
    return result;
  }
  var _mapToArray = mapToArray$1;
  function setToArray$1(set2) {
    var index2 = -1, result = Array(set2.size);
    set2.forEach(function(value) {
      result[++index2] = value;
    });
    return result;
  }
  var _setToArray = setToArray$1;
  var Symbol$3 = _Symbol$1, Uint8Array$2 = _Uint8Array, eq$2 = eq_1$1, equalArrays$1 = _equalArrays, mapToArray = _mapToArray, setToArray = _setToArray;
  var COMPARE_PARTIAL_FLAG$2 = 1, COMPARE_UNORDERED_FLAG = 2;
  var boolTag$3 = "[object Boolean]", dateTag$3 = "[object Date]", errorTag$2 = "[object Error]", mapTag$5 = "[object Map]", numberTag$3 = "[object Number]", regexpTag$3 = "[object RegExp]", setTag$5 = "[object Set]", stringTag$3 = "[object String]", symbolTag$4 = "[object Symbol]";
  var arrayBufferTag$3 = "[object ArrayBuffer]", dataViewTag$4 = "[object DataView]";
  var symbolProto$3 = Symbol$3 ? Symbol$3.prototype : void 0, symbolValueOf$1 = symbolProto$3 ? symbolProto$3.valueOf : void 0;
  function equalByTag$1(object2, other, tag, bitmask, customizer, equalFunc, stack) {
    switch (tag) {
      case dataViewTag$4:
        if (object2.byteLength != other.byteLength || object2.byteOffset != other.byteOffset) {
          return false;
        }
        object2 = object2.buffer;
        other = other.buffer;
      case arrayBufferTag$3:
        if (object2.byteLength != other.byteLength || !equalFunc(new Uint8Array$2(object2), new Uint8Array$2(other))) {
          return false;
        }
        return true;
      case boolTag$3:
      case dateTag$3:
      case numberTag$3:
        return eq$2(+object2, +other);
      case errorTag$2:
        return object2.name == other.name && object2.message == other.message;
      case regexpTag$3:
      case stringTag$3:
        return object2 == other + "";
      case mapTag$5:
        var convert2 = mapToArray;
      case setTag$5:
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG$2;
        convert2 || (convert2 = setToArray);
        if (object2.size != other.size && !isPartial) {
          return false;
        }
        var stacked = stack.get(object2);
        if (stacked) {
          return stacked == other;
        }
        bitmask |= COMPARE_UNORDERED_FLAG;
        stack.set(object2, other);
        var result = equalArrays$1(convert2(object2), convert2(other), bitmask, customizer, equalFunc, stack);
        stack["delete"](object2);
        return result;
      case symbolTag$4:
        if (symbolValueOf$1) {
          return symbolValueOf$1.call(object2) == symbolValueOf$1.call(other);
        }
    }
    return false;
  }
  var _equalByTag = equalByTag$1;
  function arrayPush$2(array2, values) {
    var index2 = -1, length = values.length, offset2 = array2.length;
    while (++index2 < length) {
      array2[offset2 + index2] = values[index2];
    }
    return array2;
  }
  var _arrayPush = arrayPush$2;
  var isArray$d = Array.isArray;
  var isArray_1$1 = isArray$d;
  var arrayPush$1 = _arrayPush, isArray$c = isArray_1$1;
  function baseGetAllKeys$2(object2, keysFunc, symbolsFunc) {
    var result = keysFunc(object2);
    return isArray$c(object2) ? result : arrayPush$1(result, symbolsFunc(object2));
  }
  var _baseGetAllKeys = baseGetAllKeys$2;
  function arrayFilter$1(array2, predicate) {
    var index2 = -1, length = array2 == null ? 0 : array2.length, resIndex = 0, result = [];
    while (++index2 < length) {
      var value = array2[index2];
      if (predicate(value, index2, array2)) {
        result[resIndex++] = value;
      }
    }
    return result;
  }
  var _arrayFilter = arrayFilter$1;
  function stubArray$2() {
    return [];
  }
  var stubArray_1 = stubArray$2;
  var arrayFilter = _arrayFilter, stubArray$1 = stubArray_1;
  var objectProto$e = Object.prototype;
  var propertyIsEnumerable$1 = objectProto$e.propertyIsEnumerable;
  var nativeGetSymbols$1 = Object.getOwnPropertySymbols;
  var getSymbols$3 = !nativeGetSymbols$1 ? stubArray$1 : function(object2) {
    if (object2 == null) {
      return [];
    }
    object2 = Object(object2);
    return arrayFilter(nativeGetSymbols$1(object2), function(symbol) {
      return propertyIsEnumerable$1.call(object2, symbol);
    });
  };
  var _getSymbols = getSymbols$3;
  function baseTimes$1(n2, iteratee) {
    var index2 = -1, result = Array(n2);
    while (++index2 < n2) {
      result[index2] = iteratee(index2);
    }
    return result;
  }
  var _baseTimes = baseTimes$1;
  function isObjectLike$9(value) {
    return value != null && typeof value == "object";
  }
  var isObjectLike_1$1 = isObjectLike$9;
  var baseGetTag$4 = _baseGetTag$1, isObjectLike$8 = isObjectLike_1$1;
  var argsTag$3 = "[object Arguments]";
  function baseIsArguments$1(value) {
    return isObjectLike$8(value) && baseGetTag$4(value) == argsTag$3;
  }
  var _baseIsArguments = baseIsArguments$1;
  var baseIsArguments = _baseIsArguments, isObjectLike$7 = isObjectLike_1$1;
  var objectProto$d = Object.prototype;
  var hasOwnProperty$c = objectProto$d.hasOwnProperty;
  var propertyIsEnumerable = objectProto$d.propertyIsEnumerable;
  var isArguments$1 = baseIsArguments(function() {
    return arguments;
  }()) ? baseIsArguments : function(value) {
    return isObjectLike$7(value) && hasOwnProperty$c.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
  };
  var isArguments_1 = isArguments$1;
  var isBuffer$4 = { exports: {} };
  function stubFalse() {
    return false;
  }
  var stubFalse_1 = stubFalse;
  (function(module2, exports3) {
    var root2 = _root$1, stubFalse2 = stubFalse_1;
    var freeExports = exports3 && !exports3.nodeType && exports3;
    var freeModule = freeExports && true && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer2 = moduleExports ? root2.Buffer : void 0;
    var nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : void 0;
    var isBuffer2 = nativeIsBuffer || stubFalse2;
    module2.exports = isBuffer2;
  })(isBuffer$4, isBuffer$4.exports);
  var MAX_SAFE_INTEGER$2 = 9007199254740991;
  var reIsUint$1 = /^(?:0|[1-9]\d*)$/;
  function isIndex$2(value, length) {
    var type2 = typeof value;
    length = length == null ? MAX_SAFE_INTEGER$2 : length;
    return !!length && (type2 == "number" || type2 != "symbol" && reIsUint$1.test(value)) && (value > -1 && value % 1 == 0 && value < length);
  }
  var _isIndex$1 = isIndex$2;
  var MAX_SAFE_INTEGER$1 = 9007199254740991;
  function isLength$2(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER$1;
  }
  var isLength_1 = isLength$2;
  var baseGetTag$3 = _baseGetTag$1, isLength$1 = isLength_1, isObjectLike$6 = isObjectLike_1$1;
  var argsTag$2 = "[object Arguments]", arrayTag$2 = "[object Array]", boolTag$2 = "[object Boolean]", dateTag$2 = "[object Date]", errorTag$1 = "[object Error]", funcTag$2 = "[object Function]", mapTag$4 = "[object Map]", numberTag$2 = "[object Number]", objectTag$3 = "[object Object]", regexpTag$2 = "[object RegExp]", setTag$4 = "[object Set]", stringTag$2 = "[object String]", weakMapTag$2 = "[object WeakMap]";
  var arrayBufferTag$2 = "[object ArrayBuffer]", dataViewTag$3 = "[object DataView]", float32Tag$2 = "[object Float32Array]", float64Tag$2 = "[object Float64Array]", int8Tag$2 = "[object Int8Array]", int16Tag$2 = "[object Int16Array]", int32Tag$2 = "[object Int32Array]", uint8Tag$2 = "[object Uint8Array]", uint8ClampedTag$2 = "[object Uint8ClampedArray]", uint16Tag$2 = "[object Uint16Array]", uint32Tag$2 = "[object Uint32Array]";
  var typedArrayTags = {};
  typedArrayTags[float32Tag$2] = typedArrayTags[float64Tag$2] = typedArrayTags[int8Tag$2] = typedArrayTags[int16Tag$2] = typedArrayTags[int32Tag$2] = typedArrayTags[uint8Tag$2] = typedArrayTags[uint8ClampedTag$2] = typedArrayTags[uint16Tag$2] = typedArrayTags[uint32Tag$2] = true;
  typedArrayTags[argsTag$2] = typedArrayTags[arrayTag$2] = typedArrayTags[arrayBufferTag$2] = typedArrayTags[boolTag$2] = typedArrayTags[dataViewTag$3] = typedArrayTags[dateTag$2] = typedArrayTags[errorTag$1] = typedArrayTags[funcTag$2] = typedArrayTags[mapTag$4] = typedArrayTags[numberTag$2] = typedArrayTags[objectTag$3] = typedArrayTags[regexpTag$2] = typedArrayTags[setTag$4] = typedArrayTags[stringTag$2] = typedArrayTags[weakMapTag$2] = false;
  function baseIsTypedArray$1(value) {
    return isObjectLike$6(value) && isLength$1(value.length) && !!typedArrayTags[baseGetTag$3(value)];
  }
  var _baseIsTypedArray = baseIsTypedArray$1;
  function baseUnary$3(func) {
    return function(value) {
      return func(value);
    };
  }
  var _baseUnary = baseUnary$3;
  var _nodeUtil = { exports: {} };
  (function(module2, exports3) {
    var freeGlobal2 = _freeGlobal$1;
    var freeExports = exports3 && !exports3.nodeType && exports3;
    var freeModule = freeExports && true && module2 && !module2.nodeType && module2;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal2.process;
    var nodeUtil2 = function() {
      try {
        var types2 = freeModule && freeModule.require && freeModule.require("util").types;
        if (types2) {
          return types2;
        }
        return freeProcess && freeProcess.binding && freeProcess.binding("util");
      } catch (e3) {
      }
    }();
    module2.exports = nodeUtil2;
  })(_nodeUtil, _nodeUtil.exports);
  var baseIsTypedArray = _baseIsTypedArray, baseUnary$2 = _baseUnary, nodeUtil$2 = _nodeUtil.exports;
  var nodeIsTypedArray = nodeUtil$2 && nodeUtil$2.isTypedArray;
  var isTypedArray$2 = nodeIsTypedArray ? baseUnary$2(nodeIsTypedArray) : baseIsTypedArray;
  var isTypedArray_1 = isTypedArray$2;
  var baseTimes = _baseTimes, isArguments = isArguments_1, isArray$b = isArray_1$1, isBuffer$3 = isBuffer$4.exports, isIndex$1 = _isIndex$1, isTypedArray$1 = isTypedArray_1;
  var objectProto$c = Object.prototype;
  var hasOwnProperty$b = objectProto$c.hasOwnProperty;
  function arrayLikeKeys$2(value, inherited) {
    var isArr = isArray$b(value), isArg = !isArr && isArguments(value), isBuff = !isArr && !isArg && isBuffer$3(value), isType2 = !isArr && !isArg && !isBuff && isTypedArray$1(value), skipIndexes = isArr || isArg || isBuff || isType2, result = skipIndexes ? baseTimes(value.length, String) : [], length = result.length;
    for (var key in value) {
      if ((inherited || hasOwnProperty$b.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType2 && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex$1(key, length)))) {
        result.push(key);
      }
    }
    return result;
  }
  var _arrayLikeKeys = arrayLikeKeys$2;
  var objectProto$b = Object.prototype;
  function isPrototype$3(value) {
    var Ctor = value && value.constructor, proto2 = typeof Ctor == "function" && Ctor.prototype || objectProto$b;
    return value === proto2;
  }
  var _isPrototype = isPrototype$3;
  function overArg$2(func, transform) {
    return function(arg) {
      return func(transform(arg));
    };
  }
  var _overArg = overArg$2;
  var overArg$1 = _overArg;
  var nativeKeys$1 = overArg$1(Object.keys, Object);
  var _nativeKeys = nativeKeys$1;
  var isPrototype$2 = _isPrototype, nativeKeys = _nativeKeys;
  var objectProto$a = Object.prototype;
  var hasOwnProperty$a = objectProto$a.hasOwnProperty;
  function baseKeys$1(object2) {
    if (!isPrototype$2(object2)) {
      return nativeKeys(object2);
    }
    var result = [];
    for (var key in Object(object2)) {
      if (hasOwnProperty$a.call(object2, key) && key != "constructor") {
        result.push(key);
      }
    }
    return result;
  }
  var _baseKeys = baseKeys$1;
  var isFunction$2 = isFunction_1$1, isLength = isLength_1;
  function isArrayLike$3(value) {
    return value != null && isLength(value.length) && !isFunction$2(value);
  }
  var isArrayLike_1 = isArrayLike$3;
  var arrayLikeKeys$1 = _arrayLikeKeys, baseKeys = _baseKeys, isArrayLike$2 = isArrayLike_1;
  function keys$4(object2) {
    return isArrayLike$2(object2) ? arrayLikeKeys$1(object2) : baseKeys(object2);
  }
  var keys_1 = keys$4;
  var baseGetAllKeys$1 = _baseGetAllKeys, getSymbols$2 = _getSymbols, keys$3 = keys_1;
  function getAllKeys$2(object2) {
    return baseGetAllKeys$1(object2, keys$3, getSymbols$2);
  }
  var _getAllKeys = getAllKeys$2;
  var getAllKeys$1 = _getAllKeys;
  var COMPARE_PARTIAL_FLAG$1 = 1;
  var objectProto$9 = Object.prototype;
  var hasOwnProperty$9 = objectProto$9.hasOwnProperty;
  function equalObjects$1(object2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$1, objProps = getAllKeys$1(object2), objLength = objProps.length, othProps = getAllKeys$1(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
      return false;
    }
    var index2 = objLength;
    while (index2--) {
      var key = objProps[index2];
      if (!(isPartial ? key in other : hasOwnProperty$9.call(other, key))) {
        return false;
      }
    }
    var objStacked = stack.get(object2);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
      return objStacked == other && othStacked == object2;
    }
    var result = true;
    stack.set(object2, other);
    stack.set(other, object2);
    var skipCtor = isPartial;
    while (++index2 < objLength) {
      key = objProps[index2];
      var objValue = object2[key], othValue = other[key];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, objValue, key, other, object2, stack) : customizer(objValue, othValue, key, object2, other, stack);
      }
      if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
        result = false;
        break;
      }
      skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
      var objCtor = object2.constructor, othCtor = other.constructor;
      if (objCtor != othCtor && ("constructor" in object2 && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
        result = false;
      }
    }
    stack["delete"](object2);
    stack["delete"](other);
    return result;
  }
  var _equalObjects = equalObjects$1;
  var getNative$5 = _getNative$1, root$b = _root$1;
  var DataView$2 = getNative$5(root$b, "DataView");
  var _DataView = DataView$2;
  var getNative$4 = _getNative$1, root$a = _root$1;
  var Promise$3 = getNative$4(root$a, "Promise");
  var _Promise = Promise$3;
  var getNative$3 = _getNative$1, root$9 = _root$1;
  var Set$3 = getNative$3(root$9, "Set");
  var _Set = Set$3;
  var getNative$2 = _getNative$1, root$8 = _root$1;
  var WeakMap$3 = getNative$2(root$8, "WeakMap");
  var _WeakMap = WeakMap$3;
  var DataView$1 = _DataView, Map$3 = _Map$1, Promise$2 = _Promise, Set$2 = _Set, WeakMap$2 = _WeakMap, baseGetTag$2 = _baseGetTag$1, toSource$1 = _toSource$1;
  var mapTag$3 = "[object Map]", objectTag$2 = "[object Object]", promiseTag = "[object Promise]", setTag$3 = "[object Set]", weakMapTag$1 = "[object WeakMap]";
  var dataViewTag$2 = "[object DataView]";
  var dataViewCtorString = toSource$1(DataView$1), mapCtorString = toSource$1(Map$3), promiseCtorString = toSource$1(Promise$2), setCtorString = toSource$1(Set$2), weakMapCtorString = toSource$1(WeakMap$2);
  var getTag$4 = baseGetTag$2;
  if (DataView$1 && getTag$4(new DataView$1(new ArrayBuffer(1))) != dataViewTag$2 || Map$3 && getTag$4(new Map$3()) != mapTag$3 || Promise$2 && getTag$4(Promise$2.resolve()) != promiseTag || Set$2 && getTag$4(new Set$2()) != setTag$3 || WeakMap$2 && getTag$4(new WeakMap$2()) != weakMapTag$1) {
    getTag$4 = function(value) {
      var result = baseGetTag$2(value), Ctor = result == objectTag$2 ? value.constructor : void 0, ctorString = Ctor ? toSource$1(Ctor) : "";
      if (ctorString) {
        switch (ctorString) {
          case dataViewCtorString:
            return dataViewTag$2;
          case mapCtorString:
            return mapTag$3;
          case promiseCtorString:
            return promiseTag;
          case setCtorString:
            return setTag$3;
          case weakMapCtorString:
            return weakMapTag$1;
        }
      }
      return result;
    };
  }
  var _getTag = getTag$4;
  var Stack$4 = _Stack, equalArrays = _equalArrays, equalByTag = _equalByTag, equalObjects = _equalObjects, getTag$3 = _getTag, isArray$a = isArray_1$1, isBuffer$2 = isBuffer$4.exports, isTypedArray = isTypedArray_1;
  var COMPARE_PARTIAL_FLAG = 1;
  var argsTag$1 = "[object Arguments]", arrayTag$1 = "[object Array]", objectTag$1 = "[object Object]";
  var objectProto$8 = Object.prototype;
  var hasOwnProperty$8 = objectProto$8.hasOwnProperty;
  function baseIsEqualDeep$1(object2, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = isArray$a(object2), othIsArr = isArray$a(other), objTag = objIsArr ? arrayTag$1 : getTag$3(object2), othTag = othIsArr ? arrayTag$1 : getTag$3(other);
    objTag = objTag == argsTag$1 ? objectTag$1 : objTag;
    othTag = othTag == argsTag$1 ? objectTag$1 : othTag;
    var objIsObj = objTag == objectTag$1, othIsObj = othTag == objectTag$1, isSameTag = objTag == othTag;
    if (isSameTag && isBuffer$2(object2)) {
      if (!isBuffer$2(other)) {
        return false;
      }
      objIsArr = true;
      objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
      stack || (stack = new Stack$4());
      return objIsArr || isTypedArray(object2) ? equalArrays(object2, other, bitmask, customizer, equalFunc, stack) : equalByTag(object2, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
      var objIsWrapped = objIsObj && hasOwnProperty$8.call(object2, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty$8.call(other, "__wrapped__");
      if (objIsWrapped || othIsWrapped) {
        var objUnwrapped = objIsWrapped ? object2.value() : object2, othUnwrapped = othIsWrapped ? other.value() : other;
        stack || (stack = new Stack$4());
        return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
      }
    }
    if (!isSameTag) {
      return false;
    }
    stack || (stack = new Stack$4());
    return equalObjects(object2, other, bitmask, customizer, equalFunc, stack);
  }
  var _baseIsEqualDeep = baseIsEqualDeep$1;
  var baseIsEqualDeep = _baseIsEqualDeep, isObjectLike$5 = isObjectLike_1$1;
  function baseIsEqual$1(value, other, bitmask, customizer, stack) {
    if (value === other) {
      return true;
    }
    if (value == null || other == null || !isObjectLike$5(value) && !isObjectLike$5(other)) {
      return value !== value && other !== other;
    }
    return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual$1, stack);
  }
  var _baseIsEqual = baseIsEqual$1;
  var baseIsEqual = _baseIsEqual;
  function isEqual$4(value, other) {
    return baseIsEqual(value, other);
  }
  var isEqual_1 = isEqual$4;
  function useDeepCompare(value) {
    const ref2 = React.useRef();
    if (!isEqual_1(value, ref2.current)) {
      ref2.current = value;
    }
    return ref2.current;
  }
  function useDimensions(liveMeasure = true) {
    const [dimensions2, setDimensions] = React.useState({});
    const [node2, setNode2] = React.useState(null);
    const ref2 = React.useCallback((_node) => {
      setNode2(_node);
    }, []);
    React.useLayoutEffect(() => {
      if (node2) {
        const measure = () => window.requestAnimationFrame(() => setDimensions(node2.getBoundingClientRect()));
        measure();
        if (liveMeasure) {
          window.addEventListener("resize", measure);
          window.addEventListener("scroll", measure);
          return () => {
            window.removeEventListener("resize", measure);
            window.removeEventListener("scroll", measure);
          };
        }
      }
    }, [liveMeasure, node2]);
    return [ref2, dimensions2, node2];
  }
  var root$7 = _root$1;
  var now$4 = function() {
    return root$7.Date.now();
  };
  var now_1$1 = now$4;
  var reWhitespace$1 = /\s/;
  function trimmedEndIndex$2(string2) {
    var index2 = string2.length;
    while (index2-- && reWhitespace$1.test(string2.charAt(index2))) {
    }
    return index2;
  }
  var _trimmedEndIndex$1 = trimmedEndIndex$2;
  var trimmedEndIndex$1 = _trimmedEndIndex$1;
  var reTrimStart$1 = /^\s+/;
  function baseTrim$2(string2) {
    return string2 ? string2.slice(0, trimmedEndIndex$1(string2) + 1).replace(reTrimStart$1, "") : string2;
  }
  var _baseTrim$1 = baseTrim$2;
  var baseGetTag$1 = _baseGetTag$1, isObjectLike$4 = isObjectLike_1$1;
  var symbolTag$3 = "[object Symbol]";
  function isSymbol$4(value) {
    return typeof value == "symbol" || isObjectLike$4(value) && baseGetTag$1(value) == symbolTag$3;
  }
  var isSymbol_1$1 = isSymbol$4;
  var baseTrim$1 = _baseTrim$1, isObject$7 = isObject_1$1, isSymbol$3 = isSymbol_1$1;
  var NAN$1 = 0 / 0;
  var reIsBadHex$1 = /^[-+]0x[0-9a-f]+$/i;
  var reIsBinary$1 = /^0b[01]+$/i;
  var reIsOctal$1 = /^0o[0-7]+$/i;
  var freeParseInt$1 = parseInt;
  function toNumber$4(value) {
    if (typeof value == "number") {
      return value;
    }
    if (isSymbol$3(value)) {
      return NAN$1;
    }
    if (isObject$7(value)) {
      var other = typeof value.valueOf == "function" ? value.valueOf() : value;
      value = isObject$7(other) ? other + "" : other;
    }
    if (typeof value != "string") {
      return value === 0 ? value : +value;
    }
    value = baseTrim$1(value);
    var isBinary = reIsBinary$1.test(value);
    return isBinary || reIsOctal$1.test(value) ? freeParseInt$1(value.slice(2), isBinary ? 2 : 8) : reIsBadHex$1.test(value) ? NAN$1 : +value;
  }
  var toNumber_1$1 = toNumber$4;
  var isObject$6 = isObject_1$1, now$3 = now_1$1, toNumber$3 = toNumber_1$1;
  var FUNC_ERROR_TEXT$3 = "Expected a function";
  var nativeMax$1 = Math.max, nativeMin$2 = Math.min;
  function debounce$6(func, wait, options) {
    var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
    if (typeof func != "function") {
      throw new TypeError(FUNC_ERROR_TEXT$3);
    }
    wait = toNumber$3(wait) || 0;
    if (isObject$6(options)) {
      leading = !!options.leading;
      maxing = "maxWait" in options;
      maxWait = maxing ? nativeMax$1(toNumber$3(options.maxWait) || 0, wait) : maxWait;
      trailing = "trailing" in options ? !!options.trailing : trailing;
    }
    function invokeFunc(time) {
      var args = lastArgs, thisArg = lastThis;
      lastArgs = lastThis = void 0;
      lastInvokeTime = time;
      result = func.apply(thisArg, args);
      return result;
    }
    function leadingEdge(time) {
      lastInvokeTime = time;
      timerId = setTimeout(timerExpired, wait);
      return leading ? invokeFunc(time) : result;
    }
    function remainingWait(time) {
      var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
      return maxing ? nativeMin$2(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
    }
    function shouldInvoke(time) {
      var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
      return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
    }
    function timerExpired() {
      var time = now$3();
      if (shouldInvoke(time)) {
        return trailingEdge(time);
      }
      timerId = setTimeout(timerExpired, remainingWait(time));
    }
    function trailingEdge(time) {
      timerId = void 0;
      if (trailing && lastArgs) {
        return invokeFunc(time);
      }
      lastArgs = lastThis = void 0;
      return result;
    }
    function cancel() {
      if (timerId !== void 0) {
        clearTimeout(timerId);
      }
      lastInvokeTime = 0;
      lastArgs = lastCallTime = lastThis = timerId = void 0;
    }
    function flush() {
      return timerId === void 0 ? result : trailingEdge(now$3());
    }
    function debounced() {
      var time = now$3(), isInvoking = shouldInvoke(time);
      lastArgs = arguments;
      lastThis = this;
      lastCallTime = time;
      if (isInvoking) {
        if (timerId === void 0) {
          return leadingEdge(lastCallTime);
        }
        if (maxing) {
          clearTimeout(timerId);
          timerId = setTimeout(timerExpired, wait);
          return invokeFunc(lastCallTime);
        }
      }
      if (timerId === void 0) {
        timerId = setTimeout(timerExpired, wait);
      }
      return result;
    }
    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
  }
  var debounce_1$1 = debounce$6;
  var debounce$5 = debounce_1$1, isObject$5 = isObject_1$1;
  var FUNC_ERROR_TEXT$2 = "Expected a function";
  function throttle(func, wait, options) {
    var leading = true, trailing = true;
    if (typeof func != "function") {
      throw new TypeError(FUNC_ERROR_TEXT$2);
    }
    if (isObject$5(options)) {
      leading = "leading" in options ? !!options.leading : leading;
      trailing = "trailing" in options ? !!options.trailing : trailing;
    }
    return debounce$5(func, wait, {
      "leading": leading,
      "maxWait": wait,
      "trailing": trailing
    });
  }
  var throttle_1 = throttle;
  function useThrottle(cb, delay, options) {
    const cbRef = React.useRef(cb);
    React.useEffect(() => {
      cbRef.current = cb;
    });
    return React.useCallback(throttle_1((...args) => cbRef.current(...args), delay, options), [delay, options]);
  }
  function useThrottledState(initialValue, delay, options = { leading: false, trailing: true }) {
    const [value, setValue] = React.useState(initialValue);
    const throttledSetValue = useThrottle(setValue, delay, options);
    return [value, throttledSetValue, setValue];
  }
  var e10 = Math.sqrt(50), e5 = Math.sqrt(10), e2 = Math.sqrt(2);
  function ticks(start2, stop, count2) {
    var reverse, i2 = -1, n2, ticks2, step2;
    stop = +stop, start2 = +start2, count2 = +count2;
    if (start2 === stop && count2 > 0)
      return [start2];
    if (reverse = stop < start2)
      n2 = start2, start2 = stop, stop = n2;
    if ((step2 = tickIncrement(start2, stop, count2)) === 0 || !isFinite(step2))
      return [];
    if (step2 > 0) {
      let r0 = Math.round(start2 / step2), r1 = Math.round(stop / step2);
      if (r0 * step2 < start2)
        ++r0;
      if (r1 * step2 > stop)
        --r1;
      ticks2 = new Array(n2 = r1 - r0 + 1);
      while (++i2 < n2)
        ticks2[i2] = (r0 + i2) * step2;
    } else {
      step2 = -step2;
      let r0 = Math.round(start2 * step2), r1 = Math.round(stop * step2);
      if (r0 / step2 < start2)
        ++r0;
      if (r1 / step2 > stop)
        --r1;
      ticks2 = new Array(n2 = r1 - r0 + 1);
      while (++i2 < n2)
        ticks2[i2] = (r0 + i2) / step2;
    }
    if (reverse)
      ticks2.reverse();
    return ticks2;
  }
  function tickIncrement(start2, stop, count2) {
    var step2 = (stop - start2) / Math.max(0, count2), power = Math.floor(Math.log(step2) / Math.LN10), error2 = step2 / Math.pow(10, power);
    return power >= 0 ? (error2 >= e10 ? 10 : error2 >= e5 ? 5 : error2 >= e2 ? 2 : 1) * Math.pow(10, power) : -Math.pow(10, -power) / (error2 >= e10 ? 10 : error2 >= e5 ? 5 : error2 >= e2 ? 2 : 1);
  }
  function useIntersectionObserver(ref2, rootMargin = "0px", threshold = 1) {
    const [isIntersecting, setIntersecting] = React.useState(false);
    React.useEffect(() => {
      const observer = new IntersectionObserver(([entry]) => setIntersecting(entry.isIntersecting), {
        rootMargin,
        threshold
      });
      if (ref2.current) {
        observer.observe(ref2.current);
      }
      const currentRef = ref2.current;
      return () => {
        if (currentRef) {
          observer.unobserve(currentRef);
        } else {
          observer.disconnect();
        }
      };
    }, [ref2, rootMargin, threshold]);
    return isIntersecting;
  }
  function useOnClickOutside(element2, handler) {
    React.useEffect(() => {
      const listener2 = (event2) => {
        if (!element2 || element2.contains(event2.target)) {
          return;
        }
        handler();
      };
      document.addEventListener("mousedown", listener2);
      document.addEventListener("touchstart", listener2);
      return () => {
        document.removeEventListener("mousedown", listener2);
        document.removeEventListener("touchstart", listener2);
      };
    }, [element2, handler]);
  }
  const useUpdateEffect = (effect2, deps) => {
    const isMounted = React.useRef(false);
    React.useEffect(() => {
      if (!isMounted.current) {
        isMounted.current = true;
        return;
      }
      return effect2();
    }, deps);
  };
  var __awaiter$4 = globalThis && globalThis.__awaiter || function(thisArg, _arguments, P2, generator) {
    function adopt(value) {
      return value instanceof P2 ? value : new P2(function(resolve2) {
        resolve2(value);
      });
    }
    return new (P2 || (P2 = Promise))(function(resolve2, reject) {
      function fulfilled(value) {
        try {
          step2(generator.next(value));
        } catch (e3) {
          reject(e3);
        }
      }
      function rejected(value) {
        try {
          step2(generator["throw"](value));
        } catch (e3) {
          reject(e3);
        }
      }
      function step2(result) {
        result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
      }
      step2((generator = generator.apply(thisArg, _arguments || [])).next());
    });
  };
  function useInfiniteLoader(onLoadData, onError, batchSize = 50) {
    const onLoadRef = React.useRef(onLoadData);
    const [internalData, setInternalData] = React.useState([]);
    const [itemCount, setItemCount] = React.useState(0);
    const [currentStartIdx, setStartIdx] = React.useState(0);
    const [currentStopIdx, setStopIdx] = React.useState(0);
    const [currentRange, setCurrentRange] = React.useState({
      overscanStartIndex: 0,
      overscanStopIndex: 50
    });
    const getItem = React.useCallback(
      (index2) => {
        const adjustedIndex = index2 - currentStartIdx;
        if (adjustedIndex < 0 || adjustedIndex > internalData.length) {
          return;
        }
        return internalData[adjustedIndex];
      },
      useDeepCompare([currentStartIdx, internalData])
    );
    const onItemsRendered = React.useCallback(({ overscanStartIndex, overscanStopIndex }, forceRefresh) => __awaiter$4(this, void 0, void 0, function* () {
      try {
        const isFirstItemLoaded = overscanStartIndex >= currentStartIdx && overscanStartIndex <= currentStopIdx;
        const isLastItemLoaded = overscanStopIndex >= currentStartIdx && overscanStopIndex <= currentStopIdx;
        setCurrentRange({ overscanStartIndex, overscanStopIndex });
        if (isFirstItemLoaded && isLastItemLoaded && !forceRefresh) {
          return;
        }
        if (isFirstItemLoaded === isLastItemLoaded) {
          const mid = Math.floor((overscanStopIndex - overscanStartIndex) / 2 + overscanStartIndex);
          const start2 = Math.max(mid - batchSize / 2, 0);
          const end3 = mid + batchSize / 2;
          setStartIdx(start2);
          setStopIdx(end3);
          const { data: data3, totalCount: totalCount2 } = yield onLoadRef.current(start2, end3);
          setInternalData(data3);
          setItemCount(totalCount2);
          return;
        }
        if (!isFirstItemLoaded) {
          const start2 = Math.max(currentStartIdx - batchSize, 0);
          const res2 = onLoadRef.current(start2, currentStartIdx);
          setStartIdx(start2);
          const { data: data3, totalCount: totalCount2 } = yield res2;
          setInternalData((current2) => [...data3, ...current2]);
          setItemCount(totalCount2);
          return;
        }
        const end2 = currentStopIdx + batchSize;
        const res = onLoadRef.current(currentStopIdx, end2);
        setStopIdx(end2);
        const { data: data2, totalCount } = yield res;
        setInternalData((current2) => [...current2, ...data2]);
        setItemCount(totalCount);
      } catch (err) {
        onError === null || onError === void 0 ? void 0 : onError(err);
      }
    }), [batchSize, currentStartIdx, currentStopIdx, onError]);
    React.useEffect(() => {
      onLoadRef.current = onLoadData;
      onItemsRendered(currentRange, true);
    }, [onLoadData]);
    const refresh = React.useCallback(
      () => {
        onItemsRendered(currentRange, true);
      },
      useDeepCompare([currentRange])
    );
    return {
      getItem,
      itemCount,
      onItemsRendered,
      refresh
    };
  }
  function getNodeName$1(node2) {
    if (isNode(node2)) {
      return (node2.nodeName || "").toLowerCase();
    }
    return "#document";
  }
  function getWindow$1(node2) {
    var _node$ownerDocument;
    return (node2 == null || (_node$ownerDocument = node2.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
  }
  function getDocumentElement$1(node2) {
    var _ref2;
    return (_ref2 = (isNode(node2) ? node2.ownerDocument : node2.document) || window.document) == null ? void 0 : _ref2.documentElement;
  }
  function isNode(value) {
    return value instanceof Node || value instanceof getWindow$1(value).Node;
  }
  function isElement$4(value) {
    return value instanceof Element || value instanceof getWindow$1(value).Element;
  }
  function isHTMLElement$1(value) {
    return value instanceof HTMLElement || value instanceof getWindow$1(value).HTMLElement;
  }
  function isShadowRoot$1(value) {
    if (typeof ShadowRoot === "undefined") {
      return false;
    }
    return value instanceof ShadowRoot || value instanceof getWindow$1(value).ShadowRoot;
  }
  function isOverflowElement(element2) {
    const {
      overflow,
      overflowX,
      overflowY,
      display
    } = getComputedStyle$2(element2);
    return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !["inline", "contents"].includes(display);
  }
  function isTableElement$1(element2) {
    return ["table", "td", "th"].includes(getNodeName$1(element2));
  }
  function isContainingBlock(element2) {
    const webkit2 = isWebKit();
    const css2 = getComputedStyle$2(element2);
    return css2.transform !== "none" || css2.perspective !== "none" || (css2.containerType ? css2.containerType !== "normal" : false) || !webkit2 && (css2.backdropFilter ? css2.backdropFilter !== "none" : false) || !webkit2 && (css2.filter ? css2.filter !== "none" : false) || ["transform", "perspective", "filter"].some((value) => (css2.willChange || "").includes(value)) || ["paint", "layout", "strict", "content"].some((value) => (css2.contain || "").includes(value));
  }
  function getContainingBlock$1(element2) {
    let currentNode = getParentNode$1(element2);
    while (isHTMLElement$1(currentNode) && !isLastTraversableNode(currentNode)) {
      if (isContainingBlock(currentNode)) {
        return currentNode;
      }
      currentNode = getParentNode$1(currentNode);
    }
    return null;
  }
  function isWebKit() {
    if (typeof CSS === "undefined" || !CSS.supports)
      return false;
    return CSS.supports("-webkit-backdrop-filter", "none");
  }
  function isLastTraversableNode(node2) {
    return ["html", "body", "#document"].includes(getNodeName$1(node2));
  }
  function getComputedStyle$2(element2) {
    return getWindow$1(element2).getComputedStyle(element2);
  }
  function getNodeScroll$1(element2) {
    if (isElement$4(element2)) {
      return {
        scrollLeft: element2.scrollLeft,
        scrollTop: element2.scrollTop
      };
    }
    return {
      scrollLeft: element2.pageXOffset,
      scrollTop: element2.pageYOffset
    };
  }
  function getParentNode$1(node2) {
    if (getNodeName$1(node2) === "html") {
      return node2;
    }
    const result = node2.assignedSlot || node2.parentNode || isShadowRoot$1(node2) && node2.host || getDocumentElement$1(node2);
    return isShadowRoot$1(result) ? result.host : result;
  }
  function getNearestOverflowAncestor(node2) {
    const parentNode = getParentNode$1(node2);
    if (isLastTraversableNode(parentNode)) {
      return node2.ownerDocument ? node2.ownerDocument.body : node2.body;
    }
    if (isHTMLElement$1(parentNode) && isOverflowElement(parentNode)) {
      return parentNode;
    }
    return getNearestOverflowAncestor(parentNode);
  }
  function getOverflowAncestors(node2, list2, traverseIframes) {
    var _node$ownerDocument2;
    if (list2 === void 0) {
      list2 = [];
    }
    if (traverseIframes === void 0) {
      traverseIframes = true;
    }
    const scrollableAncestor = getNearestOverflowAncestor(node2);
    const isBody = scrollableAncestor === ((_node$ownerDocument2 = node2.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
    const win = getWindow$1(scrollableAncestor);
    if (isBody) {
      return list2.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], win.frameElement && traverseIframes ? getOverflowAncestors(win.frameElement) : []);
    }
    return list2.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
  }
  function contains$2(parent, child) {
    if (!parent || !child) {
      return false;
    }
    const rootNode = child.getRootNode == null ? void 0 : child.getRootNode();
    if (parent.contains(child)) {
      return true;
    }
    if (rootNode && isShadowRoot$1(rootNode)) {
      let next2 = child;
      while (next2) {
        if (parent === next2) {
          return true;
        }
        next2 = next2.parentNode || next2.host;
      }
    }
    return false;
  }
  function isMouseLikePointerType(pointerType, strict) {
    const values = ["mouse", "pen"];
    if (!strict) {
      values.push("", void 0);
    }
    return values.includes(pointerType);
  }
  function isReactEvent(event2) {
    return "nativeEvent" in event2;
  }
  function isRootElement(element2) {
    return element2.matches("html,body");
  }
  function getDocument(node2) {
    return (node2 == null ? void 0 : node2.ownerDocument) || document;
  }
  function isEventTargetWithin(event2, node2) {
    if (node2 == null) {
      return false;
    }
    if ("composedPath" in event2) {
      return event2.composedPath().includes(node2);
    }
    const e3 = event2;
    return e3.target != null && node2.contains(e3.target);
  }
  function getTarget(event2) {
    if ("composedPath" in event2) {
      return event2.composedPath()[0];
    }
    return event2.target;
  }
  const TYPEABLE_SELECTOR = "input:not([type='hidden']):not([disabled]),[contenteditable]:not([contenteditable='false']),textarea:not([disabled])";
  function isTypeableElement(element2) {
    return isHTMLElement$1(element2) && element2.matches(TYPEABLE_SELECTOR);
  }
  const sides = ["top", "right", "bottom", "left"];
  const alignments = ["start", "end"];
  const placements$1 = /* @__PURE__ */ sides.reduce((acc, side) => acc.concat(side, side + "-" + alignments[0], side + "-" + alignments[1]), []);
  const min$3 = Math.min;
  const max$4 = Math.max;
  const round$3 = Math.round;
  const floor = Math.floor;
  const createCoords = (v3) => ({
    x: v3,
    y: v3
  });
  const oppositeSideMap = {
    left: "right",
    right: "left",
    bottom: "top",
    top: "bottom"
  };
  const oppositeAlignmentMap = {
    start: "end",
    end: "start"
  };
  function clamp$1(start2, value, end2) {
    return max$4(start2, min$3(value, end2));
  }
  function evaluate(value, param) {
    return typeof value === "function" ? value(param) : value;
  }
  function getSide(placement) {
    return placement.split("-")[0];
  }
  function getAlignment(placement) {
    return placement.split("-")[1];
  }
  function getOppositeAxis(axis) {
    return axis === "x" ? "y" : "x";
  }
  function getAxisLength(axis) {
    return axis === "y" ? "height" : "width";
  }
  function getSideAxis(placement) {
    return ["top", "bottom"].includes(getSide(placement)) ? "y" : "x";
  }
  function getAlignmentAxis(placement) {
    return getOppositeAxis(getSideAxis(placement));
  }
  function getAlignmentSides(placement, rects, rtl) {
    if (rtl === void 0) {
      rtl = false;
    }
    const alignment = getAlignment(placement);
    const alignmentAxis = getAlignmentAxis(placement);
    const length = getAxisLength(alignmentAxis);
    let mainAlignmentSide = alignmentAxis === "x" ? alignment === (rtl ? "end" : "start") ? "right" : "left" : alignment === "start" ? "bottom" : "top";
    if (rects.reference[length] > rects.floating[length]) {
      mainAlignmentSide = getOppositePlacement$1(mainAlignmentSide);
    }
    return [mainAlignmentSide, getOppositePlacement$1(mainAlignmentSide)];
  }
  function getExpandedPlacements(placement) {
    const oppositePlacement = getOppositePlacement$1(placement);
    return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
  }
  function getOppositeAlignmentPlacement(placement) {
    return placement.replace(/start|end/g, (alignment) => oppositeAlignmentMap[alignment]);
  }
  function getSideList(side, isStart, rtl) {
    const lr2 = ["left", "right"];
    const rl = ["right", "left"];
    const tb = ["top", "bottom"];
    const bt2 = ["bottom", "top"];
    switch (side) {
      case "top":
      case "bottom":
        if (rtl)
          return isStart ? rl : lr2;
        return isStart ? lr2 : rl;
      case "left":
      case "right":
        return isStart ? tb : bt2;
      default:
        return [];
    }
  }
  function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
    const alignment = getAlignment(placement);
    let list2 = getSideList(getSide(placement), direction === "start", rtl);
    if (alignment) {
      list2 = list2.map((side) => side + "-" + alignment);
      if (flipAlignment) {
        list2 = list2.concat(list2.map(getOppositeAlignmentPlacement));
      }
    }
    return list2;
  }
  function getOppositePlacement$1(placement) {
    return placement.replace(/left|right|bottom|top/g, (side) => oppositeSideMap[side]);
  }
  function expandPaddingObject(padding) {
    return {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0,
      ...padding
    };
  }
  function getPaddingObject(padding) {
    return typeof padding !== "number" ? expandPaddingObject(padding) : {
      top: padding,
      right: padding,
      bottom: padding,
      left: padding
    };
  }
  function rectToClientRect$1(rect) {
    const {
      x: x2,
      y: y2,
      width,
      height
    } = rect;
    return {
      width,
      height,
      top: y2,
      left: x2,
      right: x2 + width,
      bottom: y2 + height,
      x: x2,
      y: y2
    };
  }
  function computeCoordsFromPlacement(_ref2, placement, rtl) {
    let {
      reference: reference2,
      floating
    } = _ref2;
    const sideAxis = getSideAxis(placement);
    const alignmentAxis = getAlignmentAxis(placement);
    const alignLength = getAxisLength(alignmentAxis);
    const side = getSide(placement);
    const isVertical = sideAxis === "y";
    const commonX = reference2.x + reference2.width / 2 - floating.width / 2;
    const commonY = reference2.y + reference2.height / 2 - floating.height / 2;
    const commonAlign = reference2[alignLength] / 2 - floating[alignLength] / 2;
    let coords;
    switch (side) {
      case "top":
        coords = {
          x: commonX,
          y: reference2.y - floating.height
        };
        break;
      case "bottom":
        coords = {
          x: commonX,
          y: reference2.y + reference2.height
        };
        break;
      case "right":
        coords = {
          x: reference2.x + reference2.width,
          y: commonY
        };
        break;
      case "left":
        coords = {
          x: reference2.x - floating.width,
          y: commonY
        };
        break;
      default:
        coords = {
          x: reference2.x,
          y: reference2.y
        };
    }
    switch (getAlignment(placement)) {
      case "start":
        coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
        break;
      case "end":
        coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
        break;
    }
    return coords;
  }
  const computePosition$1 = async (reference2, floating, config2) => {
    const {
      placement = "bottom",
      strategy = "absolute",
      middleware = [],
      platform: platform2
    } = config2;
    const validMiddleware = middleware.filter(Boolean);
    const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(floating));
    let rects = await platform2.getElementRects({
      reference: reference2,
      floating,
      strategy
    });
    let {
      x: x2,
      y: y2
    } = computeCoordsFromPlacement(rects, placement, rtl);
    let statefulPlacement = placement;
    let middlewareData = {};
    let resetCount = 0;
    for (let i2 = 0; i2 < validMiddleware.length; i2++) {
      const {
        name: name2,
        fn: fn2
      } = validMiddleware[i2];
      const {
        x: nextX,
        y: nextY,
        data: data2,
        reset: reset2
      } = await fn2({
        x: x2,
        y: y2,
        initialPlacement: placement,
        placement: statefulPlacement,
        strategy,
        middlewareData,
        rects,
        platform: platform2,
        elements: {
          reference: reference2,
          floating
        }
      });
      x2 = nextX != null ? nextX : x2;
      y2 = nextY != null ? nextY : y2;
      middlewareData = {
        ...middlewareData,
        [name2]: {
          ...middlewareData[name2],
          ...data2
        }
      };
      if (reset2 && resetCount <= 50) {
        resetCount++;
        if (typeof reset2 === "object") {
          if (reset2.placement) {
            statefulPlacement = reset2.placement;
          }
          if (reset2.rects) {
            rects = reset2.rects === true ? await platform2.getElementRects({
              reference: reference2,
              floating,
              strategy
            }) : reset2.rects;
          }
          ({
            x: x2,
            y: y2
          } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
        }
        i2 = -1;
      }
    }
    return {
      x: x2,
      y: y2,
      placement: statefulPlacement,
      strategy,
      middlewareData
    };
  };
  async function detectOverflow$1(state, options) {
    var _await$platform$isEle;
    if (options === void 0) {
      options = {};
    }
    const {
      x: x2,
      y: y2,
      platform: platform2,
      rects,
      elements,
      strategy
    } = state;
    const {
      boundary = "clippingAncestors",
      rootBoundary = "viewport",
      elementContext = "floating",
      altBoundary = false,
      padding = 0
    } = evaluate(options, state);
    const paddingObject = getPaddingObject(padding);
    const altContext = elementContext === "floating" ? "reference" : "floating";
    const element2 = elements[altBoundary ? altContext : elementContext];
    const clippingClientRect = rectToClientRect$1(await platform2.getClippingRect({
      element: ((_await$platform$isEle = await (platform2.isElement == null ? void 0 : platform2.isElement(element2))) != null ? _await$platform$isEle : true) ? element2 : element2.contextElement || await (platform2.getDocumentElement == null ? void 0 : platform2.getDocumentElement(elements.floating)),
      boundary,
      rootBoundary,
      strategy
    }));
    const rect = elementContext === "floating" ? {
      x: x2,
      y: y2,
      width: rects.floating.width,
      height: rects.floating.height
    } : rects.reference;
    const offsetParent = await (platform2.getOffsetParent == null ? void 0 : platform2.getOffsetParent(elements.floating));
    const offsetScale = await (platform2.isElement == null ? void 0 : platform2.isElement(offsetParent)) ? await (platform2.getScale == null ? void 0 : platform2.getScale(offsetParent)) || {
      x: 1,
      y: 1
    } : {
      x: 1,
      y: 1
    };
    const elementClientRect = rectToClientRect$1(platform2.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform2.convertOffsetParentRelativeRectToViewportRelativeRect({
      elements,
      rect,
      offsetParent,
      strategy
    }) : rect);
    return {
      top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
      bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
      left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
      right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
    };
  }
  const arrow$2 = (options) => ({
    name: "arrow",
    options,
    async fn(state) {
      const {
        x: x2,
        y: y2,
        placement,
        rects,
        platform: platform2,
        elements,
        middlewareData
      } = state;
      const {
        element: element2,
        padding = 0
      } = evaluate(options, state) || {};
      if (element2 == null) {
        return {};
      }
      const paddingObject = getPaddingObject(padding);
      const coords = {
        x: x2,
        y: y2
      };
      const axis = getAlignmentAxis(placement);
      const length = getAxisLength(axis);
      const arrowDimensions = await platform2.getDimensions(element2);
      const isYAxis = axis === "y";
      const minProp = isYAxis ? "top" : "left";
      const maxProp = isYAxis ? "bottom" : "right";
      const clientProp = isYAxis ? "clientHeight" : "clientWidth";
      const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
      const startDiff = coords[axis] - rects.reference[axis];
      const arrowOffsetParent = await (platform2.getOffsetParent == null ? void 0 : platform2.getOffsetParent(element2));
      let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;
      if (!clientSize || !await (platform2.isElement == null ? void 0 : platform2.isElement(arrowOffsetParent))) {
        clientSize = elements.floating[clientProp] || rects.floating[length];
      }
      const centerToReference = endDiff / 2 - startDiff / 2;
      const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;
      const minPadding = min$3(paddingObject[minProp], largestPossiblePadding);
      const maxPadding = min$3(paddingObject[maxProp], largestPossiblePadding);
      const min$12 = minPadding;
      const max2 = clientSize - arrowDimensions[length] - maxPadding;
      const center2 = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
      const offset2 = clamp$1(min$12, center2, max2);
      const shouldAddOffset = !middlewareData.arrow && getAlignment(placement) != null && center2 !== offset2 && rects.reference[length] / 2 - (center2 < min$12 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;
      const alignmentOffset = shouldAddOffset ? center2 < min$12 ? center2 - min$12 : center2 - max2 : 0;
      return {
        [axis]: coords[axis] + alignmentOffset,
        data: {
          [axis]: offset2,
          centerOffset: center2 - offset2 - alignmentOffset,
          ...shouldAddOffset && {
            alignmentOffset
          }
        },
        reset: shouldAddOffset
      };
    }
  });
  function getPlacementList(alignment, autoAlignment, allowedPlacements) {
    const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter((placement) => getAlignment(placement) === alignment), ...allowedPlacements.filter((placement) => getAlignment(placement) !== alignment)] : allowedPlacements.filter((placement) => getSide(placement) === placement);
    return allowedPlacementsSortedByAlignment.filter((placement) => {
      if (alignment) {
        return getAlignment(placement) === alignment || (autoAlignment ? getOppositeAlignmentPlacement(placement) !== placement : false);
      }
      return true;
    });
  }
  const autoPlacement = function(options) {
    if (options === void 0) {
      options = {};
    }
    return {
      name: "autoPlacement",
      options,
      async fn(state) {
        var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;
        const {
          rects,
          middlewareData,
          placement,
          platform: platform2,
          elements
        } = state;
        const {
          crossAxis = false,
          alignment,
          allowedPlacements = placements$1,
          autoAlignment = true,
          ...detectOverflowOptions
        } = evaluate(options, state);
        const placements$1$1 = alignment !== void 0 || allowedPlacements === placements$1 ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;
        const overflow = await detectOverflow$1(state, detectOverflowOptions);
        const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;
        const currentPlacement = placements$1$1[currentIndex];
        if (currentPlacement == null) {
          return {};
        }
        const alignmentSides = getAlignmentSides(currentPlacement, rects, await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating)));
        if (placement !== currentPlacement) {
          return {
            reset: {
              placement: placements$1$1[0]
            }
          };
        }
        const currentOverflows = [overflow[getSide(currentPlacement)], overflow[alignmentSides[0]], overflow[alignmentSides[1]]];
        const allOverflows = [...((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || [], {
          placement: currentPlacement,
          overflows: currentOverflows
        }];
        const nextPlacement = placements$1$1[currentIndex + 1];
        if (nextPlacement) {
          return {
            data: {
              index: currentIndex + 1,
              overflows: allOverflows
            },
            reset: {
              placement: nextPlacement
            }
          };
        }
        const placementsSortedByMostSpace = allOverflows.map((d2) => {
          const alignment2 = getAlignment(d2.placement);
          return [d2.placement, alignment2 && crossAxis ? d2.overflows.slice(0, 2).reduce((acc, v3) => acc + v3, 0) : d2.overflows[0], d2.overflows];
        }).sort((a2, b2) => a2[1] - b2[1]);
        const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter((d2) => d2[2].slice(
          0,
          getAlignment(d2[0]) ? 2 : 3
        ).every((v3) => v3 <= 0));
        const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];
        if (resetPlacement !== placement) {
          return {
            data: {
              index: currentIndex + 1,
              overflows: allOverflows
            },
            reset: {
              placement: resetPlacement
            }
          };
        }
        return {};
      }
    };
  };
  const flip$4 = function(options) {
    if (options === void 0) {
      options = {};
    }
    return {
      name: "flip",
      options,
      async fn(state) {
        var _middlewareData$arrow, _middlewareData$flip;
        const {
          placement,
          middlewareData,
          rects,
          initialPlacement,
          platform: platform2,
          elements
        } = state;
        const {
          mainAxis: checkMainAxis = true,
          crossAxis: checkCrossAxis = true,
          fallbackPlacements: specifiedFallbackPlacements,
          fallbackStrategy = "bestFit",
          fallbackAxisSideDirection = "none",
          flipAlignment = true,
          ...detectOverflowOptions
        } = evaluate(options, state);
        if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
          return {};
        }
        const side = getSide(placement);
        const isBasePlacement = getSide(initialPlacement) === initialPlacement;
        const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating));
        const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [getOppositePlacement$1(initialPlacement)] : getExpandedPlacements(initialPlacement));
        if (!specifiedFallbackPlacements && fallbackAxisSideDirection !== "none") {
          fallbackPlacements.push(...getOppositeAxisPlacements(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
        }
        const placements2 = [initialPlacement, ...fallbackPlacements];
        const overflow = await detectOverflow$1(state, detectOverflowOptions);
        const overflows = [];
        let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
        if (checkMainAxis) {
          overflows.push(overflow[side]);
        }
        if (checkCrossAxis) {
          const sides2 = getAlignmentSides(placement, rects, rtl);
          overflows.push(overflow[sides2[0]], overflow[sides2[1]]);
        }
        overflowsData = [...overflowsData, {
          placement,
          overflows
        }];
        if (!overflows.every((side2) => side2 <= 0)) {
          var _middlewareData$flip2, _overflowsData$filter;
          const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
          const nextPlacement = placements2[nextIndex];
          if (nextPlacement) {
            return {
              data: {
                index: nextIndex,
                overflows: overflowsData
              },
              reset: {
                placement: nextPlacement
              }
            };
          }
          let resetPlacement = (_overflowsData$filter = overflowsData.filter((d2) => d2.overflows[0] <= 0).sort((a2, b2) => a2.overflows[1] - b2.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;
          if (!resetPlacement) {
            switch (fallbackStrategy) {
              case "bestFit": {
                var _overflowsData$map$so;
                const placement2 = (_overflowsData$map$so = overflowsData.map((d2) => [d2.placement, d2.overflows.filter((overflow2) => overflow2 > 0).reduce((acc, overflow2) => acc + overflow2, 0)]).sort((a2, b2) => a2[1] - b2[1])[0]) == null ? void 0 : _overflowsData$map$so[0];
                if (placement2) {
                  resetPlacement = placement2;
                }
                break;
              }
              case "initialPlacement":
                resetPlacement = initialPlacement;
                break;
            }
          }
          if (placement !== resetPlacement) {
            return {
              reset: {
                placement: resetPlacement
              }
            };
          }
        }
        return {};
      }
    };
  };
  function getSideOffsets$1(overflow, rect) {
    return {
      top: overflow.top - rect.height,
      right: overflow.right - rect.width,
      bottom: overflow.bottom - rect.height,
      left: overflow.left - rect.width
    };
  }
  function isAnySideFullyClipped$1(overflow) {
    return sides.some((side) => overflow[side] >= 0);
  }
  const hide$2 = function(options) {
    if (options === void 0) {
      options = {};
    }
    return {
      name: "hide",
      options,
      async fn(state) {
        const {
          rects
        } = state;
        const {
          strategy = "referenceHidden",
          ...detectOverflowOptions
        } = evaluate(options, state);
        switch (strategy) {
          case "referenceHidden": {
            const overflow = await detectOverflow$1(state, {
              ...detectOverflowOptions,
              elementContext: "reference"
            });
            const offsets = getSideOffsets$1(overflow, rects.reference);
            return {
              data: {
                referenceHiddenOffsets: offsets,
                referenceHidden: isAnySideFullyClipped$1(offsets)
              }
            };
          }
          case "escaped": {
            const overflow = await detectOverflow$1(state, {
              ...detectOverflowOptions,
              altBoundary: true
            });
            const offsets = getSideOffsets$1(overflow, rects.floating);
            return {
              data: {
                escapedOffsets: offsets,
                escaped: isAnySideFullyClipped$1(offsets)
              }
            };
          }
          default: {
            return {};
          }
        }
      }
    };
  };
  function getBoundingRect(rects) {
    const minX = min$3(...rects.map((rect) => rect.left));
    const minY = min$3(...rects.map((rect) => rect.top));
    const maxX = max$4(...rects.map((rect) => rect.right));
    const maxY = max$4(...rects.map((rect) => rect.bottom));
    return {
      x: minX,
      y: minY,
      width: maxX - minX,
      height: maxY - minY
    };
  }
  function getRectsByLine(rects) {
    const sortedRects = rects.slice().sort((a2, b2) => a2.y - b2.y);
    const groups = [];
    let prevRect = null;
    for (let i2 = 0; i2 < sortedRects.length; i2++) {
      const rect = sortedRects[i2];
      if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
        groups.push([rect]);
      } else {
        groups[groups.length - 1].push(rect);
      }
      prevRect = rect;
    }
    return groups.map((rect) => rectToClientRect$1(getBoundingRect(rect)));
  }
  const inline = function(options) {
    if (options === void 0) {
      options = {};
    }
    return {
      name: "inline",
      options,
      async fn(state) {
        const {
          placement,
          elements,
          rects,
          platform: platform2,
          strategy
        } = state;
        const {
          padding = 2,
          x: x2,
          y: y2
        } = evaluate(options, state);
        const nativeClientRects = Array.from(await (platform2.getClientRects == null ? void 0 : platform2.getClientRects(elements.reference)) || []);
        const clientRects = getRectsByLine(nativeClientRects);
        const fallback = rectToClientRect$1(getBoundingRect(nativeClientRects));
        const paddingObject = getPaddingObject(padding);
        function getBoundingClientRect2() {
          if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x2 != null && y2 != null) {
            return clientRects.find((rect) => x2 > rect.left - paddingObject.left && x2 < rect.right + paddingObject.right && y2 > rect.top - paddingObject.top && y2 < rect.bottom + paddingObject.bottom) || fallback;
          }
          if (clientRects.length >= 2) {
            if (getSideAxis(placement) === "y") {
              const firstRect = clientRects[0];
              const lastRect = clientRects[clientRects.length - 1];
              const isTop = getSide(placement) === "top";
              const top3 = firstRect.top;
              const bottom3 = lastRect.bottom;
              const left3 = isTop ? firstRect.left : lastRect.left;
              const right3 = isTop ? firstRect.right : lastRect.right;
              const width2 = right3 - left3;
              const height2 = bottom3 - top3;
              return {
                top: top3,
                bottom: bottom3,
                left: left3,
                right: right3,
                width: width2,
                height: height2,
                x: left3,
                y: top3
              };
            }
            const isLeftSide = getSide(placement) === "left";
            const maxRight = max$4(...clientRects.map((rect) => rect.right));
            const minLeft = min$3(...clientRects.map((rect) => rect.left));
            const measureRects = clientRects.filter((rect) => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
            const top2 = measureRects[0].top;
            const bottom2 = measureRects[measureRects.length - 1].bottom;
            const left2 = minLeft;
            const right2 = maxRight;
            const width = right2 - left2;
            const height = bottom2 - top2;
            return {
              top: top2,
              bottom: bottom2,
              left: left2,
              right: right2,
              width,
              height,
              x: left2,
              y: top2
            };
          }
          return fallback;
        }
        const resetRects = await platform2.getElementRects({
          reference: {
            getBoundingClientRect: getBoundingClientRect2
          },
          floating: elements.floating,
          strategy
        });
        if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
          return {
            reset: {
              rects: resetRects
            }
          };
        }
        return {};
      }
    };
  };
  async function convertValueToCoords(state, options) {
    const {
      placement,
      platform: platform2,
      elements
    } = state;
    const rtl = await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating));
    const side = getSide(placement);
    const alignment = getAlignment(placement);
    const isVertical = getSideAxis(placement) === "y";
    const mainAxisMulti = ["left", "top"].includes(side) ? -1 : 1;
    const crossAxisMulti = rtl && isVertical ? -1 : 1;
    const rawValue = evaluate(options, state);
    let {
      mainAxis,
      crossAxis,
      alignmentAxis
    } = typeof rawValue === "number" ? {
      mainAxis: rawValue,
      crossAxis: 0,
      alignmentAxis: null
    } : {
      mainAxis: 0,
      crossAxis: 0,
      alignmentAxis: null,
      ...rawValue
    };
    if (alignment && typeof alignmentAxis === "number") {
      crossAxis = alignment === "end" ? alignmentAxis * -1 : alignmentAxis;
    }
    return isVertical ? {
      x: crossAxis * crossAxisMulti,
      y: mainAxis * mainAxisMulti
    } : {
      x: mainAxis * mainAxisMulti,
      y: crossAxis * crossAxisMulti
    };
  }
  const offset$4 = function(options) {
    if (options === void 0) {
      options = 0;
    }
    return {
      name: "offset",
      options,
      async fn(state) {
        var _middlewareData$offse, _middlewareData$arrow;
        const {
          x: x2,
          y: y2,
          placement,
          middlewareData
        } = state;
        const diffCoords = await convertValueToCoords(state, options);
        if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
          return {};
        }
        return {
          x: x2 + diffCoords.x,
          y: y2 + diffCoords.y,
          data: {
            ...diffCoords,
            placement
          }
        };
      }
    };
  };
  const shift$3 = function(options) {
    if (options === void 0) {
      options = {};
    }
    return {
      name: "shift",
      options,
      async fn(state) {
        const {
          x: x2,
          y: y2,
          placement
        } = state;
        const {
          mainAxis: checkMainAxis = true,
          crossAxis: checkCrossAxis = false,
          limiter = {
            fn: (_ref2) => {
              let {
                x: x3,
                y: y3
              } = _ref2;
              return {
                x: x3,
                y: y3
              };
            }
          },
          ...detectOverflowOptions
        } = evaluate(options, state);
        const coords = {
          x: x2,
          y: y2
        };
        const overflow = await detectOverflow$1(state, detectOverflowOptions);
        const crossAxis = getSideAxis(getSide(placement));
        const mainAxis = getOppositeAxis(crossAxis);
        let mainAxisCoord = coords[mainAxis];
        let crossAxisCoord = coords[crossAxis];
        if (checkMainAxis) {
          const minSide = mainAxis === "y" ? "top" : "left";
          const maxSide = mainAxis === "y" ? "bottom" : "right";
          const min2 = mainAxisCoord + overflow[minSide];
          const max2 = mainAxisCoord - overflow[maxSide];
          mainAxisCoord = clamp$1(min2, mainAxisCoord, max2);
        }
        if (checkCrossAxis) {
          const minSide = crossAxis === "y" ? "top" : "left";
          const maxSide = crossAxis === "y" ? "bottom" : "right";
          const min2 = crossAxisCoord + overflow[minSide];
          const max2 = crossAxisCoord - overflow[maxSide];
          crossAxisCoord = clamp$1(min2, crossAxisCoord, max2);
        }
        const limitedCoords = limiter.fn({
          ...state,
          [mainAxis]: mainAxisCoord,
          [crossAxis]: crossAxisCoord
        });
        return {
          ...limitedCoords,
          data: {
            x: limitedCoords.x - x2,
            y: limitedCoords.y - y2
          }
        };
      }
    };
  };
  const limitShift = function(options) {
    if (options === void 0) {
      options = {};
    }
    return {
      options,
      fn(state) {
        const {
          x: x2,
          y: y2,
          placement,
          rects,
          middlewareData
        } = state;
        const {
          offset: offset2 = 0,
          mainAxis: checkMainAxis = true,
          crossAxis: checkCrossAxis = true
        } = evaluate(options, state);
        const coords = {
          x: x2,
          y: y2
        };
        const crossAxis = getSideAxis(placement);
        const mainAxis = getOppositeAxis(crossAxis);
        let mainAxisCoord = coords[mainAxis];
        let crossAxisCoord = coords[crossAxis];
        const rawOffset = evaluate(offset2, state);
        const computedOffset = typeof rawOffset === "number" ? {
          mainAxis: rawOffset,
          crossAxis: 0
        } : {
          mainAxis: 0,
          crossAxis: 0,
          ...rawOffset
        };
        if (checkMainAxis) {
          const len = mainAxis === "y" ? "height" : "width";
          const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
          const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
          if (mainAxisCoord < limitMin) {
            mainAxisCoord = limitMin;
          } else if (mainAxisCoord > limitMax) {
            mainAxisCoord = limitMax;
          }
        }
        if (checkCrossAxis) {
          var _middlewareData$offse, _middlewareData$offse2;
          const len = mainAxis === "y" ? "width" : "height";
          const isOriginSide = ["top", "left"].includes(getSide(placement));
          const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
          const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
          if (crossAxisCoord < limitMin) {
            crossAxisCoord = limitMin;
          } else if (crossAxisCoord > limitMax) {
            crossAxisCoord = limitMax;
          }
        }
        return {
          [mainAxis]: mainAxisCoord,
          [crossAxis]: crossAxisCoord
        };
      }
    };
  };
  const size$3 = function(options) {
    if (options === void 0) {
      options = {};
    }
    return {
      name: "size",
      options,
      async fn(state) {
        const {
          placement,
          rects,
          platform: platform2,
          elements
        } = state;
        const {
          apply = () => {
          },
          ...detectOverflowOptions
        } = evaluate(options, state);
        const overflow = await detectOverflow$1(state, detectOverflowOptions);
        const side = getSide(placement);
        const alignment = getAlignment(placement);
        const isYAxis = getSideAxis(placement) === "y";
        const {
          width,
          height
        } = rects.floating;
        let heightSide;
        let widthSide;
        if (side === "top" || side === "bottom") {
          heightSide = side;
          widthSide = alignment === (await (platform2.isRTL == null ? void 0 : platform2.isRTL(elements.floating)) ? "start" : "end") ? "left" : "right";
        } else {
          widthSide = side;
          heightSide = alignment === "end" ? "top" : "bottom";
        }
        const maximumClippingHeight = height - overflow.top - overflow.bottom;
        const maximumClippingWidth = width - overflow.left - overflow.right;
        const overflowAvailableHeight = min$3(height - overflow[heightSide], maximumClippingHeight);
        const overflowAvailableWidth = min$3(width - overflow[widthSide], maximumClippingWidth);
        const noShift = !state.middlewareData.shift;
        let availableHeight = overflowAvailableHeight;
        let availableWidth = overflowAvailableWidth;
        if (isYAxis) {
          availableWidth = alignment || noShift ? min$3(overflowAvailableWidth, maximumClippingWidth) : maximumClippingWidth;
        } else {
          availableHeight = alignment || noShift ? min$3(overflowAvailableHeight, maximumClippingHeight) : maximumClippingHeight;
        }
        if (noShift && !alignment) {
          const xMin = max$4(overflow.left, 0);
          const xMax = max$4(overflow.right, 0);
          const yMin = max$4(overflow.top, 0);
          const yMax = max$4(overflow.bottom, 0);
          if (isYAxis) {
            availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : max$4(overflow.left, overflow.right));
          } else {
            availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : max$4(overflow.top, overflow.bottom));
          }
        }
        await apply({
          ...state,
          availableWidth,
          availableHeight
        });
        const nextDimensions = await platform2.getDimensions(elements.floating);
        if (width !== nextDimensions.width || height !== nextDimensions.height) {
          return {
            reset: {
              rects: true
            }
          };
        }
        return {};
      }
    };
  };
  function getCssDimensions(element2) {
    const css2 = getComputedStyle$2(element2);
    let width = parseFloat(css2.width) || 0;
    let height = parseFloat(css2.height) || 0;
    const hasOffset = isHTMLElement$1(element2);
    const offsetWidth = hasOffset ? element2.offsetWidth : width;
    const offsetHeight = hasOffset ? element2.offsetHeight : height;
    const shouldFallback = round$3(width) !== offsetWidth || round$3(height) !== offsetHeight;
    if (shouldFallback) {
      width = offsetWidth;
      height = offsetHeight;
    }
    return {
      width,
      height,
      $: shouldFallback
    };
  }
  function unwrapElement(element2) {
    return !isElement$4(element2) ? element2.contextElement : element2;
  }
  function getScale$1(element2) {
    const domElement2 = unwrapElement(element2);
    if (!isHTMLElement$1(domElement2)) {
      return createCoords(1);
    }
    const rect = domElement2.getBoundingClientRect();
    const {
      width,
      height,
      $: $2
    } = getCssDimensions(domElement2);
    let x2 = ($2 ? round$3(rect.width) : rect.width) / width;
    let y2 = ($2 ? round$3(rect.height) : rect.height) / height;
    if (!x2 || !Number.isFinite(x2)) {
      x2 = 1;
    }
    if (!y2 || !Number.isFinite(y2)) {
      y2 = 1;
    }
    return {
      x: x2,
      y: y2
    };
  }
  const noOffsets = /* @__PURE__ */ createCoords(0);
  function getVisualOffsets(element2) {
    const win = getWindow$1(element2);
    if (!isWebKit() || !win.visualViewport) {
      return noOffsets;
    }
    return {
      x: win.visualViewport.offsetLeft,
      y: win.visualViewport.offsetTop
    };
  }
  function shouldAddVisualOffsets(element2, isFixed, floatingOffsetParent) {
    if (isFixed === void 0) {
      isFixed = false;
    }
    if (!floatingOffsetParent || isFixed && floatingOffsetParent !== getWindow$1(element2)) {
      return false;
    }
    return isFixed;
  }
  function getBoundingClientRect$1(element2, includeScale, isFixedStrategy, offsetParent) {
    if (includeScale === void 0) {
      includeScale = false;
    }
    if (isFixedStrategy === void 0) {
      isFixedStrategy = false;
    }
    const clientRect = element2.getBoundingClientRect();
    const domElement2 = unwrapElement(element2);
    let scale = createCoords(1);
    if (includeScale) {
      if (offsetParent) {
        if (isElement$4(offsetParent)) {
          scale = getScale$1(offsetParent);
        }
      } else {
        scale = getScale$1(element2);
      }
    }
    const visualOffsets = shouldAddVisualOffsets(domElement2, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement2) : createCoords(0);
    let x2 = (clientRect.left + visualOffsets.x) / scale.x;
    let y2 = (clientRect.top + visualOffsets.y) / scale.y;
    let width = clientRect.width / scale.x;
    let height = clientRect.height / scale.y;
    if (domElement2) {
      const win = getWindow$1(domElement2);
      const offsetWin = offsetParent && isElement$4(offsetParent) ? getWindow$1(offsetParent) : offsetParent;
      let currentWin = win;
      let currentIFrame = currentWin.frameElement;
      while (currentIFrame && offsetParent && offsetWin !== currentWin) {
        const iframeScale = getScale$1(currentIFrame);
        const iframeRect = currentIFrame.getBoundingClientRect();
        const css2 = getComputedStyle$2(currentIFrame);
        const left2 = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css2.paddingLeft)) * iframeScale.x;
        const top2 = iframeRect.top + (currentIFrame.clientTop + parseFloat(css2.paddingTop)) * iframeScale.y;
        x2 *= iframeScale.x;
        y2 *= iframeScale.y;
        width *= iframeScale.x;
        height *= iframeScale.y;
        x2 += left2;
        y2 += top2;
        currentWin = getWindow$1(currentIFrame);
        currentIFrame = currentWin.frameElement;
      }
    }
    return rectToClientRect$1({
      width,
      height,
      x: x2,
      y: y2
    });
  }
  const topLayerSelectors = [":popover-open", ":modal"];
  function isTopLayer(element2) {
    return topLayerSelectors.some((selector2) => {
      try {
        return element2.matches(selector2);
      } catch (e3) {
        return false;
      }
    });
  }
  function convertOffsetParentRelativeRectToViewportRelativeRect(_ref2) {
    let {
      elements,
      rect,
      offsetParent,
      strategy
    } = _ref2;
    const isFixed = strategy === "fixed";
    const documentElement = getDocumentElement$1(offsetParent);
    const topLayer = elements ? isTopLayer(elements.floating) : false;
    if (offsetParent === documentElement || topLayer && isFixed) {
      return rect;
    }
    let scroll = {
      scrollLeft: 0,
      scrollTop: 0
    };
    let scale = createCoords(1);
    const offsets = createCoords(0);
    const isOffsetParentAnElement = isHTMLElement$1(offsetParent);
    if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
      if (getNodeName$1(offsetParent) !== "body" || isOverflowElement(documentElement)) {
        scroll = getNodeScroll$1(offsetParent);
      }
      if (isHTMLElement$1(offsetParent)) {
        const offsetRect = getBoundingClientRect$1(offsetParent);
        scale = getScale$1(offsetParent);
        offsets.x = offsetRect.x + offsetParent.clientLeft;
        offsets.y = offsetRect.y + offsetParent.clientTop;
      }
    }
    return {
      width: rect.width * scale.x,
      height: rect.height * scale.y,
      x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x,
      y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y
    };
  }
  function getClientRects(element2) {
    return Array.from(element2.getClientRects());
  }
  function getWindowScrollBarX$1(element2) {
    return getBoundingClientRect$1(getDocumentElement$1(element2)).left + getNodeScroll$1(element2).scrollLeft;
  }
  function getDocumentRect$1(element2) {
    const html2 = getDocumentElement$1(element2);
    const scroll = getNodeScroll$1(element2);
    const body = element2.ownerDocument.body;
    const width = max$4(html2.scrollWidth, html2.clientWidth, body.scrollWidth, body.clientWidth);
    const height = max$4(html2.scrollHeight, html2.clientHeight, body.scrollHeight, body.clientHeight);
    let x2 = -scroll.scrollLeft + getWindowScrollBarX$1(element2);
    const y2 = -scroll.scrollTop;
    if (getComputedStyle$2(body).direction === "rtl") {
      x2 += max$4(html2.clientWidth, body.clientWidth) - width;
    }
    return {
      width,
      height,
      x: x2,
      y: y2
    };
  }
  function getViewportRect$1(element2, strategy) {
    const win = getWindow$1(element2);
    const html2 = getDocumentElement$1(element2);
    const visualViewport = win.visualViewport;
    let width = html2.clientWidth;
    let height = html2.clientHeight;
    let x2 = 0;
    let y2 = 0;
    if (visualViewport) {
      width = visualViewport.width;
      height = visualViewport.height;
      const visualViewportBased = isWebKit();
      if (!visualViewportBased || visualViewportBased && strategy === "fixed") {
        x2 = visualViewport.offsetLeft;
        y2 = visualViewport.offsetTop;
      }
    }
    return {
      width,
      height,
      x: x2,
      y: y2
    };
  }
  function getInnerBoundingClientRect$1(element2, strategy) {
    const clientRect = getBoundingClientRect$1(element2, true, strategy === "fixed");
    const top2 = clientRect.top + element2.clientTop;
    const left2 = clientRect.left + element2.clientLeft;
    const scale = isHTMLElement$1(element2) ? getScale$1(element2) : createCoords(1);
    const width = element2.clientWidth * scale.x;
    const height = element2.clientHeight * scale.y;
    const x2 = left2 * scale.x;
    const y2 = top2 * scale.y;
    return {
      width,
      height,
      x: x2,
      y: y2
    };
  }
  function getClientRectFromClippingAncestor(element2, clippingAncestor, strategy) {
    let rect;
    if (clippingAncestor === "viewport") {
      rect = getViewportRect$1(element2, strategy);
    } else if (clippingAncestor === "document") {
      rect = getDocumentRect$1(getDocumentElement$1(element2));
    } else if (isElement$4(clippingAncestor)) {
      rect = getInnerBoundingClientRect$1(clippingAncestor, strategy);
    } else {
      const visualOffsets = getVisualOffsets(element2);
      rect = {
        ...clippingAncestor,
        x: clippingAncestor.x - visualOffsets.x,
        y: clippingAncestor.y - visualOffsets.y
      };
    }
    return rectToClientRect$1(rect);
  }
  function hasFixedPositionAncestor(element2, stopNode) {
    const parentNode = getParentNode$1(element2);
    if (parentNode === stopNode || !isElement$4(parentNode) || isLastTraversableNode(parentNode)) {
      return false;
    }
    return getComputedStyle$2(parentNode).position === "fixed" || hasFixedPositionAncestor(parentNode, stopNode);
  }
  function getClippingElementAncestors(element2, cache2) {
    const cachedResult = cache2.get(element2);
    if (cachedResult) {
      return cachedResult;
    }
    let result = getOverflowAncestors(element2, [], false).filter((el) => isElement$4(el) && getNodeName$1(el) !== "body");
    let currentContainingBlockComputedStyle = null;
    const elementIsFixed = getComputedStyle$2(element2).position === "fixed";
    let currentNode = elementIsFixed ? getParentNode$1(element2) : element2;
    while (isElement$4(currentNode) && !isLastTraversableNode(currentNode)) {
      const computedStyle = getComputedStyle$2(currentNode);
      const currentNodeIsContaining = isContainingBlock(currentNode);
      if (!currentNodeIsContaining && computedStyle.position === "fixed") {
        currentContainingBlockComputedStyle = null;
      }
      const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === "static" && !!currentContainingBlockComputedStyle && ["absolute", "fixed"].includes(currentContainingBlockComputedStyle.position) || isOverflowElement(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element2, currentNode);
      if (shouldDropCurrentNode) {
        result = result.filter((ancestor) => ancestor !== currentNode);
      } else {
        currentContainingBlockComputedStyle = computedStyle;
      }
      currentNode = getParentNode$1(currentNode);
    }
    cache2.set(element2, result);
    return result;
  }
  function getClippingRect$1(_ref2) {
    let {
      element: element2,
      boundary,
      rootBoundary,
      strategy
    } = _ref2;
    const elementClippingAncestors = boundary === "clippingAncestors" ? isTopLayer(element2) ? [] : getClippingElementAncestors(element2, this._c) : [].concat(boundary);
    const clippingAncestors = [...elementClippingAncestors, rootBoundary];
    const firstClippingAncestor = clippingAncestors[0];
    const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
      const rect = getClientRectFromClippingAncestor(element2, clippingAncestor, strategy);
      accRect.top = max$4(rect.top, accRect.top);
      accRect.right = min$3(rect.right, accRect.right);
      accRect.bottom = min$3(rect.bottom, accRect.bottom);
      accRect.left = max$4(rect.left, accRect.left);
      return accRect;
    }, getClientRectFromClippingAncestor(element2, firstClippingAncestor, strategy));
    return {
      width: clippingRect.right - clippingRect.left,
      height: clippingRect.bottom - clippingRect.top,
      x: clippingRect.left,
      y: clippingRect.top
    };
  }
  function getDimensions(element2) {
    const {
      width,
      height
    } = getCssDimensions(element2);
    return {
      width,
      height
    };
  }
  function getRectRelativeToOffsetParent(element2, offsetParent, strategy) {
    const isOffsetParentAnElement = isHTMLElement$1(offsetParent);
    const documentElement = getDocumentElement$1(offsetParent);
    const isFixed = strategy === "fixed";
    const rect = getBoundingClientRect$1(element2, true, isFixed, offsetParent);
    let scroll = {
      scrollLeft: 0,
      scrollTop: 0
    };
    const offsets = createCoords(0);
    if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
      if (getNodeName$1(offsetParent) !== "body" || isOverflowElement(documentElement)) {
        scroll = getNodeScroll$1(offsetParent);
      }
      if (isOffsetParentAnElement) {
        const offsetRect = getBoundingClientRect$1(offsetParent, true, isFixed, offsetParent);
        offsets.x = offsetRect.x + offsetParent.clientLeft;
        offsets.y = offsetRect.y + offsetParent.clientTop;
      } else if (documentElement) {
        offsets.x = getWindowScrollBarX$1(documentElement);
      }
    }
    const x2 = rect.left + scroll.scrollLeft - offsets.x;
    const y2 = rect.top + scroll.scrollTop - offsets.y;
    return {
      x: x2,
      y: y2,
      width: rect.width,
      height: rect.height
    };
  }
  function isStaticPositioned(element2) {
    return getComputedStyle$2(element2).position === "static";
  }
  function getTrueOffsetParent$1(element2, polyfill) {
    if (!isHTMLElement$1(element2) || getComputedStyle$2(element2).position === "fixed") {
      return null;
    }
    if (polyfill) {
      return polyfill(element2);
    }
    return element2.offsetParent;
  }
  function getOffsetParent$1(element2, polyfill) {
    const win = getWindow$1(element2);
    if (isTopLayer(element2)) {
      return win;
    }
    if (!isHTMLElement$1(element2)) {
      let svgOffsetParent = getParentNode$1(element2);
      while (svgOffsetParent && !isLastTraversableNode(svgOffsetParent)) {
        if (isElement$4(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) {
          return svgOffsetParent;
        }
        svgOffsetParent = getParentNode$1(svgOffsetParent);
      }
      return win;
    }
    let offsetParent = getTrueOffsetParent$1(element2, polyfill);
    while (offsetParent && isTableElement$1(offsetParent) && isStaticPositioned(offsetParent)) {
      offsetParent = getTrueOffsetParent$1(offsetParent, polyfill);
    }
    if (offsetParent && isLastTraversableNode(offsetParent) && isStaticPositioned(offsetParent) && !isContainingBlock(offsetParent)) {
      return win;
    }
    return offsetParent || getContainingBlock$1(element2) || win;
  }
  const getElementRects = async function(data2) {
    const getOffsetParentFn = this.getOffsetParent || getOffsetParent$1;
    const getDimensionsFn = this.getDimensions;
    const floatingDimensions = await getDimensionsFn(data2.floating);
    return {
      reference: getRectRelativeToOffsetParent(data2.reference, await getOffsetParentFn(data2.floating), data2.strategy),
      floating: {
        x: 0,
        y: 0,
        width: floatingDimensions.width,
        height: floatingDimensions.height
      }
    };
  };
  function isRTL(element2) {
    return getComputedStyle$2(element2).direction === "rtl";
  }
  const platform = {
    convertOffsetParentRelativeRectToViewportRelativeRect,
    getDocumentElement: getDocumentElement$1,
    getClippingRect: getClippingRect$1,
    getOffsetParent: getOffsetParent$1,
    getElementRects,
    getClientRects,
    getDimensions,
    getScale: getScale$1,
    isElement: isElement$4,
    isRTL
  };
  function observeMove(element2, onMove) {
    let io2 = null;
    let timeoutId;
    const root2 = getDocumentElement$1(element2);
    function cleanup() {
      var _io;
      clearTimeout(timeoutId);
      (_io = io2) == null || _io.disconnect();
      io2 = null;
    }
    function refresh(skip, threshold) {
      if (skip === void 0) {
        skip = false;
      }
      if (threshold === void 0) {
        threshold = 1;
      }
      cleanup();
      const {
        left: left2,
        top: top2,
        width,
        height
      } = element2.getBoundingClientRect();
      if (!skip) {
        onMove();
      }
      if (!width || !height) {
        return;
      }
      const insetTop = floor(top2);
      const insetRight = floor(root2.clientWidth - (left2 + width));
      const insetBottom = floor(root2.clientHeight - (top2 + height));
      const insetLeft = floor(left2);
      const rootMargin = -insetTop + "px " + -insetRight + "px " + -insetBottom + "px " + -insetLeft + "px";
      const options = {
        rootMargin,
        threshold: max$4(0, min$3(1, threshold)) || 1
      };
      let isFirstUpdate = true;
      function handleObserve(entries) {
        const ratio = entries[0].intersectionRatio;
        if (ratio !== threshold) {
          if (!isFirstUpdate) {
            return refresh();
          }
          if (!ratio) {
            timeoutId = setTimeout(() => {
              refresh(false, 1e-7);
            }, 1e3);
          } else {
            refresh(false, ratio);
          }
        }
        isFirstUpdate = false;
      }
      try {
        io2 = new IntersectionObserver(handleObserve, {
          ...options,
          root: root2.ownerDocument
        });
      } catch (e3) {
        io2 = new IntersectionObserver(handleObserve, options);
      }
      io2.observe(element2);
    }
    refresh(true);
    return cleanup;
  }
  function autoUpdate(reference2, floating, update2, options) {
    if (options === void 0) {
      options = {};
    }
    const {
      ancestorScroll = true,
      ancestorResize = true,
      elementResize = typeof ResizeObserver === "function",
      layoutShift = typeof IntersectionObserver === "function",
      animationFrame = false
    } = options;
    const referenceEl = unwrapElement(reference2);
    const ancestors = ancestorScroll || ancestorResize ? [...referenceEl ? getOverflowAncestors(referenceEl) : [], ...getOverflowAncestors(floating)] : [];
    ancestors.forEach((ancestor) => {
      ancestorScroll && ancestor.addEventListener("scroll", update2, {
        passive: true
      });
      ancestorResize && ancestor.addEventListener("resize", update2);
    });
    const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update2) : null;
    let reobserveFrame = -1;
    let resizeObserver = null;
    if (elementResize) {
      resizeObserver = new ResizeObserver((_ref2) => {
        let [firstEntry] = _ref2;
        if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {
          resizeObserver.unobserve(floating);
          cancelAnimationFrame(reobserveFrame);
          reobserveFrame = requestAnimationFrame(() => {
            var _resizeObserver;
            (_resizeObserver = resizeObserver) == null || _resizeObserver.observe(floating);
          });
        }
        update2();
      });
      if (referenceEl && !animationFrame) {
        resizeObserver.observe(referenceEl);
      }
      resizeObserver.observe(floating);
    }
    let frameId;
    let prevRefRect = animationFrame ? getBoundingClientRect$1(reference2) : null;
    if (animationFrame) {
      frameLoop();
    }
    function frameLoop() {
      const nextRefRect = getBoundingClientRect$1(reference2);
      if (prevRefRect && (nextRefRect.x !== prevRefRect.x || nextRefRect.y !== prevRefRect.y || nextRefRect.width !== prevRefRect.width || nextRefRect.height !== prevRefRect.height)) {
        update2();
      }
      prevRefRect = nextRefRect;
      frameId = requestAnimationFrame(frameLoop);
    }
    update2();
    return () => {
      var _resizeObserver2;
      ancestors.forEach((ancestor) => {
        ancestorScroll && ancestor.removeEventListener("scroll", update2);
        ancestorResize && ancestor.removeEventListener("resize", update2);
      });
      cleanupIo == null || cleanupIo();
      (_resizeObserver2 = resizeObserver) == null || _resizeObserver2.disconnect();
      resizeObserver = null;
      if (animationFrame) {
        cancelAnimationFrame(frameId);
      }
    };
  }
  const offset$3 = offset$4;
  autoPlacement;
  const shift$2 = shift$3;
  const flip$3 = flip$4;
  const size$2 = size$3;
  hide$2;
  arrow$2;
  inline;
  limitShift;
  const computePosition = (reference2, floating, options) => {
    const cache2 = /* @__PURE__ */ new Map();
    const mergedOptions = {
      platform,
      ...options
    };
    const platformWithCache = {
      ...mergedOptions.platform,
      _c: cache2
    };
    return computePosition$1(reference2, floating, {
      ...mergedOptions,
      platform: platformWithCache
    });
  };
  var index$4 = typeof document !== "undefined" ? React.useLayoutEffect : React.useEffect;
  function deepEqual(a2, b2) {
    if (a2 === b2) {
      return true;
    }
    if (typeof a2 !== typeof b2) {
      return false;
    }
    if (typeof a2 === "function" && a2.toString() === b2.toString()) {
      return true;
    }
    let length;
    let i2;
    let keys2;
    if (a2 && b2 && typeof a2 === "object") {
      if (Array.isArray(a2)) {
        length = a2.length;
        if (length !== b2.length)
          return false;
        for (i2 = length; i2-- !== 0; ) {
          if (!deepEqual(a2[i2], b2[i2])) {
            return false;
          }
        }
        return true;
      }
      keys2 = Object.keys(a2);
      length = keys2.length;
      if (length !== Object.keys(b2).length) {
        return false;
      }
      for (i2 = length; i2-- !== 0; ) {
        if (!{}.hasOwnProperty.call(b2, keys2[i2])) {
          return false;
        }
      }
      for (i2 = length; i2-- !== 0; ) {
        const key = keys2[i2];
        if (key === "_owner" && a2.$$typeof) {
          continue;
        }
        if (!deepEqual(a2[key], b2[key])) {
          return false;
        }
      }
      return true;
    }
    return a2 !== a2 && b2 !== b2;
  }
  function getDPR(element2) {
    if (typeof window === "undefined") {
      return 1;
    }
    const win = element2.ownerDocument.defaultView || window;
    return win.devicePixelRatio || 1;
  }
  function roundByDPR(element2, value) {
    const dpr = getDPR(element2);
    return Math.round(value * dpr) / dpr;
  }
  function useLatestRef$1(value) {
    const ref2 = React__namespace.useRef(value);
    index$4(() => {
      ref2.current = value;
    });
    return ref2;
  }
  function useFloating$1(options) {
    if (options === void 0) {
      options = {};
    }
    const {
      placement = "bottom",
      strategy = "absolute",
      middleware = [],
      platform: platform2,
      elements: {
        reference: externalReference,
        floating: externalFloating
      } = {},
      transform = true,
      whileElementsMounted,
      open
    } = options;
    const [data2, setData] = React__namespace.useState({
      x: 0,
      y: 0,
      strategy,
      placement,
      middlewareData: {},
      isPositioned: false
    });
    const [latestMiddleware, setLatestMiddleware] = React__namespace.useState(middleware);
    if (!deepEqual(latestMiddleware, middleware)) {
      setLatestMiddleware(middleware);
    }
    const [_reference, _setReference] = React__namespace.useState(null);
    const [_floating, _setFloating] = React__namespace.useState(null);
    const setReference = React__namespace.useCallback((node2) => {
      if (node2 !== referenceRef.current) {
        referenceRef.current = node2;
        _setReference(node2);
      }
    }, []);
    const setFloating = React__namespace.useCallback((node2) => {
      if (node2 !== floatingRef.current) {
        floatingRef.current = node2;
        _setFloating(node2);
      }
    }, []);
    const referenceEl = externalReference || _reference;
    const floatingEl = externalFloating || _floating;
    const referenceRef = React__namespace.useRef(null);
    const floatingRef = React__namespace.useRef(null);
    const dataRef = React__namespace.useRef(data2);
    const hasWhileElementsMounted = whileElementsMounted != null;
    const whileElementsMountedRef = useLatestRef$1(whileElementsMounted);
    const platformRef = useLatestRef$1(platform2);
    const update2 = React__namespace.useCallback(() => {
      if (!referenceRef.current || !floatingRef.current) {
        return;
      }
      const config2 = {
        placement,
        strategy,
        middleware: latestMiddleware
      };
      if (platformRef.current) {
        config2.platform = platformRef.current;
      }
      computePosition(referenceRef.current, floatingRef.current, config2).then((data3) => {
        const fullData = {
          ...data3,
          isPositioned: true
        };
        if (isMountedRef.current && !deepEqual(dataRef.current, fullData)) {
          dataRef.current = fullData;
          ReactDOM__namespace.flushSync(() => {
            setData(fullData);
          });
        }
      });
    }, [latestMiddleware, placement, strategy, platformRef]);
    index$4(() => {
      if (open === false && dataRef.current.isPositioned) {
        dataRef.current.isPositioned = false;
        setData((data3) => ({
          ...data3,
          isPositioned: false
        }));
      }
    }, [open]);
    const isMountedRef = React__namespace.useRef(false);
    index$4(() => {
      isMountedRef.current = true;
      return () => {
        isMountedRef.current = false;
      };
    }, []);
    index$4(() => {
      if (referenceEl)
        referenceRef.current = referenceEl;
      if (floatingEl)
        floatingRef.current = floatingEl;
      if (referenceEl && floatingEl) {
        if (whileElementsMountedRef.current) {
          return whileElementsMountedRef.current(referenceEl, floatingEl, update2);
        }
        update2();
      }
    }, [referenceEl, floatingEl, update2, whileElementsMountedRef, hasWhileElementsMounted]);
    const refs = React__namespace.useMemo(() => ({
      reference: referenceRef,
      floating: floatingRef,
      setReference,
      setFloating
    }), [setReference, setFloating]);
    const elements = React__namespace.useMemo(() => ({
      reference: referenceEl,
      floating: floatingEl
    }), [referenceEl, floatingEl]);
    const floatingStyles = React__namespace.useMemo(() => {
      const initialStyles = {
        position: strategy,
        left: 0,
        top: 0
      };
      if (!elements.floating) {
        return initialStyles;
      }
      const x2 = roundByDPR(elements.floating, data2.x);
      const y2 = roundByDPR(elements.floating, data2.y);
      if (transform) {
        return {
          ...initialStyles,
          transform: "translate(" + x2 + "px, " + y2 + "px)",
          ...getDPR(elements.floating) >= 1.5 && {
            willChange: "transform"
          }
        };
      }
      return {
        position: strategy,
        left: x2,
        top: y2
      };
    }, [strategy, transform, elements.floating, data2.x, data2.y]);
    return React__namespace.useMemo(() => ({
      ...data2,
      update: update2,
      refs,
      elements,
      floatingStyles
    }), [data2, update2, refs, elements, floatingStyles]);
  }
  const offset$2 = (options, deps) => ({
    ...offset$3(options),
    options: [options, deps]
  });
  const shift$1 = (options, deps) => ({
    ...shift$2(options),
    options: [options, deps]
  });
  const flip$2 = (options, deps) => ({
    ...flip$3(options),
    options: [options, deps]
  });
  const size$1 = (options, deps) => ({
    ...size$2(options),
    options: [options, deps]
  });
  const SafeReact = {
    ...React__namespace
  };
  const useInsertionEffect = SafeReact.useInsertionEffect;
  const useSafeInsertionEffect = useInsertionEffect || ((fn2) => fn2());
  function useEffectEvent(callback) {
    const ref2 = React__namespace.useRef(() => {
    });
    useSafeInsertionEffect(() => {
      ref2.current = callback;
    });
    return React__namespace.useCallback(function() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return ref2.current == null ? void 0 : ref2.current(...args);
    }, []);
  }
  var index$3 = typeof document !== "undefined" ? React.useLayoutEffect : React.useEffect;
  let serverHandoffComplete = false;
  let count$1 = 0;
  const genId = () => "floating-ui-" + Math.random().toString(36).slice(2, 6) + count$1++;
  function useFloatingId() {
    const [id2, setId] = React__namespace.useState(() => serverHandoffComplete ? genId() : void 0);
    index$3(() => {
      if (id2 == null) {
        setId(genId());
      }
    }, []);
    React__namespace.useEffect(() => {
      serverHandoffComplete = true;
    }, []);
    return id2;
  }
  const useReactId = SafeReact.useId;
  const useId = useReactId || useFloatingId;
  function createPubSub() {
    const map2 = /* @__PURE__ */ new Map();
    return {
      emit(event2, data2) {
        var _map$get;
        (_map$get = map2.get(event2)) == null || _map$get.forEach((handler) => handler(data2));
      },
      on(event2, listener2) {
        map2.set(event2, [...map2.get(event2) || [], listener2]);
      },
      off(event2, listener2) {
        var _map$get2;
        map2.set(event2, ((_map$get2 = map2.get(event2)) == null ? void 0 : _map$get2.filter((l2) => l2 !== listener2)) || []);
      }
    };
  }
  const FloatingNodeContext = /* @__PURE__ */ React__namespace.createContext(null);
  const FloatingTreeContext = /* @__PURE__ */ React__namespace.createContext(null);
  const useFloatingParentNodeId = () => {
    var _React$useContext;
    return ((_React$useContext = React__namespace.useContext(FloatingNodeContext)) == null ? void 0 : _React$useContext.id) || null;
  };
  const useFloatingTree = () => React__namespace.useContext(FloatingTreeContext);
  function createAttribute(name2) {
    return "data-floating-ui-" + name2;
  }
  function getChildren$3(nodes, id2) {
    let allChildren = nodes.filter((node2) => {
      var _node$context;
      return node2.parentId === id2 && ((_node$context = node2.context) == null ? void 0 : _node$context.open);
    });
    let currentChildren = allChildren;
    while (currentChildren.length) {
      currentChildren = nodes.filter((node2) => {
        var _currentChildren;
        return (_currentChildren = currentChildren) == null ? void 0 : _currentChildren.some((n2) => {
          var _node$context2;
          return node2.parentId === n2.id && ((_node$context2 = node2.context) == null ? void 0 : _node$context2.open);
        });
      });
      allChildren = allChildren.concat(currentChildren);
    }
    return allChildren;
  }
  function isButtonTarget(event2) {
    return isHTMLElement$1(event2.target) && event2.target.tagName === "BUTTON";
  }
  function isSpaceIgnored(element2) {
    return isTypeableElement(element2);
  }
  function useClick(context2, props) {
    if (props === void 0) {
      props = {};
    }
    const {
      open,
      onOpenChange,
      dataRef,
      elements: {
        domReference
      }
    } = context2;
    const {
      enabled = true,
      event: eventOption = "click",
      toggle = true,
      ignoreMouse = false,
      keyboardHandlers = true
    } = props;
    const pointerTypeRef = React__namespace.useRef();
    const didKeyDownRef = React__namespace.useRef(false);
    return React__namespace.useMemo(() => {
      if (!enabled)
        return {};
      return {
        reference: {
          onPointerDown(event2) {
            pointerTypeRef.current = event2.pointerType;
          },
          onMouseDown(event2) {
            if (event2.button !== 0) {
              return;
            }
            if (isMouseLikePointerType(pointerTypeRef.current, true) && ignoreMouse) {
              return;
            }
            if (eventOption === "click") {
              return;
            }
            if (open && toggle && (dataRef.current.openEvent ? dataRef.current.openEvent.type === "mousedown" : true)) {
              onOpenChange(false, event2.nativeEvent, "click");
            } else {
              event2.preventDefault();
              onOpenChange(true, event2.nativeEvent, "click");
            }
          },
          onClick(event2) {
            if (eventOption === "mousedown" && pointerTypeRef.current) {
              pointerTypeRef.current = void 0;
              return;
            }
            if (isMouseLikePointerType(pointerTypeRef.current, true) && ignoreMouse) {
              return;
            }
            if (open && toggle && (dataRef.current.openEvent ? dataRef.current.openEvent.type === "click" : true)) {
              onOpenChange(false, event2.nativeEvent, "click");
            } else {
              onOpenChange(true, event2.nativeEvent, "click");
            }
          },
          onKeyDown(event2) {
            pointerTypeRef.current = void 0;
            if (event2.defaultPrevented || !keyboardHandlers || isButtonTarget(event2)) {
              return;
            }
            if (event2.key === " " && !isSpaceIgnored(domReference)) {
              event2.preventDefault();
              didKeyDownRef.current = true;
            }
            if (event2.key === "Enter") {
              if (open && toggle) {
                onOpenChange(false, event2.nativeEvent, "click");
              } else {
                onOpenChange(true, event2.nativeEvent, "click");
              }
            }
          },
          onKeyUp(event2) {
            if (event2.defaultPrevented || !keyboardHandlers || isButtonTarget(event2) || isSpaceIgnored(domReference)) {
              return;
            }
            if (event2.key === " " && didKeyDownRef.current) {
              didKeyDownRef.current = false;
              if (open && toggle) {
                onOpenChange(false, event2.nativeEvent, "click");
              } else {
                onOpenChange(true, event2.nativeEvent, "click");
              }
            }
          }
        }
      };
    }, [enabled, dataRef, eventOption, ignoreMouse, keyboardHandlers, domReference, toggle, open, onOpenChange]);
  }
  const bubbleHandlerKeys = {
    pointerdown: "onPointerDown",
    mousedown: "onMouseDown",
    click: "onClick"
  };
  const captureHandlerKeys = {
    pointerdown: "onPointerDownCapture",
    mousedown: "onMouseDownCapture",
    click: "onClickCapture"
  };
  const normalizeProp = (normalizable) => {
    var _normalizable$escapeK, _normalizable$outside;
    return {
      escapeKey: typeof normalizable === "boolean" ? normalizable : (_normalizable$escapeK = normalizable == null ? void 0 : normalizable.escapeKey) != null ? _normalizable$escapeK : false,
      outsidePress: typeof normalizable === "boolean" ? normalizable : (_normalizable$outside = normalizable == null ? void 0 : normalizable.outsidePress) != null ? _normalizable$outside : true
    };
  };
  function useDismiss(context2, props) {
    if (props === void 0) {
      props = {};
    }
    const {
      open,
      onOpenChange,
      elements: {
        reference: reference2,
        domReference,
        floating
      },
      dataRef
    } = context2;
    const {
      enabled = true,
      escapeKey = true,
      outsidePress: unstable_outsidePress = true,
      outsidePressEvent = "pointerdown",
      referencePress = false,
      referencePressEvent = "pointerdown",
      ancestorScroll = false,
      bubbles,
      capture
    } = props;
    const tree = useFloatingTree();
    const outsidePressFn = useEffectEvent(typeof unstable_outsidePress === "function" ? unstable_outsidePress : () => false);
    const outsidePress = typeof unstable_outsidePress === "function" ? outsidePressFn : unstable_outsidePress;
    const insideReactTreeRef = React__namespace.useRef(false);
    const endedOrStartedInsideRef = React__namespace.useRef(false);
    const {
      escapeKey: escapeKeyBubbles,
      outsidePress: outsidePressBubbles
    } = normalizeProp(bubbles);
    const {
      escapeKey: escapeKeyCapture,
      outsidePress: outsidePressCapture
    } = normalizeProp(capture);
    const closeOnEscapeKeyDown = useEffectEvent((event2) => {
      var _dataRef$current$floa;
      if (!open || !enabled || !escapeKey || event2.key !== "Escape") {
        return;
      }
      const nodeId = (_dataRef$current$floa = dataRef.current.floatingContext) == null ? void 0 : _dataRef$current$floa.nodeId;
      const children2 = tree ? getChildren$3(tree.nodesRef.current, nodeId) : [];
      if (!escapeKeyBubbles) {
        event2.stopPropagation();
        if (children2.length > 0) {
          let shouldDismiss = true;
          children2.forEach((child) => {
            var _child$context;
            if ((_child$context = child.context) != null && _child$context.open && !child.context.dataRef.current.__escapeKeyBubbles) {
              shouldDismiss = false;
              return;
            }
          });
          if (!shouldDismiss) {
            return;
          }
        }
      }
      onOpenChange(false, isReactEvent(event2) ? event2.nativeEvent : event2, "escape-key");
    });
    const closeOnEscapeKeyDownCapture = useEffectEvent((event2) => {
      var _getTarget2;
      const callback = () => {
        var _getTarget;
        closeOnEscapeKeyDown(event2);
        (_getTarget = getTarget(event2)) == null || _getTarget.removeEventListener("keydown", callback);
      };
      (_getTarget2 = getTarget(event2)) == null || _getTarget2.addEventListener("keydown", callback);
    });
    const closeOnPressOutside = useEffectEvent((event2) => {
      var _dataRef$current$floa2;
      const insideReactTree = insideReactTreeRef.current;
      insideReactTreeRef.current = false;
      const endedOrStartedInside = endedOrStartedInsideRef.current;
      endedOrStartedInsideRef.current = false;
      if (outsidePressEvent === "click" && endedOrStartedInside) {
        return;
      }
      if (insideReactTree) {
        return;
      }
      if (typeof outsidePress === "function" && !outsidePress(event2)) {
        return;
      }
      const target = getTarget(event2);
      const inertSelector = "[" + createAttribute("inert") + "]";
      const markers = getDocument(floating).querySelectorAll(inertSelector);
      let targetRootAncestor = isElement$4(target) ? target : null;
      while (targetRootAncestor && !isLastTraversableNode(targetRootAncestor)) {
        const nextParent = getParentNode$1(targetRootAncestor);
        if (isLastTraversableNode(nextParent) || !isElement$4(nextParent)) {
          break;
        }
        targetRootAncestor = nextParent;
      }
      if (markers.length && isElement$4(target) && !isRootElement(target) && !contains$2(target, floating) && Array.from(markers).every((marker) => !contains$2(targetRootAncestor, marker))) {
        return;
      }
      if (isHTMLElement$1(target) && floating) {
        const canScrollX = target.clientWidth > 0 && target.scrollWidth > target.clientWidth;
        const canScrollY = target.clientHeight > 0 && target.scrollHeight > target.clientHeight;
        let xCond = canScrollY && event2.offsetX > target.clientWidth;
        if (canScrollY) {
          const isRTL2 = getComputedStyle$2(target).direction === "rtl";
          if (isRTL2) {
            xCond = event2.offsetX <= target.offsetWidth - target.clientWidth;
          }
        }
        if (xCond || canScrollX && event2.offsetY > target.clientHeight) {
          return;
        }
      }
      const nodeId = (_dataRef$current$floa2 = dataRef.current.floatingContext) == null ? void 0 : _dataRef$current$floa2.nodeId;
      const targetIsInsideChildren = tree && getChildren$3(tree.nodesRef.current, nodeId).some((node2) => {
        var _node$context;
        return isEventTargetWithin(event2, (_node$context = node2.context) == null ? void 0 : _node$context.elements.floating);
      });
      if (isEventTargetWithin(event2, floating) || isEventTargetWithin(event2, domReference) || targetIsInsideChildren) {
        return;
      }
      const children2 = tree ? getChildren$3(tree.nodesRef.current, nodeId) : [];
      if (children2.length > 0) {
        let shouldDismiss = true;
        children2.forEach((child) => {
          var _child$context2;
          if ((_child$context2 = child.context) != null && _child$context2.open && !child.context.dataRef.current.__outsidePressBubbles) {
            shouldDismiss = false;
            return;
          }
        });
        if (!shouldDismiss) {
          return;
        }
      }
      onOpenChange(false, event2, "outside-press");
    });
    const closeOnPressOutsideCapture = useEffectEvent((event2) => {
      var _getTarget4;
      const callback = () => {
        var _getTarget3;
        closeOnPressOutside(event2);
        (_getTarget3 = getTarget(event2)) == null || _getTarget3.removeEventListener(outsidePressEvent, callback);
      };
      (_getTarget4 = getTarget(event2)) == null || _getTarget4.addEventListener(outsidePressEvent, callback);
    });
    React__namespace.useEffect(() => {
      if (!open || !enabled) {
        return;
      }
      dataRef.current.__escapeKeyBubbles = escapeKeyBubbles;
      dataRef.current.__outsidePressBubbles = outsidePressBubbles;
      function onScroll(event2) {
        onOpenChange(false, event2, "ancestor-scroll");
      }
      const doc2 = getDocument(floating);
      escapeKey && doc2.addEventListener("keydown", escapeKeyCapture ? closeOnEscapeKeyDownCapture : closeOnEscapeKeyDown, escapeKeyCapture);
      outsidePress && doc2.addEventListener(outsidePressEvent, outsidePressCapture ? closeOnPressOutsideCapture : closeOnPressOutside, outsidePressCapture);
      let ancestors = [];
      if (ancestorScroll) {
        if (isElement$4(domReference)) {
          ancestors = getOverflowAncestors(domReference);
        }
        if (isElement$4(floating)) {
          ancestors = ancestors.concat(getOverflowAncestors(floating));
        }
        if (!isElement$4(reference2) && reference2 && reference2.contextElement) {
          ancestors = ancestors.concat(getOverflowAncestors(reference2.contextElement));
        }
      }
      ancestors = ancestors.filter((ancestor) => {
        var _doc$defaultView;
        return ancestor !== ((_doc$defaultView = doc2.defaultView) == null ? void 0 : _doc$defaultView.visualViewport);
      });
      ancestors.forEach((ancestor) => {
        ancestor.addEventListener("scroll", onScroll, {
          passive: true
        });
      });
      return () => {
        escapeKey && doc2.removeEventListener("keydown", escapeKeyCapture ? closeOnEscapeKeyDownCapture : closeOnEscapeKeyDown, escapeKeyCapture);
        outsidePress && doc2.removeEventListener(outsidePressEvent, outsidePressCapture ? closeOnPressOutsideCapture : closeOnPressOutside, outsidePressCapture);
        ancestors.forEach((ancestor) => {
          ancestor.removeEventListener("scroll", onScroll);
        });
      };
    }, [dataRef, floating, domReference, reference2, escapeKey, outsidePress, outsidePressEvent, open, onOpenChange, ancestorScroll, enabled, escapeKeyBubbles, outsidePressBubbles, closeOnEscapeKeyDown, escapeKeyCapture, closeOnEscapeKeyDownCapture, closeOnPressOutside, outsidePressCapture, closeOnPressOutsideCapture]);
    React__namespace.useEffect(() => {
      insideReactTreeRef.current = false;
    }, [outsidePress, outsidePressEvent]);
    return React__namespace.useMemo(() => {
      if (!enabled) {
        return {};
      }
      return {
        reference: {
          onKeyDown: closeOnEscapeKeyDown,
          [bubbleHandlerKeys[referencePressEvent]]: (event2) => {
            if (referencePress) {
              onOpenChange(false, event2.nativeEvent, "reference-press");
            }
          }
        },
        floating: {
          onKeyDown: closeOnEscapeKeyDown,
          onMouseDown() {
            endedOrStartedInsideRef.current = true;
          },
          onMouseUp() {
            endedOrStartedInsideRef.current = true;
          },
          [captureHandlerKeys[outsidePressEvent]]: () => {
            insideReactTreeRef.current = true;
          }
        }
      };
    }, [enabled, referencePress, outsidePressEvent, referencePressEvent, onOpenChange, closeOnEscapeKeyDown]);
  }
  function useFloatingRootContext(options) {
    const {
      open = false,
      onOpenChange: onOpenChangeProp,
      elements: elementsProp
    } = options;
    const floatingId = useId();
    const dataRef = React__namespace.useRef({});
    const [events2] = React__namespace.useState(() => createPubSub());
    const nested = useFloatingParentNodeId() != null;
    const [positionReference, setPositionReference] = React__namespace.useState(elementsProp.reference);
    const onOpenChange = useEffectEvent((open2, event2, reason) => {
      dataRef.current.openEvent = open2 ? event2 : void 0;
      events2.emit("openchange", {
        open: open2,
        event: event2,
        reason,
        nested
      });
      onOpenChangeProp == null || onOpenChangeProp(open2, event2, reason);
    });
    const refs = React__namespace.useMemo(() => ({
      setPositionReference
    }), []);
    const elements = React__namespace.useMemo(() => ({
      reference: positionReference || elementsProp.reference || null,
      floating: elementsProp.floating || null,
      domReference: elementsProp.reference
    }), [positionReference, elementsProp.reference, elementsProp.floating]);
    return React__namespace.useMemo(() => ({
      dataRef,
      open,
      onOpenChange,
      elements,
      events: events2,
      floatingId,
      refs
    }), [open, onOpenChange, elements, events2, floatingId, refs]);
  }
  function useFloating(options) {
    if (options === void 0) {
      options = {};
    }
    const {
      nodeId
    } = options;
    const internalRootContext = useFloatingRootContext({
      ...options,
      elements: {
        reference: null,
        floating: null,
        ...options.elements
      }
    });
    const rootContext = options.rootContext || internalRootContext;
    const computedElements = rootContext.elements;
    const [_domReference, setDomReference] = React__namespace.useState(null);
    const [positionReference, _setPositionReference] = React__namespace.useState(null);
    const optionDomReference = computedElements == null ? void 0 : computedElements.reference;
    const domReference = optionDomReference || _domReference;
    const domReferenceRef = React__namespace.useRef(null);
    const tree = useFloatingTree();
    index$3(() => {
      if (domReference) {
        domReferenceRef.current = domReference;
      }
    }, [domReference]);
    const position2 = useFloating$1({
      ...options,
      elements: {
        ...computedElements,
        ...positionReference && {
          reference: positionReference
        }
      }
    });
    const setPositionReference = React__namespace.useCallback((node2) => {
      const computedPositionReference = isElement$4(node2) ? {
        getBoundingClientRect: () => node2.getBoundingClientRect(),
        contextElement: node2
      } : node2;
      _setPositionReference(computedPositionReference);
      position2.refs.setReference(computedPositionReference);
    }, [position2.refs]);
    const setReference = React__namespace.useCallback((node2) => {
      if (isElement$4(node2) || node2 === null) {
        domReferenceRef.current = node2;
        setDomReference(node2);
      }
      if (isElement$4(position2.refs.reference.current) || position2.refs.reference.current === null || node2 !== null && !isElement$4(node2)) {
        position2.refs.setReference(node2);
      }
    }, [position2.refs]);
    const refs = React__namespace.useMemo(() => ({
      ...position2.refs,
      setReference,
      setPositionReference,
      domReference: domReferenceRef
    }), [position2.refs, setReference, setPositionReference]);
    const elements = React__namespace.useMemo(() => ({
      ...position2.elements,
      domReference
    }), [position2.elements, domReference]);
    const context2 = React__namespace.useMemo(() => ({
      ...position2,
      ...rootContext,
      refs,
      elements,
      nodeId
    }), [position2, refs, elements, nodeId, rootContext]);
    index$3(() => {
      rootContext.dataRef.current.floatingContext = context2;
      const node2 = tree == null ? void 0 : tree.nodesRef.current.find((node3) => node3.id === nodeId);
      if (node2) {
        node2.context = context2;
      }
    });
    return React__namespace.useMemo(() => ({
      ...position2,
      context: context2,
      refs,
      elements
    }), [position2, refs, elements, context2]);
  }
  const ACTIVE_KEY = "active";
  const SELECTED_KEY = "selected";
  function mergeProps(userProps, propsList, elementKey) {
    const map2 = /* @__PURE__ */ new Map();
    const isItem2 = elementKey === "item";
    let domUserProps = userProps;
    if (isItem2 && userProps) {
      const {
        [ACTIVE_KEY]: _2,
        [SELECTED_KEY]: __,
        ...validProps
      } = userProps;
      domUserProps = validProps;
    }
    return {
      ...elementKey === "floating" && {
        tabIndex: -1
      },
      ...domUserProps,
      ...propsList.map((value) => {
        const propsOrGetProps = value ? value[elementKey] : null;
        if (typeof propsOrGetProps === "function") {
          return userProps ? propsOrGetProps(userProps) : null;
        }
        return propsOrGetProps;
      }).concat(userProps).reduce((acc, props) => {
        if (!props) {
          return acc;
        }
        Object.entries(props).forEach((_ref2) => {
          let [key, value] = _ref2;
          if (isItem2 && [ACTIVE_KEY, SELECTED_KEY].includes(key)) {
            return;
          }
          if (key.indexOf("on") === 0) {
            if (!map2.has(key)) {
              map2.set(key, []);
            }
            if (typeof value === "function") {
              var _map$get;
              (_map$get = map2.get(key)) == null || _map$get.push(value);
              acc[key] = function() {
                var _map$get2;
                for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                  args[_key] = arguments[_key];
                }
                return (_map$get2 = map2.get(key)) == null ? void 0 : _map$get2.map((fn2) => fn2(...args)).find((val) => val !== void 0);
              };
            }
          } else {
            acc[key] = value;
          }
        });
        return acc;
      }, {})
    };
  }
  function useInteractions(propsList) {
    if (propsList === void 0) {
      propsList = [];
    }
    const deps = propsList;
    const getReferenceProps = React__namespace.useCallback(
      (userProps) => mergeProps(userProps, propsList, "reference"),
      deps
    );
    const getFloatingProps = React__namespace.useCallback(
      (userProps) => mergeProps(userProps, propsList, "floating"),
      deps
    );
    const getItemProps = React__namespace.useCallback(
      (userProps) => mergeProps(userProps, propsList, "item"),
      propsList.map((key) => key == null ? void 0 : key.item)
    );
    return React__namespace.useMemo(() => ({
      getReferenceProps,
      getFloatingProps,
      getItemProps
    }), [getReferenceProps, getFloatingProps, getItemProps]);
  }
  const componentRoleToAriaRoleMap = /* @__PURE__ */ new Map([["select", "listbox"], ["combobox", "listbox"], ["label", false]]);
  function useRole(context2, props) {
    var _componentRoleToAriaR;
    if (props === void 0) {
      props = {};
    }
    const {
      open,
      floatingId
    } = context2;
    const {
      enabled = true,
      role = "dialog"
    } = props;
    const ariaRole = (_componentRoleToAriaR = componentRoleToAriaRoleMap.get(role)) != null ? _componentRoleToAriaR : role;
    const referenceId = useId();
    const parentId = useFloatingParentNodeId();
    const isNested = parentId != null;
    return React__namespace.useMemo(() => {
      if (!enabled)
        return {};
      const floatingProps = {
        id: floatingId,
        ...ariaRole && {
          role: ariaRole
        }
      };
      if (ariaRole === "tooltip" || role === "label") {
        return {
          reference: {
            ["aria-" + (role === "label" ? "labelledby" : "describedby")]: open ? floatingId : void 0
          },
          floating: floatingProps
        };
      }
      return {
        reference: {
          "aria-expanded": open ? "true" : "false",
          "aria-haspopup": ariaRole === "alertdialog" ? "dialog" : ariaRole,
          "aria-controls": open ? floatingId : void 0,
          ...ariaRole === "listbox" && {
            role: "combobox"
          },
          ...ariaRole === "menu" && {
            id: referenceId
          },
          ...ariaRole === "menu" && isNested && {
            role: "menuitem"
          },
          ...role === "select" && {
            "aria-autocomplete": "none"
          },
          ...role === "combobox" && {
            "aria-autocomplete": "list"
          }
        },
        floating: {
          ...floatingProps,
          ...ariaRole === "menu" && {
            "aria-labelledby": referenceId
          }
        },
        item(_ref2) {
          let {
            active,
            selected
          } = _ref2;
          const commonProps = {
            role: "option",
            ...active && {
              id: floatingId + "-option"
            }
          };
          switch (role) {
            case "select":
              return {
                ...commonProps,
                "aria-selected": active && selected
              };
            case "combobox": {
              return {
                ...commonProps,
                ...active && {
                  "aria-selected": true
                }
              };
            }
          }
          return {};
        }
      };
    }, [enabled, role, ariaRole, open, floatingId, referenceId, isNested]);
  }
  const matchWidthToReference = (delta = 0) => size$1({
    apply({ rects, elements }) {
      Object.assign(elements.floating.style, {
        width: `${rects.reference.width + delta}px`
      });
    }
  });
  const AccordionItemWrapper = styled__default.default.div`
    width: 100%;
    background-color: ${(props) => {
    var _a3;
    return (_a3 = props.backgroundColor) !== null && _a3 !== void 0 ? _a3 : props.theme.colors.blue1;
  }};
    border: 1px solid ${(props) => props.theme.colors.grey1};
    border-radius: 0.25rem;

    /* Define the animation used for collapsing */
    /* stylelint-disable-next-line -- external classname */
    .ReactCollapse--collapse {
        transition: height 0.35s ease;
    }
`;
  const AccordionLabel = styled__default.default.dt`
    cursor: pointer;

    display: flex;
    align-items: center;
    justify-content: space-between;

    width: 100%;
    padding: 0.5rem 1rem;

    font-size: 1.2em;
    font-weight: 400;
    color: ${(props) => props.theme.colors.text};

    background-color: ${(props) => props.theme.colors.grey1};
    border: none;
    border-radius: ${(props) => props.isOpen ? "0.25rem 0.25rem 0rem 0rem" : "0.25rem"};

    &:hover {
        background-color: ${(props) => props.theme.colors.grey2};
    }

    &:active {
        background-color: ${(props) => props.theme.colors.grey3};
    }
`;
  const ContentWrapper = styled__default.default.dd`
    overflow: hidden;

    width: 100%;
    height: 100%;

    /*
    We have to use padding for the gap between items rather than margin
    because margin doesn't work well with react-collapse and causes jumping
    See: https://github.com/nkbt/react-collapse#behaviour-notes
    */
    margin: 0;
    padding: 1rem;
`;
  const AccordionContent = styled__default.default.div`
    display: flex;

    height: auto;

    font-size: 1em;
    font-weight: 300;
    color: ${(props) => props.theme.colors.text};
`;
  function AccordionItem({ backgroundColor, headerRenderer: headerRenderer2, innerRenderer, item, onClick, open }) {
    return jsxRuntime.exports.jsxs(AccordionItemWrapper, { backgroundColor, children: [jsxRuntime.exports.jsxs(AccordionLabel, { isOpen: open, onClick, children: [headerRenderer2 ? headerRenderer2(item) : item.label, jsxRuntime.exports.jsx(Chevron$2, { isOpen: open })] }), jsxRuntime.exports.jsx(lib$2.Collapse, { isOpened: open, children: jsxRuntime.exports.jsx(ContentWrapper, { children: jsxRuntime.exports.jsx(AccordionContent, { children: innerRenderer ? innerRenderer(item) : item.content }) }) })] }, item.label);
  }
  const AccordionWrapper = styled__default.default.dl`
    overflow: auto;
    display: flex;
    flex-direction: column;
    gap: 2px;
    align-items: center;

    width: 100%;
    height: 100%;
`;
  function getInitialOpen(initialItems, value, itemsArray) {
    if (value !== void 0) {
      const initialOpen = Array.isArray(value) ? value : [value];
      return itemsArray.map((item, index2) => {
        return initialOpen.includes(index2);
      });
    }
    if (initialItems !== void 0) {
      const initialOpen = Array.isArray(initialItems) ? initialItems : [initialItems];
      return itemsArray.map((item, index2) => {
        return initialOpen.includes(index2);
      });
    }
    return new Array(itemsArray.length).fill(false);
  }
  function Accordion$1({ backgroundColor, className, initialOpenItems, headerRenderer: headerRenderer2, innerRenderer, items, style: style2, multi = true, onChange: onChange2, value }) {
    const [openItems, setOpenItems] = React.useState(getInitialOpen(initialOpenItems, value, items));
    const onClick = React.useCallback((index2) => {
      let newOpenItems = openItems;
      if (!multi) {
        newOpenItems = openItems.map((item, idx) => {
          if (idx === index2) {
            return !item;
          }
          return false;
        });
      } else {
        newOpenItems[index2] = !openItems[index2];
      }
      const chosenItems = newOpenItems.reduce((acc, curr, idx) => {
        if (curr) {
          acc.push(idx);
        }
        return acc;
      }, []);
      onChange2 === null || onChange2 === void 0 ? void 0 : onChange2([...chosenItems]);
      if (value === void 0) {
        setOpenItems([...newOpenItems]);
      }
    }, [multi, onChange2, openItems, value]);
    React.useEffect(() => {
      setOpenItems(getInitialOpen(initialOpenItems, value, items));
    }, [value]);
    return jsxRuntime.exports.jsx(AccordionWrapper, { className, style: style2, children: items.map((item, index2) => jsxRuntime.exports.jsx(AccordionItem, { backgroundColor, headerRenderer: headerRenderer2, innerRenderer, item, onClick: () => onClick(index2), open: openItems[index2] }, `accordion-item-${index2}`)) });
  }
  const shouldForwardProp$2 = (prop) => !["color", "width"].includes(prop);
  const Badge = styled__default.default.span.withConfig({ shouldForwardProp: shouldForwardProp$2 })`
    display: inline-flex;
    align-items: center;
    justify-content: center;

    width: ${(props) => props.width || "auto"};
    height: ${(props) => props.height ? `${props.height}px` : "2rem"};
    padding: 0 0.75rem;

    font-size: 0.875rem;
    font-weight: 400;
    color: ${(props) => props.outline ? props.color : props.theme.colors.blue1};

    background-color: ${(props) => props.outline ? props.theme.colors.blue1 : props.color};
    border: 1px solid ${(props) => props.color};
    border-radius: ${(props) => props.height ? `${props.height / 2}px` : "1rem"};
`;
  function _extends$2() {
    return _extends$2 = Object.assign ? Object.assign.bind() : function(n2) {
      for (var e3 = 1; e3 < arguments.length; e3++) {
        var t2 = arguments[e3];
        for (var r2 in t2)
          ({}).hasOwnProperty.call(t2, r2) && (n2[r2] = t2[r2]);
      }
      return n2;
    }, _extends$2.apply(null, arguments);
  }
  function _assertThisInitialized$2(e3) {
    if (void 0 === e3)
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    return e3;
  }
  function _setPrototypeOf$2(t2, e3) {
    return _setPrototypeOf$2 = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(t3, e4) {
      return t3.__proto__ = e4, t3;
    }, _setPrototypeOf$2(t2, e3);
  }
  function _inheritsLoose$1(t2, o2) {
    t2.prototype = Object.create(o2.prototype), t2.prototype.constructor = t2, _setPrototypeOf$2(t2, o2);
  }
  function _getPrototypeOf$1(t2) {
    return _getPrototypeOf$1 = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function(t3) {
      return t3.__proto__ || Object.getPrototypeOf(t3);
    }, _getPrototypeOf$1(t2);
  }
  function _isNativeFunction(t2) {
    try {
      return -1 !== Function.toString.call(t2).indexOf("[native code]");
    } catch (n2) {
      return "function" == typeof t2;
    }
  }
  function _isNativeReflectConstruct$1() {
    try {
      var t2 = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
      }));
    } catch (t3) {
    }
    return (_isNativeReflectConstruct$1 = function _isNativeReflectConstruct2() {
      return !!t2;
    })();
  }
  function _construct(t2, e3, r2) {
    if (_isNativeReflectConstruct$1())
      return Reflect.construct.apply(null, arguments);
    var o2 = [null];
    o2.push.apply(o2, e3);
    var p2 = new (t2.bind.apply(t2, o2))();
    return r2 && _setPrototypeOf$2(p2, r2.prototype), p2;
  }
  function _wrapNativeSuper(t2) {
    var r2 = "function" == typeof Map ? /* @__PURE__ */ new Map() : void 0;
    return _wrapNativeSuper = function _wrapNativeSuper2(t3) {
      if (null === t3 || !_isNativeFunction(t3))
        return t3;
      if ("function" != typeof t3)
        throw new TypeError("Super expression must either be null or a function");
      if (void 0 !== r2) {
        if (r2.has(t3))
          return r2.get(t3);
        r2.set(t3, Wrapper2);
      }
      function Wrapper2() {
        return _construct(t3, arguments, _getPrototypeOf$1(this).constructor);
      }
      return Wrapper2.prototype = Object.create(t3.prototype, {
        constructor: {
          value: Wrapper2,
          enumerable: false,
          writable: true,
          configurable: true
        }
      }), _setPrototypeOf$2(Wrapper2, t3);
    }, _wrapNativeSuper(t2);
  }
  var PolishedError$1 = /* @__PURE__ */ function(_Error) {
    _inheritsLoose$1(PolishedError2, _Error);
    function PolishedError2(code2) {
      var _this;
      {
        _this = _Error.call(this, "An error occurred. See https://github.com/styled-components/polished/blob/master/src/internalHelpers/errors.md#" + code2 + " for more information.") || this;
      }
      return _assertThisInitialized$2(_this);
    }
    return PolishedError2;
  }(/* @__PURE__ */ _wrapNativeSuper(Error));
  function colorToInt$1(color2) {
    return Math.round(color2 * 255);
  }
  function convertToInt$1(red, green, blue) {
    return colorToInt$1(red) + "," + colorToInt$1(green) + "," + colorToInt$1(blue);
  }
  function hslToRgb$1(hue, saturation, lightness, convert2) {
    if (convert2 === void 0) {
      convert2 = convertToInt$1;
    }
    if (saturation === 0) {
      return convert2(lightness, lightness, lightness);
    }
    var huePrime = (hue % 360 + 360) % 360 / 60;
    var chroma = (1 - Math.abs(2 * lightness - 1)) * saturation;
    var secondComponent = chroma * (1 - Math.abs(huePrime % 2 - 1));
    var red = 0;
    var green = 0;
    var blue = 0;
    if (huePrime >= 0 && huePrime < 1) {
      red = chroma;
      green = secondComponent;
    } else if (huePrime >= 1 && huePrime < 2) {
      red = secondComponent;
      green = chroma;
    } else if (huePrime >= 2 && huePrime < 3) {
      green = chroma;
      blue = secondComponent;
    } else if (huePrime >= 3 && huePrime < 4) {
      green = secondComponent;
      blue = chroma;
    } else if (huePrime >= 4 && huePrime < 5) {
      red = secondComponent;
      blue = chroma;
    } else if (huePrime >= 5 && huePrime < 6) {
      red = chroma;
      blue = secondComponent;
    }
    var lightnessModification = lightness - chroma / 2;
    var finalRed = red + lightnessModification;
    var finalGreen = green + lightnessModification;
    var finalBlue = blue + lightnessModification;
    return convert2(finalRed, finalGreen, finalBlue);
  }
  var namedColorMap$1 = {
    aliceblue: "f0f8ff",
    antiquewhite: "faebd7",
    aqua: "00ffff",
    aquamarine: "7fffd4",
    azure: "f0ffff",
    beige: "f5f5dc",
    bisque: "ffe4c4",
    black: "000",
    blanchedalmond: "ffebcd",
    blue: "0000ff",
    blueviolet: "8a2be2",
    brown: "a52a2a",
    burlywood: "deb887",
    cadetblue: "5f9ea0",
    chartreuse: "7fff00",
    chocolate: "d2691e",
    coral: "ff7f50",
    cornflowerblue: "6495ed",
    cornsilk: "fff8dc",
    crimson: "dc143c",
    cyan: "00ffff",
    darkblue: "00008b",
    darkcyan: "008b8b",
    darkgoldenrod: "b8860b",
    darkgray: "a9a9a9",
    darkgreen: "006400",
    darkgrey: "a9a9a9",
    darkkhaki: "bdb76b",
    darkmagenta: "8b008b",
    darkolivegreen: "556b2f",
    darkorange: "ff8c00",
    darkorchid: "9932cc",
    darkred: "8b0000",
    darksalmon: "e9967a",
    darkseagreen: "8fbc8f",
    darkslateblue: "483d8b",
    darkslategray: "2f4f4f",
    darkslategrey: "2f4f4f",
    darkturquoise: "00ced1",
    darkviolet: "9400d3",
    deeppink: "ff1493",
    deepskyblue: "00bfff",
    dimgray: "696969",
    dimgrey: "696969",
    dodgerblue: "1e90ff",
    firebrick: "b22222",
    floralwhite: "fffaf0",
    forestgreen: "228b22",
    fuchsia: "ff00ff",
    gainsboro: "dcdcdc",
    ghostwhite: "f8f8ff",
    gold: "ffd700",
    goldenrod: "daa520",
    gray: "808080",
    green: "008000",
    greenyellow: "adff2f",
    grey: "808080",
    honeydew: "f0fff0",
    hotpink: "ff69b4",
    indianred: "cd5c5c",
    indigo: "4b0082",
    ivory: "fffff0",
    khaki: "f0e68c",
    lavender: "e6e6fa",
    lavenderblush: "fff0f5",
    lawngreen: "7cfc00",
    lemonchiffon: "fffacd",
    lightblue: "add8e6",
    lightcoral: "f08080",
    lightcyan: "e0ffff",
    lightgoldenrodyellow: "fafad2",
    lightgray: "d3d3d3",
    lightgreen: "90ee90",
    lightgrey: "d3d3d3",
    lightpink: "ffb6c1",
    lightsalmon: "ffa07a",
    lightseagreen: "20b2aa",
    lightskyblue: "87cefa",
    lightslategray: "789",
    lightslategrey: "789",
    lightsteelblue: "b0c4de",
    lightyellow: "ffffe0",
    lime: "0f0",
    limegreen: "32cd32",
    linen: "faf0e6",
    magenta: "f0f",
    maroon: "800000",
    mediumaquamarine: "66cdaa",
    mediumblue: "0000cd",
    mediumorchid: "ba55d3",
    mediumpurple: "9370db",
    mediumseagreen: "3cb371",
    mediumslateblue: "7b68ee",
    mediumspringgreen: "00fa9a",
    mediumturquoise: "48d1cc",
    mediumvioletred: "c71585",
    midnightblue: "191970",
    mintcream: "f5fffa",
    mistyrose: "ffe4e1",
    moccasin: "ffe4b5",
    navajowhite: "ffdead",
    navy: "000080",
    oldlace: "fdf5e6",
    olive: "808000",
    olivedrab: "6b8e23",
    orange: "ffa500",
    orangered: "ff4500",
    orchid: "da70d6",
    palegoldenrod: "eee8aa",
    palegreen: "98fb98",
    paleturquoise: "afeeee",
    palevioletred: "db7093",
    papayawhip: "ffefd5",
    peachpuff: "ffdab9",
    peru: "cd853f",
    pink: "ffc0cb",
    plum: "dda0dd",
    powderblue: "b0e0e6",
    purple: "800080",
    rebeccapurple: "639",
    red: "f00",
    rosybrown: "bc8f8f",
    royalblue: "4169e1",
    saddlebrown: "8b4513",
    salmon: "fa8072",
    sandybrown: "f4a460",
    seagreen: "2e8b57",
    seashell: "fff5ee",
    sienna: "a0522d",
    silver: "c0c0c0",
    skyblue: "87ceeb",
    slateblue: "6a5acd",
    slategray: "708090",
    slategrey: "708090",
    snow: "fffafa",
    springgreen: "00ff7f",
    steelblue: "4682b4",
    tan: "d2b48c",
    teal: "008080",
    thistle: "d8bfd8",
    tomato: "ff6347",
    turquoise: "40e0d0",
    violet: "ee82ee",
    wheat: "f5deb3",
    white: "fff",
    whitesmoke: "f5f5f5",
    yellow: "ff0",
    yellowgreen: "9acd32"
  };
  function nameToHex$1(color2) {
    if (typeof color2 !== "string")
      return color2;
    var normalizedColorName = color2.toLowerCase();
    return namedColorMap$1[normalizedColorName] ? "#" + namedColorMap$1[normalizedColorName] : color2;
  }
  var hexRegex$1 = /^#[a-fA-F0-9]{6}$/;
  var hexRgbaRegex$1 = /^#[a-fA-F0-9]{8}$/;
  var reducedHexRegex$1 = /^#[a-fA-F0-9]{3}$/;
  var reducedRgbaHexRegex$1 = /^#[a-fA-F0-9]{4}$/;
  var rgbRegex$1 = /^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/i;
  var rgbaRegex$1 = /^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;
  var hslRegex$1 = /^hsl\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*\)$/i;
  var hslaRegex$1 = /^hsla\(\s*(\d{0,3}[.]?[0-9]+)\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*(\d{1,3}[.]?[0-9]?)%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/i;
  function parseToRgb$1(color2) {
    if (typeof color2 !== "string") {
      throw new PolishedError$1(3);
    }
    var normalizedColor = nameToHex$1(color2);
    if (normalizedColor.match(hexRegex$1)) {
      return {
        red: parseInt("" + normalizedColor[1] + normalizedColor[2], 16),
        green: parseInt("" + normalizedColor[3] + normalizedColor[4], 16),
        blue: parseInt("" + normalizedColor[5] + normalizedColor[6], 16)
      };
    }
    if (normalizedColor.match(hexRgbaRegex$1)) {
      var alpha = parseFloat((parseInt("" + normalizedColor[7] + normalizedColor[8], 16) / 255).toFixed(2));
      return {
        red: parseInt("" + normalizedColor[1] + normalizedColor[2], 16),
        green: parseInt("" + normalizedColor[3] + normalizedColor[4], 16),
        blue: parseInt("" + normalizedColor[5] + normalizedColor[6], 16),
        alpha
      };
    }
    if (normalizedColor.match(reducedHexRegex$1)) {
      return {
        red: parseInt("" + normalizedColor[1] + normalizedColor[1], 16),
        green: parseInt("" + normalizedColor[2] + normalizedColor[2], 16),
        blue: parseInt("" + normalizedColor[3] + normalizedColor[3], 16)
      };
    }
    if (normalizedColor.match(reducedRgbaHexRegex$1)) {
      var _alpha = parseFloat((parseInt("" + normalizedColor[4] + normalizedColor[4], 16) / 255).toFixed(2));
      return {
        red: parseInt("" + normalizedColor[1] + normalizedColor[1], 16),
        green: parseInt("" + normalizedColor[2] + normalizedColor[2], 16),
        blue: parseInt("" + normalizedColor[3] + normalizedColor[3], 16),
        alpha: _alpha
      };
    }
    var rgbMatched = rgbRegex$1.exec(normalizedColor);
    if (rgbMatched) {
      return {
        red: parseInt("" + rgbMatched[1], 10),
        green: parseInt("" + rgbMatched[2], 10),
        blue: parseInt("" + rgbMatched[3], 10)
      };
    }
    var rgbaMatched = rgbaRegex$1.exec(normalizedColor);
    if (rgbaMatched) {
      return {
        red: parseInt("" + rgbaMatched[1], 10),
        green: parseInt("" + rgbaMatched[2], 10),
        blue: parseInt("" + rgbaMatched[3], 10),
        alpha: parseFloat("" + rgbaMatched[4])
      };
    }
    var hslMatched = hslRegex$1.exec(normalizedColor);
    if (hslMatched) {
      var hue = parseInt("" + hslMatched[1], 10);
      var saturation = parseInt("" + hslMatched[2], 10) / 100;
      var lightness = parseInt("" + hslMatched[3], 10) / 100;
      var rgbColorString = "rgb(" + hslToRgb$1(hue, saturation, lightness) + ")";
      var hslRgbMatched = rgbRegex$1.exec(rgbColorString);
      if (!hslRgbMatched) {
        throw new PolishedError$1(4, normalizedColor, rgbColorString);
      }
      return {
        red: parseInt("" + hslRgbMatched[1], 10),
        green: parseInt("" + hslRgbMatched[2], 10),
        blue: parseInt("" + hslRgbMatched[3], 10)
      };
    }
    var hslaMatched = hslaRegex$1.exec(normalizedColor);
    if (hslaMatched) {
      var _hue = parseInt("" + hslaMatched[1], 10);
      var _saturation = parseInt("" + hslaMatched[2], 10) / 100;
      var _lightness = parseInt("" + hslaMatched[3], 10) / 100;
      var _rgbColorString = "rgb(" + hslToRgb$1(_hue, _saturation, _lightness) + ")";
      var _hslRgbMatched = rgbRegex$1.exec(_rgbColorString);
      if (!_hslRgbMatched) {
        throw new PolishedError$1(4, normalizedColor, _rgbColorString);
      }
      return {
        red: parseInt("" + _hslRgbMatched[1], 10),
        green: parseInt("" + _hslRgbMatched[2], 10),
        blue: parseInt("" + _hslRgbMatched[3], 10),
        alpha: parseFloat("" + hslaMatched[4])
      };
    }
    throw new PolishedError$1(5);
  }
  var reduceHexValue$2 = function reduceHexValue2(value) {
    if (value.length === 7 && value[1] === value[2] && value[3] === value[4] && value[5] === value[6]) {
      return "#" + value[1] + value[3] + value[5];
    }
    return value;
  };
  function numberToHex$1(value) {
    var hex2 = value.toString(16);
    return hex2.length === 1 ? "0" + hex2 : hex2;
  }
  function rgb$2(value, green, blue) {
    if (typeof value === "number" && typeof green === "number" && typeof blue === "number") {
      return reduceHexValue$2("#" + numberToHex$1(value) + numberToHex$1(green) + numberToHex$1(blue));
    } else if (typeof value === "object" && green === void 0 && blue === void 0) {
      return reduceHexValue$2("#" + numberToHex$1(value.red) + numberToHex$1(value.green) + numberToHex$1(value.blue));
    }
    throw new PolishedError$1(6);
  }
  function rgba$3(firstValue, secondValue, thirdValue, fourthValue) {
    if (typeof firstValue === "string" && typeof secondValue === "number") {
      var rgbValue = parseToRgb$1(firstValue);
      return "rgba(" + rgbValue.red + "," + rgbValue.green + "," + rgbValue.blue + "," + secondValue + ")";
    } else if (typeof firstValue === "number" && typeof secondValue === "number" && typeof thirdValue === "number" && typeof fourthValue === "number") {
      return fourthValue >= 1 ? rgb$2(firstValue, secondValue, thirdValue) : "rgba(" + firstValue + "," + secondValue + "," + thirdValue + "," + fourthValue + ")";
    } else if (typeof firstValue === "object" && secondValue === void 0 && thirdValue === void 0 && fourthValue === void 0) {
      return firstValue.alpha >= 1 ? rgb$2(firstValue.red, firstValue.green, firstValue.blue) : "rgba(" + firstValue.red + "," + firstValue.green + "," + firstValue.blue + "," + firstValue.alpha + ")";
    }
    throw new PolishedError$1(7);
  }
  function curried$1(f2, length, acc) {
    return function fn2() {
      var combined = acc.concat(Array.prototype.slice.call(arguments));
      return combined.length >= length ? f2.apply(this, combined) : curried$1(f2, length, combined);
    };
  }
  function curry$1(f2) {
    return curried$1(f2, f2.length, []);
  }
  function guard$1(lowerBoundary, upperBoundary, value) {
    return Math.max(lowerBoundary, Math.min(upperBoundary, value));
  }
  function transparentize$1(amount, color2) {
    if (color2 === "transparent")
      return color2;
    var parsedColor = parseToRgb$1(color2);
    var alpha = typeof parsedColor.alpha === "number" ? parsedColor.alpha : 1;
    var colorWithAlpha = _extends$2({}, parsedColor, {
      alpha: guard$1(0, 1, (alpha * 100 - parseFloat(amount) * 100) / 100)
    });
    return rgba$3(colorWithAlpha);
  }
  var curriedTransparentize$2 = /* @__PURE__ */ curry$1(transparentize$1);
  const Wrapper$c = styled__default.default.div`
    display: flex;
    gap: 1rem;
    align-items: center;
    justify-content: center;

    height: 100%;
`;
  const LoadingText = styled__default.default.span`
    font-size: 1.2rem;
    color: ${(props) => {
    var _a3;
    return (_a3 = props.color) !== null && _a3 !== void 0 ? _a3 : props.theme.colors.grey4;
  }};
`;
  const Loader$1 = styled__default.default.span`
    position: relative;
    width: ${(props) => {
    var _a3;
    return (_a3 = props.size) !== null && _a3 !== void 0 ? _a3 : "2.5rem";
  }};
    height: ${(props) => {
    var _a3;
    return (_a3 = props.size) !== null && _a3 !== void 0 ? _a3 : "2.5rem";
  }};
    animation: sk-chase 2.5s infinite linear both;

    .sk-chase-dot {
        position: absolute;
        top: 0;
        left: 0;

        width: 100%;
        height: 100%;

        animation: sk-chase-dot 2s infinite ease-in-out both;
    }

    .sk-chase-dot::before {
        content: '';

        display: block;

        width: 25%;
        height: 25%;

        background-color: ${(props) => {
    var _a3;
    return (_a3 = props.color) !== null && _a3 !== void 0 ? _a3 : props.theme.colors.grey4;
  }};
        border-radius: 100%;

        animation: sk-chase-dot-before 2s infinite ease-in-out both;
    }

    .sk-chase-dot:nth-child(1) {
        animation-delay: -1.1s;
    }

    .sk-chase-dot:nth-child(2) {
        animation-delay: -1s;
    }

    .sk-chase-dot:nth-child(3) {
        animation-delay: -0.9s;
    }

    .sk-chase-dot:nth-child(4) {
        animation-delay: -0.8s;
    }

    .sk-chase-dot:nth-child(5) {
        animation-delay: -0.7s;
    }

    .sk-chase-dot:nth-child(6) {
        animation-delay: -0.6s;
    }

    .sk-chase-dot:nth-child(1)::before {
        animation-delay: -1.1s;
    }

    .sk-chase-dot:nth-child(2)::before {
        animation-delay: -1s;
    }

    .sk-chase-dot:nth-child(3)::before {
        animation-delay: -0.9s;
    }

    .sk-chase-dot:nth-child(4)::before {
        animation-delay: -0.8s;
    }

    .sk-chase-dot:nth-child(5)::before {
        animation-delay: -0.7s;
    }

    .sk-chase-dot:nth-child(6)::before {
        animation-delay: -0.6s;
    }

    @keyframes sk-chase {
        100% {
            transform: rotate(360deg);
        }
    }

    @keyframes sk-chase-dot {
        80%,
        100% {
            transform: rotate(360deg);
        }
    }

    @keyframes sk-chase-dot-before {
        50% {
            transform: scale(0.4);
        }

        100%,
        0% {
            transform: scale(1);
        }
    }
`;
  function Spinner(props) {
    var _a3;
    return jsxRuntime.exports.jsxs(Wrapper$c, { className: props.className, style: props.style, children: [jsxRuntime.exports.jsxs(Loader$1, { color: props.color, size: props.size, children: [jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" }), jsxRuntime.exports.jsx("div", { className: "sk-chase-dot" })] }), (props.showText || props.text) && jsxRuntime.exports.jsx(LoadingText, { color: props.color, children: (_a3 = props.text) !== null && _a3 !== void 0 ? _a3 : "LOADING" })] });
  }
  var __rest$f = globalThis && globalThis.__rest || function(s2, e3) {
    var t2 = {};
    for (var p2 in s2)
      if (Object.prototype.hasOwnProperty.call(s2, p2) && e3.indexOf(p2) < 0)
        t2[p2] = s2[p2];
    if (s2 != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i2 = 0, p2 = Object.getOwnPropertySymbols(s2); i2 < p2.length; i2++) {
        if (e3.indexOf(p2[i2]) < 0 && Object.prototype.propertyIsEnumerable.call(s2, p2[i2]))
          t2[p2[i2]] = s2[p2[i2]];
      }
    return t2;
  };
  const BaseButton = styled__default.default.button`
    cursor: ${(props) => props.disabled ? "not-allowed" : "pointer"};
    user-select: none;

    display: flex;
    align-items: center;
    justify-content: center;

    height: 2.5rem;
    padding: ${(props) => props.$hasAnchor ? 0 : "0 1rem"};
    padding: 0 1rem;

    font-size: 1rem;
    font-weight: 600;

    border: none;
    border-radius: 0.25rem;
`;
  function getOutlinedButtonStyle(buttonColor, disabled2, theme2) {
    return `
        color: ${disabled2 ? theme2.colors.grey2 : buttonColor};

        background-color: transparent;
        border: 1px solid
            ${disabled2 ? theme2.colors.grey2 : buttonColor};

        :hover:not(:disabled) {
            background-color: ${theme2.themeType === "dark" ? curriedTransparentize$2(0.85, buttonColor) : curriedTransparentize$2(0.9, buttonColor)};
        }

        :active:not(:disabled) {
            background-color: ${theme2.themeType === "dark" ? curriedTransparentize$2(0.7, buttonColor) : curriedTransparentize$2(0.8, buttonColor)};
        }
    `;
  }
  function getFilledButtonStyle(buttonColor, hoverColor, clickColor, disabled2, theme2, textColor) {
    const color2 = textColor !== null && textColor !== void 0 ? textColor : theme2.colors.blue1;
    return `
        color: ${color2};

        background-color: ${disabled2 ? theme2.colors.grey2 : buttonColor};

        :hover:not(:disabled) {
            background-color: ${hoverColor};
        }

        :active:not(:disabled) {
            background-color: ${clickColor};
        }
    `;
  }
  const PrimaryButton$1 = styled__default.default(BaseButton)`
    ${(props) => props.outline ? getOutlinedButtonStyle(props.theme.colors.primary, props.disabled, props.theme) : getFilledButtonStyle(props.theme.colors.primary, props.theme.colors.primaryHover, props.theme.colors.primaryDown, props.disabled, props.theme)}
`;
  const SecondaryButton$1 = styled__default.default(BaseButton)`
    ${(props) => props.outline ? getOutlinedButtonStyle(props.theme.colors.secondary, props.disabled, props.theme) : getFilledButtonStyle(props.theme.colors.secondary, props.theme.colors.secondaryHover, props.theme.colors.secondaryDown, props.disabled, props.theme)}
`;
  const GhostButton = styled__default.default(BaseButton)`
    ${(props) => getFilledButtonStyle("transparent", props.theme.colors.grey2, props.theme.colors.grey2, props.disabled, props.theme, props.theme.colors.grey4)}
`;
  const ErrorButton = styled__default.default(BaseButton)`
    ${(props) => props.outline ? getOutlinedButtonStyle(props.theme.colors.error, props.disabled, props.theme) : getFilledButtonStyle(props.theme.colors.error, props.theme.colors.errorHover, props.theme.colors.errorDown, props.disabled, props.theme)}
`;
  const PlainButton = styled__default.default(BaseButton)`
    ${(props) => props.outline ? getOutlinedButtonStyle(props.theme.colors.grey6, props.disabled, props.theme) : getFilledButtonStyle("transparent", props.theme.colors.grey1, props.theme.colors.grey2, props.disabled, props.theme, props.theme.colors.grey6)}
`;
  const AnchorWrapper = styled__default.default.a`
    display: flex;
    align-items: center;
    justify-content: center;

    width: 100%;
    height: 100%;
    padding: 0 1rem;

    color: inherit;

    :hover,
    :active {
        color: inherit;
        text-decoration: none;
    }
`;
  const StyledLoading = styled__default.default(Spinner)`
    padding: 1rem 2rem;
`;
  const stylingMap = {
    error: ErrorButton,
    ghost: GhostButton,
    plain: PlainButton,
    primary: PrimaryButton$1,
    secondary: SecondaryButton$1
  };
  function Button$2(_a3, ref2) {
    var { autoFocus, children: children2, className, disabled: disabled2, download, href, loading, id: id2, onClick, outline = false, style: style2, styling = "primary", type: type2 = "button" } = _a3, props = __rest$f(_a3, ["autoFocus", "children", "className", "disabled", "download", "href", "loading", "id", "onClick", "outline", "style", "styling", "type"]);
    const currentTheme = useClTheme();
    const Component = stylingMap[styling];
    const content2 = loading ? jsxRuntime.exports.jsx(StyledLoading, { color: outline ? currentTheme.colors.grey2 : currentTheme.colors.blue1 }) : children2;
    const wrappedContent = href ? jsxRuntime.exports.jsx(AnchorWrapper, { download, href, children: content2 }) : content2;
    return jsxRuntime.exports.jsx(Component, Object.assign({ "$hasAnchor": !!href, autoFocus, className, disabled: disabled2 || loading, id: id2, onClick, outline, style: style2, type: type2 }, props, { ref: ref2, children: wrappedContent }));
  }
  const Button$3 = React.forwardRef(Button$2);
  const ButtonBarWrapper = styled__default.default.div`
    overflow: hidden;
    display: flex;
    flex: 1 1 auto;

    height: 2.5rem;

    border: 1px solid ${(props) => {
    var _a3;
    return props.disabled ? props.theme.colors.grey2 : (_a3 = props.theme.colors) === null || _a3 === void 0 ? void 0 : _a3[props.styling];
  }};
    border-radius: 0.25rem;

    button:not(:last-child) {
        border-right: 1px solid
            ${(props) => {
    var _a3;
    return props.disabled ? props.theme.colors.grey2 : (_a3 = props.theme.colors) === null || _a3 === void 0 ? void 0 : _a3[props.styling];
  }};
    }
`;
  const shouldForwardProp$1 = (prop) => !["selected"].includes(prop);
  function getButtonStyle(buttonColor, disabled2, selected, theme2) {
    let color2 = buttonColor;
    let backgroundColor = "transparent";
    if (selected) {
      color2 = theme2.colors.background;
      backgroundColor = buttonColor;
    }
    if (disabled2) {
      color2 = theme2.colors.grey2;
      backgroundColor = theme2.colors.blue1;
    }
    if (disabled2 && selected) {
      color2 = theme2.colors.blue1;
      backgroundColor = theme2.colors.grey2;
    }
    return `
    flex: 1 1 auto;

    margin: 0px;

    color: ${color2};

    background-color: ${backgroundColor};
    border-radius: 0px;
    height: 100%;

    ${!selected && (theme2.themeType === "dark" ? `
        :hover:not(:disabled) {
            background-color: ${curriedTransparentize$2(0.8, buttonColor)};
        }


        :active:not(:disabled) {
            background-color: ${curriedTransparentize$2(0.6, buttonColor)};
        }
    ` : `
        :hover:not(:disabled) {
            background-color: ${curriedTransparentize$2(0.9, buttonColor)};
        }


        :active:not(:disabled) {
            background-color: ${curriedTransparentize$2(0.8, buttonColor)};
        }
    `)}
    `;
  }
  const PrimaryButton = styled__default.default(BaseButton).withConfig({ shouldForwardProp: shouldForwardProp$1 })`
    ${(props) => getButtonStyle(props.theme.colors.primary, props.disabled, props.selected, props.theme)}
`;
  const SecondaryButton = styled__default.default(BaseButton).withConfig({ shouldForwardProp: shouldForwardProp$1 })`
    ${(props) => getButtonStyle(props.theme.colors.secondary, props.disabled, props.selected, props.theme)}
`;
  function ButtonBar$1({ className, disabled: disabled2, id: id2, value, initialValue, items, onSelect, style: style2, styling = "primary" }) {
    const [selected, setSelected] = React.useState(value || initialValue || items[0]);
    const ButtonComponent = styling === "secondary" ? SecondaryButton : PrimaryButton;
    const onClick = React.useCallback((item) => {
      onSelect === null || onSelect === void 0 ? void 0 : onSelect(item);
      if (value === void 0) {
        setSelected(item);
      }
    }, [value, onSelect]);
    React.useEffect(() => {
      setSelected(value || initialValue || items[0]);
    }, [value]);
    return jsxRuntime.exports.jsx(ButtonBarWrapper, { className, disabled: disabled2, style: style2, styling, children: items.map((item) => jsxRuntime.exports.jsx(ButtonComponent, { "$hasAnchor": false, "aria-selected": selected.value === item.value, disabled: disabled2, id: id2, onClick: () => onClick(item), selected: selected.value === item.value, type: "button", children: item.label }, `option-${String(item.value)}`)) });
  }
  const CarouselComponent = styled__default.default.div`
    position: relative;

    overflow: hidden;
    display: flex;
    flex: 1 1 auto;
    flex-direction: column;
    justify-content: center;

    max-height: 100%;
    padding: 0 0.5rem;
`;
  const CarouselItemsContainer = styled__default.default.div`
    display: inline-flex;
    max-height: calc(100% - 1.625rem);
    white-space: nowrap;
    transition: transform 0.3s;
`;
  const CarouselItemWrapper = styled__default.default.div`
    display: flex;
    flex: 1 0 auto;
    justify-content: center;

    width: 100%;
    min-height: 5rem;
    max-height: 100%;
`;
  const CarouselIndicators = styled__default.default.div`
    display: flex;
    gap: 0.2rem;
    justify-content: center;
`;
  const Button$1 = styled__default.default.button`
    cursor: pointer;
    user-select: none;

    position: absolute;
    z-index: 3;
    top: calc(50% - 0.5rem);
    transform: translateY(-50%);

    display: flex;
    align-items: center;

    padding: 0;

    color: ${(props) => props.theme.colors.grey4};

    background-color: inherit;
    border: none;

    :hover {
        color: ${(props) => props.theme.colors.grey5};
    }
`;
  const CircleSelect = styled__default.default.button`
    cursor: pointer;
    user-select: none;

    z-index: 3;

    padding: 0;

    color: ${(props) => props.selected ? props.theme.colors.grey4 : props.theme.colors.grey3};

    background-color: inherit;
    border: none;

    :hover {
        color: ${(props) => props.theme.colors.grey4};
    }

    svg {
        width: 0.5rem;
        height: 0.5rem;
    }
`;
  const ImageWrapper = styled__default.default.div`
    display: flex;
    flex: 0 0 auto;
    align-items: center;
    justify-content: center;
`;
  const TextWrapper = styled__default.default.div`
    overflow: auto;
    display: flex;
    flex: 1 1 auto;
    flex-direction: column;

    box-sizing: border-box;
    margin: 1rem 0;
    padding: 0 1.5rem;

    color: ${(props) => props.theme.colors.text};
`;
  const Title$3 = styled__default.default.div`
    display: flex;
    flex: 0 0 auto;
    font-weight: bold;
    color: ${(props) => props.theme.colors.text};
`;
  const CarouselItemContainer = (props) => {
    return jsxRuntime.exports.jsx(CarouselItemWrapper, { children: jsxRuntime.exports.jsxs("div", { style: {
      display: "flex",
      flexDirection: "column",
      margin: "0rem 1rem",
      overflow: "auto",
      whiteSpace: "normal"
    }, children: [props.item.image && jsxRuntime.exports.jsx(ImageWrapper, { children: jsxRuntime.exports.jsx("img", { alt: props.item.imageAlt, src: props.item.image, style: {
      height: props.item.imageHeight,
      width: props.item.imageWidth
    } }) }), (props.item.title || props.item.subtitle) && jsxRuntime.exports.jsxs(TextWrapper, { style: {
      gap: `${props.item.title && props.item.subtitle ? "0.5rem" : "0"}`,
      maxWidth: "100%"
    }, children: [jsxRuntime.exports.jsx(Title$3, { children: props.item.title }), jsxRuntime.exports.jsx("span", { children: props.item.subtitle })] }), props.item.component && props.item.component] }) });
  };
  function Carousel$1(props) {
    const [activeIndex, setActiveIndex] = React.useState(props.value || props.initialValue || 0);
    const updateIndex = React.useCallback(
      (newIndex) => {
        var _a3;
        let _newIndex = newIndex;
        if (newIndex < 0) {
          _newIndex = props.items.length - 1;
        } else if (newIndex >= props.items.length) {
          _newIndex = 0;
        }
        (_a3 = props.onChange) === null || _a3 === void 0 ? void 0 : _a3.call(props, _newIndex);
        if (props.value === void 0) {
          setActiveIndex(_newIndex);
        }
      },
      [props.onChange, props.items, props.value]
    );
    React.useEffect(() => {
      setActiveIndex(props.value || props.initialValue || 0);
    }, [props.value]);
    return jsxRuntime.exports.jsxs(CarouselComponent, { className: props.className, style: props.style, children: [jsxRuntime.exports.jsx(Button$1, { "data-testid": "carousel-left-button", onClick: () => {
      updateIndex(activeIndex - 1);
    }, style: { left: "0.5rem" }, type: "button", children: jsxRuntime.exports.jsx(ChevronLeft, {}) }), jsxRuntime.exports.jsx(CarouselItemsContainer, { style: { transform: `translateX(-${activeIndex * 100}%)` }, children: props.items.map((item, index2) => {
      return jsxRuntime.exports.jsx(CarouselItemContainer, { item }, `carousel-item-${index2}`);
    }) }), jsxRuntime.exports.jsx(Button$1, { "data-testid": "carousel-right-button", onClick: () => {
      updateIndex(activeIndex + 1);
    }, style: { right: "0.5rem" }, type: "button", children: jsxRuntime.exports.jsx(ChevronRight, {}) }), jsxRuntime.exports.jsx(CarouselIndicators, { children: props.items.map((item, index2) => {
      return jsxRuntime.exports.jsx(CircleSelect, { onClick: () => {
        updateIndex(index2);
      }, selected: index2 === activeIndex, type: "button", children: jsxRuntime.exports.jsx(Circle$1, {}) }, `carousel-select-${index2}`);
    }) })] });
  }
  var lodash$1 = { exports: {} };
  /**
   * @license
   * Lodash <https://lodash.com/>
   * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
   * Released under MIT license <https://lodash.com/license>
   * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
   * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
   */
  (function(module2, exports3) {
    (function() {
      var undefined$12;
      var VERSION = "4.17.21";
      var LARGE_ARRAY_SIZE2 = 200;
      var CORE_ERROR_TEXT = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.", FUNC_ERROR_TEXT2 = "Expected a function", INVALID_TEMPL_VAR_ERROR_TEXT = "Invalid `variable` option passed into `_.template`";
      var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
      var MAX_MEMOIZE_SIZE2 = 500;
      var PLACEHOLDER = "__lodash_placeholder__";
      var CLONE_DEEP_FLAG2 = 1, CLONE_FLAT_FLAG2 = 2, CLONE_SYMBOLS_FLAG2 = 4;
      var COMPARE_PARTIAL_FLAG2 = 1, COMPARE_UNORDERED_FLAG2 = 2;
      var WRAP_BIND_FLAG = 1, WRAP_BIND_KEY_FLAG = 2, WRAP_CURRY_BOUND_FLAG = 4, WRAP_CURRY_FLAG = 8, WRAP_CURRY_RIGHT_FLAG = 16, WRAP_PARTIAL_FLAG = 32, WRAP_PARTIAL_RIGHT_FLAG = 64, WRAP_ARY_FLAG = 128, WRAP_REARG_FLAG = 256, WRAP_FLIP_FLAG = 512;
      var DEFAULT_TRUNC_LENGTH = 30, DEFAULT_TRUNC_OMISSION = "...";
      var HOT_COUNT = 800, HOT_SPAN = 16;
      var LAZY_FILTER_FLAG = 1, LAZY_MAP_FLAG = 2, LAZY_WHILE_FLAG = 3;
      var INFINITY2 = 1 / 0, MAX_SAFE_INTEGER2 = 9007199254740991, MAX_INTEGER2 = 17976931348623157e292, NAN2 = 0 / 0;
      var MAX_ARRAY_LENGTH2 = 4294967295, MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH2 - 1, HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH2 >>> 1;
      var wrapFlags = [
        ["ary", WRAP_ARY_FLAG],
        ["bind", WRAP_BIND_FLAG],
        ["bindKey", WRAP_BIND_KEY_FLAG],
        ["curry", WRAP_CURRY_FLAG],
        ["curryRight", WRAP_CURRY_RIGHT_FLAG],
        ["flip", WRAP_FLIP_FLAG],
        ["partial", WRAP_PARTIAL_FLAG],
        ["partialRight", WRAP_PARTIAL_RIGHT_FLAG],
        ["rearg", WRAP_REARG_FLAG]
      ];
      var argsTag2 = "[object Arguments]", arrayTag2 = "[object Array]", asyncTag2 = "[object AsyncFunction]", boolTag2 = "[object Boolean]", dateTag2 = "[object Date]", domExcTag = "[object DOMException]", errorTag2 = "[object Error]", funcTag2 = "[object Function]", genTag2 = "[object GeneratorFunction]", mapTag2 = "[object Map]", numberTag2 = "[object Number]", nullTag2 = "[object Null]", objectTag2 = "[object Object]", promiseTag2 = "[object Promise]", proxyTag2 = "[object Proxy]", regexpTag2 = "[object RegExp]", setTag2 = "[object Set]", stringTag2 = "[object String]", symbolTag2 = "[object Symbol]", undefinedTag2 = "[object Undefined]", weakMapTag2 = "[object WeakMap]", weakSetTag = "[object WeakSet]";
      var arrayBufferTag2 = "[object ArrayBuffer]", dataViewTag2 = "[object DataView]", float32Tag2 = "[object Float32Array]", float64Tag2 = "[object Float64Array]", int8Tag2 = "[object Int8Array]", int16Tag2 = "[object Int16Array]", int32Tag2 = "[object Int32Array]", uint8Tag2 = "[object Uint8Array]", uint8ClampedTag2 = "[object Uint8ClampedArray]", uint16Tag2 = "[object Uint16Array]", uint32Tag2 = "[object Uint32Array]";
      var reEmptyStringLeading = /\b__p \+= '';/g, reEmptyStringMiddle = /\b(__p \+=) '' \+/g, reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
      var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g, reUnescapedHtml = /[&<>"']/g, reHasEscapedHtml = RegExp(reEscapedHtml.source), reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
      var reEscape = /<%-([\s\S]+?)%>/g, reEvaluate = /<%([\s\S]+?)%>/g, reInterpolate = /<%=([\s\S]+?)%>/g;
      var reIsDeepProp2 = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp2 = /^\w*$/, rePropName2 = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
      var reRegExpChar2 = /[\\^$.*+?()[\]{}|]/g, reHasRegExpChar = RegExp(reRegExpChar2.source);
      var reTrimStart2 = /^\s+/;
      var reWhitespace2 = /\s/;
      var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/, reSplitDetails = /,? & /;
      var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
      var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
      var reEscapeChar2 = /\\(\\)?/g;
      var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
      var reFlags2 = /\w*$/;
      var reIsBadHex2 = /^[-+]0x[0-9a-f]+$/i;
      var reIsBinary2 = /^0b[01]+$/i;
      var reIsHostCtor2 = /^\[object .+?Constructor\]$/;
      var reIsOctal2 = /^0o[0-7]+$/i;
      var reIsUint2 = /^(?:0|[1-9]\d*)$/;
      var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
      var reNoMatch = /($^)/;
      var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
      var rsAstralRange = "\\ud800-\\udfff", rsComboMarksRange = "\\u0300-\\u036f", reComboHalfMarksRange = "\\ufe20-\\ufe2f", rsComboSymbolsRange = "\\u20d0-\\u20ff", rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange, rsDingbatRange = "\\u2700-\\u27bf", rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff", rsMathOpRange = "\\xac\\xb1\\xd7\\xf7", rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf", rsPunctuationRange = "\\u2000-\\u206f", rsSpaceRange = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000", rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde", rsVarRange = "\\ufe0e\\ufe0f", rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
      var rsApos = "['\u2019]", rsAstral = "[" + rsAstralRange + "]", rsBreak = "[" + rsBreakRange + "]", rsCombo = "[" + rsComboRange + "]", rsDigits = "\\d+", rsDingbat = "[" + rsDingbatRange + "]", rsLower = "[" + rsLowerRange + "]", rsMisc = "[^" + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + "]", rsFitz = "\\ud83c[\\udffb-\\udfff]", rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")", rsNonAstral = "[^" + rsAstralRange + "]", rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}", rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]", rsUpper = "[" + rsUpperRange + "]", rsZWJ = "\\u200d";
      var rsMiscLower = "(?:" + rsLower + "|" + rsMisc + ")", rsMiscUpper = "(?:" + rsUpper + "|" + rsMisc + ")", rsOptContrLower = "(?:" + rsApos + "(?:d|ll|m|re|s|t|ve))?", rsOptContrUpper = "(?:" + rsApos + "(?:D|LL|M|RE|S|T|VE))?", reOptMod = rsModifier + "?", rsOptVar = "[" + rsVarRange + "]?", rsOptJoin = "(?:" + rsZWJ + "(?:" + [rsNonAstral, rsRegional, rsSurrPair].join("|") + ")" + rsOptVar + reOptMod + ")*", rsOrdLower = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])", rsOrdUpper = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])", rsSeq = rsOptVar + reOptMod + rsOptJoin, rsEmoji = "(?:" + [rsDingbat, rsRegional, rsSurrPair].join("|") + ")" + rsSeq, rsSymbol = "(?:" + [rsNonAstral + rsCombo + "?", rsCombo, rsRegional, rsSurrPair, rsAstral].join("|") + ")";
      var reApos = RegExp(rsApos, "g");
      var reComboMark = RegExp(rsCombo, "g");
      var reUnicode = RegExp(rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq, "g");
      var reUnicodeWord = RegExp([
        rsUpper + "?" + rsLower + "+" + rsOptContrLower + "(?=" + [rsBreak, rsUpper, "$"].join("|") + ")",
        rsMiscUpper + "+" + rsOptContrUpper + "(?=" + [rsBreak, rsUpper + rsMiscLower, "$"].join("|") + ")",
        rsUpper + "?" + rsMiscLower + "+" + rsOptContrLower,
        rsUpper + "+" + rsOptContrUpper,
        rsOrdUpper,
        rsOrdLower,
        rsDigits,
        rsEmoji
      ].join("|"), "g");
      var reHasUnicode = RegExp("[" + rsZWJ + rsAstralRange + rsComboRange + rsVarRange + "]");
      var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
      var contextProps = [
        "Array",
        "Buffer",
        "DataView",
        "Date",
        "Error",
        "Float32Array",
        "Float64Array",
        "Function",
        "Int8Array",
        "Int16Array",
        "Int32Array",
        "Map",
        "Math",
        "Object",
        "Promise",
        "RegExp",
        "Set",
        "String",
        "Symbol",
        "TypeError",
        "Uint8Array",
        "Uint8ClampedArray",
        "Uint16Array",
        "Uint32Array",
        "WeakMap",
        "_",
        "clearTimeout",
        "isFinite",
        "parseInt",
        "setTimeout"
      ];
      var templateCounter = -1;
      var typedArrayTags2 = {};
      typedArrayTags2[float32Tag2] = typedArrayTags2[float64Tag2] = typedArrayTags2[int8Tag2] = typedArrayTags2[int16Tag2] = typedArrayTags2[int32Tag2] = typedArrayTags2[uint8Tag2] = typedArrayTags2[uint8ClampedTag2] = typedArrayTags2[uint16Tag2] = typedArrayTags2[uint32Tag2] = true;
      typedArrayTags2[argsTag2] = typedArrayTags2[arrayTag2] = typedArrayTags2[arrayBufferTag2] = typedArrayTags2[boolTag2] = typedArrayTags2[dataViewTag2] = typedArrayTags2[dateTag2] = typedArrayTags2[errorTag2] = typedArrayTags2[funcTag2] = typedArrayTags2[mapTag2] = typedArrayTags2[numberTag2] = typedArrayTags2[objectTag2] = typedArrayTags2[regexpTag2] = typedArrayTags2[setTag2] = typedArrayTags2[stringTag2] = typedArrayTags2[weakMapTag2] = false;
      var cloneableTags2 = {};
      cloneableTags2[argsTag2] = cloneableTags2[arrayTag2] = cloneableTags2[arrayBufferTag2] = cloneableTags2[dataViewTag2] = cloneableTags2[boolTag2] = cloneableTags2[dateTag2] = cloneableTags2[float32Tag2] = cloneableTags2[float64Tag2] = cloneableTags2[int8Tag2] = cloneableTags2[int16Tag2] = cloneableTags2[int32Tag2] = cloneableTags2[mapTag2] = cloneableTags2[numberTag2] = cloneableTags2[objectTag2] = cloneableTags2[regexpTag2] = cloneableTags2[setTag2] = cloneableTags2[stringTag2] = cloneableTags2[symbolTag2] = cloneableTags2[uint8Tag2] = cloneableTags2[uint8ClampedTag2] = cloneableTags2[uint16Tag2] = cloneableTags2[uint32Tag2] = true;
      cloneableTags2[errorTag2] = cloneableTags2[funcTag2] = cloneableTags2[weakMapTag2] = false;
      var deburredLetters = {
        "\xC0": "A",
        "\xC1": "A",
        "\xC2": "A",
        "\xC3": "A",
        "\xC4": "A",
        "\xC5": "A",
        "\xE0": "a",
        "\xE1": "a",
        "\xE2": "a",
        "\xE3": "a",
        "\xE4": "a",
        "\xE5": "a",
        "\xC7": "C",
        "\xE7": "c",
        "\xD0": "D",
        "\xF0": "d",
        "\xC8": "E",
        "\xC9": "E",
        "\xCA": "E",
        "\xCB": "E",
        "\xE8": "e",
        "\xE9": "e",
        "\xEA": "e",
        "\xEB": "e",
        "\xCC": "I",
        "\xCD": "I",
        "\xCE": "I",
        "\xCF": "I",
        "\xEC": "i",
        "\xED": "i",
        "\xEE": "i",
        "\xEF": "i",
        "\xD1": "N",
        "\xF1": "n",
        "\xD2": "O",
        "\xD3": "O",
        "\xD4": "O",
        "\xD5": "O",
        "\xD6": "O",
        "\xD8": "O",
        "\xF2": "o",
        "\xF3": "o",
        "\xF4": "o",
        "\xF5": "o",
        "\xF6": "o",
        "\xF8": "o",
        "\xD9": "U",
        "\xDA": "U",
        "\xDB": "U",
        "\xDC": "U",
        "\xF9": "u",
        "\xFA": "u",
        "\xFB": "u",
        "\xFC": "u",
        "\xDD": "Y",
        "\xFD": "y",
        "\xFF": "y",
        "\xC6": "Ae",
        "\xE6": "ae",
        "\xDE": "Th",
        "\xFE": "th",
        "\xDF": "ss",
        "\u0100": "A",
        "\u0102": "A",
        "\u0104": "A",
        "\u0101": "a",
        "\u0103": "a",
        "\u0105": "a",
        "\u0106": "C",
        "\u0108": "C",
        "\u010A": "C",
        "\u010C": "C",
        "\u0107": "c",
        "\u0109": "c",
        "\u010B": "c",
        "\u010D": "c",
        "\u010E": "D",
        "\u0110": "D",
        "\u010F": "d",
        "\u0111": "d",
        "\u0112": "E",
        "\u0114": "E",
        "\u0116": "E",
        "\u0118": "E",
        "\u011A": "E",
        "\u0113": "e",
        "\u0115": "e",
        "\u0117": "e",
        "\u0119": "e",
        "\u011B": "e",
        "\u011C": "G",
        "\u011E": "G",
        "\u0120": "G",
        "\u0122": "G",
        "\u011D": "g",
        "\u011F": "g",
        "\u0121": "g",
        "\u0123": "g",
        "\u0124": "H",
        "\u0126": "H",
        "\u0125": "h",
        "\u0127": "h",
        "\u0128": "I",
        "\u012A": "I",
        "\u012C": "I",
        "\u012E": "I",
        "\u0130": "I",
        "\u0129": "i",
        "\u012B": "i",
        "\u012D": "i",
        "\u012F": "i",
        "\u0131": "i",
        "\u0134": "J",
        "\u0135": "j",
        "\u0136": "K",
        "\u0137": "k",
        "\u0138": "k",
        "\u0139": "L",
        "\u013B": "L",
        "\u013D": "L",
        "\u013F": "L",
        "\u0141": "L",
        "\u013A": "l",
        "\u013C": "l",
        "\u013E": "l",
        "\u0140": "l",
        "\u0142": "l",
        "\u0143": "N",
        "\u0145": "N",
        "\u0147": "N",
        "\u014A": "N",
        "\u0144": "n",
        "\u0146": "n",
        "\u0148": "n",
        "\u014B": "n",
        "\u014C": "O",
        "\u014E": "O",
        "\u0150": "O",
        "\u014D": "o",
        "\u014F": "o",
        "\u0151": "o",
        "\u0154": "R",
        "\u0156": "R",
        "\u0158": "R",
        "\u0155": "r",
        "\u0157": "r",
        "\u0159": "r",
        "\u015A": "S",
        "\u015C": "S",
        "\u015E": "S",
        "\u0160": "S",
        "\u015B": "s",
        "\u015D": "s",
        "\u015F": "s",
        "\u0161": "s",
        "\u0162": "T",
        "\u0164": "T",
        "\u0166": "T",
        "\u0163": "t",
        "\u0165": "t",
        "\u0167": "t",
        "\u0168": "U",
        "\u016A": "U",
        "\u016C": "U",
        "\u016E": "U",
        "\u0170": "U",
        "\u0172": "U",
        "\u0169": "u",
        "\u016B": "u",
        "\u016D": "u",
        "\u016F": "u",
        "\u0171": "u",
        "\u0173": "u",
        "\u0174": "W",
        "\u0175": "w",
        "\u0176": "Y",
        "\u0177": "y",
        "\u0178": "Y",
        "\u0179": "Z",
        "\u017B": "Z",
        "\u017D": "Z",
        "\u017A": "z",
        "\u017C": "z",
        "\u017E": "z",
        "\u0132": "IJ",
        "\u0133": "ij",
        "\u0152": "Oe",
        "\u0153": "oe",
        "\u0149": "'n",
        "\u017F": "s"
      };
      var htmlEscapes = {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': "&quot;",
        "'": "&#39;"
      };
      var htmlUnescapes = {
        "&amp;": "&",
        "&lt;": "<",
        "&gt;": ">",
        "&quot;": '"',
        "&#39;": "'"
      };
      var stringEscapes = {
        "\\": "\\",
        "'": "'",
        "\n": "n",
        "\r": "r",
        "\u2028": "u2028",
        "\u2029": "u2029"
      };
      var freeParseFloat = parseFloat, freeParseInt2 = parseInt;
      var freeGlobal2 = typeof commonjsGlobal$1 == "object" && commonjsGlobal$1 && commonjsGlobal$1.Object === Object && commonjsGlobal$1;
      var freeSelf2 = typeof self == "object" && self && self.Object === Object && self;
      var root2 = freeGlobal2 || freeSelf2 || Function("return this")();
      var freeExports = exports3 && !exports3.nodeType && exports3;
      var freeModule = freeExports && true && module2 && !module2.nodeType && module2;
      var moduleExports = freeModule && freeModule.exports === freeExports;
      var freeProcess = moduleExports && freeGlobal2.process;
      var nodeUtil2 = function() {
        try {
          var types2 = freeModule && freeModule.require && freeModule.require("util").types;
          if (types2) {
            return types2;
          }
          return freeProcess && freeProcess.binding && freeProcess.binding("util");
        } catch (e3) {
        }
      }();
      var nodeIsArrayBuffer = nodeUtil2 && nodeUtil2.isArrayBuffer, nodeIsDate = nodeUtil2 && nodeUtil2.isDate, nodeIsMap2 = nodeUtil2 && nodeUtil2.isMap, nodeIsRegExp = nodeUtil2 && nodeUtil2.isRegExp, nodeIsSet2 = nodeUtil2 && nodeUtil2.isSet, nodeIsTypedArray2 = nodeUtil2 && nodeUtil2.isTypedArray;
      function apply(func, thisArg, args) {
        switch (args.length) {
          case 0:
            return func.call(thisArg);
          case 1:
            return func.call(thisArg, args[0]);
          case 2:
            return func.call(thisArg, args[0], args[1]);
          case 3:
            return func.call(thisArg, args[0], args[1], args[2]);
        }
        return func.apply(thisArg, args);
      }
      function arrayAggregator(array2, setter, iteratee, accumulator) {
        var index2 = -1, length = array2 == null ? 0 : array2.length;
        while (++index2 < length) {
          var value = array2[index2];
          setter(accumulator, value, iteratee(value), array2);
        }
        return accumulator;
      }
      function arrayEach2(array2, iteratee) {
        var index2 = -1, length = array2 == null ? 0 : array2.length;
        while (++index2 < length) {
          if (iteratee(array2[index2], index2, array2) === false) {
            break;
          }
        }
        return array2;
      }
      function arrayEachRight(array2, iteratee) {
        var length = array2 == null ? 0 : array2.length;
        while (length--) {
          if (iteratee(array2[length], length, array2) === false) {
            break;
          }
        }
        return array2;
      }
      function arrayEvery(array2, predicate) {
        var index2 = -1, length = array2 == null ? 0 : array2.length;
        while (++index2 < length) {
          if (!predicate(array2[index2], index2, array2)) {
            return false;
          }
        }
        return true;
      }
      function arrayFilter2(array2, predicate) {
        var index2 = -1, length = array2 == null ? 0 : array2.length, resIndex = 0, result = [];
        while (++index2 < length) {
          var value = array2[index2];
          if (predicate(value, index2, array2)) {
            result[resIndex++] = value;
          }
        }
        return result;
      }
      function arrayIncludes(array2, value) {
        var length = array2 == null ? 0 : array2.length;
        return !!length && baseIndexOf(array2, value, 0) > -1;
      }
      function arrayIncludesWith(array2, value, comparator) {
        var index2 = -1, length = array2 == null ? 0 : array2.length;
        while (++index2 < length) {
          if (comparator(value, array2[index2])) {
            return true;
          }
        }
        return false;
      }
      function arrayMap2(array2, iteratee) {
        var index2 = -1, length = array2 == null ? 0 : array2.length, result = Array(length);
        while (++index2 < length) {
          result[index2] = iteratee(array2[index2], index2, array2);
        }
        return result;
      }
      function arrayPush2(array2, values) {
        var index2 = -1, length = values.length, offset2 = array2.length;
        while (++index2 < length) {
          array2[offset2 + index2] = values[index2];
        }
        return array2;
      }
      function arrayReduce(array2, iteratee, accumulator, initAccum) {
        var index2 = -1, length = array2 == null ? 0 : array2.length;
        if (initAccum && length) {
          accumulator = array2[++index2];
        }
        while (++index2 < length) {
          accumulator = iteratee(accumulator, array2[index2], index2, array2);
        }
        return accumulator;
      }
      function arrayReduceRight(array2, iteratee, accumulator, initAccum) {
        var length = array2 == null ? 0 : array2.length;
        if (initAccum && length) {
          accumulator = array2[--length];
        }
        while (length--) {
          accumulator = iteratee(accumulator, array2[length], length, array2);
        }
        return accumulator;
      }
      function arraySome2(array2, predicate) {
        var index2 = -1, length = array2 == null ? 0 : array2.length;
        while (++index2 < length) {
          if (predicate(array2[index2], index2, array2)) {
            return true;
          }
        }
        return false;
      }
      var asciiSize = baseProperty("length");
      function asciiToArray(string2) {
        return string2.split("");
      }
      function asciiWords(string2) {
        return string2.match(reAsciiWord) || [];
      }
      function baseFindKey(collection2, predicate, eachFunc) {
        var result;
        eachFunc(collection2, function(value, key, collection3) {
          if (predicate(value, key, collection3)) {
            result = key;
            return false;
          }
        });
        return result;
      }
      function baseFindIndex(array2, predicate, fromIndex, fromRight) {
        var length = array2.length, index2 = fromIndex + (fromRight ? 1 : -1);
        while (fromRight ? index2-- : ++index2 < length) {
          if (predicate(array2[index2], index2, array2)) {
            return index2;
          }
        }
        return -1;
      }
      function baseIndexOf(array2, value, fromIndex) {
        return value === value ? strictIndexOf(array2, value, fromIndex) : baseFindIndex(array2, baseIsNaN, fromIndex);
      }
      function baseIndexOfWith(array2, value, fromIndex, comparator) {
        var index2 = fromIndex - 1, length = array2.length;
        while (++index2 < length) {
          if (comparator(array2[index2], value)) {
            return index2;
          }
        }
        return -1;
      }
      function baseIsNaN(value) {
        return value !== value;
      }
      function baseMean(array2, iteratee) {
        var length = array2 == null ? 0 : array2.length;
        return length ? baseSum(array2, iteratee) / length : NAN2;
      }
      function baseProperty(key) {
        return function(object2) {
          return object2 == null ? undefined$12 : object2[key];
        };
      }
      function basePropertyOf(object2) {
        return function(key) {
          return object2 == null ? undefined$12 : object2[key];
        };
      }
      function baseReduce(collection2, iteratee, accumulator, initAccum, eachFunc) {
        eachFunc(collection2, function(value, index2, collection3) {
          accumulator = initAccum ? (initAccum = false, value) : iteratee(accumulator, value, index2, collection3);
        });
        return accumulator;
      }
      function baseSortBy(array2, comparer) {
        var length = array2.length;
        array2.sort(comparer);
        while (length--) {
          array2[length] = array2[length].value;
        }
        return array2;
      }
      function baseSum(array2, iteratee) {
        var result, index2 = -1, length = array2.length;
        while (++index2 < length) {
          var current2 = iteratee(array2[index2]);
          if (current2 !== undefined$12) {
            result = result === undefined$12 ? current2 : result + current2;
          }
        }
        return result;
      }
      function baseTimes2(n2, iteratee) {
        var index2 = -1, result = Array(n2);
        while (++index2 < n2) {
          result[index2] = iteratee(index2);
        }
        return result;
      }
      function baseToPairs(object2, props) {
        return arrayMap2(props, function(key) {
          return [key, object2[key]];
        });
      }
      function baseTrim2(string2) {
        return string2 ? string2.slice(0, trimmedEndIndex2(string2) + 1).replace(reTrimStart2, "") : string2;
      }
      function baseUnary2(func) {
        return function(value) {
          return func(value);
        };
      }
      function baseValues(object2, props) {
        return arrayMap2(props, function(key) {
          return object2[key];
        });
      }
      function cacheHas2(cache2, key) {
        return cache2.has(key);
      }
      function charsStartIndex(strSymbols, chrSymbols) {
        var index2 = -1, length = strSymbols.length;
        while (++index2 < length && baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1) {
        }
        return index2;
      }
      function charsEndIndex(strSymbols, chrSymbols) {
        var index2 = strSymbols.length;
        while (index2-- && baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1) {
        }
        return index2;
      }
      function countHolders(array2, placeholder) {
        var length = array2.length, result = 0;
        while (length--) {
          if (array2[length] === placeholder) {
            ++result;
          }
        }
        return result;
      }
      var deburrLetter = basePropertyOf(deburredLetters);
      var escapeHtmlChar = basePropertyOf(htmlEscapes);
      function escapeStringChar(chr) {
        return "\\" + stringEscapes[chr];
      }
      function getValue2(object2, key) {
        return object2 == null ? undefined$12 : object2[key];
      }
      function hasUnicode(string2) {
        return reHasUnicode.test(string2);
      }
      function hasUnicodeWord(string2) {
        return reHasUnicodeWord.test(string2);
      }
      function iteratorToArray(iterator2) {
        var data2, result = [];
        while (!(data2 = iterator2.next()).done) {
          result.push(data2.value);
        }
        return result;
      }
      function mapToArray2(map2) {
        var index2 = -1, result = Array(map2.size);
        map2.forEach(function(value, key) {
          result[++index2] = [key, value];
        });
        return result;
      }
      function overArg2(func, transform) {
        return function(arg) {
          return func(transform(arg));
        };
      }
      function replaceHolders(array2, placeholder) {
        var index2 = -1, length = array2.length, resIndex = 0, result = [];
        while (++index2 < length) {
          var value = array2[index2];
          if (value === placeholder || value === PLACEHOLDER) {
            array2[index2] = PLACEHOLDER;
            result[resIndex++] = index2;
          }
        }
        return result;
      }
      function setToArray2(set2) {
        var index2 = -1, result = Array(set2.size);
        set2.forEach(function(value) {
          result[++index2] = value;
        });
        return result;
      }
      function setToPairs(set2) {
        var index2 = -1, result = Array(set2.size);
        set2.forEach(function(value) {
          result[++index2] = [value, value];
        });
        return result;
      }
      function strictIndexOf(array2, value, fromIndex) {
        var index2 = fromIndex - 1, length = array2.length;
        while (++index2 < length) {
          if (array2[index2] === value) {
            return index2;
          }
        }
        return -1;
      }
      function strictLastIndexOf(array2, value, fromIndex) {
        var index2 = fromIndex + 1;
        while (index2--) {
          if (array2[index2] === value) {
            return index2;
          }
        }
        return index2;
      }
      function stringSize(string2) {
        return hasUnicode(string2) ? unicodeSize(string2) : asciiSize(string2);
      }
      function stringToArray(string2) {
        return hasUnicode(string2) ? unicodeToArray(string2) : asciiToArray(string2);
      }
      function trimmedEndIndex2(string2) {
        var index2 = string2.length;
        while (index2-- && reWhitespace2.test(string2.charAt(index2))) {
        }
        return index2;
      }
      var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
      function unicodeSize(string2) {
        var result = reUnicode.lastIndex = 0;
        while (reUnicode.test(string2)) {
          ++result;
        }
        return result;
      }
      function unicodeToArray(string2) {
        return string2.match(reUnicode) || [];
      }
      function unicodeWords(string2) {
        return string2.match(reUnicodeWord) || [];
      }
      var runInContext = function runInContext2(context2) {
        context2 = context2 == null ? root2 : _2.defaults(root2.Object(), context2, _2.pick(root2, contextProps));
        var Array2 = context2.Array, Date2 = context2.Date, Error2 = context2.Error, Function2 = context2.Function, Math2 = context2.Math, Object2 = context2.Object, RegExp2 = context2.RegExp, String2 = context2.String, TypeError2 = context2.TypeError;
        var arrayProto2 = Array2.prototype, funcProto2 = Function2.prototype, objectProto2 = Object2.prototype;
        var coreJsData2 = context2["__core-js_shared__"];
        var funcToString2 = funcProto2.toString;
        var hasOwnProperty2 = objectProto2.hasOwnProperty;
        var idCounter2 = 0;
        var maskSrcKey2 = function() {
          var uid2 = /[^.]+$/.exec(coreJsData2 && coreJsData2.keys && coreJsData2.keys.IE_PROTO || "");
          return uid2 ? "Symbol(src)_1." + uid2 : "";
        }();
        var nativeObjectToString2 = objectProto2.toString;
        var objectCtorString2 = funcToString2.call(Object2);
        var oldDash = root2._;
        var reIsNative2 = RegExp2(
          "^" + funcToString2.call(hasOwnProperty2).replace(reRegExpChar2, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
        );
        var Buffer2 = moduleExports ? context2.Buffer : undefined$12, Symbol2 = context2.Symbol, Uint8Array2 = context2.Uint8Array, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : undefined$12, getPrototype2 = overArg2(Object2.getPrototypeOf, Object2), objectCreate2 = Object2.create, propertyIsEnumerable2 = objectProto2.propertyIsEnumerable, splice2 = arrayProto2.splice, spreadableSymbol = Symbol2 ? Symbol2.isConcatSpreadable : undefined$12, symIterator = Symbol2 ? Symbol2.iterator : undefined$12, symToStringTag2 = Symbol2 ? Symbol2.toStringTag : undefined$12;
        var defineProperty2 = function() {
          try {
            var func = getNative2(Object2, "defineProperty");
            func({}, "", {});
            return func;
          } catch (e3) {
          }
        }();
        var ctxClearTimeout = context2.clearTimeout !== root2.clearTimeout && context2.clearTimeout, ctxNow = Date2 && Date2.now !== root2.Date.now && Date2.now, ctxSetTimeout = context2.setTimeout !== root2.setTimeout && context2.setTimeout;
        var nativeCeil = Math2.ceil, nativeFloor = Math2.floor, nativeGetSymbols2 = Object2.getOwnPropertySymbols, nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : undefined$12, nativeIsFinite2 = context2.isFinite, nativeJoin = arrayProto2.join, nativeKeys2 = overArg2(Object2.keys, Object2), nativeMax2 = Math2.max, nativeMin2 = Math2.min, nativeNow = Date2.now, nativeParseInt = context2.parseInt, nativeRandom = Math2.random, nativeReverse = arrayProto2.reverse;
        var DataView2 = getNative2(context2, "DataView"), Map2 = getNative2(context2, "Map"), Promise2 = getNative2(context2, "Promise"), Set2 = getNative2(context2, "Set"), WeakMap2 = getNative2(context2, "WeakMap"), nativeCreate2 = getNative2(Object2, "create");
        var metaMap = WeakMap2 && new WeakMap2();
        var realNames = {};
        var dataViewCtorString2 = toSource2(DataView2), mapCtorString2 = toSource2(Map2), promiseCtorString2 = toSource2(Promise2), setCtorString2 = toSource2(Set2), weakMapCtorString2 = toSource2(WeakMap2);
        var symbolProto2 = Symbol2 ? Symbol2.prototype : undefined$12, symbolValueOf2 = symbolProto2 ? symbolProto2.valueOf : undefined$12, symbolToString2 = symbolProto2 ? symbolProto2.toString : undefined$12;
        function lodash2(value) {
          if (isObjectLike2(value) && !isArray2(value) && !(value instanceof LazyWrapper2)) {
            if (value instanceof LodashWrapper2) {
              return value;
            }
            if (hasOwnProperty2.call(value, "__wrapped__")) {
              return wrapperClone2(value);
            }
          }
          return new LodashWrapper2(value);
        }
        var baseCreate2 = function() {
          function object2() {
          }
          return function(proto2) {
            if (!isObject2(proto2)) {
              return {};
            }
            if (objectCreate2) {
              return objectCreate2(proto2);
            }
            object2.prototype = proto2;
            var result2 = new object2();
            object2.prototype = undefined$12;
            return result2;
          };
        }();
        function baseLodash2() {
        }
        function LodashWrapper2(value, chainAll) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__chain__ = !!chainAll;
          this.__index__ = 0;
          this.__values__ = undefined$12;
        }
        lodash2.templateSettings = {
          "escape": reEscape,
          "evaluate": reEvaluate,
          "interpolate": reInterpolate,
          "variable": "",
          "imports": {
            "_": lodash2
          }
        };
        lodash2.prototype = baseLodash2.prototype;
        lodash2.prototype.constructor = lodash2;
        LodashWrapper2.prototype = baseCreate2(baseLodash2.prototype);
        LodashWrapper2.prototype.constructor = LodashWrapper2;
        function LazyWrapper2(value) {
          this.__wrapped__ = value;
          this.__actions__ = [];
          this.__dir__ = 1;
          this.__filtered__ = false;
          this.__iteratees__ = [];
          this.__takeCount__ = MAX_ARRAY_LENGTH2;
          this.__views__ = [];
        }
        function lazyClone() {
          var result2 = new LazyWrapper2(this.__wrapped__);
          result2.__actions__ = copyArray2(this.__actions__);
          result2.__dir__ = this.__dir__;
          result2.__filtered__ = this.__filtered__;
          result2.__iteratees__ = copyArray2(this.__iteratees__);
          result2.__takeCount__ = this.__takeCount__;
          result2.__views__ = copyArray2(this.__views__);
          return result2;
        }
        function lazyReverse() {
          if (this.__filtered__) {
            var result2 = new LazyWrapper2(this);
            result2.__dir__ = -1;
            result2.__filtered__ = true;
          } else {
            result2 = this.clone();
            result2.__dir__ *= -1;
          }
          return result2;
        }
        function lazyValue() {
          var array2 = this.__wrapped__.value(), dir = this.__dir__, isArr = isArray2(array2), isRight = dir < 0, arrLength = isArr ? array2.length : 0, view = getView(0, arrLength, this.__views__), start2 = view.start, end2 = view.end, length = end2 - start2, index2 = isRight ? end2 : start2 - 1, iteratees = this.__iteratees__, iterLength = iteratees.length, resIndex = 0, takeCount = nativeMin2(length, this.__takeCount__);
          if (!isArr || !isRight && arrLength == length && takeCount == length) {
            return baseWrapperValue(array2, this.__actions__);
          }
          var result2 = [];
          outer:
            while (length-- && resIndex < takeCount) {
              index2 += dir;
              var iterIndex = -1, value = array2[index2];
              while (++iterIndex < iterLength) {
                var data2 = iteratees[iterIndex], iteratee2 = data2.iteratee, type2 = data2.type, computed = iteratee2(value);
                if (type2 == LAZY_MAP_FLAG) {
                  value = computed;
                } else if (!computed) {
                  if (type2 == LAZY_FILTER_FLAG) {
                    continue outer;
                  } else {
                    break outer;
                  }
                }
              }
              result2[resIndex++] = value;
            }
          return result2;
        }
        LazyWrapper2.prototype = baseCreate2(baseLodash2.prototype);
        LazyWrapper2.prototype.constructor = LazyWrapper2;
        function Hash2(entries) {
          var index2 = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index2 < length) {
            var entry = entries[index2];
            this.set(entry[0], entry[1]);
          }
        }
        function hashClear2() {
          this.__data__ = nativeCreate2 ? nativeCreate2(null) : {};
          this.size = 0;
        }
        function hashDelete2(key) {
          var result2 = this.has(key) && delete this.__data__[key];
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function hashGet2(key) {
          var data2 = this.__data__;
          if (nativeCreate2) {
            var result2 = data2[key];
            return result2 === HASH_UNDEFINED2 ? undefined$12 : result2;
          }
          return hasOwnProperty2.call(data2, key) ? data2[key] : undefined$12;
        }
        function hashHas2(key) {
          var data2 = this.__data__;
          return nativeCreate2 ? data2[key] !== undefined$12 : hasOwnProperty2.call(data2, key);
        }
        function hashSet2(key, value) {
          var data2 = this.__data__;
          this.size += this.has(key) ? 0 : 1;
          data2[key] = nativeCreate2 && value === undefined$12 ? HASH_UNDEFINED2 : value;
          return this;
        }
        Hash2.prototype.clear = hashClear2;
        Hash2.prototype["delete"] = hashDelete2;
        Hash2.prototype.get = hashGet2;
        Hash2.prototype.has = hashHas2;
        Hash2.prototype.set = hashSet2;
        function ListCache2(entries) {
          var index2 = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index2 < length) {
            var entry = entries[index2];
            this.set(entry[0], entry[1]);
          }
        }
        function listCacheClear2() {
          this.__data__ = [];
          this.size = 0;
        }
        function listCacheDelete2(key) {
          var data2 = this.__data__, index2 = assocIndexOf2(data2, key);
          if (index2 < 0) {
            return false;
          }
          var lastIndex = data2.length - 1;
          if (index2 == lastIndex) {
            data2.pop();
          } else {
            splice2.call(data2, index2, 1);
          }
          --this.size;
          return true;
        }
        function listCacheGet2(key) {
          var data2 = this.__data__, index2 = assocIndexOf2(data2, key);
          return index2 < 0 ? undefined$12 : data2[index2][1];
        }
        function listCacheHas2(key) {
          return assocIndexOf2(this.__data__, key) > -1;
        }
        function listCacheSet2(key, value) {
          var data2 = this.__data__, index2 = assocIndexOf2(data2, key);
          if (index2 < 0) {
            ++this.size;
            data2.push([key, value]);
          } else {
            data2[index2][1] = value;
          }
          return this;
        }
        ListCache2.prototype.clear = listCacheClear2;
        ListCache2.prototype["delete"] = listCacheDelete2;
        ListCache2.prototype.get = listCacheGet2;
        ListCache2.prototype.has = listCacheHas2;
        ListCache2.prototype.set = listCacheSet2;
        function MapCache2(entries) {
          var index2 = -1, length = entries == null ? 0 : entries.length;
          this.clear();
          while (++index2 < length) {
            var entry = entries[index2];
            this.set(entry[0], entry[1]);
          }
        }
        function mapCacheClear2() {
          this.size = 0;
          this.__data__ = {
            "hash": new Hash2(),
            "map": new (Map2 || ListCache2)(),
            "string": new Hash2()
          };
        }
        function mapCacheDelete2(key) {
          var result2 = getMapData2(this, key)["delete"](key);
          this.size -= result2 ? 1 : 0;
          return result2;
        }
        function mapCacheGet2(key) {
          return getMapData2(this, key).get(key);
        }
        function mapCacheHas2(key) {
          return getMapData2(this, key).has(key);
        }
        function mapCacheSet2(key, value) {
          var data2 = getMapData2(this, key), size3 = data2.size;
          data2.set(key, value);
          this.size += data2.size == size3 ? 0 : 1;
          return this;
        }
        MapCache2.prototype.clear = mapCacheClear2;
        MapCache2.prototype["delete"] = mapCacheDelete2;
        MapCache2.prototype.get = mapCacheGet2;
        MapCache2.prototype.has = mapCacheHas2;
        MapCache2.prototype.set = mapCacheSet2;
        function SetCache2(values2) {
          var index2 = -1, length = values2 == null ? 0 : values2.length;
          this.__data__ = new MapCache2();
          while (++index2 < length) {
            this.add(values2[index2]);
          }
        }
        function setCacheAdd2(value) {
          this.__data__.set(value, HASH_UNDEFINED2);
          return this;
        }
        function setCacheHas2(value) {
          return this.__data__.has(value);
        }
        SetCache2.prototype.add = SetCache2.prototype.push = setCacheAdd2;
        SetCache2.prototype.has = setCacheHas2;
        function Stack2(entries) {
          var data2 = this.__data__ = new ListCache2(entries);
          this.size = data2.size;
        }
        function stackClear2() {
          this.__data__ = new ListCache2();
          this.size = 0;
        }
        function stackDelete2(key) {
          var data2 = this.__data__, result2 = data2["delete"](key);
          this.size = data2.size;
          return result2;
        }
        function stackGet2(key) {
          return this.__data__.get(key);
        }
        function stackHas2(key) {
          return this.__data__.has(key);
        }
        function stackSet2(key, value) {
          var data2 = this.__data__;
          if (data2 instanceof ListCache2) {
            var pairs = data2.__data__;
            if (!Map2 || pairs.length < LARGE_ARRAY_SIZE2 - 1) {
              pairs.push([key, value]);
              this.size = ++data2.size;
              return this;
            }
            data2 = this.__data__ = new MapCache2(pairs);
          }
          data2.set(key, value);
          this.size = data2.size;
          return this;
        }
        Stack2.prototype.clear = stackClear2;
        Stack2.prototype["delete"] = stackDelete2;
        Stack2.prototype.get = stackGet2;
        Stack2.prototype.has = stackHas2;
        Stack2.prototype.set = stackSet2;
        function arrayLikeKeys2(value, inherited) {
          var isArr = isArray2(value), isArg = !isArr && isArguments2(value), isBuff = !isArr && !isArg && isBuffer2(value), isType2 = !isArr && !isArg && !isBuff && isTypedArray2(value), skipIndexes = isArr || isArg || isBuff || isType2, result2 = skipIndexes ? baseTimes2(value.length, String2) : [], length = result2.length;
          for (var key in value) {
            if ((inherited || hasOwnProperty2.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType2 && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex2(key, length)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function arraySample(array2) {
          var length = array2.length;
          return length ? array2[baseRandom(0, length - 1)] : undefined$12;
        }
        function arraySampleSize(array2, n2) {
          return shuffleSelf(copyArray2(array2), baseClamp(n2, 0, array2.length));
        }
        function arrayShuffle(array2) {
          return shuffleSelf(copyArray2(array2));
        }
        function assignMergeValue(object2, key, value) {
          if (value !== undefined$12 && !eq2(object2[key], value) || value === undefined$12 && !(key in object2)) {
            baseAssignValue2(object2, key, value);
          }
        }
        function assignValue2(object2, key, value) {
          var objValue = object2[key];
          if (!(hasOwnProperty2.call(object2, key) && eq2(objValue, value)) || value === undefined$12 && !(key in object2)) {
            baseAssignValue2(object2, key, value);
          }
        }
        function assocIndexOf2(array2, key) {
          var length = array2.length;
          while (length--) {
            if (eq2(array2[length][0], key)) {
              return length;
            }
          }
          return -1;
        }
        function baseAggregator(collection2, setter, iteratee2, accumulator) {
          baseEach(collection2, function(value, key, collection3) {
            setter(accumulator, value, iteratee2(value), collection3);
          });
          return accumulator;
        }
        function baseAssign2(object2, source) {
          return object2 && copyObject2(source, keys2(source), object2);
        }
        function baseAssignIn2(object2, source) {
          return object2 && copyObject2(source, keysIn2(source), object2);
        }
        function baseAssignValue2(object2, key, value) {
          if (key == "__proto__" && defineProperty2) {
            defineProperty2(object2, key, {
              "configurable": true,
              "enumerable": true,
              "value": value,
              "writable": true
            });
          } else {
            object2[key] = value;
          }
        }
        function baseAt(object2, paths) {
          var index2 = -1, length = paths.length, result2 = Array2(length), skip = object2 == null;
          while (++index2 < length) {
            result2[index2] = skip ? undefined$12 : get2(object2, paths[index2]);
          }
          return result2;
        }
        function baseClamp(number2, lower2, upper) {
          if (number2 === number2) {
            if (upper !== undefined$12) {
              number2 = number2 <= upper ? number2 : upper;
            }
            if (lower2 !== undefined$12) {
              number2 = number2 >= lower2 ? number2 : lower2;
            }
          }
          return number2;
        }
        function baseClone2(value, bitmask, customizer, key, object2, stack) {
          var result2, isDeep = bitmask & CLONE_DEEP_FLAG2, isFlat = bitmask & CLONE_FLAT_FLAG2, isFull = bitmask & CLONE_SYMBOLS_FLAG2;
          if (customizer) {
            result2 = object2 ? customizer(value, key, object2, stack) : customizer(value);
          }
          if (result2 !== undefined$12) {
            return result2;
          }
          if (!isObject2(value)) {
            return value;
          }
          var isArr = isArray2(value);
          if (isArr) {
            result2 = initCloneArray2(value);
            if (!isDeep) {
              return copyArray2(value, result2);
            }
          } else {
            var tag = getTag2(value), isFunc = tag == funcTag2 || tag == genTag2;
            if (isBuffer2(value)) {
              return cloneBuffer2(value, isDeep);
            }
            if (tag == objectTag2 || tag == argsTag2 || isFunc && !object2) {
              result2 = isFlat || isFunc ? {} : initCloneObject2(value);
              if (!isDeep) {
                return isFlat ? copySymbolsIn2(value, baseAssignIn2(result2, value)) : copySymbols2(value, baseAssign2(result2, value));
              }
            } else {
              if (!cloneableTags2[tag]) {
                return object2 ? value : {};
              }
              result2 = initCloneByTag2(value, tag, isDeep);
            }
          }
          stack || (stack = new Stack2());
          var stacked = stack.get(value);
          if (stacked) {
            return stacked;
          }
          stack.set(value, result2);
          if (isSet2(value)) {
            value.forEach(function(subValue) {
              result2.add(baseClone2(subValue, bitmask, customizer, subValue, value, stack));
            });
          } else if (isMap2(value)) {
            value.forEach(function(subValue, key2) {
              result2.set(key2, baseClone2(subValue, bitmask, customizer, key2, value, stack));
            });
          }
          var keysFunc = isFull ? isFlat ? getAllKeysIn2 : getAllKeys2 : isFlat ? keysIn2 : keys2;
          var props = isArr ? undefined$12 : keysFunc(value);
          arrayEach2(props || value, function(subValue, key2) {
            if (props) {
              key2 = subValue;
              subValue = value[key2];
            }
            assignValue2(result2, key2, baseClone2(subValue, bitmask, customizer, key2, value, stack));
          });
          return result2;
        }
        function baseConforms(source) {
          var props = keys2(source);
          return function(object2) {
            return baseConformsTo(object2, source, props);
          };
        }
        function baseConformsTo(object2, source, props) {
          var length = props.length;
          if (object2 == null) {
            return !length;
          }
          object2 = Object2(object2);
          while (length--) {
            var key = props[length], predicate = source[key], value = object2[key];
            if (value === undefined$12 && !(key in object2) || !predicate(value)) {
              return false;
            }
          }
          return true;
        }
        function baseDelay(func, wait, args) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          return setTimeout2(function() {
            func.apply(undefined$12, args);
          }, wait);
        }
        function baseDifference(array2, values2, iteratee2, comparator) {
          var index2 = -1, includes2 = arrayIncludes, isCommon = true, length = array2.length, result2 = [], valuesLength = values2.length;
          if (!length) {
            return result2;
          }
          if (iteratee2) {
            values2 = arrayMap2(values2, baseUnary2(iteratee2));
          }
          if (comparator) {
            includes2 = arrayIncludesWith;
            isCommon = false;
          } else if (values2.length >= LARGE_ARRAY_SIZE2) {
            includes2 = cacheHas2;
            isCommon = false;
            values2 = new SetCache2(values2);
          }
          outer:
            while (++index2 < length) {
              var value = array2[index2], computed = iteratee2 == null ? value : iteratee2(value);
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var valuesIndex = valuesLength;
                while (valuesIndex--) {
                  if (values2[valuesIndex] === computed) {
                    continue outer;
                  }
                }
                result2.push(value);
              } else if (!includes2(values2, computed, comparator)) {
                result2.push(value);
              }
            }
          return result2;
        }
        var baseEach = createBaseEach(baseForOwn);
        var baseEachRight = createBaseEach(baseForOwnRight, true);
        function baseEvery(collection2, predicate) {
          var result2 = true;
          baseEach(collection2, function(value, index2, collection3) {
            result2 = !!predicate(value, index2, collection3);
            return result2;
          });
          return result2;
        }
        function baseExtremum(array2, iteratee2, comparator) {
          var index2 = -1, length = array2.length;
          while (++index2 < length) {
            var value = array2[index2], current2 = iteratee2(value);
            if (current2 != null && (computed === undefined$12 ? current2 === current2 && !isSymbol2(current2) : comparator(current2, computed))) {
              var computed = current2, result2 = value;
            }
          }
          return result2;
        }
        function baseFill(array2, value, start2, end2) {
          var length = array2.length;
          start2 = toInteger2(start2);
          if (start2 < 0) {
            start2 = -start2 > length ? 0 : length + start2;
          }
          end2 = end2 === undefined$12 || end2 > length ? length : toInteger2(end2);
          if (end2 < 0) {
            end2 += length;
          }
          end2 = start2 > end2 ? 0 : toLength(end2);
          while (start2 < end2) {
            array2[start2++] = value;
          }
          return array2;
        }
        function baseFilter(collection2, predicate) {
          var result2 = [];
          baseEach(collection2, function(value, index2, collection3) {
            if (predicate(value, index2, collection3)) {
              result2.push(value);
            }
          });
          return result2;
        }
        function baseFlatten(array2, depth, predicate, isStrict, result2) {
          var index2 = -1, length = array2.length;
          predicate || (predicate = isFlattenable);
          result2 || (result2 = []);
          while (++index2 < length) {
            var value = array2[index2];
            if (depth > 0 && predicate(value)) {
              if (depth > 1) {
                baseFlatten(value, depth - 1, predicate, isStrict, result2);
              } else {
                arrayPush2(result2, value);
              }
            } else if (!isStrict) {
              result2[result2.length] = value;
            }
          }
          return result2;
        }
        var baseFor = createBaseFor();
        var baseForRight = createBaseFor(true);
        function baseForOwn(object2, iteratee2) {
          return object2 && baseFor(object2, iteratee2, keys2);
        }
        function baseForOwnRight(object2, iteratee2) {
          return object2 && baseForRight(object2, iteratee2, keys2);
        }
        function baseFunctions(object2, props) {
          return arrayFilter2(props, function(key) {
            return isFunction2(object2[key]);
          });
        }
        function baseGet2(object2, path2) {
          path2 = castPath2(path2, object2);
          var index2 = 0, length = path2.length;
          while (object2 != null && index2 < length) {
            object2 = object2[toKey2(path2[index2++])];
          }
          return index2 && index2 == length ? object2 : undefined$12;
        }
        function baseGetAllKeys2(object2, keysFunc, symbolsFunc) {
          var result2 = keysFunc(object2);
          return isArray2(object2) ? result2 : arrayPush2(result2, symbolsFunc(object2));
        }
        function baseGetTag2(value) {
          if (value == null) {
            return value === undefined$12 ? undefinedTag2 : nullTag2;
          }
          return symToStringTag2 && symToStringTag2 in Object2(value) ? getRawTag2(value) : objectToString2(value);
        }
        function baseGt(value, other) {
          return value > other;
        }
        function baseHas(object2, key) {
          return object2 != null && hasOwnProperty2.call(object2, key);
        }
        function baseHasIn(object2, key) {
          return object2 != null && key in Object2(object2);
        }
        function baseInRange(number2, start2, end2) {
          return number2 >= nativeMin2(start2, end2) && number2 < nativeMax2(start2, end2);
        }
        function baseIntersection(arrays, iteratee2, comparator) {
          var includes2 = comparator ? arrayIncludesWith : arrayIncludes, length = arrays[0].length, othLength = arrays.length, othIndex = othLength, caches = Array2(othLength), maxLength = Infinity, result2 = [];
          while (othIndex--) {
            var array2 = arrays[othIndex];
            if (othIndex && iteratee2) {
              array2 = arrayMap2(array2, baseUnary2(iteratee2));
            }
            maxLength = nativeMin2(array2.length, maxLength);
            caches[othIndex] = !comparator && (iteratee2 || length >= 120 && array2.length >= 120) ? new SetCache2(othIndex && array2) : undefined$12;
          }
          array2 = arrays[0];
          var index2 = -1, seen = caches[0];
          outer:
            while (++index2 < length && result2.length < maxLength) {
              var value = array2[index2], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (!(seen ? cacheHas2(seen, computed) : includes2(result2, computed, comparator))) {
                othIndex = othLength;
                while (--othIndex) {
                  var cache2 = caches[othIndex];
                  if (!(cache2 ? cacheHas2(cache2, computed) : includes2(arrays[othIndex], computed, comparator))) {
                    continue outer;
                  }
                }
                if (seen) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseInverter(object2, setter, iteratee2, accumulator) {
          baseForOwn(object2, function(value, key, object3) {
            setter(accumulator, iteratee2(value), key, object3);
          });
          return accumulator;
        }
        function baseInvoke(object2, path2, args) {
          path2 = castPath2(path2, object2);
          object2 = parent(object2, path2);
          var func = object2 == null ? object2 : object2[toKey2(last(path2))];
          return func == null ? undefined$12 : apply(func, object2, args);
        }
        function baseIsArguments2(value) {
          return isObjectLike2(value) && baseGetTag2(value) == argsTag2;
        }
        function baseIsArrayBuffer(value) {
          return isObjectLike2(value) && baseGetTag2(value) == arrayBufferTag2;
        }
        function baseIsDate(value) {
          return isObjectLike2(value) && baseGetTag2(value) == dateTag2;
        }
        function baseIsEqual2(value, other, bitmask, customizer, stack) {
          if (value === other) {
            return true;
          }
          if (value == null || other == null || !isObjectLike2(value) && !isObjectLike2(other)) {
            return value !== value && other !== other;
          }
          return baseIsEqualDeep2(value, other, bitmask, customizer, baseIsEqual2, stack);
        }
        function baseIsEqualDeep2(object2, other, bitmask, customizer, equalFunc, stack) {
          var objIsArr = isArray2(object2), othIsArr = isArray2(other), objTag = objIsArr ? arrayTag2 : getTag2(object2), othTag = othIsArr ? arrayTag2 : getTag2(other);
          objTag = objTag == argsTag2 ? objectTag2 : objTag;
          othTag = othTag == argsTag2 ? objectTag2 : othTag;
          var objIsObj = objTag == objectTag2, othIsObj = othTag == objectTag2, isSameTag = objTag == othTag;
          if (isSameTag && isBuffer2(object2)) {
            if (!isBuffer2(other)) {
              return false;
            }
            objIsArr = true;
            objIsObj = false;
          }
          if (isSameTag && !objIsObj) {
            stack || (stack = new Stack2());
            return objIsArr || isTypedArray2(object2) ? equalArrays2(object2, other, bitmask, customizer, equalFunc, stack) : equalByTag2(object2, other, objTag, bitmask, customizer, equalFunc, stack);
          }
          if (!(bitmask & COMPARE_PARTIAL_FLAG2)) {
            var objIsWrapped = objIsObj && hasOwnProperty2.call(object2, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty2.call(other, "__wrapped__");
            if (objIsWrapped || othIsWrapped) {
              var objUnwrapped = objIsWrapped ? object2.value() : object2, othUnwrapped = othIsWrapped ? other.value() : other;
              stack || (stack = new Stack2());
              return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
            }
          }
          if (!isSameTag) {
            return false;
          }
          stack || (stack = new Stack2());
          return equalObjects2(object2, other, bitmask, customizer, equalFunc, stack);
        }
        function baseIsMap2(value) {
          return isObjectLike2(value) && getTag2(value) == mapTag2;
        }
        function baseIsMatch(object2, source, matchData, customizer) {
          var index2 = matchData.length, length = index2, noCustomizer = !customizer;
          if (object2 == null) {
            return !length;
          }
          object2 = Object2(object2);
          while (index2--) {
            var data2 = matchData[index2];
            if (noCustomizer && data2[2] ? data2[1] !== object2[data2[0]] : !(data2[0] in object2)) {
              return false;
            }
          }
          while (++index2 < length) {
            data2 = matchData[index2];
            var key = data2[0], objValue = object2[key], srcValue = data2[1];
            if (noCustomizer && data2[2]) {
              if (objValue === undefined$12 && !(key in object2)) {
                return false;
              }
            } else {
              var stack = new Stack2();
              if (customizer) {
                var result2 = customizer(objValue, srcValue, key, object2, source, stack);
              }
              if (!(result2 === undefined$12 ? baseIsEqual2(srcValue, objValue, COMPARE_PARTIAL_FLAG2 | COMPARE_UNORDERED_FLAG2, customizer, stack) : result2)) {
                return false;
              }
            }
          }
          return true;
        }
        function baseIsNative2(value) {
          if (!isObject2(value) || isMasked2(value)) {
            return false;
          }
          var pattern = isFunction2(value) ? reIsNative2 : reIsHostCtor2;
          return pattern.test(toSource2(value));
        }
        function baseIsRegExp(value) {
          return isObjectLike2(value) && baseGetTag2(value) == regexpTag2;
        }
        function baseIsSet2(value) {
          return isObjectLike2(value) && getTag2(value) == setTag2;
        }
        function baseIsTypedArray2(value) {
          return isObjectLike2(value) && isLength2(value.length) && !!typedArrayTags2[baseGetTag2(value)];
        }
        function baseIteratee(value) {
          if (typeof value == "function") {
            return value;
          }
          if (value == null) {
            return identity2;
          }
          if (typeof value == "object") {
            return isArray2(value) ? baseMatchesProperty(value[0], value[1]) : baseMatches(value);
          }
          return property(value);
        }
        function baseKeys2(object2) {
          if (!isPrototype2(object2)) {
            return nativeKeys2(object2);
          }
          var result2 = [];
          for (var key in Object2(object2)) {
            if (hasOwnProperty2.call(object2, key) && key != "constructor") {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseKeysIn2(object2) {
          if (!isObject2(object2)) {
            return nativeKeysIn2(object2);
          }
          var isProto = isPrototype2(object2), result2 = [];
          for (var key in object2) {
            if (!(key == "constructor" && (isProto || !hasOwnProperty2.call(object2, key)))) {
              result2.push(key);
            }
          }
          return result2;
        }
        function baseLt(value, other) {
          return value < other;
        }
        function baseMap(collection2, iteratee2) {
          var index2 = -1, result2 = isArrayLike2(collection2) ? Array2(collection2.length) : [];
          baseEach(collection2, function(value, key, collection3) {
            result2[++index2] = iteratee2(value, key, collection3);
          });
          return result2;
        }
        function baseMatches(source) {
          var matchData = getMatchData(source);
          if (matchData.length == 1 && matchData[0][2]) {
            return matchesStrictComparable(matchData[0][0], matchData[0][1]);
          }
          return function(object2) {
            return object2 === source || baseIsMatch(object2, source, matchData);
          };
        }
        function baseMatchesProperty(path2, srcValue) {
          if (isKey2(path2) && isStrictComparable(srcValue)) {
            return matchesStrictComparable(toKey2(path2), srcValue);
          }
          return function(object2) {
            var objValue = get2(object2, path2);
            return objValue === undefined$12 && objValue === srcValue ? hasIn(object2, path2) : baseIsEqual2(srcValue, objValue, COMPARE_PARTIAL_FLAG2 | COMPARE_UNORDERED_FLAG2);
          };
        }
        function baseMerge(object2, source, srcIndex, customizer, stack) {
          if (object2 === source) {
            return;
          }
          baseFor(source, function(srcValue, key) {
            stack || (stack = new Stack2());
            if (isObject2(srcValue)) {
              baseMergeDeep(object2, source, key, srcIndex, baseMerge, customizer, stack);
            } else {
              var newValue = customizer ? customizer(safeGet(object2, key), srcValue, key + "", object2, source, stack) : undefined$12;
              if (newValue === undefined$12) {
                newValue = srcValue;
              }
              assignMergeValue(object2, key, newValue);
            }
          }, keysIn2);
        }
        function baseMergeDeep(object2, source, key, srcIndex, mergeFunc, customizer, stack) {
          var objValue = safeGet(object2, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
          if (stacked) {
            assignMergeValue(object2, key, stacked);
            return;
          }
          var newValue = customizer ? customizer(objValue, srcValue, key + "", object2, source, stack) : undefined$12;
          var isCommon = newValue === undefined$12;
          if (isCommon) {
            var isArr = isArray2(srcValue), isBuff = !isArr && isBuffer2(srcValue), isTyped = !isArr && !isBuff && isTypedArray2(srcValue);
            newValue = srcValue;
            if (isArr || isBuff || isTyped) {
              if (isArray2(objValue)) {
                newValue = objValue;
              } else if (isArrayLikeObject(objValue)) {
                newValue = copyArray2(objValue);
              } else if (isBuff) {
                isCommon = false;
                newValue = cloneBuffer2(srcValue, true);
              } else if (isTyped) {
                isCommon = false;
                newValue = cloneTypedArray2(srcValue, true);
              } else {
                newValue = [];
              }
            } else if (isPlainObject2(srcValue) || isArguments2(srcValue)) {
              newValue = objValue;
              if (isArguments2(objValue)) {
                newValue = toPlainObject(objValue);
              } else if (!isObject2(objValue) || isFunction2(objValue)) {
                newValue = initCloneObject2(srcValue);
              }
            } else {
              isCommon = false;
            }
          }
          if (isCommon) {
            stack.set(srcValue, newValue);
            mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
            stack["delete"](srcValue);
          }
          assignMergeValue(object2, key, newValue);
        }
        function baseNth(array2, n2) {
          var length = array2.length;
          if (!length) {
            return;
          }
          n2 += n2 < 0 ? length : 0;
          return isIndex2(n2, length) ? array2[n2] : undefined$12;
        }
        function baseOrderBy(collection2, iteratees, orders) {
          if (iteratees.length) {
            iteratees = arrayMap2(iteratees, function(iteratee2) {
              if (isArray2(iteratee2)) {
                return function(value) {
                  return baseGet2(value, iteratee2.length === 1 ? iteratee2[0] : iteratee2);
                };
              }
              return iteratee2;
            });
          } else {
            iteratees = [identity2];
          }
          var index2 = -1;
          iteratees = arrayMap2(iteratees, baseUnary2(getIteratee()));
          var result2 = baseMap(collection2, function(value, key, collection3) {
            var criteria = arrayMap2(iteratees, function(iteratee2) {
              return iteratee2(value);
            });
            return { "criteria": criteria, "index": ++index2, "value": value };
          });
          return baseSortBy(result2, function(object2, other) {
            return compareMultiple(object2, other, orders);
          });
        }
        function basePick(object2, paths) {
          return basePickBy(object2, paths, function(value, path2) {
            return hasIn(object2, path2);
          });
        }
        function basePickBy(object2, paths, predicate) {
          var index2 = -1, length = paths.length, result2 = {};
          while (++index2 < length) {
            var path2 = paths[index2], value = baseGet2(object2, path2);
            if (predicate(value, path2)) {
              baseSet2(result2, castPath2(path2, object2), value);
            }
          }
          return result2;
        }
        function basePropertyDeep(path2) {
          return function(object2) {
            return baseGet2(object2, path2);
          };
        }
        function basePullAll(array2, values2, iteratee2, comparator) {
          var indexOf3 = comparator ? baseIndexOfWith : baseIndexOf, index2 = -1, length = values2.length, seen = array2;
          if (array2 === values2) {
            values2 = copyArray2(values2);
          }
          if (iteratee2) {
            seen = arrayMap2(array2, baseUnary2(iteratee2));
          }
          while (++index2 < length) {
            var fromIndex = 0, value = values2[index2], computed = iteratee2 ? iteratee2(value) : value;
            while ((fromIndex = indexOf3(seen, computed, fromIndex, comparator)) > -1) {
              if (seen !== array2) {
                splice2.call(seen, fromIndex, 1);
              }
              splice2.call(array2, fromIndex, 1);
            }
          }
          return array2;
        }
        function basePullAt(array2, indexes) {
          var length = array2 ? indexes.length : 0, lastIndex = length - 1;
          while (length--) {
            var index2 = indexes[length];
            if (length == lastIndex || index2 !== previous2) {
              var previous2 = index2;
              if (isIndex2(index2)) {
                splice2.call(array2, index2, 1);
              } else {
                baseUnset(array2, index2);
              }
            }
          }
          return array2;
        }
        function baseRandom(lower2, upper) {
          return lower2 + nativeFloor(nativeRandom() * (upper - lower2 + 1));
        }
        function baseRange(start2, end2, step2, fromRight) {
          var index2 = -1, length = nativeMax2(nativeCeil((end2 - start2) / (step2 || 1)), 0), result2 = Array2(length);
          while (length--) {
            result2[fromRight ? length : ++index2] = start2;
            start2 += step2;
          }
          return result2;
        }
        function baseRepeat(string2, n2) {
          var result2 = "";
          if (!string2 || n2 < 1 || n2 > MAX_SAFE_INTEGER2) {
            return result2;
          }
          do {
            if (n2 % 2) {
              result2 += string2;
            }
            n2 = nativeFloor(n2 / 2);
            if (n2) {
              string2 += string2;
            }
          } while (n2);
          return result2;
        }
        function baseRest(func, start2) {
          return setToString(overRest(func, start2, identity2), func + "");
        }
        function baseSample(collection2) {
          return arraySample(values(collection2));
        }
        function baseSampleSize(collection2, n2) {
          var array2 = values(collection2);
          return shuffleSelf(array2, baseClamp(n2, 0, array2.length));
        }
        function baseSet2(object2, path2, value, customizer) {
          if (!isObject2(object2)) {
            return object2;
          }
          path2 = castPath2(path2, object2);
          var index2 = -1, length = path2.length, lastIndex = length - 1, nested = object2;
          while (nested != null && ++index2 < length) {
            var key = toKey2(path2[index2]), newValue = value;
            if (key === "__proto__" || key === "constructor" || key === "prototype") {
              return object2;
            }
            if (index2 != lastIndex) {
              var objValue = nested[key];
              newValue = customizer ? customizer(objValue, key, nested) : undefined$12;
              if (newValue === undefined$12) {
                newValue = isObject2(objValue) ? objValue : isIndex2(path2[index2 + 1]) ? [] : {};
              }
            }
            assignValue2(nested, key, newValue);
            nested = nested[key];
          }
          return object2;
        }
        var baseSetData = !metaMap ? identity2 : function(func, data2) {
          metaMap.set(func, data2);
          return func;
        };
        var baseSetToString = !defineProperty2 ? identity2 : function(func, string2) {
          return defineProperty2(func, "toString", {
            "configurable": true,
            "enumerable": false,
            "value": constant2(string2),
            "writable": true
          });
        };
        function baseShuffle(collection2) {
          return shuffleSelf(values(collection2));
        }
        function baseSlice(array2, start2, end2) {
          var index2 = -1, length = array2.length;
          if (start2 < 0) {
            start2 = -start2 > length ? 0 : length + start2;
          }
          end2 = end2 > length ? length : end2;
          if (end2 < 0) {
            end2 += length;
          }
          length = start2 > end2 ? 0 : end2 - start2 >>> 0;
          start2 >>>= 0;
          var result2 = Array2(length);
          while (++index2 < length) {
            result2[index2] = array2[index2 + start2];
          }
          return result2;
        }
        function baseSome(collection2, predicate) {
          var result2;
          baseEach(collection2, function(value, index2, collection3) {
            result2 = predicate(value, index2, collection3);
            return !result2;
          });
          return !!result2;
        }
        function baseSortedIndex(array2, value, retHighest) {
          var low = 0, high = array2 == null ? low : array2.length;
          if (typeof value == "number" && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
            while (low < high) {
              var mid = low + high >>> 1, computed = array2[mid];
              if (computed !== null && !isSymbol2(computed) && (retHighest ? computed <= value : computed < value)) {
                low = mid + 1;
              } else {
                high = mid;
              }
            }
            return high;
          }
          return baseSortedIndexBy(array2, value, identity2, retHighest);
        }
        function baseSortedIndexBy(array2, value, iteratee2, retHighest) {
          var low = 0, high = array2 == null ? 0 : array2.length;
          if (high === 0) {
            return 0;
          }
          value = iteratee2(value);
          var valIsNaN = value !== value, valIsNull = value === null, valIsSymbol = isSymbol2(value), valIsUndefined = value === undefined$12;
          while (low < high) {
            var mid = nativeFloor((low + high) / 2), computed = iteratee2(array2[mid]), othIsDefined = computed !== undefined$12, othIsNull = computed === null, othIsReflexive = computed === computed, othIsSymbol = isSymbol2(computed);
            if (valIsNaN) {
              var setLow = retHighest || othIsReflexive;
            } else if (valIsUndefined) {
              setLow = othIsReflexive && (retHighest || othIsDefined);
            } else if (valIsNull) {
              setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
            } else if (valIsSymbol) {
              setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
            } else if (othIsNull || othIsSymbol) {
              setLow = false;
            } else {
              setLow = retHighest ? computed <= value : computed < value;
            }
            if (setLow) {
              low = mid + 1;
            } else {
              high = mid;
            }
          }
          return nativeMin2(high, MAX_ARRAY_INDEX);
        }
        function baseSortedUniq(array2, iteratee2) {
          var index2 = -1, length = array2.length, resIndex = 0, result2 = [];
          while (++index2 < length) {
            var value = array2[index2], computed = iteratee2 ? iteratee2(value) : value;
            if (!index2 || !eq2(computed, seen)) {
              var seen = computed;
              result2[resIndex++] = value === 0 ? 0 : value;
            }
          }
          return result2;
        }
        function baseToNumber(value) {
          if (typeof value == "number") {
            return value;
          }
          if (isSymbol2(value)) {
            return NAN2;
          }
          return +value;
        }
        function baseToString2(value) {
          if (typeof value == "string") {
            return value;
          }
          if (isArray2(value)) {
            return arrayMap2(value, baseToString2) + "";
          }
          if (isSymbol2(value)) {
            return symbolToString2 ? symbolToString2.call(value) : "";
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY2 ? "-0" : result2;
        }
        function baseUniq(array2, iteratee2, comparator) {
          var index2 = -1, includes2 = arrayIncludes, length = array2.length, isCommon = true, result2 = [], seen = result2;
          if (comparator) {
            isCommon = false;
            includes2 = arrayIncludesWith;
          } else if (length >= LARGE_ARRAY_SIZE2) {
            var set3 = iteratee2 ? null : createSet(array2);
            if (set3) {
              return setToArray2(set3);
            }
            isCommon = false;
            includes2 = cacheHas2;
            seen = new SetCache2();
          } else {
            seen = iteratee2 ? [] : result2;
          }
          outer:
            while (++index2 < length) {
              var value = array2[index2], computed = iteratee2 ? iteratee2(value) : value;
              value = comparator || value !== 0 ? value : 0;
              if (isCommon && computed === computed) {
                var seenIndex = seen.length;
                while (seenIndex--) {
                  if (seen[seenIndex] === computed) {
                    continue outer;
                  }
                }
                if (iteratee2) {
                  seen.push(computed);
                }
                result2.push(value);
              } else if (!includes2(seen, computed, comparator)) {
                if (seen !== result2) {
                  seen.push(computed);
                }
                result2.push(value);
              }
            }
          return result2;
        }
        function baseUnset(object2, path2) {
          path2 = castPath2(path2, object2);
          object2 = parent(object2, path2);
          return object2 == null || delete object2[toKey2(last(path2))];
        }
        function baseUpdate(object2, path2, updater, customizer) {
          return baseSet2(object2, path2, updater(baseGet2(object2, path2)), customizer);
        }
        function baseWhile(array2, predicate, isDrop, fromRight) {
          var length = array2.length, index2 = fromRight ? length : -1;
          while ((fromRight ? index2-- : ++index2 < length) && predicate(array2[index2], index2, array2)) {
          }
          return isDrop ? baseSlice(array2, fromRight ? 0 : index2, fromRight ? index2 + 1 : length) : baseSlice(array2, fromRight ? index2 + 1 : 0, fromRight ? length : index2);
        }
        function baseWrapperValue(value, actions) {
          var result2 = value;
          if (result2 instanceof LazyWrapper2) {
            result2 = result2.value();
          }
          return arrayReduce(actions, function(result3, action) {
            return action.func.apply(action.thisArg, arrayPush2([result3], action.args));
          }, result2);
        }
        function baseXor(arrays, iteratee2, comparator) {
          var length = arrays.length;
          if (length < 2) {
            return length ? baseUniq(arrays[0]) : [];
          }
          var index2 = -1, result2 = Array2(length);
          while (++index2 < length) {
            var array2 = arrays[index2], othIndex = -1;
            while (++othIndex < length) {
              if (othIndex != index2) {
                result2[index2] = baseDifference(result2[index2] || array2, arrays[othIndex], iteratee2, comparator);
              }
            }
          }
          return baseUniq(baseFlatten(result2, 1), iteratee2, comparator);
        }
        function baseZipObject(props, values2, assignFunc) {
          var index2 = -1, length = props.length, valsLength = values2.length, result2 = {};
          while (++index2 < length) {
            var value = index2 < valsLength ? values2[index2] : undefined$12;
            assignFunc(result2, props[index2], value);
          }
          return result2;
        }
        function castArrayLikeObject(value) {
          return isArrayLikeObject(value) ? value : [];
        }
        function castFunction(value) {
          return typeof value == "function" ? value : identity2;
        }
        function castPath2(value, object2) {
          if (isArray2(value)) {
            return value;
          }
          return isKey2(value, object2) ? [value] : stringToPath2(toString2(value));
        }
        var castRest = baseRest;
        function castSlice(array2, start2, end2) {
          var length = array2.length;
          end2 = end2 === undefined$12 ? length : end2;
          return !start2 && end2 >= length ? array2 : baseSlice(array2, start2, end2);
        }
        var clearTimeout2 = ctxClearTimeout || function(id2) {
          return root2.clearTimeout(id2);
        };
        function cloneBuffer2(buffer, isDeep) {
          if (isDeep) {
            return buffer.slice();
          }
          var length = buffer.length, result2 = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
          buffer.copy(result2);
          return result2;
        }
        function cloneArrayBuffer2(arrayBuffer) {
          var result2 = new arrayBuffer.constructor(arrayBuffer.byteLength);
          new Uint8Array2(result2).set(new Uint8Array2(arrayBuffer));
          return result2;
        }
        function cloneDataView2(dataView, isDeep) {
          var buffer = isDeep ? cloneArrayBuffer2(dataView.buffer) : dataView.buffer;
          return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
        }
        function cloneRegExp2(regexp) {
          var result2 = new regexp.constructor(regexp.source, reFlags2.exec(regexp));
          result2.lastIndex = regexp.lastIndex;
          return result2;
        }
        function cloneSymbol2(symbol) {
          return symbolValueOf2 ? Object2(symbolValueOf2.call(symbol)) : {};
        }
        function cloneTypedArray2(typedArray, isDeep) {
          var buffer = isDeep ? cloneArrayBuffer2(typedArray.buffer) : typedArray.buffer;
          return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
        }
        function compareAscending(value, other) {
          if (value !== other) {
            var valIsDefined = value !== undefined$12, valIsNull = value === null, valIsReflexive = value === value, valIsSymbol = isSymbol2(value);
            var othIsDefined = other !== undefined$12, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol2(other);
            if (!othIsNull && !othIsSymbol && !valIsSymbol && value > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
              return 1;
            }
            if (!valIsNull && !valIsSymbol && !othIsSymbol && value < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
              return -1;
            }
          }
          return 0;
        }
        function compareMultiple(object2, other, orders) {
          var index2 = -1, objCriteria = object2.criteria, othCriteria = other.criteria, length = objCriteria.length, ordersLength = orders.length;
          while (++index2 < length) {
            var result2 = compareAscending(objCriteria[index2], othCriteria[index2]);
            if (result2) {
              if (index2 >= ordersLength) {
                return result2;
              }
              var order2 = orders[index2];
              return result2 * (order2 == "desc" ? -1 : 1);
            }
          }
          return object2.index - other.index;
        }
        function composeArgs(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersLength = holders.length, leftIndex = -1, leftLength = partials.length, rangeLength = nativeMax2(argsLength - holdersLength, 0), result2 = Array2(leftLength + rangeLength), isUncurried = !isCurried;
          while (++leftIndex < leftLength) {
            result2[leftIndex] = partials[leftIndex];
          }
          while (++argsIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[holders[argsIndex]] = args[argsIndex];
            }
          }
          while (rangeLength--) {
            result2[leftIndex++] = args[argsIndex++];
          }
          return result2;
        }
        function composeArgsRight(args, partials, holders, isCurried) {
          var argsIndex = -1, argsLength = args.length, holdersIndex = -1, holdersLength = holders.length, rightIndex = -1, rightLength = partials.length, rangeLength = nativeMax2(argsLength - holdersLength, 0), result2 = Array2(rangeLength + rightLength), isUncurried = !isCurried;
          while (++argsIndex < rangeLength) {
            result2[argsIndex] = args[argsIndex];
          }
          var offset2 = argsIndex;
          while (++rightIndex < rightLength) {
            result2[offset2 + rightIndex] = partials[rightIndex];
          }
          while (++holdersIndex < holdersLength) {
            if (isUncurried || argsIndex < argsLength) {
              result2[offset2 + holders[holdersIndex]] = args[argsIndex++];
            }
          }
          return result2;
        }
        function copyArray2(source, array2) {
          var index2 = -1, length = source.length;
          array2 || (array2 = Array2(length));
          while (++index2 < length) {
            array2[index2] = source[index2];
          }
          return array2;
        }
        function copyObject2(source, props, object2, customizer) {
          var isNew = !object2;
          object2 || (object2 = {});
          var index2 = -1, length = props.length;
          while (++index2 < length) {
            var key = props[index2];
            var newValue = customizer ? customizer(object2[key], source[key], key, object2, source) : undefined$12;
            if (newValue === undefined$12) {
              newValue = source[key];
            }
            if (isNew) {
              baseAssignValue2(object2, key, newValue);
            } else {
              assignValue2(object2, key, newValue);
            }
          }
          return object2;
        }
        function copySymbols2(source, object2) {
          return copyObject2(source, getSymbols2(source), object2);
        }
        function copySymbolsIn2(source, object2) {
          return copyObject2(source, getSymbolsIn2(source), object2);
        }
        function createAggregator(setter, initializer) {
          return function(collection2, iteratee2) {
            var func = isArray2(collection2) ? arrayAggregator : baseAggregator, accumulator = initializer ? initializer() : {};
            return func(collection2, setter, getIteratee(iteratee2, 2), accumulator);
          };
        }
        function createAssigner(assigner) {
          return baseRest(function(object2, sources) {
            var index2 = -1, length = sources.length, customizer = length > 1 ? sources[length - 1] : undefined$12, guard2 = length > 2 ? sources[2] : undefined$12;
            customizer = assigner.length > 3 && typeof customizer == "function" ? (length--, customizer) : undefined$12;
            if (guard2 && isIterateeCall(sources[0], sources[1], guard2)) {
              customizer = length < 3 ? undefined$12 : customizer;
              length = 1;
            }
            object2 = Object2(object2);
            while (++index2 < length) {
              var source = sources[index2];
              if (source) {
                assigner(object2, source, index2, customizer);
              }
            }
            return object2;
          });
        }
        function createBaseEach(eachFunc, fromRight) {
          return function(collection2, iteratee2) {
            if (collection2 == null) {
              return collection2;
            }
            if (!isArrayLike2(collection2)) {
              return eachFunc(collection2, iteratee2);
            }
            var length = collection2.length, index2 = fromRight ? length : -1, iterable = Object2(collection2);
            while (fromRight ? index2-- : ++index2 < length) {
              if (iteratee2(iterable[index2], index2, iterable) === false) {
                break;
              }
            }
            return collection2;
          };
        }
        function createBaseFor(fromRight) {
          return function(object2, iteratee2, keysFunc) {
            var index2 = -1, iterable = Object2(object2), props = keysFunc(object2), length = props.length;
            while (length--) {
              var key = props[fromRight ? length : ++index2];
              if (iteratee2(iterable[key], key, iterable) === false) {
                break;
              }
            }
            return object2;
          };
        }
        function createBind(func, bitmask, thisArg) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var fn2 = this && this !== root2 && this instanceof wrapper ? Ctor : func;
            return fn2.apply(isBind ? thisArg : this, arguments);
          }
          return wrapper;
        }
        function createCaseFirst(methodName) {
          return function(string2) {
            string2 = toString2(string2);
            var strSymbols = hasUnicode(string2) ? stringToArray(string2) : undefined$12;
            var chr = strSymbols ? strSymbols[0] : string2.charAt(0);
            var trailing = strSymbols ? castSlice(strSymbols, 1).join("") : string2.slice(1);
            return chr[methodName]() + trailing;
          };
        }
        function createCompounder(callback) {
          return function(string2) {
            return arrayReduce(words(deburr(string2).replace(reApos, "")), callback, "");
          };
        }
        function createCtor(Ctor) {
          return function() {
            var args = arguments;
            switch (args.length) {
              case 0:
                return new Ctor();
              case 1:
                return new Ctor(args[0]);
              case 2:
                return new Ctor(args[0], args[1]);
              case 3:
                return new Ctor(args[0], args[1], args[2]);
              case 4:
                return new Ctor(args[0], args[1], args[2], args[3]);
              case 5:
                return new Ctor(args[0], args[1], args[2], args[3], args[4]);
              case 6:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
              case 7:
                return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }
            var thisBinding = baseCreate2(Ctor.prototype), result2 = Ctor.apply(thisBinding, args);
            return isObject2(result2) ? result2 : thisBinding;
          };
        }
        function createCurry(func, bitmask, arity) {
          var Ctor = createCtor(func);
          function wrapper() {
            var length = arguments.length, args = Array2(length), index2 = length, placeholder = getHolder(wrapper);
            while (index2--) {
              args[index2] = arguments[index2];
            }
            var holders = length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder ? [] : replaceHolders(args, placeholder);
            length -= holders.length;
            if (length < arity) {
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                undefined$12,
                args,
                holders,
                undefined$12,
                undefined$12,
                arity - length
              );
            }
            var fn2 = this && this !== root2 && this instanceof wrapper ? Ctor : func;
            return apply(fn2, this, args);
          }
          return wrapper;
        }
        function createFind(findIndexFunc) {
          return function(collection2, predicate, fromIndex) {
            var iterable = Object2(collection2);
            if (!isArrayLike2(collection2)) {
              var iteratee2 = getIteratee(predicate, 3);
              collection2 = keys2(collection2);
              predicate = function(key) {
                return iteratee2(iterable[key], key, iterable);
              };
            }
            var index2 = findIndexFunc(collection2, predicate, fromIndex);
            return index2 > -1 ? iterable[iteratee2 ? collection2[index2] : index2] : undefined$12;
          };
        }
        function createFlow(fromRight) {
          return flatRest(function(funcs) {
            var length = funcs.length, index2 = length, prereq = LodashWrapper2.prototype.thru;
            if (fromRight) {
              funcs.reverse();
            }
            while (index2--) {
              var func = funcs[index2];
              if (typeof func != "function") {
                throw new TypeError2(FUNC_ERROR_TEXT2);
              }
              if (prereq && !wrapper && getFuncName(func) == "wrapper") {
                var wrapper = new LodashWrapper2([], true);
              }
            }
            index2 = wrapper ? index2 : length;
            while (++index2 < length) {
              func = funcs[index2];
              var funcName = getFuncName(func), data2 = funcName == "wrapper" ? getData(func) : undefined$12;
              if (data2 && isLaziable(data2[0]) && data2[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) && !data2[4].length && data2[9] == 1) {
                wrapper = wrapper[getFuncName(data2[0])].apply(wrapper, data2[3]);
              } else {
                wrapper = func.length == 1 && isLaziable(func) ? wrapper[funcName]() : wrapper.thru(func);
              }
            }
            return function() {
              var args = arguments, value = args[0];
              if (wrapper && args.length == 1 && isArray2(value)) {
                return wrapper.plant(value).value();
              }
              var index3 = 0, result2 = length ? funcs[index3].apply(this, args) : value;
              while (++index3 < length) {
                result2 = funcs[index3].call(this, result2);
              }
              return result2;
            };
          });
        }
        function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary2, arity) {
          var isAry = bitmask & WRAP_ARY_FLAG, isBind = bitmask & WRAP_BIND_FLAG, isBindKey = bitmask & WRAP_BIND_KEY_FLAG, isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG), isFlip = bitmask & WRAP_FLIP_FLAG, Ctor = isBindKey ? undefined$12 : createCtor(func);
          function wrapper() {
            var length = arguments.length, args = Array2(length), index2 = length;
            while (index2--) {
              args[index2] = arguments[index2];
            }
            if (isCurried) {
              var placeholder = getHolder(wrapper), holdersCount = countHolders(args, placeholder);
            }
            if (partials) {
              args = composeArgs(args, partials, holders, isCurried);
            }
            if (partialsRight) {
              args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
            }
            length -= holdersCount;
            if (isCurried && length < arity) {
              var newHolders = replaceHolders(args, placeholder);
              return createRecurry(
                func,
                bitmask,
                createHybrid,
                wrapper.placeholder,
                thisArg,
                args,
                newHolders,
                argPos,
                ary2,
                arity - length
              );
            }
            var thisBinding = isBind ? thisArg : this, fn2 = isBindKey ? thisBinding[func] : func;
            length = args.length;
            if (argPos) {
              args = reorder(args, argPos);
            } else if (isFlip && length > 1) {
              args.reverse();
            }
            if (isAry && ary2 < length) {
              args.length = ary2;
            }
            if (this && this !== root2 && this instanceof wrapper) {
              fn2 = Ctor || createCtor(fn2);
            }
            return fn2.apply(thisBinding, args);
          }
          return wrapper;
        }
        function createInverter(setter, toIteratee) {
          return function(object2, iteratee2) {
            return baseInverter(object2, setter, toIteratee(iteratee2), {});
          };
        }
        function createMathOperation(operator2, defaultValue2) {
          return function(value, other) {
            var result2;
            if (value === undefined$12 && other === undefined$12) {
              return defaultValue2;
            }
            if (value !== undefined$12) {
              result2 = value;
            }
            if (other !== undefined$12) {
              if (result2 === undefined$12) {
                return other;
              }
              if (typeof value == "string" || typeof other == "string") {
                value = baseToString2(value);
                other = baseToString2(other);
              } else {
                value = baseToNumber(value);
                other = baseToNumber(other);
              }
              result2 = operator2(value, other);
            }
            return result2;
          };
        }
        function createOver(arrayFunc) {
          return flatRest(function(iteratees) {
            iteratees = arrayMap2(iteratees, baseUnary2(getIteratee()));
            return baseRest(function(args) {
              var thisArg = this;
              return arrayFunc(iteratees, function(iteratee2) {
                return apply(iteratee2, thisArg, args);
              });
            });
          });
        }
        function createPadding(length, chars) {
          chars = chars === undefined$12 ? " " : baseToString2(chars);
          var charsLength = chars.length;
          if (charsLength < 2) {
            return charsLength ? baseRepeat(chars, length) : chars;
          }
          var result2 = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
          return hasUnicode(chars) ? castSlice(stringToArray(result2), 0, length).join("") : result2.slice(0, length);
        }
        function createPartial(func, bitmask, thisArg, partials) {
          var isBind = bitmask & WRAP_BIND_FLAG, Ctor = createCtor(func);
          function wrapper() {
            var argsIndex = -1, argsLength = arguments.length, leftIndex = -1, leftLength = partials.length, args = Array2(leftLength + argsLength), fn2 = this && this !== root2 && this instanceof wrapper ? Ctor : func;
            while (++leftIndex < leftLength) {
              args[leftIndex] = partials[leftIndex];
            }
            while (argsLength--) {
              args[leftIndex++] = arguments[++argsIndex];
            }
            return apply(fn2, isBind ? thisArg : this, args);
          }
          return wrapper;
        }
        function createRange(fromRight) {
          return function(start2, end2, step2) {
            if (step2 && typeof step2 != "number" && isIterateeCall(start2, end2, step2)) {
              end2 = step2 = undefined$12;
            }
            start2 = toFinite2(start2);
            if (end2 === undefined$12) {
              end2 = start2;
              start2 = 0;
            } else {
              end2 = toFinite2(end2);
            }
            step2 = step2 === undefined$12 ? start2 < end2 ? 1 : -1 : toFinite2(step2);
            return baseRange(start2, end2, step2, fromRight);
          };
        }
        function createRelationalOperation(operator2) {
          return function(value, other) {
            if (!(typeof value == "string" && typeof other == "string")) {
              value = toNumber2(value);
              other = toNumber2(other);
            }
            return operator2(value, other);
          };
        }
        function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary2, arity) {
          var isCurry = bitmask & WRAP_CURRY_FLAG, newHolders = isCurry ? holders : undefined$12, newHoldersRight = isCurry ? undefined$12 : holders, newPartials = isCurry ? partials : undefined$12, newPartialsRight = isCurry ? undefined$12 : partials;
          bitmask |= isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG;
          bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);
          if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
            bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
          }
          var newData = [
            func,
            bitmask,
            thisArg,
            newPartials,
            newHolders,
            newPartialsRight,
            newHoldersRight,
            argPos,
            ary2,
            arity
          ];
          var result2 = wrapFunc.apply(undefined$12, newData);
          if (isLaziable(func)) {
            setData(result2, newData);
          }
          result2.placeholder = placeholder;
          return setWrapToString(result2, func, bitmask);
        }
        function createRound2(methodName) {
          var func = Math2[methodName];
          return function(number2, precision2) {
            number2 = toNumber2(number2);
            precision2 = precision2 == null ? 0 : nativeMin2(toInteger2(precision2), 292);
            if (precision2 && nativeIsFinite2(number2)) {
              var pair2 = (toString2(number2) + "e").split("e"), value = func(pair2[0] + "e" + (+pair2[1] + precision2));
              pair2 = (toString2(value) + "e").split("e");
              return +(pair2[0] + "e" + (+pair2[1] - precision2));
            }
            return func(number2);
          };
        }
        var createSet = !(Set2 && 1 / setToArray2(new Set2([, -0]))[1] == INFINITY2) ? noop2 : function(values2) {
          return new Set2(values2);
        };
        function createToPairs(keysFunc) {
          return function(object2) {
            var tag = getTag2(object2);
            if (tag == mapTag2) {
              return mapToArray2(object2);
            }
            if (tag == setTag2) {
              return setToPairs(object2);
            }
            return baseToPairs(object2, keysFunc(object2));
          };
        }
        function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary2, arity) {
          var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
          if (!isBindKey && typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          var length = partials ? partials.length : 0;
          if (!length) {
            bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
            partials = holders = undefined$12;
          }
          ary2 = ary2 === undefined$12 ? ary2 : nativeMax2(toInteger2(ary2), 0);
          arity = arity === undefined$12 ? arity : toInteger2(arity);
          length -= holders ? holders.length : 0;
          if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
            var partialsRight = partials, holdersRight = holders;
            partials = holders = undefined$12;
          }
          var data2 = isBindKey ? undefined$12 : getData(func);
          var newData = [
            func,
            bitmask,
            thisArg,
            partials,
            holders,
            partialsRight,
            holdersRight,
            argPos,
            ary2,
            arity
          ];
          if (data2) {
            mergeData(newData, data2);
          }
          func = newData[0];
          bitmask = newData[1];
          thisArg = newData[2];
          partials = newData[3];
          holders = newData[4];
          arity = newData[9] = newData[9] === undefined$12 ? isBindKey ? 0 : func.length : nativeMax2(newData[9] - length, 0);
          if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
            bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
          }
          if (!bitmask || bitmask == WRAP_BIND_FLAG) {
            var result2 = createBind(func, bitmask, thisArg);
          } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
            result2 = createCurry(func, bitmask, arity);
          } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
            result2 = createPartial(func, bitmask, thisArg, partials);
          } else {
            result2 = createHybrid.apply(undefined$12, newData);
          }
          var setter = data2 ? baseSetData : setData;
          return setWrapToString(setter(result2, newData), func, bitmask);
        }
        function customDefaultsAssignIn(objValue, srcValue, key, object2) {
          if (objValue === undefined$12 || eq2(objValue, objectProto2[key]) && !hasOwnProperty2.call(object2, key)) {
            return srcValue;
          }
          return objValue;
        }
        function customDefaultsMerge(objValue, srcValue, key, object2, source, stack) {
          if (isObject2(objValue) && isObject2(srcValue)) {
            stack.set(srcValue, objValue);
            baseMerge(objValue, srcValue, undefined$12, customDefaultsMerge, stack);
            stack["delete"](srcValue);
          }
          return objValue;
        }
        function customOmitClone(value) {
          return isPlainObject2(value) ? undefined$12 : value;
        }
        function equalArrays2(array2, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG2, arrLength = array2.length, othLength = other.length;
          if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
            return false;
          }
          var arrStacked = stack.get(array2);
          var othStacked = stack.get(other);
          if (arrStacked && othStacked) {
            return arrStacked == other && othStacked == array2;
          }
          var index2 = -1, result2 = true, seen = bitmask & COMPARE_UNORDERED_FLAG2 ? new SetCache2() : undefined$12;
          stack.set(array2, other);
          stack.set(other, array2);
          while (++index2 < arrLength) {
            var arrValue = array2[index2], othValue = other[index2];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, arrValue, index2, other, array2, stack) : customizer(arrValue, othValue, index2, array2, other, stack);
            }
            if (compared !== undefined$12) {
              if (compared) {
                continue;
              }
              result2 = false;
              break;
            }
            if (seen) {
              if (!arraySome2(other, function(othValue2, othIndex) {
                if (!cacheHas2(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
                  return seen.push(othIndex);
                }
              })) {
                result2 = false;
                break;
              }
            } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              result2 = false;
              break;
            }
          }
          stack["delete"](array2);
          stack["delete"](other);
          return result2;
        }
        function equalByTag2(object2, other, tag, bitmask, customizer, equalFunc, stack) {
          switch (tag) {
            case dataViewTag2:
              if (object2.byteLength != other.byteLength || object2.byteOffset != other.byteOffset) {
                return false;
              }
              object2 = object2.buffer;
              other = other.buffer;
            case arrayBufferTag2:
              if (object2.byteLength != other.byteLength || !equalFunc(new Uint8Array2(object2), new Uint8Array2(other))) {
                return false;
              }
              return true;
            case boolTag2:
            case dateTag2:
            case numberTag2:
              return eq2(+object2, +other);
            case errorTag2:
              return object2.name == other.name && object2.message == other.message;
            case regexpTag2:
            case stringTag2:
              return object2 == other + "";
            case mapTag2:
              var convert2 = mapToArray2;
            case setTag2:
              var isPartial = bitmask & COMPARE_PARTIAL_FLAG2;
              convert2 || (convert2 = setToArray2);
              if (object2.size != other.size && !isPartial) {
                return false;
              }
              var stacked = stack.get(object2);
              if (stacked) {
                return stacked == other;
              }
              bitmask |= COMPARE_UNORDERED_FLAG2;
              stack.set(object2, other);
              var result2 = equalArrays2(convert2(object2), convert2(other), bitmask, customizer, equalFunc, stack);
              stack["delete"](object2);
              return result2;
            case symbolTag2:
              if (symbolValueOf2) {
                return symbolValueOf2.call(object2) == symbolValueOf2.call(other);
              }
          }
          return false;
        }
        function equalObjects2(object2, other, bitmask, customizer, equalFunc, stack) {
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG2, objProps = getAllKeys2(object2), objLength = objProps.length, othProps = getAllKeys2(other), othLength = othProps.length;
          if (objLength != othLength && !isPartial) {
            return false;
          }
          var index2 = objLength;
          while (index2--) {
            var key = objProps[index2];
            if (!(isPartial ? key in other : hasOwnProperty2.call(other, key))) {
              return false;
            }
          }
          var objStacked = stack.get(object2);
          var othStacked = stack.get(other);
          if (objStacked && othStacked) {
            return objStacked == other && othStacked == object2;
          }
          var result2 = true;
          stack.set(object2, other);
          stack.set(other, object2);
          var skipCtor = isPartial;
          while (++index2 < objLength) {
            key = objProps[index2];
            var objValue = object2[key], othValue = other[key];
            if (customizer) {
              var compared = isPartial ? customizer(othValue, objValue, key, other, object2, stack) : customizer(objValue, othValue, key, object2, other, stack);
            }
            if (!(compared === undefined$12 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
              result2 = false;
              break;
            }
            skipCtor || (skipCtor = key == "constructor");
          }
          if (result2 && !skipCtor) {
            var objCtor = object2.constructor, othCtor = other.constructor;
            if (objCtor != othCtor && ("constructor" in object2 && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
              result2 = false;
            }
          }
          stack["delete"](object2);
          stack["delete"](other);
          return result2;
        }
        function flatRest(func) {
          return setToString(overRest(func, undefined$12, flatten2), func + "");
        }
        function getAllKeys2(object2) {
          return baseGetAllKeys2(object2, keys2, getSymbols2);
        }
        function getAllKeysIn2(object2) {
          return baseGetAllKeys2(object2, keysIn2, getSymbolsIn2);
        }
        var getData = !metaMap ? noop2 : function(func) {
          return metaMap.get(func);
        };
        function getFuncName(func) {
          var result2 = func.name + "", array2 = realNames[result2], length = hasOwnProperty2.call(realNames, result2) ? array2.length : 0;
          while (length--) {
            var data2 = array2[length], otherFunc = data2.func;
            if (otherFunc == null || otherFunc == func) {
              return data2.name;
            }
          }
          return result2;
        }
        function getHolder(func) {
          var object2 = hasOwnProperty2.call(lodash2, "placeholder") ? lodash2 : func;
          return object2.placeholder;
        }
        function getIteratee() {
          var result2 = lodash2.iteratee || iteratee;
          result2 = result2 === iteratee ? baseIteratee : result2;
          return arguments.length ? result2(arguments[0], arguments[1]) : result2;
        }
        function getMapData2(map3, key) {
          var data2 = map3.__data__;
          return isKeyable2(key) ? data2[typeof key == "string" ? "string" : "hash"] : data2.map;
        }
        function getMatchData(object2) {
          var result2 = keys2(object2), length = result2.length;
          while (length--) {
            var key = result2[length], value = object2[key];
            result2[length] = [key, value, isStrictComparable(value)];
          }
          return result2;
        }
        function getNative2(object2, key) {
          var value = getValue2(object2, key);
          return baseIsNative2(value) ? value : undefined$12;
        }
        function getRawTag2(value) {
          var isOwn = hasOwnProperty2.call(value, symToStringTag2), tag = value[symToStringTag2];
          try {
            value[symToStringTag2] = undefined$12;
            var unmasked = true;
          } catch (e3) {
          }
          var result2 = nativeObjectToString2.call(value);
          if (unmasked) {
            if (isOwn) {
              value[symToStringTag2] = tag;
            } else {
              delete value[symToStringTag2];
            }
          }
          return result2;
        }
        var getSymbols2 = !nativeGetSymbols2 ? stubArray2 : function(object2) {
          if (object2 == null) {
            return [];
          }
          object2 = Object2(object2);
          return arrayFilter2(nativeGetSymbols2(object2), function(symbol) {
            return propertyIsEnumerable2.call(object2, symbol);
          });
        };
        var getSymbolsIn2 = !nativeGetSymbols2 ? stubArray2 : function(object2) {
          var result2 = [];
          while (object2) {
            arrayPush2(result2, getSymbols2(object2));
            object2 = getPrototype2(object2);
          }
          return result2;
        };
        var getTag2 = baseGetTag2;
        if (DataView2 && getTag2(new DataView2(new ArrayBuffer(1))) != dataViewTag2 || Map2 && getTag2(new Map2()) != mapTag2 || Promise2 && getTag2(Promise2.resolve()) != promiseTag2 || Set2 && getTag2(new Set2()) != setTag2 || WeakMap2 && getTag2(new WeakMap2()) != weakMapTag2) {
          getTag2 = function(value) {
            var result2 = baseGetTag2(value), Ctor = result2 == objectTag2 ? value.constructor : undefined$12, ctorString = Ctor ? toSource2(Ctor) : "";
            if (ctorString) {
              switch (ctorString) {
                case dataViewCtorString2:
                  return dataViewTag2;
                case mapCtorString2:
                  return mapTag2;
                case promiseCtorString2:
                  return promiseTag2;
                case setCtorString2:
                  return setTag2;
                case weakMapCtorString2:
                  return weakMapTag2;
              }
            }
            return result2;
          };
        }
        function getView(start2, end2, transforms) {
          var index2 = -1, length = transforms.length;
          while (++index2 < length) {
            var data2 = transforms[index2], size3 = data2.size;
            switch (data2.type) {
              case "drop":
                start2 += size3;
                break;
              case "dropRight":
                end2 -= size3;
                break;
              case "take":
                end2 = nativeMin2(end2, start2 + size3);
                break;
              case "takeRight":
                start2 = nativeMax2(start2, end2 - size3);
                break;
            }
          }
          return { "start": start2, "end": end2 };
        }
        function getWrapDetails(source) {
          var match2 = source.match(reWrapDetails);
          return match2 ? match2[1].split(reSplitDetails) : [];
        }
        function hasPath(object2, path2, hasFunc) {
          path2 = castPath2(path2, object2);
          var index2 = -1, length = path2.length, result2 = false;
          while (++index2 < length) {
            var key = toKey2(path2[index2]);
            if (!(result2 = object2 != null && hasFunc(object2, key))) {
              break;
            }
            object2 = object2[key];
          }
          if (result2 || ++index2 != length) {
            return result2;
          }
          length = object2 == null ? 0 : object2.length;
          return !!length && isLength2(length) && isIndex2(key, length) && (isArray2(object2) || isArguments2(object2));
        }
        function initCloneArray2(array2) {
          var length = array2.length, result2 = new array2.constructor(length);
          if (length && typeof array2[0] == "string" && hasOwnProperty2.call(array2, "index")) {
            result2.index = array2.index;
            result2.input = array2.input;
          }
          return result2;
        }
        function initCloneObject2(object2) {
          return typeof object2.constructor == "function" && !isPrototype2(object2) ? baseCreate2(getPrototype2(object2)) : {};
        }
        function initCloneByTag2(object2, tag, isDeep) {
          var Ctor = object2.constructor;
          switch (tag) {
            case arrayBufferTag2:
              return cloneArrayBuffer2(object2);
            case boolTag2:
            case dateTag2:
              return new Ctor(+object2);
            case dataViewTag2:
              return cloneDataView2(object2, isDeep);
            case float32Tag2:
            case float64Tag2:
            case int8Tag2:
            case int16Tag2:
            case int32Tag2:
            case uint8Tag2:
            case uint8ClampedTag2:
            case uint16Tag2:
            case uint32Tag2:
              return cloneTypedArray2(object2, isDeep);
            case mapTag2:
              return new Ctor();
            case numberTag2:
            case stringTag2:
              return new Ctor(object2);
            case regexpTag2:
              return cloneRegExp2(object2);
            case setTag2:
              return new Ctor();
            case symbolTag2:
              return cloneSymbol2(object2);
          }
        }
        function insertWrapDetails(source, details) {
          var length = details.length;
          if (!length) {
            return source;
          }
          var lastIndex = length - 1;
          details[lastIndex] = (length > 1 ? "& " : "") + details[lastIndex];
          details = details.join(length > 2 ? ", " : " ");
          return source.replace(reWrapComment, "{\n/* [wrapped with " + details + "] */\n");
        }
        function isFlattenable(value) {
          return isArray2(value) || isArguments2(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
        }
        function isIndex2(value, length) {
          var type2 = typeof value;
          length = length == null ? MAX_SAFE_INTEGER2 : length;
          return !!length && (type2 == "number" || type2 != "symbol" && reIsUint2.test(value)) && (value > -1 && value % 1 == 0 && value < length);
        }
        function isIterateeCall(value, index2, object2) {
          if (!isObject2(object2)) {
            return false;
          }
          var type2 = typeof index2;
          if (type2 == "number" ? isArrayLike2(object2) && isIndex2(index2, object2.length) : type2 == "string" && index2 in object2) {
            return eq2(object2[index2], value);
          }
          return false;
        }
        function isKey2(value, object2) {
          if (isArray2(value)) {
            return false;
          }
          var type2 = typeof value;
          if (type2 == "number" || type2 == "symbol" || type2 == "boolean" || value == null || isSymbol2(value)) {
            return true;
          }
          return reIsPlainProp2.test(value) || !reIsDeepProp2.test(value) || object2 != null && value in Object2(object2);
        }
        function isKeyable2(value) {
          var type2 = typeof value;
          return type2 == "string" || type2 == "number" || type2 == "symbol" || type2 == "boolean" ? value !== "__proto__" : value === null;
        }
        function isLaziable(func) {
          var funcName = getFuncName(func), other = lodash2[funcName];
          if (typeof other != "function" || !(funcName in LazyWrapper2.prototype)) {
            return false;
          }
          if (func === other) {
            return true;
          }
          var data2 = getData(other);
          return !!data2 && func === data2[0];
        }
        function isMasked2(func) {
          return !!maskSrcKey2 && maskSrcKey2 in func;
        }
        var isMaskable = coreJsData2 ? isFunction2 : stubFalse2;
        function isPrototype2(value) {
          var Ctor = value && value.constructor, proto2 = typeof Ctor == "function" && Ctor.prototype || objectProto2;
          return value === proto2;
        }
        function isStrictComparable(value) {
          return value === value && !isObject2(value);
        }
        function matchesStrictComparable(key, srcValue) {
          return function(object2) {
            if (object2 == null) {
              return false;
            }
            return object2[key] === srcValue && (srcValue !== undefined$12 || key in Object2(object2));
          };
        }
        function memoizeCapped2(func) {
          var result2 = memoize2(func, function(key) {
            if (cache2.size === MAX_MEMOIZE_SIZE2) {
              cache2.clear();
            }
            return key;
          });
          var cache2 = result2.cache;
          return result2;
        }
        function mergeData(data2, source) {
          var bitmask = data2[1], srcBitmask = source[1], newBitmask = bitmask | srcBitmask, isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
          var isCombo = srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_CURRY_FLAG || srcBitmask == WRAP_ARY_FLAG && bitmask == WRAP_REARG_FLAG && data2[7].length <= source[8] || srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG) && source[7].length <= source[8] && bitmask == WRAP_CURRY_FLAG;
          if (!(isCommon || isCombo)) {
            return data2;
          }
          if (srcBitmask & WRAP_BIND_FLAG) {
            data2[2] = source[2];
            newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
          }
          var value = source[3];
          if (value) {
            var partials = data2[3];
            data2[3] = partials ? composeArgs(partials, value, source[4]) : value;
            data2[4] = partials ? replaceHolders(data2[3], PLACEHOLDER) : source[4];
          }
          value = source[5];
          if (value) {
            partials = data2[5];
            data2[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
            data2[6] = partials ? replaceHolders(data2[5], PLACEHOLDER) : source[6];
          }
          value = source[7];
          if (value) {
            data2[7] = value;
          }
          if (srcBitmask & WRAP_ARY_FLAG) {
            data2[8] = data2[8] == null ? source[8] : nativeMin2(data2[8], source[8]);
          }
          if (data2[9] == null) {
            data2[9] = source[9];
          }
          data2[0] = source[0];
          data2[1] = newBitmask;
          return data2;
        }
        function nativeKeysIn2(object2) {
          var result2 = [];
          if (object2 != null) {
            for (var key in Object2(object2)) {
              result2.push(key);
            }
          }
          return result2;
        }
        function objectToString2(value) {
          return nativeObjectToString2.call(value);
        }
        function overRest(func, start2, transform2) {
          start2 = nativeMax2(start2 === undefined$12 ? func.length - 1 : start2, 0);
          return function() {
            var args = arguments, index2 = -1, length = nativeMax2(args.length - start2, 0), array2 = Array2(length);
            while (++index2 < length) {
              array2[index2] = args[start2 + index2];
            }
            index2 = -1;
            var otherArgs = Array2(start2 + 1);
            while (++index2 < start2) {
              otherArgs[index2] = args[index2];
            }
            otherArgs[start2] = transform2(array2);
            return apply(func, this, otherArgs);
          };
        }
        function parent(object2, path2) {
          return path2.length < 2 ? object2 : baseGet2(object2, baseSlice(path2, 0, -1));
        }
        function reorder(array2, indexes) {
          var arrLength = array2.length, length = nativeMin2(indexes.length, arrLength), oldArray = copyArray2(array2);
          while (length--) {
            var index2 = indexes[length];
            array2[length] = isIndex2(index2, arrLength) ? oldArray[index2] : undefined$12;
          }
          return array2;
        }
        function safeGet(object2, key) {
          if (key === "constructor" && typeof object2[key] === "function") {
            return;
          }
          if (key == "__proto__") {
            return;
          }
          return object2[key];
        }
        var setData = shortOut(baseSetData);
        var setTimeout2 = ctxSetTimeout || function(func, wait) {
          return root2.setTimeout(func, wait);
        };
        var setToString = shortOut(baseSetToString);
        function setWrapToString(wrapper, reference2, bitmask) {
          var source = reference2 + "";
          return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
        }
        function shortOut(func) {
          var count2 = 0, lastCalled = 0;
          return function() {
            var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
            lastCalled = stamp;
            if (remaining > 0) {
              if (++count2 >= HOT_COUNT) {
                return arguments[0];
              }
            } else {
              count2 = 0;
            }
            return func.apply(undefined$12, arguments);
          };
        }
        function shuffleSelf(array2, size3) {
          var index2 = -1, length = array2.length, lastIndex = length - 1;
          size3 = size3 === undefined$12 ? length : size3;
          while (++index2 < size3) {
            var rand = baseRandom(index2, lastIndex), value = array2[rand];
            array2[rand] = array2[index2];
            array2[index2] = value;
          }
          array2.length = size3;
          return array2;
        }
        var stringToPath2 = memoizeCapped2(function(string2) {
          var result2 = [];
          if (string2.charCodeAt(0) === 46) {
            result2.push("");
          }
          string2.replace(rePropName2, function(match2, number2, quote2, subString) {
            result2.push(quote2 ? subString.replace(reEscapeChar2, "$1") : number2 || match2);
          });
          return result2;
        });
        function toKey2(value) {
          if (typeof value == "string" || isSymbol2(value)) {
            return value;
          }
          var result2 = value + "";
          return result2 == "0" && 1 / value == -INFINITY2 ? "-0" : result2;
        }
        function toSource2(func) {
          if (func != null) {
            try {
              return funcToString2.call(func);
            } catch (e3) {
            }
            try {
              return func + "";
            } catch (e3) {
            }
          }
          return "";
        }
        function updateWrapDetails(details, bitmask) {
          arrayEach2(wrapFlags, function(pair2) {
            var value = "_." + pair2[0];
            if (bitmask & pair2[1] && !arrayIncludes(details, value)) {
              details.push(value);
            }
          });
          return details.sort();
        }
        function wrapperClone2(wrapper) {
          if (wrapper instanceof LazyWrapper2) {
            return wrapper.clone();
          }
          var result2 = new LodashWrapper2(wrapper.__wrapped__, wrapper.__chain__);
          result2.__actions__ = copyArray2(wrapper.__actions__);
          result2.__index__ = wrapper.__index__;
          result2.__values__ = wrapper.__values__;
          return result2;
        }
        function chunk(array2, size3, guard2) {
          if (guard2 ? isIterateeCall(array2, size3, guard2) : size3 === undefined$12) {
            size3 = 1;
          } else {
            size3 = nativeMax2(toInteger2(size3), 0);
          }
          var length = array2 == null ? 0 : array2.length;
          if (!length || size3 < 1) {
            return [];
          }
          var index2 = 0, resIndex = 0, result2 = Array2(nativeCeil(length / size3));
          while (index2 < length) {
            result2[resIndex++] = baseSlice(array2, index2, index2 += size3);
          }
          return result2;
        }
        function compact2(array2) {
          var index2 = -1, length = array2 == null ? 0 : array2.length, resIndex = 0, result2 = [];
          while (++index2 < length) {
            var value = array2[index2];
            if (value) {
              result2[resIndex++] = value;
            }
          }
          return result2;
        }
        function concat() {
          var length = arguments.length;
          if (!length) {
            return [];
          }
          var args = Array2(length - 1), array2 = arguments[0], index2 = length;
          while (index2--) {
            args[index2 - 1] = arguments[index2];
          }
          return arrayPush2(isArray2(array2) ? copyArray2(array2) : [array2], baseFlatten(args, 1));
        }
        var difference = baseRest(function(array2, values2) {
          return isArrayLikeObject(array2) ? baseDifference(array2, baseFlatten(values2, 1, isArrayLikeObject, true)) : [];
        });
        var differenceBy = baseRest(function(array2, values2) {
          var iteratee2 = last(values2);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined$12;
          }
          return isArrayLikeObject(array2) ? baseDifference(array2, baseFlatten(values2, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2)) : [];
        });
        var differenceWith = baseRest(function(array2, values2) {
          var comparator = last(values2);
          if (isArrayLikeObject(comparator)) {
            comparator = undefined$12;
          }
          return isArrayLikeObject(array2) ? baseDifference(array2, baseFlatten(values2, 1, isArrayLikeObject, true), undefined$12, comparator) : [];
        });
        function drop(array2, n2, guard2) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return [];
          }
          n2 = guard2 || n2 === undefined$12 ? 1 : toInteger2(n2);
          return baseSlice(array2, n2 < 0 ? 0 : n2, length);
        }
        function dropRight(array2, n2, guard2) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return [];
          }
          n2 = guard2 || n2 === undefined$12 ? 1 : toInteger2(n2);
          n2 = length - n2;
          return baseSlice(array2, 0, n2 < 0 ? 0 : n2);
        }
        function dropRightWhile(array2, predicate) {
          return array2 && array2.length ? baseWhile(array2, getIteratee(predicate, 3), true, true) : [];
        }
        function dropWhile(array2, predicate) {
          return array2 && array2.length ? baseWhile(array2, getIteratee(predicate, 3), true) : [];
        }
        function fill(array2, value, start2, end2) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return [];
          }
          if (start2 && typeof start2 != "number" && isIterateeCall(array2, value, start2)) {
            start2 = 0;
            end2 = length;
          }
          return baseFill(array2, value, start2, end2);
        }
        function findIndex2(array2, predicate, fromIndex) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return -1;
          }
          var index2 = fromIndex == null ? 0 : toInteger2(fromIndex);
          if (index2 < 0) {
            index2 = nativeMax2(length + index2, 0);
          }
          return baseFindIndex(array2, getIteratee(predicate, 3), index2);
        }
        function findLastIndex(array2, predicate, fromIndex) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return -1;
          }
          var index2 = length - 1;
          if (fromIndex !== undefined$12) {
            index2 = toInteger2(fromIndex);
            index2 = fromIndex < 0 ? nativeMax2(length + index2, 0) : nativeMin2(index2, length - 1);
          }
          return baseFindIndex(array2, getIteratee(predicate, 3), index2, true);
        }
        function flatten2(array2) {
          var length = array2 == null ? 0 : array2.length;
          return length ? baseFlatten(array2, 1) : [];
        }
        function flattenDeep(array2) {
          var length = array2 == null ? 0 : array2.length;
          return length ? baseFlatten(array2, INFINITY2) : [];
        }
        function flattenDepth(array2, depth) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return [];
          }
          depth = depth === undefined$12 ? 1 : toInteger2(depth);
          return baseFlatten(array2, depth);
        }
        function fromPairs(pairs) {
          var index2 = -1, length = pairs == null ? 0 : pairs.length, result2 = {};
          while (++index2 < length) {
            var pair2 = pairs[index2];
            result2[pair2[0]] = pair2[1];
          }
          return result2;
        }
        function head(array2) {
          return array2 && array2.length ? array2[0] : undefined$12;
        }
        function indexOf2(array2, value, fromIndex) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return -1;
          }
          var index2 = fromIndex == null ? 0 : toInteger2(fromIndex);
          if (index2 < 0) {
            index2 = nativeMax2(length + index2, 0);
          }
          return baseIndexOf(array2, value, index2);
        }
        function initial2(array2) {
          var length = array2 == null ? 0 : array2.length;
          return length ? baseSlice(array2, 0, -1) : [];
        }
        var intersection2 = baseRest(function(arrays) {
          var mapped = arrayMap2(arrays, castArrayLikeObject);
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped) : [];
        });
        var intersectionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays), mapped = arrayMap2(arrays, castArrayLikeObject);
          if (iteratee2 === last(mapped)) {
            iteratee2 = undefined$12;
          } else {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, getIteratee(iteratee2, 2)) : [];
        });
        var intersectionWith = baseRest(function(arrays) {
          var comparator = last(arrays), mapped = arrayMap2(arrays, castArrayLikeObject);
          comparator = typeof comparator == "function" ? comparator : undefined$12;
          if (comparator) {
            mapped.pop();
          }
          return mapped.length && mapped[0] === arrays[0] ? baseIntersection(mapped, undefined$12, comparator) : [];
        });
        function join2(array2, separator) {
          return array2 == null ? "" : nativeJoin.call(array2, separator);
        }
        function last(array2) {
          var length = array2 == null ? 0 : array2.length;
          return length ? array2[length - 1] : undefined$12;
        }
        function lastIndexOf(array2, value, fromIndex) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return -1;
          }
          var index2 = length;
          if (fromIndex !== undefined$12) {
            index2 = toInteger2(fromIndex);
            index2 = index2 < 0 ? nativeMax2(length + index2, 0) : nativeMin2(index2, length - 1);
          }
          return value === value ? strictLastIndexOf(array2, value, index2) : baseFindIndex(array2, baseIsNaN, index2, true);
        }
        function nth(array2, n2) {
          return array2 && array2.length ? baseNth(array2, toInteger2(n2)) : undefined$12;
        }
        var pull = baseRest(pullAll);
        function pullAll(array2, values2) {
          return array2 && array2.length && values2 && values2.length ? basePullAll(array2, values2) : array2;
        }
        function pullAllBy(array2, values2, iteratee2) {
          return array2 && array2.length && values2 && values2.length ? basePullAll(array2, values2, getIteratee(iteratee2, 2)) : array2;
        }
        function pullAllWith(array2, values2, comparator) {
          return array2 && array2.length && values2 && values2.length ? basePullAll(array2, values2, undefined$12, comparator) : array2;
        }
        var pullAt = flatRest(function(array2, indexes) {
          var length = array2 == null ? 0 : array2.length, result2 = baseAt(array2, indexes);
          basePullAt(array2, arrayMap2(indexes, function(index2) {
            return isIndex2(index2, length) ? +index2 : index2;
          }).sort(compareAscending));
          return result2;
        });
        function remove2(array2, predicate) {
          var result2 = [];
          if (!(array2 && array2.length)) {
            return result2;
          }
          var index2 = -1, indexes = [], length = array2.length;
          predicate = getIteratee(predicate, 3);
          while (++index2 < length) {
            var value = array2[index2];
            if (predicate(value, index2, array2)) {
              result2.push(value);
              indexes.push(index2);
            }
          }
          basePullAt(array2, indexes);
          return result2;
        }
        function reverse(array2) {
          return array2 == null ? array2 : nativeReverse.call(array2);
        }
        function slice(array2, start2, end2) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return [];
          }
          if (end2 && typeof end2 != "number" && isIterateeCall(array2, start2, end2)) {
            start2 = 0;
            end2 = length;
          } else {
            start2 = start2 == null ? 0 : toInteger2(start2);
            end2 = end2 === undefined$12 ? length : toInteger2(end2);
          }
          return baseSlice(array2, start2, end2);
        }
        function sortedIndex(array2, value) {
          return baseSortedIndex(array2, value);
        }
        function sortedIndexBy(array2, value, iteratee2) {
          return baseSortedIndexBy(array2, value, getIteratee(iteratee2, 2));
        }
        function sortedIndexOf(array2, value) {
          var length = array2 == null ? 0 : array2.length;
          if (length) {
            var index2 = baseSortedIndex(array2, value);
            if (index2 < length && eq2(array2[index2], value)) {
              return index2;
            }
          }
          return -1;
        }
        function sortedLastIndex(array2, value) {
          return baseSortedIndex(array2, value, true);
        }
        function sortedLastIndexBy(array2, value, iteratee2) {
          return baseSortedIndexBy(array2, value, getIteratee(iteratee2, 2), true);
        }
        function sortedLastIndexOf(array2, value) {
          var length = array2 == null ? 0 : array2.length;
          if (length) {
            var index2 = baseSortedIndex(array2, value, true) - 1;
            if (eq2(array2[index2], value)) {
              return index2;
            }
          }
          return -1;
        }
        function sortedUniq(array2) {
          return array2 && array2.length ? baseSortedUniq(array2) : [];
        }
        function sortedUniqBy(array2, iteratee2) {
          return array2 && array2.length ? baseSortedUniq(array2, getIteratee(iteratee2, 2)) : [];
        }
        function tail(array2) {
          var length = array2 == null ? 0 : array2.length;
          return length ? baseSlice(array2, 1, length) : [];
        }
        function take2(array2, n2, guard2) {
          if (!(array2 && array2.length)) {
            return [];
          }
          n2 = guard2 || n2 === undefined$12 ? 1 : toInteger2(n2);
          return baseSlice(array2, 0, n2 < 0 ? 0 : n2);
        }
        function takeRight(array2, n2, guard2) {
          var length = array2 == null ? 0 : array2.length;
          if (!length) {
            return [];
          }
          n2 = guard2 || n2 === undefined$12 ? 1 : toInteger2(n2);
          n2 = length - n2;
          return baseSlice(array2, n2 < 0 ? 0 : n2, length);
        }
        function takeRightWhile(array2, predicate) {
          return array2 && array2.length ? baseWhile(array2, getIteratee(predicate, 3), false, true) : [];
        }
        function takeWhile(array2, predicate) {
          return array2 && array2.length ? baseWhile(array2, getIteratee(predicate, 3)) : [];
        }
        var union2 = baseRest(function(arrays) {
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
        });
        var unionBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined$12;
          }
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), getIteratee(iteratee2, 2));
        });
        var unionWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined$12;
          return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), undefined$12, comparator);
        });
        function uniq(array2) {
          return array2 && array2.length ? baseUniq(array2) : [];
        }
        function uniqBy(array2, iteratee2) {
          return array2 && array2.length ? baseUniq(array2, getIteratee(iteratee2, 2)) : [];
        }
        function uniqWith(array2, comparator) {
          comparator = typeof comparator == "function" ? comparator : undefined$12;
          return array2 && array2.length ? baseUniq(array2, undefined$12, comparator) : [];
        }
        function unzip(array2) {
          if (!(array2 && array2.length)) {
            return [];
          }
          var length = 0;
          array2 = arrayFilter2(array2, function(group) {
            if (isArrayLikeObject(group)) {
              length = nativeMax2(group.length, length);
              return true;
            }
          });
          return baseTimes2(length, function(index2) {
            return arrayMap2(array2, baseProperty(index2));
          });
        }
        function unzipWith(array2, iteratee2) {
          if (!(array2 && array2.length)) {
            return [];
          }
          var result2 = unzip(array2);
          if (iteratee2 == null) {
            return result2;
          }
          return arrayMap2(result2, function(group) {
            return apply(iteratee2, undefined$12, group);
          });
        }
        var without2 = baseRest(function(array2, values2) {
          return isArrayLikeObject(array2) ? baseDifference(array2, values2) : [];
        });
        var xor2 = baseRest(function(arrays) {
          return baseXor(arrayFilter2(arrays, isArrayLikeObject));
        });
        var xorBy = baseRest(function(arrays) {
          var iteratee2 = last(arrays);
          if (isArrayLikeObject(iteratee2)) {
            iteratee2 = undefined$12;
          }
          return baseXor(arrayFilter2(arrays, isArrayLikeObject), getIteratee(iteratee2, 2));
        });
        var xorWith = baseRest(function(arrays) {
          var comparator = last(arrays);
          comparator = typeof comparator == "function" ? comparator : undefined$12;
          return baseXor(arrayFilter2(arrays, isArrayLikeObject), undefined$12, comparator);
        });
        var zip = baseRest(unzip);
        function zipObject(props, values2) {
          return baseZipObject(props || [], values2 || [], assignValue2);
        }
        function zipObjectDeep(props, values2) {
          return baseZipObject(props || [], values2 || [], baseSet2);
        }
        var zipWith = baseRest(function(arrays) {
          var length = arrays.length, iteratee2 = length > 1 ? arrays[length - 1] : undefined$12;
          iteratee2 = typeof iteratee2 == "function" ? (arrays.pop(), iteratee2) : undefined$12;
          return unzipWith(arrays, iteratee2);
        });
        function chain2(value) {
          var result2 = lodash2(value);
          result2.__chain__ = true;
          return result2;
        }
        function tap(value, interceptor) {
          interceptor(value);
          return value;
        }
        function thru(value, interceptor) {
          return interceptor(value);
        }
        var wrapperAt = flatRest(function(paths) {
          var length = paths.length, start2 = length ? paths[0] : 0, value = this.__wrapped__, interceptor = function(object2) {
            return baseAt(object2, paths);
          };
          if (length > 1 || this.__actions__.length || !(value instanceof LazyWrapper2) || !isIndex2(start2)) {
            return this.thru(interceptor);
          }
          value = value.slice(start2, +start2 + (length ? 1 : 0));
          value.__actions__.push({
            "func": thru,
            "args": [interceptor],
            "thisArg": undefined$12
          });
          return new LodashWrapper2(value, this.__chain__).thru(function(array2) {
            if (length && !array2.length) {
              array2.push(undefined$12);
            }
            return array2;
          });
        });
        function wrapperChain() {
          return chain2(this);
        }
        function wrapperCommit() {
          return new LodashWrapper2(this.value(), this.__chain__);
        }
        function wrapperNext() {
          if (this.__values__ === undefined$12) {
            this.__values__ = toArray2(this.value());
          }
          var done = this.__index__ >= this.__values__.length, value = done ? undefined$12 : this.__values__[this.__index__++];
          return { "done": done, "value": value };
        }
        function wrapperToIterator() {
          return this;
        }
        function wrapperPlant(value) {
          var result2, parent2 = this;
          while (parent2 instanceof baseLodash2) {
            var clone3 = wrapperClone2(parent2);
            clone3.__index__ = 0;
            clone3.__values__ = undefined$12;
            if (result2) {
              previous2.__wrapped__ = clone3;
            } else {
              result2 = clone3;
            }
            var previous2 = clone3;
            parent2 = parent2.__wrapped__;
          }
          previous2.__wrapped__ = value;
          return result2;
        }
        function wrapperReverse() {
          var value = this.__wrapped__;
          if (value instanceof LazyWrapper2) {
            var wrapped = value;
            if (this.__actions__.length) {
              wrapped = new LazyWrapper2(this);
            }
            wrapped = wrapped.reverse();
            wrapped.__actions__.push({
              "func": thru,
              "args": [reverse],
              "thisArg": undefined$12
            });
            return new LodashWrapper2(wrapped, this.__chain__);
          }
          return this.thru(reverse);
        }
        function wrapperValue() {
          return baseWrapperValue(this.__wrapped__, this.__actions__);
        }
        var countBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty2.call(result2, key)) {
            ++result2[key];
          } else {
            baseAssignValue2(result2, key, 1);
          }
        });
        function every(collection2, predicate, guard2) {
          var func = isArray2(collection2) ? arrayEvery : baseEvery;
          if (guard2 && isIterateeCall(collection2, predicate, guard2)) {
            predicate = undefined$12;
          }
          return func(collection2, getIteratee(predicate, 3));
        }
        function filter2(collection2, predicate) {
          var func = isArray2(collection2) ? arrayFilter2 : baseFilter;
          return func(collection2, getIteratee(predicate, 3));
        }
        var find2 = createFind(findIndex2);
        var findLast = createFind(findLastIndex);
        function flatMap(collection2, iteratee2) {
          return baseFlatten(map2(collection2, iteratee2), 1);
        }
        function flatMapDeep(collection2, iteratee2) {
          return baseFlatten(map2(collection2, iteratee2), INFINITY2);
        }
        function flatMapDepth(collection2, iteratee2, depth) {
          depth = depth === undefined$12 ? 1 : toInteger2(depth);
          return baseFlatten(map2(collection2, iteratee2), depth);
        }
        function forEach2(collection2, iteratee2) {
          var func = isArray2(collection2) ? arrayEach2 : baseEach;
          return func(collection2, getIteratee(iteratee2, 3));
        }
        function forEachRight(collection2, iteratee2) {
          var func = isArray2(collection2) ? arrayEachRight : baseEachRight;
          return func(collection2, getIteratee(iteratee2, 3));
        }
        var groupBy = createAggregator(function(result2, value, key) {
          if (hasOwnProperty2.call(result2, key)) {
            result2[key].push(value);
          } else {
            baseAssignValue2(result2, key, [value]);
          }
        });
        function includes(collection2, value, fromIndex, guard2) {
          collection2 = isArrayLike2(collection2) ? collection2 : values(collection2);
          fromIndex = fromIndex && !guard2 ? toInteger2(fromIndex) : 0;
          var length = collection2.length;
          if (fromIndex < 0) {
            fromIndex = nativeMax2(length + fromIndex, 0);
          }
          return isString2(collection2) ? fromIndex <= length && collection2.indexOf(value, fromIndex) > -1 : !!length && baseIndexOf(collection2, value, fromIndex) > -1;
        }
        var invokeMap = baseRest(function(collection2, path2, args) {
          var index2 = -1, isFunc = typeof path2 == "function", result2 = isArrayLike2(collection2) ? Array2(collection2.length) : [];
          baseEach(collection2, function(value) {
            result2[++index2] = isFunc ? apply(path2, value, args) : baseInvoke(value, path2, args);
          });
          return result2;
        });
        var keyBy = createAggregator(function(result2, value, key) {
          baseAssignValue2(result2, key, value);
        });
        function map2(collection2, iteratee2) {
          var func = isArray2(collection2) ? arrayMap2 : baseMap;
          return func(collection2, getIteratee(iteratee2, 3));
        }
        function orderBy(collection2, iteratees, orders, guard2) {
          if (collection2 == null) {
            return [];
          }
          if (!isArray2(iteratees)) {
            iteratees = iteratees == null ? [] : [iteratees];
          }
          orders = guard2 ? undefined$12 : orders;
          if (!isArray2(orders)) {
            orders = orders == null ? [] : [orders];
          }
          return baseOrderBy(collection2, iteratees, orders);
        }
        var partition = createAggregator(function(result2, value, key) {
          result2[key ? 0 : 1].push(value);
        }, function() {
          return [[], []];
        });
        function reduce2(collection2, iteratee2, accumulator) {
          var func = isArray2(collection2) ? arrayReduce : baseReduce, initAccum = arguments.length < 3;
          return func(collection2, getIteratee(iteratee2, 4), accumulator, initAccum, baseEach);
        }
        function reduceRight(collection2, iteratee2, accumulator) {
          var func = isArray2(collection2) ? arrayReduceRight : baseReduce, initAccum = arguments.length < 3;
          return func(collection2, getIteratee(iteratee2, 4), accumulator, initAccum, baseEachRight);
        }
        function reject(collection2, predicate) {
          var func = isArray2(collection2) ? arrayFilter2 : baseFilter;
          return func(collection2, negate(getIteratee(predicate, 3)));
        }
        function sample(collection2) {
          var func = isArray2(collection2) ? arraySample : baseSample;
          return func(collection2);
        }
        function sampleSize(collection2, n2, guard2) {
          if (guard2 ? isIterateeCall(collection2, n2, guard2) : n2 === undefined$12) {
            n2 = 1;
          } else {
            n2 = toInteger2(n2);
          }
          var func = isArray2(collection2) ? arraySampleSize : baseSampleSize;
          return func(collection2, n2);
        }
        function shuffle2(collection2) {
          var func = isArray2(collection2) ? arrayShuffle : baseShuffle;
          return func(collection2);
        }
        function size2(collection2) {
          if (collection2 == null) {
            return 0;
          }
          if (isArrayLike2(collection2)) {
            return isString2(collection2) ? stringSize(collection2) : collection2.length;
          }
          var tag = getTag2(collection2);
          if (tag == mapTag2 || tag == setTag2) {
            return collection2.size;
          }
          return baseKeys2(collection2).length;
        }
        function some(collection2, predicate, guard2) {
          var func = isArray2(collection2) ? arraySome2 : baseSome;
          if (guard2 && isIterateeCall(collection2, predicate, guard2)) {
            predicate = undefined$12;
          }
          return func(collection2, getIteratee(predicate, 3));
        }
        var sortBy = baseRest(function(collection2, iteratees) {
          if (collection2 == null) {
            return [];
          }
          var length = iteratees.length;
          if (length > 1 && isIterateeCall(collection2, iteratees[0], iteratees[1])) {
            iteratees = [];
          } else if (length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
            iteratees = [iteratees[0]];
          }
          return baseOrderBy(collection2, baseFlatten(iteratees, 1), []);
        });
        var now2 = ctxNow || function() {
          return root2.Date.now();
        };
        function after(n2, func) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          n2 = toInteger2(n2);
          return function() {
            if (--n2 < 1) {
              return func.apply(this, arguments);
            }
          };
        }
        function ary(func, n2, guard2) {
          n2 = guard2 ? undefined$12 : n2;
          n2 = func && n2 == null ? func.length : n2;
          return createWrap(func, WRAP_ARY_FLAG, undefined$12, undefined$12, undefined$12, undefined$12, n2);
        }
        function before(n2, func) {
          var result2;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          n2 = toInteger2(n2);
          return function() {
            if (--n2 > 0) {
              result2 = func.apply(this, arguments);
            }
            if (n2 <= 1) {
              func = undefined$12;
            }
            return result2;
          };
        }
        var bind2 = baseRest(function(func, thisArg, partials) {
          var bitmask = WRAP_BIND_FLAG;
          if (partials.length) {
            var holders = replaceHolders(partials, getHolder(bind2));
            bitmask |= WRAP_PARTIAL_FLAG;
          }
          return createWrap(func, bitmask, thisArg, partials, holders);
        });
        var bindKey2 = baseRest(function(object2, key, partials) {
          var bitmask = WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG;
          if (partials.length) {
            var holders = replaceHolders(partials, getHolder(bindKey2));
            bitmask |= WRAP_PARTIAL_FLAG;
          }
          return createWrap(key, bitmask, object2, partials, holders);
        });
        function curry2(func, arity, guard2) {
          arity = guard2 ? undefined$12 : arity;
          var result2 = createWrap(func, WRAP_CURRY_FLAG, undefined$12, undefined$12, undefined$12, undefined$12, undefined$12, arity);
          result2.placeholder = curry2.placeholder;
          return result2;
        }
        function curryRight(func, arity, guard2) {
          arity = guard2 ? undefined$12 : arity;
          var result2 = createWrap(func, WRAP_CURRY_RIGHT_FLAG, undefined$12, undefined$12, undefined$12, undefined$12, undefined$12, arity);
          result2.placeholder = curryRight.placeholder;
          return result2;
        }
        function debounce2(func, wait, options) {
          var lastArgs, lastThis, maxWait, result2, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          wait = toNumber2(wait) || 0;
          if (isObject2(options)) {
            leading = !!options.leading;
            maxing = "maxWait" in options;
            maxWait = maxing ? nativeMax2(toNumber2(options.maxWait) || 0, wait) : maxWait;
            trailing = "trailing" in options ? !!options.trailing : trailing;
          }
          function invokeFunc(time) {
            var args = lastArgs, thisArg = lastThis;
            lastArgs = lastThis = undefined$12;
            lastInvokeTime = time;
            result2 = func.apply(thisArg, args);
            return result2;
          }
          function leadingEdge(time) {
            lastInvokeTime = time;
            timerId = setTimeout2(timerExpired, wait);
            return leading ? invokeFunc(time) : result2;
          }
          function remainingWait(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
            return maxing ? nativeMin2(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
          }
          function shouldInvoke(time) {
            var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
            return lastCallTime === undefined$12 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
          }
          function timerExpired() {
            var time = now2();
            if (shouldInvoke(time)) {
              return trailingEdge(time);
            }
            timerId = setTimeout2(timerExpired, remainingWait(time));
          }
          function trailingEdge(time) {
            timerId = undefined$12;
            if (trailing && lastArgs) {
              return invokeFunc(time);
            }
            lastArgs = lastThis = undefined$12;
            return result2;
          }
          function cancel() {
            if (timerId !== undefined$12) {
              clearTimeout2(timerId);
            }
            lastInvokeTime = 0;
            lastArgs = lastCallTime = lastThis = timerId = undefined$12;
          }
          function flush() {
            return timerId === undefined$12 ? result2 : trailingEdge(now2());
          }
          function debounced() {
            var time = now2(), isInvoking = shouldInvoke(time);
            lastArgs = arguments;
            lastThis = this;
            lastCallTime = time;
            if (isInvoking) {
              if (timerId === undefined$12) {
                return leadingEdge(lastCallTime);
              }
              if (maxing) {
                clearTimeout2(timerId);
                timerId = setTimeout2(timerExpired, wait);
                return invokeFunc(lastCallTime);
              }
            }
            if (timerId === undefined$12) {
              timerId = setTimeout2(timerExpired, wait);
            }
            return result2;
          }
          debounced.cancel = cancel;
          debounced.flush = flush;
          return debounced;
        }
        var defer = baseRest(function(func, args) {
          return baseDelay(func, 1, args);
        });
        var delay = baseRest(function(func, wait, args) {
          return baseDelay(func, toNumber2(wait) || 0, args);
        });
        function flip2(func) {
          return createWrap(func, WRAP_FLIP_FLAG);
        }
        function memoize2(func, resolver2) {
          if (typeof func != "function" || resolver2 != null && typeof resolver2 != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          var memoized = function() {
            var args = arguments, key = resolver2 ? resolver2.apply(this, args) : args[0], cache2 = memoized.cache;
            if (cache2.has(key)) {
              return cache2.get(key);
            }
            var result2 = func.apply(this, args);
            memoized.cache = cache2.set(key, result2) || cache2;
            return result2;
          };
          memoized.cache = new (memoize2.Cache || MapCache2)();
          return memoized;
        }
        memoize2.Cache = MapCache2;
        function negate(predicate) {
          if (typeof predicate != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          return function() {
            var args = arguments;
            switch (args.length) {
              case 0:
                return !predicate.call(this);
              case 1:
                return !predicate.call(this, args[0]);
              case 2:
                return !predicate.call(this, args[0], args[1]);
              case 3:
                return !predicate.call(this, args[0], args[1], args[2]);
            }
            return !predicate.apply(this, args);
          };
        }
        function once2(func) {
          return before(2, func);
        }
        var overArgs = castRest(function(func, transforms) {
          transforms = transforms.length == 1 && isArray2(transforms[0]) ? arrayMap2(transforms[0], baseUnary2(getIteratee())) : arrayMap2(baseFlatten(transforms, 1), baseUnary2(getIteratee()));
          var funcsLength = transforms.length;
          return baseRest(function(args) {
            var index2 = -1, length = nativeMin2(args.length, funcsLength);
            while (++index2 < length) {
              args[index2] = transforms[index2].call(this, args[index2]);
            }
            return apply(func, this, args);
          });
        });
        var partial = baseRest(function(func, partials) {
          var holders = replaceHolders(partials, getHolder(partial));
          return createWrap(func, WRAP_PARTIAL_FLAG, undefined$12, partials, holders);
        });
        var partialRight = baseRest(function(func, partials) {
          var holders = replaceHolders(partials, getHolder(partialRight));
          return createWrap(func, WRAP_PARTIAL_RIGHT_FLAG, undefined$12, partials, holders);
        });
        var rearg = flatRest(function(func, indexes) {
          return createWrap(func, WRAP_REARG_FLAG, undefined$12, undefined$12, undefined$12, indexes);
        });
        function rest(func, start2) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          start2 = start2 === undefined$12 ? start2 : toInteger2(start2);
          return baseRest(func, start2);
        }
        function spread(func, start2) {
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          start2 = start2 == null ? 0 : nativeMax2(toInteger2(start2), 0);
          return baseRest(function(args) {
            var array2 = args[start2], otherArgs = castSlice(args, 0, start2);
            if (array2) {
              arrayPush2(otherArgs, array2);
            }
            return apply(func, this, otherArgs);
          });
        }
        function throttle2(func, wait, options) {
          var leading = true, trailing = true;
          if (typeof func != "function") {
            throw new TypeError2(FUNC_ERROR_TEXT2);
          }
          if (isObject2(options)) {
            leading = "leading" in options ? !!options.leading : leading;
            trailing = "trailing" in options ? !!options.trailing : trailing;
          }
          return debounce2(func, wait, {
            "leading": leading,
            "maxWait": wait,
            "trailing": trailing
          });
        }
        function unary(func) {
          return ary(func, 1);
        }
        function wrap2(value, wrapper) {
          return partial(castFunction(wrapper), value);
        }
        function castArray2() {
          if (!arguments.length) {
            return [];
          }
          var value = arguments[0];
          return isArray2(value) ? value : [value];
        }
        function clone2(value) {
          return baseClone2(value, CLONE_SYMBOLS_FLAG2);
        }
        function cloneWith(value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return baseClone2(value, CLONE_SYMBOLS_FLAG2, customizer);
        }
        function cloneDeep2(value) {
          return baseClone2(value, CLONE_DEEP_FLAG2 | CLONE_SYMBOLS_FLAG2);
        }
        function cloneDeepWith(value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return baseClone2(value, CLONE_DEEP_FLAG2 | CLONE_SYMBOLS_FLAG2, customizer);
        }
        function conformsTo(object2, source) {
          return source == null || baseConformsTo(object2, source, keys2(source));
        }
        function eq2(value, other) {
          return value === other || value !== value && other !== other;
        }
        var gt2 = createRelationalOperation(baseGt);
        var gte = createRelationalOperation(function(value, other) {
          return value >= other;
        });
        var isArguments2 = baseIsArguments2(function() {
          return arguments;
        }()) ? baseIsArguments2 : function(value) {
          return isObjectLike2(value) && hasOwnProperty2.call(value, "callee") && !propertyIsEnumerable2.call(value, "callee");
        };
        var isArray2 = Array2.isArray;
        var isArrayBuffer = nodeIsArrayBuffer ? baseUnary2(nodeIsArrayBuffer) : baseIsArrayBuffer;
        function isArrayLike2(value) {
          return value != null && isLength2(value.length) && !isFunction2(value);
        }
        function isArrayLikeObject(value) {
          return isObjectLike2(value) && isArrayLike2(value);
        }
        function isBoolean2(value) {
          return value === true || value === false || isObjectLike2(value) && baseGetTag2(value) == boolTag2;
        }
        var isBuffer2 = nativeIsBuffer || stubFalse2;
        var isDate2 = nodeIsDate ? baseUnary2(nodeIsDate) : baseIsDate;
        function isElement2(value) {
          return isObjectLike2(value) && value.nodeType === 1 && !isPlainObject2(value);
        }
        function isEmpty2(value) {
          if (value == null) {
            return true;
          }
          if (isArrayLike2(value) && (isArray2(value) || typeof value == "string" || typeof value.splice == "function" || isBuffer2(value) || isTypedArray2(value) || isArguments2(value))) {
            return !value.length;
          }
          var tag = getTag2(value);
          if (tag == mapTag2 || tag == setTag2) {
            return !value.size;
          }
          if (isPrototype2(value)) {
            return !baseKeys2(value).length;
          }
          for (var key in value) {
            if (hasOwnProperty2.call(value, key)) {
              return false;
            }
          }
          return true;
        }
        function isEqual2(value, other) {
          return baseIsEqual2(value, other);
        }
        function isEqualWith(value, other, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          var result2 = customizer ? customizer(value, other) : undefined$12;
          return result2 === undefined$12 ? baseIsEqual2(value, other, undefined$12, customizer) : !!result2;
        }
        function isError2(value) {
          if (!isObjectLike2(value)) {
            return false;
          }
          var tag = baseGetTag2(value);
          return tag == errorTag2 || tag == domExcTag || typeof value.message == "string" && typeof value.name == "string" && !isPlainObject2(value);
        }
        function isFinite2(value) {
          return typeof value == "number" && nativeIsFinite2(value);
        }
        function isFunction2(value) {
          if (!isObject2(value)) {
            return false;
          }
          var tag = baseGetTag2(value);
          return tag == funcTag2 || tag == genTag2 || tag == asyncTag2 || tag == proxyTag2;
        }
        function isInteger(value) {
          return typeof value == "number" && value == toInteger2(value);
        }
        function isLength2(value) {
          return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER2;
        }
        function isObject2(value) {
          var type2 = typeof value;
          return value != null && (type2 == "object" || type2 == "function");
        }
        function isObjectLike2(value) {
          return value != null && typeof value == "object";
        }
        var isMap2 = nodeIsMap2 ? baseUnary2(nodeIsMap2) : baseIsMap2;
        function isMatch(object2, source) {
          return object2 === source || baseIsMatch(object2, source, getMatchData(source));
        }
        function isMatchWith(object2, source, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return baseIsMatch(object2, source, getMatchData(source), customizer);
        }
        function isNaN2(value) {
          return isNumber2(value) && value != +value;
        }
        function isNative(value) {
          if (isMaskable(value)) {
            throw new Error2(CORE_ERROR_TEXT);
          }
          return baseIsNative2(value);
        }
        function isNull(value) {
          return value === null;
        }
        function isNil(value) {
          return value == null;
        }
        function isNumber2(value) {
          return typeof value == "number" || isObjectLike2(value) && baseGetTag2(value) == numberTag2;
        }
        function isPlainObject2(value) {
          if (!isObjectLike2(value) || baseGetTag2(value) != objectTag2) {
            return false;
          }
          var proto2 = getPrototype2(value);
          if (proto2 === null) {
            return true;
          }
          var Ctor = hasOwnProperty2.call(proto2, "constructor") && proto2.constructor;
          return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString2.call(Ctor) == objectCtorString2;
        }
        var isRegExp2 = nodeIsRegExp ? baseUnary2(nodeIsRegExp) : baseIsRegExp;
        function isSafeInteger(value) {
          return isInteger(value) && value >= -MAX_SAFE_INTEGER2 && value <= MAX_SAFE_INTEGER2;
        }
        var isSet2 = nodeIsSet2 ? baseUnary2(nodeIsSet2) : baseIsSet2;
        function isString2(value) {
          return typeof value == "string" || !isArray2(value) && isObjectLike2(value) && baseGetTag2(value) == stringTag2;
        }
        function isSymbol2(value) {
          return typeof value == "symbol" || isObjectLike2(value) && baseGetTag2(value) == symbolTag2;
        }
        var isTypedArray2 = nodeIsTypedArray2 ? baseUnary2(nodeIsTypedArray2) : baseIsTypedArray2;
        function isUndefined(value) {
          return value === undefined$12;
        }
        function isWeakMap2(value) {
          return isObjectLike2(value) && getTag2(value) == weakMapTag2;
        }
        function isWeakSet2(value) {
          return isObjectLike2(value) && baseGetTag2(value) == weakSetTag;
        }
        var lt2 = createRelationalOperation(baseLt);
        var lte = createRelationalOperation(function(value, other) {
          return value <= other;
        });
        function toArray2(value) {
          if (!value) {
            return [];
          }
          if (isArrayLike2(value)) {
            return isString2(value) ? stringToArray(value) : copyArray2(value);
          }
          if (symIterator && value[symIterator]) {
            return iteratorToArray(value[symIterator]());
          }
          var tag = getTag2(value), func = tag == mapTag2 ? mapToArray2 : tag == setTag2 ? setToArray2 : values;
          return func(value);
        }
        function toFinite2(value) {
          if (!value) {
            return value === 0 ? value : 0;
          }
          value = toNumber2(value);
          if (value === INFINITY2 || value === -INFINITY2) {
            var sign2 = value < 0 ? -1 : 1;
            return sign2 * MAX_INTEGER2;
          }
          return value === value ? value : 0;
        }
        function toInteger2(value) {
          var result2 = toFinite2(value), remainder = result2 % 1;
          return result2 === result2 ? remainder ? result2 - remainder : result2 : 0;
        }
        function toLength(value) {
          return value ? baseClamp(toInteger2(value), 0, MAX_ARRAY_LENGTH2) : 0;
        }
        function toNumber2(value) {
          if (typeof value == "number") {
            return value;
          }
          if (isSymbol2(value)) {
            return NAN2;
          }
          if (isObject2(value)) {
            var other = typeof value.valueOf == "function" ? value.valueOf() : value;
            value = isObject2(other) ? other + "" : other;
          }
          if (typeof value != "string") {
            return value === 0 ? value : +value;
          }
          value = baseTrim2(value);
          var isBinary = reIsBinary2.test(value);
          return isBinary || reIsOctal2.test(value) ? freeParseInt2(value.slice(2), isBinary ? 2 : 8) : reIsBadHex2.test(value) ? NAN2 : +value;
        }
        function toPlainObject(value) {
          return copyObject2(value, keysIn2(value));
        }
        function toSafeInteger(value) {
          return value ? baseClamp(toInteger2(value), -MAX_SAFE_INTEGER2, MAX_SAFE_INTEGER2) : value === 0 ? value : 0;
        }
        function toString2(value) {
          return value == null ? "" : baseToString2(value);
        }
        var assign2 = createAssigner(function(object2, source) {
          if (isPrototype2(source) || isArrayLike2(source)) {
            copyObject2(source, keys2(source), object2);
            return;
          }
          for (var key in source) {
            if (hasOwnProperty2.call(source, key)) {
              assignValue2(object2, key, source[key]);
            }
          }
        });
        var assignIn = createAssigner(function(object2, source) {
          copyObject2(source, keysIn2(source), object2);
        });
        var assignInWith = createAssigner(function(object2, source, srcIndex, customizer) {
          copyObject2(source, keysIn2(source), object2, customizer);
        });
        var assignWith = createAssigner(function(object2, source, srcIndex, customizer) {
          copyObject2(source, keys2(source), object2, customizer);
        });
        var at2 = flatRest(baseAt);
        function create2(prototype, properties) {
          var result2 = baseCreate2(prototype);
          return properties == null ? result2 : baseAssign2(result2, properties);
        }
        var defaults2 = baseRest(function(object2, sources) {
          object2 = Object2(object2);
          var index2 = -1;
          var length = sources.length;
          var guard2 = length > 2 ? sources[2] : undefined$12;
          if (guard2 && isIterateeCall(sources[0], sources[1], guard2)) {
            length = 1;
          }
          while (++index2 < length) {
            var source = sources[index2];
            var props = keysIn2(source);
            var propsIndex = -1;
            var propsLength = props.length;
            while (++propsIndex < propsLength) {
              var key = props[propsIndex];
              var value = object2[key];
              if (value === undefined$12 || eq2(value, objectProto2[key]) && !hasOwnProperty2.call(object2, key)) {
                object2[key] = source[key];
              }
            }
          }
          return object2;
        });
        var defaultsDeep = baseRest(function(args) {
          args.push(undefined$12, customDefaultsMerge);
          return apply(mergeWith, undefined$12, args);
        });
        function findKey2(object2, predicate) {
          return baseFindKey(object2, getIteratee(predicate, 3), baseForOwn);
        }
        function findLastKey(object2, predicate) {
          return baseFindKey(object2, getIteratee(predicate, 3), baseForOwnRight);
        }
        function forIn(object2, iteratee2) {
          return object2 == null ? object2 : baseFor(object2, getIteratee(iteratee2, 3), keysIn2);
        }
        function forInRight(object2, iteratee2) {
          return object2 == null ? object2 : baseForRight(object2, getIteratee(iteratee2, 3), keysIn2);
        }
        function forOwn(object2, iteratee2) {
          return object2 && baseForOwn(object2, getIteratee(iteratee2, 3));
        }
        function forOwnRight(object2, iteratee2) {
          return object2 && baseForOwnRight(object2, getIteratee(iteratee2, 3));
        }
        function functions2(object2) {
          return object2 == null ? [] : baseFunctions(object2, keys2(object2));
        }
        function functionsIn(object2) {
          return object2 == null ? [] : baseFunctions(object2, keysIn2(object2));
        }
        function get2(object2, path2, defaultValue2) {
          var result2 = object2 == null ? undefined$12 : baseGet2(object2, path2);
          return result2 === undefined$12 ? defaultValue2 : result2;
        }
        function has2(object2, path2) {
          return object2 != null && hasPath(object2, path2, baseHas);
        }
        function hasIn(object2, path2) {
          return object2 != null && hasPath(object2, path2, baseHasIn);
        }
        var invert = createInverter(function(result2, value, key) {
          if (value != null && typeof value.toString != "function") {
            value = nativeObjectToString2.call(value);
          }
          result2[value] = key;
        }, constant2(identity2));
        var invertBy = createInverter(function(result2, value, key) {
          if (value != null && typeof value.toString != "function") {
            value = nativeObjectToString2.call(value);
          }
          if (hasOwnProperty2.call(result2, value)) {
            result2[value].push(key);
          } else {
            result2[value] = [key];
          }
        }, getIteratee);
        var invoke = baseRest(baseInvoke);
        function keys2(object2) {
          return isArrayLike2(object2) ? arrayLikeKeys2(object2) : baseKeys2(object2);
        }
        function keysIn2(object2) {
          return isArrayLike2(object2) ? arrayLikeKeys2(object2, true) : baseKeysIn2(object2);
        }
        function mapKeys(object2, iteratee2) {
          var result2 = {};
          iteratee2 = getIteratee(iteratee2, 3);
          baseForOwn(object2, function(value, key, object3) {
            baseAssignValue2(result2, iteratee2(value, key, object3), value);
          });
          return result2;
        }
        function mapValues(object2, iteratee2) {
          var result2 = {};
          iteratee2 = getIteratee(iteratee2, 3);
          baseForOwn(object2, function(value, key, object3) {
            baseAssignValue2(result2, key, iteratee2(value, key, object3));
          });
          return result2;
        }
        var merge2 = createAssigner(function(object2, source, srcIndex) {
          baseMerge(object2, source, srcIndex);
        });
        var mergeWith = createAssigner(function(object2, source, srcIndex, customizer) {
          baseMerge(object2, source, srcIndex, customizer);
        });
        var omit = flatRest(function(object2, paths) {
          var result2 = {};
          if (object2 == null) {
            return result2;
          }
          var isDeep = false;
          paths = arrayMap2(paths, function(path2) {
            path2 = castPath2(path2, object2);
            isDeep || (isDeep = path2.length > 1);
            return path2;
          });
          copyObject2(object2, getAllKeysIn2(object2), result2);
          if (isDeep) {
            result2 = baseClone2(result2, CLONE_DEEP_FLAG2 | CLONE_FLAT_FLAG2 | CLONE_SYMBOLS_FLAG2, customOmitClone);
          }
          var length = paths.length;
          while (length--) {
            baseUnset(result2, paths[length]);
          }
          return result2;
        });
        function omitBy(object2, predicate) {
          return pickBy(object2, negate(getIteratee(predicate)));
        }
        var pick = flatRest(function(object2, paths) {
          return object2 == null ? {} : basePick(object2, paths);
        });
        function pickBy(object2, predicate) {
          if (object2 == null) {
            return {};
          }
          var props = arrayMap2(getAllKeysIn2(object2), function(prop) {
            return [prop];
          });
          predicate = getIteratee(predicate);
          return basePickBy(object2, props, function(value, path2) {
            return predicate(value, path2[0]);
          });
        }
        function result(object2, path2, defaultValue2) {
          path2 = castPath2(path2, object2);
          var index2 = -1, length = path2.length;
          if (!length) {
            length = 1;
            object2 = undefined$12;
          }
          while (++index2 < length) {
            var value = object2 == null ? undefined$12 : object2[toKey2(path2[index2])];
            if (value === undefined$12) {
              index2 = length;
              value = defaultValue2;
            }
            object2 = isFunction2(value) ? value.call(object2) : value;
          }
          return object2;
        }
        function set2(object2, path2, value) {
          return object2 == null ? object2 : baseSet2(object2, path2, value);
        }
        function setWith(object2, path2, value, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return object2 == null ? object2 : baseSet2(object2, path2, value, customizer);
        }
        var toPairs2 = createToPairs(keys2);
        var toPairsIn = createToPairs(keysIn2);
        function transform(object2, iteratee2, accumulator) {
          var isArr = isArray2(object2), isArrLike = isArr || isBuffer2(object2) || isTypedArray2(object2);
          iteratee2 = getIteratee(iteratee2, 4);
          if (accumulator == null) {
            var Ctor = object2 && object2.constructor;
            if (isArrLike) {
              accumulator = isArr ? new Ctor() : [];
            } else if (isObject2(object2)) {
              accumulator = isFunction2(Ctor) ? baseCreate2(getPrototype2(object2)) : {};
            } else {
              accumulator = {};
            }
          }
          (isArrLike ? arrayEach2 : baseForOwn)(object2, function(value, index2, object3) {
            return iteratee2(accumulator, value, index2, object3);
          });
          return accumulator;
        }
        function unset(object2, path2) {
          return object2 == null ? true : baseUnset(object2, path2);
        }
        function update2(object2, path2, updater) {
          return object2 == null ? object2 : baseUpdate(object2, path2, castFunction(updater));
        }
        function updateWith(object2, path2, updater, customizer) {
          customizer = typeof customizer == "function" ? customizer : undefined$12;
          return object2 == null ? object2 : baseUpdate(object2, path2, castFunction(updater), customizer);
        }
        function values(object2) {
          return object2 == null ? [] : baseValues(object2, keys2(object2));
        }
        function valuesIn(object2) {
          return object2 == null ? [] : baseValues(object2, keysIn2(object2));
        }
        function clamp2(number2, lower2, upper) {
          if (upper === undefined$12) {
            upper = lower2;
            lower2 = undefined$12;
          }
          if (upper !== undefined$12) {
            upper = toNumber2(upper);
            upper = upper === upper ? upper : 0;
          }
          if (lower2 !== undefined$12) {
            lower2 = toNumber2(lower2);
            lower2 = lower2 === lower2 ? lower2 : 0;
          }
          return baseClamp(toNumber2(number2), lower2, upper);
        }
        function inRange(number2, start2, end2) {
          start2 = toFinite2(start2);
          if (end2 === undefined$12) {
            end2 = start2;
            start2 = 0;
          } else {
            end2 = toFinite2(end2);
          }
          number2 = toNumber2(number2);
          return baseInRange(number2, start2, end2);
        }
        function random2(lower2, upper, floating) {
          if (floating && typeof floating != "boolean" && isIterateeCall(lower2, upper, floating)) {
            upper = floating = undefined$12;
          }
          if (floating === undefined$12) {
            if (typeof upper == "boolean") {
              floating = upper;
              upper = undefined$12;
            } else if (typeof lower2 == "boolean") {
              floating = lower2;
              lower2 = undefined$12;
            }
          }
          if (lower2 === undefined$12 && upper === undefined$12) {
            lower2 = 0;
            upper = 1;
          } else {
            lower2 = toFinite2(lower2);
            if (upper === undefined$12) {
              upper = lower2;
              lower2 = 0;
            } else {
              upper = toFinite2(upper);
            }
          }
          if (lower2 > upper) {
            var temp = lower2;
            lower2 = upper;
            upper = temp;
          }
          if (floating || lower2 % 1 || upper % 1) {
            var rand = nativeRandom();
            return nativeMin2(lower2 + rand * (upper - lower2 + freeParseFloat("1e-" + ((rand + "").length - 1))), upper);
          }
          return baseRandom(lower2, upper);
        }
        var camelCase = createCompounder(function(result2, word, index2) {
          word = word.toLowerCase();
          return result2 + (index2 ? capitalize2(word) : word);
        });
        function capitalize2(string2) {
          return upperFirst(toString2(string2).toLowerCase());
        }
        function deburr(string2) {
          string2 = toString2(string2);
          return string2 && string2.replace(reLatin, deburrLetter).replace(reComboMark, "");
        }
        function endsWith(string2, target, position2) {
          string2 = toString2(string2);
          target = baseToString2(target);
          var length = string2.length;
          position2 = position2 === undefined$12 ? length : baseClamp(toInteger2(position2), 0, length);
          var end2 = position2;
          position2 -= target.length;
          return position2 >= 0 && string2.slice(position2, end2) == target;
        }
        function escape2(string2) {
          string2 = toString2(string2);
          return string2 && reHasUnescapedHtml.test(string2) ? string2.replace(reUnescapedHtml, escapeHtmlChar) : string2;
        }
        function escapeRegExp2(string2) {
          string2 = toString2(string2);
          return string2 && reHasRegExpChar.test(string2) ? string2.replace(reRegExpChar2, "\\$&") : string2;
        }
        var kebabCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? "-" : "") + word.toLowerCase();
        });
        var lowerCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? " " : "") + word.toLowerCase();
        });
        var lowerFirst = createCaseFirst("toLowerCase");
        function pad(string2, length, chars) {
          string2 = toString2(string2);
          length = toInteger2(length);
          var strLength = length ? stringSize(string2) : 0;
          if (!length || strLength >= length) {
            return string2;
          }
          var mid = (length - strLength) / 2;
          return createPadding(nativeFloor(mid), chars) + string2 + createPadding(nativeCeil(mid), chars);
        }
        function padEnd(string2, length, chars) {
          string2 = toString2(string2);
          length = toInteger2(length);
          var strLength = length ? stringSize(string2) : 0;
          return length && strLength < length ? string2 + createPadding(length - strLength, chars) : string2;
        }
        function padStart(string2, length, chars) {
          string2 = toString2(string2);
          length = toInteger2(length);
          var strLength = length ? stringSize(string2) : 0;
          return length && strLength < length ? createPadding(length - strLength, chars) + string2 : string2;
        }
        function parseInt2(string2, radix, guard2) {
          if (guard2 || radix == null) {
            radix = 0;
          } else if (radix) {
            radix = +radix;
          }
          return nativeParseInt(toString2(string2).replace(reTrimStart2, ""), radix || 0);
        }
        function repeat(string2, n2, guard2) {
          if (guard2 ? isIterateeCall(string2, n2, guard2) : n2 === undefined$12) {
            n2 = 1;
          } else {
            n2 = toInteger2(n2);
          }
          return baseRepeat(toString2(string2), n2);
        }
        function replace2() {
          var args = arguments, string2 = toString2(args[0]);
          return args.length < 3 ? string2 : string2.replace(args[1], args[2]);
        }
        var snakeCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? "_" : "") + word.toLowerCase();
        });
        function split(string2, separator, limit2) {
          if (limit2 && typeof limit2 != "number" && isIterateeCall(string2, separator, limit2)) {
            separator = limit2 = undefined$12;
          }
          limit2 = limit2 === undefined$12 ? MAX_ARRAY_LENGTH2 : limit2 >>> 0;
          if (!limit2) {
            return [];
          }
          string2 = toString2(string2);
          if (string2 && (typeof separator == "string" || separator != null && !isRegExp2(separator))) {
            separator = baseToString2(separator);
            if (!separator && hasUnicode(string2)) {
              return castSlice(stringToArray(string2), 0, limit2);
            }
          }
          return string2.split(separator, limit2);
        }
        var startCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? " " : "") + upperFirst(word);
        });
        function startsWith(string2, target, position2) {
          string2 = toString2(string2);
          position2 = position2 == null ? 0 : baseClamp(toInteger2(position2), 0, string2.length);
          target = baseToString2(target);
          return string2.slice(position2, position2 + target.length) == target;
        }
        function template(string2, options, guard2) {
          var settings2 = lodash2.templateSettings;
          if (guard2 && isIterateeCall(string2, options, guard2)) {
            options = undefined$12;
          }
          string2 = toString2(string2);
          options = assignInWith({}, options, settings2, customDefaultsAssignIn);
          var imports = assignInWith({}, options.imports, settings2.imports, customDefaultsAssignIn), importsKeys = keys2(imports), importsValues = baseValues(imports, importsKeys);
          var isEscaping, isEvaluating, index2 = 0, interpolate2 = options.interpolate || reNoMatch, source = "__p += '";
          var reDelimiters = RegExp2(
            (options.escape || reNoMatch).source + "|" + interpolate2.source + "|" + (interpolate2 === reInterpolate ? reEsTemplate : reNoMatch).source + "|" + (options.evaluate || reNoMatch).source + "|$",
            "g"
          );
          var sourceURL = "//# sourceURL=" + (hasOwnProperty2.call(options, "sourceURL") ? (options.sourceURL + "").replace(/\s/g, " ") : "lodash.templateSources[" + ++templateCounter + "]") + "\n";
          string2.replace(reDelimiters, function(match2, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset2) {
            interpolateValue || (interpolateValue = esTemplateValue);
            source += string2.slice(index2, offset2).replace(reUnescapedString, escapeStringChar);
            if (escapeValue) {
              isEscaping = true;
              source += "' +\n__e(" + escapeValue + ") +\n'";
            }
            if (evaluateValue) {
              isEvaluating = true;
              source += "';\n" + evaluateValue + ";\n__p += '";
            }
            if (interpolateValue) {
              source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
            }
            index2 = offset2 + match2.length;
            return match2;
          });
          source += "';\n";
          var variable = hasOwnProperty2.call(options, "variable") && options.variable;
          if (!variable) {
            source = "with (obj) {\n" + source + "\n}\n";
          } else if (reForbiddenIdentifierChars.test(variable)) {
            throw new Error2(INVALID_TEMPL_VAR_ERROR_TEXT);
          }
          source = (isEvaluating ? source.replace(reEmptyStringLeading, "") : source).replace(reEmptyStringMiddle, "$1").replace(reEmptyStringTrailing, "$1;");
          source = "function(" + (variable || "obj") + ") {\n" + (variable ? "" : "obj || (obj = {});\n") + "var __t, __p = ''" + (isEscaping ? ", __e = _.escape" : "") + (isEvaluating ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n" : ";\n") + source + "return __p\n}";
          var result2 = attempt(function() {
            return Function2(importsKeys, sourceURL + "return " + source).apply(undefined$12, importsValues);
          });
          result2.source = source;
          if (isError2(result2)) {
            throw result2;
          }
          return result2;
        }
        function toLower(value) {
          return toString2(value).toLowerCase();
        }
        function toUpper(value) {
          return toString2(value).toUpperCase();
        }
        function trim2(string2, chars, guard2) {
          string2 = toString2(string2);
          if (string2 && (guard2 || chars === undefined$12)) {
            return baseTrim2(string2);
          }
          if (!string2 || !(chars = baseToString2(chars))) {
            return string2;
          }
          var strSymbols = stringToArray(string2), chrSymbols = stringToArray(chars), start2 = charsStartIndex(strSymbols, chrSymbols), end2 = charsEndIndex(strSymbols, chrSymbols) + 1;
          return castSlice(strSymbols, start2, end2).join("");
        }
        function trimEnd(string2, chars, guard2) {
          string2 = toString2(string2);
          if (string2 && (guard2 || chars === undefined$12)) {
            return string2.slice(0, trimmedEndIndex2(string2) + 1);
          }
          if (!string2 || !(chars = baseToString2(chars))) {
            return string2;
          }
          var strSymbols = stringToArray(string2), end2 = charsEndIndex(strSymbols, stringToArray(chars)) + 1;
          return castSlice(strSymbols, 0, end2).join("");
        }
        function trimStart(string2, chars, guard2) {
          string2 = toString2(string2);
          if (string2 && (guard2 || chars === undefined$12)) {
            return string2.replace(reTrimStart2, "");
          }
          if (!string2 || !(chars = baseToString2(chars))) {
            return string2;
          }
          var strSymbols = stringToArray(string2), start2 = charsStartIndex(strSymbols, stringToArray(chars));
          return castSlice(strSymbols, start2).join("");
        }
        function truncate(string2, options) {
          var length = DEFAULT_TRUNC_LENGTH, omission = DEFAULT_TRUNC_OMISSION;
          if (isObject2(options)) {
            var separator = "separator" in options ? options.separator : separator;
            length = "length" in options ? toInteger2(options.length) : length;
            omission = "omission" in options ? baseToString2(options.omission) : omission;
          }
          string2 = toString2(string2);
          var strLength = string2.length;
          if (hasUnicode(string2)) {
            var strSymbols = stringToArray(string2);
            strLength = strSymbols.length;
          }
          if (length >= strLength) {
            return string2;
          }
          var end2 = length - stringSize(omission);
          if (end2 < 1) {
            return omission;
          }
          var result2 = strSymbols ? castSlice(strSymbols, 0, end2).join("") : string2.slice(0, end2);
          if (separator === undefined$12) {
            return result2 + omission;
          }
          if (strSymbols) {
            end2 += result2.length - end2;
          }
          if (isRegExp2(separator)) {
            if (string2.slice(end2).search(separator)) {
              var match2, substring = result2;
              if (!separator.global) {
                separator = RegExp2(separator.source, toString2(reFlags2.exec(separator)) + "g");
              }
              separator.lastIndex = 0;
              while (match2 = separator.exec(substring)) {
                var newEnd = match2.index;
              }
              result2 = result2.slice(0, newEnd === undefined$12 ? end2 : newEnd);
            }
          } else if (string2.indexOf(baseToString2(separator), end2) != end2) {
            var index2 = result2.lastIndexOf(separator);
            if (index2 > -1) {
              result2 = result2.slice(0, index2);
            }
          }
          return result2 + omission;
        }
        function unescape2(string2) {
          string2 = toString2(string2);
          return string2 && reHasEscapedHtml.test(string2) ? string2.replace(reEscapedHtml, unescapeHtmlChar) : string2;
        }
        var upperCase = createCompounder(function(result2, word, index2) {
          return result2 + (index2 ? " " : "") + word.toUpperCase();
        });
        var upperFirst = createCaseFirst("toUpperCase");
        function words(string2, pattern, guard2) {
          string2 = toString2(string2);
          pattern = guard2 ? undefined$12 : pattern;
          if (pattern === undefined$12) {
            return hasUnicodeWord(string2) ? unicodeWords(string2) : asciiWords(string2);
          }
          return string2.match(pattern) || [];
        }
        var attempt = baseRest(function(func, args) {
          try {
            return apply(func, undefined$12, args);
          } catch (e3) {
            return isError2(e3) ? e3 : new Error2(e3);
          }
        });
        var bindAll = flatRest(function(object2, methodNames) {
          arrayEach2(methodNames, function(key) {
            key = toKey2(key);
            baseAssignValue2(object2, key, bind2(object2[key], object2));
          });
          return object2;
        });
        function cond(pairs) {
          var length = pairs == null ? 0 : pairs.length, toIteratee = getIteratee();
          pairs = !length ? [] : arrayMap2(pairs, function(pair2) {
            if (typeof pair2[1] != "function") {
              throw new TypeError2(FUNC_ERROR_TEXT2);
            }
            return [toIteratee(pair2[0]), pair2[1]];
          });
          return baseRest(function(args) {
            var index2 = -1;
            while (++index2 < length) {
              var pair2 = pairs[index2];
              if (apply(pair2[0], this, args)) {
                return apply(pair2[1], this, args);
              }
            }
          });
        }
        function conforms(source) {
          return baseConforms(baseClone2(source, CLONE_DEEP_FLAG2));
        }
        function constant2(value) {
          return function() {
            return value;
          };
        }
        function defaultTo(value, defaultValue2) {
          return value == null || value !== value ? defaultValue2 : value;
        }
        var flow2 = createFlow();
        var flowRight = createFlow(true);
        function identity2(value) {
          return value;
        }
        function iteratee(func) {
          return baseIteratee(typeof func == "function" ? func : baseClone2(func, CLONE_DEEP_FLAG2));
        }
        function matches2(source) {
          return baseMatches(baseClone2(source, CLONE_DEEP_FLAG2));
        }
        function matchesProperty(path2, srcValue) {
          return baseMatchesProperty(path2, baseClone2(srcValue, CLONE_DEEP_FLAG2));
        }
        var method = baseRest(function(path2, args) {
          return function(object2) {
            return baseInvoke(object2, path2, args);
          };
        });
        var methodOf = baseRest(function(object2, args) {
          return function(path2) {
            return baseInvoke(object2, path2, args);
          };
        });
        function mixin2(object2, source, options) {
          var props = keys2(source), methodNames = baseFunctions(source, props);
          if (options == null && !(isObject2(source) && (methodNames.length || !props.length))) {
            options = source;
            source = object2;
            object2 = this;
            methodNames = baseFunctions(source, keys2(source));
          }
          var chain3 = !(isObject2(options) && "chain" in options) || !!options.chain, isFunc = isFunction2(object2);
          arrayEach2(methodNames, function(methodName) {
            var func = source[methodName];
            object2[methodName] = func;
            if (isFunc) {
              object2.prototype[methodName] = function() {
                var chainAll = this.__chain__;
                if (chain3 || chainAll) {
                  var result2 = object2(this.__wrapped__), actions = result2.__actions__ = copyArray2(this.__actions__);
                  actions.push({ "func": func, "args": arguments, "thisArg": object2 });
                  result2.__chain__ = chainAll;
                  return result2;
                }
                return func.apply(object2, arrayPush2([this.value()], arguments));
              };
            }
          });
          return object2;
        }
        function noConflict() {
          if (root2._ === this) {
            root2._ = oldDash;
          }
          return this;
        }
        function noop2() {
        }
        function nthArg(n2) {
          n2 = toInteger2(n2);
          return baseRest(function(args) {
            return baseNth(args, n2);
          });
        }
        var over = createOver(arrayMap2);
        var overEvery = createOver(arrayEvery);
        var overSome = createOver(arraySome2);
        function property(path2) {
          return isKey2(path2) ? baseProperty(toKey2(path2)) : basePropertyDeep(path2);
        }
        function propertyOf(object2) {
          return function(path2) {
            return object2 == null ? undefined$12 : baseGet2(object2, path2);
          };
        }
        var range2 = createRange();
        var rangeRight = createRange(true);
        function stubArray2() {
          return [];
        }
        function stubFalse2() {
          return false;
        }
        function stubObject() {
          return {};
        }
        function stubString() {
          return "";
        }
        function stubTrue() {
          return true;
        }
        function times(n2, iteratee2) {
          n2 = toInteger2(n2);
          if (n2 < 1 || n2 > MAX_SAFE_INTEGER2) {
            return [];
          }
          var index2 = MAX_ARRAY_LENGTH2, length = nativeMin2(n2, MAX_ARRAY_LENGTH2);
          iteratee2 = getIteratee(iteratee2);
          n2 -= MAX_ARRAY_LENGTH2;
          var result2 = baseTimes2(length, iteratee2);
          while (++index2 < n2) {
            iteratee2(index2);
          }
          return result2;
        }
        function toPath2(value) {
          if (isArray2(value)) {
            return arrayMap2(value, toKey2);
          }
          return isSymbol2(value) ? [value] : copyArray2(stringToPath2(toString2(value)));
        }
        function uniqueId(prefix) {
          var id2 = ++idCounter2;
          return toString2(prefix) + id2;
        }
        var add2 = createMathOperation(function(augend, addend) {
          return augend + addend;
        }, 0);
        var ceil = createRound2("ceil");
        var divide = createMathOperation(function(dividend, divisor) {
          return dividend / divisor;
        }, 1);
        var floor2 = createRound2("floor");
        function max2(array2) {
          return array2 && array2.length ? baseExtremum(array2, identity2, baseGt) : undefined$12;
        }
        function maxBy(array2, iteratee2) {
          return array2 && array2.length ? baseExtremum(array2, getIteratee(iteratee2, 2), baseGt) : undefined$12;
        }
        function mean2(array2) {
          return baseMean(array2, identity2);
        }
        function meanBy(array2, iteratee2) {
          return baseMean(array2, getIteratee(iteratee2, 2));
        }
        function min2(array2) {
          return array2 && array2.length ? baseExtremum(array2, identity2, baseLt) : undefined$12;
        }
        function minBy(array2, iteratee2) {
          return array2 && array2.length ? baseExtremum(array2, getIteratee(iteratee2, 2), baseLt) : undefined$12;
        }
        var multiply = createMathOperation(function(multiplier, multiplicand) {
          return multiplier * multiplicand;
        }, 1);
        var round2 = createRound2("round");
        var subtract2 = createMathOperation(function(minuend, subtrahend) {
          return minuend - subtrahend;
        }, 0);
        function sum(array2) {
          return array2 && array2.length ? baseSum(array2, identity2) : 0;
        }
        function sumBy(array2, iteratee2) {
          return array2 && array2.length ? baseSum(array2, getIteratee(iteratee2, 2)) : 0;
        }
        lodash2.after = after;
        lodash2.ary = ary;
        lodash2.assign = assign2;
        lodash2.assignIn = assignIn;
        lodash2.assignInWith = assignInWith;
        lodash2.assignWith = assignWith;
        lodash2.at = at2;
        lodash2.before = before;
        lodash2.bind = bind2;
        lodash2.bindAll = bindAll;
        lodash2.bindKey = bindKey2;
        lodash2.castArray = castArray2;
        lodash2.chain = chain2;
        lodash2.chunk = chunk;
        lodash2.compact = compact2;
        lodash2.concat = concat;
        lodash2.cond = cond;
        lodash2.conforms = conforms;
        lodash2.constant = constant2;
        lodash2.countBy = countBy;
        lodash2.create = create2;
        lodash2.curry = curry2;
        lodash2.curryRight = curryRight;
        lodash2.debounce = debounce2;
        lodash2.defaults = defaults2;
        lodash2.defaultsDeep = defaultsDeep;
        lodash2.defer = defer;
        lodash2.delay = delay;
        lodash2.difference = difference;
        lodash2.differenceBy = differenceBy;
        lodash2.differenceWith = differenceWith;
        lodash2.drop = drop;
        lodash2.dropRight = dropRight;
        lodash2.dropRightWhile = dropRightWhile;
        lodash2.dropWhile = dropWhile;
        lodash2.fill = fill;
        lodash2.filter = filter2;
        lodash2.flatMap = flatMap;
        lodash2.flatMapDeep = flatMapDeep;
        lodash2.flatMapDepth = flatMapDepth;
        lodash2.flatten = flatten2;
        lodash2.flattenDeep = flattenDeep;
        lodash2.flattenDepth = flattenDepth;
        lodash2.flip = flip2;
        lodash2.flow = flow2;
        lodash2.flowRight = flowRight;
        lodash2.fromPairs = fromPairs;
        lodash2.functions = functions2;
        lodash2.functionsIn = functionsIn;
        lodash2.groupBy = groupBy;
        lodash2.initial = initial2;
        lodash2.intersection = intersection2;
        lodash2.intersectionBy = intersectionBy;
        lodash2.intersectionWith = intersectionWith;
        lodash2.invert = invert;
        lodash2.invertBy = invertBy;
        lodash2.invokeMap = invokeMap;
        lodash2.iteratee = iteratee;
        lodash2.keyBy = keyBy;
        lodash2.keys = keys2;
        lodash2.keysIn = keysIn2;
        lodash2.map = map2;
        lodash2.mapKeys = mapKeys;
        lodash2.mapValues = mapValues;
        lodash2.matches = matches2;
        lodash2.matchesProperty = matchesProperty;
        lodash2.memoize = memoize2;
        lodash2.merge = merge2;
        lodash2.mergeWith = mergeWith;
        lodash2.method = method;
        lodash2.methodOf = methodOf;
        lodash2.mixin = mixin2;
        lodash2.negate = negate;
        lodash2.nthArg = nthArg;
        lodash2.omit = omit;
        lodash2.omitBy = omitBy;
        lodash2.once = once2;
        lodash2.orderBy = orderBy;
        lodash2.over = over;
        lodash2.overArgs = overArgs;
        lodash2.overEvery = overEvery;
        lodash2.overSome = overSome;
        lodash2.partial = partial;
        lodash2.partialRight = partialRight;
        lodash2.partition = partition;
        lodash2.pick = pick;
        lodash2.pickBy = pickBy;
        lodash2.property = property;
        lodash2.propertyOf = propertyOf;
        lodash2.pull = pull;
        lodash2.pullAll = pullAll;
        lodash2.pullAllBy = pullAllBy;
        lodash2.pullAllWith = pullAllWith;
        lodash2.pullAt = pullAt;
        lodash2.range = range2;
        lodash2.rangeRight = rangeRight;
        lodash2.rearg = rearg;
        lodash2.reject = reject;
        lodash2.remove = remove2;
        lodash2.rest = rest;
        lodash2.reverse = reverse;
        lodash2.sampleSize = sampleSize;
        lodash2.set = set2;
        lodash2.setWith = setWith;
        lodash2.shuffle = shuffle2;
        lodash2.slice = slice;
        lodash2.sortBy = sortBy;
        lodash2.sortedUniq = sortedUniq;
        lodash2.sortedUniqBy = sortedUniqBy;
        lodash2.split = split;
        lodash2.spread = spread;
        lodash2.tail = tail;
        lodash2.take = take2;
        lodash2.takeRight = takeRight;
        lodash2.takeRightWhile = takeRightWhile;
        lodash2.takeWhile = takeWhile;
        lodash2.tap = tap;
        lodash2.throttle = throttle2;
        lodash2.thru = thru;
        lodash2.toArray = toArray2;
        lodash2.toPairs = toPairs2;
        lodash2.toPairsIn = toPairsIn;
        lodash2.toPath = toPath2;
        lodash2.toPlainObject = toPlainObject;
        lodash2.transform = transform;
        lodash2.unary = unary;
        lodash2.union = union2;
        lodash2.unionBy = unionBy;
        lodash2.unionWith = unionWith;
        lodash2.uniq = uniq;
        lodash2.uniqBy = uniqBy;
        lodash2.uniqWith = uniqWith;
        lodash2.unset = unset;
        lodash2.unzip = unzip;
        lodash2.unzipWith = unzipWith;
        lodash2.update = update2;
        lodash2.updateWith = updateWith;
        lodash2.values = values;
        lodash2.valuesIn = valuesIn;
        lodash2.without = without2;
        lodash2.words = words;
        lodash2.wrap = wrap2;
        lodash2.xor = xor2;
        lodash2.xorBy = xorBy;
        lodash2.xorWith = xorWith;
        lodash2.zip = zip;
        lodash2.zipObject = zipObject;
        lodash2.zipObjectDeep = zipObjectDeep;
        lodash2.zipWith = zipWith;
        lodash2.entries = toPairs2;
        lodash2.entriesIn = toPairsIn;
        lodash2.extend = assignIn;
        lodash2.extendWith = assignInWith;
        mixin2(lodash2, lodash2);
        lodash2.add = add2;
        lodash2.attempt = attempt;
        lodash2.camelCase = camelCase;
        lodash2.capitalize = capitalize2;
        lodash2.ceil = ceil;
        lodash2.clamp = clamp2;
        lodash2.clone = clone2;
        lodash2.cloneDeep = cloneDeep2;
        lodash2.cloneDeepWith = cloneDeepWith;
        lodash2.cloneWith = cloneWith;
        lodash2.conformsTo = conformsTo;
        lodash2.deburr = deburr;
        lodash2.defaultTo = defaultTo;
        lodash2.divide = divide;
        lodash2.endsWith = endsWith;
        lodash2.eq = eq2;
        lodash2.escape = escape2;
        lodash2.escapeRegExp = escapeRegExp2;
        lodash2.every = every;
        lodash2.find = find2;
        lodash2.findIndex = findIndex2;
        lodash2.findKey = findKey2;
        lodash2.findLast = findLast;
        lodash2.findLastIndex = findLastIndex;
        lodash2.findLastKey = findLastKey;
        lodash2.floor = floor2;
        lodash2.forEach = forEach2;
        lodash2.forEachRight = forEachRight;
        lodash2.forIn = forIn;
        lodash2.forInRight = forInRight;
        lodash2.forOwn = forOwn;
        lodash2.forOwnRight = forOwnRight;
        lodash2.get = get2;
        lodash2.gt = gt2;
        lodash2.gte = gte;
        lodash2.has = has2;
        lodash2.hasIn = hasIn;
        lodash2.head = head;
        lodash2.identity = identity2;
        lodash2.includes = includes;
        lodash2.indexOf = indexOf2;
        lodash2.inRange = inRange;
        lodash2.invoke = invoke;
        lodash2.isArguments = isArguments2;
        lodash2.isArray = isArray2;
        lodash2.isArrayBuffer = isArrayBuffer;
        lodash2.isArrayLike = isArrayLike2;
        lodash2.isArrayLikeObject = isArrayLikeObject;
        lodash2.isBoolean = isBoolean2;
        lodash2.isBuffer = isBuffer2;
        lodash2.isDate = isDate2;
        lodash2.isElement = isElement2;
        lodash2.isEmpty = isEmpty2;
        lodash2.isEqual = isEqual2;
        lodash2.isEqualWith = isEqualWith;
        lodash2.isError = isError2;
        lodash2.isFinite = isFinite2;
        lodash2.isFunction = isFunction2;
        lodash2.isInteger = isInteger;
        lodash2.isLength = isLength2;
        lodash2.isMap = isMap2;
        lodash2.isMatch = isMatch;
        lodash2.isMatchWith = isMatchWith;
        lodash2.isNaN = isNaN2;
        lodash2.isNative = isNative;
        lodash2.isNil = isNil;
        lodash2.isNull = isNull;
        lodash2.isNumber = isNumber2;
        lodash2.isObject = isObject2;
        lodash2.isObjectLike = isObjectLike2;
        lodash2.isPlainObject = isPlainObject2;
        lodash2.isRegExp = isRegExp2;
        lodash2.isSafeInteger = isSafeInteger;
        lodash2.isSet = isSet2;
        lodash2.isString = isString2;
        lodash2.isSymbol = isSymbol2;
        lodash2.isTypedArray = isTypedArray2;
        lodash2.isUndefined = isUndefined;
        lodash2.isWeakMap = isWeakMap2;
        lodash2.isWeakSet = isWeakSet2;
        lodash2.join = join2;
        lodash2.kebabCase = kebabCase;
        lodash2.last = last;
        lodash2.lastIndexOf = lastIndexOf;
        lodash2.lowerCase = lowerCase;
        lodash2.lowerFirst = lowerFirst;
        lodash2.lt = lt2;
        lodash2.lte = lte;
        lodash2.max = max2;
        lodash2.maxBy = maxBy;
        lodash2.mean = mean2;
        lodash2.meanBy = meanBy;
        lodash2.min = min2;
        lodash2.minBy = minBy;
        lodash2.stubArray = stubArray2;
        lodash2.stubFalse = stubFalse2;
        lodash2.stubObject = stubObject;
        lodash2.stubString = stubString;
        lodash2.stubTrue = stubTrue;
        lodash2.multiply = multiply;
        lodash2.nth = nth;
        lodash2.noConflict = noConflict;
        lodash2.noop = noop2;
        lodash2.now = now2;
        lodash2.pad = pad;
        lodash2.padEnd = padEnd;
        lodash2.padStart = padStart;
        lodash2.parseInt = parseInt2;
        lodash2.random = random2;
        lodash2.reduce = reduce2;
        lodash2.reduceRight = reduceRight;
        lodash2.repeat = repeat;
        lodash2.replace = replace2;
        lodash2.result = result;
        lodash2.round = round2;
        lodash2.runInContext = runInContext2;
        lodash2.sample = sample;
        lodash2.size = size2;
        lodash2.snakeCase = snakeCase;
        lodash2.some = some;
        lodash2.sortedIndex = sortedIndex;
        lodash2.sortedIndexBy = sortedIndexBy;
        lodash2.sortedIndexOf = sortedIndexOf;
        lodash2.sortedLastIndex = sortedLastIndex;
        lodash2.sortedLastIndexBy = sortedLastIndexBy;
        lodash2.sortedLastIndexOf = sortedLastIndexOf;
        lodash2.startCase = startCase;
        lodash2.startsWith = startsWith;
        lodash2.subtract = subtract2;
        lodash2.sum = sum;
        lodash2.sumBy = sumBy;
        lodash2.template = template;
        lodash2.times = times;
        lodash2.toFinite = toFinite2;
        lodash2.toInteger = toInteger2;
        lodash2.toLength = toLength;
        lodash2.toLower = toLower;
        lodash2.toNumber = toNumber2;
        lodash2.toSafeInteger = toSafeInteger;
        lodash2.toString = toString2;
        lodash2.toUpper = toUpper;
        lodash2.trim = trim2;
        lodash2.trimEnd = trimEnd;
        lodash2.trimStart = trimStart;
        lodash2.truncate = truncate;
        lodash2.unescape = unescape2;
        lodash2.uniqueId = uniqueId;
        lodash2.upperCase = upperCase;
        lodash2.upperFirst = upperFirst;
        lodash2.each = forEach2;
        lodash2.eachRight = forEachRight;
        lodash2.first = head;
        mixin2(lodash2, function() {
          var source = {};
          baseForOwn(lodash2, function(func, methodName) {
            if (!hasOwnProperty2.call(lodash2.prototype, methodName)) {
              source[methodName] = func;
            }
          });
          return source;
        }(), { "chain": false });
        lodash2.VERSION = VERSION;
        arrayEach2(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function(methodName) {
          lodash2[methodName].placeholder = lodash2;
        });
        arrayEach2(["drop", "take"], function(methodName, index2) {
          LazyWrapper2.prototype[methodName] = function(n2) {
            n2 = n2 === undefined$12 ? 1 : nativeMax2(toInteger2(n2), 0);
            var result2 = this.__filtered__ && !index2 ? new LazyWrapper2(this) : this.clone();
            if (result2.__filtered__) {
              result2.__takeCount__ = nativeMin2(n2, result2.__takeCount__);
            } else {
              result2.__views__.push({
                "size": nativeMin2(n2, MAX_ARRAY_LENGTH2),
                "type": methodName + (result2.__dir__ < 0 ? "Right" : "")
              });
            }
            return result2;
          };
          LazyWrapper2.prototype[methodName + "Right"] = function(n2) {
            return this.reverse()[methodName](n2).reverse();
          };
        });
        arrayEach2(["filter", "map", "takeWhile"], function(methodName, index2) {
          var type2 = index2 + 1, isFilter = type2 == LAZY_FILTER_FLAG || type2 == LAZY_WHILE_FLAG;
          LazyWrapper2.prototype[methodName] = function(iteratee2) {
            var result2 = this.clone();
            result2.__iteratees__.push({
              "iteratee": getIteratee(iteratee2, 3),
              "type": type2
            });
            result2.__filtered__ = result2.__filtered__ || isFilter;
            return result2;
          };
        });
        arrayEach2(["head", "last"], function(methodName, index2) {
          var takeName = "take" + (index2 ? "Right" : "");
          LazyWrapper2.prototype[methodName] = function() {
            return this[takeName](1).value()[0];
          };
        });
        arrayEach2(["initial", "tail"], function(methodName, index2) {
          var dropName = "drop" + (index2 ? "" : "Right");
          LazyWrapper2.prototype[methodName] = function() {
            return this.__filtered__ ? new LazyWrapper2(this) : this[dropName](1);
          };
        });
        LazyWrapper2.prototype.compact = function() {
          return this.filter(identity2);
        };
        LazyWrapper2.prototype.find = function(predicate) {
          return this.filter(predicate).head();
        };
        LazyWrapper2.prototype.findLast = function(predicate) {
          return this.reverse().find(predicate);
        };
        LazyWrapper2.prototype.invokeMap = baseRest(function(path2, args) {
          if (typeof path2 == "function") {
            return new LazyWrapper2(this);
          }
          return this.map(function(value) {
            return baseInvoke(value, path2, args);
          });
        });
        LazyWrapper2.prototype.reject = function(predicate) {
          return this.filter(negate(getIteratee(predicate)));
        };
        LazyWrapper2.prototype.slice = function(start2, end2) {
          start2 = toInteger2(start2);
          var result2 = this;
          if (result2.__filtered__ && (start2 > 0 || end2 < 0)) {
            return new LazyWrapper2(result2);
          }
          if (start2 < 0) {
            result2 = result2.takeRight(-start2);
          } else if (start2) {
            result2 = result2.drop(start2);
          }
          if (end2 !== undefined$12) {
            end2 = toInteger2(end2);
            result2 = end2 < 0 ? result2.dropRight(-end2) : result2.take(end2 - start2);
          }
          return result2;
        };
        LazyWrapper2.prototype.takeRightWhile = function(predicate) {
          return this.reverse().takeWhile(predicate).reverse();
        };
        LazyWrapper2.prototype.toArray = function() {
          return this.take(MAX_ARRAY_LENGTH2);
        };
        baseForOwn(LazyWrapper2.prototype, function(func, methodName) {
          var checkIteratee = /^(?:filter|find|map|reject)|While$/.test(methodName), isTaker = /^(?:head|last)$/.test(methodName), lodashFunc = lodash2[isTaker ? "take" + (methodName == "last" ? "Right" : "") : methodName], retUnwrapped = isTaker || /^find/.test(methodName);
          if (!lodashFunc) {
            return;
          }
          lodash2.prototype[methodName] = function() {
            var value = this.__wrapped__, args = isTaker ? [1] : arguments, isLazy = value instanceof LazyWrapper2, iteratee2 = args[0], useLazy = isLazy || isArray2(value);
            var interceptor = function(value2) {
              var result3 = lodashFunc.apply(lodash2, arrayPush2([value2], args));
              return isTaker && chainAll ? result3[0] : result3;
            };
            if (useLazy && checkIteratee && typeof iteratee2 == "function" && iteratee2.length != 1) {
              isLazy = useLazy = false;
            }
            var chainAll = this.__chain__, isHybrid = !!this.__actions__.length, isUnwrapped = retUnwrapped && !chainAll, onlyLazy = isLazy && !isHybrid;
            if (!retUnwrapped && useLazy) {
              value = onlyLazy ? value : new LazyWrapper2(this);
              var result2 = func.apply(value, args);
              result2.__actions__.push({ "func": thru, "args": [interceptor], "thisArg": undefined$12 });
              return new LodashWrapper2(result2, chainAll);
            }
            if (isUnwrapped && onlyLazy) {
              return func.apply(this, args);
            }
            result2 = this.thru(interceptor);
            return isUnwrapped ? isTaker ? result2.value()[0] : result2.value() : result2;
          };
        });
        arrayEach2(["pop", "push", "shift", "sort", "splice", "unshift"], function(methodName) {
          var func = arrayProto2[methodName], chainName = /^(?:push|sort|unshift)$/.test(methodName) ? "tap" : "thru", retUnwrapped = /^(?:pop|shift)$/.test(methodName);
          lodash2.prototype[methodName] = function() {
            var args = arguments;
            if (retUnwrapped && !this.__chain__) {
              var value = this.value();
              return func.apply(isArray2(value) ? value : [], args);
            }
            return this[chainName](function(value2) {
              return func.apply(isArray2(value2) ? value2 : [], args);
            });
          };
        });
        baseForOwn(LazyWrapper2.prototype, function(func, methodName) {
          var lodashFunc = lodash2[methodName];
          if (lodashFunc) {
            var key = lodashFunc.name + "";
            if (!hasOwnProperty2.call(realNames, key)) {
              realNames[key] = [];
            }
            realNames[key].push({ "name": methodName, "func": lodashFunc });
          }
        });
        realNames[createHybrid(undefined$12, WRAP_BIND_KEY_FLAG).name] = [{
          "name": "wrapper",
          "func": undefined$12
        }];
        LazyWrapper2.prototype.clone = lazyClone;
        LazyWrapper2.prototype.reverse = lazyReverse;
        LazyWrapper2.prototype.value = lazyValue;
        lodash2.prototype.at = wrapperAt;
        lodash2.prototype.chain = wrapperChain;
        lodash2.prototype.commit = wrapperCommit;
        lodash2.prototype.next = wrapperNext;
        lodash2.prototype.plant = wrapperPlant;
        lodash2.prototype.reverse = wrapperReverse;
        lodash2.prototype.toJSON = lodash2.prototype.valueOf = lodash2.prototype.value = wrapperValue;
        lodash2.prototype.first = lodash2.prototype.head;
        if (symIterator) {
          lodash2.prototype[symIterator] = wrapperToIterator;
        }
        return lodash2;
      };
      var _2 = runInContext();
      if (freeModule) {
        (freeModule.exports = _2)._ = _2;
        freeExports._ = _2;
      } else {
        root2._ = _2;
      }
    }).call(commonjsGlobal$1);
  })(lodash$1, lodash$1.exports);
  let nanoid = (size2 = 21) => crypto.getRandomValues(new Uint8Array(size2)).reduce((id2, byte) => {
    byte &= 63;
    if (byte < 36) {
      id2 += byte.toString(36);
    } else if (byte < 62) {
      id2 += (byte - 26).toString(36).toUpperCase();
    } else if (byte > 62) {
      id2 += "-";
    } else {
      id2 += "_";
    }
    return id2;
  }, "");
  const ErrorMessage$2 = styled__default.default.span`
    display: flex;
    flex-direction: column;

    padding-left: 1rem;

    font-size: 0.75rem;
    color: ${(props) => props.theme.colors.error};
`;
  const PrimaryTextArea = styled__default.default.textarea`
    display: flex;
    flex: 1 1 auto;
    align-items: center;

    width: 100%;
    height: 100%;
    min-height: 3.6rem;
    padding: 1rem;

    font-size: 1rem;
    color: ${(props) => props.disabled ? props.theme.colors.grey2 : props.theme.colors.text};

    background-color: ${(props) => props.theme.colors.grey1};
    border: 1px solid ${(props) => props.isErrored ? props.theme.colors.error : props.theme.colors.grey1};
    border-radius: 0.25rem;
    outline: 0;

    :focus:not(:disabled) {
        border: 1px solid ${(props) => props.isErrored ? props.theme.colors.error : props.theme.colors.grey3};
    }

    :hover:not(:disabled) {
        border: 1px solid ${(props) => props.isErrored ? props.theme.colors.error : props.theme.colors.grey2};
    }

    :active:not(:disabled) {
        border: 1px solid ${(props) => props.isErrored ? props.theme.colors.error : props.theme.colors.grey3};
    }

    :disabled {
        cursor: not-allowed;
    }

    ::placeholder {
        font-style: italic;
    }
`;
  function TextArea({ autoFocus, className, disabled: disabled2, errorMsg, initialValue, keydownFilter, onBlur, onChange: onChange2, onClick, onComplete, placeholder, style: style2, value, resize }) {
    const onChangeText = (e3) => {
      const target = e3.target;
      if (onChange2) {
        onChange2(target.value, e3);
      }
    };
    const onKeyDown = (e3) => {
      if (keydownFilter && !keydownFilter(e3)) {
        e3.preventDefault();
      }
      if (e3.key === Key.ENTER && e3.shiftKey && onComplete) {
        return;
      }
      if (e3.key === Key.ENTER && onComplete) {
        onComplete();
      }
    };
    return jsxRuntime.exports.jsxs("div", { className, style: style2, children: [jsxRuntime.exports.jsx(PrimaryTextArea, { autoFocus, defaultValue: initialValue, disabled: disabled2, isErrored: !!errorMsg, onBlur, onChange: onChangeText, onClick, onKeyDown, placeholder, style: { resize }, value }), errorMsg && jsxRuntime.exports.jsx(ErrorMessage$2, { children: errorMsg })] });
  }
  function toInteger$3(dirtyNumber) {
    if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
      return NaN;
    }
    var number2 = Number(dirtyNumber);
    if (isNaN(number2)) {
      return number2;
    }
    return number2 < 0 ? Math.ceil(number2) : Math.floor(number2);
  }
  function requiredArgs$1(required2, args) {
    if (args.length < required2) {
      throw new TypeError(required2 + " argument" + required2 > 1 ? "s" : " required, but only " + args.length + " present");
    }
  }
  function toDate$1(argument) {
    requiredArgs$1(1, arguments);
    var argStr = Object.prototype.toString.call(argument);
    if (argument instanceof Date || typeof argument === "object" && argStr === "[object Date]") {
      return new Date(argument.getTime());
    } else if (typeof argument === "number" || argStr === "[object Number]") {
      return new Date(argument);
    } else {
      if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
        console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as arguments. Please use `parseISO` to parse strings. See: https://git.io/fjule");
        console.warn(new Error().stack);
      }
      return new Date(NaN);
    }
  }
  function addMilliseconds$1(dirtyDate, dirtyAmount) {
    requiredArgs$1(2, arguments);
    var timestamp = toDate$1(dirtyDate).getTime();
    var amount = toInteger$3(dirtyAmount);
    return new Date(timestamp + amount);
  }
  var MILLISECONDS_IN_MINUTE$3 = 6e4;
  function getTimezoneOffsetInMilliseconds$1(dirtyDate) {
    var date = new Date(dirtyDate.getTime());
    var baseTimezoneOffset = Math.ceil(date.getTimezoneOffset());
    date.setSeconds(0, 0);
    var millisecondsPartOfTimezoneOffset = date.getTime() % MILLISECONDS_IN_MINUTE$3;
    return baseTimezoneOffset * MILLISECONDS_IN_MINUTE$3 + millisecondsPartOfTimezoneOffset;
  }
  function isValid$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    return !isNaN(date);
  }
  var formatDistanceLocale$1 = {
    lessThanXSeconds: {
      one: "less than a second",
      other: "less than {{count}} seconds"
    },
    xSeconds: {
      one: "1 second",
      other: "{{count}} seconds"
    },
    halfAMinute: "half a minute",
    lessThanXMinutes: {
      one: "less than a minute",
      other: "less than {{count}} minutes"
    },
    xMinutes: {
      one: "1 minute",
      other: "{{count}} minutes"
    },
    aboutXHours: {
      one: "about 1 hour",
      other: "about {{count}} hours"
    },
    xHours: {
      one: "1 hour",
      other: "{{count}} hours"
    },
    xDays: {
      one: "1 day",
      other: "{{count}} days"
    },
    aboutXMonths: {
      one: "about 1 month",
      other: "about {{count}} months"
    },
    xMonths: {
      one: "1 month",
      other: "{{count}} months"
    },
    aboutXYears: {
      one: "about 1 year",
      other: "about {{count}} years"
    },
    xYears: {
      one: "1 year",
      other: "{{count}} years"
    },
    overXYears: {
      one: "over 1 year",
      other: "over {{count}} years"
    },
    almostXYears: {
      one: "almost 1 year",
      other: "almost {{count}} years"
    }
  };
  function formatDistance$2(token, count2, options) {
    options = options || {};
    var result;
    if (typeof formatDistanceLocale$1[token] === "string") {
      result = formatDistanceLocale$1[token];
    } else if (count2 === 1) {
      result = formatDistanceLocale$1[token].one;
    } else {
      result = formatDistanceLocale$1[token].other.replace("{{count}}", count2);
    }
    if (options.addSuffix) {
      if (options.comparison > 0) {
        return "in " + result;
      } else {
        return result + " ago";
      }
    }
    return result;
  }
  function buildFormatLongFn$1(args) {
    return function(dirtyOptions) {
      var options = dirtyOptions || {};
      var width = options.width ? String(options.width) : args.defaultWidth;
      var format2 = args.formats[width] || args.formats[args.defaultWidth];
      return format2;
    };
  }
  var dateFormats$2 = {
    full: "EEEE, MMMM do, y",
    long: "MMMM do, y",
    medium: "MMM d, y",
    short: "MM/dd/yyyy"
  };
  var timeFormats$2 = {
    full: "h:mm:ss a zzzz",
    long: "h:mm:ss a z",
    medium: "h:mm:ss a",
    short: "h:mm a"
  };
  var dateTimeFormats$2 = {
    full: "{{date}} 'at' {{time}}",
    long: "{{date}} 'at' {{time}}",
    medium: "{{date}}, {{time}}",
    short: "{{date}}, {{time}}"
  };
  var formatLong$4 = {
    date: buildFormatLongFn$1({
      formats: dateFormats$2,
      defaultWidth: "full"
    }),
    time: buildFormatLongFn$1({
      formats: timeFormats$2,
      defaultWidth: "full"
    }),
    dateTime: buildFormatLongFn$1({
      formats: dateTimeFormats$2,
      defaultWidth: "full"
    })
  };
  const formatLong$5 = formatLong$4;
  var formatRelativeLocale$1 = {
    lastWeek: "'last' eeee 'at' p",
    yesterday: "'yesterday at' p",
    today: "'today at' p",
    tomorrow: "'tomorrow at' p",
    nextWeek: "eeee 'at' p",
    other: "P"
  };
  function formatRelative$2(token, _date, _baseDate, _options) {
    return formatRelativeLocale$1[token];
  }
  function buildLocalizeFn$1(args) {
    return function(dirtyIndex, dirtyOptions) {
      var options = dirtyOptions || {};
      var context2 = options.context ? String(options.context) : "standalone";
      var valuesArray;
      if (context2 === "formatting" && args.formattingValues) {
        var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
        var width = options.width ? String(options.width) : defaultWidth;
        valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
      } else {
        var _defaultWidth = args.defaultWidth;
        var _width = options.width ? String(options.width) : args.defaultWidth;
        valuesArray = args.values[_width] || args.values[_defaultWidth];
      }
      var index2 = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
      return valuesArray[index2];
    };
  }
  var eraValues$1 = {
    narrow: ["B", "A"],
    abbreviated: ["BC", "AD"],
    wide: ["Before Christ", "Anno Domini"]
  };
  var quarterValues$1 = {
    narrow: ["1", "2", "3", "4"],
    abbreviated: ["Q1", "Q2", "Q3", "Q4"],
    wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
  };
  var monthValues$1 = {
    narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
    abbreviated: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
    wide: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
  };
  var dayValues$1 = {
    narrow: ["S", "M", "T", "W", "T", "F", "S"],
    short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
    abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    wide: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
  };
  var dayPeriodValues$1 = {
    narrow: {
      am: "a",
      pm: "p",
      midnight: "mi",
      noon: "n",
      morning: "morning",
      afternoon: "afternoon",
      evening: "evening",
      night: "night"
    },
    abbreviated: {
      am: "AM",
      pm: "PM",
      midnight: "midnight",
      noon: "noon",
      morning: "morning",
      afternoon: "afternoon",
      evening: "evening",
      night: "night"
    },
    wide: {
      am: "a.m.",
      pm: "p.m.",
      midnight: "midnight",
      noon: "noon",
      morning: "morning",
      afternoon: "afternoon",
      evening: "evening",
      night: "night"
    }
  };
  var formattingDayPeriodValues$1 = {
    narrow: {
      am: "a",
      pm: "p",
      midnight: "mi",
      noon: "n",
      morning: "in the morning",
      afternoon: "in the afternoon",
      evening: "in the evening",
      night: "at night"
    },
    abbreviated: {
      am: "AM",
      pm: "PM",
      midnight: "midnight",
      noon: "noon",
      morning: "in the morning",
      afternoon: "in the afternoon",
      evening: "in the evening",
      night: "at night"
    },
    wide: {
      am: "a.m.",
      pm: "p.m.",
      midnight: "midnight",
      noon: "noon",
      morning: "in the morning",
      afternoon: "in the afternoon",
      evening: "in the evening",
      night: "at night"
    }
  };
  function ordinalNumber$1(dirtyNumber, _dirtyOptions) {
    var number2 = Number(dirtyNumber);
    var rem100 = number2 % 100;
    if (rem100 > 20 || rem100 < 10) {
      switch (rem100 % 10) {
        case 1:
          return number2 + "st";
        case 2:
          return number2 + "nd";
        case 3:
          return number2 + "rd";
      }
    }
    return number2 + "th";
  }
  var localize$2 = {
    ordinalNumber: ordinalNumber$1,
    era: buildLocalizeFn$1({
      values: eraValues$1,
      defaultWidth: "wide"
    }),
    quarter: buildLocalizeFn$1({
      values: quarterValues$1,
      defaultWidth: "wide",
      argumentCallback: function(quarter) {
        return Number(quarter) - 1;
      }
    }),
    month: buildLocalizeFn$1({
      values: monthValues$1,
      defaultWidth: "wide"
    }),
    day: buildLocalizeFn$1({
      values: dayValues$1,
      defaultWidth: "wide"
    }),
    dayPeriod: buildLocalizeFn$1({
      values: dayPeriodValues$1,
      defaultWidth: "wide",
      formattingValues: formattingDayPeriodValues$1,
      defaultFormattingWidth: "wide"
    })
  };
  const localize$3 = localize$2;
  function buildMatchPatternFn$1(args) {
    return function(dirtyString, dirtyOptions) {
      var string2 = String(dirtyString);
      var options = dirtyOptions || {};
      var matchResult = string2.match(args.matchPattern);
      if (!matchResult) {
        return null;
      }
      var matchedString = matchResult[0];
      var parseResult = string2.match(args.parsePattern);
      if (!parseResult) {
        return null;
      }
      var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
      value = options.valueCallback ? options.valueCallback(value) : value;
      return {
        value,
        rest: string2.slice(matchedString.length)
      };
    };
  }
  function buildMatchFn$1(args) {
    return function(dirtyString, dirtyOptions) {
      var string2 = String(dirtyString);
      var options = dirtyOptions || {};
      var width = options.width;
      var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
      var matchResult = string2.match(matchPattern);
      if (!matchResult) {
        return null;
      }
      var matchedString = matchResult[0];
      var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
      var value;
      if (Object.prototype.toString.call(parsePatterns) === "[object Array]") {
        value = findIndex$1(parsePatterns, function(pattern) {
          return pattern.test(string2);
        });
      } else {
        value = findKey$1(parsePatterns, function(pattern) {
          return pattern.test(string2);
        });
      }
      value = args.valueCallback ? args.valueCallback(value) : value;
      value = options.valueCallback ? options.valueCallback(value) : value;
      return {
        value,
        rest: string2.slice(matchedString.length)
      };
    };
  }
  function findKey$1(object2, predicate) {
    for (var key in object2) {
      if (object2.hasOwnProperty(key) && predicate(object2[key])) {
        return key;
      }
    }
  }
  function findIndex$1(array2, predicate) {
    for (var key = 0; key < array2.length; key++) {
      if (predicate(array2[key])) {
        return key;
      }
    }
  }
  var matchOrdinalNumberPattern$1 = /^(\d+)(th|st|nd|rd)?/i;
  var parseOrdinalNumberPattern$1 = /\d+/i;
  var matchEraPatterns$1 = {
    narrow: /^(b|a)/i,
    abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
    wide: /^(before christ|before common era|anno domini|common era)/i
  };
  var parseEraPatterns$1 = {
    any: [/^b/i, /^(a|c)/i]
  };
  var matchQuarterPatterns$1 = {
    narrow: /^[1234]/i,
    abbreviated: /^q[1234]/i,
    wide: /^[1234](th|st|nd|rd)? quarter/i
  };
  var parseQuarterPatterns$1 = {
    any: [/1/i, /2/i, /3/i, /4/i]
  };
  var matchMonthPatterns$1 = {
    narrow: /^[jfmasond]/i,
    abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
    wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
  };
  var parseMonthPatterns$1 = {
    narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
    any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
  };
  var matchDayPatterns$1 = {
    narrow: /^[smtwf]/i,
    short: /^(su|mo|tu|we|th|fr|sa)/i,
    abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
    wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
  };
  var parseDayPatterns$1 = {
    narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
    any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
  };
  var matchDayPeriodPatterns$1 = {
    narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
    any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
  };
  var parseDayPeriodPatterns$1 = {
    any: {
      am: /^a/i,
      pm: /^p/i,
      midnight: /^mi/i,
      noon: /^no/i,
      morning: /morning/i,
      afternoon: /afternoon/i,
      evening: /evening/i,
      night: /night/i
    }
  };
  var match$3 = {
    ordinalNumber: buildMatchPatternFn$1({
      matchPattern: matchOrdinalNumberPattern$1,
      parsePattern: parseOrdinalNumberPattern$1,
      valueCallback: function(value) {
        return parseInt(value, 10);
      }
    }),
    era: buildMatchFn$1({
      matchPatterns: matchEraPatterns$1,
      defaultMatchWidth: "wide",
      parsePatterns: parseEraPatterns$1,
      defaultParseWidth: "any"
    }),
    quarter: buildMatchFn$1({
      matchPatterns: matchQuarterPatterns$1,
      defaultMatchWidth: "wide",
      parsePatterns: parseQuarterPatterns$1,
      defaultParseWidth: "any",
      valueCallback: function(index2) {
        return index2 + 1;
      }
    }),
    month: buildMatchFn$1({
      matchPatterns: matchMonthPatterns$1,
      defaultMatchWidth: "wide",
      parsePatterns: parseMonthPatterns$1,
      defaultParseWidth: "any"
    }),
    day: buildMatchFn$1({
      matchPatterns: matchDayPatterns$1,
      defaultMatchWidth: "wide",
      parsePatterns: parseDayPatterns$1,
      defaultParseWidth: "any"
    }),
    dayPeriod: buildMatchFn$1({
      matchPatterns: matchDayPeriodPatterns$1,
      defaultMatchWidth: "any",
      parsePatterns: parseDayPeriodPatterns$1,
      defaultParseWidth: "any"
    })
  };
  const match$4 = match$3;
  var locale$2 = {
    code: "en-US",
    formatDistance: formatDistance$2,
    formatLong: formatLong$5,
    formatRelative: formatRelative$2,
    localize: localize$3,
    match: match$4,
    options: {
      weekStartsOn: 0,
      firstWeekContainsDate: 1
    }
  };
  const defaultLocale$1 = locale$2;
  function subMilliseconds$1(dirtyDate, dirtyAmount) {
    requiredArgs$1(2, arguments);
    var amount = toInteger$3(dirtyAmount);
    return addMilliseconds$1(dirtyDate, -amount);
  }
  function addLeadingZeros$1(number2, targetLength) {
    var sign2 = number2 < 0 ? "-" : "";
    var output2 = Math.abs(number2).toString();
    while (output2.length < targetLength) {
      output2 = "0" + output2;
    }
    return sign2 + output2;
  }
  var formatters$5 = {
    y: function(date, token) {
      var signedYear = date.getUTCFullYear();
      var year = signedYear > 0 ? signedYear : 1 - signedYear;
      return addLeadingZeros$1(token === "yy" ? year % 100 : year, token.length);
    },
    M: function(date, token) {
      var month = date.getUTCMonth();
      return token === "M" ? String(month + 1) : addLeadingZeros$1(month + 1, 2);
    },
    d: function(date, token) {
      return addLeadingZeros$1(date.getUTCDate(), token.length);
    },
    a: function(date, token) {
      var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? "pm" : "am";
      switch (token) {
        case "a":
        case "aa":
        case "aaa":
          return dayPeriodEnumValue.toUpperCase();
        case "aaaaa":
          return dayPeriodEnumValue[0];
        case "aaaa":
        default:
          return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
      }
    },
    h: function(date, token) {
      return addLeadingZeros$1(date.getUTCHours() % 12 || 12, token.length);
    },
    H: function(date, token) {
      return addLeadingZeros$1(date.getUTCHours(), token.length);
    },
    m: function(date, token) {
      return addLeadingZeros$1(date.getUTCMinutes(), token.length);
    },
    s: function(date, token) {
      return addLeadingZeros$1(date.getUTCSeconds(), token.length);
    },
    S: function(date, token) {
      var numberOfDigits = token.length;
      var milliseconds = date.getUTCMilliseconds();
      var fractionalSeconds = Math.floor(milliseconds * Math.pow(10, numberOfDigits - 3));
      return addLeadingZeros$1(fractionalSeconds, token.length);
    }
  };
  const formatters$6 = formatters$5;
  var MILLISECONDS_IN_DAY$2 = 864e5;
  function getUTCDayOfYear$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    var timestamp = date.getTime();
    date.setUTCMonth(0, 1);
    date.setUTCHours(0, 0, 0, 0);
    var startOfYearTimestamp = date.getTime();
    var difference = timestamp - startOfYearTimestamp;
    return Math.floor(difference / MILLISECONDS_IN_DAY$2) + 1;
  }
  function startOfUTCISOWeek$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var weekStartsOn = 1;
    var date = toDate$1(dirtyDate);
    var day = date.getUTCDay();
    var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
    date.setUTCDate(date.getUTCDate() - diff);
    date.setUTCHours(0, 0, 0, 0);
    return date;
  }
  function getUTCISOWeekYear$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    var year = date.getUTCFullYear();
    var fourthOfJanuaryOfNextYear = new Date(0);
    fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
    fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
    var startOfNextYear = startOfUTCISOWeek$1(fourthOfJanuaryOfNextYear);
    var fourthOfJanuaryOfThisYear = new Date(0);
    fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
    fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
    var startOfThisYear = startOfUTCISOWeek$1(fourthOfJanuaryOfThisYear);
    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }
  function startOfUTCISOWeekYear$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var year = getUTCISOWeekYear$1(dirtyDate);
    var fourthOfJanuary = new Date(0);
    fourthOfJanuary.setUTCFullYear(year, 0, 4);
    fourthOfJanuary.setUTCHours(0, 0, 0, 0);
    var date = startOfUTCISOWeek$1(fourthOfJanuary);
    return date;
  }
  var MILLISECONDS_IN_WEEK$4 = 6048e5;
  function getUTCISOWeek$1(dirtyDate) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    var diff = startOfUTCISOWeek$1(date).getTime() - startOfUTCISOWeekYear$1(date).getTime();
    return Math.round(diff / MILLISECONDS_IN_WEEK$4) + 1;
  }
  function startOfUTCWeek$1(dirtyDate, dirtyOptions) {
    requiredArgs$1(1, arguments);
    var options = dirtyOptions || {};
    var locale2 = options.locale;
    var localeWeekStartsOn = locale2 && locale2.options && locale2.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger$3(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger$3(options.weekStartsOn);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    var date = toDate$1(dirtyDate);
    var day = date.getUTCDay();
    var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
    date.setUTCDate(date.getUTCDate() - diff);
    date.setUTCHours(0, 0, 0, 0);
    return date;
  }
  function getUTCWeekYear$1(dirtyDate, dirtyOptions) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate, dirtyOptions);
    var year = date.getUTCFullYear();
    var options = dirtyOptions || {};
    var locale2 = options.locale;
    var localeFirstWeekContainsDate = locale2 && locale2.options && locale2.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger$3(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger$3(options.firstWeekContainsDate);
    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
    }
    var firstWeekOfNextYear = new Date(0);
    firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
    firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
    var startOfNextYear = startOfUTCWeek$1(firstWeekOfNextYear, dirtyOptions);
    var firstWeekOfThisYear = new Date(0);
    firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
    firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
    var startOfThisYear = startOfUTCWeek$1(firstWeekOfThisYear, dirtyOptions);
    if (date.getTime() >= startOfNextYear.getTime()) {
      return year + 1;
    } else if (date.getTime() >= startOfThisYear.getTime()) {
      return year;
    } else {
      return year - 1;
    }
  }
  function startOfUTCWeekYear$1(dirtyDate, dirtyOptions) {
    requiredArgs$1(1, arguments);
    var options = dirtyOptions || {};
    var locale2 = options.locale;
    var localeFirstWeekContainsDate = locale2 && locale2.options && locale2.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger$3(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger$3(options.firstWeekContainsDate);
    var year = getUTCWeekYear$1(dirtyDate, dirtyOptions);
    var firstWeek = new Date(0);
    firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
    firstWeek.setUTCHours(0, 0, 0, 0);
    var date = startOfUTCWeek$1(firstWeek, dirtyOptions);
    return date;
  }
  var MILLISECONDS_IN_WEEK$3 = 6048e5;
  function getUTCWeek$1(dirtyDate, options) {
    requiredArgs$1(1, arguments);
    var date = toDate$1(dirtyDate);
    var diff = startOfUTCWeek$1(date, options).getTime() - startOfUTCWeekYear$1(date, options).getTime();
    return Math.round(diff / MILLISECONDS_IN_WEEK$3) + 1;
  }
  var dayPeriodEnum$1 = {
    am: "am",
    pm: "pm",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  };
  var formatters$3 = {
    G: function(date, token, localize2) {
      var era = date.getUTCFullYear() > 0 ? 1 : 0;
      switch (token) {
        case "G":
        case "GG":
        case "GGG":
          return localize2.era(era, {
            width: "abbreviated"
          });
        case "GGGGG":
          return localize2.era(era, {
            width: "narrow"
          });
        case "GGGG":
        default:
          return localize2.era(era, {
            width: "wide"
          });
      }
    },
    y: function(date, token, localize2) {
      if (token === "yo") {
        var signedYear = date.getUTCFullYear();
        var year = signedYear > 0 ? signedYear : 1 - signedYear;
        return localize2.ordinalNumber(year, {
          unit: "year"
        });
      }
      return formatters$6.y(date, token);
    },
    Y: function(date, token, localize2, options) {
      var signedWeekYear = getUTCWeekYear$1(date, options);
      var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;
      if (token === "YY") {
        var twoDigitYear = weekYear % 100;
        return addLeadingZeros$1(twoDigitYear, 2);
      }
      if (token === "Yo") {
        return localize2.ordinalNumber(weekYear, {
          unit: "year"
        });
      }
      return addLeadingZeros$1(weekYear, token.length);
    },
    R: function(date, token) {
      var isoWeekYear = getUTCISOWeekYear$1(date);
      return addLeadingZeros$1(isoWeekYear, token.length);
    },
    u: function(date, token) {
      var year = date.getUTCFullYear();
      return addLeadingZeros$1(year, token.length);
    },
    Q: function(date, token, localize2) {
      var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
      switch (token) {
        case "Q":
          return String(quarter);
        case "QQ":
          return addLeadingZeros$1(quarter, 2);
        case "Qo":
          return localize2.ordinalNumber(quarter, {
            unit: "quarter"
          });
        case "QQQ":
          return localize2.quarter(quarter, {
            width: "abbreviated",
            context: "formatting"
          });
        case "QQQQQ":
          return localize2.quarter(quarter, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQ":
        default:
          return localize2.quarter(quarter, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    q: function(date, token, localize2) {
      var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
      switch (token) {
        case "q":
          return String(quarter);
        case "qq":
          return addLeadingZeros$1(quarter, 2);
        case "qo":
          return localize2.ordinalNumber(quarter, {
            unit: "quarter"
          });
        case "qqq":
          return localize2.quarter(quarter, {
            width: "abbreviated",
            context: "standalone"
          });
        case "qqqqq":
          return localize2.quarter(quarter, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqq":
        default:
          return localize2.quarter(quarter, {
            width: "wide",
            context: "standalone"
          });
      }
    },
    M: function(date, token, localize2) {
      var month = date.getUTCMonth();
      switch (token) {
        case "M":
        case "MM":
          return formatters$6.M(date, token);
        case "Mo":
          return localize2.ordinalNumber(month + 1, {
            unit: "month"
          });
        case "MMM":
          return localize2.month(month, {
            width: "abbreviated",
            context: "formatting"
          });
        case "MMMMM":
          return localize2.month(month, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMM":
        default:
          return localize2.month(month, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    L: function(date, token, localize2) {
      var month = date.getUTCMonth();
      switch (token) {
        case "L":
          return String(month + 1);
        case "LL":
          return addLeadingZeros$1(month + 1, 2);
        case "Lo":
          return localize2.ordinalNumber(month + 1, {
            unit: "month"
          });
        case "LLL":
          return localize2.month(month, {
            width: "abbreviated",
            context: "standalone"
          });
        case "LLLLL":
          return localize2.month(month, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLL":
        default:
          return localize2.month(month, {
            width: "wide",
            context: "standalone"
          });
      }
    },
    w: function(date, token, localize2, options) {
      var week = getUTCWeek$1(date, options);
      if (token === "wo") {
        return localize2.ordinalNumber(week, {
          unit: "week"
        });
      }
      return addLeadingZeros$1(week, token.length);
    },
    I: function(date, token, localize2) {
      var isoWeek = getUTCISOWeek$1(date);
      if (token === "Io") {
        return localize2.ordinalNumber(isoWeek, {
          unit: "week"
        });
      }
      return addLeadingZeros$1(isoWeek, token.length);
    },
    d: function(date, token, localize2) {
      if (token === "do") {
        return localize2.ordinalNumber(date.getUTCDate(), {
          unit: "date"
        });
      }
      return formatters$6.d(date, token);
    },
    D: function(date, token, localize2) {
      var dayOfYear = getUTCDayOfYear$1(date);
      if (token === "Do") {
        return localize2.ordinalNumber(dayOfYear, {
          unit: "dayOfYear"
        });
      }
      return addLeadingZeros$1(dayOfYear, token.length);
    },
    E: function(date, token, localize2) {
      var dayOfWeek = date.getUTCDay();
      switch (token) {
        case "E":
        case "EE":
        case "EEE":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "formatting"
          });
        case "EEEEE":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEEE":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "formatting"
          });
        case "EEEE":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    e: function(date, token, localize2, options) {
      var dayOfWeek = date.getUTCDay();
      var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
      switch (token) {
        case "e":
          return String(localDayOfWeek);
        case "ee":
          return addLeadingZeros$1(localDayOfWeek, 2);
        case "eo":
          return localize2.ordinalNumber(localDayOfWeek, {
            unit: "day"
          });
        case "eee":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "formatting"
          });
        case "eeeee":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeeee":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "formatting"
          });
        case "eeee":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    c: function(date, token, localize2, options) {
      var dayOfWeek = date.getUTCDay();
      var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
      switch (token) {
        case "c":
          return String(localDayOfWeek);
        case "cc":
          return addLeadingZeros$1(localDayOfWeek, token.length);
        case "co":
          return localize2.ordinalNumber(localDayOfWeek, {
            unit: "day"
          });
        case "ccc":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "standalone"
          });
        case "ccccc":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "standalone"
          });
        case "cccccc":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "standalone"
          });
        case "cccc":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "standalone"
          });
      }
    },
    i: function(date, token, localize2) {
      var dayOfWeek = date.getUTCDay();
      var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
      switch (token) {
        case "i":
          return String(isoDayOfWeek);
        case "ii":
          return addLeadingZeros$1(isoDayOfWeek, token.length);
        case "io":
          return localize2.ordinalNumber(isoDayOfWeek, {
            unit: "day"
          });
        case "iii":
          return localize2.day(dayOfWeek, {
            width: "abbreviated",
            context: "formatting"
          });
        case "iiiii":
          return localize2.day(dayOfWeek, {
            width: "narrow",
            context: "formatting"
          });
        case "iiiiii":
          return localize2.day(dayOfWeek, {
            width: "short",
            context: "formatting"
          });
        case "iiii":
        default:
          return localize2.day(dayOfWeek, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    a: function(date, token, localize2) {
      var hours = date.getUTCHours();
      var dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
      switch (token) {
        case "a":
        case "aa":
        case "aaa":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          });
        case "aaaaa":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaa":
        default:
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    b: function(date, token, localize2) {
      var hours = date.getUTCHours();
      var dayPeriodEnumValue;
      if (hours === 12) {
        dayPeriodEnumValue = dayPeriodEnum$1.noon;
      } else if (hours === 0) {
        dayPeriodEnumValue = dayPeriodEnum$1.midnight;
      } else {
        dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
      }
      switch (token) {
        case "b":
        case "bb":
        case "bbb":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          });
        case "bbbbb":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbb":
        default:
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    B: function(date, token, localize2) {
      var hours = date.getUTCHours();
      var dayPeriodEnumValue;
      if (hours >= 17) {
        dayPeriodEnumValue = dayPeriodEnum$1.evening;
      } else if (hours >= 12) {
        dayPeriodEnumValue = dayPeriodEnum$1.afternoon;
      } else if (hours >= 4) {
        dayPeriodEnumValue = dayPeriodEnum$1.morning;
      } else {
        dayPeriodEnumValue = dayPeriodEnum$1.night;
      }
      switch (token) {
        case "B":
        case "BB":
        case "BBB":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "abbreviated",
            context: "formatting"
          });
        case "BBBBB":
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBB":
        default:
          return localize2.dayPeriod(dayPeriodEnumValue, {
            width: "wide",
            context: "formatting"
          });
      }
    },
    h: function(date, token, localize2) {
      if (token === "ho") {
        var hours = date.getUTCHours() % 12;
        if (hours === 0)
          hours = 12;
        return localize2.ordinalNumber(hours, {
          unit: "hour"
        });
      }
      return formatters$6.h(date, token);
    },
    H: function(date, token, localize2) {
      if (token === "Ho") {
        return localize2.ordinalNumber(date.getUTCHours(), {
          unit: "hour"
        });
      }
      return formatters$6.H(date, token);
    },
    K: function(date, token, localize2) {
      var hours = date.getUTCHours() % 12;
      if (token === "Ko") {
        return localize2.ordinalNumber(hours, {
          unit: "hour"
        });
      }
      return addLeadingZeros$1(hours, token.length);
    },
    k: function(date, token, localize2) {
      var hours = date.getUTCHours();
      if (hours === 0)
        hours = 24;
      if (token === "ko") {
        return localize2.ordinalNumber(hours, {
          unit: "hour"
        });
      }
      return addLeadingZeros$1(hours, token.length);
    },
    m: function(date, token, localize2) {
      if (token === "mo") {
        return localize2.ordinalNumber(date.getUTCMinutes(), {
          unit: "minute"
        });
      }
      return formatters$6.m(date, token);
    },
    s: function(date, token, localize2) {
      if (token === "so") {
        return localize2.ordinalNumber(date.getUTCSeconds(), {
          unit: "second"
        });
      }
      return formatters$6.s(date, token);
    },
    S: function(date, token) {
      return formatters$6.S(date, token);
    },
    X: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      if (timezoneOffset === 0) {
        return "Z";
      }
      switch (token) {
        case "X":
          return formatTimezoneWithOptionalMinutes$1(timezoneOffset);
        case "XXXX":
        case "XX":
          return formatTimezone$1(timezoneOffset);
        case "XXXXX":
        case "XXX":
        default:
          return formatTimezone$1(timezoneOffset, ":");
      }
    },
    x: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      switch (token) {
        case "x":
          return formatTimezoneWithOptionalMinutes$1(timezoneOffset);
        case "xxxx":
        case "xx":
          return formatTimezone$1(timezoneOffset);
        case "xxxxx":
        case "xxx":
        default:
          return formatTimezone$1(timezoneOffset, ":");
      }
    },
    O: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      switch (token) {
        case "O":
        case "OO":
        case "OOO":
          return "GMT" + formatTimezoneShort$1(timezoneOffset, ":");
        case "OOOO":
        default:
          return "GMT" + formatTimezone$1(timezoneOffset, ":");
      }
    },
    z: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timezoneOffset = originalDate.getTimezoneOffset();
      switch (token) {
        case "z":
        case "zz":
        case "zzz":
          return "GMT" + formatTimezoneShort$1(timezoneOffset, ":");
        case "zzzz":
        default:
          return "GMT" + formatTimezone$1(timezoneOffset, ":");
      }
    },
    t: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timestamp = Math.floor(originalDate.getTime() / 1e3);
      return addLeadingZeros$1(timestamp, token.length);
    },
    T: function(date, token, _localize, options) {
      var originalDate = options._originalDate || date;
      var timestamp = originalDate.getTime();
      return addLeadingZeros$1(timestamp, token.length);
    }
  };
  function formatTimezoneShort$1(offset2, dirtyDelimiter) {
    var sign2 = offset2 > 0 ? "-" : "+";
    var absOffset = Math.abs(offset2);
    var hours = Math.floor(absOffset / 60);
    var minutes = absOffset % 60;
    if (minutes === 0) {
      return sign2 + String(hours);
    }
    var delimiter = dirtyDelimiter || "";
    return sign2 + String(hours) + delimiter + addLeadingZeros$1(minutes, 2);
  }
  function formatTimezoneWithOptionalMinutes$1(offset2, dirtyDelimiter) {
    if (offset2 % 60 === 0) {
      var sign2 = offset2 > 0 ? "-" : "+";
      return sign2 + addLeadingZeros$1(Math.abs(offset2) / 60, 2);
    }
    return formatTimezone$1(offset2, dirtyDelimiter);
  }
  function formatTimezone$1(offset2, dirtyDelimiter) {
    var delimiter = dirtyDelimiter || "";
    var sign2 = offset2 > 0 ? "-" : "+";
    var absOffset = Math.abs(offset2);
    var hours = addLeadingZeros$1(Math.floor(absOffset / 60), 2);
    var minutes = addLeadingZeros$1(absOffset % 60, 2);
    return sign2 + hours + delimiter + minutes;
  }
  const formatters$4 = formatters$3;
  function dateLongFormatter$1(pattern, formatLong2) {
    switch (pattern) {
      case "P":
        return formatLong2.date({
          width: "short"
        });
      case "PP":
        return formatLong2.date({
          width: "medium"
        });
      case "PPP":
        return formatLong2.date({
          width: "long"
        });
      case "PPPP":
      default:
        return formatLong2.date({
          width: "full"
        });
    }
  }
  function timeLongFormatter$1(pattern, formatLong2) {
    switch (pattern) {
      case "p":
        return formatLong2.time({
          width: "short"
        });
      case "pp":
        return formatLong2.time({
          width: "medium"
        });
      case "ppp":
        return formatLong2.time({
          width: "long"
        });
      case "pppp":
      default:
        return formatLong2.time({
          width: "full"
        });
    }
  }
  function dateTimeLongFormatter$1(pattern, formatLong2) {
    var matchResult = pattern.match(/(P+)(p+)?/);
    var datePattern = matchResult[1];
    var timePattern = matchResult[2];
    if (!timePattern) {
      return dateLongFormatter$1(pattern, formatLong2);
    }
    var dateTimeFormat;
    switch (datePattern) {
      case "P":
        dateTimeFormat = formatLong2.dateTime({
          width: "short"
        });
        break;
      case "PP":
        dateTimeFormat = formatLong2.dateTime({
          width: "medium"
        });
        break;
      case "PPP":
        dateTimeFormat = formatLong2.dateTime({
          width: "long"
        });
        break;
      case "PPPP":
      default:
        dateTimeFormat = formatLong2.dateTime({
          width: "full"
        });
        break;
    }
    return dateTimeFormat.replace("{{date}}", dateLongFormatter$1(datePattern, formatLong2)).replace("{{time}}", timeLongFormatter$1(timePattern, formatLong2));
  }
  var longFormatters$2 = {
    p: timeLongFormatter$1,
    P: dateTimeLongFormatter$1
  };
  const longFormatters$3 = longFormatters$2;
  var protectedDayOfYearTokens$1 = ["D", "DD"];
  var protectedWeekYearTokens$1 = ["YY", "YYYY"];
  function isProtectedDayOfYearToken$1(token) {
    return protectedDayOfYearTokens$1.indexOf(token) !== -1;
  }
  function isProtectedWeekYearToken$1(token) {
    return protectedWeekYearTokens$1.indexOf(token) !== -1;
  }
  function throwProtectedError$1(token) {
    if (token === "YYYY") {
      throw new RangeError("Use `yyyy` instead of `YYYY` for formatting years; see: https://git.io/fxCyr");
    } else if (token === "YY") {
      throw new RangeError("Use `yy` instead of `YY` for formatting years; see: https://git.io/fxCyr");
    } else if (token === "D") {
      throw new RangeError("Use `d` instead of `D` for formatting days of the month; see: https://git.io/fxCyr");
    } else if (token === "DD") {
      throw new RangeError("Use `dd` instead of `DD` for formatting days of the month; see: https://git.io/fxCyr");
    }
  }
  var formattingTokensRegExp$3 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
  var longFormattingTokensRegExp$3 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
  var escapedStringRegExp$3 = /^'([^]*?)'?$/;
  var doubleQuoteRegExp$3 = /''/g;
  var unescapedLatinCharacterRegExp$3 = /[a-zA-Z]/;
  function format$2(dirtyDate, dirtyFormatStr, dirtyOptions) {
    requiredArgs$1(2, arguments);
    var formatStr = String(dirtyFormatStr);
    var options = dirtyOptions || {};
    var locale2 = options.locale || defaultLocale$1;
    var localeFirstWeekContainsDate = locale2.options && locale2.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger$3(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger$3(options.firstWeekContainsDate);
    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
    }
    var localeWeekStartsOn = locale2.options && locale2.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger$3(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger$3(options.weekStartsOn);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    if (!locale2.localize) {
      throw new RangeError("locale must contain localize property");
    }
    if (!locale2.formatLong) {
      throw new RangeError("locale must contain formatLong property");
    }
    var originalDate = toDate$1(dirtyDate);
    if (!isValid$1(originalDate)) {
      throw new RangeError("Invalid time value");
    }
    var timezoneOffset = getTimezoneOffsetInMilliseconds$1(originalDate);
    var utcDate = subMilliseconds$1(originalDate, timezoneOffset);
    var formatterOptions = {
      firstWeekContainsDate,
      weekStartsOn,
      locale: locale2,
      _originalDate: originalDate
    };
    var result = formatStr.match(longFormattingTokensRegExp$3).map(function(substring) {
      var firstCharacter = substring[0];
      if (firstCharacter === "p" || firstCharacter === "P") {
        var longFormatter = longFormatters$3[firstCharacter];
        return longFormatter(substring, locale2.formatLong, formatterOptions);
      }
      return substring;
    }).join("").match(formattingTokensRegExp$3).map(function(substring) {
      if (substring === "''") {
        return "'";
      }
      var firstCharacter = substring[0];
      if (firstCharacter === "'") {
        return cleanEscapedString$3(substring);
      }
      var formatter = formatters$4[firstCharacter];
      if (formatter) {
        if (!options.useAdditionalWeekYearTokens && isProtectedWeekYearToken$1(substring)) {
          throwProtectedError$1(substring);
        }
        if (!options.useAdditionalDayOfYearTokens && isProtectedDayOfYearToken$1(substring)) {
          throwProtectedError$1(substring);
        }
        return formatter(utcDate, substring, locale2.localize, formatterOptions);
      }
      if (firstCharacter.match(unescapedLatinCharacterRegExp$3)) {
        throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
      }
      return substring;
    }).join("");
    return result;
  }
  function cleanEscapedString$3(input) {
    return input.match(escapedStringRegExp$3)[1].replace(doubleQuoteRegExp$3, "'");
  }
  function assign$6(target, dirtyObject) {
    if (target == null) {
      throw new TypeError("assign requires that input parameter not be null or undefined");
    }
    dirtyObject = dirtyObject || {};
    for (var property in dirtyObject) {
      if (dirtyObject.hasOwnProperty(property)) {
        target[property] = dirtyObject[property];
      }
    }
    return target;
  }
  function formatISO(dirtyDate, dirtyOptions) {
    if (arguments.length < 1) {
      throw new TypeError("1 argument required, but only ".concat(arguments.length, " present"));
    }
    var originalDate = toDate$1(dirtyDate);
    if (!isValid$1(originalDate)) {
      throw new RangeError("Invalid time value");
    }
    var options = dirtyOptions || {};
    var format2 = options.format == null ? "extended" : String(options.format);
    var representation = options.representation == null ? "complete" : String(options.representation);
    if (format2 !== "extended" && format2 !== "basic") {
      throw new RangeError("format must be 'extended' or 'basic'");
    }
    if (representation !== "date" && representation !== "time" && representation !== "complete") {
      throw new RangeError("representation must be 'date', 'time', or 'complete'");
    }
    var result = "";
    var tzOffset = "";
    var dateDelimiter = format2 === "extended" ? "-" : "";
    var timeDelimiter = format2 === "extended" ? ":" : "";
    if (representation !== "time") {
      var day = addLeadingZeros$1(originalDate.getDate(), 2);
      var month = addLeadingZeros$1(originalDate.getMonth() + 1, 2);
      var year = addLeadingZeros$1(originalDate.getFullYear(), 4);
      result = "".concat(year).concat(dateDelimiter).concat(month).concat(dateDelimiter).concat(day);
    }
    if (representation !== "date") {
      var offset2 = originalDate.getTimezoneOffset();
      if (offset2 !== 0) {
        var absoluteOffset = Math.abs(offset2);
        var hourOffset = addLeadingZeros$1(absoluteOffset / 60, 2);
        var minuteOffset = addLeadingZeros$1(absoluteOffset % 60, 2);
        var sign2 = offset2 < 0 ? "+" : "-";
        tzOffset = "".concat(sign2).concat(hourOffset, ":").concat(minuteOffset);
      } else {
        tzOffset = "Z";
      }
      var hour = addLeadingZeros$1(originalDate.getHours(), 2);
      var minute = addLeadingZeros$1(originalDate.getMinutes(), 2);
      var second = addLeadingZeros$1(originalDate.getSeconds(), 2);
      var separator = result === "" ? "" : "T";
      var time = [hour, minute, second].join(timeDelimiter);
      result = "".concat(result).concat(separator).concat(time).concat(tzOffset);
    }
    return result;
  }
  function isAfter$1(dirtyDate, dirtyDateToCompare) {
    requiredArgs$1(2, arguments);
    var date = toDate$1(dirtyDate);
    var dateToCompare = toDate$1(dirtyDateToCompare);
    return date.getTime() > dateToCompare.getTime();
  }
  function isBefore$1(dirtyDate, dirtyDateToCompare) {
    requiredArgs$1(2, arguments);
    var date = toDate$1(dirtyDate);
    var dateToCompare = toDate$1(dirtyDateToCompare);
    return date.getTime() < dateToCompare.getTime();
  }
  function isEqual$3(dirtyLeftDate, dirtyRightDate) {
    requiredArgs$1(2, arguments);
    var dateLeft = toDate$1(dirtyLeftDate);
    var dateRight = toDate$1(dirtyRightDate);
    return dateLeft.getTime() === dateRight.getTime();
  }
  function isWithinInterval$1(dirtyDate, dirtyInterval) {
    requiredArgs$1(2, arguments);
    var interval2 = dirtyInterval || {};
    var time = toDate$1(dirtyDate).getTime();
    var startTime = toDate$1(interval2.start).getTime();
    var endTime = toDate$1(interval2.end).getTime();
    if (!(startTime <= endTime)) {
      throw new RangeError("Invalid interval");
    }
    return time >= startTime && time <= endTime;
  }
  function setUTCDay$1(dirtyDate, dirtyDay, dirtyOptions) {
    requiredArgs$1(2, arguments);
    var options = dirtyOptions || {};
    var locale2 = options.locale;
    var localeWeekStartsOn = locale2 && locale2.options && locale2.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger$3(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger$3(options.weekStartsOn);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    var date = toDate$1(dirtyDate);
    var day = toInteger$3(dirtyDay);
    var currentDay = date.getUTCDay();
    var remainder = day % 7;
    var dayIndex = (remainder + 7) % 7;
    var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
    date.setUTCDate(date.getUTCDate() + diff);
    return date;
  }
  function setUTCISODay$1(dirtyDate, dirtyDay) {
    requiredArgs$1(2, arguments);
    var day = toInteger$3(dirtyDay);
    if (day % 7 === 0) {
      day = day - 7;
    }
    var weekStartsOn = 1;
    var date = toDate$1(dirtyDate);
    var currentDay = date.getUTCDay();
    var remainder = day % 7;
    var dayIndex = (remainder + 7) % 7;
    var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
    date.setUTCDate(date.getUTCDate() + diff);
    return date;
  }
  function setUTCISOWeek$1(dirtyDate, dirtyISOWeek) {
    requiredArgs$1(2, arguments);
    var date = toDate$1(dirtyDate);
    var isoWeek = toInteger$3(dirtyISOWeek);
    var diff = getUTCISOWeek$1(date) - isoWeek;
    date.setUTCDate(date.getUTCDate() - diff * 7);
    return date;
  }
  function setUTCWeek$1(dirtyDate, dirtyWeek, options) {
    requiredArgs$1(2, arguments);
    var date = toDate$1(dirtyDate);
    var week = toInteger$3(dirtyWeek);
    var diff = getUTCWeek$1(date, options) - week;
    date.setUTCDate(date.getUTCDate() - diff * 7);
    return date;
  }
  var MILLISECONDS_IN_HOUR$2 = 36e5;
  var MILLISECONDS_IN_MINUTE$2 = 6e4;
  var MILLISECONDS_IN_SECOND = 1e3;
  var numericPatterns$1 = {
    month: /^(1[0-2]|0?\d)/,
    date: /^(3[0-1]|[0-2]?\d)/,
    dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
    week: /^(5[0-3]|[0-4]?\d)/,
    hour23h: /^(2[0-3]|[0-1]?\d)/,
    hour24h: /^(2[0-4]|[0-1]?\d)/,
    hour11h: /^(1[0-1]|0?\d)/,
    hour12h: /^(1[0-2]|0?\d)/,
    minute: /^[0-5]?\d/,
    second: /^[0-5]?\d/,
    singleDigit: /^\d/,
    twoDigits: /^\d{1,2}/,
    threeDigits: /^\d{1,3}/,
    fourDigits: /^\d{1,4}/,
    anyDigitsSigned: /^-?\d+/,
    singleDigitSigned: /^-?\d/,
    twoDigitsSigned: /^-?\d{1,2}/,
    threeDigitsSigned: /^-?\d{1,3}/,
    fourDigitsSigned: /^-?\d{1,4}/
  };
  var timezonePatterns$1 = {
    basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
    basic: /^([+-])(\d{2})(\d{2})|Z/,
    basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
    extended: /^([+-])(\d{2}):(\d{2})|Z/,
    extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
  };
  function parseNumericPattern$1(pattern, string2, valueCallback) {
    var matchResult = string2.match(pattern);
    if (!matchResult) {
      return null;
    }
    var value = parseInt(matchResult[0], 10);
    return {
      value: valueCallback ? valueCallback(value) : value,
      rest: string2.slice(matchResult[0].length)
    };
  }
  function parseTimezonePattern$1(pattern, string2) {
    var matchResult = string2.match(pattern);
    if (!matchResult) {
      return null;
    }
    if (matchResult[0] === "Z") {
      return {
        value: 0,
        rest: string2.slice(1)
      };
    }
    var sign2 = matchResult[1] === "+" ? 1 : -1;
    var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
    var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
    var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
    return {
      value: sign2 * (hours * MILLISECONDS_IN_HOUR$2 + minutes * MILLISECONDS_IN_MINUTE$2 + seconds * MILLISECONDS_IN_SECOND),
      rest: string2.slice(matchResult[0].length)
    };
  }
  function parseAnyDigitsSigned$1(string2, valueCallback) {
    return parseNumericPattern$1(numericPatterns$1.anyDigitsSigned, string2, valueCallback);
  }
  function parseNDigits$1(n2, string2, valueCallback) {
    switch (n2) {
      case 1:
        return parseNumericPattern$1(numericPatterns$1.singleDigit, string2, valueCallback);
      case 2:
        return parseNumericPattern$1(numericPatterns$1.twoDigits, string2, valueCallback);
      case 3:
        return parseNumericPattern$1(numericPatterns$1.threeDigits, string2, valueCallback);
      case 4:
        return parseNumericPattern$1(numericPatterns$1.fourDigits, string2, valueCallback);
      default:
        return parseNumericPattern$1(new RegExp("^\\d{1," + n2 + "}"), string2, valueCallback);
    }
  }
  function parseNDigitsSigned$1(n2, string2, valueCallback) {
    switch (n2) {
      case 1:
        return parseNumericPattern$1(numericPatterns$1.singleDigitSigned, string2, valueCallback);
      case 2:
        return parseNumericPattern$1(numericPatterns$1.twoDigitsSigned, string2, valueCallback);
      case 3:
        return parseNumericPattern$1(numericPatterns$1.threeDigitsSigned, string2, valueCallback);
      case 4:
        return parseNumericPattern$1(numericPatterns$1.fourDigitsSigned, string2, valueCallback);
      default:
        return parseNumericPattern$1(new RegExp("^-?\\d{1," + n2 + "}"), string2, valueCallback);
    }
  }
  function dayPeriodEnumToHours$1(enumValue) {
    switch (enumValue) {
      case "morning":
        return 4;
      case "evening":
        return 17;
      case "pm":
      case "noon":
      case "afternoon":
        return 12;
      case "am":
      case "midnight":
      case "night":
      default:
        return 0;
    }
  }
  function normalizeTwoDigitYear$1(twoDigitYear, currentYear) {
    var isCommonEra = currentYear > 0;
    var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
    var result;
    if (absCurrentYear <= 50) {
      result = twoDigitYear || 100;
    } else {
      var rangeEnd2 = absCurrentYear + 50;
      var rangeEndCentury = Math.floor(rangeEnd2 / 100) * 100;
      var isPreviousCentury = twoDigitYear >= rangeEnd2 % 100;
      result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
    }
    return isCommonEra ? result : 1 - result;
  }
  var DAYS_IN_MONTH$1 = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  var DAYS_IN_MONTH_LEAP_YEAR$1 = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  function isLeapYearIndex$3(year) {
    return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
  }
  var parsers$1 = {
    G: {
      priority: 140,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "G":
          case "GG":
          case "GGG":
            return match2.era(string2, {
              width: "abbreviated"
            }) || match2.era(string2, {
              width: "narrow"
            });
          case "GGGGG":
            return match2.era(string2, {
              width: "narrow"
            });
          case "GGGG":
          default:
            return match2.era(string2, {
              width: "wide"
            }) || match2.era(string2, {
              width: "abbreviated"
            }) || match2.era(string2, {
              width: "narrow"
            });
        }
      },
      set: function(date, flags, value, _options) {
        flags.era = value;
        date.setUTCFullYear(value, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["R", "u", "t", "T"]
    },
    y: {
      priority: 130,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(year) {
          return {
            year,
            isTwoDigitYear: token === "yy"
          };
        };
        switch (token) {
          case "y":
            return parseNDigits$1(4, string2, valueCallback);
          case "yo":
            return match2.ordinalNumber(string2, {
              unit: "year",
              valueCallback
            });
          default:
            return parseNDigits$1(token.length, string2, valueCallback);
        }
      },
      validate: function(_date, value, _options) {
        return value.isTwoDigitYear || value.year > 0;
      },
      set: function(date, flags, value, _options) {
        var currentYear = date.getUTCFullYear();
        if (value.isTwoDigitYear) {
          var normalizedTwoDigitYear = normalizeTwoDigitYear$1(value.year, currentYear);
          date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
          date.setUTCHours(0, 0, 0, 0);
          return date;
        }
        var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
        date.setUTCFullYear(year, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "u", "w", "I", "i", "e", "c", "t", "T"]
    },
    Y: {
      priority: 130,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(year) {
          return {
            year,
            isTwoDigitYear: token === "YY"
          };
        };
        switch (token) {
          case "Y":
            return parseNDigits$1(4, string2, valueCallback);
          case "Yo":
            return match2.ordinalNumber(string2, {
              unit: "year",
              valueCallback
            });
          default:
            return parseNDigits$1(token.length, string2, valueCallback);
        }
      },
      validate: function(_date, value, _options) {
        return value.isTwoDigitYear || value.year > 0;
      },
      set: function(date, flags, value, options) {
        var currentYear = getUTCWeekYear$1(date, options);
        if (value.isTwoDigitYear) {
          var normalizedTwoDigitYear = normalizeTwoDigitYear$1(value.year, currentYear);
          date.setUTCFullYear(normalizedTwoDigitYear, 0, options.firstWeekContainsDate);
          date.setUTCHours(0, 0, 0, 0);
          return startOfUTCWeek$1(date, options);
        }
        var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
        date.setUTCFullYear(year, 0, options.firstWeekContainsDate);
        date.setUTCHours(0, 0, 0, 0);
        return startOfUTCWeek$1(date, options);
      },
      incompatibleTokens: ["y", "R", "u", "Q", "q", "M", "L", "I", "d", "D", "i", "t", "T"]
    },
    R: {
      priority: 130,
      parse: function(string2, token, _match, _options) {
        if (token === "R") {
          return parseNDigitsSigned$1(4, string2);
        }
        return parseNDigitsSigned$1(token.length, string2);
      },
      set: function(_date, _flags, value, _options) {
        var firstWeekOfYear = new Date(0);
        firstWeekOfYear.setUTCFullYear(value, 0, 4);
        firstWeekOfYear.setUTCHours(0, 0, 0, 0);
        return startOfUTCISOWeek$1(firstWeekOfYear);
      },
      incompatibleTokens: ["G", "y", "Y", "u", "Q", "q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]
    },
    u: {
      priority: 130,
      parse: function(string2, token, _match, _options) {
        if (token === "u") {
          return parseNDigitsSigned$1(4, string2);
        }
        return parseNDigitsSigned$1(token.length, string2);
      },
      set: function(date, _flags, value, _options) {
        date.setUTCFullYear(value, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["G", "y", "Y", "R", "w", "I", "i", "e", "c", "t", "T"]
    },
    Q: {
      priority: 120,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "Q":
          case "QQ":
            return parseNDigits$1(token.length, string2);
          case "Qo":
            return match2.ordinalNumber(string2, {
              unit: "quarter"
            });
          case "QQQ":
            return match2.quarter(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.quarter(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "QQQQQ":
            return match2.quarter(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "QQQQ":
          default:
            return match2.quarter(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.quarter(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.quarter(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 4;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth((value - 1) * 3, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]
    },
    q: {
      priority: 120,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "q":
          case "qq":
            return parseNDigits$1(token.length, string2);
          case "qo":
            return match2.ordinalNumber(string2, {
              unit: "quarter"
            });
          case "qqq":
            return match2.quarter(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.quarter(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "qqqqq":
            return match2.quarter(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "qqqq":
          default:
            return match2.quarter(string2, {
              width: "wide",
              context: "standalone"
            }) || match2.quarter(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.quarter(string2, {
              width: "narrow",
              context: "standalone"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 4;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth((value - 1) * 3, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "Q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]
    },
    M: {
      priority: 110,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(value) {
          return value - 1;
        };
        switch (token) {
          case "M":
            return parseNumericPattern$1(numericPatterns$1.month, string2, valueCallback);
          case "MM":
            return parseNDigits$1(2, string2, valueCallback);
          case "Mo":
            return match2.ordinalNumber(string2, {
              unit: "month",
              valueCallback
            });
          case "MMM":
            return match2.month(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.month(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "MMMMM":
            return match2.month(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "MMMM":
          default:
            return match2.month(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.month(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.month(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 11;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth(value, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "Q", "L", "w", "I", "D", "i", "e", "c", "t", "T"]
    },
    L: {
      priority: 110,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(value) {
          return value - 1;
        };
        switch (token) {
          case "L":
            return parseNumericPattern$1(numericPatterns$1.month, string2, valueCallback);
          case "LL":
            return parseNDigits$1(2, string2, valueCallback);
          case "Lo":
            return match2.ordinalNumber(string2, {
              unit: "month",
              valueCallback
            });
          case "LLL":
            return match2.month(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.month(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "LLLLL":
            return match2.month(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "LLLL":
          default:
            return match2.month(string2, {
              width: "wide",
              context: "standalone"
            }) || match2.month(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.month(string2, {
              width: "narrow",
              context: "standalone"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 11;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth(value, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "Q", "M", "w", "I", "D", "i", "e", "c", "t", "T"]
    },
    w: {
      priority: 100,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "w":
            return parseNumericPattern$1(numericPatterns$1.week, string2);
          case "wo":
            return match2.ordinalNumber(string2, {
              unit: "week"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 53;
      },
      set: function(date, _flags, value, options) {
        return startOfUTCWeek$1(setUTCWeek$1(date, value, options), options);
      },
      incompatibleTokens: ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "i", "t", "T"]
    },
    I: {
      priority: 100,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "I":
            return parseNumericPattern$1(numericPatterns$1.week, string2);
          case "Io":
            return match2.ordinalNumber(string2, {
              unit: "week"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 53;
      },
      set: function(date, _flags, value, options) {
        return startOfUTCISOWeek$1(setUTCISOWeek$1(date, value, options), options);
      },
      incompatibleTokens: ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]
    },
    d: {
      priority: 90,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "d":
            return parseNumericPattern$1(numericPatterns$1.date, string2);
          case "do":
            return match2.ordinalNumber(string2, {
              unit: "date"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(date, value, _options) {
        var year = date.getUTCFullYear();
        var isLeapYear = isLeapYearIndex$3(year);
        var month = date.getUTCMonth();
        if (isLeapYear) {
          return value >= 1 && value <= DAYS_IN_MONTH_LEAP_YEAR$1[month];
        } else {
          return value >= 1 && value <= DAYS_IN_MONTH$1[month];
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCDate(value);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "Q", "w", "I", "D", "i", "e", "c", "t", "T"]
    },
    D: {
      priority: 90,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "D":
          case "DD":
            return parseNumericPattern$1(numericPatterns$1.dayOfYear, string2);
          case "Do":
            return match2.ordinalNumber(string2, {
              unit: "date"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(date, value, _options) {
        var year = date.getUTCFullYear();
        var isLeapYear = isLeapYearIndex$3(year);
        if (isLeapYear) {
          return value >= 1 && value <= 366;
        } else {
          return value >= 1 && value <= 365;
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMonth(0, value);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["Y", "R", "q", "Q", "M", "L", "w", "I", "d", "E", "i", "e", "c", "t", "T"]
    },
    E: {
      priority: 90,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "E":
          case "EE":
          case "EEE":
            return match2.day(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "EEEEE":
            return match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "EEEEEE":
            return match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "EEEE":
          default:
            return match2.day(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.day(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 6;
      },
      set: function(date, _flags, value, options) {
        date = setUTCDay$1(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["D", "i", "e", "c", "t", "T"]
    },
    e: {
      priority: 90,
      parse: function(string2, token, match2, options) {
        var valueCallback = function(value) {
          var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
          return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
        };
        switch (token) {
          case "e":
          case "ee":
            return parseNDigits$1(token.length, string2, valueCallback);
          case "eo":
            return match2.ordinalNumber(string2, {
              unit: "day",
              valueCallback
            });
          case "eee":
            return match2.day(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "eeeee":
            return match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "eeeeee":
            return match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "eeee":
          default:
            return match2.day(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.day(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.day(string2, {
              width: "short",
              context: "formatting"
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 6;
      },
      set: function(date, _flags, value, options) {
        date = setUTCDay$1(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "c", "t", "T"]
    },
    c: {
      priority: 90,
      parse: function(string2, token, match2, options) {
        var valueCallback = function(value) {
          var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
          return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
        };
        switch (token) {
          case "c":
          case "cc":
            return parseNDigits$1(token.length, string2, valueCallback);
          case "co":
            return match2.ordinalNumber(string2, {
              unit: "day",
              valueCallback
            });
          case "ccc":
            return match2.day(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.day(string2, {
              width: "short",
              context: "standalone"
            }) || match2.day(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "ccccc":
            return match2.day(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "cccccc":
            return match2.day(string2, {
              width: "short",
              context: "standalone"
            }) || match2.day(string2, {
              width: "narrow",
              context: "standalone"
            });
          case "cccc":
          default:
            return match2.day(string2, {
              width: "wide",
              context: "standalone"
            }) || match2.day(string2, {
              width: "abbreviated",
              context: "standalone"
            }) || match2.day(string2, {
              width: "short",
              context: "standalone"
            }) || match2.day(string2, {
              width: "narrow",
              context: "standalone"
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 6;
      },
      set: function(date, _flags, value, options) {
        date = setUTCDay$1(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "e", "t", "T"]
    },
    i: {
      priority: 90,
      parse: function(string2, token, match2, _options) {
        var valueCallback = function(value) {
          if (value === 0) {
            return 7;
          }
          return value;
        };
        switch (token) {
          case "i":
          case "ii":
            return parseNDigits$1(token.length, string2);
          case "io":
            return match2.ordinalNumber(string2, {
              unit: "day"
            });
          case "iii":
            return match2.day(string2, {
              width: "abbreviated",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "short",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting",
              valueCallback
            });
          case "iiiii":
            return match2.day(string2, {
              width: "narrow",
              context: "formatting",
              valueCallback
            });
          case "iiiiii":
            return match2.day(string2, {
              width: "short",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting",
              valueCallback
            });
          case "iiii":
          default:
            return match2.day(string2, {
              width: "wide",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "abbreviated",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "short",
              context: "formatting",
              valueCallback
            }) || match2.day(string2, {
              width: "narrow",
              context: "formatting",
              valueCallback
            });
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 7;
      },
      set: function(date, _flags, value, options) {
        date = setUTCISODay$1(date, value, options);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "E", "e", "c", "t", "T"]
    },
    a: {
      priority: 80,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "a":
          case "aa":
          case "aaa":
            return match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "aaaaa":
            return match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "aaaa":
          default:
            return match2.dayPeriod(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCHours(dayPeriodEnumToHours$1(value), 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["b", "B", "H", "K", "k", "t", "T"]
    },
    b: {
      priority: 80,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "b":
          case "bb":
          case "bbb":
            return match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "bbbbb":
            return match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "bbbb":
          default:
            return match2.dayPeriod(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCHours(dayPeriodEnumToHours$1(value), 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["a", "B", "H", "K", "k", "t", "T"]
    },
    B: {
      priority: 80,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "B":
          case "BB":
          case "BBB":
            return match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "BBBBB":
            return match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
          case "BBBB":
          default:
            return match2.dayPeriod(string2, {
              width: "wide",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "abbreviated",
              context: "formatting"
            }) || match2.dayPeriod(string2, {
              width: "narrow",
              context: "formatting"
            });
        }
      },
      set: function(date, _flags, value, _options) {
        date.setUTCHours(dayPeriodEnumToHours$1(value), 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["a", "b", "t", "T"]
    },
    h: {
      priority: 70,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "h":
            return parseNumericPattern$1(numericPatterns$1.hour12h, string2);
          case "ho":
            return match2.ordinalNumber(string2, {
              unit: "hour"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 12;
      },
      set: function(date, _flags, value, _options) {
        var isPM = date.getUTCHours() >= 12;
        if (isPM && value < 12) {
          date.setUTCHours(value + 12, 0, 0, 0);
        } else if (!isPM && value === 12) {
          date.setUTCHours(0, 0, 0, 0);
        } else {
          date.setUTCHours(value, 0, 0, 0);
        }
        return date;
      },
      incompatibleTokens: ["H", "K", "k", "t", "T"]
    },
    H: {
      priority: 70,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "H":
            return parseNumericPattern$1(numericPatterns$1.hour23h, string2);
          case "Ho":
            return match2.ordinalNumber(string2, {
              unit: "hour"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 23;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCHours(value, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["a", "b", "h", "K", "k", "t", "T"]
    },
    K: {
      priority: 70,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "K":
            return parseNumericPattern$1(numericPatterns$1.hour11h, string2);
          case "Ko":
            return match2.ordinalNumber(string2, {
              unit: "hour"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 11;
      },
      set: function(date, _flags, value, _options) {
        var isPM = date.getUTCHours() >= 12;
        if (isPM && value < 12) {
          date.setUTCHours(value + 12, 0, 0, 0);
        } else {
          date.setUTCHours(value, 0, 0, 0);
        }
        return date;
      },
      incompatibleTokens: ["a", "b", "h", "H", "k", "t", "T"]
    },
    k: {
      priority: 70,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "k":
            return parseNumericPattern$1(numericPatterns$1.hour24h, string2);
          case "ko":
            return match2.ordinalNumber(string2, {
              unit: "hour"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 1 && value <= 24;
      },
      set: function(date, _flags, value, _options) {
        var hours = value <= 24 ? value % 24 : value;
        date.setUTCHours(hours, 0, 0, 0);
        return date;
      },
      incompatibleTokens: ["a", "b", "h", "H", "K", "t", "T"]
    },
    m: {
      priority: 60,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "m":
            return parseNumericPattern$1(numericPatterns$1.minute, string2);
          case "mo":
            return match2.ordinalNumber(string2, {
              unit: "minute"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 59;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMinutes(value, 0, 0);
        return date;
      },
      incompatibleTokens: ["t", "T"]
    },
    s: {
      priority: 50,
      parse: function(string2, token, match2, _options) {
        switch (token) {
          case "s":
            return parseNumericPattern$1(numericPatterns$1.second, string2);
          case "so":
            return match2.ordinalNumber(string2, {
              unit: "second"
            });
          default:
            return parseNDigits$1(token.length, string2);
        }
      },
      validate: function(_date, value, _options) {
        return value >= 0 && value <= 59;
      },
      set: function(date, _flags, value, _options) {
        date.setUTCSeconds(value, 0);
        return date;
      },
      incompatibleTokens: ["t", "T"]
    },
    S: {
      priority: 30,
      parse: function(string2, token, _match, _options) {
        var valueCallback = function(value) {
          return Math.floor(value * Math.pow(10, -token.length + 3));
        };
        return parseNDigits$1(token.length, string2, valueCallback);
      },
      set: function(date, _flags, value, _options) {
        date.setUTCMilliseconds(value);
        return date;
      },
      incompatibleTokens: ["t", "T"]
    },
    X: {
      priority: 10,
      parse: function(string2, token, _match, _options) {
        switch (token) {
          case "X":
            return parseTimezonePattern$1(timezonePatterns$1.basicOptionalMinutes, string2);
          case "XX":
            return parseTimezonePattern$1(timezonePatterns$1.basic, string2);
          case "XXXX":
            return parseTimezonePattern$1(timezonePatterns$1.basicOptionalSeconds, string2);
          case "XXXXX":
            return parseTimezonePattern$1(timezonePatterns$1.extendedOptionalSeconds, string2);
          case "XXX":
          default:
            return parseTimezonePattern$1(timezonePatterns$1.extended, string2);
        }
      },
      set: function(date, flags, value, _options) {
        if (flags.timestampIsSet) {
          return date;
        }
        return new Date(date.getTime() - value);
      },
      incompatibleTokens: ["t", "T", "x"]
    },
    x: {
      priority: 10,
      parse: function(string2, token, _match, _options) {
        switch (token) {
          case "x":
            return parseTimezonePattern$1(timezonePatterns$1.basicOptionalMinutes, string2);
          case "xx":
            return parseTimezonePattern$1(timezonePatterns$1.basic, string2);
          case "xxxx":
            return parseTimezonePattern$1(timezonePatterns$1.basicOptionalSeconds, string2);
          case "xxxxx":
            return parseTimezonePattern$1(timezonePatterns$1.extendedOptionalSeconds, string2);
          case "xxx":
          default:
            return parseTimezonePattern$1(timezonePatterns$1.extended, string2);
        }
      },
      set: function(date, flags, value, _options) {
        if (flags.timestampIsSet) {
          return date;
        }
        return new Date(date.getTime() - value);
      },
      incompatibleTokens: ["t", "T", "X"]
    },
    t: {
      priority: 40,
      parse: function(string2, _token, _match, _options) {
        return parseAnyDigitsSigned$1(string2);
      },
      set: function(_date, _flags, value, _options) {
        return [new Date(value * 1e3), {
          timestampIsSet: true
        }];
      },
      incompatibleTokens: "*"
    },
    T: {
      priority: 20,
      parse: function(string2, _token, _match, _options) {
        return parseAnyDigitsSigned$1(string2);
      },
      set: function(_date, _flags, value, _options) {
        return [new Date(value), {
          timestampIsSet: true
        }];
      },
      incompatibleTokens: "*"
    }
  };
  const parsers$2 = parsers$1;
  var TIMEZONE_UNIT_PRIORITY$1 = 10;
  var formattingTokensRegExp$2 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
  var longFormattingTokensRegExp$2 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
  var escapedStringRegExp$2 = /^'([^]*?)'?$/;
  var doubleQuoteRegExp$2 = /''/g;
  var notWhitespaceRegExp$1 = /\S/;
  var unescapedLatinCharacterRegExp$2 = /[a-zA-Z]/;
  function parse$9(dirtyDateString, dirtyFormatString, dirtyBackupDate, dirtyOptions) {
    requiredArgs$1(3, arguments);
    var dateString = String(dirtyDateString);
    var formatString = String(dirtyFormatString);
    var options = dirtyOptions || {};
    var locale2 = options.locale || defaultLocale$1;
    if (!locale2.match) {
      throw new RangeError("locale must contain match property");
    }
    var localeFirstWeekContainsDate = locale2.options && locale2.options.firstWeekContainsDate;
    var defaultFirstWeekContainsDate = localeFirstWeekContainsDate == null ? 1 : toInteger$3(localeFirstWeekContainsDate);
    var firstWeekContainsDate = options.firstWeekContainsDate == null ? defaultFirstWeekContainsDate : toInteger$3(options.firstWeekContainsDate);
    if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
      throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
    }
    var localeWeekStartsOn = locale2.options && locale2.options.weekStartsOn;
    var defaultWeekStartsOn = localeWeekStartsOn == null ? 0 : toInteger$3(localeWeekStartsOn);
    var weekStartsOn = options.weekStartsOn == null ? defaultWeekStartsOn : toInteger$3(options.weekStartsOn);
    if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
      throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
    }
    if (formatString === "") {
      if (dateString === "") {
        return toDate$1(dirtyBackupDate);
      } else {
        return new Date(NaN);
      }
    }
    var subFnOptions = {
      firstWeekContainsDate,
      weekStartsOn,
      locale: locale2
    };
    var setters = [{
      priority: TIMEZONE_UNIT_PRIORITY$1,
      set: dateToSystemTimezone,
      index: 0
    }];
    var i2;
    var tokens2 = formatString.match(longFormattingTokensRegExp$2).map(function(substring) {
      var firstCharacter2 = substring[0];
      if (firstCharacter2 === "p" || firstCharacter2 === "P") {
        var longFormatter = longFormatters$3[firstCharacter2];
        return longFormatter(substring, locale2.formatLong, subFnOptions);
      }
      return substring;
    }).join("").match(formattingTokensRegExp$2);
    var usedTokens = [];
    for (i2 = 0; i2 < tokens2.length; i2++) {
      var token = tokens2[i2];
      if (!options.useAdditionalWeekYearTokens && isProtectedWeekYearToken$1(token)) {
        throwProtectedError$1(token);
      }
      if (!options.useAdditionalDayOfYearTokens && isProtectedDayOfYearToken$1(token)) {
        throwProtectedError$1(token);
      }
      var firstCharacter = token[0];
      var parser2 = parsers$2[firstCharacter];
      if (parser2) {
        var incompatibleTokens = parser2.incompatibleTokens;
        if (Array.isArray(incompatibleTokens)) {
          var incompatibleToken = void 0;
          for (var _i2 = 0; _i2 < usedTokens.length; _i2++) {
            var usedToken = usedTokens[_i2].token;
            if (incompatibleTokens.indexOf(usedToken) !== -1 || usedToken === firstCharacter) {
              incompatibleToken = usedTokens[_i2];
              break;
            }
          }
          if (incompatibleToken) {
            throw new RangeError("The format string mustn't contain `".concat(incompatibleToken.fullToken, "` and `").concat(token, "` at the same time"));
          }
        } else if (parser2.incompatibleTokens === "*" && usedTokens.length) {
          throw new RangeError("The format string mustn't contain `".concat(token, "` and any other token at the same time"));
        }
        usedTokens.push({
          token: firstCharacter,
          fullToken: token
        });
        var parseResult = parser2.parse(dateString, token, locale2.match, subFnOptions);
        if (!parseResult) {
          return new Date(NaN);
        }
        setters.push({
          priority: parser2.priority,
          set: parser2.set,
          validate: parser2.validate,
          value: parseResult.value,
          index: setters.length
        });
        dateString = parseResult.rest;
      } else {
        if (firstCharacter.match(unescapedLatinCharacterRegExp$2)) {
          throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
        }
        if (token === "''") {
          token = "'";
        } else if (firstCharacter === "'") {
          token = cleanEscapedString$2(token);
        }
        if (dateString.indexOf(token) === 0) {
          dateString = dateString.slice(token.length);
        } else {
          return new Date(NaN);
        }
      }
    }
    if (dateString.length > 0 && notWhitespaceRegExp$1.test(dateString)) {
      return new Date(NaN);
    }
    var uniquePrioritySetters = setters.map(function(setter2) {
      return setter2.priority;
    }).sort(function(a2, b2) {
      return b2 - a2;
    }).filter(function(priority, index2, array2) {
      return array2.indexOf(priority) === index2;
    }).map(function(priority) {
      return setters.filter(function(setter2) {
        return setter2.priority === priority;
      }).reverse();
    }).map(function(setterArray) {
      return setterArray[0];
    });
    var date = toDate$1(dirtyBackupDate);
    if (isNaN(date)) {
      return new Date(NaN);
    }
    var utcDate = subMilliseconds$1(date, getTimezoneOffsetInMilliseconds$1(date));
    var flags = {};
    for (i2 = 0; i2 < uniquePrioritySetters.length; i2++) {
      var setter = uniquePrioritySetters[i2];
      if (setter.validate && !setter.validate(utcDate, setter.value, subFnOptions)) {
        return new Date(NaN);
      }
      var result = setter.set(utcDate, flags, setter.value, subFnOptions);
      if (result[0]) {
        utcDate = result[0];
        assign$6(flags, result[1]);
      } else {
        utcDate = result;
      }
    }
    return utcDate;
  }
  function dateToSystemTimezone(date, flags) {
    if (flags.timestampIsSet) {
      return date;
    }
    var convertedDate = new Date(0);
    convertedDate.setFullYear(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
    convertedDate.setHours(date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
    return convertedDate;
  }
  function cleanEscapedString$2(input) {
    return input.match(escapedStringRegExp$2)[1].replace(doubleQuoteRegExp$2, "'");
  }
  var MILLISECONDS_IN_HOUR$1 = 36e5;
  var MILLISECONDS_IN_MINUTE$1 = 6e4;
  var DEFAULT_ADDITIONAL_DIGITS = 2;
  var patterns$1 = {
    dateTimeDelimiter: /[T ]/,
    timeZoneDelimiter: /[Z ]/i,
    timezone: /([Z+-].*)$/
  };
  var dateRegex$1 = /^-?(?:(\d{3})|(\d{2})(?:-?(\d{2}))?|W(\d{2})(?:-?(\d{1}))?|)$/;
  var timeRegex$1 = /^(\d{2}(?:[.,]\d*)?)(?::?(\d{2}(?:[.,]\d*)?))?(?::?(\d{2}(?:[.,]\d*)?))?$/;
  var timezoneRegex$1 = /^([+-])(\d{2})(?::?(\d{2}))?$/;
  function parseISO$1(argument, dirtyOptions) {
    requiredArgs$1(1, arguments);
    var options = dirtyOptions || {};
    var additionalDigits = options.additionalDigits == null ? DEFAULT_ADDITIONAL_DIGITS : toInteger$3(options.additionalDigits);
    if (additionalDigits !== 2 && additionalDigits !== 1 && additionalDigits !== 0) {
      throw new RangeError("additionalDigits must be 0, 1 or 2");
    }
    if (!(typeof argument === "string" || Object.prototype.toString.call(argument) === "[object String]")) {
      return new Date(NaN);
    }
    var dateStrings = splitDateString$1(argument);
    var date;
    if (dateStrings.date) {
      var parseYearResult = parseYear$1(dateStrings.date, additionalDigits);
      date = parseDate$1(parseYearResult.restDateString, parseYearResult.year);
    }
    if (isNaN(date) || !date) {
      return new Date(NaN);
    }
    var timestamp = date.getTime();
    var time = 0;
    var offset2;
    if (dateStrings.time) {
      time = parseTime$1(dateStrings.time);
      if (isNaN(time) || time === null) {
        return new Date(NaN);
      }
    }
    if (dateStrings.timezone) {
      offset2 = parseTimezone$1(dateStrings.timezone);
      if (isNaN(offset2)) {
        return new Date(NaN);
      }
    } else {
      var fullTime = timestamp + time;
      var fullTimeDate = new Date(fullTime);
      offset2 = getTimezoneOffsetInMilliseconds$1(fullTimeDate);
      var fullTimeDateDiffDay = new Date(fullTime);
      if (offset2 > 0) {
        fullTimeDateDiffDay.setDate(fullTimeDate.getDate() + 1);
      } else {
        fullTimeDateDiffDay.setDate(fullTimeDate.getDate() - 1);
      }
      var offsetDiff = getTimezoneOffsetInMilliseconds$1(fullTimeDateDiffDay) - offset2;
      if (offsetDiff > 0) {
        offset2 += offsetDiff;
      }
    }
    return new Date(timestamp + time + offset2);
  }
  function splitDateString$1(dateString) {
    var dateStrings = {};
    var array2 = dateString.split(patterns$1.dateTimeDelimiter);
    var timeString;
    if (/:/.test(array2[0])) {
      dateStrings.date = null;
      timeString = array2[0];
    } else {
      dateStrings.date = array2[0];
      timeString = array2[1];
      if (patterns$1.timeZoneDelimiter.test(dateStrings.date)) {
        dateStrings.date = dateString.split(patterns$1.timeZoneDelimiter)[0];
        timeString = dateString.substr(dateStrings.date.length, dateString.length);
      }
    }
    if (timeString) {
      var token = patterns$1.timezone.exec(timeString);
      if (token) {
        dateStrings.time = timeString.replace(token[1], "");
        dateStrings.timezone = token[1];
      } else {
        dateStrings.time = timeString;
      }
    }
    return dateStrings;
  }
  function parseYear$1(dateString, additionalDigits) {
    var regex = new RegExp("^(?:(\\d{4}|[+-]\\d{" + (4 + additionalDigits) + "})|(\\d{2}|[+-]\\d{" + (2 + additionalDigits) + "})$)");
    var captures = dateString.match(regex);
    if (!captures)
      return {
        year: null
      };
    var year = captures[1] && parseInt(captures[1]);
    var century = captures[2] && parseInt(captures[2]);
    return {
      year: century == null ? year : century * 100,
      restDateString: dateString.slice((captures[1] || captures[2]).length)
    };
  }
  function parseDate$1(dateString, year) {
    if (year === null)
      return null;
    var captures = dateString.match(dateRegex$1);
    if (!captures)
      return null;
    var isWeekDate = !!captures[4];
    var dayOfYear = parseDateUnit$1(captures[1]);
    var month = parseDateUnit$1(captures[2]) - 1;
    var day = parseDateUnit$1(captures[3]);
    var week = parseDateUnit$1(captures[4]);
    var dayOfWeek = parseDateUnit$1(captures[5]) - 1;
    if (isWeekDate) {
      if (!validateWeekDate$1(year, week, dayOfWeek)) {
        return new Date(NaN);
      }
      return dayOfISOWeekYear$1(year, week, dayOfWeek);
    } else {
      var date = new Date(0);
      if (!validateDate$1(year, month, day) || !validateDayOfYearDate$1(year, dayOfYear)) {
        return new Date(NaN);
      }
      date.setUTCFullYear(year, month, Math.max(dayOfYear, day));
      return date;
    }
  }
  function parseDateUnit$1(value) {
    return value ? parseInt(value) : 1;
  }
  function parseTime$1(timeString) {
    var captures = timeString.match(timeRegex$1);
    if (!captures)
      return null;
    var hours = parseTimeUnit$1(captures[1]);
    var minutes = parseTimeUnit$1(captures[2]);
    var seconds = parseTimeUnit$1(captures[3]);
    if (!validateTime$1(hours, minutes, seconds)) {
      return NaN;
    }
    return hours * MILLISECONDS_IN_HOUR$1 + minutes * MILLISECONDS_IN_MINUTE$1 + seconds * 1e3;
  }
  function parseTimeUnit$1(value) {
    return value && parseFloat(value.replace(",", ".")) || 0;
  }
  function parseTimezone$1(timezoneString) {
    if (timezoneString === "Z")
      return 0;
    var captures = timezoneString.match(timezoneRegex$1);
    if (!captures)
      return 0;
    var sign2 = captures[1] === "+" ? -1 : 1;
    var hours = parseInt(captures[2]);
    var minutes = captures[3] && parseInt(captures[3]) || 0;
    if (!validateTimezone$1(hours, minutes)) {
      return NaN;
    }
    return sign2 * (hours * MILLISECONDS_IN_HOUR$1 + minutes * MILLISECONDS_IN_MINUTE$1);
  }
  function dayOfISOWeekYear$1(isoWeekYear, week, day) {
    var date = new Date(0);
    date.setUTCFullYear(isoWeekYear, 0, 4);
    var fourthOfJanuaryDay = date.getUTCDay() || 7;
    var diff = (week - 1) * 7 + day + 1 - fourthOfJanuaryDay;
    date.setUTCDate(date.getUTCDate() + diff);
    return date;
  }
  var daysInMonths$1 = [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  function isLeapYearIndex$2(year) {
    return year % 400 === 0 || year % 4 === 0 && year % 100;
  }
  function validateDate$1(year, month, date) {
    return month >= 0 && month <= 11 && date >= 1 && date <= (daysInMonths$1[month] || (isLeapYearIndex$2(year) ? 29 : 28));
  }
  function validateDayOfYearDate$1(year, dayOfYear) {
    return dayOfYear >= 1 && dayOfYear <= (isLeapYearIndex$2(year) ? 366 : 365);
  }
  function validateWeekDate$1(_year, week, day) {
    return week >= 1 && week <= 53 && day >= 0 && day <= 6;
  }
  function validateTime$1(hours, minutes, seconds) {
    if (hours === 24) {
      return minutes === 0 && seconds === 0;
    }
    return seconds >= 0 && seconds < 60 && minutes >= 0 && minutes < 60 && hours >= 0 && hours < 25;
  }
  function validateTimezone$1(_hours, minutes) {
    return minutes >= 0 && minutes <= 59;
  }
  function ok$2() {
  }
  function unreachable() {
  }
  function parse$8(value) {
    const tokens2 = [];
    const input = String(value || "");
    let index2 = input.indexOf(",");
    let start2 = 0;
    let end2 = false;
    while (!end2) {
      if (index2 === -1) {
        index2 = input.length;
        end2 = true;
      }
      const token = input.slice(start2, index2).trim();
      if (token || !end2) {
        tokens2.push(token);
      }
      start2 = index2 + 1;
      index2 = input.indexOf(",", start2);
    }
    return tokens2;
  }
  function stringify$3(values, options) {
    const settings2 = options || {};
    const input = values[values.length - 1] === "" ? [...values, ""] : values;
    return input.join(
      (settings2.padRight ? " " : "") + "," + (settings2.padLeft === false ? "" : " ")
    ).trim();
  }
  const nameRe = /^[$_\p{ID_Start}][$_\u{200C}\u{200D}\p{ID_Continue}]*$/u;
  const nameReJsx = /^[$_\p{ID_Start}][-$_\u{200C}\u{200D}\p{ID_Continue}]*$/u;
  const emptyOptions$3 = {};
  function name$2(name2, options) {
    const settings2 = options || emptyOptions$3;
    const re2 = settings2.jsx ? nameReJsx : nameRe;
    return re2.test(name2);
  }
  const re$1 = /[ \t\n\f\r]/g;
  function whitespace(thing) {
    return typeof thing === "object" ? thing.type === "text" ? empty$3(thing.value) : false : empty$3(thing);
  }
  function empty$3(value) {
    return value.replace(re$1, "") === "";
  }
  class Schema {
    constructor(property, normal, space2) {
      this.property = property;
      this.normal = normal;
      if (space2) {
        this.space = space2;
      }
    }
  }
  Schema.prototype.property = {};
  Schema.prototype.normal = {};
  Schema.prototype.space = null;
  function merge$1(definitions, space2) {
    const property = {};
    const normal = {};
    let index2 = -1;
    while (++index2 < definitions.length) {
      Object.assign(property, definitions[index2].property);
      Object.assign(normal, definitions[index2].normal);
    }
    return new Schema(property, normal, space2);
  }
  function normalize$2(value) {
    return value.toLowerCase();
  }
  class Info {
    constructor(property, attribute) {
      this.property = property;
      this.attribute = attribute;
    }
  }
  Info.prototype.space = null;
  Info.prototype.boolean = false;
  Info.prototype.booleanish = false;
  Info.prototype.overloadedBoolean = false;
  Info.prototype.number = false;
  Info.prototype.commaSeparated = false;
  Info.prototype.spaceSeparated = false;
  Info.prototype.commaOrSpaceSeparated = false;
  Info.prototype.mustUseProperty = false;
  Info.prototype.defined = false;
  let powers = 0;
  const boolean = increment();
  const booleanish = increment();
  const overloadedBoolean = increment();
  const number$3 = increment();
  const spaceSeparated = increment();
  const commaSeparated = increment();
  const commaOrSpaceSeparated = increment();
  function increment() {
    return 2 ** ++powers;
  }
  const types$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    boolean,
    booleanish,
    overloadedBoolean,
    number: number$3,
    spaceSeparated,
    commaSeparated,
    commaOrSpaceSeparated
  }, Symbol.toStringTag, { value: "Module" }));
  const checks = Object.keys(types$1);
  class DefinedInfo extends Info {
    constructor(property, attribute, mask, space2) {
      let index2 = -1;
      super(property, attribute);
      mark(this, "space", space2);
      if (typeof mask === "number") {
        while (++index2 < checks.length) {
          const check = checks[index2];
          mark(this, checks[index2], (mask & types$1[check]) === types$1[check]);
        }
      }
    }
  }
  DefinedInfo.prototype.defined = true;
  function mark(values, key, value) {
    if (value) {
      values[key] = value;
    }
  }
  const own$8 = {}.hasOwnProperty;
  function create$1(definition2) {
    const property = {};
    const normal = {};
    let prop;
    for (prop in definition2.properties) {
      if (own$8.call(definition2.properties, prop)) {
        const value = definition2.properties[prop];
        const info = new DefinedInfo(
          prop,
          definition2.transform(definition2.attributes || {}, prop),
          value,
          definition2.space
        );
        if (definition2.mustUseProperty && definition2.mustUseProperty.includes(prop)) {
          info.mustUseProperty = true;
        }
        property[prop] = info;
        normal[normalize$2(prop)] = prop;
        normal[normalize$2(info.attribute)] = prop;
      }
    }
    return new Schema(property, normal, definition2.space);
  }
  const xlink = create$1({
    space: "xlink",
    transform(_2, prop) {
      return "xlink:" + prop.slice(5).toLowerCase();
    },
    properties: {
      xLinkActuate: null,
      xLinkArcRole: null,
      xLinkHref: null,
      xLinkRole: null,
      xLinkShow: null,
      xLinkTitle: null,
      xLinkType: null
    }
  });
  const xml = create$1({
    space: "xml",
    transform(_2, prop) {
      return "xml:" + prop.slice(3).toLowerCase();
    },
    properties: { xmlLang: null, xmlBase: null, xmlSpace: null }
  });
  function caseSensitiveTransform(attributes2, attribute) {
    return attribute in attributes2 ? attributes2[attribute] : attribute;
  }
  function caseInsensitiveTransform(attributes2, property) {
    return caseSensitiveTransform(attributes2, property.toLowerCase());
  }
  const xmlns = create$1({
    space: "xmlns",
    attributes: { xmlnsxlink: "xmlns:xlink" },
    transform: caseInsensitiveTransform,
    properties: { xmlns: null, xmlnsXLink: null }
  });
  const aria = create$1({
    transform(_2, prop) {
      return prop === "role" ? prop : "aria-" + prop.slice(4).toLowerCase();
    },
    properties: {
      ariaActiveDescendant: null,
      ariaAtomic: booleanish,
      ariaAutoComplete: null,
      ariaBusy: booleanish,
      ariaChecked: booleanish,
      ariaColCount: number$3,
      ariaColIndex: number$3,
      ariaColSpan: number$3,
      ariaControls: spaceSeparated,
      ariaCurrent: null,
      ariaDescribedBy: spaceSeparated,
      ariaDetails: null,
      ariaDisabled: booleanish,
      ariaDropEffect: spaceSeparated,
      ariaErrorMessage: null,
      ariaExpanded: booleanish,
      ariaFlowTo: spaceSeparated,
      ariaGrabbed: booleanish,
      ariaHasPopup: null,
      ariaHidden: booleanish,
      ariaInvalid: null,
      ariaKeyShortcuts: null,
      ariaLabel: null,
      ariaLabelledBy: spaceSeparated,
      ariaLevel: number$3,
      ariaLive: null,
      ariaModal: booleanish,
      ariaMultiLine: booleanish,
      ariaMultiSelectable: booleanish,
      ariaOrientation: null,
      ariaOwns: spaceSeparated,
      ariaPlaceholder: null,
      ariaPosInSet: number$3,
      ariaPressed: booleanish,
      ariaReadOnly: booleanish,
      ariaRelevant: null,
      ariaRequired: booleanish,
      ariaRoleDescription: spaceSeparated,
      ariaRowCount: number$3,
      ariaRowIndex: number$3,
      ariaRowSpan: number$3,
      ariaSelected: booleanish,
      ariaSetSize: number$3,
      ariaSort: null,
      ariaValueMax: number$3,
      ariaValueMin: number$3,
      ariaValueNow: number$3,
      ariaValueText: null,
      role: null
    }
  });
  const html$4 = create$1({
    space: "html",
    attributes: {
      acceptcharset: "accept-charset",
      classname: "class",
      htmlfor: "for",
      httpequiv: "http-equiv"
    },
    transform: caseInsensitiveTransform,
    mustUseProperty: ["checked", "multiple", "muted", "selected"],
    properties: {
      abbr: null,
      accept: commaSeparated,
      acceptCharset: spaceSeparated,
      accessKey: spaceSeparated,
      action: null,
      allow: null,
      allowFullScreen: boolean,
      allowPaymentRequest: boolean,
      allowUserMedia: boolean,
      alt: null,
      as: null,
      async: boolean,
      autoCapitalize: null,
      autoComplete: spaceSeparated,
      autoFocus: boolean,
      autoPlay: boolean,
      blocking: spaceSeparated,
      capture: null,
      charSet: null,
      checked: boolean,
      cite: null,
      className: spaceSeparated,
      cols: number$3,
      colSpan: null,
      content: null,
      contentEditable: booleanish,
      controls: boolean,
      controlsList: spaceSeparated,
      coords: number$3 | commaSeparated,
      crossOrigin: null,
      data: null,
      dateTime: null,
      decoding: null,
      default: boolean,
      defer: boolean,
      dir: null,
      dirName: null,
      disabled: boolean,
      download: overloadedBoolean,
      draggable: booleanish,
      encType: null,
      enterKeyHint: null,
      fetchPriority: null,
      form: null,
      formAction: null,
      formEncType: null,
      formMethod: null,
      formNoValidate: boolean,
      formTarget: null,
      headers: spaceSeparated,
      height: number$3,
      hidden: boolean,
      high: number$3,
      href: null,
      hrefLang: null,
      htmlFor: spaceSeparated,
      httpEquiv: spaceSeparated,
      id: null,
      imageSizes: null,
      imageSrcSet: null,
      inert: boolean,
      inputMode: null,
      integrity: null,
      is: null,
      isMap: boolean,
      itemId: null,
      itemProp: spaceSeparated,
      itemRef: spaceSeparated,
      itemScope: boolean,
      itemType: spaceSeparated,
      kind: null,
      label: null,
      lang: null,
      language: null,
      list: null,
      loading: null,
      loop: boolean,
      low: number$3,
      manifest: null,
      max: null,
      maxLength: number$3,
      media: null,
      method: null,
      min: null,
      minLength: number$3,
      multiple: boolean,
      muted: boolean,
      name: null,
      nonce: null,
      noModule: boolean,
      noValidate: boolean,
      onAbort: null,
      onAfterPrint: null,
      onAuxClick: null,
      onBeforeMatch: null,
      onBeforePrint: null,
      onBeforeToggle: null,
      onBeforeUnload: null,
      onBlur: null,
      onCancel: null,
      onCanPlay: null,
      onCanPlayThrough: null,
      onChange: null,
      onClick: null,
      onClose: null,
      onContextLost: null,
      onContextMenu: null,
      onContextRestored: null,
      onCopy: null,
      onCueChange: null,
      onCut: null,
      onDblClick: null,
      onDrag: null,
      onDragEnd: null,
      onDragEnter: null,
      onDragExit: null,
      onDragLeave: null,
      onDragOver: null,
      onDragStart: null,
      onDrop: null,
      onDurationChange: null,
      onEmptied: null,
      onEnded: null,
      onError: null,
      onFocus: null,
      onFormData: null,
      onHashChange: null,
      onInput: null,
      onInvalid: null,
      onKeyDown: null,
      onKeyPress: null,
      onKeyUp: null,
      onLanguageChange: null,
      onLoad: null,
      onLoadedData: null,
      onLoadedMetadata: null,
      onLoadEnd: null,
      onLoadStart: null,
      onMessage: null,
      onMessageError: null,
      onMouseDown: null,
      onMouseEnter: null,
      onMouseLeave: null,
      onMouseMove: null,
      onMouseOut: null,
      onMouseOver: null,
      onMouseUp: null,
      onOffline: null,
      onOnline: null,
      onPageHide: null,
      onPageShow: null,
      onPaste: null,
      onPause: null,
      onPlay: null,
      onPlaying: null,
      onPopState: null,
      onProgress: null,
      onRateChange: null,
      onRejectionHandled: null,
      onReset: null,
      onResize: null,
      onScroll: null,
      onScrollEnd: null,
      onSecurityPolicyViolation: null,
      onSeeked: null,
      onSeeking: null,
      onSelect: null,
      onSlotChange: null,
      onStalled: null,
      onStorage: null,
      onSubmit: null,
      onSuspend: null,
      onTimeUpdate: null,
      onToggle: null,
      onUnhandledRejection: null,
      onUnload: null,
      onVolumeChange: null,
      onWaiting: null,
      onWheel: null,
      open: boolean,
      optimum: number$3,
      pattern: null,
      ping: spaceSeparated,
      placeholder: null,
      playsInline: boolean,
      popover: null,
      popoverTarget: null,
      popoverTargetAction: null,
      poster: null,
      preload: null,
      readOnly: boolean,
      referrerPolicy: null,
      rel: spaceSeparated,
      required: boolean,
      reversed: boolean,
      rows: number$3,
      rowSpan: number$3,
      sandbox: spaceSeparated,
      scope: null,
      scoped: boolean,
      seamless: boolean,
      selected: boolean,
      shadowRootClonable: boolean,
      shadowRootDelegatesFocus: boolean,
      shadowRootMode: null,
      shape: null,
      size: number$3,
      sizes: null,
      slot: null,
      span: number$3,
      spellCheck: booleanish,
      src: null,
      srcDoc: null,
      srcLang: null,
      srcSet: null,
      start: number$3,
      step: null,
      style: null,
      tabIndex: number$3,
      target: null,
      title: null,
      translate: null,
      type: null,
      typeMustMatch: boolean,
      useMap: null,
      value: booleanish,
      width: number$3,
      wrap: null,
      writingSuggestions: null,
      align: null,
      aLink: null,
      archive: spaceSeparated,
      axis: null,
      background: null,
      bgColor: null,
      border: number$3,
      borderColor: null,
      bottomMargin: number$3,
      cellPadding: null,
      cellSpacing: null,
      char: null,
      charOff: null,
      classId: null,
      clear: null,
      code: null,
      codeBase: null,
      codeType: null,
      color: null,
      compact: boolean,
      declare: boolean,
      event: null,
      face: null,
      frame: null,
      frameBorder: null,
      hSpace: number$3,
      leftMargin: number$3,
      link: null,
      longDesc: null,
      lowSrc: null,
      marginHeight: number$3,
      marginWidth: number$3,
      noResize: boolean,
      noHref: boolean,
      noShade: boolean,
      noWrap: boolean,
      object: null,
      profile: null,
      prompt: null,
      rev: null,
      rightMargin: number$3,
      rules: null,
      scheme: null,
      scrolling: booleanish,
      standby: null,
      summary: null,
      text: null,
      topMargin: number$3,
      valueType: null,
      version: null,
      vAlign: null,
      vLink: null,
      vSpace: number$3,
      allowTransparency: null,
      autoCorrect: null,
      autoSave: null,
      disablePictureInPicture: boolean,
      disableRemotePlayback: boolean,
      prefix: null,
      property: null,
      results: number$3,
      security: null,
      unselectable: null
    }
  });
  const svg$1 = create$1({
    space: "svg",
    attributes: {
      accentHeight: "accent-height",
      alignmentBaseline: "alignment-baseline",
      arabicForm: "arabic-form",
      baselineShift: "baseline-shift",
      capHeight: "cap-height",
      className: "class",
      clipPath: "clip-path",
      clipRule: "clip-rule",
      colorInterpolation: "color-interpolation",
      colorInterpolationFilters: "color-interpolation-filters",
      colorProfile: "color-profile",
      colorRendering: "color-rendering",
      crossOrigin: "crossorigin",
      dataType: "datatype",
      dominantBaseline: "dominant-baseline",
      enableBackground: "enable-background",
      fillOpacity: "fill-opacity",
      fillRule: "fill-rule",
      floodColor: "flood-color",
      floodOpacity: "flood-opacity",
      fontFamily: "font-family",
      fontSize: "font-size",
      fontSizeAdjust: "font-size-adjust",
      fontStretch: "font-stretch",
      fontStyle: "font-style",
      fontVariant: "font-variant",
      fontWeight: "font-weight",
      glyphName: "glyph-name",
      glyphOrientationHorizontal: "glyph-orientation-horizontal",
      glyphOrientationVertical: "glyph-orientation-vertical",
      hrefLang: "hreflang",
      horizAdvX: "horiz-adv-x",
      horizOriginX: "horiz-origin-x",
      horizOriginY: "horiz-origin-y",
      imageRendering: "image-rendering",
      letterSpacing: "letter-spacing",
      lightingColor: "lighting-color",
      markerEnd: "marker-end",
      markerMid: "marker-mid",
      markerStart: "marker-start",
      navDown: "nav-down",
      navDownLeft: "nav-down-left",
      navDownRight: "nav-down-right",
      navLeft: "nav-left",
      navNext: "nav-next",
      navPrev: "nav-prev",
      navRight: "nav-right",
      navUp: "nav-up",
      navUpLeft: "nav-up-left",
      navUpRight: "nav-up-right",
      onAbort: "onabort",
      onActivate: "onactivate",
      onAfterPrint: "onafterprint",
      onBeforePrint: "onbeforeprint",
      onBegin: "onbegin",
      onCancel: "oncancel",
      onCanPlay: "oncanplay",
      onCanPlayThrough: "oncanplaythrough",
      onChange: "onchange",
      onClick: "onclick",
      onClose: "onclose",
      onCopy: "oncopy",
      onCueChange: "oncuechange",
      onCut: "oncut",
      onDblClick: "ondblclick",
      onDrag: "ondrag",
      onDragEnd: "ondragend",
      onDragEnter: "ondragenter",
      onDragExit: "ondragexit",
      onDragLeave: "ondragleave",
      onDragOver: "ondragover",
      onDragStart: "ondragstart",
      onDrop: "ondrop",
      onDurationChange: "ondurationchange",
      onEmptied: "onemptied",
      onEnd: "onend",
      onEnded: "onended",
      onError: "onerror",
      onFocus: "onfocus",
      onFocusIn: "onfocusin",
      onFocusOut: "onfocusout",
      onHashChange: "onhashchange",
      onInput: "oninput",
      onInvalid: "oninvalid",
      onKeyDown: "onkeydown",
      onKeyPress: "onkeypress",
      onKeyUp: "onkeyup",
      onLoad: "onload",
      onLoadedData: "onloadeddata",
      onLoadedMetadata: "onloadedmetadata",
      onLoadStart: "onloadstart",
      onMessage: "onmessage",
      onMouseDown: "onmousedown",
      onMouseEnter: "onmouseenter",
      onMouseLeave: "onmouseleave",
      onMouseMove: "onmousemove",
      onMouseOut: "onmouseout",
      onMouseOver: "onmouseover",
      onMouseUp: "onmouseup",
      onMouseWheel: "onmousewheel",
      onOffline: "onoffline",
      onOnline: "ononline",
      onPageHide: "onpagehide",
      onPageShow: "onpageshow",
      onPaste: "onpaste",
      onPause: "onpause",
      onPlay: "onplay",
      onPlaying: "onplaying",
      onPopState: "onpopstate",
      onProgress: "onprogress",
      onRateChange: "onratechange",
      onRepeat: "onrepeat",
      onReset: "onreset",
      onResize: "onresize",
      onScroll: "onscroll",
      onSeeked: "onseeked",
      onSeeking: "onseeking",
      onSelect: "onselect",
      onShow: "onshow",
      onStalled: "onstalled",
      onStorage: "onstorage",
      onSubmit: "onsubmit",
      onSuspend: "onsuspend",
      onTimeUpdate: "ontimeupdate",
      onToggle: "ontoggle",
      onUnload: "onunload",
      onVolumeChange: "onvolumechange",
      onWaiting: "onwaiting",
      onZoom: "onzoom",
      overlinePosition: "overline-position",
      overlineThickness: "overline-thickness",
      paintOrder: "paint-order",
      panose1: "panose-1",
      pointerEvents: "pointer-events",
      referrerPolicy: "referrerpolicy",
      renderingIntent: "rendering-intent",
      shapeRendering: "shape-rendering",
      stopColor: "stop-color",
      stopOpacity: "stop-opacity",
      strikethroughPosition: "strikethrough-position",
      strikethroughThickness: "strikethrough-thickness",
      strokeDashArray: "stroke-dasharray",
      strokeDashOffset: "stroke-dashoffset",
      strokeLineCap: "stroke-linecap",
      strokeLineJoin: "stroke-linejoin",
      strokeMiterLimit: "stroke-miterlimit",
      strokeOpacity: "stroke-opacity",
      strokeWidth: "stroke-width",
      tabIndex: "tabindex",
      textAnchor: "text-anchor",
      textDecoration: "text-decoration",
      textRendering: "text-rendering",
      transformOrigin: "transform-origin",
      typeOf: "typeof",
      underlinePosition: "underline-position",
      underlineThickness: "underline-thickness",
      unicodeBidi: "unicode-bidi",
      unicodeRange: "unicode-range",
      unitsPerEm: "units-per-em",
      vAlphabetic: "v-alphabetic",
      vHanging: "v-hanging",
      vIdeographic: "v-ideographic",
      vMathematical: "v-mathematical",
      vectorEffect: "vector-effect",
      vertAdvY: "vert-adv-y",
      vertOriginX: "vert-origin-x",
      vertOriginY: "vert-origin-y",
      wordSpacing: "word-spacing",
      writingMode: "writing-mode",
      xHeight: "x-height",
      playbackOrder: "playbackorder",
      timelineBegin: "timelinebegin"
    },
    transform: caseSensitiveTransform,
    properties: {
      about: commaOrSpaceSeparated,
      accentHeight: number$3,
      accumulate: null,
      additive: null,
      alignmentBaseline: null,
      alphabetic: number$3,
      amplitude: number$3,
      arabicForm: null,
      ascent: number$3,
      attributeName: null,
      attributeType: null,
      azimuth: number$3,
      bandwidth: null,
      baselineShift: null,
      baseFrequency: null,
      baseProfile: null,
      bbox: null,
      begin: null,
      bias: number$3,
      by: null,
      calcMode: null,
      capHeight: number$3,
      className: spaceSeparated,
      clip: null,
      clipPath: null,
      clipPathUnits: null,
      clipRule: null,
      color: null,
      colorInterpolation: null,
      colorInterpolationFilters: null,
      colorProfile: null,
      colorRendering: null,
      content: null,
      contentScriptType: null,
      contentStyleType: null,
      crossOrigin: null,
      cursor: null,
      cx: null,
      cy: null,
      d: null,
      dataType: null,
      defaultAction: null,
      descent: number$3,
      diffuseConstant: number$3,
      direction: null,
      display: null,
      dur: null,
      divisor: number$3,
      dominantBaseline: null,
      download: boolean,
      dx: null,
      dy: null,
      edgeMode: null,
      editable: null,
      elevation: number$3,
      enableBackground: null,
      end: null,
      event: null,
      exponent: number$3,
      externalResourcesRequired: null,
      fill: null,
      fillOpacity: number$3,
      fillRule: null,
      filter: null,
      filterRes: null,
      filterUnits: null,
      floodColor: null,
      floodOpacity: null,
      focusable: null,
      focusHighlight: null,
      fontFamily: null,
      fontSize: null,
      fontSizeAdjust: null,
      fontStretch: null,
      fontStyle: null,
      fontVariant: null,
      fontWeight: null,
      format: null,
      fr: null,
      from: null,
      fx: null,
      fy: null,
      g1: commaSeparated,
      g2: commaSeparated,
      glyphName: commaSeparated,
      glyphOrientationHorizontal: null,
      glyphOrientationVertical: null,
      glyphRef: null,
      gradientTransform: null,
      gradientUnits: null,
      handler: null,
      hanging: number$3,
      hatchContentUnits: null,
      hatchUnits: null,
      height: null,
      href: null,
      hrefLang: null,
      horizAdvX: number$3,
      horizOriginX: number$3,
      horizOriginY: number$3,
      id: null,
      ideographic: number$3,
      imageRendering: null,
      initialVisibility: null,
      in: null,
      in2: null,
      intercept: number$3,
      k: number$3,
      k1: number$3,
      k2: number$3,
      k3: number$3,
      k4: number$3,
      kernelMatrix: commaOrSpaceSeparated,
      kernelUnitLength: null,
      keyPoints: null,
      keySplines: null,
      keyTimes: null,
      kerning: null,
      lang: null,
      lengthAdjust: null,
      letterSpacing: null,
      lightingColor: null,
      limitingConeAngle: number$3,
      local: null,
      markerEnd: null,
      markerMid: null,
      markerStart: null,
      markerHeight: null,
      markerUnits: null,
      markerWidth: null,
      mask: null,
      maskContentUnits: null,
      maskUnits: null,
      mathematical: null,
      max: null,
      media: null,
      mediaCharacterEncoding: null,
      mediaContentEncodings: null,
      mediaSize: number$3,
      mediaTime: null,
      method: null,
      min: null,
      mode: null,
      name: null,
      navDown: null,
      navDownLeft: null,
      navDownRight: null,
      navLeft: null,
      navNext: null,
      navPrev: null,
      navRight: null,
      navUp: null,
      navUpLeft: null,
      navUpRight: null,
      numOctaves: null,
      observer: null,
      offset: null,
      onAbort: null,
      onActivate: null,
      onAfterPrint: null,
      onBeforePrint: null,
      onBegin: null,
      onCancel: null,
      onCanPlay: null,
      onCanPlayThrough: null,
      onChange: null,
      onClick: null,
      onClose: null,
      onCopy: null,
      onCueChange: null,
      onCut: null,
      onDblClick: null,
      onDrag: null,
      onDragEnd: null,
      onDragEnter: null,
      onDragExit: null,
      onDragLeave: null,
      onDragOver: null,
      onDragStart: null,
      onDrop: null,
      onDurationChange: null,
      onEmptied: null,
      onEnd: null,
      onEnded: null,
      onError: null,
      onFocus: null,
      onFocusIn: null,
      onFocusOut: null,
      onHashChange: null,
      onInput: null,
      onInvalid: null,
      onKeyDown: null,
      onKeyPress: null,
      onKeyUp: null,
      onLoad: null,
      onLoadedData: null,
      onLoadedMetadata: null,
      onLoadStart: null,
      onMessage: null,
      onMouseDown: null,
      onMouseEnter: null,
      onMouseLeave: null,
      onMouseMove: null,
      onMouseOut: null,
      onMouseOver: null,
      onMouseUp: null,
      onMouseWheel: null,
      onOffline: null,
      onOnline: null,
      onPageHide: null,
      onPageShow: null,
      onPaste: null,
      onPause: null,
      onPlay: null,
      onPlaying: null,
      onPopState: null,
      onProgress: null,
      onRateChange: null,
      onRepeat: null,
      onReset: null,
      onResize: null,
      onScroll: null,
      onSeeked: null,
      onSeeking: null,
      onSelect: null,
      onShow: null,
      onStalled: null,
      onStorage: null,
      onSubmit: null,
      onSuspend: null,
      onTimeUpdate: null,
      onToggle: null,
      onUnload: null,
      onVolumeChange: null,
      onWaiting: null,
      onZoom: null,
      opacity: null,
      operator: null,
      order: null,
      orient: null,
      orientation: null,
      origin: null,
      overflow: null,
      overlay: null,
      overlinePosition: number$3,
      overlineThickness: number$3,
      paintOrder: null,
      panose1: null,
      path: null,
      pathLength: number$3,
      patternContentUnits: null,
      patternTransform: null,
      patternUnits: null,
      phase: null,
      ping: spaceSeparated,
      pitch: null,
      playbackOrder: null,
      pointerEvents: null,
      points: null,
      pointsAtX: number$3,
      pointsAtY: number$3,
      pointsAtZ: number$3,
      preserveAlpha: null,
      preserveAspectRatio: null,
      primitiveUnits: null,
      propagate: null,
      property: commaOrSpaceSeparated,
      r: null,
      radius: null,
      referrerPolicy: null,
      refX: null,
      refY: null,
      rel: commaOrSpaceSeparated,
      rev: commaOrSpaceSeparated,
      renderingIntent: null,
      repeatCount: null,
      repeatDur: null,
      requiredExtensions: commaOrSpaceSeparated,
      requiredFeatures: commaOrSpaceSeparated,
      requiredFonts: commaOrSpaceSeparated,
      requiredFormats: commaOrSpaceSeparated,
      resource: null,
      restart: null,
      result: null,
      rotate: null,
      rx: null,
      ry: null,
      scale: null,
      seed: null,
      shapeRendering: null,
      side: null,
      slope: null,
      snapshotTime: null,
      specularConstant: number$3,
      specularExponent: number$3,
      spreadMethod: null,
      spacing: null,
      startOffset: null,
      stdDeviation: null,
      stemh: null,
      stemv: null,
      stitchTiles: null,
      stopColor: null,
      stopOpacity: null,
      strikethroughPosition: number$3,
      strikethroughThickness: number$3,
      string: null,
      stroke: null,
      strokeDashArray: commaOrSpaceSeparated,
      strokeDashOffset: null,
      strokeLineCap: null,
      strokeLineJoin: null,
      strokeMiterLimit: number$3,
      strokeOpacity: number$3,
      strokeWidth: null,
      style: null,
      surfaceScale: number$3,
      syncBehavior: null,
      syncBehaviorDefault: null,
      syncMaster: null,
      syncTolerance: null,
      syncToleranceDefault: null,
      systemLanguage: commaOrSpaceSeparated,
      tabIndex: number$3,
      tableValues: null,
      target: null,
      targetX: number$3,
      targetY: number$3,
      textAnchor: null,
      textDecoration: null,
      textRendering: null,
      textLength: null,
      timelineBegin: null,
      title: null,
      transformBehavior: null,
      type: null,
      typeOf: commaOrSpaceSeparated,
      to: null,
      transform: null,
      transformOrigin: null,
      u1: null,
      u2: null,
      underlinePosition: number$3,
      underlineThickness: number$3,
      unicode: null,
      unicodeBidi: null,
      unicodeRange: null,
      unitsPerEm: number$3,
      values: null,
      vAlphabetic: number$3,
      vMathematical: number$3,
      vectorEffect: null,
      vHanging: number$3,
      vIdeographic: number$3,
      version: null,
      vertAdvY: number$3,
      vertOriginX: number$3,
      vertOriginY: number$3,
      viewBox: null,
      viewTarget: null,
      visibility: null,
      width: null,
      widths: null,
      wordSpacing: null,
      writingMode: null,
      x: null,
      x1: null,
      x2: null,
      xChannelSelector: null,
      xHeight: number$3,
      y: null,
      y1: null,
      y2: null,
      yChannelSelector: null,
      z: null,
      zoomAndPan: null
    }
  });
  const valid$1 = /^data[-\w.:]+$/i;
  const dash = /-[a-z]/g;
  const cap$1 = /[A-Z]/g;
  function find$3(schema, value) {
    const normal = normalize$2(value);
    let prop = value;
    let Type2 = Info;
    if (normal in schema.normal) {
      return schema.property[schema.normal[normal]];
    }
    if (normal.length > 4 && normal.slice(0, 4) === "data" && valid$1.test(value)) {
      if (value.charAt(4) === "-") {
        const rest = value.slice(5).replace(dash, camelcase);
        prop = "data" + rest.charAt(0).toUpperCase() + rest.slice(1);
      } else {
        const rest = value.slice(4);
        if (!dash.test(rest)) {
          let dashes = rest.replace(cap$1, kebab);
          if (dashes.charAt(0) !== "-") {
            dashes = "-" + dashes;
          }
          value = "data" + dashes;
        }
      }
      Type2 = DefinedInfo;
    }
    return new Type2(prop, value);
  }
  function kebab($0) {
    return "-" + $0.toLowerCase();
  }
  function camelcase($0) {
    return $0.charAt(1).toUpperCase();
  }
  const hastToReact = {
    classId: "classID",
    dataType: "datatype",
    itemId: "itemID",
    strokeDashArray: "strokeDasharray",
    strokeDashOffset: "strokeDashoffset",
    strokeLineCap: "strokeLinecap",
    strokeLineJoin: "strokeLinejoin",
    strokeMiterLimit: "strokeMiterlimit",
    typeOf: "typeof",
    xLinkActuate: "xlinkActuate",
    xLinkArcRole: "xlinkArcrole",
    xLinkHref: "xlinkHref",
    xLinkRole: "xlinkRole",
    xLinkShow: "xlinkShow",
    xLinkTitle: "xlinkTitle",
    xLinkType: "xlinkType",
    xmlnsXLink: "xmlnsXlink"
  };
  const html$3 = merge$1([xml, xlink, xmlns, aria, html$4], "html");
  const svg = merge$1([xml, xlink, xmlns, aria, svg$1], "svg");
  function parse$7(value) {
    const input = String(value || "").trim();
    return input ? input.split(/[ \t\n\r\f]+/g) : [];
  }
  function stringify$2(values) {
    return values.join(" ").trim();
  }
  var cjs = {};
  var COMMENT_REGEX = /\/\*[^*]*\*+([^/*][^*]*\*+)*\//g;
  var NEWLINE_REGEX = /\n/g;
  var WHITESPACE_REGEX = /^\s*/;
  var PROPERTY_REGEX = /^(\*?[-#/*\\\w]+(\[[0-9a-z_-]+\])?)\s*/;
  var COLON_REGEX = /^:\s*/;
  var VALUE_REGEX = /^((?:'(?:\\'|.)*?'|"(?:\\"|.)*?"|\([^)]*?\)|[^};])+)/;
  var SEMICOLON_REGEX = /^[;\s]*/;
  var TRIM_REGEX = /^\s+|\s+$/g;
  var NEWLINE = "\n";
  var FORWARD_SLASH = "/";
  var ASTERISK = "*";
  var EMPTY_STRING = "";
  var TYPE_COMMENT = "comment";
  var TYPE_DECLARATION = "declaration";
  var inlineStyleParser = function(style2, options) {
    if (typeof style2 !== "string") {
      throw new TypeError("First argument must be a string");
    }
    if (!style2)
      return [];
    options = options || {};
    var lineno = 1;
    var column = 1;
    function updatePosition(str) {
      var lines = str.match(NEWLINE_REGEX);
      if (lines)
        lineno += lines.length;
      var i2 = str.lastIndexOf(NEWLINE);
      column = ~i2 ? str.length - i2 : column + str.length;
    }
    function position2() {
      var start2 = { line: lineno, column };
      return function(node2) {
        node2.position = new Position(start2);
        whitespace2();
        return node2;
      };
    }
    function Position(start2) {
      this.start = start2;
      this.end = { line: lineno, column };
      this.source = options.source;
    }
    Position.prototype.content = style2;
    function error2(msg) {
      var err = new Error(
        options.source + ":" + lineno + ":" + column + ": " + msg
      );
      err.reason = msg;
      err.filename = options.source;
      err.line = lineno;
      err.column = column;
      err.source = style2;
      if (options.silent)
        ;
      else {
        throw err;
      }
    }
    function match2(re2) {
      var m2 = re2.exec(style2);
      if (!m2)
        return;
      var str = m2[0];
      updatePosition(str);
      style2 = style2.slice(str.length);
      return m2;
    }
    function whitespace2() {
      match2(WHITESPACE_REGEX);
    }
    function comments(rules) {
      var c2;
      rules = rules || [];
      while (c2 = comment2()) {
        if (c2 !== false) {
          rules.push(c2);
        }
      }
      return rules;
    }
    function comment2() {
      var pos = position2();
      if (FORWARD_SLASH != style2.charAt(0) || ASTERISK != style2.charAt(1))
        return;
      var i2 = 2;
      while (EMPTY_STRING != style2.charAt(i2) && (ASTERISK != style2.charAt(i2) || FORWARD_SLASH != style2.charAt(i2 + 1))) {
        ++i2;
      }
      i2 += 2;
      if (EMPTY_STRING === style2.charAt(i2 - 1)) {
        return error2("End of comment missing");
      }
      var str = style2.slice(2, i2 - 2);
      column += 2;
      updatePosition(str);
      style2 = style2.slice(i2);
      column += 2;
      return pos({
        type: TYPE_COMMENT,
        comment: str
      });
    }
    function declaration() {
      var pos = position2();
      var prop = match2(PROPERTY_REGEX);
      if (!prop)
        return;
      comment2();
      if (!match2(COLON_REGEX))
        return error2("property missing ':'");
      var val = match2(VALUE_REGEX);
      var ret = pos({
        type: TYPE_DECLARATION,
        property: trim(prop[0].replace(COMMENT_REGEX, EMPTY_STRING)),
        value: val ? trim(val[0].replace(COMMENT_REGEX, EMPTY_STRING)) : EMPTY_STRING
      });
      match2(SEMICOLON_REGEX);
      return ret;
    }
    function declarations() {
      var decls = [];
      comments(decls);
      var decl;
      while (decl = declaration()) {
        if (decl !== false) {
          decls.push(decl);
          comments(decls);
        }
      }
      return decls;
    }
    whitespace2();
    return declarations();
  };
  function trim(str) {
    return str ? str.replace(TRIM_REGEX, EMPTY_STRING) : EMPTY_STRING;
  }
  var __importDefault = commonjsGlobal$1 && commonjsGlobal$1.__importDefault || function(mod) {
    return mod && mod.__esModule ? mod : { "default": mod };
  };
  Object.defineProperty(cjs, "__esModule", { value: true });
  var inline_style_parser_1 = __importDefault(inlineStyleParser);
  function StyleToObject(style2, iterator2) {
    var styleObject = null;
    if (!style2 || typeof style2 !== "string") {
      return styleObject;
    }
    var declarations = (0, inline_style_parser_1.default)(style2);
    var hasIterator = typeof iterator2 === "function";
    declarations.forEach(function(declaration) {
      if (declaration.type !== "declaration") {
        return;
      }
      var property = declaration.property, value = declaration.value;
      if (hasIterator) {
        iterator2(property, value, declaration);
      } else if (value) {
        styleObject = styleObject || {};
        styleObject[property] = value;
      }
    });
    return styleObject;
  }
  var _default$2 = cjs.default = StyleToObject;
  const styleToObject = _default$2.default || _default$2;
  const pointEnd$1 = point$4("end");
  const pointStart$1 = point$4("start");
  function point$4(type2) {
    return point2;
    function point2(node2) {
      const point3 = node2 && node2.position && node2.position[type2] || {};
      if (typeof point3.line === "number" && point3.line > 0 && typeof point3.column === "number" && point3.column > 0) {
        return {
          line: point3.line,
          column: point3.column,
          offset: typeof point3.offset === "number" && point3.offset > -1 ? point3.offset : void 0
        };
      }
    }
  }
  function position$3(node2) {
    const start2 = pointStart$1(node2);
    const end2 = pointEnd$1(node2);
    if (start2 && end2) {
      return { start: start2, end: end2 };
    }
  }
  function stringifyPosition(value) {
    if (!value || typeof value !== "object") {
      return "";
    }
    if ("position" in value || "type" in value) {
      return position$2(value.position);
    }
    if ("start" in value || "end" in value) {
      return position$2(value);
    }
    if ("line" in value || "column" in value) {
      return point$3(value);
    }
    return "";
  }
  function point$3(point2) {
    return index$2(point2 && point2.line) + ":" + index$2(point2 && point2.column);
  }
  function position$2(pos) {
    return point$3(pos && pos.start) + "-" + point$3(pos && pos.end);
  }
  function index$2(value) {
    return value && typeof value === "number" ? value : 1;
  }
  class VFileMessage extends Error {
    constructor(causeOrReason, optionsOrParentOrPlace, origin) {
      super();
      if (typeof optionsOrParentOrPlace === "string") {
        origin = optionsOrParentOrPlace;
        optionsOrParentOrPlace = void 0;
      }
      let reason = "";
      let options = {};
      let legacyCause = false;
      if (optionsOrParentOrPlace) {
        if ("line" in optionsOrParentOrPlace && "column" in optionsOrParentOrPlace) {
          options = { place: optionsOrParentOrPlace };
        } else if ("start" in optionsOrParentOrPlace && "end" in optionsOrParentOrPlace) {
          options = { place: optionsOrParentOrPlace };
        } else if ("type" in optionsOrParentOrPlace) {
          options = {
            ancestors: [optionsOrParentOrPlace],
            place: optionsOrParentOrPlace.position
          };
        } else {
          options = { ...optionsOrParentOrPlace };
        }
      }
      if (typeof causeOrReason === "string") {
        reason = causeOrReason;
      } else if (!options.cause && causeOrReason) {
        legacyCause = true;
        reason = causeOrReason.message;
        options.cause = causeOrReason;
      }
      if (!options.ruleId && !options.source && typeof origin === "string") {
        const index2 = origin.indexOf(":");
        if (index2 === -1) {
          options.ruleId = origin;
        } else {
          options.source = origin.slice(0, index2);
          options.ruleId = origin.slice(index2 + 1);
        }
      }
      if (!options.place && options.ancestors && options.ancestors) {
        const parent = options.ancestors[options.ancestors.length - 1];
        if (parent) {
          options.place = parent.position;
        }
      }
      const start2 = options.place && "start" in options.place ? options.place.start : options.place;
      this.ancestors = options.ancestors || void 0;
      this.cause = options.cause || void 0;
      this.column = start2 ? start2.column : void 0;
      this.fatal = void 0;
      this.file;
      this.message = reason;
      this.line = start2 ? start2.line : void 0;
      this.name = stringifyPosition(options.place) || "1:1";
      this.place = options.place || void 0;
      this.reason = this.message;
      this.ruleId = options.ruleId || void 0;
      this.source = options.source || void 0;
      this.stack = legacyCause && options.cause && typeof options.cause.stack === "string" ? options.cause.stack : "";
      this.actual;
      this.expected;
      this.note;
      this.url;
    }
  }
  VFileMessage.prototype.file = "";
  VFileMessage.prototype.name = "";
  VFileMessage.prototype.reason = "";
  VFileMessage.prototype.message = "";
  VFileMessage.prototype.stack = "";
  VFileMessage.prototype.column = void 0;
  VFileMessage.prototype.line = void 0;
  VFileMessage.prototype.ancestors = void 0;
  VFileMessage.prototype.cause = void 0;
  VFileMessage.prototype.fatal = void 0;
  VFileMessage.prototype.place = void 0;
  VFileMessage.prototype.ruleId = void 0;
  VFileMessage.prototype.source = void 0;
  const own$7 = {}.hasOwnProperty;
  const emptyMap = /* @__PURE__ */ new Map();
  const cap = /[A-Z]/g;
  const dashSomething = /-([a-z])/g;
  const tableElements = /* @__PURE__ */ new Set(["table", "tbody", "thead", "tfoot", "tr"]);
  const tableCellElement = /* @__PURE__ */ new Set(["td", "th"]);
  const docs = "https://github.com/syntax-tree/hast-util-to-jsx-runtime";
  function toJsxRuntime(tree, options) {
    if (!options || options.Fragment === void 0) {
      throw new TypeError("Expected `Fragment` in options");
    }
    const filePath = options.filePath || void 0;
    let create2;
    if (options.development) {
      if (typeof options.jsxDEV !== "function") {
        throw new TypeError(
          "Expected `jsxDEV` in options when `development: true`"
        );
      }
      create2 = developmentCreate(filePath, options.jsxDEV);
    } else {
      if (typeof options.jsx !== "function") {
        throw new TypeError("Expected `jsx` in production options");
      }
      if (typeof options.jsxs !== "function") {
        throw new TypeError("Expected `jsxs` in production options");
      }
      create2 = productionCreate(filePath, options.jsx, options.jsxs);
    }
    const state = {
      Fragment: options.Fragment,
      ancestors: [],
      components: options.components || {},
      create: create2,
      elementAttributeNameCase: options.elementAttributeNameCase || "react",
      evaluater: options.createEvaluater ? options.createEvaluater() : void 0,
      filePath,
      ignoreInvalidStyle: options.ignoreInvalidStyle || false,
      passKeys: options.passKeys !== false,
      passNode: options.passNode || false,
      schema: options.space === "svg" ? svg : html$3,
      stylePropertyNameCase: options.stylePropertyNameCase || "dom",
      tableCellAlignToStyle: options.tableCellAlignToStyle !== false
    };
    const result = one$4(state, tree, void 0);
    if (result && typeof result !== "string") {
      return result;
    }
    return state.create(
      tree,
      state.Fragment,
      { children: result || void 0 },
      void 0
    );
  }
  function one$4(state, node2, key) {
    if (node2.type === "element") {
      return element$4(state, node2, key);
    }
    if (node2.type === "mdxFlowExpression" || node2.type === "mdxTextExpression") {
      return mdxExpression(state, node2);
    }
    if (node2.type === "mdxJsxFlowElement" || node2.type === "mdxJsxTextElement") {
      return mdxJsxElement(state, node2, key);
    }
    if (node2.type === "mdxjsEsm") {
      return mdxEsm(state, node2);
    }
    if (node2.type === "root") {
      return root$6(state, node2, key);
    }
    if (node2.type === "text") {
      return text$6(state, node2);
    }
  }
  function element$4(state, node2, key) {
    const parentSchema = state.schema;
    let schema = parentSchema;
    if (node2.tagName.toLowerCase() === "svg" && parentSchema.space === "html") {
      schema = svg;
      state.schema = schema;
    }
    state.ancestors.push(node2);
    const type2 = findComponentFromName(state, node2.tagName, false);
    const props = createElementProps(state, node2);
    let children2 = createChildren(state, node2);
    if (tableElements.has(node2.tagName)) {
      children2 = children2.filter(function(child) {
        return typeof child === "string" ? !whitespace(child) : true;
      });
    }
    addNode$1(state, props, type2, node2);
    addChildren$1(props, children2);
    state.ancestors.pop();
    state.schema = parentSchema;
    return state.create(node2, type2, props, key);
  }
  function mdxExpression(state, node2) {
    if (node2.data && node2.data.estree && state.evaluater) {
      const program = node2.data.estree;
      const expression = program.body[0];
      ok$2(expression.type === "ExpressionStatement");
      return state.evaluater.evaluateExpression(expression.expression);
    }
    crashEstree(state, node2.position);
  }
  function mdxEsm(state, node2) {
    if (node2.data && node2.data.estree && state.evaluater) {
      return state.evaluater.evaluateProgram(node2.data.estree);
    }
    crashEstree(state, node2.position);
  }
  function mdxJsxElement(state, node2, key) {
    const parentSchema = state.schema;
    let schema = parentSchema;
    if (node2.name === "svg" && parentSchema.space === "html") {
      schema = svg;
      state.schema = schema;
    }
    state.ancestors.push(node2);
    const type2 = node2.name === null ? state.Fragment : findComponentFromName(state, node2.name, true);
    const props = createJsxElementProps(state, node2);
    const children2 = createChildren(state, node2);
    addNode$1(state, props, type2, node2);
    addChildren$1(props, children2);
    state.ancestors.pop();
    state.schema = parentSchema;
    return state.create(node2, type2, props, key);
  }
  function root$6(state, node2, key) {
    const props = {};
    addChildren$1(props, createChildren(state, node2));
    return state.create(node2, state.Fragment, props, key);
  }
  function text$6(_2, node2) {
    return node2.value;
  }
  function addNode$1(state, props, type2, node2) {
    if (typeof type2 !== "string" && type2 !== state.Fragment && state.passNode) {
      props.node = node2;
    }
  }
  function addChildren$1(props, children2) {
    if (children2.length > 0) {
      const value = children2.length > 1 ? children2 : children2[0];
      if (value) {
        props.children = value;
      }
    }
  }
  function productionCreate(_2, jsx, jsxs) {
    return create2;
    function create2(_3, type2, props, key) {
      const isStaticChildren = Array.isArray(props.children);
      const fn2 = isStaticChildren ? jsxs : jsx;
      return key ? fn2(type2, props, key) : fn2(type2, props);
    }
  }
  function developmentCreate(filePath, jsxDEV) {
    return create2;
    function create2(node2, type2, props, key) {
      const isStaticChildren = Array.isArray(props.children);
      const point2 = pointStart$1(node2);
      return jsxDEV(
        type2,
        props,
        key,
        isStaticChildren,
        {
          columnNumber: point2 ? point2.column - 1 : void 0,
          fileName: filePath,
          lineNumber: point2 ? point2.line : void 0
        },
        void 0
      );
    }
  }
  function createElementProps(state, node2) {
    const props = {};
    let alignValue;
    let prop;
    for (prop in node2.properties) {
      if (prop !== "children" && own$7.call(node2.properties, prop)) {
        const result = createProperty$1(state, prop, node2.properties[prop]);
        if (result) {
          const [key, value] = result;
          if (state.tableCellAlignToStyle && key === "align" && typeof value === "string" && tableCellElement.has(node2.tagName)) {
            alignValue = value;
          } else {
            props[key] = value;
          }
        }
      }
    }
    if (alignValue) {
      const style2 = props.style || (props.style = {});
      style2[state.stylePropertyNameCase === "css" ? "text-align" : "textAlign"] = alignValue;
    }
    return props;
  }
  function createJsxElementProps(state, node2) {
    const props = {};
    for (const attribute of node2.attributes) {
      if (attribute.type === "mdxJsxExpressionAttribute") {
        if (attribute.data && attribute.data.estree && state.evaluater) {
          const program = attribute.data.estree;
          const expression = program.body[0];
          ok$2(expression.type === "ExpressionStatement");
          const objectExpression = expression.expression;
          ok$2(objectExpression.type === "ObjectExpression");
          const property = objectExpression.properties[0];
          ok$2(property.type === "SpreadElement");
          Object.assign(
            props,
            state.evaluater.evaluateExpression(property.argument)
          );
        } else {
          crashEstree(state, node2.position);
        }
      } else {
        const name2 = attribute.name;
        let value;
        if (attribute.value && typeof attribute.value === "object") {
          if (attribute.value.data && attribute.value.data.estree && state.evaluater) {
            const program = attribute.value.data.estree;
            const expression = program.body[0];
            ok$2(expression.type === "ExpressionStatement");
            value = state.evaluater.evaluateExpression(expression.expression);
          } else {
            crashEstree(state, node2.position);
          }
        } else {
          value = attribute.value === null ? true : attribute.value;
        }
        props[name2] = value;
      }
    }
    return props;
  }
  function createChildren(state, node2) {
    const children2 = [];
    let index2 = -1;
    const countsByName = state.passKeys ? /* @__PURE__ */ new Map() : emptyMap;
    while (++index2 < node2.children.length) {
      const child = node2.children[index2];
      let key;
      if (state.passKeys) {
        const name2 = child.type === "element" ? child.tagName : child.type === "mdxJsxFlowElement" || child.type === "mdxJsxTextElement" ? child.name : void 0;
        if (name2) {
          const count2 = countsByName.get(name2) || 0;
          key = name2 + "-" + count2;
          countsByName.set(name2, count2 + 1);
        }
      }
      const result = one$4(state, child, key);
      if (result !== void 0)
        children2.push(result);
    }
    return children2;
  }
  function createProperty$1(state, prop, value) {
    const info = find$3(state.schema, prop);
    if (value === null || value === void 0 || typeof value === "number" && Number.isNaN(value)) {
      return;
    }
    if (Array.isArray(value)) {
      value = info.commaSeparated ? stringify$3(value) : stringify$2(value);
    }
    if (info.property === "style") {
      let styleObject = typeof value === "object" ? value : parseStyle(state, String(value));
      if (state.stylePropertyNameCase === "css") {
        styleObject = transformStylesToCssCasing(styleObject);
      }
      return ["style", styleObject];
    }
    return [
      state.elementAttributeNameCase === "react" && info.space ? hastToReact[info.property] || info.property : info.attribute,
      value
    ];
  }
  function parseStyle(state, value) {
    const result = {};
    try {
      styleToObject(value, replacer);
    } catch (error2) {
      if (!state.ignoreInvalidStyle) {
        const cause = error2;
        const message = new VFileMessage("Cannot parse `style` attribute", {
          ancestors: state.ancestors,
          cause,
          ruleId: "style",
          source: "hast-util-to-jsx-runtime"
        });
        message.file = state.filePath || void 0;
        message.url = docs + "#cannot-parse-style-attribute";
        throw message;
      }
    }
    return result;
    function replacer(name2, value2) {
      let key = name2;
      if (key.slice(0, 2) !== "--") {
        if (key.slice(0, 4) === "-ms-")
          key = "ms-" + key.slice(4);
        key = key.replace(dashSomething, toCamel);
      }
      result[key] = value2;
    }
  }
  function findComponentFromName(state, name2, allowExpression) {
    let result;
    if (!allowExpression) {
      result = { type: "Literal", value: name2 };
    } else if (name2.includes(".")) {
      const identifiers = name2.split(".");
      let index2 = -1;
      let node2;
      while (++index2 < identifiers.length) {
        const prop = name$2(identifiers[index2]) ? { type: "Identifier", name: identifiers[index2] } : { type: "Literal", value: identifiers[index2] };
        node2 = node2 ? {
          type: "MemberExpression",
          object: node2,
          property: prop,
          computed: Boolean(index2 && prop.type === "Literal"),
          optional: false
        } : prop;
      }
      result = node2;
    } else {
      result = name$2(name2) && !/^[a-z]/.test(name2) ? { type: "Identifier", name: name2 } : { type: "Literal", value: name2 };
    }
    if (result.type === "Literal") {
      const name3 = result.value;
      return own$7.call(state.components, name3) ? state.components[name3] : name3;
    }
    if (state.evaluater) {
      return state.evaluater.evaluateExpression(result);
    }
    crashEstree(state);
  }
  function crashEstree(state, place2) {
    const message = new VFileMessage(
      "Cannot handle MDX estrees without `createEvaluater`",
      {
        ancestors: state.ancestors,
        place: place2,
        ruleId: "mdx-estree",
        source: "hast-util-to-jsx-runtime"
      }
    );
    message.file = state.filePath || void 0;
    message.url = docs + "#cannot-handle-mdx-estrees-without-createevaluater";
    throw message;
  }
  function transformStylesToCssCasing(domCasing) {
    const cssCasing = {};
    let from;
    for (from in domCasing) {
      if (own$7.call(domCasing, from)) {
        cssCasing[transformStyleToCssCasing(from)] = domCasing[from];
      }
    }
    return cssCasing;
  }
  function transformStyleToCssCasing(from) {
    let to2 = from.replace(cap, toDash);
    if (to2.slice(0, 3) === "ms-")
      to2 = "-" + to2;
    return to2;
  }
  function toCamel(_2, $1) {
    return $1.toUpperCase();
  }
  function toDash($0) {
    return "-" + $0.toLowerCase();
  }
  const urlAttributes = {
    action: ["form"],
    cite: ["blockquote", "del", "ins", "q"],
    data: ["object"],
    formAction: ["button", "input"],
    href: ["a", "area", "base", "link"],
    icon: ["menuitem"],
    itemId: null,
    manifest: ["html"],
    ping: ["a", "area"],
    poster: ["video"],
    src: [
      "audio",
      "embed",
      "iframe",
      "img",
      "input",
      "script",
      "source",
      "track",
      "video"
    ]
  };
  const emptyOptions$2 = {};
  function toString$5(value, options) {
    const settings2 = options || emptyOptions$2;
    const includeImageAlt = typeof settings2.includeImageAlt === "boolean" ? settings2.includeImageAlt : true;
    const includeHtml = typeof settings2.includeHtml === "boolean" ? settings2.includeHtml : true;
    return one$3(value, includeImageAlt, includeHtml);
  }
  function one$3(value, includeImageAlt, includeHtml) {
    if (node(value)) {
      if ("value" in value) {
        return value.type === "html" && !includeHtml ? "" : value.value;
      }
      if (includeImageAlt && "alt" in value && value.alt) {
        return value.alt;
      }
      if ("children" in value) {
        return all$2(value.children, includeImageAlt, includeHtml);
      }
    }
    if (Array.isArray(value)) {
      return all$2(value, includeImageAlt, includeHtml);
    }
    return "";
  }
  function all$2(values, includeImageAlt, includeHtml) {
    const result = [];
    let index2 = -1;
    while (++index2 < values.length) {
      result[index2] = one$3(values[index2], includeImageAlt, includeHtml);
    }
    return result.join("");
  }
  function node(value) {
    return Boolean(value && typeof value === "object");
  }
  const element$3 = document.createElement("i");
  function decodeNamedCharacterReference(value) {
    const characterReference2 = "&" + value + ";";
    element$3.innerHTML = characterReference2;
    const char = element$3.textContent;
    if (char.charCodeAt(char.length - 1) === 59 && value !== "semi") {
      return false;
    }
    return char === characterReference2 ? false : char;
  }
  function splice$1(list2, start2, remove2, items) {
    const end2 = list2.length;
    let chunkStart = 0;
    let parameters;
    if (start2 < 0) {
      start2 = -start2 > end2 ? 0 : end2 + start2;
    } else {
      start2 = start2 > end2 ? end2 : start2;
    }
    remove2 = remove2 > 0 ? remove2 : 0;
    if (items.length < 1e4) {
      parameters = Array.from(items);
      parameters.unshift(start2, remove2);
      list2.splice(...parameters);
    } else {
      if (remove2)
        list2.splice(start2, remove2);
      while (chunkStart < items.length) {
        parameters = items.slice(chunkStart, chunkStart + 1e4);
        parameters.unshift(start2, 0);
        list2.splice(...parameters);
        chunkStart += 1e4;
        start2 += 1e4;
      }
    }
  }
  function push$2(list2, items) {
    if (list2.length > 0) {
      splice$1(list2, list2.length, 0, items);
      return list2;
    }
    return items;
  }
  const hasOwnProperty$7 = {}.hasOwnProperty;
  function combineExtensions(extensions2) {
    const all2 = {};
    let index2 = -1;
    while (++index2 < extensions2.length) {
      syntaxExtension(all2, extensions2[index2]);
    }
    return all2;
  }
  function syntaxExtension(all2, extension2) {
    let hook;
    for (hook in extension2) {
      const maybe = hasOwnProperty$7.call(all2, hook) ? all2[hook] : void 0;
      const left2 = maybe || (all2[hook] = {});
      const right2 = extension2[hook];
      let code2;
      if (right2) {
        for (code2 in right2) {
          if (!hasOwnProperty$7.call(left2, code2))
            left2[code2] = [];
          const value = right2[code2];
          constructs(
            left2[code2],
            Array.isArray(value) ? value : value ? [value] : []
          );
        }
      }
    }
  }
  function constructs(existing, list2) {
    let index2 = -1;
    const before = [];
    while (++index2 < list2.length) {
      (list2[index2].add === "after" ? existing : before).push(list2[index2]);
    }
    splice$1(existing, 0, 0, before);
  }
  function decodeNumericCharacterReference(value, base2) {
    const code2 = Number.parseInt(value, base2);
    if (code2 < 9 || code2 === 11 || code2 > 13 && code2 < 32 || code2 > 126 && code2 < 160 || code2 > 55295 && code2 < 57344 || code2 > 64975 && code2 < 65008 || (code2 & 65535) === 65535 || (code2 & 65535) === 65534 || code2 > 1114111) {
      return "\uFFFD";
    }
    return String.fromCodePoint(code2);
  }
  function normalizeIdentifier(value) {
    return value.replace(/[\t\n\r ]+/g, " ").replace(/^ | $/g, "").toLowerCase().toUpperCase();
  }
  const asciiAlpha = regexCheck(/[A-Za-z]/);
  const asciiAlphanumeric = regexCheck(/[\dA-Za-z]/);
  const asciiAtext = regexCheck(/[#-'*+\--9=?A-Z^-~]/);
  function asciiControl(code2) {
    return code2 !== null && (code2 < 32 || code2 === 127);
  }
  const asciiDigit = regexCheck(/\d/);
  const asciiHexDigit = regexCheck(/[\dA-Fa-f]/);
  const asciiPunctuation = regexCheck(/[!-/:-@[-`{-~]/);
  function markdownLineEnding(code2) {
    return code2 !== null && code2 < -2;
  }
  function markdownLineEndingOrSpace(code2) {
    return code2 !== null && (code2 < 0 || code2 === 32);
  }
  function markdownSpace(code2) {
    return code2 === -2 || code2 === -1 || code2 === 32;
  }
  const unicodePunctuation = regexCheck(/\p{P}|\p{S}/u);
  const unicodeWhitespace = regexCheck(/\s/);
  function regexCheck(regex) {
    return check;
    function check(code2) {
      return code2 !== null && code2 > -1 && regex.test(String.fromCharCode(code2));
    }
  }
  function normalizeUri(value) {
    const result = [];
    let index2 = -1;
    let start2 = 0;
    let skip = 0;
    while (++index2 < value.length) {
      const code2 = value.charCodeAt(index2);
      let replace2 = "";
      if (code2 === 37 && asciiAlphanumeric(value.charCodeAt(index2 + 1)) && asciiAlphanumeric(value.charCodeAt(index2 + 2))) {
        skip = 2;
      } else if (code2 < 128) {
        if (!/[!#$&-;=?-Z_a-z~]/.test(String.fromCharCode(code2))) {
          replace2 = String.fromCharCode(code2);
        }
      } else if (code2 > 55295 && code2 < 57344) {
        const next2 = value.charCodeAt(index2 + 1);
        if (code2 < 56320 && next2 > 56319 && next2 < 57344) {
          replace2 = String.fromCharCode(code2, next2);
          skip = 1;
        } else {
          replace2 = "\uFFFD";
        }
      } else {
        replace2 = String.fromCharCode(code2);
      }
      if (replace2) {
        result.push(value.slice(start2, index2), encodeURIComponent(replace2));
        start2 = index2 + skip + 1;
        replace2 = "";
      }
      if (skip) {
        index2 += skip;
        skip = 0;
      }
    }
    return result.join("") + value.slice(start2);
  }
  function factorySpace(effects, ok2, type2, max2) {
    const limit2 = max2 ? max2 - 1 : Number.POSITIVE_INFINITY;
    let size2 = 0;
    return start2;
    function start2(code2) {
      if (markdownSpace(code2)) {
        effects.enter(type2);
        return prefix(code2);
      }
      return ok2(code2);
    }
    function prefix(code2) {
      if (markdownSpace(code2) && size2++ < limit2) {
        effects.consume(code2);
        return prefix;
      }
      effects.exit(type2);
      return ok2(code2);
    }
  }
  const content$2 = {
    tokenize: initializeContent
  };
  function initializeContent(effects) {
    const contentStart = effects.attempt(
      this.parser.constructs.contentInitial,
      afterContentStartConstruct,
      paragraphInitial
    );
    let previous2;
    return contentStart;
    function afterContentStartConstruct(code2) {
      if (code2 === null) {
        effects.consume(code2);
        return;
      }
      effects.enter("lineEnding");
      effects.consume(code2);
      effects.exit("lineEnding");
      return factorySpace(effects, contentStart, "linePrefix");
    }
    function paragraphInitial(code2) {
      effects.enter("paragraph");
      return lineStart(code2);
    }
    function lineStart(code2) {
      const token = effects.enter("chunkText", {
        contentType: "text",
        previous: previous2
      });
      if (previous2) {
        previous2.next = token;
      }
      previous2 = token;
      return data2(code2);
    }
    function data2(code2) {
      if (code2 === null) {
        effects.exit("chunkText");
        effects.exit("paragraph");
        effects.consume(code2);
        return;
      }
      if (markdownLineEnding(code2)) {
        effects.consume(code2);
        effects.exit("chunkText");
        return lineStart;
      }
      effects.consume(code2);
      return data2;
    }
  }
  const document$2 = {
    tokenize: initializeDocument
  };
  const containerConstruct = {
    tokenize: tokenizeContainer
  };
  function initializeDocument(effects) {
    const self2 = this;
    const stack = [];
    let continued = 0;
    let childFlow;
    let childToken;
    let lineStartOffset;
    return start2;
    function start2(code2) {
      if (continued < stack.length) {
        const item = stack[continued];
        self2.containerState = item[1];
        return effects.attempt(
          item[0].continuation,
          documentContinue,
          checkNewContainers
        )(code2);
      }
      return checkNewContainers(code2);
    }
    function documentContinue(code2) {
      continued++;
      if (self2.containerState._closeFlow) {
        self2.containerState._closeFlow = void 0;
        if (childFlow) {
          closeFlow();
        }
        const indexBeforeExits = self2.events.length;
        let indexBeforeFlow = indexBeforeExits;
        let point2;
        while (indexBeforeFlow--) {
          if (self2.events[indexBeforeFlow][0] === "exit" && self2.events[indexBeforeFlow][1].type === "chunkFlow") {
            point2 = self2.events[indexBeforeFlow][1].end;
            break;
          }
        }
        exitContainers(continued);
        let index2 = indexBeforeExits;
        while (index2 < self2.events.length) {
          self2.events[index2][1].end = Object.assign({}, point2);
          index2++;
        }
        splice$1(
          self2.events,
          indexBeforeFlow + 1,
          0,
          self2.events.slice(indexBeforeExits)
        );
        self2.events.length = index2;
        return checkNewContainers(code2);
      }
      return start2(code2);
    }
    function checkNewContainers(code2) {
      if (continued === stack.length) {
        if (!childFlow) {
          return documentContinued(code2);
        }
        if (childFlow.currentConstruct && childFlow.currentConstruct.concrete) {
          return flowStart(code2);
        }
        self2.interrupt = Boolean(
          childFlow.currentConstruct && !childFlow._gfmTableDynamicInterruptHack
        );
      }
      self2.containerState = {};
      return effects.check(
        containerConstruct,
        thereIsANewContainer,
        thereIsNoNewContainer
      )(code2);
    }
    function thereIsANewContainer(code2) {
      if (childFlow)
        closeFlow();
      exitContainers(continued);
      return documentContinued(code2);
    }
    function thereIsNoNewContainer(code2) {
      self2.parser.lazy[self2.now().line] = continued !== stack.length;
      lineStartOffset = self2.now().offset;
      return flowStart(code2);
    }
    function documentContinued(code2) {
      self2.containerState = {};
      return effects.attempt(
        containerConstruct,
        containerContinue,
        flowStart
      )(code2);
    }
    function containerContinue(code2) {
      continued++;
      stack.push([self2.currentConstruct, self2.containerState]);
      return documentContinued(code2);
    }
    function flowStart(code2) {
      if (code2 === null) {
        if (childFlow)
          closeFlow();
        exitContainers(0);
        effects.consume(code2);
        return;
      }
      childFlow = childFlow || self2.parser.flow(self2.now());
      effects.enter("chunkFlow", {
        contentType: "flow",
        previous: childToken,
        _tokenizer: childFlow
      });
      return flowContinue(code2);
    }
    function flowContinue(code2) {
      if (code2 === null) {
        writeToChild(effects.exit("chunkFlow"), true);
        exitContainers(0);
        effects.consume(code2);
        return;
      }
      if (markdownLineEnding(code2)) {
        effects.consume(code2);
        writeToChild(effects.exit("chunkFlow"));
        continued = 0;
        self2.interrupt = void 0;
        return start2;
      }
      effects.consume(code2);
      return flowContinue;
    }
    function writeToChild(token, eof2) {
      const stream = self2.sliceStream(token);
      if (eof2)
        stream.push(null);
      token.previous = childToken;
      if (childToken)
        childToken.next = token;
      childToken = token;
      childFlow.defineSkip(token.start);
      childFlow.write(stream);
      if (self2.parser.lazy[token.start.line]) {
        let index2 = childFlow.events.length;
        while (index2--) {
          if (childFlow.events[index2][1].start.offset < lineStartOffset && (!childFlow.events[index2][1].end || childFlow.events[index2][1].end.offset > lineStartOffset)) {
            return;
          }
        }
        const indexBeforeExits = self2.events.length;
        let indexBeforeFlow = indexBeforeExits;
        let seen;
        let point2;
        while (indexBeforeFlow--) {
          if (self2.events[indexBeforeFlow][0] === "exit" && self2.events[indexBeforeFlow][1].type === "chunkFlow") {
            if (seen) {
              point2 = self2.events[indexBeforeFlow][1].end;
              break;
            }
            seen = true;
          }
        }
        exitContainers(continued);
        index2 = indexBeforeExits;
        while (index2 < self2.events.length) {
          self2.events[index2][1].end = Object.assign({}, point2);
          index2++;
        }
        splice$1(
          self2.events,
          indexBeforeFlow + 1,
          0,
          self2.events.slice(indexBeforeExits)
        );
        self2.events.length = index2;
      }
    }
    function exitContainers(size2) {
      let index2 = stack.length;
      while (index2-- > size2) {
        const entry = stack[index2];
        self2.containerState = entry[1];
        entry[0].exit.call(self2, effects);
      }
      stack.length = size2;
    }
    function closeFlow() {
      childFlow.write([null]);
      childToken = void 0;
      childFlow = void 0;
      self2.containerState._closeFlow = void 0;
    }
  }
  function tokenizeContainer(effects, ok2, nok) {
    return factorySpace(
      effects,
      effects.attempt(this.parser.constructs.document, ok2, nok),
      "linePrefix",
      this.parser.constructs.disable.null.includes("codeIndented") ? void 0 : 4
    );
  }
  function classifyCharacter(code2) {
    if (code2 === null || markdownLineEndingOrSpace(code2) || unicodeWhitespace(code2)) {
      return 1;
    }
    if (unicodePunctuation(code2)) {
      return 2;
    }
  }
  function resolveAll(constructs2, events2, context2) {
    const called = [];
    let index2 = -1;
    while (++index2 < constructs2.length) {
      const resolve2 = constructs2[index2].resolveAll;
      if (resolve2 && !called.includes(resolve2)) {
        events2 = resolve2(events2, context2);
        called.push(resolve2);
      }
    }
    return events2;
  }
  const attention = {
    name: "attention",
    tokenize: tokenizeAttention,
    resolveAll: resolveAllAttention
  };
  function resolveAllAttention(events2, context2) {
    let index2 = -1;
    let open;
    let group;
    let text2;
    let openingSequence;
    let closingSequence;
    let use;
    let nextEvents;
    let offset2;
    while (++index2 < events2.length) {
      if (events2[index2][0] === "enter" && events2[index2][1].type === "attentionSequence" && events2[index2][1]._close) {
        open = index2;
        while (open--) {
          if (events2[open][0] === "exit" && events2[open][1].type === "attentionSequence" && events2[open][1]._open && context2.sliceSerialize(events2[open][1]).charCodeAt(0) === context2.sliceSerialize(events2[index2][1]).charCodeAt(0)) {
            if ((events2[open][1]._close || events2[index2][1]._open) && (events2[index2][1].end.offset - events2[index2][1].start.offset) % 3 && !((events2[open][1].end.offset - events2[open][1].start.offset + events2[index2][1].end.offset - events2[index2][1].start.offset) % 3)) {
              continue;
            }
            use = events2[open][1].end.offset - events2[open][1].start.offset > 1 && events2[index2][1].end.offset - events2[index2][1].start.offset > 1 ? 2 : 1;
            const start2 = Object.assign({}, events2[open][1].end);
            const end2 = Object.assign({}, events2[index2][1].start);
            movePoint(start2, -use);
            movePoint(end2, use);
            openingSequence = {
              type: use > 1 ? "strongSequence" : "emphasisSequence",
              start: start2,
              end: Object.assign({}, events2[open][1].end)
            };
            closingSequence = {
              type: use > 1 ? "strongSequence" : "emphasisSequence",
              start: Object.assign({}, events2[index2][1].start),
              end: end2
            };
            text2 = {
              type: use > 1 ? "strongText" : "emphasisText",
              start: Object.assign({}, events2[open][1].end),
              end: Object.assign({}, events2[index2][1].start)
            };
            group = {
              type: use > 1 ? "strong" : "emphasis",
              start: Object.assign({}, openingSequence.start),
              end: Object.assign({}, closingSequence.end)
            };
            events2[open][1].end = Object.assign({}, openingSequence.start);
            events2[index2][1].start = Object.assign({}, closingSequence.end);
            nextEvents = [];
            if (events2[open][1].end.offset - events2[open][1].start.offset) {
              nextEvents = push$2(nextEvents, [["enter", events2[open][1], context2], ["exit", events2[open][1], context2]]);
            }
            nextEvents = push$2(nextEvents, [["enter", group, context2], ["enter", openingSequence, context2], ["exit", openingSequence, context2], ["enter", text2, context2]]);
            nextEvents = push$2(nextEvents, resolveAll(context2.parser.constructs.insideSpan.null, events2.slice(open + 1, index2), context2));
            nextEvents = push$2(nextEvents, [["exit", text2, context2], ["enter", closingSequence, context2], ["exit", closingSequence, context2], ["exit", group, context2]]);
            if (events2[index2][1].end.offset - events2[index2][1].start.offset) {
              offset2 = 2;
              nextEvents = push$2(nextEvents, [["enter", events2[index2][1], context2], ["exit", events2[index2][1], context2]]);
            } else {
              offset2 = 0;
            }
            splice$1(events2, open - 1, index2 - open + 3, nextEvents);
            index2 = open + nextEvents.length - offset2 - 2;
            break;
          }
        }
      }
    }
    index2 = -1;
    while (++index2 < events2.length) {
      if (events2[index2][1].type === "attentionSequence") {
        events2[index2][1].type = "data";
      }
    }
    return events2;
  }
  function tokenizeAttention(effects, ok2) {
    const attentionMarkers2 = this.parser.constructs.attentionMarkers.null;
    const previous2 = this.previous;
    const before = classifyCharacter(previous2);
    let marker;
    return start2;
    function start2(code2) {
      marker = code2;
      effects.enter("attentionSequence");
      return inside2(code2);
    }
    function inside2(code2) {
      if (code2 === marker) {
        effects.consume(code2);
        return inside2;
      }
      const token = effects.exit("attentionSequence");
      const after = classifyCharacter(code2);
      const open = !after || after === 2 && before || attentionMarkers2.includes(code2);
      const close = !before || before === 2 && after || attentionMarkers2.includes(previous2);
      token._open = Boolean(marker === 42 ? open : open && (before || !close));
      token._close = Boolean(marker === 42 ? close : close && (after || !open));
      return ok2(code2);
    }
  }
  function movePoint(point2, offset2) {
    point2.column += offset2;
    point2.offset += offset2;
    point2._bufferIndex += offset2;
  }
  const autolink = {
    name: "autolink",
    tokenize: tokenizeAutolink
  };
  function tokenizeAutolink(effects, ok2, nok) {
    let size2 = 0;
    return start2;
    function start2(code2) {
      effects.enter("autolink");
      effects.enter("autolinkMarker");
      effects.consume(code2);
      effects.exit("autolinkMarker");
      effects.enter("autolinkProtocol");
      return open;
    }
    function open(code2) {
      if (asciiAlpha(code2)) {
        effects.consume(code2);
        return schemeOrEmailAtext;
      }
      if (code2 === 64) {
        return nok(code2);
      }
      return emailAtext(code2);
    }
    function schemeOrEmailAtext(code2) {
      if (code2 === 43 || code2 === 45 || code2 === 46 || asciiAlphanumeric(code2)) {
        size2 = 1;
        return schemeInsideOrEmailAtext(code2);
      }
      return emailAtext(code2);
    }
    function schemeInsideOrEmailAtext(code2) {
      if (code2 === 58) {
        effects.consume(code2);
        size2 = 0;
        return urlInside;
      }
      if ((code2 === 43 || code2 === 45 || code2 === 46 || asciiAlphanumeric(code2)) && size2++ < 32) {
        effects.consume(code2);
        return schemeInsideOrEmailAtext;
      }
      size2 = 0;
      return emailAtext(code2);
    }
    function urlInside(code2) {
      if (code2 === 62) {
        effects.exit("autolinkProtocol");
        effects.enter("autolinkMarker");
        effects.consume(code2);
        effects.exit("autolinkMarker");
        effects.exit("autolink");
        return ok2;
      }
      if (code2 === null || code2 === 32 || code2 === 60 || asciiControl(code2)) {
        return nok(code2);
      }
      effects.consume(code2);
      return urlInside;
    }
    function emailAtext(code2) {
      if (code2 === 64) {
        effects.consume(code2);
        return emailAtSignOrDot;
      }
      if (asciiAtext(code2)) {
        effects.consume(code2);
        return emailAtext;
      }
      return nok(code2);
    }
    function emailAtSignOrDot(code2) {
      return asciiAlphanumeric(code2) ? emailLabel(code2) : nok(code2);
    }
    function emailLabel(code2) {
      if (code2 === 46) {
        effects.consume(code2);
        size2 = 0;
        return emailAtSignOrDot;
      }
      if (code2 === 62) {
        effects.exit("autolinkProtocol").type = "autolinkEmail";
        effects.enter("autolinkMarker");
        effects.consume(code2);
        effects.exit("autolinkMarker");
        effects.exit("autolink");
        return ok2;
      }
      return emailValue(code2);
    }
    function emailValue(code2) {
      if ((code2 === 45 || asciiAlphanumeric(code2)) && size2++ < 63) {
        const next2 = code2 === 45 ? emailValue : emailLabel;
        effects.consume(code2);
        return next2;
      }
      return nok(code2);
    }
  }
  const blankLine = {
    tokenize: tokenizeBlankLine,
    partial: true
  };
  function tokenizeBlankLine(effects, ok2, nok) {
    return start2;
    function start2(code2) {
      return markdownSpace(code2) ? factorySpace(effects, after, "linePrefix")(code2) : after(code2);
    }
    function after(code2) {
      return code2 === null || markdownLineEnding(code2) ? ok2(code2) : nok(code2);
    }
  }
  const blockQuote = {
    name: "blockQuote",
    tokenize: tokenizeBlockQuoteStart,
    continuation: {
      tokenize: tokenizeBlockQuoteContinuation
    },
    exit: exit$1
  };
  function tokenizeBlockQuoteStart(effects, ok2, nok) {
    const self2 = this;
    return start2;
    function start2(code2) {
      if (code2 === 62) {
        const state = self2.containerState;
        if (!state.open) {
          effects.enter("blockQuote", {
            _container: true
          });
          state.open = true;
        }
        effects.enter("blockQuotePrefix");
        effects.enter("blockQuoteMarker");
        effects.consume(code2);
        effects.exit("blockQuoteMarker");
        return after;
      }
      return nok(code2);
    }
    function after(code2) {
      if (markdownSpace(code2)) {
        effects.enter("blockQuotePrefixWhitespace");
        effects.consume(code2);
        effects.exit("blockQuotePrefixWhitespace");
        effects.exit("blockQuotePrefix");
        return ok2;
      }
      effects.exit("blockQuotePrefix");
      return ok2(code2);
    }
  }
  function tokenizeBlockQuoteContinuation(effects, ok2, nok) {
    const self2 = this;
    return contStart;
    function contStart(code2) {
      if (markdownSpace(code2)) {
        return factorySpace(effects, contBefore, "linePrefix", self2.parser.constructs.disable.null.includes("codeIndented") ? void 0 : 4)(code2);
      }
      return contBefore(code2);
    }
    function contBefore(code2) {
      return effects.attempt(blockQuote, ok2, nok)(code2);
    }
  }
  function exit$1(effects) {
    effects.exit("blockQuote");
  }
  const characterEscape = {
    name: "characterEscape",
    tokenize: tokenizeCharacterEscape
  };
  function tokenizeCharacterEscape(effects, ok2, nok) {
    return start2;
    function start2(code2) {
      effects.enter("characterEscape");
      effects.enter("escapeMarker");
      effects.consume(code2);
      effects.exit("escapeMarker");
      return inside2;
    }
    function inside2(code2) {
      if (asciiPunctuation(code2)) {
        effects.enter("characterEscapeValue");
        effects.consume(code2);
        effects.exit("characterEscapeValue");
        effects.exit("characterEscape");
        return ok2;
      }
      return nok(code2);
    }
  }
  const characterReference = {
    name: "characterReference",
    tokenize: tokenizeCharacterReference
  };
  function tokenizeCharacterReference(effects, ok2, nok) {
    const self2 = this;
    let size2 = 0;
    let max2;
    let test2;
    return start2;
    function start2(code2) {
      effects.enter("characterReference");
      effects.enter("characterReferenceMarker");
      effects.consume(code2);
      effects.exit("characterReferenceMarker");
      return open;
    }
    function open(code2) {
      if (code2 === 35) {
        effects.enter("characterReferenceMarkerNumeric");
        effects.consume(code2);
        effects.exit("characterReferenceMarkerNumeric");
        return numeric2;
      }
      effects.enter("characterReferenceValue");
      max2 = 31;
      test2 = asciiAlphanumeric;
      return value(code2);
    }
    function numeric2(code2) {
      if (code2 === 88 || code2 === 120) {
        effects.enter("characterReferenceMarkerHexadecimal");
        effects.consume(code2);
        effects.exit("characterReferenceMarkerHexadecimal");
        effects.enter("characterReferenceValue");
        max2 = 6;
        test2 = asciiHexDigit;
        return value;
      }
      effects.enter("characterReferenceValue");
      max2 = 7;
      test2 = asciiDigit;
      return value(code2);
    }
    function value(code2) {
      if (code2 === 59 && size2) {
        const token = effects.exit("characterReferenceValue");
        if (test2 === asciiAlphanumeric && !decodeNamedCharacterReference(self2.sliceSerialize(token))) {
          return nok(code2);
        }
        effects.enter("characterReferenceMarker");
        effects.consume(code2);
        effects.exit("characterReferenceMarker");
        effects.exit("characterReference");
        return ok2;
      }
      if (test2(code2) && size2++ < max2) {
        effects.consume(code2);
        return value;
      }
      return nok(code2);
    }
  }
  const nonLazyContinuation = {
    tokenize: tokenizeNonLazyContinuation,
    partial: true
  };
  const codeFenced = {
    name: "codeFenced",
    tokenize: tokenizeCodeFenced,
    concrete: true
  };
  function tokenizeCodeFenced(effects, ok2, nok) {
    const self2 = this;
    const closeStart = {
      tokenize: tokenizeCloseStart,
      partial: true
    };
    let initialPrefix = 0;
    let sizeOpen = 0;
    let marker;
    return start2;
    function start2(code2) {
      return beforeSequenceOpen(code2);
    }
    function beforeSequenceOpen(code2) {
      const tail = self2.events[self2.events.length - 1];
      initialPrefix = tail && tail[1].type === "linePrefix" ? tail[2].sliceSerialize(tail[1], true).length : 0;
      marker = code2;
      effects.enter("codeFenced");
      effects.enter("codeFencedFence");
      effects.enter("codeFencedFenceSequence");
      return sequenceOpen(code2);
    }
    function sequenceOpen(code2) {
      if (code2 === marker) {
        sizeOpen++;
        effects.consume(code2);
        return sequenceOpen;
      }
      if (sizeOpen < 3) {
        return nok(code2);
      }
      effects.exit("codeFencedFenceSequence");
      return markdownSpace(code2) ? factorySpace(effects, infoBefore, "whitespace")(code2) : infoBefore(code2);
    }
    function infoBefore(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("codeFencedFence");
        return self2.interrupt ? ok2(code2) : effects.check(nonLazyContinuation, atNonLazyBreak, after)(code2);
      }
      effects.enter("codeFencedFenceInfo");
      effects.enter("chunkString", {
        contentType: "string"
      });
      return info(code2);
    }
    function info(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("chunkString");
        effects.exit("codeFencedFenceInfo");
        return infoBefore(code2);
      }
      if (markdownSpace(code2)) {
        effects.exit("chunkString");
        effects.exit("codeFencedFenceInfo");
        return factorySpace(effects, metaBefore, "whitespace")(code2);
      }
      if (code2 === 96 && code2 === marker) {
        return nok(code2);
      }
      effects.consume(code2);
      return info;
    }
    function metaBefore(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        return infoBefore(code2);
      }
      effects.enter("codeFencedFenceMeta");
      effects.enter("chunkString", {
        contentType: "string"
      });
      return meta2(code2);
    }
    function meta2(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("chunkString");
        effects.exit("codeFencedFenceMeta");
        return infoBefore(code2);
      }
      if (code2 === 96 && code2 === marker) {
        return nok(code2);
      }
      effects.consume(code2);
      return meta2;
    }
    function atNonLazyBreak(code2) {
      return effects.attempt(closeStart, after, contentBefore)(code2);
    }
    function contentBefore(code2) {
      effects.enter("lineEnding");
      effects.consume(code2);
      effects.exit("lineEnding");
      return contentStart;
    }
    function contentStart(code2) {
      return initialPrefix > 0 && markdownSpace(code2) ? factorySpace(effects, beforeContentChunk, "linePrefix", initialPrefix + 1)(code2) : beforeContentChunk(code2);
    }
    function beforeContentChunk(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        return effects.check(nonLazyContinuation, atNonLazyBreak, after)(code2);
      }
      effects.enter("codeFlowValue");
      return contentChunk(code2);
    }
    function contentChunk(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("codeFlowValue");
        return beforeContentChunk(code2);
      }
      effects.consume(code2);
      return contentChunk;
    }
    function after(code2) {
      effects.exit("codeFenced");
      return ok2(code2);
    }
    function tokenizeCloseStart(effects2, ok3, nok2) {
      let size2 = 0;
      return startBefore;
      function startBefore(code2) {
        effects2.enter("lineEnding");
        effects2.consume(code2);
        effects2.exit("lineEnding");
        return start3;
      }
      function start3(code2) {
        effects2.enter("codeFencedFence");
        return markdownSpace(code2) ? factorySpace(effects2, beforeSequenceClose, "linePrefix", self2.parser.constructs.disable.null.includes("codeIndented") ? void 0 : 4)(code2) : beforeSequenceClose(code2);
      }
      function beforeSequenceClose(code2) {
        if (code2 === marker) {
          effects2.enter("codeFencedFenceSequence");
          return sequenceClose(code2);
        }
        return nok2(code2);
      }
      function sequenceClose(code2) {
        if (code2 === marker) {
          size2++;
          effects2.consume(code2);
          return sequenceClose;
        }
        if (size2 >= sizeOpen) {
          effects2.exit("codeFencedFenceSequence");
          return markdownSpace(code2) ? factorySpace(effects2, sequenceCloseAfter, "whitespace")(code2) : sequenceCloseAfter(code2);
        }
        return nok2(code2);
      }
      function sequenceCloseAfter(code2) {
        if (code2 === null || markdownLineEnding(code2)) {
          effects2.exit("codeFencedFence");
          return ok3(code2);
        }
        return nok2(code2);
      }
    }
  }
  function tokenizeNonLazyContinuation(effects, ok2, nok) {
    const self2 = this;
    return start2;
    function start2(code2) {
      if (code2 === null) {
        return nok(code2);
      }
      effects.enter("lineEnding");
      effects.consume(code2);
      effects.exit("lineEnding");
      return lineStart;
    }
    function lineStart(code2) {
      return self2.parser.lazy[self2.now().line] ? nok(code2) : ok2(code2);
    }
  }
  const codeIndented = {
    name: "codeIndented",
    tokenize: tokenizeCodeIndented
  };
  const furtherStart = {
    tokenize: tokenizeFurtherStart,
    partial: true
  };
  function tokenizeCodeIndented(effects, ok2, nok) {
    const self2 = this;
    return start2;
    function start2(code2) {
      effects.enter("codeIndented");
      return factorySpace(effects, afterPrefix, "linePrefix", 4 + 1)(code2);
    }
    function afterPrefix(code2) {
      const tail = self2.events[self2.events.length - 1];
      return tail && tail[1].type === "linePrefix" && tail[2].sliceSerialize(tail[1], true).length >= 4 ? atBreak(code2) : nok(code2);
    }
    function atBreak(code2) {
      if (code2 === null) {
        return after(code2);
      }
      if (markdownLineEnding(code2)) {
        return effects.attempt(furtherStart, atBreak, after)(code2);
      }
      effects.enter("codeFlowValue");
      return inside2(code2);
    }
    function inside2(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("codeFlowValue");
        return atBreak(code2);
      }
      effects.consume(code2);
      return inside2;
    }
    function after(code2) {
      effects.exit("codeIndented");
      return ok2(code2);
    }
  }
  function tokenizeFurtherStart(effects, ok2, nok) {
    const self2 = this;
    return furtherStart2;
    function furtherStart2(code2) {
      if (self2.parser.lazy[self2.now().line]) {
        return nok(code2);
      }
      if (markdownLineEnding(code2)) {
        effects.enter("lineEnding");
        effects.consume(code2);
        effects.exit("lineEnding");
        return furtherStart2;
      }
      return factorySpace(effects, afterPrefix, "linePrefix", 4 + 1)(code2);
    }
    function afterPrefix(code2) {
      const tail = self2.events[self2.events.length - 1];
      return tail && tail[1].type === "linePrefix" && tail[2].sliceSerialize(tail[1], true).length >= 4 ? ok2(code2) : markdownLineEnding(code2) ? furtherStart2(code2) : nok(code2);
    }
  }
  const codeText = {
    name: "codeText",
    tokenize: tokenizeCodeText,
    resolve: resolveCodeText,
    previous: previous$1
  };
  function resolveCodeText(events2) {
    let tailExitIndex = events2.length - 4;
    let headEnterIndex = 3;
    let index2;
    let enter;
    if ((events2[headEnterIndex][1].type === "lineEnding" || events2[headEnterIndex][1].type === "space") && (events2[tailExitIndex][1].type === "lineEnding" || events2[tailExitIndex][1].type === "space")) {
      index2 = headEnterIndex;
      while (++index2 < tailExitIndex) {
        if (events2[index2][1].type === "codeTextData") {
          events2[headEnterIndex][1].type = "codeTextPadding";
          events2[tailExitIndex][1].type = "codeTextPadding";
          headEnterIndex += 2;
          tailExitIndex -= 2;
          break;
        }
      }
    }
    index2 = headEnterIndex - 1;
    tailExitIndex++;
    while (++index2 <= tailExitIndex) {
      if (enter === void 0) {
        if (index2 !== tailExitIndex && events2[index2][1].type !== "lineEnding") {
          enter = index2;
        }
      } else if (index2 === tailExitIndex || events2[index2][1].type === "lineEnding") {
        events2[enter][1].type = "codeTextData";
        if (index2 !== enter + 2) {
          events2[enter][1].end = events2[index2 - 1][1].end;
          events2.splice(enter + 2, index2 - enter - 2);
          tailExitIndex -= index2 - enter - 2;
          index2 = enter + 2;
        }
        enter = void 0;
      }
    }
    return events2;
  }
  function previous$1(code2) {
    return code2 !== 96 || this.events[this.events.length - 1][1].type === "characterEscape";
  }
  function tokenizeCodeText(effects, ok2, nok) {
    let sizeOpen = 0;
    let size2;
    let token;
    return start2;
    function start2(code2) {
      effects.enter("codeText");
      effects.enter("codeTextSequence");
      return sequenceOpen(code2);
    }
    function sequenceOpen(code2) {
      if (code2 === 96) {
        effects.consume(code2);
        sizeOpen++;
        return sequenceOpen;
      }
      effects.exit("codeTextSequence");
      return between(code2);
    }
    function between(code2) {
      if (code2 === null) {
        return nok(code2);
      }
      if (code2 === 32) {
        effects.enter("space");
        effects.consume(code2);
        effects.exit("space");
        return between;
      }
      if (code2 === 96) {
        token = effects.enter("codeTextSequence");
        size2 = 0;
        return sequenceClose(code2);
      }
      if (markdownLineEnding(code2)) {
        effects.enter("lineEnding");
        effects.consume(code2);
        effects.exit("lineEnding");
        return between;
      }
      effects.enter("codeTextData");
      return data2(code2);
    }
    function data2(code2) {
      if (code2 === null || code2 === 32 || code2 === 96 || markdownLineEnding(code2)) {
        effects.exit("codeTextData");
        return between(code2);
      }
      effects.consume(code2);
      return data2;
    }
    function sequenceClose(code2) {
      if (code2 === 96) {
        effects.consume(code2);
        size2++;
        return sequenceClose;
      }
      if (size2 === sizeOpen) {
        effects.exit("codeTextSequence");
        effects.exit("codeText");
        return ok2(code2);
      }
      token.type = "codeTextData";
      return data2(code2);
    }
  }
  class SpliceBuffer {
    constructor(initial2) {
      this.left = initial2 ? [...initial2] : [];
      this.right = [];
    }
    get(index2) {
      if (index2 < 0 || index2 >= this.left.length + this.right.length) {
        throw new RangeError("Cannot access index `" + index2 + "` in a splice buffer of size `" + (this.left.length + this.right.length) + "`");
      }
      if (index2 < this.left.length)
        return this.left[index2];
      return this.right[this.right.length - index2 + this.left.length - 1];
    }
    get length() {
      return this.left.length + this.right.length;
    }
    shift() {
      this.setCursor(0);
      return this.right.pop();
    }
    slice(start2, end2) {
      const stop = end2 === null || end2 === void 0 ? Number.POSITIVE_INFINITY : end2;
      if (stop < this.left.length) {
        return this.left.slice(start2, stop);
      }
      if (start2 > this.left.length) {
        return this.right.slice(this.right.length - stop + this.left.length, this.right.length - start2 + this.left.length).reverse();
      }
      return this.left.slice(start2).concat(this.right.slice(this.right.length - stop + this.left.length).reverse());
    }
    splice(start2, deleteCount, items) {
      const count2 = deleteCount || 0;
      this.setCursor(Math.trunc(start2));
      const removed = this.right.splice(this.right.length - count2, Number.POSITIVE_INFINITY);
      if (items)
        chunkedPush(this.left, items);
      return removed.reverse();
    }
    pop() {
      this.setCursor(Number.POSITIVE_INFINITY);
      return this.left.pop();
    }
    push(item) {
      this.setCursor(Number.POSITIVE_INFINITY);
      this.left.push(item);
    }
    pushMany(items) {
      this.setCursor(Number.POSITIVE_INFINITY);
      chunkedPush(this.left, items);
    }
    unshift(item) {
      this.setCursor(0);
      this.right.push(item);
    }
    unshiftMany(items) {
      this.setCursor(0);
      chunkedPush(this.right, items.reverse());
    }
    setCursor(n2) {
      if (n2 === this.left.length || n2 > this.left.length && this.right.length === 0 || n2 < 0 && this.left.length === 0)
        return;
      if (n2 < this.left.length) {
        const removed = this.left.splice(n2, Number.POSITIVE_INFINITY);
        chunkedPush(this.right, removed.reverse());
      } else {
        const removed = this.right.splice(this.left.length + this.right.length - n2, Number.POSITIVE_INFINITY);
        chunkedPush(this.left, removed.reverse());
      }
    }
  }
  function chunkedPush(list2, right2) {
    let chunkStart = 0;
    if (right2.length < 1e4) {
      list2.push(...right2);
    } else {
      while (chunkStart < right2.length) {
        list2.push(...right2.slice(chunkStart, chunkStart + 1e4));
        chunkStart += 1e4;
      }
    }
  }
  function subtokenize(eventsArray) {
    const jumps = {};
    let index2 = -1;
    let event2;
    let lineIndex;
    let otherIndex;
    let otherEvent;
    let parameters;
    let subevents;
    let more;
    const events2 = new SpliceBuffer(eventsArray);
    while (++index2 < events2.length) {
      while (index2 in jumps) {
        index2 = jumps[index2];
      }
      event2 = events2.get(index2);
      if (index2 && event2[1].type === "chunkFlow" && events2.get(index2 - 1)[1].type === "listItemPrefix") {
        subevents = event2[1]._tokenizer.events;
        otherIndex = 0;
        if (otherIndex < subevents.length && subevents[otherIndex][1].type === "lineEndingBlank") {
          otherIndex += 2;
        }
        if (otherIndex < subevents.length && subevents[otherIndex][1].type === "content") {
          while (++otherIndex < subevents.length) {
            if (subevents[otherIndex][1].type === "content") {
              break;
            }
            if (subevents[otherIndex][1].type === "chunkText") {
              subevents[otherIndex][1]._isInFirstContentOfListItem = true;
              otherIndex++;
            }
          }
        }
      }
      if (event2[0] === "enter") {
        if (event2[1].contentType) {
          Object.assign(jumps, subcontent(events2, index2));
          index2 = jumps[index2];
          more = true;
        }
      } else if (event2[1]._container) {
        otherIndex = index2;
        lineIndex = void 0;
        while (otherIndex--) {
          otherEvent = events2.get(otherIndex);
          if (otherEvent[1].type === "lineEnding" || otherEvent[1].type === "lineEndingBlank") {
            if (otherEvent[0] === "enter") {
              if (lineIndex) {
                events2.get(lineIndex)[1].type = "lineEndingBlank";
              }
              otherEvent[1].type = "lineEnding";
              lineIndex = otherIndex;
            }
          } else {
            break;
          }
        }
        if (lineIndex) {
          event2[1].end = Object.assign({}, events2.get(lineIndex)[1].start);
          parameters = events2.slice(lineIndex, index2);
          parameters.unshift(event2);
          events2.splice(lineIndex, index2 - lineIndex + 1, parameters);
        }
      }
    }
    splice$1(eventsArray, 0, Number.POSITIVE_INFINITY, events2.slice(0));
    return !more;
  }
  function subcontent(events2, eventIndex) {
    const token = events2.get(eventIndex)[1];
    const context2 = events2.get(eventIndex)[2];
    let startPosition = eventIndex - 1;
    const startPositions = [];
    const tokenizer2 = token._tokenizer || context2.parser[token.contentType](token.start);
    const childEvents = tokenizer2.events;
    const jumps = [];
    const gaps = {};
    let stream;
    let previous2;
    let index2 = -1;
    let current2 = token;
    let adjust = 0;
    let start2 = 0;
    const breaks = [start2];
    while (current2) {
      while (events2.get(++startPosition)[1] !== current2) {
      }
      startPositions.push(startPosition);
      if (!current2._tokenizer) {
        stream = context2.sliceStream(current2);
        if (!current2.next) {
          stream.push(null);
        }
        if (previous2) {
          tokenizer2.defineSkip(current2.start);
        }
        if (current2._isInFirstContentOfListItem) {
          tokenizer2._gfmTasklistFirstContentOfListItem = true;
        }
        tokenizer2.write(stream);
        if (current2._isInFirstContentOfListItem) {
          tokenizer2._gfmTasklistFirstContentOfListItem = void 0;
        }
      }
      previous2 = current2;
      current2 = current2.next;
    }
    current2 = token;
    while (++index2 < childEvents.length) {
      if (childEvents[index2][0] === "exit" && childEvents[index2 - 1][0] === "enter" && childEvents[index2][1].type === childEvents[index2 - 1][1].type && childEvents[index2][1].start.line !== childEvents[index2][1].end.line) {
        start2 = index2 + 1;
        breaks.push(start2);
        current2._tokenizer = void 0;
        current2.previous = void 0;
        current2 = current2.next;
      }
    }
    tokenizer2.events = [];
    if (current2) {
      current2._tokenizer = void 0;
      current2.previous = void 0;
    } else {
      breaks.pop();
    }
    index2 = breaks.length;
    while (index2--) {
      const slice = childEvents.slice(breaks[index2], breaks[index2 + 1]);
      const start3 = startPositions.pop();
      jumps.push([start3, start3 + slice.length - 1]);
      events2.splice(start3, 2, slice);
    }
    jumps.reverse();
    index2 = -1;
    while (++index2 < jumps.length) {
      gaps[adjust + jumps[index2][0]] = adjust + jumps[index2][1];
      adjust += jumps[index2][1] - jumps[index2][0] - 1;
    }
    return gaps;
  }
  const content$1 = {
    tokenize: tokenizeContent,
    resolve: resolveContent
  };
  const continuationConstruct = {
    tokenize: tokenizeContinuation,
    partial: true
  };
  function resolveContent(events2) {
    subtokenize(events2);
    return events2;
  }
  function tokenizeContent(effects, ok2) {
    let previous2;
    return chunkStart;
    function chunkStart(code2) {
      effects.enter("content");
      previous2 = effects.enter("chunkContent", {
        contentType: "content"
      });
      return chunkInside(code2);
    }
    function chunkInside(code2) {
      if (code2 === null) {
        return contentEnd(code2);
      }
      if (markdownLineEnding(code2)) {
        return effects.check(continuationConstruct, contentContinue, contentEnd)(code2);
      }
      effects.consume(code2);
      return chunkInside;
    }
    function contentEnd(code2) {
      effects.exit("chunkContent");
      effects.exit("content");
      return ok2(code2);
    }
    function contentContinue(code2) {
      effects.consume(code2);
      effects.exit("chunkContent");
      previous2.next = effects.enter("chunkContent", {
        contentType: "content",
        previous: previous2
      });
      previous2 = previous2.next;
      return chunkInside;
    }
  }
  function tokenizeContinuation(effects, ok2, nok) {
    const self2 = this;
    return startLookahead;
    function startLookahead(code2) {
      effects.exit("chunkContent");
      effects.enter("lineEnding");
      effects.consume(code2);
      effects.exit("lineEnding");
      return factorySpace(effects, prefixed, "linePrefix");
    }
    function prefixed(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        return nok(code2);
      }
      const tail = self2.events[self2.events.length - 1];
      if (!self2.parser.constructs.disable.null.includes("codeIndented") && tail && tail[1].type === "linePrefix" && tail[2].sliceSerialize(tail[1], true).length >= 4) {
        return ok2(code2);
      }
      return effects.interrupt(self2.parser.constructs.flow, nok, ok2)(code2);
    }
  }
  function factoryDestination(effects, ok2, nok, type2, literalType, literalMarkerType, rawType, stringType, max2) {
    const limit2 = max2 || Number.POSITIVE_INFINITY;
    let balance = 0;
    return start2;
    function start2(code2) {
      if (code2 === 60) {
        effects.enter(type2);
        effects.enter(literalType);
        effects.enter(literalMarkerType);
        effects.consume(code2);
        effects.exit(literalMarkerType);
        return enclosedBefore;
      }
      if (code2 === null || code2 === 32 || code2 === 41 || asciiControl(code2)) {
        return nok(code2);
      }
      effects.enter(type2);
      effects.enter(rawType);
      effects.enter(stringType);
      effects.enter("chunkString", {
        contentType: "string"
      });
      return raw2(code2);
    }
    function enclosedBefore(code2) {
      if (code2 === 62) {
        effects.enter(literalMarkerType);
        effects.consume(code2);
        effects.exit(literalMarkerType);
        effects.exit(literalType);
        effects.exit(type2);
        return ok2;
      }
      effects.enter(stringType);
      effects.enter("chunkString", {
        contentType: "string"
      });
      return enclosed(code2);
    }
    function enclosed(code2) {
      if (code2 === 62) {
        effects.exit("chunkString");
        effects.exit(stringType);
        return enclosedBefore(code2);
      }
      if (code2 === null || code2 === 60 || markdownLineEnding(code2)) {
        return nok(code2);
      }
      effects.consume(code2);
      return code2 === 92 ? enclosedEscape : enclosed;
    }
    function enclosedEscape(code2) {
      if (code2 === 60 || code2 === 62 || code2 === 92) {
        effects.consume(code2);
        return enclosed;
      }
      return enclosed(code2);
    }
    function raw2(code2) {
      if (!balance && (code2 === null || code2 === 41 || markdownLineEndingOrSpace(code2))) {
        effects.exit("chunkString");
        effects.exit(stringType);
        effects.exit(rawType);
        effects.exit(type2);
        return ok2(code2);
      }
      if (balance < limit2 && code2 === 40) {
        effects.consume(code2);
        balance++;
        return raw2;
      }
      if (code2 === 41) {
        effects.consume(code2);
        balance--;
        return raw2;
      }
      if (code2 === null || code2 === 32 || code2 === 40 || asciiControl(code2)) {
        return nok(code2);
      }
      effects.consume(code2);
      return code2 === 92 ? rawEscape : raw2;
    }
    function rawEscape(code2) {
      if (code2 === 40 || code2 === 41 || code2 === 92) {
        effects.consume(code2);
        return raw2;
      }
      return raw2(code2);
    }
  }
  function factoryLabel(effects, ok2, nok, type2, markerType, stringType) {
    const self2 = this;
    let size2 = 0;
    let seen;
    return start2;
    function start2(code2) {
      effects.enter(type2);
      effects.enter(markerType);
      effects.consume(code2);
      effects.exit(markerType);
      effects.enter(stringType);
      return atBreak;
    }
    function atBreak(code2) {
      if (size2 > 999 || code2 === null || code2 === 91 || code2 === 93 && !seen || code2 === 94 && !size2 && "_hiddenFootnoteSupport" in self2.parser.constructs) {
        return nok(code2);
      }
      if (code2 === 93) {
        effects.exit(stringType);
        effects.enter(markerType);
        effects.consume(code2);
        effects.exit(markerType);
        effects.exit(type2);
        return ok2;
      }
      if (markdownLineEnding(code2)) {
        effects.enter("lineEnding");
        effects.consume(code2);
        effects.exit("lineEnding");
        return atBreak;
      }
      effects.enter("chunkString", {
        contentType: "string"
      });
      return labelInside(code2);
    }
    function labelInside(code2) {
      if (code2 === null || code2 === 91 || code2 === 93 || markdownLineEnding(code2) || size2++ > 999) {
        effects.exit("chunkString");
        return atBreak(code2);
      }
      effects.consume(code2);
      if (!seen)
        seen = !markdownSpace(code2);
      return code2 === 92 ? labelEscape : labelInside;
    }
    function labelEscape(code2) {
      if (code2 === 91 || code2 === 92 || code2 === 93) {
        effects.consume(code2);
        size2++;
        return labelInside;
      }
      return labelInside(code2);
    }
  }
  function factoryTitle(effects, ok2, nok, type2, markerType, stringType) {
    let marker;
    return start2;
    function start2(code2) {
      if (code2 === 34 || code2 === 39 || code2 === 40) {
        effects.enter(type2);
        effects.enter(markerType);
        effects.consume(code2);
        effects.exit(markerType);
        marker = code2 === 40 ? 41 : code2;
        return begin2;
      }
      return nok(code2);
    }
    function begin2(code2) {
      if (code2 === marker) {
        effects.enter(markerType);
        effects.consume(code2);
        effects.exit(markerType);
        effects.exit(type2);
        return ok2;
      }
      effects.enter(stringType);
      return atBreak(code2);
    }
    function atBreak(code2) {
      if (code2 === marker) {
        effects.exit(stringType);
        return begin2(marker);
      }
      if (code2 === null) {
        return nok(code2);
      }
      if (markdownLineEnding(code2)) {
        effects.enter("lineEnding");
        effects.consume(code2);
        effects.exit("lineEnding");
        return factorySpace(effects, atBreak, "linePrefix");
      }
      effects.enter("chunkString", {
        contentType: "string"
      });
      return inside2(code2);
    }
    function inside2(code2) {
      if (code2 === marker || code2 === null || markdownLineEnding(code2)) {
        effects.exit("chunkString");
        return atBreak(code2);
      }
      effects.consume(code2);
      return code2 === 92 ? escape2 : inside2;
    }
    function escape2(code2) {
      if (code2 === marker || code2 === 92) {
        effects.consume(code2);
        return inside2;
      }
      return inside2(code2);
    }
  }
  function factoryWhitespace(effects, ok2) {
    let seen;
    return start2;
    function start2(code2) {
      if (markdownLineEnding(code2)) {
        effects.enter("lineEnding");
        effects.consume(code2);
        effects.exit("lineEnding");
        seen = true;
        return start2;
      }
      if (markdownSpace(code2)) {
        return factorySpace(
          effects,
          start2,
          seen ? "linePrefix" : "lineSuffix"
        )(code2);
      }
      return ok2(code2);
    }
  }
  const definition$1 = {
    name: "definition",
    tokenize: tokenizeDefinition
  };
  const titleBefore = {
    tokenize: tokenizeTitleBefore,
    partial: true
  };
  function tokenizeDefinition(effects, ok2, nok) {
    const self2 = this;
    let identifier;
    return start2;
    function start2(code2) {
      effects.enter("definition");
      return before(code2);
    }
    function before(code2) {
      return factoryLabel.call(
        self2,
        effects,
        labelAfter,
        nok,
        "definitionLabel",
        "definitionLabelMarker",
        "definitionLabelString"
      )(code2);
    }
    function labelAfter(code2) {
      identifier = normalizeIdentifier(self2.sliceSerialize(self2.events[self2.events.length - 1][1]).slice(1, -1));
      if (code2 === 58) {
        effects.enter("definitionMarker");
        effects.consume(code2);
        effects.exit("definitionMarker");
        return markerAfter;
      }
      return nok(code2);
    }
    function markerAfter(code2) {
      return markdownLineEndingOrSpace(code2) ? factoryWhitespace(effects, destinationBefore)(code2) : destinationBefore(code2);
    }
    function destinationBefore(code2) {
      return factoryDestination(
        effects,
        destinationAfter,
        nok,
        "definitionDestination",
        "definitionDestinationLiteral",
        "definitionDestinationLiteralMarker",
        "definitionDestinationRaw",
        "definitionDestinationString"
      )(code2);
    }
    function destinationAfter(code2) {
      return effects.attempt(titleBefore, after, after)(code2);
    }
    function after(code2) {
      return markdownSpace(code2) ? factorySpace(effects, afterWhitespace, "whitespace")(code2) : afterWhitespace(code2);
    }
    function afterWhitespace(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("definition");
        self2.parser.defined.push(identifier);
        return ok2(code2);
      }
      return nok(code2);
    }
  }
  function tokenizeTitleBefore(effects, ok2, nok) {
    return titleBefore2;
    function titleBefore2(code2) {
      return markdownLineEndingOrSpace(code2) ? factoryWhitespace(effects, beforeMarker)(code2) : nok(code2);
    }
    function beforeMarker(code2) {
      return factoryTitle(effects, titleAfter, nok, "definitionTitle", "definitionTitleMarker", "definitionTitleString")(code2);
    }
    function titleAfter(code2) {
      return markdownSpace(code2) ? factorySpace(effects, titleAfterOptionalWhitespace, "whitespace")(code2) : titleAfterOptionalWhitespace(code2);
    }
    function titleAfterOptionalWhitespace(code2) {
      return code2 === null || markdownLineEnding(code2) ? ok2(code2) : nok(code2);
    }
  }
  const hardBreakEscape = {
    name: "hardBreakEscape",
    tokenize: tokenizeHardBreakEscape
  };
  function tokenizeHardBreakEscape(effects, ok2, nok) {
    return start2;
    function start2(code2) {
      effects.enter("hardBreakEscape");
      effects.consume(code2);
      return after;
    }
    function after(code2) {
      if (markdownLineEnding(code2)) {
        effects.exit("hardBreakEscape");
        return ok2(code2);
      }
      return nok(code2);
    }
  }
  const headingAtx = {
    name: "headingAtx",
    tokenize: tokenizeHeadingAtx,
    resolve: resolveHeadingAtx
  };
  function resolveHeadingAtx(events2, context2) {
    let contentEnd = events2.length - 2;
    let contentStart = 3;
    let content2;
    let text2;
    if (events2[contentStart][1].type === "whitespace") {
      contentStart += 2;
    }
    if (contentEnd - 2 > contentStart && events2[contentEnd][1].type === "whitespace") {
      contentEnd -= 2;
    }
    if (events2[contentEnd][1].type === "atxHeadingSequence" && (contentStart === contentEnd - 1 || contentEnd - 4 > contentStart && events2[contentEnd - 2][1].type === "whitespace")) {
      contentEnd -= contentStart + 1 === contentEnd ? 2 : 4;
    }
    if (contentEnd > contentStart) {
      content2 = {
        type: "atxHeadingText",
        start: events2[contentStart][1].start,
        end: events2[contentEnd][1].end
      };
      text2 = {
        type: "chunkText",
        start: events2[contentStart][1].start,
        end: events2[contentEnd][1].end,
        contentType: "text"
      };
      splice$1(events2, contentStart, contentEnd - contentStart + 1, [["enter", content2, context2], ["enter", text2, context2], ["exit", text2, context2], ["exit", content2, context2]]);
    }
    return events2;
  }
  function tokenizeHeadingAtx(effects, ok2, nok) {
    let size2 = 0;
    return start2;
    function start2(code2) {
      effects.enter("atxHeading");
      return before(code2);
    }
    function before(code2) {
      effects.enter("atxHeadingSequence");
      return sequenceOpen(code2);
    }
    function sequenceOpen(code2) {
      if (code2 === 35 && size2++ < 6) {
        effects.consume(code2);
        return sequenceOpen;
      }
      if (code2 === null || markdownLineEndingOrSpace(code2)) {
        effects.exit("atxHeadingSequence");
        return atBreak(code2);
      }
      return nok(code2);
    }
    function atBreak(code2) {
      if (code2 === 35) {
        effects.enter("atxHeadingSequence");
        return sequenceFurther(code2);
      }
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("atxHeading");
        return ok2(code2);
      }
      if (markdownSpace(code2)) {
        return factorySpace(effects, atBreak, "whitespace")(code2);
      }
      effects.enter("atxHeadingText");
      return data2(code2);
    }
    function sequenceFurther(code2) {
      if (code2 === 35) {
        effects.consume(code2);
        return sequenceFurther;
      }
      effects.exit("atxHeadingSequence");
      return atBreak(code2);
    }
    function data2(code2) {
      if (code2 === null || code2 === 35 || markdownLineEndingOrSpace(code2)) {
        effects.exit("atxHeadingText");
        return atBreak(code2);
      }
      effects.consume(code2);
      return data2;
    }
  }
  const htmlBlockNames = [
    "address",
    "article",
    "aside",
    "base",
    "basefont",
    "blockquote",
    "body",
    "caption",
    "center",
    "col",
    "colgroup",
    "dd",
    "details",
    "dialog",
    "dir",
    "div",
    "dl",
    "dt",
    "fieldset",
    "figcaption",
    "figure",
    "footer",
    "form",
    "frame",
    "frameset",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "head",
    "header",
    "hr",
    "html",
    "iframe",
    "legend",
    "li",
    "link",
    "main",
    "menu",
    "menuitem",
    "nav",
    "noframes",
    "ol",
    "optgroup",
    "option",
    "p",
    "param",
    "search",
    "section",
    "summary",
    "table",
    "tbody",
    "td",
    "tfoot",
    "th",
    "thead",
    "title",
    "tr",
    "track",
    "ul"
  ];
  const htmlRawNames = ["pre", "script", "style", "textarea"];
  const htmlFlow = {
    name: "htmlFlow",
    tokenize: tokenizeHtmlFlow,
    resolveTo: resolveToHtmlFlow,
    concrete: true
  };
  const blankLineBefore = {
    tokenize: tokenizeBlankLineBefore,
    partial: true
  };
  const nonLazyContinuationStart = {
    tokenize: tokenizeNonLazyContinuationStart,
    partial: true
  };
  function resolveToHtmlFlow(events2) {
    let index2 = events2.length;
    while (index2--) {
      if (events2[index2][0] === "enter" && events2[index2][1].type === "htmlFlow") {
        break;
      }
    }
    if (index2 > 1 && events2[index2 - 2][1].type === "linePrefix") {
      events2[index2][1].start = events2[index2 - 2][1].start;
      events2[index2 + 1][1].start = events2[index2 - 2][1].start;
      events2.splice(index2 - 2, 2);
    }
    return events2;
  }
  function tokenizeHtmlFlow(effects, ok2, nok) {
    const self2 = this;
    let marker;
    let closingTag;
    let buffer;
    let index2;
    let markerB;
    return start2;
    function start2(code2) {
      return before(code2);
    }
    function before(code2) {
      effects.enter("htmlFlow");
      effects.enter("htmlFlowData");
      effects.consume(code2);
      return open;
    }
    function open(code2) {
      if (code2 === 33) {
        effects.consume(code2);
        return declarationOpen;
      }
      if (code2 === 47) {
        effects.consume(code2);
        closingTag = true;
        return tagCloseStart;
      }
      if (code2 === 63) {
        effects.consume(code2);
        marker = 3;
        return self2.interrupt ? ok2 : continuationDeclarationInside;
      }
      if (asciiAlpha(code2)) {
        effects.consume(code2);
        buffer = String.fromCharCode(code2);
        return tagName;
      }
      return nok(code2);
    }
    function declarationOpen(code2) {
      if (code2 === 45) {
        effects.consume(code2);
        marker = 2;
        return commentOpenInside;
      }
      if (code2 === 91) {
        effects.consume(code2);
        marker = 5;
        index2 = 0;
        return cdataOpenInside;
      }
      if (asciiAlpha(code2)) {
        effects.consume(code2);
        marker = 4;
        return self2.interrupt ? ok2 : continuationDeclarationInside;
      }
      return nok(code2);
    }
    function commentOpenInside(code2) {
      if (code2 === 45) {
        effects.consume(code2);
        return self2.interrupt ? ok2 : continuationDeclarationInside;
      }
      return nok(code2);
    }
    function cdataOpenInside(code2) {
      const value = "CDATA[";
      if (code2 === value.charCodeAt(index2++)) {
        effects.consume(code2);
        if (index2 === value.length) {
          return self2.interrupt ? ok2 : continuation;
        }
        return cdataOpenInside;
      }
      return nok(code2);
    }
    function tagCloseStart(code2) {
      if (asciiAlpha(code2)) {
        effects.consume(code2);
        buffer = String.fromCharCode(code2);
        return tagName;
      }
      return nok(code2);
    }
    function tagName(code2) {
      if (code2 === null || code2 === 47 || code2 === 62 || markdownLineEndingOrSpace(code2)) {
        const slash = code2 === 47;
        const name2 = buffer.toLowerCase();
        if (!slash && !closingTag && htmlRawNames.includes(name2)) {
          marker = 1;
          return self2.interrupt ? ok2(code2) : continuation(code2);
        }
        if (htmlBlockNames.includes(buffer.toLowerCase())) {
          marker = 6;
          if (slash) {
            effects.consume(code2);
            return basicSelfClosing;
          }
          return self2.interrupt ? ok2(code2) : continuation(code2);
        }
        marker = 7;
        return self2.interrupt && !self2.parser.lazy[self2.now().line] ? nok(code2) : closingTag ? completeClosingTagAfter(code2) : completeAttributeNameBefore(code2);
      }
      if (code2 === 45 || asciiAlphanumeric(code2)) {
        effects.consume(code2);
        buffer += String.fromCharCode(code2);
        return tagName;
      }
      return nok(code2);
    }
    function basicSelfClosing(code2) {
      if (code2 === 62) {
        effects.consume(code2);
        return self2.interrupt ? ok2 : continuation;
      }
      return nok(code2);
    }
    function completeClosingTagAfter(code2) {
      if (markdownSpace(code2)) {
        effects.consume(code2);
        return completeClosingTagAfter;
      }
      return completeEnd(code2);
    }
    function completeAttributeNameBefore(code2) {
      if (code2 === 47) {
        effects.consume(code2);
        return completeEnd;
      }
      if (code2 === 58 || code2 === 95 || asciiAlpha(code2)) {
        effects.consume(code2);
        return completeAttributeName;
      }
      if (markdownSpace(code2)) {
        effects.consume(code2);
        return completeAttributeNameBefore;
      }
      return completeEnd(code2);
    }
    function completeAttributeName(code2) {
      if (code2 === 45 || code2 === 46 || code2 === 58 || code2 === 95 || asciiAlphanumeric(code2)) {
        effects.consume(code2);
        return completeAttributeName;
      }
      return completeAttributeNameAfter(code2);
    }
    function completeAttributeNameAfter(code2) {
      if (code2 === 61) {
        effects.consume(code2);
        return completeAttributeValueBefore;
      }
      if (markdownSpace(code2)) {
        effects.consume(code2);
        return completeAttributeNameAfter;
      }
      return completeAttributeNameBefore(code2);
    }
    function completeAttributeValueBefore(code2) {
      if (code2 === null || code2 === 60 || code2 === 61 || code2 === 62 || code2 === 96) {
        return nok(code2);
      }
      if (code2 === 34 || code2 === 39) {
        effects.consume(code2);
        markerB = code2;
        return completeAttributeValueQuoted;
      }
      if (markdownSpace(code2)) {
        effects.consume(code2);
        return completeAttributeValueBefore;
      }
      return completeAttributeValueUnquoted(code2);
    }
    function completeAttributeValueQuoted(code2) {
      if (code2 === markerB) {
        effects.consume(code2);
        markerB = null;
        return completeAttributeValueQuotedAfter;
      }
      if (code2 === null || markdownLineEnding(code2)) {
        return nok(code2);
      }
      effects.consume(code2);
      return completeAttributeValueQuoted;
    }
    function completeAttributeValueUnquoted(code2) {
      if (code2 === null || code2 === 34 || code2 === 39 || code2 === 47 || code2 === 60 || code2 === 61 || code2 === 62 || code2 === 96 || markdownLineEndingOrSpace(code2)) {
        return completeAttributeNameAfter(code2);
      }
      effects.consume(code2);
      return completeAttributeValueUnquoted;
    }
    function completeAttributeValueQuotedAfter(code2) {
      if (code2 === 47 || code2 === 62 || markdownSpace(code2)) {
        return completeAttributeNameBefore(code2);
      }
      return nok(code2);
    }
    function completeEnd(code2) {
      if (code2 === 62) {
        effects.consume(code2);
        return completeAfter;
      }
      return nok(code2);
    }
    function completeAfter(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        return continuation(code2);
      }
      if (markdownSpace(code2)) {
        effects.consume(code2);
        return completeAfter;
      }
      return nok(code2);
    }
    function continuation(code2) {
      if (code2 === 45 && marker === 2) {
        effects.consume(code2);
        return continuationCommentInside;
      }
      if (code2 === 60 && marker === 1) {
        effects.consume(code2);
        return continuationRawTagOpen;
      }
      if (code2 === 62 && marker === 4) {
        effects.consume(code2);
        return continuationClose;
      }
      if (code2 === 63 && marker === 3) {
        effects.consume(code2);
        return continuationDeclarationInside;
      }
      if (code2 === 93 && marker === 5) {
        effects.consume(code2);
        return continuationCdataInside;
      }
      if (markdownLineEnding(code2) && (marker === 6 || marker === 7)) {
        effects.exit("htmlFlowData");
        return effects.check(blankLineBefore, continuationAfter, continuationStart)(code2);
      }
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("htmlFlowData");
        return continuationStart(code2);
      }
      effects.consume(code2);
      return continuation;
    }
    function continuationStart(code2) {
      return effects.check(nonLazyContinuationStart, continuationStartNonLazy, continuationAfter)(code2);
    }
    function continuationStartNonLazy(code2) {
      effects.enter("lineEnding");
      effects.consume(code2);
      effects.exit("lineEnding");
      return continuationBefore;
    }
    function continuationBefore(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        return continuationStart(code2);
      }
      effects.enter("htmlFlowData");
      return continuation(code2);
    }
    function continuationCommentInside(code2) {
      if (code2 === 45) {
        effects.consume(code2);
        return continuationDeclarationInside;
      }
      return continuation(code2);
    }
    function continuationRawTagOpen(code2) {
      if (code2 === 47) {
        effects.consume(code2);
        buffer = "";
        return continuationRawEndTag;
      }
      return continuation(code2);
    }
    function continuationRawEndTag(code2) {
      if (code2 === 62) {
        const name2 = buffer.toLowerCase();
        if (htmlRawNames.includes(name2)) {
          effects.consume(code2);
          return continuationClose;
        }
        return continuation(code2);
      }
      if (asciiAlpha(code2) && buffer.length < 8) {
        effects.consume(code2);
        buffer += String.fromCharCode(code2);
        return continuationRawEndTag;
      }
      return continuation(code2);
    }
    function continuationCdataInside(code2) {
      if (code2 === 93) {
        effects.consume(code2);
        return continuationDeclarationInside;
      }
      return continuation(code2);
    }
    function continuationDeclarationInside(code2) {
      if (code2 === 62) {
        effects.consume(code2);
        return continuationClose;
      }
      if (code2 === 45 && marker === 2) {
        effects.consume(code2);
        return continuationDeclarationInside;
      }
      return continuation(code2);
    }
    function continuationClose(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("htmlFlowData");
        return continuationAfter(code2);
      }
      effects.consume(code2);
      return continuationClose;
    }
    function continuationAfter(code2) {
      effects.exit("htmlFlow");
      return ok2(code2);
    }
  }
  function tokenizeNonLazyContinuationStart(effects, ok2, nok) {
    const self2 = this;
    return start2;
    function start2(code2) {
      if (markdownLineEnding(code2)) {
        effects.enter("lineEnding");
        effects.consume(code2);
        effects.exit("lineEnding");
        return after;
      }
      return nok(code2);
    }
    function after(code2) {
      return self2.parser.lazy[self2.now().line] ? nok(code2) : ok2(code2);
    }
  }
  function tokenizeBlankLineBefore(effects, ok2, nok) {
    return start2;
    function start2(code2) {
      effects.enter("lineEnding");
      effects.consume(code2);
      effects.exit("lineEnding");
      return effects.attempt(blankLine, ok2, nok);
    }
  }
  const htmlText = {
    name: "htmlText",
    tokenize: tokenizeHtmlText
  };
  function tokenizeHtmlText(effects, ok2, nok) {
    const self2 = this;
    let marker;
    let index2;
    let returnState;
    return start2;
    function start2(code2) {
      effects.enter("htmlText");
      effects.enter("htmlTextData");
      effects.consume(code2);
      return open;
    }
    function open(code2) {
      if (code2 === 33) {
        effects.consume(code2);
        return declarationOpen;
      }
      if (code2 === 47) {
        effects.consume(code2);
        return tagCloseStart;
      }
      if (code2 === 63) {
        effects.consume(code2);
        return instruction;
      }
      if (asciiAlpha(code2)) {
        effects.consume(code2);
        return tagOpen;
      }
      return nok(code2);
    }
    function declarationOpen(code2) {
      if (code2 === 45) {
        effects.consume(code2);
        return commentOpenInside;
      }
      if (code2 === 91) {
        effects.consume(code2);
        index2 = 0;
        return cdataOpenInside;
      }
      if (asciiAlpha(code2)) {
        effects.consume(code2);
        return declaration;
      }
      return nok(code2);
    }
    function commentOpenInside(code2) {
      if (code2 === 45) {
        effects.consume(code2);
        return commentEnd;
      }
      return nok(code2);
    }
    function comment2(code2) {
      if (code2 === null) {
        return nok(code2);
      }
      if (code2 === 45) {
        effects.consume(code2);
        return commentClose;
      }
      if (markdownLineEnding(code2)) {
        returnState = comment2;
        return lineEndingBefore(code2);
      }
      effects.consume(code2);
      return comment2;
    }
    function commentClose(code2) {
      if (code2 === 45) {
        effects.consume(code2);
        return commentEnd;
      }
      return comment2(code2);
    }
    function commentEnd(code2) {
      return code2 === 62 ? end2(code2) : code2 === 45 ? commentClose(code2) : comment2(code2);
    }
    function cdataOpenInside(code2) {
      const value = "CDATA[";
      if (code2 === value.charCodeAt(index2++)) {
        effects.consume(code2);
        return index2 === value.length ? cdata : cdataOpenInside;
      }
      return nok(code2);
    }
    function cdata(code2) {
      if (code2 === null) {
        return nok(code2);
      }
      if (code2 === 93) {
        effects.consume(code2);
        return cdataClose;
      }
      if (markdownLineEnding(code2)) {
        returnState = cdata;
        return lineEndingBefore(code2);
      }
      effects.consume(code2);
      return cdata;
    }
    function cdataClose(code2) {
      if (code2 === 93) {
        effects.consume(code2);
        return cdataEnd;
      }
      return cdata(code2);
    }
    function cdataEnd(code2) {
      if (code2 === 62) {
        return end2(code2);
      }
      if (code2 === 93) {
        effects.consume(code2);
        return cdataEnd;
      }
      return cdata(code2);
    }
    function declaration(code2) {
      if (code2 === null || code2 === 62) {
        return end2(code2);
      }
      if (markdownLineEnding(code2)) {
        returnState = declaration;
        return lineEndingBefore(code2);
      }
      effects.consume(code2);
      return declaration;
    }
    function instruction(code2) {
      if (code2 === null) {
        return nok(code2);
      }
      if (code2 === 63) {
        effects.consume(code2);
        return instructionClose;
      }
      if (markdownLineEnding(code2)) {
        returnState = instruction;
        return lineEndingBefore(code2);
      }
      effects.consume(code2);
      return instruction;
    }
    function instructionClose(code2) {
      return code2 === 62 ? end2(code2) : instruction(code2);
    }
    function tagCloseStart(code2) {
      if (asciiAlpha(code2)) {
        effects.consume(code2);
        return tagClose;
      }
      return nok(code2);
    }
    function tagClose(code2) {
      if (code2 === 45 || asciiAlphanumeric(code2)) {
        effects.consume(code2);
        return tagClose;
      }
      return tagCloseBetween(code2);
    }
    function tagCloseBetween(code2) {
      if (markdownLineEnding(code2)) {
        returnState = tagCloseBetween;
        return lineEndingBefore(code2);
      }
      if (markdownSpace(code2)) {
        effects.consume(code2);
        return tagCloseBetween;
      }
      return end2(code2);
    }
    function tagOpen(code2) {
      if (code2 === 45 || asciiAlphanumeric(code2)) {
        effects.consume(code2);
        return tagOpen;
      }
      if (code2 === 47 || code2 === 62 || markdownLineEndingOrSpace(code2)) {
        return tagOpenBetween(code2);
      }
      return nok(code2);
    }
    function tagOpenBetween(code2) {
      if (code2 === 47) {
        effects.consume(code2);
        return end2;
      }
      if (code2 === 58 || code2 === 95 || asciiAlpha(code2)) {
        effects.consume(code2);
        return tagOpenAttributeName;
      }
      if (markdownLineEnding(code2)) {
        returnState = tagOpenBetween;
        return lineEndingBefore(code2);
      }
      if (markdownSpace(code2)) {
        effects.consume(code2);
        return tagOpenBetween;
      }
      return end2(code2);
    }
    function tagOpenAttributeName(code2) {
      if (code2 === 45 || code2 === 46 || code2 === 58 || code2 === 95 || asciiAlphanumeric(code2)) {
        effects.consume(code2);
        return tagOpenAttributeName;
      }
      return tagOpenAttributeNameAfter(code2);
    }
    function tagOpenAttributeNameAfter(code2) {
      if (code2 === 61) {
        effects.consume(code2);
        return tagOpenAttributeValueBefore;
      }
      if (markdownLineEnding(code2)) {
        returnState = tagOpenAttributeNameAfter;
        return lineEndingBefore(code2);
      }
      if (markdownSpace(code2)) {
        effects.consume(code2);
        return tagOpenAttributeNameAfter;
      }
      return tagOpenBetween(code2);
    }
    function tagOpenAttributeValueBefore(code2) {
      if (code2 === null || code2 === 60 || code2 === 61 || code2 === 62 || code2 === 96) {
        return nok(code2);
      }
      if (code2 === 34 || code2 === 39) {
        effects.consume(code2);
        marker = code2;
        return tagOpenAttributeValueQuoted;
      }
      if (markdownLineEnding(code2)) {
        returnState = tagOpenAttributeValueBefore;
        return lineEndingBefore(code2);
      }
      if (markdownSpace(code2)) {
        effects.consume(code2);
        return tagOpenAttributeValueBefore;
      }
      effects.consume(code2);
      return tagOpenAttributeValueUnquoted;
    }
    function tagOpenAttributeValueQuoted(code2) {
      if (code2 === marker) {
        effects.consume(code2);
        marker = void 0;
        return tagOpenAttributeValueQuotedAfter;
      }
      if (code2 === null) {
        return nok(code2);
      }
      if (markdownLineEnding(code2)) {
        returnState = tagOpenAttributeValueQuoted;
        return lineEndingBefore(code2);
      }
      effects.consume(code2);
      return tagOpenAttributeValueQuoted;
    }
    function tagOpenAttributeValueUnquoted(code2) {
      if (code2 === null || code2 === 34 || code2 === 39 || code2 === 60 || code2 === 61 || code2 === 96) {
        return nok(code2);
      }
      if (code2 === 47 || code2 === 62 || markdownLineEndingOrSpace(code2)) {
        return tagOpenBetween(code2);
      }
      effects.consume(code2);
      return tagOpenAttributeValueUnquoted;
    }
    function tagOpenAttributeValueQuotedAfter(code2) {
      if (code2 === 47 || code2 === 62 || markdownLineEndingOrSpace(code2)) {
        return tagOpenBetween(code2);
      }
      return nok(code2);
    }
    function end2(code2) {
      if (code2 === 62) {
        effects.consume(code2);
        effects.exit("htmlTextData");
        effects.exit("htmlText");
        return ok2;
      }
      return nok(code2);
    }
    function lineEndingBefore(code2) {
      effects.exit("htmlTextData");
      effects.enter("lineEnding");
      effects.consume(code2);
      effects.exit("lineEnding");
      return lineEndingAfter;
    }
    function lineEndingAfter(code2) {
      return markdownSpace(code2) ? factorySpace(effects, lineEndingAfterPrefix, "linePrefix", self2.parser.constructs.disable.null.includes("codeIndented") ? void 0 : 4)(code2) : lineEndingAfterPrefix(code2);
    }
    function lineEndingAfterPrefix(code2) {
      effects.enter("htmlTextData");
      return returnState(code2);
    }
  }
  const labelEnd = {
    name: "labelEnd",
    tokenize: tokenizeLabelEnd,
    resolveTo: resolveToLabelEnd,
    resolveAll: resolveAllLabelEnd
  };
  const resourceConstruct = {
    tokenize: tokenizeResource
  };
  const referenceFullConstruct = {
    tokenize: tokenizeReferenceFull
  };
  const referenceCollapsedConstruct = {
    tokenize: tokenizeReferenceCollapsed
  };
  function resolveAllLabelEnd(events2) {
    let index2 = -1;
    while (++index2 < events2.length) {
      const token = events2[index2][1];
      if (token.type === "labelImage" || token.type === "labelLink" || token.type === "labelEnd") {
        events2.splice(index2 + 1, token.type === "labelImage" ? 4 : 2);
        token.type = "data";
        index2++;
      }
    }
    return events2;
  }
  function resolveToLabelEnd(events2, context2) {
    let index2 = events2.length;
    let offset2 = 0;
    let token;
    let open;
    let close;
    let media;
    while (index2--) {
      token = events2[index2][1];
      if (open) {
        if (token.type === "link" || token.type === "labelLink" && token._inactive) {
          break;
        }
        if (events2[index2][0] === "enter" && token.type === "labelLink") {
          token._inactive = true;
        }
      } else if (close) {
        if (events2[index2][0] === "enter" && (token.type === "labelImage" || token.type === "labelLink") && !token._balanced) {
          open = index2;
          if (token.type !== "labelLink") {
            offset2 = 2;
            break;
          }
        }
      } else if (token.type === "labelEnd") {
        close = index2;
      }
    }
    const group = {
      type: events2[open][1].type === "labelLink" ? "link" : "image",
      start: Object.assign({}, events2[open][1].start),
      end: Object.assign({}, events2[events2.length - 1][1].end)
    };
    const label = {
      type: "label",
      start: Object.assign({}, events2[open][1].start),
      end: Object.assign({}, events2[close][1].end)
    };
    const text2 = {
      type: "labelText",
      start: Object.assign({}, events2[open + offset2 + 2][1].end),
      end: Object.assign({}, events2[close - 2][1].start)
    };
    media = [["enter", group, context2], ["enter", label, context2]];
    media = push$2(media, events2.slice(open + 1, open + offset2 + 3));
    media = push$2(media, [["enter", text2, context2]]);
    media = push$2(media, resolveAll(context2.parser.constructs.insideSpan.null, events2.slice(open + offset2 + 4, close - 3), context2));
    media = push$2(media, [["exit", text2, context2], events2[close - 2], events2[close - 1], ["exit", label, context2]]);
    media = push$2(media, events2.slice(close + 1));
    media = push$2(media, [["exit", group, context2]]);
    splice$1(events2, open, events2.length, media);
    return events2;
  }
  function tokenizeLabelEnd(effects, ok2, nok) {
    const self2 = this;
    let index2 = self2.events.length;
    let labelStart;
    let defined;
    while (index2--) {
      if ((self2.events[index2][1].type === "labelImage" || self2.events[index2][1].type === "labelLink") && !self2.events[index2][1]._balanced) {
        labelStart = self2.events[index2][1];
        break;
      }
    }
    return start2;
    function start2(code2) {
      if (!labelStart) {
        return nok(code2);
      }
      if (labelStart._inactive) {
        return labelEndNok(code2);
      }
      defined = self2.parser.defined.includes(normalizeIdentifier(self2.sliceSerialize({
        start: labelStart.end,
        end: self2.now()
      })));
      effects.enter("labelEnd");
      effects.enter("labelMarker");
      effects.consume(code2);
      effects.exit("labelMarker");
      effects.exit("labelEnd");
      return after;
    }
    function after(code2) {
      if (code2 === 40) {
        return effects.attempt(resourceConstruct, labelEndOk, defined ? labelEndOk : labelEndNok)(code2);
      }
      if (code2 === 91) {
        return effects.attempt(referenceFullConstruct, labelEndOk, defined ? referenceNotFull : labelEndNok)(code2);
      }
      return defined ? labelEndOk(code2) : labelEndNok(code2);
    }
    function referenceNotFull(code2) {
      return effects.attempt(referenceCollapsedConstruct, labelEndOk, labelEndNok)(code2);
    }
    function labelEndOk(code2) {
      return ok2(code2);
    }
    function labelEndNok(code2) {
      labelStart._balanced = true;
      return nok(code2);
    }
  }
  function tokenizeResource(effects, ok2, nok) {
    return resourceStart;
    function resourceStart(code2) {
      effects.enter("resource");
      effects.enter("resourceMarker");
      effects.consume(code2);
      effects.exit("resourceMarker");
      return resourceBefore;
    }
    function resourceBefore(code2) {
      return markdownLineEndingOrSpace(code2) ? factoryWhitespace(effects, resourceOpen)(code2) : resourceOpen(code2);
    }
    function resourceOpen(code2) {
      if (code2 === 41) {
        return resourceEnd(code2);
      }
      return factoryDestination(effects, resourceDestinationAfter, resourceDestinationMissing, "resourceDestination", "resourceDestinationLiteral", "resourceDestinationLiteralMarker", "resourceDestinationRaw", "resourceDestinationString", 32)(code2);
    }
    function resourceDestinationAfter(code2) {
      return markdownLineEndingOrSpace(code2) ? factoryWhitespace(effects, resourceBetween)(code2) : resourceEnd(code2);
    }
    function resourceDestinationMissing(code2) {
      return nok(code2);
    }
    function resourceBetween(code2) {
      if (code2 === 34 || code2 === 39 || code2 === 40) {
        return factoryTitle(effects, resourceTitleAfter, nok, "resourceTitle", "resourceTitleMarker", "resourceTitleString")(code2);
      }
      return resourceEnd(code2);
    }
    function resourceTitleAfter(code2) {
      return markdownLineEndingOrSpace(code2) ? factoryWhitespace(effects, resourceEnd)(code2) : resourceEnd(code2);
    }
    function resourceEnd(code2) {
      if (code2 === 41) {
        effects.enter("resourceMarker");
        effects.consume(code2);
        effects.exit("resourceMarker");
        effects.exit("resource");
        return ok2;
      }
      return nok(code2);
    }
  }
  function tokenizeReferenceFull(effects, ok2, nok) {
    const self2 = this;
    return referenceFull;
    function referenceFull(code2) {
      return factoryLabel.call(self2, effects, referenceFullAfter, referenceFullMissing, "reference", "referenceMarker", "referenceString")(code2);
    }
    function referenceFullAfter(code2) {
      return self2.parser.defined.includes(normalizeIdentifier(self2.sliceSerialize(self2.events[self2.events.length - 1][1]).slice(1, -1))) ? ok2(code2) : nok(code2);
    }
    function referenceFullMissing(code2) {
      return nok(code2);
    }
  }
  function tokenizeReferenceCollapsed(effects, ok2, nok) {
    return referenceCollapsedStart;
    function referenceCollapsedStart(code2) {
      effects.enter("reference");
      effects.enter("referenceMarker");
      effects.consume(code2);
      effects.exit("referenceMarker");
      return referenceCollapsedOpen;
    }
    function referenceCollapsedOpen(code2) {
      if (code2 === 93) {
        effects.enter("referenceMarker");
        effects.consume(code2);
        effects.exit("referenceMarker");
        effects.exit("reference");
        return ok2;
      }
      return nok(code2);
    }
  }
  const labelStartImage = {
    name: "labelStartImage",
    tokenize: tokenizeLabelStartImage,
    resolveAll: labelEnd.resolveAll
  };
  function tokenizeLabelStartImage(effects, ok2, nok) {
    const self2 = this;
    return start2;
    function start2(code2) {
      effects.enter("labelImage");
      effects.enter("labelImageMarker");
      effects.consume(code2);
      effects.exit("labelImageMarker");
      return open;
    }
    function open(code2) {
      if (code2 === 91) {
        effects.enter("labelMarker");
        effects.consume(code2);
        effects.exit("labelMarker");
        effects.exit("labelImage");
        return after;
      }
      return nok(code2);
    }
    function after(code2) {
      return code2 === 94 && "_hiddenFootnoteSupport" in self2.parser.constructs ? nok(code2) : ok2(code2);
    }
  }
  const labelStartLink = {
    name: "labelStartLink",
    tokenize: tokenizeLabelStartLink,
    resolveAll: labelEnd.resolveAll
  };
  function tokenizeLabelStartLink(effects, ok2, nok) {
    const self2 = this;
    return start2;
    function start2(code2) {
      effects.enter("labelLink");
      effects.enter("labelMarker");
      effects.consume(code2);
      effects.exit("labelMarker");
      effects.exit("labelLink");
      return after;
    }
    function after(code2) {
      return code2 === 94 && "_hiddenFootnoteSupport" in self2.parser.constructs ? nok(code2) : ok2(code2);
    }
  }
  const lineEnding = {
    name: "lineEnding",
    tokenize: tokenizeLineEnding
  };
  function tokenizeLineEnding(effects, ok2) {
    return start2;
    function start2(code2) {
      effects.enter("lineEnding");
      effects.consume(code2);
      effects.exit("lineEnding");
      return factorySpace(effects, ok2, "linePrefix");
    }
  }
  const thematicBreak$2 = {
    name: "thematicBreak",
    tokenize: tokenizeThematicBreak
  };
  function tokenizeThematicBreak(effects, ok2, nok) {
    let size2 = 0;
    let marker;
    return start2;
    function start2(code2) {
      effects.enter("thematicBreak");
      return before(code2);
    }
    function before(code2) {
      marker = code2;
      return atBreak(code2);
    }
    function atBreak(code2) {
      if (code2 === marker) {
        effects.enter("thematicBreakSequence");
        return sequence(code2);
      }
      if (size2 >= 3 && (code2 === null || markdownLineEnding(code2))) {
        effects.exit("thematicBreak");
        return ok2(code2);
      }
      return nok(code2);
    }
    function sequence(code2) {
      if (code2 === marker) {
        effects.consume(code2);
        size2++;
        return sequence;
      }
      effects.exit("thematicBreakSequence");
      return markdownSpace(code2) ? factorySpace(effects, atBreak, "whitespace")(code2) : atBreak(code2);
    }
  }
  const list$2 = {
    name: "list",
    tokenize: tokenizeListStart,
    continuation: {
      tokenize: tokenizeListContinuation
    },
    exit: tokenizeListEnd
  };
  const listItemPrefixWhitespaceConstruct = {
    tokenize: tokenizeListItemPrefixWhitespace,
    partial: true
  };
  const indentConstruct = {
    tokenize: tokenizeIndent$1,
    partial: true
  };
  function tokenizeListStart(effects, ok2, nok) {
    const self2 = this;
    const tail = self2.events[self2.events.length - 1];
    let initialSize = tail && tail[1].type === "linePrefix" ? tail[2].sliceSerialize(tail[1], true).length : 0;
    let size2 = 0;
    return start2;
    function start2(code2) {
      const kind = self2.containerState.type || (code2 === 42 || code2 === 43 || code2 === 45 ? "listUnordered" : "listOrdered");
      if (kind === "listUnordered" ? !self2.containerState.marker || code2 === self2.containerState.marker : asciiDigit(code2)) {
        if (!self2.containerState.type) {
          self2.containerState.type = kind;
          effects.enter(kind, {
            _container: true
          });
        }
        if (kind === "listUnordered") {
          effects.enter("listItemPrefix");
          return code2 === 42 || code2 === 45 ? effects.check(thematicBreak$2, nok, atMarker)(code2) : atMarker(code2);
        }
        if (!self2.interrupt || code2 === 49) {
          effects.enter("listItemPrefix");
          effects.enter("listItemValue");
          return inside2(code2);
        }
      }
      return nok(code2);
    }
    function inside2(code2) {
      if (asciiDigit(code2) && ++size2 < 10) {
        effects.consume(code2);
        return inside2;
      }
      if ((!self2.interrupt || size2 < 2) && (self2.containerState.marker ? code2 === self2.containerState.marker : code2 === 41 || code2 === 46)) {
        effects.exit("listItemValue");
        return atMarker(code2);
      }
      return nok(code2);
    }
    function atMarker(code2) {
      effects.enter("listItemMarker");
      effects.consume(code2);
      effects.exit("listItemMarker");
      self2.containerState.marker = self2.containerState.marker || code2;
      return effects.check(
        blankLine,
        self2.interrupt ? nok : onBlank,
        effects.attempt(listItemPrefixWhitespaceConstruct, endOfPrefix, otherPrefix)
      );
    }
    function onBlank(code2) {
      self2.containerState.initialBlankLine = true;
      initialSize++;
      return endOfPrefix(code2);
    }
    function otherPrefix(code2) {
      if (markdownSpace(code2)) {
        effects.enter("listItemPrefixWhitespace");
        effects.consume(code2);
        effects.exit("listItemPrefixWhitespace");
        return endOfPrefix;
      }
      return nok(code2);
    }
    function endOfPrefix(code2) {
      self2.containerState.size = initialSize + self2.sliceSerialize(effects.exit("listItemPrefix"), true).length;
      return ok2(code2);
    }
  }
  function tokenizeListContinuation(effects, ok2, nok) {
    const self2 = this;
    self2.containerState._closeFlow = void 0;
    return effects.check(blankLine, onBlank, notBlank);
    function onBlank(code2) {
      self2.containerState.furtherBlankLines = self2.containerState.furtherBlankLines || self2.containerState.initialBlankLine;
      return factorySpace(effects, ok2, "listItemIndent", self2.containerState.size + 1)(code2);
    }
    function notBlank(code2) {
      if (self2.containerState.furtherBlankLines || !markdownSpace(code2)) {
        self2.containerState.furtherBlankLines = void 0;
        self2.containerState.initialBlankLine = void 0;
        return notInCurrentItem(code2);
      }
      self2.containerState.furtherBlankLines = void 0;
      self2.containerState.initialBlankLine = void 0;
      return effects.attempt(indentConstruct, ok2, notInCurrentItem)(code2);
    }
    function notInCurrentItem(code2) {
      self2.containerState._closeFlow = true;
      self2.interrupt = void 0;
      return factorySpace(effects, effects.attempt(list$2, ok2, nok), "linePrefix", self2.parser.constructs.disable.null.includes("codeIndented") ? void 0 : 4)(code2);
    }
  }
  function tokenizeIndent$1(effects, ok2, nok) {
    const self2 = this;
    return factorySpace(effects, afterPrefix, "listItemIndent", self2.containerState.size + 1);
    function afterPrefix(code2) {
      const tail = self2.events[self2.events.length - 1];
      return tail && tail[1].type === "listItemIndent" && tail[2].sliceSerialize(tail[1], true).length === self2.containerState.size ? ok2(code2) : nok(code2);
    }
  }
  function tokenizeListEnd(effects) {
    effects.exit(this.containerState.type);
  }
  function tokenizeListItemPrefixWhitespace(effects, ok2, nok) {
    const self2 = this;
    return factorySpace(effects, afterPrefix, "listItemPrefixWhitespace", self2.parser.constructs.disable.null.includes("codeIndented") ? void 0 : 4 + 1);
    function afterPrefix(code2) {
      const tail = self2.events[self2.events.length - 1];
      return !markdownSpace(code2) && tail && tail[1].type === "listItemPrefixWhitespace" ? ok2(code2) : nok(code2);
    }
  }
  const setextUnderline = {
    name: "setextUnderline",
    tokenize: tokenizeSetextUnderline,
    resolveTo: resolveToSetextUnderline
  };
  function resolveToSetextUnderline(events2, context2) {
    let index2 = events2.length;
    let content2;
    let text2;
    let definition2;
    while (index2--) {
      if (events2[index2][0] === "enter") {
        if (events2[index2][1].type === "content") {
          content2 = index2;
          break;
        }
        if (events2[index2][1].type === "paragraph") {
          text2 = index2;
        }
      } else {
        if (events2[index2][1].type === "content") {
          events2.splice(index2, 1);
        }
        if (!definition2 && events2[index2][1].type === "definition") {
          definition2 = index2;
        }
      }
    }
    const heading2 = {
      type: "setextHeading",
      start: Object.assign({}, events2[text2][1].start),
      end: Object.assign({}, events2[events2.length - 1][1].end)
    };
    events2[text2][1].type = "setextHeadingText";
    if (definition2) {
      events2.splice(text2, 0, ["enter", heading2, context2]);
      events2.splice(definition2 + 1, 0, ["exit", events2[content2][1], context2]);
      events2[content2][1].end = Object.assign({}, events2[definition2][1].end);
    } else {
      events2[content2][1] = heading2;
    }
    events2.push(["exit", heading2, context2]);
    return events2;
  }
  function tokenizeSetextUnderline(effects, ok2, nok) {
    const self2 = this;
    let marker;
    return start2;
    function start2(code2) {
      let index2 = self2.events.length;
      let paragraph2;
      while (index2--) {
        if (self2.events[index2][1].type !== "lineEnding" && self2.events[index2][1].type !== "linePrefix" && self2.events[index2][1].type !== "content") {
          paragraph2 = self2.events[index2][1].type === "paragraph";
          break;
        }
      }
      if (!self2.parser.lazy[self2.now().line] && (self2.interrupt || paragraph2)) {
        effects.enter("setextHeadingLine");
        marker = code2;
        return before(code2);
      }
      return nok(code2);
    }
    function before(code2) {
      effects.enter("setextHeadingLineSequence");
      return inside2(code2);
    }
    function inside2(code2) {
      if (code2 === marker) {
        effects.consume(code2);
        return inside2;
      }
      effects.exit("setextHeadingLineSequence");
      return markdownSpace(code2) ? factorySpace(effects, after, "lineSuffix")(code2) : after(code2);
    }
    function after(code2) {
      if (code2 === null || markdownLineEnding(code2)) {
        effects.exit("setextHeadingLine");
        return ok2(code2);
      }
      return nok(code2);
    }
  }
  const flow$1 = {
    tokenize: initializeFlow
  };
  function initializeFlow(effects) {
    const self2 = this;
    const initial2 = effects.attempt(
      blankLine,
      atBlankEnding,
      effects.attempt(
        this.parser.constructs.flowInitial,
        afterConstruct,
        factorySpace(
          effects,
          effects.attempt(
            this.parser.constructs.flow,
            afterConstruct,
            effects.attempt(content$1, afterConstruct)
          ),
          "linePrefix"
        )
      )
    );
    return initial2;
    function atBlankEnding(code2) {
      if (code2 === null) {
        effects.consume(code2);
        return;
      }
      effects.enter("lineEndingBlank");
      effects.consume(code2);
      effects.exit("lineEndingBlank");
      self2.currentConstruct = void 0;
      return initial2;
    }
    function afterConstruct(code2) {
      if (code2 === null) {
        effects.consume(code2);
        return;
      }
      effects.enter("lineEnding");
      effects.consume(code2);
      effects.exit("lineEnding");
      self2.currentConstruct = void 0;
      return initial2;
    }
  }
  const resolver$1 = {
    resolveAll: createResolver()
  };
  const string$3 = initializeFactory("string");
  const text$5 = initializeFactory("text");
  function initializeFactory(field) {
    return {
      tokenize: initializeText,
      resolveAll: createResolver(
        field === "text" ? resolveAllLineSuffixes : void 0
      )
    };
    function initializeText(effects) {
      const self2 = this;
      const constructs2 = this.parser.constructs[field];
      const text2 = effects.attempt(constructs2, start2, notText);
      return start2;
      function start2(code2) {
        return atBreak(code2) ? text2(code2) : notText(code2);
      }
      function notText(code2) {
        if (code2 === null) {
          effects.consume(code2);
          return;
        }
        effects.enter("data");
        effects.consume(code2);
        return data2;
      }
      function data2(code2) {
        if (atBreak(code2)) {
          effects.exit("data");
          return text2(code2);
        }
        effects.consume(code2);
        return data2;
      }
      function atBreak(code2) {
        if (code2 === null) {
          return true;
        }
        const list2 = constructs2[code2];
        let index2 = -1;
        if (list2) {
          while (++index2 < list2.length) {
            const item = list2[index2];
            if (!item.previous || item.previous.call(self2, self2.previous)) {
              return true;
            }
          }
        }
        return false;
      }
    }
  }
  function createResolver(extraResolver) {
    return resolveAllText;
    function resolveAllText(events2, context2) {
      let index2 = -1;
      let enter;
      while (++index2 <= events2.length) {
        if (enter === void 0) {
          if (events2[index2] && events2[index2][1].type === "data") {
            enter = index2;
            index2++;
          }
        } else if (!events2[index2] || events2[index2][1].type !== "data") {
          if (index2 !== enter + 2) {
            events2[enter][1].end = events2[index2 - 1][1].end;
            events2.splice(enter + 2, index2 - enter - 2);
            index2 = enter + 2;
          }
          enter = void 0;
        }
      }
      return extraResolver ? extraResolver(events2, context2) : events2;
    }
  }
  function resolveAllLineSuffixes(events2, context2) {
    let eventIndex = 0;
    while (++eventIndex <= events2.length) {
      if ((eventIndex === events2.length || events2[eventIndex][1].type === "lineEnding") && events2[eventIndex - 1][1].type === "data") {
        const data2 = events2[eventIndex - 1][1];
        const chunks = context2.sliceStream(data2);
        let index2 = chunks.length;
        let bufferIndex = -1;
        let size2 = 0;
        let tabs;
        while (index2--) {
          const chunk = chunks[index2];
          if (typeof chunk === "string") {
            bufferIndex = chunk.length;
            while (chunk.charCodeAt(bufferIndex - 1) === 32) {
              size2++;
              bufferIndex--;
            }
            if (bufferIndex)
              break;
            bufferIndex = -1;
          } else if (chunk === -2) {
            tabs = true;
            size2++;
          } else if (chunk === -1)
            ;
          else {
            index2++;
            break;
          }
        }
        if (size2) {
          const token = {
            type: eventIndex === events2.length || tabs || size2 < 2 ? "lineSuffix" : "hardBreakTrailing",
            start: {
              line: data2.end.line,
              column: data2.end.column - size2,
              offset: data2.end.offset - size2,
              _index: data2.start._index + index2,
              _bufferIndex: index2 ? bufferIndex : data2.start._bufferIndex + bufferIndex
            },
            end: Object.assign({}, data2.end)
          };
          data2.end = Object.assign({}, token.start);
          if (data2.start.offset === data2.end.offset) {
            Object.assign(data2, token);
          } else {
            events2.splice(
              eventIndex,
              0,
              ["enter", token, context2],
              ["exit", token, context2]
            );
            eventIndex += 2;
          }
        }
        eventIndex++;
      }
    }
    return events2;
  }
  function createTokenizer(parser2, initialize, from) {
    let point2 = Object.assign(
      from ? Object.assign({}, from) : {
        line: 1,
        column: 1,
        offset: 0
      },
      {
        _index: 0,
        _bufferIndex: -1
      }
    );
    const columnStart = {};
    const resolveAllConstructs = [];
    let chunks = [];
    let stack = [];
    const effects = {
      consume,
      enter,
      exit: exit2,
      attempt: constructFactory(onsuccessfulconstruct),
      check: constructFactory(onsuccessfulcheck),
      interrupt: constructFactory(onsuccessfulcheck, {
        interrupt: true
      })
    };
    const context2 = {
      previous: null,
      code: null,
      containerState: {},
      events: [],
      parser: parser2,
      sliceStream,
      sliceSerialize,
      now: now2,
      defineSkip,
      write: write2
    };
    let state = initialize.tokenize.call(context2, effects);
    if (initialize.resolveAll) {
      resolveAllConstructs.push(initialize);
    }
    return context2;
    function write2(slice) {
      chunks = push$2(chunks, slice);
      main2();
      if (chunks[chunks.length - 1] !== null) {
        return [];
      }
      addResult(initialize, 0);
      context2.events = resolveAll(resolveAllConstructs, context2.events, context2);
      return context2.events;
    }
    function sliceSerialize(token, expandTabs) {
      return serializeChunks(sliceStream(token), expandTabs);
    }
    function sliceStream(token) {
      return sliceChunks(chunks, token);
    }
    function now2() {
      const { line, column, offset: offset2, _index, _bufferIndex } = point2;
      return {
        line,
        column,
        offset: offset2,
        _index,
        _bufferIndex
      };
    }
    function defineSkip(value) {
      columnStart[value.line] = value.column;
      accountForPotentialSkip();
    }
    function main2() {
      let chunkIndex;
      while (point2._index < chunks.length) {
        const chunk = chunks[point2._index];
        if (typeof chunk === "string") {
          chunkIndex = point2._index;
          if (point2._bufferIndex < 0) {
            point2._bufferIndex = 0;
          }
          while (point2._index === chunkIndex && point2._bufferIndex < chunk.length) {
            go2(chunk.charCodeAt(point2._bufferIndex));
          }
        } else {
          go2(chunk);
        }
      }
    }
    function go2(code2) {
      state = state(code2);
    }
    function consume(code2) {
      if (markdownLineEnding(code2)) {
        point2.line++;
        point2.column = 1;
        point2.offset += code2 === -3 ? 2 : 1;
        accountForPotentialSkip();
      } else if (code2 !== -1) {
        point2.column++;
        point2.offset++;
      }
      if (point2._bufferIndex < 0) {
        point2._index++;
      } else {
        point2._bufferIndex++;
        if (point2._bufferIndex === chunks[point2._index].length) {
          point2._bufferIndex = -1;
          point2._index++;
        }
      }
      context2.previous = code2;
    }
    function enter(type2, fields) {
      const token = fields || {};
      token.type = type2;
      token.start = now2();
      context2.events.push(["enter", token, context2]);
      stack.push(token);
      return token;
    }
    function exit2(type2) {
      const token = stack.pop();
      token.end = now2();
      context2.events.push(["exit", token, context2]);
      return token;
    }
    function onsuccessfulconstruct(construct, info) {
      addResult(construct, info.from);
    }
    function onsuccessfulcheck(_2, info) {
      info.restore();
    }
    function constructFactory(onreturn, fields) {
      return hook;
      function hook(constructs2, returnState, bogusState) {
        let listOfConstructs;
        let constructIndex;
        let currentConstruct;
        let info;
        return Array.isArray(constructs2) ? handleListOfConstructs(constructs2) : "tokenize" in constructs2 ? handleListOfConstructs([constructs2]) : handleMapOfConstructs(constructs2);
        function handleMapOfConstructs(map2) {
          return start2;
          function start2(code2) {
            const def = code2 !== null && map2[code2];
            const all2 = code2 !== null && map2.null;
            const list2 = [
              ...Array.isArray(def) ? def : def ? [def] : [],
              ...Array.isArray(all2) ? all2 : all2 ? [all2] : []
            ];
            return handleListOfConstructs(list2)(code2);
          }
        }
        function handleListOfConstructs(list2) {
          listOfConstructs = list2;
          constructIndex = 0;
          if (list2.length === 0) {
            return bogusState;
          }
          return handleConstruct(list2[constructIndex]);
        }
        function handleConstruct(construct) {
          return start2;
          function start2(code2) {
            info = store();
            currentConstruct = construct;
            if (!construct.partial) {
              context2.currentConstruct = construct;
            }
            if (construct.name && context2.parser.constructs.disable.null.includes(construct.name)) {
              return nok();
            }
            return construct.tokenize.call(
              fields ? Object.assign(Object.create(context2), fields) : context2,
              effects,
              ok2,
              nok
            )(code2);
          }
        }
        function ok2(code2) {
          onreturn(currentConstruct, info);
          return returnState;
        }
        function nok(code2) {
          info.restore();
          if (++constructIndex < listOfConstructs.length) {
            return handleConstruct(listOfConstructs[constructIndex]);
          }
          return bogusState;
        }
      }
    }
    function addResult(construct, from2) {
      if (construct.resolveAll && !resolveAllConstructs.includes(construct)) {
        resolveAllConstructs.push(construct);
      }
      if (construct.resolve) {
        splice$1(
          context2.events,
          from2,
          context2.events.length - from2,
          construct.resolve(context2.events.slice(from2), context2)
        );
      }
      if (construct.resolveTo) {
        context2.events = construct.resolveTo(context2.events, context2);
      }
    }
    function store() {
      const startPoint = now2();
      const startPrevious = context2.previous;
      const startCurrentConstruct = context2.currentConstruct;
      const startEventsIndex = context2.events.length;
      const startStack = Array.from(stack);
      return {
        restore,
        from: startEventsIndex
      };
      function restore() {
        point2 = startPoint;
        context2.previous = startPrevious;
        context2.currentConstruct = startCurrentConstruct;
        context2.events.length = startEventsIndex;
        stack = startStack;
        accountForPotentialSkip();
      }
    }
    function accountForPotentialSkip() {
      if (point2.line in columnStart && point2.column < 2) {
        point2.column = columnStart[point2.line];
        point2.offset += columnStart[point2.line] - 1;
      }
    }
  }
  function sliceChunks(chunks, token) {
    const startIndex = token.start._index;
    const startBufferIndex = token.start._bufferIndex;
    const endIndex = token.end._index;
    const endBufferIndex = token.end._bufferIndex;
    let view;
    if (startIndex === endIndex) {
      view = [chunks[startIndex].slice(startBufferIndex, endBufferIndex)];
    } else {
      view = chunks.slice(startIndex, endIndex);
      if (startBufferIndex > -1) {
        const head = view[0];
        if (typeof head === "string") {
          view[0] = head.slice(startBufferIndex);
        } else {
          view.shift();
        }
      }
      if (endBufferIndex > 0) {
        view.push(chunks[endIndex].slice(0, endBufferIndex));
      }
    }
    return view;
  }
  function serializeChunks(chunks, expandTabs) {
    let index2 = -1;
    const result = [];
    let atTab;
    while (++index2 < chunks.length) {
      const chunk = chunks[index2];
      let value;
      if (typeof chunk === "string") {
        value = chunk;
      } else
        switch (chunk) {
          case -5: {
            value = "\r";
            break;
          }
          case -4: {
            value = "\n";
            break;
          }
          case -3: {
            value = "\r\n";
            break;
          }
          case -2: {
            value = expandTabs ? " " : "	";
            break;
          }
          case -1: {
            if (!expandTabs && atTab)
              continue;
            value = " ";
            break;
          }
          default: {
            value = String.fromCharCode(chunk);
          }
        }
      atTab = chunk === -2;
      result.push(value);
    }
    return result.join("");
  }
  const document$1 = {
    [42]: list$2,
    [43]: list$2,
    [45]: list$2,
    [48]: list$2,
    [49]: list$2,
    [50]: list$2,
    [51]: list$2,
    [52]: list$2,
    [53]: list$2,
    [54]: list$2,
    [55]: list$2,
    [56]: list$2,
    [57]: list$2,
    [62]: blockQuote
  };
  const contentInitial = {
    [91]: definition$1
  };
  const flowInitial = {
    [-2]: codeIndented,
    [-1]: codeIndented,
    [32]: codeIndented
  };
  const flow = {
    [35]: headingAtx,
    [42]: thematicBreak$2,
    [45]: [setextUnderline, thematicBreak$2],
    [60]: htmlFlow,
    [61]: setextUnderline,
    [95]: thematicBreak$2,
    [96]: codeFenced,
    [126]: codeFenced
  };
  const string$2 = {
    [38]: characterReference,
    [92]: characterEscape
  };
  const text$4 = {
    [-5]: lineEnding,
    [-4]: lineEnding,
    [-3]: lineEnding,
    [33]: labelStartImage,
    [38]: characterReference,
    [42]: attention,
    [60]: [autolink, htmlText],
    [91]: labelStartLink,
    [92]: [hardBreakEscape, characterEscape],
    [93]: labelEnd,
    [95]: attention,
    [96]: codeText
  };
  const insideSpan = {
    null: [attention, resolver$1]
  };
  const attentionMarkers = {
    null: [42, 95]
  };
  const disable = {
    null: []
  };
  const defaultConstructs = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    document: document$1,
    contentInitial,
    flowInitial,
    flow,
    string: string$2,
    text: text$4,
    insideSpan,
    attentionMarkers,
    disable
  }, Symbol.toStringTag, { value: "Module" }));
  function parse$6(options) {
    const settings2 = options || {};
    const constructs2 = combineExtensions([defaultConstructs, ...settings2.extensions || []]);
    const parser2 = {
      defined: [],
      lazy: {},
      constructs: constructs2,
      content: create2(content$2),
      document: create2(document$2),
      flow: create2(flow$1),
      string: create2(string$3),
      text: create2(text$5)
    };
    return parser2;
    function create2(initial2) {
      return creator2;
      function creator2(from) {
        return createTokenizer(parser2, initial2, from);
      }
    }
  }
  function postprocess(events2) {
    while (!subtokenize(events2)) {
    }
    return events2;
  }
  const search$1 = /[\0\t\n\r]/g;
  function preprocess() {
    let column = 1;
    let buffer = "";
    let start2 = true;
    let atCarriageReturn;
    return preprocessor2;
    function preprocessor2(value, encoding, end2) {
      const chunks = [];
      let match2;
      let next2;
      let startPosition;
      let endPosition;
      let code2;
      value = buffer + (typeof value === "string" ? value.toString() : new TextDecoder(encoding || void 0).decode(value));
      startPosition = 0;
      buffer = "";
      if (start2) {
        if (value.charCodeAt(0) === 65279) {
          startPosition++;
        }
        start2 = void 0;
      }
      while (startPosition < value.length) {
        search$1.lastIndex = startPosition;
        match2 = search$1.exec(value);
        endPosition = match2 && match2.index !== void 0 ? match2.index : value.length;
        code2 = value.charCodeAt(endPosition);
        if (!match2) {
          buffer = value.slice(startPosition);
          break;
        }
        if (code2 === 10 && startPosition === endPosition && atCarriageReturn) {
          chunks.push(-3);
          atCarriageReturn = void 0;
        } else {
          if (atCarriageReturn) {
            chunks.push(-5);
            atCarriageReturn = void 0;
          }
          if (startPosition < endPosition) {
            chunks.push(value.slice(startPosition, endPosition));
            column += endPosition - startPosition;
          }
          switch (code2) {
            case 0: {
              chunks.push(65533);
              column++;
              break;
            }
            case 9: {
              next2 = Math.ceil(column / 4) * 4;
              chunks.push(-2);
              while (column++ < next2)
                chunks.push(-1);
              break;
            }
            case 10: {
              chunks.push(-4);
              column = 1;
              break;
            }
            default: {
              atCarriageReturn = true;
              column = 1;
            }
          }
        }
        startPosition = endPosition + 1;
      }
      if (end2) {
        if (atCarriageReturn)
          chunks.push(-5);
        if (buffer)
          chunks.push(buffer);
        chunks.push(null);
      }
      return chunks;
    }
  }
  const characterEscapeOrReference = /\\([!-/:-@[-`{-~])|&(#(?:\d{1,7}|x[\da-f]{1,6})|[\da-z]{1,31});/gi;
  function decodeString(value) {
    return value.replace(characterEscapeOrReference, decode$1);
  }
  function decode$1($0, $1, $2) {
    if ($1) {
      return $1;
    }
    const head = $2.charCodeAt(0);
    if (head === 35) {
      const head2 = $2.charCodeAt(1);
      const hex2 = head2 === 120 || head2 === 88;
      return decodeNumericCharacterReference($2.slice(hex2 ? 2 : 1), hex2 ? 16 : 10);
    }
    return decodeNamedCharacterReference($2) || $0;
  }
  const own$6 = {}.hasOwnProperty;
  function fromMarkdown(value, encoding, options) {
    if (typeof encoding !== "string") {
      options = encoding;
      encoding = void 0;
    }
    return compiler(options)(postprocess(parse$6(options).document().write(preprocess()(value, encoding, true))));
  }
  function compiler(options) {
    const config2 = {
      transforms: [],
      canContainEols: ["emphasis", "fragment", "heading", "paragraph", "strong"],
      enter: {
        autolink: opener(link2),
        autolinkProtocol: onenterdata,
        autolinkEmail: onenterdata,
        atxHeading: opener(heading2),
        blockQuote: opener(blockQuote2),
        characterEscape: onenterdata,
        characterReference: onenterdata,
        codeFenced: opener(codeFlow),
        codeFencedFenceInfo: buffer,
        codeFencedFenceMeta: buffer,
        codeIndented: opener(codeFlow, buffer),
        codeText: opener(codeText2, buffer),
        codeTextData: onenterdata,
        data: onenterdata,
        codeFlowValue: onenterdata,
        definition: opener(definition2),
        definitionDestinationString: buffer,
        definitionLabelString: buffer,
        definitionTitleString: buffer,
        emphasis: opener(emphasis2),
        hardBreakEscape: opener(hardBreak2),
        hardBreakTrailing: opener(hardBreak2),
        htmlFlow: opener(html2, buffer),
        htmlFlowData: onenterdata,
        htmlText: opener(html2, buffer),
        htmlTextData: onenterdata,
        image: opener(image2),
        label: buffer,
        link: opener(link2),
        listItem: opener(listItem2),
        listItemValue: onenterlistitemvalue,
        listOrdered: opener(list2, onenterlistordered),
        listUnordered: opener(list2),
        paragraph: opener(paragraph2),
        reference: onenterreference,
        referenceString: buffer,
        resourceDestinationString: buffer,
        resourceTitleString: buffer,
        setextHeading: opener(heading2),
        strong: opener(strong2),
        thematicBreak: opener(thematicBreak2)
      },
      exit: {
        atxHeading: closer(),
        atxHeadingSequence: onexitatxheadingsequence,
        autolink: closer(),
        autolinkEmail: onexitautolinkemail,
        autolinkProtocol: onexitautolinkprotocol,
        blockQuote: closer(),
        characterEscapeValue: onexitdata,
        characterReferenceMarkerHexadecimal: onexitcharacterreferencemarker,
        characterReferenceMarkerNumeric: onexitcharacterreferencemarker,
        characterReferenceValue: onexitcharacterreferencevalue,
        characterReference: onexitcharacterreference,
        codeFenced: closer(onexitcodefenced),
        codeFencedFence: onexitcodefencedfence,
        codeFencedFenceInfo: onexitcodefencedfenceinfo,
        codeFencedFenceMeta: onexitcodefencedfencemeta,
        codeFlowValue: onexitdata,
        codeIndented: closer(onexitcodeindented),
        codeText: closer(onexitcodetext),
        codeTextData: onexitdata,
        data: onexitdata,
        definition: closer(),
        definitionDestinationString: onexitdefinitiondestinationstring,
        definitionLabelString: onexitdefinitionlabelstring,
        definitionTitleString: onexitdefinitiontitlestring,
        emphasis: closer(),
        hardBreakEscape: closer(onexithardbreak),
        hardBreakTrailing: closer(onexithardbreak),
        htmlFlow: closer(onexithtmlflow),
        htmlFlowData: onexitdata,
        htmlText: closer(onexithtmltext),
        htmlTextData: onexitdata,
        image: closer(onexitimage),
        label: onexitlabel,
        labelText: onexitlabeltext,
        lineEnding: onexitlineending,
        link: closer(onexitlink),
        listItem: closer(),
        listOrdered: closer(),
        listUnordered: closer(),
        paragraph: closer(),
        referenceString: onexitreferencestring,
        resourceDestinationString: onexitresourcedestinationstring,
        resourceTitleString: onexitresourcetitlestring,
        resource: onexitresource,
        setextHeading: closer(onexitsetextheading),
        setextHeadingLineSequence: onexitsetextheadinglinesequence,
        setextHeadingText: onexitsetextheadingtext,
        strong: closer(),
        thematicBreak: closer()
      }
    };
    configure(config2, (options || {}).mdastExtensions || []);
    const data2 = {};
    return compile;
    function compile(events2) {
      let tree = {
        type: "root",
        children: []
      };
      const context2 = {
        stack: [tree],
        tokenStack: [],
        config: config2,
        enter,
        exit: exit2,
        buffer,
        resume,
        data: data2
      };
      const listStack = [];
      let index2 = -1;
      while (++index2 < events2.length) {
        if (events2[index2][1].type === "listOrdered" || events2[index2][1].type === "listUnordered") {
          if (events2[index2][0] === "enter") {
            listStack.push(index2);
          } else {
            const tail = listStack.pop();
            index2 = prepareList(events2, tail, index2);
          }
        }
      }
      index2 = -1;
      while (++index2 < events2.length) {
        const handler = config2[events2[index2][0]];
        if (own$6.call(handler, events2[index2][1].type)) {
          handler[events2[index2][1].type].call(Object.assign({
            sliceSerialize: events2[index2][2].sliceSerialize
          }, context2), events2[index2][1]);
        }
      }
      if (context2.tokenStack.length > 0) {
        const tail = context2.tokenStack[context2.tokenStack.length - 1];
        const handler = tail[1] || defaultOnError;
        handler.call(context2, void 0, tail[0]);
      }
      tree.position = {
        start: point$2(events2.length > 0 ? events2[0][1].start : {
          line: 1,
          column: 1,
          offset: 0
        }),
        end: point$2(events2.length > 0 ? events2[events2.length - 2][1].end : {
          line: 1,
          column: 1,
          offset: 0
        })
      };
      index2 = -1;
      while (++index2 < config2.transforms.length) {
        tree = config2.transforms[index2](tree) || tree;
      }
      return tree;
    }
    function prepareList(events2, start2, length) {
      let index2 = start2 - 1;
      let containerBalance = -1;
      let listSpread = false;
      let listItem3;
      let lineIndex;
      let firstBlankLineIndex;
      let atMarker;
      while (++index2 <= length) {
        const event2 = events2[index2];
        switch (event2[1].type) {
          case "listUnordered":
          case "listOrdered":
          case "blockQuote": {
            if (event2[0] === "enter") {
              containerBalance++;
            } else {
              containerBalance--;
            }
            atMarker = void 0;
            break;
          }
          case "lineEndingBlank": {
            if (event2[0] === "enter") {
              if (listItem3 && !atMarker && !containerBalance && !firstBlankLineIndex) {
                firstBlankLineIndex = index2;
              }
              atMarker = void 0;
            }
            break;
          }
          case "linePrefix":
          case "listItemValue":
          case "listItemMarker":
          case "listItemPrefix":
          case "listItemPrefixWhitespace": {
            break;
          }
          default: {
            atMarker = void 0;
          }
        }
        if (!containerBalance && event2[0] === "enter" && event2[1].type === "listItemPrefix" || containerBalance === -1 && event2[0] === "exit" && (event2[1].type === "listUnordered" || event2[1].type === "listOrdered")) {
          if (listItem3) {
            let tailIndex = index2;
            lineIndex = void 0;
            while (tailIndex--) {
              const tailEvent = events2[tailIndex];
              if (tailEvent[1].type === "lineEnding" || tailEvent[1].type === "lineEndingBlank") {
                if (tailEvent[0] === "exit")
                  continue;
                if (lineIndex) {
                  events2[lineIndex][1].type = "lineEndingBlank";
                  listSpread = true;
                }
                tailEvent[1].type = "lineEnding";
                lineIndex = tailIndex;
              } else if (tailEvent[1].type === "linePrefix" || tailEvent[1].type === "blockQuotePrefix" || tailEvent[1].type === "blockQuotePrefixWhitespace" || tailEvent[1].type === "blockQuoteMarker" || tailEvent[1].type === "listItemIndent")
                ;
              else {
                break;
              }
            }
            if (firstBlankLineIndex && (!lineIndex || firstBlankLineIndex < lineIndex)) {
              listItem3._spread = true;
            }
            listItem3.end = Object.assign({}, lineIndex ? events2[lineIndex][1].start : event2[1].end);
            events2.splice(lineIndex || index2, 0, ["exit", listItem3, event2[2]]);
            index2++;
            length++;
          }
          if (event2[1].type === "listItemPrefix") {
            const item = {
              type: "listItem",
              _spread: false,
              start: Object.assign({}, event2[1].start),
              end: void 0
            };
            listItem3 = item;
            events2.splice(index2, 0, ["enter", item, event2[2]]);
            index2++;
            length++;
            firstBlankLineIndex = void 0;
            atMarker = true;
          }
        }
      }
      events2[start2][1]._spread = listSpread;
      return length;
    }
    function opener(create2, and) {
      return open;
      function open(token) {
        enter.call(this, create2(token), token);
        if (and)
          and.call(this, token);
      }
    }
    function buffer() {
      this.stack.push({
        type: "fragment",
        children: []
      });
    }
    function enter(node2, token, errorHandler) {
      const parent = this.stack[this.stack.length - 1];
      const siblings = parent.children;
      siblings.push(node2);
      this.stack.push(node2);
      this.tokenStack.push([token, errorHandler]);
      node2.position = {
        start: point$2(token.start),
        end: void 0
      };
    }
    function closer(and) {
      return close;
      function close(token) {
        if (and)
          and.call(this, token);
        exit2.call(this, token);
      }
    }
    function exit2(token, onExitError) {
      const node2 = this.stack.pop();
      const open = this.tokenStack.pop();
      if (!open) {
        throw new Error("Cannot close `" + token.type + "` (" + stringifyPosition({
          start: token.start,
          end: token.end
        }) + "): it\u2019s not open");
      } else if (open[0].type !== token.type) {
        if (onExitError) {
          onExitError.call(this, token, open[0]);
        } else {
          const handler = open[1] || defaultOnError;
          handler.call(this, token, open[0]);
        }
      }
      node2.position.end = point$2(token.end);
    }
    function resume() {
      return toString$5(this.stack.pop());
    }
    function onenterlistordered() {
      this.data.expectingFirstListItemValue = true;
    }
    function onenterlistitemvalue(token) {
      if (this.data.expectingFirstListItemValue) {
        const ancestor = this.stack[this.stack.length - 2];
        ancestor.start = Number.parseInt(this.sliceSerialize(token), 10);
        this.data.expectingFirstListItemValue = void 0;
      }
    }
    function onexitcodefencedfenceinfo() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.lang = data3;
    }
    function onexitcodefencedfencemeta() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.meta = data3;
    }
    function onexitcodefencedfence() {
      if (this.data.flowCodeInside)
        return;
      this.buffer();
      this.data.flowCodeInside = true;
    }
    function onexitcodefenced() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.value = data3.replace(/^(\r?\n|\r)|(\r?\n|\r)$/g, "");
      this.data.flowCodeInside = void 0;
    }
    function onexitcodeindented() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.value = data3.replace(/(\r?\n|\r)$/g, "");
    }
    function onexitdefinitionlabelstring(token) {
      const label = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.label = label;
      node2.identifier = normalizeIdentifier(this.sliceSerialize(token)).toLowerCase();
    }
    function onexitdefinitiontitlestring() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.title = data3;
    }
    function onexitdefinitiondestinationstring() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.url = data3;
    }
    function onexitatxheadingsequence(token) {
      const node2 = this.stack[this.stack.length - 1];
      if (!node2.depth) {
        const depth = this.sliceSerialize(token).length;
        node2.depth = depth;
      }
    }
    function onexitsetextheadingtext() {
      this.data.setextHeadingSlurpLineEnding = true;
    }
    function onexitsetextheadinglinesequence(token) {
      const node2 = this.stack[this.stack.length - 1];
      node2.depth = this.sliceSerialize(token).codePointAt(0) === 61 ? 1 : 2;
    }
    function onexitsetextheading() {
      this.data.setextHeadingSlurpLineEnding = void 0;
    }
    function onenterdata(token) {
      const node2 = this.stack[this.stack.length - 1];
      const siblings = node2.children;
      let tail = siblings[siblings.length - 1];
      if (!tail || tail.type !== "text") {
        tail = text2();
        tail.position = {
          start: point$2(token.start),
          end: void 0
        };
        siblings.push(tail);
      }
      this.stack.push(tail);
    }
    function onexitdata(token) {
      const tail = this.stack.pop();
      tail.value += this.sliceSerialize(token);
      tail.position.end = point$2(token.end);
    }
    function onexitlineending(token) {
      const context2 = this.stack[this.stack.length - 1];
      if (this.data.atHardBreak) {
        const tail = context2.children[context2.children.length - 1];
        tail.position.end = point$2(token.end);
        this.data.atHardBreak = void 0;
        return;
      }
      if (!this.data.setextHeadingSlurpLineEnding && config2.canContainEols.includes(context2.type)) {
        onenterdata.call(this, token);
        onexitdata.call(this, token);
      }
    }
    function onexithardbreak() {
      this.data.atHardBreak = true;
    }
    function onexithtmlflow() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.value = data3;
    }
    function onexithtmltext() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.value = data3;
    }
    function onexitcodetext() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.value = data3;
    }
    function onexitlink() {
      const node2 = this.stack[this.stack.length - 1];
      if (this.data.inReference) {
        const referenceType = this.data.referenceType || "shortcut";
        node2.type += "Reference";
        node2.referenceType = referenceType;
        delete node2.url;
        delete node2.title;
      } else {
        delete node2.identifier;
        delete node2.label;
      }
      this.data.referenceType = void 0;
    }
    function onexitimage() {
      const node2 = this.stack[this.stack.length - 1];
      if (this.data.inReference) {
        const referenceType = this.data.referenceType || "shortcut";
        node2.type += "Reference";
        node2.referenceType = referenceType;
        delete node2.url;
        delete node2.title;
      } else {
        delete node2.identifier;
        delete node2.label;
      }
      this.data.referenceType = void 0;
    }
    function onexitlabeltext(token) {
      const string2 = this.sliceSerialize(token);
      const ancestor = this.stack[this.stack.length - 2];
      ancestor.label = decodeString(string2);
      ancestor.identifier = normalizeIdentifier(string2).toLowerCase();
    }
    function onexitlabel() {
      const fragment2 = this.stack[this.stack.length - 1];
      const value = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      this.data.inReference = true;
      if (node2.type === "link") {
        const children2 = fragment2.children;
        node2.children = children2;
      } else {
        node2.alt = value;
      }
    }
    function onexitresourcedestinationstring() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.url = data3;
    }
    function onexitresourcetitlestring() {
      const data3 = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.title = data3;
    }
    function onexitresource() {
      this.data.inReference = void 0;
    }
    function onenterreference() {
      this.data.referenceType = "collapsed";
    }
    function onexitreferencestring(token) {
      const label = this.resume();
      const node2 = this.stack[this.stack.length - 1];
      node2.label = label;
      node2.identifier = normalizeIdentifier(this.sliceSerialize(token)).toLowerCase();
      this.data.referenceType = "full";
    }
    function onexitcharacterreferencemarker(token) {
      this.data.characterReferenceType = token.type;
    }
    function onexitcharacterreferencevalue(token) {
      const data3 = this.sliceSerialize(token);
      const type2 = this.data.characterReferenceType;
      let value;
      if (type2) {
        value = decodeNumericCharacterReference(data3, type2 === "characterReferenceMarkerNumeric" ? 10 : 16);
        this.data.characterReferenceType = void 0;
      } else {
        const result = decodeNamedCharacterReference(data3);
        value = result;
      }
      const tail = this.stack[this.stack.length - 1];
      tail.value += value;
    }
    function onexitcharacterreference(token) {
      const tail = this.stack.pop();
      tail.position.end = point$2(token.end);
    }
    function onexitautolinkprotocol(token) {
      onexitdata.call(this, token);
      const node2 = this.stack[this.stack.length - 1];
      node2.url = this.sliceSerialize(token);
    }
    function onexitautolinkemail(token) {
      onexitdata.call(this, token);
      const node2 = this.stack[this.stack.length - 1];
      node2.url = "mailto:" + this.sliceSerialize(token);
    }
    function blockQuote2() {
      return {
        type: "blockquote",
        children: []
      };
    }
    function codeFlow() {
      return {
        type: "code",
        lang: null,
        meta: null,
        value: ""
      };
    }
    function codeText2() {
      return {
        type: "inlineCode",
        value: ""
      };
    }
    function definition2() {
      return {
        type: "definition",
        identifier: "",
        label: null,
        title: null,
        url: ""
      };
    }
    function emphasis2() {
      return {
        type: "emphasis",
        children: []
      };
    }
    function heading2() {
      return {
        type: "heading",
        depth: 0,
        children: []
      };
    }
    function hardBreak2() {
      return {
        type: "break"
      };
    }
    function html2() {
      return {
        type: "html",
        value: ""
      };
    }
    function image2() {
      return {
        type: "image",
        title: null,
        url: "",
        alt: null
      };
    }
    function link2() {
      return {
        type: "link",
        title: null,
        url: "",
        children: []
      };
    }
    function list2(token) {
      return {
        type: "list",
        ordered: token.type === "listOrdered",
        start: null,
        spread: token._spread,
        children: []
      };
    }
    function listItem2(token) {
      return {
        type: "listItem",
        spread: token._spread,
        checked: null,
        children: []
      };
    }
    function paragraph2() {
      return {
        type: "paragraph",
        children: []
      };
    }
    function strong2() {
      return {
        type: "strong",
        children: []
      };
    }
    function text2() {
      return {
        type: "text",
        value: ""
      };
    }
    function thematicBreak2() {
      return {
        type: "thematicBreak"
      };
    }
  }
  function point$2(d2) {
    return {
      line: d2.line,
      column: d2.column,
      offset: d2.offset
    };
  }
  function configure(combined, extensions2) {
    let index2 = -1;
    while (++index2 < extensions2.length) {
      const value = extensions2[index2];
      if (Array.isArray(value)) {
        configure(combined, value);
      } else {
        extension$1(combined, value);
      }
    }
  }
  function extension$1(combined, extension2) {
    let key;
    for (key in extension2) {
      if (own$6.call(extension2, key)) {
        switch (key) {
          case "canContainEols": {
            const right2 = extension2[key];
            if (right2) {
              combined[key].push(...right2);
            }
            break;
          }
          case "transforms": {
            const right2 = extension2[key];
            if (right2) {
              combined[key].push(...right2);
            }
            break;
          }
          case "enter":
          case "exit": {
            const right2 = extension2[key];
            if (right2) {
              Object.assign(combined[key], right2);
            }
            break;
          }
        }
      }
    }
  }
  function defaultOnError(left2, right2) {
    if (left2) {
      throw new Error("Cannot close `" + left2.type + "` (" + stringifyPosition({
        start: left2.start,
        end: left2.end
      }) + "): a different token (`" + right2.type + "`, " + stringifyPosition({
        start: right2.start,
        end: right2.end
      }) + ") is open");
    } else {
      throw new Error("Cannot close document, a token (`" + right2.type + "`, " + stringifyPosition({
        start: right2.start,
        end: right2.end
      }) + ") is still open");
    }
  }
  function remarkParse(options) {
    const self2 = this;
    self2.parser = parser2;
    function parser2(doc2) {
      return fromMarkdown(doc2, {
        ...self2.data("settings"),
        ...options,
        extensions: self2.data("micromarkExtensions") || [],
        mdastExtensions: self2.data("fromMarkdownExtensions") || []
      });
    }
  }
  function blockquote$1(state, node2) {
    const result = {
      type: "element",
      tagName: "blockquote",
      properties: {},
      children: state.wrap(state.all(node2), true)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function hardBreak$1(state, node2) {
    const result = { type: "element", tagName: "br", properties: {}, children: [] };
    state.patch(node2, result);
    return [state.applyData(node2, result), { type: "text", value: "\n" }];
  }
  function code$3(state, node2) {
    const value = node2.value ? node2.value + "\n" : "";
    const properties = {};
    if (node2.lang) {
      properties.className = ["language-" + node2.lang];
    }
    let result = {
      type: "element",
      tagName: "code",
      properties,
      children: [{ type: "text", value }]
    };
    if (node2.meta) {
      result.data = { meta: node2.meta };
    }
    state.patch(node2, result);
    result = state.applyData(node2, result);
    result = { type: "element", tagName: "pre", properties: {}, children: [result] };
    state.patch(node2, result);
    return result;
  }
  function strikethrough(state, node2) {
    const result = {
      type: "element",
      tagName: "del",
      properties: {},
      children: state.all(node2)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function emphasis$1(state, node2) {
    const result = {
      type: "element",
      tagName: "em",
      properties: {},
      children: state.all(node2)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function footnoteReference$1(state, node2) {
    const clobberPrefix = typeof state.options.clobberPrefix === "string" ? state.options.clobberPrefix : "user-content-";
    const id2 = String(node2.identifier).toUpperCase();
    const safeId = normalizeUri(id2.toLowerCase());
    const index2 = state.footnoteOrder.indexOf(id2);
    let counter2;
    let reuseCounter = state.footnoteCounts.get(id2);
    if (reuseCounter === void 0) {
      reuseCounter = 0;
      state.footnoteOrder.push(id2);
      counter2 = state.footnoteOrder.length;
    } else {
      counter2 = index2 + 1;
    }
    reuseCounter += 1;
    state.footnoteCounts.set(id2, reuseCounter);
    const link2 = {
      type: "element",
      tagName: "a",
      properties: {
        href: "#" + clobberPrefix + "fn-" + safeId,
        id: clobberPrefix + "fnref-" + safeId + (reuseCounter > 1 ? "-" + reuseCounter : ""),
        dataFootnoteRef: true,
        ariaDescribedBy: ["footnote-label"]
      },
      children: [{ type: "text", value: String(counter2) }]
    };
    state.patch(node2, link2);
    const sup = {
      type: "element",
      tagName: "sup",
      properties: {},
      children: [link2]
    };
    state.patch(node2, sup);
    return state.applyData(node2, sup);
  }
  function heading$2(state, node2) {
    const result = {
      type: "element",
      tagName: "h" + node2.depth,
      properties: {},
      children: state.all(node2)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function html$2(state, node2) {
    if (state.options.allowDangerousHtml) {
      const result = { type: "raw", value: node2.value };
      state.patch(node2, result);
      return state.applyData(node2, result);
    }
    return void 0;
  }
  function revert(state, node2) {
    const subtype = node2.referenceType;
    let suffix = "]";
    if (subtype === "collapsed") {
      suffix += "[]";
    } else if (subtype === "full") {
      suffix += "[" + (node2.label || node2.identifier) + "]";
    }
    if (node2.type === "imageReference") {
      return [{ type: "text", value: "![" + node2.alt + suffix }];
    }
    const contents = state.all(node2);
    const head = contents[0];
    if (head && head.type === "text") {
      head.value = "[" + head.value;
    } else {
      contents.unshift({ type: "text", value: "[" });
    }
    const tail = contents[contents.length - 1];
    if (tail && tail.type === "text") {
      tail.value += suffix;
    } else {
      contents.push({ type: "text", value: suffix });
    }
    return contents;
  }
  function imageReference$1(state, node2) {
    const id2 = String(node2.identifier).toUpperCase();
    const definition2 = state.definitionById.get(id2);
    if (!definition2) {
      return revert(state, node2);
    }
    const properties = { src: normalizeUri(definition2.url || ""), alt: node2.alt };
    if (definition2.title !== null && definition2.title !== void 0) {
      properties.title = definition2.title;
    }
    const result = { type: "element", tagName: "img", properties, children: [] };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function image$1(state, node2) {
    const properties = { src: normalizeUri(node2.url) };
    if (node2.alt !== null && node2.alt !== void 0) {
      properties.alt = node2.alt;
    }
    if (node2.title !== null && node2.title !== void 0) {
      properties.title = node2.title;
    }
    const result = { type: "element", tagName: "img", properties, children: [] };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function inlineCode$1(state, node2) {
    const text2 = { type: "text", value: node2.value.replace(/\r?\n|\r/g, " ") };
    state.patch(node2, text2);
    const result = {
      type: "element",
      tagName: "code",
      properties: {},
      children: [text2]
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function linkReference$1(state, node2) {
    const id2 = String(node2.identifier).toUpperCase();
    const definition2 = state.definitionById.get(id2);
    if (!definition2) {
      return revert(state, node2);
    }
    const properties = { href: normalizeUri(definition2.url || "") };
    if (definition2.title !== null && definition2.title !== void 0) {
      properties.title = definition2.title;
    }
    const result = {
      type: "element",
      tagName: "a",
      properties,
      children: state.all(node2)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function link$2(state, node2) {
    const properties = { href: normalizeUri(node2.url) };
    if (node2.title !== null && node2.title !== void 0) {
      properties.title = node2.title;
    }
    const result = {
      type: "element",
      tagName: "a",
      properties,
      children: state.all(node2)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function listItem$1(state, node2, parent) {
    const results = state.all(node2);
    const loose = parent ? listLoose(parent) : listItemLoose(node2);
    const properties = {};
    const children2 = [];
    if (typeof node2.checked === "boolean") {
      const head = results[0];
      let paragraph2;
      if (head && head.type === "element" && head.tagName === "p") {
        paragraph2 = head;
      } else {
        paragraph2 = { type: "element", tagName: "p", properties: {}, children: [] };
        results.unshift(paragraph2);
      }
      if (paragraph2.children.length > 0) {
        paragraph2.children.unshift({ type: "text", value: " " });
      }
      paragraph2.children.unshift({
        type: "element",
        tagName: "input",
        properties: { type: "checkbox", checked: node2.checked, disabled: true },
        children: []
      });
      properties.className = ["task-list-item"];
    }
    let index2 = -1;
    while (++index2 < results.length) {
      const child = results[index2];
      if (loose || index2 !== 0 || child.type !== "element" || child.tagName !== "p") {
        children2.push({ type: "text", value: "\n" });
      }
      if (child.type === "element" && child.tagName === "p" && !loose) {
        children2.push(...child.children);
      } else {
        children2.push(child);
      }
    }
    const tail = results[results.length - 1];
    if (tail && (loose || tail.type !== "element" || tail.tagName !== "p")) {
      children2.push({ type: "text", value: "\n" });
    }
    const result = { type: "element", tagName: "li", properties, children: children2 };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function listLoose(node2) {
    let loose = false;
    if (node2.type === "list") {
      loose = node2.spread || false;
      const children2 = node2.children;
      let index2 = -1;
      while (!loose && ++index2 < children2.length) {
        loose = listItemLoose(children2[index2]);
      }
    }
    return loose;
  }
  function listItemLoose(node2) {
    const spread = node2.spread;
    return spread === null || spread === void 0 ? node2.children.length > 1 : spread;
  }
  function list$1(state, node2) {
    const properties = {};
    const results = state.all(node2);
    let index2 = -1;
    if (typeof node2.start === "number" && node2.start !== 1) {
      properties.start = node2.start;
    }
    while (++index2 < results.length) {
      const child = results[index2];
      if (child.type === "element" && child.tagName === "li" && child.properties && Array.isArray(child.properties.className) && child.properties.className.includes("task-list-item")) {
        properties.className = ["contains-task-list"];
        break;
      }
    }
    const result = {
      type: "element",
      tagName: node2.ordered ? "ol" : "ul",
      properties,
      children: state.wrap(results, true)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function paragraph$1(state, node2) {
    const result = {
      type: "element",
      tagName: "p",
      properties: {},
      children: state.all(node2)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function root$5(state, node2) {
    const result = { type: "root", children: state.wrap(state.all(node2)) };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function strong$1(state, node2) {
    const result = {
      type: "element",
      tagName: "strong",
      properties: {},
      children: state.all(node2)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function table(state, node2) {
    const rows = state.all(node2);
    const firstRow = rows.shift();
    const tableContent = [];
    if (firstRow) {
      const head = {
        type: "element",
        tagName: "thead",
        properties: {},
        children: state.wrap([firstRow], true)
      };
      state.patch(node2.children[0], head);
      tableContent.push(head);
    }
    if (rows.length > 0) {
      const body = {
        type: "element",
        tagName: "tbody",
        properties: {},
        children: state.wrap(rows, true)
      };
      const start2 = pointStart$1(node2.children[1]);
      const end2 = pointEnd$1(node2.children[node2.children.length - 1]);
      if (start2 && end2)
        body.position = { start: start2, end: end2 };
      tableContent.push(body);
    }
    const result = {
      type: "element",
      tagName: "table",
      properties: {},
      children: state.wrap(tableContent, true)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function tableRow(state, node2, parent) {
    const siblings = parent ? parent.children : void 0;
    const rowIndex = siblings ? siblings.indexOf(node2) : 1;
    const tagName = rowIndex === 0 ? "th" : "td";
    const align = parent && parent.type === "table" ? parent.align : void 0;
    const length = align ? align.length : node2.children.length;
    let cellIndex = -1;
    const cells2 = [];
    while (++cellIndex < length) {
      const cell = node2.children[cellIndex];
      const properties = {};
      const alignValue = align ? align[cellIndex] : void 0;
      if (alignValue) {
        properties.align = alignValue;
      }
      let result2 = { type: "element", tagName, properties, children: [] };
      if (cell) {
        result2.children = state.all(cell);
        state.patch(cell, result2);
        result2 = state.applyData(cell, result2);
      }
      cells2.push(result2);
    }
    const result = {
      type: "element",
      tagName: "tr",
      properties: {},
      children: state.wrap(cells2, true)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function tableCell(state, node2) {
    const result = {
      type: "element",
      tagName: "td",
      properties: {},
      children: state.all(node2)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  const tab$1 = 9;
  const space$1 = 32;
  function trimLines(value) {
    const source = String(value);
    const search2 = /\r?\n|\r/g;
    let match2 = search2.exec(source);
    let last = 0;
    const lines = [];
    while (match2) {
      lines.push(
        trimLine(source.slice(last, match2.index), last > 0, true),
        match2[0]
      );
      last = match2.index + match2[0].length;
      match2 = search2.exec(source);
    }
    lines.push(trimLine(source.slice(last), last > 0, false));
    return lines.join("");
  }
  function trimLine(value, start2, end2) {
    let startIndex = 0;
    let endIndex = value.length;
    if (start2) {
      let code2 = value.codePointAt(startIndex);
      while (code2 === tab$1 || code2 === space$1) {
        startIndex++;
        code2 = value.codePointAt(startIndex);
      }
    }
    if (end2) {
      let code2 = value.codePointAt(endIndex - 1);
      while (code2 === tab$1 || code2 === space$1) {
        endIndex--;
        code2 = value.codePointAt(endIndex - 1);
      }
    }
    return endIndex > startIndex ? value.slice(startIndex, endIndex) : "";
  }
  function text$3(state, node2) {
    const result = { type: "text", value: trimLines(String(node2.value)) };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function thematicBreak$1(state, node2) {
    const result = {
      type: "element",
      tagName: "hr",
      properties: {},
      children: []
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  const handlers$1 = {
    blockquote: blockquote$1,
    break: hardBreak$1,
    code: code$3,
    delete: strikethrough,
    emphasis: emphasis$1,
    footnoteReference: footnoteReference$1,
    heading: heading$2,
    html: html$2,
    imageReference: imageReference$1,
    image: image$1,
    inlineCode: inlineCode$1,
    linkReference: linkReference$1,
    link: link$2,
    listItem: listItem$1,
    list: list$1,
    paragraph: paragraph$1,
    root: root$5,
    strong: strong$1,
    table,
    tableCell,
    tableRow,
    text: text$3,
    thematicBreak: thematicBreak$1,
    toml: ignore,
    yaml: ignore,
    definition: ignore,
    footnoteDefinition: ignore
  };
  function ignore() {
    return void 0;
  }
  const VOID = -1;
  const PRIMITIVE = 0;
  const ARRAY = 1;
  const OBJECT = 2;
  const DATE = 3;
  const REGEXP = 4;
  const MAP = 5;
  const SET$1 = 6;
  const ERROR = 7;
  const BIGINT = 8;
  const env = typeof self === "object" ? self : globalThis;
  const deserializer = ($2, _2) => {
    const as = (out, index2) => {
      $2.set(index2, out);
      return out;
    };
    const unpair = (index2) => {
      if ($2.has(index2))
        return $2.get(index2);
      const [type2, value] = _2[index2];
      switch (type2) {
        case PRIMITIVE:
        case VOID:
          return as(value, index2);
        case ARRAY: {
          const arr = as([], index2);
          for (const index3 of value)
            arr.push(unpair(index3));
          return arr;
        }
        case OBJECT: {
          const object2 = as({}, index2);
          for (const [key, index3] of value)
            object2[unpair(key)] = unpair(index3);
          return object2;
        }
        case DATE:
          return as(new Date(value), index2);
        case REGEXP: {
          const { source, flags } = value;
          return as(new RegExp(source, flags), index2);
        }
        case MAP: {
          const map2 = as(/* @__PURE__ */ new Map(), index2);
          for (const [key, index3] of value)
            map2.set(unpair(key), unpair(index3));
          return map2;
        }
        case SET$1: {
          const set2 = as(/* @__PURE__ */ new Set(), index2);
          for (const index3 of value)
            set2.add(unpair(index3));
          return set2;
        }
        case ERROR: {
          const { name: name2, message } = value;
          return as(new env[name2](message), index2);
        }
        case BIGINT:
          return as(BigInt(value), index2);
        case "BigInt":
          return as(Object(BigInt(value)), index2);
      }
      return as(new env[type2](value), index2);
    };
    return unpair;
  };
  const deserialize = (serialized) => deserializer(/* @__PURE__ */ new Map(), serialized)(0);
  const EMPTY = "";
  const { toString: toString$4 } = {};
  const { keys: keys$2 } = Object;
  const typeOf = (value) => {
    const type2 = typeof value;
    if (type2 !== "object" || !value)
      return [PRIMITIVE, type2];
    const asString = toString$4.call(value).slice(8, -1);
    switch (asString) {
      case "Array":
        return [ARRAY, EMPTY];
      case "Object":
        return [OBJECT, EMPTY];
      case "Date":
        return [DATE, EMPTY];
      case "RegExp":
        return [REGEXP, EMPTY];
      case "Map":
        return [MAP, EMPTY];
      case "Set":
        return [SET$1, EMPTY];
    }
    if (asString.includes("Array"))
      return [ARRAY, asString];
    if (asString.includes("Error"))
      return [ERROR, asString];
    return [OBJECT, asString];
  };
  const shouldSkip = ([TYPE, type2]) => TYPE === PRIMITIVE && (type2 === "function" || type2 === "symbol");
  const serializer = (strict, json2, $2, _2) => {
    const as = (out, value) => {
      const index2 = _2.push(out) - 1;
      $2.set(value, index2);
      return index2;
    };
    const pair2 = (value) => {
      if ($2.has(value))
        return $2.get(value);
      let [TYPE, type2] = typeOf(value);
      switch (TYPE) {
        case PRIMITIVE: {
          let entry = value;
          switch (type2) {
            case "bigint":
              TYPE = BIGINT;
              entry = value.toString();
              break;
            case "function":
            case "symbol":
              if (strict)
                throw new TypeError("unable to serialize " + type2);
              entry = null;
              break;
            case "undefined":
              return as([VOID], value);
          }
          return as([TYPE, entry], value);
        }
        case ARRAY: {
          if (type2)
            return as([type2, [...value]], value);
          const arr = [];
          const index2 = as([TYPE, arr], value);
          for (const entry of value)
            arr.push(pair2(entry));
          return index2;
        }
        case OBJECT: {
          if (type2) {
            switch (type2) {
              case "BigInt":
                return as([type2, value.toString()], value);
              case "Boolean":
              case "Number":
              case "String":
                return as([type2, value.valueOf()], value);
            }
          }
          if (json2 && "toJSON" in value)
            return pair2(value.toJSON());
          const entries = [];
          const index2 = as([TYPE, entries], value);
          for (const key of keys$2(value)) {
            if (strict || !shouldSkip(typeOf(value[key])))
              entries.push([pair2(key), pair2(value[key])]);
          }
          return index2;
        }
        case DATE:
          return as([TYPE, value.toISOString()], value);
        case REGEXP: {
          const { source, flags } = value;
          return as([TYPE, { source, flags }], value);
        }
        case MAP: {
          const entries = [];
          const index2 = as([TYPE, entries], value);
          for (const [key, entry] of value) {
            if (strict || !(shouldSkip(typeOf(key)) || shouldSkip(typeOf(entry))))
              entries.push([pair2(key), pair2(entry)]);
          }
          return index2;
        }
        case SET$1: {
          const entries = [];
          const index2 = as([TYPE, entries], value);
          for (const entry of value) {
            if (strict || !shouldSkip(typeOf(entry)))
              entries.push(pair2(entry));
          }
          return index2;
        }
      }
      const { message } = value;
      return as([TYPE, { name: type2, message }], value);
    };
    return pair2;
  };
  const serialize$1 = (value, { json: json2, lossy } = {}) => {
    const _2 = [];
    return serializer(!(json2 || lossy), !!json2, /* @__PURE__ */ new Map(), _2)(value), _2;
  };
  const structuredClone$1 = typeof structuredClone === "function" ? (any, options) => options && ("json" in options || "lossy" in options) ? deserialize(serialize$1(any, options)) : structuredClone(any) : (any, options) => deserialize(serialize$1(any, options));
  function defaultFootnoteBackContent(_2, rereferenceIndex) {
    const result = [{ type: "text", value: "\u21A9" }];
    if (rereferenceIndex > 1) {
      result.push({
        type: "element",
        tagName: "sup",
        properties: {},
        children: [{ type: "text", value: String(rereferenceIndex) }]
      });
    }
    return result;
  }
  function defaultFootnoteBackLabel(referenceIndex, rereferenceIndex) {
    return "Back to reference " + (referenceIndex + 1) + (rereferenceIndex > 1 ? "-" + rereferenceIndex : "");
  }
  function footer(state) {
    const clobberPrefix = typeof state.options.clobberPrefix === "string" ? state.options.clobberPrefix : "user-content-";
    const footnoteBackContent = state.options.footnoteBackContent || defaultFootnoteBackContent;
    const footnoteBackLabel = state.options.footnoteBackLabel || defaultFootnoteBackLabel;
    const footnoteLabel = state.options.footnoteLabel || "Footnotes";
    const footnoteLabelTagName = state.options.footnoteLabelTagName || "h2";
    const footnoteLabelProperties = state.options.footnoteLabelProperties || {
      className: ["sr-only"]
    };
    const listItems = [];
    let referenceIndex = -1;
    while (++referenceIndex < state.footnoteOrder.length) {
      const definition2 = state.footnoteById.get(
        state.footnoteOrder[referenceIndex]
      );
      if (!definition2) {
        continue;
      }
      const content2 = state.all(definition2);
      const id2 = String(definition2.identifier).toUpperCase();
      const safeId = normalizeUri(id2.toLowerCase());
      let rereferenceIndex = 0;
      const backReferences = [];
      const counts = state.footnoteCounts.get(id2);
      while (counts !== void 0 && ++rereferenceIndex <= counts) {
        if (backReferences.length > 0) {
          backReferences.push({ type: "text", value: " " });
        }
        let children2 = typeof footnoteBackContent === "string" ? footnoteBackContent : footnoteBackContent(referenceIndex, rereferenceIndex);
        if (typeof children2 === "string") {
          children2 = { type: "text", value: children2 };
        }
        backReferences.push({
          type: "element",
          tagName: "a",
          properties: {
            href: "#" + clobberPrefix + "fnref-" + safeId + (rereferenceIndex > 1 ? "-" + rereferenceIndex : ""),
            dataFootnoteBackref: "",
            ariaLabel: typeof footnoteBackLabel === "string" ? footnoteBackLabel : footnoteBackLabel(referenceIndex, rereferenceIndex),
            className: ["data-footnote-backref"]
          },
          children: Array.isArray(children2) ? children2 : [children2]
        });
      }
      const tail = content2[content2.length - 1];
      if (tail && tail.type === "element" && tail.tagName === "p") {
        const tailTail = tail.children[tail.children.length - 1];
        if (tailTail && tailTail.type === "text") {
          tailTail.value += " ";
        } else {
          tail.children.push({ type: "text", value: " " });
        }
        tail.children.push(...backReferences);
      } else {
        content2.push(...backReferences);
      }
      const listItem2 = {
        type: "element",
        tagName: "li",
        properties: { id: clobberPrefix + "fn-" + safeId },
        children: state.wrap(content2, true)
      };
      state.patch(definition2, listItem2);
      listItems.push(listItem2);
    }
    if (listItems.length === 0) {
      return;
    }
    return {
      type: "element",
      tagName: "section",
      properties: { dataFootnotes: true, className: ["footnotes"] },
      children: [
        {
          type: "element",
          tagName: footnoteLabelTagName,
          properties: {
            ...structuredClone$1(footnoteLabelProperties),
            id: "footnote-label"
          },
          children: [{ type: "text", value: footnoteLabel }]
        },
        { type: "text", value: "\n" },
        {
          type: "element",
          tagName: "ol",
          properties: {},
          children: state.wrap(listItems, true)
        },
        { type: "text", value: "\n" }
      ]
    };
  }
  const convert$1 = function(test2) {
    if (test2 === null || test2 === void 0) {
      return ok$1;
    }
    if (typeof test2 === "function") {
      return castFactory$1(test2);
    }
    if (typeof test2 === "object") {
      return Array.isArray(test2) ? anyFactory$1(test2) : propsFactory$1(test2);
    }
    if (typeof test2 === "string") {
      return typeFactory$1(test2);
    }
    throw new Error("Expected function, string, or object as test");
  };
  function anyFactory$1(tests) {
    const checks2 = [];
    let index2 = -1;
    while (++index2 < tests.length) {
      checks2[index2] = convert$1(tests[index2]);
    }
    return castFactory$1(any);
    function any(...parameters) {
      let index3 = -1;
      while (++index3 < checks2.length) {
        if (checks2[index3].apply(this, parameters))
          return true;
      }
      return false;
    }
  }
  function propsFactory$1(check) {
    const checkAsRecord = check;
    return castFactory$1(all2);
    function all2(node2) {
      const nodeAsRecord = node2;
      let key;
      for (key in check) {
        if (nodeAsRecord[key] !== checkAsRecord[key])
          return false;
      }
      return true;
    }
  }
  function typeFactory$1(check) {
    return castFactory$1(type2);
    function type2(node2) {
      return node2 && node2.type === check;
    }
  }
  function castFactory$1(testFunction) {
    return check;
    function check(value, index2, parent) {
      return Boolean(
        looksLikeANode(value) && testFunction.call(
          this,
          value,
          typeof index2 === "number" ? index2 : void 0,
          parent || void 0
        )
      );
    }
  }
  function ok$1() {
    return true;
  }
  function looksLikeANode(value) {
    return value !== null && typeof value === "object" && "type" in value;
  }
  function color$2(d2) {
    return d2;
  }
  const empty$2 = [];
  const CONTINUE$1 = true;
  const EXIT$1 = false;
  const SKIP$1 = "skip";
  function visitParents$1(tree, test2, visitor, reverse) {
    let check;
    if (typeof test2 === "function" && typeof visitor !== "function") {
      reverse = visitor;
      visitor = test2;
    } else {
      check = test2;
    }
    const is2 = convert$1(check);
    const step2 = reverse ? -1 : 1;
    factory2(tree, void 0, [])();
    function factory2(node2, index2, parents) {
      const value = node2 && typeof node2 === "object" ? node2 : {};
      if (typeof value.type === "string") {
        const name2 = typeof value.tagName === "string" ? value.tagName : typeof value.name === "string" ? value.name : void 0;
        Object.defineProperty(visit2, "name", {
          value: "node (" + color$2(node2.type + (name2 ? "<" + name2 + ">" : "")) + ")"
        });
      }
      return visit2;
      function visit2() {
        let result = empty$2;
        let subresult;
        let offset2;
        let grandparents;
        if (!test2 || is2(node2, index2, parents[parents.length - 1] || void 0)) {
          result = toResult$1(visitor(node2, parents));
          if (result[0] === EXIT$1) {
            return result;
          }
        }
        if ("children" in node2 && node2.children) {
          const nodeAsParent = node2;
          if (nodeAsParent.children && result[0] !== SKIP$1) {
            offset2 = (reverse ? nodeAsParent.children.length : -1) + step2;
            grandparents = parents.concat(nodeAsParent);
            while (offset2 > -1 && offset2 < nodeAsParent.children.length) {
              const child = nodeAsParent.children[offset2];
              subresult = factory2(child, offset2, grandparents)();
              if (subresult[0] === EXIT$1) {
                return subresult;
              }
              offset2 = typeof subresult[1] === "number" ? subresult[1] : offset2 + step2;
            }
          }
        }
        return result;
      }
    }
  }
  function toResult$1(value) {
    if (Array.isArray(value)) {
      return value;
    }
    if (typeof value === "number") {
      return [CONTINUE$1, value];
    }
    return value === null || value === void 0 ? empty$2 : [value];
  }
  function visit$1(tree, testOrVisitor, visitorOrReverse, maybeReverse) {
    let reverse;
    let test2;
    let visitor;
    if (typeof testOrVisitor === "function" && typeof visitorOrReverse !== "function") {
      test2 = void 0;
      visitor = testOrVisitor;
      reverse = visitorOrReverse;
    } else {
      test2 = testOrVisitor;
      visitor = visitorOrReverse;
      reverse = maybeReverse;
    }
    visitParents$1(tree, test2, overload, reverse);
    function overload(node2, parents) {
      const parent = parents[parents.length - 1];
      const index2 = parent ? parent.children.indexOf(node2) : void 0;
      return visitor(node2, index2, parent);
    }
  }
  const own$5 = {}.hasOwnProperty;
  const emptyOptions$1 = {};
  function createState(tree, options) {
    const settings2 = options || emptyOptions$1;
    const definitionById = /* @__PURE__ */ new Map();
    const footnoteById = /* @__PURE__ */ new Map();
    const footnoteCounts = /* @__PURE__ */ new Map();
    const handlers2 = { ...handlers$1, ...settings2.handlers };
    const state = {
      all: all2,
      applyData,
      definitionById,
      footnoteById,
      footnoteCounts,
      footnoteOrder: [],
      handlers: handlers2,
      one: one2,
      options: settings2,
      patch: patch$2,
      wrap: wrap$1
    };
    visit$1(tree, function(node2) {
      if (node2.type === "definition" || node2.type === "footnoteDefinition") {
        const map2 = node2.type === "definition" ? definitionById : footnoteById;
        const id2 = String(node2.identifier).toUpperCase();
        if (!map2.has(id2)) {
          map2.set(id2, node2);
        }
      }
    });
    return state;
    function one2(node2, parent) {
      const type2 = node2.type;
      const handle2 = state.handlers[type2];
      if (own$5.call(state.handlers, type2) && handle2) {
        return handle2(state, node2, parent);
      }
      if (state.options.passThrough && state.options.passThrough.includes(type2)) {
        if ("children" in node2) {
          const { children: children2, ...shallow } = node2;
          const result = structuredClone$1(shallow);
          result.children = state.all(node2);
          return result;
        }
        return structuredClone$1(node2);
      }
      const unknown2 = state.options.unknownHandler || defaultUnknownHandler;
      return unknown2(state, node2, parent);
    }
    function all2(parent) {
      const values = [];
      if ("children" in parent) {
        const nodes = parent.children;
        let index2 = -1;
        while (++index2 < nodes.length) {
          const result = state.one(nodes[index2], parent);
          if (result) {
            if (index2 && nodes[index2 - 1].type === "break") {
              if (!Array.isArray(result) && result.type === "text") {
                result.value = trimMarkdownSpaceStart(result.value);
              }
              if (!Array.isArray(result) && result.type === "element") {
                const head = result.children[0];
                if (head && head.type === "text") {
                  head.value = trimMarkdownSpaceStart(head.value);
                }
              }
            }
            if (Array.isArray(result)) {
              values.push(...result);
            } else {
              values.push(result);
            }
          }
        }
      }
      return values;
    }
  }
  function patch$2(from, to2) {
    if (from.position)
      to2.position = position$3(from);
  }
  function applyData(from, to2) {
    let result = to2;
    if (from && from.data) {
      const hName = from.data.hName;
      const hChildren = from.data.hChildren;
      const hProperties = from.data.hProperties;
      if (typeof hName === "string") {
        if (result.type === "element") {
          result.tagName = hName;
        } else {
          const children2 = "children" in result ? result.children : [result];
          result = { type: "element", tagName: hName, properties: {}, children: children2 };
        }
      }
      if (result.type === "element" && hProperties) {
        Object.assign(result.properties, structuredClone$1(hProperties));
      }
      if ("children" in result && result.children && hChildren !== null && hChildren !== void 0) {
        result.children = hChildren;
      }
    }
    return result;
  }
  function defaultUnknownHandler(state, node2) {
    const data2 = node2.data || {};
    const result = "value" in node2 && !(own$5.call(data2, "hProperties") || own$5.call(data2, "hChildren")) ? { type: "text", value: node2.value } : {
      type: "element",
      tagName: "div",
      properties: {},
      children: state.all(node2)
    };
    state.patch(node2, result);
    return state.applyData(node2, result);
  }
  function wrap$1(nodes, loose) {
    const result = [];
    let index2 = -1;
    if (loose) {
      result.push({ type: "text", value: "\n" });
    }
    while (++index2 < nodes.length) {
      if (index2)
        result.push({ type: "text", value: "\n" });
      result.push(nodes[index2]);
    }
    if (loose && nodes.length > 0) {
      result.push({ type: "text", value: "\n" });
    }
    return result;
  }
  function trimMarkdownSpaceStart(value) {
    let index2 = 0;
    let code2 = value.charCodeAt(index2);
    while (code2 === 9 || code2 === 32) {
      index2++;
      code2 = value.charCodeAt(index2);
    }
    return value.slice(index2);
  }
  function toHast(tree, options) {
    const state = createState(tree, options);
    const node2 = state.one(tree, void 0);
    const foot = footer(state);
    const result = Array.isArray(node2) ? { type: "root", children: node2 } : node2 || { type: "root", children: [] };
    if (foot) {
      result.children.push({ type: "text", value: "\n" }, foot);
    }
    return result;
  }
  function remarkRehype(destination, options) {
    if (destination && "run" in destination) {
      return async function(tree, file) {
        const hastTree = toHast(tree, { file, ...options });
        await destination.run(hastTree, file);
      };
    }
    return function(tree, file) {
      return toHast(tree, { file, ...options || destination });
    };
  }
  function bail(error2) {
    if (error2) {
      throw error2;
    }
  }
  var hasOwn$2 = Object.prototype.hasOwnProperty;
  var toStr$2 = Object.prototype.toString;
  var defineProperty$3 = Object.defineProperty;
  var gOPD$1 = Object.getOwnPropertyDescriptor;
  var isArray$9 = function isArray2(arr) {
    if (typeof Array.isArray === "function") {
      return Array.isArray(arr);
    }
    return toStr$2.call(arr) === "[object Array]";
  };
  var isPlainObject$4 = function isPlainObject2(obj) {
    if (!obj || toStr$2.call(obj) !== "[object Object]") {
      return false;
    }
    var hasOwnConstructor = hasOwn$2.call(obj, "constructor");
    var hasIsPrototypeOf = obj.constructor && obj.constructor.prototype && hasOwn$2.call(obj.constructor.prototype, "isPrototypeOf");
    if (obj.constructor && !hasOwnConstructor && !hasIsPrototypeOf) {
      return false;
    }
    var key;
    for (key in obj) {
    }
    return typeof key === "undefined" || hasOwn$2.call(obj, key);
  };
  var setProperty = function setProperty2(target, options) {
    if (defineProperty$3 && options.name === "__proto__") {
      defineProperty$3(target, options.name, {
        enumerable: true,
        configurable: true,
        value: options.newValue,
        writable: true
      });
    } else {
      target[options.name] = options.newValue;
    }
  };
  var getProperty = function getProperty2(obj, name2) {
    if (name2 === "__proto__") {
      if (!hasOwn$2.call(obj, name2)) {
        return void 0;
      } else if (gOPD$1) {
        return gOPD$1(obj, name2).value;
      }
    }
    return obj[name2];
  };
  var extend$3 = function extend2() {
    var options, name2, src, copy2, copyIsArray, clone2;
    var target = arguments[0];
    var i2 = 1;
    var length = arguments.length;
    var deep = false;
    if (typeof target === "boolean") {
      deep = target;
      target = arguments[1] || {};
      i2 = 2;
    }
    if (target == null || typeof target !== "object" && typeof target !== "function") {
      target = {};
    }
    for (; i2 < length; ++i2) {
      options = arguments[i2];
      if (options != null) {
        for (name2 in options) {
          src = getProperty(target, name2);
          copy2 = getProperty(options, name2);
          if (target !== copy2) {
            if (deep && copy2 && (isPlainObject$4(copy2) || (copyIsArray = isArray$9(copy2)))) {
              if (copyIsArray) {
                copyIsArray = false;
                clone2 = src && isArray$9(src) ? src : [];
              } else {
                clone2 = src && isPlainObject$4(src) ? src : {};
              }
              setProperty(target, { name: name2, newValue: extend2(deep, clone2, copy2) });
            } else if (typeof copy2 !== "undefined") {
              setProperty(target, { name: name2, newValue: copy2 });
            }
          }
        }
      }
    }
    return target;
  };
  function isPlainObject$3(value) {
    if (typeof value !== "object" || value === null) {
      return false;
    }
    const prototype = Object.getPrototypeOf(value);
    return (prototype === null || prototype === Object.prototype || Object.getPrototypeOf(prototype) === null) && !(Symbol.toStringTag in value) && !(Symbol.iterator in value);
  }
  function trough() {
    const fns = [];
    const pipeline = { run, use };
    return pipeline;
    function run(...values) {
      let middlewareIndex = -1;
      const callback = values.pop();
      if (typeof callback !== "function") {
        throw new TypeError("Expected function as last argument, not " + callback);
      }
      next2(null, ...values);
      function next2(error2, ...output2) {
        const fn2 = fns[++middlewareIndex];
        let index2 = -1;
        if (error2) {
          callback(error2);
          return;
        }
        while (++index2 < values.length) {
          if (output2[index2] === null || output2[index2] === void 0) {
            output2[index2] = values[index2];
          }
        }
        values = output2;
        if (fn2) {
          wrap(fn2, next2)(...output2);
        } else {
          callback(null, ...output2);
        }
      }
    }
    function use(middelware) {
      if (typeof middelware !== "function") {
        throw new TypeError(
          "Expected `middelware` to be a function, not " + middelware
        );
      }
      fns.push(middelware);
      return pipeline;
    }
  }
  function wrap(middleware, callback) {
    let called;
    return wrapped;
    function wrapped(...parameters) {
      const fnExpectsCallback = middleware.length > parameters.length;
      let result;
      if (fnExpectsCallback) {
        parameters.push(done);
      }
      try {
        result = middleware.apply(this, parameters);
      } catch (error2) {
        const exception = error2;
        if (fnExpectsCallback && called) {
          throw exception;
        }
        return done(exception);
      }
      if (!fnExpectsCallback) {
        if (result && result.then && typeof result.then === "function") {
          result.then(then, done);
        } else if (result instanceof Error) {
          done(result);
        } else {
          then(result);
        }
      }
    }
    function done(error2, ...output2) {
      if (!called) {
        called = true;
        callback(error2, ...output2);
      }
    }
    function then(value) {
      done(null, value);
    }
  }
  const path$2 = { basename, dirname, extname, join, sep: "/" };
  function basename(path2, ext) {
    if (ext !== void 0 && typeof ext !== "string") {
      throw new TypeError('"ext" argument must be a string');
    }
    assertPath$2(path2);
    let start2 = 0;
    let end2 = -1;
    let index2 = path2.length;
    let seenNonSlash;
    if (ext === void 0 || ext.length === 0 || ext.length > path2.length) {
      while (index2--) {
        if (path2.codePointAt(index2) === 47) {
          if (seenNonSlash) {
            start2 = index2 + 1;
            break;
          }
        } else if (end2 < 0) {
          seenNonSlash = true;
          end2 = index2 + 1;
        }
      }
      return end2 < 0 ? "" : path2.slice(start2, end2);
    }
    if (ext === path2) {
      return "";
    }
    let firstNonSlashEnd = -1;
    let extIndex = ext.length - 1;
    while (index2--) {
      if (path2.codePointAt(index2) === 47) {
        if (seenNonSlash) {
          start2 = index2 + 1;
          break;
        }
      } else {
        if (firstNonSlashEnd < 0) {
          seenNonSlash = true;
          firstNonSlashEnd = index2 + 1;
        }
        if (extIndex > -1) {
          if (path2.codePointAt(index2) === ext.codePointAt(extIndex--)) {
            if (extIndex < 0) {
              end2 = index2;
            }
          } else {
            extIndex = -1;
            end2 = firstNonSlashEnd;
          }
        }
      }
    }
    if (start2 === end2) {
      end2 = firstNonSlashEnd;
    } else if (end2 < 0) {
      end2 = path2.length;
    }
    return path2.slice(start2, end2);
  }
  function dirname(path2) {
    assertPath$2(path2);
    if (path2.length === 0) {
      return ".";
    }
    let end2 = -1;
    let index2 = path2.length;
    let unmatchedSlash;
    while (--index2) {
      if (path2.codePointAt(index2) === 47) {
        if (unmatchedSlash) {
          end2 = index2;
          break;
        }
      } else if (!unmatchedSlash) {
        unmatchedSlash = true;
      }
    }
    return end2 < 0 ? path2.codePointAt(0) === 47 ? "/" : "." : end2 === 1 && path2.codePointAt(0) === 47 ? "//" : path2.slice(0, end2);
  }
  function extname(path2) {
    assertPath$2(path2);
    let index2 = path2.length;
    let end2 = -1;
    let startPart = 0;
    let startDot = -1;
    let preDotState = 0;
    let unmatchedSlash;
    while (index2--) {
      const code2 = path2.codePointAt(index2);
      if (code2 === 47) {
        if (unmatchedSlash) {
          startPart = index2 + 1;
          break;
        }
        continue;
      }
      if (end2 < 0) {
        unmatchedSlash = true;
        end2 = index2 + 1;
      }
      if (code2 === 46) {
        if (startDot < 0) {
          startDot = index2;
        } else if (preDotState !== 1) {
          preDotState = 1;
        }
      } else if (startDot > -1) {
        preDotState = -1;
      }
    }
    if (startDot < 0 || end2 < 0 || preDotState === 0 || preDotState === 1 && startDot === end2 - 1 && startDot === startPart + 1) {
      return "";
    }
    return path2.slice(startDot, end2);
  }
  function join(...segments) {
    let index2 = -1;
    let joined;
    while (++index2 < segments.length) {
      assertPath$2(segments[index2]);
      if (segments[index2]) {
        joined = joined === void 0 ? segments[index2] : joined + "/" + segments[index2];
      }
    }
    return joined === void 0 ? "." : normalize$1(joined);
  }
  function normalize$1(path2) {
    assertPath$2(path2);
    const absolute = path2.codePointAt(0) === 47;
    let value = normalizeString(path2, !absolute);
    if (value.length === 0 && !absolute) {
      value = ".";
    }
    if (value.length > 0 && path2.codePointAt(path2.length - 1) === 47) {
      value += "/";
    }
    return absolute ? "/" + value : value;
  }
  function normalizeString(path2, allowAboveRoot) {
    let result = "";
    let lastSegmentLength = 0;
    let lastSlash = -1;
    let dots = 0;
    let index2 = -1;
    let code2;
    let lastSlashIndex;
    while (++index2 <= path2.length) {
      if (index2 < path2.length) {
        code2 = path2.codePointAt(index2);
      } else if (code2 === 47) {
        break;
      } else {
        code2 = 47;
      }
      if (code2 === 47) {
        if (lastSlash === index2 - 1 || dots === 1)
          ;
        else if (lastSlash !== index2 - 1 && dots === 2) {
          if (result.length < 2 || lastSegmentLength !== 2 || result.codePointAt(result.length - 1) !== 46 || result.codePointAt(result.length - 2) !== 46) {
            if (result.length > 2) {
              lastSlashIndex = result.lastIndexOf("/");
              if (lastSlashIndex !== result.length - 1) {
                if (lastSlashIndex < 0) {
                  result = "";
                  lastSegmentLength = 0;
                } else {
                  result = result.slice(0, lastSlashIndex);
                  lastSegmentLength = result.length - 1 - result.lastIndexOf("/");
                }
                lastSlash = index2;
                dots = 0;
                continue;
              }
            } else if (result.length > 0) {
              result = "";
              lastSegmentLength = 0;
              lastSlash = index2;
              dots = 0;
              continue;
            }
          }
          if (allowAboveRoot) {
            result = result.length > 0 ? result + "/.." : "..";
            lastSegmentLength = 2;
          }
        } else {
          if (result.length > 0) {
            result += "/" + path2.slice(lastSlash + 1, index2);
          } else {
            result = path2.slice(lastSlash + 1, index2);
          }
          lastSegmentLength = index2 - lastSlash - 1;
        }
        lastSlash = index2;
        dots = 0;
      } else if (code2 === 46 && dots > -1) {
        dots++;
      } else {
        dots = -1;
      }
    }
    return result;
  }
  function assertPath$2(path2) {
    if (typeof path2 !== "string") {
      throw new TypeError(
        "Path must be a string. Received " + JSON.stringify(path2)
      );
    }
  }
  const proc = { cwd };
  function cwd() {
    return "/";
  }
  function isUrl(fileUrlOrPath) {
    return Boolean(
      fileUrlOrPath !== null && typeof fileUrlOrPath === "object" && "href" in fileUrlOrPath && fileUrlOrPath.href && "protocol" in fileUrlOrPath && fileUrlOrPath.protocol && fileUrlOrPath.auth === void 0
    );
  }
  function urlToPath(path2) {
    if (typeof path2 === "string") {
      path2 = new URL(path2);
    } else if (!isUrl(path2)) {
      const error2 = new TypeError(
        'The "path" argument must be of type string or an instance of URL. Received `' + path2 + "`"
      );
      error2.code = "ERR_INVALID_ARG_TYPE";
      throw error2;
    }
    if (path2.protocol !== "file:") {
      const error2 = new TypeError("The URL must be of scheme file");
      error2.code = "ERR_INVALID_URL_SCHEME";
      throw error2;
    }
    return getPathFromURLPosix(path2);
  }
  function getPathFromURLPosix(url2) {
    if (url2.hostname !== "") {
      const error2 = new TypeError(
        'File URL host must be "localhost" or empty on darwin'
      );
      error2.code = "ERR_INVALID_FILE_URL_HOST";
      throw error2;
    }
    const pathname = url2.pathname;
    let index2 = -1;
    while (++index2 < pathname.length) {
      if (pathname.codePointAt(index2) === 37 && pathname.codePointAt(index2 + 1) === 50) {
        const third = pathname.codePointAt(index2 + 2);
        if (third === 70 || third === 102) {
          const error2 = new TypeError(
            "File URL path must not include encoded / characters"
          );
          error2.code = "ERR_INVALID_FILE_URL_PATH";
          throw error2;
        }
      }
    }
    return decodeURIComponent(pathname);
  }
  const order$1 = [
    "history",
    "path",
    "basename",
    "stem",
    "extname",
    "dirname"
  ];
  class VFile {
    constructor(value) {
      let options;
      if (!value) {
        options = {};
      } else if (isUrl(value)) {
        options = { path: value };
      } else if (typeof value === "string" || isUint8Array$1(value)) {
        options = { value };
      } else {
        options = value;
      }
      this.cwd = proc.cwd();
      this.data = {};
      this.history = [];
      this.messages = [];
      this.value;
      this.map;
      this.result;
      this.stored;
      let index2 = -1;
      while (++index2 < order$1.length) {
        const prop2 = order$1[index2];
        if (prop2 in options && options[prop2] !== void 0 && options[prop2] !== null) {
          this[prop2] = prop2 === "history" ? [...options[prop2]] : options[prop2];
        }
      }
      let prop;
      for (prop in options) {
        if (!order$1.includes(prop)) {
          this[prop] = options[prop];
        }
      }
    }
    get basename() {
      return typeof this.path === "string" ? path$2.basename(this.path) : void 0;
    }
    set basename(basename2) {
      assertNonEmpty(basename2, "basename");
      assertPart(basename2, "basename");
      this.path = path$2.join(this.dirname || "", basename2);
    }
    get dirname() {
      return typeof this.path === "string" ? path$2.dirname(this.path) : void 0;
    }
    set dirname(dirname2) {
      assertPath$1(this.basename, "dirname");
      this.path = path$2.join(dirname2 || "", this.basename);
    }
    get extname() {
      return typeof this.path === "string" ? path$2.extname(this.path) : void 0;
    }
    set extname(extname2) {
      assertPart(extname2, "extname");
      assertPath$1(this.dirname, "extname");
      if (extname2) {
        if (extname2.codePointAt(0) !== 46) {
          throw new Error("`extname` must start with `.`");
        }
        if (extname2.includes(".", 1)) {
          throw new Error("`extname` cannot contain multiple dots");
        }
      }
      this.path = path$2.join(this.dirname, this.stem + (extname2 || ""));
    }
    get path() {
      return this.history[this.history.length - 1];
    }
    set path(path2) {
      if (isUrl(path2)) {
        path2 = urlToPath(path2);
      }
      assertNonEmpty(path2, "path");
      if (this.path !== path2) {
        this.history.push(path2);
      }
    }
    get stem() {
      return typeof this.path === "string" ? path$2.basename(this.path, this.extname) : void 0;
    }
    set stem(stem) {
      assertNonEmpty(stem, "stem");
      assertPart(stem, "stem");
      this.path = path$2.join(this.dirname || "", stem + (this.extname || ""));
    }
    fail(causeOrReason, optionsOrParentOrPlace, origin) {
      const message = this.message(causeOrReason, optionsOrParentOrPlace, origin);
      message.fatal = true;
      throw message;
    }
    info(causeOrReason, optionsOrParentOrPlace, origin) {
      const message = this.message(causeOrReason, optionsOrParentOrPlace, origin);
      message.fatal = void 0;
      return message;
    }
    message(causeOrReason, optionsOrParentOrPlace, origin) {
      const message = new VFileMessage(
        causeOrReason,
        optionsOrParentOrPlace,
        origin
      );
      if (this.path) {
        message.name = this.path + ":" + message.name;
        message.file = this.path;
      }
      message.fatal = false;
      this.messages.push(message);
      return message;
    }
    toString(encoding) {
      if (this.value === void 0) {
        return "";
      }
      if (typeof this.value === "string") {
        return this.value;
      }
      const decoder = new TextDecoder(encoding || void 0);
      return decoder.decode(this.value);
    }
  }
  function assertPart(part, name2) {
    if (part && part.includes(path$2.sep)) {
      throw new Error(
        "`" + name2 + "` cannot be a path: did not expect `" + path$2.sep + "`"
      );
    }
  }
  function assertNonEmpty(part, name2) {
    if (!part) {
      throw new Error("`" + name2 + "` cannot be empty");
    }
  }
  function assertPath$1(path2, name2) {
    if (!path2) {
      throw new Error("Setting `" + name2 + "` requires `path` to be set too");
    }
  }
  function isUint8Array$1(value) {
    return Boolean(
      value && typeof value === "object" && "byteLength" in value && "byteOffset" in value
    );
  }
  const CallableInstance = function(property) {
    const self2 = this;
    const constr = self2.constructor;
    const proto2 = constr.prototype;
    const value = proto2[property];
    const apply = function() {
      return value.apply(apply, arguments);
    };
    Object.setPrototypeOf(apply, proto2);
    return apply;
  };
  const own$4 = {}.hasOwnProperty;
  class Processor extends CallableInstance {
    constructor() {
      super("copy");
      this.Compiler = void 0;
      this.Parser = void 0;
      this.attachers = [];
      this.compiler = void 0;
      this.freezeIndex = -1;
      this.frozen = void 0;
      this.namespace = {};
      this.parser = void 0;
      this.transformers = trough();
    }
    copy() {
      const destination = new Processor();
      let index2 = -1;
      while (++index2 < this.attachers.length) {
        const attacher = this.attachers[index2];
        destination.use(...attacher);
      }
      destination.data(extend$3(true, {}, this.namespace));
      return destination;
    }
    data(key, value) {
      if (typeof key === "string") {
        if (arguments.length === 2) {
          assertUnfrozen("data", this.frozen);
          this.namespace[key] = value;
          return this;
        }
        return own$4.call(this.namespace, key) && this.namespace[key] || void 0;
      }
      if (key) {
        assertUnfrozen("data", this.frozen);
        this.namespace = key;
        return this;
      }
      return this.namespace;
    }
    freeze() {
      if (this.frozen) {
        return this;
      }
      const self2 = this;
      while (++this.freezeIndex < this.attachers.length) {
        const [attacher, ...options] = this.attachers[this.freezeIndex];
        if (options[0] === false) {
          continue;
        }
        if (options[0] === true) {
          options[0] = void 0;
        }
        const transformer = attacher.call(self2, ...options);
        if (typeof transformer === "function") {
          this.transformers.use(transformer);
        }
      }
      this.frozen = true;
      this.freezeIndex = Number.POSITIVE_INFINITY;
      return this;
    }
    parse(file) {
      this.freeze();
      const realFile = vfile(file);
      const parser2 = this.parser || this.Parser;
      assertParser("parse", parser2);
      return parser2(String(realFile), realFile);
    }
    process(file, done) {
      const self2 = this;
      this.freeze();
      assertParser("process", this.parser || this.Parser);
      assertCompiler("process", this.compiler || this.Compiler);
      return done ? executor(void 0, done) : new Promise(executor);
      function executor(resolve2, reject) {
        const realFile = vfile(file);
        const parseTree = self2.parse(realFile);
        self2.run(parseTree, realFile, function(error2, tree, file2) {
          if (error2 || !tree || !file2) {
            return realDone(error2);
          }
          const compileTree = tree;
          const compileResult = self2.stringify(compileTree, file2);
          if (looksLikeAValue(compileResult)) {
            file2.value = compileResult;
          } else {
            file2.result = compileResult;
          }
          realDone(error2, file2);
        });
        function realDone(error2, file2) {
          if (error2 || !file2) {
            reject(error2);
          } else if (resolve2) {
            resolve2(file2);
          } else {
            done(void 0, file2);
          }
        }
      }
    }
    processSync(file) {
      let complete = false;
      let result;
      this.freeze();
      assertParser("processSync", this.parser || this.Parser);
      assertCompiler("processSync", this.compiler || this.Compiler);
      this.process(file, realDone);
      assertDone("processSync", "process", complete);
      return result;
      function realDone(error2, file2) {
        complete = true;
        bail(error2);
        result = file2;
      }
    }
    run(tree, file, done) {
      assertNode(tree);
      this.freeze();
      const transformers = this.transformers;
      if (!done && typeof file === "function") {
        done = file;
        file = void 0;
      }
      return done ? executor(void 0, done) : new Promise(executor);
      function executor(resolve2, reject) {
        const realFile = vfile(file);
        transformers.run(tree, realFile, realDone);
        function realDone(error2, outputTree, file2) {
          const resultingTree = outputTree || tree;
          if (error2) {
            reject(error2);
          } else if (resolve2) {
            resolve2(resultingTree);
          } else {
            done(void 0, resultingTree, file2);
          }
        }
      }
    }
    runSync(tree, file) {
      let complete = false;
      let result;
      this.run(tree, file, realDone);
      assertDone("runSync", "run", complete);
      return result;
      function realDone(error2, tree2) {
        bail(error2);
        result = tree2;
        complete = true;
      }
    }
    stringify(tree, file) {
      this.freeze();
      const realFile = vfile(file);
      const compiler2 = this.compiler || this.Compiler;
      assertCompiler("stringify", compiler2);
      assertNode(tree);
      return compiler2(tree, realFile);
    }
    use(value, ...parameters) {
      const attachers = this.attachers;
      const namespace2 = this.namespace;
      assertUnfrozen("use", this.frozen);
      if (value === null || value === void 0)
        ;
      else if (typeof value === "function") {
        addPlugin(value, parameters);
      } else if (typeof value === "object") {
        if (Array.isArray(value)) {
          addList(value);
        } else {
          addPreset(value);
        }
      } else {
        throw new TypeError("Expected usable value, not `" + value + "`");
      }
      return this;
      function add2(value2) {
        if (typeof value2 === "function") {
          addPlugin(value2, []);
        } else if (typeof value2 === "object") {
          if (Array.isArray(value2)) {
            const [plugin, ...parameters2] = value2;
            addPlugin(plugin, parameters2);
          } else {
            addPreset(value2);
          }
        } else {
          throw new TypeError("Expected usable value, not `" + value2 + "`");
        }
      }
      function addPreset(result) {
        if (!("plugins" in result) && !("settings" in result)) {
          throw new Error(
            "Expected usable value but received an empty preset, which is probably a mistake: presets typically come with `plugins` and sometimes with `settings`, but this has neither"
          );
        }
        addList(result.plugins);
        if (result.settings) {
          namespace2.settings = extend$3(true, namespace2.settings, result.settings);
        }
      }
      function addList(plugins2) {
        let index2 = -1;
        if (plugins2 === null || plugins2 === void 0)
          ;
        else if (Array.isArray(plugins2)) {
          while (++index2 < plugins2.length) {
            const thing = plugins2[index2];
            add2(thing);
          }
        } else {
          throw new TypeError("Expected a list of plugins, not `" + plugins2 + "`");
        }
      }
      function addPlugin(plugin, parameters2) {
        let index2 = -1;
        let entryIndex = -1;
        while (++index2 < attachers.length) {
          if (attachers[index2][0] === plugin) {
            entryIndex = index2;
            break;
          }
        }
        if (entryIndex === -1) {
          attachers.push([plugin, ...parameters2]);
        } else if (parameters2.length > 0) {
          let [primary, ...rest] = parameters2;
          const currentPrimary = attachers[entryIndex][1];
          if (isPlainObject$3(currentPrimary) && isPlainObject$3(primary)) {
            primary = extend$3(true, currentPrimary, primary);
          }
          attachers[entryIndex] = [plugin, primary, ...rest];
        }
      }
    }
  }
  const unified = new Processor().freeze();
  function assertParser(name2, value) {
    if (typeof value !== "function") {
      throw new TypeError("Cannot `" + name2 + "` without `parser`");
    }
  }
  function assertCompiler(name2, value) {
    if (typeof value !== "function") {
      throw new TypeError("Cannot `" + name2 + "` without `compiler`");
    }
  }
  function assertUnfrozen(name2, frozen) {
    if (frozen) {
      throw new Error(
        "Cannot call `" + name2 + "` on a frozen processor.\nCreate a new processor first, by calling it: use `processor()` instead of `processor`."
      );
    }
  }
  function assertNode(node2) {
    if (!isPlainObject$3(node2) || typeof node2.type !== "string") {
      throw new TypeError("Expected node, got `" + node2 + "`");
    }
  }
  function assertDone(name2, asyncName, complete) {
    if (!complete) {
      throw new Error(
        "`" + name2 + "` finished async. Use `" + asyncName + "` instead"
      );
    }
  }
  function vfile(value) {
    return looksLikeAVFile(value) ? value : new VFile(value);
  }
  function looksLikeAVFile(value) {
    return Boolean(
      value && typeof value === "object" && "message" in value && "messages" in value
    );
  }
  function looksLikeAValue(value) {
    return typeof value === "string" || isUint8Array(value);
  }
  function isUint8Array(value) {
    return Boolean(
      value && typeof value === "object" && "byteLength" in value && "byteOffset" in value
    );
  }
  const changelog = "https://github.com/remarkjs/react-markdown/blob/main/changelog.md";
  const emptyPlugins = [];
  const emptyRemarkRehypeOptions = { allowDangerousHtml: true };
  const safeProtocol = /^(https?|ircs?|mailto|xmpp)$/i;
  const deprecations = [
    { from: "astPlugins", id: "remove-buggy-html-in-markdown-parser" },
    { from: "allowDangerousHtml", id: "remove-buggy-html-in-markdown-parser" },
    {
      from: "allowNode",
      id: "replace-allownode-allowedtypes-and-disallowedtypes",
      to: "allowElement"
    },
    {
      from: "allowedTypes",
      id: "replace-allownode-allowedtypes-and-disallowedtypes",
      to: "allowedElements"
    },
    {
      from: "disallowedTypes",
      id: "replace-allownode-allowedtypes-and-disallowedtypes",
      to: "disallowedElements"
    },
    { from: "escapeHtml", id: "remove-buggy-html-in-markdown-parser" },
    { from: "includeElementIndex", id: "#remove-includeelementindex" },
    {
      from: "includeNodeIndex",
      id: "change-includenodeindex-to-includeelementindex"
    },
    { from: "linkTarget", id: "remove-linktarget" },
    { from: "plugins", id: "change-plugins-to-remarkplugins", to: "remarkPlugins" },
    { from: "rawSourcePos", id: "#remove-rawsourcepos" },
    { from: "renderers", id: "change-renderers-to-components", to: "components" },
    { from: "source", id: "change-source-to-children", to: "children" },
    { from: "sourcePos", id: "#remove-sourcepos" },
    { from: "transformImageUri", id: "#add-urltransform", to: "urlTransform" },
    { from: "transformLinkUri", id: "#add-urltransform", to: "urlTransform" }
  ];
  function Markdown$2(options) {
    const allowedElements = options.allowedElements;
    const allowElement = options.allowElement;
    const children2 = options.children || "";
    const className = options.className;
    const components = options.components;
    const disallowedElements = options.disallowedElements;
    const rehypePlugins = options.rehypePlugins || emptyPlugins;
    const remarkPlugins = options.remarkPlugins || emptyPlugins;
    const remarkRehypeOptions = options.remarkRehypeOptions ? { ...options.remarkRehypeOptions, ...emptyRemarkRehypeOptions } : emptyRemarkRehypeOptions;
    const skipHtml = options.skipHtml;
    const unwrapDisallowed = options.unwrapDisallowed;
    const urlTransform = options.urlTransform || defaultUrlTransform;
    const processor = unified().use(remarkParse).use(remarkPlugins).use(remarkRehype, remarkRehypeOptions).use(rehypePlugins);
    const file = new VFile();
    if (typeof children2 === "string") {
      file.value = children2;
    }
    for (const deprecation2 of deprecations) {
      if (Object.hasOwn(options, deprecation2.from)) {
        unreachable(
          "Unexpected `" + deprecation2.from + "` prop, " + (deprecation2.to ? "use `" + deprecation2.to + "` instead" : "remove it") + " (see <" + changelog + "#" + deprecation2.id + "> for more info)"
        );
      }
    }
    const mdastTree = processor.parse(file);
    let hastTree = processor.runSync(mdastTree, file);
    if (className) {
      hastTree = {
        type: "element",
        tagName: "div",
        properties: { className },
        children: hastTree.type === "root" ? hastTree.children : [hastTree]
      };
    }
    visit$1(hastTree, transform);
    return toJsxRuntime(hastTree, {
      Fragment: jsxRuntime.exports.Fragment,
      components,
      ignoreInvalidStyle: true,
      jsx: jsxRuntime.exports.jsx,
      jsxs: jsxRuntime.exports.jsxs,
      passKeys: true,
      passNode: true
    });
    function transform(node2, index2, parent) {
      if (node2.type === "raw" && parent && typeof index2 === "number") {
        if (skipHtml) {
          parent.children.splice(index2, 1);
        } else {
          parent.children[index2] = { type: "text", value: node2.value };
        }
        return index2;
      }
      if (node2.type === "element") {
        let key;
        for (key in urlAttributes) {
          if (Object.hasOwn(urlAttributes, key) && Object.hasOwn(node2.properties, key)) {
            const value = node2.properties[key];
            const test2 = urlAttributes[key];
            if (test2 === null || test2.includes(node2.tagName)) {
              node2.properties[key] = urlTransform(String(value || ""), key, node2);
            }
          }
        }
      }
      if (node2.type === "element") {
        let remove2 = allowedElements ? !allowedElements.includes(node2.tagName) : disallowedElements ? disallowedElements.includes(node2.tagName) : false;
        if (!remove2 && allowElement && typeof index2 === "number") {
          remove2 = !allowElement(node2, index2, parent);
        }
        if (remove2 && parent && typeof index2 === "number") {
          if (unwrapDisallowed && node2.children) {
            parent.children.splice(index2, 1, ...node2.children);
          } else {
            parent.children.splice(index2, 1);
          }
          return index2;
        }
      }
    }
  }
  function defaultUrlTransform(value) {
    const colon = value.indexOf(":");
    const questionMark = value.indexOf("?");
    const numberSign = value.indexOf("#");
    const slash = value.indexOf("/");
    if (colon < 0 || slash > -1 && colon > slash || questionMark > -1 && colon > questionMark || numberSign > -1 && colon > numberSign || safeProtocol.test(value.slice(0, colon))) {
      return value;
    }
    return "";
  }
  function ccount(value, character) {
    const source = String(value);
    if (typeof character !== "string") {
      throw new TypeError("Expected character");
    }
    let count2 = 0;
    let index2 = source.indexOf(character);
    while (index2 !== -1) {
      count2++;
      index2 = source.indexOf(character, index2 + character.length);
    }
    return count2;
  }
  function escapeStringRegexp(string2) {
    if (typeof string2 !== "string") {
      throw new TypeError("Expected a string");
    }
    return string2.replace(/[|\\{}()[\]^$+*?.]/g, "\\$&").replace(/-/g, "\\x2d");
  }
  function findAndReplace(tree, list2, options) {
    const settings2 = options || {};
    const ignored = convert$1(settings2.ignore || []);
    const pairs = toPairs(list2);
    let pairIndex = -1;
    while (++pairIndex < pairs.length) {
      visitParents$1(tree, "text", visitor);
    }
    function visitor(node2, parents) {
      let index2 = -1;
      let grandparent;
      while (++index2 < parents.length) {
        const parent = parents[index2];
        const siblings = grandparent ? grandparent.children : void 0;
        if (ignored(
          parent,
          siblings ? siblings.indexOf(parent) : void 0,
          grandparent
        )) {
          return;
        }
        grandparent = parent;
      }
      if (grandparent) {
        return handler(node2, parents);
      }
    }
    function handler(node2, parents) {
      const parent = parents[parents.length - 1];
      const find2 = pairs[pairIndex][0];
      const replace2 = pairs[pairIndex][1];
      let start2 = 0;
      const siblings = parent.children;
      const index2 = siblings.indexOf(node2);
      let change = false;
      let nodes = [];
      find2.lastIndex = 0;
      let match2 = find2.exec(node2.value);
      while (match2) {
        const position2 = match2.index;
        const matchObject = {
          index: match2.index,
          input: match2.input,
          stack: [...parents, node2]
        };
        let value = replace2(...match2, matchObject);
        if (typeof value === "string") {
          value = value.length > 0 ? { type: "text", value } : void 0;
        }
        if (value === false) {
          find2.lastIndex = position2 + 1;
        } else {
          if (start2 !== position2) {
            nodes.push({
              type: "text",
              value: node2.value.slice(start2, position2)
            });
          }
          if (Array.isArray(value)) {
            nodes.push(...value);
          } else if (value) {
            nodes.push(value);
          }
          start2 = position2 + match2[0].length;
          change = true;
        }
        if (!find2.global) {
          break;
        }
        match2 = find2.exec(node2.value);
      }
      if (change) {
        if (start2 < node2.value.length) {
          nodes.push({ type: "text", value: node2.value.slice(start2) });
        }
        parent.children.splice(index2, 1, ...nodes);
      } else {
        nodes = [node2];
      }
      return index2 + nodes.length;
    }
  }
  function toPairs(tupleOrList) {
    const result = [];
    if (!Array.isArray(tupleOrList)) {
      throw new TypeError("Expected find and replace tuple or list of tuples");
    }
    const list2 = !tupleOrList[0] || Array.isArray(tupleOrList[0]) ? tupleOrList : [tupleOrList];
    let index2 = -1;
    while (++index2 < list2.length) {
      const tuple = list2[index2];
      result.push([toExpression(tuple[0]), toFunction(tuple[1])]);
    }
    return result;
  }
  function toExpression(find2) {
    return typeof find2 === "string" ? new RegExp(escapeStringRegexp(find2), "g") : find2;
  }
  function toFunction(replace2) {
    return typeof replace2 === "function" ? replace2 : function() {
      return replace2;
    };
  }
  const inConstruct = "phrasing";
  const notInConstruct = ["autolink", "link", "image", "label"];
  function gfmAutolinkLiteralFromMarkdown() {
    return {
      transforms: [transformGfmAutolinkLiterals],
      enter: {
        literalAutolink: enterLiteralAutolink,
        literalAutolinkEmail: enterLiteralAutolinkValue,
        literalAutolinkHttp: enterLiteralAutolinkValue,
        literalAutolinkWww: enterLiteralAutolinkValue
      },
      exit: {
        literalAutolink: exitLiteralAutolink,
        literalAutolinkEmail: exitLiteralAutolinkEmail,
        literalAutolinkHttp: exitLiteralAutolinkHttp,
        literalAutolinkWww: exitLiteralAutolinkWww
      }
    };
  }
  function gfmAutolinkLiteralToMarkdown() {
    return {
      unsafe: [
        {
          character: "@",
          before: "[+\\-.\\w]",
          after: "[\\-.\\w]",
          inConstruct,
          notInConstruct
        },
        {
          character: ".",
          before: "[Ww]",
          after: "[\\-.\\w]",
          inConstruct,
          notInConstruct
        },
        {
          character: ":",
          before: "[ps]",
          after: "\\/",
          inConstruct,
          notInConstruct
        }
      ]
    };
  }
  function enterLiteralAutolink(token) {
    this.enter({ type: "link", title: null, url: "", children: [] }, token);
  }
  function enterLiteralAutolinkValue(token) {
    this.config.enter.autolinkProtocol.call(this, token);
  }
  function exitLiteralAutolinkHttp(token) {
    this.config.exit.autolinkProtocol.call(this, token);
  }
  function exitLiteralAutolinkWww(token) {
    this.config.exit.data.call(this, token);
    const node2 = this.stack[this.stack.length - 1];
    ok$2(node2.type === "link");
    node2.url = "http://" + this.sliceSerialize(token);
  }
  function exitLiteralAutolinkEmail(token) {
    this.config.exit.autolinkEmail.call(this, token);
  }
  function exitLiteralAutolink(token) {
    this.exit(token);
  }
  function transformGfmAutolinkLiterals(tree) {
    findAndReplace(
      tree,
      [
        [/(https?:\/\/|www(?=\.))([-.\w]+)([^ \t\r\n]*)/gi, findUrl],
        [/([-.\w+]+)@([-\w]+(?:\.[-\w]+)+)/g, findEmail]
      ],
      { ignore: ["link", "linkReference"] }
    );
  }
  function findUrl(_2, protocol, domain2, path2, match2) {
    let prefix = "";
    if (!previous(match2)) {
      return false;
    }
    if (/^w/i.test(protocol)) {
      domain2 = protocol + domain2;
      protocol = "";
      prefix = "http://";
    }
    if (!isCorrectDomain(domain2)) {
      return false;
    }
    const parts = splitUrl(domain2 + path2);
    if (!parts[0])
      return false;
    const result = {
      type: "link",
      title: null,
      url: prefix + protocol + parts[0],
      children: [{ type: "text", value: protocol + parts[0] }]
    };
    if (parts[1]) {
      return [result, { type: "text", value: parts[1] }];
    }
    return result;
  }
  function findEmail(_2, atext, label, match2) {
    if (!previous(match2, true) || /[-\d_]$/.test(label)) {
      return false;
    }
    return {
      type: "link",
      title: null,
      url: "mailto:" + atext + "@" + label,
      children: [{ type: "text", value: atext + "@" + label }]
    };
  }
  function isCorrectDomain(domain2) {
    const parts = domain2.split(".");
    if (parts.length < 2 || parts[parts.length - 1] && (/_/.test(parts[parts.length - 1]) || !/[a-zA-Z\d]/.test(parts[parts.length - 1])) || parts[parts.length - 2] && (/_/.test(parts[parts.length - 2]) || !/[a-zA-Z\d]/.test(parts[parts.length - 2]))) {
      return false;
    }
    return true;
  }
  function splitUrl(url2) {
    const trailExec = /[!"&'),.:;<>?\]}]+$/.exec(url2);
    if (!trailExec) {
      return [url2, void 0];
    }
    url2 = url2.slice(0, trailExec.index);
    let trail2 = trailExec[0];
    let closingParenIndex = trail2.indexOf(")");
    const openingParens = ccount(url2, "(");
    let closingParens = ccount(url2, ")");
    while (closingParenIndex !== -1 && openingParens > closingParens) {
      url2 += trail2.slice(0, closingParenIndex + 1);
      trail2 = trail2.slice(closingParenIndex + 1);
      closingParenIndex = trail2.indexOf(")");
      closingParens++;
    }
    return [url2, trail2];
  }
  function previous(match2, email) {
    const code2 = match2.input.charCodeAt(match2.index - 1);
    return (match2.index === 0 || unicodeWhitespace(code2) || unicodePunctuation(code2)) && (!email || code2 !== 47);
  }
  footnoteReference.peek = footnoteReferencePeek;
  function gfmFootnoteFromMarkdown() {
    return {
      enter: {
        gfmFootnoteDefinition: enterFootnoteDefinition,
        gfmFootnoteDefinitionLabelString: enterFootnoteDefinitionLabelString,
        gfmFootnoteCall: enterFootnoteCall,
        gfmFootnoteCallString: enterFootnoteCallString
      },
      exit: {
        gfmFootnoteDefinition: exitFootnoteDefinition,
        gfmFootnoteDefinitionLabelString: exitFootnoteDefinitionLabelString,
        gfmFootnoteCall: exitFootnoteCall,
        gfmFootnoteCallString: exitFootnoteCallString
      }
    };
  }
  function gfmFootnoteToMarkdown() {
    return {
      unsafe: [{ character: "[", inConstruct: ["phrasing", "label", "reference"] }],
      handlers: { footnoteDefinition, footnoteReference }
    };
  }
  function enterFootnoteDefinition(token) {
    this.enter(
      { type: "footnoteDefinition", identifier: "", label: "", children: [] },
      token
    );
  }
  function enterFootnoteDefinitionLabelString() {
    this.buffer();
  }
  function exitFootnoteDefinitionLabelString(token) {
    const label = this.resume();
    const node2 = this.stack[this.stack.length - 1];
    ok$2(node2.type === "footnoteDefinition");
    node2.label = label;
    node2.identifier = normalizeIdentifier(
      this.sliceSerialize(token)
    ).toLowerCase();
  }
  function exitFootnoteDefinition(token) {
    this.exit(token);
  }
  function enterFootnoteCall(token) {
    this.enter({ type: "footnoteReference", identifier: "", label: "" }, token);
  }
  function enterFootnoteCallString() {
    this.buffer();
  }
  function exitFootnoteCallString(token) {
    const label = this.resume();
    const node2 = this.stack[this.stack.length - 1];
    ok$2(node2.type === "footnoteReference");
    node2.label = label;
    node2.identifier = normalizeIdentifier(
      this.sliceSerialize(token)
    ).toLowerCase();
  }
  function exitFootnoteCall(token) {
    this.exit(token);
  }
  function footnoteReference(node2, _2, state, info) {
    const tracker = state.createTracker(info);
    let value = tracker.move("[^");
    const exit2 = state.enter("footnoteReference");
    const subexit = state.enter("reference");
    value += tracker.move(
      state.safe(state.associationId(node2), {
        ...tracker.current(),
        before: value,
        after: "]"
      })
    );
    subexit();
    exit2();
    value += tracker.move("]");
    return value;
  }
  function footnoteReferencePeek() {
    return "[";
  }
  function footnoteDefinition(node2, _2, state, info) {
    const tracker = state.createTracker(info);
    let value = tracker.move("[^");
    const exit2 = state.enter("footnoteDefinition");
    const subexit = state.enter("label");
    value += tracker.move(
      state.safe(state.associationId(node2), {
        ...tracker.current(),
        before: value,
        after: "]"
      })
    );
    subexit();
    value += tracker.move(
      "]:" + (node2.children && node2.children.length > 0 ? " " : "")
    );
    tracker.shift(4);
    value += tracker.move(
      state.indentLines(state.containerFlow(node2, tracker.current()), map$4)
    );
    exit2();
    return value;
  }
  function map$4(line, index2, blank) {
    if (index2 === 0) {
      return line;
    }
    return (blank ? "" : "    ") + line;
  }
  const constructsWithoutStrikethrough = [
    "autolink",
    "destinationLiteral",
    "destinationRaw",
    "reference",
    "titleQuote",
    "titleApostrophe"
  ];
  handleDelete.peek = peekDelete;
  function gfmStrikethroughFromMarkdown() {
    return {
      canContainEols: ["delete"],
      enter: { strikethrough: enterStrikethrough },
      exit: { strikethrough: exitStrikethrough }
    };
  }
  function gfmStrikethroughToMarkdown() {
    return {
      unsafe: [
        {
          character: "~",
          inConstruct: "phrasing",
          notInConstruct: constructsWithoutStrikethrough
        }
      ],
      handlers: { delete: handleDelete }
    };
  }
  function enterStrikethrough(token) {
    this.enter({ type: "delete", children: [] }, token);
  }
  function exitStrikethrough(token) {
    this.exit(token);
  }
  function handleDelete(node2, _2, state, info) {
    const tracker = state.createTracker(info);
    const exit2 = state.enter("strikethrough");
    let value = tracker.move("~~");
    value += state.containerPhrasing(node2, {
      ...tracker.current(),
      before: value,
      after: "~"
    });
    value += tracker.move("~~");
    exit2();
    return value;
  }
  function peekDelete() {
    return "~";
  }
  function markdownTable(table2, options = {}) {
    const align = (options.align || []).concat();
    const stringLength = options.stringLength || defaultStringLength;
    const alignments2 = [];
    const cellMatrix = [];
    const sizeMatrix = [];
    const longestCellByColumn = [];
    let mostCellsPerRow = 0;
    let rowIndex = -1;
    while (++rowIndex < table2.length) {
      const row2 = [];
      const sizes2 = [];
      let columnIndex2 = -1;
      if (table2[rowIndex].length > mostCellsPerRow) {
        mostCellsPerRow = table2[rowIndex].length;
      }
      while (++columnIndex2 < table2[rowIndex].length) {
        const cell = serialize(table2[rowIndex][columnIndex2]);
        if (options.alignDelimiters !== false) {
          const size2 = stringLength(cell);
          sizes2[columnIndex2] = size2;
          if (longestCellByColumn[columnIndex2] === void 0 || size2 > longestCellByColumn[columnIndex2]) {
            longestCellByColumn[columnIndex2] = size2;
          }
        }
        row2.push(cell);
      }
      cellMatrix[rowIndex] = row2;
      sizeMatrix[rowIndex] = sizes2;
    }
    let columnIndex = -1;
    if (typeof align === "object" && "length" in align) {
      while (++columnIndex < mostCellsPerRow) {
        alignments2[columnIndex] = toAlignment(align[columnIndex]);
      }
    } else {
      const code2 = toAlignment(align);
      while (++columnIndex < mostCellsPerRow) {
        alignments2[columnIndex] = code2;
      }
    }
    columnIndex = -1;
    const row = [];
    const sizes = [];
    while (++columnIndex < mostCellsPerRow) {
      const code2 = alignments2[columnIndex];
      let before = "";
      let after = "";
      if (code2 === 99) {
        before = ":";
        after = ":";
      } else if (code2 === 108) {
        before = ":";
      } else if (code2 === 114) {
        after = ":";
      }
      let size2 = options.alignDelimiters === false ? 1 : Math.max(
        1,
        longestCellByColumn[columnIndex] - before.length - after.length
      );
      const cell = before + "-".repeat(size2) + after;
      if (options.alignDelimiters !== false) {
        size2 = before.length + size2 + after.length;
        if (size2 > longestCellByColumn[columnIndex]) {
          longestCellByColumn[columnIndex] = size2;
        }
        sizes[columnIndex] = size2;
      }
      row[columnIndex] = cell;
    }
    cellMatrix.splice(1, 0, row);
    sizeMatrix.splice(1, 0, sizes);
    rowIndex = -1;
    const lines = [];
    while (++rowIndex < cellMatrix.length) {
      const row2 = cellMatrix[rowIndex];
      const sizes2 = sizeMatrix[rowIndex];
      columnIndex = -1;
      const line = [];
      while (++columnIndex < mostCellsPerRow) {
        const cell = row2[columnIndex] || "";
        let before = "";
        let after = "";
        if (options.alignDelimiters !== false) {
          const size2 = longestCellByColumn[columnIndex] - (sizes2[columnIndex] || 0);
          const code2 = alignments2[columnIndex];
          if (code2 === 114) {
            before = " ".repeat(size2);
          } else if (code2 === 99) {
            if (size2 % 2) {
              before = " ".repeat(size2 / 2 + 0.5);
              after = " ".repeat(size2 / 2 - 0.5);
            } else {
              before = " ".repeat(size2 / 2);
              after = before;
            }
          } else {
            after = " ".repeat(size2);
          }
        }
        if (options.delimiterStart !== false && !columnIndex) {
          line.push("|");
        }
        if (options.padding !== false && !(options.alignDelimiters === false && cell === "") && (options.delimiterStart !== false || columnIndex)) {
          line.push(" ");
        }
        if (options.alignDelimiters !== false) {
          line.push(before);
        }
        line.push(cell);
        if (options.alignDelimiters !== false) {
          line.push(after);
        }
        if (options.padding !== false) {
          line.push(" ");
        }
        if (options.delimiterEnd !== false || columnIndex !== mostCellsPerRow - 1) {
          line.push("|");
        }
      }
      lines.push(
        options.delimiterEnd === false ? line.join("").replace(/ +$/, "") : line.join("")
      );
    }
    return lines.join("\n");
  }
  function serialize(value) {
    return value === null || value === void 0 ? "" : String(value);
  }
  function defaultString