"""Add archived fields to main tables

Revision ID: 05b7dc79a416
Revises: 7748d3d22925
Create Date: 2023-11-09 01:30:51.793676

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "05b7dc79a416"
down_revision = "c49e41f1298b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("department", schema=None) as batch_op:
        batch_op.add_column(sa.Column("archived", sa.Boolean(), nullable=True))

    with op.batch_alter_table("entity_type", schema=None) as batch_op:
        batch_op.add_column(sa.Column("archived", sa.Boolean(), nullable=True))

    with op.batch_alter_table("status_automation", schema=None) as batch_op:
        batch_op.add_column(sa.Column("archived", sa.Boolean(), nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("status_automation", schema=None) as batch_op:
        batch_op.drop_column("archived")

    with op.batch_alter_table("entity_type", schema=None) as batch_op:
        batch_op.drop_column("archived")

    with op.batch_alter_table("department", schema=None) as batch_op:
        batch_op.drop_column("archived")

    # ### end Alembic commands ###
