import pandas as pd

ddfs = pd.read_csv("./AllDDF/flBldgStructDmgFn-Table 1.csv")
damage_columns = [c for c in ddfs.columns if c[0:2] == "ft" and c[-1] != "m"]
# 0.3048 converts feet to meters
ddfs = ddfs[["Occupancy"] + damage_columns].groupby(["Occupancy"]).median()
ddfs.index = pd.Series(ddfs.index).apply(lambda x: x.replace(' ', ''))
column_name_mapping = {
    c: c.replace("ft", "m").replace(
        c[2:4], str(
            round(int(c[2:4]) * 0.3048,1)
        ))
    for c in damage_columns
}
ddfs = ddfs.rename(columns=column_name_mapping)
ddfs.to_csv('./nsi_median_vulnerability_curves.csv')
