# Copyright (c) 2024 Darren Erik Vengroff
"""
Auto-generated module. It should not be edited directly.

This module contains abbreviated names for commonly used data sets.

These are typically used as the first argument to :py:func:`censudis.data.download`.

The Census Bureau routinely adds new datasets, so there many be more data sets available
than there are symbolic names here. However, we have automated the process of generating
these symbolic names so they should almost always be very close to up to date.

But you can always use raw strings. For example, even for `ACS5` you can use

`acs/acs5` instead.
"""


ABS_CB = "abscb"

ABS_CBO = "abscbo"

ABS_CS = "abscs"

ABS_MCB = "absmcb"

ABS_NESD = "absnesd"

ABS_NESDO = "absnesdo"

ABS_TCB = "abstcb"

ACS1 = "acs/acs1"

ACS1_CD113 = "acs1/cd113"

ACS1_CD115 = "acs1/cd115"

ACS1_CPROFILE = "acs/acs1/cprofile"

ACS1_PROFILE = "acs/acs1/profile"

ACS1_PUMS = "acs/acs1/pums"

ACS1_PUMSPR = "acs/acs1/pumspr"

ACS1_SPP = "acs/acs1/spp"

ACS1_SUBJECT = "acs/acs1/subject"

ACS3 = "acs/acs3"

ACS3_CPROFILE = "acs/acs3/cprofile"

ACS3_PROFILE = "acs/acs3/profile"

ACS3_SPP = "acs/acs3/spp"

ACS3_SUBJECT = "acs/acs3/subject"

ACS5 = "acs/acs5"

ACS5_AIAN = "acs/acs5/aian"

ACS5_AIANPROFILE = "acs/acs5/aianprofile"

ACS5_CPROFILE = "acs/acs5/cprofile"

ACS5_EEO = "acs/acs5/eeo"

ACS5_PROFILE = "acs/acs5/profile"

ACS5_PUMS = "acs/acs5/pums"

ACS5_PUMSPR = "acs/acs5/pumspr"

ACS5_SPT = "acs/acs5/spt"

ACS5_SPTPROFILE = "acs/acs5/sptprofile"

ACS5_SUBJECT = "acs/acs5/subject"

ACSSE = "acs/acsse"

ACS_FLOWS = "acs/flows"

ASE_CSA = "ase/csa"

ASE_CSCB = "ase/cscb"

ASE_CSCBO = "ase/cscbo"

CBP = "cbp"

CFSAREA = "cfsarea"

CFSEXPORT = "cfsexport"

CFSHAZMAT = "cfshazmat"

CFSPRELIM = "cfsprelim"

CFSTEMP = "cfstemp"

CPS_ARTS = "cps/arts/feb"

CPS_ASEC = "cps/asec/mar"

CPS_BASIC = "cps/basic/jan"

CPS_CIVIC = "cps/civic/nov"

CPS_CONTWORKER = "cps/contworker/may"

CPS_DISABILITY = "cps/disability/jul"

CPS_DWJT = "cps/dwjt/jan"

CPS_FERTILITY = "cps/fertility/jun"

CPS_FOODSEC = "cps/foodsec/dec"

CPS_IMMIGRATION = "cps/immigration/aug"

CPS_INTERNET = "cps/internet/nov"

CPS_LIBRARY = "cps/library/oct"

CPS_MARITAL = "cps/marital/jun"

CPS_PUBARTS = "cps/pubarts/jul"

CPS_RACE = "cps/race/may"

CPS_SCHOOL = "cps/school/oct"

CPS_TOBACCO = "cps/tobacco/may"

CPS_UNBANK = "cps/unbank/jun"

CPS_VETS = "cps/vets/aug"

CPS_VOLUNTEER = "cps/volunteer/sep"

CPS_VOTING = "cps/voting/nov"

CPS_WORKSCHED = "cps/worksched/may"

CRE = "cre"

DECENNIAL_AIAN = "dec/aian"

DECENNIAL_AIANPROFILE = "dec/aianprofile"

DECENNIAL_AS = "dec/as"

DECENNIAL_ASYOE = "dec/asyoe"

DECENNIAL_CD110H = "dec/cd110h"

DECENNIAL_CD110HPROFILE = "dec/cd110hprofile"

DECENNIAL_CD110S = "dec/cd110s"

DECENNIAL_CD110SPROFILE = "dec/cd110sprofile"

DECENNIAL_CD113 = "dec/cd113"

DECENNIAL_CD113PROFILE = "dec/cd113profile"

DECENNIAL_CD115 = "dec/cd115"

DECENNIAL_CD115PROFILE = "dec/cd115profile"

DECENNIAL_CD116 = "dec/cd116"

DECENNIAL_CD118 = "dec/cd118"

DECENNIAL_CQR = "dec/cqr"

DECENNIAL_CROSSTABAS = "dec/crosstabas"

DECENNIAL_CROSSTABGU = "dec/crosstabgu"

DECENNIAL_CROSSTABMP = "dec/crosstabmp"

DECENNIAL_CROSSTABVI = "dec/crosstabvi"

DECENNIAL_DDHCA = "dec/ddhca"

DECENNIAL_DHC = "dec/dhc"

DECENNIAL_DHCAS = "dec/dhcas"

DECENNIAL_DHCGU = "dec/dhcgu"

DECENNIAL_DHCMP = "dec/dhcmp"

DECENNIAL_DHCVI = "dec/dhcvi"

DECENNIAL_DP = "dec/dp"

DECENNIAL_DPAS = "dec/dpas"

DECENNIAL_DPGU = "dec/dpgu"

DECENNIAL_DPMP = "dec/dpmp"

DECENNIAL_DPVI = "dec/dpvi"

DECENNIAL_GU = "dec/gu"

DECENNIAL_GUYOE = "dec/guyoe"

DECENNIAL_MP = "dec/mp"

DECENNIAL_MPYOE = "dec/mpyoe"

DECENNIAL_PES = "dec/pes"

DECENNIAL_PLNAT = "dec/plnat"

DECENNIAL_PUBLIC_LAW_94_171 = "dec/pl"

DECENNIAL_RESPONSERATE = "dec/responserate"

DECENNIAL_SF1 = "dec/sf1"

DECENNIAL_SF2 = "dec/sf2"

DECENNIAL_SF2PROFILE = "dec/sf2profile"

DECENNIAL_SF3 = "dec/sf3"

DECENNIAL_SF3PROFILE = "dec/sf3profile"

DECENNIAL_SF4 = "dec/sf4"

DECENNIAL_SF4PROFILE = "dec/sf4profile"

DECENNIAL_SLDH = "dec/sldh"

DECENNIAL_SLDHPROFILE = "dec/sldhprofile"

DECENNIAL_SLDS = "dec/slds"

DECENNIAL_SLDSPROFILE = "dec/sldsprofile"

DECENNIAL_SURNAME = "surname"

DECENNIAL_VI = "dec/vi"

ECN_ADBNPROP = "ecnadbnprop"

ECN_ADMBEN = "ecnadmben"

ECN_BASIC = "ecnbasic"

ECN_BRANDDEAL = "ecnbranddeal"

ECN_BRIDGE1 = "ecnbridge1"

ECN_BRIDGE2 = "ecnbridge2"

ECN_BRORDEAL = "ecnbrordeal"

ECN_CASHADV = "ecncashadv"

ECN_CCARD = "ecnccard"

ECN_CLCUST = "ecnclcust"

ECN_COMM = "ecncomm"

ECN_COMP = "ecncomp"

ECN_CONACT = "ecnconact"

ECN_CONCESS = "ecnconcess"

ECN_CRFIN = "ecncrfin"

ECN_DIRPREM = "ecndirprem"

ECN_DISSMED = "ecndissmed"

ECN_ELMENU = "ecnelmenu"

ECN_EMPFUNC = "ecnempfunc"

ECN_ENTSUP = "ecnentsup"

ECN_EOYINV = "ecneoyinv"

ECN_EOYINVWH = "ecneoyinvwh"

ECN_EQUIP = "ecnequip"

ECN_EXPNRG = "ecnexpnrg"

ECN_EXPSVC = "ecnexpsvc"

ECN_FLSPACE = "ecnflspace"

ECN_FOODSVC = "ecnfoodsvc"

ECN_FRAN = "ecnfran"

ECN_GRANT = "ecngrant"

ECN_GUEST = "ecnguest"

ECN_GUESTSIZE = "ecnguestsize"

ECN_HOSP = "ecnhosp"

ECN_HOTEL = "ecnhotel"

ECN_INSTR = "ecninstr"

ECN_INVVAL = "ecninvval"

ECN_IPA = "ecnipa"

ECN_ISLANDAREAS = "ecn/islandareas/napcs"

ECN_KOB = "ecnkob"

ECN_LABOR = "ecnlabor"

ECN_LIFOMFG = "ecnlifomfg"

ECN_LIFOMINE = "ecnlifomine"

ECN_LIFOVAL = "ecnlifoval"

ECN_LINES = "ecnlines"

ECN_LOAN = "ecnloan"

ECN_LOCCONS = "ecnloccons"

ECN_LOCMFG = "ecnlocmfg"

ECN_LOCMINE = "ecnlocmine"

ECN_MARGIN = "ecnmargin"

ECN_MATFUEL = "ecnmatfuel"

ECN_MEALCOST = "ecnmealcost"

ECN_MENUTYPE = "ecnmenutype"

ECN_NAPCSIND = "ecnnapcsind"

ECN_NAPCSPRD = "ecnnapcsprd"

ECN_PATIENT = "ecnpatient"

ECN_PETRFAC = "ecnpetrfac"

ECN_PETRPROD = "ecnpetrprod"

ECN_PETRREC = "ecnpetrrec"

ECN_PETRSTAT = "ecnpetrstat"

ECN_PROFIT = "ecnprofit"

ECN_PURELEC = "ecnpurelec"

ECN_PURGAS = "ecnpurgas"

ECN_PURMODE = "ecnpurmode"

ECN_RDACQ = "ecnrdacq"

ECN_RDOFC = "ecnrdofc"

ECN_SEAT = "ecnseat"

ECN_SIZE = "ecnsize"

ECN_SOCIAL = "ecnsocial"

ECN_TYPE = "ecntype"

ECN_TYPEPAYER = "ecntypepayer"

ECN_TYPOP = "ecntypop"

ECN_VALCON = "ecnvalcon"

EWKS = "ewks"

INTLTRADE_IMP_EXP = "intltrade/imp_exp"

LANGUAGE = "language"

NONEMP = "nonemp"

PDB_BLOCKGROUP = "pdb/blockgroup"

PDB_STATECOUNTY = "pdb/statecounty"

PDB_TRACT = "pdb/tract"

PEP_AGESEX = "pep/agesex"

PEP_AGESPECIAL5 = "pep/agespecial5"

PEP_AGESPECIAL6 = "pep/agespecial6"

PEP_AGESPECIALPR = "pep/agespecialpr"

PEP_CHARAGE = "pep/charage"

PEP_CHARAGEGROUPS = "pep/charagegroups"

PEP_COCHAR5 = "pep/cochar5"

PEP_COCHAR6 = "pep/cochar6"

PEP_COMPONENTS = "pep/components"

PEP_CTY = "pep/cty"

PEP_HOUSING = "pep/housing"

PEP_INT_CHARAGE = "pep/int_charage"

PEP_INT_CHARAGEGROUPS = "pep/int_charagegroups"

PEP_INT_HOUSINGUNITS = "pep/int_housingunits"

PEP_INT_NATCIVPOP = "pep/int_natcivpop"

PEP_INT_NATMONTHLY = "pep/int_natmonthly"

PEP_INT_NATRESAFO = "pep/int_natresafo"

PEP_INT_NATRESPOP = "pep/int_natrespop"

PEP_INT_POPULATION = "pep/int_population"

PEP_MONTHLYNATCHAR5 = "pep/monthlynatchar5"

PEP_MONTHLYNATCHAR6 = "pep/monthlynatchar6"

PEP_NATMONTHLY = "pep/natmonthly"

PEP_NATSTPRC = "pep/natstprc"

PEP_NATSTPRC18 = "pep/natstprc18"

PEP_POPULATION = "pep/population"

PEP_PRCAGESEX = "pep/prcagesex"

PEP_PRM = "pep/prm"

PEP_PRMAGESEX = "pep/prmagesex"

PEP_PROJAGEGROUPS = "pep/projagegroups"

PEP_PROJBIRTHS = "pep/projbirths"

PEP_PROJDEATHS = "pep/projdeaths"

PEP_PROJNAT = "pep/projnat"

PEP_PROJNIM = "pep/projnim"

PEP_PROJPOP = "pep/projpop"

PEP_STCHAR5 = "pep/stchar5"

PEP_STCHAR6 = "pep/stchar6"

PEP_SUBCTY = "pep/subcty"

POPPROJ = "popproj/pop"

POPPROJ_AGEGROUPS = "popproj/agegroups"

POPPROJ_BIRTHS = "popproj/births"

POPPROJ_DEATHS = "popproj/deaths"

POPPROJ_NAT = "popproj/nat"

POPPROJ_NIM = "popproj/nim"

PUBLIC_PK12_EDUCATION_FINANCE = "pubschlfin"

SBO_CS = "sbo/cs"

SBO_CSCB = "sbo/cscb"

SBO_CSCBO = "sbo/cscbo"

SIPP_CORE = "sipp/core/2008panel/wave9"

SIPP_TOPICAL = "sipp/topical/2008panel/wave9"

SIPP_TOPICALED = "sipp/topicaled/1993panel/wave8"

SIPP_TOPICALEDEX = "sipp/topicaledex/1993panel/wave8"

SIPP_TOPICALEX = "sipp/topicalex/1993panel/wave3"

SIPP_TOPICALRES = "sipp/topicalres/2001panel/wave8"

TIMESERIES_ASM = "timeseries/asm/value2017"

TIMESERIES_BDS = "timeseries/bds"

TIMESERIES_EITS = "timeseries/eits/vip"

TIMESERIES_GOVS = "timeseries/govs"

TIMESERIES_HEALTHINS = "timeseries/healthins/sahie"

TIMESERIES_HHPULSE = "timeseries/hhpulse"

TIMESERIES_HPS = "timeseries/hps"

TIMESERIES_IDB = "timeseries/idb/5year"

TIMESERIES_INTLTRADE = "timeseries/intltrade/imports/usda"

TIMESERIES_POVERTY = "timeseries/poverty/saipe/schdist"

TIMESERIES_PSEO = "timeseries/pseo/flows"

TIMESERIES_QWI = "timeseries/qwi/se"

TIMESERIES_SOMA = "timeseries/soma"

VIUSA = "viusa"

VIUSB = "viusb"

VIUSC = "viusc"

VIUSD = "viusd"

VIUSE = "viuse"

VIUSF = "viusf"

ZBP = "zbp"


DATASET_REFERENCE_URLS = {
    ABS_CB: "http://api.census.gov/data/2021/abscb",
    ABS_CBO: "http://api.census.gov/data/2021/abscbo",
    ABS_CS: "http://api.census.gov/data/2021/abscs",
    ABS_MCB: "http://api.census.gov/data/2021/absmcb",
    ABS_NESD: "http://api.census.gov/data/2020/absnesd",
    ABS_NESDO: "http://api.census.gov/data/2020/absnesdo",
    ABS_TCB: "http://api.census.gov/data/2018/abstcb",
    ACS1: "http://api.census.gov/data/2022/acs/acs1",
    ACS1_CD113: "http://api.census.gov/data/2011/acs1/cd113",
    ACS1_CD115: "http://api.census.gov/data/2015/acs1/cd115",
    ACS1_CPROFILE: "http://api.census.gov/data/2022/acs/acs1/cprofile",
    ACS1_PROFILE: "http://api.census.gov/data/2022/acs/acs1/profile",
    ACS1_PUMS: "http://api.census.gov/data/2022/acs/acs1/pums",
    ACS1_PUMSPR: "http://api.census.gov/data/2022/acs/acs1/pumspr",
    ACS1_SPP: "http://api.census.gov/data/2022/acs/acs1/spp",
    ACS1_SUBJECT: "http://api.census.gov/data/2022/acs/acs1/subject",
    ACS3: "http://api.census.gov/data/2013/acs/acs3",
    ACS3_CPROFILE: "http://api.census.gov/data/2013/acs/acs3/cprofile",
    ACS3_PROFILE: "http://api.census.gov/data/2013/acs/acs3/profile",
    ACS3_SPP: "http://api.census.gov/data/2013/acs/acs3/spp",
    ACS3_SUBJECT: "http://api.census.gov/data/2013/acs/acs3/subject",
    ACS5: "http://api.census.gov/data/2022/acs/acs5",
    ACS5_AIAN: "http://api.census.gov/data/2021/acs/acs5/aian",
    ACS5_AIANPROFILE: "http://api.census.gov/data/2021/acs/acs5/aianprofile",
    ACS5_CPROFILE: "http://api.census.gov/data/2022/acs/acs5/cprofile",
    ACS5_EEO: "http://api.census.gov/data/2018/acs/acs5/eeo",
    ACS5_PROFILE: "http://api.census.gov/data/2022/acs/acs5/profile",
    ACS5_PUMS: "http://api.census.gov/data/2022/acs/acs5/pums",
    ACS5_PUMSPR: "http://api.census.gov/data/2022/acs/acs5/pumspr",
    ACS5_SPT: "http://api.census.gov/data/2021/acs/acs5/spt",
    ACS5_SPTPROFILE: "http://api.census.gov/data/2021/acs/acs5/sptprofile",
    ACS5_SUBJECT: "http://api.census.gov/data/2022/acs/acs5/subject",
    ACSSE: "http://api.census.gov/data/2022/acs/acsse",
    ACS_FLOWS: "http://api.census.gov/data/2021/acs/flows",
    ASE_CSA: "http://api.census.gov/data/2016/ase/csa",
    ASE_CSCB: "http://api.census.gov/data/2016/ase/cscb",
    ASE_CSCBO: "http://api.census.gov/data/2016/ase/cscbo",
    CBP: "http://api.census.gov/data/2021/cbp",
    CFSAREA: "http://api.census.gov/data/2017/cfsarea",
    CFSEXPORT: "http://api.census.gov/data/2017/cfsexport",
    CFSHAZMAT: "http://api.census.gov/data/2017/cfshazmat",
    CFSPRELIM: "http://api.census.gov/data/2017/cfsprelim",
    CFSTEMP: "http://api.census.gov/data/2017/cfstemp",
    CPS_ARTS: "http://api.census.gov/data/2020/cps/arts/feb",
    CPS_ASEC: "http://api.census.gov/data/2023/cps/asec/mar",
    CPS_BASIC: "http://api.census.gov/data/2024/cps/basic/jan",
    CPS_CIVIC: "http://api.census.gov/data/2013/cps/civic/nov",
    CPS_CONTWORKER: "http://api.census.gov/data/2017/cps/contworker/may",
    CPS_DISABILITY: "http://api.census.gov/data/2021/cps/disability/jul",
    CPS_DWJT: "http://api.census.gov/data/2022/cps/dwjt/jan",
    CPS_FERTILITY: "http://api.census.gov/data/2022/cps/fertility/jun",
    CPS_FOODSEC: "http://api.census.gov/data/2022/cps/foodsec/dec",
    CPS_IMMIGRATION: "http://api.census.gov/data/2008/cps/immigration/aug",
    CPS_INTERNET: "http://api.census.gov/data/2021/cps/internet/nov",
    CPS_LIBRARY: "http://api.census.gov/data/2002/cps/library/oct",
    CPS_MARITAL: "http://api.census.gov/data/1995/cps/marital/jun",
    CPS_PUBARTS: "http://api.census.gov/data/2022/cps/pubarts/jul",
    CPS_RACE: "http://api.census.gov/data/1995/cps/race/may",
    CPS_SCHOOL: "http://api.census.gov/data/2022/cps/school/oct",
    CPS_TOBACCO: "http://api.census.gov/data/2019/cps/tobacco/may",
    CPS_UNBANK: "http://api.census.gov/data/2021/cps/unbank/jun",
    CPS_VETS: "http://api.census.gov/data/2022/cps/vets/aug",
    CPS_VOLUNTEER: "http://api.census.gov/data/2021/cps/volunteer/sep",
    CPS_VOTING: "http://api.census.gov/data/2022/cps/voting/nov",
    CPS_WORKSCHED: "http://api.census.gov/data/2004/cps/worksched/may",
    CRE: "http://api.census.gov/data/2022/cre",
    DECENNIAL_AIAN: "http://api.census.gov/data/2010/dec/aian",
    DECENNIAL_AIANPROFILE: "http://api.census.gov/data/2000/dec/aianprofile",
    DECENNIAL_AS: "http://api.census.gov/data/2010/dec/as",
    DECENNIAL_ASYOE: "http://api.census.gov/data/2010/dec/asyoe",
    DECENNIAL_CD110H: "http://api.census.gov/data/2000/dec/cd110h",
    DECENNIAL_CD110HPROFILE: "http://api.census.gov/data/2000/dec/cd110hprofile",
    DECENNIAL_CD110S: "http://api.census.gov/data/2000/dec/cd110s",
    DECENNIAL_CD110SPROFILE: "http://api.census.gov/data/2000/dec/cd110sprofile",
    DECENNIAL_CD113: "http://api.census.gov/data/2010/dec/cd113",
    DECENNIAL_CD113PROFILE: "http://api.census.gov/data/2010/dec/cd113profile",
    DECENNIAL_CD115: "http://api.census.gov/data/2010/dec/cd115",
    DECENNIAL_CD115PROFILE: "http://api.census.gov/data/2010/dec/cd115profile",
    DECENNIAL_CD116: "http://api.census.gov/data/2010/dec/cd116",
    DECENNIAL_CD118: "http://api.census.gov/data/2020/dec/cd118",
    DECENNIAL_CQR: "http://api.census.gov/data/2000/dec/cqr",
    DECENNIAL_CROSSTABAS: "http://api.census.gov/data/2020/dec/crosstabas",
    DECENNIAL_CROSSTABGU: "http://api.census.gov/data/2020/dec/crosstabgu",
    DECENNIAL_CROSSTABMP: "http://api.census.gov/data/2020/dec/crosstabmp",
    DECENNIAL_CROSSTABVI: "http://api.census.gov/data/2020/dec/crosstabvi",
    DECENNIAL_DDHCA: "http://api.census.gov/data/2020/dec/ddhca",
    DECENNIAL_DHC: "http://api.census.gov/data/2020/dec/dhc",
    DECENNIAL_DHCAS: "http://api.census.gov/data/2020/dec/dhcas",
    DECENNIAL_DHCGU: "http://api.census.gov/data/2020/dec/dhcgu",
    DECENNIAL_DHCMP: "http://api.census.gov/data/2020/dec/dhcmp",
    DECENNIAL_DHCVI: "http://api.census.gov/data/2020/dec/dhcvi",
    DECENNIAL_DP: "http://api.census.gov/data/2020/dec/dp",
    DECENNIAL_DPAS: "http://api.census.gov/data/2020/dec/dpas",
    DECENNIAL_DPGU: "http://api.census.gov/data/2020/dec/dpgu",
    DECENNIAL_DPMP: "http://api.census.gov/data/2020/dec/dpmp",
    DECENNIAL_DPVI: "http://api.census.gov/data/2020/dec/dpvi",
    DECENNIAL_GU: "http://api.census.gov/data/2010/dec/gu",
    DECENNIAL_GUYOE: "http://api.census.gov/data/2010/dec/guyoe",
    DECENNIAL_MP: "http://api.census.gov/data/2010/dec/mp",
    DECENNIAL_MPYOE: "http://api.census.gov/data/2010/dec/mpyoe",
    DECENNIAL_PES: "http://api.census.gov/data/2020/dec/pes",
    DECENNIAL_PLNAT: "http://api.census.gov/data/2010/dec/plnat",
    DECENNIAL_PUBLIC_LAW_94_171: "http://api.census.gov/data/2020/dec/pl",
    DECENNIAL_RESPONSERATE: "http://api.census.gov/data/2020/dec/responserate",
    DECENNIAL_SF1: "http://api.census.gov/data/2010/dec/sf1",
    DECENNIAL_SF2: "http://api.census.gov/data/2010/dec/sf2",
    DECENNIAL_SF2PROFILE: "http://api.census.gov/data/2000/dec/sf2profile",
    DECENNIAL_SF3: "http://api.census.gov/data/2000/dec/sf3",
    DECENNIAL_SF3PROFILE: "http://api.census.gov/data/2000/dec/sf3profile",
    DECENNIAL_SF4: "http://api.census.gov/data/2000/dec/sf4",
    DECENNIAL_SF4PROFILE: "http://api.census.gov/data/2000/dec/sf4profile",
    DECENNIAL_SLDH: "http://api.census.gov/data/2000/dec/sldh",
    DECENNIAL_SLDHPROFILE: "http://api.census.gov/data/2000/dec/sldhprofile",
    DECENNIAL_SLDS: "http://api.census.gov/data/2000/dec/slds",
    DECENNIAL_SLDSPROFILE: "http://api.census.gov/data/2000/dec/sldsprofile",
    DECENNIAL_SURNAME: "http://api.census.gov/data/2010/surname",
    DECENNIAL_VI: "http://api.census.gov/data/2010/dec/vi",
    ECN_ADBNPROP: "http://api.census.gov/data/2017/ecnadbnprop",
    ECN_ADMBEN: "http://api.census.gov/data/2017/ecnadmben",
    ECN_BASIC: "http://api.census.gov/data/2022/ecnbasic",
    ECN_BRANDDEAL: "http://api.census.gov/data/2017/ecnbranddeal",
    ECN_BRIDGE1: "http://api.census.gov/data/2017/ecnbridge1",
    ECN_BRIDGE2: "http://api.census.gov/data/2017/ecnbridge2",
    ECN_BRORDEAL: "http://api.census.gov/data/2017/ecnbrordeal",
    ECN_CASHADV: "http://api.census.gov/data/2012/ecncashadv",
    ECN_CCARD: "http://api.census.gov/data/2017/ecnccard",
    ECN_CLCUST: "http://api.census.gov/data/2017/ecnclcust",
    ECN_COMM: "http://api.census.gov/data/2017/ecncomm",
    ECN_COMP: "http://api.census.gov/data/2017/ecncomp",
    ECN_CONACT: "http://api.census.gov/data/2017/ecnconact",
    ECN_CONCESS: "http://api.census.gov/data/2012/ecnconcess",
    ECN_CRFIN: "http://api.census.gov/data/2017/ecncrfin",
    ECN_DIRPREM: "http://api.census.gov/data/2017/ecndirprem",
    ECN_DISSMED: "http://api.census.gov/data/2017/ecndissmed",
    ECN_ELMENU: "http://api.census.gov/data/2017/ecnelmenu",
    ECN_EMPFUNC: "http://api.census.gov/data/2017/ecnempfunc",
    ECN_ENTSUP: "http://api.census.gov/data/2017/ecnentsup",
    ECN_EOYINV: "http://api.census.gov/data/2017/ecneoyinv",
    ECN_EOYINVWH: "http://api.census.gov/data/2017/ecneoyinvwh",
    ECN_EQUIP: "http://api.census.gov/data/2012/ecnequip",
    ECN_EXPNRG: "http://api.census.gov/data/2017/ecnexpnrg",
    ECN_EXPSVC: "http://api.census.gov/data/2017/ecnexpsvc",
    ECN_FLSPACE: "http://api.census.gov/data/2017/ecnflspace",
    ECN_FOODSVC: "http://api.census.gov/data/2017/ecnfoodsvc",
    ECN_FRAN: "http://api.census.gov/data/2017/ecnfran",
    ECN_GRANT: "http://api.census.gov/data/2017/ecngrant",
    ECN_GUEST: "http://api.census.gov/data/2012/ecnguest",
    ECN_GUESTSIZE: "http://api.census.gov/data/2012/ecnguestsize",
    ECN_HOSP: "http://api.census.gov/data/2017/ecnhosp",
    ECN_HOTEL: "http://api.census.gov/data/2017/ecnhotel",
    ECN_INSTR: "http://api.census.gov/data/2017/ecninstr",
    ECN_INVVAL: "http://api.census.gov/data/2017/ecninvval",
    ECN_IPA: "http://api.census.gov/data/2012/ecnipa",
    ECN_ISLANDAREAS: "http://api.census.gov/data/2017/ecn/islandareas/napcs",
    ECN_KOB: "http://api.census.gov/data/2017/ecnkob",
    ECN_LABOR: "http://api.census.gov/data/2017/ecnlabor",
    ECN_LIFOMFG: "http://api.census.gov/data/2017/ecnlifomfg",
    ECN_LIFOMINE: "http://api.census.gov/data/2017/ecnlifomine",
    ECN_LIFOVAL: "http://api.census.gov/data/2012/ecnlifoval",
    ECN_LINES: "http://api.census.gov/data/2012/ecnlines",
    ECN_LOAN: "http://api.census.gov/data/2017/ecnloan",
    ECN_LOCCONS: "http://api.census.gov/data/2017/ecnloccons",
    ECN_LOCMFG: "http://api.census.gov/data/2017/ecnlocmfg",
    ECN_LOCMINE: "http://api.census.gov/data/2017/ecnlocmine",
    ECN_MARGIN: "http://api.census.gov/data/2017/ecnmargin",
    ECN_MATFUEL: "http://api.census.gov/data/2017/ecnmatfuel",
    ECN_MEALCOST: "http://api.census.gov/data/2012/ecnmealcost",
    ECN_MENUTYPE: "http://api.census.gov/data/2012/ecnmenutype",
    ECN_NAPCSIND: "http://api.census.gov/data/2017/ecnnapcsind",
    ECN_NAPCSPRD: "http://api.census.gov/data/2017/ecnnapcsprd",
    ECN_PATIENT: "http://api.census.gov/data/2017/ecnpatient",
    ECN_PETRFAC: "http://api.census.gov/data/2017/ecnpetrfac",
    ECN_PETRPROD: "http://api.census.gov/data/2017/ecnpetrprod",
    ECN_PETRREC: "http://api.census.gov/data/2017/ecnpetrrec",
    ECN_PETRSTAT: "http://api.census.gov/data/2017/ecnpetrstat",
    ECN_PROFIT: "http://api.census.gov/data/2017/ecnprofit",
    ECN_PURELEC: "http://api.census.gov/data/2017/ecnpurelec",
    ECN_PURGAS: "http://api.census.gov/data/2017/ecnpurgas",
    ECN_PURMODE: "http://api.census.gov/data/2017/ecnpurmode",
    ECN_RDACQ: "http://api.census.gov/data/2012/ecnrdacq",
    ECN_RDOFC: "http://api.census.gov/data/2017/ecnrdofc",
    ECN_SEAT: "http://api.census.gov/data/2012/ecnseat",
    ECN_SIZE: "http://api.census.gov/data/2017/ecnsize",
    ECN_SOCIAL: "http://api.census.gov/data/2017/ecnsocial",
    ECN_TYPE: "http://api.census.gov/data/2017/ecntype",
    ECN_TYPEPAYER: "http://api.census.gov/data/2017/ecntypepayer",
    ECN_TYPOP: "http://api.census.gov/data/2017/ecntypop",
    ECN_VALCON: "http://api.census.gov/data/2017/ecnvalcon",
    EWKS: "http://api.census.gov/data/2012/ewks",
    INTLTRADE_IMP_EXP: "http://api.census.gov/data/2018/intltrade/imp_exp",
    LANGUAGE: "http://api.census.gov/data/2013/language",
    NONEMP: "http://api.census.gov/data/2020/nonemp",
    PDB_BLOCKGROUP: "http://api.census.gov/data/2022/pdb/blockgroup",
    PDB_STATECOUNTY: "http://api.census.gov/data/2020/pdb/statecounty",
    PDB_TRACT: "http://api.census.gov/data/2022/pdb/tract",
    PEP_AGESEX: "http://api.census.gov/data/2014/pep/agesex",
    PEP_AGESPECIAL5: "http://api.census.gov/data/2014/pep/agespecial5",
    PEP_AGESPECIAL6: "http://api.census.gov/data/2014/pep/agespecial6",
    PEP_AGESPECIALPR: "http://api.census.gov/data/2014/pep/agespecialpr",
    PEP_CHARAGE: "http://api.census.gov/data/2019/pep/charage",
    PEP_CHARAGEGROUPS: "http://api.census.gov/data/2019/pep/charagegroups",
    PEP_COCHAR5: "http://api.census.gov/data/2014/pep/cochar5",
    PEP_COCHAR6: "http://api.census.gov/data/2014/pep/cochar6",
    PEP_COMPONENTS: "http://api.census.gov/data/2019/pep/components",
    PEP_CTY: "http://api.census.gov/data/2014/pep/cty",
    PEP_HOUSING: "http://api.census.gov/data/2019/pep/housing",
    PEP_INT_CHARAGE: "http://api.census.gov/data/2000/pep/int_charage",
    PEP_INT_CHARAGEGROUPS: "http://api.census.gov/data/2000/pep/int_charagegroups",
    PEP_INT_HOUSINGUNITS: "http://api.census.gov/data/2000/pep/int_housingunits",
    PEP_INT_NATCIVPOP: "http://api.census.gov/data/1990/pep/int_natcivpop",
    PEP_INT_NATMONTHLY: "http://api.census.gov/data/2000/pep/int_natmonthly",
    PEP_INT_NATRESAFO: "http://api.census.gov/data/1990/pep/int_natresafo",
    PEP_INT_NATRESPOP: "http://api.census.gov/data/1990/pep/int_natrespop",
    PEP_INT_POPULATION: "http://api.census.gov/data/2000/pep/int_population",
    PEP_MONTHLYNATCHAR5: "http://api.census.gov/data/2014/pep/monthlynatchar5",
    PEP_MONTHLYNATCHAR6: "http://api.census.gov/data/2014/pep/monthlynatchar6",
    PEP_NATMONTHLY: "http://api.census.gov/data/2021/pep/natmonthly",
    PEP_NATSTPRC: "http://api.census.gov/data/2014/pep/natstprc",
    PEP_NATSTPRC18: "http://api.census.gov/data/2014/pep/natstprc18",
    PEP_POPULATION: "http://api.census.gov/data/2021/pep/population",
    PEP_PRCAGESEX: "http://api.census.gov/data/2014/pep/prcagesex",
    PEP_PRM: "http://api.census.gov/data/2014/pep/prm",
    PEP_PRMAGESEX: "http://api.census.gov/data/2014/pep/prmagesex",
    PEP_PROJAGEGROUPS: "http://api.census.gov/data/2014/pep/projagegroups",
    PEP_PROJBIRTHS: "http://api.census.gov/data/2014/pep/projbirths",
    PEP_PROJDEATHS: "http://api.census.gov/data/2014/pep/projdeaths",
    PEP_PROJNAT: "http://api.census.gov/data/2014/pep/projnat",
    PEP_PROJNIM: "http://api.census.gov/data/2014/pep/projnim",
    PEP_PROJPOP: "http://api.census.gov/data/2014/pep/projpop",
    PEP_STCHAR5: "http://api.census.gov/data/2014/pep/stchar5",
    PEP_STCHAR6: "http://api.census.gov/data/2014/pep/stchar6",
    PEP_SUBCTY: "http://api.census.gov/data/2014/pep/subcty",
    POPPROJ: "http://api.census.gov/data/2017/popproj/pop",
    POPPROJ_AGEGROUPS: "http://api.census.gov/data/2017/popproj/agegroups",
    POPPROJ_BIRTHS: "http://api.census.gov/data/2017/popproj/births",
    POPPROJ_DEATHS: "http://api.census.gov/data/2017/popproj/deaths",
    POPPROJ_NAT: "http://api.census.gov/data/2017/popproj/nat",
    POPPROJ_NIM: "http://api.census.gov/data/2017/popproj/nim",
    PUBLIC_PK12_EDUCATION_FINANCE: "http://api.census.gov/data/2012/pubschlfin",
    SBO_CS: "http://api.census.gov/data/2012/sbo/cs",
    SBO_CSCB: "http://api.census.gov/data/2012/sbo/cscb",
    SBO_CSCBO: "http://api.census.gov/data/2012/sbo/cscbo",
    SIPP_CORE: "http://api.census.gov/data/2008/sipp/core/2008panel/wave9",
    SIPP_TOPICAL: "http://api.census.gov/data/2008/sipp/topical/2008panel/wave9",
    SIPP_TOPICALED: "http://api.census.gov/data/1993/sipp/topicaled/1993panel/wave8",
    SIPP_TOPICALEDEX: "http://api.census.gov/data/1993/sipp/topicaledex/1993panel/wave8",
    SIPP_TOPICALEX: "http://api.census.gov/data/1993/sipp/topicalex/1993panel/wave3",
    SIPP_TOPICALRES: "http://api.census.gov/data/2001/sipp/topicalres/2001panel/wave8",
    TIMESERIES_ASM: "http://api.census.gov/data/timeseries/asm/value2017",
    TIMESERIES_BDS: "http://api.census.gov/data/timeseries/bds",
    TIMESERIES_EITS: "http://api.census.gov/data/timeseries/eits/vip",
    TIMESERIES_GOVS: "http://api.census.gov/data/timeseries/govs",
    TIMESERIES_HEALTHINS: "http://api.census.gov/data/timeseries/healthins/sahie",
    TIMESERIES_HHPULSE: "http://api.census.gov/data/timeseries/hhpulse",
    TIMESERIES_HPS: "http://api.census.gov/data/timeseries/hps",
    TIMESERIES_IDB: "http://api.census.gov/data/timeseries/idb/5year",
    TIMESERIES_INTLTRADE: "http://api.census.gov/data/timeseries/intltrade/imports/usda",
    TIMESERIES_POVERTY: "http://api.census.gov/data/timeseries/poverty/saipe/schdist",
    TIMESERIES_PSEO: "http://api.census.gov/data/timeseries/pseo/flows",
    TIMESERIES_QWI: "http://api.census.gov/data/timeseries/qwi/se",
    TIMESERIES_SOMA: "http://api.census.gov/data/timeseries/soma",
    VIUSA: "http://api.census.gov/data/2021/viusa",
    VIUSB: "http://api.census.gov/data/2021/viusb",
    VIUSC: "http://api.census.gov/data/2021/viusc",
    VIUSD: "http://api.census.gov/data/2021/viusd",
    VIUSE: "http://api.census.gov/data/2021/viuse",
    VIUSF: "http://api.census.gov/data/2021/viusf",
    ZBP: "http://api.census.gov/data/2018/zbp",
}
