# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTargetAssetsResult',
    'AwaitableGetTargetAssetsResult',
    'get_target_assets',
    'get_target_assets_output',
]

@pulumi.output_type
class GetTargetAssetsResult:
    """
    A collection of values returned by getTargetAssets.
    """
    def __init__(__self__, display_name=None, filters=None, id=None, migration_plan_id=None, state=None, target_asset_collections=None, target_asset_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if migration_plan_id and not isinstance(migration_plan_id, str):
            raise TypeError("Expected argument 'migration_plan_id' to be a str")
        pulumi.set(__self__, "migration_plan_id", migration_plan_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_asset_collections and not isinstance(target_asset_collections, list):
            raise TypeError("Expected argument 'target_asset_collections' to be a list")
        pulumi.set(__self__, "target_asset_collections", target_asset_collections)
        if target_asset_id and not isinstance(target_asset_id, str):
            raise TypeError("Expected argument 'target_asset_id' to be a str")
        pulumi.set(__self__, "target_asset_id", target_asset_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTargetAssetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> Optional[str]:
        """
        OCID of the associated migration plan.
        """
        return pulumi.get(self, "migration_plan_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the target asset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetAssetCollections")
    def target_asset_collections(self) -> Sequence['outputs.GetTargetAssetsTargetAssetCollectionResult']:
        """
        The list of target_asset_collection.
        """
        return pulumi.get(self, "target_asset_collections")

    @property
    @pulumi.getter(name="targetAssetId")
    def target_asset_id(self) -> Optional[str]:
        return pulumi.get(self, "target_asset_id")


class AwaitableGetTargetAssetsResult(GetTargetAssetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetAssetsResult(
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            migration_plan_id=self.migration_plan_id,
            state=self.state,
            target_asset_collections=self.target_asset_collections,
            target_asset_id=self.target_asset_id)


def get_target_assets(display_name: Optional[str] = None,
                      filters: Optional[Sequence[pulumi.InputType['GetTargetAssetsFilterArgs']]] = None,
                      migration_plan_id: Optional[str] = None,
                      state: Optional[str] = None,
                      target_asset_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetAssetsResult:
    """
    This data source provides the list of Target Assets in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of target assets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_assets = oci.CloudMigrations.get_target_assets(display_name=var["target_asset_display_name"],
        migration_plan_id=oci_cloud_migrations_migration_plan["test_migration_plan"]["id"],
        state=var["target_asset_state"],
        target_asset_id=oci_cloud_migrations_target_asset["test_target_asset"]["id"])
    ```


    :param str display_name: A filter to return only resources that match the entire given display name.
    :param str migration_plan_id: Unique migration plan identifier
    :param str state: The current state of the target asset.
    :param str target_asset_id: Unique target asset identifier
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['migrationPlanId'] = migration_plan_id
    __args__['state'] = state
    __args__['targetAssetId'] = target_asset_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudMigrations/getTargetAssets:getTargetAssets', __args__, opts=opts, typ=GetTargetAssetsResult).value

    return AwaitableGetTargetAssetsResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        migration_plan_id=pulumi.get(__ret__, 'migration_plan_id'),
        state=pulumi.get(__ret__, 'state'),
        target_asset_collections=pulumi.get(__ret__, 'target_asset_collections'),
        target_asset_id=pulumi.get(__ret__, 'target_asset_id'))


@_utilities.lift_output_func(get_target_assets)
def get_target_assets_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetTargetAssetsFilterArgs']]]]] = None,
                             migration_plan_id: Optional[pulumi.Input[Optional[str]]] = None,
                             state: Optional[pulumi.Input[Optional[str]]] = None,
                             target_asset_id: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTargetAssetsResult]:
    """
    This data source provides the list of Target Assets in Oracle Cloud Infrastructure Cloud Migrations service.

    Returns a list of target assets.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_assets = oci.CloudMigrations.get_target_assets(display_name=var["target_asset_display_name"],
        migration_plan_id=oci_cloud_migrations_migration_plan["test_migration_plan"]["id"],
        state=var["target_asset_state"],
        target_asset_id=oci_cloud_migrations_target_asset["test_target_asset"]["id"])
    ```


    :param str display_name: A filter to return only resources that match the entire given display name.
    :param str migration_plan_id: Unique migration plan identifier
    :param str state: The current state of the target asset.
    :param str target_asset_id: Unique target asset identifier
    """
    ...
