/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.CommunicationChannel;
import py4j.DefaultCommunicationChannel;
import py4j.Py4JException;
import py4j.Py4JNetworkException;

public class CommunicationChannelFactory {
    private final int port;
    private final InetAddress address;
    private final Deque<CommunicationChannel> channels = new ArrayDeque<CommunicationChannel>();
    private final Lock lock = new ReentrantLock(true);
    private final Logger logger = Logger.getLogger(CommunicationChannelFactory.class.getName());
    private boolean isShutdown = false;
    public static final long DEFAULT_MIN_CONNECTION_TIME = 30L;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final long minConnectionTime;
    private final TimeUnit minConnectionTimeUnit;

    public CommunicationChannelFactory(int port) {
        this.port = port;
        try {
            this.address = InetAddress.getByName("localhost");
        }
        catch (Exception e) {
            throw new Py4JNetworkException("Local Host could not be determined when creating communication channel.");
        }
        this.minConnectionTime = 30L;
        this.minConnectionTimeUnit = TimeUnit.SECONDS;
        this.setupCleaner();
    }

    public CommunicationChannelFactory(int port, InetAddress address) {
        this.port = port;
        this.address = address;
        this.minConnectionTime = 30L;
        this.minConnectionTimeUnit = TimeUnit.SECONDS;
        this.setupCleaner();
    }

    public CommunicationChannelFactory(int port, InetAddress address, long minConnectionTime, TimeUnit minConnectionTimeUnit) {
        this.port = port;
        this.address = address;
        this.minConnectionTime = minConnectionTime;
        this.minConnectionTimeUnit = minConnectionTimeUnit;
        this.setupCleaner();
    }

    private void setupCleaner() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CommunicationChannelFactory.this.periodicCleanup();
            }
        }, this.minConnectionTime, this.minConnectionTime, this.minConnectionTimeUnit);
    }

    public String sendCommand(String command) {
        String returnCommand = null;
        CommunicationChannel cc = this.getChannelLock();
        if (cc == null) {
            throw new Py4JException("Cannot obtain a new communication channel");
        }
        try {
            returnCommand = cc.sendCommand(command);
        }
        catch (Py4JNetworkException pe) {
            this.logger.log(Level.WARNING, "Error while sending a command", pe);
            returnCommand = this.sendCommand(command);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Critical error while sending a command", e);
            throw new Py4JException("Error while sending a command.");
        }
        this.giveBackChannel(cc);
        return returnCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.logger.info("Shutting down Communication Channel Factory");
        try {
            this.lock.lock();
            this.isShutdown = true;
            for (CommunicationChannel cc : this.channels) {
                cc.shutdown();
            }
            this.executor.shutdownNow();
            this.channels.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void periodicCleanup() {
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                int size = this.channels.size();
                for (int i = 0; i < size; ++i) {
                    CommunicationChannel cc = this.channels.getLast();
                    if (cc.wasUsed()) {
                        cc.setUsed(false);
                        this.channels.addFirst(cc);
                        continue;
                    }
                    cc.shutdown();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private CommunicationChannel getChannelLock() {
        CommunicationChannel cc = null;
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                cc = this.getChannel();
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Critical error while sending a command", e);
            throw new Py4JException("Error while obtaining a new communication channel", e);
        }
        finally {
            this.lock.unlock();
        }
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void giveBackChannel(CommunicationChannel cc) {
        try {
            this.lock.lock();
            if (cc != null) {
                if (!this.isShutdown) {
                    this.channels.addLast(cc);
                } else {
                    cc.shutdown();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private CommunicationChannel getChannel() throws IOException {
        CommunicationChannel channel = null;
        channel = this.channels.pollLast();
        if (channel == null) {
            channel = new DefaultCommunicationChannel(this.port, this.address);
            channel.start();
        }
        return channel;
    }
}

