/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.CommunicationChannelFactory;
import py4j.Gateway;
import py4j.GatewayConnection;
import py4j.NetworkUtil;

public class GatewayServer
implements Runnable {
    public static final int DEFAULT_PORT = 25333;
    public static final int DEFAULT_PYTHON_PORT = 25334;
    public static final int DEFAULT_CONNECT_TIMEOUT = 0;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    private final int port;
    private final int pythonPort;
    private final Gateway gateway;
    private final boolean acceptOnlyOne;
    private final int connectTimeout;
    private final int readTimeout;
    private final Logger logger = Logger.getLogger(GatewayServer.class.getName());
    private final List<Socket> connections = new ArrayList<Socket>();
    private final CommunicationChannelFactory ccFactory;
    private Socket currentSocket;
    private ServerSocket sSocket;

    public GatewayServer(Object entryPoint, int port, int connectTimeout, int readTimeout, boolean acceptOnlyOne) {
        this(entryPoint, port, 25334, connectTimeout, readTimeout, acceptOnlyOne);
    }

    public GatewayServer(Object entryPoint, int port, int pythonPort, int connectTimeout, int readTimeout, boolean acceptOnlyOne) {
        this.port = port;
        this.pythonPort = pythonPort;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.acceptOnlyOne = acceptOnlyOne;
        this.ccFactory = new CommunicationChannelFactory(pythonPort);
        this.gateway = new Gateway(entryPoint, this.ccFactory);
    }

    public GatewayServer(Object entryPoint) {
        this(entryPoint, 25333, 0, 0, false);
    }

    public GatewayServer(Object entryPoint, int port) {
        this(entryPoint, port, 0, 0, false);
    }

    @Override
    public void run() {
        try {
            this.logger.info("Gateway Server Starting");
            this.gateway.startup();
            this.sSocket = new ServerSocket(this.port);
            this.sSocket.setSoTimeout(this.connectTimeout);
            while (true) {
                Socket socket = this.sSocket.accept();
                this.processSocket(socket);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while waiting for connection.", e);
            this.logger.info("Gateway Server Stopping");
            return;
        }
    }

    protected Object createConnection(GatewayServer server, Gateway gateway, Socket socket) throws IOException {
        return new GatewayConnection(server, gateway, socket);
    }

    private void processSocket(Socket socket) {
        try {
            if (this.acceptOnlyOne && this.isConnected()) {
                socket.close();
            } else {
                this.logger.info("Gateway Server accepted a connection");
                this.connections.add(socket);
                socket.setSoTimeout(this.readTimeout);
                this.createConnection(this, this.gateway, socket);
                if (this.acceptOnlyOne) {
                    this.currentSocket = socket;
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while processing a connection.", e);
        }
    }

    private boolean isConnected() {
        return this.currentSocket != null && this.currentSocket.isConnected();
    }

    public void start(boolean fork) {
        if (fork) {
            Thread t = new Thread(this);
            t.start();
        } else {
            this.run();
        }
    }

    public void start() {
        this.start(true);
    }

    public void shutdown() {
        this.logger.info("Shutting down Gateway");
        NetworkUtil.quietlyClose(this.sSocket);
        for (Socket socket : this.connections) {
            NetworkUtil.quietlyClose(socket);
        }
        this.connections.clear();
        this.gateway.shutdown();
        this.ccFactory.shutdown();
    }

    public boolean isAcceptOnlyOne() {
        return this.acceptOnlyOne;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getPythonPort() {
        return this.pythonPort;
    }

    public CommunicationChannelFactory getCommunicationChannelFactory() {
        return this.ccFactory;
    }

    public static void turnLoggingOff() {
        Logger.getLogger("py4j").setLevel(Level.OFF);
    }

    public static void turnLoggingOn() {
        Logger.getLogger("py4j").setLevel(Level.ALL);
    }

    static {
        GatewayServer.turnLoggingOff();
    }
}

