import { ISecret, Secret, SecretProps } from 'aws-cdk-lib/aws-secretsmanager';
import { Construct, IDependable } from 'constructs';
import { ReplicatedKey } from '@reapit-cdk/replicated-key';
import { Grant, IGrantable } from 'aws-cdk-lib/aws-iam';
export interface MultiRegionSecretProps {
    readonly replicatedKey: ReplicatedKey;
    readonly replicaRegions: string[];
    readonly secretObjectValue?: SecretProps['secretObjectValue'];
    readonly secretStringValue?: SecretProps['secretStringValue'];
}
export declare class ReplicatedSecret extends Secret {
    private secrets;
    private replicatedKey;
    masterRegion: string;
    dependable: IDependable;
    constructor(scope: Construct, id: string, props: MultiRegionSecretProps);
    getRegionalSecret(region: string): ISecret;
    grantWrite(grantee: IGrantable): Grant;
    grantRead(grantee: IGrantable, versionStages?: string[]): Grant;
}
