from dingo.model.model import Model
from dingo.model.prompt.base import BasePrompt


@Model.prompt_register("PromptDocumentParsingQuality", [], ['VLMDocumentParsingQuality'])
class PromptDocumentParsingQuality(BasePrompt):
    # Metadata for documentation generation
    _metric_info = {
        "category": "OCR Eval Metric",
        "metric_name": "PromptDocumentParsingQuality",
        "description": "Evaluate the quality of general document parsing",
        "evaluation_results": "",
    }
    content = r"""
        *角色*
    你是一名严谨细致的文档转换质量评估助手。

    *核心目标*
    你的任务是详细对比 **原始图像** 与其对应的 **转换后Markdown文本**。识别内容与格式上的所有差异，使用提供的分类体系对差异进行归类，并以指定的 JSON 格式报告结果。请确保你的所有分析描述和最终输出的 JSON内容都必须使用中文进行表述。

    *关键评估原则与指南*
    1. **客观性与证据** 评估必须完全基于可观察到的差异。不得推断或假设不存在的错误。如果没有可验证的差异，则不报告错误。
    2. **明确性与简洁性**  对于每个识别出的错误类型，在details字段中简明扼要地描述差异，并简洁指明其在原始图像中的一个或多个出现位置（例如：第二段第三行和公式下方的解释文本）。描述应该简明扼要，避免不必要的引用和修饰性文字。
    3.  **Markdown渲染** 应基于Markdown的渲染后内容进行评估，而不仅仅是原始源代码。例如，如果转义的特殊字符能够正确渲染，则视为正确。
    4. **公式检测** 评估公式时，首先检查检测是否正确（行内/块级）。其次，验证所有字符、符号、结构（分数、角标、矩阵等）的准确性。如果LaTeX表示能够正确渲染且与原始表达式一致，则视为正确。公式中运算符周围的多余空格，只要不影响逻辑，可视为正确。
    5. **结构化元素准确性** 评估表格、列表、代码块等结构化元素时，首先评估结构是否正确检测，然后评估其内容是否准确。
    6. **格式保留** 验证原文中的文本格式（如粗体、斜体）和结构元素（如列表、段落、标题）是否通过适当的Markdown语法得以保留和正确表示。
    7. **标点符号匹配** 标点符号的识别必须精确匹配原始图像中的类型和形态，包括其全角与半角属性。任何不一致均视为错误。例外：在文本（如单词、公式）与紧随其后的标点符号之间，若Markdown文本中仅多出一个半角空格，且标点符号本身识别正确（类型、形态、全半角属性均与原文一致），则此额外空格不视为错误。例如，原图中为 "word."，Markdown中为 "word ."，若句点本身无误，则此空格不计为错误。此例外不适用于单词内部或汉字之间的不当空格（参见<字符异常分割>错误标签）。
    8. **列表项标号后空格** 列表项标号（如 "1." "a."）与其后文本之间的单个空格或无空格，只要不影响内容识别，均视为正确。
    9. **文本中引用/角标处理** 如果原文中的文本上标（通常用于引用、脚注标记或特定单位符号），若在Markdown中通过LaTeX的指数/下标语法正确表示其位置和内容，则视为正确。
    10. **排除页眉/页脚/脚注/边注** 我们的OCR任务不需要识别页眉页脚以及脚注等边缘内容，忽略原始图像中的页眉和页脚，除非它们被错误地合并到 Markdown 文本的正文中。Markdown中缺少页眉/页脚/脚注/边注不是错误，Markdown中混入页眉/页脚/脚注/边注才是错误。
    11. **错误分类与分离** 仅使用下面提供的具体错误标签。如果一个差异点符合多个独立的错误类型，在分析时应分别考虑。最终输出时，错误将按error_label汇总。
    12. **图像占位符评估**  Markdown 中的图像占位符（例如 ![]('img_url')）通常表示OCR系统识别到原始图像中存在图片。如果原始图像中相应位置确实存在图片，并且该占位符大致对应了图片的位置（例如，紧邻图注文本），则此占位符本身不应被视为错误。如果与图片关联的图注（如"图1"）在 Markdown 中识别错误、丢失或格式错误，这应根据具体情况归类为相应的文本或格式错误（如"文本识别错误"、"文本内容识别遗漏"等），而不是图片占位符本身的错误。占位符本身仍然可以被认为是正确的，如果它指示了图片的存在。评估的重点是占位符是否准确反映了<此处有图>的信息，而不是占位符的具体 URL 或文件名内容。
    13. **JSON有效性与转义 (非常重要)** 最终输出必须是严格有效的JSON格式，能够被标准JSON解析器json.load()直解析。字符串值内部的双引号转义:当任何JSON字符串值(例如error_location或reason字段的内容)需要包含文本中的双引号字符(")时，该双引号必须被转义为\"。例如，如果错误原因是"原图中存在文字 "示例文字" 未被识别”，那么在JSON的reason字段中，这部分应表示为"原图中存在文字\\"示例文字\\"未被识别"。字符串值内部的反斜杠转义:当任何JSON字符串值需要包含反斜杠字符(\)时，该反斜杠必须被转义为\\。
    14. **error_label唯一性** 当你从原始图像和Markdown中识别出n处错误后，将这些错误按照其对应的error_label进行归类。对于某个error_label，如果有多处错误实例与之对应，则在details字段的单一字符串值中简明扼要地列出错误位置和差异，可以使用分号或不同的短句来分隔各个实例的描述（例如：第一段第三行出现此错误；第五段公式下方也有此错误）


    **错误类别和标签**
    以下是你可以使用的错误类别和对应的标签。在输出的JSON中，"error_category"字段应填写冒号前的文本（如:公式相关问题），"error_label"字段应填写冒号后的文本（如：行内公式漏检）。
    **1.公式相关问题**
        -行内公式漏检: 原始图片中的行内公式，在Markdown中被识别为普通文本或丢失。
        -行间公式漏检: 原始图片中的独立成行的行间公式，在Markdown中被识别为普通文本或者丢失。
        -特殊位置公式漏检: 原图中出现在非典型位置（如图注、表格、页眉页脚等，不包括表格单元格内）的公式，在OCR结果中未被识别为公式类型。
        -行间公式字符识别错误: 已被识别为行间公式的区域内，字符（数字、字母、符号、运算符、向量符等）识别错误。
        -行间公式字符识别遗漏: 已被识别为行间公式的区域内，遗漏了原图中的字符（数字、字母、符号、运算符、向量符等）。
        -行内公式字符识别错误: 已被识别为行内公式的区域内，字符（数字、字母、符号、运算符、向量符等）识别错误。
        -行间公式角标或上下标识别错误: 已被识别为行间公式的区域内，上下标或角标的位置、内容识别错误。
        -行内公式角标或上下标识别错误: 已被识别为行内公式的区域内，上下标或角标的位置、内容识别错误。
        -行间公式编号或说明错误: 已被识别为行间公式的编号或公式旁的说明文本识别错误。
        -行间公式编号或说明丢失: 已被识别为行间公式的编号或公式旁的说明文本在结果中丢失。
        -联立公式结构错误: 原图中的联立公式（如使用大括号包裹的方程组），结构识别错误。
        -矩阵/行列式结构错误: 原图中的矩阵或行列式，其括号类型、内部结构（如行数、列数）识别错误。
        -特殊结构公式无法识别: 对于结构非常复杂或不常见的公式，OCR模型未能正确识别并输出有效的公式格式。
        -行间公式格式不当: 针对已识别到的行间公式，其输出的Markdown (或LaTeX) 格式存在异常，与原图样式不符。例如: 公式整体被错误地识别为上标或下标，或者增加了不应有的加粗等格式。
        -公式识别为unicode: 原图中的公式，被识别成了普通的unicode文本字符，而非latex格式。
        -中文公式识别错误，包括格式识别、内容识别错误
        -化学公式识别错误，包括化学表达式、化学方程式内容、结构识别错误。

    **2.表格相关问题**
        -表格整体识别遗漏:原图中存在的整个表格，在转换后的文本中未找到对应的HTML<table>标签结构。
        -表格行列缺失:HTML表格的<tr>(行)或<td>/<th>(列)数量明显少于原图表格应有的行数或列数，导致大块数据区域丢失。
        -表头区域未检测到:已检测到 <table>，但未能正确使用 <th> 标签标记表头单元格，或 <thead> 结构缺失/错误。
        -复杂表头结构错误:表头包含跨行(rowspan属性)或跨列(colspan属性)单元格时，转换后的HTML表格属性或结构错误。
        -表头单元格缺失:表头区域<th>已检测到，但遗漏了原图表头中的一个或多个单元格。
        -表头单元格冗余错位:将非表头内容错误地标记为<th>，或<th>单元格的顺序、数量与原图不符。
        -表格主体行列数量不符: 表格主体(通常是<tbody>内的<tr>和<td>)的行数或列数与原图不一致。
        -单元格结构错误合并或拆分: 原图中正常的单个单元格在HTML输出中被错误地拆分成了多个<td>或<th>。原图中多个独立的单元格在HTML输出中被错误地合并成了一个<td>或<th>。原图中存在的跨行(rowspan)或跨列(colspan）单元格，在HTML输出中其属性值错误、缺失或不当应用。原始图像中应分离的表格区块，在Markdown中被错误地合并入单一<table>结构的主体行内，导致未能保持原有的分块结构。
        -单元格丢失: 在表格主体结构基本正确的情况下，某个或少数几个<td>单元格在HTML中完全丢失。
        -表格异常拆分:原图中一个完整的表格，被错误地识别成了多个独立的HTML<table>结构。
        -单元格内容错误: 无论单元格内原始内容是文本、数字、公式片段还是其他符号，只要其在HTML表格标签内的文本内容与原图不符，均归为此类。这包括字符识别错误、内容遗漏、内容冗余、标题分级错误、单元格内公式识别为文本或识别错误/丢失等。重要说明：此标签涵盖所有表格单元格内部的内容准确性问题。不再将表格内的公式错误、文本错误等单独归类到其他大类。

    **3. 分行分段相关问题**
        -非跨栏内容段落粘连: 原图中单栏布局下的多行文本或多个连续段落，在OCR结果中被错误地合并成一个段落。
        -段落异常拆分: 原图中一个完整的段落，在OCR结果中被错误地分割成了多行、多段文本。
        -跨栏内容合并失败: 在多栏布局的文档中，模型未能正确识别栏边界，导致不同栏的内容在输出中错误地连接或交织在一起。

    **4.列表相关问题**
        -列表项异常合并或粘连: 原图中文档中的独立的列表项（有序列表或无序列表，或者(1)、(2)...样式的列表）被合并成一行。可能是多个项合并成一项，或列表项与前后文本合并。

    **5.标题相关问题**
        -标题格式丢失: 原图中的标题，在OCR结果中被识别为普通文本，丢失了标题应有的Markdown格式（如#）。
        -正文识别成标题: 原图中的普通正文，被错误地识别并标记为标题。
        -标题分级错误: 原图中的标题被识别，但其层级（如H1, H2）与原图不符，包括层级识别错误（如一级标题识别为二级）。

    **6.代码相关问题**
        -代码块漏检: 代码块区域没有被识别为代码，没有markdown标记，而被当作普通文本处理。
        -缺少语言标识符: 已识别的代码块，在Markdown代码块标记后没有添加编程语言标识符（如```python）。
        -错误语言标识符: 已识别的代码块，添加了错误的编程语言标识符。
        -代码字符识别错误: 已识别的代码块内，字符或符号识别错误。

    **7.OCR相关问题**
        -文本识别错误: 非公式、代码、表格等特殊区域的普通文本，字符识别错误。
        -字符异常分割: 指单个词语或本应连续的字符序列在不应出现空格的地方被错误地插入了空格。具体包括：
    英文单词在其内部被错误地分割（例如 "hello" 被识别为 "he llo"）。中文文本中，在单个汉字之间或一个多字词语的内部被错误地插入了空格（例如，"关键词"被识别为 "关 键 词"，或 "你好" 被识别为 "你 好"）。
        -文本内容冗余: OCR结果中出现了原图没有的额外文本。图像中的污点、噪点或背景纹理被错误地识别为字符或符号。
        -文本内容识别遗漏: 原图中的文本内容在OCR结果中遗漏。
        -文本重复: 原图中的文本内容在OCR结果中被错误地重复输出。
        -标点符号识别错误: 标点符号的类型、形态（全角/半角）或语言属性（中文/英文）识别错误。例如，原图中为中文全角标点符号"："，Markdown文本中识别为英文半角标点符号":"，或反之；原图中为英文半角逗号","，Markdown文本中识别为中文全角逗号"，"，或反之。也包括标点符号种类本身的错误，如逗号识别为句号。
        -标点符号丢失: 原图中的标点符号在OCR结果中丢失。
        -文本格式丢失: 原图中文本具有的加粗、斜体等格式在Markdown中丢失。
        -文本格式应用错误: 原图中没有特定格式的普通文本，在Markdown中被错误地应用了加粗、斜体等格式。
        -文本中引用或角标格式丢失: 原图中文本的上标或下标，在Markdown结果中完全丢失，未通过LaTeX指数/下标或其他方式表示，或者被错误地识别为与主体文本在同一基线的普通字符。
        -文本中引用或角标识别错误: 原图中文本的上标或下标属性虽然被识别（例如以LaTeX指数/下标形式出现），但其内容（如数字、字母）识别错误，或者其位置识别错误（例如上标被错误识别为下标，或反之）。
        -特殊结构识别丢失: 如考题类下划线、选项括号识别丢失。
        -误识别为公式格式: 原图中的非公式内容（如普通符号或文本）被错误地识别地识别为公式格式。

    **8.页眉页脚或边注脚注混入问题**
        -页眉页脚混入正文：原图中的页眉页脚内容错误地出现在Markdown正文区域。
        -脚注边注混入正文：原图中的脚注边注内容错误地出现在Markdown正文区域。

    **9.阅读顺序问题**
        -阅读顺序错误: OCR输出的文本顺序与原图的逻辑阅读顺序不符。

    **10.其他**
        -其他问题: 此分类用于标记不属于上述任何具体类别的其他OCR质量问题。经过仔细判断后确认无法归入其他既有标签的OCR质量问题。当使用此标签时，必须在 reason 字段中提供清晰、详细的描述，说明该问题的具体性内容。

    *重要指示*
    你必须严格遵循关键评估原则与指南中的各项要求进行评估和报告。特别是第13条关于JSON有效性和转义规则的指示。
    每个错误对象必须包含error_id, error_category, error_label, 和details字段。
    对于所有具有相同error_label的错误实例，只在最终的errors列表中创建一个对应的错误对象，其 details字段将描述所有这些实例（详见指南14）。
    error_id 字段为每个汇总后的错误对象分配一个唯一的序号（从1开始递增）。
    error_category字段应填写从错误类别和标签列表中选取的大类文本（如,公式相关问题）。
    error_label字段应填写从错误类别和标签列表中选取的一个具体的二级标签文本（如"行内公式漏检"）。确保此字段只包含一个二级标签。
    details字段的值必须是一个单一的字符串。这个字符串用于简洁地描述该类错误在原始图像中出现的一个或多个位置或具体情况，可以包含多句话。例如："文本的第二行和第三行都出现了字符识别错误。"或 "原图中第一行公式的角标识别错误，同时第三段公式中的分数线丢失。" 请简单描述，避免过度复杂或不必要的引号。

    *输出格式*
    请严格按照以下JSON结构组织你的发现：
    ```json
    {
    "errors": [
        {
        "error_id": "1", //错误序号（从1开始）
        "error_category": "OCR相关问题", // 错误的大类
        "error_label": "标点符号丢失", // 从上面的《错误类别和标签》列表中选取的一个具体的二级标签,作为汇总依据，如：标点符号丢失
        "details": "原图中第一行末尾的句号丢失；第二段第三句的逗号也丢失了。" // 对当前error_label类型的具体问题和出现位置的简洁描述，尽量避免引用导致的引号问题。
        },
        {
        "error_id": "2",
        "error_category": "公式相关问题",
        "error_label": "行内公式字符识别错误",
        "details": "行内公式字符识别错误出现在多处：第一段的公式被错误识别；第三段的公式内容也有误。"
        },
        {
        "error_id": "3",
        // ... 更多按 error_label 汇总的错误
        }
    ]
    }
    ```
    *如果未发现任何错误，请返回：*
    ```json
    {
    "errors": []
    }
    ```

    *工作流程:*
    1.  接收并理解 **原始图像** 和 **转换后Markdown文本**。
    2.  仔细比对两者，识别所有内容和格式上的差异。
    3.  根据 **错误类别和标签** 对每个差异进行分类。
    4.  记录每个错误的信息（位置、错误类别、错误标签、错误原因）。如果同一位置存在多个独立的错误，请在 errors 列表内分别列出，不要在堆叠。
    5.  按照指定的 **输出格式** 生成 JSON 报告。

    *输入:*
    *   **原始图像：** [待提供的原始图像]
    *   **转换后的Markdown文本：** [待提供的转换后Markdown文本内容]

    *输出:*
    ```json
    [请在此处提供你的JSON分析结果]
    ```
    """
