# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.2.8
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from perian.models.accelerator_data_view import AcceleratorDataView
from perian.models.availability import Availability
from perian.models.compute_instance_type import ComputeInstanceType
from perian.models.cpu_data import CpuData
from perian.models.memory import Memory
from perian.models.network import Network
from perian.models.price_data import PriceData
from perian.models.provider import Provider
from perian.models.region import Region
from perian.models.storage_data import StorageData
from perian.models.zone import Zone
from typing import Optional, Set
from typing_extensions import Self

class InstanceTypeView(BaseModel):
    """
    Limited View on Model representation of a cloud provider instance type.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    provider: Optional[Provider] = None
    region: Optional[Region] = None
    zone: Optional[Zone] = None
    type: Optional[ComputeInstanceType] = None
    cpu: Optional[CpuData] = None
    accelerator: Optional[AcceleratorDataView] = None
    ram: Optional[Memory] = None
    storage: Optional[StorageData] = None
    network: Optional[Network] = None
    price: Optional[PriceData] = None
    availability: Optional[Availability] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    attributes_hash: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "provider", "region", "zone", "type", "cpu", "accelerator", "ram", "storage", "network", "price", "availability", "created_at", "updated_at", "attributes_hash"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InstanceTypeView from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of region
        if self.region:
            _dict['region'] = self.region.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu
        if self.cpu:
            _dict['cpu'] = self.cpu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of accelerator
        if self.accelerator:
            _dict['accelerator'] = self.accelerator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ram
        if self.ram:
            _dict['ram'] = self.ram.to_dict()
        # override the default output from pydantic by calling `to_dict()` of storage
        if self.storage:
            _dict['storage'] = self.storage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict['network'] = self.network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict['price'] = self.price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of availability
        if self.availability:
            _dict['availability'] = self.availability.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if provider (nullable) is None
        # and model_fields_set contains the field
        if self.provider is None and "provider" in self.model_fields_set:
            _dict['provider'] = None

        # set to None if region (nullable) is None
        # and model_fields_set contains the field
        if self.region is None and "region" in self.model_fields_set:
            _dict['region'] = None

        # set to None if zone (nullable) is None
        # and model_fields_set contains the field
        if self.zone is None and "zone" in self.model_fields_set:
            _dict['zone'] = None

        # set to None if attributes_hash (nullable) is None
        # and model_fields_set contains the field
        if self.attributes_hash is None and "attributes_hash" in self.model_fields_set:
            _dict['attributes_hash'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InstanceTypeView from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "provider": Provider.from_dict(obj["provider"]) if obj.get("provider") is not None else None,
            "region": Region.from_dict(obj["region"]) if obj.get("region") is not None else None,
            "zone": Zone.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "type": obj.get("type"),
            "cpu": CpuData.from_dict(obj["cpu"]) if obj.get("cpu") is not None else None,
            "accelerator": AcceleratorDataView.from_dict(obj["accelerator"]) if obj.get("accelerator") is not None else None,
            "ram": Memory.from_dict(obj["ram"]) if obj.get("ram") is not None else None,
            "storage": StorageData.from_dict(obj["storage"]) if obj.get("storage") is not None else None,
            "network": Network.from_dict(obj["network"]) if obj.get("network") is not None else None,
            "price": PriceData.from_dict(obj["price"]) if obj.get("price") is not None else None,
            "availability": Availability.from_dict(obj["availability"]) if obj.get("availability") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "attributes_hash": obj.get("attributes_hash")
        })
        return _obj


