from typing import Any, Callable, Final, Generic, Tuple, TypeVar
from typing_extensions import Protocol, Self
from .lexer import BaseLexer, Token


class SupportGetCommand(Protocol):
    def __getitem__(self, __key: str) -> Callable: ...


T_CmdSet = TypeVar("T_CmdSet", bound=SupportGetCommand)
T_Lexer = TypeVar("T_Lexer", bound=BaseLexer)


class Parser(Generic[T_Lexer, T_CmdSet]):
    lexer: Final[T_Lexer]
    command_set: Final[T_CmdSet]

    def __init__(self, lexer: T_Lexer, command_set: T_CmdSet) -> None: ...
    def push(self, token: Token) -> None: ...
    def pop(self) -> Token: ...
    def parse_args(self) -> Tuple[tuple, dict]: ...
    def exec_once(self) -> Any: ...
    def exec(self) -> None: ...
    def eof(self) -> bool: ...
    def __iter__(self) -> Self: ...
    def __next__(self) -> Any: ...