# generated by datamodel-codegen:
#   filename:  AdaptiveGrader.json

from __future__ import annotations
from typing import Annotated, Any, List, Literal, Optional, Union
from .base import DtoBaseModel
from uuid import UUID
from pydantic import Field
from enum import Enum


class ChatMessage(DtoBaseModel):
    content: str
    metadata: Optional[Any] = None
    role: str


class Custom(DtoBaseModel):
    description: Optional[str] = None
    type: Literal["Custom"] = "Custom"


class JudgeExample(DtoBaseModel):
    id: UUID
    input: List[ChatMessage]
    output: str
    pass_: Annotated[bool, Field(alias="pass")]
    reasoning: Optional[str] = None


class PrebuiltConfigKey(Enum):
    AnswerRelevancy = "AnswerRelevancy"
    ContextRelevancy = "ContextRelevancy"
    Faithfulness = "Faithfulness"


class Remote(DtoBaseModel):
    description: str
    type: Literal["Remote"] = "Remote"
    url: str
    version: str


class Judge(DtoBaseModel):
    criteria: str
    examples: List[JudgeExample]
    model_uri: str
    type: Literal["Judge"] = "Judge"


class Prebuilt(DtoBaseModel):
    model_uri: str
    prebuilt_config_key: PrebuiltConfigKey
    type: Literal["Prebuilt"] = "Prebuilt"


class AdaptiveGrader(DtoBaseModel):
    config: Annotated[Union[Judge, Prebuilt, Remote, Custom], Field(discriminator="type")]
    grader_id: UUID
    key: str
    metric_id: UUID
    name: str
