# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_3
import enum
from typing import Any, Callable, ClassVar

__pyx_capi__: dict
__test__: dict
cleanup_threads: _cython_3_1_3.cython_function_or_method
cleanup_threads_double: _cython_3_1_3.cython_function_or_method
cleanup_threads_float: _cython_3_1_3.cython_function_or_method
destroy: _cython_3_1_3.cython_function_or_method
destroy_plan_double: _cython_3_1_3.cython_function_or_method
destroy_plan_float: _cython_3_1_3.cython_function_or_method
execute: _cython_3_1_3.cython_function_or_method
execute_c2c_double: _cython_3_1_3.cython_function_or_method
execute_c2c_float: _cython_3_1_3.cython_function_or_method
execute_c2r_double: _cython_3_1_3.cython_function_or_method
execute_c2r_float: _cython_3_1_3.cython_function_or_method
execute_r2c_double: _cython_3_1_3.cython_function_or_method
execute_r2c_float: _cython_3_1_3.cython_function_or_method
get_version: _cython_3_1_3.cython_function_or_method
init_threads: _cython_3_1_3.cython_function_or_method
init_threads_double: _cython_3_1_3.cython_function_or_method
init_threads_float: _cython_3_1_3.cython_function_or_method
plan_many: _cython_3_1_3.cython_function_or_method
plan_many_c2c_double: _cython_3_1_3.cython_function_or_method
plan_many_c2c_float: _cython_3_1_3.cython_function_or_method
plan_many_c2r_double: _cython_3_1_3.cython_function_or_method
plan_many_c2r_float: _cython_3_1_3.cython_function_or_method
plan_many_r2c_double: _cython_3_1_3.cython_function_or_method
plan_many_r2c_float: _cython_3_1_3.cython_function_or_method
plan_with_nthreads: _cython_3_1_3.cython_function_or_method
plan_with_nthreads_double: _cython_3_1_3.cython_function_or_method
plan_with_nthreads_float: _cython_3_1_3.cython_function_or_method
planner_nthreads: _cython_3_1_3.cython_function_or_method
planner_nthreads_double: _cython_3_1_3.cython_function_or_method
planner_nthreads_float: _cython_3_1_3.cython_function_or_method

class FFTWError(Exception): ...

class FFTWUnaligned(FFTWError): ...

class Kind(enum.IntFlag):
    """An enumeration."""
    __new__: ClassVar[Callable] = ...
    C2C: ClassVar[Kind] = ...
    C2R: ClassVar[Kind] = ...
    R2C: ClassVar[Kind] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Plan:
    @classmethod
    def __init__(cls, *args, **kwargs) -> None:
        """Create and return a new object.  See help(type) for accurate signature."""
    def __reduce__(self) -> Any:
        """Plan.__reduce__(self)"""

class PlannerFlags(enum.IntFlag):
    """An enumeration."""
    __new__: ClassVar[Callable] = ...
    ESTIMATE: ClassVar[PlannerFlags] = ...
    EXHAUSTIVE: ClassVar[PlannerFlags] = ...
    MEASURE: ClassVar[PlannerFlags] = ...
    PATIENT: ClassVar[PlannerFlags] = ...
    WISDOM_ONLY: ClassVar[PlannerFlags] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Precision(enum.IntFlag):
    """An enumeration."""
    __new__: ClassVar[Callable] = ...
    DOUBLE: ClassVar[Precision] = ...
    FLOAT: ClassVar[Precision] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Sign(enum.IntFlag):
    """An enumeration."""
    __new__: ClassVar[Callable] = ...
    FORWARD: ClassVar[Sign] = ...
    INVERSE: ClassVar[Sign] = ...
    UNSPECIFIED: ClassVar[Sign] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...
