"""price growth

Revision ID: b62d0afd2675
Revises: 5f6984590216
Create Date: 2025-06-15 07:06:37.914668

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "b62d0afd2675"
down_revision: Union[str, None] = "5f6984590216"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_analysis_source"))
        batch_op.drop_index(batch_op.f("ix_analysis_symbol"))

    op.drop_table("analysis")
    with op.batch_alter_table("view", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_view_source"))
        batch_op.drop_index(batch_op.f("ix_view_symbol"))

    op.drop_table("view")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "view",
        sa.Column("symbol", sa.VARCHAR(), nullable=False),
        sa.Column("exchange", sa.VARCHAR(), nullable=True),
        sa.Column("source", sa.VARCHAR(), nullable=False),
        sa.Column("date", sa.DATE(), nullable=False),
        sa.Column("created_at", sa.DATE(), nullable=False),
        sa.Column("name", sa.VARCHAR(), nullable=True),
        sa.Column("isin", sa.VARCHAR(), nullable=True),
        sa.Column("view_name", sa.VARCHAR(), nullable=True),
        sa.Column("id", sa.INTEGER(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("view", schema=None) as batch_op:
        batch_op.create_index(batch_op.f("ix_view_symbol"), ["symbol"], unique=False)
        batch_op.create_index(batch_op.f("ix_view_source"), ["source"], unique=False)

    op.create_table(
        "analysis",
        sa.Column("quarterly_positive_free_cash_flow", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_growing_operating_cash_flow", sa.FLOAT(), nullable=True),
        sa.Column(
            "quarterly_operating_cash_flow_is_higher_than_net_income",
            sa.FLOAT(),
            nullable=True,
        ),
        sa.Column("quarterly_mean_capex_ratio", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_max_capex_ratio", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_min_capex_ratio", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_mean_dividend_payout_ratio", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_max_dividend_payout_ratio", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_min_dividend_payout_ratio", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_positive_net_income", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_positive_operating_income", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_growing_net_income", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_growing_operating_income", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_positive_diluted_eps", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_positive_basic_eps", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_growing_basic_eps", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_growing_diluted_eps", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_positive_debt_to_equity", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_positive_return_on_assets", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_positive_return_on_equity", sa.FLOAT(), nullable=True),
        sa.Column("quarterly_earning_per_share", sa.FLOAT(), nullable=True),
        sa.Column("positive_free_cash_flow", sa.FLOAT(), nullable=True),
        sa.Column("growing_operating_cash_flow", sa.FLOAT(), nullable=True),
        sa.Column(
            "operating_cash_flow_is_higher_than_net_income", sa.FLOAT(), nullable=True
        ),
        sa.Column("mean_capex_ratio", sa.FLOAT(), nullable=True),
        sa.Column("max_capex_ratio", sa.FLOAT(), nullable=True),
        sa.Column("min_capex_ratio", sa.FLOAT(), nullable=True),
        sa.Column("mean_dividend_payout_ratio", sa.FLOAT(), nullable=True),
        sa.Column("max_dividend_payout_ratio", sa.FLOAT(), nullable=True),
        sa.Column("min_dividend_payout_ratio", sa.FLOAT(), nullable=True),
        sa.Column("positive_net_income", sa.FLOAT(), nullable=True),
        sa.Column("positive_operating_income", sa.FLOAT(), nullable=True),
        sa.Column("growing_net_income", sa.FLOAT(), nullable=True),
        sa.Column("growing_operating_income", sa.FLOAT(), nullable=True),
        sa.Column("positive_diluted_eps", sa.FLOAT(), nullable=True),
        sa.Column("positive_basic_eps", sa.FLOAT(), nullable=True),
        sa.Column("growing_basic_eps", sa.FLOAT(), nullable=True),
        sa.Column("growing_diluted_eps", sa.FLOAT(), nullable=True),
        sa.Column("positive_debt_to_equity", sa.FLOAT(), nullable=True),
        sa.Column("positive_return_on_assets", sa.FLOAT(), nullable=True),
        sa.Column("positive_return_on_equity", sa.FLOAT(), nullable=True),
        sa.Column("earning_per_share", sa.FLOAT(), nullable=True),
        sa.Column("rsi_last_value", sa.FLOAT(), nullable=True),
        sa.Column("macd_12_26_9_buy_date", sa.DATE(), nullable=True),
        sa.Column("ma_50_200_buy_date", sa.DATE(), nullable=True),
        sa.Column("slope_7", sa.FLOAT(), nullable=True),
        sa.Column("slope_14", sa.FLOAT(), nullable=True),
        sa.Column("slope_30", sa.FLOAT(), nullable=True),
        sa.Column("slope_60", sa.FLOAT(), nullable=True),
        sa.Column("last_adx", sa.FLOAT(), nullable=True),
        sa.Column("last_dmp", sa.FLOAT(), nullable=True),
        sa.Column("last_dmn", sa.FLOAT(), nullable=True),
        sa.Column("last_price", sa.FLOAT(), nullable=True),
        sa.Column("last_price_date", sa.DATE(), nullable=True),
        sa.Column("year_to_date_growth", sa.FLOAT(), nullable=True),
        sa.Column("last_52_weeks_growth", sa.FLOAT(), nullable=True),
        sa.Column("last_week_growth", sa.FLOAT(), nullable=True),
        sa.Column("last_month_growth", sa.FLOAT(), nullable=True),
        sa.Column("last_year_growth", sa.FLOAT(), nullable=True),
        sa.Column("year_to_date_max_growth", sa.FLOAT(), nullable=True),
        sa.Column("last_week_max_growth", sa.FLOAT(), nullable=True),
        sa.Column("last_month_max_growth", sa.FLOAT(), nullable=True),
        sa.Column("last_year_max_growth", sa.FLOAT(), nullable=True),
        sa.Column("macd_12_26_9_buy", sa.FLOAT(), nullable=True),
        sa.Column("star_yoy", sa.FLOAT(), nullable=True),
        sa.Column("star_wow", sa.FLOAT(), nullable=True),
        sa.Column("star_mom", sa.FLOAT(), nullable=True),
        sa.Column("symbol", sa.VARCHAR(), nullable=False),
        sa.Column("exchange", sa.VARCHAR(), nullable=True),
        sa.Column("source", sa.VARCHAR(), nullable=False),
        sa.Column("date", sa.DATE(), nullable=False),
        sa.Column("created_at", sa.DATE(), nullable=False),
        sa.Column("name", sa.VARCHAR(), nullable=True),
        sa.Column("isin", sa.VARCHAR(), nullable=True),
        sa.Column("base_symbol", sa.VARCHAR(), nullable=False),
        sa.Column("modifier", sa.VARCHAR(), nullable=True),
        sa.Column("summary", sa.VARCHAR(), nullable=True),
        sa.Column("currency", sa.VARCHAR(), nullable=True),
        sa.Column("market", sa.VARCHAR(), nullable=True),
        sa.Column("country", sa.VARCHAR(), nullable=True),
        sa.Column("sector", sa.VARCHAR(), nullable=True),
        sa.Column("industry_group", sa.VARCHAR(), nullable=True),
        sa.Column("industry", sa.VARCHAR(), nullable=True),
        sa.Column("website", sa.VARCHAR(), nullable=True),
        sa.Column("market_capitalization", sa.FLOAT(), nullable=True),
        sa.Column("book_value", sa.FLOAT(), nullable=True),
        sa.Column("price_to_book", sa.FLOAT(), nullable=True),
        sa.Column("trailing_price_to_earnings", sa.FLOAT(), nullable=True),
        sa.Column("dividend_yield", sa.FLOAT(), nullable=True),
        sa.Column("dividend_rate", sa.FLOAT(), nullable=True),
        sa.Column("trailing_earnings_per_share", sa.FLOAT(), nullable=True),
        sa.Column("forward_earnings_per_share", sa.FLOAT(), nullable=True),
        sa.Column("return_on_equity", sa.FLOAT(), nullable=True),
        sa.Column("operating_margins", sa.FLOAT(), nullable=True),
        sa.Column("gross_margins", sa.FLOAT(), nullable=True),
        sa.Column("revenue_growth", sa.FLOAT(), nullable=True),
        sa.Column("price_per_earning_ratio", sa.FLOAT(), nullable=True),
        sa.Column("id", sa.INTEGER(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_analysis_symbol"), ["symbol"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_analysis_source"), ["source"], unique=False
        )

    # ### end Alembic commands ###
