/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous;

import infodynamics.measures.continuous.MutualInfoCalculatorMultiVariate;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;
import java.util.Iterator;
import java.util.Vector;

public abstract class MutualInfoMultiVariateCommon
implements MutualInfoCalculatorMultiVariate {
    protected int dimensionsSource = 1;
    protected int dimensionsDest = 1;
    protected double[][] sourceObservations;
    protected double[][] destObservations;
    protected int totalObservations = 0;
    protected double lastAverage;
    protected boolean miComputed;
    protected boolean debug;
    protected int timeDiff = 0;
    protected Vector<double[][]> vectorOfSourceObservations;
    protected Vector<double[][]> vectorOfDestinationObservations;
    protected boolean addedMoreThanOneObservationSet;

    @Override
    public void initialise() throws Exception {
        this.initialise(this.dimensionsSource, this.dimensionsDest);
    }

    @Override
    public void initialise(int n, int n2) {
        this.dimensionsSource = n;
        this.dimensionsDest = n2;
        this.lastAverage = 0.0;
        this.totalObservations = 0;
        this.miComputed = false;
        this.sourceObservations = null;
        this.destObservations = null;
        this.addedMoreThanOneObservationSet = false;
    }

    @Override
    public void setProperty(String string, String string2) throws Exception {
        boolean bl = true;
        if (string.equalsIgnoreCase("TIME_DIFF")) {
            this.timeDiff = Integer.parseInt(string2);
            if (this.timeDiff < 0) {
                throw new Exception("Time difference must be >= 0. Flip data1 and data2 around if required.");
            }
        } else {
            bl = false;
        }
        if (this.debug && bl) {
            System.out.println(this.getClass().getSimpleName() + ": Set property " + string + " to " + string2);
        }
    }

    @Override
    public String getProperty(String string) throws Exception {
        if (string.equalsIgnoreCase("TIME_DIFF")) {
            return Integer.toString(this.timeDiff);
        }
        return null;
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2) throws Exception {
        this.startAddObservations();
        this.addObservations(dArray, dArray2);
        this.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2) throws Exception {
        this.startAddObservations();
        this.addObservations(dArray, dArray2);
        this.finaliseAddObservations();
    }

    @Override
    public void startAddObservations() {
        this.vectorOfSourceObservations = new Vector();
        this.vectorOfDestinationObservations = new Vector();
    }

    @Override
    public void addObservations(double[][] dArray, double[][] dArray2) throws Exception {
        if (this.vectorOfSourceObservations == null) {
            throw new RuntimeException("User did not call startAddObservations before addObservations");
        }
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray.length <= this.timeDiff) {
            return;
        }
        if (dArray[0].length != this.dimensionsSource) {
            throw new Exception(String.format("Number of joint variables in source data %d does not match the initialised value %d", dArray[0].length, this.dimensionsSource));
        }
        if (dArray2[0].length != this.dimensionsDest) {
            throw new Exception(String.format("Number of joint variables in destination data %d does not match the initialised value %d", dArray2[0].length, this.dimensionsDest));
        }
        this.vectorOfSourceObservations.add(dArray);
        this.vectorOfDestinationObservations.add(dArray2);
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2) throws Exception {
        if (this.dimensionsDest != 1 || this.dimensionsSource != 1) {
            throw new Exception("The number of source and dest dimensions (having been initialised to " + this.dimensionsSource + " and " + this.dimensionsDest + ") can only be 1 when " + "the univariate addObservations(double[],double[]) and " + "setObservations(double[],double[]) methods are called");
        }
        this.addObservations(MatrixUtils.reshape(dArray, dArray.length, 1), MatrixUtils.reshape(dArray2, dArray2.length, 1));
    }

    @Override
    public void addObservations(double[][] dArray, double[][] dArray2, int n, int n2) throws Exception {
        if (this.vectorOfSourceObservations == null) {
            throw new RuntimeException("User did not call startAddObservations before addObservations");
        }
        if (n2 <= this.timeDiff) {
            return;
        }
        double[][] dArrayArray = new double[n2][];
        System.arraycopy(dArray, n, dArrayArray, 0, n2);
        this.vectorOfSourceObservations.add(dArrayArray);
        double[][] dArrayArray2 = new double[n2][];
        System.arraycopy(dArray2, n, dArrayArray2, 0, n2);
        this.vectorOfDestinationObservations.add(dArrayArray2);
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2, int n, int n2) throws Exception {
        if (this.dimensionsDest != 1 || this.dimensionsSource != 1) {
            throw new Exception("The number of source and dest dimensions (having been initialised to " + this.dimensionsSource + " and " + this.dimensionsDest + ") can only be 1 when " + "the univariate addObservations(double[],double[]) and " + "setObservations(double[],double[]) methods are called");
        }
        this.addObservations(MatrixUtils.reshape(dArray, dArray.length, 1), MatrixUtils.reshape(dArray2, dArray2.length, 1), n, n2);
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2, boolean[] blArray, boolean[] blArray2) throws Exception {
        Vector<int[]> vector = this.computeStartAndEndTimePairs(blArray, blArray2);
        this.startAddObservations();
        for (int[] nArray : vector) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.addObservations(dArray, dArray2, n, n2 - n + 1);
        }
        this.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2, boolean[] blArray, boolean[] blArray2) throws Exception {
        if (this.dimensionsDest != 1 || this.dimensionsSource != 1) {
            throw new Exception("The number of source and dest dimensions (having been initialised to " + this.dimensionsSource + " and " + this.dimensionsDest + ") can only be 1 when " + "the univariate addObservations(double[],double[]) and " + "setObservations(double[],double[]) methods are called");
        }
        this.setObservations(MatrixUtils.reshape(dArray, dArray.length, 1), MatrixUtils.reshape(dArray2, dArray2.length, 1), blArray, blArray2);
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2, boolean[][] blArray, boolean[][] blArray2) throws Exception {
        boolean[] blArray3 = MatrixUtils.andRows(blArray);
        boolean[] blArray4 = MatrixUtils.andRows(blArray2);
        this.setObservations(dArray, dArray2, blArray3, blArray4);
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        this.totalObservations = 0;
        for (double[][] object2 : this.vectorOfDestinationObservations) {
            this.totalObservations += object2.length - this.timeDiff;
        }
        this.destObservations = new double[this.totalObservations][this.dimensionsDest];
        this.sourceObservations = new double[this.totalObservations][this.dimensionsSource];
        int n = 0;
        Iterator<double[][]> iterator = this.vectorOfDestinationObservations.iterator();
        for (double[][] dArray : this.vectorOfSourceObservations) {
            double[][] dArray2 = iterator.next();
            MatrixUtils.arrayCopy(dArray, 0, 0, this.sourceObservations, n, 0, dArray.length - this.timeDiff, this.dimensionsSource);
            MatrixUtils.arrayCopy(dArray2, this.timeDiff, 0, this.destObservations, n, 0, dArray2.length - this.timeDiff, this.dimensionsDest);
            n += dArray2.length - this.timeDiff;
        }
        if (this.vectorOfSourceObservations.size() > 1) {
            this.addedMoreThanOneObservationSet = true;
        }
        this.vectorOfSourceObservations = null;
        this.vectorOfDestinationObservations = null;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.sourceObservations.length, n);
        return this.computeSignificance(nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        int n = nArray.length;
        if (!this.miComputed) {
            this.computeAverageLocalOfObservations();
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.computeAverageLocalOfObservations(nArray[i]);
            if (!this.debug) continue;
            System.out.println("New MI was " + dArray[i]);
        }
        return new EmpiricalMeasurementDistribution(dArray, this.lastAverage);
    }

    @Override
    public double computeAverageLocalOfObservations(int[] nArray) throws Exception {
        if (nArray == null) {
            return this.computeAverageLocalOfObservations();
        }
        MutualInfoMultiVariateCommon mutualInfoMultiVariateCommon = (MutualInfoMultiVariateCommon)this.clone();
        double[][] dArray = MatrixUtils.extractSelectedTimePointsReusingArrays(this.sourceObservations, nArray);
        mutualInfoMultiVariateCommon.initialise(this.dimensionsSource, this.dimensionsDest);
        mutualInfoMultiVariateCommon.setObservations(dArray, this.destObservations);
        return mutualInfoMultiVariateCommon.computeAverageLocalOfObservations();
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2) throws Exception {
        if (this.dimensionsDest != 1 || this.dimensionsSource != 1) {
            throw new Exception("The number of source and dest dimensions (having been initialised to " + this.dimensionsSource + " and " + this.dimensionsDest + ") can only be 1 when " + "the univariate addObservations(double[],double[]) and " + "setObservations(double[],double[]) methods are called");
        }
        return this.computeLocalUsingPreviousObservations(MatrixUtils.reshape(dArray, dArray.length, 1), MatrixUtils.reshape(dArray2, dArray2.length, 1));
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }

    @Override
    public int getNumObservations() throws Exception {
        return this.totalObservations;
    }

    @Override
    public boolean getAddedMoreThanOneObservationSet() {
        return this.addedMoreThanOneObservationSet;
    }

    public Vector<int[]> computeStartAndEndTimePairs(boolean[] blArray, boolean[] blArray2) {
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        Vector<int[]> vector = new Vector<int[]>();
        for (int i = 0; i < blArray2.length; ++i) {
            if (bl) {
                if (blArray2[i] && blArray[i - this.timeDiff]) {
                    n2 = i;
                    bl = false;
                    if (i != blArray2.length - 1) continue;
                    int[] nArray = new int[]{n, n2};
                    vector.add(nArray);
                    continue;
                }
                ++n;
                continue;
            }
            boolean bl2 = false;
            if (blArray2[i] && blArray[i - this.timeDiff]) {
                n2 = i;
            } else {
                bl2 = true;
            }
            if (i == blArray2.length - 1) {
                bl2 = true;
            }
            if (!bl2) continue;
            int[] nArray = new int[]{n, n2};
            vector.add(nArray);
            bl = true;
            n = i + 1;
        }
        return vector;
    }
}

