/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.continuous.MultiInfoCalculator;
import infodynamics.measures.discrete.ContextOfPastMeasureCalculatorDiscrete;
import infodynamics.measures.discrete.SeparableInfoCalculatorDiscreteByAddition;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import java.util.Properties;

public class SeparableInfoCalculatorDiscrete
extends ContextOfPastMeasureCalculatorDiscrete {
    protected int numSources = 0;
    protected int base_power_sources = 0;
    protected int[][][][] sourceNumValueNextPastCount = null;
    protected int[][][] sourcesNextPastCount = null;
    protected int[][][] sourceNumValuePastCount = null;
    protected double avPositiveLocal = 0.0;
    protected double avNegativeLocal = 0.0;
    protected double meanSqLocals;
    protected boolean periodicBoundaryConditions = true;
    protected boolean computeMultiInfoCoherence = false;
    protected MultiInfoCalculator miCalc = null;
    public static final int ROW_INDEX = 0;
    public static final int COLUMN_INDEX = 0;
    public static int MAX_CONFIGS_FOR_DIRECT_CALC = 1000000;
    public static boolean FORCE_DIRECT_CALC = false;

    public static SeparableInfoCalculatorDiscrete newInstance(int n, int n2, int n3) {
        if (n2 < 1) {
            throw new RuntimeException("This class does not currently function with k < 1 (see ConditionalTransferEntropyCalculator for how to implement this)");
        }
        if (!FORCE_DIRECT_CALC && MathsUtils.power(n, n3 + n2 + 1) > MAX_CONFIGS_FOR_DIRECT_CALC) {
            return new SeparableInfoCalculatorDiscreteByAddition(n, n2, n3);
        }
        return new SeparableInfoCalculatorDiscrete(n, n2, n3);
    }

    public SeparableInfoCalculatorDiscrete(int n, int n2, int n3) {
        this(n, n2, n3, false);
    }

    protected SeparableInfoCalculatorDiscrete(int n, int n2, int n3, boolean bl) {
        super(n, n2, bl);
        this.numSources = n3;
        this.base_power_sources = MathsUtils.power(n, this.numSources);
        if (n3 < 1) {
            throw new RuntimeException("Number of info contributors < 1 for SeparableInfoCalculator");
        }
        if (!bl) {
            this.sourceNumValueNextPastCount = new int[n3][n][n][this.base_power_k];
            this.sourcesNextPastCount = new int[this.base_power_sources][n][this.base_power_k];
            this.sourceNumValuePastCount = new int[n3][n][this.base_power_k];
        }
    }

    @Override
    public void initialise() {
        super.initialise();
        if (!this.noObservationStorage) {
            MatrixUtils.fill(this.sourceNumValueNextPastCount, 0);
            MatrixUtils.fill(this.sourcesNextPastCount, 0);
            MatrixUtils.fill(this.sourceNumValuePastCount, 0);
        }
        if (this.computeMultiInfoCoherence) {
            this.miCalc.initialise(this.numSources + 1);
        }
    }

    public void addObservations(int[][] nArray, int[] nArray2) {
        this.addObservations(nArray, nArray2, false);
    }

    private void addObservations(int[][] nArray, int[] nArray2, boolean bl) {
        int n;
        int n2;
        int[] nArray3 = bl ? nArray2 : this.cleanOffsetOfDestFromSources(nArray2);
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        int n5 = MatrixUtils.min(nArray3);
        int n6 = MatrixUtils.max(nArray3);
        int n7 = Math.max(0, n6);
        int n8 = n4 - 1 + Math.min(0, n5);
        this.observations = this.periodicBoundaryConditions ? (this.observations += (n3 - this.k) * n4) : (this.observations += (n3 - this.k) * (n8 - n7 + 1));
        int[] nArray4 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray4[n2] = 0;
            for (n = 0; n < this.k; ++n) {
                int n9 = n2;
                nArray4[n9] = nArray4[n9] * this.base;
                int n10 = n2;
                nArray4[n10] = nArray4[n10] + nArray[n][n2];
            }
        }
        for (int i = this.k; i < n3; ++i) {
            for (int j = this.periodicBoundaryConditions ? 0 : n7; j < (this.periodicBoundaryConditions ? n4 : n8 + 1); ++j) {
                n2 = nArray[i][j];
                int[] nArray5 = this.nextPastCount[n2];
                int n11 = nArray4[j];
                nArray5[n11] = nArray5[n11] + 1;
                int n12 = nArray4[j];
                this.pastCount[n12] = this.pastCount[n12] + 1;
                int n13 = n2;
                this.nextCount[n13] = this.nextCount[n13] + 1;
                int n14 = 0;
                for (int k = 0; k < this.numSources; ++k) {
                    n = nArray[i - 1][(j - nArray3[k] + n4) % n4];
                    int[] nArray6 = this.sourceNumValueNextPastCount[k][n][n2];
                    int n15 = nArray4[j];
                    nArray6[n15] = nArray6[n15] + 1;
                    int[] nArray7 = this.sourceNumValuePastCount[k][n];
                    int n16 = nArray4[j];
                    nArray7[n16] = nArray7[n16] + 1;
                    n14 *= this.base;
                    n14 += n;
                }
                int[] nArray8 = this.sourcesNextPastCount[n14][n2];
                int n17 = nArray4[j];
                nArray8[n17] = nArray8[n17] + 1;
                int n18 = j;
                nArray4[n18] = nArray4[n18] - this.maxShiftedValue[nArray[i - this.k][j]];
                int n19 = j;
                nArray4[n19] = nArray4[n19] * this.base;
                int n20 = j;
                nArray4[n20] = nArray4[n20] + nArray[i][j];
            }
        }
    }

    public void addObservations(int[][][] nArray, int[][] nArray2) {
        this.addObservations(nArray, nArray2, false);
    }

    private void addObservations(int[][][] nArray, int[][] nArray2, boolean bl) {
        int n;
        int n2;
        int n3;
        int[][] nArray3 = bl ? nArray2 : this.cleanOffsetOfDestFromSources(nArray2);
        int n4 = nArray.length;
        if (n4 == 0) {
            return;
        }
        int n5 = nArray[0].length;
        if (n5 == 0) {
            return;
        }
        int n6 = nArray[0][0].length;
        int n7 = MatrixUtils.min(nArray3, 0);
        int n8 = MatrixUtils.max(nArray3, 0);
        int n9 = Math.max(0, n8);
        int n10 = n5 - 1 + Math.min(0, n7);
        int n11 = MatrixUtils.min(nArray3, 0);
        int n12 = MatrixUtils.max(nArray3, 0);
        int n13 = Math.max(0, n12);
        int n14 = n6 - 1 + Math.min(0, n11);
        this.observations = this.periodicBoundaryConditions ? (this.observations += (n4 - this.k) * n5 * n6) : (this.observations += (n4 - this.k) * (n10 - n9 + 1) * (n14 - n13 + 1));
        int[][] nArray4 = new int[n5][n6];
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                nArray4[n3][n2] = 0;
                for (n = 0; n < this.k; ++n) {
                    int[] nArray5 = nArray4[n3];
                    int n15 = n2;
                    nArray5[n15] = nArray5[n15] * this.base;
                    int[] nArray6 = nArray4[n3];
                    int n16 = n2;
                    nArray6[n16] = nArray6[n16] + nArray[n][n3][n2];
                }
            }
        }
        for (int i = this.k; i < n4; ++i) {
            for (int j = this.periodicBoundaryConditions ? 0 : n9; j < (this.periodicBoundaryConditions ? n5 : n10 + 1); ++j) {
                for (int k = this.periodicBoundaryConditions ? 0 : n13; k < (this.periodicBoundaryConditions ? n6 : n14 + 1); ++k) {
                    n3 = nArray[i][j][k];
                    int[] nArray7 = this.nextPastCount[n3];
                    int n17 = nArray4[j][k];
                    nArray7[n17] = nArray7[n17] + 1;
                    int n18 = nArray4[j][k];
                    this.pastCount[n18] = this.pastCount[n18] + 1;
                    int n19 = n3;
                    this.nextCount[n19] = this.nextCount[n19] + 1;
                    n = 0;
                    for (int i2 = 0; i2 < this.numSources; ++i2) {
                        n2 = nArray[i - 1][(j - nArray3[i2][0] + n5) % n5][(k - nArray3[i2][0] + n6) % n6];
                        int[] nArray8 = this.sourceNumValueNextPastCount[i2][n2][n3];
                        int n20 = nArray4[j][k];
                        nArray8[n20] = nArray8[n20] + 1;
                        int[] nArray9 = this.sourceNumValuePastCount[i2][n2];
                        int n21 = nArray4[j][k];
                        nArray9[n21] = nArray9[n21] + 1;
                        n *= this.base;
                        n += n2;
                    }
                    int[] nArray10 = this.sourcesNextPastCount[n][n3];
                    int n22 = nArray4[j][k];
                    nArray10[n22] = nArray10[n22] + 1;
                    int[] nArray11 = nArray4[j];
                    int n23 = k;
                    nArray11[n23] = nArray11[n23] - this.maxShiftedValue[nArray[i - this.k][j][k]];
                    int[] nArray12 = nArray4[j];
                    int n24 = k;
                    nArray12[n24] = nArray12[n24] * this.base;
                    int[] nArray13 = nArray4[j];
                    int n25 = k;
                    nArray13[n25] = nArray13[n25] + nArray[i][j][k];
                }
            }
        }
    }

    public void addObservations(int[][] nArray, int n, int[] nArray2) {
        this.addObservations(nArray, n, nArray2, false);
    }

    private void addObservations(int[][] nArray, int n, int[] nArray2, boolean bl) {
        int n2;
        int[] nArray3 = bl ? nArray2 : this.cleanAbsoluteSources(nArray2, n);
        int n3 = nArray.length;
        this.observations += n3 - this.k;
        int n4 = 0;
        for (n2 = 0; n2 < this.k; ++n2) {
            n4 *= this.base;
            n4 += nArray[n2][n];
        }
        for (int i = this.k; i < n3; ++i) {
            n2 = nArray[i][n];
            int[] nArray4 = this.nextPastCount[n2];
            int n5 = n4;
            nArray4[n5] = nArray4[n5] + 1;
            int n6 = n4;
            this.pastCount[n6] = this.pastCount[n6] + 1;
            int n7 = n2;
            this.nextCount[n7] = this.nextCount[n7] + 1;
            int n8 = 0;
            for (int j = 0; j < this.numSources; ++j) {
                int n9 = nArray[i - 1][nArray3[j]];
                int[] nArray5 = this.sourceNumValueNextPastCount[j][n9][n2];
                int n10 = n4;
                nArray5[n10] = nArray5[n10] + 1;
                int[] nArray6 = this.sourceNumValuePastCount[j][n9];
                int n11 = n4;
                nArray6[n11] = nArray6[n11] + 1;
                n8 *= this.base;
                n8 += n9;
            }
            int[] nArray7 = this.sourcesNextPastCount[n8][n2];
            int n12 = n4;
            nArray7[n12] = nArray7[n12] + 1;
            n4 -= this.maxShiftedValue[nArray[i - this.k][n]];
            n4 *= this.base;
            n4 += nArray[i][n];
        }
    }

    public void addObservations(int[][][] nArray, int n, int n2, int[][] nArray2) {
        this.addObservations(nArray, n, n2, nArray2, false);
    }

    private void addObservations(int[][][] nArray, int n, int n2, int[][] nArray2, boolean bl) {
        int n3;
        int[][] nArray3 = bl ? nArray2 : this.cleanAbsoluteSources(nArray2, n, n2);
        int n4 = nArray.length;
        this.observations += n4 - this.k;
        int n5 = 0;
        for (n3 = 0; n3 < this.k; ++n3) {
            n5 *= this.base;
            n5 += nArray[n3][n][n2];
        }
        for (int i = this.k; i < n4; ++i) {
            n3 = nArray[i][n][n2];
            int[] nArray4 = this.nextPastCount[n3];
            int n6 = n5;
            nArray4[n6] = nArray4[n6] + 1;
            int n7 = n5;
            this.pastCount[n7] = this.pastCount[n7] + 1;
            int n8 = n3;
            this.nextCount[n8] = this.nextCount[n8] + 1;
            int n9 = 0;
            for (int j = 0; j < this.numSources; ++j) {
                int n10 = nArray[i - 1][nArray3[j][0]][nArray3[j][0]];
                int[] nArray5 = this.sourceNumValueNextPastCount[j][n10][n3];
                int n11 = n5;
                nArray5[n11] = nArray5[n11] + 1;
                int[] nArray6 = this.sourceNumValuePastCount[j][n10];
                int n12 = n5;
                nArray6[n12] = nArray6[n12] + 1;
                n9 *= this.base;
                n9 += n10;
            }
            int[] nArray7 = this.sourcesNextPastCount[n9][n3];
            int n13 = n5;
            nArray7[n13] = nArray7[n13] + 1;
            n5 -= this.maxShiftedValue[nArray[i - this.k][n][n2]];
            n5 *= this.base;
            n5 += nArray[i][n][n2];
        }
    }

    @Override
    public synchronized double computeAverageLocalOfObservations() {
        this.max = 0.0;
        this.min = 0.0;
        this.meanSqLocals = 0.0;
        this.average = 0.0;
        this.avPositiveLocal = 0.0;
        this.avNegativeLocal = 0.0;
        if (this.computeMultiInfoCoherence) {
            this.miCalc.startAddObservations();
        }
        int[] nArray = new int[this.numSources];
        this.computeAverageLocalOfObservations(nArray, 0);
        try {
            if (this.computeMultiInfoCoherence) {
                this.miCalc.finaliseAddObservations();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Number of causal contributors changed from intialisation to calculation!");
        }
        this.std = Math.sqrt(this.meanSqLocals - this.average * this.average);
        return this.average;
    }

    protected void computeAverageLocalOfObservations(int[] nArray, int n) {
        if (n < nArray.length) {
            int n2 = 0;
            while (n2 < this.base) {
                nArray[n] = n2++;
                this.computeAverageLocalOfObservations(nArray, n + 1);
            }
            return;
        }
        int n3 = 0;
        for (int i = 0; i < this.numSources; ++i) {
            n3 *= this.base;
            n3 += nArray[i];
        }
        double[] dArray = new double[this.numSources + 1];
        for (int i = 0; i < this.base_power_k; ++i) {
            for (int j = 0; j < this.base; ++j) {
                int n4;
                if (this.sourcesNextPastCount[n3][j][i] == 0) continue;
                double d = (double)this.nextPastCount[j][i] / ((double)this.nextCount[j] * (double)this.pastCount[i]);
                d *= (double)this.observations;
                if (this.computeMultiInfoCoherence) {
                    dArray[0] = Math.log(d);
                }
                for (n4 = 0; n4 < this.numSources; ++n4) {
                    int n5 = nArray[n4];
                    dArray[n4 + 1] = (double)this.sourceNumValueNextPastCount[n4][n5][j][i] / (double)this.sourceNumValuePastCount[n4][n5][i] / ((double)this.nextPastCount[j][i] / (double)this.pastCount[i]);
                    d *= dArray[n4 + 1];
                    if (!this.computeMultiInfoCoherence) continue;
                    dArray[n4 + 1] = Math.log(dArray[n4 + 1]);
                }
                if (this.computeMultiInfoCoherence) {
                    for (n4 = 0; n4 < this.sourcesNextPastCount[n3][j][i]; ++n4) {
                        this.miCalc.addObservation(dArray);
                    }
                }
                double d2 = Math.log(d) / this.log_2;
                double d3 = (double)this.sourcesNextPastCount[n3][j][i] / (double)this.observations * d2;
                this.average += d3;
                if (d3 >= 0.0) {
                    this.avPositiveLocal += d3;
                } else {
                    this.avNegativeLocal += d3;
                }
                if (d2 > this.max) {
                    this.max = d2;
                } else if (d2 < this.min) {
                    this.min = d2;
                }
                this.meanSqLocals += d3 * d2;
            }
        }
    }

    public double[][] computeLocalFromPreviousObservations(int[][] nArray, int[] nArray2) {
        return this.computeLocalFromPreviousObservations(nArray, nArray2, false);
    }

    private double[][] computeLocalFromPreviousObservations(int[][] nArray, int[] nArray2, boolean bl) {
        int n;
        int[] nArray3 = bl ? nArray2 : this.cleanOffsetOfDestFromSources(nArray2);
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int n4 = MatrixUtils.min(nArray3);
        int n5 = MatrixUtils.max(nArray3);
        int n6 = Math.max(0, n5);
        int n7 = n3 - 1 + Math.min(0, n4);
        double[][] dArray = new double[n2][n3];
        this.average = 0.0;
        this.avPositiveLocal = 0.0;
        this.avNegativeLocal = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[] nArray4 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray4[i] = 0;
            for (n = 0; n < this.k; ++n) {
                int n8 = i;
                nArray4[n8] = nArray4[n8] * this.base;
                int n9 = i;
                nArray4[n9] = nArray4[n9] + nArray[n][i];
            }
        }
        if (this.computeMultiInfoCoherence) {
            this.miCalc.startAddObservations();
        }
        double[] dArray2 = new double[this.numSources + 1];
        for (int i = this.k; i < n2; ++i) {
            for (int j = this.periodicBoundaryConditions ? 0 : n6; j < (this.periodicBoundaryConditions ? n3 : n7 + 1); ++j) {
                n = nArray[i][j];
                double d = (double)this.nextPastCount[n][nArray4[j]] / ((double)this.nextCount[n] * (double)this.pastCount[nArray4[j]]);
                d *= (double)this.observations;
                if (this.computeMultiInfoCoherence) {
                    dArray2[0] = Math.log(d);
                }
                for (int k = 0; k < this.numSources; ++k) {
                    int n10 = nArray[i - 1][(j - nArray3[k] + n3) % n3];
                    dArray2[k + 1] = (double)this.sourceNumValueNextPastCount[k][n10][n][nArray4[j]] / (double)this.sourceNumValuePastCount[k][n10][nArray4[j]] / ((double)this.nextPastCount[n][nArray4[j]] / (double)this.pastCount[nArray4[j]]);
                    d *= dArray2[k + 1];
                    if (!this.computeMultiInfoCoherence) continue;
                    dArray2[k + 1] = Math.log(dArray2[k + 1]);
                }
                if (this.computeMultiInfoCoherence) {
                    this.miCalc.addObservation(dArray2);
                }
                dArray[i][j] = Math.log(d) / this.log_2;
                this.average += dArray[i][j];
                if (dArray[i][j] > 0.0) {
                    this.avPositiveLocal += dArray[i][j];
                } else {
                    this.avNegativeLocal += dArray[i][j];
                }
                if (dArray[i][j] > this.max) {
                    this.max = dArray[i][j];
                } else if (dArray[i][j] < this.min) {
                    this.min = dArray[i][j];
                }
                int n11 = j;
                nArray4[n11] = nArray4[n11] - this.maxShiftedValue[nArray[i - this.k][j]];
                int n12 = j;
                nArray4[n12] = nArray4[n12] * this.base;
                int n13 = j;
                nArray4[n13] = nArray4[n13] + nArray[i][j];
            }
        }
        if (this.periodicBoundaryConditions) {
            this.average /= (double)(n3 * (n2 - this.k));
            this.avPositiveLocal /= (double)(n3 * (n2 - this.k));
            this.avNegativeLocal /= (double)(n3 * (n2 - this.k));
        } else {
            this.average /= (double)((n2 - this.k) * (n7 - n6 + 1));
            this.avPositiveLocal /= (double)((n2 - this.k) * (n7 - n6 + 1));
            this.avNegativeLocal /= (double)((n2 - this.k) * (n7 - n6 + 1));
        }
        try {
            if (this.computeMultiInfoCoherence) {
                this.miCalc.finaliseAddObservations();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Number of causal contributors changed from intialisation to calculation!");
        }
        return dArray;
    }

    public double[][][] computeLocalFromPreviousObservations(int[][][] nArray, int[][] nArray2) {
        return this.computeLocalFromPreviousObservations(nArray, nArray2, false);
    }

    private double[][][] computeLocalFromPreviousObservations(int[][][] nArray, int[][] nArray2, boolean bl) {
        int n;
        int n2;
        int[][] nArray3 = bl ? nArray2 : this.cleanOffsetOfDestFromSources(nArray2);
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        int n5 = nArray[0][0].length;
        int n6 = MatrixUtils.min(nArray3, 0);
        int n7 = MatrixUtils.max(nArray3, 0);
        int n8 = Math.max(0, n7);
        int n9 = n4 - 1 + Math.min(0, n6);
        int n10 = MatrixUtils.min(nArray3, 0);
        int n11 = MatrixUtils.max(nArray3, 0);
        int n12 = Math.max(0, n11);
        int n13 = n5 - 1 + Math.min(0, n10);
        double[][][] dArray = new double[n3][n4][n5];
        this.average = 0.0;
        this.avPositiveLocal = 0.0;
        this.avNegativeLocal = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[][] nArray4 = new int[n4][n5];
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n5; ++n2) {
                nArray4[i][n2] = 0;
                for (n = 0; n < this.k; ++n) {
                    int[] nArray5 = nArray4[i];
                    int n14 = n2;
                    nArray5[n14] = nArray5[n14] * this.base;
                    int[] nArray6 = nArray4[i];
                    int n15 = n2;
                    nArray6[n15] = nArray6[n15] + nArray[n][i][n2];
                }
            }
        }
        if (this.computeMultiInfoCoherence) {
            this.miCalc.startAddObservations();
        }
        double[] dArray2 = new double[this.numSources + 1];
        for (int i = this.k; i < n3; ++i) {
            for (int j = this.periodicBoundaryConditions ? 0 : n8; j < (this.periodicBoundaryConditions ? n4 : n9 + 1); ++j) {
                for (int k = this.periodicBoundaryConditions ? 0 : n12; k < (this.periodicBoundaryConditions ? n5 : n13 + 1); ++k) {
                    n2 = nArray[i][j][k];
                    double d = (double)this.nextPastCount[n2][nArray4[j][k]] / ((double)this.nextCount[n2] * (double)this.pastCount[nArray4[j][k]]);
                    d *= (double)this.observations;
                    if (this.computeMultiInfoCoherence) {
                        dArray2[0] = Math.log(d);
                    }
                    for (int i2 = 0; i2 < this.numSources; ++i2) {
                        n = nArray[i - 1][(j - nArray3[i2][0] + n4) % n4][(k - nArray3[i2][0] + n5) % n5];
                        dArray2[i2 + 1] = (double)this.sourceNumValueNextPastCount[i2][n][n2][nArray4[j][k]] / (double)this.sourceNumValuePastCount[i2][n][nArray4[j][k]] / ((double)this.nextPastCount[n2][nArray4[j][k]] / (double)this.pastCount[nArray4[j][k]]);
                        d *= dArray2[i2 + 1];
                        if (!this.computeMultiInfoCoherence) continue;
                        dArray2[i2 + 1] = Math.log(dArray2[i2 + 1]);
                    }
                    if (this.computeMultiInfoCoherence) {
                        this.miCalc.addObservation(dArray2);
                    }
                    dArray[i][j][k] = Math.log(d) / this.log_2;
                    this.average += dArray[i][j][k];
                    if (dArray[i][j][k] > 0.0) {
                        this.avPositiveLocal += dArray[i][j][k];
                    } else {
                        this.avNegativeLocal += dArray[i][j][k];
                    }
                    if (dArray[i][j][k] > this.max) {
                        this.max = dArray[i][j][k];
                    } else if (dArray[i][j][k] < this.min) {
                        this.min = dArray[i][j][k];
                    }
                    int[] nArray7 = nArray4[j];
                    int n16 = k;
                    nArray7[n16] = nArray7[n16] - this.maxShiftedValue[nArray[i - this.k][j][k]];
                    int[] nArray8 = nArray4[j];
                    int n17 = k;
                    nArray8[n17] = nArray8[n17] * this.base;
                    int[] nArray9 = nArray4[j];
                    int n18 = k;
                    nArray9[n18] = nArray9[n18] + nArray[i][j][k];
                }
            }
        }
        if (this.periodicBoundaryConditions) {
            this.average /= (double)((n3 - this.k) * n4 * n5);
            this.avPositiveLocal /= (double)((n3 - this.k) * n4 * n5);
            this.avNegativeLocal /= (double)((n3 - this.k) * n4 * n5);
        } else {
            this.average /= (double)((n3 - this.k) * (n9 - n8 + 1) * (n13 - n12 + 1));
            this.avPositiveLocal /= (double)((n3 - this.k) * (n9 - n8 + 1) * (n13 - n12 + 1));
            this.avNegativeLocal /= (double)((n3 - this.k) * (n9 - n8 + 1) * (n13 - n12 + 1));
        }
        try {
            if (this.computeMultiInfoCoherence) {
                this.miCalc.finaliseAddObservations();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Number of causal contributors changed from intialisation to calculation!");
        }
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n, int[] nArray2) {
        return this.computeLocalFromPreviousObservations(nArray, n, nArray2, false);
    }

    private double[] computeLocalFromPreviousObservations(int[][] nArray, int n, int[] nArray2, boolean bl) {
        int[] nArray3 = bl ? nArray2 : this.cleanAbsoluteSources(nArray2, n);
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        this.average = 0.0;
        this.avPositiveLocal = 0.0;
        this.avNegativeLocal = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n3 = 0;
        n3 = 0;
        for (int i = 0; i < this.k; ++i) {
            n3 *= this.base;
            n3 += nArray[i][n];
        }
        if (this.computeMultiInfoCoherence) {
            this.miCalc.startAddObservations();
        }
        double[] dArray2 = new double[this.numSources + 1];
        for (int i = this.k; i < n2; ++i) {
            int n4 = nArray[i][n];
            double d = (double)this.nextPastCount[n4][n3] / ((double)this.nextCount[n4] * (double)this.pastCount[n3]);
            d *= (double)this.observations;
            if (this.computeMultiInfoCoherence) {
                dArray2[0] = Math.log(d);
            }
            for (int j = 0; j < this.numSources; ++j) {
                int n5 = nArray[i - 1][nArray3[j]];
                dArray2[j + 1] = (double)this.sourceNumValueNextPastCount[j][n5][n4][n3] / (double)this.sourceNumValuePastCount[j][n5][n3] / ((double)this.nextPastCount[n4][n3] / (double)this.pastCount[n3]);
                d *= dArray2[j + 1];
                if (!this.computeMultiInfoCoherence) continue;
                dArray2[j + 1] = Math.log(dArray2[j + 1]);
            }
            if (this.computeMultiInfoCoherence) {
                this.miCalc.addObservation(dArray2);
            }
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > 0.0) {
                this.avPositiveLocal += dArray[i];
            } else {
                this.avNegativeLocal += dArray[i];
            }
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            n3 -= this.maxShiftedValue[nArray[i - this.k][n]];
            n3 *= this.base;
            n3 += nArray[i][n];
        }
        this.average /= (double)(n2 - this.k);
        this.avPositiveLocal /= (double)(n2 - this.k);
        this.avNegativeLocal /= (double)(n2 - this.k);
        try {
            if (this.computeMultiInfoCoherence) {
                this.miCalc.finaliseAddObservations();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Number of causal contributors changed from intialisation to calculation!");
        }
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2, int[][] nArray2) {
        return this.computeLocalFromPreviousObservations(nArray, n, n2, nArray2, false);
    }

    private double[] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2, int[][] nArray2, boolean bl) {
        int[][] nArray3 = bl ? nArray2 : this.cleanAbsoluteSources(nArray2, n, n2);
        int n3 = nArray.length;
        double[] dArray = new double[n3];
        this.average = 0.0;
        this.avPositiveLocal = 0.0;
        this.avNegativeLocal = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n4 = 0;
        n4 = 0;
        for (int i = 0; i < this.k; ++i) {
            n4 *= this.base;
            n4 += nArray[i][n][n2];
        }
        if (this.computeMultiInfoCoherence) {
            this.miCalc.startAddObservations();
        }
        double[] dArray2 = new double[this.numSources + 1];
        for (int i = this.k; i < n3; ++i) {
            int n5 = nArray[i][n][n2];
            double d = (double)this.nextPastCount[n5][n4] / ((double)this.nextCount[n5] * (double)this.pastCount[n4]);
            d *= (double)this.observations;
            if (this.computeMultiInfoCoherence) {
                dArray2[0] = Math.log(d);
            }
            for (int j = 0; j < this.numSources; ++j) {
                int n6 = nArray[i - 1][nArray3[j][0]][nArray3[j][0]];
                dArray2[j + 1] = (double)this.sourceNumValueNextPastCount[j][n6][n5][n4] / (double)this.sourceNumValuePastCount[j][n6][n4] / ((double)this.nextPastCount[n5][n4] / (double)this.pastCount[n4]);
                d *= dArray2[j + 1];
                if (!this.computeMultiInfoCoherence) continue;
                dArray2[j + 1] = Math.log(dArray2[j + 1]);
            }
            if (this.computeMultiInfoCoherence) {
                this.miCalc.addObservation(dArray2);
            }
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > 0.0) {
                this.avPositiveLocal += dArray[i];
            } else {
                this.avNegativeLocal += dArray[i];
            }
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            n4 -= this.maxShiftedValue[nArray[i - this.k][n][n2]];
            n4 *= this.base;
            n4 += nArray[i][n][n2];
        }
        this.average /= (double)(n3 - this.k);
        this.avPositiveLocal /= (double)(n3 - this.k);
        this.avNegativeLocal /= (double)(n3 - this.k);
        try {
            if (this.computeMultiInfoCoherence) {
                this.miCalc.finaliseAddObservations();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Number of causal contributors changed from intialisation to calculation!");
        }
        return dArray;
    }

    public double[][] computeLocal(int[][] nArray, int[] nArray2) {
        this.initialise();
        int[] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        this.addObservations(nArray, nArray3, true);
        return this.computeLocalFromPreviousObservations(nArray, nArray3, true);
    }

    public double[][][] computeLocal(int[][][] nArray, int[][] nArray2) {
        this.initialise();
        int[][] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        this.addObservations(nArray, nArray3, true);
        return this.computeLocalFromPreviousObservations(nArray, nArray3, true);
    }

    public double computeAverageLocal(int[][] nArray, int[] nArray2) {
        this.initialise();
        this.addObservations(nArray, nArray2);
        return this.computeAverageLocalOfObservations();
    }

    public double computeAverageLocal(int[][][] nArray, int[][] nArray2) {
        this.initialise();
        this.addObservations(nArray, nArray2);
        return this.computeAverageLocalOfObservations();
    }

    public double[] computeLocal(int[][] nArray, int n, int[] nArray2) {
        this.initialise();
        int[] nArray3 = this.cleanAbsoluteSources(nArray2, n);
        this.addObservations(nArray, n, nArray3, true);
        return this.computeLocalFromPreviousObservations(nArray, n, nArray3, true);
    }

    public double[] computeLocal(int[][][] nArray, int n, int n2, int[][] nArray2) {
        this.initialise();
        int[][] nArray3 = this.cleanAbsoluteSources(nArray2, n, n2);
        this.addObservations(nArray, n, n2, nArray3, true);
        return this.computeLocalFromPreviousObservations(nArray, n, n2, nArray3, true);
    }

    public double computeAverageLocal(int[][] nArray, int n, int[] nArray2) {
        this.initialise();
        this.addObservations(nArray, n, nArray2);
        return this.computeAverageLocalOfObservations();
    }

    public double computeAverageLocal(int[][][] nArray, int n, int n2, int[][] nArray2) {
        this.initialise();
        this.addObservations(nArray, n, n2, nArray2);
        return this.computeAverageLocalOfObservations();
    }

    public double getLastAveragePositive() {
        return this.avPositiveLocal;
    }

    public double getLastAverageNegative() {
        return this.avNegativeLocal;
    }

    public static int countOfOffsetSources(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            ++n;
        }
        return n;
    }

    public static int countOfOffsetSources(int[][] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i][0] == 0 || nArray[i][0] == 0) continue;
            ++n;
        }
        return n;
    }

    public static int countOfAbsoluteSources(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            ++n2;
        }
        return n2;
    }

    public static int countOfAbsoluteSources(int[][] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i][0] == n || nArray[i][0] == n2) continue;
            ++n3;
        }
        return n3;
    }

    public boolean confirmEnoughOffsetSources(int[] nArray) {
        if (SeparableInfoCalculatorDiscrete.countOfOffsetSources(nArray) != this.numSources) {
            throw new RuntimeException("Incorrect number of sources in offsets");
        }
        return true;
    }

    public boolean confirmEnoughOffsetSources(int[][] nArray) {
        if (SeparableInfoCalculatorDiscrete.countOfOffsetSources(nArray) != this.numSources) {
            throw new RuntimeException("Incorrect number of sources in offsets");
        }
        return true;
    }

    public boolean confirmEnoughAbsoluteSources(int[] nArray, int n) {
        if (SeparableInfoCalculatorDiscrete.countOfAbsoluteSources(nArray, n) != this.numSources) {
            throw new RuntimeException("Incorrect number of sources in absolutes");
        }
        return true;
    }

    public boolean confirmEnoughAbsoluteSources(int[][] nArray, int n, int n2) {
        if (SeparableInfoCalculatorDiscrete.countOfAbsoluteSources(nArray, n, n2) != this.numSources) {
            throw new RuntimeException("Incorrect number of sources in absolutes");
        }
        return true;
    }

    public int[] cleanOffsetOfDestFromSources(int[] nArray) {
        int[] nArray2 = new int[this.numSources];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            if (n == this.numSources) {
                ++n;
                break;
            }
            nArray2[n] = nArray[i];
            ++n;
        }
        if (n < this.numSources) {
            throw new RuntimeException("Too few sources in offsets");
        }
        if (n > this.numSources) {
            throw new RuntimeException("Too many sources in offsets");
        }
        return nArray2;
    }

    public int[][] cleanOffsetOfDestFromSources(int[][] nArray) {
        int[][] nArray2 = new int[this.numSources][2];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i][0] == 0 && nArray[i][1] == 0) continue;
            if (n == this.numSources) {
                ++n;
                break;
            }
            nArray2[n][0] = nArray[i][0];
            nArray2[n][0] = nArray[i][0];
            ++n;
        }
        if (n < this.numSources) {
            throw new RuntimeException("Too few sources in offsets");
        }
        if (n > this.numSources) {
            throw new RuntimeException("Too many sources in offsets");
        }
        return nArray2;
    }

    public int[] cleanAbsoluteSources(int[] nArray, int n) {
        int[] nArray2 = new int[this.numSources];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            if (n2 == this.numSources) {
                ++n2;
                break;
            }
            nArray2[n2] = nArray[i];
            ++n2;
        }
        if (n2 < this.numSources) {
            throw new RuntimeException("Too few sources in absolutes");
        }
        if (n2 > this.numSources) {
            throw new RuntimeException("Too many sources in absolutes");
        }
        return nArray2;
    }

    public int[][] cleanAbsoluteSources(int[][] nArray, int n, int n2) {
        int[][] nArray2 = new int[this.numSources][2];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i][0] == n || nArray[i][0] == n2) continue;
            if (n3 == this.numSources) {
                ++n3;
                break;
            }
            nArray2[n3][0] = nArray[i][0];
            nArray2[n3][0] = nArray[i][0];
            ++n3;
        }
        if (n3 < this.numSources) {
            throw new RuntimeException("Too few sources in absolutes");
        }
        if (n3 > this.numSources) {
            throw new RuntimeException("Too many sources in absolutes");
        }
        return nArray2;
    }

    public boolean isPeriodicBoundaryConditions() {
        return this.periodicBoundaryConditions;
    }

    public void setPeriodicBoundaryConditions(boolean bl) {
        this.periodicBoundaryConditions = bl;
    }

    public boolean isComputeMultiInfoCoherence() {
        return this.computeMultiInfoCoherence;
    }

    public void setComputeMultiInfoCoherence(String string, Properties properties) throws Exception {
        this.computeMultiInfoCoherence = true;
        try {
            this.miCalc = (MultiInfoCalculator)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot initiate class " + string + " as the MultiInfoCalculator class inside SeparableInfoCalculator");
        }
        this.miCalc.setDebug(this.debug);
        for (Object object : properties.keySet()) {
            String string2 = (String)object;
            String string3 = properties.getProperty(string2);
            this.miCalc.setProperty(string2, string3);
        }
        if (this.miCalc == null) {
            throw new Exception("Calculator was not initialised with a multi-info calculator to compute the coherence");
        }
    }

    public void clearComputeMultiInfoCoherence() {
        this.computeMultiInfoCoherence = false;
    }

    public double computeMultiInfoCoherence() throws Exception {
        if (!this.computeMultiInfoCoherence) {
            throw new Exception("Calculator was not set to track coherence before separable info was calculated");
        }
        return this.miCalc.computeAverageLocalOfObservations();
    }

    public boolean canComputeMultiInfoCoherenceFromAverageOfObservations() {
        return true;
    }

    public void resetMultiInfoCoherenceCalculator() {
        this.miCalc.initialise(this.numSources + 1);
    }

    @Override
    public void setDebug(boolean bl) {
        if (this.computeMultiInfoCoherence) {
            this.miCalc.setDebug(bl);
        }
        super.setDebug(bl);
    }
}

