/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import infodynamics.utils.NonPositiveDefiniteMatrixException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class MatrixUtils {
    public static double[][] identityMatrix(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    public static int[] range(int n, int n2) {
        int[] nArray = new int[n2 - n + 1];
        for (int i = 0; i < n2 - n + 1; ++i) {
            nArray[i] = n + i;
        }
        return nArray;
    }

    public static double[] constantArray(int n, double d) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        return dArray;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double sum(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n + n2; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double sumSpecificIndices(double[] dArray, int[] nArray) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += dArray[nArray[i]];
        }
        return d;
    }

    public static double sumSpecificIndices(double[] dArray, int[][] nArray, int n) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += dArray[nArray[i][n]];
        }
        return d;
    }

    public static double sumSpecificIndices(double[] dArray, int[][] nArray, int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += dArray[nArray[i][n] + n2];
        }
        return d;
    }

    public static double sum(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                d += dArray[i][j];
            }
        }
        return d;
    }

    public static double sum(double[][] dArray, int n) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i][n];
        }
        return d;
    }

    public static double sum(double[][][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    d += dArray[i][j][k];
                }
            }
        }
        return d;
    }

    public static int sum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static int sum(int[][] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                n += nArray[i][j];
            }
        }
        return n;
    }

    public static int sum(int[][][] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                for (int k = 0; k < nArray[i][j].length; ++k) {
                    n += nArray[i][j][k];
                }
            }
        }
        return n;
    }

    public static double[] sums(double[][] dArray) {
        double[] dArray2 = new double[dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                int n = j;
                dArray2[n] = dArray2[n] + dArray[i][j];
            }
        }
        return dArray2;
    }

    public static double[] sums(double[][] dArray, int n, int n2) {
        double[] dArray2 = new double[dArray[0].length];
        for (int i = n; i < n + n2; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                int n3 = j;
                dArray2[n3] = dArray2[n3] + dArray[i][j];
            }
        }
        return dArray2;
    }

    public static int countIf(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static int countIf(int[][] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                if (nArray[i][j] != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static int countIf(long[][] lArray, long l) {
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            for (int j = 0; j < lArray[0].length; ++j) {
                if (lArray[i][j] != l) continue;
                ++n;
            }
        }
        return n;
    }

    public static int countIf(int[] nArray, int n, int[] nArray2, int n2) throws Exception {
        if (nArray.length != nArray2.length) {
            throw new Exception("MatrixUtils.sumIf() - arguments are not of equal length (" + nArray.length + " != " + nArray2.length + ")");
        }
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n || nArray2[i] != n2) continue;
            ++n3;
        }
        return n3;
    }

    public static int countIf(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3) throws Exception {
        if (nArray.length != nArray2.length || nArray.length != nArray3.length) {
            throw new Exception("MatrixUtils.sumIf() - arguments are not of equal length (" + nArray.length + " != " + nArray2.length + " != " + nArray3.length + ")");
        }
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n || nArray2[i] != n2 || nArray3[i] != n3) continue;
            ++n4;
        }
        return n4;
    }

    public static int countIf(boolean[] blArray, boolean bl) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] != bl) continue;
            ++n;
        }
        return n;
    }

    public static double mean(int[] nArray) {
        return (double)MatrixUtils.sum(nArray) / (double)nArray.length;
    }

    public static double mean(double[] dArray) {
        return MatrixUtils.sum(dArray) / (double)dArray.length;
    }

    public static double mean(double[] dArray, int n, int n2) {
        return MatrixUtils.sum(dArray, n, n2) / (double)n2;
    }

    public static double mean(double[][] dArray) {
        return MatrixUtils.sum(dArray) / (double)(dArray.length * dArray[0].length);
    }

    public static double mean(double[][] dArray, int n) {
        return MatrixUtils.sum(dArray, n) / (double)dArray.length;
    }

    public static double[] means(double[][] dArray) {
        double[] dArray2 = MatrixUtils.sums(dArray);
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray2[i] / (double)dArray.length;
        }
        return dArray2;
    }

    public static double[] means(double[][] dArray, int n, int n2) {
        double[] dArray2 = MatrixUtils.sums(dArray, n, n2);
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray2[i] / (double)n2;
        }
        return dArray2;
    }

    public static double[] meansOfRows(double[][] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = MatrixUtils.mean(dArray[i]);
        }
        return dArray2;
    }

    public static int[][] columnShift(int[][] nArray, int n) {
        if (n == 0) {
            return nArray;
        }
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        while (n < 0) {
            n += n3;
        }
        int[][] nArray2 = new int[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                nArray2[i][(j + n) % n3] = nArray[i][j];
            }
        }
        return nArray2;
    }

    public static double[][] columnShift(double[][] dArray, int n) {
        if (n == 0) {
            return dArray;
        }
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        while (n < 0) {
            n += n3;
        }
        double[][] dArray2 = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                dArray2[i][(j + n) % n3] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static int[] matrixToArray(int[][] nArray, int n, int n2, int n3, int n4) {
        int[] nArray2 = new int[n2 * n4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray2[i * n2 + j] = nArray[j + n][i + n3];
            }
        }
        return nArray2;
    }

    public static int[] matrixToArray(int[][] nArray, int n, int n2) {
        return MatrixUtils.matrixToArray(nArray, n, n2, 0, nArray[0].length);
    }

    public static int[] matrixToArray(int[][] nArray) {
        return MatrixUtils.matrixToArray(nArray, 0, nArray.length, 0, nArray[0].length);
    }

    public static double[] matrixToArray(double[][] dArray, int n, int n2, int n3, int n4) {
        double[] dArray2 = new double[n2 * n4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i * n2 + j] = dArray[j + n][i + n3];
            }
        }
        return dArray2;
    }

    public static double[] matrixToArray(double[][] dArray, int n, int n2) {
        return MatrixUtils.matrixToArray(dArray, n, n2, 0, dArray[0].length);
    }

    public static double[] matrixToArray(double[][] dArray) {
        return MatrixUtils.matrixToArray(dArray, 0, dArray.length, 0, dArray[0].length);
    }

    public static int[] add(int[] nArray, int[] nArray2) throws Exception {
        if (nArray.length != nArray2.length) {
            throw new Exception("Lengths of arrays are not equal");
        }
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = nArray[i] + nArray2[i];
        }
        return nArray3;
    }

    public static double[] add(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("Lengths of arrays are not equal");
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
        return dArray3;
    }

    public static void addInPlace(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("Lengths of arrays are not equal");
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] + dArray2[i];
        }
    }

    public static void addSquaresInPlace(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("Lengths of arrays are not equal");
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] + dArray2[i] * dArray2[i];
        }
    }

    public static int[][] add(int[][] nArray, int[][] nArray2) throws Exception {
        int n = nArray.length;
        int n2 = nArray[0].length;
        if (nArray2.length != n) {
            throw new Exception("Row length of arrays are not equal");
        }
        if (nArray2[0].length != n2) {
            throw new Exception("Column length of arrays are not equal");
        }
        int[][] nArray3 = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray3[i][j] = nArray[i][j] + nArray2[i][j];
            }
        }
        return nArray3;
    }

    public static double[][] add(double[][] dArray, double[][] dArray2) throws Exception {
        int n = dArray.length;
        int n2 = dArray[0].length;
        if (dArray2.length != n) {
            throw new Exception("Row length of arrays are not equal");
        }
        if (dArray2[0].length != n2) {
            throw new Exception("Column length of arrays are not equal");
        }
        double[][] dArray3 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray3[i][j] = dArray[i][j] + dArray2[i][j];
            }
        }
        return dArray3;
    }

    public static double[][][] add(double[][][] dArray, double[][][] dArray2) throws Exception {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        if (dArray2.length != n) {
            throw new Exception("Row length of arrays are not equal");
        }
        if (dArray2[0].length != n2) {
            throw new Exception("Column length of arrays are not equal");
        }
        if (dArray2[0][0].length != n3) {
            throw new Exception("Heights (3rd dim) of arrays are not equal");
        }
        double[][][] dArray3 = new double[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    dArray3[i][j][k] = dArray[i][j][k] + dArray2[i][j][k];
                }
            }
        }
        return dArray3;
    }

    public static double[] subtract(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("Lengths of arrays are not equal");
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
        return dArray3;
    }

    public static double[] subtract(double[] dArray, double d) throws Exception {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i] - d;
        }
        return dArray2;
    }

    public static void subtractInPlace(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("Lengths of arrays are not equal");
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] - dArray2[i];
        }
    }

    public static int[][] subtract(int[][] nArray, int[][] nArray2) throws Exception {
        int n = nArray.length;
        int n2 = nArray[0].length;
        if (nArray2.length != n) {
            throw new Exception("Row length of arrays are not equal");
        }
        if (nArray2[0].length != n2) {
            throw new Exception("Column length of arrays are not equal");
        }
        int[][] nArray3 = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray3[i][j] = nArray[i][j] - nArray2[i][j];
            }
        }
        return nArray3;
    }

    public static int[] subtract(int[] nArray, int n) throws Exception {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i] - n;
        }
        return nArray2;
    }

    public static double[][] matrixProduct(double[][] dArray, double[][] dArray2) throws Exception {
        if (dArray[0].length != dArray2.length) {
            throw new Exception("Number of columns of a " + dArray[0].length + " does not match the number of rows of b " + dArray2.length);
        }
        double[][] dArray3 = new double[dArray.length][dArray2[0].length];
        for (int i = 0; i < dArray3.length; ++i) {
            for (int j = 0; j < dArray3[i].length; ++j) {
                dArray3[i][j] = 0.0;
                for (int k = 0; k < dArray[i].length; ++k) {
                    double[] dArray4 = dArray3[i];
                    int n = j;
                    dArray4[n] = dArray4[n] + dArray[i][k] * dArray2[k][j];
                }
            }
        }
        return dArray3;
    }

    public static double[] matrixProduct(double[] dArray, double[][] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("Number of entries of v " + dArray.length + " does not match the number of rows of A " + dArray2.length);
        }
        double[] dArray3 = new double[dArray2[0].length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[j] * dArray2[j][i];
            }
        }
        return dArray3;
    }

    public static double[] matrixProduct(double[][] dArray, double[] dArray2) throws Exception {
        if (dArray2.length != dArray[0].length) {
            throw new Exception("Number of entries of v " + dArray2.length + " does not match the number of columns of A " + dArray[0].length);
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = 0.0;
            for (int j = 0; j < dArray2.length; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    public static double dotProduct(double[] dArray, double[] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception("Number of entries of v " + dArray.length + " does not match the number of entries of u " + dArray2.length);
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static int[][] duplicateMatrix(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = new int[nArray[i].length];
            System.arraycopy(nArray[i], 0, nArrayArray[i], 0, nArray[i].length);
        }
        return nArrayArray;
    }

    public static void arrayCopy(double[][] dArray, double[][] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            System.arraycopy(dArray[i], 0, dArray2[i], 0, dArray[i].length);
        }
    }

    public static double[][] arrayCopy(double[][] dArray) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = new double[dArray[i].length];
            System.arraycopy(dArray[i], 0, dArrayArray[i], 0, dArray[i].length);
        }
        return dArrayArray;
    }

    public static void arrayCopy(double[][] dArray, int n, int n2, double[][] dArray2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n5; ++i) {
            System.arraycopy(dArray[n + i], n2, dArray2[n3 + i], n4, n6);
        }
    }

    public static void arrayCopy(int[][] nArray, int[][] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            System.arraycopy(nArray[i], 0, nArray2[i], 0, nArray[i].length);
        }
    }

    public static void arrayCopy(int[][] nArray, int n, int n2, int[][] nArray2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < n5; ++i) {
            System.arraycopy(nArray[n + i], n2, nArray2[n3 + i], n4, n6);
        }
    }

    public static void copyIntoColumn(int[][] nArray, int n, int[] nArray2) throws Exception {
        if (nArray2.length != nArray.length) {
            throw new Exception("Destination column is not of the same length as the source (" + nArray.length + " vs " + nArray2.length + ")");
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i][n] = nArray2[i];
        }
    }

    public static void copyIntoColumn(double[][] dArray, int n, int n2, double[] dArray2, int n3, int n4) throws Exception {
        if (n3 + n4 > dArray2.length) {
            throw new Exception("Attempting to copy too many rows " + n4 + " after the start row " + n3 + " from the source of length " + dArray2.length);
        }
        if (n2 + n4 > dArray.length) {
            throw new Exception("Attempting to copy too many rows " + n4 + " after the start row " + n2 + " from the destination of length " + dArray.length);
        }
        for (int i = 0; i < n4; ++i) {
            dArray[i + n2][n] = dArray2[i + n3];
        }
    }

    public static void copyIntoColumn(int[][] nArray, int n, int n2, int[] nArray2, int n3, int n4) throws Exception {
        if (n3 + n4 > nArray2.length) {
            throw new Exception("Attempting to copy too many rows " + n4 + " after the start row " + n3 + " from the source of length " + nArray2.length);
        }
        if (n2 + n4 > nArray.length) {
            throw new Exception("Attempting to copy too many rows " + n4 + " after the start row " + n2 + " from the destination of length " + nArray.length);
        }
        for (int i = 0; i < n4; ++i) {
            nArray[i + n2][n] = nArray2[i + n3];
        }
    }

    public static void copyIntoColumn(double[][] dArray, int n, double[] dArray2) throws Exception {
        if (dArray2.length != dArray.length) {
            throw new Exception("Destination column is not of the same length as the source (" + dArray.length + " vs " + dArray2.length + ")");
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][n] = dArray2[i];
        }
    }

    public static void copyIntoColumn3D(int[][][] nArray, int n, int n2, int[] nArray2) throws Exception {
        if (nArray2.length != nArray.length) {
            throw new Exception("Destination column is not of the same length as the source (" + nArray.length + " vs " + nArray2.length + ")");
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i][n][n2] = nArray2[i];
        }
    }

    public static double[][] appendColumns(double[][] dArray, double[][] dArray2) throws Exception {
        double[][] dArrayArray = new double[dArray.length][];
        if (dArray.length != dArray2.length) {
            throw new Exception("matrix1 and matrix2 have different lengths");
        }
        if (dArray.length == 0) {
            return dArrayArray;
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = MatrixUtils.append(dArray[i], dArray2[i]);
        }
        return dArrayArray;
    }

    public static double[] append(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return dArray3;
    }

    public static int[] append(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    public static int[] computeCombinedValues(int[][] nArray, int n) throws Exception {
        int n2 = nArray[0].length;
        return MatrixUtils.computeCombinedValues(nArray, n2, n);
    }

    public static int[] computeCombinedValues(int[][] nArray, int n, int n2) throws Exception {
        if (n > nArray[0].length) {
            throw new Exception("computeCombinedValues: computation request across more columns " + n + " than are available " + nArray[0].length);
        }
        if (MatrixUtils.combinedValuesOverflow(n, n2)) {
            throw new Exception("Too many columns " + n + " for the given base " + n2 + " for this call to computeCombinedValues");
        }
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            int n5 = 1;
            for (int j = n - 1; j >= 0; --j) {
                n4 += nArray[i][j] * n5;
                n5 *= n2;
            }
            nArray2[i] = n4;
        }
        return nArray2;
    }

    public static long[] computeCombinedValuesLong(int[][] nArray, int n) throws Exception {
        int n2 = nArray[0].length;
        return MatrixUtils.computeCombinedValuesLong(nArray, n2, n);
    }

    public static long[] computeCombinedValuesLong(int[][] nArray, int n, int n2) throws Exception {
        if (n > nArray[0].length) {
            throw new Exception("computeCombinedValuesLong: computation request across more columns " + n + " than are available " + nArray[0].length);
        }
        if (MatrixUtils.combinedValuesOverflowLong(n, n2)) {
            throw new Exception("Too many columns " + n + " for the given base " + n2 + " for this call to computeCombinedValuesLong");
        }
        int n3 = nArray.length;
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            long l = 0L;
            long l2 = 1L;
            for (int j = n - 1; j >= 0; --j) {
                l += (long)nArray[i][j] * l2;
                l2 *= (long)n2;
            }
            lArray[i] = l;
        }
        return lArray;
    }

    public static boolean combinedValuesOverflow(int n, int n2) {
        int n3 = 1;
        for (int i = n - 1; i >= 0; --i) {
            if (n3 < 0) {
                return true;
            }
            n3 = (int)((long)n3 * (long)n2);
        }
        return false;
    }

    public static boolean combinedValuesOverflowLong(int n, int n2) {
        long l = 1L;
        for (int i = n - 1; i >= 0; --i) {
            if (l < 0L) {
                return true;
            }
            l *= (long)n2;
        }
        return false;
    }

    public static double[] select(double[] dArray, int n, int n2) {
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, n, dArray2, 0, n2);
        return dArray2;
    }

    public static double[] select(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray2[i] = dArray[nArray[i]];
        }
        return dArray2;
    }

    public static int[] select(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, n, nArray2, 0, n2);
        return nArray2;
    }

    public static int[] select(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    public static boolean[] selectColumn(boolean[][] blArray, int n) {
        boolean[] blArray2 = new boolean[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray2[i] = blArray[i][n];
        }
        return blArray2;
    }

    public static int[] selectColumn(int[][] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i][n];
        }
        return nArray2;
    }

    public static double[] selectColumn(double[][] dArray, int n) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i][n];
        }
        return dArray2;
    }

    public static double[] selectColumn(double[][] dArray, int n, int n2, int n3) {
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = dArray[n2 + i][n];
        }
        return dArray2;
    }

    public static int[] selectColumn(int[][] nArray, int n, int n2, int n3) {
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = nArray[n2 + i][n];
        }
        return nArray2;
    }

    public static byte[] selectColumn(byte[][] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = byArray[n2 + i][n];
        }
        return byArray2;
    }

    public static double[][] selectColumns(double[][] dArray, int n, int n2) {
        double[][] dArray2 = new double[dArray.length][n2];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[i][j + n];
            }
        }
        return dArray2;
    }

    public static double[][] selectColumns(double[][] dArray, int[] nArray) {
        double[][] dArray2 = new double[dArray.length][nArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                dArray2[i][j] = dArray[i][nArray[j]];
            }
        }
        return dArray2;
    }

    public static double[][] selectColumns(double[][] dArray, boolean[] blArray) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            vector.add(new Integer(i));
        }
        double[][] dArray2 = new double[dArray.length][vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                int n = (Integer)vector.get(j);
                dArray2[i][j] = dArray[i][n];
            }
        }
        return dArray2;
    }

    public static double[][] selectColumns(double[][] dArray, Vector<Integer> vector) {
        double[][] dArray2 = new double[dArray.length][vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                dArray2[i][j] = dArray[i][vector.elementAt(j)];
            }
        }
        return dArray2;
    }

    public static double[][] selectRows(double[][] dArray, int n, int n2) {
        double[][] dArrayArray = new double[n2][];
        for (int i = 0; i < n2; ++i) {
            dArrayArray[i] = dArray[i + n];
        }
        return dArrayArray;
    }

    public static double[][] selectRowsAndColumns(double[][] dArray, int[] nArray, int[] nArray2) {
        double[][] dArray2 = new double[nArray.length][nArray2.length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                dArray2[i][j] = dArray[nArray[i]][nArray2[j]];
            }
        }
        return dArray2;
    }

    public static double[][] selectRowsAndColumns(double[][] dArray, int n, int n2, int n3, int n4) {
        double[][] dArray2 = new double[n2][n4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4; ++j) {
                dArray2[i][j] = dArray[i + n][j + n3];
            }
        }
        return dArray2;
    }

    public static double[][] selectFirstTwoDimenions(double[][][][] dArray, int n, int n2) {
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            dArrayArray[i] = new double[dArray[i].length];
            for (int j = 0; j < dArray[i].length; ++j) {
                dArrayArray[i][j] = dArray[i][j][n][n2];
            }
        }
        return dArrayArray;
    }

    public static double[][] copyMatrixEliminateRowAndColumn(double[][] dArray, int n, int n2) {
        double[][] dArray2 = new double[dArray.length - 1][dArray[0].length - 1];
        for (int i = 0; i < dArray.length; ++i) {
            if (i == n) continue;
            for (int j = 0; j < dArray.length; ++j) {
                if (j == n2) continue;
                int n3 = i;
                int n4 = j;
                if (n3 > n) {
                    --n3;
                }
                if (n4 > n2) {
                    --n4;
                }
                dArray2[n3][n4] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static double[] extractSelectedTimePoints(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray2[i] = dArray[nArray[i]];
        }
        return dArray2;
    }

    public static int[] extractSelectedTimePoints(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    public static double[][] extractSelectedTimePoints(double[][] dArray, int[] nArray) {
        int n = dArray[0].length;
        double[][] dArray2 = new double[nArray.length][n];
        for (int i = 0; i < nArray.length; ++i) {
            System.arraycopy(dArray[nArray[i]], 0, dArray2[i], 0, n);
        }
        return dArray2;
    }

    public static double[][] extractSelectedTimePointsReusingArrays(double[][] dArray, int[] nArray) {
        double[][] dArrayArray = new double[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            dArrayArray[i] = dArray[nArray[i]];
        }
        return dArrayArray;
    }

    public static boolean[][] extractSelectedTimePointsReusingArrays(boolean[][] blArray, int[] nArray) {
        boolean[][] blArrayArray = new boolean[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            blArrayArray[i] = blArray[nArray[i]];
        }
        return blArrayArray;
    }

    public static double[][] extractSelectedTimePoints(double[][] dArray, int[][] nArray, int n) {
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[nArray.length][n2];
        for (int i = 0; i < nArray.length; ++i) {
            System.arraycopy(dArray[nArray[i][n]], 0, dArray2[i], 0, n2);
        }
        return dArray2;
    }

    public static double[][] extractSelectedTimePoints(double[][] dArray, int[][] nArray, int n, int n2) {
        int n3 = dArray[0].length;
        double[][] dArray2 = new double[nArray.length][n3];
        for (int i = 0; i < nArray.length; ++i) {
            System.arraycopy(dArray[nArray[i][n] + n2], 0, dArray2[i], 0, n3);
        }
        return dArray2;
    }

    public static double[][] extractSelectedPointsMatchingCondition(double[][] dArray, int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (nArray[i] != n) continue;
            ++n2;
        }
        return MatrixUtils.extractSelectedPointsMatchingCondition(dArray, nArray, n, n2);
    }

    public static double[][] extractSelectedPointsMatchingCondition(double[][] dArray, int[] nArray, int n, int n2) {
        int n3 = dArray[0].length;
        double[][] dArray2 = new double[n2][n3];
        int n4 = 0;
        if (n2 == 0) {
            return dArray2;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (nArray[i] == n) {
                System.arraycopy(dArray[i], 0, dArray2[n4++], 0, n3);
            }
            if (n4 == n2) break;
        }
        return dArray2;
    }

    public static void reorderVectorIntoMatrix(double[] dArray, int[] nArray, double[][] dArray2, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            dArray2[i][n] = dArray[n2];
        }
    }

    public static double[][] reorderDataForVariables(double[][] dArray, int[][] nArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        boolean bl = nArray.length == n2;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            dArray2[i][0] = bl ? dArray[nArray[n3++][i]][0] : dArray[i][0];
            for (int j = 1; j < n2; ++j) {
                dArray2[i][j] = dArray[nArray[n3++][i]][j];
            }
        }
        return dArray2;
    }

    public static double[][] reshape(double[] dArray, int n, int n2) {
        double[][] dArray2 = new double[n][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[n3++];
            }
        }
        return dArray2;
    }

    public static int[][] makeDelayEmbeddingVector(int[] nArray, int n) {
        try {
            return MatrixUtils.makeDelayEmbeddingVector(nArray, n, n - 1, nArray.length - n + 1);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static double[][] makeDelayEmbeddingVector(double[] dArray, int n) {
        try {
            return MatrixUtils.makeDelayEmbeddingVector(dArray, n, n - 1, dArray.length - n + 1);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static int[][] makeDelayEmbeddingVector(int[] nArray, int n, int n2, int n3) throws Exception {
        if (n2 < n - 1) {
            throw new Exception("Start point t=" + n2 + " is too early for a " + n + " length embedding vector");
        }
        if (n3 + n2 > nArray.length) {
            throw new Exception("Too many embedding vectors " + n3 + " requested for the given startPoint " + n2 + " and time series length " + nArray.length);
        }
        int[][] nArray2 = new int[n3][n];
        for (int i = n2; i < n3 + n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2[i - n2][j] = nArray[i - j];
            }
        }
        return nArray2;
    }

    public static double[][] makeDelayEmbeddingVector(double[] dArray, int n, int n2, int n3) throws Exception {
        if (n2 < n - 1) {
            throw new Exception("Start point t=" + n2 + " is too early for a " + n + " length embedding vector");
        }
        if (n3 + n2 > dArray.length) {
            throw new Exception("Too many embedding vectors " + n3 + " requested for the given startPoint " + n2 + " and time series length " + dArray.length);
        }
        double[][] dArray2 = new double[n3][n];
        for (int i = n2; i < n3 + n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i - n2][j] = dArray[i - j];
            }
        }
        return dArray2;
    }

    public static int[][] makeDelayEmbeddingVector(int[] nArray, int n, int n2, int n3, int n4) throws Exception {
        if (n3 < (n - 1) * n2) {
            throw new Exception("Start point t=" + n3 + " is too early for a " + n + " length embedding vector with delay " + n2);
        }
        if (n4 + n3 > nArray.length) {
            throw new Exception("Too many embedding vectors " + n4 + " requested for the given startPoint " + n3 + " and time series length " + nArray.length);
        }
        int[][] nArray2 = new int[n4][n];
        for (int i = n3; i < n4 + n3; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2[i - n3][j] = nArray[i - j * n2];
            }
        }
        return nArray2;
    }

    public static double[][] makeDelayEmbeddingVector(double[] dArray, int n, int n2, int n3, int n4) throws Exception {
        if (n3 < (n - 1) * n2) {
            throw new Exception("Start point t=" + n3 + " is too early for a " + n + " length embedding vector with delay " + n2);
        }
        if (n4 + n3 > dArray.length) {
            throw new Exception("Too many embedding vectors " + n4 + " requested for the given startPoint " + n3 + " and time series length " + dArray.length);
        }
        double[][] dArray2 = new double[n4][n];
        for (int i = n3; i < n4 + n3; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i - n3][j] = dArray[i - j * n2];
            }
        }
        return dArray2;
    }

    public static double[][] makeDelayEmbeddingVector(double[][] dArray, int n) {
        try {
            return MatrixUtils.makeDelayEmbeddingVector(dArray, n, n - 1, dArray.length - n + 1);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static double[][] makeDelayEmbeddingVector(double[][] dArray, int n, int n2, int n3) throws Exception {
        if (n2 < n - 1) {
            throw new Exception("Start point t=" + n2 + " is too early for a " + n + " length embedding vector");
        }
        if (n3 + n2 > dArray.length) {
            throw new Exception("Too many embedding vectors " + n3 + " requested for the given startPoint " + n2 + " and time series length " + dArray.length);
        }
        int n4 = dArray[0].length;
        double[][] dArray2 = new double[n3][n * n4];
        for (int i = n2; i < n3 + n2; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n4; ++k) {
                    dArray2[i - n2][j * n4 + k] = dArray[i - j][k];
                }
            }
        }
        return dArray2;
    }

    public static double[][] makeDelayEmbeddingVector(double[][] dArray, int n, int n2, int n3, int n4) throws Exception {
        if (n3 < (n - 1) * n2) {
            throw new Exception("Start point t=" + n3 + " is too early for a " + n + " length embedding vector with delay " + n2);
        }
        if (n4 + n3 > dArray.length) {
            throw new Exception("Too many embedding vectors " + n4 + " requested for the given startPoint " + n3 + " and time series length " + dArray.length);
        }
        int n5 = dArray[0].length;
        double[][] dArray2 = new double[n4][n * n5];
        for (int i = n3; i < n4 + n3; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n5; ++k) {
                    dArray2[i - n3][j * n5 + k] = dArray[i - j * n2][k];
                }
            }
        }
        return dArray2;
    }

    public static double[][] makeDelayEmbeddingVector(double[][] dArray, int n, int n2, int n3, int n4, int n5) throws Exception {
        if (n4 < (n2 - 1) * n3) {
            throw new Exception("Start point t=" + n4 + " is too early for a " + n2 + " length embedding vector with delay " + n3);
        }
        if (n5 + n4 > dArray.length) {
            throw new Exception("Too many embedding vectors " + n5 + " requested for the given startPoint " + n4 + " and time series length " + dArray.length);
        }
        double[][] dArray2 = new double[n5][n2];
        for (int i = n4; i < n5 + n4; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i - n4][j] = dArray[i - j * n3][n];
            }
        }
        return dArray2;
    }

    public static double stdDev(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i];
        }
        d = d2 / (double)dArray.length;
        return MatrixUtils.stdDev(dArray, d);
    }

    public static double stdDev(double[][] dArray, int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i][n];
        }
        d = d2 / (double)dArray.length;
        return MatrixUtils.stdDev(dArray, n, d);
    }

    public static double stdDev(double[] dArray, double d) {
        return MatrixUtils.stdDev(dArray, d, dArray.length);
    }

    public static double stdDev(double[] dArray, double d, int n) {
        if (n == 0) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += (dArray[i] - d) * (dArray[i] - d);
        }
        double d3 = d2 / (double)(n - 1);
        d3 = Math.sqrt(d3);
        return d3;
    }

    public static double stdDev(double[][] dArray, int n, double d) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += (dArray[i][n] - d) * (dArray[i][n] - d);
        }
        double d3 = d2 / (double)(dArray.length - 1);
        d3 = Math.sqrt(d3);
        return d3;
    }

    public static double stdDev(double[][] dArray) {
        double d = MatrixUtils.mean(dArray);
        return MatrixUtils.stdDev(dArray, d);
    }

    public static double stdDev(double[][] dArray, double d) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                d2 += (dArray[i][j] - d) * (dArray[i][j] - d);
            }
        }
        double d3 = d2 / (double)(dArray.length * dArray[0].length - 1);
        d3 = Math.sqrt(d3);
        return d3;
    }

    public static double[] stdDevs(double[][] dArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (n = 0; n < dArray[i].length; ++n) {
                int n2 = n;
                dArray3[n2] = dArray3[n2] + (dArray[i][n] - dArray2[n]) * (dArray[i][n] - dArray2[n]);
            }
        }
        double[] dArray4 = new double[dArray2.length];
        for (n = 0; n < dArray4.length; ++n) {
            dArray4[n] = dArray3[n] / (double)(dArray.length - 1);
            dArray4[n] = Math.sqrt(dArray4[n]);
        }
        return dArray4;
    }

    public static double[] stdDevsOfRows(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d = 0.0;
            for (int j = 0; j < dArray[i].length; ++j) {
                d += (dArray[i][j] - dArray2[i]) * (dArray[i][j] - dArray2[i]);
            }
            dArray3[i] = d / (double)(dArray[i].length - 1);
            dArray3[i] = Math.sqrt(dArray3[i]);
        }
        return dArray3;
    }

    public static double max(double[][][] dArray) {
        double d = dArray[0][0][0];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    if (!(dArray[i][j][k] > d)) continue;
                    d = dArray[i][j][k];
                }
            }
        }
        return d;
    }

    public static void normalise(double[] dArray) {
        double d = MatrixUtils.mean(dArray);
        double d2 = MatrixUtils.stdDev(dArray, d);
        if (Double.isInfinite(1.0 / d2)) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = dArray[i] - d;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (dArray[i] - d) / d2;
            }
        }
    }

    public static double[] normaliseIntoNewArray(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = MatrixUtils.mean(dArray);
        double d2 = MatrixUtils.stdDev(dArray, d);
        if (Double.isInfinite(1.0 / d2)) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = dArray[i] - d;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = (dArray[i] - d) / d2;
            }
        }
        return dArray2;
    }

    public static void normalise(double[][] dArray, int n) {
        double d = MatrixUtils.mean(dArray, n);
        double d2 = MatrixUtils.stdDev(dArray, n, d);
        if (Double.isInfinite(1.0 / d2)) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][n] = dArray[i][n] - d;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][n] = (dArray[i][n] - d) / d2;
            }
        }
    }

    public static double[] normaliseIntoNewArray(double[][] dArray, int n) {
        double[] dArray2 = new double[dArray.length];
        double d = MatrixUtils.mean(dArray, n);
        double d2 = MatrixUtils.stdDev(dArray, n, d);
        if (Double.isInfinite(1.0 / d2)) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = dArray[i][n] - d;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = (dArray[i][n] - d) / d2;
            }
        }
        return dArray2;
    }

    public static void normalise(double[][] dArray) {
        int n;
        double[] dArray2 = MatrixUtils.means(dArray);
        double[] dArray3 = MatrixUtils.stdDevs(dArray, dArray2);
        boolean[] blArray = new boolean[dArray3.length];
        for (n = 0; n < dArray[0].length; ++n) {
            blArray[n] = !Double.isInfinite(1.0 / dArray3[n]);
        }
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray[n].length; ++i) {
                dArray[n][i] = dArray[n][i] - dArray2[i];
                if (!blArray[i]) continue;
                double[] dArray4 = dArray[n];
                int n2 = i;
                dArray4[n2] = dArray4[n2] / dArray3[i];
            }
        }
    }

    public static void normalise(double[][] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray[i][j] = dArray[i][j] - dArray2[j];
                if (Double.isInfinite(1.0 / dArray3[j])) continue;
                double[] dArray4 = dArray[i];
                int n = j;
                dArray4[n] = dArray4[n] / dArray3[j];
            }
        }
    }

    public static double[][] normaliseIntoNewArray(double[][] dArray) {
        double[] dArray2 = MatrixUtils.means(dArray);
        double[] dArray3 = MatrixUtils.stdDevs(dArray, dArray2);
        return MatrixUtils.normaliseIntoNewArray(dArray, dArray2, dArray3);
    }

    public static double[][] normaliseIntoNewArray(double[][] dArray, double[] dArray2, double[] dArray3) {
        double[][] dArray4 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray4.length; ++i) {
            for (int j = 0; j < dArray4[i].length; ++j) {
                dArray4[i][j] = dArray[i][j] - dArray2[j];
                if (Double.isInfinite(1.0 / dArray3[j])) continue;
                double[] dArray5 = dArray4[i];
                int n = j;
                dArray5[n] = dArray5[n] / dArray3[j];
            }
        }
        return dArray4;
    }

    public static double max(double[][] dArray) {
        double d = dArray[0][0];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!Double.isNaN(d) && !(dArray[i][j] > d)) continue;
                d = dArray[i][j];
            }
        }
        return d;
    }

    public static int max(int[][] nArray) {
        int n = nArray[0][0];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                if (nArray[i][j] <= n) continue;
                n = nArray[i][j];
            }
        }
        return n;
    }

    public static double max(double[] dArray) {
        return MatrixUtils.maxStartFromIndex(dArray, 0);
    }

    public static double maxStartFromIndex(double[] dArray, int n) {
        double d = dArray[n];
        for (int i = n; i < dArray.length; ++i) {
            if (!Double.isNaN(d) && !(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static int maxIndex(double[] dArray) {
        double d = dArray[0];
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    public static int max(int[] nArray) {
        int n = nArray[0];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static double max(double[][] dArray, int n) {
        double d = dArray[0][n];
        for (int i = 1; i < dArray.length; ++i) {
            if (!Double.isNaN(d) && !(dArray[i][n] > d)) continue;
            d = dArray[i][n];
        }
        return d;
    }

    public static int max(int[][] nArray, int n) {
        int n2 = nArray[0][n];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i][n] <= n2) continue;
            n2 = nArray[i][n];
        }
        return n2;
    }

    public static double min(double[][] dArray) {
        double d = dArray[0][0];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!Double.isNaN(d) && !(dArray[i][j] < d)) continue;
                d = dArray[i][j];
            }
        }
        return d;
    }

    public static int min(int[][] nArray) {
        int n = nArray[0][0];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                if (nArray[i][j] >= n) continue;
                n = nArray[i][j];
            }
        }
        return n;
    }

    public static double min(double[] dArray) {
        return MatrixUtils.minStartFromIndex(dArray, 0);
    }

    public static double kthMin(double[] dArray, int n) throws Exception {
        int n2;
        if (n == 1) {
            return MatrixUtils.min(dArray);
        }
        if (dArray.length < n) {
            throw new Exception(String.format("Length of array (%d) is less than k (%d)", dArray.length, n));
        }
        double[] dArray2 = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = Double.POSITIVE_INFINITY;
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (!(dArray[n2] < dArray2[n - 1])) continue;
            dArray2[n - 1] = dArray[n2];
            for (int i = n - 2; i >= 0 && dArray[n2] < dArray2[i]; --i) {
                dArray2[i + 1] = dArray2[i];
                dArray2[i] = dArray[n2];
            }
        }
        return dArray2[n - 1];
    }

    public static double kthMinSubjectTo(double[] dArray, int n, int[] nArray, int n2) throws Exception {
        int n3;
        if (dArray.length < n) {
            throw new Exception(String.format("Length of array (%d) is less than k (%d)", dArray.length, n));
        }
        double[] dArray2 = new double[n];
        for (n3 = 0; n3 < n; ++n3) {
            dArray2[n3] = Double.POSITIVE_INFINITY;
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            if (nArray[n3] != n2 || !(dArray[n3] < dArray2[n - 1])) continue;
            dArray2[n - 1] = dArray[n3];
            for (int i = n - 2; i >= 0 && dArray[n3] < dArray2[i]; --i) {
                dArray2[i + 1] = dArray2[i];
                dArray2[i] = dArray[n3];
            }
        }
        return dArray2[n - 1];
    }

    public static double minIgnoreIndex(double[] dArray, int n) {
        double d = n != 0 ? dArray[0] : dArray[1];
        for (int i = 0; i < dArray.length; ++i) {
            if (n == i || !Double.isNaN(d) && !(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double minStartFromIndex(double[] dArray, int n) {
        double d = dArray[n];
        for (int i = n; i < dArray.length; ++i) {
            if (!Double.isNaN(d) && !(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static int min(int[] nArray) {
        int n = nArray[0];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static double min(double[][] dArray, int n) {
        double d = dArray[0][n];
        for (int i = 1; i < dArray.length; ++i) {
            if (!Double.isNaN(d) && !(dArray[i][n] < d)) continue;
            d = dArray[i][n];
        }
        return d;
    }

    public static int min(int[][] nArray, int n) {
        int n2 = nArray[0][n];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i][n] >= n2) continue;
            n2 = nArray[i][n];
        }
        return n2;
    }

    public static int minIndex(double[][] dArray, int n) {
        double d = dArray[0][n];
        int n2 = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!Double.isNaN(d) && !(dArray[i][n] < d)) continue;
            d = dArray[i][n];
            n2 = i;
        }
        return n2;
    }

    public static int[] kMinIndices(double[][] dArray, int n, int n2) throws Exception {
        int n3;
        if (dArray.length < n2) {
            throw new Exception(String.format("Length of array (%d) is less than k (%d)", dArray.length, n2));
        }
        double[] dArray2 = new double[n2];
        int[] nArray = new int[n2];
        if (n2 == 1) {
            nArray[0] = MatrixUtils.minIndex(dArray, n);
            return nArray;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            dArray2[n3] = Double.POSITIVE_INFINITY;
            nArray[n3] = -1;
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            if (!(dArray[n3][n] < dArray2[n2 - 1])) continue;
            dArray2[n2 - 1] = dArray[n3][n];
            nArray[n2 - 1] = n3;
            for (int i = n2 - 2; i >= 0 && dArray[n3][n] < dArray2[i]; --i) {
                dArray2[i + 1] = dArray2[i];
                nArray[i + 1] = nArray[i];
                dArray2[i] = dArray[n3][n];
                nArray[i] = n3;
            }
        }
        return nArray;
    }

    public static int[] kMinIndicesSubjectTo(double[][] dArray, int n, int n2, int[] nArray, int n3) throws Exception {
        int n4;
        if (dArray.length < n2) {
            throw new Exception(String.format("Length of array (%d) is less than k (%d)", dArray.length, n2));
        }
        double[] dArray2 = new double[n2];
        int[] nArray2 = new int[n2];
        for (n4 = 0; n4 < n2; ++n4) {
            dArray2[n4] = Double.POSITIVE_INFINITY;
            nArray2[n4] = -1;
        }
        for (n4 = 0; n4 < dArray.length; ++n4) {
            if (nArray[n4] != n3 || !(dArray[n4][n] < dArray2[n2 - 1])) continue;
            dArray2[n2 - 1] = dArray[n4][n];
            nArray2[n2 - 1] = n4;
            for (int i = n2 - 2; i >= 0 && dArray[n4][n] < dArray2[i]; --i) {
                dArray2[i + 1] = dArray2[i];
                nArray2[i + 1] = nArray2[i];
                dArray2[i] = dArray[n4][n];
                nArray2[i] = n4;
            }
        }
        return nArray2;
    }

    public static int[] sortIndices(double[] dArray) {
        MatrixUtils matrixUtils = new MatrixUtils();
        DoubleWithIndexForSort[] doubleWithIndexForSortArray = new DoubleWithIndexForSort[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            MatrixUtils matrixUtils2 = matrixUtils;
            matrixUtils2.getClass();
            doubleWithIndexForSortArray[i] = matrixUtils2.new DoubleWithIndexForSort(dArray[i], i);
        }
        MatrixUtils matrixUtils3 = matrixUtils;
        matrixUtils3.getClass();
        Arrays.sort(doubleWithIndexForSortArray, matrixUtils3.new DoubleWithIndexForSortComparator());
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = doubleWithIndexForSortArray[i].originalIndex;
        }
        return nArray;
    }

    public static int[][] mirrorMatrixBothCoords(int[][] nArray) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        int[][] nArray2 = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray2[n - 1 - i][n2 - 1 - j] = nArray[i][j];
            }
        }
        return nArray2;
    }

    public static double[][] mirrorMatrixBothCoords(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[n - 1 - i][n2 - 1 - j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static void moveRowsUp(double[][] dArray, int n) {
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        for (n3 = 0; n3 < n4 - n; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                dArray[n3][n2] = dArray[n3 + n][n2];
            }
        }
        for (n3 = n4 - n; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                dArray[n3][n2] = 0.0;
            }
        }
    }

    public static double covariance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = MatrixUtils.mean(dArray);
        double d3 = MatrixUtils.mean(dArray2);
        for (int i = 0; i < dArray.length; ++i) {
            d += (dArray[i] - d2) * (dArray2[i] - d3);
        }
        return d / (double)(dArray.length - 1);
    }

    public static double covariance(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length - n; ++i) {
            d += dArray[i];
            d2 += dArray2[i + n];
        }
        d /= (double)(dArray.length - n);
        d2 /= (double)(dArray.length - n);
        double d3 = 0.0;
        for (int i = 0; i < dArray.length - n; ++i) {
            d3 += (dArray[i] - d) * (dArray2[i + n] - d2);
        }
        return d3 / (double)(dArray.length - n - 1);
    }

    public static double covarianceFirstTwoColumns(double[][] dArray) {
        return MatrixUtils.covarianceTwoColumns(dArray, 0, 1);
    }

    public static double covarianceTwoColumns(double[][] dArray, int n, int n2) {
        double d = MatrixUtils.mean(dArray, n);
        double d2 = MatrixUtils.mean(dArray, n2);
        return MatrixUtils.covarianceTwoColumns(dArray, n, n2, d, d2);
    }

    public static double covarianceTwoColumns(double[][] dArray, int n, int n2, double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d3 += (dArray[i][n] - d) * (dArray[i][n2] - d2);
        }
        return d3 / (double)(dArray.length - 1);
    }

    public static double covarianceTwoColumns(double[][] dArray, double[][] dArray2, int n, int n2, double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d3 += (dArray[i][n] - d) * (dArray2[i][n2] - d2);
        }
        return d3 / (double)(dArray.length - 1);
    }

    public static double[][] covarianceMatrix(double[][] dArray) {
        return MatrixUtils.covarianceMatrix(dArray, MatrixUtils.means(dArray));
    }

    public static double[][] covarianceMatrix(double[][] dArray, double[] dArray2) {
        int n = dArray[0].length;
        double[][] dArray3 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                dArray3[i][j] = MatrixUtils.covarianceTwoColumns(dArray, i, j, dArray2[i], dArray2[j]);
                dArray3[j][i] = dArray3[i][j];
            }
        }
        return dArray3;
    }

    public static double[][] covarianceMatrix(double[][] dArray, double[][] dArray2) {
        return MatrixUtils.covarianceMatrix(dArray, dArray2, 0);
    }

    public static double[][] covarianceMatrix(double[][] object, double[][] object2, int n) {
        int n2;
        int n3;
        int n4;
        if (n > 0) {
            double[][] dArrayArray = new double[((double[][])object).length - n][];
            double[][] dArrayArray2 = new double[((double[][])object2).length - n][];
            for (n4 = 0; n4 < ((double[][])object).length - n; ++n4) {
                dArrayArray[n4] = object[n4];
                dArrayArray2[n4] = object2[n4 + n];
            }
            object = dArrayArray;
            object2 = dArrayArray2;
        }
        int n5 = object[0].length;
        int n6 = object2[0].length;
        n4 = n5 + n6;
        double[][] dArray = new double[n4][n4];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n6];
        for (n3 = 0; n3 < n5; ++n3) {
            dArray2[n3] = MatrixUtils.mean(object, n3);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            dArray3[n3] = MatrixUtils.mean(object2, n3);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = n3; n2 < n5; ++n2) {
                dArray[n3][n2] = MatrixUtils.covarianceTwoColumns(object, n3, n2, dArray2[n3], dArray2[n2]);
                dArray[n2][n3] = dArray[n3][n2];
            }
            for (n2 = 0; n2 < n6; ++n2) {
                dArray[n3][n5 + n2] = MatrixUtils.covarianceTwoColumns(object, object2, n3, n2, dArray2[n3], dArray3[n2]);
                dArray[n5 + n2][n3] = dArray[n3][n5 + n2];
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = n3; n2 < n6; ++n2) {
                dArray[n5 + n3][n5 + n2] = MatrixUtils.covarianceTwoColumns(object2, n3, n2, dArray3[n3], dArray3[n2]);
                dArray[n5 + n2][n5 + n3] = dArray[n5 + n3][n5 + n2];
            }
        }
        return dArray;
    }

    public static double[][] covarianceMatrix(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n;
        int n2;
        int n3 = dArray[0].length;
        int n4 = dArray2[0].length;
        int n5 = dArray3[0].length;
        int n6 = n3 + n4 + n5;
        double[][] dArray4 = new double[n6][n6];
        double[] dArray5 = new double[n3];
        double[] dArray6 = new double[n4];
        double[] dArray7 = new double[n5];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray5[n2] = MatrixUtils.mean(dArray, n2);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            dArray6[n2] = MatrixUtils.mean(dArray2, n2);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            dArray7[n2] = MatrixUtils.mean(dArray3, n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2; n < n3; ++n) {
                dArray4[n2][n] = MatrixUtils.covarianceTwoColumns(dArray, n2, n, dArray5[n2], dArray5[n]);
                dArray4[n][n2] = dArray4[n2][n];
            }
            for (n = 0; n < n4; ++n) {
                dArray4[n2][n3 + n] = MatrixUtils.covarianceTwoColumns(dArray, dArray2, n2, n, dArray5[n2], dArray6[n]);
                dArray4[n3 + n][n2] = dArray4[n2][n3 + n];
            }
            for (n = 0; n < n5; ++n) {
                dArray4[n2][n3 + n4 + n] = MatrixUtils.covarianceTwoColumns(dArray, dArray3, n2, n, dArray5[n2], dArray7[n]);
                dArray4[n3 + n4 + n][n2] = dArray4[n2][n3 + n4 + n];
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = n2; n < n4; ++n) {
                dArray4[n3 + n2][n3 + n] = MatrixUtils.covarianceTwoColumns(dArray2, n2, n, dArray6[n2], dArray6[n]);
                dArray4[n3 + n][n3 + n2] = dArray4[n3 + n2][n3 + n];
            }
            for (n = 0; n < n5; ++n) {
                dArray4[n3 + n2][n3 + n4 + n] = MatrixUtils.covarianceTwoColumns(dArray2, dArray3, n2, n, dArray6[n2], dArray7[n]);
                dArray4[n3 + n4 + n][n3 + n2] = dArray4[n3 + n2][n3 + n4 + n];
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = n2; n < n5; ++n) {
                dArray4[n3 + n4 + n2][n3 + n4 + n] = MatrixUtils.covarianceTwoColumns(dArray3, n2, n, dArray7[n2], dArray7[n]);
                dArray4[n3 + n4 + n][n3 + n4 + n2] = dArray4[n3 + n4 + n2][n3 + n4 + n];
            }
        }
        return dArray4;
    }

    public static double correlation(double[] dArray, double[] dArray2) {
        return MatrixUtils.correlation(dArray, dArray2, dArray.length);
    }

    public static double correlation(double[] dArray, double[] dArray2, int n) {
        double d = 0.0;
        double d2 = MatrixUtils.mean(dArray, 0, n);
        double d3 = MatrixUtils.mean(dArray2, 0, n);
        for (int i = 0; i < n; ++i) {
            d += (dArray[i] - d2) * (dArray2[i] - d3);
        }
        double d4 = d / (double)(n - 1);
        return d4 / MatrixUtils.stdDev(dArray, d2, n) / MatrixUtils.stdDev(dArray2, d3, n);
    }

    public static double correlationIgnoreNans(double[] dArray, double[] dArray2, int n) {
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (Double.isNaN(dArray[n2]) || Double.isNaN(dArray2[n2])) continue;
            d2 += dArray[n2];
            d3 += dArray2[n2];
            ++n3;
        }
        d2 /= (double)n3;
        d3 /= (double)n3;
        for (n2 = 0; n2 < n; ++n2) {
            if (Double.isNaN(dArray[n2]) || Double.isNaN(dArray2[n2])) continue;
            d += (dArray[n2] - d2) * (dArray2[n2] - d3);
        }
        double d4 = d / (double)(n3 - 1);
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isNaN(dArray2[i])) continue;
            d5 += (dArray[i] - d2) * (dArray[i] - d2);
            d6 += (dArray2[i] - d3) * (dArray2[i] - d3);
        }
        double d7 = d5 / (double)(n3 - 1);
        d7 = Math.sqrt(d7);
        double d8 = d6 / (double)(n3 - 1);
        d8 = Math.sqrt(d8);
        return d4 / d7 / d8;
    }

    public static void fill(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        for (int i = n2; i < n2 + n3; ++i) {
            nArray[i] = n;
        }
    }

    public static void fill(int[][] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i].length;
            for (int j = 0; j < n3; ++j) {
                nArray[i][j] = n;
            }
        }
    }

    public static void fill(int[][][] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i].length;
            for (int j = 0; j < n3; ++j) {
                int n4 = nArray[i][j].length;
                for (int k = 0; k < n4; ++k) {
                    nArray[i][j][k] = n;
                }
            }
        }
    }

    public static void fill(int[][][][] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i].length;
            for (int j = 0; j < n3; ++j) {
                int n4 = nArray[i][j].length;
                for (int k = 0; k < n4; ++k) {
                    int n5 = nArray[i][j][k].length;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        nArray[i][j][k][i2] = n;
                    }
                }
            }
        }
    }

    public static void fill(long[] lArray, long l) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            lArray[i] = l;
        }
    }

    public static void fill(long[][] lArray, long l) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = lArray[i].length;
            for (int j = 0; j < n2; ++j) {
                lArray[i][j] = l;
            }
        }
    }

    public static void fill(long[][][] lArray, long l) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = lArray[i].length;
            for (int j = 0; j < n2; ++j) {
                int n3 = lArray[i][j].length;
                for (int k = 0; k < n3; ++k) {
                    lArray[i][j][k] = l;
                }
            }
        }
    }

    public static void fill(long[][][][] lArray, long l) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = lArray[i].length;
            for (int j = 0; j < n2; ++j) {
                int n3 = lArray[i][j].length;
                for (int k = 0; k < n3; ++k) {
                    int n4 = lArray[i][j][k].length;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        lArray[i][j][k][i2] = l;
                    }
                }
            }
        }
    }

    public static double[][] transpose(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray2[j][i] = dArray[i][j];
            }
        }
        return dArray2;
    }

    public static int[][] transpose(int[][] nArray) {
        int[][] nArray2 = new int[nArray[0].length][nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                nArray2[j][i] = nArray[i][j];
            }
        }
        return nArray2;
    }

    public static double[][] convertMatrix(int[][] nArray) {
        double[][] dArrayArray = new double[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            dArrayArray[i] = new double[nArray[i].length];
            for (int j = 0; j < nArray[i].length; ++j) {
                dArrayArray[i][j] = nArray[i][j];
            }
        }
        return dArrayArray;
    }

    public static int[] convertMatrix(double[] dArray, int n) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)dArray[i] - n;
        }
        return nArray;
    }

    public static int[] convertMatrix(double[] dArray) {
        return MatrixUtils.convertMatrix(dArray, 0);
    }

    public static double determinant(double[][] dArray) throws Exception {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            if (dArray[i].length == n) continue;
            throw new Exception("Cannot compute the determinant of a non-square matrix");
        }
        return MatrixUtils.recursiveDeterminant(dArray);
    }

    private static double recursiveDeterminant(double[][] dArray) {
        int n = dArray.length;
        double d = 0.0;
        if (n == 1) {
            return dArray[0][0];
        }
        if (n == 2) {
            return dArray[0][0] * dArray[1][1] - dArray[0][1] * dArray[1][0];
        }
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            double[][] dArray2 = MatrixUtils.copyMatrixEliminateRowAndColumn(dArray, 0, i);
            d += (double)n2 * dArray[0][i] * MatrixUtils.recursiveDeterminant(dArray2);
            n2 *= -1;
        }
        return d;
    }

    public static double[][] CholeskyDecomposition(double[][] dArray) throws Exception {
        int n = dArray.length;
        double[][] dArray2 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            int n2;
            if (dArray[i].length != n) {
                throw new Exception("CholeskyDecomposition is only performed on square matrices");
            }
            double d = 0.0;
            for (n2 = 0; n2 < i; ++n2) {
                double d2 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d2 += dArray2[n2][j] * dArray2[i][j];
                }
                dArray2[i][n2] = d2 = (dArray[i][n2] - d2) / dArray2[n2][n2];
                d += d2 * d2;
                if (dArray[n2][i] == dArray[i][n2]) continue;
                throw new Exception("CholeskyDecomposition is only performed on symmetric matrices");
            }
            if ((d = dArray[i][i] - d) <= 0.0) {
                throw new NonPositiveDefiniteMatrixException("CholeskyDecomposition is only performed on positive-definite matrices. Some reasons for non-positive-definite matrix are listed at http://www2.gsu.edu/~mkteer/npdmatri.html - note: a correlation matrix is non-positive-definite if you have more variables than observations");
            }
            dArray2[i][i] = Math.sqrt(d);
            for (n2 = i + 1; n2 < n; ++n2) {
                dArray2[i][n2] = 0.0;
            }
        }
        return dArray2;
    }

    public static double[][] invertSymmPosDefMatrix(double[][] dArray) throws Exception {
        double[][] dArray2 = MatrixUtils.CholeskyDecomposition(dArray);
        return MatrixUtils.solveViaCholeskyResult(dArray2, MatrixUtils.identityMatrix(dArray.length));
    }

    public static double[][] solveViaCholeskyResult(double[][] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3;
        int n4 = dArray.length;
        if (n4 != dArray2.length) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        double[][] dArray3 = MatrixUtils.arrayCopy(dArray2);
        int n5 = dArray2[0].length;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 0;
            while (n2 < n5) {
                for (n = 0; n < n3; ++n) {
                    double[] dArray4 = dArray3[n3];
                    int n6 = n2;
                    dArray4[n6] = dArray4[n6] - dArray3[n][n2] * dArray[n3][n];
                }
                double[] dArray5 = dArray3[n3];
                int n7 = n2++;
                dArray5[n7] = dArray5[n7] / dArray[n3][n3];
            }
        }
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            n2 = 0;
            while (n2 < n5) {
                for (n = n3 + 1; n < n4; ++n) {
                    double[] dArray6 = dArray3[n3];
                    int n8 = n2;
                    dArray6[n8] = dArray6[n8] - dArray3[n][n2] * dArray[n][n3];
                }
                double[] dArray7 = dArray3[n3];
                int n9 = n2++;
                dArray7[n9] = dArray7[n9] / dArray[n3][n3];
            }
        }
        return dArray3;
    }

    public static double determinantSymmPosDefMatrix(double[][] dArray) throws Exception {
        double[][] dArray2 = MatrixUtils.CholeskyDecomposition(dArray);
        return MatrixUtils.determinantViaCholeskyResult(dArray2);
    }

    public static double determinantViaCholeskyResult(double[][] dArray) {
        double d = 1.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            d *= dArray[i][i];
        }
        return d * d;
    }

    public static void printMatrix(PrintStream printStream, double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                printStream.print(dArray[i][j] + " ");
            }
            printStream.println();
        }
    }

    public static void printMatrix(PrintStream printStream, int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                printStream.print(nArray[i][j] + " ");
            }
            printStream.println();
        }
    }

    public static void printArray(PrintStream printStream, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            printStream.print(dArray[i] + " ");
        }
    }

    public static void printArray(PrintStream printStream, double[] dArray, int n) {
        for (int i = 0; i < dArray.length; ++i) {
            printStream.printf(String.format("%%.%df ", n), dArray[i]);
        }
    }

    public static String arrayToString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(dArray[i] + ",");
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public static void printArray(PrintStream printStream, int n, double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            printStream.printf(String.format("%%.%df ", n), dArray[i]);
        }
        printStream.println();
    }

    public static void printArray(PrintStream printStream, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            printStream.print(nArray[i] + " ");
        }
        printStream.println();
    }

    public static int[] discretise(double[] dArray, int n) {
        int[] nArray = new int[dArray.length];
        double d = MatrixUtils.min(dArray);
        double d2 = MatrixUtils.max(dArray);
        double d3 = (d2 - d) / (double)n;
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)((dArray[i] - d) / d3);
            if (nArray[i] != n) continue;
            int n2 = i;
            nArray[n2] = nArray[n2] - 1;
        }
        return nArray;
    }

    public static int[] discretiseMaxEntropy(double[] dArray, int n) {
        int n2;
        int[] nArray = new int[dArray.length];
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        Arrays.sort(dArray2);
        double[] dArray3 = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = (int)((double)(n2 + 1) * (double)dArray.length / (double)n) - 1;
            dArray3[n2] = dArray2[n3];
        }
        block1: for (n2 = 0; n2 < dArray.length; ++n2) {
            for (int i = 0; i < n; ++i) {
                if (!(dArray[n2] <= dArray3[i])) continue;
                nArray[n2] = i;
                continue block1;
            }
        }
        return nArray;
    }

    public static int[][] discretiseMaxEntropy(double[][] dArray, int n) {
        int n2 = dArray[0].length;
        int n3 = dArray.length;
        int[][] nArray = new int[n3][n2];
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            double[] dArray2 = new double[n3];
            for (n5 = 0; n5 < n3; ++n5) {
                dArray2[n5] = dArray[n5][i];
            }
            Arrays.sort(dArray2);
            double[] dArray3 = new double[n];
            for (n4 = 0; n4 < n; ++n4) {
                n5 = (int)((double)(n4 + 1) * (double)n3 / (double)n) - 1;
                dArray3[n4] = dArray2[n5];
            }
            for (n4 = 0; n4 < n3; ++n4) {
                for (int j = 0; j < n; ++j) {
                    if (!(dArray[n4][i] <= dArray3[j])) continue;
                    nArray[n4][i] = j;
                    j = n;
                }
            }
        }
        return nArray;
    }

    public static boolean[] andRows(boolean[][] blArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray2[i] = true;
            for (int j = 0; j < blArray[i].length; ++j) {
                int n = i;
                blArray2[n] = blArray2[n] & blArray[i][j];
            }
        }
        return blArray2;
    }

    public static boolean[] andRowsOverSelectedColumns(boolean[][] blArray, int[] nArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray2[i] = true;
            for (int j = 0; j < nArray.length; ++j) {
                int n = i;
                blArray2[n] = blArray2[n] & blArray[i][nArray[j]];
            }
        }
        return blArray2;
    }

    public static double[][] doubleTo2DArray(double[] dArray) {
        double[][] dArray2 = new double[dArray.length][1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][0] = dArray[i];
        }
        return dArray2;
    }

    public static int[] doubleToIntArray(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)dArray[i];
        }
        return nArray;
    }

    public static int[][] doubleToIntArray(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        int[][] nArrayArray = new int[dArray.length][];
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == null) {
                nArrayArray[i] = null;
                continue;
            }
            nArrayArray[i] = new int[dArray[i].length];
            for (int j = 0; j < dArray[i].length; ++j) {
                nArrayArray[i][j] = (int)dArray[i][j];
            }
        }
        return nArrayArray;
    }

    private class DoubleWithIndexForSortComparator
    implements Comparator<DoubleWithIndexForSort> {
        private DoubleWithIndexForSortComparator() {
        }

        @Override
        public int compare(DoubleWithIndexForSort doubleWithIndexForSort, DoubleWithIndexForSort doubleWithIndexForSort2) {
            if (doubleWithIndexForSort.value < doubleWithIndexForSort2.value) {
                return -1;
            }
            if (doubleWithIndexForSort.value > doubleWithIndexForSort2.value) {
                return 1;
            }
            return 0;
        }
    }

    private class DoubleWithIndexForSort {
        double value;
        int originalIndex;

        public DoubleWithIndexForSort(double d, int n) {
            this.value = d;
            this.originalIndex = n;
        }
    }
}

