from versions.constants import (
    A_LITERAL,
    ALPHA,
    B_LITERAL,
    BETA,
    C_LITERAL,
    CANDIDATE,
    DEV,
    POST,
    PRE,
    PREVIEW,
    R_LITERAL,
    RC,
    REV,
)

__all__ = (
    # constants
    "PHASE_ALPHA",
    "PHASE_ALPHA_SHORT",
    "PHASE_BETA",
    "PHASE_BETA_SHORT",
    "PHASE_CANDIDATE",
    "PHASE_CANDIDATE_SHORT",
    "PHASE_RC",
    "PHASE_RC_SHORT",
    "PHASE_PREVIEW",
    "PHASE_PREVIEW_SHORT",
    "PHASE_POST",
    "PHASE_POST_SHORT",
    "PHASE_REV",
    "PHASE_REV_SHORT",
    "PHASE_DEV",
    "PHASE_DEV_SHORT",
    # defaults
    "PHASE_ALL_DEFAULT",
    "PHASE_PRE_DEFAULT",
    "PHASE_POST_DEFAULT",
    "PHASE_DEV_DEFAULT",
    # sets
    "PHASE_ALL_SET",
    "PHASE_PRE_SET",
    "PHASE_POST_SET",
    "PHASE_DEV_SET",
    # mappings
    "PHASE_TO_SHORT",
    "SHORT_TO_PHASE",
    "PHASE_TO_NEXT",
    "PHASE_TO_NORMAL",
)

PHASE_ALPHA = ALPHA
PHASE_ALPHA_SHORT = A_LITERAL

PHASE_BETA = BETA
PHASE_BETA_SHORT = B_LITERAL

PHASE_CANDIDATE = CANDIDATE
PHASE_CANDIDATE_SHORT = C_LITERAL

PHASE_RC = RC
PHASE_RC_SHORT = RC

PHASE_PREVIEW = PREVIEW
PHASE_PREVIEW_SHORT = PRE

PHASE_POST = POST
PHASE_POST_SHORT = POST

PHASE_REV = REV
PHASE_REV_SHORT = R_LITERAL

PHASE_DEV = DEV
PHASE_DEV_SHORT = DEV

PHASE_PRE_DEFAULT = PHASE_ALPHA

PHASE_PRE_SET = {
    PHASE_ALPHA,
    PHASE_ALPHA_SHORT,
    PHASE_BETA,
    PHASE_BETA_SHORT,
    PHASE_CANDIDATE,
    PHASE_CANDIDATE_SHORT,
    PHASE_RC,
    PHASE_RC_SHORT,
    PHASE_PREVIEW,
    PHASE_PREVIEW_SHORT,
}

PHASE_POST_DEFAULT = PHASE_POST

PHASE_POST_SET = {
    PHASE_POST,
    PHASE_POST_SHORT,
    PHASE_REV,
    PHASE_REV_SHORT,
}

PHASE_DEV_DEFAULT = PHASE_DEV

PHASE_DEV_SET = {
    PHASE_DEV,
    PHASE_DEV_SHORT,
}

PHASE_ALL_DEFAULT = PHASE_PRE_DEFAULT

PHASE_ALL_SET = PHASE_PRE_SET | PHASE_POST_SET | PHASE_DEV_SET

PHASE_TO_SHORT = {
    PHASE_ALPHA: PHASE_ALPHA_SHORT,
    PHASE_BETA: PHASE_BETA_SHORT,
    PHASE_CANDIDATE: PHASE_CANDIDATE_SHORT,
    PHASE_RC: PHASE_RC_SHORT,
    PHASE_PREVIEW: PHASE_PREVIEW_SHORT,
    PHASE_POST: PHASE_POST_SHORT,
    PHASE_REV: PHASE_REV_SHORT,
    PHASE_DEV: PHASE_DEV_SHORT,
}

SHORT_TO_PHASE = {short: phase for phase, short in PHASE_TO_SHORT.items()}

PHASE_TO_NEXT = {
    PHASE_ALPHA: PHASE_BETA,
    PHASE_ALPHA_SHORT: PHASE_BETA_SHORT,
    PHASE_BETA: PHASE_RC,
    PHASE_BETA_SHORT: PHASE_RC_SHORT,
}

PHASE_TO_NORMAL = {
    PHASE_CANDIDATE: PHASE_RC,
    PHASE_CANDIDATE_SHORT: PHASE_RC_SHORT,
    PHASE_PREVIEW: PHASE_RC,
    PHASE_PREVIEW_SHORT: PHASE_RC_SHORT,
    PHASE_REV: PHASE_POST,
    PHASE_REV_SHORT: PHASE_POST_SHORT,
}
