from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingCore

class vtkDGRenderResponder(object):
    class ScalarVisualizationOverrideType(int):
        L2_NORM_R_S:'ScalarVisualizationOverrideType'
        L2_NORM_S_T:'ScalarVisualizationOverrideType'
        L2_NORM_T_R:'ScalarVisualizationOverrideType'
        NONE:'ScalarVisualizationOverrideType'
        R:'ScalarVisualizationOverrideType'
        S:'ScalarVisualizationOverrideType'
        T:'ScalarVisualizationOverrideType'
    scalar_visualization_override_type:'getset_descriptor'
    visualize_tessellation:'getset_descriptor'
    def AddMod(self, className:str) -> None: ...
    def AddMods(self, classNames:Sequence[str]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGRenderResponder': ...
    def Query(self, request:'vtkCellGridRenderRequest', metadata:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    def RemoveAllMods(self) -> None: ...
    def RemoveMod(self, className:str) -> None: ...
    def ResetModsToDefault(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGRenderResponder': ...
    @staticmethod
    def SetScalarVisualizationOverrideType(type:'ScalarVisualizationOverrideType') -> None: ...
    @staticmethod
    def SetVisualizeTessellation(value:bool) -> None: ...

class vtkOpenGLCellGridMapper(vtkmodules.vtkRenderingCore.vtkCellGridMapper):
    supports_selection:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSupportsSelection(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLCellGridMapper': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLCellGridMapper': ...
    def ShallowCopy(self, m:'vtkAbstractMapper') -> None: ...

class vtkRenderingCellGrid(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderingCellGrid': ...
    @staticmethod
    def RegisterCellsAndResponders() -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderingCellGrid': ...

