from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingVolume

class vtkMultiBlockUnstructuredGridVolumeMapper(vtkmodules.vtkRenderingVolume.vtkUnstructuredGridVolumeMapper):
    array_access_mode:'getset_descriptor'
    blend_mode:'getset_descriptor'
    bounds:'getset_descriptor'
    scalar_mode:'getset_descriptor'
    use_floating_point_frame_buffer:'getset_descriptor'
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseFloatingPointFrameBuffer(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiBlockUnstructuredGridVolumeMapper': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', vol:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiBlockUnstructuredGridVolumeMapper': ...
    @overload
    def SelectScalarArray(self, arrayNum:int) -> None: ...
    @overload
    def SelectScalarArray(self, arrayName:str) -> None: ...
    def SetArrayAccessMode(self, accessMode:int) -> None: ...
    def SetBlendMode(self, mode:int) -> None: ...
    def SetScalarMode(self, ScalarMode:int) -> None: ...
    def SetUseFloatingPointFrameBuffer(self, use:bool) -> None: ...

class vtkMultiBlockVolumeMapper(vtkmodules.vtkRenderingVolume.vtkVolumeMapper):
    array_access_mode:'getset_descriptor'
    blend_mode:'getset_descriptor'
    bounds:'getset_descriptor'
    compute_normal_from_opacity:'getset_descriptor'
    cropping:'getset_descriptor'
    cropping_region_flags:'getset_descriptor'
    cropping_region_planes:'getset_descriptor'
    global_illumination_reach:'getset_descriptor'
    requested_render_mode:'getset_descriptor'
    scalar_mode:'getset_descriptor'
    transfer2dy_axis_array:'getset_descriptor'
    vector_component:'getset_descriptor'
    vector_mode:'getset_descriptor'
    volumetric_scattering_blending:'getset_descriptor'
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetGlobalIlluminationReach(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVectorComponent(self) -> int: ...
    def GetVectorMode(self) -> int: ...
    def GetVolumetricScatteringBlending(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMultiBlockVolumeMapper': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', vol:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiBlockVolumeMapper': ...
    @overload
    def SelectScalarArray(self, arrayNum:int) -> None: ...
    @overload
    def SelectScalarArray(self, arrayName:str) -> None: ...
    def SetArrayAccessMode(self, accessMode:int) -> None: ...
    def SetBlendMode(self, mode:int) -> None: ...
    def SetComputeNormalFromOpacity(self, val:bool) -> None: ...
    def SetCropping(self, mode:int) -> None: ...
    def SetCroppingRegionFlags(self, mode:int) -> None: ...
    @overload
    def SetCroppingRegionPlanes(self, arg1:float, arg2:float, arg3:float, arg4:float, arg5:float, arg6:float) -> None: ...
    @overload
    def SetCroppingRegionPlanes(self, planes:Sequence[float]) -> None: ...
    def SetGlobalIlluminationReach(self, val:float) -> None: ...
    def SetRequestedRenderMode(self, __a:int) -> None: ...
    def SetScalarMode(self, ScalarMode:int) -> None: ...
    def SetTransfer2DYAxisArray(self, a:str) -> None: ...
    def SetVectorComponent(self, component:int) -> None: ...
    def SetVectorMode(self, mode:int) -> None: ...
    def SetVolumetricScatteringBlending(self, val:float) -> None: ...

class vtkOpenGLGPUVolumeRayCastMapper(vtkmodules.vtkRenderingVolume.vtkGPUVolumeRayCastMapper):
    class Passes(int): ...
    DepthPass:'Passes'
    RenderPass:'Passes'
    color_texture:'getset_descriptor'
    current_pass:'getset_descriptor'
    depth_texture:'getset_descriptor'
    partitions:'getset_descriptor'
    shared_depth_texture:'getset_descriptor'
    def GetColorImage(self, im:'vtkImageData') -> None: ...
    def GetColorTexture(self) -> 'vtkTextureObject': ...
    def GetCurrentPass(self) -> int: ...
    def GetDepthImage(self, im:'vtkImageData') -> None: ...
    def GetDepthTexture(self) -> 'vtkTextureObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLGPUVolumeRayCastMapper': ...
    def PreLoadData(self, ren:'vtkRenderer', vol:'vtkVolume') -> bool: ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLGPUVolumeRayCastMapper': ...
    def SetPartitions(self, x:int, y:int, z:int) -> None: ...
    def SetSharedDepthTexture(self, nt:'vtkTextureObject') -> None: ...

class vtkOpenGLProjectedTetrahedraMapper(vtkmodules.vtkRenderingVolume.vtkProjectedTetrahedraMapper):
    use_floating_point_frame_buffer:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseFloatingPointFrameBuffer(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsSupported(self, context:'vtkRenderWindow') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLProjectedTetrahedraMapper': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def Render(self, renderer:'vtkRenderer', volume:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLProjectedTetrahedraMapper': ...
    def SetUseFloatingPointFrameBuffer(self, _arg:bool) -> None: ...
    def UseFloatingPointFrameBufferOff(self) -> None: ...
    def UseFloatingPointFrameBufferOn(self) -> None: ...

class vtkOpenGLRayCastImageDisplayHelper(vtkmodules.vtkRenderingVolume.vtkRayCastImageDisplayHelper):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLRayCastImageDisplayHelper': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    @overload
    def RenderTexture(self, vol:'vtkVolume', ren:'vtkRenderer', imageMemorySize:MutableSequence[int], imageViewportSize:MutableSequence[int], imageInUseSize:MutableSequence[int], imageOrigin:MutableSequence[int], requestedDepth:float, image:MutableSequence[int]) -> None: ...
    @overload
    def RenderTexture(self, vol:'vtkVolume', ren:'vtkRenderer', image:'vtkFixedPointRayCastImage', requestedDepth:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLRayCastImageDisplayHelper': ...

class vtkSmartVolumeMapper(vtkmodules.vtkRenderingVolume.vtkVolumeMapper):
    class VectorModeType(int): ...
    class LowResModeType(int): ...
    AnariRenderMode:int
    COMPONENT:'VectorModeType'
    DISABLED:'VectorModeType'
    DefaultRenderMode:int
    GPURenderMode:int
    InvalidRenderMode:int
    LowResModeDisabled:'LowResModeType'
    LowResModeResample:'LowResModeType'
    MAGNITUDE:'VectorModeType'
    OSPRayRenderMode:int
    RayCastRenderMode:int
    UndefinedRenderMode:int
    auto_adjust_sample_distances:'getset_descriptor'
    final_color_level:'getset_descriptor'
    final_color_window:'getset_descriptor'
    global_illumination_reach:'getset_descriptor'
    interactive_adjust_sample_distances:'getset_descriptor'
    interactive_update_rate:'getset_descriptor'
    interpolation_mode:'getset_descriptor'
    last_used_render_mode:'getset_descriptor'
    low_res_mode:'getset_descriptor'
    max_memory_fraction:'getset_descriptor'
    max_memory_in_bytes:'getset_descriptor'
    requested_render_mode:'getset_descriptor'
    sample_distance:'getset_descriptor'
    transfer2dy_axis_array:'getset_descriptor'
    use_jittering:'getset_descriptor'
    vector_component:'getset_descriptor'
    vector_mode:'getset_descriptor'
    volumetric_scattering_blending:'getset_descriptor'
    def AutoAdjustSampleDistancesOff(self) -> None: ...
    def AutoAdjustSampleDistancesOn(self) -> None: ...
    def CreateCanonicalView(self, ren:'vtkRenderer', volume:'vtkVolume', volume2:'vtkVolume', image:'vtkImageData', blend_mode:int, viewDirection:MutableSequence[float], viewUp:MutableSequence[float]) -> None: ...
    def GetAutoAdjustSampleDistances(self) -> int: ...
    def GetAutoAdjustSampleDistancesMaxValue(self) -> int: ...
    def GetAutoAdjustSampleDistancesMinValue(self) -> int: ...
    def GetFinalColorLevel(self) -> float: ...
    def GetFinalColorWindow(self) -> float: ...
    def GetGlobalIlluminationReach(self) -> float: ...
    def GetGlobalIlluminationReachMaxValue(self) -> float: ...
    def GetGlobalIlluminationReachMinValue(self) -> float: ...
    def GetInteractiveAdjustSampleDistances(self) -> int: ...
    def GetInteractiveAdjustSampleDistancesMaxValue(self) -> int: ...
    def GetInteractiveAdjustSampleDistancesMinValue(self) -> int: ...
    def GetInteractiveUpdateRate(self) -> float: ...
    def GetInteractiveUpdateRateMaxValue(self) -> float: ...
    def GetInteractiveUpdateRateMinValue(self) -> float: ...
    def GetInterpolationMode(self) -> int: ...
    def GetInterpolationModeMaxValue(self) -> int: ...
    def GetInterpolationModeMinValue(self) -> int: ...
    def GetLastUsedRenderMode(self) -> int: ...
    def GetLowResMode(self) -> int: ...
    def GetMaxMemoryFraction(self) -> float: ...
    def GetMaxMemoryFractionMaxValue(self) -> float: ...
    def GetMaxMemoryFractionMinValue(self) -> float: ...
    def GetMaxMemoryInBytes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRequestedRenderMode(self) -> int: ...
    def GetSampleDistance(self) -> float: ...
    def GetTransfer2DYAxisArray(self) -> str: ...
    def GetUseJittering(self) -> int: ...
    def GetUseJitteringMaxValue(self) -> int: ...
    def GetUseJitteringMinValue(self) -> int: ...
    def GetVectorComponent(self) -> int: ...
    def GetVectorComponentMaxValue(self) -> int: ...
    def GetVectorComponentMinValue(self) -> int: ...
    def GetVectorMode(self) -> int: ...
    def GetVolumetricScatteringBlending(self) -> float: ...
    def GetVolumetricScatteringBlendingMaxValue(self) -> float: ...
    def GetVolumetricScatteringBlendingMinValue(self) -> float: ...
    def InteractiveAdjustSampleDistancesOff(self) -> None: ...
    def InteractiveAdjustSampleDistancesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSmartVolumeMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSmartVolumeMapper': ...
    def SetAutoAdjustSampleDistances(self, _arg:int) -> None: ...
    def SetFinalColorLevel(self, _arg:float) -> None: ...
    def SetFinalColorWindow(self, _arg:float) -> None: ...
    def SetGlobalIlluminationReach(self, _arg:float) -> None: ...
    def SetInteractiveAdjustSampleDistances(self, _arg:int) -> None: ...
    def SetInteractiveUpdateRate(self, _arg:float) -> None: ...
    def SetInterpolationMode(self, _arg:int) -> None: ...
    def SetInterpolationModeToCubic(self) -> None: ...
    def SetInterpolationModeToLinear(self) -> None: ...
    def SetInterpolationModeToNearestNeighbor(self) -> None: ...
    def SetLowResMode(self, _arg:int) -> None: ...
    def SetMaxMemoryFraction(self, _arg:float) -> None: ...
    def SetMaxMemoryInBytes(self, _arg:int) -> None: ...
    def SetRequestedRenderMode(self, mode:int) -> None: ...
    def SetRequestedRenderModeToAnari(self) -> None: ...
    def SetRequestedRenderModeToDefault(self) -> None: ...
    def SetRequestedRenderModeToGPU(self) -> None: ...
    def SetRequestedRenderModeToOSPRay(self) -> None: ...
    def SetRequestedRenderModeToRayCast(self) -> None: ...
    def SetSampleDistance(self, _arg:float) -> None: ...
    def SetTransfer2DYAxisArray(self, _arg:str) -> None: ...
    def SetUseJittering(self, _arg:int) -> None: ...
    def SetVectorComponent(self, _arg:int) -> None: ...
    def SetVectorMode(self, mode:int) -> None: ...
    def SetVolumetricScatteringBlending(self, _arg:float) -> None: ...
    def UseJitteringOff(self) -> None: ...
    def UseJitteringOn(self) -> None: ...

class vtkVolumeTexture(vtkmodules.vtkCommonCore.vtkObject):
    loaded_scalars:'getset_descriptor'
    partitions:'getset_descriptor'
    def GetLoadedScalars(self) -> 'vtkDataArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPartitions(self) -> 'vtkTuple_IiLi3EE': ...
    @staticmethod
    def GetScaleAndBias(scalarType:int, scalarRange:MutableSequence[float], scale:float, bias:float) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LoadVolume(self, ren:'vtkRenderer', data:'vtkDataSet', scalars:'vtkDataArray', isCell:int, interpolation:int) -> bool: ...
    def NewInstance(self) -> 'vtkVolumeTexture': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeTexture': ...
    def SetPartitions(self, x:int, y:int, z:int) -> None: ...
    def SortBlocksBackToFront(self, ren:'vtkRenderer', volumeMat:'vtkMatrix4x4') -> None: ...
    def UpdateVolume(self, property:'vtkVolumeProperty') -> None: ...

