from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingSceneGraph

class vtkVtkJSSceneGraphSerializer(vtkmodules.vtkCommonCore.vtkObject):
    number_of_data_arrays:'getset_descriptor'
    number_of_data_objects:'getset_descriptor'
    @overload
    def Add(self, __a:'vtkViewNode', __b:'vtkActor') -> None: ...
    @overload
    def Add(self, __a:'vtkViewNode', __b:'vtkCompositePolyDataMapper') -> None: ...
    @overload
    def Add(self, __a:'vtkViewNode', __b:'vtkGlyph3DMapper') -> None: ...
    @overload
    def Add(self, __a:'vtkViewNode', __b:'vtkMapper') -> None: ...
    @overload
    def Add(self, __a:'vtkViewNode', __b:'vtkRenderer') -> None: ...
    @overload
    def Add(self, __a:'vtkViewNode', __b:'vtkRenderWindow') -> None: ...
    def GetDataArray(self, __a:int) -> 'vtkDataArray': ...
    def GetDataArrayId(self, __a:int) -> str: ...
    def GetDataObject(self, __a:int) -> 'vtkDataObject': ...
    def GetNumberOfDataArrays(self) -> int: ...
    def GetNumberOfDataObjects(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVtkJSSceneGraphSerializer': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVtkJSSceneGraphSerializer': ...

class vtkVtkJSViewNodeFactory(vtkmodules.vtkRenderingSceneGraph.vtkViewNodeFactory):
    serializer:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSerializer(self) -> 'vtkVtkJSSceneGraphSerializer': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVtkJSViewNodeFactory': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVtkJSViewNodeFactory': ...
    def SetSerializer(self, __a:'vtkVtkJSSceneGraphSerializer') -> None: ...

