commands_dict = {
    "GUI.up": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "GUI Cursor Up",
        "note": "None"
    },
    "GUI.down": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "GUI Cursor Down",
        "note": "None"
    },
    "GUI.left": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "GUI Cursor Left",
        "note": "None"
    },
    "GUI.right": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "GUI Cursor Right",
        "note": "None"
    },
    "GUI.home": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "GUI Home Screen Toggle",
        "note": "None"
    },
    "GUI.enter": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "GUI Select operation",
        "note": "None"
    },
    "GUI.return": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "GUI Return operation",
        "note": "None"
    },
    "GUI.display": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "GUI Display toggle",
        "note": "None"
    },
    "GUI.optionmenu": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "GUI Option menu",
        "note": "None"
    },
    "GUI.ampmenu": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Activate AMP Menu ",
        "note": "None"
    },
    "main.power": {
        "format": "String",
        "string_value": " \"on\", \"off\", \"toggle\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Main Zone Power",
        "note": "None"
    },
    "main.input": {
        "format": "String",
        "string_value": "{{INPUTSOURCE_VARIABLES}}",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Main Zone Input",
        "note": "None"
    },
    "main.mute": {
        "format": "String",
        "string_value": " \"on\", \"off\", \"toggle\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Main Zone Mute",
        "note": "None"
    },
    "main.volume+": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Main Zone Volume Increase",
        "note": "Pulse command: Volume can be incrementally pulsed up or down stepwise for all 3 zones using the respective \u201cvolume+\u201d and \u201cvolume-\u201c features for these zones.      Currently, rate limiting of pulse commands is not supported."
    },
    "main.volume-": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Main Zone Volume Decrease",
        "note": "Pulse command: Volume can be incrementally pulsed up or down stepwise for all 3 zones using the respective \u201cvolume+\u201d and \u201cvolume-\u201c features for these zones.      Currently, rate limiting of pulse commands is not supported."
    },
    "main.volumedb": {
        "format": "Number",
        "string_value": "None",
        "min_number": -92.0,
        "max_number": 23.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Main Zone Volume Relative",
        "note": "Depending on the \u201csystem.volumedisplay\u201d setting of \u201cstep\u201d or \u201ddb\u201d, the volume settings can be set, get or notified only using the corresponding volume commands for that setting.      For instance if the \u201csystem.volumedisplay\u201d setting is at \u201cstep\u201d, volumestep/presetvolumestep comands will function normally, whereas volumedb/presetvolumedb commands will return NAK. Notifications dispatched from the AV Receiver will be in volumestep or volumedb according to  \u201csystem.volumedisplay\u201d setting. The AV receiver dispatches notifications for any changes to \u201csystem.volumedisplay\u201d, so that controllers can keep in sync with this setting, and send appropriate commands. Moreover, the controller can query the \u201csystem.volumedisplay\u201d state at any time using a GET command."
    },
    "main.volumestep": {
        "format": "Number",
        "string_value": "None",
        "min_number": 0.0,
        "max_number": 100.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Main Zone Volume Absolute",
        "note": "Depending on the \u201csystem.volumedisplay\u201d setting of \u201cstep\u201d or \u201ddb\u201d, the volume settings can be set, get or notified only using the corresponding volume commands for that setting.      For instance if the \u201csystem.volumedisplay\u201d setting is at \u201cstep\u201d, volumestep/presetvolumestep comands will function normally, whereas volumedb/presetvolumedb commands will return NAK. Notifications dispatched from the AV Receiver will be in volumestep or volumedb according to  \u201csystem.volumedisplay\u201d setting. The AV receiver dispatches notifications for any changes to \u201csystem.volumedisplay\u201d, so that controllers can keep in sync with this setting, and send appropriate commands. Moreover, the controller can query the \u201csystem.volumedisplay\u201d state at any time using a GET command."
    },
    "main.presetvoldb": {
        "format": "String/Number",
        "string_value": "\"off\"",
        "min_number": -92.0,
        "max_number": 23.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Main Zone Preset Volume Relative",
        "note": "\"off\" accepted as well"
    },
    "main.presetvolstep": {
        "format": "String/Number",
        "string_value": "\"off\"",
        "min_number": 0.0,
        "max_number": 100.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Main Zone Preset Volume Absolute",
        "note": "\"off\" accepted as well"
    },
    "zone2.power": {
        "format": "String",
        "string_value": " \"on\", \"off\", \"toggle\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Power",
        "note": "None"
    },
    "zone2.input": {
        "format": "String",
        "string_value": "{{INPUTSOURCE_VARIABLES}}",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Input",
        "note": "None"
    },
    "zone2.mute": {
        "format": "String",
        "string_value": " \"on\", \"off\", \"toggle\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Mute",
        "note": "None"
    },
    "zone2.volume+": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Volume Increase",
        "note": "Pulse command: Volume can be incrementally pulsed up or down stepwise for all 3 zones using the respective \u201cvolume+\u201d and \u201cvolume-\u201c features for these zones.      Currently, rate limiting of pulse commands is not supported."
    },
    "zone2.volume-": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Volume Decrease",
        "note": "Pulse command: Volume can be incrementally pulsed up or down stepwise for all 3 zones using the respective \u201cvolume+\u201d and \u201cvolume-\u201c features for these zones.      Currently, rate limiting of pulse commands is not supported."
    },
    "zone2.volumedb": {
        "format": "Number",
        "string_value": "None",
        "min_number": -92.0,
        "max_number": 23.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Volume Relative",
        "note": "Depending on the \u201csystem.volumedisplay\u201d setting of \u201cstep\u201d or \u201ddb\u201d, the volume settings can be set, get or notified only using the corresponding volume commands for that setting.      For instance if the \u201csystem.volumedisplay\u201d setting is at \u201cstep\u201d, volumestep/presetvolumestep comands will function normally, whereas volumedb/presetvolumedb commands will return NAK. Notifications dispatched from the AV Receiver will be in volumestep or volumedb according to  \u201csystem.volumedisplay\u201d setting. The AV receiver dispatches notifications for any changes to \u201csystem.volumedisplay\u201d, so that controllers can keep in sync with this setting, and send appropriate commands. Moreover, the controller can query the \u201csystem.volumedisplay\u201d state at any time using a GET command."
    },
    "zone2.volumestep": {
        "format": "Number",
        "string_value": "None",
        "min_number": 0.0,
        "max_number": 100.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Volume Absolute",
        "note": "Depending on the \u201csystem.volumedisplay\u201d setting of \u201cstep\u201d or \u201ddb\u201d, the volume settings can be set, get or notified only using the corresponding volume commands for that setting.      For instance if the \u201csystem.volumedisplay\u201d setting is at \u201cstep\u201d, volumestep/presetvolumestep comands will function normally, whereas volumedb/presetvolumedb commands will return NAK. Notifications dispatched from the AV Receiver will be in volumestep or volumedb according to  \u201csystem.volumedisplay\u201d setting. The AV receiver dispatches notifications for any changes to \u201csystem.volumedisplay\u201d, so that controllers can keep in sync with this setting, and send appropriate commands. Moreover, the controller can query the \u201csystem.volumedisplay\u201d state at any time using a GET command."
    },
    "zone2.presetvoldb": {
        "format": "String/Number",
        "string_value": "\"off\"",
        "min_number": -92.0,
        "max_number": 23.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Preset Volume Relative",
        "note": "\"off\" accepted as well"
    },
    "zone2.presetvolstep": {
        "format": "String/Number",
        "string_value": "\"off\"",
        "min_number": 0.0,
        "max_number": 100.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Preset Volume Absolute",
        "note": "\"off\" accepted as well"
    },
    "zone2.lineout": {
        "format": "String",
        "string_value": "\"variable\", \"fixed\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Line Out",
        "note": "None"
    },
    "zone3.power": {
        "format": "String",
        "string_value": " \"on\", \"off\", \"toggle\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Power",
        "note": "None"
    },
    "zone3.input": {
        "format": "String",
        "string_value": "{{INPUTSOURCE_VARIABLES}}",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Input",
        "note": "None"
    },
    "zone3.mute": {
        "format": "String",
        "string_value": " \"on\", \"off\", \"toggle\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Mute",
        "note": "None"
    },
    "zone3.volume+": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Volume Increase",
        "note": "Pulse command: Volume can be incrementally pulsed up or down stepwise for all 3 zones using the respective \u201cvolume+\u201d and \u201cvolume-\u201c features for these zones.      Currently, rate limiting of pulse commands is not supported."
    },
    "zone3.volume-": {
        "format": "String",
        "string_value": "\"pulse\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Volume Decrease",
        "note": "Pulse command: Volume can be incrementally pulsed up or down stepwise for all 3 zones using the respective \u201cvolume+\u201d and \u201cvolume-\u201c features for these zones.      Currently, rate limiting of pulse commands is not supported."
    },
    "zone3.volumedb": {
        "format": "Number",
        "string_value": "None",
        "min_number": -92.0,
        "max_number": 23.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Volume Relative",
        "note": "Depending on the \u201csystem.volumedisplay\u201d setting of \u201cstep\u201d or \u201ddb\u201d, the volume settings can be set, get or notified only using the corresponding volume commands for that setting.      For instance if the \u201csystem.volumedisplay\u201d setting is at \u201cstep\u201d, volumestep/presetvolumestep comands will function normally, whereas volumedb/presetvolumedb commands will return NAK. Notifications dispatched from the AV Receiver will be in volumestep or volumedb according to  \u201csystem.volumedisplay\u201d setting. The AV receiver dispatches notifications for any changes to \u201csystem.volumedisplay\u201d, so that controllers can keep in sync with this setting, and send appropriate commands. Moreover, the controller can query the \u201csystem.volumedisplay\u201d state at any time using a GET command."
    },
    "zone3.volumestep": {
        "format": "Number",
        "string_value": "None",
        "min_number": 0.0,
        "max_number": 100.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Zone Volume Absolute",
        "note": "Depending on the \u201csystem.volumedisplay\u201d setting of \u201cstep\u201d or \u201ddb\u201d, the volume settings can be set, get or notified only using the corresponding volume commands for that setting.      For instance if the \u201csystem.volumedisplay\u201d setting is at \u201cstep\u201d, volumestep/presetvolumestep comands will function normally, whereas volumedb/presetvolumedb commands will return NAK. Notifications dispatched from the AV Receiver will be in volumestep or volumedb according to  \u201csystem.volumedisplay\u201d setting. The AV receiver dispatches notifications for any changes to \u201csystem.volumedisplay\u201d, so that controllers can keep in sync with this setting, and send appropriate commands. Moreover, the controller can query the \u201csystem.volumedisplay\u201d state at any time using a GET command."
    },
    "zone3.presetvoldb": {
        "format": "String/Number",
        "string_value": "\"off\"",
        "min_number": -92.0,
        "max_number": 23.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Preset Volume Relative",
        "note": "\"off\" accepted as well"
    },
    "zone3.presetvolstep": {
        "format": "String/Number",
        "string_value": "\"off\"",
        "min_number": 0.0,
        "max_number": 100.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Preset Volume Absolute",
        "note": "\"off\" accepted as well"
    },
    "zone3.lineout": {
        "format": "String",
        "string_value": "\"variable\", \"fixed\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone Line Out",
        "note": "None"
    },
    "distance.FL": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front Left Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.FR": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front Right Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.CR": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Center Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.SL": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Left Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.SR": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Right Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.SB": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Back Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.SBL": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Back Left Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.SBR": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Back Right Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.FHL": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front High Left Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.FHR": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front High Right Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "distance.SW": {
        "format": "Number",
        "string_value": "None",
        "min_number": 10000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "SubWoofer Distance",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "level.FL": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front Left Level",
        "note": "None"
    },
    "level.FR": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front Right Level",
        "note": "None"
    },
    "level.CR": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Center Level",
        "note": "None"
    },
    "level.SL": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Left Level",
        "note": "None"
    },
    "level.SR": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Right Level",
        "note": "None"
    },
    "level.SB": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Back Level",
        "note": "None"
    },
    "level.SBL": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Back Left Level",
        "note": "None"
    },
    "level.SBR": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Back Right Level",
        "note": "None"
    },
    "level.FHL": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front High Left Level",
        "note": "None"
    },
    "level.FHR": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front High Right Level",
        "note": "None"
    },
    "level.SW": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 0.5,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "SubWoofer Level",
        "note": "None"
    },
    "size.front": {
        "format": "String",
        "string_value": " \"small\" , \"large\" ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front Speaker Size",
        "note": "None"
    },
    "size.center": {
        "format": "String",
        "string_value": " \"small\" , \"large\" ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Center Speaker Size",
        "note": "None"
    },
    "size.surround": {
        "format": "String",
        "string_value": " \"small\" , \"large\" ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Speaker Size",
        "note": "None"
    },
    "size.fronthigh": {
        "format": "String",
        "string_value": " \"small\" , \"large\" ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front High Speaker Size",
        "note": "None"
    },
    "crossover.front": {
        "format": "Number",
        "string_value": "None",
        "min_number": 40.0,
        "max_number": 200.0,
        "step": 10.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front Speaker crossover frequency",
        "note": "None"
    },
    "crossover.center": {
        "format": "Number",
        "string_value": "None",
        "min_number": 40.0,
        "max_number": 200.0,
        "step": 10.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Center Speaker crossover frequency",
        "note": "None"
    },
    "crossover.surround": {
        "format": "Number",
        "string_value": "None",
        "min_number": 40.0,
        "max_number": 200.0,
        "step": 10.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Speaker crossover frequency",
        "note": "None"
    },
    "crossover.fronthigh": {
        "format": "Number",
        "string_value": "None",
        "min_number": 40.0,
        "max_number": 200.0,
        "step": 10.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front High Speaker crossover frequency",
        "note": "None"
    },
    "speaker.out": {
        "format": "String",
        "string_value": "\"A\", \"B\", \"AB\", \"Off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Speaker Out Select",
        "note": "None"
    },
    "speaker.autocal": {
        "format": "String",
        "string_value": "\"start\", \"stop\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Auto Calibration",
        "note": "None"
    },
    "speaker.apm": {
        "format": "String",
        "string_value": "\"auto\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Automatic Phase Matching",
        "note": "None"
    },
    "speaker.calibrationtype": {
        "format": "String",
        "string_value": "\"off\", \"frontref\", \"engineer\", \"fullflat\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Calibration Type",
        "note": "None"
    },
    "speaker.pattern": {
        "format": "String",
        "string_value": "\"X.X.X\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Speaker Pattern",
        "note": "e.g. 3.0.0, 5.1.2, 5.1.0"
    },
    "speaker.surrassign": {
        "format": "String",
        "string_value": "\"zone3\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Suround Speaker output Assign",
        "note": "None"
    },
    "speaker.SBassign\u3000": {
        "format": "String",
        "string_value": "\"zone2\", \"amp\", \"front\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Surround Back Speaker output Assign",
        "note": "None"
    },
    "speaker.distanceunit": {
        "format": "String",
        "string_value": "\"feet\", \"meter\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Distance Unit",
        "note": "None"
    },
    "speaker.centerliftup": {
        "format": "Number",
        "string_value": "None",
        "min_number": 0.0,
        "max_number": 10.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Center Speaker Lift Up",
        "note": "( 0 = Off)"
    },
    "speaker.ceilingheight": {
        "format": "Number",
        "string_value": "None",
        "min_number": 20000.0,
        "max_number": 100000.0,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Ceiling Height",
        "note": "100 unit = 1 cm, 254 units = 1inch"
    },
    "speaker.testtone": {
        "format": "String",
        "string_value": "\"off\", \"auto\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Speaker Test Tone",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.icon": {
        "format": "String",
        "string_value": "{{ICON_VARIABLES}}",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Icon linked with this Input",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.inputname": {
        "format": "String",
        "string_value": "*",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Custom name for this Input",
        "note": "User Input Value"
    },
    "{{INPUTCONFIG_VARIABLES}}.category": {
        "format": "String",
        "string_value": " \"watch\", \"listen\", \"watch_listen\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Watch/Listen Category for this Input",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.show": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Show this Input?",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.hdmiassign": {
        "format": "String",
        "string_value": " \"in1\", \"in2\", \"in3\", \"in4\", \"in5\", \"in6\", \"none\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "HDMI In Assign",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.digitalassign": {
        "format": "String",
        "string_value": "\"coax\", \"opt1\", \"opt2\", \"none\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Digital Audio In Assign",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.componentassign": {
        "format": "String",
        "string_value": "\"in1\", \"in2\", \"none\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Component Video In Assign",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.compositeassign": {
        "format": "String",
        "string_value": "\"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Composite In Assign",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.inputmode": {
        "format": "String",
        "string_value": "\"auto\", \"coax\", \"opt\", \"analog\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Input Mode",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.avsync": {
        "format": "String/Number",
        "string_value": "\"hdmi\"",
        "min_number": 0.0,
        "max_number": 300.0,
        "step": 10.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "AV Sync",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.soundfield": {
        "format": "String",
        "string_value": "{{SOUNDFIELD_VARIABLES}}",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Preset Sound Field assigned to Input",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.inceilingmode": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "In-Ceiling Speaker Mode",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.swlevel": {
        "format": "String",
        "string_value": "\"auto\", \"0\", \"10\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Subwoofer Level",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.swlpf": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Subwoofer Low Pass Filter",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.usetrigger1": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Use Trigger1 for this input?",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.usetrigger2": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Use Trigger2 for this input?",
        "note": "None"
    },
    "{{INPUTCONFIG_VARIABLES}}.usetrigger3": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Use Trigger3 for this input?",
        "note": "None"
    },
    "bass.front": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front Speaker Bass",
        "note": "None"
    },
    "bass.center": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Center Speaker Bass",
        "note": "None"
    },
    "bass.surround": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Sur/SB Speaker Bass",
        "note": "None"
    },
    "bass.fronthigh": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front High Speaker Bass",
        "note": "None"
    },
    "treble.front": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front Speaker Treble",
        "note": "None"
    },
    "treble.center": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Center Speaker Treble",
        "note": "None"
    },
    "treble.surround": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Sur/SB Speaker Treble",
        "note": "None"
    },
    "treble.fronthigh": {
        "format": "Number",
        "string_value": "None",
        "min_number": -10.0,
        "max_number": 10.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front High Speaker Treble",
        "note": "None"
    },
    "network.macaddress": {
        "format": "String",
        "string_value": "\"X:X:X:X:X:X\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "N",
        "get": "Y",
        "notify": "N",
        "description": "Mac Address (Wired/Wireless)",
        "note": "X=hex octet"
    },
    "network.dhcp": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "DHCP (Enable / Disable)",
        "note": "None"
    },
    "network.ipaddress": {
        "format": "String",
        "string_value": "\"X.X.X.X\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "IP Address",
        "note": "X=decimal octet, no leading zeroes required"
    },
    "network.subnetmask": {
        "format": "String",
        "string_value": "\"X.X.X.X\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Subnet Mask",
        "note": "X=decimal octet, no leading zeroes required"
    },
    "network.gateway": {
        "format": "String",
        "string_value": "\"X.X.X.X\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Gateway",
        "note": "X=decimal octet, no leading zeroes required"
    },
    "network.dns1": {
        "format": "String",
        "string_value": "\"X.X.X.X\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Primary DNS",
        "note": "X=decimal octet, no leading zeroes required"
    },
    "network.dns2": {
        "format": "String",
        "string_value": "\"X.X.X.X\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Secondary DNS",
        "note": "X=decimal octet, no leading zeroes required"
    },
    "network.standby": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Network Standby/ Quick Start",
        "note": "None"
    },
    "hdmi.out": {
        "format": "String",
        "string_value": "\"A\", \"B\", \"AB\", \"Off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "HDMI output select",
        "note": "None"
    },
    "hdmi.out2": {
        "format": "String",
        "string_value": "\"main\", \"zone2\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "2nd HDMI Output Zone Select",
        "note": "None"
    },
    "hdmi.4kscaling": {
        "format": "String",
        "string_value": " \"auto\",  \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "4K Scaling",
        "note": "None"
    },
    "hdmi.cec": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Control for HDMI",
        "note": "None"
    },
    "hdmi.passthrough": {
        "format": "String",
        "string_value": " \"on\", \"off\", \"auto\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Pass Through",
        "note": "None"
    },
    "hdmi.audioout": {
        "format": "String",
        "string_value": "\"amp\", \"tvamp\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Audio Out",
        "note": "None"
    },
    "hdmi.swlevel": {
        "format": "String",
        "string_value": "\"auto\", \"0\", \"10\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Subwoofer Level",
        "note": "None"
    },
    "hdmi.zone2audioout": {
        "format": "String",
        "string_value": " \"amp\", \"zone2tv\", \"zone2amp\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone2 Audio Out",
        "note": "None"
    },
    "hdmi.zonepriority": {
        "format": "String",
        "string_value": "\"main\", \"zone2main\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "HDMI Zone Priority",
        "note": "None"
    },
    "hdmi.fastview": {
        "format": "String",
        "string_value": "\"auto\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Fast View",
        "note": "None"
    },
    "audio.dll": {
        "format": "String",
        "string_value": " \"auto1\", \"auto2\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Digital Legato Linear",
        "note": "None"
    },
    "audio.soundoptimizer": {
        "format": "String",
        "string_value": "\"off\", \"normal\", \"low\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Sound Optimizer",
        "note": "None"
    },
    "audio.soundfield": {
        "format": "String",
        "string_value": "{{SOUNDFIELD_VARIABLES}}, \"+\", \"-\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Current Soundfield Select",
        "note": "None"
    },
    "audio.hddcstype": {
        "format": "String",
        "string_value": "\"studio\", \"theater\", \"dynamic\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "HD-DCS Effect Type",
        "note": "None"
    },
    "audio.inceilingmode": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "In-Ceiling Speaker Mode",
        "note": "None"
    },
    "audio.puredirect": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Pure Direct",
        "note": "None"
    },
    "audio.dualmono": {
        "format": "String",
        "string_value": " \"main\", \"sub\", \"main_sub\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Dual Mono",
        "note": "None"
    },
    "audio.drangecomp": {
        "format": "String",
        "string_value": " \"auto\", \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Dynamic Range Compressor",
        "note": "None"
    },
    "tuner.band": {
        "format": "String",
        "string_value": "\"am\",\"fm\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Band",
        "note": "None"
    },
    "tuner.tuning": {
        "format": "String",
        "string_value": "\"step+\", \"step-\", \"scan+\", \"scan-\", \"stop\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Tuner Frequency",
        "note": "None"
    },
    "tuner.frequency": {
        "format": "Number",
        "string_value": "None",
        "min_number": 530.0,
        "max_number": 1080.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Tuner Frequency Direct",
        "note": "FM width: (x0.1MHz)/875 - 1080, AM width: (x1KHz)/530 - 1710  "
    },
    "tuner.fmmode": {
        "format": "String",
        "string_value": "\"stereo\", \"mono\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "FM Mode\u3000",
        "note": "None"
    },
    "tuner.stepsize": {
        "format": "String",
        "string_value": "\"9k\", \"10k\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "AM 9k / 10k",
        "note": "None"
    },
    "tuner.preset": {
        "format": "Number",
        "string_value": "None",
        "min_number": 0.0,
        "max_number": 30.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Tuner Preset Select",
        "note": "0 = No Preset"
    },
    "AMpreset{{AM_VARIABLES}}.name": {
        "format": "String",
        "string_value": "*",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Tuner Preset Name\u3000",
        "note": "User Set String (8 Character Max)"
    },
    "AMpreset{{AM_VARIABLES}}.frequency": {
        "format": "Number",
        "string_value": "None",
        "min_number": 530.0,
        "max_number": 1710.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "AM Frequency of preset",
        "note": "(x1KHz)"
    },
    "AMpreset{{AM_VARIABLES}}.soundfield": {
        "format": "String",
        "string_value": "{{SOUNDFIELD_VARIABLES}}",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Preset Soundfield",
        "note": "None"
    },
    "FMpreset{{FM_VARIABLES}}.name": {
        "format": "String",
        "string_value": "*",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Tuner Preset Name\u3000",
        "note": "User Set String (8 Character Max)"
    },
    "FMpreset{{FM_VARIABLES}}.frequency": {
        "format": "Number",
        "string_value": "None",
        "min_number": 875.0,
        "max_number": 1080.0,
        "step": 1.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "FM Frequency of preset",
        "note": "(x0.1MHz)"
    },
    "FMpreset{{FM_VARIABLES}}.soundfield": {
        "format": "String",
        "string_value": "{{SOUNDFIELD_VARIABLES}}",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "FM Mode\u3000",
        "note": "None"
    },
    "FMpreset{{FM_VARIABLES}}.fmmode": {
        "format": "String",
        "string_value": "\"stereo\", \"mono\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Preset Soundfield",
        "note": "None"
    },
    "system.modeltype": {
        "format": "String",
        "string_value": " \"Z0\", \"Z1\", \"Z3\", \"DN1060\", \"DN860\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "N",
        "get": "Y",
        "notify": "N",
        "description": "Model Type",
        "note": "None"
    },
    "system.sleep": {
        "format": "Number",
        "string_value": "None",
        "min_number": 30.0,
        "max_number": 120.0,
        "step": 30.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Sleep",
        "note": "120 Max"
    },
    "system.externalcontrol": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "External Control",
        "note": "None"
    },
    "system.volumedisplay": {
        "format": "String",
        "string_value": "\"db\", \"step\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "Y",
        "description": "Volume Display (Absolute or Relative)",
        "note": "None"
    },
    "system.autodisplay": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Auto Display",
        "note": "None"
    },
    "system.testpicture": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Test Picture",
        "note": "None"
    },
    "system.settingslock": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Settings Lock",
        "note": "None"
    },
    "system.language": {
        "format": "String",
        "string_value": "\"english\", \"spanish\", \"french\", \"german\", \"japanese\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "OSD language",
        "note": "None"
    },
    "system.version": {
        "format": "String",
        "string_value": " X.XXX ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "System Firmware Version",
        "note": "None"
    },
    "system.dimmer": {
        "format": "Number",
        "string_value": "None",
        "min_number": 0.0,
        "max_number": 100.0,
        "step": 60.0,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Front Display Dimmer Percentage",
        "note": "None"
    },
    "system.factoryreset": {
        "format": "String",
        "string_value": "\"\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Factory Reset",
        "note": "Value Is Ignored"
    },
    "system.SFreset": {
        "format": "String",
        "string_value": "\"\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Sound Field Initialize",
        "note": "Value Is Ignored"
    },
    "system.sircsmode": {
        "format": "String",
        "string_value": "\"av1\", \"av2\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "SIRCS mode",
        "note": "None"
    },
    "system.autoStandby": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Auto Standby",
        "note": "None"
    },
    "system.quickstart": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Quick Start Mode",
        "note": "None"
    },
    "system.remotestart": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Remote Start Mode",
        "note": "None"
    },
    "custompreset1\n.import": {
        "format": "String",
        "string_value": " \"\"   ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Capture current settings.",
        "note": "Value Is Ignored"
    },
    "custompreset1\n.select": {
        "format": "String",
        "string_value": " \"\"   ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Select this scene.",
        "note": "Value Is Ignored"
    },
    "custompreset2.import": {
        "format": "String",
        "string_value": " \"\"   ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Capture current settings.",
        "note": "Value Is Ignored"
    },
    "custompreset2.select": {
        "format": "String",
        "string_value": " \"\"   ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Select this scene.",
        "note": "Value Is Ignored"
    },
    "custompreset3.import": {
        "format": "String",
        "string_value": " \"\"   ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Capture current settings.",
        "note": "Value Is Ignored"
    },
    "custompreset3.select": {
        "format": "String",
        "string_value": " \"\"   ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Select this scene.",
        "note": "Value Is Ignored"
    },
    "custompreset4.import": {
        "format": "String",
        "string_value": " \"\"   ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Capture current settings.",
        "note": "Value Is Ignored"
    },
    "custompreset4.select": {
        "format": "String",
        "string_value": " \"\"   ",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "N",
        "notify": "N",
        "description": "Select this scene.",
        "note": "Value Is Ignored"
    },
    "{{TRIGGERS_VARIABLES}}.control": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "12V Trigger On/Off Direct Control",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.usemain": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Main Zone 12V Trigger ",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.usezone2": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone2 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.usezone3": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "Zone3 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.BD ( Or DVD)": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "BD/DVD 12V Input Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.SAT (Or CATV)": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "SAT/CATV 12V Input Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.GAME": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "GAME Input 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.STB": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "STB Input 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.VIDEO": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "VIDEO Input 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.AUX": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "AUX Input 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.TV": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "TV Input 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.CD (Or SACD)": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "SACD/CD 12V Input Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.FM": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "FM Input 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.AM": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "AM Input 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.hdmiA": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "HDMI OUT A 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.hdmiB": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "HDMI OUT B 12V Trigger",
        "note": "None"
    },
    "{{TRIGGERS_VARIABLES}}.hdmiOff": {
        "format": "String",
        "string_value": " \"on\", \"off\"",
        "min_number": None,
        "max_number": None,
        "step": None,
        "set": "Y",
        "get": "Y",
        "notify": "N",
        "description": "HDMI OUT OFF 12V Trigger",
        "note": "None"
    }
}