# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WirelessSsidsSchedulesArgs', 'WirelessSsidsSchedules']

@pulumi.input_type
class WirelessSsidsSchedulesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 number: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ranges: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangeArgs']]]] = None,
                 ranges_in_seconds: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangesInSecondArgs']]]] = None):
        """
        The set of arguments for constructing a WirelessSsidsSchedules resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] number: number path parameter.
        :param pulumi.Input[builtins.bool] enabled: If true, the SSID outage schedule is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangeArgs']]] ranges: List of outage ranges. Has a start date and time, and end date and time. If this parameter is passed in along with rangesInSeconds parameter, this will take precedence.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangesInSecondArgs']]] ranges_in_seconds: List of outage ranges in seconds since Sunday at Midnight. Has a start and end. If this parameter is passed in along with the ranges parameter, ranges will take precedence.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "number", number)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)
        if ranges_in_seconds is not None:
            pulumi.set(__self__, "ranges_in_seconds", ranges_in_seconds)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[builtins.str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the SSID outage schedule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangeArgs']]]]:
        """
        List of outage ranges. Has a start date and time, and end date and time. If this parameter is passed in along with rangesInSeconds parameter, this will take precedence.
        """
        return pulumi.get(self, "ranges")

    @ranges.setter
    def ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangeArgs']]]]):
        pulumi.set(self, "ranges", value)

    @property
    @pulumi.getter(name="rangesInSeconds")
    def ranges_in_seconds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangesInSecondArgs']]]]:
        """
        List of outage ranges in seconds since Sunday at Midnight. Has a start and end. If this parameter is passed in along with the ranges parameter, ranges will take precedence.
        """
        return pulumi.get(self, "ranges_in_seconds")

    @ranges_in_seconds.setter
    def ranges_in_seconds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangesInSecondArgs']]]]):
        pulumi.set(self, "ranges_in_seconds", value)


@pulumi.input_type
class _WirelessSsidsSchedulesState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 number: Optional[pulumi.Input[builtins.str]] = None,
                 ranges: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangeArgs']]]] = None,
                 ranges_in_seconds: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangesInSecondArgs']]]] = None):
        """
        Input properties used for looking up and filtering WirelessSsidsSchedules resources.
        :param pulumi.Input[builtins.bool] enabled: If true, the SSID outage schedule is enabled.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] number: number path parameter.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangeArgs']]] ranges: List of outage ranges. Has a start date and time, and end date and time. If this parameter is passed in along with rangesInSeconds parameter, this will take precedence.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangesInSecondArgs']]] ranges_in_seconds: List of outage ranges in seconds since Sunday at Midnight. Has a start and end. If this parameter is passed in along with the ranges parameter, ranges will take precedence.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if ranges is not None:
            pulumi.set(__self__, "ranges", ranges)
        if ranges_in_seconds is not None:
            pulumi.set(__self__, "ranges_in_seconds", ranges_in_seconds)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the SSID outage schedule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangeArgs']]]]:
        """
        List of outage ranges. Has a start date and time, and end date and time. If this parameter is passed in along with rangesInSeconds parameter, this will take precedence.
        """
        return pulumi.get(self, "ranges")

    @ranges.setter
    def ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangeArgs']]]]):
        pulumi.set(self, "ranges", value)

    @property
    @pulumi.getter(name="rangesInSeconds")
    def ranges_in_seconds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangesInSecondArgs']]]]:
        """
        List of outage ranges in seconds since Sunday at Midnight. Has a start and end. If this parameter is passed in along with the ranges parameter, ranges will take precedence.
        """
        return pulumi.get(self, "ranges_in_seconds")

    @ranges_in_seconds.setter
    def ranges_in_seconds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessSsidsSchedulesRangesInSecondArgs']]]]):
        pulumi.set(self, "ranges_in_seconds", value)


class WirelessSsidsSchedules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 number: Optional[pulumi.Input[builtins.str]] = None,
                 ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangeArgs', 'WirelessSsidsSchedulesRangeArgsDict']]]]] = None,
                 ranges_in_seconds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangesInSecondArgs', 'WirelessSsidsSchedulesRangesInSecondArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsSchedules:WirelessSsidsSchedules example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: If true, the SSID outage schedule is enabled.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] number: number path parameter.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangeArgs', 'WirelessSsidsSchedulesRangeArgsDict']]]] ranges: List of outage ranges. Has a start date and time, and end date and time. If this parameter is passed in along with rangesInSeconds parameter, this will take precedence.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangesInSecondArgs', 'WirelessSsidsSchedulesRangesInSecondArgsDict']]]] ranges_in_seconds: List of outage ranges in seconds since Sunday at Midnight. Has a start and end. If this parameter is passed in along with the ranges parameter, ranges will take precedence.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessSsidsSchedulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsSchedules:WirelessSsidsSchedules example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessSsidsSchedulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessSsidsSchedulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 number: Optional[pulumi.Input[builtins.str]] = None,
                 ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangeArgs', 'WirelessSsidsSchedulesRangeArgsDict']]]]] = None,
                 ranges_in_seconds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangesInSecondArgs', 'WirelessSsidsSchedulesRangesInSecondArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessSsidsSchedulesArgs.__new__(WirelessSsidsSchedulesArgs)

            __props__.__dict__["enabled"] = enabled
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if number is None and not opts.urn:
                raise TypeError("Missing required property 'number'")
            __props__.__dict__["number"] = number
            __props__.__dict__["ranges"] = ranges
            __props__.__dict__["ranges_in_seconds"] = ranges_in_seconds
        super(WirelessSsidsSchedules, __self__).__init__(
            'meraki:networks/wirelessSsidsSchedules:WirelessSsidsSchedules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            number: Optional[pulumi.Input[builtins.str]] = None,
            ranges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangeArgs', 'WirelessSsidsSchedulesRangeArgsDict']]]]] = None,
            ranges_in_seconds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangesInSecondArgs', 'WirelessSsidsSchedulesRangesInSecondArgsDict']]]]] = None) -> 'WirelessSsidsSchedules':
        """
        Get an existing WirelessSsidsSchedules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] enabled: If true, the SSID outage schedule is enabled.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] number: number path parameter.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangeArgs', 'WirelessSsidsSchedulesRangeArgsDict']]]] ranges: List of outage ranges. Has a start date and time, and end date and time. If this parameter is passed in along with rangesInSeconds parameter, this will take precedence.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessSsidsSchedulesRangesInSecondArgs', 'WirelessSsidsSchedulesRangesInSecondArgsDict']]]] ranges_in_seconds: List of outage ranges in seconds since Sunday at Midnight. Has a start and end. If this parameter is passed in along with the ranges parameter, ranges will take precedence.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessSsidsSchedulesState.__new__(_WirelessSsidsSchedulesState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["number"] = number
        __props__.__dict__["ranges"] = ranges
        __props__.__dict__["ranges_in_seconds"] = ranges_in_seconds
        return WirelessSsidsSchedules(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[builtins.bool]:
        """
        If true, the SSID outage schedule is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def number(self) -> pulumi.Output[builtins.str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def ranges(self) -> pulumi.Output[Sequence['outputs.WirelessSsidsSchedulesRange']]:
        """
        List of outage ranges. Has a start date and time, and end date and time. If this parameter is passed in along with rangesInSeconds parameter, this will take precedence.
        """
        return pulumi.get(self, "ranges")

    @property
    @pulumi.getter(name="rangesInSeconds")
    def ranges_in_seconds(self) -> pulumi.Output[Sequence['outputs.WirelessSsidsSchedulesRangesInSecond']]:
        """
        List of outage ranges in seconds since Sunday at Midnight. Has a start and end. If this parameter is passed in along with the ranges parameter, ranges will take precedence.
        """
        return pulumi.get(self, "ranges_in_seconds")

