# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCameraBoundariesLinesByDeviceResult',
    'AwaitableGetCameraBoundariesLinesByDeviceResult',
    'get_camera_boundaries_lines_by_device',
    'get_camera_boundaries_lines_by_device_output',
]

@pulumi.output_type
class GetCameraBoundariesLinesByDeviceResult:
    """
    A collection of values returned by getCameraBoundariesLinesByDevice.
    """
    def __init__(__self__, id=None, items=None, organization_id=None, serials=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if serials and not isinstance(serials, list):
            raise TypeError("Expected argument 'serials' to be a list")
        pulumi.set(__self__, "serials", serials)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetCameraBoundariesLinesByDeviceItemResult']:
        """
        Array of ResponseCameraGetOrganizationCameraBoundariesLinesByDevice
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> builtins.str:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def serials(self) -> Optional[Sequence[builtins.str]]:
        """
        serials query parameter. A list of serial numbers. The returned cameras will be filtered to only include these serials.
        """
        return pulumi.get(self, "serials")


class AwaitableGetCameraBoundariesLinesByDeviceResult(GetCameraBoundariesLinesByDeviceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCameraBoundariesLinesByDeviceResult(
            id=self.id,
            items=self.items,
            organization_id=self.organization_id,
            serials=self.serials)


def get_camera_boundaries_lines_by_device(organization_id: Optional[builtins.str] = None,
                                          serials: Optional[Sequence[builtins.str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCameraBoundariesLinesByDeviceResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_camera_boundaries_lines_by_device(organization_id="string",
        serials=["string"])
    pulumi.export("merakiOrganizationsCameraBoundariesLinesByDeviceExample", example.items)
    ```


    :param builtins.str organization_id: organizationId path parameter. Organization ID
    :param Sequence[builtins.str] serials: serials query parameter. A list of serial numbers. The returned cameras will be filtered to only include these serials.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['serials'] = serials
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:organizations/getCameraBoundariesLinesByDevice:getCameraBoundariesLinesByDevice', __args__, opts=opts, typ=GetCameraBoundariesLinesByDeviceResult).value

    return AwaitableGetCameraBoundariesLinesByDeviceResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        serials=pulumi.get(__ret__, 'serials'))
def get_camera_boundaries_lines_by_device_output(organization_id: Optional[pulumi.Input[builtins.str]] = None,
                                                 serials: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCameraBoundariesLinesByDeviceResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_camera_boundaries_lines_by_device(organization_id="string",
        serials=["string"])
    pulumi.export("merakiOrganizationsCameraBoundariesLinesByDeviceExample", example.items)
    ```


    :param builtins.str organization_id: organizationId path parameter. Organization ID
    :param Sequence[builtins.str] serials: serials query parameter. A list of serial numbers. The returned cameras will be filtered to only include these serials.
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['serials'] = serials
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:organizations/getCameraBoundariesLinesByDevice:getCameraBoundariesLinesByDevice', __args__, opts=opts, typ=GetCameraBoundariesLinesByDeviceResult)
    return __ret__.apply(lambda __response__: GetCameraBoundariesLinesByDeviceResult(
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        serials=pulumi.get(__response__, 'serials')))
