from pathlib import Path
from typing import Dict

from setuptools import find_packages, setup


def get_version() -> str:
    version: Dict[str, str] = {}
    with open(Path(__file__).parent / "dg_cli/version.py", encoding="utf8") as fp:
        exec(fp.read(), version)

    return version["__version__"]


ver = get_version()
# dont pin dev installs to avoid pip dep resolver issues
pin = "" if ver == "1!0+dev" else f"=={ver}"
setup(
    name="dagster-dg",
    version=get_version(),
    author="Dagster Labs",
    author_email="hello@dagsterlabs.com",
    license="Apache-2.0",
    description="",  # TODO - fill out description
    url=("https://github.com/dagster-io/dagster/tree/master/python_modules/libraries/dg-cli"),
    classifiers=[
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent",
    ],
    packages=find_packages(exclude=["dg_cli_tests*"]),
    install_requires=[
        "Jinja2",
        "tomli",
        "click>=8",
        "typing_extensions>=4.4.0,<5",
    ],
    zip_safe=False,
    entry_points={
        "console_scripts": [
            "dg = dg_cli.cli:main",
        ]
    },
    extras_require={
        "test": ["pytest"],
    },
)
