COUNTRIES = {
    # A
    "Afghanistan": {
        "formal name": "Islamic Emirate of Afghanistan",
        "continents": ["Asia"],
        "area": 652864.0,
        "land area": 652230.0,
        "population": 42045000,
        "official languages": ["Dari", "Pashto"],
        "nominal GDP": 16417000000,
        "HDI": 0.496,
        "ISO 3166-1": {"alpha-2": "AF", "alpha-3": "AFG", "numeric": "004"},
    },
    "Albania": {
        "formal name": "Republic of Albania",
        "continents": ["Europe"],
        "area": 28748.0,
        "land area": 27400.0,
        "population": 2363314,
        "official languages": ["Albanian"],
        "nominal GDP": 22978000000,
        "HDI": 0.810,
        "ISO 3166-1": {"alpha-2": "AL", "alpha-3": "ALB", "numeric": "008"},
    },
    "Algeria": {
        "formal name": "People's Democratic Republic of Algeria",
        "continents": ["Africa"],
        "area": 2381741.0,
        "land area": 2381741.0,
        "population": 47400000,
        "official languages": ["Arabic", "Standard Algerian Berber"],
        "nominal GDP": 247626000000,
        "HDI": 0.763,
        "ISO 3166-1": {"alpha-2": "DZ", "alpha-3": "DZA", "numeric": "012"},
    },
    "Andorra": {
        "formal name": "Principality of Andorra",
        "continents": ["Europe"],
        "area": 468.0,
        "land area": 468.0,
        "population": 87682,
        "official languages": ["Catalan"],
        "nominal GDP": 3785000000,
        "HDI": 0.913,
        "ISO 3166-1": {"alpha-2": "AD", "alpha-3": "AND", "numeric": "020"},
    },
    "Angola": {
        "formal name": "Republic of Angola",
        "continents": ["Africa"],
        "area": 1246700.0,
        "land area": 1246700.0,
        "population": 36170961,
        "official languages": ["Portuguese"],
        "nominal GDP": 90552000000,
        "HDI": 0.616,
        "ISO 3166-1": {"alpha-2": "AO", "alpha-3": "AGO", "numeric": "024"},
    },
    "Antigua and Barbuda": {
        "formal name": "Antigua and Barbuda",
        "continents": ["North America"],
        "area": 442.0,
        "land area": 442.0,
        "population": 103603,
        "official languages": [],
        "nominal GDP": 2033000000,
        "HDI": 0.851,
        "ISO 3166-1": {"alpha-2": "AG", "alpha-3": "ATG", "numeric": "028"},
    },
    "Argentina": {
        "formal name": "Argentine Republic",
        "continents": ["South America"],
        "area": 2780400.0,
        "land area": 2736690.0,
        "population": 47067641,
        "official languages": [],
        "nominal GDP": 646075000000,
        "HDI": 0.865,
        "ISO 3166-1": {"alpha-2": "AR", "alpha-3": "ARG", "numeric": "032"},
    },
    "Armenia": {
        "formal name": "Republic of Armenia",
        "continents": ["Asia"],
        "area": 29743.0,
        "land area": 28470.0,
        "population": 3081100,
        "official languages": ["Armenian"],
        "nominal GDP": 24219000000,
        "HDI": 0.811,
        "ISO 3166-1": {"alpha-2": "AM", "alpha-3": "ARM", "numeric": "051"},
    },
    "Australia": {
        "formal name": "Commonwealth of Australia",
        "continents": ["Oceania"],
        "area": 7741220.0,
        "land area": 7682300.0,
        "population": 27400013,
        "official languages": [],
        "nominal GDP": 1775628000000,
        "HDI": 0.958,
        "ISO 3166-1": {"alpha-2": "AU", "alpha-3": "AUS", "numeric": "036"},
    },
    "Austria": {
        "formal name": "Republic of Austria",
        "continents": ["Europe"],
        "area": 83878.0,
        "land area": 82520.0,
        "population": 9202428,
        "official languages": ["German"],
        "nominal GDP": 511685000000,
        "HDI": 0.930,
        "ISO 3166-1": {"alpha-2": "AT", "alpha-3": "AUT", "numeric": "040"},
    },
    "Azerbaijan": {
        "formal name": "Republic of Azerbaijan",
        "continents": ["Asia"],
        "area": 86600.0,
        "land area": 82650.0,
        "population": 10236227,
        "official languages": ["Azerbaijani"],
        "nominal GDP": 72356000000,
        "HDI": 0.789,
        "ISO 3166-1": {"alpha-2": "AZ", "alpha-3": "AZE", "numeric": "031"},
    },
    # B
    "Bahamas": {
        "formal name": "Commonwealth of The Bahamas",
        "continents": ["North America"],
        "area": 13880.0,
        "land area": 10010.0,
        "population": 398165,
        "official languages": ["English"],
        "nominal GDP": 14338000000,
        "HDI": 0.820,
        "ISO 3166-1": {"alpha-2": "BS", "alpha-3": "BHS", "numeric": "044"},
    },
    "Bahrain": {
        "formal name": "Kingdom of Bahrain",
        "continents": ["Asia"],
        "area": 778.0,
        "land area": 778.0,
        "population": 1594654,
        "official languages": ["Arabic"],
        "nominal GDP": 44662000000,
        "HDI": 0.899,
        "ISO 3166-1": {"alpha-2": "BH", "alpha-3": "BHR", "numeric": "048"},
    },
    "Bangladesh": {
        "formal name": "People's Republic of Bangladesh",
        "continents": ["Asia"],
        "area": 148460.0,
        "land area": 130170.0,
        "population": 169828911,
        "official languages": ["Bengali"],
        "nominal GDP": 422431000000,
        "HDI": 0.685,
        "ISO 3166-1": {"alpha-2": "BD", "alpha-3": "BGD", "numeric": "050"},
    },
    "Barbados": {
        "formal name": "Barbados",
        "continents": ["North America"],
        "area": 431.0,
        "land area": 431.0,
        "population": 267800,
        "official languages": ["English"],
        "nominal GDP": 6721000000,
        "HDI": 0.811,
        "ISO 3166-1": {"alpha-2": "BB", "alpha-3": "BRB", "numeric": "052"},
    },
    "Belarus": {
        "formal name": "Republic of Belarus",
        "continents": ["Europe"],
        "area": 207600.0,
        "land area": 202900.0,
        "population": 9109280,
        "official languages": ["Belarusian", "Russian"],
        "nominal GDP": 71857000000,
        "HDI": 0.824,
        "ISO 3166-1": {"alpha-2": "BY", "alpha-3": "BLR", "numeric": "112"},
    },
    "Belgium": {
        "formal name": "Kingdom of Belgium",
        "continents": ["Europe"],
        "area": 30528.0,
        "land area": 30280.0,
        "population": 11825551,
        "official languages": ["Dutch", "French", "German"],
        "nominal GDP": 644783000000,
        "HDI": 0.951,
        "ISO 3166-1": {"alpha-2": "BE", "alpha-3": "BEL", "numeric": "056"},
    },
    "Belize": {
        "formal name": "Belize",
        "continents": ["North America"],
        "area": 22965.0,
        "land area": 22810.0,
        "population": 410919,
        "official languages": ["English"],
        "nominal GDP": 3079000000,
        "HDI": 0.721,
        "ISO 3166-1": {"alpha-2": "BZ", "alpha-3": "BLZ", "numeric": "084"},
    },
    "Benin": {
        "formal name": "Republic of Benin",
        "continents": ["Africa"],
        "area": 114763.0,
        "land area": 112760.0,
        "population": 13224860,
        "official languages": ["French"],
        "nominal GDP": 19673000000,
        "HDI": 0.515,
        "ISO 3166-1": {"alpha-2": "BJ", "alpha-3": "BEN", "numeric": "204"},
    },
    "Bhutan": {
        "formal name": "Kingdom of Bhutan",
        "continents": ["Asia"],
        "area": 38394.0,
        "land area": 38140.0,
        "population": 777224,
        "official languages": ["Dzongkha"],
        "nominal GDP": 3019000000,
        "HDI": 0.698,
        "ISO 3166-1": {"alpha-2": "BT", "alpha-3": "BTN", "numeric": "064"},
    },
    "Bolivia": {
        "formal name": "Plurinational State of Bolivia",
        "continents": ["South America"],
        "area": 1098581.0,
        "land area": 1083300.0,
        "population": 11312620,
        "official languages": ["Bolivian Spanish", "Aymara", "Araona", "Baure", "Chiquitano", "Canichana", "Cavineña", "Cayubaba", "Chácobo-Pakawara", "Chimané", "Ese Ejja", "Guarani", "Warázu", "Guarayu", "Itonama", "Leco", "Kallawaya", "Yine", "Reyesano", "Mojeño-Ignaciano", "Mojeño-Trinitario", "Itene", "Mosetén", "Movima", "Pacahuara", "Puquina", "Quechuan", "Sirionó", "Tacana", "Eastern Bolivian Guaraní", "Toromono", "Uru–Chipaya", "Wichí Lhamtés Nocten", "Yaminawa", "Yuqui", "Yuracaré", "Ayoreo"],
        "nominal GDP": 45135000000,
        "HDI": 0.733,
        "ISO 3166-1": {"alpha-2": "BO", "alpha-3": "BOL", "numeric": "068"},
    },
    "Bosnia and Herzegovina": {
        "formal name": "Bosnia and Herzegovina",
        "continents": ["Europe"],
        "area": 51209.0,
        "land area": 51200.0,
        "population": 3422000,
        "official languages": [],
        "nominal GDP": 27515000000,
        "HDI": 0.804,
        "ISO 3166-1": {"alpha-2": "BA", "alpha-3": "BIH", "numeric": "070"},
    },
    "Botswana": {
        "formal name": "Republic of Botswana",
        "continents": ["Africa"],
        "area": 582000.0,
        "land area": 566730.0,
        "population": 2359609,
        "official languages": ["English"],
        "nominal GDP": 19396000000,
        "HDI": 0.731,
        "ISO 3166-1": {"alpha-2": "BW", "alpha-3": "BWA", "numeric": "072"},
    },
    "Brazil": {
        "formal name": "Federative Republic of Brazil",
        "continents": ["South America"],
        "area": 8510346.0,
        "land area": 8460415.0,
        "population": 212583750,
        "official languages": ["Portuguese"],
        "nominal GDP": 2191132000000,
        "HDI": 0.786,
        "ISO 3166-1": {"alpha-2": "BR", "alpha-3": "BRA", "numeric": "076"},
    },
    "Brunei": {
        "formal name": "Nation of Brunei, the Abode of Peace",
        "continents": ["Asia"],
        "area": 5765.0,
        "land area": 5270.0,
        "population": 455500,
        "official languages": ["Brunei Malay"],
        "nominal GDP": 15128000000,
        "HDI": 0.837,
        "ISO 3166-1": {"alpha-2": "BN", "alpha-3": "BRN", "numeric": "096"},
    },
    "Bulgaria": {
        "formal name": "Republic of Bulgaria",
        "continents": ["Europe"],
        "area": 110879.0,
        "land area": 108489.0,
        "population": 6437360,
        "official languages": ["Bulgarian"],
        "nominal GDP": 102397000000,
        "HDI": 0.845,
        "ISO 3166-1": {"alpha-2": "BG", "alpha-3": "BGR", "numeric": "100"},
    },
    "Burkina Faso": {
        "formal name": "Burkina Faso",
        "continents": ["Africa"],
        "area": 274200.0,
        "land area": 273800.0,
        "population": 24070553,
        "official languages": ["Mooré", "Bissa", "Dyula", "Fula"],
        "nominal GDP": 20325000000,
        "HDI": 0.459,
        "ISO 3166-1": {"alpha-2": "BF", "alpha-3": "BFA", "numeric": "854"},
    },
    "Burundi": {
        "formal name": "Republic of Burundi",
        "continents": ["Africa"],
        "area": 27834.0,
        "land area": 25680.0,
        "population": 12332788,
        "official languages": ["French", "Kirundi", "English"],
        "nominal GDP": 3960000000,
        "HDI": 0.439,
        "ISO 3166-1": {"alpha-2": "BI", "alpha-3": "BDI", "numeric": "108"},
    },
    # C
    "Cambodia": {
        "formal name": "Kingdom of Cambodia",
        "continents": ["Asia"],
        "area": 181035.0,
        "land area": 176520.0,
        "population": 17577760,
        "official languages": ["Khmer"],
        "nominal GDP": 42824000000,
        "HDI": 0.606,
        "ISO 3166-1": {"alpha-2": "KH", "alpha-3": "KHM", "numeric": "116"},
    },
    "Cameroon": {
        "formal name": "Republic of Cameroon",
        "continents": ["Africa"],
        "area": 475650.0,
        "land area": 472710.0,
        "population": 29442327,
        "official languages": ["English", "French"],
        "nominal GDP": 49279000000,
        "HDI": 0.588,
        "ISO 3166-1": {"alpha-2": "CM", "alpha-3": "CMR", "numeric": "120"},
    },
    "Canada": {
        "formal name": "Canada",
        "continents": ["North America"],
        "area": 9984670.0,
        "land area": 9093507.0,
        "population": 41548787,
        "official languages": ["Canadian English", "Canadian French"],
        "nominal GDP": 2142471000000,
        "HDI": 0.939,
        "ISO 3166-1": {"alpha-2": "CA", "alpha-3": "CAN", "numeric": "124"},
    },
    "Cape Verde": {
        "formal name": "Republic of Cabo Verde",
        "continents": ["Africa"],
        "area": 4033.0,
        "land area": 4033.0,
        "population": 491233,
        "official languages": ["Portuguese"],
        "nominal GDP": 2591000000,
        "HDI": 0.668,
        "ISO 3166-1": {"alpha-2": "CV", "alpha-3": "CPV", "numeric": "132"},
    },
    "Central African Republic": {
        "formal name": "Central African Republic",
        "continents": ["Africa"],
        "area": 622984.0,
        "land area": 622984.0,
        "population": 6470307,
        "official languages": ["French", "Sango"],
        "nominal GDP": 2555000000,
        "HDI": 0.414,
        "ISO 3166-1": {"alpha-2": "CF", "alpha-3": "CAF", "numeric": "140"},
    },
    "Chad": {
        "formal name": "Republic of Chad",
        "continents": ["Africa"],
        "area": 1284000.0,
        "land area": 1259200.0,
        "population": 19340757,
        "official languages": ["Arabic", "French"],
        "nominal GDP": 17643000000,
        "HDI": 0.416,
        "ISO 3166-1": {"alpha-2": "TD", "alpha-3": "TCD", "numeric": "148"},
    },
    "Chile": {
        "formal name": "Republic of Chile",
        "continents": ["South America"],
        "area": 756102.0,
        "land area": 743812.0,
        "population": 20206953,
        "official languages": ["Spanish"],
        "nominal GDP": 335533000000,
        "HDI": 0.878,
        "ISO 3166-1": {"alpha-2": "CL", "alpha-3": "CHL", "numeric": "152"},
    },
    "China": {
        "formal name": "People's Republic of China",
        "continents": ["Asia"],
        "area": 9596960.0,
        "land area": 9326410.0,
        "population": 1408280000,
        "official languages": ["Standard Chinese"],
        "nominal GDP": 17794782000000,
        "HDI": 0.797,
        "ISO 3166-1": {"alpha-2": "CN", "alpha-3": "CHN", "numeric": "156"},
    },
    "Colombia": {
        "formal name": "Republic of Colombia",
        "continents": ["South America"],
        "area": 1138910.0,
        "land area": 1038700.0,
        "population": 52695952,
        "official languages": ["Spanish"],
        "nominal GDP": 363540000000,
        "HDI": 0.788,
        "ISO 3166-1": {"alpha-2": "CO", "alpha-3": "COL", "numeric": "170"},
    },
    "Comoros": {
        "formal name": "Union of the Comoros",
        "continents": ["Africa"],
        "area": 1861.0,
        "land area": 1861.0,
        "population": 870038,
        "official languages": ["Arabic", "Comorian", "French"],
        "nominal GDP": 1448000000,
        "HDI": 0.603,
        "ISO 3166-1": {"alpha-2": "KM", "alpha-3": "COM", "numeric": "174"},
    },
    "Costa Rica": {
        "formal name": "Republic of Costa Rica",
        "continents": ["North America"],
        "area": 51100.0,
        "land area": 51060.0,
        "population": 5309625,
        "official languages": ["Spanish"],
        "nominal GDP": 86498000000,
        "HDI": 0.833,
        "ISO 3166-1": {"alpha-2": "CR", "alpha-3": "CRI", "numeric": "188"},
    },
    "Croatia": {
        "formal name": "Republic of Croatia",
        "continents": ["Europe"],
        "area": 56594.0,
        "land area": 55974.0,
        "population": 3859686,
        "official languages": ["Croatian"],
        "nominal GDP": 84391000000,
        "HDI": 0.889,
        "ISO 3166-1": {"alpha-2": "HR", "alpha-3": "HRV", "numeric": "191"},
    },
    "Cuba": {
        "formal name": "Republic of Cuba",
        "continents": ["North America"],
        "area": 109884.0,
        "land area": 103800.0,
        "population": 9748007,
        "official languages": ["Spanish"],
        "nominal GDP": 201986000000,
        "HDI": 0.762,
        "ISO 3166-1": {"alpha-2": "CU", "alpha-3": "CUB", "numeric": "192"},
    },
    "Cyprus": {
        "formal name": "Republic of Cyprus",
        "continents": ["Asia"],
        "area": 9251.0,
        "land area": 9241.0,
        "population": 966400,
        "official languages": ["Greek", "Turkish"],
        "nominal GDP": 33887000000,
        "HDI": 0.913,
        "ISO 3166-1": {"alpha-2": "CY", "alpha-3": "CYP", "numeric": "196"},
    },
    "Czech Republic": {
        "formal name": "Czech Republic",
        "continents": ["Europe"],
        "area": 78871.0,
        "land area": 77187.0,
        "population": 10876875,
        "official languages": ["Czech"],
        "nominal GDP": 343208000000,
        "HDI": 0.915,
        "ISO 3166-1": {"alpha-2": "CZ", "alpha-3": "CZE", "numeric": "203"},
    },
    # D
    "Democratic Republic of the Congo": {
        "formal name": "Democratic Republic of the Congo",
        "continents": ["Africa"],
        "area": 2344858.0,
        "land area": 2267048.0,
        "population": 109276000,
        "official languages": ["French"],
        "nominal GDP": 69338000000,
        "HDI": 0.522,
        "ISO 3166-1": {"alpha-2": "CD", "alpha-3": "COD", "numeric": "180"},
    },
    "Denmark": {
        "formal name": "Kingdom of Denmark",
        "continents": ["Europe"],
        "area": 42947.0,
        "land area": 42434.0,
        "population": 6001008,
        "official languages": ["Danish"],
        "nominal GDP": 407092000000,
        "HDI": 0.962,
        "ISO 3166-1": {"alpha-2": "DK", "alpha-3": "DNK", "numeric": "208"},
    },
    "Djibouti": {
        "formal name": "Republic of Djibouti",
        "continents": ["Africa"],
        "area": 23200.0,
        "land area": 23180.0,
        "population": 1066809,
        "official languages": ["Arabic", "French"],
        "nominal GDP": 4000000000,
        "HDI": 0.513,
        "ISO 3166-1": {"alpha-2": "DJ", "alpha-3": "DJI", "numeric": "262"},
    },
    "Dominica": {
        "formal name": "Commonwealth of Dominica",
        "continents": ["North America"],
        "area": 750.0,
        "land area": 750.0,
        "population": 67408,
        "official languages": ["English"],
        "nominal GDP": 651000000,
        "HDI": 0.761,
        "ISO 3166-1": {"alpha-2": "DM", "alpha-3": "DMA", "numeric": "212"},
    },
    "Dominican Republic": {
        "formal name": "Dominican Republic",
        "continents": ["North America"],
        "area": 48670.0,
        "land area": 48320.0,
        "population": 10771504,
        "official languages": ["Spanish"],
        "nominal GDP": 121444000000,
        "HDI": 0.776,
        "ISO 3166-1": {"alpha-2": "DO", "alpha-3": "DOM", "numeric": "214"},
    },
    # E
    "Ecuador": {
        "formal name": "Republic of Ecuador",
        "continents": ["South America"],
        "area": 283561.0,
        "land area": 276841.0,
        "population": 16938986,
        "official languages": ["Spanish"],
        "nominal GDP": 118845000000,
        "HDI": 0.777,
        "ISO 3166-1": {"alpha-2": "EC", "alpha-3": "ECU", "numeric": "218"},
    },
    "Egypt": {
        "formal name": "Arab Republic of Egypt",
        "continents": ["Asia", "Africa"],
        "area": 1001450.0,
        "land area": 995450.0,
        "population": 107271260,
        "official languages": ["Arabic"],
        "nominal GDP": 331590000000,
        "HDI": 0.754,
        "ISO 3166-1": {"alpha-2": "EG", "alpha-3": "EGY", "numeric": "818"},
    },
    "El Salvador": {
        "formal name": "Republic of El Salvador",
        "continents": ["North America"],
        "area": 21041.0,
        "land area": 20720.0,
        "population": 6029976,
        "official languages": ["Spanish"],
        "nominal GDP": 34016000000,
        "HDI": 0.678,
        "ISO 3166-1": {"alpha-2": "SV", "alpha-3": "SLV", "numeric": "222"},
    },
    "Equatorial Guinea": {
        "formal name": "Republic of Equatorial Guinea",
        "continents": ["Africa"],
        "area": 28051.0,
        "land area": 28051.0,
        "population": 1558160,
        "official languages": ["French", "Portuguese", "Spanish"],
        "nominal GDP": 12117000000,
        "HDI": 0.674,
        "ISO 3166-1": {"alpha-2": "GQ", "alpha-3": "GNQ", "numeric": "226"},
    },
    "Eritrea": {
        "formal name": "State of Eritrea",
        "continents": ["Africa"],
        "area": 117600.0,
        "land area": 101000.0,
        "population": 3535603,
        "official languages": ["Tigrinya"],
        "nominal GDP": 2275000000,
        "HDI": 0.503,
        "ISO 3166-1": {"alpha-2": "ER", "alpha-3": "ERI", "numeric": "232"},
    },
    "Estonia": {
        "formal name": "Republic of Estonia",
        "continents": ["Europe"],
        "area": 45339.0,
        "land area": 42388.0,
        "population": 1369995,
        "official languages": ["Estonian"],
        "nominal GDP": 41291000000,
        "HDI": 0.905,
        "ISO 3166-1": {"alpha-2": "EE", "alpha-3": "EST", "numeric": "233"},
    },
    "Eswatini": {
        "formal name": "Kingdom of Eswatini",
        "continents": ["Africa"],
        "area": 17363.0,
        "land area": 17200.0,
        "population": 1235549,
        "official languages": ["English", "Swazi"],
        "nominal GDP": 4574000000,
        "HDI": 0.695,
        "ISO 3166-1": {"alpha-2": "SZ", "alpha-3": "SWZ", "numeric": "748"},
    },
    "Ethiopia": {
        "formal name": "Federal Democratic Republic of Ethiopia",
        "continents": ["Africa"],
        "area": 1104300.0,
        "land area": 1096570.0,
        "population": 111652998,
        "official languages": ["Afar", "Amharic", "Oromo", "Somali", "Tigrinya"],
        "nominal GDP": 159746000000,
        "HDI": 0.497,
        "ISO 3166-1": {"alpha-2": "ET", "alpha-3": "ETH", "numeric": "231"},
    },
    # F
    "Fiji": {
        "formal name": "Republic of Fiji",
        "continents": ["Oceania"],
        "area": 18272.0,
        "land area": 18272.0,
        "population": 900869,
        "official languages": ["English", "Fijian", "Fiji Hindi"],
        "nominal GDP": 5442000000,
        "HDI": 0.731,
        "ISO 3166-1": {"alpha-2": "FJ", "alpha-3": "FJI", "numeric": "242"},
    },
    "Finland": {
        "formal name": "Republic of Finland",
        "continents": ["Europe"],
        "area": 338145.0,
        "land area": 303815.0,
        "population": 5641532,
        "official languages": ["Finnish", "Swedish"],
        "nominal GDP": 295532000000,
        "HDI": 0.948,
        "ISO 3166-1": {"alpha-2": "FI", "alpha-3": "FIN", "numeric": "246"},
    },
    "France": {
        "formal name": "French Republic",
        "continents": ["Europe"],
        "area": 643801.0,
        "land area": 640427.0,
        "population": 68649000,
        "official languages": ["French"],
        "nominal GDP": 3051832000000,
        "HDI": 0.920,
        "ISO 3166-1": {"alpha-2": "FR", "alpha-3": "FRA", "numeric": "250"},
    },
    # G
    "Gabon": {
        "formal name": "Gabonese Republic",
        "continents": ["Africa"],
        "area": 267668.0,
        "land area": 257670.0,
        "population": 2408586,
        "official languages": ["French"],
        "nominal GDP": 20056000000,
        "HDI": 0.733,
        "ISO 3166-1": {"alpha-2": "GA", "alpha-3": "GAB", "numeric": "266"},
    },
    "Gambia": {
        "formal name": "Republic of The Gambia",
        "continents": ["Africa"],
        "area": 11295.0,
        "land area": 10120.0,
        "population": 2417471,
        "official languages": ["English"],
        "nominal GDP": 2401000000,
        "HDI": 0.524,
        "ISO 3166-1": {"alpha-2": "GM", "alpha-3": "GMB", "numeric": "270"},
    },
    "Georgia": {
        "formal name": "Republic of Georgia",
        "continents": ["Asia"],
        "area": 69700.0,
        "land area": 69490.0,
        "population": 3704500,
        "official languages": ["Georgian"],
        "nominal GDP": 30536000000,
        "HDI": 0.844,
        "ISO 3166-1": {"alpha-2": "GE", "alpha-3": "GEO", "numeric": "268"},
    },
    "Germany": {
        "formal name": "Federal Republic of Germany",
        "continents": ["Europe"],
        "area": 357581.0,
        "land area": 349390.0,
        "population": 83577140,
        "official languages": ["German"],
        "nominal GDP": 4525704000000,
        "HDI": 0.959,
        "ISO 3166-1": {"alpha-2": "DE", "alpha-3": "DEU", "numeric": "276"},
    },
    "Ghana": {
        "formal name": "Republic of Ghana",
        "continents": ["Africa"],
        "area": 238537.0,
        "land area": 227533.0,
        "population": 33742380,
        "official languages": ["English"],
        "nominal GDP": 76370000000,
        "HDI": 0.628,
        "ISO 3166-1": {"alpha-2": "GH", "alpha-3": "GHA", "numeric": "288"},
    },
    "Greece": {
        "formal name": "Hellenic Republic",
        "continents": ["Europe"],
        "area": 131957.0,
        "land area": 128900.0,
        "population": 10400720,
        "official languages": ["Greek"],
        "nominal GDP": 243498000000,
        "HDI": 0.908,
        "ISO 3166-1": {"alpha-2": "GR", "alpha-3": "GRC", "numeric": "300"},
    },
    "Grenada": {
        "formal name": "Grenada",
        "continents": ["North America"],
        "area": 345.0,
        "land area": 340.0,
        "population": 112579,
        "official languages": ["English"],
        "nominal GDP": 1317000000,
        "HDI": 0.791,
        "ISO 3166-1": {"alpha-2": "GD", "alpha-3": "GRD", "numeric": "308"},
    },
    "Guatemala": {
        "formal name": "Republic of Guatemala",
        "continents": ["North America"],
        "area": 108889.0,
        "land area": 107160.0,
        "population": 18079810,
        "official languages": ["Spanish"],
        "nominal GDP": 104451000000,
        "HDI": 0.662,
        "ISO 3166-1": {"alpha-2": "GT", "alpha-3": "GTM", "numeric": "320"},
    },
    "Guinea": {
        "formal name": "Republic of Guinea",
        "continents": ["Africa"],
        "area": 245857.0,
        "land area": 245717.0,
        "population": 14363931,
        "official languages": ["French"],
        "nominal GDP": 23006000000,
        "HDI": 0.500,
        "ISO 3166-1": {"alpha-2": "GN", "alpha-3": "GIN", "numeric": "324"},
    },
    "Guinea-Bissau": {
        "formal name": "Republic of Guinea-Bissau",
        "continents": ["Africa"],
        "area": 36125.0,
        "land area": 28120.0,
        "population": 1781308,
        "official languages": ["Portuguese"],
        "nominal GDP": 1841000000,
        "HDI": 0.514,
        "ISO 3166-1": {"alpha-2": "GW", "alpha-3": "GNB", "numeric": "624"},
    },
    "Guyana": {
        "formal name": "Co-operative Republic of Guyana",
        "continents": ["South America"],
        "area": 214969.0,
        "land area": 196850.0,
        "population": 772975,
        "official languages": ["English"],
        "nominal GDP": 16683000000,
        "HDI": 0.776,
        "ISO 3166-1": {"alpha-2": "GY", "alpha-3": "GUY", "numeric": "328"},
    },
    # H
    "Haiti": {
        "formal name": "Republic of Haiti",
        "continents": ["North America"],
        "area": 27750.0,
        "land area": 27560.0,
        "population": 11867032,
        "official languages": ["French", "Haitian Creole"],
        "nominal GDP": 19841000000,
        "HDI": 0.554,
        "ISO 3166-1": {"alpha-2": "HT", "alpha-3": "HTI", "numeric": "332"},
    },
    "Honduras": {
        "formal name": "Republic of Honduras",
        "continents": ["North America"],
        "area": 112492.0,
        "land area": 111890.0,
        "population": 9892632,
        "official languages": ["Spanish"],
        "nominal GDP": 34401000000,
        "HDI": 0.645,
        "ISO 3166-1": {"alpha-2": "HN", "alpha-3": "HND", "numeric": "340"},
    },
    "Hungary": {
        "formal name": "Hungary",
        "continents": ["Europe"],
        "area": 93025.0,
        "land area": 91260.0,
        "population": 9539502,
        "official languages": ["Hungarian"],
        "nominal GDP": 212657000000,
        "HDI": 0.870,
        "ISO 3166-1": {"alpha-2": "HU", "alpha-3": "HUN", "numeric": "348"},
    },
    # I
    "Iceland": {
        "formal name": "Iceland",
        "continents": ["Europe"],
        "area": 103000.0,
        "land area": 100830.0,
        "population": 389990,
        "official languages": ["Icelandic", "Icelandic Sign Language"],
        "nominal GDP": 31325000000,
        "HDI": 0.972,
        "ISO 3166-1": {"alpha-2": "IS", "alpha-3": "ISL", "numeric": "352"},
    },
    "India": {
        "formal name": "Republic of India",
        "continents": ["Asia"],
        "area": 3163751.0,
        "land area": 2973190.0,
        "population": 1413324000,
        "official languages": ["Hindi", "English"],
        "nominal GDP": 3575778000000,
        "HDI": 0.685,
        "ISO 3166-1": {"alpha-2": "IN", "alpha-3": "IND", "numeric": "356"},
    },
    "Indonesia": {
        "formal name": "Republic of Indonesia",
        "continents": ["Asia", "Oceania"],
        "area": 1904569.0,
        "land area": 1811569.0,
        "population": 282477584,
        "official languages": ["Indonesian"],
        "nominal GDP": 1371171000000,
        "HDI": 0.728,
        "ISO 3166-1": {"alpha-2": "ID", "alpha-3": "IDN", "numeric": "360"},
    },
    "Iran": {
        "formal name": "Islamic Republic of Iran",
        "continents": ["Asia"],
        "area": 1648195.0,
        "land area": 1531595.0,
        "population": 85961000,
        "official languages": ["Persian"],
        "nominal GDP": 401596000000,
        "HDI": 0.799,
        "ISO 3166-1": {"alpha-2": "IR", "alpha-3": "IRN", "numeric": "364"},
    },
    "Iraq": {
        "formal name": "Republic of Iraq",
        "continents": ["Asia"],
        "area": 438317.0,
        "land area": 437367.0,
        "population": 46118793,
        "official languages": ["Arabic", "Kurdish"],
        "nominal GDP": 232107000000,
        "HDI": 0.695,
        "ISO 3166-1": {"alpha-2": "IQ", "alpha-3": "IRQ", "numeric": "368"},
    },
    "Ireland": {
        "formal name": "Ireland",
        "continents": ["Europe"],
        "area": 70273.0,
        "land area": 68883.0,
        "population": 5380300,
        "official languages": ["Irish", "Hiberno-English"],
        "nominal GDP": 551395000000,
        "HDI": 0.949,
        "ISO 3166-1": {"alpha-2": "IE", "alpha-3": "IRL", "numeric": "372"},
    },
    "Israel": {
        "formal name": "State of Israel",
        "continents": ["Asia"],
        "area": 21937.0,
        "land area": 21497.0,
        "population": 10098200,
        "official languages": ["Hebrew"],
        "nominal GDP": 513611000000,
        "HDI": 0.919,
        "ISO 3166-1": {"alpha-2": "IL", "alpha-3": "ISR", "numeric": "376"},
    },
    "Italy": {
        "formal name": "Italian Republic",
        "continents": ["Europe"],
        "area": 302068.0,
        "land area": 295717.0,
        "population": 58921111,
        "official languages": ["Italian"],
        "nominal GDP": 2300941000000,
        "HDI": 0.915,
        "ISO 3166-1": {"alpha-2": "IT", "alpha-3": "ITA", "numeric": "380"},
    },
    "Ivory Coast": {
        "formal name": "Republic of Côte d'Ivoire",
        "continents": ["Africa"],
        "area": 322462.0,
        "land area": 318000.0,
        "population": 29389150,
        "official languages": ["French"],
        "nominal GDP": 78789000000,
        "HDI": 0.582,
        "ISO 3166-1": {"alpha-2": "CI", "alpha-3": "CIV", "numeric": "384"},
    },
    # J
    "Jamaica": {
        "formal name": "Jamaica",
        "continents": ["North America"],
        "area": 10991.0,
        "land area": 10830.0,
        "population": 2825544,
        "official languages": ["English"],
        "nominal GDP": 19423000000,
        "HDI": 0.720,
        "ISO 3166-1": {"alpha-2": "JM", "alpha-3": "JAM", "numeric": "388"},
    },
    "Japan": {
        "formal name": "Japan",
        "continents": ["Asia"],
        "area": 377915.0,
        "land area": 364485.0,
        "population": 123360000,
        "official languages": [],
        "nominal GDP": 4204495000000,
        "HDI": 0.925,
        "ISO 3166-1": {"alpha-2": "JP", "alpha-3": "JPN", "numeric": "392"},
    },
    "Jordan": {
        "formal name": "Hashemite Kingdom of Jordan",
        "continents": ["Asia"],
        "area": 89318.0,
        "land area": 88794.0,
        "population": 11734000,
        "official languages": ["Arabic"],
        "nominal GDP": 50814000000,
        "HDI": 0.754,
        "ISO 3166-1": {"alpha-2": "JO", "alpha-3": "JOR", "numeric": "400"},
    },
    # K
    "Kazakhstan": {
        "formal name": "Republic of Kazakhstan",
        "continents": ["Asia"],
        "area": 2724910.0,
        "land area": 2699700.0,
        "population": 20370672,
        "official languages": ["Kazakh", "Russian"],
        "nominal GDP": 264293000000,
        "HDI": 0.837,
        "ISO 3166-1": {"alpha-2": "KZ", "alpha-3": "KAZ", "numeric": "398"},
    },
    "Kenya": {
        "formal name": "Republic of Kenya",
        "continents": ["Africa"],
        "area": 580367.0,
        "land area": 569140.0,
        "population": 53330978,
        "official languages": ["English", "Swahili"],
        "nominal GDP": 108039000000,
        "HDI": 0.628,
        "ISO 3166-1": {"alpha-2": "KE", "alpha-3": "KEN", "numeric": "404"},
    },
    "Kiribati": {
        "formal name": "Republic of Kiribati",
        "continents": ["Oceania"],
        "area": 811.0,
        "land area": 811.0,
        "population": 120740,
        "official languages": ["English", "Gilbertese"],
        "nominal GDP": 289000000,
        "HDI": 0.644,
        "ISO 3166-1": {"alpha-2": "KI", "alpha-3": "KIR", "numeric": "296"},
    },
    "Kuwait": {
        "formal name": "State of Kuwait",
        "continents": ["Asia"],
        "area": 17818.0,
        "land area": 17818.0,
        "population": 4913271,
        "official languages": ["Arabic"],
        "nominal GDP": 163705000000,
        "HDI": 0.852,
        "ISO 3166-1": {"alpha-2": "KW", "alpha-3": "KWT", "numeric": "414"},
    },
    "Kyrgyzstan": {
        "formal name": "Kyrgyz Republic",
        "continents": ["Asia"],
        "area": 199949.0,
        "land area": 191800.0,
        "population": 7161900,
        "official languages": ["Kyrgyz", "Russian"],
        "nominal GDP": 13988000000,
        "HDI": 0.720,
        "ISO 3166-1": {"alpha-2": "KG", "alpha-3": "KGZ", "numeric": "417"},
    },
    # L
    "Laos": {
        "formal name": "Lao People's Democratic Republic",
        "continents": ["Asia"],
        "area": 236800.0,
        "land area": 230800.0,
        "population": 7546000,
        "official languages": ["Lao"],
        "nominal GDP": 15008000000,
        "HDI": 0.617,
        "ISO 3166-1": {"alpha-2": "LA", "alpha-3": "LAO", "numeric": "418"},
    },
    "Latvia": {
        "formal name": "Republic of Latvia",
        "continents": ["Europe"],
        "area": 64594.0,
        "land area": 62230.0,
        "population": 1852100,
        "official languages": ["Latvian"],
        "nominal GDP": 42248000000,
        "HDI": 0.889,
        "ISO 3166-1": {"alpha-2": "LV", "alpha-3": "LVA", "numeric": "428"},
    },
    "Lebanon": {
        "formal name": "Republic of Lebanon",
        "continents": ["Asia"],
        "area": 10452.0,
        "land area": 10230.0,
        "population": 5490000,
        "official languages": ["Arabic"],
        "nominal GDP": 27464000000,
        "HDI": 0.752,
        "ISO 3166-1": {"alpha-2": "LB", "alpha-3": "LBN", "numeric": "422"},
    },
    "Lesotho": {
        "formal name": "Kingdom of Lesotho",
        "continents": ["Africa"],
        "area": 30355.0,
        "land area": 30355.0,
        "population": 2306000,
        "official languages": ["Sotho", "English"],
        "nominal GDP": 2118000000,
        "HDI": 0.550,
        "ISO 3166-1": {"alpha-2": "LS", "alpha-3": "LSO", "numeric": "426"},
    },
    "Liberia": {
        "formal name": "Republic of Liberia",
        "continents": ["Africa"],
        "area": 111369.0,
        "land area": 96320.0,
        "population": 5248621,
        "official languages": ["English"],
        "nominal GDP": 5039000000,
        "HDI": 0.510,
        "ISO 3166-1": {"alpha-2": "LR", "alpha-3": "LBR", "numeric": "430"},
    },
    "Libya": {
        "formal name": "State of Libya",
        "continents": ["Africa"],
        "area": 1759540.0,
        "land area": 1759540.0,
        "population": 7381023,
        "official languages": ["Arabic"],
        "nominal GDP": 44030000000,
        "HDI": 0.721,
        "ISO 3166-1": {"alpha-2": "LY", "alpha-3": "LBY", "numeric": "434"},
    },
    "Liechtenstein": {
        "formal name": "Principality of Liechtenstein",
        "continents": ["Europe"],
        "area": 160.0,
        "land area": 160.0,
        "population": 40900,
        "official languages": ["German"],
        "nominal GDP": 7965000000,
        "HDI": 0.938,
        "ISO 3166-1": {"alpha-2": "LI", "alpha-3": "LIE", "numeric": "438"},
    },
    "Lithuania": {
        "formal name": "Republic of Lithuania",
        "continents": ["Europe"],
        "area": 65286.0,
        "land area": 62610.0,
        "population": 2892177,
        "official languages": ["Lithuanian"],
        "nominal GDP": 79790000000,
        "HDI": 0.895,
        "ISO 3166-1": {"alpha-2": "LT", "alpha-3": "LTU", "numeric": "440"},
    },
    "Luxembourg": {
        "formal name": "Grand Duchy of Luxembourg",
        "continents": ["Europe"],
        "area": 2586.0,
        "land area": 2574.0,
        "population": 681973,
        "official languages": ["French", "German", "Luxembourgish"],
        "nominal GDP": 85755000000,
        "HDI": 0.922,
        "ISO 3166-1": {"alpha-2": "LU", "alpha-3": "LUX", "numeric": "442"},
    },
    # M
    "Madagascar": {
        "formal name": "Republic of Madagascar",
        "continents": ["Africa"],
        "area": 587041.0,
        "land area": 581540.0,
        "population": 31727042,
        "official languages": ["French", "Malagasy"],
        "nominal GDP": 15870000000,
        "HDI": 0.487,
        "ISO 3166-1": {"alpha-2": "MG", "alpha-3": "MDG", "numeric": "450"},
    },
    "Malawi": {
        "formal name": "Republic of Malawi",
        "continents": ["Africa"],
        "area": 118484.0,
        "land area": 94080.0,
        "population": 20734262,
        "official languages": ["English"],
        "nominal GDP": 12627000000,
        "HDI": 0.517,
        "ISO 3166-1": {"alpha-2": "MW", "alpha-3": "MWI", "numeric": "454"},
    },
    "Malaysia": {
        "formal name": "Malaysia",
        "continents": ["Asia"],
        "area": 330621.0,
        "land area": 329432.0,
        "population": 34192800,
        "official languages": ["Malaysian Malay"],
        "nominal GDP": 399649000000,
        "HDI": 0.819,
        "ISO 3166-1": {"alpha-2": "MY", "alpha-3": "MYS", "numeric": "458"},
    },
    "Maldives": {
        "formal name": "Republic of Maldives",
        "continents": ["Asia"],
        "area": 300.0,
        "land area": 300.0,
        "population": 515132,
        "official languages": ["Maldivian"],
        "nominal GDP": 6591000000,
        "HDI": 0.766,
        "ISO 3166-1": {"alpha-2": "MV", "alpha-3": "MDV", "numeric": "462"},
    },
    "Mali": {
        "formal name": "Republic of Mali",
        "continents": ["Africa"],
        "area": 1240192.0,
        "land area": 1220190.0,
        "population": 22395489,
        "official languages": ["Bambara", "Bobo", "Bozo", "Dogon", "Fula", "Hassaniya", "Kassonke", "Maninka", "Minyaka", "Senufo", "Songhay languages", "Soninke", "Tamasheq"],
        "nominal GDP": 20662000000,
        "HDI": 0.419,
        "ISO 3166-1": {"alpha-2": "ML", "alpha-3": "MLI", "numeric": "466"},
    },
    "Malta": {
        "formal name": "Republic of Malta",
        "continents": ["Europe"],
        "area": 315.0,
        "land area": 315.0,
        "population": 563443,
        "official languages": ["Maltese", "English"],
        "nominal GDP": 22212000000,
        "HDI": 0.924,
        "ISO 3166-1": {"alpha-2": "MT", "alpha-3": "MLT", "numeric": "470"},
    },
    "Marshall Islands": {
        "formal name": "Republic of the Marshall Islands",
        "continents": ["Oceania"],
        "area": 181.0,
        "land area": 180.0,
        "population": 42418,
        "official languages": ["English", "Marshallese"],
        "nominal GDP": 270000000,
        "HDI": 0.733,
        "ISO 3166-1": {"alpha-2": "MH", "alpha-3": "MHL", "numeric": "584"},
    },
    "Mauritania": {
        "formal name": "Islamic Republic of Mauritania",
        "continents": ["Africa"],
        "area": 1030700.0,
        "land area": 1030700.0,
        "population": 4927532,
        "official languages": ["Arabic"],
        "nominal GDP": 10652000000,
        "HDI": 0.563,
        "ISO 3166-1": {"alpha-2": "MR", "alpha-3": "MRT", "numeric": "478"},
    },
    "Mauritius": {
        "formal name": "Republic of Mauritius",
        "continents": ["Africa"],
        "area": 2096.0,
        "land area": 2086.0,
        "population": 1244477,
        "official languages": [],
        "nominal GDP": 14397000000,
        "HDI": 0.806,
        "ISO 3166-1": {"alpha-2": "MU", "alpha-3": "MUS", "numeric": "480"},
    },
    "Mexico": {
        "formal name": "United Mexican States",
        "continents": ["North America"],
        "area": 1964375.0,
        "land area": 1943950.0,
        "population": 130417144,
        "official languages": [],
        "nominal GDP": 1793799000000,
        "HDI": 0.789,
        "ISO 3166-1": {"alpha-2": "MX", "alpha-3": "MEX", "numeric": "484"},
    },
    "Micronesia": {
        "formal name": "Federated States of Micronesia",
        "continents": ["Oceania"],
        "area": 702.0,
        "land area": 700.0,
        "population": 105754,
        "official languages": ["English"],
        "nominal GDP": 460000000,
        "HDI": 0.615,
        "ISO 3166-1": {"alpha-2": "FM", "alpha-3": "FSM", "numeric": "583"},
    },
    "Moldova": {
        "formal name": "Republic of Moldova",
        "continents": ["Europe"],
        "area": 33847.0,
        "land area": 32970.0,
        "population": 2381300,
        "official languages": ["Romanian"],
        "nominal GDP": 16542000000,
        "HDI": 0.785,
        "ISO 3166-1": {"alpha-2": "MD", "alpha-3": "MDA", "numeric": "498"},
    },
    "Monaco": {
        "formal name": "Principality of Monaco",
        "continents": ["Europe"],
        "area": 2.0,
        "land area": 2.0,
        "population": 38423,
        "official languages": ["French"],
        "nominal GDP": 9995000000,
        "HDI": 0,
        "ISO 3166-1": {"alpha-2": "MC", "alpha-3": "MCO", "numeric": "492"},
    },
    "Mongolia": {
        "formal name": "Mongolia",
        "continents": ["Asia"],
        "area": 1564116.0,
        "land area": 1557507.0,
        "population": 3544835,
        "official languages": ["Mongolian"],
        "nominal GDP": 19872000000,
        "HDI": 0.747,
        "ISO 3166-1": {"alpha-2": "MN", "alpha-3": "MNG", "numeric": "496"},
    },
    "Montenegro": {
        "formal name": "Montenegro",
        "continents": ["Europe"],
        "area": 13812.0,
        "land area": 13452.0,
        "population": 623327,
        "official languages": ["Montenegrin"],
        "nominal GDP": 7530000000,
        "HDI": 0.862,
        "ISO 3166-1": {"alpha-2": "ME", "alpha-3": "MNE", "numeric": "499"},
    },
    "Morocco": {
        "formal name": "Kingdom of Morocco",
        "continents": ["Africa"],
        "area": 446550.0,
        "land area": 446300.0,
        "population": 36828330,
        "official languages": ["Arabic", "Berber languages"],
        "nominal GDP": 144438000000,
        "HDI": 0.710,
        "ISO 3166-1": {"alpha-2": "MA", "alpha-3": "MAR", "numeric": "504"},
    },
    "Mozambique": {
        "formal name": "Republic of Mozambique",
        "continents": ["Africa"],
        "area": 799380.0,
        "land area": 786380.0,
        "population": 33244414,
        "official languages": ["Portuguese"],
        "nominal GDP": 20954000000,
        "HDI": 0.493,
        "ISO 3166-1": {"alpha-2": "MZ", "alpha-3": "MOZ", "numeric": "508"},
    },
    "Myanmar": {
        "formal name": "Republic of the Union of Myanmar",
        "continents": ["Asia"],
        "area": 676578.0,
        "land area": 653508.0,
        "population": 51316756,
        "official languages": ["Burmese"],
        "nominal GDP": 62084000000,
        "HDI": 0.609,
        "ISO 3166-1": {"alpha-2": "MM", "alpha-3": "MMR", "numeric": "104"},
    },
    # N
    "Namibia": {
        "formal name": "Republic of Namibia",
        "continents": ["Africa"],
        "area": 824292.0,
        "land area": 823290.0,
        "population": 3022401,
        "official languages": ["English"],
        "nominal GDP": 12351000000,
        "HDI": 0.665,
        "ISO 3166-1": {"alpha-2": "NA", "alpha-3": "NAM", "numeric": "516"},
    },
    "Nauru": {
        "formal name": "Republic of Nauru",
        "continents": ["Oceania"],
        "area": 21.0,
        "land area": 20.0,
        "population": 11680,
        "official languages": ["English", "Nauruan"],
        "nominal GDP": 176000000,
        "HDI": 0.703,
        "ISO 3166-1": {"alpha-2": "NR", "alpha-3": "NRU", "numeric": "520"},
    },
    "Nepal": {
        "formal name": "Federal Democratic Republic of Nepal",
        "continents": ["Asia"],
        "area": 147181.0,
        "land area": 143350.0,
        "population": 29164578,
        "official languages": ["Nepali"],
        "nominal GDP": 40484000000,
        "HDI": 0.622,
        "ISO 3166-1": {"alpha-2": "NP", "alpha-3": "NPL", "numeric": "524"},
    },
    "Netherlands": {
        "formal name": "Kingdom of the Netherlands",
        "continents": ["Europe"],
        "area": 41865.0,
        "land area": 33893.0,
        "population": 18077662,
        "official languages": ["Dutch"],
        "nominal GDP": 1154361000000,
        "HDI": 0.955,
        "ISO 3166-1": {"alpha-2": "NL", "alpha-3": "NLD", "numeric": "528"},
    },
    "New Zealand": {
        "formal name": "New Zealand",
        "continents": ["Oceania"],
        "area": 268838.0,
        "land area": 264537.0,
        "population": 5330600,
        "official languages": ["Māori", "New Zealand Sign Language"],
        "nominal GDP": 252176000000,
        "HDI": 0.938,
        "ISO 3166-1": {"alpha-2": "NZ", "alpha-3": "NZL", "numeric": "554"},
    },
    "Nicaragua": {
        "formal name": "Republic of Nicaragua",
        "continents": ["North America"],
        "area": 130373.0,
        "land area": 120340.0,
        "population": 6803886,
        "official languages": ["Spanish"],
        "nominal GDP": 17829000000,
        "HDI": 0.706,
        "ISO 3166-1": {"alpha-2": "NI", "alpha-3": "NIC", "numeric": "558"},
    },
    "Niger": {
        "formal name": "Republic of the Niger",
        "continents": ["Africa"],
        "area": 1267000.0,
        "land area": 1266700.0,
        "population": 26312034,
        "official languages": ["Hausa"],
        "nominal GDP": 16819000000,
        "HDI": 0.419,
        "ISO 3166-1": {"alpha-2": "NE", "alpha-3": "NER", "numeric": "562"},
    },
    "Nigeria": {
        "formal name": "Federal Republic of Nigeria",
        "continents": ["Africa"],
        "area": 923768.0,
        "land area": 910770.0,
        "population": 223800000,
        "official languages": ["English"],
        "nominal GDP": 374984000000,
        "HDI": 0.560,
        "ISO 3166-1": {"alpha-2": "NG", "alpha-3": "NGA", "numeric": "566"},
    },
    "North Korea": {
        "formal name": "Democratic People's Republic of Korea",
        "continents": ["Asia"],
        "area": 120538.0,
        "land area": 120410.0,
        "population": 25950000,
        "official languages": ["Korean"],
        "nominal GDP": 16447000000,
        "HDI": 0,
        "ISO 3166-1": {"alpha-2": "KP", "alpha-3": "PRK", "numeric": "408"},
    },
    "North Macedonia": {
        "formal name": "Republic of North Macedonia",
        "continents": ["Europe"],
        "area": 25713.0,
        "land area": 25220.0,
        "population": 1826247,
        "official languages": ["Macedonian", "Albanian"],
        "nominal GDP": 15764000000,
        "HDI": 0.815,
        "ISO 3166-1": {"alpha-2": "MK", "alpha-3": "MKD", "numeric": "807"},
    },
    "Norway": {
        "formal name": "Kingdom of Norway",
        "continents": ["Europe"],
        "area": 386224.0,
        "land area": 366704.0,
        "population": 5601049,
        "official languages": ["Norwegian", "Sámi languages"],
        "nominal GDP": 485311000000,
        "HDI": 0.970,
        "ISO 3166-1": {"alpha-2": "NO", "alpha-3": "NOR", "numeric": "578"},
    },
    # O
    "Oman": {
        "formal name": "Sultanate of Oman",
        "continents": ["Asia"],
        "area": 309500.0,
        "land area": 309500.0,
        "population": 5286172,
        "official languages": ["Arabic"],
        "nominal GDP": 105896000000,
        "HDI": 0.858,
        "ISO 3166-1": {"alpha-2": "OM", "alpha-3": "OMN", "numeric": "512"},
    },
    # P
    "Pakistan": {
        "formal name": "Islamic Republic of Pakistan",
        "continents": ["Asia"],
        "area": 882363.0,
        "land area": 857143.0,
        "population": 241499431,
        "official languages": ["Urdu", "English"],
        "nominal GDP": 299864000000,
        "HDI": 0.544,
        "ISO 3166-1": {"alpha-2": "PK", "alpha-3": "PAK", "numeric": "586"},
    },
    "Palau": {
        "formal name": "Republic of Palau",
        "continents": ["Oceania"],
        "area": 459.0,
        "land area": 459.0,
        "population": 16733,
        "official languages": ["English", "Palauan"],
        "nominal GDP": 282000000,
        "HDI": 0.786,
        "ISO 3166-1": {"alpha-2": "PW", "alpha-3": "PLW", "numeric": "585"},
    },
    "Palestine": {
        "formal name": "State of Palestine",
        "continents": ["Asia"],
        "area": 6020.0,
        "land area": 6025.0,
        "population": 5483450,
        "official languages": ["Arabic"],
        "nominal GDP": 17396000000,
        "HDI": 0.674,
        "ISO 3166-1": {"alpha-2": "PS", "alpha-3": "PSE", "numeric": "275"},
    },
    "Panama": {
        "formal name": "Republic of Panama",
        "continents": ["North America", "South America"],
        "area": 75320.0,
        "land area": 74180.0,
        "population": 4064780,
        "official languages": ["Spanish"],
        "nominal GDP": 83382000000,
        "HDI": 0.839,
        "ISO 3166-1": {"alpha-2": "PA", "alpha-3": "PAN", "numeric": "591"},
    },
    "Papua New Guinea": {
        "formal name": "Independent State of Papua New Guinea",
        "continents": ["Oceania"],
        "area": 462840.0,
        "land area": 452860.0,
        "population": 11781559,
        "official languages": ["English", "Hiri Motu", "Papua New Guinean Sign Language", "Tok Pisin"],
        "nominal GDP": 31020000000,
        "HDI": 0.576,
        "ISO 3166-1": {"alpha-2": "PG", "alpha-3": "PNG", "numeric": "598"},
    },
    "Paraguay": {
        "formal name": "Republic of Paraguay",
        "continents": ["South America"],
        "area": 406752.0,
        "land area": 397300.0,
        "population": 6109644,
        "official languages": ["Spanish", "Guaraní"],
        "nominal GDP": 42955000000,
        "HDI": 0.756,
        "ISO 3166-1": {"alpha-2": "PY", "alpha-3": "PRY", "numeric": "600"},
    },
    "Peru": {
        "formal name": "Republic of Peru",
        "continents": ["South America"],
        "area": 1285216.0,
        "land area": 1279996.0,
        "population": 34350244,
        "official languages": ["Spanish"],
        "nominal GDP": 267603000000,
        "HDI": 0.794,
        "ISO 3166-1": {"alpha-2": "PE", "alpha-3": "PER", "numeric": "604"},
    },
    "Philippines": {
        "formal name": "Republic of the Philippines",
        "continents": ["Asia"],
        "area": 300000.0,
        "land area": 298170.0,
        "population": 114123600,
        "official languages": ["Filipino", "English"],
        "nominal GDP": 437146000000,
        "HDI": 0.720,
        "ISO 3166-1": {"alpha-2": "PH", "alpha-3": "PHL", "numeric": "608"},
    },
    "Poland": {
        "formal name": "Republic of Poland",
        "continents": ["Europe"],
        "area": 312685.0,
        "land area": 304255.0,
        "population": 37423000,
        "official languages": ["Polish"],
        "nominal GDP": 809201000000,
        "HDI": 0.906,
        "ISO 3166-1": {"alpha-2": "PL", "alpha-3": "POL", "numeric": "616"},
    },
    "Portugal": {
        "formal name": "Portuguese Republic",
        "continents": ["Europe"],
        "area": 92225.0,
        "land area": 91606.0,
        "population": 10749635,
        "official languages": ["Portuguese"],
        "nominal GDP": 289114000000,
        "HDI": 0.890,
        "ISO 3166-1": {"alpha-2": "PT", "alpha-3": "PRT", "numeric": "620"},
    },
    # Q
    "Qatar": {
        "formal name": "State of Qatar",
        "continents": ["Asia"],
        "area": 11586.0,
        "land area": 11586.0,
        "population": 2857822,
        "official languages": ["Arabic"],
        "nominal GDP": 213003000000,
        "HDI": 0.886,
        "ISO 3166-1": {"alpha-2": "QA", "alpha-3": "QAT", "numeric": "634"},
    },
    # R
    "Republic of the Congo": {
        "formal name": "",
        "continents": ["Africa"],
        "area": 342000.0,
        "land area": 341500.0,
        "population": 6142180,
        "official languages": ["French"],
        "nominal GDP": 14167000000,
        "HDI": 0.,
        "ISO 3166-1": {"alpha-2": "CG", "alpha-3": "COG", "numeric": "178"},
    },
    "Romania": {
        "formal name": "Romania",
        "continents": ["Europe"],
        "area": 238398.0,
        "land area": 230080.0,
        "population": 19064409,
        "official languages": ["Romanian"],
        "nominal GDP": 350776000000,
        "HDI": 0.845,
        "ISO 3166-1": {"alpha-2": "RO", "alpha-3": "ROU", "numeric": "642"},
    },
    "Russia": {
        "formal name": "Russian Federation",
        "continents": ["Asia", "Europe"],
        "area": 17098246.0,
        "land area": 16376870.0,
        "population": 146028325,
        "official languages": ["Russian"],
        "nominal GDP": 2008419000000,
        "HDI": 0.832,
        "ISO 3166-1": {"alpha-2": "RU", "alpha-3": "RUS", "numeric": "643"},
    },
    "Rwanda": {
        "formal name": "Republic of Rwanda",
        "continents": ["Africa"],
        "area": 26338.0,
        "land area": 24670.0,
        "population": 14104969,
        "official languages": ["English", "French", "Kinyarwanda", "Swahili"],
        "nominal GDP": 14097000000,
        "HDI": 0.578,
        "ISO 3166-1": {"alpha-2": "RW", "alpha-3": "RWA", "numeric": "646"},
    },
    # S
    "Saint Kitts and Nevis": {
        "formal name": "Federation of Saint Christopher and Nevis",
        "continents": ["North America"],
        "area": 261.0,
        "land area": 261.0,
        "population": 51320,
        "official languages": ["English"],
        "nominal GDP": 1058000000,
        "HDI": 0.840,
        "ISO 3166-1": {"alpha-2": "KN", "alpha-3": "KNA", "numeric": "659"},
    },
    "Saint Lucia": {
        "formal name": "Saint Lucia",
        "continents": ["North America"],
        "area": 616.0,
        "land area": 610.0,
        "population": 184100,
        "official languages": ["English"],
        "nominal GDP": 2430000000,
        "HDI": 0.748,
        "ISO 3166-1": {"alpha-2": "LC", "alpha-3": "LCA", "numeric": "662"},
    },
    "Saint Vincent and the Grenadines": {
        "formal name": "Saint Vincent and the Grenadines",
        "continents": ["North America"],
        "area": 389.0,
        "land area": 389.0,
        "population": 110872,
        "official languages": ["English"],
        "nominal GDP": 1091000000,
        "HDI": 0.798,
        "ISO 3166-1": {"alpha-2": "VC", "alpha-3": "VCT", "numeric": "670"},
    },
    "Samoa": {
        "formal name": "Independent State of Samoa",
        "continents": ["Oceania"],
        "area": 2842.0,
        "land area": 2780.0,
        "population": 205557,
        "official languages": ["English", "Samoan"],
        "nominal GDP": 1032000000,
        "HDI": 0.708,
        "ISO 3166-1": {"alpha-2": "WS", "alpha-3": "WSM", "numeric": "882"},
    },
    "San Marino": {
        "formal name": "Republic of San Marino",
        "continents": ["Europe"],
        "area": 61.0,
        "land area": 61.0,
        "population": 34062,
        "official languages": ["Italian"],
        "nominal GDP": 1987000000,
        "HDI": 0.915,
        "ISO 3166-1": {"alpha-2": "SM", "alpha-3": "SMR", "numeric": "674"},
    },
    "Saudi Arabia": {
        "formal name": "Kingdom of Saudi Arabia",
        "continents": ["Asia"],
        "area": 2149690.0,
        "land area": 2149690.0,
        "population": 35300280,
        "official languages": ["Arabic"],
        "nominal GDP": 1067583000000,
        "HDI": 0.900,
        "ISO 3166-1": {"alpha-2": "SA", "alpha-3": "SAU", "numeric": "682"},
    },
    "Senegal": {
        "formal name": "Republic of Senegal",
        "continents": ["Africa"],
        "area": 196712.0,
        "land area": 192530.0,
        "population": 18126390,
        "official languages": ["French"],
        "nominal GDP": 30408000000,
        "HDI": 0.530,
        "ISO 3166-1": {"alpha-2": "SN", "alpha-3": "SEN", "numeric": "686"},
    },
    "Serbia": {
        "formal name": "Republic of Serbia",
        "continents": ["Europe"],
        "area": 88499.0,
        "land area": 88499.0,
        "population": 6567783,
        "official languages": ["Serbian"],
        "nominal GDP": 75187000000,
        "HDI": 0.833,
        "ISO 3166-1": {"alpha-2": "RS", "alpha-3": "SRB", "numeric": "688"},
    },
    "Seychelles": {
        "formal name": "Republic of Seychelles",
        "continents": ["Africa"],
        "area": 457.0,
        "land area": 457.0,
        "population": 122038,
        "official languages": ["English", "French", "Seychellois Creole"],
        "nominal GDP": 2141000000,
        "HDI": 0.848,
        "ISO 3166-1": {"alpha-2": "SC", "alpha-3": "SYC", "numeric": "690"},
    },
    "Sierra Leone": {
        "formal name": "Republic of Sierra Leone",
        "continents": ["Africa"],
        "area": 72300.0,
        "land area": 72180.0,
        "population": 8884032,
        "official languages": ["English"],
        "nominal GDP": 6412000000,
        "HDI": 0.467,
        "ISO 3166-1": {"alpha-2": "SL", "alpha-3": "SLE", "numeric": "694"},
    },
    "Singapore": {
        "formal name": "Republic of Singapore",
        "continents": ["Asia"],
        "area": 736.0,
        "land area": 726.0,
        "population": 6036900,
        "official languages": ["Singapore English", "Malay", "Singaporean Mandarin", "Singaporean Tamil"],
        "nominal GDP": 501428000000,
        "HDI": 0.946,
        "ISO 3166-1": {"alpha-2": "SG", "alpha-3": "SGP", "numeric": "702"},
    },
    "Slovakia": {
        "formal name": "Slovak Republic",
        "continents": ["Europe"],
        "area": 49035.0,
        "land area": 48080.0,
        "population": 5415978,
        "official languages": ["Slovak"],
        "nominal GDP": 132908000000,
        "HDI": 0.880,
        "ISO 3166-1": {"alpha-2": "SK", "alpha-3": "SVK", "numeric": "703"},
    },
    "Slovenia": {
        "formal name": "Republic of Slovenia",
        "continents": ["Europe"],
        "area": 20273.0,
        "land area": 20151.0,
        "population": 2130850,
        "official languages": ["Slovene"],
        "nominal GDP": 69148000000,
        "HDI": 0.931,
        "ISO 3166-1": {"alpha-2": "SI", "alpha-3": "SVN", "numeric": "705"},
    },
    "Solomon Islands": {
        "formal name": "Solomon Islands",
        "continents": ["Oceania"],
        "area": 28896.0,
        "land area": 27990.0,
        "population": 750325,
        "official languages": ["English"],
        "nominal GDP": 1633000000,
        "HDI": 0.584,
        "ISO 3166-1": {"alpha-2": "SB", "alpha-3": "SLB", "numeric": "090"},
    },
    "Somalia": {
        "formal name": "Federal Republic of Somalia",
        "continents": ["Africa"],
        "area": 637657.0,
        "land area": 627340.0,
        "population": 19009151,
        "official languages": ["Somali", "Arabic"],
        "nominal GDP": 10969000000,
        "HDI": 0.404,
        "ISO 3166-1": {"alpha-2": "SO", "alpha-3": "SOM", "numeric": "706"},
    },
    "South Africa": {
        "formal name": "Republic of South Africa",
        "continents": ["Africa"],
        "area": 1219090.0,
        "land area": 1214470.0,
        "population": 63015904,
        "official languages": ["Afrikaans", "South African English", "Southern Ndebele", "Sotho", "Northern Sotho", "Swazi", "Tsonga", "Tswana", "Venḓa", "Xhosa", "Zulu", "South African Sign Language"],
        "nominal GDP": 377782000000,
        "HDI": 0.741,
        "ISO 3166-1": {"alpha-2": "ZA", "alpha-3": "ZAF", "numeric": "710"},
    },
    "South Korea": {
        "formal name": "Republic of Korea",
        "continents": ["Asia"],
        "area": 100432.0,
        "land area": 97600.0,
        "population": 51164582,
        "official languages": ["Korean", "Korean Sign Language"],
        "nominal GDP": 1839058000000,
        "HDI": 0.937,
        "ISO 3166-1": {"alpha-2": "KR", "alpha-3": "KOR", "numeric": "410"},
    },
    "South Sudan": {
        "formal name": "Republic of South Sudan",
        "continents": ["Africa"],
        "area": 644329.0,
        "land area": 631930.0,
        "population": 15786898,
        "official languages": ["English"],
        "nominal GDP": 4629000000,
        "HDI": 0.388,
        "ISO 3166-1": {"alpha-2": "SS", "alpha-3": "SSD", "numeric": "728"},
    },
    "Spain": {
        "formal name": "Kingdom of Spain",
        "continents": ["Europe"],
        "area": 505370.0,
        "land area": 498980.0,
        "population": 49153849,
        "official languages": ["Spanish"],
        "nominal GDP": 1620091000000,
        "HDI": 0.918,
        "ISO 3166-1": {"alpha-2": "ES", "alpha-3": "ESP", "numeric": "724"},
    },
    "Sri Lanka": {
        "formal name": "Democratic Socialist Republic of Sri Lanka",
        "continents": ["Asia"],
        "area": 65610.0,
        "land area": 61860.0,
        "population": 21763170,
        "official languages": ["Sinhala", "Tamil"],
        "nominal GDP": 84364000000,
        "HDI": 0.776,
        "ISO 3166-1": {"alpha-2": "LK", "alpha-3": "LKA", "numeric": "144"},
    },
    "Sudan": {
        "formal name": "Republic of the Sudan",
        "continents": ["Africa"],
        "area": 1861484.0,
        "land area": 1731671.0,
        "population": 50448963,
        "official languages": ["Arabic", "English"],
        "nominal GDP": 34021000000,
        "HDI": 0.511,
        "ISO 3166-1": {"alpha-2": "SD", "alpha-3": "SDN", "numeric": "729"},
    },
    "Suriname": {
        "formal name": "Republic of Suriname",
        "continents": ["South America"],
        "area": 163820.0,
        "land area": 156000.0,
        "population": 616500,
        "official languages": ["Dutch"],
        "nominal GDP": 3759000000,
        "HDI": 0.722,
        "ISO 3166-1": {"alpha-2": "SR", "alpha-3": "SUR", "numeric": "740"},
    },
    "Sweden": {
        "formal name": "Kingdom of Sweden",
        "continents": ["Europe"],
        "area": 450295.0,
        "land area": 407284.0,
        "population": 10588818,
        "official languages": ["Swedish"],
        "nominal GDP": 584960000000,
        "HDI": 0.959,
        "ISO 3166-1": {"alpha-2": "SE", "alpha-3": "SWE", "numeric": "752"},
    },
    "Switzerland": {
        "formal name": "Swiss Confederation",
        "continents": ["Europe"],
        "area": 41291.0,
        "land area": 39510.0,
        "population": 9067144,
        "official languages": ["French", "German", "Italian", "Romansh"],
        "nominal GDP": 894425000000,
        "HDI": 0.970,
        "ISO 3166-1": {"alpha-2": "CH", "alpha-3": "CHE", "numeric": "756"},
    },
    "Syria": {
        "formal name": "Syrian Arab Republic",
        "continents": ["Asia"],
        "area": 185180.0,
        "land area": 183630.0,
        "population": 24672760,
        "official languages": ["Arabic"],
        "nominal GDP": 29028000000,
        "HDI": 0.564,
        "ISO 3166-1": {"alpha-2": "SY", "alpha-3": "SYR", "numeric": "760"},
    },
    "São Tomé and Príncipe": {
        "formal name": "Democratic Republic of São Tomé and Príncipe",
        "continents": ["Africa"],
        "area": 964.0,
        "land area": 964.0,
        "population": 228319,
        "official languages": ["Portuguese"],
        "nominal GDP": 684000000,
        "HDI": 0.637,
        "ISO 3166-1": {"alpha-2": "ST", "alpha-3": "STP", "numeric": "678"},
    },
    # T
    "Tajikistan": {
        "formal name": "Republic of Tajikistan",
        "continents": ["Asia"],
        "area": 144100.0,
        "land area": 141510.0,
        "population": 10499000,
        "official languages": ["Tajik"],
        "nominal GDP": 12061000000,
        "HDI": 0.691,
        "ISO 3166-1": {"alpha-2": "TJ", "alpha-3": "TJK", "numeric": "762"},
    },
    "Tanzania": {
        "formal name": "United Republic of Tanzania",
        "continents": ["Africa"],
        "area": 947303.0,
        "land area": 885800.0,
        "population": 68153004,
        "official languages": ["Swahili", "English"],
        "nominal GDP": 78353000000,
        "HDI": 0.555,
        "ISO 3166-1": {"alpha-2": "TZ", "alpha-3": "TZA", "numeric": "834"},
    },
    "Thailand": {
        "formal name": "Kingdom of Thailand",
        "continents": ["Asia"],
        "area": 513120.0,
        "land area": 510890.0,
        "population": 65870610,
        "official languages": ["Thai"],
        "nominal GDP": 514945000000,
        "HDI": 0.798,
        "ISO 3166-1": {"alpha-2": "TH", "alpha-3": "THA", "numeric": "764"},
    },
    "Timor-Leste": {
        "formal name": "Democratic Republic of Timor-Leste",
        "continents": ["Asia"],
        "area": 14874.0,
        "land area": 14874.0,
        "population": 1373024,
        "official languages": ["Portuguese", "Tetum"],
        "nominal GDP": 2080000000,
        "HDI": 0.634,
        "ISO 3166-1": {"alpha-2": "TL", "alpha-3": "TLS", "numeric": "626"},
    },
    "Togo": {
        "formal name": "Togolese Republic",
        "continents": ["Africa"],
        "area": 56785.0,
        "land area": 54390.0,
        "population": 8095498,
        "official languages": ["French"],
        "nominal GDP": 9278000000,
        "HDI": 0.571,
        "ISO 3166-1": {"alpha-2": "TG", "alpha-3": "TGO", "numeric": "768"},
    },
    "Tonga": {
        "formal name": "Kingdom of Tonga",
        "continents": ["Oceania"],
        "area": 747.0,
        "land area": 720.0,
        "population": 100179,
        "official languages": ["English", "Tongan"],
        "nominal GDP": 508000000,
        "HDI": 0.769,
        "ISO 3166-1": {"alpha-2": "TO", "alpha-3": "TON", "numeric": "776"},
    },
    "Trinidad and Tobago": {
        "formal name": "Republic of Trinidad and Tobago",
        "continents": ["North America"],
        "area": 5127.0,
        "land area": 5127.0,
        "population": 1368333,
        "official languages": ["English"],
        "nominal GDP": 25489000000,
        "HDI": 0.807,
        "ISO 3166-1": {"alpha-2": "TT", "alpha-3": "TTO", "numeric": "780"},
    },
    "Tunisia": {
        "formal name": "Republic of Tunisia",
        "continents": ["Africa"],
        "area": 163610.0,
        "land area": 155360.0,
        "population": 11972169,
        "official languages": ["Arabic"],
        "nominal GDP": 48541000000,
        "HDI": 0.746,
        "ISO 3166-1": {"alpha-2": "TN", "alpha-3": "TUN", "numeric": "788"},
    },
    "Turkey": {
        "formal name": "Republic of Türkiye",
        "continents": ["Asia", "Europe"],
        "area": 783562.0,
        "land area": 769632.0,
        "population": 85664944,
        "official languages": ["Turkish"],
        "nominal GDP": 1118253000000,
        "HDI": 0.853,
        "ISO 3166-1": {"alpha-2": "TR", "alpha-3": "TUR", "numeric": "792"},
    },
    "Turkmenistan": {
        "formal name": "Turkmenistan",
        "continents": ["Asia"],
        "area": 488100.0,
        "land area": 469930.0,
        "population": 7057841,
        "official languages": ["Turkmen"],
        "nominal GDP": 59887000000,
        "HDI": 0.764,
        "ISO 3166-1": {"alpha-2": "TM", "alpha-3": "TKM", "numeric": "795"},
    },
    "Tuvalu": {
        "formal name": "Tuvalu",
        "continents": ["Oceania"],
        "area": 25.0,
        "land area": 25.0,
        "population": 10643,
        "official languages": ["Tuvaluan", "English"],
        "nominal GDP": 68000000,
        "HDI": 0.689,
        "ISO 3166-1": {"alpha-2": "TV", "alpha-3": "TUV", "numeric": "798"},
    },
    "Uganda": {
        "formal name": "Republic of Uganda",
        "continents": ["Africa"],
        "area": 241550.0,
        "land area": 200520.0,
        "population": 45905417,
        "official languages": ["English", "Swahili"],
        "nominal GDP": 51023000000,
        "HDI": 0.582,
        "ISO 3166-1": {"alpha-2": "UG", "alpha-3": "UGA", "numeric": "800"},
    },
    "Ukraine": {
        "formal name": "Ukraine",
        "continents": ["Europe"],
        "area": 603550.0,
        "land area": 579330.0,
        "population": 32862000,
        "official languages": ["Ukrainian"],
        "nominal GDP": 178757000000,
        "HDI": 0.779,
        "ISO 3166-1": {"alpha-2": "UA", "alpha-3": "UKR", "numeric": "804"},
    },
    "United Arab Emirates": {
        "formal name": "United Arab Emirates",
        "continents": ["Asia"],
        "area": 83600.0,
        "land area": 82880.0,
        "population": 10678556,
        "official languages": ["Arabic"],
        "nominal GDP": 514130000000,
        "HDI": 0.940,
        "ISO 3166-1": {"alpha-2": "AE", "alpha-3": "ARE", "numeric": "784"},
    },
    "United Kingdom": {
        "formal name": "United Kingdom of Great Britain and Northern Ireland",
        "continents": ["Europe"],
        "area": 244376.0,
        "land area": 242741.0,
        "population": 68265209,
        "official languages": [],
        "nominal GDP": 3380855000000,
        "HDI": 0.946,
        "ISO 3166-1": {"alpha-2": "GB", "alpha-3": "GBR", "numeric": "826"},
    },
    "United States": {
        "formal name": "United States of America",
        "continents": ["North America"],
        "area": 9525067.0,
        "land area": 9147593.0,
        "population": 340110988,
        "official languages": [],
        "nominal GDP": 27720700000000,
        "HDI": 0.938,
        "ISO 3166-1": {"alpha-2": "US", "alpha-3": "USA", "numeric": "840"},
    },
    "Uruguay": {
        "formal name": "Oriental Republic of Uruguay",
        "continents": ["South America"],
        "area": 176215.0,
        "land area": 175015.0,
        "population": 3499451,
        "official languages": ["Uruguayan Sign Language"],
        "nominal GDP": 77236000000,
        "HDI": 0.862,
        "ISO 3166-1": {"alpha-2": "UY", "alpha-3": "URY", "numeric": "858"},
    },
    "Uzbekistan": {
        "formal name": "Republic of Uzbekistan",
        "continents": ["Asia"],
        "area": 447400.0,
        "land area": 425400.0,
        "population": 37860975,
        "official languages": ["Uzbek"],
        "nominal GDP": 90889000000,
        "HDI": 0.740,
        "ISO 3166-1": {"alpha-2": "UZ", "alpha-3": "UZB", "numeric": "860"},
    },
    "Vanuatu": {
        "formal name": "Republic of Vanuatu",
        "continents": ["Oceania"],
        "area": 12189.0,
        "land area": 12189.0,
        "population": 321409,
        "official languages": ["English", "French", "Bislama"],
        "nominal GDP": 1119000000,
        "HDI": 0.621,
        "ISO 3166-1": {"alpha-2": "VU", "alpha-3": "VUT", "numeric": "798"},
    },
    "Vatican City": {
        "formal name": "Vatican City State",
        "continents": ["Europe"],
        "area": 0.49,
        "land area": 0.49,
        "population": 882,
        "official languages": ["Italian", "Latin"],
        "nominal GDP": 17000000,
        "HDI": 0,
        "ISO 3166-1": {"alpha-2": "VA", "alpha-3": "VAT", "numeric": "336"},
    },
    "Venezuela": {
        "formal name": "Bolivarian Republic of Venezuela",
        "continents": ["South America"],
        "area": 912050.0,
        "land area": 882050.0,
        "population": 28405543,
        "official languages": ["Spanish"],
        "nominal GDP": 139395000000,
        "HDI": 0.709,
        "ISO 3166-1": {"alpha-2": "VE", "alpha-3": "VEN", "numeric": "862"},
    },
    "Vietnam": {
        "formal name": "Socialist Republic of Vietnam",
        "continents": ["Asia"],
        "area": 331340.0,
        "land area": 313429.0,
        "population": 101343800,
        "official languages": ["Vietnamese"],
        "nominal GDP": 429717000000,
        "HDI": 0.766,
        "ISO 3166-1": {"alpha-2": "VN", "alpha-3": "VNM", "numeric": "704"},
    },
    "Yemen": {
        "formal name": "Republic of Yemen",
        "continents": ["Asia"],
        "area": 455503.0,
        "land area": 455503.0,
        "population": 32684503,
        "official languages": ["Arabic"],
        "nominal GDP": 8758000000,
        "HDI": 0.470,
        "ISO 3166-1": {"alpha-2": "YE", "alpha-3": "YEM", "numeric": "887"},
    },
    "Zambia": {
        "formal name": "Republic of Zambia",
        "continents": ["Africa"],
        "area": 752612.0,
        "land area": 743390.0,
        "population": 19693423,
        "official languages": ["English"],
        "nominal GDP": 27578000000,
        "HDI": 0.595,
        "ISO 3166-1": {"alpha-2": "ZM", "alpha-3": "ZMB", "numeric": "894"},
    },
    "Zimbabwe": {
        "formal name": "Republic of Zimbabwe",
        "continents": ["Africa"],
        "area": 390757.0,
        "land area": 386850.0,
        "population": 16751469,
        "official languages": ["Chewa", "Sena", "English", "Kalanga", "Khoisan", "Nambya", "Ndau", "Northern Ndebele", "Tsonga", "Shona", "Sign languages", "Sotho", "Sotho", "Tswana", "Venḓa", "Xhosa"],
        "nominal GDP": 30368000000,
        "HDI": 0.598,
        "ISO 3166-1": {"alpha-2": "ZW", "alpha-3": "ZWE", "numeric": "716"},
    },
}
"""A dictionary contains all members and observer states of the United Nations and information about them:
- Formal name
- Continent(s) of the country's mainland, order: Asia, Europe, Africa, North America, South America, Oceania
- Area and land area (in square kilometre), source: https://en.wikipedia.org/wiki/List_of_countries_and_dependencies_by_area
- Population, source: https://en.wikipedia.org/wiki/List_of_countries_and_dependencies_by_population
- Official language(s), source: https://en.wikipedia.org/wiki/List_of_official_languages_by_country_and_territory
- Nominal GDP (in dollar), source: https://en.wikipedia.org/wiki/List_of_countries_by_GDP_(nominal); https://en.wikipedia.org/wiki/Vatican_City
- Human Development Index, source: https://en.wikipedia.org/wiki/List_of_countries_by_Human_Development_Index, excluding Monaco; North Korea and Vatican City
- ISO 3166-1 codes

Note: the dictionary might contain inaccuracies"""