# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSqlCollectionResult',
    'AwaitableGetSqlCollectionResult',
    'get_sql_collection',
    'get_sql_collection_output',
]

@pulumi.output_type
class GetSqlCollectionResult:
    """
    A collection of values returned by getSqlCollection.
    """
    def __init__(__self__, compartment_id=None, db_user_name=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, generate_sql_firewall_policy_trigger=None, id=None, lifecycle_details=None, purge_logs_trigger=None, refresh_log_insights_trigger=None, sql_collection_id=None, sql_level=None, start_trigger=None, state=None, status=None, stop_trigger=None, system_tags=None, target_id=None, time_created=None, time_last_started=None, time_last_stopped=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_user_name and not isinstance(db_user_name, str):
            raise TypeError("Expected argument 'db_user_name' to be a str")
        pulumi.set(__self__, "db_user_name", db_user_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generate_sql_firewall_policy_trigger and not isinstance(generate_sql_firewall_policy_trigger, bool):
            raise TypeError("Expected argument 'generate_sql_firewall_policy_trigger' to be a bool")
        pulumi.set(__self__, "generate_sql_firewall_policy_trigger", generate_sql_firewall_policy_trigger)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if purge_logs_trigger and not isinstance(purge_logs_trigger, bool):
            raise TypeError("Expected argument 'purge_logs_trigger' to be a bool")
        pulumi.set(__self__, "purge_logs_trigger", purge_logs_trigger)
        if refresh_log_insights_trigger and not isinstance(refresh_log_insights_trigger, bool):
            raise TypeError("Expected argument 'refresh_log_insights_trigger' to be a bool")
        pulumi.set(__self__, "refresh_log_insights_trigger", refresh_log_insights_trigger)
        if sql_collection_id and not isinstance(sql_collection_id, str):
            raise TypeError("Expected argument 'sql_collection_id' to be a str")
        pulumi.set(__self__, "sql_collection_id", sql_collection_id)
        if sql_level and not isinstance(sql_level, str):
            raise TypeError("Expected argument 'sql_level' to be a str")
        pulumi.set(__self__, "sql_level", sql_level)
        if start_trigger and not isinstance(start_trigger, bool):
            raise TypeError("Expected argument 'start_trigger' to be a bool")
        pulumi.set(__self__, "start_trigger", start_trigger)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if stop_trigger and not isinstance(stop_trigger, bool):
            raise TypeError("Expected argument 'stop_trigger' to be a bool")
        pulumi.set(__self__, "stop_trigger", stop_trigger)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_started and not isinstance(time_last_started, str):
            raise TypeError("Expected argument 'time_last_started' to be a str")
        pulumi.set(__self__, "time_last_started", time_last_started)
        if time_last_stopped and not isinstance(time_last_stopped, str):
            raise TypeError("Expected argument 'time_last_stopped' to be a str")
        pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the SQL collection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> str:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the SQL collection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the SQL collection.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="generateSqlFirewallPolicyTrigger")
    def generate_sql_firewall_policy_trigger(self) -> bool:
        return pulumi.get(self, "generate_sql_firewall_policy_trigger")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the SQL collection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the current state of the SQL collection in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="purgeLogsTrigger")
    def purge_logs_trigger(self) -> bool:
        return pulumi.get(self, "purge_logs_trigger")

    @property
    @pulumi.getter(name="refreshLogInsightsTrigger")
    def refresh_log_insights_trigger(self) -> bool:
        return pulumi.get(self, "refresh_log_insights_trigger")

    @property
    @pulumi.getter(name="sqlCollectionId")
    def sql_collection_id(self) -> str:
        return pulumi.get(self, "sql_collection_id")

    @property
    @pulumi.getter(name="sqlLevel")
    def sql_level(self) -> str:
        """
        Specifies the level of SQL that will be collected. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        """
        return pulumi.get(self, "sql_level")

    @property
    @pulumi.getter(name="startTrigger")
    def start_trigger(self) -> bool:
        return pulumi.get(self, "start_trigger")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the SQL collection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Specifies if the status of the SqlCollection. Enabled indicates that the collecting is in progress.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stopTrigger")
    def stop_trigger(self) -> bool:
        return pulumi.get(self, "stop_trigger")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the target corresponding to the security policy deployment.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time that the SQL collection was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> str:
        """
        The timestamp of the most recent SqlCollection start operation, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_started")

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> str:
        """
        The timestamp of the most recent SqlCollection stop operation, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_stopped")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The last date and time the SQL collection was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetSqlCollectionResult(GetSqlCollectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlCollectionResult(
            compartment_id=self.compartment_id,
            db_user_name=self.db_user_name,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            generate_sql_firewall_policy_trigger=self.generate_sql_firewall_policy_trigger,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            purge_logs_trigger=self.purge_logs_trigger,
            refresh_log_insights_trigger=self.refresh_log_insights_trigger,
            sql_collection_id=self.sql_collection_id,
            sql_level=self.sql_level,
            start_trigger=self.start_trigger,
            state=self.state,
            status=self.status,
            stop_trigger=self.stop_trigger,
            system_tags=self.system_tags,
            target_id=self.target_id,
            time_created=self.time_created,
            time_last_started=self.time_last_started,
            time_last_stopped=self.time_last_stopped,
            time_updated=self.time_updated)


def get_sql_collection(sql_collection_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlCollectionResult:
    """
    This data source provides details about a specific Sql Collection resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a SQL collection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_collection = oci.DataSafe.get_sql_collection(sql_collection_id=test_sql_collection_oci_data_safe_sql_collection["id"])
    ```


    :param str sql_collection_id: The OCID of the SQL collection resource.
    """
    __args__ = dict()
    __args__['sqlCollectionId'] = sql_collection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSqlCollection:getSqlCollection', __args__, opts=opts, typ=GetSqlCollectionResult).value

    return AwaitableGetSqlCollectionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_user_name=pulumi.get(__ret__, 'db_user_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        generate_sql_firewall_policy_trigger=pulumi.get(__ret__, 'generate_sql_firewall_policy_trigger'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        purge_logs_trigger=pulumi.get(__ret__, 'purge_logs_trigger'),
        refresh_log_insights_trigger=pulumi.get(__ret__, 'refresh_log_insights_trigger'),
        sql_collection_id=pulumi.get(__ret__, 'sql_collection_id'),
        sql_level=pulumi.get(__ret__, 'sql_level'),
        start_trigger=pulumi.get(__ret__, 'start_trigger'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        stop_trigger=pulumi.get(__ret__, 'stop_trigger'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_started=pulumi.get(__ret__, 'time_last_started'),
        time_last_stopped=pulumi.get(__ret__, 'time_last_stopped'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_sql_collection_output(sql_collection_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSqlCollectionResult]:
    """
    This data source provides details about a specific Sql Collection resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a SQL collection by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_collection = oci.DataSafe.get_sql_collection(sql_collection_id=test_sql_collection_oci_data_safe_sql_collection["id"])
    ```


    :param str sql_collection_id: The OCID of the SQL collection resource.
    """
    __args__ = dict()
    __args__['sqlCollectionId'] = sql_collection_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSqlCollection:getSqlCollection', __args__, opts=opts, typ=GetSqlCollectionResult)
    return __ret__.apply(lambda __response__: GetSqlCollectionResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_user_name=pulumi.get(__response__, 'db_user_name'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        generate_sql_firewall_policy_trigger=pulumi.get(__response__, 'generate_sql_firewall_policy_trigger'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        purge_logs_trigger=pulumi.get(__response__, 'purge_logs_trigger'),
        refresh_log_insights_trigger=pulumi.get(__response__, 'refresh_log_insights_trigger'),
        sql_collection_id=pulumi.get(__response__, 'sql_collection_id'),
        sql_level=pulumi.get(__response__, 'sql_level'),
        start_trigger=pulumi.get(__response__, 'start_trigger'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        stop_trigger=pulumi.get(__response__, 'stop_trigger'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_id=pulumi.get(__response__, 'target_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_started=pulumi.get(__response__, 'time_last_started'),
        time_last_stopped=pulumi.get(__response__, 'time_last_stopped'),
        time_updated=pulumi.get(__response__, 'time_updated')))
