"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../../lib");
const sqs = require("aws-cdk-lib/aws-sqs");
const sns = require("aws-cdk-lib/aws-sns");
const kms = require("aws-cdk-lib/aws-kms");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
stack.templateOptions.description = 'Integration Test for aws-sns-sqs Standard Queue';
stack.node.setContext("@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption", true);
// Definitions
const snsManagedKey = kms.Alias.fromAliasName(stack, 'sns-managed-key', 'alias/aws/sns');
const topic = new sns.Topic(stack, 'TestTopic', {
    displayName: 'Customer subscription topic',
    fifo: false,
    masterKey: snsManagedKey
});
const encryptionKeyProps = {
    enableKeyRotation: true,
    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
};
const existingQUeueKey = new kms.Key(stack, 'ImportedEncryptionKey', encryptionKeyProps);
const deadLetterQueueKey = new kms.Key(stack, 'ImportedDLQEncryptionKey', encryptionKeyProps);
const props = {
    encryptQueueWithCmk: true,
    existingQueueEncryptionKey: existingQUeueKey,
    existingTopicObj: topic,
    queueProps: {
        fifo: false,
    },
    deadLetterQueueProps: {
        encryption: sqs.QueueEncryption.KMS,
        fifo: false,
        encryptionMasterKey: deadLetterQueueKey
    },
};
new lib_1.SnsToSqs(stack, 'test-sns-sqs', props);
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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