"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../../lib");
const kms = require("aws-cdk-lib/aws-kms");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
stack.templateOptions.description = 'Integration Test for aws-sns-sqs with customer managed KMS key';
stack.node.setContext("@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption", true);
// Definitions
// Create a customer managed KMS CMK to encrypt the SNS Topic
const snsEncryptionKeyProps = {
    enableKeyRotation: true,
    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
};
const snsEncryptionKey = new kms.Key(stack, 'ImportedSNSEncryptionKey', snsEncryptionKeyProps);
// Create customer managed KMS CMK to encrypt the SQS Queue
const sqsEncryptionKeyProps = {
    enableKeyRotation: true,
    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
};
const sqsEncryptionKey = new kms.Key(stack, 'ImportedSQSEncryptionKey', sqsEncryptionKeyProps);
// Create the SNS to SQS construct
const props = {
    topicProps: {
        masterKey: snsEncryptionKey
    },
    queueProps: {
        encryptionMasterKey: sqsEncryptionKey
    },
    encryptQueueWithCmk: false,
    encryptTopicWithCmk: false
};
new lib_1.SnsToSqs(stack, 'test-sns-sqs', props);
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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