"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../../lib");
const kms = require("aws-cdk-lib/aws-kms");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
stack.templateOptions.description = 'Integration Test for aws-sns-sqs with SNS managed KMS key';
stack.node.setContext("@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption", true);
// Definitions
// Retrieve SNS managed key to encrypt the SNS Topic
const snsManagedKey = kms.Alias.fromAliasName(stack, 'sns-managed-key', 'alias/aws/sns');
// Create customer managed KMS CMK to encrypt the SQS Queue
const sqsEncryptionKeyProps = {
    enableKeyRotation: true,
    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY
};
const sqsEncryptionKey = new kms.Key(stack, 'ImportedSQSEncryptionKey', sqsEncryptionKeyProps);
// Create the SNS to SQS construct
const props = {
    topicProps: {
        masterKey: snsManagedKey
    },
    queueProps: {
        encryptionMasterKey: sqsEncryptionKey
    },
    encryptQueueWithCmk: false,
    encryptTopicWithCmk: false
};
new lib_1.SnsToSqs(stack, 'test-sns-sqs', props);
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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