"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.keyType = void 0;
exports.CheckTopicKeyType = CheckTopicKeyType;
exports.CheckQueueKeyType = CheckQueueKeyType;
exports.CheckKeyProperty = CheckKeyProperty;
const assertions_1 = require("aws-cdk-lib/assertions");
/*
 * Checking the specific type of key associated  with a resource is non-trivial. We've
 * extracted the functionality here to keep the code  that checks the test result cleaner
 */
var keyType;
(function (keyType) {
    keyType[keyType["cmk"] = 0] = "cmk";
    keyType[keyType["sse"] = 1] = "sse";
    keyType[keyType["none"] = 2] = "none";
})(keyType || (exports.keyType = keyType = {}));
function CheckTopicKeyType(template, type) {
    // First ensure there's an encryption key
    if (type === keyType.none) {
        template.hasResourceProperties("AWS::SNS::Topic", assertions_1.Match.not({
            KmsMasterKeyId: assertions_1.Match.anyValue()
        }));
    }
    else {
        template.hasResourceProperties("AWS::SNS::Topic", {
            KmsMasterKeyId: assertions_1.Match.anyValue()
        });
        // Now confirm is is the correct  type
        if (type === keyType.cmk) {
            template.hasResourceProperties("AWS::SNS::Topic", assertions_1.Match.not({
                KmsMasterKeyId: {
                    "Fn::Join": ["", assertions_1.Match.arrayWith([":alias/aws/sns"])]
                }
            }));
        }
        else if (type === keyType.sse) {
            template.hasResourceProperties("AWS::SNS::Topic", {
                KmsMasterKeyId: {
                    "Fn::Join": ["", assertions_1.Match.arrayWith([":alias/aws/sns"])]
                }
            });
        }
        else {
            throw new Error('Invalid Key Type');
        }
    }
}
function CheckQueueKeyType(template, type) {
    if (type === keyType.none) {
        template.hasResourceProperties("AWS::SQS::Queue", assertions_1.Match.not({
            KmsMasterKeyId: assertions_1.Match.anyValue()
        }));
    }
    else {
        template.hasResourceProperties("AWS::SQS::Queue", {
            KmsMasterKeyId: assertions_1.Match.anyValue()
        });
        // Now confirm is is the correct  type
        if (type === keyType.cmk) {
            template.hasResourceProperties("AWS::SQS::Queue", assertions_1.Match.not({
                KmsMasterKeyId: {
                    "Fn::Join": ["", assertions_1.Match.arrayWith([":alias/aws/sqs"])]
                }
            }));
        }
        else if (type === keyType.sse) {
            template.hasResourceProperties("AWS::SQS::Queue", {
                KmsMasterKeyId: {
                    "Fn::Join": ["", assertions_1.Match.arrayWith([":alias/aws/sqs"])]
                }
            });
        }
        else {
            throw new Error('Invalid Key Type');
        }
    }
}
function CheckKeyProperty(encryptionKey, type) {
    // Ensure the value  is set
    if (type === keyType.none) {
        expect(encryptionKey).toBeUndefined();
    }
    else {
        expect(encryptionKey).toBeDefined();
        // Now confirm it is the correct type\
        if (type === keyType.cmk) {
            expect(encryptionKey?.keyArn).not.toContain('alias/aws/sns');
        }
        else if (type === keyType.sse) {
            expect(encryptionKey?.keyArn).toContain('alias/aws/sns');
        }
        else {
            throw new Error('Invalid Key Type');
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7O0dBV0c7OztBQWdCSCw4Q0E0QkM7QUFFRCw4Q0EyQkM7QUFFRCw0Q0FnQkM7QUF6RkQsdURBQXlEO0FBR3pEOzs7R0FHRztBQUVILElBQVksT0FJWDtBQUpELFdBQVksT0FBTztJQUNqQixtQ0FBRyxDQUFBO0lBQ0gsbUNBQUcsQ0FBQTtJQUNILHFDQUFJLENBQUE7QUFDTixDQUFDLEVBSlcsT0FBTyx1QkFBUCxPQUFPLFFBSWxCO0FBRUQsU0FBZ0IsaUJBQWlCLENBQUMsUUFBa0IsRUFBRSxJQUFhO0lBQ2pFLHlDQUF5QztJQUN6QyxJQUFJLElBQUksS0FBSyxPQUFPLENBQUMsSUFBSSxFQUFFLENBQUM7UUFDMUIsUUFBUSxDQUFDLHFCQUFxQixDQUFDLGlCQUFpQixFQUFFLGtCQUFLLENBQUMsR0FBRyxDQUFDO1lBQzFELGNBQWMsRUFBRSxrQkFBSyxDQUFDLFFBQVEsRUFBRTtTQUNqQyxDQUFDLENBQUMsQ0FBQztJQUNOLENBQUM7U0FBTSxDQUFDO1FBQ04sUUFBUSxDQUFDLHFCQUFxQixDQUFDLGlCQUFpQixFQUFFO1lBQ2hELGNBQWMsRUFBRSxrQkFBSyxDQUFDLFFBQVEsRUFBRTtTQUNqQyxDQUFDLENBQUM7UUFFSCxzQ0FBc0M7UUFDdEMsSUFBSSxJQUFJLEtBQUssT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO1lBQ3pCLFFBQVEsQ0FBQyxxQkFBcUIsQ0FBQyxpQkFBaUIsRUFBRSxrQkFBSyxDQUFDLEdBQUcsQ0FBQztnQkFDMUQsY0FBYyxFQUFFO29CQUNkLFVBQVUsRUFBRSxDQUFDLEVBQUUsRUFBRSxrQkFBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztpQkFDdEQ7YUFDRixDQUFDLENBQUMsQ0FBQztRQUNOLENBQUM7YUFBTSxJQUFJLElBQUksS0FBSyxPQUFPLENBQUMsR0FBRyxFQUFFLENBQUM7WUFDaEMsUUFBUSxDQUFDLHFCQUFxQixDQUFDLGlCQUFpQixFQUFFO2dCQUNoRCxjQUFjLEVBQUU7b0JBQ2QsVUFBVSxFQUFFLENBQUMsRUFBRSxFQUFFLGtCQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO2lCQUN0RDthQUNGLENBQUMsQ0FBQztRQUNMLENBQUM7YUFBTSxDQUFDO1lBQ04sTUFBTSxJQUFJLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3RDLENBQUM7SUFDSCxDQUFDO0FBQ0gsQ0FBQztBQUVELFNBQWdCLGlCQUFpQixDQUFDLFFBQWtCLEVBQUUsSUFBYTtJQUNqRSxJQUFJLElBQUksS0FBSyxPQUFPLENBQUMsSUFBSSxFQUFFLENBQUM7UUFDMUIsUUFBUSxDQUFDLHFCQUFxQixDQUFDLGlCQUFpQixFQUFFLGtCQUFLLENBQUMsR0FBRyxDQUFDO1lBQzFELGNBQWMsRUFBRSxrQkFBSyxDQUFDLFFBQVEsRUFBRTtTQUNqQyxDQUFDLENBQUMsQ0FBQztJQUNOLENBQUM7U0FBTSxDQUFDO1FBQ04sUUFBUSxDQUFDLHFCQUFxQixDQUFDLGlCQUFpQixFQUFFO1lBQ2hELGNBQWMsRUFBRSxrQkFBSyxDQUFDLFFBQVEsRUFBRTtTQUNqQyxDQUFDLENBQUM7UUFFSCxzQ0FBc0M7UUFDdEMsSUFBSSxJQUFJLEtBQUssT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO1lBQ3pCLFFBQVEsQ0FBQyxxQkFBcUIsQ0FBQyxpQkFBaUIsRUFBRSxrQkFBSyxDQUFDLEdBQUcsQ0FBQztnQkFDMUQsY0FBYyxFQUFFO29CQUNkLFVBQVUsRUFBRSxDQUFDLEVBQUUsRUFBRSxrQkFBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztpQkFDdEQ7YUFDRixDQUFDLENBQUMsQ0FBQztRQUNOLENBQUM7YUFBTSxJQUFJLElBQUksS0FBSyxPQUFPLENBQUMsR0FBRyxFQUFFLENBQUM7WUFDaEMsUUFBUSxDQUFDLHFCQUFxQixDQUFDLGlCQUFpQixFQUFFO2dCQUNoRCxjQUFjLEVBQUU7b0JBQ2QsVUFBVSxFQUFFLENBQUMsRUFBRSxFQUFFLGtCQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO2lCQUN0RDthQUNGLENBQUMsQ0FBQztRQUNMLENBQUM7YUFBTSxDQUFDO1lBQ04sTUFBTSxJQUFJLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3RDLENBQUM7SUFDSCxDQUFDO0FBQ0gsQ0FBQztBQUVELFNBQWdCLGdCQUFnQixDQUFDLGFBQWtDLEVBQUUsSUFBYTtJQUNoRiwyQkFBMkI7SUFDM0IsSUFBSSxJQUFJLEtBQUssT0FBTyxDQUFDLElBQUksRUFBRSxDQUFDO1FBQzFCLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN4QyxDQUFDO1NBQU0sQ0FBQztRQUNOLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUVwQyxzQ0FBc0M7UUFDdEMsSUFBSSxJQUFJLEtBQUssT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO1lBQ3pCLE1BQU0sQ0FBQyxhQUFhLEVBQUUsTUFBTSxDQUFDLENBQUMsR0FBRyxDQUFDLFNBQVMsQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUMvRCxDQUFDO2FBQU0sSUFBSSxJQUFJLEtBQUssT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO1lBQ2hDLE1BQU0sQ0FBQyxhQUFhLEVBQUUsTUFBTSxDQUFDLENBQUMsU0FBUyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQzNELENBQUM7YUFBTSxDQUFDO1lBQ04sTUFBTSxJQUFJLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3RDLENBQUM7SUFDSCxDQUFDO0FBQ0gsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCB7IE1hdGNoLCBUZW1wbGF0ZSB9IGZyb20gJ2F3cy1jZGstbGliL2Fzc2VydGlvbnMnO1xuaW1wb3J0ICogYXMga21zIGZyb20gJ2F3cy1jZGstbGliL2F3cy1rbXMnO1xuXG4vKlxuICogQ2hlY2tpbmcgdGhlIHNwZWNpZmljIHR5cGUgb2Yga2V5IGFzc29jaWF0ZWQgIHdpdGggYSByZXNvdXJjZSBpcyBub24tdHJpdmlhbC4gV2UndmVcbiAqIGV4dHJhY3RlZCB0aGUgZnVuY3Rpb25hbGl0eSBoZXJlIHRvIGtlZXAgdGhlIGNvZGUgIHRoYXQgY2hlY2tzIHRoZSB0ZXN0IHJlc3VsdCBjbGVhbmVyXG4gKi9cblxuZXhwb3J0IGVudW0ga2V5VHlwZSB7XG4gIGNtayxcbiAgc3NlLFxuICBub25lXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBDaGVja1RvcGljS2V5VHlwZSh0ZW1wbGF0ZTogVGVtcGxhdGUsIHR5cGU6IGtleVR5cGUpIHtcbiAgLy8gRmlyc3QgZW5zdXJlIHRoZXJlJ3MgYW4gZW5jcnlwdGlvbiBrZXlcbiAgaWYgKHR5cGUgPT09IGtleVR5cGUubm9uZSkge1xuICAgIHRlbXBsYXRlLmhhc1Jlc291cmNlUHJvcGVydGllcyhcIkFXUzo6U05TOjpUb3BpY1wiLCBNYXRjaC5ub3Qoe1xuICAgICAgS21zTWFzdGVyS2V5SWQ6IE1hdGNoLmFueVZhbHVlKClcbiAgICB9KSk7XG4gIH0gZWxzZSB7XG4gICAgdGVtcGxhdGUuaGFzUmVzb3VyY2VQcm9wZXJ0aWVzKFwiQVdTOjpTTlM6OlRvcGljXCIsIHtcbiAgICAgIEttc01hc3RlcktleUlkOiBNYXRjaC5hbnlWYWx1ZSgpXG4gICAgfSk7XG5cbiAgICAvLyBOb3cgY29uZmlybSBpcyBpcyB0aGUgY29ycmVjdCAgdHlwZVxuICAgIGlmICh0eXBlID09PSBrZXlUeXBlLmNtaykge1xuICAgICAgdGVtcGxhdGUuaGFzUmVzb3VyY2VQcm9wZXJ0aWVzKFwiQVdTOjpTTlM6OlRvcGljXCIsIE1hdGNoLm5vdCh7XG4gICAgICAgIEttc01hc3RlcktleUlkOiB7XG4gICAgICAgICAgXCJGbjo6Sm9pblwiOiBbXCJcIiwgTWF0Y2guYXJyYXlXaXRoKFtcIjphbGlhcy9hd3Mvc25zXCJdKV1cbiAgICAgICAgfVxuICAgICAgfSkpO1xuICAgIH0gZWxzZSBpZiAodHlwZSA9PT0ga2V5VHlwZS5zc2UpIHtcbiAgICAgIHRlbXBsYXRlLmhhc1Jlc291cmNlUHJvcGVydGllcyhcIkFXUzo6U05TOjpUb3BpY1wiLCB7XG4gICAgICAgIEttc01hc3RlcktleUlkOiB7XG4gICAgICAgICAgXCJGbjo6Sm9pblwiOiBbXCJcIiwgTWF0Y2guYXJyYXlXaXRoKFtcIjphbGlhcy9hd3Mvc25zXCJdKV1cbiAgICAgICAgfVxuICAgICAgfSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignSW52YWxpZCBLZXkgVHlwZScpO1xuICAgIH1cbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gQ2hlY2tRdWV1ZUtleVR5cGUodGVtcGxhdGU6IFRlbXBsYXRlLCB0eXBlOiBrZXlUeXBlKSB7XG4gIGlmICh0eXBlID09PSBrZXlUeXBlLm5vbmUpIHtcbiAgICB0ZW1wbGF0ZS5oYXNSZXNvdXJjZVByb3BlcnRpZXMoXCJBV1M6OlNRUzo6UXVldWVcIiwgTWF0Y2gubm90KHtcbiAgICAgIEttc01hc3RlcktleUlkOiBNYXRjaC5hbnlWYWx1ZSgpXG4gICAgfSkpO1xuICB9IGVsc2Uge1xuICAgIHRlbXBsYXRlLmhhc1Jlc291cmNlUHJvcGVydGllcyhcIkFXUzo6U1FTOjpRdWV1ZVwiLCB7XG4gICAgICBLbXNNYXN0ZXJLZXlJZDogTWF0Y2guYW55VmFsdWUoKVxuICAgIH0pO1xuXG4gICAgLy8gTm93IGNvbmZpcm0gaXMgaXMgdGhlIGNvcnJlY3QgIHR5cGVcbiAgICBpZiAodHlwZSA9PT0ga2V5VHlwZS5jbWspIHtcbiAgICAgIHRlbXBsYXRlLmhhc1Jlc291cmNlUHJvcGVydGllcyhcIkFXUzo6U1FTOjpRdWV1ZVwiLCBNYXRjaC5ub3Qoe1xuICAgICAgICBLbXNNYXN0ZXJLZXlJZDoge1xuICAgICAgICAgIFwiRm46OkpvaW5cIjogW1wiXCIsIE1hdGNoLmFycmF5V2l0aChbXCI6YWxpYXMvYXdzL3Nxc1wiXSldXG4gICAgICAgIH1cbiAgICAgIH0pKTtcbiAgICB9IGVsc2UgaWYgKHR5cGUgPT09IGtleVR5cGUuc3NlKSB7XG4gICAgICB0ZW1wbGF0ZS5oYXNSZXNvdXJjZVByb3BlcnRpZXMoXCJBV1M6OlNRUzo6UXVldWVcIiwge1xuICAgICAgICBLbXNNYXN0ZXJLZXlJZDoge1xuICAgICAgICAgIFwiRm46OkpvaW5cIjogW1wiXCIsIE1hdGNoLmFycmF5V2l0aChbXCI6YWxpYXMvYXdzL3Nxc1wiXSldXG4gICAgICAgIH1cbiAgICAgIH0pO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0ludmFsaWQgS2V5IFR5cGUnKTtcbiAgICB9XG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIENoZWNrS2V5UHJvcGVydHkoZW5jcnlwdGlvbktleToga21zLktleSB8IHVuZGVmaW5lZCwgdHlwZToga2V5VHlwZSkge1xuICAvLyBFbnN1cmUgdGhlIHZhbHVlICBpcyBzZXRcbiAgaWYgKHR5cGUgPT09IGtleVR5cGUubm9uZSkge1xuICAgIGV4cGVjdChlbmNyeXB0aW9uS2V5KS50b0JlVW5kZWZpbmVkKCk7XG4gIH0gZWxzZSB7XG4gICAgZXhwZWN0KGVuY3J5cHRpb25LZXkpLnRvQmVEZWZpbmVkKCk7XG5cbiAgICAvLyBOb3cgY29uZmlybSBpdCBpcyB0aGUgY29ycmVjdCB0eXBlXFxcbiAgICBpZiAodHlwZSA9PT0ga2V5VHlwZS5jbWspIHtcbiAgICAgIGV4cGVjdChlbmNyeXB0aW9uS2V5Py5rZXlBcm4pLm5vdC50b0NvbnRhaW4oJ2FsaWFzL2F3cy9zbnMnKTtcbiAgICB9IGVsc2UgaWYgKHR5cGUgPT09IGtleVR5cGUuc3NlKSB7XG4gICAgICBleHBlY3QoZW5jcnlwdGlvbktleT8ua2V5QXJuKS50b0NvbnRhaW4oJ2FsaWFzL2F3cy9zbnMnKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdJbnZhbGlkIEtleSBUeXBlJyk7XG4gICAgfVxuICB9XG59Il19