from setuptools import setup, find_packages

version = '0.1.dev0'


def read_file(path):
    with open(path) as f:
        return f.read()


long_description = '\n\n'.join([
    read_file('README.txt'),
    read_file('CHANGES.txt'),
])

setup(name='tha.example',
      version=version,
      description="Example package",
      long_description=long_description,
      # Get strings from https://pypi.org/classifiers
      classifiers=[
          "Development Status :: 1 - Planning",
          "License :: OSI Approved :: GNU General Public License (GPL)",
          "Programming Language :: Python :: 3.9",
      ],
      keywords=['example'],
      author='The Health Agency',
      author_email='techniek@thehealthagency.com',
      url='https://www.thehealthagency.com',
      license='',
      package_dir={'': 'src'},
      packages=find_packages('src'),
      include_package_data=True,
      zip_safe=False,
      install_requires=['setuptools',
                        ],
      extras_require={
          'test': ['z3c.testsetup>=0.3'],
      },
      entry_points={
          'console_scripts': [
          ]},
      )
