"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Codecommit = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [codecommit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodecommit.html).
 *
 * @experimental
 */
class Codecommit extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [codecommit](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodecommit.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'codecommit';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AssociateApprovalRuleTemplateWithRepository",
                "BatchAssociateApprovalRuleTemplateWithRepositories",
                "BatchDisassociateApprovalRuleTemplateFromRepositories",
                "CreateApprovalRuleTemplate",
                "CreateBranch",
                "CreateCommit",
                "CreatePullRequest",
                "CreatePullRequestApprovalRule",
                "CreateRepository",
                "CreateUnreferencedMergeCommit",
                "DeleteApprovalRuleTemplate",
                "DeleteBranch",
                "DeleteCommentContent",
                "DeleteFile",
                "DeletePullRequestApprovalRule",
                "DeleteRepository",
                "DisassociateApprovalRuleTemplateFromRepository",
                "GitPush",
                "MergeBranchesByFastForward",
                "MergeBranchesBySquash",
                "MergeBranchesByThreeWay",
                "MergePullRequestByFastForward",
                "MergePullRequestBySquash",
                "MergePullRequestByThreeWay",
                "OverridePullRequestApprovalRules",
                "PostCommentForComparedCommit",
                "PostCommentForPullRequest",
                "PostCommentReply",
                "PutCommentReaction",
                "PutFile",
                "PutRepositoryTriggers",
                "TagResource",
                "TestRepositoryTriggers",
                "UntagResource",
                "UpdateApprovalRuleTemplateContent",
                "UpdateApprovalRuleTemplateDescription",
                "UpdateApprovalRuleTemplateName",
                "UpdateComment",
                "UpdateDefaultBranch",
                "UpdatePullRequestApprovalRuleContent",
                "UpdatePullRequestApprovalState",
                "UpdatePullRequestDescription",
                "UpdatePullRequestStatus",
                "UpdatePullRequestTitle",
                "UpdateRepositoryDescription",
                "UpdateRepositoryName",
                "UploadArchive"
            ],
            "Read": [
                "BatchDescribeMergeConflicts",
                "BatchGetCommits",
                "BatchGetPullRequests",
                "BatchGetRepositories",
                "CancelUploadArchive",
                "DescribeMergeConflicts",
                "DescribePullRequestEvents",
                "EvaluatePullRequestApprovalRules",
                "GetApprovalRuleTemplate",
                "GetBlob",
                "GetBranch",
                "GetComment",
                "GetCommentReactions",
                "GetCommentsForComparedCommit",
                "GetCommentsForPullRequest",
                "GetCommit",
                "GetCommitHistory",
                "GetCommitsFromMergeBase",
                "GetDifferences",
                "GetFile",
                "GetFolder",
                "GetMergeCommit",
                "GetMergeConflicts",
                "GetMergeOptions",
                "GetObjectIdentifier",
                "GetPullRequest",
                "GetPullRequestApprovalStates",
                "GetPullRequestOverrideState",
                "GetReferences",
                "GetRepository",
                "GetRepositoryTriggers",
                "GetTree",
                "GetUploadArchiveStatus",
                "GitPull"
            ],
            "List": [
                "ListApprovalRuleTemplates",
                "ListAssociatedApprovalRuleTemplatesForRepository",
                "ListBranches",
                "ListPullRequests",
                "ListRepositories",
                "ListRepositoriesForApprovalRuleTemplate",
                "ListTagsForResource"
            ]
        };
    }
    /**
     * (experimental) Grants permission to associate an approval rule template with a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_AssociateApprovalRuleTemplateWithRepository.html
     *
     * @experimental
     */
    toAssociateApprovalRuleTemplateWithRepository() {
        return this.to('AssociateApprovalRuleTemplateWithRepository');
    }
    /**
     * (experimental) Grants permission to associate an approval rule template with multiple repositories in a single operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchAssociateApprovalRuleTemplateWithRepositories.html
     *
     * @experimental
     */
    toBatchAssociateApprovalRuleTemplateWithRepositories() {
        return this.to('BatchAssociateApprovalRuleTemplateWithRepositories');
    }
    /**
     * (experimental) Grants permission to get information about multiple merge conflicts when attempting to merge two commits using either the three-way merge or the squash merge option.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchDescribeMergeConflicts.html
     *
     * @experimental
     */
    toBatchDescribeMergeConflicts() {
        return this.to('BatchDescribeMergeConflicts');
    }
    /**
     * (experimental) Grants permission to remove the association between an approval rule template and multiple repositories in a single operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchDisassociateApprovalRuleTemplateFromRepositories.html
     *
     * @experimental
     */
    toBatchDisassociateApprovalRuleTemplateFromRepositories() {
        return this.to('BatchDisassociateApprovalRuleTemplateFromRepositories');
    }
    /**
     * (experimental) Grants permission to get return information about one or more commits in an AWS CodeCommit repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchGetCommits.html
     *
     * @experimental
     */
    toBatchGetCommits() {
        return this.to('BatchGetCommits');
    }
    /**
     * (experimental) Grants permission to return information about one or more pull requests in an AWS CodeCommit repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-pr
     *
     * @experimental
     */
    toBatchGetPullRequests() {
        return this.to('BatchGetPullRequests');
    }
    /**
     * (experimental) Grants permission to get information about multiple repositories.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_BatchGetRepositories.html
     *
     * @experimental
     */
    toBatchGetRepositories() {
        return this.to('BatchGetRepositories');
    }
    /**
     * (experimental) Grants permission to cancel the uploading of an archive to a pipeline in AWS CodePipeline.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-acp
     *
     * @experimental
     */
    toCancelUploadArchive() {
        return this.to('CancelUploadArchive');
    }
    /**
     * (experimental) Grants permission to create an approval rule template that will automatically create approval rules in pull requests that match the conditions defined in the template;
     *
     * does not grant permission to create approval rules for individual pull requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateApprovalRuleTemplate.html
     *
     * @experimental
     */
    toCreateApprovalRuleTemplate() {
        return this.to('CreateApprovalRuleTemplate');
    }
    /**
     * (experimental) Grants permission to create a branch in an AWS CodeCommit repository with this API;
     *
     * does not control Git create branch actions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateBranch.html
     *
     * @experimental
     */
    toCreateBranch() {
        return this.to('CreateBranch');
    }
    /**
     * (experimental) Grants permission to add, copy, move or update single or multiple files in a branch in an AWS CodeCommit repository, and generate a commit for the changes in the specified branch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateCommit.html
     *
     * @experimental
     */
    toCreateCommit() {
        return this.to('CreateCommit');
    }
    /**
     * (experimental) Grants permission to create a pull request in the specified repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreatePullRequest.html
     *
     * @experimental
     */
    toCreatePullRequest() {
        return this.to('CreatePullRequest');
    }
    /**
     * (experimental) Grants permission to create an approval rule specific to an individual pull request;
     *
     * does not grant permission to create approval rule templates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreatePullRequestApprovalRule.html
     *
     * @experimental
     */
    toCreatePullRequestApprovalRule() {
        return this.to('CreatePullRequestApprovalRule');
    }
    /**
     * (experimental) Grants permission to create an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateRepository.html
     *
     * @experimental
     */
    toCreateRepository() {
        return this.to('CreateRepository');
    }
    /**
     * (experimental) Grants permission to create an unreferenced commit that contains the result of merging two commits using either the three-way or the squash merge option;
     *
     * does not control Git merge actions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_CreateUnreferencedMergeCommit.html
     *
     * @experimental
     */
    toCreateUnreferencedMergeCommit() {
        return this.to('CreateUnreferencedMergeCommit');
    }
    /**
     * (experimental) Grants permission to delete an approval rule template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteApprovalRuleTemplate.html
     *
     * @experimental
     */
    toDeleteApprovalRuleTemplate() {
        return this.to('DeleteApprovalRuleTemplate');
    }
    /**
     * (experimental) Grants permission to delete a branch in an AWS CodeCommit repository with this API;
     *
     * does not control Git delete branch actions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteBranch.html
     *
     * @experimental
     */
    toDeleteBranch() {
        return this.to('DeleteBranch');
    }
    /**
     * (experimental) Grants permission to delete the content of a comment made on a change, file, or commit in a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteCommentContent.html
     *
     * @experimental
     */
    toDeleteCommentContent() {
        return this.to('DeleteCommentContent');
    }
    /**
     * (experimental) Grants permission to delete a specified file from a specified branch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteFile.html
     *
     * @experimental
     */
    toDeleteFile() {
        return this.to('DeleteFile');
    }
    /**
     * (experimental) Grants permission to delete approval rule created for a pull request if the rule was not created by an approval rule template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeletePullRequestApprovalRule.html
     *
     * @experimental
     */
    toDeletePullRequestApprovalRule() {
        return this.to('DeletePullRequestApprovalRule');
    }
    /**
     * (experimental) Grants permission to delete an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DeleteRepository.html
     *
     * @experimental
     */
    toDeleteRepository() {
        return this.to('DeleteRepository');
    }
    /**
     * (experimental) Grants permission to get information about specific merge conflicts when attempting to merge two commits using either the three-way or the squash merge option.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DescribeMergeConflicts.html
     *
     * @experimental
     */
    toDescribeMergeConflicts() {
        return this.to('DescribeMergeConflicts');
    }
    /**
     * (experimental) Grants permission to return information about one or more pull request events.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DescribePullRequestEvents.html
     *
     * @experimental
     */
    toDescribePullRequestEvents() {
        return this.to('DescribePullRequestEvents');
    }
    /**
     * (experimental) Grants permission to remove the association between an approval rule template and a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_DisassociateApprovalRuleTemplateFromRepository.html
     *
     * @experimental
     */
    toDisassociateApprovalRuleTemplateFromRepository() {
        return this.to('DisassociateApprovalRuleTemplateFromRepository');
    }
    /**
     * (experimental) Grants permission to evaluate whether a pull request is mergable based on its current approval state and approval rule requirements.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_EvaluatePullRequestApprovalRules.html
     *
     * @experimental
     */
    toEvaluatePullRequestApprovalRules() {
        return this.to('EvaluatePullRequestApprovalRules');
    }
    /**
     * (experimental) Grants permission to return information about an approval rule template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetApprovalRuleTemplate.html
     *
     * @experimental
     */
    toGetApprovalRuleTemplate() {
        return this.to('GetApprovalRuleTemplate');
    }
    /**
     * (experimental) Grants permission to view the encoded content of an individual file in an AWS CodeCommit repository from the AWS CodeCommit console.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetBlob.html
     *
     * @experimental
     */
    toGetBlob() {
        return this.to('GetBlob');
    }
    /**
     * (experimental) Grants permission to get details about a branch in an AWS CodeCommit repository with this API;
     *
     * does not control Git branch actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetBranch.html
     *
     * @experimental
     */
    toGetBranch() {
        return this.to('GetBranch');
    }
    /**
     * (experimental) Grants permission to get the content of a comment made on a change, file, or commit in a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetComment.html
     *
     * @experimental
     */
    toGetComment() {
        return this.to('GetComment');
    }
    /**
     * (experimental) Grants permission to get the reactions on a comment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommentReactions.html
     *
     * @experimental
     */
    toGetCommentReactions() {
        return this.to('GetCommentReactions');
    }
    /**
     * (experimental) Grants permission to get information about comments made on the comparison between two commits.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommentsForComparedCommit.html
     *
     * @experimental
     */
    toGetCommentsForComparedCommit() {
        return this.to('GetCommentsForComparedCommit');
    }
    /**
     * (experimental) Grants permission to get comments made on a pull request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommentsForPullRequest.html
     *
     * @experimental
     */
    toGetCommentsForPullRequest() {
        return this.to('GetCommentsForPullRequest');
    }
    /**
     * (experimental) Grants permission to return information about a commit, including commit message and committer information, with this API;
     *
     * does not control Git log actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetCommit.html
     *
     * @experimental
     */
    toGetCommit() {
        return this.to('GetCommit');
    }
    /**
     * (experimental) Grants permission to get information about the history of commits in a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     *
     * @experimental
     */
    toGetCommitHistory() {
        return this.to('GetCommitHistory');
    }
    /**
     * (experimental) Grants permission to get information about the difference between commits in the context of a potential merge.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-pr
     *
     * @experimental
     */
    toGetCommitsFromMergeBase() {
        return this.to('GetCommitsFromMergeBase');
    }
    /**
     * (experimental) Grants permission to view information about the differences between valid commit specifiers such as a branch, tag, HEAD, commit ID, or other fully qualified reference.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetDifferences.html
     *
     * @experimental
     */
    toGetDifferences() {
        return this.to('GetDifferences');
    }
    /**
     * (experimental) Grants permission to return the base-64 encoded contents of a specified file and its metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetFile.html
     *
     * @experimental
     */
    toGetFile() {
        return this.to('GetFile');
    }
    /**
     * (experimental) Grants permission to return the contents of a specified folder in a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetFolder.html
     *
     * @experimental
     */
    toGetFolder() {
        return this.to('GetFolder');
    }
    /**
     * (experimental) Grants permission to get information about a merge commit created by one of the merge options for pull requests that creates merge commits.
     *
     * Not all merge options create merge commits. This permission does not control Git merge actions
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetMergeCommit.html
     *
     * @experimental
     */
    toGetMergeCommit() {
        return this.to('GetMergeCommit');
    }
    /**
     * (experimental) Grants permission to get information about merge conflicts between the before and after commit IDs for a pull request in a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetMergeConflicts.html
     *
     * @experimental
     */
    toGetMergeConflicts() {
        return this.to('GetMergeConflicts');
    }
    /**
     * (experimental) Grants permission to get information about merge options for pull requests that can be used to merge two commits;
     *
     * does not control Git merge actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetMergeOptions.html
     *
     * @experimental
     */
    toGetMergeOptions() {
        return this.to('GetMergeOptions');
    }
    /**
     * (experimental) Grants permission to resolve blobs, trees, and commits to their identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     *
     * @experimental
     */
    toGetObjectIdentifier() {
        return this.to('GetObjectIdentifier');
    }
    /**
     * (experimental) Grants permission to get information about a pull request in a specified repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetPullRequest.html
     *
     * @experimental
     */
    toGetPullRequest() {
        return this.to('GetPullRequest');
    }
    /**
     * (experimental) Grants permission to retrieve the current approvals on an inputted pull request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetPullRequestApprovalStates.html
     *
     * @experimental
     */
    toGetPullRequestApprovalStates() {
        return this.to('GetPullRequestApprovalStates');
    }
    /**
     * (experimental) Grants permission to retrieve the current override state of a given pull request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetPullRequestOverrideState.html
     *
     * @experimental
     */
    toGetPullRequestOverrideState() {
        return this.to('GetPullRequestOverrideState');
    }
    /**
     * (experimental) Grants permission to get details about references in an AWS CodeCommit repository; does not control Git reference actions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     *
     * @experimental
     */
    toGetReferences() {
        return this.to('GetReferences');
    }
    /**
     * (experimental) Grants permission to get information about an AWS CodeCommit repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html
     *
     * @experimental
     */
    toGetRepository() {
        return this.to('GetRepository');
    }
    /**
     * (experimental) Grants permission to get information about triggers configured for a repository.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepositoryTriggers.html
     *
     * @experimental
     */
    toGetRepositoryTriggers() {
        return this.to('GetRepositoryTriggers');
    }
    /**
     * (experimental) Grants permission to view the contents of a specified tree in an AWS CodeCommit repository from the AWS CodeCommit console.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-code
     *
     * @experimental
     */
    toGetTree() {
        return this.to('GetTree');
    }
    /**
     * (experimental) Grants permission to get status information about an archive upload to a pipeline in AWS CodePipeline.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-acp
     *
     * @experimental
     */
    toGetUploadArchiveStatus() {
        return this.to('GetUploadArchiveStatus');
    }
    /**
     * (experimental) Grants permission to pull information from an AWS CodeCommit repository to a local repo.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-git
     *
     * @experimental
     */
    toGitPull() {
        return this.to('GitPull');
    }
    /**
     * (experimental) Grants permission to push information from a local repo to an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-git
     *
     * @experimental
     */
    toGitPush() {
        return this.to('GitPush');
    }
    /**
     * (experimental) Grants permission to list all approval rule templates in an AWS Region for the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListApprovalRuleTemplates.html
     *
     * @experimental
     */
    toListApprovalRuleTemplates() {
        return this.to('ListApprovalRuleTemplates');
    }
    /**
     * (experimental) Grants permission to list approval rule templates that are associated with a repository.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListAssociatedApprovalRuleTemplatesForRepository.html
     *
     * @experimental
     */
    toListAssociatedApprovalRuleTemplatesForRepository() {
        return this.to('ListAssociatedApprovalRuleTemplatesForRepository');
    }
    /**
     * (experimental) Grants permission to list branches for an AWS CodeCommit repository with this API; does not control Git branch actions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListBranches.html
     *
     * @experimental
     */
    toListBranches() {
        return this.to('ListBranches');
    }
    /**
     * (experimental) Grants permission to list pull requests for a specified repository.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListPullRequests.html
     *
     * @experimental
     */
    toListPullRequests() {
        return this.to('ListPullRequests');
    }
    /**
     * (experimental) Grants permission to list information about AWS CodeCommit repositories in the current Region for your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListRepositories.html
     *
     * @experimental
     */
    toListRepositories() {
        return this.to('ListRepositories');
    }
    /**
     * (experimental) Grants permission to list repositories that are associated with an approval rule template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListRepositoriesForApprovalRuleTemplate.html
     *
     * @experimental
     */
    toListRepositoriesForApprovalRuleTemplate() {
        return this.to('ListRepositoriesForApprovalRuleTemplate');
    }
    /**
     * (experimental) Grants permission to list the resource attached to a CodeCommit resource ARN.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Grants permission to merge two commits into the specified destination branch using the fast-forward merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergeBranchesByFastForward.html
     *
     * @experimental
     */
    toMergeBranchesByFastForward() {
        return this.to('MergeBranchesByFastForward');
    }
    /**
     * (experimental) Grants permission to merge two commits into the specified destination branch using the squash merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergeBranchesBySquash.html
     *
     * @experimental
     */
    toMergeBranchesBySquash() {
        return this.to('MergeBranchesBySquash');
    }
    /**
     * (experimental) Grants permission to merge two commits into the specified destination branch using the three-way merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergeBranchesByThreeWay.html
     *
     * @experimental
     */
    toMergeBranchesByThreeWay() {
        return this.to('MergeBranchesByThreeWay');
    }
    /**
     * (experimental) Grants permission to close a pull request and attempt to merge it into the specified destination branch for that pull request at the specified commit using the fast-forward merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergePullRequestByFastForward.html
     *
     * @experimental
     */
    toMergePullRequestByFastForward() {
        return this.to('MergePullRequestByFastForward');
    }
    /**
     * (experimental) Grants permission to close a pull request and attempt to merge it into the specified destination branch for that pull request at the specified commit using the squash merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergePullRequestBySquash.html
     *
     * @experimental
     */
    toMergePullRequestBySquash() {
        return this.to('MergePullRequestBySquash');
    }
    /**
     * (experimental) Grants permission to close a pull request and attempt to merge it into the specified destination branch for that pull request at the specified commit using the three-way merge option.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_MergePullRequestByThreeWay.html
     *
     * @experimental
     */
    toMergePullRequestByThreeWay() {
        return this.to('MergePullRequestByThreeWay');
    }
    /**
     * (experimental) Grants permission to override all approval rules for a pull request, including approval rules created by a template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_OverridePullRequestApprovalRules.html
     *
     * @experimental
     */
    toOverridePullRequestApprovalRules() {
        return this.to('OverridePullRequestApprovalRules');
    }
    /**
     * (experimental) Grants permission to post a comment on the comparison between two commits.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PostCommentForComparedCommit.html
     *
     * @experimental
     */
    toPostCommentForComparedCommit() {
        return this.to('PostCommentForComparedCommit');
    }
    /**
     * (experimental) Grants permission to post a comment on a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PostCommentForPullRequest.html
     *
     * @experimental
     */
    toPostCommentForPullRequest() {
        return this.to('PostCommentForPullRequest');
    }
    /**
     * (experimental) Grants permission to post a comment in reply to a comment on a comparison between commits or a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PostCommentReply.html
     *
     * @experimental
     */
    toPostCommentReply() {
        return this.to('PostCommentReply');
    }
    /**
     * (experimental) Grants permission to post a reaction on a comment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PutCommentReaction.html
     *
     * @experimental
     */
    toPutCommentReaction() {
        return this.to('PutCommentReaction');
    }
    /**
     * (experimental) Grants permission to add or update a file in a branch in an AWS CodeCommit repository, and generate a commit for the addition in the specified branch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifReferences()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PutFile.html
     *
     * @experimental
     */
    toPutFile() {
        return this.to('PutFile');
    }
    /**
     * (experimental) Grants permission to create, update, or delete triggers for a repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_PutRepositoryTriggers.html
     *
     * @experimental
     */
    toPutRepositoryTriggers() {
        return this.to('PutRepositoryTriggers');
    }
    /**
     * (experimental) Grants permission to attach resource tags to a CodeCommit resource ARN.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * (experimental) Grants permission to test the functionality of repository triggers by sending information to the trigger target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_TestRepositoryTriggers.html
     *
     * @experimental
     */
    toTestRepositoryTriggers() {
        return this.to('TestRepositoryTriggers');
    }
    /**
     * (experimental) Grants permission to disassociate resource tags from a CodeCommit resource ARN.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * (experimental) Grants permission to update the content of approval rule templates;
     *
     * does not grant permission to update content of approval rules created specifically for pull requests
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateApprovalRuleTemplateContent.html
     *
     * @experimental
     */
    toUpdateApprovalRuleTemplateContent() {
        return this.to('UpdateApprovalRuleTemplateContent');
    }
    /**
     * (experimental) Grants permission to update the description of approval rule templates.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateApprovalRuleTemplateDescription.html
     *
     * @experimental
     */
    toUpdateApprovalRuleTemplateDescription() {
        return this.to('UpdateApprovalRuleTemplateDescription');
    }
    /**
     * (experimental) Grants permission to update the name of approval rule templates.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateApprovalRuleTemplateName.html
     *
     * @experimental
     */
    toUpdateApprovalRuleTemplateName() {
        return this.to('UpdateApprovalRuleTemplateName');
    }
    /**
     * (experimental) Grants permission to update the contents of a comment if the identity matches the identity used to create the comment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateComment.html
     *
     * @experimental
     */
    toUpdateComment() {
        return this.to('UpdateComment');
    }
    /**
     * (experimental) Grants permission to change the default branch in an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateDefaultBranch.html
     *
     * @experimental
     */
    toUpdateDefaultBranch() {
        return this.to('UpdateDefaultBranch');
    }
    /**
     * (experimental) Grants permission to update the content for approval rules created for a specific pull requests;
     *
     * does not grant permission to update approval rule content for rules created with an approval rule template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestApprovalRuleContent.html
     *
     * @experimental
     */
    toUpdatePullRequestApprovalRuleContent() {
        return this.to('UpdatePullRequestApprovalRuleContent');
    }
    /**
     * (experimental) Grants permission to update the approval state for pull requests.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestApprovalState.html
     *
     * @experimental
     */
    toUpdatePullRequestApprovalState() {
        return this.to('UpdatePullRequestApprovalState');
    }
    /**
     * (experimental) Grants permission to update the description of a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestDescription.html
     *
     * @experimental
     */
    toUpdatePullRequestDescription() {
        return this.to('UpdatePullRequestDescription');
    }
    /**
     * (experimental) Grants permission to update the status of a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestStatus.html
     *
     * @experimental
     */
    toUpdatePullRequestStatus() {
        return this.to('UpdatePullRequestStatus');
    }
    /**
     * (experimental) Grants permission to update the title of a pull request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdatePullRequestTitle.html
     *
     * @experimental
     */
    toUpdatePullRequestTitle() {
        return this.to('UpdatePullRequestTitle');
    }
    /**
     * (experimental) Grants permission to change the description of an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateRepositoryDescription.html
     *
     * @experimental
     */
    toUpdateRepositoryDescription() {
        return this.to('UpdateRepositoryDescription');
    }
    /**
     * (experimental) Grants permission to change the name of an AWS CodeCommit repository.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/APIReference/API_UpdateRepositoryName.html
     *
     * @experimental
     */
    toUpdateRepositoryName() {
        return this.to('UpdateRepositoryName');
    }
    /**
     * (experimental) Grants permission to the service role for AWS CodePipeline to upload repository changes into a pipeline.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-permissions-reference.html#aa-acp
     *
     * @experimental
     */
    toUploadArchive() {
        return this.to('UploadArchive');
    }
    /**
     * (experimental) Adds a resource of type repository to the statement.
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats
     *
     * @param repositoryName - Identifier for the repositoryName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRepository(repositoryName, account, region, partition) {
        var arn = 'arn:${Partition}:codecommit:${Region}:${Account}:${RepositoryName}';
        arn = arn.replace('${RepositoryName}', repositoryName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Filters access by Git reference to specified AWS CodeCommit actions.
     *
     * https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-conditional-branch.html
     *
     * Applies to actions:
     * - .toCreateBranch()
     * - .toCreateCommit()
     * - .toCreateUnreferencedMergeCommit()
     * - .toDeleteBranch()
     * - .toDeleteFile()
     * - .toGetMergeCommit()
     * - .toGitPush()
     * - .toMergeBranchesByFastForward()
     * - .toMergeBranchesBySquash()
     * - .toMergeBranchesByThreeWay()
     * - .toMergePullRequestByFastForward()
     * - .toMergePullRequestBySquash()
     * - .toMergePullRequestByThreeWay()
     * - .toPutFile()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifReferences(value, operator) {
        return this.if(`References`, value, operator || 'StringLike');
    }
}
exports.Codecommit = Codecommit;
_a = JSII_RTTI_SYMBOL_1;
Codecommit[_a] = { fqn: "cdk-iam-floyd.Codecommit", version: "0.149.0" };
//# sourceMappingURL=data:application/json;base64,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