<img align="centre" src="https://github.com/digitalearthafrica/deafrica-sandbox-notebooks/blob/main/Supplementary_data/Github_banner.jpg?raw=true" width="100%">

# Digital Earth Africa Tools Package

Python functions and algorithms developed to assist in analysing Digital Earth Africa data (e.g. loading data, plotting, spatial analysis, machine learning).

## Installation

This module is automatically installed on the Digital Earth Africa Sandbox. If for some reason the module isn't avilable, you can also `pip install` the module.
To do this on the Digital Earth Africa Sandbox, run `pip` from the terminal:

```
pip install -e Tools/
```
       
To install this module from the source on any other system with `pip`:

```
pip install --extra-index-url="https://packages.dea.ga.gov.au" git+https://github.com/digitalearthafrica/deafrica-sandbox-notebooks.git#subdirectory=Tools
```


## Citing Digital Earth Africa Tools

The code in this module is an adaptation of code from the [Digital Earth Australia](https://github.com/GeoscienceAustralia/dea-notebooks) `dea-tools` package. If you use any of the code in this repository in your work, please reference them using the following citation:

    Krause, C., Dunn, B., Bishop-Taylor, R., Adams, C., Burton, C., Alger, M., Chua, S., Phillips, C., Newey, V., Kouzoubov, K., Leith, A., Ayers, D., Hicks, A., DEA Notebooks contributors 2021. Digital Earth Australia notebooks and tools repository. Geoscience Australia, Canberra. https://doi.org/10.26186/145234
    
    
## Translation

Translation of the module into other languages is done using `gettext` and `pot/po/mo` files.

The template `pot` file can be generated by running `pybabel extract -o deafrica_tools.pot *` from the Tools directory.

This file can then be uploaded to POEditor.com, by joining this project: https://poeditor.com/join/project?hash=0Q33A7sRM6.

(TODO: Automate this step as in other projects such as [deafrica-docs](https://github.com/digitalearthafrica/deafrica-docs/blob/main/.github/workflows/main.yml))

Currently, the `po` and `mo` files must be exported to `deafrica_tools/locales/fr/LC_MESSAGES/deafrica_tools.mo`

In python code, strings surrounded by an underscore function `_('')` will be translated.

This `_()` function is declared as a global after [`deafrica_tools.set_lang('fr')`](deafrica_tools/__init__.py) is called. 

Calling `deafrica_tools.set_lang()` with no argument will use the language set by JupyterLab under **Settings -> Language**.

See [wetlandsinsighttool.py](deafrica_tools/app/wetlandsinsighttool.py) as an example.
