'''
# cdk8s+ (cdk8s-plus)

### High level constructs for Kubernetes

![Stability:Stable](https://img.shields.io/badge/stability-stable-success)
[![cdk8s-plus-23](https://img.shields.io/github/workflow/status/cdk8s-team/cdk8s-plus/release-k8s.23?label=cdk8s-plus-23&logo=GitHub)](https://github.com/cdk8s-team/cdk8s-plus/actions/workflows/release-k8s.23.yml)
[![cdk8s-plus-24](https://img.shields.io/github/workflow/status/cdk8s-team/cdk8s-plus/release-k8s.24?label=cdk8s-plus-24&logo=GitHub)](https://github.com/cdk8s-team/cdk8s-plus/actions/workflows/release-k8s.24.yml)

| k8s version | npm (JS/TS)                                         | PyPI (Python)                                   | Maven (Java)                                                      | Go                                                              |
| ----------- | --------------------------------------------------- | ----------------------------------------------- | ----------------------------------------------------------------- | --------------------------------------------------------------- |
| 1.21.0      | [Link](https://www.npmjs.com/package/cdk8s-plus-21) | [Link](https://pypi.org/project/cdk8s-plus-21/) | [Link](https://search.maven.org/artifact/org.cdk8s/cdk8s-plus-21) | [Link](https://github.com/cdk8s-team/cdk8s-plus-go/tree/k8s.21) |
| 1.22.0      | [Link](https://www.npmjs.com/package/cdk8s-plus-22) | [Link](https://pypi.org/project/cdk8s-plus-22/) | [Link](https://search.maven.org/artifact/org.cdk8s/cdk8s-plus-22) | [Link](https://github.com/cdk8s-team/cdk8s-plus-go/tree/k8s.22) |
| 1.23.0      | [Link](https://www.npmjs.com/package/cdk8s-plus-23) | [Link](https://pypi.org/project/cdk8s-plus-23/) | [Link](https://search.maven.org/artifact/org.cdk8s/cdk8s-plus-23) | [Link](https://github.com/cdk8s-team/cdk8s-plus-go/tree/k8s.23) |

**cdk8s+** is a software development framework that provides high level
abstractions for authoring Kubernetes applications. Built on top of the auto
generated building blocks provided by [cdk8s](../cdk8s), this library includes a
hand crafted *construct* for each native kubernetes object, exposing richer
API's with reduced complexity.

## :books: Documentation

See [cdk8s.io](https://cdk8s.io/docs/latest/plus).

## :raised_hand: Contributing

If you'd like to add a new feature or fix a bug, please visit
[CONTRIBUTING.md](CONTRIBUTING.md)!

## :balance_scale: License

This project is distributed under the [Apache License, Version 2.0](./LICENSE).

This module is part of the [cdk8s project](https://github.com/cdk8s-team).
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import cdk8s as _cdk8s_d3d9af27
import constructs as _constructs_77d1e7e8


@jsii.data_type(
    jsii_type="cdk8s-plus-23.AddDirectoryOptions",
    jsii_struct_bases=[],
    name_mapping={"exclude": "exclude", "key_prefix": "keyPrefix"},
)
class AddDirectoryOptions:
    def __init__(
        self,
        *,
        exclude: typing.Optional[typing.Sequence[builtins.str]] = None,
        key_prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options for ``configmap.addDirectory()``.

        :param exclude: Glob patterns to exclude when adding files. Default: - include all files
        :param key_prefix: A prefix to add to all keys in the config map. Default: ""
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__28509bd3935094c78b0e590ca6612e5d7421f988fd1121c3e73cc1eff184f093)
            check_type(argname="argument exclude", value=exclude, expected_type=type_hints["exclude"])
            check_type(argname="argument key_prefix", value=key_prefix, expected_type=type_hints["key_prefix"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if exclude is not None:
            self._values["exclude"] = exclude
        if key_prefix is not None:
            self._values["key_prefix"] = key_prefix

    @builtins.property
    def exclude(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Glob patterns to exclude when adding files.

        :default: - include all files
        '''
        result = self._values.get("exclude")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def key_prefix(self) -> typing.Optional[builtins.str]:
        '''A prefix to add to all keys in the config map.

        :default: ""
        '''
        result = self._values.get("key_prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AddDirectoryOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ApiResourceOptions",
    jsii_struct_bases=[],
    name_mapping={"api_group": "apiGroup", "resource_type": "resourceType"},
)
class ApiResourceOptions:
    def __init__(self, *, api_group: builtins.str, resource_type: builtins.str) -> None:
        '''Options for ``ApiResource``.

        :param api_group: The group portion of the API version (e.g. ``authorization.k8s.io``).
        :param resource_type: The name of the resource type as it appears in the relevant API endpoint.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78f6119754216f05d22b0a933bf43d3275db0ab9d1fe8f1972198e25edd84533)
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "api_group": api_group,
            "resource_type": resource_type,
        }

    @builtins.property
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        result = self._values.get("api_group")
        assert result is not None, "Required property 'api_group' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def resource_type(self) -> builtins.str:
        '''The name of the resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        result = self._values.get("resource_type")
        assert result is not None, "Required property 'resource_type' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.AwsElasticBlockStoreVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "fs_type": "fsType",
        "name": "name",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class AwsElasticBlockStoreVolumeOptions:
    def __init__(
        self,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options of ``Volume.fromAwsElasticBlockStore``.

        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9f76012a6ab3ffec0dc1f4a2c928e8426e01b67d39883b77b5f0cfcaef4bf8e1)
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if name is not None:
            self._values["name"] = name
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsElasticBlockStoreVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.AzureDiskPersistentVolumeCachingMode")
class AzureDiskPersistentVolumeCachingMode(enum.Enum):
    '''Azure disk caching modes.'''

    NONE = "NONE"
    '''None.'''
    READ_ONLY = "READ_ONLY"
    '''ReadOnly.'''
    READ_WRITE = "READ_WRITE"
    '''ReadWrite.'''


@jsii.enum(jsii_type="cdk8s-plus-23.AzureDiskPersistentVolumeKind")
class AzureDiskPersistentVolumeKind(enum.Enum):
    '''Azure Disk kinds.'''

    SHARED = "SHARED"
    '''Multiple blob disks per storage account.'''
    DEDICATED = "DEDICATED"
    '''Single blob disk per storage account.'''
    MANAGED = "MANAGED"
    '''Azure managed data disk.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-23.AzureDiskVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "name": "name",
        "read_only": "readOnly",
    },
)
class AzureDiskVolumeOptions:
    def __init__(
        self,
        *,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options of ``Volume.fromAzureDisk``.

        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param name: The volume name. Default: - auto-generated
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__812e3d4cab553c4c0223e6c175694f4781acf8bfc99d3cfec48b74eb38cb511e)
            check_type(argname="argument caching_mode", value=caching_mode, expected_type=type_hints["caching_mode"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if name is not None:
            self._values["name"] = name
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def caching_mode(self) -> typing.Optional[AzureDiskPersistentVolumeCachingMode]:
        '''Host Caching mode.

        :default: - AzureDiskPersistentVolumeCachingMode.NONE.
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeCachingMode], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type to mount.

        Must be a filesystem type supported by the host operating system.

        :default: 'ext4'
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[AzureDiskPersistentVolumeKind]:
        '''Kind of disk.

        :default: AzureDiskPersistentVolumeKind.SHARED
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeKind], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Force the ReadOnly setting in VolumeMounts.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureDiskVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ClusterRolePolicyRule",
    jsii_struct_bases=[],
    name_mapping={"endpoints": "endpoints", "verbs": "verbs"},
)
class ClusterRolePolicyRule:
    def __init__(
        self,
        *,
        endpoints: typing.Sequence["IApiEndpoint"],
        verbs: typing.Sequence[builtins.str],
    ) -> None:
        '''Policy rule of a `ClusterRole.

        :param endpoints: Endpoints this rule applies to. Can be either api resources or non api resources.
        :param verbs: Verbs to allow. (e.g ['get', 'watch'])
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0156544660c9df09d5838362fb6be4e25df7b991cb03dc8fd0b1f989ac8f0e1b)
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
            "verbs": verbs,
        }

    @builtins.property
    def endpoints(self) -> typing.List["IApiEndpoint"]:
        '''Endpoints this rule applies to.

        Can be either api resources
        or non api resources.
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(typing.List["IApiEndpoint"], result)

    @builtins.property
    def verbs(self) -> typing.List[builtins.str]:
        '''Verbs to allow.

        (e.g ['get', 'watch'])
        '''
        result = self._values.get("verbs")
        assert result is not None, "Required property 'verbs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterRolePolicyRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.ConcurrencyPolicy")
class ConcurrencyPolicy(enum.Enum):
    '''Concurrency policy for CronJobs.'''

    ALLOW = "ALLOW"
    '''This policy allows to run job concurrently.'''
    FORBID = "FORBID"
    '''This policy does not allow to run job concurrently.

    It does not let a new job to be scheduled if the previous one is not finished yet.
    '''
    REPLACE = "REPLACE"
    '''This policy replaces the currently running job if a new job is being scheduled.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ConfigMapVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class ConfigMapVolumeOptions:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union["PathMapping", typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for the ConfigMap-based volume.

        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the ConfigMap or its keys must be defined. Default: - undocumented
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8c5aa4b18b102a0745cd86b2958395a35b076d41909474fa4e730685bf56fe23)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''Mode bits to use on created files by default.

        Must be a value between 0 and
        0777. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.

        :default:

        644. Directories within the path are not affected by this
        setting. This might be in conflict with other options that affect the file
        mode, like fsGroup, and the result can be other mode bits set.
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.Mapping[builtins.str, "PathMapping"]]:
        '''If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected
        into the specified paths, and unlisted keys will not be present. If a key
        is specified which is not present in the ConfigMap, the volume setup will
        error unless it is marked optional. Paths must be relative and may not
        contain the '..' path or start with '..'.

        :default: - no mapping
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "PathMapping"]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap or its keys must be defined.

        :default: - undocumented
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.ConnectionScheme")
class ConnectionScheme(enum.Enum):
    HTTP = "HTTP"
    '''Use HTTP request for connecting to host.'''
    HTTPS = "HTTPS"
    '''Use HTTPS request for connecting to host.'''


class Container(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Container"):
    '''A single application container that you want to run within a pod.'''

    def __init__(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence["EnvFrom"]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, "EnvValue"]] = None,
        image_pull_policy: typing.Optional["ImagePullPolicy"] = None,
        lifecycle: typing.Optional[typing.Union["ContainerLifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional["Probe"] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ContainerPort", typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional["Probe"] = None,
        resources: typing.Optional[typing.Union["ContainerResources", typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["ContainerSecurityContextProps", typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional["Probe"] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        props = ContainerProps(
            image=image,
            args=args,
            command=command,
            env_from=env_from,
            env_variables=env_variables,
            image_pull_policy=image_pull_policy,
            lifecycle=lifecycle,
            liveness=liveness,
            name=name,
            port=port,
            port_number=port_number,
            ports=ports,
            readiness=readiness,
            resources=resources,
            security_context=security_context,
            startup=startup,
            volume_mounts=volume_mounts,
            working_dir=working_dir,
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="addPort")
    def add_port(
        self,
        *,
        number: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional["Protocol"] = None,
    ) -> None:
        '''Add a port to expose from this container.

        :param number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param host_ip: What host IP to bind the external port to. Default: - 127.0.0.1.
        :param host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. Most containers do not need this. Default: - auto generated by kubernetes and might change on restarts.
        :param name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. Default: - port is not named.
        :param protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP". Default: Protocol.TCP
        '''
        port = ContainerPort(
            number=number,
            host_ip=host_ip,
            host_port=host_port,
            name=name,
            protocol=protocol,
        )

        return typing.cast(None, jsii.invoke(self, "addPort", [port]))

    @jsii.member(jsii_name="mount")
    def mount(
        self,
        path: builtins.str,
        storage: "IStorage",
        *,
        propagation: typing.Optional["MountPropagation"] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Mount a volume to a specific path so that it is accessible by the container.

        Every pod that is configured to use this container will autmoatically have access to the volume.

        :param path: - The desired path in the container.
        :param storage: - The storage to mount.
        :param propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. Mount propagation allows for sharing volumes mounted by a Container to other Containers in the same Pod, or even to other Pods on the same node. Default: MountPropagation.NONE
        :param read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. Default: false
        :param sub_path: Path within the volume from which the container's volume should be mounted.). Default: "" the volume's root
        :param sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). ``subPathExpr`` and ``subPath`` are mutually exclusive. Default: "" volume's root.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8a99d4ff48feb8fc2f16e5086d42b925c11c4816134a3a0d207935e0f338265)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
        options = MountOptions(
            propagation=propagation,
            read_only=read_only,
            sub_path=sub_path,
            sub_path_expr=sub_path_expr,
        )

        return typing.cast(None, jsii.invoke(self, "mount", [path, storage, options]))

    @builtins.property
    @jsii.member(jsii_name="env")
    def env(self) -> "Env":
        '''The environment of the container.'''
        return typing.cast("Env", jsii.get(self, "env"))

    @builtins.property
    @jsii.member(jsii_name="image")
    def image(self) -> builtins.str:
        '''The container image.'''
        return typing.cast(builtins.str, jsii.get(self, "image"))

    @builtins.property
    @jsii.member(jsii_name="imagePullPolicy")
    def image_pull_policy(self) -> "ImagePullPolicy":
        '''Image pull policy for this container.'''
        return typing.cast("ImagePullPolicy", jsii.get(self, "imagePullPolicy"))

    @builtins.property
    @jsii.member(jsii_name="mounts")
    def mounts(self) -> typing.List["VolumeMount"]:
        '''Volume mounts configured for this container.'''
        return typing.cast(typing.List["VolumeMount"], jsii.get(self, "mounts"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The name of the container.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="ports")
    def ports(self) -> typing.List["ContainerPort"]:
        '''Ports exposed by this containers.

        Returns a copy, use ``addPort`` to modify.
        '''
        return typing.cast(typing.List["ContainerPort"], jsii.get(self, "ports"))

    @builtins.property
    @jsii.member(jsii_name="securityContext")
    def security_context(self) -> "ContainerSecurityContext":
        '''The security context of the container.'''
        return typing.cast("ContainerSecurityContext", jsii.get(self, "securityContext"))

    @builtins.property
    @jsii.member(jsii_name="args")
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint.

        :return: a copy of the arguments array, cannot be modified.
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "args"))

    @builtins.property
    @jsii.member(jsii_name="command")
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array (the command to execute when the container starts).

        :return: a copy of the entrypoint array, cannot be modified
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "command"))

    @builtins.property
    @jsii.member(jsii_name="port")
    def port(self) -> typing.Optional[jsii.Number]:
        '''
        :deprecated: - use ``portNumber``.

        :stability: deprecated
        '''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "port"))

    @builtins.property
    @jsii.member(jsii_name="portNumber")
    def port_number(self) -> typing.Optional[jsii.Number]:
        '''The port number that was configured for this container.

        If undefined, either the container doesn't expose a port, or its
        port configuration is stored in the ``ports`` field.
        '''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "portNumber"))

    @builtins.property
    @jsii.member(jsii_name="resources")
    def resources(self) -> typing.Optional["ContainerResources"]:
        '''Compute resources (CPU and memory requests and limits) required by the container.

        :see: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        '''
        return typing.cast(typing.Optional["ContainerResources"], jsii.get(self, "resources"))

    @builtins.property
    @jsii.member(jsii_name="workingDir")
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''The working directory inside the container.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "workingDir"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ContainerLifecycle",
    jsii_struct_bases=[],
    name_mapping={"post_start": "postStart", "pre_stop": "preStop"},
)
class ContainerLifecycle:
    def __init__(
        self,
        *,
        post_start: typing.Optional["Handler"] = None,
        pre_stop: typing.Optional["Handler"] = None,
    ) -> None:
        '''Container lifecycle properties.

        :param post_start: This hook is executed immediately after a container is created. However, there is no guarantee that the hook will execute before the container ENTRYPOINT. Default: - No post start handler.
        :param pre_stop: This hook is called immediately before a container is terminated due to an API request or management event such as a liveness/startup probe failure, preemption, resource contention and others. A call to the PreStop hook fails if the container is already in a terminated or completed state and the hook must complete before the TERM signal to stop the container can be sent. The Pod's termination grace period countdown begins before the PreStop hook is executed, so regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. No parameters are passed to the handler. Default: - No pre stop handler.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d4a43b35d5a159e18818008ed650d826cbf7fb8ec2b00823590a8a8425cd805)
            check_type(argname="argument post_start", value=post_start, expected_type=type_hints["post_start"])
            check_type(argname="argument pre_stop", value=pre_stop, expected_type=type_hints["pre_stop"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if post_start is not None:
            self._values["post_start"] = post_start
        if pre_stop is not None:
            self._values["pre_stop"] = pre_stop

    @builtins.property
    def post_start(self) -> typing.Optional["Handler"]:
        '''This hook is executed immediately after a container is created.

        However,
        there is no guarantee that the hook will execute before the container ENTRYPOINT.

        :default: - No post start handler.
        '''
        result = self._values.get("post_start")
        return typing.cast(typing.Optional["Handler"], result)

    @builtins.property
    def pre_stop(self) -> typing.Optional["Handler"]:
        '''This hook is called immediately before a container is terminated due to an API request or management event such as a liveness/startup probe failure, preemption, resource contention and others.

        A call to the PreStop hook fails if the container is already in a terminated or completed state
        and the hook must complete before the TERM signal to stop the container can be sent.
        The Pod's termination grace period countdown begins before the PreStop hook is executed,
        so regardless of the outcome of the handler, the container will eventually terminate
        within the Pod's termination grace period. No parameters are passed to the handler.

        :default: - No pre stop handler.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#pod-termination
        '''
        result = self._values.get("pre_stop")
        return typing.cast(typing.Optional["Handler"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerLifecycle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ContainerPort",
    jsii_struct_bases=[],
    name_mapping={
        "number": "number",
        "host_ip": "hostIp",
        "host_port": "hostPort",
        "name": "name",
        "protocol": "protocol",
    },
)
class ContainerPort:
    def __init__(
        self,
        *,
        number: jsii.Number,
        host_ip: typing.Optional[builtins.str] = None,
        host_port: typing.Optional[jsii.Number] = None,
        name: typing.Optional[builtins.str] = None,
        protocol: typing.Optional["Protocol"] = None,
    ) -> None:
        '''Represents a network port in a single container.

        :param number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param host_ip: What host IP to bind the external port to. Default: - 127.0.0.1.
        :param host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. Most containers do not need this. Default: - auto generated by kubernetes and might change on restarts.
        :param name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. Default: - port is not named.
        :param protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP". Default: Protocol.TCP
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e6c206e8fcc9ed50b6d582c8f9b81d8c64799f6825941532b25277f14851cd0)
            check_type(argname="argument number", value=number, expected_type=type_hints["number"])
            check_type(argname="argument host_ip", value=host_ip, expected_type=type_hints["host_ip"])
            check_type(argname="argument host_port", value=host_port, expected_type=type_hints["host_port"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "number": number,
        }
        if host_ip is not None:
            self._values["host_ip"] = host_ip
        if host_port is not None:
            self._values["host_port"] = host_port
        if name is not None:
            self._values["name"] = name
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def number(self) -> jsii.Number:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.
        '''
        result = self._values.get("number")
        assert result is not None, "Required property 'number' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def host_ip(self) -> typing.Optional[builtins.str]:
        '''What host IP to bind the external port to.

        :default: - 127.0.0.1.
        '''
        result = self._values.get("host_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host_port(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the host.

        If specified, this must be a valid port number, 0 < x < 65536.
        Most containers do not need this.

        :default: - auto generated by kubernetes and might change on restarts.
        '''
        result = self._values.get("host_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''If specified, this must be an IANA_SVC_NAME and unique within the pod.

        Each named port in a pod must have a unique name.
        Name for the port that can be referred to by services.

        :default: - port is not named.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def protocol(self) -> typing.Optional["Protocol"]:
        '''Protocol for port.

        Must be UDP, TCP, or SCTP. Defaults to "TCP".

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional["Protocol"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerPort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ContainerProps",
    jsii_struct_bases=[],
    name_mapping={
        "image": "image",
        "args": "args",
        "command": "command",
        "env_from": "envFrom",
        "env_variables": "envVariables",
        "image_pull_policy": "imagePullPolicy",
        "lifecycle": "lifecycle",
        "liveness": "liveness",
        "name": "name",
        "port": "port",
        "port_number": "portNumber",
        "ports": "ports",
        "readiness": "readiness",
        "resources": "resources",
        "security_context": "securityContext",
        "startup": "startup",
        "volume_mounts": "volumeMounts",
        "working_dir": "workingDir",
    },
)
class ContainerProps:
    def __init__(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence["EnvFrom"]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, "EnvValue"]] = None,
        image_pull_policy: typing.Optional["ImagePullPolicy"] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional["Probe"] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional["Probe"] = None,
        resources: typing.Optional[typing.Union["ContainerResources", typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union["ContainerSecurityContextProps", typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional["Probe"] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union["VolumeMount", typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Properties for creating a container.

        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        if isinstance(lifecycle, dict):
            lifecycle = ContainerLifecycle(**lifecycle)
        if isinstance(resources, dict):
            resources = ContainerResources(**resources)
        if isinstance(security_context, dict):
            security_context = ContainerSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__077d1beedf2f7f8eff42ed8166d81fac24c6f8404e9a00e79c8d61a5d90d6754)
            check_type(argname="argument image", value=image, expected_type=type_hints["image"])
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument env_from", value=env_from, expected_type=type_hints["env_from"])
            check_type(argname="argument env_variables", value=env_variables, expected_type=type_hints["env_variables"])
            check_type(argname="argument image_pull_policy", value=image_pull_policy, expected_type=type_hints["image_pull_policy"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument liveness", value=liveness, expected_type=type_hints["liveness"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument port_number", value=port_number, expected_type=type_hints["port_number"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument readiness", value=readiness, expected_type=type_hints["readiness"])
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument startup", value=startup, expected_type=type_hints["startup"])
            check_type(argname="argument volume_mounts", value=volume_mounts, expected_type=type_hints["volume_mounts"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "image": image,
        }
        if args is not None:
            self._values["args"] = args
        if command is not None:
            self._values["command"] = command
        if env_from is not None:
            self._values["env_from"] = env_from
        if env_variables is not None:
            self._values["env_variables"] = env_variables
        if image_pull_policy is not None:
            self._values["image_pull_policy"] = image_pull_policy
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if liveness is not None:
            self._values["liveness"] = liveness
        if name is not None:
            self._values["name"] = name
        if port is not None:
            self._values["port"] = port
        if port_number is not None:
            self._values["port_number"] = port_number
        if ports is not None:
            self._values["ports"] = ports
        if readiness is not None:
            self._values["readiness"] = readiness
        if resources is not None:
            self._values["resources"] = resources
        if security_context is not None:
            self._values["security_context"] = security_context
        if startup is not None:
            self._values["startup"] = startup
        if volume_mounts is not None:
            self._values["volume_mounts"] = volume_mounts
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def image(self) -> builtins.str:
        '''Docker image name.'''
        result = self._values.get("image")
        assert result is not None, "Required property 'image' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def args(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided.

        Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
        double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
        regardless of whether the variable exists or not.

        Cannot be updated.

        :default: []

        :see: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        '''
        result = self._values.get("args")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def command(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Entrypoint array.

        Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment.
        If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME).
        Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated.
        More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell

        :default: - The docker image's ENTRYPOINT.
        '''
        result = self._values.get("command")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def env_from(self) -> typing.Optional[typing.List["EnvFrom"]]:
        '''List of sources to populate environment variables in the container.

        When a key exists in multiple sources, the value associated with
        the last source will take precedence. Values defined by the ``envVariables`` property
        with a duplicate key will take precedence.

        :default: - No sources.
        '''
        result = self._values.get("env_from")
        return typing.cast(typing.Optional[typing.List["EnvFrom"]], result)

    @builtins.property
    def env_variables(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "EnvValue"]]:
        '''Environment variables to set in the container.

        :default: - No environment variables.
        '''
        result = self._values.get("env_variables")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "EnvValue"]], result)

    @builtins.property
    def image_pull_policy(self) -> typing.Optional["ImagePullPolicy"]:
        '''Image pull policy for this container.

        :default: ImagePullPolicy.ALWAYS
        '''
        result = self._values.get("image_pull_policy")
        return typing.cast(typing.Optional["ImagePullPolicy"], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional[ContainerLifecycle]:
        '''Describes actions that the management system should take in response to container lifecycle events.'''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional[ContainerLifecycle], result)

    @builtins.property
    def liveness(self) -> typing.Optional["Probe"]:
        '''Periodic probe of container liveness.

        Container will be restarted if the probe fails.

        :default: - no liveness probe is defined
        '''
        result = self._values.get("liveness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''Name of the container specified as a DNS_LABEL.

        Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.

        :default: 'main'
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''
        :deprecated: - use ``portNumber``.

        :stability: deprecated
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port_number(self) -> typing.Optional[jsii.Number]:
        '''Number of port to expose on the pod's IP address.

        This must be a valid port number, 0 < x < 65536.

        This is a convinience property if all you need a single TCP numbered port.
        In case more advanced configuartion is required, use the ``ports`` property.

        This port is added to the list of ports mentioned in the ``ports`` property.

        :default: - Only the ports mentiond in the ``ports`` property are exposed.
        '''
        result = self._values.get("port_number")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ContainerPort]]:
        '''List of ports to expose from this container.

        :default: - Only the port mentioned in the ``portNumber`` property is exposed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ContainerPort]], result)

    @builtins.property
    def readiness(self) -> typing.Optional["Probe"]:
        '''Determines when the container is ready to serve traffic.

        :default: - no readiness probe is defined
        '''
        result = self._values.get("readiness")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def resources(self) -> typing.Optional["ContainerResources"]:
        '''Compute resources (CPU and memory requests and limits) required by the container.

        :default:

        cpu:
        request: 1000 millis
        limit: 1500 millis
        memory:
        request: 512 mebibytes
        limit: 2048 mebibytes

        :see: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        '''
        result = self._values.get("resources")
        return typing.cast(typing.Optional["ContainerResources"], result)

    @builtins.property
    def security_context(self) -> typing.Optional["ContainerSecurityContextProps"]:
        '''SecurityContext defines the security options the container should be run with.

        If set, the fields override equivalent fields of the pod's security context.

        :default:

        ensureNonRoot: true
        privileged: false
        readOnlyRootFilesystem: true
        allowPrivilegeEscalation: false
        user: 25000
        group: 26000

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional["ContainerSecurityContextProps"], result)

    @builtins.property
    def startup(self) -> typing.Optional["Probe"]:
        '''StartupProbe indicates that the Pod has successfully initialized.

        If specified, no other probes are executed until this completes successfully

        :default:

        - If a port is provided, then knocks on that port
        to determine when the container is ready for readiness and
        liveness probe checks.
        Otherwise, no startup probe is defined.
        '''
        result = self._values.get("startup")
        return typing.cast(typing.Optional["Probe"], result)

    @builtins.property
    def volume_mounts(self) -> typing.Optional[typing.List["VolumeMount"]]:
        '''Pod volumes to mount into the container's filesystem.

        Cannot be updated.
        '''
        result = self._values.get("volume_mounts")
        return typing.cast(typing.Optional[typing.List["VolumeMount"]], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''Container's working directory.

        If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.

        :default: - The container runtime's default.
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ContainerResources",
    jsii_struct_bases=[],
    name_mapping={
        "cpu": "cpu",
        "ephemeral_storage": "ephemeralStorage",
        "memory": "memory",
    },
)
class ContainerResources:
    def __init__(
        self,
        *,
        cpu: typing.Optional[typing.Union["CpuResources", typing.Dict[builtins.str, typing.Any]]] = None,
        ephemeral_storage: typing.Optional[typing.Union["EphemeralStorageResources", typing.Dict[builtins.str, typing.Any]]] = None,
        memory: typing.Optional[typing.Union["MemoryResources", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''CPU and memory compute resources.

        :param cpu: 
        :param ephemeral_storage: 
        :param memory: 
        '''
        if isinstance(cpu, dict):
            cpu = CpuResources(**cpu)
        if isinstance(ephemeral_storage, dict):
            ephemeral_storage = EphemeralStorageResources(**ephemeral_storage)
        if isinstance(memory, dict):
            memory = MemoryResources(**memory)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__481e5d68036db6694f2f15f02079bca500acf41f91320a7d907e506682091781)
            check_type(argname="argument cpu", value=cpu, expected_type=type_hints["cpu"])
            check_type(argname="argument ephemeral_storage", value=ephemeral_storage, expected_type=type_hints["ephemeral_storage"])
            check_type(argname="argument memory", value=memory, expected_type=type_hints["memory"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if cpu is not None:
            self._values["cpu"] = cpu
        if ephemeral_storage is not None:
            self._values["ephemeral_storage"] = ephemeral_storage
        if memory is not None:
            self._values["memory"] = memory

    @builtins.property
    def cpu(self) -> typing.Optional["CpuResources"]:
        result = self._values.get("cpu")
        return typing.cast(typing.Optional["CpuResources"], result)

    @builtins.property
    def ephemeral_storage(self) -> typing.Optional["EphemeralStorageResources"]:
        result = self._values.get("ephemeral_storage")
        return typing.cast(typing.Optional["EphemeralStorageResources"], result)

    @builtins.property
    def memory(self) -> typing.Optional["MemoryResources"]:
        result = self._values.get("memory")
        return typing.cast(typing.Optional["MemoryResources"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ContainerSecurityContext(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.ContainerSecurityContext",
):
    '''Container security attributes and settings.'''

    def __init__(
        self,
        *,
        allow_privilege_escalation: typing.Optional[builtins.bool] = None,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        group: typing.Optional[jsii.Number] = None,
        privileged: typing.Optional[builtins.bool] = None,
        read_only_root_filesystem: typing.Optional[builtins.bool] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param allow_privilege_escalation: Whether a process can gain more privileges than its parent process. Default: false
        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param group: The GID to run the entrypoint of the container process. Default: - 26000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        :param privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Default: false
        :param read_only_root_filesystem: Whether this container has a read-only root filesystem. Default: true
        :param user: The UID to run the entrypoint of the container process. Default: - 25000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        '''
        props = ContainerSecurityContextProps(
            allow_privilege_escalation=allow_privilege_escalation,
            ensure_non_root=ensure_non_root,
            group=group,
            privileged=privileged,
            read_only_root_filesystem=read_only_root_filesystem,
            user=user,
        )

        jsii.create(self.__class__, self, [props])

    @builtins.property
    @jsii.member(jsii_name="ensureNonRoot")
    def ensure_non_root(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "ensureNonRoot"))

    @builtins.property
    @jsii.member(jsii_name="privileged")
    def privileged(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "privileged"))

    @builtins.property
    @jsii.member(jsii_name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "readOnlyRootFilesystem"))

    @builtins.property
    @jsii.member(jsii_name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> typing.Optional[builtins.bool]:
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "allowPrivilegeEscalation"))

    @builtins.property
    @jsii.member(jsii_name="group")
    def group(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "group"))

    @builtins.property
    @jsii.member(jsii_name="user")
    def user(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "user"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ContainerSecurityContextProps",
    jsii_struct_bases=[],
    name_mapping={
        "allow_privilege_escalation": "allowPrivilegeEscalation",
        "ensure_non_root": "ensureNonRoot",
        "group": "group",
        "privileged": "privileged",
        "read_only_root_filesystem": "readOnlyRootFilesystem",
        "user": "user",
    },
)
class ContainerSecurityContextProps:
    def __init__(
        self,
        *,
        allow_privilege_escalation: typing.Optional[builtins.bool] = None,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        group: typing.Optional[jsii.Number] = None,
        privileged: typing.Optional[builtins.bool] = None,
        read_only_root_filesystem: typing.Optional[builtins.bool] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties for ``ContainerSecurityContext``.

        :param allow_privilege_escalation: Whether a process can gain more privileges than its parent process. Default: false
        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param group: The GID to run the entrypoint of the container process. Default: - 26000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        :param privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Default: false
        :param read_only_root_filesystem: Whether this container has a read-only root filesystem. Default: true
        :param user: The UID to run the entrypoint of the container process. Default: - 25000. An arbitrary number bigger than 9999 is selected here. This is so that the container is blocked to access host files even if somehow it manages to get access to host file system.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d3913b9d206a00627a1c8f6b818c811cc0cb5e4375c3cbc5555379f1be6f8d8b)
            check_type(argname="argument allow_privilege_escalation", value=allow_privilege_escalation, expected_type=type_hints["allow_privilege_escalation"])
            check_type(argname="argument ensure_non_root", value=ensure_non_root, expected_type=type_hints["ensure_non_root"])
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument privileged", value=privileged, expected_type=type_hints["privileged"])
            check_type(argname="argument read_only_root_filesystem", value=read_only_root_filesystem, expected_type=type_hints["read_only_root_filesystem"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if allow_privilege_escalation is not None:
            self._values["allow_privilege_escalation"] = allow_privilege_escalation
        if ensure_non_root is not None:
            self._values["ensure_non_root"] = ensure_non_root
        if group is not None:
            self._values["group"] = group
        if privileged is not None:
            self._values["privileged"] = privileged
        if read_only_root_filesystem is not None:
            self._values["read_only_root_filesystem"] = read_only_root_filesystem
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def allow_privilege_escalation(self) -> typing.Optional[builtins.bool]:
        '''Whether a process can gain more privileges than its parent process.

        :default: false
        '''
        result = self._values.get("allow_privilege_escalation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def ensure_non_root(self) -> typing.Optional[builtins.bool]:
        '''Indicates that the container must run as a non-root user.

        If true, the Kubelet will validate the image at runtime to ensure that it does
        not run as UID 0 (root) and fail to start the container if it does.

        :default: true
        '''
        result = self._values.get("ensure_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def group(self) -> typing.Optional[jsii.Number]:
        '''The GID to run the entrypoint of the container process.

        :default:

        -
        26000. An arbitrary number bigger than 9999 is selected here.
        This is so that the container is blocked to access host files even if
        somehow it manages to get access to host file system.
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def privileged(self) -> typing.Optional[builtins.bool]:
        '''Run container in privileged mode.

        Processes in privileged containers are essentially equivalent to root on the host.

        :default: false
        '''
        result = self._values.get("privileged")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def read_only_root_filesystem(self) -> typing.Optional[builtins.bool]:
        '''Whether this container has a read-only root filesystem.

        :default: true
        '''
        result = self._values.get("read_only_root_filesystem")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def user(self) -> typing.Optional[jsii.Number]:
        '''The UID to run the entrypoint of the container process.

        :default:

        -
        25000. An arbitrary number bigger than 9999 is selected here.
        This is so that the container is blocked to access host files even if
        somehow it manages to get access to host file system.
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ContainerSecurityContextProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Cpu(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Cpu"):
    '''Represents the amount of CPU.

    The amount can be passed as millis or units.
    '''

    @jsii.member(jsii_name="millis")
    @builtins.classmethod
    def millis(cls, amount: jsii.Number) -> "Cpu":
        '''
        :param amount: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6fff4163763c9a0bd23123d3e3455cfd3d39af873d81aab0cbe11269e170e90e)
            check_type(argname="argument amount", value=amount, expected_type=type_hints["amount"])
        return typing.cast("Cpu", jsii.sinvoke(cls, "millis", [amount]))

    @jsii.member(jsii_name="units")
    @builtins.classmethod
    def units(cls, amount: jsii.Number) -> "Cpu":
        '''
        :param amount: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c47474054b4942569a65708cdeade621a842a4d6115d42528489bc482981df98)
            check_type(argname="argument amount", value=amount, expected_type=type_hints["amount"])
        return typing.cast("Cpu", jsii.sinvoke(cls, "units", [amount]))

    @builtins.property
    @jsii.member(jsii_name="amount")
    def amount(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "amount"))

    @amount.setter
    def amount(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64b0b8a055141ec984455e57974b90f7f6b49146dcd999540e834bd9348d02a5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "amount", value)


@jsii.data_type(
    jsii_type="cdk8s-plus-23.CpuResources",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "request": "request"},
)
class CpuResources:
    def __init__(
        self,
        *,
        limit: typing.Optional[Cpu] = None,
        request: typing.Optional[Cpu] = None,
    ) -> None:
        '''CPU request and limit.

        :param limit: 
        :param request: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d167b8a1f5220dbffc26afbabf635c4e41d936597cc801233d4817964d7673b2)
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if request is not None:
            self._values["request"] = request

    @builtins.property
    def limit(self) -> typing.Optional[Cpu]:
        result = self._values.get("limit")
        return typing.cast(typing.Optional[Cpu], result)

    @builtins.property
    def request(self) -> typing.Optional[Cpu]:
        result = self._values.get("request")
        return typing.cast(typing.Optional[Cpu], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CpuResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.DeploymentExposeViaServiceOptions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "ports": "ports", "service_type": "serviceType"},
)
class DeploymentExposeViaServiceOptions:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ServicePort", typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional["ServiceType"] = None,
    ) -> None:
        '''Options for ``Deployment.exposeViaService``.

        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__999b753d9a7dfb45be09c8aa3d2c77b87b576709ac55e47716a3568d031750fc)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument service_type", value=service_type, expected_type=type_hints["service_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if ports is not None:
            self._values["ports"] = ports
        if service_type is not None:
            self._values["service_type"] = service_type

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the service to expose.

        If you'd like to expose the deployment multiple times,
        you must explicitly set a name starting from the second expose call.

        :default: - auto generated.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["ServicePort"]]:
        '''The ports that the service should bind to.

        :default: - extracted from the deployment.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["ServicePort"]], result)

    @builtins.property
    def service_type(self) -> typing.Optional["ServiceType"]:
        '''The type of the exposed service.

        :default: - ClusterIP.
        '''
        result = self._values.get("service_type")
        return typing.cast(typing.Optional["ServiceType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentExposeViaServiceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DeploymentStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.DeploymentStrategy",
):
    '''Deployment strategies.'''

    @jsii.member(jsii_name="recreate")
    @builtins.classmethod
    def recreate(cls) -> "DeploymentStrategy":
        '''All existing Pods are killed before new ones are created.

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#recreate-deployment
        '''
        return typing.cast("DeploymentStrategy", jsii.sinvoke(cls, "recreate", []))

    @jsii.member(jsii_name="rollingUpdate")
    @builtins.classmethod
    def rolling_update(
        cls,
        *,
        max_surge: typing.Optional["PercentOrAbsolute"] = None,
        max_unavailable: typing.Optional["PercentOrAbsolute"] = None,
    ) -> "DeploymentStrategy":
        '''
        :param max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0 if ``maxUnavailable`` is 0. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods. Default: '25%'
        :param max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if ``maxSurge`` is 0. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods. Default: '25%'
        '''
        options = DeploymentStrategyRollingUpdateOptions(
            max_surge=max_surge, max_unavailable=max_unavailable
        )

        return typing.cast("DeploymentStrategy", jsii.sinvoke(cls, "rollingUpdate", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.DeploymentStrategyRollingUpdateOptions",
    jsii_struct_bases=[],
    name_mapping={"max_surge": "maxSurge", "max_unavailable": "maxUnavailable"},
)
class DeploymentStrategyRollingUpdateOptions:
    def __init__(
        self,
        *,
        max_surge: typing.Optional["PercentOrAbsolute"] = None,
        max_unavailable: typing.Optional["PercentOrAbsolute"] = None,
    ) -> None:
        '''Options for ``DeploymentStrategy.rollingUpdate``.

        :param max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0 if ``maxUnavailable`` is 0. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods. Default: '25%'
        :param max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if ``maxSurge`` is 0. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods. Default: '25%'
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5df4d3f3c1830422843bc640efa015bb59e604342cdfbffafd2b1fcb81c17244)
            check_type(argname="argument max_surge", value=max_surge, expected_type=type_hints["max_surge"])
            check_type(argname="argument max_unavailable", value=max_unavailable, expected_type=type_hints["max_unavailable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if max_surge is not None:
            self._values["max_surge"] = max_surge
        if max_unavailable is not None:
            self._values["max_unavailable"] = max_unavailable

    @builtins.property
    def max_surge(self) -> typing.Optional["PercentOrAbsolute"]:
        '''The maximum number of pods that can be scheduled above the desired number of pods.

        Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
        Absolute number is calculated from percentage by rounding up.
        This can not be 0 if ``maxUnavailable`` is 0.

        Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update
        starts, such that the total number of old and new pods do not exceed 130% of desired pods.
        Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that
        total number of pods running at any time during the update is at most 130% of desired pods.

        :default: '25%'
        '''
        result = self._values.get("max_surge")
        return typing.cast(typing.Optional["PercentOrAbsolute"], result)

    @builtins.property
    def max_unavailable(self) -> typing.Optional["PercentOrAbsolute"]:
        '''The maximum number of pods that can be unavailable during the update.

        Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
        Absolute number is calculated from percentage by rounding down.
        This can not be 0 if ``maxSurge`` is 0.

        Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired
        pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can
        be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total
        number of pods available at all times during the update is at least 70% of desired pods.

        :default: '25%'
        '''
        result = self._values.get("max_unavailable")
        return typing.cast(typing.Optional["PercentOrAbsolute"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentStrategyRollingUpdateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.DnsOption",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class DnsOption:
    def __init__(
        self,
        *,
        name: builtins.str,
        value: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Custom DNS option.

        :param name: Option name.
        :param value: Option value. Default: - No value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02c93aa76e2914958e11bc0efed685a5525a60676b138726fa2bc37b938e30db)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
        }
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def name(self) -> builtins.str:
        '''Option name.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> typing.Optional[builtins.str]:
        '''Option value.

        :default: - No value.
        '''
        result = self._values.get("value")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DnsOption(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.DnsPolicy")
class DnsPolicy(enum.Enum):
    '''Pod DNS policies.'''

    CLUSTER_FIRST = "CLUSTER_FIRST"
    '''Any DNS query that does not match the configured cluster domain suffix, such as "www.kubernetes.io", is forwarded to the upstream nameserver inherited from the node. Cluster administrators may have extra stub-domain and upstream DNS servers configured.'''
    CLUSTER_FIRST_WITH_HOST_NET = "CLUSTER_FIRST_WITH_HOST_NET"
    '''For Pods running with hostNetwork, you should explicitly set its DNS policy "ClusterFirstWithHostNet".'''
    DEFAULT = "DEFAULT"
    '''The Pod inherits the name resolution configuration from the node that the pods run on.'''
    NONE = "NONE"
    '''It allows a Pod to ignore DNS settings from the Kubernetes environment.

    All DNS settings are supposed to be provided using the dnsConfig
    field in the Pod Spec.
    '''


@jsii.enum(jsii_type="cdk8s-plus-23.EmptyDirMedium")
class EmptyDirMedium(enum.Enum):
    '''The medium on which to store the volume.'''

    DEFAULT = "DEFAULT"
    '''The default volume of the backing node.'''
    MEMORY = "MEMORY"
    '''Mount a tmpfs (RAM-backed filesystem) for you instead.

    While tmpfs is very
    fast, be aware that unlike disks, tmpfs is cleared on node reboot and any
    files you write will count against your Container's memory limit.
    '''


@jsii.data_type(
    jsii_type="cdk8s-plus-23.EmptyDirVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"medium": "medium", "size_limit": "sizeLimit"},
)
class EmptyDirVolumeOptions:
    def __init__(
        self,
        *,
        medium: typing.Optional[EmptyDirMedium] = None,
        size_limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> None:
        '''Options for volumes populated with an empty directory.

        :param medium: By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment. However, you can set the emptyDir.medium field to ``EmptyDirMedium.MEMORY`` to tell Kubernetes to mount a tmpfs (RAM-backed filesystem) for you instead. While tmpfs is very fast, be aware that unlike disks, tmpfs is cleared on node reboot and any files you write will count against your Container's memory limit. Default: EmptyDirMedium.DEFAULT
        :param size_limit: Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. Default: - limit is undefined
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3c7dca4e6af57253de9440ed3e229cc2b7d8d53036ada30e8f11239bc43824c3)
            check_type(argname="argument medium", value=medium, expected_type=type_hints["medium"])
            check_type(argname="argument size_limit", value=size_limit, expected_type=type_hints["size_limit"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if medium is not None:
            self._values["medium"] = medium
        if size_limit is not None:
            self._values["size_limit"] = size_limit

    @builtins.property
    def medium(self) -> typing.Optional[EmptyDirMedium]:
        '''By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment.

        However, you can set the emptyDir.medium field to
        ``EmptyDirMedium.MEMORY`` to tell Kubernetes to mount a tmpfs (RAM-backed
        filesystem) for you instead. While tmpfs is very fast, be aware that unlike
        disks, tmpfs is cleared on node reboot and any files you write will count
        against your Container's memory limit.

        :default: EmptyDirMedium.DEFAULT
        '''
        result = self._values.get("medium")
        return typing.cast(typing.Optional[EmptyDirMedium], result)

    @builtins.property
    def size_limit(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Total amount of local storage required for this EmptyDir volume.

        The size
        limit is also applicable for memory medium. The maximum usage on memory
        medium EmptyDir would be the minimum value between the SizeLimit specified
        here and the sum of memory limits of all containers in a pod.

        :default: - limit is undefined
        '''
        result = self._values.get("size_limit")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EmptyDirVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Env(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Env"):
    '''Container environment variables.'''

    def __init__(
        self,
        sources: typing.Sequence["EnvFrom"],
        variables: typing.Mapping[builtins.str, "EnvValue"],
    ) -> None:
        '''
        :param sources: -
        :param variables: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d4d8559592e4cafee176d11182dbe870f85a9c593db008bb6c6cda11a676e3c2)
            check_type(argname="argument sources", value=sources, expected_type=type_hints["sources"])
            check_type(argname="argument variables", value=variables, expected_type=type_hints["variables"])
        jsii.create(self.__class__, self, [sources, variables])

    @jsii.member(jsii_name="fromConfigMap")
    @builtins.classmethod
    def from_config_map(
        cls,
        config_map: "IConfigMap",
        prefix: typing.Optional[builtins.str] = None,
    ) -> "EnvFrom":
        '''Selects a ConfigMap to populate the environment variables with.

        The contents of the target ConfigMap's Data field will represent
        the key-value pairs as environment variables.

        :param config_map: -
        :param prefix: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c6f4de7143f8de40d0dd0b28f7be438e6004c9f0a2ed07c9dbc35a87b8a5de6)
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        return typing.cast("EnvFrom", jsii.sinvoke(cls, "fromConfigMap", [config_map, prefix]))

    @jsii.member(jsii_name="fromSecret")
    @builtins.classmethod
    def from_secret(cls, secr: "ISecret") -> "EnvFrom":
        '''Selects a Secret to populate the environment variables with.

        The contents of the target Secret's Data field will represent
        the key-value pairs as environment variables.

        :param secr: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__376d3fcaeafa448425023bca09764307888a3f1c135c39935686a4311eb1f60e)
            check_type(argname="argument secr", value=secr, expected_type=type_hints["secr"])
        return typing.cast("EnvFrom", jsii.sinvoke(cls, "fromSecret", [secr]))

    @jsii.member(jsii_name="addVariable")
    def add_variable(self, name: builtins.str, value: "EnvValue") -> None:
        '''Add a single variable by name and value.

        The variable value can come from various dynamic sources such a secrets of config maps.
        Use ``EnvValue.fromXXX`` to select sources.

        :param name: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5d0505f6025237e70d62a582f2dc6631523f3d6314f51716dfcfcd0871be06e4)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addVariable", [name, value]))

    @jsii.member(jsii_name="copyFrom")
    def copy_from(self, from_: "EnvFrom") -> None:
        '''Add a collection of variables by copying from another source.

        Use ``Env.fromXXX`` functions to select sources.

        :param from_: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fc879901ba71b6a5286bd17d8af689b5886b7862591799686f9ac37e0edaeb98)
            check_type(argname="argument from_", value=from_, expected_type=type_hints["from_"])
        return typing.cast(None, jsii.invoke(self, "copyFrom", [from_]))

    @builtins.property
    @jsii.member(jsii_name="sources")
    def sources(self) -> typing.List["EnvFrom"]:
        '''The list of sources used to populate the container environment, in addition to the ``variables``.

        Returns a copy. To add a source use ``container.env.copyFrom()``.
        '''
        return typing.cast(typing.List["EnvFrom"], jsii.get(self, "sources"))

    @builtins.property
    @jsii.member(jsii_name="variables")
    def variables(self) -> typing.Mapping[builtins.str, "EnvValue"]:
        '''The environment variables for this container.

        Returns a copy. To add environment variables use ``container.env.addVariable()``.
        '''
        return typing.cast(typing.Mapping[builtins.str, "EnvValue"], jsii.get(self, "variables"))


@jsii.enum(jsii_type="cdk8s-plus-23.EnvFieldPaths")
class EnvFieldPaths(enum.Enum):
    POD_NAME = "POD_NAME"
    '''The name of the pod.'''
    POD_NAMESPACE = "POD_NAMESPACE"
    '''The namespace of the pod.'''
    POD_UID = "POD_UID"
    '''The uid of the pod.'''
    POD_LABEL = "POD_LABEL"
    '''The labels of the pod.'''
    POD_ANNOTATION = "POD_ANNOTATION"
    '''The annotations of the pod.'''
    POD_IP = "POD_IP"
    '''The ipAddress of the pod.'''
    SERVICE_ACCOUNT_NAME = "SERVICE_ACCOUNT_NAME"
    '''The service account name of the pod.'''
    NODE_NAME = "NODE_NAME"
    '''The name of the node.'''
    NODE_IP = "NODE_IP"
    '''The ipAddress of the node.'''
    POD_IPS = "POD_IPS"
    '''The ipAddresess of the pod.'''


class EnvFrom(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.EnvFrom"):
    '''A collection of env variables defined in other resources.'''

    def __init__(
        self,
        config_map: typing.Optional["IConfigMap"] = None,
        prefix: typing.Optional[builtins.str] = None,
        sec: typing.Optional["ISecret"] = None,
    ) -> None:
        '''
        :param config_map: -
        :param prefix: -
        :param sec: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a10644a931ab341fa44ddbc17eca19db1083933d22d46cdd4c348d998a69c6e)
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument sec", value=sec, expected_type=type_hints["sec"])
        jsii.create(self.__class__, self, [config_map, prefix, sec])


class EnvValue(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.EnvValue"):
    '''Utility class for creating reading env values from various sources.'''

    @jsii.member(jsii_name="fromConfigMap")
    @builtins.classmethod
    def from_config_map(
        cls,
        config_map: "IConfigMap",
        key: builtins.str,
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "EnvValue":
        '''Create a value by reading a specific key inside a config map.

        :param config_map: - The config map.
        :param key: - The key to extract the value from.
        :param optional: Specify whether the ConfigMap or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__16605ecba5dbb06ed10676145544c60128aaea9b110611af2a9407ea55d575bf)
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromConfigMapOptions(optional=optional)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromConfigMap", [config_map, key, options]))

    @jsii.member(jsii_name="fromFieldRef")
    @builtins.classmethod
    def from_field_ref(
        cls,
        field_path: EnvFieldPaths,
        *,
        api_version: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
    ) -> "EnvValue":
        '''Create a value from a field reference.

        :param field_path: : The field reference.
        :param api_version: Version of the schema the FieldPath is written in terms of.
        :param key: The key to select the pod label or annotation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8791f321d5053f094623d86f3539286e4087cc23c006307f48d336b68a816ba8)
            check_type(argname="argument field_path", value=field_path, expected_type=type_hints["field_path"])
        options = EnvValueFromFieldRefOptions(api_version=api_version, key=key)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromFieldRef", [field_path, options]))

    @jsii.member(jsii_name="fromProcess")
    @builtins.classmethod
    def from_process(
        cls,
        key: builtins.str,
        *,
        required: typing.Optional[builtins.bool] = None,
    ) -> "EnvValue":
        '''Create a value from a key in the current process environment.

        :param key: - The key to read.
        :param required: Specify whether the key must exist in the environment. If this is set to true, and the key does not exist, an error will thrown. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eeb507e60cc226fa1b062094a432264022db18f186716af37eae73c80786dbfb)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = EnvValueFromProcessOptions(required=required)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromProcess", [key, options]))

    @jsii.member(jsii_name="fromResource")
    @builtins.classmethod
    def from_resource(
        cls,
        resource: "ResourceFieldPaths",
        *,
        container: typing.Optional[Container] = None,
        divisor: typing.Optional[builtins.str] = None,
    ) -> "EnvValue":
        '''Create a value from a resource.

        :param resource: : Resource to select the value from.
        :param container: The container to select the value from.
        :param divisor: The output format of the exposed resource.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__14814676d1e988516cf23956dc6299de50b08a14e837cba996ed68df31284ae9)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
        options = EnvValueFromResourceOptions(container=container, divisor=divisor)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromResource", [resource, options]))

    @jsii.member(jsii_name="fromSecretValue")
    @builtins.classmethod
    def from_secret_value(
        cls,
        secret_value: typing.Union["SecretValue", typing.Dict[builtins.str, typing.Any]],
        *,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "EnvValue":
        '''Defines an environment value from a secret JSON value.

        :param secret_value: The secret value (secrent + key).
        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a8adf6f7f4a95a874380f91ab1f2a1777f67505981bd6447dbfa96d079fd4ff2)
            check_type(argname="argument secret_value", value=secret_value, expected_type=type_hints["secret_value"])
        options = EnvValueFromSecretOptions(optional=optional)

        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromSecretValue", [secret_value, options]))

    @jsii.member(jsii_name="fromValue")
    @builtins.classmethod
    def from_value(cls, value: builtins.str) -> "EnvValue":
        '''Create a value from the given argument.

        :param value: - The value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce08632791289bc283b29947d1377948457b892cc8b8255021892f032a525dc9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("EnvValue", jsii.sinvoke(cls, "fromValue", [value]))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "value"))

    @builtins.property
    @jsii.member(jsii_name="valueFrom")
    def value_from(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "valueFrom"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.EnvValueFromConfigMapOptions",
    jsii_struct_bases=[],
    name_mapping={"optional": "optional"},
)
class EnvValueFromConfigMapOptions:
    def __init__(self, *, optional: typing.Optional[builtins.bool] = None) -> None:
        '''Options to specify an envionment variable value from a ConfigMap key.

        :param optional: Specify whether the ConfigMap or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__588f1312e36214ab38b8c4bf7f592ded9e23aac16130f22bcb1a5c5f50e61cb0)
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the ConfigMap or its key must be defined.

        :default: false
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromConfigMapOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.EnvValueFromFieldRefOptions",
    jsii_struct_bases=[],
    name_mapping={"api_version": "apiVersion", "key": "key"},
)
class EnvValueFromFieldRefOptions:
    def __init__(
        self,
        *,
        api_version: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options to specify an environment variable value from a field reference.

        :param api_version: Version of the schema the FieldPath is written in terms of.
        :param key: The key to select the pod label or annotation.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3bb4a7f9086569e4e792a5a4def08b7a80708102f3506c660569680d792285f4)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if api_version is not None:
            self._values["api_version"] = api_version
        if key is not None:
            self._values["key"] = key

    @builtins.property
    def api_version(self) -> typing.Optional[builtins.str]:
        '''Version of the schema the FieldPath is written in terms of.'''
        result = self._values.get("api_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''The key to select the pod label or annotation.'''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromFieldRefOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.EnvValueFromProcessOptions",
    jsii_struct_bases=[],
    name_mapping={"required": "required"},
)
class EnvValueFromProcessOptions:
    def __init__(self, *, required: typing.Optional[builtins.bool] = None) -> None:
        '''Options to specify an environment variable value from the process environment.

        :param required: Specify whether the key must exist in the environment. If this is set to true, and the key does not exist, an error will thrown. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cfe2fd55adbd6510097a74fde9121ae0266583a800cf0ee37a49ceb4634cd00f)
            check_type(argname="argument required", value=required, expected_type=type_hints["required"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if required is not None:
            self._values["required"] = required

    @builtins.property
    def required(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the key must exist in the environment.

        If this is set to true, and the key does not exist, an error will thrown.

        :default: false
        '''
        result = self._values.get("required")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromProcessOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.EnvValueFromResourceOptions",
    jsii_struct_bases=[],
    name_mapping={"container": "container", "divisor": "divisor"},
)
class EnvValueFromResourceOptions:
    def __init__(
        self,
        *,
        container: typing.Optional[Container] = None,
        divisor: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options to specify an environment variable value from a resource.

        :param container: The container to select the value from.
        :param divisor: The output format of the exposed resource.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9202d760c4858b2e0e26a4165baa1bc3877b745e6d64f482d90b5290c4c6c598)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument divisor", value=divisor, expected_type=type_hints["divisor"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if container is not None:
            self._values["container"] = container
        if divisor is not None:
            self._values["divisor"] = divisor

    @builtins.property
    def container(self) -> typing.Optional[Container]:
        '''The container to select the value from.'''
        result = self._values.get("container")
        return typing.cast(typing.Optional[Container], result)

    @builtins.property
    def divisor(self) -> typing.Optional[builtins.str]:
        '''The output format of the exposed resource.'''
        result = self._values.get("divisor")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.EnvValueFromSecretOptions",
    jsii_struct_bases=[],
    name_mapping={"optional": "optional"},
)
class EnvValueFromSecretOptions:
    def __init__(self, *, optional: typing.Optional[builtins.bool] = None) -> None:
        '''Options to specify an environment variable value from a Secret.

        :param optional: Specify whether the Secret or its key must be defined. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__041a72fa1eb85b9152d0dde92c47279fb9941e0b2bed1b47455c73eee20acf85)
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the Secret or its key must be defined.

        :default: false
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EnvValueFromSecretOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.EphemeralStorageResources",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "request": "request"},
)
class EphemeralStorageResources:
    def __init__(
        self,
        *,
        limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        request: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> None:
        '''Emphemeral storage request and limit.

        :param limit: 
        :param request: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9aed8e9590e4d726c6932c5017c4152f05c0b1d836b6b190615a0e889ce07215)
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if request is not None:
            self._values["request"] = request

    @builtins.property
    def limit(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("limit")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def request(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("request")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EphemeralStorageResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ExposeServiceViaIngressOptions",
    jsii_struct_bases=[],
    name_mapping={"ingress": "ingress", "path_type": "pathType"},
)
class ExposeServiceViaIngressOptions:
    def __init__(
        self,
        *,
        ingress: typing.Optional["Ingress"] = None,
        path_type: typing.Optional["HttpIngressPathType"] = None,
    ) -> None:
        '''Options for exposing a service using an ingress.

        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__57fb36fb6d54d40d0d8624007d96e2a97e61292eb59ff67aa1c8653328f20a35)
            check_type(argname="argument ingress", value=ingress, expected_type=type_hints["ingress"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ingress is not None:
            self._values["ingress"] = ingress
        if path_type is not None:
            self._values["path_type"] = path_type

    @builtins.property
    def ingress(self) -> typing.Optional["Ingress"]:
        '''The ingress to add rules to.

        :default: - An ingress will be automatically created.
        '''
        result = self._values.get("ingress")
        return typing.cast(typing.Optional["Ingress"], result)

    @builtins.property
    def path_type(self) -> typing.Optional["HttpIngressPathType"]:
        '''The type of the path.

        :default: HttpIngressPathType.PREFIX
        '''
        result = self._values.get("path_type")
        return typing.cast(typing.Optional["HttpIngressPathType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExposeServiceViaIngressOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.FromServiceAccountNameOptions",
    jsii_struct_bases=[],
    name_mapping={"namespace_name": "namespaceName"},
)
class FromServiceAccountNameOptions:
    def __init__(self, *, namespace_name: typing.Optional[builtins.str] = None) -> None:
        '''
        :param namespace_name: The name of the namespace the service account belongs to. Default: "default"
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d5946d06364048de8726979f2837314237d765b8eaad977e24db855059b802c)
            check_type(argname="argument namespace_name", value=namespace_name, expected_type=type_hints["namespace_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if namespace_name is not None:
            self._values["namespace_name"] = namespace_name

    @builtins.property
    def namespace_name(self) -> typing.Optional[builtins.str]:
        '''The name of the namespace the service account belongs to.

        :default: "default"
        '''
        result = self._values.get("namespace_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FromServiceAccountNameOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.FsGroupChangePolicy")
class FsGroupChangePolicy(enum.Enum):
    ON_ROOT_MISMATCH = "ON_ROOT_MISMATCH"
    '''Only change permissions and ownership if permission and ownership of root directory does not match with expected permissions of the volume.

    This could help shorten the time it takes to change ownership and permission of a volume
    '''
    ALWAYS = "ALWAYS"
    '''Always change permission and ownership of the volume when volume is mounted.'''


@jsii.data_type(
    jsii_type="cdk8s-plus-23.GCEPersistentDiskVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "fs_type": "fsType",
        "name": "name",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class GCEPersistentDiskVolumeOptions:
    def __init__(
        self,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options of ``Volume.fromGcePersistentDisk``.

        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f3c05367ec535fcaa494765c14c4024b6dbdc3debaf3130ea19552f3a98dcabc)
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if name is not None:
            self._values["name"] = name
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GCEPersistentDiskVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Handler(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Handler"):
    '''Defines a specific action that should be taken.'''

    @jsii.member(jsii_name="fromCommand")
    @builtins.classmethod
    def from_command(cls, command: typing.Sequence[builtins.str]) -> "Handler":
        '''Defines a handler based on a command which is executed within the container.

        :param command: The command to execute.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__86b7a0a46fc5fc0a6465767c79d040470e85366ee731f433b112a657a09f10f2)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        return typing.cast("Handler", jsii.sinvoke(cls, "fromCommand", [command]))

    @jsii.member(jsii_name="fromHttpGet")
    @builtins.classmethod
    def from_http_get(
        cls,
        path: builtins.str,
        *,
        port: typing.Optional[jsii.Number] = None,
    ) -> "Handler":
        '''Defines a handler based on an HTTP GET request to the IP address of the container.

        :param path: The URL path to hit.
        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03ae78fc18f0fd98e4038a3c4beb927ec6ca27fa5b3bf3d3a808ab78ac3ce385)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = HandlerFromHttpGetOptions(port=port)

        return typing.cast("Handler", jsii.sinvoke(cls, "fromHttpGet", [path, options]))

    @jsii.member(jsii_name="fromTcpSocket")
    @builtins.classmethod
    def from_tcp_socket(
        cls,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> "Handler":
        '''Defines a handler based opening a connection to a TCP socket on the container.

        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        '''
        options = HandlerFromTcpSocketOptions(host=host, port=port)

        return typing.cast("Handler", jsii.sinvoke(cls, "fromTcpSocket", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.HandlerFromHttpGetOptions",
    jsii_struct_bases=[],
    name_mapping={"port": "port"},
)
class HandlerFromHttpGetOptions:
    def __init__(self, *, port: typing.Optional[jsii.Number] = None) -> None:
        '''Options for ``Handler.fromHttpGet``.

        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d79763d8d56a52e5e7c946162013ee40a4a74dd5488d113a432032893293b967)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to use when sending the GET request.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HandlerFromHttpGetOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.HandlerFromTcpSocketOptions",
    jsii_struct_bases=[],
    name_mapping={"host": "host", "port": "port"},
)
class HandlerFromTcpSocketOptions:
    def __init__(
        self,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``Handler.fromTcpSocket``.

        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c659da803a806f2dc5afb653d37d155e85f3d51c8b975956c531770768b8540)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if host is not None:
            self._values["host"] = host
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''The host name to connect to on the container.

        :default: - defaults to the pod IP
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to connect to on the container.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HandlerFromTcpSocketOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.HostAlias",
    jsii_struct_bases=[],
    name_mapping={"hostnames": "hostnames", "ip": "ip"},
)
class HostAlias:
    def __init__(
        self,
        *,
        hostnames: typing.Sequence[builtins.str],
        ip: builtins.str,
    ) -> None:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's /etc/hosts file.

        :param hostnames: Hostnames for the chosen IP address.
        :param ip: IP address of the host file entry.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__252b61658a033f664a65617ac6aa60beec33e227b5c43b5af2837df8e5469ea0)
            check_type(argname="argument hostnames", value=hostnames, expected_type=type_hints["hostnames"])
            check_type(argname="argument ip", value=ip, expected_type=type_hints["ip"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "hostnames": hostnames,
            "ip": ip,
        }

    @builtins.property
    def hostnames(self) -> typing.List[builtins.str]:
        '''Hostnames for the chosen IP address.'''
        result = self._values.get("hostnames")
        assert result is not None, "Required property 'hostnames' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def ip(self) -> builtins.str:
        '''IP address of the host file entry.'''
        result = self._values.get("ip")
        assert result is not None, "Required property 'ip' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostAlias(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.HostPathVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "type": "type"},
)
class HostPathVolumeOptions:
    def __init__(
        self,
        *,
        path: builtins.str,
        type: typing.Optional["HostPathVolumeType"] = None,
    ) -> None:
        '''Options for a HostPathVolume-based volume.

        :param path: The path of the directory on the host.
        :param type: The expected type of the path found on the host. Default: HostPathVolumeType.DEFAULT
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85d833b024e648644b0c32dec7f1ce39ae755c83d8e51cc7a228f086a5924a05)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def path(self) -> builtins.str:
        '''The path of the directory on the host.'''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> typing.Optional["HostPathVolumeType"]:
        '''The expected type of the path found on the host.

        :default: HostPathVolumeType.DEFAULT
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional["HostPathVolumeType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HostPathVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.HostPathVolumeType")
class HostPathVolumeType(enum.Enum):
    '''Host path types.'''

    DEFAULT = "DEFAULT"
    '''Empty string (default) is for backward compatibility, which means that no checks will be performed before mounting the hostPath volume.'''
    DIRECTORY_OR_CREATE = "DIRECTORY_OR_CREATE"
    '''If nothing exists at the given path, an empty directory will be created there as needed with permission set to 0755, having the same group and ownership with Kubelet.'''
    DIRECTORY = "DIRECTORY"
    '''A directory must exist at the given path.'''
    FILE_OR_CREATE = "FILE_OR_CREATE"
    '''If nothing exists at the given path, an empty file will be created there as needed with permission set to 0644, having the same group and ownership with Kubelet.'''
    FILE = "FILE"
    '''A file must exist at the given path.'''
    SOCKET = "SOCKET"
    '''A UNIX socket must exist at the given path.'''
    CHAR_DEVICE = "CHAR_DEVICE"
    '''A character device must exist at the given path.'''
    BLOCK_DEVICE = "BLOCK_DEVICE"
    '''A block device must exist at the given path.'''


@jsii.enum(jsii_type="cdk8s-plus-23.HttpIngressPathType")
class HttpIngressPathType(enum.Enum):
    '''Specify how the path is matched against request paths.

    :see: https://kubernetes.io/docs/concepts/services-networking/ingress/#path-types
    '''

    PREFIX = "PREFIX"
    '''Matches the URL path exactly.'''
    EXACT = "EXACT"
    '''Matches based on a URL path prefix split by '/'.'''
    IMPLEMENTATION_SPECIFIC = "IMPLEMENTATION_SPECIFIC"
    '''Matching is specified by the underlying IngressClass.'''


@jsii.interface(jsii_type="cdk8s-plus-23.IApiEndpoint")
class IApiEndpoint(typing_extensions.Protocol):
    '''An API Endpoint can either be a resource descriptor (e.g /pods) or a non resource url (e.g /healthz). It must be one or the other, and not both.'''

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional["IApiResource"]:
        '''Return the IApiResource this object represents.'''
        ...

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        ...


class _IApiEndpointProxy:
    '''An API Endpoint can either be a resource descriptor (e.g /pods) or a non resource url (e.g /healthz). It must be one or the other, and not both.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IApiEndpoint"

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional["IApiResource"]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional["IApiResource"], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IApiEndpoint).__jsii_proxy_class__ = lambda : _IApiEndpointProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IApiResource")
class IApiResource(typing_extensions.Protocol):
    '''Represents a resource or collection of resources.'''

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        ...

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''The unique, namespace-global, name of an object inside the Kubernetes cluster.

        If this is omitted, the ApiResource should represent all objects of the given type.
        '''
        ...


class _IApiResourceProxy:
    '''Represents a resource or collection of resources.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IApiResource"

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        return typing.cast(builtins.str, jsii.get(self, "apiGroup"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''The unique, namespace-global, name of an object inside the Kubernetes cluster.

        If this is omitted, the ApiResource should represent all objects of the given type.
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceName"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IApiResource).__jsii_proxy_class__ = lambda : _IApiResourceProxy


@jsii.interface(jsii_type="cdk8s-plus-23.INamespaceSelector")
class INamespaceSelector(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents an object that can select namespaces.'''

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> "NamespaceSelectorConfig":
        '''Return the configuration of this selector.'''
        ...


class _INamespaceSelectorProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents an object that can select namespaces.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.INamespaceSelector"

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> "NamespaceSelectorConfig":
        '''Return the configuration of this selector.'''
        return typing.cast("NamespaceSelectorConfig", jsii.invoke(self, "toNamespaceSelectorConfig", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, INamespaceSelector).__jsii_proxy_class__ = lambda : _INamespaceSelectorProxy


@jsii.interface(jsii_type="cdk8s-plus-23.INetworkPolicyPeer")
class INetworkPolicyPeer(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Describes a peer to allow traffic to/from.'''

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.'''
        ...

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional["IPodSelector"]:
        '''Convert the peer into a pod selector, if possible.'''
        ...


class _INetworkPolicyPeerProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Describes a peer to allow traffic to/from.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.INetworkPolicyPeer"

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.'''
        return typing.cast("NetworkPolicyPeerConfig", jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional["IPodSelector"]:
        '''Convert the peer into a pod selector, if possible.'''
        return typing.cast(typing.Optional["IPodSelector"], jsii.invoke(self, "toPodSelector", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, INetworkPolicyPeer).__jsii_proxy_class__ = lambda : _INetworkPolicyPeerProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IPodSelector")
class IPodSelector(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents an object that can select pods.'''

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> "PodSelectorConfig":
        '''Return the configuration of this selector.'''
        ...


class _IPodSelectorProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents an object that can select pods.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IPodSelector"

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> "PodSelectorConfig":
        '''Return the configuration of this selector.'''
        return typing.cast("PodSelectorConfig", jsii.invoke(self, "toPodSelectorConfig", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPodSelector).__jsii_proxy_class__ = lambda : _IPodSelectorProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IResource")
class IResource(
    _constructs_77d1e7e8.IConstruct,
    IApiResource,
    typing_extensions.Protocol,
):
    '''Represents a resource.'''

    @builtins.property
    @jsii.member(jsii_name="apiVersion")
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        ...

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        ...

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The Kubernetes name of this resource.'''
        ...


class _IResourceProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
    jsii.proxy_for(IApiResource), # type: ignore[misc]
):
    '''Represents a resource.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IResource"

    @builtins.property
    @jsii.member(jsii_name="apiVersion")
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        return typing.cast(builtins.str, jsii.get(self, "apiVersion"))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The Kubernetes name of this resource.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IResource).__jsii_proxy_class__ = lambda : _IResourceProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IRole")
class IRole(IResource, typing_extensions.Protocol):
    '''A reference to any Role or ClusterRole.'''

    pass


class _IRoleProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''A reference to any Role or ClusterRole.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IRole"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IRole).__jsii_proxy_class__ = lambda : _IRoleProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IScalable")
class IScalable(typing_extensions.Protocol):
    '''Represents a scalable workload.'''

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        ...

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        ...

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.'''
        ...

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> "ScalingTarget":
        '''Return the target spec properties of this Scalable.'''
        ...


class _IScalableProxy:
    '''Represents a scalable workload.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IScalable"

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        return typing.cast(builtins.bool, jsii.get(self, "hasAutoscaler"))

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7eda88e2f857820b8b9c33f96ece456b7345bd1641791d6752fd6c00b9151678)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "hasAutoscaler", value)

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.'''
        return typing.cast(None, jsii.invoke(self, "markHasAutoscaler", []))

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> "ScalingTarget":
        '''Return the target spec properties of this Scalable.'''
        return typing.cast("ScalingTarget", jsii.invoke(self, "toScalingTarget", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IScalable).__jsii_proxy_class__ = lambda : _IScalableProxy


@jsii.interface(jsii_type="cdk8s-plus-23.ISecret")
class ISecret(IResource, typing_extensions.Protocol):
    pass


class _ISecretProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.ISecret"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ISecret).__jsii_proxy_class__ = lambda : _ISecretProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IStorage")
class IStorage(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents a piece of storage in the cluster.'''

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> "Volume":
        '''Convert the piece of storage into a concrete volume.'''
        ...


class _IStorageProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents a piece of storage in the cluster.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IStorage"

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> "Volume":
        '''Convert the piece of storage into a concrete volume.'''
        return typing.cast("Volume", jsii.invoke(self, "asVolume", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IStorage).__jsii_proxy_class__ = lambda : _IStorageProxy


@jsii.interface(jsii_type="cdk8s-plus-23.ISubject")
class ISubject(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''Represents an object that can be used as a role binding subject.'''

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> "SubjectConfiguration":
        '''Return the subject configuration.'''
        ...


class _ISubjectProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''Represents an object that can be used as a role binding subject.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.ISubject"

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> "SubjectConfiguration":
        '''Return the subject configuration.'''
        return typing.cast("SubjectConfiguration", jsii.invoke(self, "toSubjectConfiguration", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ISubject).__jsii_proxy_class__ = lambda : _ISubjectProxy


@jsii.enum(jsii_type="cdk8s-plus-23.ImagePullPolicy")
class ImagePullPolicy(enum.Enum):
    ALWAYS = "ALWAYS"
    '''Every time the kubelet launches a container, the kubelet queries the container image registry to resolve the name to an image digest.

    If the kubelet has a container image with that exact
    digest cached locally, the kubelet uses its cached image; otherwise, the kubelet downloads
    (pulls) the image with the resolved digest, and uses that image to launch the container.

    Default is Always if ImagePullPolicy is omitted and either the image tag is :latest or
    the image tag is omitted.
    '''
    IF_NOT_PRESENT = "IF_NOT_PRESENT"
    '''The image is pulled only if it is not already present locally.

    Default is IfNotPresent if ImagePullPolicy is omitted and the image tag is present but
    not :latest
    '''
    NEVER = "NEVER"
    '''The image is assumed to exist locally.

    No attempt is made to pull the image.
    '''


class IngressBackend(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.IngressBackend"):
    '''The backend for an ingress path.'''

    @jsii.member(jsii_name="fromResource")
    @builtins.classmethod
    def from_resource(cls, resource: IResource) -> "IngressBackend":
        '''A Resource backend is an ObjectRef to another Kubernetes resource within the same namespace as the Ingress object.

        A common usage for a Resource backend is to ingress data to an object
        storage backend with static assets.

        :param resource: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__297fc4a09bc6cb56b470036eb953e59252f2a81bfecfb2233729e03ebc857e5a)
            check_type(argname="argument resource", value=resource, expected_type=type_hints["resource"])
        return typing.cast("IngressBackend", jsii.sinvoke(cls, "fromResource", [resource]))

    @jsii.member(jsii_name="fromService")
    @builtins.classmethod
    def from_service(
        cls,
        serv: "Service",
        *,
        port: typing.Optional[jsii.Number] = None,
    ) -> "IngressBackend":
        '''A Kubernetes ``Service`` to use as the backend for this path.

        :param serv: The service object.
        :param port: The port to use to access the service. - This option will fail if the service does not expose any ports. - If the service exposes multiple ports, this option must be specified. - If the service exposes a single port, this option is optional and if specified, it must be the same port exposed by the service. Default: - if the service exposes a single port, this port will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a3289826f5fba0cb0f360b71172aa99a27eaf7c4043ec04a04bbf1b20078c532)
            check_type(argname="argument serv", value=serv, expected_type=type_hints["serv"])
        options = ServiceIngressBackendOptions(port=port)

        return typing.cast("IngressBackend", jsii.sinvoke(cls, "fromService", [serv, options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.IngressRule",
    jsii_struct_bases=[],
    name_mapping={
        "backend": "backend",
        "host": "host",
        "path": "path",
        "path_type": "pathType",
    },
)
class IngressRule:
    def __init__(
        self,
        *,
        backend: IngressBackend,
        host: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Represents the rules mapping the paths under a specified host to the related backend services.

        Incoming requests are first evaluated for a host match,
        then routed to the backend associated with the matching path.

        :param backend: Backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param host: Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the IP in the Spec of the parent Ingress. 2. The ``:`` delimiter is not respected because ports are not allowed. Currently the port of an Ingress is implicitly :80 for http and :443 for https. Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. Default: - If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
        :param path: Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'. Default: - If unspecified, the path defaults to a catch all sending traffic to the backend.
        :param path_type: Specify how the path is matched against request paths. By default, path types will be matched by prefix.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__730420d8175a1f44ae74c6c32e518c4100ac4906384ffa4775cad60dfebfe0ce)
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "backend": backend,
        }
        if host is not None:
            self._values["host"] = host
        if path is not None:
            self._values["path"] = path
        if path_type is not None:
            self._values["path_type"] = path_type

    @builtins.property
    def backend(self) -> IngressBackend:
        '''Backend defines the referenced service endpoint to which the traffic will be forwarded to.'''
        result = self._values.get("backend")
        assert result is not None, "Required property 'backend' is missing"
        return typing.cast(IngressBackend, result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''Host is the fully qualified domain name of a network host, as defined by RFC 3986.

        Note the following deviations from the "host" part of the URI as
        defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue
        can only apply to the IP in the Spec of the parent Ingress. 2. The ``:``
        delimiter is not respected because ports are not allowed. Currently the
        port of an Ingress is implicitly :80 for http and :443 for https. Both
        these may change in the future. Incoming requests are matched against the
        host before the IngressRuleValue.

        :default:

        - If the host is unspecified, the Ingress routes all traffic based
        on the specified IngressRuleValue.
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''Path is an extended POSIX regex as defined by IEEE Std 1003.1, (i.e this follows the egrep/unix syntax, not the perl syntax) matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/'.

        :default:

        - If unspecified, the path defaults to a catch all sending traffic
        to the backend.
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path_type(self) -> typing.Optional[HttpIngressPathType]:
        '''Specify how the path is matched against request paths.

        By default, path
        types will be matched by prefix.

        :see: https://kubernetes.io/docs/concepts/services-networking/ingress/#path-types
        '''
        result = self._values.get("path_type")
        return typing.cast(typing.Optional[HttpIngressPathType], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.IngressTls",
    jsii_struct_bases=[],
    name_mapping={"hosts": "hosts", "secret": "secret"},
)
class IngressTls:
    def __init__(
        self,
        *,
        hosts: typing.Optional[typing.Sequence[builtins.str]] = None,
        secret: typing.Optional[ISecret] = None,
    ) -> None:
        '''Represents the TLS configuration mapping that is passed to the ingress controller for SSL termination.

        :param hosts: Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the TLS Secret. Default: - If unspecified, it defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress.
        :param secret: Secret is the secret that contains the certificate and key used to terminate SSL traffic on 443. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing. Default: - If unspecified, it allows SSL routing based on SNI hostname.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a35a0736d6594cb3633ff748f48e4012737772c9805f2b338b64769bfbcdba5)
            check_type(argname="argument hosts", value=hosts, expected_type=type_hints["hosts"])
            check_type(argname="argument secret", value=secret, expected_type=type_hints["secret"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hosts is not None:
            self._values["hosts"] = hosts
        if secret is not None:
            self._values["secret"] = secret

    @builtins.property
    def hosts(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Hosts are a list of hosts included in the TLS certificate.

        The values in
        this list must match the name/s used in the TLS Secret.

        :default:

        - If unspecified, it defaults to the wildcard host setting for
        the loadbalancer controller fulfilling this Ingress.
        '''
        result = self._values.get("hosts")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def secret(self) -> typing.Optional[ISecret]:
        '''Secret is the secret that contains the certificate and key used to terminate SSL traffic on 443.

        If the SNI host in a listener conflicts with
        the "Host" header field used by an IngressRule, the SNI host is used for
        termination and value of the Host header is used for routing.

        :default: - If unspecified, it allows SSL routing based on SNI hostname.
        '''
        result = self._values.get("secret")
        return typing.cast(typing.Optional[ISecret], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressTls(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class LabelExpression(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.LabelExpression",
):
    '''Represents a query that can be performed against resources with labels.'''

    @jsii.member(jsii_name="doesNotExist")
    @builtins.classmethod
    def does_not_exist(cls, key: builtins.str) -> "LabelExpression":
        '''Requires label ``key`` to not exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1dd87f4543a6a01bf5191b11734f57ee01a30db67049ac174256ac103a347ae7)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "doesNotExist", [key]))

    @jsii.member(jsii_name="exists")
    @builtins.classmethod
    def exists(cls, key: builtins.str) -> "LabelExpression":
        '''Requires label ``key`` to exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b8f54a6b449f562cdfbb2c3c554135ff8a08038f7c61ba69ef0eb8d2645c794)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "exists", [key]))

    @jsii.member(jsii_name="in")
    @builtins.classmethod
    def in_(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "LabelExpression":
        '''Requires value of label ``key`` to be one of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__126ddf2f6dfb97d42929c1a86fdec8102ecb2fc7b48aa713bdeec529e56cb5f9)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "in", [key, values]))

    @jsii.member(jsii_name="notIn")
    @builtins.classmethod
    def not_in(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "LabelExpression":
        '''Requires value of label ``key`` to be none of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a52c1574ecda8b08e87b7448e1e2360801b410de65b2ec3647a52b11414b57f4)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("LabelExpression", jsii.sinvoke(cls, "notIn", [key, values]))

    @builtins.property
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "key"))

    @builtins.property
    @jsii.member(jsii_name="operator")
    def operator(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "operator"))

    @builtins.property
    @jsii.member(jsii_name="values")
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "values"))


class LabelSelector(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.LabelSelector"):
    '''Match a resource by labels.'''

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(
        cls,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> "LabelSelector":
        '''
        :param expressions: Expression based label matchers.
        :param labels: Strict label matchers.
        '''
        options = LabelSelectorOptions(expressions=expressions, labels=labels)

        return typing.cast("LabelSelector", jsii.sinvoke(cls, "of", [options]))

    @jsii.member(jsii_name="isEmpty")
    def is_empty(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.invoke(self, "isEmpty", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.LabelSelectorOptions",
    jsii_struct_bases=[],
    name_mapping={"expressions": "expressions", "labels": "labels"},
)
class LabelSelectorOptions:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''Options for ``LabelSelector.of``.

        :param expressions: Expression based label matchers.
        :param labels: Strict label matchers.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d5475dbde46bec53109b5985e3dcb39b4f6165c11d936e41e5b01f6f9abae07)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if labels is not None:
            self._values["labels"] = labels

    @builtins.property
    def expressions(self) -> typing.Optional[typing.List[LabelExpression]]:
        '''Expression based label matchers.'''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.List[LabelExpression]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Strict label matchers.'''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LabelSelectorOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.LabelSelectorRequirement",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "operator": "operator", "values": "values"},
)
class LabelSelectorRequirement:
    def __init__(
        self,
        *,
        key: builtins.str,
        operator: builtins.str,
        values: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.

        :param key: The label key that the selector applies to.
        :param operator: Represents a key's relationship to a set of values.
        :param values: An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3f7d0f5ec3bdc659ee0aa64a23602748bcaa2878067b2030fb782464c6ef8f7c)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument operator", value=operator, expected_type=type_hints["operator"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "operator": operator,
        }
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def key(self) -> builtins.str:
        '''The label key that the selector applies to.'''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def operator(self) -> builtins.str:
        '''Represents a key's relationship to a set of values.'''
        result = self._values.get("operator")
        assert result is not None, "Required property 'operator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def values(self) -> typing.Optional[typing.List[builtins.str]]:
        '''An array of string values.

        If the operator is In or NotIn, the values array
        must be non-empty. If the operator is Exists or DoesNotExist,
        the values array must be empty. This array is replaced during a strategic merge patch.
        '''
        result = self._values.get("values")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LabelSelectorRequirement(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class LabeledNode(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.LabeledNode"):
    '''A node that is matched by label selectors.'''

    def __init__(self, label_selector: typing.Sequence["NodeLabelQuery"]) -> None:
        '''
        :param label_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ee2aab0d0f13e6d9ed07cb255725d87bd914bcc0562b884d7633679ffbff86d9)
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        jsii.create(self.__class__, self, [label_selector])

    @builtins.property
    @jsii.member(jsii_name="labelSelector")
    def label_selector(self) -> typing.List["NodeLabelQuery"]:
        return typing.cast(typing.List["NodeLabelQuery"], jsii.get(self, "labelSelector"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.MemoryResources",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "request": "request"},
)
class MemoryResources:
    def __init__(
        self,
        *,
        limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        request: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> None:
        '''Memory request and limit.

        :param limit: 
        :param request: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ab08181704e84d42e4c2bf4ef43335b9b4eacad6c862b50731fcdcdad0e4eb0)
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument request", value=request, expected_type=type_hints["request"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if limit is not None:
            self._values["limit"] = limit
        if request is not None:
            self._values["request"] = request

    @builtins.property
    def limit(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("limit")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def request(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        result = self._values.get("request")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MemoryResources(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Metric(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Metric"):
    '''A metric condition that HorizontalPodAutoscaler's scale on.'''

    @jsii.member(jsii_name="containerCpu")
    @builtins.classmethod
    def container_cpu(cls, *, container: Container, target: "MetricTarget") -> "Metric":
        '''Metric that tracks the CPU of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerCpu", [options]))

    @jsii.member(jsii_name="containerEphemeralStorage")
    @builtins.classmethod
    def container_ephemeral_storage(
        cls,
        *,
        container: Container,
        target: "MetricTarget",
    ) -> "Metric":
        '''Metric that tracks the local ephemeral storage of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerEphemeralStorage", [options]))

    @jsii.member(jsii_name="containerMemory")
    @builtins.classmethod
    def container_memory(
        cls,
        *,
        container: Container,
        target: "MetricTarget",
    ) -> "Metric":
        '''Metric that tracks the Memory of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerMemory", [options]))

    @jsii.member(jsii_name="containerStorage")
    @builtins.classmethod
    def container_storage(
        cls,
        *,
        container: Container,
        target: "MetricTarget",
    ) -> "Metric":
        '''Metric that tracks the volume size of a container.

        This metric
        will be tracked across all pods of the current scale target.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        options = MetricContainerResourceOptions(container=container, target=target)

        return typing.cast("Metric", jsii.sinvoke(cls, "containerStorage", [options]))

    @jsii.member(jsii_name="external")
    @builtins.classmethod
    def external(
        cls,
        *,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> "Metric":
        '''A global metric that is not associated with any Kubernetes object.

        Allows for autoscaling based on information coming from components running outside of
        the cluster.

        Use case:

        - Scale up when the length of an SQS queue is greater than 10 messages.
        - Scale down when an outside load balancer's queries are less than 10000 per second.

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        options = MetricOptions(
            name=name, target=target, label_selector=label_selector
        )

        return typing.cast("Metric", jsii.sinvoke(cls, "external", [options]))

    @jsii.member(jsii_name="object")
    @builtins.classmethod
    def object(
        cls,
        *,
        object: IResource,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> "Metric":
        '''Metric that describes a metric of a kubernetes object.

        Use case:

        - Scale on a Kubernetes Ingress's hits-per-second metric.

        :param object: Resource where the metric can be found.
        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        options = MetricObjectOptions(
            object=object, name=name, target=target, label_selector=label_selector
        )

        return typing.cast("Metric", jsii.sinvoke(cls, "object", [options]))

    @jsii.member(jsii_name="pods")
    @builtins.classmethod
    def pods(
        cls,
        *,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> "Metric":
        '''A pod metric that will be averaged across all pods of the current scale target.

        Use case:

        - Average CPU utilization across all pods
        - Transactions processed per second across all pods

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        options = MetricOptions(
            name=name, target=target, label_selector=label_selector
        )

        return typing.cast("Metric", jsii.sinvoke(cls, "pods", [options]))

    @jsii.member(jsii_name="resourceCpu")
    @builtins.classmethod
    def resource_cpu(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available CPU of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        Use case:

        - Scale up when CPU is above 40%.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9350316cc89d0d2eff0791dbd528fb2b2e10cc5e4e80d96d500a29bd6d427d9e)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceCpu", [target]))

    @jsii.member(jsii_name="resourceEphemeralStorage")
    @builtins.classmethod
    def resource_ephemeral_storage(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available Ephemeral Storage of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__46ad83354adb01d33ec57a620338c8e92529f994ccf013460b35b066b44dd08e)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceEphemeralStorage", [target]))

    @jsii.member(jsii_name="resourceMemory")
    @builtins.classmethod
    def resource_memory(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available Memory of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        Use case:

        - Scale up when Memory is above 512MB.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4aab7bfac901a4f3d2e84139c2c4b9f7cf826f5bd0e3a9b5461a3de7863c34e4)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceMemory", [target]))

    @jsii.member(jsii_name="resourceStorage")
    @builtins.classmethod
    def resource_storage(cls, target: "MetricTarget") -> "Metric":
        '''Tracks the available Storage of the pods in a target.

        Note: Since the resource usages of all the containers are summed up the total
        pod utilization may not accurately represent the individual container resource
        usage. This could lead to situations where a single container might be running
        with high usage and the HPA will not scale out because the overall pod usage
        is still within acceptable limits.

        :param target: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__562e775cd714593083085ee3ebced3cbc0b275f5d094d7f37a23251cb4b1d48c)
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        return typing.cast("Metric", jsii.sinvoke(cls, "resourceStorage", [target]))

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "type"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.MetricContainerResourceOptions",
    jsii_struct_bases=[],
    name_mapping={"container": "container", "target": "target"},
)
class MetricContainerResourceOptions:
    def __init__(self, *, container: Container, target: "MetricTarget") -> None:
        '''Options for ``Metric.containerResource()``.

        :param container: Container where the metric can be found.
        :param target: Target metric value that will trigger scaling.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e6e87138273d4b8be5720154d84cc75e8145be8064066abca6142c87dd956434)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container": container,
            "target": target,
        }

    @builtins.property
    def container(self) -> Container:
        '''Container where the metric can be found.'''
        result = self._values.get("container")
        assert result is not None, "Required property 'container' is missing"
        return typing.cast(Container, result)

    @builtins.property
    def target(self) -> "MetricTarget":
        '''Target metric value that will trigger scaling.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTarget", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricContainerResourceOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.MetricOptions",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "target": "target",
        "label_selector": "labelSelector",
    },
)
class MetricOptions:
    def __init__(
        self,
        *,
        name: builtins.str,
        target: "MetricTarget",
        label_selector: typing.Optional[LabelSelector] = None,
    ) -> None:
        '''Base options for a Metric.

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__131b893e4ec3e0eb65680eb6a8e91a6eee2e1e74d531441b6b4d24eece5af5e8)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "target": target,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the metric to scale on.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> "MetricTarget":
        '''The target metric value that will trigger scaling.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast("MetricTarget", result)

    @builtins.property
    def label_selector(self) -> typing.Optional[LabelSelector]:
        '''A selector to find a metric by label.

        When set, it is passed as an additional parameter to the metrics server
        for more specific metrics scoping.

        :default: - Just the metric 'name' will be used to gather metrics.
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional[LabelSelector], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MetricTarget(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.MetricTarget"):
    '''A metric condition that will trigger scaling behavior when satisfied.

    Example::

        MetricTarget.averageUtilization(70); // 70% average utilization
    '''

    @jsii.member(jsii_name="averageUtilization")
    @builtins.classmethod
    def average_utilization(cls, average_utilization: jsii.Number) -> "MetricTarget":
        '''Target a percentage value across all relevant pods.

        :param average_utilization: The percentage of the utilization metric. e.g. ``50`` for 50%.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__183717667170141e28699690b4ddf1a428f6c8c38332e2f9aec85edd19836782)
            check_type(argname="argument average_utilization", value=average_utilization, expected_type=type_hints["average_utilization"])
        return typing.cast("MetricTarget", jsii.sinvoke(cls, "averageUtilization", [average_utilization]))

    @jsii.member(jsii_name="averageValue")
    @builtins.classmethod
    def average_value(cls, average_value: jsii.Number) -> "MetricTarget":
        '''Target the average value across all relevant pods.

        :param average_value: The average metric value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f9e3195154f5a32a7166fef5ad538cc972cbe8c95131bfbdbda27d08767a3dce)
            check_type(argname="argument average_value", value=average_value, expected_type=type_hints["average_value"])
        return typing.cast("MetricTarget", jsii.sinvoke(cls, "averageValue", [average_value]))

    @jsii.member(jsii_name="value")
    @builtins.classmethod
    def value(cls, value: jsii.Number) -> "MetricTarget":
        '''Target a specific target value.

        :param value: The target value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a0f8a259830bd41540c00bd2c49e80a5a0e3fa5b09cbec1cdd5fba787bba0d1d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("MetricTarget", jsii.sinvoke(cls, "value", [value]))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.MountOptions",
    jsii_struct_bases=[],
    name_mapping={
        "propagation": "propagation",
        "read_only": "readOnly",
        "sub_path": "subPath",
        "sub_path_expr": "subPathExpr",
    },
)
class MountOptions:
    def __init__(
        self,
        *,
        propagation: typing.Optional["MountPropagation"] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options for mounts.

        :param propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. Mount propagation allows for sharing volumes mounted by a Container to other Containers in the same Pod, or even to other Pods on the same node. Default: MountPropagation.NONE
        :param read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. Default: false
        :param sub_path: Path within the volume from which the container's volume should be mounted.). Default: "" the volume's root
        :param sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). ``subPathExpr`` and ``subPath`` are mutually exclusive. Default: "" volume's root.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__17957ca55b169dfbb8b7450e896d5b6dcd69ff50128f569ecfdd91e8a92884e1)
            check_type(argname="argument propagation", value=propagation, expected_type=type_hints["propagation"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument sub_path", value=sub_path, expected_type=type_hints["sub_path"])
            check_type(argname="argument sub_path_expr", value=sub_path_expr, expected_type=type_hints["sub_path_expr"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if propagation is not None:
            self._values["propagation"] = propagation
        if read_only is not None:
            self._values["read_only"] = read_only
        if sub_path is not None:
            self._values["sub_path"] = sub_path
        if sub_path_expr is not None:
            self._values["sub_path_expr"] = sub_path_expr

    @builtins.property
    def propagation(self) -> typing.Optional["MountPropagation"]:
        '''Determines how mounts are propagated from the host to container and the other way around.

        When not set, MountPropagationNone is used.

        Mount propagation allows for sharing volumes mounted by a Container to
        other Containers in the same Pod, or even to other Pods on the same node.

        :default: MountPropagation.NONE
        '''
        result = self._values.get("propagation")
        return typing.cast(typing.Optional["MountPropagation"], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Mounted read-only if true, read-write otherwise (false or unspecified).

        Defaults to false.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sub_path(self) -> typing.Optional[builtins.str]:
        '''Path within the volume from which the container's volume should be mounted.).

        :default: "" the volume's root
        '''
        result = self._values.get("sub_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sub_path_expr(self) -> typing.Optional[builtins.str]:
        '''Expanded path within the volume from which the container's volume should be mounted.

        Behaves similarly to SubPath but environment variable references
        $(VAR_NAME) are expanded using the container's environment. Defaults to ""
        (volume's root).

        ``subPathExpr`` and ``subPath`` are mutually exclusive.

        :default: "" volume's root.
        '''
        result = self._values.get("sub_path_expr")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MountOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.MountPropagation")
class MountPropagation(enum.Enum):
    NONE = "NONE"
    '''This volume mount will not receive any subsequent mounts that are mounted to this volume or any of its subdirectories by the host.

    In similar
    fashion, no mounts created by the Container will be visible on the host.

    This is the default mode.

    This mode is equal to ``private`` mount propagation as described in the Linux
    kernel documentation
    '''
    HOST_TO_CONTAINER = "HOST_TO_CONTAINER"
    '''This volume mount will receive all subsequent mounts that are mounted to this volume or any of its subdirectories.

    In other words, if the host mounts anything inside the volume mount, the
    Container will see it mounted there.

    Similarly, if any Pod with Bidirectional mount propagation to the same
    volume mounts anything there, the Container with HostToContainer mount
    propagation will see it.

    This mode is equal to ``rslave`` mount propagation as described in the Linux
    kernel documentation
    '''
    BIDIRECTIONAL = "BIDIRECTIONAL"
    '''This volume mount behaves the same the HostToContainer mount.

    In addition,
    all volume mounts created by the Container will be propagated back to the
    host and to all Containers of all Pods that use the same volume

    A typical use case for this mode is a Pod with a FlexVolume or CSI driver
    or a Pod that needs to mount something on the host using a hostPath volume.

    This mode is equal to ``rshared`` mount propagation as described in the Linux
    kernel documentation

    Caution: Bidirectional mount propagation can be dangerous. It can damage
    the host operating system and therefore it is allowed only in privileged
    Containers. Familiarity with Linux kernel behavior is strongly recommended.
    In addition, any volume mounts created by Containers in Pods must be
    destroyed (unmounted) by the Containers on termination.
    '''


class NamedNode(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.NamedNode"):
    '''A node that is matched by its name.'''

    def __init__(self, name: builtins.str) -> None:
        '''
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5cc03c919fceaaeb24c85cf626a94c7ce7d1945a1b3c2d62f18f8803ca6f6d7f)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        jsii.create(self.__class__, self, [name])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NamespaceSelectorConfig",
    jsii_struct_bases=[],
    name_mapping={"label_selector": "labelSelector", "names": "names"},
)
class NamespaceSelectorConfig:
    def __init__(
        self,
        *,
        label_selector: typing.Optional[LabelSelector] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Configuration for selecting namespaces.

        :param label_selector: A selector to select namespaces by labels.
        :param names: A list of names to select namespaces by names.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03ca4dd908c9db7669824913d57a529dc0bf296d30354f398c444eb5baece26d)
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if label_selector is not None:
            self._values["label_selector"] = label_selector
        if names is not None:
            self._values["names"] = names

    @builtins.property
    def label_selector(self) -> typing.Optional[LabelSelector]:
        '''A selector to select namespaces by labels.'''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional[LabelSelector], result)

    @builtins.property
    def names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of names to select namespaces by names.'''
        result = self._values.get("names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NamespaceSelectorConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(INamespaceSelector, INetworkPolicyPeer)
class Namespaces(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.Namespaces",
):
    '''Represents a group of namespaces.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param expressions: -
        :param names: -
        :param labels: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c3a2c584750b6b23e0d3616e4c6e3eb625282021f95407d395f4b42e86022b8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
        jsii.create(self.__class__, self, [scope, id, expressions, names, labels])

    @jsii.member(jsii_name="all")
    @builtins.classmethod
    def all(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
    ) -> "Namespaces":
        '''Select all namespaces.

        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3c2402ae762af550f09cbaa4d0cbd14e75ff30212b2cdb02cf70107f92a98ef)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        return typing.cast("Namespaces", jsii.sinvoke(cls, "all", [scope, id]))

    @jsii.member(jsii_name="select")
    @builtins.classmethod
    def select(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> "Namespaces":
        '''Select specific namespaces.

        :param scope: -
        :param id: -
        :param expressions: Namespaces must satisfy these selectors. The selectors query labels, just like the ``labels`` property, but they provide a more advanced matching mechanism. Default: - no selector requirements.
        :param labels: Labels the namespaces must have. This is equivalent to using an 'Is' selector. Default: - no strict labels requirements.
        :param names: Namespaces names must be one of these. Default: - no name requirements.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb790717ce568fcf47fbf7c1c9e45539a5f1053fe8e0fe0b29acca9dd171e8ff)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = NamespacesSelectOptions(
            expressions=expressions, labels=labels, names=names
        )

        return typing.cast("Namespaces", jsii.sinvoke(cls, "select", [scope, id, options]))

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> NamespaceSelectorConfig:
        '''Return the configuration of this selector.

        :see: INamespaceSelector.toNamespaceSelectorConfig()
        '''
        return typing.cast(NamespaceSelectorConfig, jsii.invoke(self, "toNamespaceSelectorConfig", []))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast("NetworkPolicyPeerConfig", jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NamespacesSelectOptions",
    jsii_struct_bases=[],
    name_mapping={"expressions": "expressions", "labels": "labels", "names": "names"},
)
class NamespacesSelectOptions:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        names: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''Options for ``Namespaces.select``.

        :param expressions: Namespaces must satisfy these selectors. The selectors query labels, just like the ``labels`` property, but they provide a more advanced matching mechanism. Default: - no selector requirements.
        :param labels: Labels the namespaces must have. This is equivalent to using an 'Is' selector. Default: - no strict labels requirements.
        :param names: Namespaces names must be one of these. Default: - no name requirements.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0ac17cb97e0ab351d1e7e1cf0f09a295dd2d635d7aac060c7c6f09d8dc6b915)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument names", value=names, expected_type=type_hints["names"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if labels is not None:
            self._values["labels"] = labels
        if names is not None:
            self._values["names"] = names

    @builtins.property
    def expressions(self) -> typing.Optional[typing.List[LabelExpression]]:
        '''Namespaces must satisfy these selectors.

        The selectors query labels, just like the ``labels`` property, but they
        provide a more advanced matching mechanism.

        :default: - no selector requirements.
        '''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.List[LabelExpression]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Labels the namespaces must have.

        This is equivalent to using an 'Is' selector.

        :default: - no strict labels requirements.
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def names(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Namespaces names must be one of these.

        :default: - no name requirements.
        '''
        result = self._values.get("names")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NamespacesSelectOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NetworkPolicyAddEgressRuleOptions",
    jsii_struct_bases=[],
    name_mapping={"ports": "ports"},
)
class NetworkPolicyAddEgressRuleOptions:
    def __init__(
        self,
        *,
        ports: typing.Optional[typing.Sequence["NetworkPolicyPort"]] = None,
    ) -> None:
        '''Options for ``NetworkPolicy.addEgressRule``.

        :param ports: Ports the rule should allow outgoing traffic to. Default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a6d3711758213672193c13dacb28100d7da179c43400fefd5e144561b66f713)
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def ports(self) -> typing.Optional[typing.List["NetworkPolicyPort"]]:
        '''Ports the rule should allow outgoing traffic to.

        :default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List["NetworkPolicyPort"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyAddEgressRuleOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(INetworkPolicyPeer)
class NetworkPolicyIpBlock(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.NetworkPolicyIpBlock",
):
    '''Describes a particular CIDR (Ex.

    "192.168.1.1/24","2001:db9::/64") that is
    allowed to the pods matched by a network policy selector.
    The except entry describes CIDRs that should not be included within this rule.
    '''

    @jsii.member(jsii_name="anyIpv4")
    @builtins.classmethod
    def any_ipv4(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
    ) -> "NetworkPolicyIpBlock":
        '''Any IPv4 address.

        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b8bfab0ab1451da87df495060b50737f4e2b977ffc2c2b483191fb84d8c4fa8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "anyIpv4", [scope, id]))

    @jsii.member(jsii_name="anyIpv6")
    @builtins.classmethod
    def any_ipv6(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
    ) -> "NetworkPolicyIpBlock":
        '''Any IPv6 address.

        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6f9c912bebe64d25ab29ab87bbc46ecbd2df08efa390973ccdee7b52fc582c21)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "anyIpv6", [scope, id]))

    @jsii.member(jsii_name="ipv4")
    @builtins.classmethod
    def ipv4(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        cidr_ip: builtins.str,
        except_: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> "NetworkPolicyIpBlock":
        '''Create an IPv4 peer from a CIDR.

        :param scope: -
        :param id: -
        :param cidr_ip: -
        :param except_: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__552cc1332ea2adff05f65d31906fdb84b41f998f1e24c50f4a11d1dc6283079a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument cidr_ip", value=cidr_ip, expected_type=type_hints["cidr_ip"])
            check_type(argname="argument except_", value=except_, expected_type=type_hints["except_"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "ipv4", [scope, id, cidr_ip, except_]))

    @jsii.member(jsii_name="ipv6")
    @builtins.classmethod
    def ipv6(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        cidr_ip: builtins.str,
        except_: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> "NetworkPolicyIpBlock":
        '''Create an IPv6 peer from a CIDR.

        :param scope: -
        :param id: -
        :param cidr_ip: -
        :param except_: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8fb851eb93e3bdc63274ff056d3f7d1905ff2ffaef0f927a17a08d1dac5e4c00)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument cidr_ip", value=cidr_ip, expected_type=type_hints["cidr_ip"])
            check_type(argname="argument except_", value=except_, expected_type=type_hints["except_"])
        return typing.cast("NetworkPolicyIpBlock", jsii.sinvoke(cls, "ipv6", [scope, id, cidr_ip, except_]))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> "NetworkPolicyPeerConfig":
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast("NetworkPolicyPeerConfig", jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @builtins.property
    @jsii.member(jsii_name="cidr")
    def cidr(self) -> builtins.str:
        '''A string representing the IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64".'''
        return typing.cast(builtins.str, jsii.get(self, "cidr"))

    @builtins.property
    @jsii.member(jsii_name="except")
    def except_(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A slice of CIDRs that should not be included within an IP Block Valid examples are "192.168.1.1/24" or "2001:db9::/64". Except values will be rejected if they are outside the CIDR range.'''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "except"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NetworkPolicyPeerConfig",
    jsii_struct_bases=[],
    name_mapping={"ip_block": "ipBlock", "pod_selector": "podSelector"},
)
class NetworkPolicyPeerConfig:
    def __init__(
        self,
        *,
        ip_block: typing.Optional[NetworkPolicyIpBlock] = None,
        pod_selector: typing.Optional[typing.Union["PodSelectorConfig", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Configuration for network peers.

        A peer can either by an ip block, or a selection of pods, not both.

        :param ip_block: The ip block this peer represents.
        :param pod_selector: The pod selector this peer represents.
        '''
        if isinstance(pod_selector, dict):
            pod_selector = PodSelectorConfig(**pod_selector)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b6c07dfed45c391b97dd1be35c8ef4892d4993279f58f06229c27c535680ef5)
            check_type(argname="argument ip_block", value=ip_block, expected_type=type_hints["ip_block"])
            check_type(argname="argument pod_selector", value=pod_selector, expected_type=type_hints["pod_selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ip_block is not None:
            self._values["ip_block"] = ip_block
        if pod_selector is not None:
            self._values["pod_selector"] = pod_selector

    @builtins.property
    def ip_block(self) -> typing.Optional[NetworkPolicyIpBlock]:
        '''The ip block this peer represents.'''
        result = self._values.get("ip_block")
        return typing.cast(typing.Optional[NetworkPolicyIpBlock], result)

    @builtins.property
    def pod_selector(self) -> typing.Optional["PodSelectorConfig"]:
        '''The pod selector this peer represents.'''
        result = self._values.get("pod_selector")
        return typing.cast(typing.Optional["PodSelectorConfig"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyPeerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class NetworkPolicyPort(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.NetworkPolicyPort",
):
    '''Describes a port to allow traffic on.'''

    @jsii.member(jsii_name="allTcp")
    @builtins.classmethod
    def all_tcp(cls) -> "NetworkPolicyPort":
        '''Any TCP traffic.'''
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "allTcp", []))

    @jsii.member(jsii_name="allUdp")
    @builtins.classmethod
    def all_udp(cls) -> "NetworkPolicyPort":
        '''Any UDP traffic.'''
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "allUdp", []))

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(
        cls,
        *,
        end_port: typing.Optional[jsii.Number] = None,
        port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional["NetworkProtocol"] = None,
    ) -> "NetworkPolicyPort":
        '''Custom port configuration.

        :param end_port: End port (relative to ``port``). Only applies if ``port`` is defined. Use this to specify a port range, rather that a specific one. Default: - not a port range.
        :param port: Specific port number. Default: - all ports are allowed.
        :param protocol: Protocol. Default: NetworkProtocol.TCP
        '''
        props = NetworkPolicyPortProps(end_port=end_port, port=port, protocol=protocol)

        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "of", [props]))

    @jsii.member(jsii_name="tcp")
    @builtins.classmethod
    def tcp(cls, port: jsii.Number) -> "NetworkPolicyPort":
        '''Distinct TCP ports.

        :param port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00bc0745185a4ea10664112d0be22a868fce65b098daea0a308248060f440937)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "tcp", [port]))

    @jsii.member(jsii_name="tcpRange")
    @builtins.classmethod
    def tcp_range(
        cls,
        start_port: jsii.Number,
        end_port: jsii.Number,
    ) -> "NetworkPolicyPort":
        '''A TCP port range.

        :param start_port: -
        :param end_port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6cfb27a440a1243fca85bf7dffdc267f3753fd2cd7a7afaf71780b1de8bb03e)
            check_type(argname="argument start_port", value=start_port, expected_type=type_hints["start_port"])
            check_type(argname="argument end_port", value=end_port, expected_type=type_hints["end_port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "tcpRange", [start_port, end_port]))

    @jsii.member(jsii_name="udp")
    @builtins.classmethod
    def udp(cls, port: jsii.Number) -> "NetworkPolicyPort":
        '''Distinct UDP ports.

        :param port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__21e7983032b20cbc934fd6b4d0e5f9a1a76353af222e7b2db784b3b9ce235849)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "udp", [port]))

    @jsii.member(jsii_name="udpRange")
    @builtins.classmethod
    def udp_range(
        cls,
        start_port: jsii.Number,
        end_port: jsii.Number,
    ) -> "NetworkPolicyPort":
        '''A UDP port range.

        :param start_port: -
        :param end_port: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5adecb7ee8124a6e92c86353a105f6e716fb0e0a7c6a989687c18670c494ee4b)
            check_type(argname="argument start_port", value=start_port, expected_type=type_hints["start_port"])
            check_type(argname="argument end_port", value=end_port, expected_type=type_hints["end_port"])
        return typing.cast("NetworkPolicyPort", jsii.sinvoke(cls, "udpRange", [start_port, end_port]))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NetworkPolicyPortProps",
    jsii_struct_bases=[],
    name_mapping={"end_port": "endPort", "port": "port", "protocol": "protocol"},
)
class NetworkPolicyPortProps:
    def __init__(
        self,
        *,
        end_port: typing.Optional[jsii.Number] = None,
        port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional["NetworkProtocol"] = None,
    ) -> None:
        '''Properties for ``NetworkPolicyPort``.

        :param end_port: End port (relative to ``port``). Only applies if ``port`` is defined. Use this to specify a port range, rather that a specific one. Default: - not a port range.
        :param port: Specific port number. Default: - all ports are allowed.
        :param protocol: Protocol. Default: NetworkProtocol.TCP
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5eb8cce61569ae4e97c298bca38b2c21df887005c9580c7cfea540c3c84db1c8)
            check_type(argname="argument end_port", value=end_port, expected_type=type_hints["end_port"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if end_port is not None:
            self._values["end_port"] = end_port
        if port is not None:
            self._values["port"] = port
        if protocol is not None:
            self._values["protocol"] = protocol

    @builtins.property
    def end_port(self) -> typing.Optional[jsii.Number]:
        '''End port (relative to ``port``).

        Only applies if ``port`` is defined.
        Use this to specify a port range, rather that a specific one.

        :default: - not a port range.
        '''
        result = self._values.get("end_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''Specific port number.

        :default: - all ports are allowed.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional["NetworkProtocol"]:
        '''Protocol.

        :default: NetworkProtocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional["NetworkProtocol"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyPortProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NetworkPolicyRule",
    jsii_struct_bases=[],
    name_mapping={"peer": "peer", "ports": "ports"},
)
class NetworkPolicyRule:
    def __init__(
        self,
        *,
        peer: INetworkPolicyPeer,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Describes a rule allowing traffic from / to pods matched by a network policy selector.

        :param peer: Peer this rule interacts with.
        :param ports: The ports of the rule. Default: - traffic is allowed on all ports.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d53655b1e3ea4067b3d33e1a399feb4c564ab8bed72e95b48630062e2e954a6a)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "peer": peer,
        }
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def peer(self) -> INetworkPolicyPeer:
        '''Peer this rule interacts with.'''
        result = self._values.get("peer")
        assert result is not None, "Required property 'peer' is missing"
        return typing.cast(INetworkPolicyPeer, result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[NetworkPolicyPort]]:
        '''The ports of the rule.

        :default: - traffic is allowed on all ports.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NetworkPolicyTraffic",
    jsii_struct_bases=[],
    name_mapping={"default": "default", "rules": "rules"},
)
class NetworkPolicyTraffic:
    def __init__(
        self,
        *,
        default: typing.Optional["NetworkPolicyTrafficDefault"] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[NetworkPolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Describes how the network policy should configure egress / ingress traffic.

        :param default: Specifies the default behavior of the policy when no rules are defined. Default: - unset, the policy does not change the behavior.
        :param rules: List of rules to be applied to the selected pods. If empty, the behavior of the policy is dictated by the ``default`` property. Default: - no rules
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da549a775544853b2780ae69bb990ee1978a17df763795f4ecaf6ecc47f1d92d)
            check_type(argname="argument default", value=default, expected_type=type_hints["default"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default is not None:
            self._values["default"] = default
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def default(self) -> typing.Optional["NetworkPolicyTrafficDefault"]:
        '''Specifies the default behavior of the policy when no rules are defined.

        :default: - unset, the policy does not change the behavior.
        '''
        result = self._values.get("default")
        return typing.cast(typing.Optional["NetworkPolicyTrafficDefault"], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[NetworkPolicyRule]]:
        '''List of rules to be applied to the selected pods.

        If empty, the behavior of the policy is dictated by the ``default`` property.

        :default: - no rules
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyRule]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyTraffic(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.NetworkPolicyTrafficDefault")
class NetworkPolicyTrafficDefault(enum.Enum):
    '''Default behaviors of network traffic in policies.'''

    DENY = "DENY"
    '''The policy denies all traffic.

    Since rules are additive, additional rules or policies can allow
    specific traffic.
    '''
    ALLOW = "ALLOW"
    '''The policy allows all traffic (either ingress or egress).

    Since rules are additive, no additional rule or policies can
    subsequently deny the traffic.
    '''


@jsii.enum(jsii_type="cdk8s-plus-23.NetworkProtocol")
class NetworkProtocol(enum.Enum):
    '''Network protocols.'''

    TCP = "TCP"
    '''TCP.'''
    UDP = "UDP"
    '''UDP.'''
    SCTP = "SCTP"
    '''SCTP.'''


class Node(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Node"):
    '''Represents a node in the cluster.'''

    def __init__(self) -> None:
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="labeled")
    @builtins.classmethod
    def labeled(cls, *label_selector: "NodeLabelQuery") -> LabeledNode:
        '''Match a node by its labels.

        :param label_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6372726f39233a7d91abbe32b7b2f4c9aec3c56eebfc51c3c8955b10c460d439)
            check_type(argname="argument label_selector", value=label_selector, expected_type=typing.Tuple[type_hints["label_selector"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(LabeledNode, jsii.sinvoke(cls, "labeled", [*label_selector]))

    @jsii.member(jsii_name="named")
    @builtins.classmethod
    def named(cls, node_name: builtins.str) -> NamedNode:
        '''Match a node by its name.

        :param node_name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1afe771ab507e484df8f180d5c2f8e55f2e48df3b6957e7473d7cac9bb9b73a2)
            check_type(argname="argument node_name", value=node_name, expected_type=type_hints["node_name"])
        return typing.cast(NamedNode, jsii.sinvoke(cls, "named", [node_name]))

    @jsii.member(jsii_name="tainted")
    @builtins.classmethod
    def tainted(cls, *taint_selector: "NodeTaintQuery") -> "TaintedNode":
        '''Match a node by its taints.

        :param taint_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6fc52a13f4398746d63fbc228beb32a3bd684d74409fdc1aa4d32d0c95a52ecb)
            check_type(argname="argument taint_selector", value=taint_selector, expected_type=typing.Tuple[type_hints["taint_selector"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("TaintedNode", jsii.sinvoke(cls, "tainted", [*taint_selector]))


class NodeLabelQuery(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.NodeLabelQuery"):
    '''Represents a query that can be performed against nodes with labels.'''

    @jsii.member(jsii_name="doesNotExist")
    @builtins.classmethod
    def does_not_exist(cls, key: builtins.str) -> "NodeLabelQuery":
        '''Requires label ``key`` to not exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__44383a9e8d93659287f1cc92a494f9a9851b699fc449bd19ad068e4dff1cb380)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "doesNotExist", [key]))

    @jsii.member(jsii_name="exists")
    @builtins.classmethod
    def exists(cls, key: builtins.str) -> "NodeLabelQuery":
        '''Requires label ``key`` to exist.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6e8b1381373dd1b0e3fe8e91a7445e46d051cecbbf23e65647100f34147230bd)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "exists", [key]))

    @jsii.member(jsii_name="gt")
    @builtins.classmethod
    def gt(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to greater than all elements in ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5b562ee3165387b455c25e482b3bcdd08e15b6ce53217d125b3e6d3d534fd2ae)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "gt", [key, values]))

    @jsii.member(jsii_name="in")
    @builtins.classmethod
    def in_(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to be one of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__073acee7debd33e713f77895fb3e6d382a9eea212a4a4c6e1c7a2f3705de6f64)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "in", [key, values]))

    @jsii.member(jsii_name="is")
    @builtins.classmethod
    def is_(cls, key: builtins.str, value: builtins.str) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to equal ``value``.

        :param key: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0bbfb326d14b25705802b3c6c4cecaa037e4f1860a589256574f4c9fe27ba451)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "is", [key, value]))

    @jsii.member(jsii_name="lt")
    @builtins.classmethod
    def lt(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to less than all elements in ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__111b8f6c1b953e77a0992d11b3a577354987a6277ac78be2e636eb0ffcc14e44)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "lt", [key, values]))

    @jsii.member(jsii_name="notIn")
    @builtins.classmethod
    def not_in(
        cls,
        key: builtins.str,
        values: typing.Sequence[builtins.str],
    ) -> "NodeLabelQuery":
        '''Requires value of label ``key`` to be none of ``values``.

        :param key: -
        :param values: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6c0d435e0e346e4acd5c1b759d1c2019f34047c8c2625e0f9a7248d134e213f7)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast("NodeLabelQuery", jsii.sinvoke(cls, "notIn", [key, values]))


class NodeTaintQuery(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.NodeTaintQuery"):
    '''Taint queries that can be perfomed against nodes.'''

    @jsii.member(jsii_name="any")
    @builtins.classmethod
    def any(cls) -> "NodeTaintQuery":
        '''Matches any taint.'''
        return typing.cast("NodeTaintQuery", jsii.sinvoke(cls, "any", []))

    @jsii.member(jsii_name="exists")
    @builtins.classmethod
    def exists(
        cls,
        key: builtins.str,
        *,
        effect: typing.Optional["TaintEffect"] = None,
        evict_after: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "NodeTaintQuery":
        '''Matches a tain with any value of a specific key.

        :param key: -
        :param effect: The taint effect to match. Default: - all effects are matched.
        :param evict_after: How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node. Only applies for the ``NO_EXECUTE`` effect. Default: - bound forever.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__315d384afcd8a57cabb5fc286251866268f8b230d0faab332530cc7cfe9165aa)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        options = NodeTaintQueryOptions(effect=effect, evict_after=evict_after)

        return typing.cast("NodeTaintQuery", jsii.sinvoke(cls, "exists", [key, options]))

    @jsii.member(jsii_name="is")
    @builtins.classmethod
    def is_(
        cls,
        key: builtins.str,
        value: builtins.str,
        *,
        effect: typing.Optional["TaintEffect"] = None,
        evict_after: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "NodeTaintQuery":
        '''Matches a taint with a specific key and value.

        :param key: -
        :param value: -
        :param effect: The taint effect to match. Default: - all effects are matched.
        :param evict_after: How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node. Only applies for the ``NO_EXECUTE`` effect. Default: - bound forever.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fea84b95c4c50b9fcf9e3a66474138c3f227bd669015fccb52b9c534ab00741c)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        options = NodeTaintQueryOptions(effect=effect, evict_after=evict_after)

        return typing.cast("NodeTaintQuery", jsii.sinvoke(cls, "is", [key, value, options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NodeTaintQueryOptions",
    jsii_struct_bases=[],
    name_mapping={"effect": "effect", "evict_after": "evictAfter"},
)
class NodeTaintQueryOptions:
    def __init__(
        self,
        *,
        effect: typing.Optional["TaintEffect"] = None,
        evict_after: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Options for ``NodeTaintQuery``.

        :param effect: The taint effect to match. Default: - all effects are matched.
        :param evict_after: How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node. Only applies for the ``NO_EXECUTE`` effect. Default: - bound forever.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5699a2a86039391e5e5f1447227e1901e356177b347a331e9e9b0e8ac033c85f)
            check_type(argname="argument effect", value=effect, expected_type=type_hints["effect"])
            check_type(argname="argument evict_after", value=evict_after, expected_type=type_hints["evict_after"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if effect is not None:
            self._values["effect"] = effect
        if evict_after is not None:
            self._values["evict_after"] = evict_after

    @builtins.property
    def effect(self) -> typing.Optional["TaintEffect"]:
        '''The taint effect to match.

        :default: - all effects are matched.
        '''
        result = self._values.get("effect")
        return typing.cast(typing.Optional["TaintEffect"], result)

    @builtins.property
    def evict_after(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How much time should a pod that tolerates the ``NO_EXECUTE`` effect be bound to the node.

        Only applies for the ``NO_EXECUTE`` effect.

        :default: - bound forever.
        '''
        result = self._values.get("evict_after")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NodeTaintQueryOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IApiEndpoint)
class NonApiResource(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.NonApiResource"):
    '''Factory for creating non api resources.'''

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(cls, url: builtins.str) -> "NonApiResource":
        '''
        :param url: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__65b1b9af2f409f9ee21ea4e2dbe9859396579bd8a0eadeafb1fb0f2f5a1a1cd6)
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
        return typing.cast("NonApiResource", jsii.sinvoke(cls, "of", [url]))

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional[IApiResource]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional[IApiResource], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PathMapping",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "mode": "mode"},
)
class PathMapping:
    def __init__(
        self,
        *,
        path: builtins.str,
        mode: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Maps a string key to a path within a volume.

        :param path: The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        :param mode: Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3411a3dc66705e26dc1f479a09544fa394baa543a8ab6e58ccba4acac30c9056)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument mode", value=mode, expected_type=type_hints["mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if mode is not None:
            self._values["mode"] = mode

    @builtins.property
    def path(self) -> builtins.str:
        '''The relative path of the file to map the key to.

        May not be an absolute
        path. May not contain the path element '..'. May not start with the string
        '..'.
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def mode(self) -> typing.Optional[jsii.Number]:
        '''Optional: mode bits to use on this file, must be a value between 0 and 0777.

        If not specified, the volume defaultMode will be used. This might be
        in conflict with other options that affect the file mode, like fsGroup, and
        the result can be other mode bits set.
        '''
        result = self._values.get("mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PathMapping(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class PercentOrAbsolute(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.PercentOrAbsolute",
):
    '''Union like class repsenting either a ration in percents or an absolute number.'''

    @jsii.member(jsii_name="absolute")
    @builtins.classmethod
    def absolute(cls, num: jsii.Number) -> "PercentOrAbsolute":
        '''Absolute number.

        :param num: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__27ab65cf469b8ea6a7b769e1b98a85675042e413b1071f5a0980fdf01b9512d9)
            check_type(argname="argument num", value=num, expected_type=type_hints["num"])
        return typing.cast("PercentOrAbsolute", jsii.sinvoke(cls, "absolute", [num]))

    @jsii.member(jsii_name="percent")
    @builtins.classmethod
    def percent(cls, percent: jsii.Number) -> "PercentOrAbsolute":
        '''Percent ratio.

        :param percent: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__42de161a812ebc2074f6761937397096a6e92f901f1d7f64e2fe20b9ff12a229)
            check_type(argname="argument percent", value=percent, expected_type=type_hints["percent"])
        return typing.cast("PercentOrAbsolute", jsii.sinvoke(cls, "percent", [percent]))

    @jsii.member(jsii_name="isZero")
    def is_zero(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.invoke(self, "isZero", []))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        return typing.cast(typing.Any, jsii.get(self, "value"))


@jsii.enum(jsii_type="cdk8s-plus-23.PersistentVolumeAccessMode")
class PersistentVolumeAccessMode(enum.Enum):
    '''Access Modes.'''

    READ_WRITE_ONCE = "READ_WRITE_ONCE"
    '''The volume can be mounted as read-write by a single node.

    ReadWriteOnce access mode still can allow multiple pods to access
    the volume when the pods are running on the same node.
    '''
    READ_ONLY_MANY = "READ_ONLY_MANY"
    '''The volume can be mounted as read-only by many nodes.'''
    READ_WRITE_MANY = "READ_WRITE_MANY"
    '''The volume can be mounted as read-write by many nodes.'''
    READ_WRITE_ONCE_POD = "READ_WRITE_ONCE_POD"
    '''The volume can be mounted as read-write by a single Pod.

    Use ReadWriteOncePod access mode if you want to ensure that
    only one pod across whole cluster can read that PVC or write to it.
    This is only supported for CSI volumes and Kubernetes version 1.22+.
    '''


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PersistentVolumeClaimVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "read_only": "readOnly"},
)
class PersistentVolumeClaimVolumeOptions:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for a PersistentVolumeClaim-based volume.

        :param name: The volume name. Default: - Derived from the PVC name.
        :param read_only: Will force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fec7607525c4f2ff5082b241989a432e7ccaa548f4318cf8c06712b746a50cec)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - Derived from the PVC name.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Will force the ReadOnly setting in VolumeMounts.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PersistentVolumeClaimVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.PersistentVolumeMode")
class PersistentVolumeMode(enum.Enum):
    '''Volume Modes.'''

    FILE_SYSTEM = "FILE_SYSTEM"
    '''Volume is ounted into Pods into a directory.

    If the volume is backed by a block device and the device is empty,
    Kubernetes creates a filesystem on the device before mounting it
    for the first time.
    '''
    BLOCK = "BLOCK"
    '''Use a volume as a raw block device.

    Such volume is presented into a Pod as a block device,
    without any filesystem on it. This mode is useful to provide a Pod the fastest possible way
    to access a volume, without any filesystem layer between the Pod
    and the volume. On the other hand, the application running in
    the Pod must know how to handle a raw block device
    '''


@jsii.enum(jsii_type="cdk8s-plus-23.PersistentVolumeReclaimPolicy")
class PersistentVolumeReclaimPolicy(enum.Enum):
    '''Reclaim Policies.'''

    RETAIN = "RETAIN"
    '''The Retain reclaim policy allows for manual reclamation of the resource.

    When the PersistentVolumeClaim is deleted, the PersistentVolume still exists and the
    volume is considered "released". But it is not yet available for another claim
    because the previous claimant's data remains on the volume.
    An administrator can manually reclaim the volume with the following steps:

    1. Delete the PersistentVolume. The associated storage asset in external
       infrastructure (such as an AWS EBS, GCE PD, Azure Disk, or Cinder volume) still exists after the PV is deleted.
    2. Manually clean up the data on the associated storage asset accordingly.
    3. Manually delete the associated storage asset.

    If you want to reuse the same storage asset, create a new PersistentVolume
    with the same storage asset definition.
    '''
    DELETE = "DELETE"
    '''For volume plugins that support the Delete reclaim policy, deletion removes both the PersistentVolume object from Kubernetes, as well as the associated storage asset in the external infrastructure, such as an AWS EBS, GCE PD, Azure Disk, or Cinder volume.

    Volumes that were dynamically provisioned inherit the reclaim policy of their StorageClass, which defaults to Delete.
    The administrator should configure the StorageClass according to users' expectations; otherwise,
    the PV must be edited or patched after it is created
    '''


class PodConnections(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.PodConnections"):
    '''Controls network isolation rules for inter-pod communication.'''

    def __init__(self, instance: "AbstractPod") -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bd7c1c5475ef401c364ac27aa869f9c27b716ffd0df6523c1e44380983d310f)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="allowFrom")
    def allow_from(
        self,
        peer: INetworkPolicyPeer,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow network traffic from the peer to this pod.

        By default, this will create an ingress network policy for this pod, and an egress
        network policy for the peer. This is required if both sides are already isolated.
        Use ``options.isolation`` to control this behavior.

        :param peer: -
        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow incoming traffic to. Default: - The pod ports.

        Example::

            // create only an egress policy that selects the 'web' pod to allow outgoing traffic
            // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
            redis.connections.allowFrom(web, { isolation: Isolation.PEER })
            
            // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
            // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
            redis.connections.allowFrom(web, { isolation: Isolation.POD })
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d3c1eb1c88facf4f3c361c5dee059ee9e0c521100140f5cfda8cfceafcc10385)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
        options = PodConnectionsAllowFromOptions(isolation=isolation, ports=ports)

        return typing.cast(None, jsii.invoke(self, "allowFrom", [peer, options]))

    @jsii.member(jsii_name="allowTo")
    def allow_to(
        self,
        peer: INetworkPolicyPeer,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow network traffic from this pod to the peer.

        By default, this will create an egress network policy for this pod, and an ingress
        network policy for the peer. This is required if both sides are already isolated.
        Use ``options.isolation`` to control this behavior.

        :param peer: -
        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow outgoing traffic to. Default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.

        Example::

            // create only an egress policy that selects the 'web' pod to allow outgoing traffic
            // to the 'redis' pod. this requires the 'redis' pod to not be isolated for ingress.
            web.connections.allowTo(redis, { isolation: Isolation.POD })
            
            // create only an ingress policy that selects the 'redis' peer to allow incoming traffic
            // from the 'web' pod. this requires the 'web' pod to not be isolated for egress.
            web.connections.allowTo(redis, { isolation: Isolation.PEER })
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f4ae447e52f71d98ffc93533bb487918666384d41cac99eff19eb67051e8d02)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
        options = PodConnectionsAllowToOptions(isolation=isolation, ports=ports)

        return typing.cast(None, jsii.invoke(self, "allowTo", [peer, options]))

    @jsii.member(jsii_name="isolate")
    def isolate(self) -> None:
        '''Sets the default network policy for Pod/Workload to have all egress and ingress connections as disabled.'''
        return typing.cast(None, jsii.invoke(self, "isolate", []))

    @builtins.property
    @jsii.member(jsii_name="instance")
    def _instance(self) -> "AbstractPod":
        return typing.cast("AbstractPod", jsii.get(self, "instance"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodConnectionsAllowFromOptions",
    jsii_struct_bases=[],
    name_mapping={"isolation": "isolation", "ports": "ports"},
)
class PodConnectionsAllowFromOptions:
    def __init__(
        self,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Options for ``PodConnections.allowFrom``.

        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow incoming traffic to. Default: - The pod ports.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c0acdcd2c421feaa2dede8463b6fd83019efd8f2249acc7fac61b7bd335e34f)
            check_type(argname="argument isolation", value=isolation, expected_type=type_hints["isolation"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if isolation is not None:
            self._values["isolation"] = isolation
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def isolation(self) -> typing.Optional["PodConnectionsIsolation"]:
        '''Which isolation should be applied to establish the connection.

        :default: - unset, isolates both the pod and the peer.
        '''
        result = self._values.get("isolation")
        return typing.cast(typing.Optional["PodConnectionsIsolation"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[NetworkPolicyPort]]:
        '''Ports to allow incoming traffic to.

        :default: - The pod ports.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodConnectionsAllowFromOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodConnectionsAllowToOptions",
    jsii_struct_bases=[],
    name_mapping={"isolation": "isolation", "ports": "ports"},
)
class PodConnectionsAllowToOptions:
    def __init__(
        self,
        *,
        isolation: typing.Optional["PodConnectionsIsolation"] = None,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Options for ``PodConnections.allowTo``.

        :param isolation: Which isolation should be applied to establish the connection. Default: - unset, isolates both the pod and the peer.
        :param ports: Ports to allow outgoing traffic to. Default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae3b802c6cc3cb23e376c3302d96b94d325fe3a488303e5d0ed08c0600571678)
            check_type(argname="argument isolation", value=isolation, expected_type=type_hints["isolation"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if isolation is not None:
            self._values["isolation"] = isolation
        if ports is not None:
            self._values["ports"] = ports

    @builtins.property
    def isolation(self) -> typing.Optional["PodConnectionsIsolation"]:
        '''Which isolation should be applied to establish the connection.

        :default: - unset, isolates both the pod and the peer.
        '''
        result = self._values.get("isolation")
        return typing.cast(typing.Optional["PodConnectionsIsolation"], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[NetworkPolicyPort]]:
        '''Ports to allow outgoing traffic to.

        :default: - If the peer is a managed pod, take its ports. Otherwise, all ports are allowed.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[NetworkPolicyPort]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodConnectionsAllowToOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.PodConnectionsIsolation")
class PodConnectionsIsolation(enum.Enum):
    '''Isolation determines which policies are created when allowing connections from a a pod / workload to peers.'''

    POD = "POD"
    '''Only creates network policies that select the pod.'''
    PEER = "PEER"
    '''Only creates network policies that select the peer.'''


class PodDns(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.PodDns"):
    '''Holds dns settings of the pod.'''

    def __init__(
        self,
        *,
        hostname: typing.Optional[builtins.str] = None,
        hostname_as_fqdn: typing.Optional[builtins.bool] = None,
        nameservers: typing.Optional[typing.Sequence[builtins.str]] = None,
        options: typing.Optional[typing.Sequence[typing.Union[DnsOption, typing.Dict[builtins.str, typing.Any]]]] = None,
        policy: typing.Optional[DnsPolicy] = None,
        searches: typing.Optional[typing.Sequence[builtins.str]] = None,
        subdomain: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param hostname: Specifies the hostname of the Pod. Default: - Set to a system-defined value.
        :param hostname_as_fqdn: If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default: false
        :param nameservers: A list of IP addresses that will be used as DNS servers for the Pod. There can be at most 3 IP addresses specified. When the policy is set to "NONE", the list must contain at least one IP address, otherwise this property is optional. The servers listed will be combined to the base nameservers generated from the specified DNS policy with duplicate addresses removed.
        :param options: List of objects where each object may have a name property (required) and a value property (optional). The contents in this property will be merged to the options generated from the specified DNS policy. Duplicate entries are removed.
        :param policy: Set DNS policy for the pod. If policy is set to ``None``, other configuration must be supplied. Default: DnsPolicy.CLUSTER_FIRST
        :param searches: A list of DNS search domains for hostname lookup in the Pod. When specified, the provided list will be merged into the base search domain names generated from the chosen DNS policy. Duplicate domain names are removed. Kubernetes allows for at most 6 search domains.
        :param subdomain: If specified, the fully qualified Pod hostname will be "...svc.". Default: - No subdomain.
        '''
        props = PodDnsProps(
            hostname=hostname,
            hostname_as_fqdn=hostname_as_fqdn,
            nameservers=nameservers,
            options=options,
            policy=policy,
            searches=searches,
            subdomain=subdomain,
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="addNameserver")
    def add_nameserver(self, *nameservers: builtins.str) -> None:
        '''Add a nameserver.

        :param nameservers: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66a66d1de10ed911906db64d68fb7bdd08adeb4512c0e1814cc67599f789f532)
            check_type(argname="argument nameservers", value=nameservers, expected_type=typing.Tuple[type_hints["nameservers"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addNameserver", [*nameservers]))

    @jsii.member(jsii_name="addOption")
    def add_option(self, *options: DnsOption) -> None:
        '''Add a custom option.

        :param options: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3c34eee02a4d8daef1ac1092e96ae1fd61835fb87a92ac454a5c75f0aad36328)
            check_type(argname="argument options", value=options, expected_type=typing.Tuple[type_hints["options"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addOption", [*options]))

    @jsii.member(jsii_name="addSearch")
    def add_search(self, *searches: builtins.str) -> None:
        '''Add a search domain.

        :param searches: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a7c66cc0ec53776b66b09c61e55efd3700e6286ea480a5aa30a957e86c24e14)
            check_type(argname="argument searches", value=searches, expected_type=typing.Tuple[type_hints["searches"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addSearch", [*searches]))

    @builtins.property
    @jsii.member(jsii_name="hostnameAsFQDN")
    def hostname_as_fqdn(self) -> builtins.bool:
        '''Whether or not the pods hostname is set to its FQDN.'''
        return typing.cast(builtins.bool, jsii.get(self, "hostnameAsFQDN"))

    @builtins.property
    @jsii.member(jsii_name="nameservers")
    def nameservers(self) -> typing.List[builtins.str]:
        '''Nameservers defined for this pod.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "nameservers"))

    @builtins.property
    @jsii.member(jsii_name="options")
    def options(self) -> typing.List[DnsOption]:
        '''Custom dns options defined for this pod.'''
        return typing.cast(typing.List[DnsOption], jsii.get(self, "options"))

    @builtins.property
    @jsii.member(jsii_name="policy")
    def policy(self) -> DnsPolicy:
        '''The DNS policy of this pod.'''
        return typing.cast(DnsPolicy, jsii.get(self, "policy"))

    @builtins.property
    @jsii.member(jsii_name="searches")
    def searches(self) -> typing.List[builtins.str]:
        '''Search domains defined for this pod.'''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "searches"))

    @builtins.property
    @jsii.member(jsii_name="hostname")
    def hostname(self) -> typing.Optional[builtins.str]:
        '''The configured hostname of the pod.

        Undefined means its set to a system-defined value.
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "hostname"))

    @builtins.property
    @jsii.member(jsii_name="subdomain")
    def subdomain(self) -> typing.Optional[builtins.str]:
        '''The configured subdomain of the pod.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "subdomain"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodDnsProps",
    jsii_struct_bases=[],
    name_mapping={
        "hostname": "hostname",
        "hostname_as_fqdn": "hostnameAsFQDN",
        "nameservers": "nameservers",
        "options": "options",
        "policy": "policy",
        "searches": "searches",
        "subdomain": "subdomain",
    },
)
class PodDnsProps:
    def __init__(
        self,
        *,
        hostname: typing.Optional[builtins.str] = None,
        hostname_as_fqdn: typing.Optional[builtins.bool] = None,
        nameservers: typing.Optional[typing.Sequence[builtins.str]] = None,
        options: typing.Optional[typing.Sequence[typing.Union[DnsOption, typing.Dict[builtins.str, typing.Any]]]] = None,
        policy: typing.Optional[DnsPolicy] = None,
        searches: typing.Optional[typing.Sequence[builtins.str]] = None,
        subdomain: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Properties for ``PodDns``.

        :param hostname: Specifies the hostname of the Pod. Default: - Set to a system-defined value.
        :param hostname_as_fqdn: If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default: false
        :param nameservers: A list of IP addresses that will be used as DNS servers for the Pod. There can be at most 3 IP addresses specified. When the policy is set to "NONE", the list must contain at least one IP address, otherwise this property is optional. The servers listed will be combined to the base nameservers generated from the specified DNS policy with duplicate addresses removed.
        :param options: List of objects where each object may have a name property (required) and a value property (optional). The contents in this property will be merged to the options generated from the specified DNS policy. Duplicate entries are removed.
        :param policy: Set DNS policy for the pod. If policy is set to ``None``, other configuration must be supplied. Default: DnsPolicy.CLUSTER_FIRST
        :param searches: A list of DNS search domains for hostname lookup in the Pod. When specified, the provided list will be merged into the base search domain names generated from the chosen DNS policy. Duplicate domain names are removed. Kubernetes allows for at most 6 search domains.
        :param subdomain: If specified, the fully qualified Pod hostname will be "...svc.". Default: - No subdomain.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ac1bf922e81aa14b3fba4768a878f59172779f71facdca401374ca4d3214e90e)
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument hostname_as_fqdn", value=hostname_as_fqdn, expected_type=type_hints["hostname_as_fqdn"])
            check_type(argname="argument nameservers", value=nameservers, expected_type=type_hints["nameservers"])
            check_type(argname="argument options", value=options, expected_type=type_hints["options"])
            check_type(argname="argument policy", value=policy, expected_type=type_hints["policy"])
            check_type(argname="argument searches", value=searches, expected_type=type_hints["searches"])
            check_type(argname="argument subdomain", value=subdomain, expected_type=type_hints["subdomain"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if hostname is not None:
            self._values["hostname"] = hostname
        if hostname_as_fqdn is not None:
            self._values["hostname_as_fqdn"] = hostname_as_fqdn
        if nameservers is not None:
            self._values["nameservers"] = nameservers
        if options is not None:
            self._values["options"] = options
        if policy is not None:
            self._values["policy"] = policy
        if searches is not None:
            self._values["searches"] = searches
        if subdomain is not None:
            self._values["subdomain"] = subdomain

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''Specifies the hostname of the Pod.

        :default: - Set to a system-defined value.
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def hostname_as_fqdn(self) -> typing.Optional[builtins.bool]:
        '''If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default).

        In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname).
        In Windows containers, this means setting the registry value of hostname for the registry
        key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN.
        If a pod does not have FQDN, this has no effect.

        :default: false
        '''
        result = self._values.get("hostname_as_fqdn")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def nameservers(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of IP addresses that will be used as DNS servers for the Pod.

        There can be at most 3 IP addresses specified.
        When the policy is set to "NONE", the list must contain at least one IP address,
        otherwise this property is optional.
        The servers listed will be combined to the base nameservers generated from
        the specified DNS policy with duplicate addresses removed.
        '''
        result = self._values.get("nameservers")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def options(self) -> typing.Optional[typing.List[DnsOption]]:
        '''List of objects where each object may have a name property (required) and a value property (optional).

        The contents in this property
        will be merged to the options generated from the specified DNS policy.
        Duplicate entries are removed.
        '''
        result = self._values.get("options")
        return typing.cast(typing.Optional[typing.List[DnsOption]], result)

    @builtins.property
    def policy(self) -> typing.Optional[DnsPolicy]:
        '''Set DNS policy for the pod.

        If policy is set to ``None``, other configuration must be supplied.

        :default: DnsPolicy.CLUSTER_FIRST
        '''
        result = self._values.get("policy")
        return typing.cast(typing.Optional[DnsPolicy], result)

    @builtins.property
    def searches(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of DNS search domains for hostname lookup in the Pod.

        When specified, the provided list will be merged into the base
        search domain names generated from the chosen DNS policy.
        Duplicate domain names are removed.

        Kubernetes allows for at most 6 search domains.
        '''
        result = self._values.get("searches")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def subdomain(self) -> typing.Optional[builtins.str]:
        '''If specified, the fully qualified Pod hostname will be "...svc.".

        :default: - No subdomain.
        '''
        result = self._values.get("subdomain")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodDnsProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.PodManagementPolicy")
class PodManagementPolicy(enum.Enum):
    '''Controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down.

    The default policy is ``OrderedReady``, where pods are created in increasing order
    (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before
    continuing. When scaling down, the pods are removed in the opposite order.

    The alternative policy is ``Parallel`` which will create pods in parallel to match the
    desired scale without waiting, and on scale down will delete all pods at once.
    '''

    ORDERED_READY = "ORDERED_READY"
    PARALLEL = "PARALLEL"


class PodScheduling(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.PodScheduling"):
    '''Controls the pod scheduling strategy.'''

    def __init__(self, instance: "AbstractPod") -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47ed12829b5baad897980c42126fb49dbeaf1772ed7af8154360aafaf81abdd5)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="assign")
    def assign(self, node: NamedNode) -> None:
        '''Assign this pod a specific node by name.

        The scheduler ignores the Pod, and the kubelet on the named node
        tries to place the Pod on that node. Overrules any affinity rules of the pod.

        Some limitations of static assignment are:

        - If the named node does not exist, the Pod will not run, and in some
          cases may be automatically deleted.
        - If the named node does not have the resources to accommodate the Pod,
          the Pod will fail and its reason will indicate why, for example OutOfmemory or OutOfcpu.
        - Node names in cloud environments are not always predictable or stable.

        Will throw is the pod is already assigned to named node.

        Under the hood, this method utilizes the ``nodeName`` property.

        :param node: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__baa6a319ffc92f237f3131eb44fb98081d93d1374dafdfa1e64513e2f09df390)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        return typing.cast(None, jsii.invoke(self, "assign", [node]))

    @jsii.member(jsii_name="attract")
    def attract(
        self,
        node: LabeledNode,
        *,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Attract this pod to a node matched by selectors. You can select a node by using ``Node.labeled()``.

        Attracting to multiple nodes (i.e invoking this method multiple times) acts as
        an OR condition, meaning the pod will be assigned to either one of the nodes.

        Under the hood, this method utilizes the ``nodeAffinity`` property.

        :param node: -
        :param weight: Indicates the attraction is optional (soft), with this weight score. Default: - no weight. assignment is assumed to be required (hard).

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#node-affinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a688a3b42f476515177133c845f77cbcc73c9b46ebf0cab5b7c5788679cacf1)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        options = PodSchedulingAttractOptions(weight=weight)

        return typing.cast(None, jsii.invoke(self, "attract", [node, options]))

    @jsii.member(jsii_name="colocate")
    def colocate(
        self,
        selector: IPodSelector,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Co-locate this pod with a scheduling selection.

        A selection can be one of:

        - An instance of a ``Pod``.
        - An instance of a ``Workload`` (e.g ``Deployment``, ``StatefulSet``).
        - An un-managed pod that can be selected via ``Pods.select()``.

        Co-locating with multiple selections ((i.e invoking this method multiple times)) acts as
        an AND condition. meaning the pod will be assigned to a node that satisfies all
        selections (i.e runs at least one pod that satisifies each selection).

        Under the hood, this method utilizes the ``podAffinity`` property.

        :param selector: -
        :param topology: Which topology to coloate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the co-location is optional (soft), with this weight score. Default: - no weight. co-location is assumed to be required (hard).

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5121750265e3e753173fdf512ecbdb7b8806b8861cbd7e92aef08acc4b8a4370)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        options = PodSchedulingColocateOptions(topology=topology, weight=weight)

        return typing.cast(None, jsii.invoke(self, "colocate", [selector, options]))

    @jsii.member(jsii_name="separate")
    def separate(
        self,
        selector: IPodSelector,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Seperate this pod from a scheduling selection.

        A selection can be one of:

        - An instance of a ``Pod``.
        - An instance of a ``Workload`` (e.g ``Deployment``, ``StatefulSet``).
        - An un-managed pod that can be selected via ``Pods.select()``.

        Seperating from multiple selections acts as an AND condition. meaning the pod
        will not be assigned to a node that satisfies all selections (i.e runs at least one pod that satisifies each selection).

        Under the hood, this method utilizes the ``podAntiAffinity`` property.

        :param selector: -
        :param topology: Which topology to separate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the separation is optional (soft), with this weight score. Default: - no weight. separation is assumed to be required (hard).

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#inter-pod-affinity-and-anti-affinity
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a9a836c3b8d8e2d705fc1930e2a220d38e99ebcd0691265222c1585e4fe21e7d)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        options = PodSchedulingSeparateOptions(topology=topology, weight=weight)

        return typing.cast(None, jsii.invoke(self, "separate", [selector, options]))

    @jsii.member(jsii_name="tolerate")
    def tolerate(self, node: "TaintedNode") -> None:
        '''Allow this pod to tolerate taints matching these tolerations.

        You can put multiple taints on the same node and multiple tolerations on the same pod.
        The way Kubernetes processes multiple taints and tolerations is like a filter: start with
        all of a node's taints, then ignore the ones for which the pod has a matching toleration;
        the remaining un-ignored taints have the indicated effects on the pod. In particular:

        - if there is at least one un-ignored taint with effect NoSchedule then Kubernetes will
          not schedule the pod onto that node
        - if there is no un-ignored taint with effect NoSchedule but there is at least one un-ignored
          taint with effect PreferNoSchedule then Kubernetes will try to not schedule the pod onto the node
        - if there is at least one un-ignored taint with effect NoExecute then the pod will be evicted from
          the node (if it is already running on the node), and will not be scheduled onto the node (if it is
          not yet running on the node).

        Under the hood, this method utilizes the ``tolerations`` property.

        :param node: -

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4628bc3592fe5bc19aa6b8945e0104e46ab68f5bf7786cb794c7ba200ea1d9d0)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        return typing.cast(None, jsii.invoke(self, "tolerate", [node]))

    @builtins.property
    @jsii.member(jsii_name="instance")
    def _instance(self) -> "AbstractPod":
        return typing.cast("AbstractPod", jsii.get(self, "instance"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodSchedulingAttractOptions",
    jsii_struct_bases=[],
    name_mapping={"weight": "weight"},
)
class PodSchedulingAttractOptions:
    def __init__(self, *, weight: typing.Optional[jsii.Number] = None) -> None:
        '''Options for ``PodScheduling.attract``.

        :param weight: Indicates the attraction is optional (soft), with this weight score. Default: - no weight. assignment is assumed to be required (hard).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b3f6dda6c3bafc0a2557de901aca390a5d3ec5b453fcbce4f26e8cd50b144dbb)
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the attraction is optional (soft), with this weight score.

        :default: - no weight. assignment is assumed to be required (hard).
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSchedulingAttractOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodSchedulingColocateOptions",
    jsii_struct_bases=[],
    name_mapping={"topology": "topology", "weight": "weight"},
)
class PodSchedulingColocateOptions:
    def __init__(
        self,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``PodScheduling.colocate``.

        :param topology: Which topology to coloate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the co-location is optional (soft), with this weight score. Default: - no weight. co-location is assumed to be required (hard).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__930cc986b04cb79dc54ee74f1c128fc7e879bfd43f278004659a02ff51521b46)
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if topology is not None:
            self._values["topology"] = topology
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def topology(self) -> typing.Optional["Topology"]:
        '''Which topology to coloate on.

        :default: - Topology.HOSTNAME
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional["Topology"], result)

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the co-location is optional (soft), with this weight score.

        :default: - no weight. co-location is assumed to be required (hard).
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSchedulingColocateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodSchedulingSeparateOptions",
    jsii_struct_bases=[],
    name_mapping={"topology": "topology", "weight": "weight"},
)
class PodSchedulingSeparateOptions:
    def __init__(
        self,
        *,
        topology: typing.Optional["Topology"] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``PodScheduling.separate``.

        :param topology: Which topology to separate on. Default: - Topology.HOSTNAME
        :param weight: Indicates the separation is optional (soft), with this weight score. Default: - no weight. separation is assumed to be required (hard).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__792147c2c401e9a6df5c2bc6afecdf316a2dda24edbf73d1b5dcbaeca05c4969)
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if topology is not None:
            self._values["topology"] = topology
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def topology(self) -> typing.Optional["Topology"]:
        '''Which topology to separate on.

        :default: - Topology.HOSTNAME
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional["Topology"], result)

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the separation is optional (soft), with this weight score.

        :default: - no weight. separation is assumed to be required (hard).
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSchedulingSeparateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class PodSecurityContext(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.PodSecurityContext",
):
    '''Holds pod-level security attributes and common container settings.'''

    def __init__(
        self,
        *,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[FsGroupChangePolicy] = None,
        group: typing.Optional[jsii.Number] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["Sysctl", typing.Dict[builtins.str, typing.Any]]]] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param fs_group: Modify the ownership and permissions of pod volumes to this GID. Default: - Volume ownership is not changed.
        :param fs_group_change_policy: Defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Default: FsGroupChangePolicy.ALWAYS
        :param group: The GID to run the entrypoint of the container process. Default: - Group configured by container runtime
        :param sysctls: Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Default: - No sysctls
        :param user: The UID to run the entrypoint of the container process. Default: - User specified in image metadata
        '''
        props = PodSecurityContextProps(
            ensure_non_root=ensure_non_root,
            fs_group=fs_group,
            fs_group_change_policy=fs_group_change_policy,
            group=group,
            sysctls=sysctls,
            user=user,
        )

        jsii.create(self.__class__, self, [props])

    @builtins.property
    @jsii.member(jsii_name="ensureNonRoot")
    def ensure_non_root(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "ensureNonRoot"))

    @builtins.property
    @jsii.member(jsii_name="fsGroupChangePolicy")
    def fs_group_change_policy(self) -> FsGroupChangePolicy:
        return typing.cast(FsGroupChangePolicy, jsii.get(self, "fsGroupChangePolicy"))

    @builtins.property
    @jsii.member(jsii_name="sysctls")
    def sysctls(self) -> typing.List["Sysctl"]:
        return typing.cast(typing.List["Sysctl"], jsii.get(self, "sysctls"))

    @builtins.property
    @jsii.member(jsii_name="fsGroup")
    def fs_group(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "fsGroup"))

    @builtins.property
    @jsii.member(jsii_name="group")
    def group(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "group"))

    @builtins.property
    @jsii.member(jsii_name="user")
    def user(self) -> typing.Optional[jsii.Number]:
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "user"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodSecurityContextProps",
    jsii_struct_bases=[],
    name_mapping={
        "ensure_non_root": "ensureNonRoot",
        "fs_group": "fsGroup",
        "fs_group_change_policy": "fsGroupChangePolicy",
        "group": "group",
        "sysctls": "sysctls",
        "user": "user",
    },
)
class PodSecurityContextProps:
    def __init__(
        self,
        *,
        ensure_non_root: typing.Optional[builtins.bool] = None,
        fs_group: typing.Optional[jsii.Number] = None,
        fs_group_change_policy: typing.Optional[FsGroupChangePolicy] = None,
        group: typing.Optional[jsii.Number] = None,
        sysctls: typing.Optional[typing.Sequence[typing.Union["Sysctl", typing.Dict[builtins.str, typing.Any]]]] = None,
        user: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties for ``PodSecurityContext``.

        :param ensure_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. Default: true
        :param fs_group: Modify the ownership and permissions of pod volumes to this GID. Default: - Volume ownership is not changed.
        :param fs_group_change_policy: Defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Default: FsGroupChangePolicy.ALWAYS
        :param group: The GID to run the entrypoint of the container process. Default: - Group configured by container runtime
        :param sysctls: Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch. Default: - No sysctls
        :param user: The UID to run the entrypoint of the container process. Default: - User specified in image metadata
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6363a2ddd5446bad79772eff755e7f683629276e428641acf1c670eff63172ae)
            check_type(argname="argument ensure_non_root", value=ensure_non_root, expected_type=type_hints["ensure_non_root"])
            check_type(argname="argument fs_group", value=fs_group, expected_type=type_hints["fs_group"])
            check_type(argname="argument fs_group_change_policy", value=fs_group_change_policy, expected_type=type_hints["fs_group_change_policy"])
            check_type(argname="argument group", value=group, expected_type=type_hints["group"])
            check_type(argname="argument sysctls", value=sysctls, expected_type=type_hints["sysctls"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if ensure_non_root is not None:
            self._values["ensure_non_root"] = ensure_non_root
        if fs_group is not None:
            self._values["fs_group"] = fs_group
        if fs_group_change_policy is not None:
            self._values["fs_group_change_policy"] = fs_group_change_policy
        if group is not None:
            self._values["group"] = group
        if sysctls is not None:
            self._values["sysctls"] = sysctls
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def ensure_non_root(self) -> typing.Optional[builtins.bool]:
        '''Indicates that the container must run as a non-root user.

        If true, the Kubelet will validate the image at runtime to ensure that it does
        not run as UID 0 (root) and fail to start the container if it does.

        :default: true
        '''
        result = self._values.get("ensure_non_root")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fs_group(self) -> typing.Optional[jsii.Number]:
        '''Modify the ownership and permissions of pod volumes to this GID.

        :default: - Volume ownership is not changed.
        '''
        result = self._values.get("fs_group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fs_group_change_policy(self) -> typing.Optional[FsGroupChangePolicy]:
        '''Defines behavior of changing ownership and permission of the volume before being exposed inside Pod.

        This field will only apply to volume types which support fsGroup based ownership(and permissions).
        It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir.

        :default: FsGroupChangePolicy.ALWAYS
        '''
        result = self._values.get("fs_group_change_policy")
        return typing.cast(typing.Optional[FsGroupChangePolicy], result)

    @builtins.property
    def group(self) -> typing.Optional[jsii.Number]:
        '''The GID to run the entrypoint of the container process.

        :default: - Group configured by container runtime
        '''
        result = self._values.get("group")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def sysctls(self) -> typing.Optional[typing.List["Sysctl"]]:
        '''Sysctls hold a list of namespaced sysctls used for the pod.

        Pods with unsupported sysctls (by the container runtime) might fail to launch.

        :default: - No sysctls
        '''
        result = self._values.get("sysctls")
        return typing.cast(typing.Optional[typing.List["Sysctl"]], result)

    @builtins.property
    def user(self) -> typing.Optional[jsii.Number]:
        '''The UID to run the entrypoint of the container process.

        :default: - User specified in image metadata
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSecurityContextProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodSelectorConfig",
    jsii_struct_bases=[],
    name_mapping={"label_selector": "labelSelector", "namespaces": "namespaces"},
)
class PodSelectorConfig:
    def __init__(
        self,
        *,
        label_selector: LabelSelector,
        namespaces: typing.Optional[typing.Union[NamespaceSelectorConfig, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Configuration for selecting pods, optionally in particular namespaces.

        :param label_selector: A selector to select pods by labels.
        :param namespaces: Configuration for selecting which namepsaces are the pods allowed to be in.
        '''
        if isinstance(namespaces, dict):
            namespaces = NamespaceSelectorConfig(**namespaces)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__44fe7df147b4a0842d46f74b027dce8abd094924db423fde9d0e5312e061c390)
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "label_selector": label_selector,
        }
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def label_selector(self) -> LabelSelector:
        '''A selector to select pods by labels.'''
        result = self._values.get("label_selector")
        assert result is not None, "Required property 'label_selector' is missing"
        return typing.cast(LabelSelector, result)

    @builtins.property
    def namespaces(self) -> typing.Optional[NamespaceSelectorConfig]:
        '''Configuration for selecting which namepsaces are the pods allowed to be in.'''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[NamespaceSelectorConfig], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodSelectorConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IPodSelector)
class Pods(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.Pods",
):
    '''Represents a group of pods.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        namespaces: typing.Optional[INamespaceSelector] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param expressions: -
        :param labels: -
        :param namespaces: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b3f449172ea56f633aeb3f6c4cbb054fccdd66b28226c551ae10b950b79a5ef6)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        jsii.create(self.__class__, self, [scope, id, expressions, labels, namespaces])

    @jsii.member(jsii_name="all")
    @builtins.classmethod
    def all(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        namespaces: typing.Optional[Namespaces] = None,
    ) -> "Pods":
        '''Select all pods.

        :param scope: -
        :param id: -
        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58016a5ad7c076cae23e11393df24a223755c9fe60f2557a565cf9669b252f84)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = PodsAllOptions(namespaces=namespaces)

        return typing.cast("Pods", jsii.sinvoke(cls, "all", [scope, id, options]))

    @jsii.member(jsii_name="select")
    @builtins.classmethod
    def select(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        namespaces: typing.Optional[Namespaces] = None,
    ) -> "Pods":
        '''Select pods in the cluster with various selectors.

        :param scope: -
        :param id: -
        :param expressions: Expressions the pods must satisify. Default: - no expressions requirements.
        :param labels: Labels the pods must have. Default: - no strict labels requirements.
        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b85462ca2fc7137164c4a4532a3648a65a48f96a3e302b9c60056fe04635d36b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = PodsSelectOptions(
            expressions=expressions, labels=labels, namespaces=namespaces
        )

        return typing.cast("Pods", jsii.sinvoke(cls, "select", [scope, id, options]))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> NetworkPolicyPeerConfig:
        '''
        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast(NetworkPolicyPeerConfig, jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''
        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> PodSelectorConfig:
        '''Return the configuration of this selector.

        :see: IPodSelector.toPodSelectorConfig()
        '''
        return typing.cast(PodSelectorConfig, jsii.invoke(self, "toPodSelectorConfig", []))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodsAllOptions",
    jsii_struct_bases=[],
    name_mapping={"namespaces": "namespaces"},
)
class PodsAllOptions:
    def __init__(self, *, namespaces: typing.Optional[Namespaces] = None) -> None:
        '''Options for ``Pods.all``.

        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8582e12c7b48911cd1a16bf24ba5d98c6a57c8a408af614b1f003885e45f5dbf)
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def namespaces(self) -> typing.Optional[Namespaces]:
        '''Namespaces the pods are allowed to be in.

        Use ``Namespaces.all()`` to allow all namespaces.

        :default: - unset, implies the namespace of the resource this selection is used in.
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[Namespaces], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodsAllOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodsSelectOptions",
    jsii_struct_bases=[],
    name_mapping={
        "expressions": "expressions",
        "labels": "labels",
        "namespaces": "namespaces",
    },
)
class PodsSelectOptions:
    def __init__(
        self,
        *,
        expressions: typing.Optional[typing.Sequence[LabelExpression]] = None,
        labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        namespaces: typing.Optional[Namespaces] = None,
    ) -> None:
        '''Options for ``Pods.select``.

        :param expressions: Expressions the pods must satisify. Default: - no expressions requirements.
        :param labels: Labels the pods must have. Default: - no strict labels requirements.
        :param namespaces: Namespaces the pods are allowed to be in. Use ``Namespaces.all()`` to allow all namespaces. Default: - unset, implies the namespace of the resource this selection is used in.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__501a3690ab302dc547d79a77d2674ce08972c8264fc2772f02a72b0748146b3b)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
            check_type(argname="argument labels", value=labels, expected_type=type_hints["labels"])
            check_type(argname="argument namespaces", value=namespaces, expected_type=type_hints["namespaces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if expressions is not None:
            self._values["expressions"] = expressions
        if labels is not None:
            self._values["labels"] = labels
        if namespaces is not None:
            self._values["namespaces"] = namespaces

    @builtins.property
    def expressions(self) -> typing.Optional[typing.List[LabelExpression]]:
        '''Expressions the pods must satisify.

        :default: - no expressions requirements.
        '''
        result = self._values.get("expressions")
        return typing.cast(typing.Optional[typing.List[LabelExpression]], result)

    @builtins.property
    def labels(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Labels the pods must have.

        :default: - no strict labels requirements.
        '''
        result = self._values.get("labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def namespaces(self) -> typing.Optional[Namespaces]:
        '''Namespaces the pods are allowed to be in.

        Use ``Namespaces.all()`` to allow all namespaces.

        :default: - unset, implies the namespace of the resource this selection is used in.
        '''
        result = self._values.get("namespaces")
        return typing.cast(typing.Optional[Namespaces], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodsSelectOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Probe(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Probe"):
    '''Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.'''

    @jsii.member(jsii_name="fromCommand")
    @builtins.classmethod
    def from_command(
        cls,
        command: typing.Sequence[builtins.str],
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "Probe":
        '''Defines a probe based on a command which is executed within the container.

        :param command: The command to execute.
        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5817ad73b49c26f1b90747085a44963aacaa4b5518c4533a02d64581a4f6d65b)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
        options = CommandProbeOptions(
            failure_threshold=failure_threshold,
            initial_delay_seconds=initial_delay_seconds,
            period_seconds=period_seconds,
            success_threshold=success_threshold,
            timeout_seconds=timeout_seconds,
        )

        return typing.cast("Probe", jsii.sinvoke(cls, "fromCommand", [command, options]))

    @jsii.member(jsii_name="fromHttpGet")
    @builtins.classmethod
    def from_http_get(
        cls,
        path: builtins.str,
        *,
        port: typing.Optional[jsii.Number] = None,
        scheme: typing.Optional[ConnectionScheme] = None,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "Probe":
        '''Defines a probe based on an HTTP GET request to the IP address of the container.

        :param path: The URL path to hit.
        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        :param scheme: Scheme to use for connecting to the host (HTTP or HTTPS). Default: ConnectionScheme.HTTP
        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d53634f7ee66eb84025d70153b0c2853861f88f84acc4192668ec6f5ba52187)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = HttpGetProbeOptions(
            port=port,
            scheme=scheme,
            failure_threshold=failure_threshold,
            initial_delay_seconds=initial_delay_seconds,
            period_seconds=period_seconds,
            success_threshold=success_threshold,
            timeout_seconds=timeout_seconds,
        )

        return typing.cast("Probe", jsii.sinvoke(cls, "fromHttpGet", [path, options]))

    @jsii.member(jsii_name="fromTcpSocket")
    @builtins.classmethod
    def from_tcp_socket(
        cls,
        *,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> "Probe":
        '''Defines a probe based opening a connection to a TCP socket on the container.

        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        options = TcpSocketProbeOptions(
            host=host,
            port=port,
            failure_threshold=failure_threshold,
            initial_delay_seconds=initial_delay_seconds,
            period_seconds=period_seconds,
            success_threshold=success_threshold,
            timeout_seconds=timeout_seconds,
        )

        return typing.cast("Probe", jsii.sinvoke(cls, "fromTcpSocket", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ProbeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
    },
)
class ProbeOptions:
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Probe options.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e05451d9602048251a9c4f8a1d0fb63b24ea8b98f04209a3d5d0f708001660a5)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.Protocol")
class Protocol(enum.Enum):
    '''Network protocols.'''

    TCP = "TCP"
    '''TCP.'''
    UDP = "UDP"
    '''UDP.'''
    SCTP = "SCTP"
    '''SCTP.'''


class Replicas(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Replicas"):
    '''The amount of replicas that will change.'''

    @jsii.member(jsii_name="absolute")
    @builtins.classmethod
    def absolute(cls, value: jsii.Number) -> "Replicas":
        '''Changes the pods by a percentage of the it's current value.

        :param value: The amount of change to apply. Must be greater than 0.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f3ce43be5a382976f8a0fe4dc9db719215daba3641b59e72583d687d137644b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Replicas", jsii.sinvoke(cls, "absolute", [value]))

    @jsii.member(jsii_name="percent")
    @builtins.classmethod
    def percent(cls, value: jsii.Number) -> "Replicas":
        '''Changes the pods by a percentage of the it's current value.

        :param value: The percentage of change to apply. Must be greater than 0.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__552dd4095bf0bcce2fb46b86aeff6d3be67e672c332434fd17222c5180b4516e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast("Replicas", jsii.sinvoke(cls, "percent", [value]))


@jsii.implements(IResource, IApiResource, IApiEndpoint)
class Resource(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk8s-plus-23.Resource",
):
    '''Base class for all Kubernetes objects in stdk8s.

    Represents a single
    resource.
    '''

    def __init__(self, scope: _constructs_77d1e7e8.Construct, id: builtins.str) -> None:
        '''
        :param scope: -
        :param id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b68a4b204ef5d33bffc8c77581ba03f8b62729fd1249ee6980cb5412a48f6dc)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        jsii.create(self.__class__, self, [scope, id])

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional[IApiResource]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional[IApiResource], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. "authorization.k8s.io").'''
        return typing.cast(builtins.str, jsii.get(self, "apiGroup"))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    @abc.abstractmethod
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.'''
        ...

    @builtins.property
    @jsii.member(jsii_name="apiVersion")
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        return typing.cast(builtins.str, jsii.get(self, "apiVersion"))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="metadata")
    def metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "metadata"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''The name of this API object.'''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="permissions")
    def permissions(self) -> "ResourcePermissions":
        return typing.cast("ResourcePermissions", jsii.get(self, "permissions"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    @abc.abstractmethod
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        ...

    @builtins.property
    @jsii.member(jsii_name="resourceName")
    def resource_name(self) -> typing.Optional[builtins.str]:
        '''The unique, namespace-global, name of an object inside the Kubernetes cluster.

        If this is omitted, the ApiResource should represent all objects of the given type.
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "resourceName"))


class _ResourceProxy(Resource):
    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.'''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, Resource).__jsii_proxy_class__ = lambda : _ResourceProxy


@jsii.enum(jsii_type="cdk8s-plus-23.ResourceFieldPaths")
class ResourceFieldPaths(enum.Enum):
    CPU_LIMIT = "CPU_LIMIT"
    '''CPU limit of the container.'''
    MEMORY_LIMIT = "MEMORY_LIMIT"
    '''Memory limit of the container.'''
    CPU_REQUEST = "CPU_REQUEST"
    '''CPU request of the container.'''
    MEMORY_REQUEST = "MEMORY_REQUEST"
    '''Memory request of the container.'''
    STORAGE_LIMIT = "STORAGE_LIMIT"
    '''Ephemeral storage limit of the container.'''
    STORAGE_REQUEST = "STORAGE_REQUEST"
    '''Ephemeral storage request of the container.'''


class ResourcePermissions(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.ResourcePermissions",
):
    '''Controls permissions for operations on resources.'''

    def __init__(self, instance: Resource) -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__48bc5628f9123f64c62154c2768e7e261dd09abf4445bfb575d5739313f56616)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="grantRead")
    def grant_read(self, *subjects: ISubject) -> "RoleBinding":
        '''Grants the list of subjects permissions to read this resource.

        :param subjects: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e27dca4f9e605ba2970b89f244bd3eeebfe0476fc6047b34800825e5a8d6651)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("RoleBinding", jsii.invoke(self, "grantRead", [*subjects]))

    @jsii.member(jsii_name="grantReadWrite")
    def grant_read_write(self, *subjects: ISubject) -> "RoleBinding":
        '''Grants the list of subjects permissions to read and write this resource.

        :param subjects: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3cc2138737d712727d611915745acfc6b190cfb19ff8fb0cd13d8503e6c5a574)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("RoleBinding", jsii.invoke(self, "grantReadWrite", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="instance")
    def _instance(self) -> Resource:
        return typing.cast(Resource, jsii.get(self, "instance"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ResourceProps",
    jsii_struct_bases=[],
    name_mapping={"metadata": "metadata"},
)
class ResourceProps:
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Initialization properties for resources.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8cd997edae0f9676df4ed694a33400050945ad0dfa94f28f50d1e4e9d98d7c9d)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ResourceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.RestartPolicy")
class RestartPolicy(enum.Enum):
    '''Restart policy for all containers within the pod.'''

    ALWAYS = "ALWAYS"
    '''Always restart the pod after it exits.'''
    ON_FAILURE = "ON_FAILURE"
    '''Only restart if the pod exits with a non-zero exit code.'''
    NEVER = "NEVER"
    '''Never restart the pod.'''


@jsii.implements(IRole)
class Role(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Role"):
    '''Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        rules: typing.Optional[typing.Sequence[typing.Union["RolePolicyRule", typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param rules: A list of rules the role should allow. Default: []
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63791843c690ca783ef1f82d5ce2dae4aed60abdc633a5ccde5e30e98e7cec0f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = RoleProps(rules=rules, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromRoleName")
    @builtins.classmethod
    def from_role_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> IRole:
        '''Imports a role from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f0d562518e66184aef58e7456eb5a34ae2f3a666724944121416a501ebe2ea39)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(IRole, jsii.sinvoke(cls, "fromRoleName", [scope, id, name]))

    @jsii.member(jsii_name="allow")
    def allow(
        self,
        verbs: typing.Sequence[builtins.str],
        *resources: IApiResource,
    ) -> None:
        '''Add permission to perform a list of HTTP verbs on a collection of resources.

        :param verbs: -
        :param resources: The resource(s) to apply to.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/authorization/#determine-the-request-verb
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__95deb0719c7a0b61379b6abf53feecbcc3f47751b6a2bcea9f58e8848b0a5e81)
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allow", [verbs, *resources]))

    @jsii.member(jsii_name="allowCreate")
    def allow_create(self, *resources: IApiResource) -> None:
        '''Add "create" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__098b0749da390e33fc4223b52c89e77bb8175204176d953251894d2490c198ec)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowCreate", [*resources]))

    @jsii.member(jsii_name="allowDelete")
    def allow_delete(self, *resources: IApiResource) -> None:
        '''Add "delete" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e04325f514d3b82e149999f7ffb6678e6418b21ce711dc9639484d60338dabbf)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDelete", [*resources]))

    @jsii.member(jsii_name="allowDeleteCollection")
    def allow_delete_collection(self, *resources: IApiResource) -> None:
        '''Add "deletecollection" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8edf4dab103ada2e33d54027e001551862567de23ef2e3f309781175d3faa03b)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDeleteCollection", [*resources]))

    @jsii.member(jsii_name="allowGet")
    def allow_get(self, *resources: IApiResource) -> None:
        '''Add "get" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__45ff7679e65f692cb9a63b3e5f2fd374e294d356c084ade4e4b7692492382e84)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowGet", [*resources]))

    @jsii.member(jsii_name="allowList")
    def allow_list(self, *resources: IApiResource) -> None:
        '''Add "list" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fb452e4adfa89a35a86129327a69e2443a30f6941b51425ce83a5e57e6fd9151)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowList", [*resources]))

    @jsii.member(jsii_name="allowPatch")
    def allow_patch(self, *resources: IApiResource) -> None:
        '''Add "patch" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ea16007e4cbc4989268efc0b3a1af93c852cf215d598c8a7ecd907ed3891f4a)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowPatch", [*resources]))

    @jsii.member(jsii_name="allowRead")
    def allow_read(self, *resources: IApiResource) -> None:
        '''Add "get", "list", and "watch" permissions for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5894496c5a8d931c5d4b40b684c4b564dd884ac77a1c18a5b85893f0066f7bbf)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowRead", [*resources]))

    @jsii.member(jsii_name="allowReadWrite")
    def allow_read_write(self, *resources: IApiResource) -> None:
        '''Add "get", "list", "watch", "create", "update", "patch", "delete", and "deletecollection" permissions for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c69e62f79eedee623a3ac2c0cefbbc174d5ae04fcadd0be86d0e8f99df27d93c)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowReadWrite", [*resources]))

    @jsii.member(jsii_name="allowUpdate")
    def allow_update(self, *resources: IApiResource) -> None:
        '''Add "update" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__31b356da4053847dd79288316bfb46270633ccf8496e1107fce4eebd06a46f3d)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowUpdate", [*resources]))

    @jsii.member(jsii_name="allowWatch")
    def allow_watch(self, *resources: IApiResource) -> None:
        '''Add "watch" permission for the resources.

        :param resources: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__26301015243334a2be795743f69b5013da69e6f3cc66b9bab4860a87166072a8)
            check_type(argname="argument resources", value=resources, expected_type=typing.Tuple[type_hints["resources"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowWatch", [*resources]))

    @jsii.member(jsii_name="bind")
    def bind(self, *subjects: ISubject) -> "RoleBinding":
        '''Create a RoleBinding that binds the permissions in this Role to a list of subjects, that will only apply this role's namespace.

        :param subjects: a list of subjects to bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df082262ce320c3ecae5a8da349a8967b36874b8c0ba374d20597ae77e220f44)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast("RoleBinding", jsii.invoke(self, "bind", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(self) -> typing.List["RolePolicyRule"]:
        '''Rules associaated with this Role.

        Returns a copy, use ``allow`` to add rules.
        '''
        return typing.cast(typing.List["RolePolicyRule"], jsii.get(self, "rules"))


class RoleBinding(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.RoleBinding",
):
    '''A RoleBinding grants permissions within a specific namespace to a user or set of users.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        role: IRole,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param role: The role to bind to. A RoleBinding can reference a Role or a ClusterRole.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4d49ae7b42f8d3fd9d657ce71f8a53016767546a6ac857ade2fbb5fc8560bb25)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = RoleBindingProps(role=role, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addSubjects")
    def add_subjects(self, *subjects: ISubject) -> None:
        '''Adds a subject to the role.

        :param subjects: The subjects to add.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0c14d3d0ba0690502c4c139a63e6dc32ff09449b46d3a025fc59fec191a86cb)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addSubjects", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> IRole:
        return typing.cast(IRole, jsii.get(self, "role"))

    @builtins.property
    @jsii.member(jsii_name="subjects")
    def subjects(self) -> typing.List[ISubject]:
        return typing.cast(typing.List[ISubject], jsii.get(self, "subjects"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.RoleBindingProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "role": "role"},
)
class RoleBindingProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        role: IRole,
    ) -> None:
        '''Properties for ``RoleBinding``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param role: The role to bind to. A RoleBinding can reference a Role or a ClusterRole.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__38fb9deb73e2ae9ce8501e69d0c916b438e6ccf4429460617f0ed947240726a3)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "role": role,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def role(self) -> IRole:
        '''The role to bind to.

        A RoleBinding can reference a Role or a ClusterRole.
        '''
        result = self._values.get("role")
        assert result is not None, "Required property 'role' is missing"
        return typing.cast(IRole, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RoleBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.RolePolicyRule",
    jsii_struct_bases=[],
    name_mapping={"resources": "resources", "verbs": "verbs"},
)
class RolePolicyRule:
    def __init__(
        self,
        *,
        resources: typing.Sequence[IApiResource],
        verbs: typing.Sequence[builtins.str],
    ) -> None:
        '''Policy rule of a `Role.

        :param resources: Resources this rule applies to.
        :param verbs: Verbs to allow. (e.g ['get', 'watch'])
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c563faa70a7835eccec8e51e2f74ef3aca555d19b03c0d8f04e64e1b64fef77a)
            check_type(argname="argument resources", value=resources, expected_type=type_hints["resources"])
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "resources": resources,
            "verbs": verbs,
        }

    @builtins.property
    def resources(self) -> typing.List[IApiResource]:
        '''Resources this rule applies to.'''
        result = self._values.get("resources")
        assert result is not None, "Required property 'resources' is missing"
        return typing.cast(typing.List[IApiResource], result)

    @builtins.property
    def verbs(self) -> typing.List[builtins.str]:
        '''Verbs to allow.

        (e.g ['get', 'watch'])
        '''
        result = self._values.get("verbs")
        assert result is not None, "Required property 'verbs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RolePolicyRule(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.RoleProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "rules": "rules"},
)
class RoleProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[RolePolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for ``Role``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param rules: A list of rules the role should allow. Default: []
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f7d8b37fa30ec5f3d060737787dda1138983bd354f4f5930bb015c0fd7f0e2e)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[RolePolicyRule]]:
        '''A list of rules the role should allow.

        :default: []
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[RolePolicyRule]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RoleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ScalingPolicy",
    jsii_struct_bases=[],
    name_mapping={"replicas": "replicas", "duration": "duration"},
)
class ScalingPolicy:
    def __init__(
        self,
        *,
        replicas: Replicas,
        duration: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''
        :param replicas: The type and quantity of replicas to change.
        :param duration: The amount of time the scaling policy has to continue scaling before the target metric must be revalidated. Must be greater than 0 seconds and no longer than 30 minutes. Default: - 15 seconds
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__adf30d72bf9cd6b078c0f87b91b29aaa26ec17dd2412093007404b680825e4e6)
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument duration", value=duration, expected_type=type_hints["duration"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "replicas": replicas,
        }
        if duration is not None:
            self._values["duration"] = duration

    @builtins.property
    def replicas(self) -> Replicas:
        '''The type and quantity of replicas to change.'''
        result = self._values.get("replicas")
        assert result is not None, "Required property 'replicas' is missing"
        return typing.cast(Replicas, result)

    @builtins.property
    def duration(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''The amount of time the scaling policy has to continue scaling before the target metric must be revalidated.

        Must be greater than 0 seconds and no longer than 30 minutes.

        :default: - 15 seconds
        '''
        result = self._values.get("duration")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ScalingPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ScalingRules",
    jsii_struct_bases=[],
    name_mapping={
        "policies": "policies",
        "stabilization_window": "stabilizationWindow",
        "strategy": "strategy",
    },
)
class ScalingRules:
    def __init__(
        self,
        *,
        policies: typing.Optional[typing.Sequence[typing.Union[ScalingPolicy, typing.Dict[builtins.str, typing.Any]]]] = None,
        stabilization_window: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        strategy: typing.Optional["ScalingStrategy"] = None,
    ) -> None:
        '''Defines the scaling behavior for one direction.

        :param policies: The scaling policies. Default: - Scale up - Increase no more than 4 pods per 60 seconds - Double the number of pods per 60 seconds - Scale down - Decrease to minReplica count
        :param stabilization_window: Defines the window of past metrics that the autoscaler should consider when calculating wether or not autoscaling should occur. Minimum duration is 1 second, max is 1 hour. Default: - On scale down no stabilization is performed. - On scale up stabilization is performed for 5 minutes.
        :param strategy: The strategy to use when scaling. Default: MAX_CHANGE
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9f95e43fbe37f4d603ca0dc30fafaf3a419500f86b570cdd967369ff72dce51e)
            check_type(argname="argument policies", value=policies, expected_type=type_hints["policies"])
            check_type(argname="argument stabilization_window", value=stabilization_window, expected_type=type_hints["stabilization_window"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if policies is not None:
            self._values["policies"] = policies
        if stabilization_window is not None:
            self._values["stabilization_window"] = stabilization_window
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def policies(self) -> typing.Optional[typing.List[ScalingPolicy]]:
        '''The scaling policies.

        :default:

        - Scale up

        - Increase no more than 4 pods per 60 seconds
        - Double the number of pods per 60 seconds

        - Scale down

        - Decrease to minReplica count
        '''
        result = self._values.get("policies")
        return typing.cast(typing.Optional[typing.List[ScalingPolicy]], result)

    @builtins.property
    def stabilization_window(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Defines the window of past metrics that the autoscaler should consider when calculating wether or not autoscaling should occur.

        Minimum duration is 1 second, max is 1 hour.

        :default:

        - On scale down no stabilization is performed.
        - On scale up stabilization is performed for 5 minutes.

        Example::

            stabilizationWindow: Duration.minutes(30)
            // Autoscaler considers the last 30 minutes of metrics when deciding whether to scale.
        '''
        result = self._values.get("stabilization_window")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def strategy(self) -> typing.Optional["ScalingStrategy"]:
        '''The strategy to use when scaling.

        :default: MAX_CHANGE
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional["ScalingStrategy"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ScalingRules(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.ScalingStrategy")
class ScalingStrategy(enum.Enum):
    MAX_CHANGE = "MAX_CHANGE"
    '''Use the policy that provisions the most changes.'''
    MIN_CHANGE = "MIN_CHANGE"
    '''Use the policy that provisions the least amount of changes.'''
    DISABLED = "DISABLED"
    '''(deprecated) Disables scaling in this direction.

    :deprecated: - Omit the ScalingRule instead

    :stability: deprecated
    '''


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ScalingTarget",
    jsii_struct_bases=[],
    name_mapping={
        "api_version": "apiVersion",
        "containers": "containers",
        "kind": "kind",
        "name": "name",
        "replicas": "replicas",
    },
)
class ScalingTarget:
    def __init__(
        self,
        *,
        api_version: builtins.str,
        containers: typing.Sequence[Container],
        kind: builtins.str,
        name: builtins.str,
        replicas: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties used to configure the target of an Autoscaler.

        :param api_version: The object's API version (e.g. "authorization.k8s.io/v1").
        :param containers: Container definitions associated with the target.
        :param kind: The object kind (e.g. "Deployment").
        :param name: The Kubernetes name of this resource.
        :param replicas: The fixed number of replicas defined on the target. This is used for validation purposes as Scalable targets should not have a fixed number of replicas.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb2090cb54589f72519999c7a4c7ac50287144d1d10388d96f3101a75306337b)
            check_type(argname="argument api_version", value=api_version, expected_type=type_hints["api_version"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "api_version": api_version,
            "containers": containers,
            "kind": kind,
            "name": name,
        }
        if replicas is not None:
            self._values["replicas"] = replicas

    @builtins.property
    def api_version(self) -> builtins.str:
        '''The object's API version (e.g. "authorization.k8s.io/v1").'''
        result = self._values.get("api_version")
        assert result is not None, "Required property 'api_version' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def containers(self) -> typing.List[Container]:
        '''Container definitions associated with the target.'''
        result = self._values.get("containers")
        assert result is not None, "Required property 'containers' is missing"
        return typing.cast(typing.List[Container], result)

    @builtins.property
    def kind(self) -> builtins.str:
        '''The object kind (e.g. "Deployment").'''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The Kubernetes name of this resource.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''The fixed number of replicas defined on the target.

        This is used
        for validation purposes as Scalable targets should not have a
        fixed number of replicas.
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ScalingTarget(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ISecret)
class Secret(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Secret"):
    '''Kubernetes Secrets let you store and manage sensitive information, such as passwords, OAuth tokens, and ssh keys.

    Storing confidential information in a
    Secret is safer and more flexible than putting it verbatim in a Pod
    definition or in a container image.

    :see: https://kubernetes.io/docs/concepts/configuration/secret
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        string_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        type: typing.Optional[builtins.str] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param string_data: stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.
        :param type: Optional type associated with the secret. Used to facilitate programmatic handling of secret data by various controllers. Default: undefined - Don't set a type.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fa88080038af5985de8ce4a7040b874761c706df78a35acfca2e7156ad575ed6)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = SecretProps(
            string_data=string_data, type=type, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromSecretName")
    @builtins.classmethod
    def from_secret_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> ISecret:
        '''Imports a secret from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fcbd203a969f69f1384eb3916c54864536abf5d37610f38824e72481cc4e9843)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(ISecret, jsii.sinvoke(cls, "fromSecretName", [scope, id, name]))

    @jsii.member(jsii_name="addStringData")
    def add_string_data(self, key: builtins.str, value: builtins.str) -> None:
        '''Adds a string data field to the secert.

        :param key: Key.
        :param value: Value.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f0cff387c2fe26062fbe9f933cd7ddc06a5be63c0dbbff1eda0c0322a7223711)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addStringData", [key, value]))

    @jsii.member(jsii_name="getStringData")
    def get_string_data(self, key: builtins.str) -> typing.Optional[builtins.str]:
        '''Gets a string data by key or undefined.

        :param key: Key.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01dc1ba1ba0c0ada278ed61b4289ccaf0ed36f27745db1fe2eabc52d3b2c8254)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getStringData", [key]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="immutable")
    def immutable(self) -> builtins.bool:
        '''Whether or not the secret is immutable.'''
        return typing.cast(builtins.bool, jsii.get(self, "immutable"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.SecretValue",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "secret": "secret"},
)
class SecretValue:
    def __init__(self, *, key: builtins.str, secret: ISecret) -> None:
        '''Represents a specific value in JSON secret.

        :param key: The JSON key.
        :param secret: The secret.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20588d9523cdaac39e1a49d4f743ecb14f7d02b63f274cb511e1f78b2041d0a2)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument secret", value=secret, expected_type=type_hints["secret"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "secret": secret,
        }

    @builtins.property
    def key(self) -> builtins.str:
        '''The JSON key.'''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def secret(self) -> ISecret:
        '''The secret.'''
        result = self._values.get("secret")
        assert result is not None, "Required property 'secret' is missing"
        return typing.cast(ISecret, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SecretValue(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.SecretVolumeOptions",
    jsii_struct_bases=[],
    name_mapping={
        "default_mode": "defaultMode",
        "items": "items",
        "name": "name",
        "optional": "optional",
    },
)
class SecretVolumeOptions:
    def __init__(
        self,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union[PathMapping, typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Options for the Secret-based volume.

        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the secret or its keys must be defined. Default: - undocumented
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__314736a843ae47826249ce3e4e19d56166a4517c5881e4d1fcb34a4fd37c20bf)
            check_type(argname="argument default_mode", value=default_mode, expected_type=type_hints["default_mode"])
            check_type(argname="argument items", value=items, expected_type=type_hints["items"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument optional", value=optional, expected_type=type_hints["optional"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default_mode is not None:
            self._values["default_mode"] = default_mode
        if items is not None:
            self._values["items"] = items
        if name is not None:
            self._values["name"] = name
        if optional is not None:
            self._values["optional"] = optional

    @builtins.property
    def default_mode(self) -> typing.Optional[jsii.Number]:
        '''Mode bits to use on created files by default.

        Must be a value between 0 and
        0777. Defaults to 0644. Directories within the path are not affected by
        this setting. This might be in conflict with other options that affect the
        file mode, like fsGroup, and the result can be other mode bits set.

        :default:

        644. Directories within the path are not affected by this
        setting. This might be in conflict with other options that affect the file
        mode, like fsGroup, and the result can be other mode bits set.
        '''
        result = self._values.get("default_mode")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def items(self) -> typing.Optional[typing.Mapping[builtins.str, PathMapping]]:
        '''If unspecified, each key-value pair in the Data field of the referenced secret will be projected into the volume as a file whose name is the key and content is the value.

        If specified, the listed keys will be projected
        into the specified paths, and unlisted keys will not be present. If a key
        is specified which is not present in the secret, the volume setup will
        error unless it is marked optional. Paths must be relative and may not
        contain the '..' path or start with '..'.

        :default: - no mapping
        '''
        result = self._values.get("items")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, PathMapping]], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The volume name.

        :default: - auto-generated
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def optional(self) -> typing.Optional[builtins.bool]:
        '''Specify whether the secret or its keys must be defined.

        :default: - undocumented
        '''
        result = self._values.get("optional")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SecretVolumeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Service(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Service"):
    '''An abstract way to expose an application running on a set of Pods as a network service.

    With Kubernetes you don't need to modify your application to use an unfamiliar service discovery mechanism.
    Kubernetes gives Pods their own IP addresses and a single DNS name for a set of Pods, and can load-balance across them.

    For example, consider a stateless image-processing backend which is running with 3 replicas. Those replicas are fungible—frontends do not care which backend they use.
    While the actual Pods that compose the backend set may change, the frontend clients should not need to be aware of that,
    nor should they need to keep track of the set of backends themselves.
    The Service abstraction enables this decoupling.

    If you're able to use Kubernetes APIs for service discovery in your application, you can query the API server for Endpoints,
    that get updated whenever the set of Pods in a Service changes. For non-native applications, Kubernetes offers ways to place a network port
    or load balancer in between your application and the backend Pods.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        cluster_ip: typing.Optional[builtins.str] = None,
        external_i_ps: typing.Optional[typing.Sequence[builtins.str]] = None,
        external_name: typing.Optional[builtins.str] = None,
        load_balancer_source_ranges: typing.Optional[typing.Sequence[builtins.str]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union["ServicePort", typing.Dict[builtins.str, typing.Any]]]] = None,
        selector: typing.Optional[IPodSelector] = None,
        type: typing.Optional["ServiceType"] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param cluster_ip: The IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are "None", empty string (""), or a valid IP address. "None" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. Default: - Automatically assigned.
        :param external_i_ps: A list of IP addresses for which nodes in the cluster will also accept traffic for this service. These IPs are not managed by Kubernetes. The user is responsible for ensuring that traffic arrives at a node with this IP. A common example is external load-balancers that are not part of the Kubernetes system. Default: - No external IPs.
        :param external_name: The externalName to be used when ServiceType.EXTERNAL_NAME is set. Default: - No external name.
        :param load_balancer_source_ranges: A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs. More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        :param ports: The ports this service binds to. If the selector of the service is a managed pod / workload, its ports will are automatically extracted and used as the default value. Otherwise, no ports are bound. Default: - either the selector ports, or none.
        :param selector: Which pods should the service select and route to. You can pass one of the following: - An instance of ``Pod`` or any workload resource (e.g ``Deployment``, ``StatefulSet``, ...) - Pods selected by the ``Pods.select`` function. Note that in this case only labels can be specified. Default: - unset, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify.
        :param type: Determines how the Service is exposed. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types Default: ServiceType.ClusterIP
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9a84f91ae7740ede6e1dc46d82adb689cc60e7e363fa461d8c91a1455137eba9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceProps(
            cluster_ip=cluster_ip,
            external_i_ps=external_i_ps,
            external_name=external_name,
            load_balancer_source_ranges=load_balancer_source_ranges,
            ports=ports,
            selector=selector,
            type=type,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="bind")
    def bind(
        self,
        port: jsii.Number,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Configure a port the service will bind to.

        This method can be called multiple times.

        :param port: The port definition.
        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7a78807f502284a3ca96df4b7f53e78011c2f6a2a42ef049ba33f8c3c6ed810c)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        options = ServiceBindOptions(
            name=name, node_port=node_port, protocol=protocol, target_port=target_port
        )

        return typing.cast(None, jsii.invoke(self, "bind", [port, options]))

    @jsii.member(jsii_name="exposeViaIngress")
    def expose_via_ingress(
        self,
        path: builtins.str,
        *,
        ingress: typing.Optional["Ingress"] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> "Ingress":
        '''Expose a service via an ingress using the specified path.

        :param path: The path to expose the service under.
        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX

        :return: The ``Ingress`` resource that was used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7f00359d1a27bf562ea3633ac9da6067f84607bf075a57f9ac520be76d4f8e5)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = ExposeServiceViaIngressOptions(ingress=ingress, path_type=path_type)

        return typing.cast("Ingress", jsii.invoke(self, "exposeViaIngress", [path, options]))

    @jsii.member(jsii_name="select")
    def select(self, selector: IPodSelector) -> None:
        '''Require this service to select pods matching the selector.

        Note that invoking this method multiple times acts as an AND operator
        on the resulting labels.

        :param selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__830a447755940ecea0240f1b5ca19e71379558631aa6d4a2237f86625a4ea83f)
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        return typing.cast(None, jsii.invoke(self, "select", [selector]))

    @jsii.member(jsii_name="selectLabel")
    def select_label(self, key: builtins.str, value: builtins.str) -> None:
        '''Require this service to select pods with this label.

        Note that invoking this method multiple times acts as an AND operator
        on the resulting labels.

        :param key: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88a4c86f5fd7107f7f18b7790352616a886cac0a0e4b95cd08864f1ecf9b073d)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "selectLabel", [key, value]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="port")
    def port(self) -> jsii.Number:
        '''Return the first port of the service.'''
        return typing.cast(jsii.Number, jsii.get(self, "port"))

    @builtins.property
    @jsii.member(jsii_name="ports")
    def ports(self) -> typing.List["ServicePort"]:
        '''Ports for this service.

        Use ``bind()`` to bind additional service ports.
        '''
        return typing.cast(typing.List["ServicePort"], jsii.get(self, "ports"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> "ServiceType":
        '''Determines how the Service is exposed.'''
        return typing.cast("ServiceType", jsii.get(self, "type"))

    @builtins.property
    @jsii.member(jsii_name="clusterIP")
    def cluster_ip(self) -> typing.Optional[builtins.str]:
        '''The IP address of the service and is usually assigned randomly by the master.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "clusterIP"))

    @builtins.property
    @jsii.member(jsii_name="externalName")
    def external_name(self) -> typing.Optional[builtins.str]:
        '''The externalName to be used for EXTERNAL_NAME types.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "externalName"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ServiceAccountProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "automount_token": "automountToken",
        "secrets": "secrets",
    },
)
class ServiceAccountProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_token: typing.Optional[builtins.bool] = None,
        secrets: typing.Optional[typing.Sequence[ISecret]] = None,
    ) -> None:
        '''Properties for initialization of ``ServiceAccount``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_token: Indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level. Default: false
        :param secrets: List of secrets allowed to be used by pods running using this ServiceAccount.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a26d772435c12f686dcce3744905947b166f17b6a6fd2561bbab7178dd1d42d)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_token", value=automount_token, expected_type=type_hints["automount_token"])
            check_type(argname="argument secrets", value=secrets, expected_type=type_hints["secrets"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_token is not None:
            self._values["automount_token"] = automount_token
        if secrets is not None:
            self._values["secrets"] = secrets

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether pods running as this service account should have an API token automatically mounted.

        Can be overridden at the pod level.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def secrets(self) -> typing.Optional[typing.List[ISecret]]:
        '''List of secrets allowed to be used by pods running using this ServiceAccount.

        :see: https://kubernetes.io/docs/concepts/configuration/secret
        '''
        result = self._values.get("secrets")
        return typing.cast(typing.Optional[typing.List[ISecret]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceAccountProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ServiceAccountTokenSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.ServiceAccountTokenSecret",
):
    '''Create a secret for a service account token.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#service-account-token-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        service_account: "IServiceAccount",
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param service_account: The service account to store a secret for.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ba241e9c297482e0d95c53108857a5ea92b84fdf36fe8bc061cf870c5245a4be)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceAccountTokenSecretProps(
            service_account=service_account, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ServiceBindOptions",
    jsii_struct_bases=[],
    name_mapping={
        "name": "name",
        "node_port": "nodePort",
        "protocol": "protocol",
        "target_port": "targetPort",
    },
)
class ServiceBindOptions:
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``Service.bind``.

        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22dd453b250e151cdc52956889cdc15a32926e7b182dc3b5039588df67581c6a)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_port", value=node_port, expected_type=type_hints["node_port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument target_port", value=target_port, expected_type=type_hints["target_port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if node_port is not None:
            self._values["node_port"] = node_port
        if protocol is not None:
            self._values["protocol"] = protocol
        if target_port is not None:
            self._values["target_port"] = target_port

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port within the service.

        This must be a DNS_LABEL. All
        ports within a ServiceSpec must have unique names. This maps to the 'Name'
        field in EndpointPort objects. Optional if only one ServicePort is defined
        on this service.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_port(self) -> typing.Optional[jsii.Number]:
        '''The port on each node on which this service is exposed when type=NodePort or LoadBalancer.

        Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will
        fail. Default is to auto-allocate a port if the ServiceType of this Service
        requires one.

        :default: - auto-allocate a port if the ServiceType of this Service requires one.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        '''
        result = self._values.get("node_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[Protocol]:
        '''The IP protocol for this port.

        Supports "TCP", "UDP", and "SCTP". Default is TCP.

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[Protocol], result)

    @builtins.property
    def target_port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will redirect to.

        :default: - The value of ``port`` will be used.
        '''
        result = self._values.get("target_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceBindOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ServiceIngressBackendOptions",
    jsii_struct_bases=[],
    name_mapping={"port": "port"},
)
class ServiceIngressBackendOptions:
    def __init__(self, *, port: typing.Optional[jsii.Number] = None) -> None:
        '''Options for setting up backends for ingress rules.

        :param port: The port to use to access the service. - This option will fail if the service does not expose any ports. - If the service exposes multiple ports, this option must be specified. - If the service exposes a single port, this option is optional and if specified, it must be the same port exposed by the service. Default: - if the service exposes a single port, this port will be used.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b85e1dbcb13818db5da8788b9c75b8ea70ced9e2a4ddec129f1ba6552d5a8597)
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The port to use to access the service.

        - This option will fail if the service does not expose any ports.
        - If the service exposes multiple ports, this option must be specified.
        - If the service exposes a single port, this option is optional and if
          specified, it must be the same port exposed by the service.

        :default: - if the service exposes a single port, this port will be used.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceIngressBackendOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ServicePort",
    jsii_struct_bases=[ServiceBindOptions],
    name_mapping={
        "name": "name",
        "node_port": "nodePort",
        "protocol": "protocol",
        "target_port": "targetPort",
        "port": "port",
    },
)
class ServicePort(ServiceBindOptions):
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
        port: jsii.Number,
    ) -> None:
        '''Definition of a service port.

        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        :param port: The port number the service will bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2eea3e393e97b14ad32c98560b91c804b7be6a99a73e452591c8437406398682)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_port", value=node_port, expected_type=type_hints["node_port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument target_port", value=target_port, expected_type=type_hints["target_port"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "port": port,
        }
        if name is not None:
            self._values["name"] = name
        if node_port is not None:
            self._values["node_port"] = node_port
        if protocol is not None:
            self._values["protocol"] = protocol
        if target_port is not None:
            self._values["target_port"] = target_port

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port within the service.

        This must be a DNS_LABEL. All
        ports within a ServiceSpec must have unique names. This maps to the 'Name'
        field in EndpointPort objects. Optional if only one ServicePort is defined
        on this service.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_port(self) -> typing.Optional[jsii.Number]:
        '''The port on each node on which this service is exposed when type=NodePort or LoadBalancer.

        Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will
        fail. Default is to auto-allocate a port if the ServiceType of this Service
        requires one.

        :default: - auto-allocate a port if the ServiceType of this Service requires one.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        '''
        result = self._values.get("node_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[Protocol]:
        '''The IP protocol for this port.

        Supports "TCP", "UDP", and "SCTP". Default is TCP.

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[Protocol], result)

    @builtins.property
    def target_port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will redirect to.

        :default: - The value of ``port`` will be used.
        '''
        result = self._values.get("target_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port(self) -> jsii.Number:
        '''The port number the service will bind to.'''
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServicePort(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ServiceProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "cluster_ip": "clusterIP",
        "external_i_ps": "externalIPs",
        "external_name": "externalName",
        "load_balancer_source_ranges": "loadBalancerSourceRanges",
        "ports": "ports",
        "selector": "selector",
        "type": "type",
    },
)
class ServiceProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        cluster_ip: typing.Optional[builtins.str] = None,
        external_i_ps: typing.Optional[typing.Sequence[builtins.str]] = None,
        external_name: typing.Optional[builtins.str] = None,
        load_balancer_source_ranges: typing.Optional[typing.Sequence[builtins.str]] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        selector: typing.Optional[IPodSelector] = None,
        type: typing.Optional["ServiceType"] = None,
    ) -> None:
        '''Properties for ``Service``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param cluster_ip: The IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are "None", empty string (""), or a valid IP address. "None" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. Default: - Automatically assigned.
        :param external_i_ps: A list of IP addresses for which nodes in the cluster will also accept traffic for this service. These IPs are not managed by Kubernetes. The user is responsible for ensuring that traffic arrives at a node with this IP. A common example is external load-balancers that are not part of the Kubernetes system. Default: - No external IPs.
        :param external_name: The externalName to be used when ServiceType.EXTERNAL_NAME is set. Default: - No external name.
        :param load_balancer_source_ranges: A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs. More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        :param ports: The ports this service binds to. If the selector of the service is a managed pod / workload, its ports will are automatically extracted and used as the default value. Otherwise, no ports are bound. Default: - either the selector ports, or none.
        :param selector: Which pods should the service select and route to. You can pass one of the following: - An instance of ``Pod`` or any workload resource (e.g ``Deployment``, ``StatefulSet``, ...) - Pods selected by the ``Pods.select`` function. Note that in this case only labels can be specified. Default: - unset, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify.
        :param type: Determines how the Service is exposed. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types Default: ServiceType.ClusterIP
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ef8a59fbb2e778efa4631ae85fbe9ed44ce53f8970806077422685985592c484)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument cluster_ip", value=cluster_ip, expected_type=type_hints["cluster_ip"])
            check_type(argname="argument external_i_ps", value=external_i_ps, expected_type=type_hints["external_i_ps"])
            check_type(argname="argument external_name", value=external_name, expected_type=type_hints["external_name"])
            check_type(argname="argument load_balancer_source_ranges", value=load_balancer_source_ranges, expected_type=type_hints["load_balancer_source_ranges"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if cluster_ip is not None:
            self._values["cluster_ip"] = cluster_ip
        if external_i_ps is not None:
            self._values["external_i_ps"] = external_i_ps
        if external_name is not None:
            self._values["external_name"] = external_name
        if load_balancer_source_ranges is not None:
            self._values["load_balancer_source_ranges"] = load_balancer_source_ranges
        if ports is not None:
            self._values["ports"] = ports
        if selector is not None:
            self._values["selector"] = selector
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def cluster_ip(self) -> typing.Optional[builtins.str]:
        '''The IP address of the service and is usually assigned randomly by the master.

        If an address is specified manually and is not in use by others, it
        will be allocated to the service; otherwise, creation of the service will
        fail. This field can not be changed through updates. Valid values are
        "None", empty string (""), or a valid IP address. "None" can be specified
        for headless services when proxying is not required. Only applies to types
        ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName.

        :default: - Automatically assigned.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
        '''
        result = self._values.get("cluster_ip")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def external_i_ps(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of IP addresses for which nodes in the cluster will also accept traffic for this service.

        These IPs are not managed by Kubernetes. The user
        is responsible for ensuring that traffic arrives at a node with this IP. A
        common example is external load-balancers that are not part of the
        Kubernetes system.

        :default: - No external IPs.
        '''
        result = self._values.get("external_i_ps")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def external_name(self) -> typing.Optional[builtins.str]:
        '''The externalName to be used when ServiceType.EXTERNAL_NAME is set.

        :default: - No external name.
        '''
        result = self._values.get("external_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def load_balancer_source_ranges(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of CIDR IP addresses, if specified and supported by the platform, will restrict traffic through the cloud-provider load-balancer to the specified client IPs.

        More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
        '''
        result = self._values.get("load_balancer_source_ranges")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ServicePort]]:
        '''The ports this service binds to.

        If the selector of the service is a managed pod / workload,
        its ports will are automatically extracted and used as the default value.
        Otherwise, no ports are bound.

        :default: - either the selector ports, or none.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ServicePort]], result)

    @builtins.property
    def selector(self) -> typing.Optional[IPodSelector]:
        '''Which pods should the service select and route to.

        You can pass one of the following:

        - An instance of ``Pod`` or any workload resource (e.g ``Deployment``, ``StatefulSet``, ...)
        - Pods selected by the ``Pods.select`` function. Note that in this case only labels can be specified.

        :default:

        - unset, the service is assumed to have an external process managing
        its endpoints, which Kubernetes will not modify.

        Example::

            // select the pods of a specific deployment
            const backend = new kplus.Deployment(this, 'Backend', ...);
            new kplus.Service(this, 'Service', { selector: backend });
            
            // select all pods labeled with the `tier=backend` label
            const backend = kplus.Pod.labeled({ tier: 'backend' });
            new kplus.Service(this, 'Service', { selector: backend });
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional[IPodSelector], result)

    @builtins.property
    def type(self) -> typing.Optional["ServiceType"]:
        '''Determines how the Service is exposed.

        More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types

        :default: ServiceType.ClusterIP
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional["ServiceType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.ServiceType")
class ServiceType(enum.Enum):
    '''For some parts of your application (for example, frontends) you may want to expose a Service onto an external IP address, that's outside of your cluster.

    Kubernetes ServiceTypes allow you to specify what kind of Service you want.
    The default is ClusterIP.
    '''

    CLUSTER_IP = "CLUSTER_IP"
    '''Exposes the Service on a cluster-internal IP.

    Choosing this value makes the Service only reachable from within the cluster.
    This is the default ServiceType
    '''
    NODE_PORT = "NODE_PORT"
    '''Exposes the Service on each Node's IP at a static port (the NodePort).

    A ClusterIP Service, to which the NodePort Service routes, is automatically created.
    You'll be able to contact the NodePort Service, from outside the cluster,
    by requesting :.
    '''
    LOAD_BALANCER = "LOAD_BALANCER"
    '''Exposes the Service externally using a cloud provider's load balancer.

    NodePort and ClusterIP Services, to which the external load balancer routes,
    are automatically created.
    '''
    EXTERNAL_NAME = "EXTERNAL_NAME"
    '''Maps the Service to the contents of the externalName field (e.g. foo.bar.example.com), by returning a CNAME record with its value. No proxying of any kind is set up.

    .. epigraph::

       Note: You need either kube-dns version 1.7 or CoreDNS version 0.0.8 or higher to use the ExternalName type.
    '''


class SshAuthSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.SshAuthSecret",
):
    '''Create a secret for ssh authentication.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#ssh-authentication-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        ssh_private_key: builtins.str,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param ssh_private_key: The SSH private key to use.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a2b4eace00be4cdea5646b6fa3ebc4885f30655f0cedcc6cbf5631a17cba863a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = SshAuthSecretProps(
            ssh_private_key=ssh_private_key, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


class StatefulSetUpdateStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.StatefulSetUpdateStrategy",
):
    '''StatefulSet update strategies.'''

    @jsii.member(jsii_name="onDelete")
    @builtins.classmethod
    def on_delete(cls) -> "StatefulSetUpdateStrategy":
        '''The controller will not automatically update the Pods in a StatefulSet.

        Users must manually delete Pods to cause the controller to create new Pods
        that reflect modifications.
        '''
        return typing.cast("StatefulSetUpdateStrategy", jsii.sinvoke(cls, "onDelete", []))

    @jsii.member(jsii_name="rollingUpdate")
    @builtins.classmethod
    def rolling_update(
        cls,
        *,
        partition: typing.Optional[jsii.Number] = None,
    ) -> "StatefulSetUpdateStrategy":
        '''The controller will delete and recreate each Pod in the StatefulSet.

        It will proceed in the same order as Pod termination (from the largest ordinal to the smallest),
        updating each Pod one at a time. The Kubernetes control plane waits until an updated
        Pod is Running and Ready prior to updating its predecessor.

        :param partition: If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version. If the partition is greater than replicas, updates to the pod template will not be propagated to Pods. In most cases you will not need to use a partition, but they are useful if you want to stage an update, roll out a canary, or perform a phased roll out. Default: 0
        '''
        options = StatefulSetUpdateStrategyRollingUpdateOptions(partition=partition)

        return typing.cast("StatefulSetUpdateStrategy", jsii.sinvoke(cls, "rollingUpdate", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.StatefulSetUpdateStrategyRollingUpdateOptions",
    jsii_struct_bases=[],
    name_mapping={"partition": "partition"},
)
class StatefulSetUpdateStrategyRollingUpdateOptions:
    def __init__(self, *, partition: typing.Optional[jsii.Number] = None) -> None:
        '''Options for ``StatefulSetUpdateStrategy.rollingUpdate``.

        :param partition: If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version. If the partition is greater than replicas, updates to the pod template will not be propagated to Pods. In most cases you will not need to use a partition, but they are useful if you want to stage an update, roll out a canary, or perform a phased roll out. Default: 0
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__79e8ab74f4cd5813bfcbe4c035a585f40510038c847326a0bf5148261d352276)
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if partition is not None:
            self._values["partition"] = partition

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version.

        If the partition is greater than replicas, updates to the pod template will not be propagated to Pods.
        In most cases you will not need to use a partition, but they are useful if you want to stage an
        update, roll out a canary, or perform a phased roll out.

        :default: 0

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/statefulset/#partitions
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "StatefulSetUpdateStrategyRollingUpdateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.SubjectConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "kind": "kind",
        "name": "name",
        "api_group": "apiGroup",
        "namespace": "namespace",
    },
)
class SubjectConfiguration:
    def __init__(
        self,
        *,
        kind: builtins.str,
        name: builtins.str,
        api_group: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Subject contains a reference to the object or user identities a role binding applies to.

        This can either hold a direct API object reference, or a value
        for non-objects such as user and group names.

        :param kind: Kind of object being referenced. Values defined by this API group are "User", "Group", and "ServiceAccount". If the Authorizer does not recognized the kind value, the Authorizer should report an error.
        :param name: Name of the object being referenced.
        :param api_group: APIGroup holds the API group of the referenced subject. Defaults to "" for ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User and Group subjects.
        :param namespace: Namespace of the referenced object. If the object kind is non-namespace, such as "User" or "Group", and this value is not empty the Authorizer should report an error.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d477e4fa5eb1539a369e01b59685c2e08dbfaecba27e04c2cb13264e62668051)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument api_group", value=api_group, expected_type=type_hints["api_group"])
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "kind": kind,
            "name": name,
        }
        if api_group is not None:
            self._values["api_group"] = api_group
        if namespace is not None:
            self._values["namespace"] = namespace

    @builtins.property
    def kind(self) -> builtins.str:
        '''Kind of object being referenced.

        Values defined by this API group are
        "User", "Group", and "ServiceAccount". If the Authorizer does not
        recognized the kind value, the Authorizer should report an error.
        '''
        result = self._values.get("kind")
        assert result is not None, "Required property 'kind' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of the object being referenced.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def api_group(self) -> typing.Optional[builtins.str]:
        '''APIGroup holds the API group of the referenced subject.

        Defaults to "" for
        ServiceAccount subjects. Defaults to "rbac.authorization.k8s.io" for User
        and Group subjects.
        '''
        result = self._values.get("api_group")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''Namespace of the referenced object.

        If the object kind is non-namespace,
        such as "User" or "Group", and this value is not empty the Authorizer
        should report an error.
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SubjectConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.Sysctl",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class Sysctl:
    def __init__(self, *, name: builtins.str, value: builtins.str) -> None:
        '''Sysctl defines a kernel parameter to be set.

        :param name: Name of a property to set.
        :param value: Value of a property to set.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__03b86490dbe6749f0389413aa71c89af16a90832de70104af205ce131d667548)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> builtins.str:
        '''Name of a property to set.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        '''Value of a property to set.'''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Sysctl(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk8s-plus-23.TaintEffect")
class TaintEffect(enum.Enum):
    '''Taint effects.'''

    NO_SCHEDULE = "NO_SCHEDULE"
    '''This means that no pod will be able to schedule onto the node unless it has a matching toleration.'''
    PREFER_NO_SCHEDULE = "PREFER_NO_SCHEDULE"
    '''This is a "preference" or "soft" version of ``NO_SCHEDULE`` -- the system will try to avoid placing a pod that does not tolerate the taint on the node, but it is not required.'''
    NO_EXECUTE = "NO_EXECUTE"
    '''This affects pods that are already running on the node as follows:.

    - Pods that do not tolerate the taint are evicted immediately.
    - Pods that tolerate the taint without specifying ``duration`` remain bound forever.
    - Pods that tolerate the taint with a specified ``duration`` remain bound for
      the specified amount of time.
    '''


class TaintedNode(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.TaintedNode"):
    '''A node that is matched by taint selectors.'''

    def __init__(self, taint_selector: typing.Sequence[NodeTaintQuery]) -> None:
        '''
        :param taint_selector: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__534034cf5a6197b9e6882ceb011a40169daa4ea926727227eb709992eb8cf27f)
            check_type(argname="argument taint_selector", value=taint_selector, expected_type=type_hints["taint_selector"])
        jsii.create(self.__class__, self, [taint_selector])

    @builtins.property
    @jsii.member(jsii_name="taintSelector")
    def taint_selector(self) -> typing.List[NodeTaintQuery]:
        return typing.cast(typing.List[NodeTaintQuery], jsii.get(self, "taintSelector"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.TcpSocketProbeOptions",
    jsii_struct_bases=[ProbeOptions],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
        "host": "host",
        "port": "port",
    },
)
class TcpSocketProbeOptions(ProbeOptions):
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        host: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``Probe.fromTcpSocket()``.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        :param host: The host name to connect to on the container. Default: - defaults to the pod IP
        :param port: The TCP port to connect to on the container. Default: - defaults to ``container.port``.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1da4fbd6bd2e635875b92b58369ee51cfc3f0b929d9b08ae7fb9696ad7c3141c)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds
        if host is not None:
            self._values["host"] = host
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def host(self) -> typing.Optional[builtins.str]:
        '''The host name to connect to on the container.

        :default: - defaults to the pod IP
        '''
        result = self._values.get("host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to connect to on the container.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TcpSocketProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TlsSecret(Secret, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.TlsSecret"):
    '''Create a secret for storing a TLS certificate and its associated key.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        tls_cert: builtins.str,
        tls_key: builtins.str,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param tls_cert: The TLS cert.
        :param tls_key: The TLS key.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7638ba68d6f7d6f12616f9c8b82c1414221a2d8cc164e7c3b8795ab261b92f66)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = TlsSecretProps(
            tls_cert=tls_cert, tls_key=tls_key, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


class Topology(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Topology"):
    '''Available topology domains.'''

    @jsii.member(jsii_name="custom")
    @builtins.classmethod
    def custom(cls, key: builtins.str) -> "Topology":
        '''Custom key for the node label that the system uses to denote the topology domain.

        :param key: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d708380df25aad397654ef02aea3d52fa7882629c617c91725daae50b9077549)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast("Topology", jsii.sinvoke(cls, "custom", [key]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="HOSTNAME")
    def HOSTNAME(cls) -> "Topology":
        '''A hostname represents a single node in the cluster.

        :see: https://kubernetes.io/docs/reference/labels-annotations-taints/#kubernetesiohostname
        '''
        return typing.cast("Topology", jsii.sget(cls, "HOSTNAME"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="REGION")
    def REGION(cls) -> "Topology":
        '''A region represents a larger domain, made up of one or more zones.

        It is uncommon
        for Kubernetes clusters to span multiple regions. While the exact definition of a
        zone or region is left to infrastructure implementations, common properties of a region
        include higher network latency between them than within them, non-zero cost for network
        traffic between them, and failure independence from other zones or regions.

        For example, nodes within a region might share power infrastructure (e.g. a UPS or generator), but
        nodes in different regions typically would not.

        :see: https://kubernetes.io/docs/reference/labels-annotations-taints/#topologykubernetesioregion
        '''
        return typing.cast("Topology", jsii.sget(cls, "REGION"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ZONE")
    def ZONE(cls) -> "Topology":
        '''A zone represents a logical failure domain.

        It is common for Kubernetes clusters to
        span multiple zones for increased availability. While the exact definition of a zone is
        left to infrastructure implementations, common properties of a zone include very low
        network latency within a zone, no-cost network traffic within a zone, and failure
        independence from other zones. For example, nodes within a zone might share a network
        switch, but nodes in different zones should not.

        :see: https://kubernetes.io/docs/reference/labels-annotations-taints/#topologykubernetesiozone
        '''
        return typing.cast("Topology", jsii.sget(cls, "ZONE"))

    @builtins.property
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "key"))


@jsii.implements(ISubject)
class User(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.User",
):
    '''Represents a user.'''

    @jsii.member(jsii_name="fromName")
    @builtins.classmethod
    def from_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> "User":
        '''Reference a user in the cluster by name.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58bfc631990b5e8692c9ea0996ded5c289e3b330044bbf5ce6073b7a6300c4ae)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast("User", jsii.sinvoke(cls, "fromName", [scope, id, name]))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "apiGroup"))


@jsii.implements(IStorage)
class Volume(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.Volume",
):
    '''Volume represents a named volume in a pod that may be accessed by any container in the pod.

    Docker also has a concept of volumes, though it is somewhat looser and less
    managed. In Docker, a volume is simply a directory on disk or in another
    Container. Lifetimes are not managed and until very recently there were only
    local-disk-backed volumes. Docker now provides volume drivers, but the
    functionality is very limited for now (e.g. as of Docker 1.7 only one volume
    driver is allowed per Container and there is no way to pass parameters to
    volumes).

    A Kubernetes volume, on the other hand, has an explicit lifetime - the same
    as the Pod that encloses it. Consequently, a volume outlives any Containers
    that run within the Pod, and data is preserved across Container restarts. Of
    course, when a Pod ceases to exist, the volume will cease to exist, too.
    Perhaps more importantly than this, Kubernetes supports many types of
    volumes, and a Pod can use any number of them simultaneously.

    At its core, a volume is just a directory, possibly with some data in it,
    which is accessible to the Containers in a Pod. How that directory comes to
    be, the medium that backs it, and the contents of it are determined by the
    particular volume type used.

    To use a volume, a Pod specifies what volumes to provide for the Pod (the
    .spec.volumes field) and where to mount those into Containers (the
    .spec.containers[*].volumeMounts field).

    A process in a container sees a filesystem view composed from their Docker
    image and volumes. The Docker image is at the root of the filesystem
    hierarchy, and any volumes are mounted at the specified paths within the
    image. Volumes can not mount onto other volumes
    '''

    @jsii.member(jsii_name="fromAwsElasticBlockStore")
    @builtins.classmethod
    def from_aws_elastic_block_store(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        volume_id: builtins.str,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Mounts an Amazon Web Services (AWS) EBS volume into your pod.

        Unlike emptyDir, which is erased when a pod is removed, the contents of an EBS volume are
        persisted and the volume is unmounted. This means that an EBS volume can be pre-populated with data,
        and that data can be shared between pods.

        There are some restrictions when using an awsElasticBlockStore volume:

        - the nodes on which pods are running must be AWS EC2 instances.
        - those instances need to be in the same region and availability zone as the EBS volume.
        - EBS only supports a single EC2 instance mounting a volume.

        :param scope: -
        :param id: -
        :param volume_id: -
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__28f4652b24144d84ef06595d1ddc682700ec94633dfcfe30155a3b359fd02367)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
        options = AwsElasticBlockStoreVolumeOptions(
            fs_type=fs_type, name=name, partition=partition, read_only=read_only
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromAwsElasticBlockStore", [scope, id, volume_id, options]))

    @jsii.member(jsii_name="fromAzureDisk")
    @builtins.classmethod
    def from_azure_disk(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        *,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Mounts a Microsoft Azure Data Disk into a pod.

        :param scope: -
        :param id: -
        :param disk_name: -
        :param disk_uri: -
        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param name: The volume name. Default: - auto-generated
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c5a79b46f20f1251dc931bf16c23506ea4c3749d8d27282d7f99e6435dee0212)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument disk_name", value=disk_name, expected_type=type_hints["disk_name"])
            check_type(argname="argument disk_uri", value=disk_uri, expected_type=type_hints["disk_uri"])
        options = AzureDiskVolumeOptions(
            caching_mode=caching_mode,
            fs_type=fs_type,
            kind=kind,
            name=name,
            read_only=read_only,
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromAzureDisk", [scope, id, disk_name, disk_uri, options]))

    @jsii.member(jsii_name="fromConfigMap")
    @builtins.classmethod
    def from_config_map(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        config_map: "IConfigMap",
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union[PathMapping, typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Populate the volume from a ConfigMap.

        The configMap resource provides a way to inject configuration data into
        Pods. The data stored in a ConfigMap object can be referenced in a volume
        of type configMap and then consumed by containerized applications running
        in a Pod.

        When referencing a configMap object, you can simply provide its name in the
        volume to reference it. You can also customize the path to use for a
        specific entry in the ConfigMap.

        :param scope: -
        :param id: -
        :param config_map: The config map to use to populate the volume.
        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the ConfigMap or its keys must be defined. Default: - undocumented
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4836e3d16a177be43def8d9f0eb1946d5daeca32d058a49af86be2295f996d07)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument config_map", value=config_map, expected_type=type_hints["config_map"])
        options = ConfigMapVolumeOptions(
            default_mode=default_mode, items=items, name=name, optional=optional
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromConfigMap", [scope, id, config_map, options]))

    @jsii.member(jsii_name="fromEmptyDir")
    @builtins.classmethod
    def from_empty_dir(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        medium: typing.Optional[EmptyDirMedium] = None,
        size_limit: typing.Optional[_cdk8s_d3d9af27.Size] = None,
    ) -> "Volume":
        '''An emptyDir volume is first created when a Pod is assigned to a Node, and exists as long as that Pod is running on that node.

        As the name says, it is
        initially empty. Containers in the Pod can all read and write the same
        files in the emptyDir volume, though that volume can be mounted at the same
        or different paths in each Container. When a Pod is removed from a node for
        any reason, the data in the emptyDir is deleted forever.

        :param scope: -
        :param id: -
        :param name: -
        :param medium: By default, emptyDir volumes are stored on whatever medium is backing the node - that might be disk or SSD or network storage, depending on your environment. However, you can set the emptyDir.medium field to ``EmptyDirMedium.MEMORY`` to tell Kubernetes to mount a tmpfs (RAM-backed filesystem) for you instead. While tmpfs is very fast, be aware that unlike disks, tmpfs is cleared on node reboot and any files you write will count against your Container's memory limit. Default: EmptyDirMedium.DEFAULT
        :param size_limit: Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. Default: - limit is undefined

        :see: http://kubernetes.io/docs/user-guide/volumes#emptydir
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7139f2d7f47cea65c31cae29c756b3e0cf87d4d4e3272f86fdeb6af3d2ae71cb)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = EmptyDirVolumeOptions(medium=medium, size_limit=size_limit)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromEmptyDir", [scope, id, name, options]))

    @jsii.member(jsii_name="fromGcePersistentDisk")
    @builtins.classmethod
    def from_gce_persistent_disk(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        pd_name: builtins.str,
        *,
        fs_type: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Mounts a Google Compute Engine (GCE) persistent disk (PD) into your Pod.

        Unlike emptyDir, which is erased when a pod is removed, the contents of a PD are
        preserved and the volume is merely unmounted. This means that a PD can be pre-populated
        with data, and that data can be shared between pods.

        There are some restrictions when using a gcePersistentDisk:

        - the nodes on which Pods are running must be GCE VMs
        - those VMs need to be in the same GCE project and zone as the persistent disk

        :param scope: -
        :param id: -
        :param pd_name: -
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param name: The volume name. Default: - auto-generated
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__74bc3278a2aa955db6175f137916d9816864452487b463e3b9834510e76f7597)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument pd_name", value=pd_name, expected_type=type_hints["pd_name"])
        options = GCEPersistentDiskVolumeOptions(
            fs_type=fs_type, name=name, partition=partition, read_only=read_only
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromGcePersistentDisk", [scope, id, pd_name, options]))

    @jsii.member(jsii_name="fromHostPath")
    @builtins.classmethod
    def from_host_path(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        path: builtins.str,
        type: typing.Optional[HostPathVolumeType] = None,
    ) -> "Volume":
        '''Used to mount a file or directory from the host node's filesystem into a Pod.

        This is not something that most Pods will need, but it offers a powerful
        escape hatch for some applications.

        :param scope: -
        :param id: -
        :param name: -
        :param path: The path of the directory on the host.
        :param type: The expected type of the path found on the host. Default: HostPathVolumeType.DEFAULT

        :see: https://kubernetes.io/docs/concepts/storage/volumes/#hostpath
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__047cacb0f93a0dea8a5168b7e17c78978a36d6e3a41848af8ee4b7f9cfddd037)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = HostPathVolumeOptions(path=path, type=type)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromHostPath", [scope, id, name, options]))

    @jsii.member(jsii_name="fromPersistentVolumeClaim")
    @builtins.classmethod
    def from_persistent_volume_claim(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        claim: "IPersistentVolumeClaim",
        *,
        name: typing.Optional[builtins.str] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Used to mount a PersistentVolume into a Pod.

        PersistentVolumeClaims are a way for users to "claim" durable storage (such as a GCE PersistentDisk or an iSCSI volume)
        without knowing the details of the particular cloud environment.

        :param scope: -
        :param id: -
        :param claim: -
        :param name: The volume name. Default: - Derived from the PVC name.
        :param read_only: Will force the ReadOnly setting in VolumeMounts. Default: false

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__43c24412831e0acd07040840090998f029e3f19e423eef5a7731fe2227a956e8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
        options = PersistentVolumeClaimVolumeOptions(name=name, read_only=read_only)

        return typing.cast("Volume", jsii.sinvoke(cls, "fromPersistentVolumeClaim", [scope, id, claim, options]))

    @jsii.member(jsii_name="fromSecret")
    @builtins.classmethod
    def from_secret(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        secr: ISecret,
        *,
        default_mode: typing.Optional[jsii.Number] = None,
        items: typing.Optional[typing.Mapping[builtins.str, typing.Union[PathMapping, typing.Dict[builtins.str, typing.Any]]]] = None,
        name: typing.Optional[builtins.str] = None,
        optional: typing.Optional[builtins.bool] = None,
    ) -> "Volume":
        '''Populate the volume from a Secret.

        A secret volume is used to pass sensitive information, such as passwords, to Pods.
        You can store secrets in the Kubernetes API and mount them as files for use by pods
        without coupling to Kubernetes directly.

        secret volumes are backed by tmpfs (a RAM-backed filesystem)
        so they are never written to non-volatile storage.

        :param scope: -
        :param id: -
        :param secr: The secret to use to populate the volume.
        :param default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. Default: 644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param items: If unspecified, each key-value pair in the Data field of the referenced secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'. Default: - no mapping
        :param name: The volume name. Default: - auto-generated
        :param optional: Specify whether the secret or its keys must be defined. Default: - undocumented

        :see: https://kubernetes.io/docs/concepts/storage/volumes/#secret
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__561223d7b33ae64c93d0f6f2be77f3df5323f0bdb5b37f80c4ceecae2b791e63)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument secr", value=secr, expected_type=type_hints["secr"])
        options = SecretVolumeOptions(
            default_mode=default_mode, items=items, name=name, optional=optional
        )

        return typing.cast("Volume", jsii.sinvoke(cls, "fromSecret", [scope, id, secr, options]))

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> "Volume":
        '''Convert the piece of storage into a concrete volume.'''
        return typing.cast("Volume", jsii.invoke(self, "asVolume", []))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.VolumeMount",
    jsii_struct_bases=[MountOptions],
    name_mapping={
        "propagation": "propagation",
        "read_only": "readOnly",
        "sub_path": "subPath",
        "sub_path_expr": "subPathExpr",
        "path": "path",
        "volume": "volume",
    },
)
class VolumeMount(MountOptions):
    def __init__(
        self,
        *,
        propagation: typing.Optional[MountPropagation] = None,
        read_only: typing.Optional[builtins.bool] = None,
        sub_path: typing.Optional[builtins.str] = None,
        sub_path_expr: typing.Optional[builtins.str] = None,
        path: builtins.str,
        volume: Volume,
    ) -> None:
        '''Mount a volume from the pod to the container.

        :param propagation: Determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. Mount propagation allows for sharing volumes mounted by a Container to other Containers in the same Pod, or even to other Pods on the same node. Default: MountPropagation.NONE
        :param read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. Default: false
        :param sub_path: Path within the volume from which the container's volume should be mounted.). Default: "" the volume's root
        :param sub_path_expr: Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). ``subPathExpr`` and ``subPath`` are mutually exclusive. Default: "" volume's root.
        :param path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param volume: The volume to mount.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d36d04bc2b6f92bbe0d1ec9b830c44a8c7e305669098765064c79da80c1bc702)
            check_type(argname="argument propagation", value=propagation, expected_type=type_hints["propagation"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
            check_type(argname="argument sub_path", value=sub_path, expected_type=type_hints["sub_path"])
            check_type(argname="argument sub_path_expr", value=sub_path_expr, expected_type=type_hints["sub_path_expr"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument volume", value=volume, expected_type=type_hints["volume"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
            "volume": volume,
        }
        if propagation is not None:
            self._values["propagation"] = propagation
        if read_only is not None:
            self._values["read_only"] = read_only
        if sub_path is not None:
            self._values["sub_path"] = sub_path
        if sub_path_expr is not None:
            self._values["sub_path_expr"] = sub_path_expr

    @builtins.property
    def propagation(self) -> typing.Optional[MountPropagation]:
        '''Determines how mounts are propagated from the host to container and the other way around.

        When not set, MountPropagationNone is used.

        Mount propagation allows for sharing volumes mounted by a Container to
        other Containers in the same Pod, or even to other Pods on the same node.

        :default: MountPropagation.NONE
        '''
        result = self._values.get("propagation")
        return typing.cast(typing.Optional[MountPropagation], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Mounted read-only if true, read-write otherwise (false or unspecified).

        Defaults to false.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sub_path(self) -> typing.Optional[builtins.str]:
        '''Path within the volume from which the container's volume should be mounted.).

        :default: "" the volume's root
        '''
        result = self._values.get("sub_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sub_path_expr(self) -> typing.Optional[builtins.str]:
        '''Expanded path within the volume from which the container's volume should be mounted.

        Behaves similarly to SubPath but environment variable references
        $(VAR_NAME) are expanded using the container's environment. Defaults to ""
        (volume's root).

        ``subPathExpr`` and ``subPath`` are mutually exclusive.

        :default: "" volume's root.
        '''
        result = self._values.get("sub_path_expr")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path(self) -> builtins.str:
        '''Path within the container at which the volume should be mounted.

        Must not
        contain ':'.
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def volume(self) -> Volume:
        '''The volume to mount.'''
        result = self._values.get("volume")
        assert result is not None, "Required property 'volume' is missing"
        return typing.cast(Volume, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VolumeMount(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class WorkloadScheduling(
    PodScheduling,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.WorkloadScheduling",
):
    '''Controls the pod scheduling strategy of this workload.

    It offers some additional API's on top of the core pod scheduling.
    '''

    def __init__(self, instance: "AbstractPod") -> None:
        '''
        :param instance: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77160bf1593530982be4cc599aabf3b8d412448eac408700a759e07173e02389)
            check_type(argname="argument instance", value=instance, expected_type=type_hints["instance"])
        jsii.create(self.__class__, self, [instance])

    @jsii.member(jsii_name="spread")
    def spread(
        self,
        *,
        topology: typing.Optional[Topology] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Spread the pods in this workload by the topology key.

        A spread is a separation of the pod from itself and is used to
        balance out pod replicas across a given topology.

        :param topology: Which topology to spread on. Default: - Topology.HOSTNAME
        :param weight: Indicates the spread is optional, with this weight score. Default: - no weight. spread is assumed to be required.
        '''
        options = WorkloadSchedulingSpreadOptions(topology=topology, weight=weight)

        return typing.cast(None, jsii.invoke(self, "spread", [options]))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.WorkloadSchedulingSpreadOptions",
    jsii_struct_bases=[],
    name_mapping={"topology": "topology", "weight": "weight"},
)
class WorkloadSchedulingSpreadOptions:
    def __init__(
        self,
        *,
        topology: typing.Optional[Topology] = None,
        weight: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options for ``WorkloadScheduling.spread``.

        :param topology: Which topology to spread on. Default: - Topology.HOSTNAME
        :param weight: Indicates the spread is optional, with this weight score. Default: - no weight. spread is assumed to be required.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22ff85f46d18d84c9b92a826fbaa5eab7b3066da0373808fbae85532c132a4e5)
            check_type(argname="argument topology", value=topology, expected_type=type_hints["topology"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if topology is not None:
            self._values["topology"] = topology
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def topology(self) -> typing.Optional[Topology]:
        '''Which topology to spread on.

        :default: - Topology.HOSTNAME
        '''
        result = self._values.get("topology")
        return typing.cast(typing.Optional[Topology], result)

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        '''Indicates the spread is optional, with this weight score.

        :default: - no weight. spread is assumed to be required.
        '''
        result = self._values.get("weight")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "WorkloadSchedulingSpreadOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IPodSelector, INetworkPolicyPeer, ISubject)
class AbstractPod(
    Resource,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk8s-plus-23.AbstractPod",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional["DockerConfigSecret"] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional["IServiceAccount"] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3fb97dc308ab4631a679a2ebae0475f2d8b0b091271a8178ecef5d2c741a9e28)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AbstractPodProps(
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addContainer")
    def add_container(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence[EnvFrom]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, EnvValue]] = None,
        image_pull_policy: typing.Optional[ImagePullPolicy] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional[Probe] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional[Probe] = None,
        resources: typing.Optional[typing.Union[ContainerResources, typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union[ContainerSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional[Probe] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union[VolumeMount, typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> Container:
        '''
        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        cont = ContainerProps(
            image=image,
            args=args,
            command=command,
            env_from=env_from,
            env_variables=env_variables,
            image_pull_policy=image_pull_policy,
            lifecycle=lifecycle,
            liveness=liveness,
            name=name,
            port=port,
            port_number=port_number,
            ports=ports,
            readiness=readiness,
            resources=resources,
            security_context=security_context,
            startup=startup,
            volume_mounts=volume_mounts,
            working_dir=working_dir,
        )

        return typing.cast(Container, jsii.invoke(self, "addContainer", [cont]))

    @jsii.member(jsii_name="addHostAlias")
    def add_host_alias(
        self,
        *,
        hostnames: typing.Sequence[builtins.str],
        ip: builtins.str,
    ) -> None:
        '''
        :param hostnames: Hostnames for the chosen IP address.
        :param ip: IP address of the host file entry.
        '''
        host_alias = HostAlias(hostnames=hostnames, ip=ip)

        return typing.cast(None, jsii.invoke(self, "addHostAlias", [host_alias]))

    @jsii.member(jsii_name="addInitContainer")
    def add_init_container(
        self,
        *,
        image: builtins.str,
        args: typing.Optional[typing.Sequence[builtins.str]] = None,
        command: typing.Optional[typing.Sequence[builtins.str]] = None,
        env_from: typing.Optional[typing.Sequence[EnvFrom]] = None,
        env_variables: typing.Optional[typing.Mapping[builtins.str, EnvValue]] = None,
        image_pull_policy: typing.Optional[ImagePullPolicy] = None,
        lifecycle: typing.Optional[typing.Union[ContainerLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        liveness: typing.Optional[Probe] = None,
        name: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        port_number: typing.Optional[jsii.Number] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ContainerPort, typing.Dict[builtins.str, typing.Any]]]] = None,
        readiness: typing.Optional[Probe] = None,
        resources: typing.Optional[typing.Union[ContainerResources, typing.Dict[builtins.str, typing.Any]]] = None,
        security_context: typing.Optional[typing.Union[ContainerSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        startup: typing.Optional[Probe] = None,
        volume_mounts: typing.Optional[typing.Sequence[typing.Union[VolumeMount, typing.Dict[builtins.str, typing.Any]]]] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> Container:
        '''
        :param image: Docker image name.
        :param args: Arguments to the entrypoint. The docker image's CMD is used if ``command`` is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. Default: []
        :param command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell Default: - The docker image's ENTRYPOINT.
        :param env_from: List of sources to populate environment variables in the container. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by the ``envVariables`` property with a duplicate key will take precedence. Default: - No sources.
        :param env_variables: Environment variables to set in the container. Default: - No environment variables.
        :param image_pull_policy: Image pull policy for this container. Default: ImagePullPolicy.ALWAYS
        :param lifecycle: Describes actions that the management system should take in response to container lifecycle events.
        :param liveness: Periodic probe of container liveness. Container will be restarted if the probe fails. Default: - no liveness probe is defined
        :param name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated. Default: 'main'
        :param port: 
        :param port_number: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536. This is a convinience property if all you need a single TCP numbered port. In case more advanced configuartion is required, use the ``ports`` property. This port is added to the list of ports mentioned in the ``ports`` property. Default: - Only the ports mentiond in the ``ports`` property are exposed.
        :param ports: List of ports to expose from this container. Default: - Only the port mentioned in the ``portNumber`` property is exposed.
        :param readiness: Determines when the container is ready to serve traffic. Default: - no readiness probe is defined
        :param resources: Compute resources (CPU and memory requests and limits) required by the container. Default: cpu: request: 1000 millis limit: 1500 millis memory: request: 512 mebibytes limit: 2048 mebibytes
        :param security_context: SecurityContext defines the security options the container should be run with. If set, the fields override equivalent fields of the pod's security context. Default: ensureNonRoot: true privileged: false readOnlyRootFilesystem: true allowPrivilegeEscalation: false user: 25000 group: 26000
        :param startup: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully Default: - If a port is provided, then knocks on that port to determine when the container is ready for readiness and liveness probe checks. Otherwise, no startup probe is defined.
        :param volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. Default: - The container runtime's default.
        '''
        cont = ContainerProps(
            image=image,
            args=args,
            command=command,
            env_from=env_from,
            env_variables=env_variables,
            image_pull_policy=image_pull_policy,
            lifecycle=lifecycle,
            liveness=liveness,
            name=name,
            port=port,
            port_number=port_number,
            ports=ports,
            readiness=readiness,
            resources=resources,
            security_context=security_context,
            startup=startup,
            volume_mounts=volume_mounts,
            working_dir=working_dir,
        )

        return typing.cast(Container, jsii.invoke(self, "addInitContainer", [cont]))

    @jsii.member(jsii_name="addVolume")
    def add_volume(self, vol: Volume) -> None:
        '''
        :param vol: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d20d9df39ca5629b6c54538145e201465fddc1b7dbd8fe4c6dafc8a6ad1279de)
            check_type(argname="argument vol", value=vol, expected_type=type_hints["vol"])
        return typing.cast(None, jsii.invoke(self, "addVolume", [vol]))

    @jsii.member(jsii_name="attachContainer")
    def attach_container(self, cont: Container) -> None:
        '''
        :param cont: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__58cface46fdc259b7983768612e9ebaa6f6d0848a3b878e806eee97be64834cd)
            check_type(argname="argument cont", value=cont, expected_type=type_hints["cont"])
        return typing.cast(None, jsii.invoke(self, "attachContainer", [cont]))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> NetworkPolicyPeerConfig:
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast(NetworkPolicyPeerConfig, jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @jsii.member(jsii_name="toPodSelectorConfig")
    def to_pod_selector_config(self) -> PodSelectorConfig:
        '''Return the configuration of this selector.

        :see: IPodSelector.toPodSelectorConfig()
        '''
        return typing.cast(PodSelectorConfig, jsii.invoke(self, "toPodSelectorConfig", []))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="automountServiceAccountToken")
    def automount_service_account_token(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "automountServiceAccountToken"))

    @builtins.property
    @jsii.member(jsii_name="containers")
    def containers(self) -> typing.List[Container]:
        return typing.cast(typing.List[Container], jsii.get(self, "containers"))

    @builtins.property
    @jsii.member(jsii_name="dns")
    def dns(self) -> PodDns:
        return typing.cast(PodDns, jsii.get(self, "dns"))

    @builtins.property
    @jsii.member(jsii_name="hostAliases")
    def host_aliases(self) -> typing.List[HostAlias]:
        return typing.cast(typing.List[HostAlias], jsii.get(self, "hostAliases"))

    @builtins.property
    @jsii.member(jsii_name="initContainers")
    def init_containers(self) -> typing.List[Container]:
        return typing.cast(typing.List[Container], jsii.get(self, "initContainers"))

    @builtins.property
    @jsii.member(jsii_name="isolate")
    def _isolate(self) -> builtins.bool:
        return typing.cast(builtins.bool, jsii.get(self, "isolate"))

    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    @abc.abstractmethod
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        ...

    @builtins.property
    @jsii.member(jsii_name="securityContext")
    def security_context(self) -> PodSecurityContext:
        return typing.cast(PodSecurityContext, jsii.get(self, "securityContext"))

    @builtins.property
    @jsii.member(jsii_name="volumes")
    def volumes(self) -> typing.List[Volume]:
        return typing.cast(typing.List[Volume], jsii.get(self, "volumes"))

    @builtins.property
    @jsii.member(jsii_name="dockerRegistryAuth")
    def docker_registry_auth(self) -> typing.Optional["DockerConfigSecret"]:
        return typing.cast(typing.Optional["DockerConfigSecret"], jsii.get(self, "dockerRegistryAuth"))

    @builtins.property
    @jsii.member(jsii_name="restartPolicy")
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        return typing.cast(typing.Optional[RestartPolicy], jsii.get(self, "restartPolicy"))

    @builtins.property
    @jsii.member(jsii_name="serviceAccount")
    def service_account(self) -> typing.Optional["IServiceAccount"]:
        return typing.cast(typing.Optional["IServiceAccount"], jsii.get(self, "serviceAccount"))


class _AbstractPodProxy(
    AbstractPod,
    jsii.proxy_for(Resource), # type: ignore[misc]
):
    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "podMetadata"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, AbstractPod).__jsii_proxy_class__ = lambda : _AbstractPodProxy


@jsii.data_type(
    jsii_type="cdk8s-plus-23.AbstractPodProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "volumes": "volumes",
    },
)
class AbstractPodProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional["DockerConfigSecret"] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional["IServiceAccount"] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
    ) -> None:
        '''Properties for ``AbstractPod``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__48b287ae16fd7f3c8af8f10a921b091e93a037ac321bc55e7a17d66dadf835cb)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if volumes is not None:
            self._values["volumes"] = volumes

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional["DockerConfigSecret"]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional["DockerConfigSecret"], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional["IServiceAccount"]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional["IServiceAccount"], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AbstractPodProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.AddDeploymentOptions",
    jsii_struct_bases=[ServiceBindOptions],
    name_mapping={
        "name": "name",
        "node_port": "nodePort",
        "protocol": "protocol",
        "target_port": "targetPort",
        "port": "port",
    },
)
class AddDeploymentOptions(ServiceBindOptions):
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        node_port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[Protocol] = None,
        target_port: typing.Optional[jsii.Number] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Options to add a deployment to a service.

        :param name: The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. This maps to the 'Name' field in EndpointPort objects. Optional if only one ServicePort is defined on this service.
        :param node_port: The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. Default: - auto-allocate a port if the ServiceType of this Service requires one.
        :param protocol: The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP. Default: Protocol.TCP
        :param target_port: The port number the service will redirect to. Default: - The value of ``port`` will be used.
        :param port: The port number the service will bind to. Default: - Copied from the first container of the deployment.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ae2e993c5f4be0a223b4c5bc9d24ee9136d04a97f3fbc1ed530238eb432b35a2)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument node_port", value=node_port, expected_type=type_hints["node_port"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument target_port", value=target_port, expected_type=type_hints["target_port"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if node_port is not None:
            self._values["node_port"] = node_port
        if protocol is not None:
            self._values["protocol"] = protocol
        if target_port is not None:
            self._values["target_port"] = target_port
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of this port within the service.

        This must be a DNS_LABEL. All
        ports within a ServiceSpec must have unique names. This maps to the 'Name'
        field in EndpointPort objects. Optional if only one ServicePort is defined
        on this service.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def node_port(self) -> typing.Optional[jsii.Number]:
        '''The port on each node on which this service is exposed when type=NodePort or LoadBalancer.

        Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will
        fail. Default is to auto-allocate a port if the ServiceType of this Service
        requires one.

        :default: - auto-allocate a port if the ServiceType of this Service requires one.

        :see: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
        '''
        result = self._values.get("node_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def protocol(self) -> typing.Optional[Protocol]:
        '''The IP protocol for this port.

        Supports "TCP", "UDP", and "SCTP". Default is TCP.

        :default: Protocol.TCP
        '''
        result = self._values.get("protocol")
        return typing.cast(typing.Optional[Protocol], result)

    @builtins.property
    def target_port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will redirect to.

        :default: - The value of ``port`` will be used.
        '''
        result = self._values.get("target_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The port number the service will bind to.

        :default: - Copied from the first container of the deployment.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AddDeploymentOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IApiResource, IApiEndpoint)
class ApiResource(metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.ApiResource"):
    '''Represents information about an API resource type.'''

    @jsii.member(jsii_name="custom")
    @builtins.classmethod
    def custom(
        cls,
        *,
        api_group: builtins.str,
        resource_type: builtins.str,
    ) -> "ApiResource":
        '''API resource information for a custom resource type.

        :param api_group: The group portion of the API version (e.g. ``authorization.k8s.io``).
        :param resource_type: The name of the resource type as it appears in the relevant API endpoint.
        '''
        options = ApiResourceOptions(api_group=api_group, resource_type=resource_type)

        return typing.cast("ApiResource", jsii.sinvoke(cls, "custom", [options]))

    @jsii.member(jsii_name="asApiResource")
    def as_api_resource(self) -> typing.Optional[IApiResource]:
        '''Return the IApiResource this object represents.'''
        return typing.cast(typing.Optional[IApiResource], jsii.invoke(self, "asApiResource", []))

    @jsii.member(jsii_name="asNonApiResource")
    def as_non_api_resource(self) -> typing.Optional[builtins.str]:
        '''Return the non resource url this object represents.'''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "asNonApiResource", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="API_SERVICES")
    def API_SERVICES(cls) -> "ApiResource":
        '''API resource information for APIService.'''
        return typing.cast("ApiResource", jsii.sget(cls, "API_SERVICES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="BINDINGS")
    def BINDINGS(cls) -> "ApiResource":
        '''API resource information for Binding.'''
        return typing.cast("ApiResource", jsii.sget(cls, "BINDINGS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CERTIFICATE_SIGNING_REQUESTS")
    def CERTIFICATE_SIGNING_REQUESTS(cls) -> "ApiResource":
        '''API resource information for CertificateSigningRequest.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CERTIFICATE_SIGNING_REQUESTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CLUSTER_ROLE_BINDINGS")
    def CLUSTER_ROLE_BINDINGS(cls) -> "ApiResource":
        '''API resource information for ClusterRoleBinding.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CLUSTER_ROLE_BINDINGS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CLUSTER_ROLES")
    def CLUSTER_ROLES(cls) -> "ApiResource":
        '''API resource information for ClusterRole.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CLUSTER_ROLES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="COMPONENT_STATUSES")
    def COMPONENT_STATUSES(cls) -> "ApiResource":
        '''API resource information for ComponentStatus.'''
        return typing.cast("ApiResource", jsii.sget(cls, "COMPONENT_STATUSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CONFIG_MAPS")
    def CONFIG_MAPS(cls) -> "ApiResource":
        '''API resource information for ConfigMap.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CONFIG_MAPS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CONTROLLER_REVISIONS")
    def CONTROLLER_REVISIONS(cls) -> "ApiResource":
        '''API resource information for ControllerRevision.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CONTROLLER_REVISIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CRON_JOBS")
    def CRON_JOBS(cls) -> "ApiResource":
        '''API resource information for CronJob.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CRON_JOBS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CSI_DRIVERS")
    def CSI_DRIVERS(cls) -> "ApiResource":
        '''API resource information for CSIDriver.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CSI_DRIVERS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CSI_NODES")
    def CSI_NODES(cls) -> "ApiResource":
        '''API resource information for CSINode.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CSI_NODES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CSI_STORAGE_CAPACITIES")
    def CSI_STORAGE_CAPACITIES(cls) -> "ApiResource":
        '''API resource information for CSIStorageCapacity.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CSI_STORAGE_CAPACITIES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="CUSTOM_RESOURCE_DEFINITIONS")
    def CUSTOM_RESOURCE_DEFINITIONS(cls) -> "ApiResource":
        '''API resource information for CustomResourceDefinition.'''
        return typing.cast("ApiResource", jsii.sget(cls, "CUSTOM_RESOURCE_DEFINITIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="DAEMON_SETS")
    def DAEMON_SETS(cls) -> "ApiResource":
        '''API resource information for DaemonSet.'''
        return typing.cast("ApiResource", jsii.sget(cls, "DAEMON_SETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="DEPLOYMENTS")
    def DEPLOYMENTS(cls) -> "ApiResource":
        '''API resource information for Deployment.'''
        return typing.cast("ApiResource", jsii.sget(cls, "DEPLOYMENTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ENDPOINT_SLICES")
    def ENDPOINT_SLICES(cls) -> "ApiResource":
        '''API resource information for EndpointSlice.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ENDPOINT_SLICES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ENDPOINTS")
    def ENDPOINTS(cls) -> "ApiResource":
        '''API resource information for Endpoints.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ENDPOINTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="EVENTS")
    def EVENTS(cls) -> "ApiResource":
        '''API resource information for Event.'''
        return typing.cast("ApiResource", jsii.sget(cls, "EVENTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="FLOW_SCHEMAS")
    def FLOW_SCHEMAS(cls) -> "ApiResource":
        '''API resource information for FlowSchema.'''
        return typing.cast("ApiResource", jsii.sget(cls, "FLOW_SCHEMAS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="HORIZONTAL_POD_AUTOSCALERS")
    def HORIZONTAL_POD_AUTOSCALERS(cls) -> "ApiResource":
        '''API resource information for HorizontalPodAutoscaler.'''
        return typing.cast("ApiResource", jsii.sget(cls, "HORIZONTAL_POD_AUTOSCALERS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="INGRESS_CLASSES")
    def INGRESS_CLASSES(cls) -> "ApiResource":
        '''API resource information for IngressClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "INGRESS_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="INGRESSES")
    def INGRESSES(cls) -> "ApiResource":
        '''API resource information for Ingress.'''
        return typing.cast("ApiResource", jsii.sget(cls, "INGRESSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="JOBS")
    def JOBS(cls) -> "ApiResource":
        '''API resource information for Job.'''
        return typing.cast("ApiResource", jsii.sget(cls, "JOBS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LEASES")
    def LEASES(cls) -> "ApiResource":
        '''API resource information for Lease.'''
        return typing.cast("ApiResource", jsii.sget(cls, "LEASES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LIMIT_RANGES")
    def LIMIT_RANGES(cls) -> "ApiResource":
        '''API resource information for LimitRange.'''
        return typing.cast("ApiResource", jsii.sget(cls, "LIMIT_RANGES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LOCAL_SUBJECT_ACCESS_REVIEWS")
    def LOCAL_SUBJECT_ACCESS_REVIEWS(cls) -> "ApiResource":
        '''API resource information for LocalSubjectAccessReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "LOCAL_SUBJECT_ACCESS_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="MUTATING_WEBHOOK_CONFIGURATIONS")
    def MUTATING_WEBHOOK_CONFIGURATIONS(cls) -> "ApiResource":
        '''API resource information for MutatingWebhookConfiguration.'''
        return typing.cast("ApiResource", jsii.sget(cls, "MUTATING_WEBHOOK_CONFIGURATIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NAMESPACES")
    def NAMESPACES(cls) -> "ApiResource":
        '''API resource information for Namespace.'''
        return typing.cast("ApiResource", jsii.sget(cls, "NAMESPACES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NETWORK_POLICIES")
    def NETWORK_POLICIES(cls) -> "ApiResource":
        '''API resource information for NetworkPolicy.'''
        return typing.cast("ApiResource", jsii.sget(cls, "NETWORK_POLICIES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NODES")
    def NODES(cls) -> "ApiResource":
        '''API resource information for Node.'''
        return typing.cast("ApiResource", jsii.sget(cls, "NODES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PERSISTENT_VOLUME_CLAIMS")
    def PERSISTENT_VOLUME_CLAIMS(cls) -> "ApiResource":
        '''API resource information for PersistentVolumeClaim.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PERSISTENT_VOLUME_CLAIMS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PERSISTENT_VOLUMES")
    def PERSISTENT_VOLUMES(cls) -> "ApiResource":
        '''API resource information for PersistentVolume.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PERSISTENT_VOLUMES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="POD_DISRUPTION_BUDGETS")
    def POD_DISRUPTION_BUDGETS(cls) -> "ApiResource":
        '''API resource information for PodDisruptionBudget.'''
        return typing.cast("ApiResource", jsii.sget(cls, "POD_DISRUPTION_BUDGETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="POD_SECURITY_POLICIES")
    def POD_SECURITY_POLICIES(cls) -> "ApiResource":
        '''API resource information for PodSecurityPolicy.'''
        return typing.cast("ApiResource", jsii.sget(cls, "POD_SECURITY_POLICIES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="POD_TEMPLATES")
    def POD_TEMPLATES(cls) -> "ApiResource":
        '''API resource information for PodTemplate.'''
        return typing.cast("ApiResource", jsii.sget(cls, "POD_TEMPLATES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PODS")
    def PODS(cls) -> "ApiResource":
        '''API resource information for Pod.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PODS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PRIORITY_CLASSES")
    def PRIORITY_CLASSES(cls) -> "ApiResource":
        '''API resource information for PriorityClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PRIORITY_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="PRIORITY_LEVEL_CONFIGURATIONS")
    def PRIORITY_LEVEL_CONFIGURATIONS(cls) -> "ApiResource":
        '''API resource information for PriorityLevelConfiguration.'''
        return typing.cast("ApiResource", jsii.sget(cls, "PRIORITY_LEVEL_CONFIGURATIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="REPLICA_SETS")
    def REPLICA_SETS(cls) -> "ApiResource":
        '''API resource information for ReplicaSet.'''
        return typing.cast("ApiResource", jsii.sget(cls, "REPLICA_SETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="REPLICATION_CONTROLLERS")
    def REPLICATION_CONTROLLERS(cls) -> "ApiResource":
        '''API resource information for ReplicationController.'''
        return typing.cast("ApiResource", jsii.sget(cls, "REPLICATION_CONTROLLERS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="RESOURCE_QUOTAS")
    def RESOURCE_QUOTAS(cls) -> "ApiResource":
        '''API resource information for ResourceQuota.'''
        return typing.cast("ApiResource", jsii.sget(cls, "RESOURCE_QUOTAS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ROLE_BINDINGS")
    def ROLE_BINDINGS(cls) -> "ApiResource":
        '''API resource information for RoleBinding.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ROLE_BINDINGS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ROLES")
    def ROLES(cls) -> "ApiResource":
        '''API resource information for Role.'''
        return typing.cast("ApiResource", jsii.sget(cls, "ROLES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="RUNTIME_CLASSES")
    def RUNTIME_CLASSES(cls) -> "ApiResource":
        '''API resource information for RuntimeClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "RUNTIME_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SECRETS")
    def SECRETS(cls) -> "ApiResource":
        '''API resource information for Secret.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SECRETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SELF_SUBJECT_ACCESS_REVIEWS")
    def SELF_SUBJECT_ACCESS_REVIEWS(cls) -> "ApiResource":
        '''API resource information for SelfSubjectAccessReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SELF_SUBJECT_ACCESS_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SELF_SUBJECT_RULES_REVIEWS")
    def SELF_SUBJECT_RULES_REVIEWS(cls) -> "ApiResource":
        '''API resource information for SelfSubjectRulesReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SELF_SUBJECT_RULES_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SERVICE_ACCOUNTS")
    def SERVICE_ACCOUNTS(cls) -> "ApiResource":
        '''API resource information for ServiceAccount.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SERVICE_ACCOUNTS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SERVICES")
    def SERVICES(cls) -> "ApiResource":
        '''API resource information for Service.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SERVICES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="STATEFUL_SETS")
    def STATEFUL_SETS(cls) -> "ApiResource":
        '''API resource information for StatefulSet.'''
        return typing.cast("ApiResource", jsii.sget(cls, "STATEFUL_SETS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="STORAGE_CLASSES")
    def STORAGE_CLASSES(cls) -> "ApiResource":
        '''API resource information for StorageClass.'''
        return typing.cast("ApiResource", jsii.sget(cls, "STORAGE_CLASSES"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SUBJECT_ACCESS_REVIEWS")
    def SUBJECT_ACCESS_REVIEWS(cls) -> "ApiResource":
        '''API resource information for SubjectAccessReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "SUBJECT_ACCESS_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="TOKEN_REVIEWS")
    def TOKEN_REVIEWS(cls) -> "ApiResource":
        '''API resource information for TokenReview.'''
        return typing.cast("ApiResource", jsii.sget(cls, "TOKEN_REVIEWS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="VALIDATING_WEBHOOK_CONFIGURATIONS")
    def VALIDATING_WEBHOOK_CONFIGURATIONS(cls) -> "ApiResource":
        '''API resource information for ValidatingWebhookConfiguration.'''
        return typing.cast("ApiResource", jsii.sget(cls, "VALIDATING_WEBHOOK_CONFIGURATIONS"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="VOLUME_ATTACHMENTS")
    def VOLUME_ATTACHMENTS(cls) -> "ApiResource":
        '''API resource information for VolumeAttachment.'''
        return typing.cast("ApiResource", jsii.sget(cls, "VOLUME_ATTACHMENTS"))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> builtins.str:
        '''The group portion of the API version (e.g. ``authorization.k8s.io``).'''
        return typing.cast(builtins.str, jsii.get(self, "apiGroup"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of the resource type as it appears in the relevant API endpoint.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/rbac/#referring-to-resources

        Example::

            - "pods" or "pods/log"
        '''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


class BasicAuthSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.BasicAuthSecret",
):
    '''Create a secret for basic authentication.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        password: builtins.str,
        username: builtins.str,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param password: The password or token for authentication.
        :param username: The user name for authentication.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cf0201a1c7948a099fc3deb654a6653725f15fec595481f71ef930060e076c70)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = BasicAuthSecretProps(
            password=password,
            username=username,
            immutable=immutable,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])


class ClusterRoleBinding(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.ClusterRoleBinding",
):
    '''A ClusterRoleBinding grants permissions cluster-wide to a user or set of users.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        role: "IClusterRole",
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param role: The role to bind to.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ddcb7664b672b0f2d31a247096348f3100ce354efcca13ce0dc306369c90b6a2)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ClusterRoleBindingProps(role=role, metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addSubjects")
    def add_subjects(self, *subjects: ISubject) -> None:
        '''Adds a subject to the role.

        :param subjects: The subjects to add.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4728c0769bd0872e478be23cafedff87f28865fdc2cea8b0b4f62e55195ad7fc)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addSubjects", [*subjects]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="role")
    def role(self) -> "IClusterRole":
        return typing.cast("IClusterRole", jsii.get(self, "role"))

    @builtins.property
    @jsii.member(jsii_name="subjects")
    def subjects(self) -> typing.List[ISubject]:
        return typing.cast(typing.List[ISubject], jsii.get(self, "subjects"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ClusterRoleBindingProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "role": "role"},
)
class ClusterRoleBindingProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        role: "IClusterRole",
    ) -> None:
        '''Properties for ``ClusterRoleBinding``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param role: The role to bind to.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89fcdede47d563117c096204eb72000fa2790596963f2ff146700e1a08bba9ae)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument role", value=role, expected_type=type_hints["role"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "role": role,
        }
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def role(self) -> "IClusterRole":
        '''The role to bind to.'''
        result = self._values.get("role")
        assert result is not None, "Required property 'role' is missing"
        return typing.cast("IClusterRole", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterRoleBindingProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ClusterRoleProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "aggregation_labels": "aggregationLabels",
        "rules": "rules",
    },
)
class ClusterRoleProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        aggregation_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[ClusterRolePolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for ``ClusterRole``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param aggregation_labels: Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.
        :param rules: A list of rules the role should allow. Default: []
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8fa1bb1bacfb987e3df1ac1430937cf61d1913c4b8e0a48649ddb518fcd87049)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument aggregation_labels", value=aggregation_labels, expected_type=type_hints["aggregation_labels"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if aggregation_labels is not None:
            self._values["aggregation_labels"] = aggregation_labels
        if rules is not None:
            self._values["rules"] = rules

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def aggregation_labels(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.'''
        result = self._values.get("aggregation_labels")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[ClusterRolePolicyRule]]:
        '''A list of rules the role should allow.

        :default: []
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[ClusterRolePolicyRule]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ClusterRoleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.CommandProbeOptions",
    jsii_struct_bases=[ProbeOptions],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
    },
)
class CommandProbeOptions(ProbeOptions):
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Options for ``Probe.fromCommand()``.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__efcc568b743f7eff5b2cd01c2ec94b8922273d4d241a7de76be5d8d6110d3243)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CommandProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.CommonSecretProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata", "immutable": "immutable"},
)
class CommonSecretProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Common properties for ``Secret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a2d7d8bfcecd03899f96f1a53151a0aa0e406077b601f4c6714442b34d1a94ce)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CommonSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ConfigMapProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "binary_data": "binaryData",
        "data": "data",
        "immutable": "immutable",
    },
)
class ConfigMapProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for initialization of ``ConfigMap``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. You can also add binary data using ``configMap.addBinaryData()``.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process. You can also add data using ``configMap.addData()``.
        :param immutable: If set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__487d2a7214bb653d96561c26081cf89f1a0536df4ddec7194cbfad0020d4e3cc)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument binary_data", value=binary_data, expected_type=type_hints["binary_data"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if binary_data is not None:
            self._values["binary_data"] = binary_data
        if data is not None:
            self._values["data"] = data
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def binary_data(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''BinaryData contains the binary data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'.
        BinaryData can contain byte sequences that are not in the UTF-8 range. The
        keys stored in BinaryData must not overlap with the ones in the Data field,
        this is enforced during validation process.

        You can also add binary data using ``configMap.addBinaryData()``.
        '''
        result = self._values.get("binary_data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def data(self) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''Data contains the configuration data.

        Each key must consist of alphanumeric characters, '-', '_' or '.'. Values
        with non-UTF-8 byte sequences must use the BinaryData field. The keys
        stored in Data must not overlap with the keys in the BinaryData field, this
        is enforced during validation process.

        You can also add data using ``configMap.addData()``.
        '''
        result = self._values.get("data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConfigMapProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DockerConfigSecret(
    Secret,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.DockerConfigSecret",
):
    '''Create a secret for storing credentials for accessing a container image registry.

    :see: https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        data: typing.Mapping[builtins.str, typing.Any],
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param data: JSON content to provide for the ``~/.docker/config.json`` file. This will be stringified and inserted as stringData.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89590d35f33989c458ad5438a64e4232e6cb30f13ec1df3796de1f70270c518d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = DockerConfigSecretProps(
            data=data, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])


@jsii.data_type(
    jsii_type="cdk8s-plus-23.DockerConfigSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={"metadata": "metadata", "immutable": "immutable", "data": "data"},
)
class DockerConfigSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        data: typing.Mapping[builtins.str, typing.Any],
    ) -> None:
        '''Options for ``DockerConfigSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param data: JSON content to provide for the ``~/.docker/config.json`` file. This will be stringified and inserted as stringData.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b16563cb2811c1e1d79ebdaed5b409985b073e349e8730630f44bb73eb19ecd7)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument data", value=data, expected_type=type_hints["data"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data": data,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def data(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''JSON content to provide for the ``~/.docker/config.json`` file. This will be stringified and inserted as stringData.

        :see: https://docs.docker.com/engine/reference/commandline/cli/#sample-configuration-file
        '''
        result = self._values.get("data")
        assert result is not None, "Required property 'data' is missing"
        return typing.cast(typing.Mapping[builtins.str, typing.Any], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DockerConfigSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ExposeDeploymentViaIngressOptions",
    jsii_struct_bases=[
        DeploymentExposeViaServiceOptions, ExposeServiceViaIngressOptions
    ],
    name_mapping={
        "name": "name",
        "ports": "ports",
        "service_type": "serviceType",
        "ingress": "ingress",
        "path_type": "pathType",
    },
)
class ExposeDeploymentViaIngressOptions(
    DeploymentExposeViaServiceOptions,
    ExposeServiceViaIngressOptions,
):
    def __init__(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional[ServiceType] = None,
        ingress: typing.Optional["Ingress"] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Options for exposing a deployment via an ingress.

        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ce8af844b8043e26062998bdef4345dba622e901dec6c68047dba9552254c9e)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
            check_type(argname="argument service_type", value=service_type, expected_type=type_hints["service_type"])
            check_type(argname="argument ingress", value=ingress, expected_type=type_hints["ingress"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if name is not None:
            self._values["name"] = name
        if ports is not None:
            self._values["ports"] = ports
        if service_type is not None:
            self._values["service_type"] = service_type
        if ingress is not None:
            self._values["ingress"] = ingress
        if path_type is not None:
            self._values["path_type"] = path_type

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the service to expose.

        If you'd like to expose the deployment multiple times,
        you must explicitly set a name starting from the second expose call.

        :default: - auto generated.
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ports(self) -> typing.Optional[typing.List[ServicePort]]:
        '''The ports that the service should bind to.

        :default: - extracted from the deployment.
        '''
        result = self._values.get("ports")
        return typing.cast(typing.Optional[typing.List[ServicePort]], result)

    @builtins.property
    def service_type(self) -> typing.Optional[ServiceType]:
        '''The type of the exposed service.

        :default: - ClusterIP.
        '''
        result = self._values.get("service_type")
        return typing.cast(typing.Optional[ServiceType], result)

    @builtins.property
    def ingress(self) -> typing.Optional["Ingress"]:
        '''The ingress to add rules to.

        :default: - An ingress will be automatically created.
        '''
        result = self._values.get("ingress")
        return typing.cast(typing.Optional["Ingress"], result)

    @builtins.property
    def path_type(self) -> typing.Optional[HttpIngressPathType]:
        '''The type of the path.

        :default: HttpIngressPathType.PREFIX
        '''
        result = self._values.get("path_type")
        return typing.cast(typing.Optional[HttpIngressPathType], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ExposeDeploymentViaIngressOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ISubject)
class Group(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.Group",
):
    '''Represents a group.'''

    @jsii.member(jsii_name="fromName")
    @builtins.classmethod
    def from_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> "Group":
        '''Reference a group by name.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70f519a205d9803d338cc64c38fdf80057bfa3bb2020f242049101837cf1f92e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast("Group", jsii.sinvoke(cls, "fromName", [scope, id, name]))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "kind"))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @builtins.property
    @jsii.member(jsii_name="apiGroup")
    def api_group(self) -> typing.Optional[builtins.str]:
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "apiGroup"))


class HorizontalPodAutoscaler(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.HorizontalPodAutoscaler",
):
    '''A HorizontalPodAutoscaler scales a workload up or down in response to a metric change.

    This allows your services to scale up when demand is high and scale down
    when they are no longer needed.

    Typical use cases for HorizontalPodAutoscaler:

    - When Memory usage is above 70%, scale up the number of replicas to meet the demand.
    - When CPU usage is below 30%, scale down the number of replicas to save resources.
    - When a service is experiencing a spike in traffic, scale up the number of replicas
      to meet the demand. Then, when the traffic subsides, scale down the number of
      replicas to save resources.

    The autoscaler uses the following algorithm to determine the number of replicas to scale:

    ``desiredReplicas = ceil[currentReplicas * ( currentMetricValue / desiredMetricValue )]``

    HorizontalPodAutoscaler's can be used to with any ``Scalable`` workload:

    - Deployment
    - StatefulSet

    **Targets that already have a replica count defined:**

    Remove any replica counts from the target resource before associating with a
    HorizontalPodAutoscaler. If this isn't done, then any time a change to that object is applied,
    Kubernetes will scale the current number of Pods to the value of the target.replicas key. This
    may not be desired and could lead to unexpected behavior.

    :see: https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/#implicit-maintenance-mode-deactivation

    Example::

        const backend = new kplus.Deployment(this, 'Backend', ...);
        
        const hpa = new kplus.HorizontalPodAutoscaler(chart, 'Hpa', {
         target: backend,
         maxReplicas: 10,
         scaleUp: {
           policies: [
             {
               replicas: kplus.Replicas.absolute(3),
               duration: Duration.minutes(5),
             },
           ],
         },
        });
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        max_replicas: jsii.Number,
        target: IScalable,
        metrics: typing.Optional[typing.Sequence[Metric]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
        scale_down: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
        scale_up: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param max_replicas: The maximum number of replicas that can be scaled up to.
        :param target: The workload to scale up or down. Scalable workload types: - Deployment - StatefulSet
        :param metrics: The metric conditions that trigger a scale up or scale down. Default: - If metrics are not provided, then the target resource constraints (e.g. cpu limit) will be used as scaling metrics.
        :param min_replicas: The minimum number of replicas that can be scaled down to. Can be set to 0 if the alpha feature gate ``HPAScaleToZero`` is enabled and at least one Object or External metric is configured. Default: 1
        :param scale_down: The scaling behavior when scaling down. Default: - Scale down to minReplica count with a 5 minute stabilization window.
        :param scale_up: The scaling behavior when scaling up. Default: - Is the higher of: - Increase no more than 4 pods per 60 seconds - Double the number of pods per 60 seconds
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__34c8e2345085099134e331ede37ce731b60bc78648f5cb2fbaa91787d87f93da)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = HorizontalPodAutoscalerProps(
            max_replicas=max_replicas,
            target=target,
            metrics=metrics,
            min_replicas=min_replicas,
            scale_down=scale_down,
            scale_up=scale_up,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="maxReplicas")
    def max_replicas(self) -> jsii.Number:
        '''The maximum number of replicas that can be scaled up to.'''
        return typing.cast(jsii.Number, jsii.get(self, "maxReplicas"))

    @builtins.property
    @jsii.member(jsii_name="minReplicas")
    def min_replicas(self) -> jsii.Number:
        '''The minimum number of replicas that can be scaled down to.'''
        return typing.cast(jsii.Number, jsii.get(self, "minReplicas"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="scaleDown")
    def scale_down(self) -> ScalingRules:
        '''The scaling behavior when scaling down.'''
        return typing.cast(ScalingRules, jsii.get(self, "scaleDown"))

    @builtins.property
    @jsii.member(jsii_name="scaleUp")
    def scale_up(self) -> ScalingRules:
        '''The scaling behavior when scaling up.'''
        return typing.cast(ScalingRules, jsii.get(self, "scaleUp"))

    @builtins.property
    @jsii.member(jsii_name="target")
    def target(self) -> IScalable:
        '''The workload to scale up or down.'''
        return typing.cast(IScalable, jsii.get(self, "target"))

    @builtins.property
    @jsii.member(jsii_name="metrics")
    def metrics(self) -> typing.Optional[typing.List[Metric]]:
        '''The metric conditions that trigger a scale up or scale down.'''
        return typing.cast(typing.Optional[typing.List[Metric]], jsii.get(self, "metrics"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.HorizontalPodAutoscalerProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "max_replicas": "maxReplicas",
        "target": "target",
        "metrics": "metrics",
        "min_replicas": "minReplicas",
        "scale_down": "scaleDown",
        "scale_up": "scaleUp",
    },
)
class HorizontalPodAutoscalerProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        max_replicas: jsii.Number,
        target: IScalable,
        metrics: typing.Optional[typing.Sequence[Metric]] = None,
        min_replicas: typing.Optional[jsii.Number] = None,
        scale_down: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
        scale_up: typing.Optional[typing.Union[ScalingRules, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Properties for HorizontalPodAutoscaler.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param max_replicas: The maximum number of replicas that can be scaled up to.
        :param target: The workload to scale up or down. Scalable workload types: - Deployment - StatefulSet
        :param metrics: The metric conditions that trigger a scale up or scale down. Default: - If metrics are not provided, then the target resource constraints (e.g. cpu limit) will be used as scaling metrics.
        :param min_replicas: The minimum number of replicas that can be scaled down to. Can be set to 0 if the alpha feature gate ``HPAScaleToZero`` is enabled and at least one Object or External metric is configured. Default: 1
        :param scale_down: The scaling behavior when scaling down. Default: - Scale down to minReplica count with a 5 minute stabilization window.
        :param scale_up: The scaling behavior when scaling up. Default: - Is the higher of: - Increase no more than 4 pods per 60 seconds - Double the number of pods per 60 seconds
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(scale_down, dict):
            scale_down = ScalingRules(**scale_down)
        if isinstance(scale_up, dict):
            scale_up = ScalingRules(**scale_up)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a376245fa10976954ca9e91693b4878569a9d2070f2eb684f3239d8b4b8aeb2e)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument max_replicas", value=max_replicas, expected_type=type_hints["max_replicas"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument metrics", value=metrics, expected_type=type_hints["metrics"])
            check_type(argname="argument min_replicas", value=min_replicas, expected_type=type_hints["min_replicas"])
            check_type(argname="argument scale_down", value=scale_down, expected_type=type_hints["scale_down"])
            check_type(argname="argument scale_up", value=scale_up, expected_type=type_hints["scale_up"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "max_replicas": max_replicas,
            "target": target,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if metrics is not None:
            self._values["metrics"] = metrics
        if min_replicas is not None:
            self._values["min_replicas"] = min_replicas
        if scale_down is not None:
            self._values["scale_down"] = scale_down
        if scale_up is not None:
            self._values["scale_up"] = scale_up

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def max_replicas(self) -> jsii.Number:
        '''The maximum number of replicas that can be scaled up to.'''
        result = self._values.get("max_replicas")
        assert result is not None, "Required property 'max_replicas' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def target(self) -> IScalable:
        '''The workload to scale up or down.

        Scalable workload types:

        - Deployment
        - StatefulSet
        '''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast(IScalable, result)

    @builtins.property
    def metrics(self) -> typing.Optional[typing.List[Metric]]:
        '''The metric conditions that trigger a scale up or scale down.

        :default:

        - If metrics are not provided, then the target resource
        constraints (e.g. cpu limit) will be used as scaling metrics.
        '''
        result = self._values.get("metrics")
        return typing.cast(typing.Optional[typing.List[Metric]], result)

    @builtins.property
    def min_replicas(self) -> typing.Optional[jsii.Number]:
        '''The minimum number of replicas that can be scaled down to.

        Can be set to 0 if the alpha feature gate ``HPAScaleToZero`` is enabled and
        at least one Object or External metric is configured.

        :default: 1
        '''
        result = self._values.get("min_replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def scale_down(self) -> typing.Optional[ScalingRules]:
        '''The scaling behavior when scaling down.

        :default: - Scale down to minReplica count with a 5 minute stabilization window.
        '''
        result = self._values.get("scale_down")
        return typing.cast(typing.Optional[ScalingRules], result)

    @builtins.property
    def scale_up(self) -> typing.Optional[ScalingRules]:
        '''The scaling behavior when scaling up.

        :default:

        - Is the higher of:

        - Increase no more than 4 pods per 60 seconds
        - Double the number of pods per 60 seconds
        '''
        result = self._values.get("scale_up")
        return typing.cast(typing.Optional[ScalingRules], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HorizontalPodAutoscalerProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.HttpGetProbeOptions",
    jsii_struct_bases=[ProbeOptions],
    name_mapping={
        "failure_threshold": "failureThreshold",
        "initial_delay_seconds": "initialDelaySeconds",
        "period_seconds": "periodSeconds",
        "success_threshold": "successThreshold",
        "timeout_seconds": "timeoutSeconds",
        "port": "port",
        "scheme": "scheme",
    },
)
class HttpGetProbeOptions(ProbeOptions):
    def __init__(
        self,
        *,
        failure_threshold: typing.Optional[jsii.Number] = None,
        initial_delay_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        period_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        success_threshold: typing.Optional[jsii.Number] = None,
        timeout_seconds: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        port: typing.Optional[jsii.Number] = None,
        scheme: typing.Optional[ConnectionScheme] = None,
    ) -> None:
        '''Options for ``Probe.fromHttpGet()``.

        :param failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Default: 3
        :param initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Default: - immediate
        :param period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Default: Duration.seconds(10) Minimum value is 1.
        :param success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        :param timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Default: Duration.seconds(1)
        :param port: The TCP port to use when sending the GET request. Default: - defaults to ``container.port``.
        :param scheme: Scheme to use for connecting to the host (HTTP or HTTPS). Default: ConnectionScheme.HTTP
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18cbef4aae57cef30b4cfa6e8abf88b2358b09bc439feb651b6921bb527b6216)
            check_type(argname="argument failure_threshold", value=failure_threshold, expected_type=type_hints["failure_threshold"])
            check_type(argname="argument initial_delay_seconds", value=initial_delay_seconds, expected_type=type_hints["initial_delay_seconds"])
            check_type(argname="argument period_seconds", value=period_seconds, expected_type=type_hints["period_seconds"])
            check_type(argname="argument success_threshold", value=success_threshold, expected_type=type_hints["success_threshold"])
            check_type(argname="argument timeout_seconds", value=timeout_seconds, expected_type=type_hints["timeout_seconds"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if failure_threshold is not None:
            self._values["failure_threshold"] = failure_threshold
        if initial_delay_seconds is not None:
            self._values["initial_delay_seconds"] = initial_delay_seconds
        if period_seconds is not None:
            self._values["period_seconds"] = period_seconds
        if success_threshold is not None:
            self._values["success_threshold"] = success_threshold
        if timeout_seconds is not None:
            self._values["timeout_seconds"] = timeout_seconds
        if port is not None:
            self._values["port"] = port
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def failure_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive failures for the probe to be considered failed after having succeeded.

        Defaults to 3. Minimum value is 1.

        :default: 3
        '''
        result = self._values.get("failure_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def initial_delay_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after the container has started before liveness probes are initiated.

        :default: - immediate

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("initial_delay_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def period_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''How often (in seconds) to perform the probe.

        Default to 10 seconds. Minimum value is 1.

        :default: Duration.seconds(10) Minimum value is 1.
        '''
        result = self._values.get("period_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def success_threshold(self) -> typing.Optional[jsii.Number]:
        '''Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1.

        Must be 1 for liveness and startup. Minimum value is 1.

        :default: 1 Must be 1 for liveness and startup. Minimum value is 1.
        '''
        result = self._values.get("success_threshold")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def timeout_seconds(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Number of seconds after which the probe times out.

        Defaults to 1 second. Minimum value is 1.

        :default: Duration.seconds(1)

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        '''
        result = self._values.get("timeout_seconds")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''The TCP port to use when sending the GET request.

        :default: - defaults to ``container.port``.
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def scheme(self) -> typing.Optional[ConnectionScheme]:
        '''Scheme to use for connecting to the host (HTTP or HTTPS).

        :default: ConnectionScheme.HTTP
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[ConnectionScheme], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpGetProbeOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.interface(jsii_type="cdk8s-plus-23.IClusterRole")
class IClusterRole(IResource, typing_extensions.Protocol):
    '''Represents a cluster-level role.'''

    pass


class _IClusterRoleProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Represents a cluster-level role.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IClusterRole"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IClusterRole).__jsii_proxy_class__ = lambda : _IClusterRoleProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IConfigMap")
class IConfigMap(IResource, typing_extensions.Protocol):
    '''Represents a config map.'''

    pass


class _IConfigMapProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Represents a config map.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IConfigMap"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IConfigMap).__jsii_proxy_class__ = lambda : _IConfigMapProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IPersistentVolume")
class IPersistentVolume(IResource, typing_extensions.Protocol):
    '''Contract of a ``PersistentVolumeClaim``.'''

    pass


class _IPersistentVolumeProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Contract of a ``PersistentVolumeClaim``.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IPersistentVolume"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPersistentVolume).__jsii_proxy_class__ = lambda : _IPersistentVolumeProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IPersistentVolumeClaim")
class IPersistentVolumeClaim(IResource, typing_extensions.Protocol):
    '''Contract of a ``PersistentVolumeClaim``.'''

    pass


class _IPersistentVolumeClaimProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
):
    '''Contract of a ``PersistentVolumeClaim``.'''

    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IPersistentVolumeClaim"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPersistentVolumeClaim).__jsii_proxy_class__ = lambda : _IPersistentVolumeClaimProxy


@jsii.interface(jsii_type="cdk8s-plus-23.IServiceAccount")
class IServiceAccount(IResource, ISubject, typing_extensions.Protocol):
    pass


class _IServiceAccountProxy(
    jsii.proxy_for(IResource), # type: ignore[misc]
    jsii.proxy_for(ISubject), # type: ignore[misc]
):
    __jsii_type__: typing.ClassVar[str] = "cdk8s-plus-23.IServiceAccount"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IServiceAccount).__jsii_proxy_class__ = lambda : _IServiceAccountProxy


class Ingress(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Ingress"):
    '''Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.

    An Ingress can be configured to give services
    externally-reachable urls, load balance traffic, terminate SSL, offer name
    based virtual hosting etc.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        default_backend: typing.Optional[IngressBackend] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[IngressRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        tls: typing.Optional[typing.Sequence[typing.Union[IngressTls, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param default_backend: The default backend services requests that do not match any rule. Using this option or the ``addDefaultBackend()`` method is equivalent to adding a rule with both ``path`` and ``host`` undefined.
        :param rules: Routing rules for this ingress. Each rule must define an ``IngressBackend`` that will receive the requests that match this rule. If both ``host`` and ``path`` are not specifiec, this backend will be used as the default backend of the ingress. You can also add rules later using ``addRule()``, ``addHostRule()``, ``addDefaultBackend()`` and ``addHostDefaultBackend()``.
        :param tls: TLS settings for this ingress. Using this option tells the ingress controller to expose a TLS endpoint. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__474a62df954c3ec1439fbda94acaa42389a7263d88d9188d9f60206509053fd6)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = IngressProps(
            default_backend=default_backend, rules=rules, tls=tls, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addDefaultBackend")
    def add_default_backend(self, backend: IngressBackend) -> None:
        '''Defines the default backend for this ingress.

        A default backend capable of
        servicing requests that don't match any rule.

        :param backend: The backend to use for requests that do not match any rule.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20112cab96ec88741fc6bb16179c3f4614e5e4c269d57f698428adea05b7f7a7)
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
        return typing.cast(None, jsii.invoke(self, "addDefaultBackend", [backend]))

    @jsii.member(jsii_name="addHostDefaultBackend")
    def add_host_default_backend(
        self,
        host: builtins.str,
        backend: IngressBackend,
    ) -> None:
        '''Specify a default backend for a specific host name.

        This backend will be used as a catch-all for requests
        targeted to this host name (the ``Host`` header matches this value).

        :param host: The host name to match.
        :param backend: The backend to route to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c81a1da8e29e5f8d0c628adb32aadca790efd99e093433bbadab0f180d31d06f)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
        return typing.cast(None, jsii.invoke(self, "addHostDefaultBackend", [host, backend]))

    @jsii.member(jsii_name="addHostRule")
    def add_host_rule(
        self,
        host: builtins.str,
        path: builtins.str,
        backend: IngressBackend,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Adds an ingress rule applied to requests to a specific host and a specific HTTP path (the ``Host`` header matches this value).

        :param host: The host name.
        :param path: The HTTP path.
        :param backend: The backend to route requests to.
        :param path_type: How the path is matched against request paths.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f43461ec2de9a825791dce51fd8c35e6012b33167af35171174ea40a7098479e)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        return typing.cast(None, jsii.invoke(self, "addHostRule", [host, path, backend, path_type]))

    @jsii.member(jsii_name="addRule")
    def add_rule(
        self,
        path: builtins.str,
        backend: IngressBackend,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> None:
        '''Adds an ingress rule applied to requests sent to a specific HTTP path.

        :param path: The HTTP path.
        :param backend: The backend to route requests to.
        :param path_type: How the path is matched against request paths.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8cfa5e8470bfb1d383d0d54ae18f9e6fadfa05cc3b9056bd6dbc5875e6784148)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument path_type", value=path_type, expected_type=type_hints["path_type"])
        return typing.cast(None, jsii.invoke(self, "addRule", [path, backend, path_type]))

    @jsii.member(jsii_name="addRules")
    def add_rules(self, *rules: IngressRule) -> None:
        '''Adds rules to this ingress.

        :param rules: The rules to add.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6794531c39a069a7dcb58132bc24cff9d7c759cb3dde90aad7ed23738318969)
            check_type(argname="argument rules", value=rules, expected_type=typing.Tuple[type_hints["rules"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "addRules", [*rules]))

    @jsii.member(jsii_name="addTls")
    def add_tls(
        self,
        tls: typing.Sequence[typing.Union[IngressTls, typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''
        :param tls: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__651181d29daf069eaec886935aaeada5bef9e02f7eeeaec245968c94e4b08629)
            check_type(argname="argument tls", value=tls, expected_type=type_hints["tls"])
        return typing.cast(None, jsii.invoke(self, "addTls", [tls]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.IngressProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "default_backend": "defaultBackend",
        "rules": "rules",
        "tls": "tls",
    },
)
class IngressProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        default_backend: typing.Optional[IngressBackend] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[IngressRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        tls: typing.Optional[typing.Sequence[typing.Union[IngressTls, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Properties for ``Ingress``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param default_backend: The default backend services requests that do not match any rule. Using this option or the ``addDefaultBackend()`` method is equivalent to adding a rule with both ``path`` and ``host`` undefined.
        :param rules: Routing rules for this ingress. Each rule must define an ``IngressBackend`` that will receive the requests that match this rule. If both ``host`` and ``path`` are not specifiec, this backend will be used as the default backend of the ingress. You can also add rules later using ``addRule()``, ``addHostRule()``, ``addDefaultBackend()`` and ``addHostDefaultBackend()``.
        :param tls: TLS settings for this ingress. Using this option tells the ingress controller to expose a TLS endpoint. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__debfda7355d6908a015a90d234d79a3ee87610ef520ad5b78ec2492e1ce681d2)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument default_backend", value=default_backend, expected_type=type_hints["default_backend"])
            check_type(argname="argument rules", value=rules, expected_type=type_hints["rules"])
            check_type(argname="argument tls", value=tls, expected_type=type_hints["tls"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if default_backend is not None:
            self._values["default_backend"] = default_backend
        if rules is not None:
            self._values["rules"] = rules
        if tls is not None:
            self._values["tls"] = tls

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def default_backend(self) -> typing.Optional[IngressBackend]:
        '''The default backend services requests that do not match any rule.

        Using this option or the ``addDefaultBackend()`` method is equivalent to
        adding a rule with both ``path`` and ``host`` undefined.
        '''
        result = self._values.get("default_backend")
        return typing.cast(typing.Optional[IngressBackend], result)

    @builtins.property
    def rules(self) -> typing.Optional[typing.List[IngressRule]]:
        '''Routing rules for this ingress.

        Each rule must define an ``IngressBackend`` that will receive the requests
        that match this rule. If both ``host`` and ``path`` are not specifiec, this
        backend will be used as the default backend of the ingress.

        You can also add rules later using ``addRule()``, ``addHostRule()``,
        ``addDefaultBackend()`` and ``addHostDefaultBackend()``.
        '''
        result = self._values.get("rules")
        return typing.cast(typing.Optional[typing.List[IngressRule]], result)

    @builtins.property
    def tls(self) -> typing.Optional[typing.List[IngressTls]]:
        '''TLS settings for this ingress.

        Using this option tells the ingress controller to expose a TLS endpoint.
        Currently the Ingress only supports a single TLS port, 443. If multiple
        members of this list specify different hosts, they will be multiplexed on
        the same port according to the hostname specified through the SNI TLS
        extension, if the ingress controller fulfilling the ingress supports SNI.
        '''
        result = self._values.get("tls")
        return typing.cast(typing.Optional[typing.List[IngressTls]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "IngressProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.MetricObjectOptions",
    jsii_struct_bases=[MetricOptions],
    name_mapping={
        "name": "name",
        "target": "target",
        "label_selector": "labelSelector",
        "object": "object",
    },
)
class MetricObjectOptions(MetricOptions):
    def __init__(
        self,
        *,
        name: builtins.str,
        target: MetricTarget,
        label_selector: typing.Optional[LabelSelector] = None,
        object: IResource,
    ) -> None:
        '''Options for ``Metric.object()``.

        :param name: The name of the metric to scale on.
        :param target: The target metric value that will trigger scaling.
        :param label_selector: A selector to find a metric by label. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. Default: - Just the metric 'name' will be used to gather metrics.
        :param object: Resource where the metric can be found.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3db461de8e3ba3dfd65572883bc86fed5d3221e83da305f1a43b897a13132251)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument target", value=target, expected_type=type_hints["target"])
            check_type(argname="argument label_selector", value=label_selector, expected_type=type_hints["label_selector"])
            check_type(argname="argument object", value=object, expected_type=type_hints["object"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "name": name,
            "target": target,
            "object": object,
        }
        if label_selector is not None:
            self._values["label_selector"] = label_selector

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the metric to scale on.'''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def target(self) -> MetricTarget:
        '''The target metric value that will trigger scaling.'''
        result = self._values.get("target")
        assert result is not None, "Required property 'target' is missing"
        return typing.cast(MetricTarget, result)

    @builtins.property
    def label_selector(self) -> typing.Optional[LabelSelector]:
        '''A selector to find a metric by label.

        When set, it is passed as an additional parameter to the metrics server
        for more specific metrics scoping.

        :default: - Just the metric 'name' will be used to gather metrics.
        '''
        result = self._values.get("label_selector")
        return typing.cast(typing.Optional[LabelSelector], result)

    @builtins.property
    def object(self) -> IResource:
        '''Resource where the metric can be found.'''
        result = self._values.get("object")
        assert result is not None, "Required property 'object' is missing"
        return typing.cast(IResource, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricObjectOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(INamespaceSelector, INetworkPolicyPeer)
class Namespace(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Namespace"):
    '''In Kubernetes, namespaces provides a mechanism for isolating groups of resources within a single cluster.

    Names of resources need to be unique within a namespace, but not across namespaces.
    Namespace-based scoping is applicable only for namespaced objects (e.g. Deployments, Services, etc) and
    not for cluster-wide objects (e.g. StorageClass, Nodes, PersistentVolumes, etc).
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bc80153c9cd8e5031805f0ec156c7cf6d77d2108541853f84a915c9883ae29ac)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = NamespaceProps(metadata=metadata)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="toNamespaceSelectorConfig")
    def to_namespace_selector_config(self) -> NamespaceSelectorConfig:
        '''Return the configuration of this selector.

        :see: INamespaceSelector.toNamespaceSelectorConfig()
        '''
        return typing.cast(NamespaceSelectorConfig, jsii.invoke(self, "toNamespaceSelectorConfig", []))

    @jsii.member(jsii_name="toNetworkPolicyPeerConfig")
    def to_network_policy_peer_config(self) -> NetworkPolicyPeerConfig:
        '''Return the configuration of this peer.

        :see: INetworkPolicyPeer.toNetworkPolicyPeerConfig()
        '''
        return typing.cast(NetworkPolicyPeerConfig, jsii.invoke(self, "toNetworkPolicyPeerConfig", []))

    @jsii.member(jsii_name="toPodSelector")
    def to_pod_selector(self) -> typing.Optional[IPodSelector]:
        '''Convert the peer into a pod selector, if possible.

        :see: INetworkPolicyPeer.toPodSelector()
        '''
        return typing.cast(typing.Optional[IPodSelector], jsii.invoke(self, "toPodSelector", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NAME_LABEL")
    def NAME_LABEL(cls) -> builtins.str:
        '''
        :see: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/#automatic-labelling
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "NAME_LABEL"))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NamespaceProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={"metadata": "metadata"},
)
class NamespaceProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Properties for ``Namespace``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9b5e937cd81e4a3f2c7d270e261ebd89fdfc3e57fd0a812019759fe8428182dc)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NamespaceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class NetworkPolicy(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.NetworkPolicy",
):
    '''Control traffic flow at the IP address or port level (OSI layer 3 or 4), network policies are an application-centric construct which allow you to specify how a pod is allowed to communicate with various network peers.

    - Outgoing traffic is allowed if there are no network policies selecting
      the pod (and cluster policy otherwise allows the traffic),
      OR if the traffic matches at least one egress rule across all of the
      network policies that select the pod.
    - Incoming traffic is allowed to a pod if there are no network policies
      selecting the pod (and cluster policy otherwise allows the traffic),
      OR if the traffic source is the pod's local node,
      OR if the traffic matches at least one ingress rule across all of
      the network policies that select the pod.

    Network policies do not conflict; they are additive.
    If any policy or policies apply to a given pod for a given
    direction, the connections allowed in that direction from
    that pod is the union of what the applicable policies allow.
    Thus, order of evaluation does not affect the policy result.

    For a connection from a source pod to a destination pod to be allowed,
    both the egress policy on the source pod and the ingress policy on the
    destination pod need to allow the connection.
    If either side does not allow the connection, it will not happen.

    :see: https://kubernetes.io/docs/concepts/services-networking/network-policies/#networkpolicy-resource
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        egress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        ingress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        selector: typing.Optional[IPodSelector] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param egress: Egress traffic configuration. Default: - the policy doesn't change egress behavior of the pods it selects.
        :param ingress: Ingress traffic configuration. Default: - the policy doesn't change ingress behavior of the pods it selects.
        :param selector: Which pods does this policy object applies to. This can either be a single pod / workload, or a grouping of pods selected via the ``Pods.select`` function. Rules is applied to any pods selected by this property. Multiple network policies can select the same set of pods. In this case, the rules for each are combined additively. Note that Default: - will select all pods in the namespace of the policy.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49bccd8d2805802a63cd52bb9020f30bd69cdf2f39c80fbd8c5e0f52c0f079e0)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = NetworkPolicyProps(
            egress=egress, ingress=ingress, selector=selector, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addEgressRule")
    def add_egress_rule(
        self,
        peer: INetworkPolicyPeer,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow outgoing traffic to the peer.

        If ports are not passed, traffic will be allowed on all ports.

        :param peer: -
        :param ports: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4d097b80438759be5f700474576b97d6a49a1ccc6968db078e41af08a010ec1f)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        return typing.cast(None, jsii.invoke(self, "addEgressRule", [peer, ports]))

    @jsii.member(jsii_name="addIngressRule")
    def add_ingress_rule(
        self,
        peer: INetworkPolicyPeer,
        ports: typing.Optional[typing.Sequence[NetworkPolicyPort]] = None,
    ) -> None:
        '''Allow incoming traffic from the peer.

        If ports are not passed, traffic will be allowed on all ports.

        :param peer: -
        :param ports: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bbea05b908200e48a24ccdf330afb18d5e4294ccae85a80a2c7674554e5892b7)
            check_type(argname="argument peer", value=peer, expected_type=type_hints["peer"])
            check_type(argname="argument ports", value=ports, expected_type=type_hints["ports"])
        return typing.cast(None, jsii.invoke(self, "addIngressRule", [peer, ports]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.NetworkPolicyProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "egress": "egress",
        "ingress": "ingress",
        "selector": "selector",
    },
)
class NetworkPolicyProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        egress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        ingress: typing.Optional[typing.Union[NetworkPolicyTraffic, typing.Dict[builtins.str, typing.Any]]] = None,
        selector: typing.Optional[IPodSelector] = None,
    ) -> None:
        '''Properties for ``NetworkPolicy``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param egress: Egress traffic configuration. Default: - the policy doesn't change egress behavior of the pods it selects.
        :param ingress: Ingress traffic configuration. Default: - the policy doesn't change ingress behavior of the pods it selects.
        :param selector: Which pods does this policy object applies to. This can either be a single pod / workload, or a grouping of pods selected via the ``Pods.select`` function. Rules is applied to any pods selected by this property. Multiple network policies can select the same set of pods. In this case, the rules for each are combined additively. Note that Default: - will select all pods in the namespace of the policy.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(egress, dict):
            egress = NetworkPolicyTraffic(**egress)
        if isinstance(ingress, dict):
            ingress = NetworkPolicyTraffic(**ingress)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__196bbf4228c0fcada7727ceea98961e385fd5de91bb23ec3116b35d62333f3ab)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument egress", value=egress, expected_type=type_hints["egress"])
            check_type(argname="argument ingress", value=ingress, expected_type=type_hints["ingress"])
            check_type(argname="argument selector", value=selector, expected_type=type_hints["selector"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if egress is not None:
            self._values["egress"] = egress
        if ingress is not None:
            self._values["ingress"] = ingress
        if selector is not None:
            self._values["selector"] = selector

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def egress(self) -> typing.Optional[NetworkPolicyTraffic]:
        '''Egress traffic configuration.

        :default: - the policy doesn't change egress behavior of the pods it selects.
        '''
        result = self._values.get("egress")
        return typing.cast(typing.Optional[NetworkPolicyTraffic], result)

    @builtins.property
    def ingress(self) -> typing.Optional[NetworkPolicyTraffic]:
        '''Ingress traffic configuration.

        :default: - the policy doesn't change ingress behavior of the pods it selects.
        '''
        result = self._values.get("ingress")
        return typing.cast(typing.Optional[NetworkPolicyTraffic], result)

    @builtins.property
    def selector(self) -> typing.Optional[IPodSelector]:
        '''Which pods does this policy object applies to.

        This can either be a single pod / workload, or a grouping of pods selected
        via the ``Pods.select`` function. Rules is applied to any pods selected by this property.
        Multiple network policies can select the same set of pods.
        In this case, the rules for each are combined additively.

        Note that

        :default: - will select all pods in the namespace of the policy.
        '''
        result = self._values.get("selector")
        return typing.cast(typing.Optional[IPodSelector], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkPolicyProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IPersistentVolume, IStorage)
class PersistentVolume(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.PersistentVolume",
):
    '''A PersistentVolume (PV) is a piece of storage in the cluster that has been provisioned by an administrator or dynamically provisioned using Storage Classes.

    It is a resource in the cluster just like a node is a cluster resource.
    PVs are volume plugins like Volumes, but have a lifecycle independent of any
    individual Pod that uses the PV. This API object captures the details of the
    implementation of the storage, be that NFS, iSCSI, or a
    cloud-provider-specific storage system.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77bf09dabe0779d240553fa8cd29969eed29dc2d7f08b95cd8333d248c99dec2)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PersistentVolumeProps(
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromPersistentVolumeName")
    @builtins.classmethod
    def from_persistent_volume_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        volume_name: builtins.str,
    ) -> IPersistentVolume:
        '''Imports a pv from the cluster as a reference.

        :param scope: -
        :param id: -
        :param volume_name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5cf04ec188ef8f82476326ebefd01c53fa08c05c2184a667e94b96cabd3fe9d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument volume_name", value=volume_name, expected_type=type_hints["volume_name"])
        return typing.cast(IPersistentVolume, jsii.sinvoke(cls, "fromPersistentVolumeName", [scope, id, volume_name]))

    @jsii.member(jsii_name="asVolume")
    def as_volume(self) -> Volume:
        '''Convert the piece of storage into a concrete volume.'''
        return typing.cast(Volume, jsii.invoke(self, "asVolume", []))

    @jsii.member(jsii_name="bind")
    def bind(self, claim: IPersistentVolumeClaim) -> None:
        '''Bind a volume to a specific claim.

        Note that you must also bind the claim to the volume.

        :param claim: The PVC to bind to.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__98fcbb2124c77402f8144e0bac606a30a0f10a2e68bee90a68d7377e701b0800)
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
        return typing.cast(None, jsii.invoke(self, "bind", [claim]))

    @jsii.member(jsii_name="reserve")
    def reserve(self) -> "PersistentVolumeClaim":
        '''Reserve a ``PersistentVolume`` by creating a ``PersistentVolumeClaim`` that is wired to claim this volume.

        Note that this method will throw in case the volume is already claimed.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#reserving-a-persistentvolume
        '''
        return typing.cast("PersistentVolumeClaim", jsii.invoke(self, "reserve", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="mode")
    def mode(self) -> PersistentVolumeMode:
        '''Volume mode of this volume.'''
        return typing.cast(PersistentVolumeMode, jsii.get(self, "mode"))

    @builtins.property
    @jsii.member(jsii_name="reclaimPolicy")
    def reclaim_policy(self) -> PersistentVolumeReclaimPolicy:
        '''Reclaim policy of this volume.'''
        return typing.cast(PersistentVolumeReclaimPolicy, jsii.get(self, "reclaimPolicy"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="accessModes")
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Access modes requirement of this claim.'''
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], jsii.get(self, "accessModes"))

    @builtins.property
    @jsii.member(jsii_name="claim")
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''PVC this volume is bound to.

        Undefined means this volume is not yet
        claimed by any PVC.
        '''
        return typing.cast(typing.Optional[IPersistentVolumeClaim], jsii.get(self, "claim"))

    @builtins.property
    @jsii.member(jsii_name="mountOptions")
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''Mount options of this volume.'''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "mountOptions"))

    @builtins.property
    @jsii.member(jsii_name="storage")
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Storage size of this volume.'''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], jsii.get(self, "storage"))

    @builtins.property
    @jsii.member(jsii_name="storageClassName")
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Storage class this volume belongs to.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "storageClassName"))


@jsii.implements(IPersistentVolumeClaim)
class PersistentVolumeClaim(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.PersistentVolumeClaim",
):
    '''A PersistentVolumeClaim (PVC) is a request for storage by a user.

    It is similar to a Pod. Pods consume node resources and PVCs consume PV resources.
    Pods can request specific levels of resources (CPU and Memory).
    Claims can request specific size and access modes
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume: typing.Optional[IPersistentVolume] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param access_modes: Contains the access modes the volume should support. Default: - No access modes requirement.
        :param storage: Minimum storage size the volume should have. Default: - No storage requirement.
        :param storage_class_name: Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:. - If the admission plugin is turned on, the storage class marked as default will be used. - If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class. Default: - Not set.
        :param volume: The PersistentVolume backing this claim. The control plane still checks that storage class, access modes, and requested storage size on the volume are valid. Note that in order to guarantee a proper binding, the volume should also define a ``claimRef`` referring to this claim. Otherwise, the volume may be claimed be other pvc's before it gets a chance to bind to this one. If the volume is managed (i.e not imported), you can use ``pv.claim()`` to easily create a bi-directional bounded claim. Default: - No specific volume binding.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__582bce90fc8f918c2077c07b626f7ffb1111db419e858bf64c055385d97121d8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PersistentVolumeClaimProps(
            access_modes=access_modes,
            storage=storage,
            storage_class_name=storage_class_name,
            volume=volume,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromClaimName")
    @builtins.classmethod
    def from_claim_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        claim_name: builtins.str,
    ) -> IPersistentVolumeClaim:
        '''Imports a pvc from the cluster as a reference.

        :param scope: -
        :param id: -
        :param claim_name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3ea56bd8c086755fd54395d0cf08403a6ae325a78f74e42bd4297dede511739a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument claim_name", value=claim_name, expected_type=type_hints["claim_name"])
        return typing.cast(IPersistentVolumeClaim, jsii.sinvoke(cls, "fromClaimName", [scope, id, claim_name]))

    @jsii.member(jsii_name="bind")
    def bind(self, vol: IPersistentVolume) -> None:
        '''Bind a claim to a specific volume.

        Note that you must also bind the volume to the claim.

        :param vol: The PV to bind to.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fa955d96df83e910928ce1f12ca2451b9d5a44d67183a259f86b99a0536fa6e1)
            check_type(argname="argument vol", value=vol, expected_type=type_hints["vol"])
        return typing.cast(None, jsii.invoke(self, "bind", [vol]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="volumeMode")
    def volume_mode(self) -> PersistentVolumeMode:
        '''Volume mode requirement of this claim.'''
        return typing.cast(PersistentVolumeMode, jsii.get(self, "volumeMode"))

    @builtins.property
    @jsii.member(jsii_name="accessModes")
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Access modes requirement of this claim.'''
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], jsii.get(self, "accessModes"))

    @builtins.property
    @jsii.member(jsii_name="storage")
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Storage requirement of this claim.'''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], jsii.get(self, "storage"))

    @builtins.property
    @jsii.member(jsii_name="storageClassName")
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Storage class requirment of this claim.'''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "storageClassName"))

    @builtins.property
    @jsii.member(jsii_name="volume")
    def volume(self) -> typing.Optional[IPersistentVolume]:
        '''PV this claim is bound to.

        Undefined means the claim is not bound
        to any specific volume.
        '''
        return typing.cast(typing.Optional[IPersistentVolume], jsii.get(self, "volume"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PersistentVolumeClaimProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume": "volume",
        "volume_mode": "volumeMode",
    },
)
class PersistentVolumeClaimProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume: typing.Optional[IPersistentVolume] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
    ) -> None:
        '''Properties for ``PersistentVolumeClaim``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains the access modes the volume should support. Default: - No access modes requirement.
        :param storage: Minimum storage size the volume should have. Default: - No storage requirement.
        :param storage_class_name: Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:. - If the admission plugin is turned on, the storage class marked as default will be used. - If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class. Default: - Not set.
        :param volume: The PersistentVolume backing this claim. The control plane still checks that storage class, access modes, and requested storage size on the volume are valid. Note that in order to guarantee a proper binding, the volume should also define a ``claimRef`` referring to this claim. Otherwise, the volume may be claimed be other pvc's before it gets a chance to bind to this one. If the volume is managed (i.e not imported), you can use ``pv.claim()`` to easily create a bi-directional bounded claim. Default: - No specific volume binding.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8e056d97c620415f48651a436e9a3fc1598bf20479626e85f8690ddf22ec8f4a)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume", value=volume, expected_type=type_hints["volume"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume is not None:
            self._values["volume"] = volume
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains the access modes the volume should support.

        :default: - No access modes requirement.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''Minimum storage size the volume should have.

        :default: - No storage requirement.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of the StorageClass required by the claim. When this property is not set, the behavior is as follows:.

        - If the admission plugin is turned on, the storage class marked as default will be used.
        - If the admission plugin is turned off, the pvc can only be bound to volumes without a storage class.

        :default: - Not set.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume(self) -> typing.Optional[IPersistentVolume]:
        '''The PersistentVolume backing this claim.

        The control plane still checks that storage class, access modes,
        and requested storage size on the volume are valid.

        Note that in order to guarantee a proper binding, the volume should
        also define a ``claimRef`` referring to this claim. Otherwise, the volume may be
        claimed be other pvc's before it gets a chance to bind to this one.

        If the volume is managed (i.e not imported), you can use ``pv.claim()`` to easily
        create a bi-directional bounded claim.

        :default: - No specific volume binding.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#binding.
        '''
        result = self._values.get("volume")
        return typing.cast(typing.Optional[IPersistentVolume], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PersistentVolumeClaimProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PersistentVolumeProps",
    jsii_struct_bases=[ResourceProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
    },
)
class PersistentVolumeProps(ResourceProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
    ) -> None:
        '''Properties for ``PersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__547da9f3e0db57034dcb6166322888c2027fba8dc249c608531e2de3f4be5396)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Pod(AbstractPod, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Pod"):
    '''Pod is a collection of containers that can run on a host.

    This resource is
    created by clients and scheduled onto hosts.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd98bdba554794c5ac6a185996c349343deddb223fc21a47de708e2c601e63bd)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PodProps(
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.python.classproperty
    @jsii.member(jsii_name="ADDRESS_LABEL")
    def ADDRESS_LABEL(cls) -> builtins.str:
        '''This label is autoamtically added by cdk8s to any pod.

        It provides
        a unique and stable identifier for the pod.
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "ADDRESS_LABEL"))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="connections")
    def connections(self) -> PodConnections:
        return typing.cast(PodConnections, jsii.get(self, "connections"))

    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "podMetadata"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="scheduling")
    def scheduling(self) -> PodScheduling:
        return typing.cast(PodScheduling, jsii.get(self, "scheduling"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.PodProps",
    jsii_struct_bases=[AbstractPodProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "volumes": "volumes",
    },
)
class PodProps(AbstractPodProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
    ) -> None:
        '''Properties for ``Pod``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e5fb08ea3cae4f9ff7173259d5247a4a994252f41fc565289210f748cbccd63c)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if volumes is not None:
            self._values["volumes"] = volumes

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[DockerConfigSecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[DockerConfigSecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PodProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.SecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "string_data": "stringData",
        "type": "type",
    },
)
class SecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        string_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Options for ``Secret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param string_data: stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.
        :param type: Optional type associated with the secret. Used to facilitate programmatic handling of secret data by various controllers. Default: undefined - Don't set a type.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7ea3cc675d91e881f639526079df31b61a783b4a6643743c8203331c1617f4ba)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument string_data", value=string_data, expected_type=type_hints["string_data"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable
        if string_data is not None:
            self._values["string_data"] = string_data
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def string_data(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''stringData allows specifying non-binary secret data in string form.

        It is
        provided as a write-only convenience method. All keys and values are merged
        into the data field on write, overwriting any existing values. It is never
        output when reading from the API.
        '''
        result = self._values.get("string_data")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''Optional type associated with the secret.

        Used to facilitate programmatic
        handling of secret data by various controllers.

        :default: undefined - Don't set a type.
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IServiceAccount, ISubject)
class ServiceAccount(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.ServiceAccount",
):
    '''A service account provides an identity for processes that run in a Pod.

    When you (a human) access the cluster (for example, using kubectl), you are
    authenticated by the apiserver as a particular User Account (currently this
    is usually admin, unless your cluster administrator has customized your
    cluster). Processes in containers inside pods can also contact the apiserver.
    When they do, they are authenticated as a particular Service Account (for
    example, default).

    :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        automount_token: typing.Optional[builtins.bool] = None,
        secrets: typing.Optional[typing.Sequence[ISecret]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param automount_token: Indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level. Default: false
        :param secrets: List of secrets allowed to be used by pods running using this ServiceAccount.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__996f29d9854614b905672f117853322a72d82ab1e35d403e5682464c7fd1a199)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ServiceAccountProps(
            automount_token=automount_token, secrets=secrets, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromServiceAccountName")
    @builtins.classmethod
    def from_service_account_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
        *,
        namespace_name: typing.Optional[builtins.str] = None,
    ) -> IServiceAccount:
        '''Imports a service account from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: The name of the service account resource.
        :param namespace_name: The name of the namespace the service account belongs to. Default: "default"
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__61bd4efa559d1f872c7237b7e2d2372580841c768fe688587982edade83e3c48)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        options = FromServiceAccountNameOptions(namespace_name=namespace_name)

        return typing.cast(IServiceAccount, jsii.sinvoke(cls, "fromServiceAccountName", [scope, id, name, options]))

    @jsii.member(jsii_name="addSecret")
    def add_secret(self, secr: ISecret) -> None:
        '''Allow a secret to be accessed by pods using this service account.

        :param secr: The secret.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__befa4c49f190858e99101b3413915a78d6354ce964072f700e0832c4d2debd0c)
            check_type(argname="argument secr", value=secr, expected_type=type_hints["secr"])
        return typing.cast(None, jsii.invoke(self, "addSecret", [secr]))

    @jsii.member(jsii_name="toSubjectConfiguration")
    def to_subject_configuration(self) -> SubjectConfiguration:
        '''Return the subject configuration.

        :see: ISubect.toSubjectConfiguration()
        '''
        return typing.cast(SubjectConfiguration, jsii.invoke(self, "toSubjectConfiguration", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="automountToken")
    def automount_token(self) -> builtins.bool:
        '''Whether or not a token is automatically mounted for this service account.'''
        return typing.cast(builtins.bool, jsii.get(self, "automountToken"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="secrets")
    def secrets(self) -> typing.List[ISecret]:
        '''List of secrets allowed to be used by pods running using this service account.

        Returns a copy. To add a secret, use ``addSecret()``.
        '''
        return typing.cast(typing.List[ISecret], jsii.get(self, "secrets"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.ServiceAccountTokenSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "service_account": "serviceAccount",
    },
)
class ServiceAccountTokenSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        service_account: IServiceAccount,
    ) -> None:
        '''Options for ``ServiceAccountTokenSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param service_account: The service account to store a secret for.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab4be016a6d534a8bd18d5f73dba8e84225b7ccad5538167a88c7451918e54c3)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "service_account": service_account,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def service_account(self) -> IServiceAccount:
        '''The service account to store a secret for.'''
        result = self._values.get("service_account")
        assert result is not None, "Required property 'service_account' is missing"
        return typing.cast(IServiceAccount, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ServiceAccountTokenSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.SshAuthSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "ssh_private_key": "sshPrivateKey",
    },
)
class SshAuthSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        ssh_private_key: builtins.str,
    ) -> None:
        '''Options for ``SshAuthSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param ssh_private_key: The SSH private key to use.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__42fbd0dfcc70d00a5825cc0d151d6422664c02e13dc009d93ce72dd4aebac780)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument ssh_private_key", value=ssh_private_key, expected_type=type_hints["ssh_private_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "ssh_private_key": ssh_private_key,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def ssh_private_key(self) -> builtins.str:
        '''The SSH private key to use.'''
        result = self._values.get("ssh_private_key")
        assert result is not None, "Required property 'ssh_private_key' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SshAuthSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.TlsSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "tls_cert": "tlsCert",
        "tls_key": "tlsKey",
    },
)
class TlsSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        tls_cert: builtins.str,
        tls_key: builtins.str,
    ) -> None:
        '''Options for ``TlsSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param tls_cert: The TLS cert.
        :param tls_key: The TLS key.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3bb14247719e317d6c0fae6385211b74b786d0544a6440f4d2fc77bcca61ef89)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument tls_cert", value=tls_cert, expected_type=type_hints["tls_cert"])
            check_type(argname="argument tls_key", value=tls_key, expected_type=type_hints["tls_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "tls_cert": tls_cert,
            "tls_key": tls_key,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def tls_cert(self) -> builtins.str:
        '''The TLS cert.'''
        result = self._values.get("tls_cert")
        assert result is not None, "Required property 'tls_cert' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def tls_key(self) -> builtins.str:
        '''The TLS key.'''
        result = self._values.get("tls_key")
        assert result is not None, "Required property 'tls_key' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TlsSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Workload(
    AbstractPod,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk8s-plus-23.Workload",
):
    '''A workload is an application running on Kubernetes.

    Whether your workload is a single
    component or several that work together, on Kubernetes you run it inside a set of pods.
    In Kubernetes, a Pod represents a set of running containers on your cluster.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8dd9eae79f6cea88c9831569e4436a3444d2b97f6e18538ec2f8953f0a8cf006)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = WorkloadProps(
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="select")
    def select(self, *selectors: LabelSelector) -> None:
        '''Configure selectors for this workload.

        :param selectors: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__857f4a61a3103118d33754f262fc644b01177948ac4fe2f43d589442e538749f)
            check_type(argname="argument selectors", value=selectors, expected_type=typing.Tuple[type_hints["selectors"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "select", [*selectors]))

    @builtins.property
    @jsii.member(jsii_name="connections")
    def connections(self) -> PodConnections:
        return typing.cast(PodConnections, jsii.get(self, "connections"))

    @builtins.property
    @jsii.member(jsii_name="matchExpressions")
    def match_expressions(self) -> typing.List[LabelSelectorRequirement]:
        '''The expression matchers this workload will use in order to select pods.

        Returns a a copy. Use ``select()`` to add expression matchers.
        '''
        return typing.cast(typing.List[LabelSelectorRequirement], jsii.get(self, "matchExpressions"))

    @builtins.property
    @jsii.member(jsii_name="matchLabels")
    def match_labels(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''The label matchers this workload will use in order to select pods.

        Returns a a copy. Use ``select()`` to add label matchers.
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "matchLabels"))

    @builtins.property
    @jsii.member(jsii_name="podMetadata")
    def pod_metadata(self) -> _cdk8s_d3d9af27.ApiObjectMetadataDefinition:
        '''The metadata of pods in this workload.'''
        return typing.cast(_cdk8s_d3d9af27.ApiObjectMetadataDefinition, jsii.get(self, "podMetadata"))

    @builtins.property
    @jsii.member(jsii_name="scheduling")
    def scheduling(self) -> WorkloadScheduling:
        return typing.cast(WorkloadScheduling, jsii.get(self, "scheduling"))


class _WorkloadProxy(
    Workload,
    jsii.proxy_for(AbstractPod), # type: ignore[misc]
):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, Workload).__jsii_proxy_class__ = lambda : _WorkloadProxy


@jsii.data_type(
    jsii_type="cdk8s-plus-23.WorkloadProps",
    jsii_struct_bases=[AbstractPodProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
    },
)
class WorkloadProps(AbstractPodProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``Workload``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e5c89864c1f0ba79a46ac607d4408ba99352c41b2eff7a8e5279b148c6da44b2)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[DockerConfigSecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[DockerConfigSecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "WorkloadProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AwsElasticBlockStorePersistentVolume(
    PersistentVolume,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.AwsElasticBlockStorePersistentVolume",
):
    '''Represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod.

    :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param volume_id: Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0baac8f4ddd172f9b0cb46f708421eb9b95d23028324f8289908da6d11c0e781)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AwsElasticBlockStorePersistentVolumeProps(
            volume_id=volume_id,
            fs_type=fs_type,
            partition=partition,
            read_only=read_only,
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="fsType")
    def fs_type(self) -> builtins.str:
        '''File system type of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "fsType"))

    @builtins.property
    @jsii.member(jsii_name="readOnly")
    def read_only(self) -> builtins.bool:
        '''Whether or not it is mounted as a read-only volume.'''
        return typing.cast(builtins.bool, jsii.get(self, "readOnly"))

    @builtins.property
    @jsii.member(jsii_name="volumeId")
    def volume_id(self) -> builtins.str:
        '''Volume id of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "volumeId"))

    @builtins.property
    @jsii.member(jsii_name="partition")
    def partition(self) -> typing.Optional[jsii.Number]:
        '''Partition of this volume.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "partition"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.AwsElasticBlockStorePersistentVolumeProps",
    jsii_struct_bases=[PersistentVolumeProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "volume_id": "volumeId",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class AwsElasticBlockStorePersistentVolumeProps(PersistentVolumeProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        volume_id: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``AwsElasticBlockStorePersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param volume_id: Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8773a48c4e36b427c7e5f0f99746b88f892dbed0e229fb2a566cbf639472777f)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument volume_id", value=volume_id, expected_type=type_hints["volume_id"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "volume_id": volume_id,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    @builtins.property
    def volume_id(self) -> builtins.str:
        '''Unique ID of the persistent disk resource in AWS (Amazon EBS volume).

        More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("volume_id")
        assert result is not None, "Required property 'volume_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsElasticBlockStorePersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AzureDiskPersistentVolume(
    PersistentVolume,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.AzureDiskPersistentVolume",
):
    '''AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        read_only: typing.Optional[builtins.bool] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param disk_name: The Name of the data disk in the blob storage.
        :param disk_uri: The URI the data disk in the blob storage.
        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5443ef7b4fa7aa15e28240c0f0390a25c63efbe0ae4963c390535faba5922219)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AzureDiskPersistentVolumeProps(
            disk_name=disk_name,
            disk_uri=disk_uri,
            caching_mode=caching_mode,
            fs_type=fs_type,
            kind=kind,
            read_only=read_only,
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="azureKind")
    def azure_kind(self) -> AzureDiskPersistentVolumeKind:
        '''Azure kind of this volume.'''
        return typing.cast(AzureDiskPersistentVolumeKind, jsii.get(self, "azureKind"))

    @builtins.property
    @jsii.member(jsii_name="cachingMode")
    def caching_mode(self) -> AzureDiskPersistentVolumeCachingMode:
        '''Caching mode of this volume.'''
        return typing.cast(AzureDiskPersistentVolumeCachingMode, jsii.get(self, "cachingMode"))

    @builtins.property
    @jsii.member(jsii_name="diskName")
    def disk_name(self) -> builtins.str:
        '''Disk name of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "diskName"))

    @builtins.property
    @jsii.member(jsii_name="diskUri")
    def disk_uri(self) -> builtins.str:
        '''Disk URI of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "diskUri"))

    @builtins.property
    @jsii.member(jsii_name="fsType")
    def fs_type(self) -> builtins.str:
        '''File system type of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "fsType"))

    @builtins.property
    @jsii.member(jsii_name="readOnly")
    def read_only(self) -> builtins.bool:
        '''Whether or not it is mounted as a read-only volume.'''
        return typing.cast(builtins.bool, jsii.get(self, "readOnly"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.AzureDiskPersistentVolumeProps",
    jsii_struct_bases=[PersistentVolumeProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "disk_name": "diskName",
        "disk_uri": "diskUri",
        "caching_mode": "cachingMode",
        "fs_type": "fsType",
        "kind": "kind",
        "read_only": "readOnly",
    },
)
class AzureDiskPersistentVolumeProps(PersistentVolumeProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        disk_name: builtins.str,
        disk_uri: builtins.str,
        caching_mode: typing.Optional[AzureDiskPersistentVolumeCachingMode] = None,
        fs_type: typing.Optional[builtins.str] = None,
        kind: typing.Optional[AzureDiskPersistentVolumeKind] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``AzureDiskPersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param disk_name: The Name of the data disk in the blob storage.
        :param disk_uri: The URI the data disk in the blob storage.
        :param caching_mode: Host Caching mode. Default: - AzureDiskPersistentVolumeCachingMode.NONE.
        :param fs_type: Filesystem type to mount. Must be a filesystem type supported by the host operating system. Default: 'ext4'
        :param kind: Kind of disk. Default: AzureDiskPersistentVolumeKind.SHARED
        :param read_only: Force the ReadOnly setting in VolumeMounts. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59bf2637afc8a1f1aa9f3261c8110f67107fba41c8ff2c29863428724912ca83)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument disk_name", value=disk_name, expected_type=type_hints["disk_name"])
            check_type(argname="argument disk_uri", value=disk_uri, expected_type=type_hints["disk_uri"])
            check_type(argname="argument caching_mode", value=caching_mode, expected_type=type_hints["caching_mode"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "disk_name": disk_name,
            "disk_uri": disk_uri,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if caching_mode is not None:
            self._values["caching_mode"] = caching_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if kind is not None:
            self._values["kind"] = kind
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    @builtins.property
    def disk_name(self) -> builtins.str:
        '''The Name of the data disk in the blob storage.'''
        result = self._values.get("disk_name")
        assert result is not None, "Required property 'disk_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def disk_uri(self) -> builtins.str:
        '''The URI the data disk in the blob storage.'''
        result = self._values.get("disk_uri")
        assert result is not None, "Required property 'disk_uri' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def caching_mode(self) -> typing.Optional[AzureDiskPersistentVolumeCachingMode]:
        '''Host Caching mode.

        :default: - AzureDiskPersistentVolumeCachingMode.NONE.
        '''
        result = self._values.get("caching_mode")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeCachingMode], result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type to mount.

        Must be a filesystem type supported by the host operating system.

        :default: 'ext4'
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kind(self) -> typing.Optional[AzureDiskPersistentVolumeKind]:
        '''Kind of disk.

        :default: AzureDiskPersistentVolumeKind.SHARED
        '''
        result = self._values.get("kind")
        return typing.cast(typing.Optional[AzureDiskPersistentVolumeKind], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Force the ReadOnly setting in VolumeMounts.

        :default: false
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzureDiskPersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.BasicAuthSecretProps",
    jsii_struct_bases=[CommonSecretProps],
    name_mapping={
        "metadata": "metadata",
        "immutable": "immutable",
        "password": "password",
        "username": "username",
    },
)
class BasicAuthSecretProps(CommonSecretProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        password: builtins.str,
        username: builtins.str,
    ) -> None:
        '''Options for ``BasicAuthSecret``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param immutable: If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param password: The password or token for authentication.
        :param username: The user name for authentication.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d8c073ef6c766be75571b1b6830a3c5776b5844a902b38b27379aefa285b9290)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument immutable", value=immutable, expected_type=type_hints["immutable"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "password": password,
            "username": username,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if immutable is not None:
            self._values["immutable"] = immutable

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def immutable(self) -> typing.Optional[builtins.bool]:
        '''If set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified).

        If not set to true, the field can be modified at any time.

        :default: false
        '''
        result = self._values.get("immutable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def password(self) -> builtins.str:
        '''The password or token for authentication.'''
        result = self._values.get("password")
        assert result is not None, "Required property 'password' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def username(self) -> builtins.str:
        '''The user name for authentication.'''
        result = self._values.get("username")
        assert result is not None, "Required property 'username' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BasicAuthSecretProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IClusterRole, IRole)
class ClusterRole(
    Resource,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.ClusterRole",
):
    '''ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        aggregation_labels: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        rules: typing.Optional[typing.Sequence[typing.Union[ClusterRolePolicyRule, typing.Dict[builtins.str, typing.Any]]]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param aggregation_labels: Specify labels that should be used to locate ClusterRoles, whose rules will be automatically filled into this ClusterRole's rules.
        :param rules: A list of rules the role should allow. Default: []
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__028c525b64bae25a01aa05e0b5c1eaa3c687f4ced50d9a3641925db8f3f2ebe8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ClusterRoleProps(
            aggregation_labels=aggregation_labels, rules=rules, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromClusterRoleName")
    @builtins.classmethod
    def from_cluster_role_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> IClusterRole:
        '''Imports a role from the cluster as a reference.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c3bf11b171f48d0ba6fb33d74fa1d8ac328089a5d8ed170635944d8a9b23ad3)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(IClusterRole, jsii.sinvoke(cls, "fromClusterRoleName", [scope, id, name]))

    @jsii.member(jsii_name="aggregate")
    def aggregate(self, key: builtins.str, value: builtins.str) -> None:
        '''Aggregate rules from roles matching this label selector.

        :param key: -
        :param value: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ea0384c76a5006c3c061904e7733164d496d7ef764379ba2b923ca9b6dd9f71)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "aggregate", [key, value]))

    @jsii.member(jsii_name="allow")
    def allow(
        self,
        verbs: typing.Sequence[builtins.str],
        *endpoints: IApiEndpoint,
    ) -> None:
        '''Add permission to perform a list of HTTP verbs on a collection of resources.

        :param verbs: -
        :param endpoints: The endpoints(s) to apply to.

        :see: https://kubernetes.io/docs/reference/access-authn-authz/authorization/#determine-the-request-verb
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8d1ba65d0455c7882102a18f8bdb1b819d55b4a4d528b4ceacea6465c90eb614)
            check_type(argname="argument verbs", value=verbs, expected_type=type_hints["verbs"])
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allow", [verbs, *endpoints]))

    @jsii.member(jsii_name="allowCreate")
    def allow_create(self, *endpoints: IApiEndpoint) -> None:
        '''Add "create" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8de9fa4f4232eddc685c8b4a4f167303f08e1bb4ff96f134876dfdbf6960c17)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowCreate", [*endpoints]))

    @jsii.member(jsii_name="allowDelete")
    def allow_delete(self, *endpoints: IApiEndpoint) -> None:
        '''Add "delete" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0e5cd06cc520cd7b37b936c6960517821f178122c83ff6c0ab773221c82e677)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDelete", [*endpoints]))

    @jsii.member(jsii_name="allowDeleteCollection")
    def allow_delete_collection(self, *endpoints: IApiEndpoint) -> None:
        '''Add "deletecollection" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fbc2c629cd74b3ad9c78d79a6502782bb2cb85886537d66cd97d577c45175df6)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowDeleteCollection", [*endpoints]))

    @jsii.member(jsii_name="allowGet")
    def allow_get(self, *endpoints: IApiEndpoint) -> None:
        '''Add "get" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ebb91982f3ce9ab9598b24995c2c83fa7fc31929b9f0951c399373ce70e2b58)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowGet", [*endpoints]))

    @jsii.member(jsii_name="allowList")
    def allow_list(self, *endpoints: IApiEndpoint) -> None:
        '''Add "list" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cb349724bdccbb1619160b7e8f6f5853603c8d0744d591f826dca8fc73f49d03)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowList", [*endpoints]))

    @jsii.member(jsii_name="allowPatch")
    def allow_patch(self, *endpoints: IApiEndpoint) -> None:
        '''Add "patch" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5af99061b9731ccc969251c3d2fa7e3f8a242d4e07a62c0e1f7197b64a26218)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowPatch", [*endpoints]))

    @jsii.member(jsii_name="allowRead")
    def allow_read(self, *endpoints: IApiEndpoint) -> None:
        '''Add "get", "list", and "watch" permissions for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__115f2201e2c491d7f32b17d41abbd94e687a6826aecbc6b9da612dbe70dc1b8d)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowRead", [*endpoints]))

    @jsii.member(jsii_name="allowReadWrite")
    def allow_read_write(self, *endpoints: IApiEndpoint) -> None:
        '''Add "get", "list", "watch", "create", "update", "patch", "delete", and "deletecollection" permissions for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__865fa9665416c1eaed5417d7b7ed3ac4b193c95503a8886bf7b9806fca1853c9)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowReadWrite", [*endpoints]))

    @jsii.member(jsii_name="allowUpdate")
    def allow_update(self, *endpoints: IApiEndpoint) -> None:
        '''Add "update" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c8c562672fe69ef9da5bda409cb444d1b9afdcbedf096ee7ac05a97cc09621a)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowUpdate", [*endpoints]))

    @jsii.member(jsii_name="allowWatch")
    def allow_watch(self, *endpoints: IApiEndpoint) -> None:
        '''Add "watch" permission for the resources.

        :param endpoints: The resource(s) to apply to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cc603c873e93a4966be760cb393c2b18213fb352920ffcfebb6ca752f9878d3a)
            check_type(argname="argument endpoints", value=endpoints, expected_type=typing.Tuple[type_hints["endpoints"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(None, jsii.invoke(self, "allowWatch", [*endpoints]))

    @jsii.member(jsii_name="bind")
    def bind(self, *subjects: ISubject) -> ClusterRoleBinding:
        '''Create a ClusterRoleBinding that binds the permissions in this ClusterRole to a list of subjects, without namespace restrictions.

        :param subjects: a list of subjects to bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e20e1f2e5f8c6771fcb895ed80ad42296814f3fc26f467adc1535e370a74cc7e)
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(ClusterRoleBinding, jsii.invoke(self, "bind", [*subjects]))

    @jsii.member(jsii_name="bindInNamespace")
    def bind_in_namespace(
        self,
        namespace: builtins.str,
        *subjects: ISubject,
    ) -> RoleBinding:
        '''Create a RoleBinding that binds the permissions in this ClusterRole to a list of subjects, that will only apply to the given namespace.

        :param namespace: the namespace to limit permissions to.
        :param subjects: a list of subjects to bind to.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3372d4f7d8bfa9a33225f4d284fecb10aeb8503c84dd29d988686f1d2e16a73f)
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument subjects", value=subjects, expected_type=typing.Tuple[type_hints["subjects"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(RoleBinding, jsii.invoke(self, "bindInNamespace", [namespace, *subjects]))

    @jsii.member(jsii_name="combine")
    def combine(self, rol: "ClusterRole") -> None:
        '''Combines the rules of the argument ClusterRole into this ClusterRole using aggregation labels.

        :param rol: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47f3b15b5a11cab1150635f30d572a141464b5a9118672b7471971f925715177)
            check_type(argname="argument rol", value=rol, expected_type=type_hints["rol"])
        return typing.cast(None, jsii.invoke(self, "combine", [rol]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="rules")
    def rules(self) -> typing.List[ClusterRolePolicyRule]:
        '''Rules associaated with this Role.

        Returns a copy, use ``allow`` to add rules.
        '''
        return typing.cast(typing.List[ClusterRolePolicyRule], jsii.get(self, "rules"))


@jsii.implements(IConfigMap)
class ConfigMap(Resource, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.ConfigMap"):
    '''ConfigMap holds configuration data for pods to consume.'''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        binary_data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        data: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        immutable: typing.Optional[builtins.bool] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. You can also add binary data using ``configMap.addBinaryData()``.
        :param data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process. You can also add data using ``configMap.addData()``.
        :param immutable: If set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Default: false
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7eb48c8955a35a1d3238fcc4f09c3c363fe59673425da7213f059cfff7a7f3c8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ConfigMapProps(
            binary_data=binary_data, data=data, immutable=immutable, metadata=metadata
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="fromConfigMapName")
    @builtins.classmethod
    def from_config_map_name(
        cls,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> IConfigMap:
        '''Represents a ConfigMap created elsewhere.

        :param scope: -
        :param id: -
        :param name: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__56f8eb8a9cf50e746f364ee80494195e18b4ef8344a0c2b7e334dd06928f499d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(IConfigMap, jsii.sinvoke(cls, "fromConfigMapName", [scope, id, name]))

    @jsii.member(jsii_name="addBinaryData")
    def add_binary_data(self, key: builtins.str, value: builtins.str) -> None:
        '''Adds a binary data entry to the config map.

        BinaryData can contain byte
        sequences that are not in the UTF-8 range.

        :param key: The key.
        :param value: The value.

        :throws: if there is either a ``data`` or ``binaryData`` entry with the same key
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dff7d47d8acd55ad93917750a0c67c5cd2d229061994dea5698add9db6904d5b)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addBinaryData", [key, value]))

    @jsii.member(jsii_name="addData")
    def add_data(self, key: builtins.str, value: builtins.str) -> None:
        '''Adds a data entry to the config map.

        :param key: The key.
        :param value: The value.

        :throws: if there is either a ``data`` or ``binaryData`` entry with the same key
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__431055a710c99379f73838b501c5af68c3a0cee3a00671dd56634c988030f653)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addData", [key, value]))

    @jsii.member(jsii_name="addDirectory")
    def add_directory(
        self,
        local_dir: builtins.str,
        *,
        exclude: typing.Optional[typing.Sequence[builtins.str]] = None,
        key_prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Adds a directory to the ConfigMap.

        :param local_dir: A path to a local directory.
        :param exclude: Glob patterns to exclude when adding files. Default: - include all files
        :param key_prefix: A prefix to add to all keys in the config map. Default: ""
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bc30d8ca7b8b12999c95f8a0c04803dac1583338a0480cb62f657e8ae482b87)
            check_type(argname="argument local_dir", value=local_dir, expected_type=type_hints["local_dir"])
        options = AddDirectoryOptions(exclude=exclude, key_prefix=key_prefix)

        return typing.cast(None, jsii.invoke(self, "addDirectory", [local_dir, options]))

    @jsii.member(jsii_name="addFile")
    def add_file(
        self,
        local_file: builtins.str,
        key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Adds a file to the ConfigMap.

        :param local_file: The path to the local file.
        :param key: The ConfigMap key (default to the file name).
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4d9a85acb693cb55dab63e4db55d6d49c7d80d61ecec1f853fe2ab57ebbf9a77)
            check_type(argname="argument local_file", value=local_file, expected_type=type_hints["local_file"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(None, jsii.invoke(self, "addFile", [local_file, key]))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="binaryData")
    def binary_data(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''The binary data associated with this config map.

        Returns a copy. To add data records, use ``addBinaryData()`` or ``addData()``.
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "binaryData"))

    @builtins.property
    @jsii.member(jsii_name="data")
    def data(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''The data associated with this config map.

        Returns an copy. To add data records, use ``addData()`` or ``addBinaryData()``.
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "data"))

    @builtins.property
    @jsii.member(jsii_name="immutable")
    def immutable(self) -> builtins.bool:
        '''Whether or not this config map is immutable.'''
        return typing.cast(builtins.bool, jsii.get(self, "immutable"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


class CronJob(Workload, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.CronJob"):
    '''A CronJob is responsible for creating a Job and scheduling it based on provided cron schedule.

    This helps running Jobs in a recurring manner.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        schedule: _cdk8s_d3d9af27.Cron,
        concurrency_policy: typing.Optional[ConcurrencyPolicy] = None,
        failed_jobs_retained: typing.Optional[jsii.Number] = None,
        starting_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        successful_jobs_retained: typing.Optional[jsii.Number] = None,
        suspend: typing.Optional[builtins.bool] = None,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param schedule: Specifies the time in which the job would run again. This is defined as a cron expression in the CronJob resource.
        :param concurrency_policy: Specifies the concurrency policy for the job. Default: ConcurrencyPolicy.Forbid
        :param failed_jobs_retained: Specifies the number of failed jobs history retained. This would retain the Job and the associated Pod resource and can be useful for debugging. Default: 1
        :param starting_deadline: Kubernetes attempts to start cron jobs at its schedule time, but this is not guaranteed. This deadline specifies how much time can pass after a schedule point, for which kubernetes can still start the job. For example, if this is set to 100 seconds, kubernetes is allowed to start the job at a maximum 100 seconds after the scheduled time. Note that the Kubernetes CronJobController checks for things every 10 seconds, for this reason, a deadline below 10 seconds is not allowed, as it may cause your job to never be scheduled. In addition, kubernetes will stop scheduling jobs if more than 100 schedules were missed (for any reason). This property also controls what time interval should kubernetes consider when counting for missed schedules. For example, suppose a CronJob is set to schedule a new Job every one minute beginning at 08:30:00, and its ``startingDeadline`` field is not set. If the CronJob controller happens to be down from 08:29:00 to 10:21:00, the job will not start as the number of missed jobs which missed their schedule is greater than 100. However, if ``startingDeadline`` is set to 200 seconds, kubernetes will only count 3 missed schedules, and thus start a new execution at 10:22:00. Default: Duration.seconds(10)
        :param successful_jobs_retained: Specifies the number of successful jobs history retained. This would retain the Job and the associated Pod resource and can be useful for debugging. Default: 3
        :param suspend: Specifies if the cron job should be suspended. Only applies to future executions, current ones are remained untouched. Default: false
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f865f319fb21757dae3e1b4e957e7f9d389738579ea127490528f4954d1262a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = CronJobProps(
            schedule=schedule,
            concurrency_policy=concurrency_policy,
            failed_jobs_retained=failed_jobs_retained,
            starting_deadline=starting_deadline,
            successful_jobs_retained=successful_jobs_retained,
            suspend=suspend,
            active_deadline=active_deadline,
            backoff_limit=backoff_limit,
            ttl_after_finished=ttl_after_finished,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="concurrencyPolicy")
    def concurrency_policy(self) -> builtins.str:
        '''The policy used by this cron job to determine the concurrency mode in which to schedule jobs.'''
        return typing.cast(builtins.str, jsii.get(self, "concurrencyPolicy"))

    @builtins.property
    @jsii.member(jsii_name="failedJobsRetained")
    def failed_jobs_retained(self) -> jsii.Number:
        '''The number of failed jobs retained by this cron job.'''
        return typing.cast(jsii.Number, jsii.get(self, "failedJobsRetained"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''Represents the resource type.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="schedule")
    def schedule(self) -> _cdk8s_d3d9af27.Cron:
        '''The schedule this cron job is scheduled to run in.'''
        return typing.cast(_cdk8s_d3d9af27.Cron, jsii.get(self, "schedule"))

    @builtins.property
    @jsii.member(jsii_name="startingDeadline")
    def starting_deadline(self) -> _cdk8s_d3d9af27.Duration:
        '''The time by which the running cron job needs to schedule the next job execution.

        The job is considered as failed if it misses this deadline.
        '''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "startingDeadline"))

    @builtins.property
    @jsii.member(jsii_name="successfulJobsRetained")
    def successful_jobs_retained(self) -> jsii.Number:
        '''The number of successful jobs retained by this cron job.'''
        return typing.cast(jsii.Number, jsii.get(self, "successfulJobsRetained"))

    @builtins.property
    @jsii.member(jsii_name="suspend")
    def suspend(self) -> builtins.bool:
        '''Whether or not the cron job is currently suspended or not.'''
        return typing.cast(builtins.bool, jsii.get(self, "suspend"))


class DaemonSet(Workload, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.DaemonSet"):
    '''A DaemonSet ensures that all (or some) Nodes run a copy of a Pod.

    As nodes are added to the cluster, Pods are added to them.
    As nodes are removed from the cluster, those Pods are garbage collected.
    Deleting a DaemonSet will clean up the Pods it created.

    Some typical uses of a DaemonSet are:

    - running a cluster storage daemon on every node
    - running a logs collection daemon on every node
    - running a node monitoring daemon on every node

    In a simple case, one DaemonSet, covering all nodes, would be used for each type of daemon.
    A more complex setup might use multiple DaemonSets for a single type of daemon,
    but with different flags and/or different memory and cpu requests for different hardware types.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        min_ready_seconds: typing.Optional[jsii.Number] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Default: 0
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0fb3bcb978727e250cb8dd320513274e02e707f01d8162be1d7072982f15e526)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = DaemonSetProps(
            min_ready_seconds=min_ready_seconds,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="minReadySeconds")
    def min_ready_seconds(self) -> jsii.Number:
        return typing.cast(jsii.Number, jsii.get(self, "minReadySeconds"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.DaemonSetProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "min_ready_seconds": "minReadySeconds",
    },
)
class DaemonSetProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        min_ready_seconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''Properties for ``DaemonSet``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Default: 0
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c7c5d9b618a5577e7c2d6cd401eb2a80ba1689e104ccdeb144d23a3cf9452a25)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument min_ready_seconds", value=min_ready_seconds, expected_type=type_hints["min_ready_seconds"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if min_ready_seconds is not None:
            self._values["min_ready_seconds"] = min_ready_seconds

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[DockerConfigSecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[DockerConfigSecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def min_ready_seconds(self) -> typing.Optional[jsii.Number]:
        '''Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        :default: 0
        '''
        result = self._values.get("min_ready_seconds")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaemonSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IScalable)
class Deployment(
    Workload,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.Deployment",
):
    '''A Deployment provides declarative updates for Pods and ReplicaSets.

    You describe a desired state in a Deployment, and the Deployment Controller changes the actual
    state to the desired state at a controlled rate. You can define Deployments to create new ReplicaSets, or to remove
    existing Deployments and adopt all their resources with new Deployments.
    .. epigraph::

       Note: Do not manage ReplicaSets owned by a Deployment. Consider opening an issue in the main Kubernetes repository if your use case is not covered below.

    Use Case

    The following are typical use cases for Deployments:

    - Create a Deployment to rollout a ReplicaSet. The ReplicaSet creates Pods in the background.
      Check the status of the rollout to see if it succeeds or not.
    - Declare the new state of the Pods by updating the PodTemplateSpec of the Deployment.
      A new ReplicaSet is created and the Deployment manages moving the Pods from the old ReplicaSet to the new one at a controlled rate.
      Each new ReplicaSet updates the revision of the Deployment.
    - Rollback to an earlier Deployment revision if the current state of the Deployment is not stable.
      Each rollback updates the revision of the Deployment.
    - Scale up the Deployment to facilitate more load.
    - Pause the Deployment to apply multiple fixes to its PodTemplateSpec and then resume it to start a new rollout.
    - Use the status of the Deployment as an indicator that a rollout has stuck.
    - Clean up older ReplicaSets that you don't need anymore.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        progress_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        replicas: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[DeploymentStrategy] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. Default: Duration.seconds(0)
        :param progress_deadline: The maximum duration for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Default: Duration.seconds(600)
        :param replicas: Number of desired pods. Default: 2
        :param strategy: Specifies the strategy used to replace old Pods by new ones. Default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b04dc9183aee525bc9acebd0c74488337718a684891d782517238cab7e002ad7)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = DeploymentProps(
            min_ready=min_ready,
            progress_deadline=progress_deadline,
            replicas=replicas,
            strategy=strategy,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="exposeViaIngress")
    def expose_via_ingress(
        self,
        path: builtins.str,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional[ServiceType] = None,
        ingress: typing.Optional[Ingress] = None,
        path_type: typing.Optional[HttpIngressPathType] = None,
    ) -> Ingress:
        '''Expose a deployment via an ingress.

        This will first expose the deployment with a service, and then expose the service via an ingress.

        :param path: The ingress path to register under.
        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        :param ingress: The ingress to add rules to. Default: - An ingress will be automatically created.
        :param path_type: The type of the path. Default: HttpIngressPathType.PREFIX
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80ea286443bc422188a502f7e018f3555646581a90bd42f751d67399564e0918)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        options = ExposeDeploymentViaIngressOptions(
            name=name,
            ports=ports,
            service_type=service_type,
            ingress=ingress,
            path_type=path_type,
        )

        return typing.cast(Ingress, jsii.invoke(self, "exposeViaIngress", [path, options]))

    @jsii.member(jsii_name="exposeViaService")
    def expose_via_service(
        self,
        *,
        name: typing.Optional[builtins.str] = None,
        ports: typing.Optional[typing.Sequence[typing.Union[ServicePort, typing.Dict[builtins.str, typing.Any]]]] = None,
        service_type: typing.Optional[ServiceType] = None,
    ) -> Service:
        '''Expose a deployment via a service.

        This is equivalent to running ``kubectl expose deployment <deployment-name>``.

        :param name: The name of the service to expose. If you'd like to expose the deployment multiple times, you must explicitly set a name starting from the second expose call. Default: - auto generated.
        :param ports: The ports that the service should bind to. Default: - extracted from the deployment.
        :param service_type: The type of the exposed service. Default: - ClusterIP.
        '''
        options = DeploymentExposeViaServiceOptions(
            name=name, ports=ports, service_type=service_type
        )

        return typing.cast(Service, jsii.invoke(self, "exposeViaService", [options]))

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.

        :see: IScalable.markHasAutoscaler()
        '''
        return typing.cast(None, jsii.invoke(self, "markHasAutoscaler", []))

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> ScalingTarget:
        '''Return the target spec properties of this Scalable.

        :see: IScalable.toScalingTarget()
        '''
        return typing.cast(ScalingTarget, jsii.invoke(self, "toScalingTarget", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="minReady")
    def min_ready(self) -> _cdk8s_d3d9af27.Duration:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.'''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "minReady"))

    @builtins.property
    @jsii.member(jsii_name="progressDeadline")
    def progress_deadline(self) -> _cdk8s_d3d9af27.Duration:
        '''The maximum duration for a deployment to make progress before it is considered to be failed.'''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "progressDeadline"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="strategy")
    def strategy(self) -> DeploymentStrategy:
        return typing.cast(DeploymentStrategy, jsii.get(self, "strategy"))

    @builtins.property
    @jsii.member(jsii_name="replicas")
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "replicas"))

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        return typing.cast(builtins.bool, jsii.get(self, "hasAutoscaler"))

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bd6a263aa5eb6a0417377c1d9fe798d7c6d22d52d36c10e42e0402f07b4173a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "hasAutoscaler", value)


@jsii.data_type(
    jsii_type="cdk8s-plus-23.DeploymentProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "min_ready": "minReady",
        "progress_deadline": "progressDeadline",
        "replicas": "replicas",
        "strategy": "strategy",
    },
)
class DeploymentProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        progress_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        replicas: typing.Optional[jsii.Number] = None,
        strategy: typing.Optional[DeploymentStrategy] = None,
    ) -> None:
        '''Properties for ``Deployment``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. Default: Duration.seconds(0)
        :param progress_deadline: The maximum duration for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Default: Duration.seconds(600)
        :param replicas: Number of desired pods. Default: 2
        :param strategy: Specifies the strategy used to replace old Pods by new ones. Default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__887f5e99b2eb7a4eb4872cba90bfe15106bd5abee8303840e64a240d65d45718)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument min_ready", value=min_ready, expected_type=type_hints["min_ready"])
            check_type(argname="argument progress_deadline", value=progress_deadline, expected_type=type_hints["progress_deadline"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if min_ready is not None:
            self._values["min_ready"] = min_ready
        if progress_deadline is not None:
            self._values["progress_deadline"] = progress_deadline
        if replicas is not None:
            self._values["replicas"] = replicas
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[DockerConfigSecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[DockerConfigSecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def min_ready(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        Zero means the pod will be considered available as soon as it is ready.

        :default: Duration.seconds(0)

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#min-ready-seconds
        '''
        result = self._values.get("min_ready")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def progress_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''The maximum duration for a deployment to make progress before it is considered to be failed.

        The deployment controller will continue
        to process failed deployments and a condition with a ProgressDeadlineExceeded
        reason will be surfaced in the deployment status.

        Note that progress will not be estimated during the time a deployment is paused.

        :default: Duration.seconds(600)

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#progress-deadline-seconds
        '''
        result = self._values.get("progress_deadline")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.

        :default: 2
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def strategy(self) -> typing.Optional[DeploymentStrategy]:
        '''Specifies the strategy used to replace old Pods by new ones.

        :default: - RollingUpdate with maxSurge and maxUnavailable set to 25%.
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional[DeploymentStrategy], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DeploymentProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class GCEPersistentDiskPersistentVolume(
    PersistentVolume,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.GCEPersistentDiskPersistentVolume",
):
    '''GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod.

    Provisioned by an admin.

    :see: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        pd_name: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param pd_name: Unique name of the PD resource in GCE. Used to identify the disk in GCE.
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__085b1704b8b0b32c8201d8be9f3adc5412e8d4bc2bec4d514788fd75f8325bff)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = GCEPersistentDiskPersistentVolumeProps(
            pd_name=pd_name,
            fs_type=fs_type,
            partition=partition,
            read_only=read_only,
            access_modes=access_modes,
            claim=claim,
            mount_options=mount_options,
            reclaim_policy=reclaim_policy,
            storage=storage,
            storage_class_name=storage_class_name,
            volume_mode=volume_mode,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="fsType")
    def fs_type(self) -> builtins.str:
        '''File system type of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "fsType"))

    @builtins.property
    @jsii.member(jsii_name="pdName")
    def pd_name(self) -> builtins.str:
        '''PD resource in GCE of this volume.'''
        return typing.cast(builtins.str, jsii.get(self, "pdName"))

    @builtins.property
    @jsii.member(jsii_name="readOnly")
    def read_only(self) -> builtins.bool:
        '''Whether or not it is mounted as a read-only volume.'''
        return typing.cast(builtins.bool, jsii.get(self, "readOnly"))

    @builtins.property
    @jsii.member(jsii_name="partition")
    def partition(self) -> typing.Optional[jsii.Number]:
        '''Partition of this volume.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "partition"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.GCEPersistentDiskPersistentVolumeProps",
    jsii_struct_bases=[PersistentVolumeProps],
    name_mapping={
        "metadata": "metadata",
        "access_modes": "accessModes",
        "claim": "claim",
        "mount_options": "mountOptions",
        "reclaim_policy": "reclaimPolicy",
        "storage": "storage",
        "storage_class_name": "storageClassName",
        "volume_mode": "volumeMode",
        "pd_name": "pdName",
        "fs_type": "fsType",
        "partition": "partition",
        "read_only": "readOnly",
    },
)
class GCEPersistentDiskPersistentVolumeProps(PersistentVolumeProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        access_modes: typing.Optional[typing.Sequence[PersistentVolumeAccessMode]] = None,
        claim: typing.Optional[IPersistentVolumeClaim] = None,
        mount_options: typing.Optional[typing.Sequence[builtins.str]] = None,
        reclaim_policy: typing.Optional[PersistentVolumeReclaimPolicy] = None,
        storage: typing.Optional[_cdk8s_d3d9af27.Size] = None,
        storage_class_name: typing.Optional[builtins.str] = None,
        volume_mode: typing.Optional[PersistentVolumeMode] = None,
        pd_name: builtins.str,
        fs_type: typing.Optional[builtins.str] = None,
        partition: typing.Optional[jsii.Number] = None,
        read_only: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``GCEPersistentDiskPersistentVolume``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param access_modes: Contains all ways the volume can be mounted. Default: - No access modes.
        :param claim: Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. Default: - Not bound to a specific claim.
        :param mount_options: A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. Default: - No options.
        :param reclaim_policy: When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource. The reclaim policy tells the cluster what to do with the volume after it has been released of its claim. Default: PersistentVolumeReclaimPolicy.RETAIN
        :param storage: What is the storage capacity of this volume. Default: - No specified.
        :param storage_class_name: Name of StorageClass to which this persistent volume belongs. Default: - Volume does not belong to any storage class.
        :param volume_mode: Defines what type of volume is required by the claim. Default: VolumeMode.FILE_SYSTEM
        :param pd_name: Unique name of the PD resource in GCE. Used to identify the disk in GCE.
        :param fs_type: Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Default: 'ext4'
        :param partition: The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). Default: - No partition.
        :param read_only: Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eacc3c05f361da8adf7c2d84f3d0069d6323b939c2461d920bd3c8838af77f2d)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument access_modes", value=access_modes, expected_type=type_hints["access_modes"])
            check_type(argname="argument claim", value=claim, expected_type=type_hints["claim"])
            check_type(argname="argument mount_options", value=mount_options, expected_type=type_hints["mount_options"])
            check_type(argname="argument reclaim_policy", value=reclaim_policy, expected_type=type_hints["reclaim_policy"])
            check_type(argname="argument storage", value=storage, expected_type=type_hints["storage"])
            check_type(argname="argument storage_class_name", value=storage_class_name, expected_type=type_hints["storage_class_name"])
            check_type(argname="argument volume_mode", value=volume_mode, expected_type=type_hints["volume_mode"])
            check_type(argname="argument pd_name", value=pd_name, expected_type=type_hints["pd_name"])
            check_type(argname="argument fs_type", value=fs_type, expected_type=type_hints["fs_type"])
            check_type(argname="argument partition", value=partition, expected_type=type_hints["partition"])
            check_type(argname="argument read_only", value=read_only, expected_type=type_hints["read_only"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "pd_name": pd_name,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if access_modes is not None:
            self._values["access_modes"] = access_modes
        if claim is not None:
            self._values["claim"] = claim
        if mount_options is not None:
            self._values["mount_options"] = mount_options
        if reclaim_policy is not None:
            self._values["reclaim_policy"] = reclaim_policy
        if storage is not None:
            self._values["storage"] = storage
        if storage_class_name is not None:
            self._values["storage_class_name"] = storage_class_name
        if volume_mode is not None:
            self._values["volume_mode"] = volume_mode
        if fs_type is not None:
            self._values["fs_type"] = fs_type
        if partition is not None:
            self._values["partition"] = partition
        if read_only is not None:
            self._values["read_only"] = read_only

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def access_modes(self) -> typing.Optional[typing.List[PersistentVolumeAccessMode]]:
        '''Contains all ways the volume can be mounted.

        :default: - No access modes.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        '''
        result = self._values.get("access_modes")
        return typing.cast(typing.Optional[typing.List[PersistentVolumeAccessMode]], result)

    @builtins.property
    def claim(self) -> typing.Optional[IPersistentVolumeClaim]:
        '''Part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.

        Expected to be non-nil when bound.

        :default: - Not bound to a specific claim.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        '''
        result = self._values.get("claim")
        return typing.cast(typing.Optional[IPersistentVolumeClaim], result)

    @builtins.property
    def mount_options(self) -> typing.Optional[typing.List[builtins.str]]:
        '''A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid.

        :default: - No options.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        '''
        result = self._values.get("mount_options")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def reclaim_policy(self) -> typing.Optional[PersistentVolumeReclaimPolicy]:
        '''When a user is done with their volume, they can delete the PVC objects from the API that allows reclamation of the resource.

        The reclaim policy tells the cluster what to do with
        the volume after it has been released of its claim.

        :default: PersistentVolumeReclaimPolicy.RETAIN

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        '''
        result = self._values.get("reclaim_policy")
        return typing.cast(typing.Optional[PersistentVolumeReclaimPolicy], result)

    @builtins.property
    def storage(self) -> typing.Optional[_cdk8s_d3d9af27.Size]:
        '''What is the storage capacity of this volume.

        :default: - No specified.

        :see: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        '''
        result = self._values.get("storage")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Size], result)

    @builtins.property
    def storage_class_name(self) -> typing.Optional[builtins.str]:
        '''Name of StorageClass to which this persistent volume belongs.

        :default: - Volume does not belong to any storage class.
        '''
        result = self._values.get("storage_class_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def volume_mode(self) -> typing.Optional[PersistentVolumeMode]:
        '''Defines what type of volume is required by the claim.

        :default: VolumeMode.FILE_SYSTEM
        '''
        result = self._values.get("volume_mode")
        return typing.cast(typing.Optional[PersistentVolumeMode], result)

    @builtins.property
    def pd_name(self) -> builtins.str:
        '''Unique name of the PD resource in GCE.

        Used to identify the disk in GCE.

        :see: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        '''
        result = self._values.get("pd_name")
        assert result is not None, "Required property 'pd_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def fs_type(self) -> typing.Optional[builtins.str]:
        '''Filesystem type of the volume that you want to mount.

        Tip: Ensure that the filesystem type is supported by the host operating system.

        :default: 'ext4'

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("fs_type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def partition(self) -> typing.Optional[jsii.Number]:
        '''The partition in the volume that you want to mount.

        If omitted, the default is to mount by volume name.
        Examples: For volume /dev/sda1, you specify the partition as "1".
        Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).

        :default: - No partition.
        '''
        result = self._values.get("partition")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def read_only(self) -> typing.Optional[builtins.bool]:
        '''Specify "true" to force and set the ReadOnly property in VolumeMounts to "true".

        :default: false

        :see: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        '''
        result = self._values.get("read_only")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GCEPersistentDiskPersistentVolumeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Job(Workload, metaclass=jsii.JSIIMeta, jsii_type="cdk8s-plus-23.Job"):
    '''A Job creates one or more Pods and ensures that a specified number of them successfully terminate.

    As pods successfully complete,
    the Job tracks the successful completions. When a specified number of successful completions is reached, the task (ie, Job) is complete.
    Deleting a Job will clean up the Pods it created. A simple case is to create one Job object in order to reliably run one Pod to completion.
    The Job object will start a new Pod if the first Pod fails or is deleted (for example due to a node hardware failure or a node reboot).
    You can also use a Job to run multiple Pods in parallel.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4edbe0d9234b2d1cc574c7a147ff9fb7e879ca31af5a20e601985e5f877b66d8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = JobProps(
            active_deadline=active_deadline,
            backoff_limit=backoff_limit,
            ttl_after_finished=ttl_after_finished,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="activeDeadline")
    def active_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Duration before job is terminated.

        If undefined, there is no deadline.
        '''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], jsii.get(self, "activeDeadline"))

    @builtins.property
    @jsii.member(jsii_name="backoffLimit")
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''Number of retries before marking failed.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "backoffLimit"))

    @builtins.property
    @jsii.member(jsii_name="ttlAfterFinished")
    def ttl_after_finished(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''TTL before the job is deleted after it is finished.'''
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], jsii.get(self, "ttlAfterFinished"))


@jsii.data_type(
    jsii_type="cdk8s-plus-23.JobProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "active_deadline": "activeDeadline",
        "backoff_limit": "backoffLimit",
        "ttl_after_finished": "ttlAfterFinished",
    },
)
class JobProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
    ) -> None:
        '''Properties for ``Job``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ae2a205c7f6d41c1cc1a286c895d052ea1f461fed6b35f357fec9eefea828a8)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument active_deadline", value=active_deadline, expected_type=type_hints["active_deadline"])
            check_type(argname="argument backoff_limit", value=backoff_limit, expected_type=type_hints["backoff_limit"])
            check_type(argname="argument ttl_after_finished", value=ttl_after_finished, expected_type=type_hints["ttl_after_finished"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if active_deadline is not None:
            self._values["active_deadline"] = active_deadline
        if backoff_limit is not None:
            self._values["backoff_limit"] = backoff_limit
        if ttl_after_finished is not None:
            self._values["ttl_after_finished"] = ttl_after_finished

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[DockerConfigSecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[DockerConfigSecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def active_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Specifies the duration the job may be active before the system tries to terminate it.

        :default: - If unset, then there is no deadline.
        '''
        result = self._values.get("active_deadline")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''Specifies the number of retries before marking this job failed.

        :default: - If not set, system defaults to 6.
        '''
        result = self._values.get("backoff_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ttl_after_finished(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Limits the lifetime of a Job that has finished execution (either Complete or Failed).

        If this field is set, after the Job finishes, it is eligible to
        be automatically deleted. When the Job is being deleted, its lifecycle
        guarantees (e.g. finalizers) will be honored. If this field is set to zero,
        the Job becomes eligible to be deleted immediately after it finishes. This
        field is alpha-level and is only honored by servers that enable the
        ``TTLAfterFinished`` feature.

        :default: - If this field is unset, the Job won't be automatically deleted.
        '''
        result = self._values.get("ttl_after_finished")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "JobProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IScalable)
class StatefulSet(
    Workload,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk8s-plus-23.StatefulSet",
):
    '''StatefulSet is the workload API object used to manage stateful applications.

    Manages the deployment and scaling of a set of Pods, and provides guarantees
    about the ordering and uniqueness of these Pods.

    Like a Deployment, a StatefulSet manages Pods that are based on an identical
    container spec. Unlike a Deployment, a StatefulSet maintains a sticky identity
    for each of their Pods. These pods are created from the same spec, but are not
    interchangeable: each has a persistent identifier that it maintains across any
    rescheduling.

    If you want to use storage volumes to provide persistence for your workload, you
    can use a StatefulSet as part of the solution. Although individual Pods in a StatefulSet
    are susceptible to failure, the persistent Pod identifiers make it easier to match existing
    volumes to the new Pods that replace any that have failed.


    Using StatefulSets

    StatefulSets are valuable for applications that require one or more of the following.

    - Stable, unique network identifiers.
    - Stable, persistent storage.
    - Ordered, graceful deployment and scaling.
    - Ordered, automated rolling updates.
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_management_policy: typing.Optional[PodManagementPolicy] = None,
        replicas: typing.Optional[jsii.Number] = None,
        service: typing.Optional[Service] = None,
        strategy: typing.Optional[StatefulSetUpdateStrategy] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate. Default: Duration.seconds(0)
        :param pod_management_policy: Pod management policy to use for this statefulset. Default: PodManagementPolicy.ORDERED_READY
        :param replicas: Number of desired pods. Default: 1
        :param service: Service to associate with the statefulset. Default: - A new headless service will be created.
        :param strategy: Indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template. Default: - RollingUpdate with partition set to 0
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a690a84cf25fdba4a59340347d0e37c83e8c3b598dbacb90fc898ca2ef2f6bcf)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = StatefulSetProps(
            min_ready=min_ready,
            pod_management_policy=pod_management_policy,
            replicas=replicas,
            service=service,
            strategy=strategy,
            pod_metadata=pod_metadata,
            select=select,
            spread=spread,
            automount_service_account_token=automount_service_account_token,
            containers=containers,
            dns=dns,
            docker_registry_auth=docker_registry_auth,
            host_aliases=host_aliases,
            init_containers=init_containers,
            isolate=isolate,
            restart_policy=restart_policy,
            security_context=security_context,
            service_account=service_account,
            volumes=volumes,
            metadata=metadata,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="markHasAutoscaler")
    def mark_has_autoscaler(self) -> None:
        '''Called on all IScalable targets when they are associated with an autoscaler.

        :see: IScalable.markHasAutoscaler()
        '''
        return typing.cast(None, jsii.invoke(self, "markHasAutoscaler", []))

    @jsii.member(jsii_name="toScalingTarget")
    def to_scaling_target(self) -> ScalingTarget:
        '''Return the target spec properties of this Scalable.

        :see: IScalable.toScalingTarget()
        '''
        return typing.cast(ScalingTarget, jsii.invoke(self, "toScalingTarget", []))

    @builtins.property
    @jsii.member(jsii_name="apiObject")
    def _api_object(self) -> _cdk8s_d3d9af27.ApiObject:
        '''The underlying cdk8s API object.

        :see: base.Resource.apiObject
        '''
        return typing.cast(_cdk8s_d3d9af27.ApiObject, jsii.get(self, "apiObject"))

    @builtins.property
    @jsii.member(jsii_name="minReady")
    def min_ready(self) -> _cdk8s_d3d9af27.Duration:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.'''
        return typing.cast(_cdk8s_d3d9af27.Duration, jsii.get(self, "minReady"))

    @builtins.property
    @jsii.member(jsii_name="podManagementPolicy")
    def pod_management_policy(self) -> PodManagementPolicy:
        '''Management policy to use for the set.'''
        return typing.cast(PodManagementPolicy, jsii.get(self, "podManagementPolicy"))

    @builtins.property
    @jsii.member(jsii_name="resourceType")
    def resource_type(self) -> builtins.str:
        '''The name of a resource type as it appears in the relevant API endpoint.'''
        return typing.cast(builtins.str, jsii.get(self, "resourceType"))

    @builtins.property
    @jsii.member(jsii_name="service")
    def service(self) -> Service:
        return typing.cast(Service, jsii.get(self, "service"))

    @builtins.property
    @jsii.member(jsii_name="strategy")
    def strategy(self) -> StatefulSetUpdateStrategy:
        '''The update startegy of this stateful set.'''
        return typing.cast(StatefulSetUpdateStrategy, jsii.get(self, "strategy"))

    @builtins.property
    @jsii.member(jsii_name="replicas")
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.'''
        return typing.cast(typing.Optional[jsii.Number], jsii.get(self, "replicas"))

    @builtins.property
    @jsii.member(jsii_name="hasAutoscaler")
    def has_autoscaler(self) -> builtins.bool:
        '''If this is a target of an autoscaler.'''
        return typing.cast(builtins.bool, jsii.get(self, "hasAutoscaler"))

    @has_autoscaler.setter
    def has_autoscaler(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7127297532a99d2bcd0bbab790a0fd04b1025c5377eea2676cd1e5fa638ab346)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "hasAutoscaler", value)


@jsii.data_type(
    jsii_type="cdk8s-plus-23.StatefulSetProps",
    jsii_struct_bases=[WorkloadProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "min_ready": "minReady",
        "pod_management_policy": "podManagementPolicy",
        "replicas": "replicas",
        "service": "service",
        "strategy": "strategy",
    },
)
class StatefulSetProps(WorkloadProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        min_ready: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        pod_management_policy: typing.Optional[PodManagementPolicy] = None,
        replicas: typing.Optional[jsii.Number] = None,
        service: typing.Optional[Service] = None,
        strategy: typing.Optional[StatefulSetUpdateStrategy] = None,
    ) -> None:
        '''Properties for initialization of ``StatefulSet``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param min_ready: Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Zero means the pod will be considered available as soon as it is ready. This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate. Default: Duration.seconds(0)
        :param pod_management_policy: Pod management policy to use for this statefulset. Default: PodManagementPolicy.ORDERED_READY
        :param replicas: Number of desired pods. Default: 1
        :param service: Service to associate with the statefulset. Default: - A new headless service will be created.
        :param strategy: Indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template. Default: - RollingUpdate with partition set to 0
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9a02905f5002bc349d64a3a096796b39fc0b024a908d6a83c6bab3e8b219be88)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument min_ready", value=min_ready, expected_type=type_hints["min_ready"])
            check_type(argname="argument pod_management_policy", value=pod_management_policy, expected_type=type_hints["pod_management_policy"])
            check_type(argname="argument replicas", value=replicas, expected_type=type_hints["replicas"])
            check_type(argname="argument service", value=service, expected_type=type_hints["service"])
            check_type(argname="argument strategy", value=strategy, expected_type=type_hints["strategy"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if min_ready is not None:
            self._values["min_ready"] = min_ready
        if pod_management_policy is not None:
            self._values["pod_management_policy"] = pod_management_policy
        if replicas is not None:
            self._values["replicas"] = replicas
        if service is not None:
            self._values["service"] = service
        if strategy is not None:
            self._values["strategy"] = strategy

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[DockerConfigSecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[DockerConfigSecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def min_ready(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Minimum duration for which a newly created pod should be ready without any of its container crashing, for it to be considered available.

        Zero means the pod will be considered available as soon as it is ready.

        This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate.

        :default: Duration.seconds(0)

        :see: https://kubernetes.io/docs/concepts/workloads/controllers/deployment/#min-ready-seconds
        '''
        result = self._values.get("min_ready")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def pod_management_policy(self) -> typing.Optional[PodManagementPolicy]:
        '''Pod management policy to use for this statefulset.

        :default: PodManagementPolicy.ORDERED_READY
        '''
        result = self._values.get("pod_management_policy")
        return typing.cast(typing.Optional[PodManagementPolicy], result)

    @builtins.property
    def replicas(self) -> typing.Optional[jsii.Number]:
        '''Number of desired pods.

        :default: 1
        '''
        result = self._values.get("replicas")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def service(self) -> typing.Optional[Service]:
        '''Service to associate with the statefulset.

        :default: - A new headless service will be created.
        '''
        result = self._values.get("service")
        return typing.cast(typing.Optional[Service], result)

    @builtins.property
    def strategy(self) -> typing.Optional[StatefulSetUpdateStrategy]:
        '''Indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.

        :default: - RollingUpdate with partition set to 0
        '''
        result = self._values.get("strategy")
        return typing.cast(typing.Optional[StatefulSetUpdateStrategy], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "StatefulSetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk8s-plus-23.CronJobProps",
    jsii_struct_bases=[JobProps],
    name_mapping={
        "metadata": "metadata",
        "automount_service_account_token": "automountServiceAccountToken",
        "containers": "containers",
        "dns": "dns",
        "docker_registry_auth": "dockerRegistryAuth",
        "host_aliases": "hostAliases",
        "init_containers": "initContainers",
        "isolate": "isolate",
        "restart_policy": "restartPolicy",
        "security_context": "securityContext",
        "service_account": "serviceAccount",
        "volumes": "volumes",
        "pod_metadata": "podMetadata",
        "select": "select",
        "spread": "spread",
        "active_deadline": "activeDeadline",
        "backoff_limit": "backoffLimit",
        "ttl_after_finished": "ttlAfterFinished",
        "schedule": "schedule",
        "concurrency_policy": "concurrencyPolicy",
        "failed_jobs_retained": "failedJobsRetained",
        "starting_deadline": "startingDeadline",
        "successful_jobs_retained": "successfulJobsRetained",
        "suspend": "suspend",
    },
)
class CronJobProps(JobProps):
    def __init__(
        self,
        *,
        metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        automount_service_account_token: typing.Optional[builtins.bool] = None,
        containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        dns: typing.Optional[typing.Union[PodDnsProps, typing.Dict[builtins.str, typing.Any]]] = None,
        docker_registry_auth: typing.Optional[DockerConfigSecret] = None,
        host_aliases: typing.Optional[typing.Sequence[typing.Union[HostAlias, typing.Dict[builtins.str, typing.Any]]]] = None,
        init_containers: typing.Optional[typing.Sequence[typing.Union[ContainerProps, typing.Dict[builtins.str, typing.Any]]]] = None,
        isolate: typing.Optional[builtins.bool] = None,
        restart_policy: typing.Optional[RestartPolicy] = None,
        security_context: typing.Optional[typing.Union[PodSecurityContextProps, typing.Dict[builtins.str, typing.Any]]] = None,
        service_account: typing.Optional[IServiceAccount] = None,
        volumes: typing.Optional[typing.Sequence[Volume]] = None,
        pod_metadata: typing.Optional[typing.Union[_cdk8s_d3d9af27.ApiObjectMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        select: typing.Optional[builtins.bool] = None,
        spread: typing.Optional[builtins.bool] = None,
        active_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        backoff_limit: typing.Optional[jsii.Number] = None,
        ttl_after_finished: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        schedule: _cdk8s_d3d9af27.Cron,
        concurrency_policy: typing.Optional[ConcurrencyPolicy] = None,
        failed_jobs_retained: typing.Optional[jsii.Number] = None,
        starting_deadline: typing.Optional[_cdk8s_d3d9af27.Duration] = None,
        successful_jobs_retained: typing.Optional[jsii.Number] = None,
        suspend: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''Properties for ``CronJob``.

        :param metadata: Metadata that all persisted resources must have, which includes all objects users must create.
        :param automount_service_account_token: Indicates whether a service account token should be automatically mounted. Default: false
        :param containers: List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. You can add additionnal containers using ``podSpec.addContainer()`` Default: - No containers. Note that a pod spec must include at least one container.
        :param dns: DNS settings for the pod. Default: policy: DnsPolicy.CLUSTER_FIRST hostnameAsFQDN: false
        :param docker_registry_auth: A secret containing docker credentials for authenticating to a registry. Default: - No auth. Images are assumed to be publicly available.
        :param host_aliases: HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param init_containers: List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added ,removed or updated. Default: - No init containers.
        :param isolate: Isolates the pod. This will prevent any ingress or egress connections to / from this pod. You can however allow explicit connections post instantiation by using the ``.connections`` property. Default: false
        :param restart_policy: Restart policy for all containers within the pod. Default: RestartPolicy.ALWAYS
        :param security_context: SecurityContext holds pod-level security attributes and common container settings. Default: fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS ensureNonRoot: true
        :param service_account: A service account provides an identity for processes that run in a Pod. When you (a human) access the cluster (for example, using kubectl), you are authenticated by the apiserver as a particular User Account (currently this is usually admin, unless your cluster administrator has customized your cluster). Processes in containers inside pods can also contact the apiserver. When they do, they are authenticated as a particular Service Account (for example, default). Default: - No service account.
        :param volumes: List of volumes that can be mounted by containers belonging to the pod. You can also add volumes later using ``podSpec.addVolume()`` Default: - No volumes.
        :param pod_metadata: The pod metadata of this workload.
        :param select: Automatically allocates a pod label selector for this workload and add it to the pod metadata. This ensures this workload manages pods created by its pod template. Default: true
        :param spread: Automatically spread pods across hostname and zones. Default: false
        :param active_deadline: Specifies the duration the job may be active before the system tries to terminate it. Default: - If unset, then there is no deadline.
        :param backoff_limit: Specifies the number of retries before marking this job failed. Default: - If not set, system defaults to 6.
        :param ttl_after_finished: Limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the ``TTLAfterFinished`` feature. Default: - If this field is unset, the Job won't be automatically deleted.
        :param schedule: Specifies the time in which the job would run again. This is defined as a cron expression in the CronJob resource.
        :param concurrency_policy: Specifies the concurrency policy for the job. Default: ConcurrencyPolicy.Forbid
        :param failed_jobs_retained: Specifies the number of failed jobs history retained. This would retain the Job and the associated Pod resource and can be useful for debugging. Default: 1
        :param starting_deadline: Kubernetes attempts to start cron jobs at its schedule time, but this is not guaranteed. This deadline specifies how much time can pass after a schedule point, for which kubernetes can still start the job. For example, if this is set to 100 seconds, kubernetes is allowed to start the job at a maximum 100 seconds after the scheduled time. Note that the Kubernetes CronJobController checks for things every 10 seconds, for this reason, a deadline below 10 seconds is not allowed, as it may cause your job to never be scheduled. In addition, kubernetes will stop scheduling jobs if more than 100 schedules were missed (for any reason). This property also controls what time interval should kubernetes consider when counting for missed schedules. For example, suppose a CronJob is set to schedule a new Job every one minute beginning at 08:30:00, and its ``startingDeadline`` field is not set. If the CronJob controller happens to be down from 08:29:00 to 10:21:00, the job will not start as the number of missed jobs which missed their schedule is greater than 100. However, if ``startingDeadline`` is set to 200 seconds, kubernetes will only count 3 missed schedules, and thus start a new execution at 10:22:00. Default: Duration.seconds(10)
        :param successful_jobs_retained: Specifies the number of successful jobs history retained. This would retain the Job and the associated Pod resource and can be useful for debugging. Default: 3
        :param suspend: Specifies if the cron job should be suspended. Only applies to future executions, current ones are remained untouched. Default: false
        '''
        if isinstance(metadata, dict):
            metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**metadata)
        if isinstance(dns, dict):
            dns = PodDnsProps(**dns)
        if isinstance(security_context, dict):
            security_context = PodSecurityContextProps(**security_context)
        if isinstance(pod_metadata, dict):
            pod_metadata = _cdk8s_d3d9af27.ApiObjectMetadata(**pod_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__869a9617e3af7282c7074a0691d24f6baa390e5764990db8bc9995105eb4be74)
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument automount_service_account_token", value=automount_service_account_token, expected_type=type_hints["automount_service_account_token"])
            check_type(argname="argument containers", value=containers, expected_type=type_hints["containers"])
            check_type(argname="argument dns", value=dns, expected_type=type_hints["dns"])
            check_type(argname="argument docker_registry_auth", value=docker_registry_auth, expected_type=type_hints["docker_registry_auth"])
            check_type(argname="argument host_aliases", value=host_aliases, expected_type=type_hints["host_aliases"])
            check_type(argname="argument init_containers", value=init_containers, expected_type=type_hints["init_containers"])
            check_type(argname="argument isolate", value=isolate, expected_type=type_hints["isolate"])
            check_type(argname="argument restart_policy", value=restart_policy, expected_type=type_hints["restart_policy"])
            check_type(argname="argument security_context", value=security_context, expected_type=type_hints["security_context"])
            check_type(argname="argument service_account", value=service_account, expected_type=type_hints["service_account"])
            check_type(argname="argument volumes", value=volumes, expected_type=type_hints["volumes"])
            check_type(argname="argument pod_metadata", value=pod_metadata, expected_type=type_hints["pod_metadata"])
            check_type(argname="argument select", value=select, expected_type=type_hints["select"])
            check_type(argname="argument spread", value=spread, expected_type=type_hints["spread"])
            check_type(argname="argument active_deadline", value=active_deadline, expected_type=type_hints["active_deadline"])
            check_type(argname="argument backoff_limit", value=backoff_limit, expected_type=type_hints["backoff_limit"])
            check_type(argname="argument ttl_after_finished", value=ttl_after_finished, expected_type=type_hints["ttl_after_finished"])
            check_type(argname="argument schedule", value=schedule, expected_type=type_hints["schedule"])
            check_type(argname="argument concurrency_policy", value=concurrency_policy, expected_type=type_hints["concurrency_policy"])
            check_type(argname="argument failed_jobs_retained", value=failed_jobs_retained, expected_type=type_hints["failed_jobs_retained"])
            check_type(argname="argument starting_deadline", value=starting_deadline, expected_type=type_hints["starting_deadline"])
            check_type(argname="argument successful_jobs_retained", value=successful_jobs_retained, expected_type=type_hints["successful_jobs_retained"])
            check_type(argname="argument suspend", value=suspend, expected_type=type_hints["suspend"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "schedule": schedule,
        }
        if metadata is not None:
            self._values["metadata"] = metadata
        if automount_service_account_token is not None:
            self._values["automount_service_account_token"] = automount_service_account_token
        if containers is not None:
            self._values["containers"] = containers
        if dns is not None:
            self._values["dns"] = dns
        if docker_registry_auth is not None:
            self._values["docker_registry_auth"] = docker_registry_auth
        if host_aliases is not None:
            self._values["host_aliases"] = host_aliases
        if init_containers is not None:
            self._values["init_containers"] = init_containers
        if isolate is not None:
            self._values["isolate"] = isolate
        if restart_policy is not None:
            self._values["restart_policy"] = restart_policy
        if security_context is not None:
            self._values["security_context"] = security_context
        if service_account is not None:
            self._values["service_account"] = service_account
        if volumes is not None:
            self._values["volumes"] = volumes
        if pod_metadata is not None:
            self._values["pod_metadata"] = pod_metadata
        if select is not None:
            self._values["select"] = select
        if spread is not None:
            self._values["spread"] = spread
        if active_deadline is not None:
            self._values["active_deadline"] = active_deadline
        if backoff_limit is not None:
            self._values["backoff_limit"] = backoff_limit
        if ttl_after_finished is not None:
            self._values["ttl_after_finished"] = ttl_after_finished
        if concurrency_policy is not None:
            self._values["concurrency_policy"] = concurrency_policy
        if failed_jobs_retained is not None:
            self._values["failed_jobs_retained"] = failed_jobs_retained
        if starting_deadline is not None:
            self._values["starting_deadline"] = starting_deadline
        if successful_jobs_retained is not None:
            self._values["successful_jobs_retained"] = successful_jobs_retained
        if suspend is not None:
            self._values["suspend"] = suspend

    @builtins.property
    def metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''Metadata that all persisted resources must have, which includes all objects users must create.'''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def automount_service_account_token(self) -> typing.Optional[builtins.bool]:
        '''Indicates whether a service account token should be automatically mounted.

        :default: false

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/#use-the-default-service-account-to-access-the-api-server
        '''
        result = self._values.get("automount_service_account_token")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of containers belonging to the pod.

        Containers cannot currently be
        added or removed. There must be at least one container in a Pod.

        You can add additionnal containers using ``podSpec.addContainer()``

        :default: - No containers. Note that a pod spec must include at least one container.
        '''
        result = self._values.get("containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def dns(self) -> typing.Optional[PodDnsProps]:
        '''DNS settings for the pod.

        :default:

        policy: DnsPolicy.CLUSTER_FIRST
        hostnameAsFQDN: false

        :see: https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/
        '''
        result = self._values.get("dns")
        return typing.cast(typing.Optional[PodDnsProps], result)

    @builtins.property
    def docker_registry_auth(self) -> typing.Optional[DockerConfigSecret]:
        '''A secret containing docker credentials for authenticating to a registry.

        :default: - No auth. Images are assumed to be publicly available.
        '''
        result = self._values.get("docker_registry_auth")
        return typing.cast(typing.Optional[DockerConfigSecret], result)

    @builtins.property
    def host_aliases(self) -> typing.Optional[typing.List[HostAlias]]:
        '''HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.

        :schema: io.k8s.api.core.v1.HostAlias
        '''
        result = self._values.get("host_aliases")
        return typing.cast(typing.Optional[typing.List[HostAlias]], result)

    @builtins.property
    def init_containers(self) -> typing.Optional[typing.List[ContainerProps]]:
        '''List of initialization containers belonging to the pod.

        Init containers are executed in order prior to containers being started.
        If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy.
        The name for an init container or normal container must be unique among all containers.
        Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
        The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit
        for each resource type, and then using the max of of that value or the sum of the normal containers.
        Limits are applied to init containers in a similar fashion.

        Init containers cannot currently be added ,removed or updated.

        :default: - No init containers.

        :see: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
        '''
        result = self._values.get("init_containers")
        return typing.cast(typing.Optional[typing.List[ContainerProps]], result)

    @builtins.property
    def isolate(self) -> typing.Optional[builtins.bool]:
        '''Isolates the pod.

        This will prevent any ingress or egress connections to / from this pod.
        You can however allow explicit connections post instantiation by using the ``.connections`` property.

        :default: false
        '''
        result = self._values.get("isolate")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def restart_policy(self) -> typing.Optional[RestartPolicy]:
        '''Restart policy for all containers within the pod.

        :default: RestartPolicy.ALWAYS

        :see: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
        '''
        result = self._values.get("restart_policy")
        return typing.cast(typing.Optional[RestartPolicy], result)

    @builtins.property
    def security_context(self) -> typing.Optional[PodSecurityContextProps]:
        '''SecurityContext holds pod-level security attributes and common container settings.

        :default:

        fsGroupChangePolicy: FsGroupChangePolicy.FsGroupChangePolicy.ALWAYS
        ensureNonRoot: true
        '''
        result = self._values.get("security_context")
        return typing.cast(typing.Optional[PodSecurityContextProps], result)

    @builtins.property
    def service_account(self) -> typing.Optional[IServiceAccount]:
        '''A service account provides an identity for processes that run in a Pod.

        When you (a human) access the cluster (for example, using kubectl), you are
        authenticated by the apiserver as a particular User Account (currently this
        is usually admin, unless your cluster administrator has customized your
        cluster). Processes in containers inside pods can also contact the
        apiserver. When they do, they are authenticated as a particular Service
        Account (for example, default).

        :default: - No service account.

        :see: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
        '''
        result = self._values.get("service_account")
        return typing.cast(typing.Optional[IServiceAccount], result)

    @builtins.property
    def volumes(self) -> typing.Optional[typing.List[Volume]]:
        '''List of volumes that can be mounted by containers belonging to the pod.

        You can also add volumes later using ``podSpec.addVolume()``

        :default: - No volumes.

        :see: https://kubernetes.io/docs/concepts/storage/volumes
        '''
        result = self._values.get("volumes")
        return typing.cast(typing.Optional[typing.List[Volume]], result)

    @builtins.property
    def pod_metadata(self) -> typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata]:
        '''The pod metadata of this workload.'''
        result = self._values.get("pod_metadata")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.ApiObjectMetadata], result)

    @builtins.property
    def select(self) -> typing.Optional[builtins.bool]:
        '''Automatically allocates a pod label selector for this workload and add it to the pod metadata.

        This ensures this workload manages pods created by
        its pod template.

        :default: true
        '''
        result = self._values.get("select")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def spread(self) -> typing.Optional[builtins.bool]:
        '''Automatically spread pods across hostname and zones.

        :default: false

        :see: https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/#internal-default-constraints
        '''
        result = self._values.get("spread")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def active_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Specifies the duration the job may be active before the system tries to terminate it.

        :default: - If unset, then there is no deadline.
        '''
        result = self._values.get("active_deadline")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def backoff_limit(self) -> typing.Optional[jsii.Number]:
        '''Specifies the number of retries before marking this job failed.

        :default: - If not set, system defaults to 6.
        '''
        result = self._values.get("backoff_limit")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def ttl_after_finished(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Limits the lifetime of a Job that has finished execution (either Complete or Failed).

        If this field is set, after the Job finishes, it is eligible to
        be automatically deleted. When the Job is being deleted, its lifecycle
        guarantees (e.g. finalizers) will be honored. If this field is set to zero,
        the Job becomes eligible to be deleted immediately after it finishes. This
        field is alpha-level and is only honored by servers that enable the
        ``TTLAfterFinished`` feature.

        :default: - If this field is unset, the Job won't be automatically deleted.
        '''
        result = self._values.get("ttl_after_finished")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def schedule(self) -> _cdk8s_d3d9af27.Cron:
        '''Specifies the time in which the job would run again.

        This is defined as a cron expression in the CronJob resource.
        '''
        result = self._values.get("schedule")
        assert result is not None, "Required property 'schedule' is missing"
        return typing.cast(_cdk8s_d3d9af27.Cron, result)

    @builtins.property
    def concurrency_policy(self) -> typing.Optional[ConcurrencyPolicy]:
        '''Specifies the concurrency policy for the job.

        :default: ConcurrencyPolicy.Forbid
        '''
        result = self._values.get("concurrency_policy")
        return typing.cast(typing.Optional[ConcurrencyPolicy], result)

    @builtins.property
    def failed_jobs_retained(self) -> typing.Optional[jsii.Number]:
        '''Specifies the number of failed jobs history retained.

        This would retain the Job and the associated Pod resource and can be useful for debugging.

        :default: 1
        '''
        result = self._values.get("failed_jobs_retained")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def starting_deadline(self) -> typing.Optional[_cdk8s_d3d9af27.Duration]:
        '''Kubernetes attempts to start cron jobs at its schedule time, but this is not guaranteed.

        This deadline specifies
        how much time can pass after a schedule point, for which kubernetes can still start the job.
        For example, if this is set to 100 seconds, kubernetes is allowed to start the job at a maximum 100 seconds after
        the scheduled time.

        Note that the Kubernetes CronJobController checks for things every 10 seconds, for this reason, a deadline below 10
        seconds is not allowed, as it may cause your job to never be scheduled.

        In addition, kubernetes will stop scheduling jobs if more than 100 schedules were missed (for any reason).
        This property also controls what time interval should kubernetes consider when counting for missed schedules.

        For example, suppose a CronJob is set to schedule a new Job every one minute beginning at 08:30:00,
        and its ``startingDeadline`` field is not set. If the CronJob controller happens to be down from 08:29:00 to 10:21:00,
        the job will not start as the number of missed jobs which missed their schedule is greater than 100.
        However, if ``startingDeadline`` is set to 200 seconds, kubernetes will only count 3 missed schedules, and thus
        start a new execution at 10:22:00.

        :default: Duration.seconds(10)
        '''
        result = self._values.get("starting_deadline")
        return typing.cast(typing.Optional[_cdk8s_d3d9af27.Duration], result)

    @builtins.property
    def successful_jobs_retained(self) -> typing.Optional[jsii.Number]:
        '''Specifies the number of successful jobs history retained.

        This would retain the Job and the associated Pod resource and can be useful for debugging.

        :default: 3
        '''
        result = self._values.get("successful_jobs_retained")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def suspend(self) -> typing.Optional[builtins.bool]:
        '''Specifies if the cron job should be suspended.

        Only applies to future executions, current ones are remained untouched.

        :default: false
        '''
        result = self._values.get("suspend")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CronJobProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "AbstractPod",
    "AbstractPodProps",
    "AddDeploymentOptions",
    "AddDirectoryOptions",
    "ApiResource",
    "ApiResourceOptions",
    "AwsElasticBlockStorePersistentVolume",
    "AwsElasticBlockStorePersistentVolumeProps",
    "AwsElasticBlockStoreVolumeOptions",
    "AzureDiskPersistentVolume",
    "AzureDiskPersistentVolumeCachingMode",
    "AzureDiskPersistentVolumeKind",
    "AzureDiskPersistentVolumeProps",
    "AzureDiskVolumeOptions",
    "BasicAuthSecret",
    "BasicAuthSecretProps",
    "ClusterRole",
    "ClusterRoleBinding",
    "ClusterRoleBindingProps",
    "ClusterRolePolicyRule",
    "ClusterRoleProps",
    "CommandProbeOptions",
    "CommonSecretProps",
    "ConcurrencyPolicy",
    "ConfigMap",
    "ConfigMapProps",
    "ConfigMapVolumeOptions",
    "ConnectionScheme",
    "Container",
    "ContainerLifecycle",
    "ContainerPort",
    "ContainerProps",
    "ContainerResources",
    "ContainerSecurityContext",
    "ContainerSecurityContextProps",
    "Cpu",
    "CpuResources",
    "CronJob",
    "CronJobProps",
    "DaemonSet",
    "DaemonSetProps",
    "Deployment",
    "DeploymentExposeViaServiceOptions",
    "DeploymentProps",
    "DeploymentStrategy",
    "DeploymentStrategyRollingUpdateOptions",
    "DnsOption",
    "DnsPolicy",
    "DockerConfigSecret",
    "DockerConfigSecretProps",
    "EmptyDirMedium",
    "EmptyDirVolumeOptions",
    "Env",
    "EnvFieldPaths",
    "EnvFrom",
    "EnvValue",
    "EnvValueFromConfigMapOptions",
    "EnvValueFromFieldRefOptions",
    "EnvValueFromProcessOptions",
    "EnvValueFromResourceOptions",
    "EnvValueFromSecretOptions",
    "EphemeralStorageResources",
    "ExposeDeploymentViaIngressOptions",
    "ExposeServiceViaIngressOptions",
    "FromServiceAccountNameOptions",
    "FsGroupChangePolicy",
    "GCEPersistentDiskPersistentVolume",
    "GCEPersistentDiskPersistentVolumeProps",
    "GCEPersistentDiskVolumeOptions",
    "Group",
    "Handler",
    "HandlerFromHttpGetOptions",
    "HandlerFromTcpSocketOptions",
    "HorizontalPodAutoscaler",
    "HorizontalPodAutoscalerProps",
    "HostAlias",
    "HostPathVolumeOptions",
    "HostPathVolumeType",
    "HttpGetProbeOptions",
    "HttpIngressPathType",
    "IApiEndpoint",
    "IApiResource",
    "IClusterRole",
    "IConfigMap",
    "INamespaceSelector",
    "INetworkPolicyPeer",
    "IPersistentVolume",
    "IPersistentVolumeClaim",
    "IPodSelector",
    "IResource",
    "IRole",
    "IScalable",
    "ISecret",
    "IServiceAccount",
    "IStorage",
    "ISubject",
    "ImagePullPolicy",
    "Ingress",
    "IngressBackend",
    "IngressProps",
    "IngressRule",
    "IngressTls",
    "Job",
    "JobProps",
    "LabelExpression",
    "LabelSelector",
    "LabelSelectorOptions",
    "LabelSelectorRequirement",
    "LabeledNode",
    "MemoryResources",
    "Metric",
    "MetricContainerResourceOptions",
    "MetricObjectOptions",
    "MetricOptions",
    "MetricTarget",
    "MountOptions",
    "MountPropagation",
    "NamedNode",
    "Namespace",
    "NamespaceProps",
    "NamespaceSelectorConfig",
    "Namespaces",
    "NamespacesSelectOptions",
    "NetworkPolicy",
    "NetworkPolicyAddEgressRuleOptions",
    "NetworkPolicyIpBlock",
    "NetworkPolicyPeerConfig",
    "NetworkPolicyPort",
    "NetworkPolicyPortProps",
    "NetworkPolicyProps",
    "NetworkPolicyRule",
    "NetworkPolicyTraffic",
    "NetworkPolicyTrafficDefault",
    "NetworkProtocol",
    "Node",
    "NodeLabelQuery",
    "NodeTaintQuery",
    "NodeTaintQueryOptions",
    "NonApiResource",
    "PathMapping",
    "PercentOrAbsolute",
    "PersistentVolume",
    "PersistentVolumeAccessMode",
    "PersistentVolumeClaim",
    "PersistentVolumeClaimProps",
    "PersistentVolumeClaimVolumeOptions",
    "PersistentVolumeMode",
    "PersistentVolumeProps",
    "PersistentVolumeReclaimPolicy",
    "Pod",
    "PodConnections",
    "PodConnectionsAllowFromOptions",
    "PodConnectionsAllowToOptions",
    "PodConnectionsIsolation",
    "PodDns",
    "PodDnsProps",
    "PodManagementPolicy",
    "PodProps",
    "PodScheduling",
    "PodSchedulingAttractOptions",
    "PodSchedulingColocateOptions",
    "PodSchedulingSeparateOptions",
    "PodSecurityContext",
    "PodSecurityContextProps",
    "PodSelectorConfig",
    "Pods",
    "PodsAllOptions",
    "PodsSelectOptions",
    "Probe",
    "ProbeOptions",
    "Protocol",
    "Replicas",
    "Resource",
    "ResourceFieldPaths",
    "ResourcePermissions",
    "ResourceProps",
    "RestartPolicy",
    "Role",
    "RoleBinding",
    "RoleBindingProps",
    "RolePolicyRule",
    "RoleProps",
    "ScalingPolicy",
    "ScalingRules",
    "ScalingStrategy",
    "ScalingTarget",
    "Secret",
    "SecretProps",
    "SecretValue",
    "SecretVolumeOptions",
    "Service",
    "ServiceAccount",
    "ServiceAccountProps",
    "ServiceAccountTokenSecret",
    "ServiceAccountTokenSecretProps",
    "ServiceBindOptions",
    "ServiceIngressBackendOptions",
    "ServicePort",
    "ServiceProps",
