# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServicesResult',
    'AwaitableGetServicesResult',
    'get_services',
    'get_services_output',
]

@pulumi.output_type
class GetServicesResult:
    """
    A collection of values returned by getServices.
    """
    def __init__(__self__, comms_manager_name=None, compartment_id=None, filters=None, id=None, platform_type=None, services_collections=None):
        if comms_manager_name and not isinstance(comms_manager_name, str):
            raise TypeError("Expected argument 'comms_manager_name' to be a str")
        pulumi.set(__self__, "comms_manager_name", comms_manager_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if platform_type and not isinstance(platform_type, str):
            raise TypeError("Expected argument 'platform_type' to be a str")
        pulumi.set(__self__, "platform_type", platform_type)
        if services_collections and not isinstance(services_collections, list):
            raise TypeError("Expected argument 'services_collections' to be a list")
        pulumi.set(__self__, "services_collections", services_collections)

    @_builtins.property
    @pulumi.getter(name="commsManagerName")
    def comms_manager_name(self) -> Optional[_builtins.str]:
        """
        Name of the comms manager team that manages Notifications to this service.
        """
        return pulumi.get(self, "comms_manager_name")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServicesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> Optional[_builtins.str]:
        """
        The platform type this service object is related to.
        """
        return pulumi.get(self, "platform_type")

    @_builtins.property
    @pulumi.getter(name="servicesCollections")
    def services_collections(self) -> Sequence['outputs.GetServicesServicesCollectionResult']:
        """
        The list of services_collection.
        """
        return pulumi.get(self, "services_collections")


class AwaitableGetServicesResult(GetServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServicesResult(
            comms_manager_name=self.comms_manager_name,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            platform_type=self.platform_type,
            services_collections=self.services_collections)


def get_services(comms_manager_name: Optional[_builtins.str] = None,
                 compartment_id: Optional[_builtins.str] = None,
                 filters: Optional[Sequence[Union['GetServicesFilterArgs', 'GetServicesFilterArgsDict']]] = None,
                 platform_type: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServicesResult:
    """
    This data source provides the list of Services in Oracle Cloud Infrastructure.

    List all OCI services

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_services = oci.AnnouncementsService.get_services(compartment_id=compartment_id,
        comms_manager_name=service_comms_manager_name,
        platform_type=service_platform_type)
    ```


    :param _builtins.str comms_manager_name: Filter by comms manager name
    :param _builtins.str compartment_id: The OCID of the root compartment/tenancy.
    :param _builtins.str platform_type: A filter to return only services underlying a specific platform.
    """
    __args__ = dict()
    __args__['commsManagerName'] = comms_manager_name
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['platformType'] = platform_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AnnouncementsService/getServices:getServices', __args__, opts=opts, typ=GetServicesResult).value

    return AwaitableGetServicesResult(
        comms_manager_name=pulumi.get(__ret__, 'comms_manager_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        platform_type=pulumi.get(__ret__, 'platform_type'),
        services_collections=pulumi.get(__ret__, 'services_collections'))
def get_services_output(comms_manager_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetServicesFilterArgs', 'GetServicesFilterArgsDict']]]]] = None,
                        platform_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServicesResult]:
    """
    This data source provides the list of Services in Oracle Cloud Infrastructure.

    List all OCI services

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_services = oci.AnnouncementsService.get_services(compartment_id=compartment_id,
        comms_manager_name=service_comms_manager_name,
        platform_type=service_platform_type)
    ```


    :param _builtins.str comms_manager_name: Filter by comms manager name
    :param _builtins.str compartment_id: The OCID of the root compartment/tenancy.
    :param _builtins.str platform_type: A filter to return only services underlying a specific platform.
    """
    __args__ = dict()
    __args__['commsManagerName'] = comms_manager_name
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['platformType'] = platform_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AnnouncementsService/getServices:getServices', __args__, opts=opts, typ=GetServicesResult)
    return __ret__.apply(lambda __response__: GetServicesResult(
        comms_manager_name=pulumi.get(__response__, 'comms_manager_name'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        platform_type=pulumi.get(__response__, 'platform_type'),
        services_collections=pulumi.get(__response__, 'services_collections')))
