# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAlertRulesAlertRuleResult',
    'GetAlertRulesFilterResult',
    'GetBudgetsBudgetResult',
    'GetBudgetsFilterResult',
]

@pulumi.output_type
class GetAlertRulesAlertRuleResult(dict):
    def __init__(__self__, *,
                 budget_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 message: _builtins.str,
                 recipients: _builtins.str,
                 state: _builtins.str,
                 threshold: _builtins.float,
                 threshold_type: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 type: _builtins.str,
                 version: _builtins.int):
        """
        :param _builtins.str budget_id: The unique budget OCID.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: The description of the alert rule.
        :param _builtins.str display_name: A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of the alert rule.
        :param _builtins.str message: The custom message that will be sent when the alert is triggered.
        :param _builtins.str recipients: The delimited list of email addresses to receive the alert when it triggers. Delimiter characters can be a comma, space, TAB, or semicolon.
        :param _builtins.str state: The current state of the resource to filter by.
        :param _builtins.float threshold: The threshold for triggering the alert. If the thresholdType is PERCENTAGE, the maximum value is 10000.
        :param _builtins.str threshold_type: The type of threshold.
        :param _builtins.str time_created: The time when the budget was created.
        :param _builtins.str time_updated: The time when the budget was updated.
        :param _builtins.str type: The type of the alert. Valid values are ACTUAL (the alert triggers based on actual usage), or FORECAST (the alert triggers based on predicted usage).
        :param _builtins.int version: The version of the alert rule. Starts from 1 and increments by 1.
        """
        pulumi.set(__self__, "budget_id", budget_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recipients", recipients)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "threshold_type", threshold_type)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="budgetId")
    def budget_id(self) -> _builtins.str:
        """
        The unique budget OCID.
        """
        return pulumi.get(self, "budget_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the alert rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the alert rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        The custom message that will be sent when the alert is triggered.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> _builtins.str:
        """
        The delimited list of email addresses to receive the alert when it triggers. Delimiter characters can be a comma, space, TAB, or semicolon.
        """
        return pulumi.get(self, "recipients")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the resource to filter by.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        The threshold for triggering the alert. If the thresholdType is PERCENTAGE, the maximum value is 10000.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> _builtins.str:
        """
        The type of threshold.
        """
        return pulumi.get(self, "threshold_type")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the budget was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the alert. Valid values are ACTUAL (the alert triggers based on actual usage), or FORECAST (the alert triggers based on predicted usage).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the alert rule. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAlertRulesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetBudgetsBudgetResult(dict):
    def __init__(__self__, *,
                 actual_spend: _builtins.float,
                 alert_rule_count: _builtins.int,
                 amount: _builtins.int,
                 budget_processing_period_start_offset: _builtins.int,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 end_date: _builtins.str,
                 forecasted_spend: _builtins.float,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 processing_period_type: _builtins.str,
                 reset_period: _builtins.str,
                 start_date: _builtins.str,
                 state: _builtins.str,
                 target_compartment_id: _builtins.str,
                 target_type: _builtins.str,
                 targets: Sequence[_builtins.str],
                 time_created: _builtins.str,
                 time_spend_computed: _builtins.str,
                 time_updated: _builtins.str,
                 version: _builtins.int):
        """
        :param _builtins.float actual_spend: The actual spend in currency for the current budget cycle.
        :param _builtins.int alert_rule_count: The total number of alert rules in the budget.
        :param _builtins.int amount: The amount of the budget, expressed in the currency of the customer's rate card.
        :param _builtins.int budget_processing_period_start_offset: The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: The description of the budget.
        :param _builtins.str display_name: A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        :param _builtins.str end_date: The time when the one-time budget concludes. For example, - `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param _builtins.float forecasted_spend: The forecasted spend in currency by the end of the current budget cycle.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of the budget.
        :param _builtins.str processing_period_type: The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        :param _builtins.str reset_period: The reset period for the budget.
        :param _builtins.str start_date: The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param _builtins.str state: The current state of the resource to filter by.
        :param _builtins.str target_compartment_id: This is DEPRECATED. For backwards compatability, the property is populated when the targetType is "COMPARTMENT", and targets contain the specific target compartment OCID. For all other scenarios, this property will be left empty.
        :param _builtins.str target_type: The type of target to filter by:
               * ALL - List all budgets
               * COMPARTMENT - List all budgets with targetType == "COMPARTMENT"
               * TAG - List all budgets with targetType == "TAG"
        :param Sequence[_builtins.str] targets: The list of targets on which the budget is applied. If the targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If the targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}".
        :param _builtins.str time_created: The time that the budget was created.
        :param _builtins.str time_spend_computed: The time that the budget spend was last computed.
        :param _builtins.str time_updated: The time that the budget was updated.
        :param _builtins.int version: The version of the budget. Starts from 1 and increments by 1.
        """
        pulumi.set(__self__, "actual_spend", actual_spend)
        pulumi.set(__self__, "alert_rule_count", alert_rule_count)
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "budget_processing_period_start_offset", budget_processing_period_start_offset)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "forecasted_spend", forecasted_spend)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "processing_period_type", processing_period_type)
        pulumi.set(__self__, "reset_period", reset_period)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "target_compartment_id", target_compartment_id)
        pulumi.set(__self__, "target_type", target_type)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_spend_computed", time_spend_computed)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="actualSpend")
    def actual_spend(self) -> _builtins.float:
        """
        The actual spend in currency for the current budget cycle.
        """
        return pulumi.get(self, "actual_spend")

    @_builtins.property
    @pulumi.getter(name="alertRuleCount")
    def alert_rule_count(self) -> _builtins.int:
        """
        The total number of alert rules in the budget.
        """
        return pulumi.get(self, "alert_rule_count")

    @_builtins.property
    @pulumi.getter
    def amount(self) -> _builtins.int:
        """
        The amount of the budget, expressed in the currency of the customer's rate card.
        """
        return pulumi.get(self, "amount")

    @_builtins.property
    @pulumi.getter(name="budgetProcessingPeriodStartOffset")
    def budget_processing_period_start_offset(self) -> _builtins.int:
        """
        The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        """
        return pulumi.get(self, "budget_processing_period_start_offset")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the budget.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> _builtins.str:
        """
        The time when the one-time budget concludes. For example, - `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="forecastedSpend")
    def forecasted_spend(self) -> _builtins.float:
        """
        The forecasted spend in currency by the end of the current budget cycle.
        """
        return pulumi.get(self, "forecasted_spend")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the budget.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="processingPeriodType")
    def processing_period_type(self) -> _builtins.str:
        """
        The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        """
        return pulumi.get(self, "processing_period_type")

    @_builtins.property
    @pulumi.getter(name="resetPeriod")
    def reset_period(self) -> _builtins.str:
        """
        The reset period for the budget.
        """
        return pulumi.get(self, "reset_period")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the resource to filter by.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="targetCompartmentId")
    @_utilities.deprecated("""The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""")
    def target_compartment_id(self) -> _builtins.str:
        """
        This is DEPRECATED. For backwards compatability, the property is populated when the targetType is "COMPARTMENT", and targets contain the specific target compartment OCID. For all other scenarios, this property will be left empty.
        """
        return pulumi.get(self, "target_compartment_id")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        The type of target to filter by:
        * ALL - List all budgets
        * COMPARTMENT - List all budgets with targetType == "COMPARTMENT"
        * TAG - List all budgets with targetType == "TAG"
        """
        return pulumi.get(self, "target_type")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Sequence[_builtins.str]:
        """
        The list of targets on which the budget is applied. If the targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If the targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}".
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time that the budget was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeSpendComputed")
    def time_spend_computed(self) -> _builtins.str:
        """
        The time that the budget spend was last computed.
        """
        return pulumi.get(self, "time_spend_computed")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time that the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the budget. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetBudgetsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


